VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Upload_Class"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const MODULE_NAME As String = "Upload_Class"

Implements EzeScan_Interfaces.IUpload


Private uploadFields_() As EzeScan_Interfaces.UploadTargetField
Private uploadParameters_() As EzeScan_Interfaces.UserConfigurableParameter
Private fieldTypes_() As String

Private Sub Class_Initialize()
            
    ' This sample Plugin supports the following types (The names can be anything - EzeScan just lists them for the user to select)
    fieldTypes_ = Split("String,Integer,Boolean", ",")
    
    ' define the field type arrays to limit the field types certain fields can be set to
    Dim string_integer(1) As String
    Dim boolean_type(0) As String
    
    string_integer(0) = fieldTypes_(0)
    string_integer(1) = fieldTypes_(1)
    boolean_type(0) = fieldTypes_(2)
    
    'Create the ID field - It's default static value is "1" - It defaults to using a static value - It can only be set to String or Integer type - Default is string
    ' - is not user or system mandatory - has no user or system max length - and uses a custom dialog to simplify setting static values
    PluginHelper.AddField uploadFields_, PluginHelper.CreateField("ID", "1", True, string_integer, string_integer(0), False, False, 0, 0, True)
    
    'Create the Increment field - It's default static value is "" - It does not default to using a static value - It can only be set to Boolean type - Default Type is Boolean
    ' - is not user or system mandatory - has no user or system max length - and has no custom dialog for setting static values
    PluginHelper.AddField uploadFields_, PluginHelper.CreateField("Increment", "", False, boolean_type, boolean_type(0), False, False, 0, 0, False)
    
    ' Create the parameter that sets the numeric range - it uses a static field custom dialog to set the value
    PluginHelper.AddParameter uploadParameters_, PluginHelper.CreateParameter("range", "Range Limits", ParameterType_CustomLocked, "1,10", "Enter the limits to use when browsing for an ID range", False)
End Sub

Private Function IUpload_AllowArbitraryFieldNameEntry(upload_parameters() As EzeScan_Interfaces.UserConfigurableParameter) As Boolean
    ' EzeScan calls this function to determine whether the user should be allowed to add custom fields
    ' Custom fields are usually either extra EDRMS metadata fields created by the use
    ' In this sample Plugin custom fields are not handled and therefore not allowed
    IUpload_AllowArbitraryFieldNameEntry = False
End Function

Private Function IUpload_EditCustomField(ByVal field_name As String, field_value As String) As Long
    ' EzeScan calls this function when the user has clicked the browse button on a custom field (which has it's source set to static)
    
    Dim return_code As Long
    Dim selected_range As Long
    
    return_code = 0 ' Default to code for user cancelled
    
    Select Case field_name
        Case "ID"
            ' Note this is separate from the range limit parameter
            selected_range = SelectRange_Dialog.SelectFromRange(1, 10)
            
            If (Not SelectRange_Dialog.UserCancelled) Then
                field_value = CStr(selected_range)
                return_code = 1
            End If
        
            Unload SelectRange_Dialog
    End Select
    
    IUpload_EditCustomField = return_code
    
End Function

Private Function IUpload_EditCustomParameter(ByVal parameter_id As String, upload_parameters() As EzeScan_Interfaces.UserConfigurableParameter, value_out As String) As Long
    ' See Connection_Class.IConnection_EditCustomParameter() for a description of this function
    ' This plugin upload object has one custom parameter - range
    On Error GoTo errHandler
        
    Dim range_parameter As EzeScan_Interfaces.UserConfigurableParameter
    Dim range_parts() As String
    Dim range_start As Long
    Dim range_end As Long
    Dim return_code As Long
    
    return_code = 0 ' the user cancelled editing the value
    
    If FindParameter("range", upload_parameters, range_parameter) Then
        range_parts = Split(range_parameter.Value, ",")
        range_start = CLng(range_parts(0))
        range_end = CLng(range_parts(1))
        
        If ConfigureRange_Dialog.ConfigureRange(range_start, range_end) Then
            value_out = CStr(ConfigureRange_Dialog.RangeStart) & "," & CStr(ConfigureRange_Dialog.RangeEnd)
            return_code = 1 ' User accepted change
        End If
        
        Unload ConfigureRange_Dialog
    End If
    
    IUpload_EditCustomParameter = return_code
    
Exit Function
errHandler:
    
    DebugError MODULE_NAME, "IUpload_EditCustomParameter"
    DebugLog.LogUserErrorMessage "Error editing range: " & Err.Description
    IUpload_EditCustomParameter = -99 ' Error code
    
End Function

Private Function IUpload_GetUploadFields(upload_fields() As EzeScan_Interfaces.UploadTargetField) As Long
    ' EzeScan calls this function when it needs the list of fields the Plugin supports
    ' If the list can only be determined whilst the Plugin is connected and a connection is not already established then return the code 2 to ask EzeScan to connect
    
    upload_fields = uploadFields_
    
    IUpload_GetUploadFields = 1 ' Success
    
End Function

Private Function IUpload_GetUploadFieldTypes(upload_types() As String) As Long
    ' EzeScan calls this function to get a list of names for the types this plugin supports
    ' e.g some systems may have a text type, others may call the same thing a string
    ' some systems may have an integer type, others may call it a different name or may not support it at all
    
    ' The type to use as the default type should be at the start of the list
    upload_types = fieldTypes_
    
    IUpload_GetUploadFieldTypes = 1 ' Success
End Function

Private Function IUpload_UploadDocument(ByVal document_path As String, ByVal index_file_path As String, upload_fields() As EzeScan_Interfaces.UploadTargetField, upload_parameters() As EzeScan_Interfaces.UserConfigurableParameter, upload_status As EzeScan_Interfaces.IStatusProvider) As Boolean
    On Error GoTo errHandler

    Dim field_index As Long
    Dim range_parameter As EzeScan_Interfaces.UserConfigurableParameter
    Dim range_parts() As String
    Dim range_start As Long
    Dim range_end As Long
    Dim return_flag As Boolean
    Dim base_folder As String
    Dim target_file_path As String
    Dim document_id As String
    Dim increment_requested As Boolean

    return_flag = False ' Default to failed
    increment_requested = False

    upload_status.ProgessIncrements = 4
    
    upload_status.IncrementStatus "Processing Fields"

    For field_index = 0 To (PluginHelper.FieldCount(upload_fields) - 1)

        Select Case upload_fields(field_index).FieldName
            Case "ID"
                document_id = upload_fields(field_index).Value
            Case "Increment"

                Select Case UCase$(upload_fields(field_index).Value)
                    Case "Y", "T", "1", "YES", "TRUE"
                        increment_requested = True
                End Select

        End Select

    Next field_index

    ' Validate the field values
    upload_status.IncrementStatus "Validating Fields"

    If (document_id = "") Or (Not increment_requested) Then

        If (document_id = "") Then
            document_id = "1"
        End If

        If FindParameter("range", upload_parameters, range_parameter) Then

            If range_parameter.Value <> "" Then
                range_parts = Split(range_parameter.Value, ",")
                range_start = CLng(range_parts(0))
                range_end = CLng(range_parts(1))
            End If

        End If

        If (document_id <> "") And (range_start <> -1 Or range_end <> -1) Then

            If (CLng(document_id) < range_start) Or (CLng(document_id) > range_end) Then
                DebugLog.LogUserErrorMessage "Validation error - Value '" & document_id & "' is outside of the range '" & CStr(range_start) & "' to '" & CStr(range_end) & "'"
                document_id = ""
            End If

        End If

        base_folder = FSO.BuildPath(StorageFolder, UserName)

        If document_id <> "" Then

            Do While increment_requested And FSO.FileExists(FSO.BuildPath(base_folder, document_id & "." & FSO.GetExtensionName(document_path)))
                document_id = CStr(CLng(document_id) + 1)
            Loop

            If (Not FSO.FolderExists(base_folder)) Then
                DebugLog.LogPluginMessage "Creating Folder: " & base_folder, PluginDebugLevel_InfoNormal
                FSO.CreateFolder base_folder
            End If

            target_file_path = FSO.BuildPath(base_folder, document_id & "." & FSO.GetExtensionName(document_path))

            If FSO.FileExists(target_file_path) Then
                DebugLog.LogPluginMessage "Removing existing file: " & target_file_path, PluginDebugLevel_InfoNormal
                FSO.DeleteFile target_file_path, True
            End If
            
            upload_status.IncrementStatus "Uploading Document"
            DebugLog.LogPluginMessage "Uploading file: " & target_file_path, PluginDebugLevel_InfoNormal
            FSO.CopyFile document_path, target_file_path, False

            PreviousDocumentReference = document_id

            return_flag = True
        End If

    Else
        ' Validation error - Both ID and Increment are set
        DebugLog.LogUserErrorMessage "Validation error - Both ID and Increment are set"
    End If

    IUpload_UploadDocument = return_flag

Exit Function
errHandler:

    DebugError MODULE_NAME, "IUpload_UploadDocument"
    DebugLog.LogUserErrorMessage "Error uploading document: " & Err.Description
    IUpload_UploadDocument = False ' Upload failed

End Function

Private Property Get IUpload_UploadParameters() As EzeScan_Interfaces.UserConfigurableParameter()
    IUpload_UploadParameters = uploadParameters_
End Property
