Attribute VB_Name = "Shared_Objects"
Option Explicit

Private Const MODULE_NAME As String = "Shared_Objects"

' A file system object for the Sample Plugins file/folder operations
Public FSO As FileSystemObject

' The DebugLog object allows log messages to be passed back to EzeScan and displayed in the Debug viewer
Public DebugLog As EzeScan_Interfaces.ILogging

' The SystemSettings object can be used to read & write plugin specific settings that can not be handled via the usual parameters
' (i.e settings which are not set by the user in the EzeScan interface)
' This object can also read certain EzeScan settings (e.g the current user name)
Public SystemSettings As EzeScan_Interfaces.ISystemSettings

' A helper object to simplfy creating parameter arrays, etc
Public PluginHelper As EzeScan_Interfaces.Helper

Public isConnected As Boolean
Public PreviousDocumentReference As String
Public UserName As String
Public StorageFolder As String

Public Sub DebugError(module__name As String, procedure_name As String, Optional message_text As String = "")
    DebugLog.LogPluginMessage module__name & "." & procedure_name & ": " & IIf(message_text <> "", message_text, Err.Description & ": " & CStr(Err.Number)), PluginDebugLevel_ErrorSevere
End Sub


Public Function FindParameter(ByVal parameter_id As String, ByRef parameter_array() As EzeScan_Interfaces.UserConfigurableParameter, ByRef parameter_out As EzeScan_Interfaces.UserConfigurableParameter) As Boolean
    
    Dim param_index As Long

    For param_index = 0 To (PluginHelper.ParameterCount(parameter_array) - 1)
        
        If parameter_array(param_index).ID = parameter_id Then
            parameter_out = parameter_array(param_index)
            FindParameter = True
            Exit Function
        End If
        
    Next param_index

    ' Parameter was not found
    FindParameter = False
    
End Function
