VERSION 5.00
Begin VB.Form Open_Dialog 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Open from Sample EDRMS"
   ClientHeight    =   3765
   ClientLeft      =   45
   ClientTop       =   345
   ClientWidth     =   3270
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3765
   ScaleWidth      =   3270
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Select_Frame 
      Caption         =   "Choose a Document to Open"
      Height          =   3495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3015
      Begin VB.CommandButton Cancel_Button 
         Cancel          =   -1  'True
         Caption         =   "&Cancel"
         Height          =   615
         Left            =   1560
         TabIndex        =   3
         Top             =   2760
         Width           =   1335
      End
      Begin VB.CommandButton OK_Button 
         Caption         =   "&OK"
         Height          =   615
         Left            =   120
         TabIndex        =   2
         Top             =   2760
         Width           =   1335
      End
      Begin VB.ListBox File_ListBox 
         Height          =   2205
         Left            =   120
         TabIndex        =   1
         Top             =   360
         Width           =   2775
      End
   End
End
Attribute VB_Name = "Open_Dialog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private userCancelled_ As Boolean

Public Function OpenDocument(storage_folder_path As String) As String
    Dim return_path As String
    Dim storage_folder As Folder
    Dim document_file As File
    
    userCancelled_ = True
    return_path = ""
    File_ListBox.Clear
    
    If FSO.FolderExists(storage_folder_path) Then
        Set storage_folder = FSO.GetFolder(storage_folder_path)
        
        For Each document_file In storage_folder.Files
            
            If LCase$(FSO.GetExtensionName(document_file.Name)) = "tif" Then
                File_ListBox.AddItem FSO.GetBaseName(document_file.Name)
            End If
            
        Next
        
        If File_ListBox.ListCount > 0 Then
            ' select the first item
            File_ListBox.Selected(0) = True
            
            Show vbModal
            
            If (Not userCancelled_) Then
                return_path = FSO.BuildPath(storage_folder_path, File_ListBox.Text & ".tif")
            End If
            
        Else
            MsgBox "The Document Library is empty - there are no documents to import", vbCritical, "Open Document Error"
        End If
        
    Else
        MsgBox "Document Library folder '" & storage_folder_path & "' does not exist", vbCritical, "Open Document Error"
    End If

    OpenDocument = return_path

End Function

Public Property Get UserCancelled() As Boolean
    UserCancelled = userCancelled_
End Property

Private Sub Cancel_Button_Click()
    userCancelled_ = True
    Hide
End Sub

Private Sub OK_Button_Click()
    userCancelled_ = False
    Hide
End Sub
