VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "KFIBrowse_Class"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const MODULE_NAME As String = "KFIBrowse_Class"

Implements EzeScan_Interfaces.IKFI

Private kfiParameters_() As EzeScan_Interfaces.UserConfigurableParameter

Private locationNames_() As String
Private locationIds_() As String

Private Sub Class_Initialize()

    Dim field_names() As String
    
    field_names = Split("Range,Location", ",")
    
    ' Create the parameter that allows us to choose which field to browse
    PluginHelper.AddParameter kfiParameters_, PluginHelper.CreateLookupParameter("field", "Browse for", ParameterType_Lookup, field_names(0), "Choose the field to browse", field_names, False)

    ' Create the parameter that sets the numeric range - it uses a custom dialog to set the value
    PluginHelper.AddParameter kfiParameters_, PluginHelper.CreateParameter("range", "Range Limits", ParameterType_CustomLocked, "1,10", "Enter the limits to use when browsing for a Range", False)
    
    locationNames_ = Split("Sydney,London,New York", ",")
    locationIds_ = Split("S421,L3dE,NY31", ",")
End Sub

Private Function IKFI_BrowseField(kfi_parameters() As EzeScan_Interfaces.UserConfigurableParameter, values_out() As String, hidden_values_out() As String) As Long
    
    On Error GoTo errHandler
    
    Dim field_parameter As EzeScan_Interfaces.UserConfigurableParameter
    Dim range_parameter As EzeScan_Interfaces.UserConfigurableParameter
    Dim range_parts() As String
    Dim range_start As Long
    Dim range_end As Long
    Dim selected_range As Long
    Dim return_code As Long
    
    return_code = 0 ' Browse cancelled
    
    If FindParameter("field", kfi_parameters, field_parameter) Then
    
        Select Case field_parameter.Value
            Case "Range"
                
                If FindParameter("range", kfi_parameters, range_parameter) Then
                    range_parts = Split(range_parameter.Value, ",")
                    range_start = CLng(range_parts(0))
                    range_end = CLng(range_parts(1))
                    selected_range = SelectRange_Dialog.SelectFromRange(range_start, range_end)
                
                    If (Not SelectRange_Dialog.UserCancelled) Then
                        ReDim values_out(0)
                        values_out(0) = CStr(selected_range)
                        return_code = 1 ' Browse Successful
                    End If
                
                    Unload SelectRange_Dialog
                End If
                
            Case "Location"
                ' The plugin doesn't have it's own dialog for the user to select from these values so we just pass them back to EzeScan and let it show them to the user
                values_out = locationNames_
                hidden_values_out = locationIds_
                return_code = 1 ' Browse Successful
        End Select
        
    End If

    IKFI_BrowseField = return_code
    
Exit Function
errHandler:
    
    DebugError MODULE_NAME, "IKFI_BrowseField"
    DebugLog.LogUserErrorMessage "Error browsing field: " & Err.Description
    IKFI_BrowseField = -99 ' Error code

End Function

Private Function IKFI_EditCustomParameter(ByVal parameter_id As String, kfi_parameters() As EzeScan_Interfaces.UserConfigurableParameter, value_out As String) As Long
    On Error GoTo errHandler
    
    Dim field_parameter As EzeScan_Interfaces.UserConfigurableParameter
    Dim range_parameter As EzeScan_Interfaces.UserConfigurableParameter
    Dim range_parts() As String
    Dim range_start As Long
    Dim range_end As Long
    Dim return_code As Long
    
    return_code = 0 ' the user cancelled editing the value
    
    If FindParameter("field", kfi_parameters, field_parameter) Then
    
        If field_parameter.Value = "Range" Then
        
            If FindParameter("range", kfi_parameters, range_parameter) Then
                range_parts = Split(range_parameter.Value, ",")
                range_start = CLng(range_parts(0))
                range_end = CLng(range_parts(1))
                
                If ConfigureRange_Dialog.ConfigureRange(range_start, range_end) Then
                    value_out = CStr(ConfigureRange_Dialog.RangeStart) & "," & CStr(ConfigureRange_Dialog.RangeEnd)
                    return_code = 1 ' User accepted change
                End If
                
                Unload ConfigureRange_Dialog
            End If
        
        Else
            MsgBox "Range is not required when browsing location", vbExclamation, "Not Required"
        End If
        
    End If
    
    IKFI_EditCustomParameter = return_code
    
Exit Function
errHandler:
    
    DebugError MODULE_NAME, "IKFI_EditCustomParameter"
    DebugLog.LogUserErrorMessage "Error editing range: " & Err.Description
    IKFI_EditCustomParameter = -99 ' Error code
    
End Function

Private Property Get IKFI_FieldBrowseParameters() As EzeScan_Interfaces.UserConfigurableParameter()
    ' EzeScan calls this property to retrieve an array of parameters that are required by the plugin to browse a field
    IKFI_FieldBrowseParameters = kfiParameters_
End Property

Private Function IKFI_FieldReturnsHiddenData(kfi_parameters() As EzeScan_Interfaces.UserConfigurableParameter) As Long
    ' EzeScan calls this function to find out whether the field also returns a hidden id.
    ' This allows the plugin to return a user visible description and a hidden id that can later be used during a document upload

    ' In this sample Plugin the Location field also returns a hidden location ID

    Dim field_parameter As EzeScan_Interfaces.UserConfigurableParameter
    Dim return_code As Long
    
    return_code = 0 ' the field does not return hidden data
    
    ' Find the "field" parameter and check if it's value is set to "Location"

    If FindParameter("field", kfi_parameters, field_parameter) Then
    
        If field_parameter.Value = "Location" Then
            return_code = 1 ' the field returns hidden data
        End If
    
    End If
        
    IKFI_FieldReturnsHiddenData = return_code
    
End Function

Private Function IKFI_FieldUsesOwnDialog(kfi_parameters() As EzeScan_Interfaces.UserConfigurableParameter) As Long

    ' EzeScan calls this function to find out whether the Plugin will provide it's own dialog for the current settings (or whether it would like ezescan to manage a simple list)

    ' In this sample Plugin browsing for a Range requires a custom dialog
    
    Dim field_parameter As EzeScan_Interfaces.UserConfigurableParameter
    Dim return_code As Long
    
    return_code = 0 ' the field does not use it's own dialog

    ' Find the "field" parameter and check if it's value is set to "Range"

    If FindParameter("field", kfi_parameters, field_parameter) Then
    
        If field_parameter.Value = "Range" Then
            return_code = 1 ' the field returns hidden data
        End If
    
    End If
    
    IKFI_FieldUsesOwnDialog = return_code

End Function
