VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Import_Class"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const MODULE_NAME As String = "Import_Class"

Implements EzeScan_Interfaces.IImport

' the import parameter list is empty as no extra settings are required
Private importParameters_() As EzeScan_Interfaces.UserConfigurableParameter

Private Function IImport_EditCustomParameter(ByVal parameter_id As String, import_parameters() As EzeScan_Interfaces.UserConfigurableParameter, value_out As String) As Long
    ' See Connection_Class.IConnection_EditCustomParameter() for a description of this function
    ' This plugin import object does not contain any custom parameters - so the return code is always cancel just in case this function is ever called in error
    IImport_EditCustomParameter = 0
End Function

Private Function IImport_ImportDocument(ByVal import_folder As String, import_parameters() As EzeScan_Interfaces.UserConfigurableParameter, returned_document_path As String) As Long

    Dim source_file_path As String
    Dim target_file_path As String
    Dim base_folder As String
    
    base_folder = FSO.BuildPath(StorageFolder, UserName)
    source_file_path = Open_Dialog.OpenDocument(base_folder)
    
    Unload Open_Dialog
    
    If FSO.FileExists(source_file_path) Then
        target_file_path = FSO.BuildPath(import_folder, FSO.GetFileName(source_file_path))
        FSO.CopyFile source_file_path, target_file_path, True
    
        returned_document_path = target_file_path
        PreviousDocumentReference = FSO.GetBaseName(target_file_path)
        IImport_ImportDocument = 1
    Else
        returned_document_path = ""
        IImport_ImportDocument = 0
    End If
    
End Function

Private Property Get IImport_ImportParameters() As EzeScan_Interfaces.UserConfigurableParameter()
    ' EzeScan calls this property to retrieve an array of parameters that are required by the plugin to import a document
    ' in this case there are none (we are returning an empty array)
    IImport_ImportParameters = importParameters_
End Property
