VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Connection_Class"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const MODULE_NAME As String = "Connection_Class"

Implements EzeScan_Interfaces.IConnection

Private outputHandler_ As Output_Class
Private importHandler_ As Import_Class
Private kfiHandler_ As KFIBrowse_Class
Private uploadHandler_ As Upload_Class
Private connectionParameters_() As EzeScan_Interfaces.UserConfigurableParameter

Private Sub Class_Initialize()
    isConnected = False
    PreviousDocumentReference = ""
    
    ' Initialise the shared objects required by the sample plugin
    Set FSO = New FileSystemObject
    Set PluginHelper = New EzeScan_Interfaces.Helper
    Set outputHandler_ = New Output_Class
    Set importHandler_ = New Import_Class
    Set kfiHandler_ = New KFIBrowse_Class
    Set uploadHandler_ = New Upload_Class
    
    ' Create the connection parameters
    PluginHelper.AddParameter connectionParameters_, PluginHelper.CreateParameter("user", "User", ParameterType_String, "Bob", "Enter your username (hint: try Bob)", False)
    PluginHelper.AddParameter connectionParameters_, PluginHelper.CreateParameter("pass", "Password", ParameterType_Password, "bob", "Enter your password (hint: try bob)", False)
    PluginHelper.AddParameter connectionParameters_, PluginHelper.CreateParameter("folder", "Storage Folder", ParameterType_FolderPath, "C:\Storage", "Enter your Storage Folder where documents will be stored", False)
            
End Sub

Private Sub Class_Terminate()
    Set DebugLog = Nothing
    Set outputHandler_ = Nothing
    Set importHandler_ = Nothing
    Set kfiHandler_ = Nothing
    Set uploadHandler_ = Nothing
    Set PluginHelper = Nothing
    Set FSO = Nothing
End Sub

Private Function IConnection_Initialise(system_settings As EzeScan_Interfaces.ISystemSettings, plugin_log As EzeScan_Interfaces.ILogging) As Boolean
    ' EzeScan calls this function mainly to pass the following 2 helper objects
    ' It also allows the plugin to do any extra setup required before a connection occurs

    ' EzeScan passes a log object to the plugin
    Set DebugLog = plugin_log
    
    ' EzeScan passes a system settings object to the plugin
    Set SystemSettings = system_settings
    
    IConnection_Initialise = True ' Success
End Function

Private Property Get IConnection_ConnectionParameters() As EzeScan_Interfaces.UserConfigurableParameter()
    ' EzeScan calls this property to retrieve an array of parameters that are required by the plugin to establish a connection
    ' (e.g a Database connection may require parameters for "Server", "User", "Password", "Database", etc)

    IConnection_ConnectionParameters = connectionParameters_
End Property

Private Function IConnection_Connect(connection_parameters() As EzeScan_Interfaces.UserConfigurableParameter) As Boolean
    ' EzeScan calls this function before it performs any operation that requires or has requested a connection
    
    ' The connection_parameters array is the same one passed out via IConnection_Properties, however now the "Value" property of each element has been filled in
    
    On Error GoTo errHandler
    
    Dim user_name As String
    Dim user_password As String
    Dim folder_path As String
    
    Dim param_index As Long
        
    ' Process the parameters
    
    For param_index = 0 To (PluginHelper.ParameterCount(connection_parameters) - 1)
        
        Select Case connection_parameters(param_index).ID
            Case "user"
                user_name = connection_parameters(param_index).Value
            Case "pass"
                user_password = connection_parameters(param_index).Value
            Case "folder"
                folder_path = connection_parameters(param_index).Value
        End Select
        
    Next param_index
    
    If isConnected And (StorageFolder = folder_path) Then
        DebugLog.LogPluginMessage "Using Existing Connection", PluginDebugLevel_InfoNormal
    Else
        DebugLog.LogPluginMessage "Connecting", PluginDebugLevel_InfoNormal
        
        ' Process the login information
        
        If user_name = "Bob" Then
            DebugLog.LogPluginMessage "Using user: " & user_name, PluginDebugLevel_InfoNormal
            
            If user_password = "bob" Then
                DebugLog.LogPluginMessage "Valid Password", PluginDebugLevel_InfoNormal
                
                If FSO.FolderExists(folder_path) Then
                    DebugLog.LogPluginMessage "Using folder: " & folder_path, PluginDebugLevel_InfoNormal
                    isConnected = True
                    StorageFolder = folder_path
                    UserName = user_name
                Else
                    DebugLog.LogUserErrorMessage "Invalid Folder Path: " & folder_path
                End If
                
            Else
                DebugLog.LogUserErrorMessage "Invalid User or Password"
            End If
        
        Else
            DebugLog.LogUserErrorMessage "Invalid User or Password"
        End If

    End If
    
    IConnection_Connect = isConnected

Exit Function
errHandler:

    DebugError MODULE_NAME, "IConnection_Connect"
    Resume Next
    
End Function

Private Property Get IConnection_ConnectionSpeed() As EzeScan_Interfaces.SpeedType
    ' Use SpeedType_Fast for connections that *fail* quickly (e.g don't time out for more than 1 or 2 seconds)
    IConnection_ConnectionSpeed = SpeedType_Fast
    
    ' Otherwise use SpeedType_Slow
End Property

Private Sub IConnection_Disconnect(ByVal full_disconnect As Boolean)
    ' EzeScan calls this function after it performs any operation that requires or has requested a connection
    
    ' There are 2 types of disconnect, allowing plugins greater flexibility in managing their connections
    ' * A partial disconnect (full_disconnect = False) is to notify the plugin that EzeScan has temporarily finished with the connection (however may require to use it again shortly)
    ' * A full disconnect (full_disconnect = True) is passed when EzeScan has finished with the connection (e.g the application is about to close or a job using a different plugin or EDRMS is selected)
    
    If full_disconnect And isConnected Then
        DebugLog.LogPluginMessage "Disconnecting", PluginDebugLevel_InfoNormal
        isConnected = False
        StorageFolder = ""
    Else
    
        If isConnected Then
            DebugLog.LogPluginMessage "Keeping existing connection", PluginDebugLevel_InfoNormal
        Else
            DebugLog.LogPluginMessage "not currently connected", PluginDebugLevel_InfoNormal
        End If
    
    End If
    
End Sub

Private Function IConnection_RecentDocumentProperty(ByVal property_id As Long, value_out As String) As Long
    ' EzeScan calls this function after a document has been Imported, Outputted or Uploaded to retrieve details that can be used to:
    ' * Display a confirmation to the user
    ' * Output or Upload a new version of an existing document
    ' * Print a barcode containing document information

    Dim return_code As Long

    return_code = 1 ' supported

    Select Case property_id
        Case 0 ' Default
            value_out = PreviousDocumentReference
        Case 1 ' User
            value_out = "D-" & PreviousDocumentReference
        Case 2 ' Title for User
            value_out = "Document ID"
        Case 3 ' Reusable Storage ID (not user visible)
            value_out = PreviousDocumentReference
        Case 4 ' = Barcode value
            value_out = "B_" & PreviousDocumentReference
        Case Else ' Not supported
            value_out = ""
            return_code = 0 ' Not supported
    End Select

    IConnection_RecentDocumentProperty = return_code

End Function

Private Function IConnection_EditCustomParameter(ByVal parameter_id As String, connection_parameters() As EzeScan_Interfaces.UserConfigurableParameter, value_out As String) As Long
    ' EzeScan calls this function when the user is about to edit one of the plugin parameters that is of custom type (i.e it uses it's own dialog)
    ' parameter_id - the id of the parameter being edited
    ' connection_parameters - the current state of the connection parameters
    ' value_out - set this parameter to return the new value
    
    ' Return values:
    ' 0 = User Cancelled
    ' 1 = User Accepted
    ' less than 0 = error code
    
    ' This plugin connection object does not contain any custom parameters - so the return code is always cancel just in case this function is ever called in error
    IConnection_EditCustomParameter = 0
End Function

Private Property Get IConnection_OutputHandler() As EzeScan_Interfaces.IOutput
    ' EzeScan calls this property to retrieve the object that provides the IOutput interface (and therefore handles document output from EzeScan to the Plugin)
    Set IConnection_OutputHandler = outputHandler_
End Property


Private Property Get IConnection_ImportHandler() As EzeScan_Interfaces.IImport
    ' EzeScan calls this property to retrieve the object that provides the IImport interface (and therefore handles document import from the plugin to EzeScan)
    Set IConnection_ImportHandler = importHandler_
End Property

Private Property Get IConnection_KFIHandler() As EzeScan_Interfaces.IKFI
    ' EzeScan calls this property to retrieve the object that provides the IKFI interface (and therefore handles KFI field browsing for the plugin)
    Set IConnection_KFIHandler = kfiHandler_
End Property

Private Property Get IConnection_UploadHandler() As EzeScan_Interfaces.IUpload
    ' EzeScan calls this property to retrieve the object that provides the IOutput interface (and therefore handles document and metadata upload from EzeScan to the Plugin)
    Set IConnection_UploadHandler = uploadHandler_
End Property

