VERSION 5.00
Begin VB.Form ConfigureRange_Dialog 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Configure Range"
   ClientHeight    =   3120
   ClientLeft      =   45
   ClientTop       =   345
   ClientWidth     =   3000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3120
   ScaleWidth      =   3000
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Range_Frame 
      Caption         =   "Range"
      Height          =   2895
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   2775
      Begin VB.CommandButton Cancel_Button 
         Cancel          =   -1  'True
         Caption         =   "&Cancel"
         Height          =   615
         Left            =   1440
         TabIndex        =   6
         Top             =   2040
         Width           =   1215
      End
      Begin VB.CommandButton OK_Button 
         Caption         =   "&OK"
         Height          =   615
         Left            =   120
         TabIndex        =   5
         Top             =   2040
         Width           =   1215
      End
      Begin VB.TextBox End_TextBox 
         Height          =   375
         Left            =   840
         TabIndex        =   4
         Top             =   960
         Width           =   1215
      End
      Begin VB.TextBox Start_TextBox 
         Height          =   375
         Left            =   840
         TabIndex        =   2
         Top             =   480
         Width           =   1215
      End
      Begin VB.Label End_Label 
         Caption         =   "End"
         Height          =   255
         Left            =   240
         TabIndex        =   3
         Top             =   960
         Width           =   495
      End
      Begin VB.Label Start_Label 
         Caption         =   "Start"
         Height          =   255
         Left            =   240
         TabIndex        =   1
         Top             =   480
         Width           =   495
      End
   End
End
Attribute VB_Name = "ConfigureRange_Dialog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const MODULE_NAME As String = "ConfigureRange_Dialog"

Private userCancelled_ As Boolean

Public Function ConfigureRange(range_start As Long, range_end As Long) As Boolean
    userCancelled_ = True
    Start_TextBox.Text = CStr(range_start)
    End_TextBox.Text = CStr(range_end)

    Show vbModal

    ConfigureRange = (Not userCancelled_)
End Function

Public Property Get RangeStart() As Long
    On Error GoTo errHandler
    
    RangeStart = CLng(Start_TextBox.Text)
    
Exit Property
errHandler:

    DebugError MODULE_NAME, "RangeStart"
    ' An invalid range start was provided so instead set it to a reasonable value
    Start_TextBox.Text = "1"
    RangeStart = 1
    
End Property

Public Property Get RangeEnd() As Long
    On Error GoTo errHandler
    
    Dim range_end As Long
    
    range_end = CLng(End_TextBox.Text)
    
    If range_end < RangeStart Then
        ' An invalid range end less than the range start was provided so instead set it to a reasonable value
        DebugLog.LogPluginMessage "Fixing a range end that is before range start", PluginDebugLevel_WarnSevere
        range_end = RangeStart + 9
        End_TextBox.Text = CStr(RangeStart + 9)
    End If
    
    RangeEnd = range_end
    
Exit Property
errHandler:

    DebugError MODULE_NAME, "RangeEnd"
    ' An invalid range end was provided so instead set it to a reasonable value
    End_TextBox.Text = CStr(RangeStart + 9)
    RangeEnd = RangeStart + 9
    
End Property

Private Sub Cancel_Button_Click()
    userCancelled_ = True
    Hide
End Sub

Private Sub OK_Button_Click()
    userCancelled_ = False
    Hide
End Sub
