using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Complete
{
    public partial class SelectRange_Dialog : Form
    {
        public SelectRange_Dialog()
        {
            InitializeComponent();
        }

        private DialogResult _userResponse = DialogResult.Cancel;

        public DialogResult UserResponse
        {
            get { return _userResponse; }
        }

        public Int32 SelectFromRange(Int32 range_start, Int32 range_end)
        {
            Range_ListBox.Items.Clear();
    
            for (Int32 range_item = range_start; range_item <= range_end; range_item++)
            {
                Range_ListBox.Items.Add(range_item.ToString());
            }
    
            Range_ListBox.SelectedIndex = 0;    

            _userResponse =  ShowDialog();

            try
            {
                return Int32.Parse(Range_ListBox.Text);
            }
            catch (Exception ex)
            {
                Connection_Class.DebugError(ex);
                return range_start;
            }
        }
    }
}