using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Complete
{
    public partial class Open_Dialog : Form
    {
        public Open_Dialog()
        {
            InitializeComponent();
        }

        public String OpenDocument(String storage_folder_path)
        {
            String return_path = "";
            String[] file_paths;                        
      
            File_ListBox.Items.Clear();
            
            if (System.IO.Directory.Exists(storage_folder_path))
            {
                file_paths = System.IO.Directory.GetFiles(storage_folder_path, "*.tif");
                
                if (file_paths != null)
                {
                    foreach (String document_path in file_paths)
                    {                    
                        File_ListBox.Items.Add(System.IO.Path.GetFileNameWithoutExtension(document_path));                    
                    }
                }

                if (File_ListBox.Items.Count > 0)
                {
                    // select the first item
                    File_ListBox.SelectedIndex = 0;
                    DialogResult dialog_result = ShowDialog();                    
                    
                    if (dialog_result == DialogResult.OK)
                    {
                        return_path = System.IO.Path.Combine(storage_folder_path, File_ListBox.Text + ".tif");
                    }
                }
                else
                {
                    MessageBox.Show( "The Document Library is empty - there are no documents to import",  "Open Document Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }    
            else
            {
                MessageBox.Show("Document Library folder '" + storage_folder_path + "' does not exist", "Open Document Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            return return_path;
        }
    }
}