using System;
using System.Collections.Generic;
using System.Text;
using EzeScan.Interfaces;
using System.Windows.Forms;

namespace Complete
{
    public class KFIBrowse_Class: IKFI
    {
        private UserConfigurableParameter[] _kfiParameters;
        private String[] _locationNames;
        private String[] _locationIds;

        public KFIBrowse_Class()
        {
            String[] field_names = new String[] { "Range", "Location" };
    
            // Create the parameter that allows us to choose which field to browse
            UserConfigurableParameter new_param = Connection_Class.PluginHelper.CreateLookupParameter("field", "Browse for", ParameterType.Lookup, field_names[0], "Choose the field to browse", ref field_names, false);
            Connection_Class.PluginHelper.AddParameter(ref _kfiParameters, ref new_param);

            // Create the parameter that sets the numeric range - it uses a custom dialog to set the value
            new_param = Connection_Class.PluginHelper.CreateParameter("range", "Range Limits", ParameterType.CustomLocked, "1,10", "Enter the limits to use when browsing for a Range", false);
            Connection_Class.PluginHelper.AddParameter(ref _kfiParameters, ref new_param);
    
            _locationNames = new String[] {"Sydney","London","New York"};
            _locationIds = new String[] {"S421","L3dE","NY31"};
        }

        #region IKFI Members

        int IKFI.BrowseField(ref UserConfigurableParameter[] kfi_parameters, ref string[] values_out, ref string[] hidden_values_out)
        {
            try
            {
    
                UserConfigurableParameter field_parameter = new UserConfigurableParameter();
                UserConfigurableParameter range_parameter = new UserConfigurableParameter();
                             
                Int32 return_code = 0; // Browse cancelled
                
                if (Connection_Class.FindParameter("field", ref kfi_parameters, ref field_parameter))
                {
                    switch (field_parameter.Value)
                    {
                        case "Range":
                            
                            if (Connection_Class.FindParameter("range", ref kfi_parameters, ref range_parameter))
                            {
                                String[] range_parts = range_parameter.Value.Split(new char[] {','});
                                Int32 range_start = Int32.Parse(range_parts[0]);
                                Int32 range_end = Int32.Parse(range_parts[1]);
                                SelectRange_Dialog select_range_dialog = new SelectRange_Dialog();
                                Int32 selected_range = select_range_dialog.SelectFromRange(range_start, range_end);
                            
                                if (select_range_dialog.UserResponse == DialogResult.OK)
                                {
                                    
                                    values_out = new String[] { selected_range.ToString() };
                                    return_code = 1; // Browse Successful
                                }                                                            
                            }
                            
                            break;
                        case "Location":
                            // The plugin doesn't have it's own dialog for the user to select from these values so we just pass them back to EzeScan and let it show them to the user
                            values_out = _locationNames;
                            hidden_values_out = _locationIds;
                            return_code = 1; // Browse Successful
                            break;
                    }
                    
                }   

                return return_code;
            }
            catch (Exception ex)
            {
                
                Connection_Class.DebugError(ex);
                Connection_Class.DebugLog.LogUserErrorMessage("Error browsing field: " + ex.Message);
                return -99; // Error code
            }
        }

        int IKFI.EditCustomParameter(string parameter_id, ref UserConfigurableParameter[] kfi_parameters, ref string value_out)
        {
            try
            {    
                UserConfigurableParameter field_parameter = new UserConfigurableParameter();
                UserConfigurableParameter range_parameter = new UserConfigurableParameter();                         
                
                Int32 return_code = 0; // the user cancelled editing the value
                
                if (Connection_Class.FindParameter("field", ref kfi_parameters, ref field_parameter))
                {
                    if (field_parameter.Value == "Range")
                    {    
                        if (Connection_Class.FindParameter("range", ref kfi_parameters, ref range_parameter))
                        {
                            String[] range_parts = range_parameter.Value.Split(new char[] {','});
                            Int32 range_start = Int32.Parse(range_parts[0]);
                            Int32 range_end = Int32.Parse(range_parts[1]);
                            
                            ConfigureRange_Dialog config_range_dialog = new ConfigureRange_Dialog();

                            if (config_range_dialog.ConfigureRange(range_start, range_end))
                            {
                                value_out = config_range_dialog.RangeStart.ToString() + "," + config_range_dialog.RangeEnd.ToString();
                                return_code = 1; // User accepted change
                            }                                                
                        }
                    }
                    else
                    {
                        MessageBox.Show("Range is not required when browsing location", "Not Required", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    }
                    
                }
            
                return return_code;            
            }
            catch (Exception ex)
            {            
                Connection_Class.DebugError(ex);
                Connection_Class.DebugLog.LogUserErrorMessage( "Error editing range: " + ex.Message);
                return -99; // Error code
            }
        }

        UserConfigurableParameter[] IKFI.FieldBrowseParameters
        {
            // EzeScan calls this property to retrieve an array of parameters that are required by the plugin to browse a field
            get { return _kfiParameters; }
        }

        int IKFI.FieldReturnsHiddenData(ref UserConfigurableParameter[] kfi_parameters)
        {
            // EzeScan calls this function to find out whether the field also returns a hidden id.
            // This allows the plugin to return a user visible description and a hidden id that can later be used during a document upload

            // In this sample Plugin the Location field also returns a hidden location ID

            UserConfigurableParameter field_parameter = new UserConfigurableParameter();
            Int32 return_code = 0; // the field does not return hidden data
            
            // Find the "field" parameter and check if it's value is set to "Location"

            if (Connection_Class.FindParameter("field", ref kfi_parameters, ref field_parameter))
            {
                if (field_parameter.Value == "Location")
                {
                    return_code = 1; // the field returns hidden data
                }
            
            }
                
            return return_code;
        }

        int IKFI.FieldUsesOwnDialog(ref UserConfigurableParameter[] kfi_parameters)
        {
            // EzeScan calls this function to find out whether the Plugin will provide it's own dialog for the current settings (or whether it would like ezescan to manage a simple list)            

            // In this sample Plugin browsing for a Range requires a custom dialog

            UserConfigurableParameter field_parameter = new UserConfigurableParameter();
            Int32 return_code = 0; // the field does not use it's own dialog

            // Find the "field" parameter and check if it's value is set to "Range"

            if (Connection_Class.FindParameter("field", ref kfi_parameters, ref field_parameter))
            {
                if (field_parameter.Value == "Range")
                {
                    return_code = 1; // the field returns hidden data
                }

            }

            return return_code;
        }

        #endregion
    }
}
