using System;
using System.Collections.Generic;
using System.Text;
using EzeScan.Interfaces;

namespace Complete
{
    class Import_Class : IImport
    {
        private UserConfigurableParameter[] _importParameters = new UserConfigurableParameter[] { };



        #region IImport Members

        int IImport.EditCustomParameter(string parameter_id, ref UserConfigurableParameter[] import_parameters, ref string value_out)
        {
            // See Connection_Class.IConnection_EditCustomParameter() for a description of this function
            // This plugin import object does not contain any custom parameters - so the return code is always cancel just in case this function is ever called in error
            return 0;
        }

        int IImport.ImportDocument(string import_folder, ref UserConfigurableParameter[] import_parameters, ref string returned_document_path)
        {                        
            String base_folder = System.IO.Path.Combine(Connection_Class.StorageFolder, Connection_Class.UserName);
            Open_Dialog open_from_dialog = new Open_Dialog();
            String source_file_path = open_from_dialog.OpenDocument(base_folder);    
    
            if (System.IO.File.Exists(source_file_path))
            {
                String target_file_path = System.IO.Path.Combine(import_folder, System.IO.Path.GetFileName(source_file_path));
                System.IO.File.Copy(source_file_path, target_file_path, true);
            
                returned_document_path = target_file_path;
                Connection_Class.PreviousDocumentReference = System.IO.Path.GetFileNameWithoutExtension(target_file_path);
                return 1;
            }
            else
            {
                    returned_document_path = "";
                    return 0;
            }
        }

        UserConfigurableParameter[] IImport.ImportParameters
        {
            // EzeScan calls this property to retrieve an array of parameters that are required by the plugin to import a document
            // in this case there are none (we are returning an empty array)
    
            get { return _importParameters; }
        }

        #endregion
    }
}
