using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using EzeScan.Interfaces;

namespace Complete
{
    public partial class ConfigureRange_Dialog : Form
    {
        public ConfigureRange_Dialog()
        {
            InitializeComponent();
        }        

        public Boolean ConfigureRange(Int32 range_start, Int32 range_end)
        {            
            Start_TextBox.Text = range_start.ToString();
            End_TextBox.Text = range_end.ToString();

            DialogResult dialog_result = this.ShowDialog();

            return (dialog_result == DialogResult.OK);    
        }

        public Int32 RangeStart
        {
            get 
            {
                try
                {
                    return Int32.Parse(Start_TextBox.Text);
                }
                catch (Exception ex)
                {
                    Connection_Class.DebugError(ex);
                    // An invalid range start was provided so instead set it to a reasonable value
                    Start_TextBox.Text = "1";
                    return 1;
                }
            
            }
        }

        public Int32 RangeEnd
        {
            get
            {
                Int32 range_end = 0;

                try
                {                                    
                    range_end = Int32.Parse(End_TextBox.Text);
            
                    if (range_end < RangeStart)
                    {
                        // An invalid range end less than the range start was provided so instead set it to a reasonable value
                        Connection_Class.DebugLog.LogPluginMessage("Fixing a range end that is before range start", PluginDebugLevel.WarnSevere);
                        range_end = (RangeStart + 9);
                        End_TextBox.Text = range_end.ToString();
                    }                                    
                }
                catch (Exception ex)
                {
                    Connection_Class.DebugError(ex);
                    // An invalid range end was provided so instead set it to a reasonable value
                    range_end = (RangeStart + 9); 
                    End_TextBox.Text = range_end.ToString();
                }

                return range_end;
            }
        }

    }
}