var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { C as Component, P as Prop, c as Action, G as Getter, bD as Mutation, V as Vue, M as Moment, d as IndexingClient, T as Transformer, b as baseUrl, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { P as PageIdSelect } from "./pageIdSelect-CR6gaxNP.js";
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a;
let UserNotificationsRoute = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "profileNotifications");
    __publicField(this, "userId");
    __publicField(this, "showActionButtons");
    __publicField(this, "addNotificationConfiguration");
    __publicField(this, "cancelUpdate");
    __publicField(this, "refresh");
    __publicField(this, "updateNotification");
    __publicField(this, "save");
    __publicField(this, "delete");
    __publicField(this, "notifications");
    __publicField(this, "editing");
    __publicField(this, "loading");
    __publicField(this, "editingChanged");
    __publicField(this, "configurationTemplates", [
      { value: null, text: "Custom Configuration" },
      { value: "enable", text: "Enable all notifications" },
      { value: "disable", text: "Disable all notifications" }
    ]);
    __publicField(this, "durationOptions", [
      { value: null, text: "Never" },
      { value: "seconds", text: "Seconds" },
      { value: "minutes", text: "Minutes" },
      { value: "hours", text: "Hours" },
      { value: "hours", text: "Days" }
    ]);
    __publicField(this, "userNotificationTypes", [
      { value: null, text: "All notification types" },
      { value: "created", text: "New Item" },
      { value: "routed", text: "Item Routed" },
      { value: "reactivated", text: "Item Reactivated" }
    ]);
    __publicField(this, "notificationsFields", [
      { key: "pageId", label: "Page" },
      { key: "notificationType", label: "Notification Types" },
      { key: "enabled", label: "" },
      { key: "notificationFrequency", label: "Suppress notifications" },
      { key: "actions", label: "" }
    ]);
    __publicField(this, "secondsInMinute", 60);
    __publicField(this, "secondsInHour", 3600);
    __publicField(this, "secondsInDay", 86400);
    __publicField(this, "confirmDeleteId", null);
    __publicField(this, "pageOptions", []);
    __publicField(this, "durationSelected", null);
    __publicField(this, "configurationTemplate", null);
    __publicField(this, "durationMultiplier", 1);
  }
  mounted() {
    this.getAvailablePages();
  }
  calculateDuration(userNotification) {
    if (this.editing && userNotification.id === this.editing.id)
      return userNotification.notificationFrequency + " " + this.durationSelected;
    let asMilliseconds = userNotification.notificationFrequency * 1e3, calculatedDurationType = this.calculateDurationType(userNotification.notificationFrequency), calculatedDuration = "";
    switch (calculatedDurationType) {
      case "seconds":
        calculatedDuration = userNotification.notificationFrequency + " " + calculatedDurationType;
        break;
      case "minutes":
        calculatedDuration = Moment.duration(asMilliseconds).asMinutes() + " " + calculatedDurationType;
        break;
      case "hours":
        calculatedDuration = Moment.duration(asMilliseconds).asHours() + " " + calculatedDurationType;
        break;
      case "days":
        calculatedDuration = Moment.duration(asMilliseconds).asDays() + " " + calculatedDurationType;
        break;
    }
    return calculatedDuration.startsWith("1 ") && (calculatedDuration = calculatedDuration.slice(0, -1)), calculatedDuration;
  }
  calculateDurationType(duration) {
    let durationType = "";
    return duration < this.secondsInMinute && (durationType = "seconds"), duration >= this.secondsInMinute && duration < this.secondsInHour && (durationType = "minutes"), duration >= this.secondsInHour && duration < this.secondsInDay && (durationType = "hours"), duration >= this.secondsInDay && (durationType = "days"), durationType;
  }
  calculateEditingFrequency() {
    switch (this.durationSelected) {
      case "seconds":
        break;
      case "minutes":
        this.editing.notificationFrequency = this.editing.notificationFrequency / this.secondsInMinute;
        break;
      case "hours":
        this.editing.notificationFrequency = this.editing.notificationFrequency / this.secondsInHour;
        break;
      case "days":
        this.editing.notificationFrequency = this.editing.notificationFrequency / this.secondsInDay;
        break;
    }
  }
  setDurationMultiplier() {
    switch (this.durationSelected) {
      case null:
        this.editing.notificationFrequency = null;
      case "seconds":
        this.durationMultiplier = 1;
        break;
      case "minutes":
        this.durationMultiplier = this.secondsInMinute;
        break;
      case "hours":
        this.durationMultiplier = this.secondsInHour;
        break;
      case "days":
        this.durationMultiplier = this.secondsInDay;
        break;
    }
  }
  setEditingAsTemplate() {
    this.configurationTemplate === "custom" && (this.editing.pageId = null, this.editing.notificationType = null, this.editing.enabled = !0, this.editing.notificationFrequency = null), this.configurationTemplate === "enable" && (this.editing.pageId = null, this.editing.notificationType = null, this.editing.enabled = !0, this.editing.notificationFrequency = null), this.configurationTemplate === "disable" && (this.editing.pageId = null, this.editing.notificationType = null, this.editing.enabled = !1, this.editing.notificationFrequency = null);
  }
  async saveUserNotification() {
    this.editing.pageId === "" && (this.editing.pageId = null), this.editing.notificationFrequency = this.editing.notificationFrequency * this.durationMultiplier, this.save(), this.$root.$emit("bv::hide::modal", "notificationsModal"), this.configurationTemplate = null;
  }
  async addNotificationSetting() {
    this.durationSelected = null, this.addNotificationConfiguration();
  }
  async editUserNotification(notification) {
    this.updateNotification(notification), this.durationSelected = this.calculateDurationType(this.editing.notificationFrequency), this.setDurationMultiplier(), this.calculateEditingFrequency(), this.$root.$emit("bv::show::modal", "notificationsModal");
  }
  async cancel() {
    this.cancelUpdate();
  }
  async deleteNotification(notificationId) {
    this.delete(notificationId);
  }
  async validate() {
    let validators = this.$children.map((c) => c.$validator);
    return await Promise.all(validators.map((v) => v.validateAll())).then((r) => r.every((v) => v));
  }
  hideModal() {
    this.$root.$emit("bv::hide::modal", "notificationsModal");
  }
  async getAvailablePages() {
    let pages = await new IndexingClient(new Transformer(), baseUrl()).getPages();
    this.pageOptions = pages.map((page) => ({ text: page.name, value: page.id }));
  }
  duplicateRuleConflict(userNotification) {
    let conflictMessage = "";
    return this.profileNotifications.forEach((notification) => {
      notification.id != userNotification.id && (notification.pageId === userNotification.pageId && notification.notificationType == userNotification.notificationType && notification.enabled != userNotification.enabled && (conflictMessage = "There is a duplicate rule that could override this rule"), notification.pageId === userNotification.pageId && notification.notificationType == userNotification.notificationType && notification.enabled === userNotification.enabled && (conflictMessage = "There is an duplicate of this rule"));
    }), conflictMessage;
  }
}, __name(_a, "UserNotificationsRoute"), _a);
__decorateClass$1([
  Prop({
    required: !0
  })
], UserNotificationsRoute.prototype, "profileNotifications", 2);
__decorateClass$1([
  Prop({
    required: !1,
    default: null
  })
], UserNotificationsRoute.prototype, "userId", 2);
__decorateClass$1([
  Prop({
    required: !1,
    default: !0
  })
], UserNotificationsRoute.prototype, "showActionButtons", 2);
__decorateClass$1([
  Action("account/notifications/action/add")
], UserNotificationsRoute.prototype, "addNotificationConfiguration", 2);
__decorateClass$1([
  Action("account/notifications/action/cancel")
], UserNotificationsRoute.prototype, "cancelUpdate", 2);
__decorateClass$1([
  Action("account/notifications/action/refresh")
], UserNotificationsRoute.prototype, "refresh", 2);
__decorateClass$1([
  Action("account/notifications/action/update")
], UserNotificationsRoute.prototype, "updateNotification", 2);
__decorateClass$1([
  Action("account/notifications/action/save")
], UserNotificationsRoute.prototype, "save", 2);
__decorateClass$1([
  Action("account/notifications/action/delete")
], UserNotificationsRoute.prototype, "delete", 2);
__decorateClass$1([
  Getter("account/notifications/getters/notifications")
], UserNotificationsRoute.prototype, "notifications", 2);
__decorateClass$1([
  Getter("account/notifications/getters/editing")
], UserNotificationsRoute.prototype, "editing", 2);
__decorateClass$1([
  Getter("account/notifications/getters/loading")
], UserNotificationsRoute.prototype, "loading", 2);
__decorateClass$1([
  Mutation("account/notifications/commit/editingChanged")
], UserNotificationsRoute.prototype, "editingChanged", 2);
UserNotificationsRoute = __decorateClass$1([
  Component({ components: {} })
], UserNotificationsRoute);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "notificationsTable" }, [_c("b-table", { attrs: { striped: "", hover: "", fields: _vm.notificationsFields, items: _vm.profileNotifications, busy: _vm.loading, "show-empty": "" }, scopedSlots: _vm._u([{ key: "empty", fn: /* @__PURE__ */ __name(function(scope) {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" No notification settings configured")], 1), _vm._v(" "), _c("span", [_vm._v("If no notifications configurations are present it will default to the Pages settings")])];
  }, "fn") }, { key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(pageId)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm.duplicateRuleConflict(data.item) ? _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "text-warning", attrs: { title: _vm.duplicateRuleConflict(data.item) } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } })], 1) : _vm._e(), _vm._v(" "), data.item.pageId ? data.value && _vm.pageOptions && _vm.pageOptions.length ? _c("span", [_vm._v(_vm._s(_vm.pageOptions.find((p) => p.value === data.value).text))]) : _vm._e() : _c("span", [_vm._v("All Pages")])];
  }, "fn") }, { key: "cell(notificationType)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.notificationType ? _c("span", [_vm._v(_vm._s(_vm.$options.filters.capitaliseFirstLetter(data.value)))]) : _c("span", [_vm._v("All notification types")])];
  }, "fn") }, { key: "cell(enabled)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.value ? _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "text-success", attrs: { pill: "", title: "Notifications will be sent" } }, [_c("font-awesome-icon", { attrs: { icon: "play" } })], 1) : _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "text-danger", attrs: { pill: "", title: "Notifications will not be sent" } }, [_c("font-awesome-icon", { attrs: { icon: "ban" } })], 1)];
  }, "fn") }, { key: "cell(notificationFrequency)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.enabled ? _c("span", [data.value != "" ? _c("span", [_vm._v(_vm._s(_vm.calculateDuration(data.item)))]) : _c("span", [_vm._v("Never suppress notifications")])]) : _c("span", [_vm._v("N/A")])];
  }, "fn") }, _vm.showActionButtons ? { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_vm.confirmDeleteId === data.item.id ? _c("span", [_c("b-button", { attrs: { variant: "danger", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteNotification(data.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Confirm")], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.confirmDeleteId = null;
    }, "click") } }, [_vm._v("Cancel")])], 1) : _c("span", [_c("b-button", { attrs: { variant: "primary", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editUserNotification(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(" Edit")], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "danger", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.confirmDeleteId = data.item.id;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)], 1)])];
  }, "fn") } : null], null, !0) })], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  UserNotificationsRoute,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "42538ffb"
);
const UserNotificationsTable = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a2;
let UserNotificationModal$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "addNotificationConfiguration");
    __publicField(this, "cancelUpdate");
    __publicField(this, "refresh");
    __publicField(this, "updateNotification");
    __publicField(this, "save");
    __publicField(this, "delete");
    __publicField(this, "notifications");
    __publicField(this, "editing");
    __publicField(this, "loading");
    __publicField(this, "editingChanged");
    __publicField(this, "configurationTemplates", [
      { value: null, text: "Custom Configuration" },
      { value: "enable", text: "Enable all notifications" },
      { value: "disable", text: "Disable all notifications" }
    ]);
    __publicField(this, "durationOptions", [
      { value: null, text: "Never" },
      { value: "seconds", text: "Seconds" },
      { value: "minutes", text: "Minutes" },
      { value: "hours", text: "Hours" },
      { value: "hours", text: "Days" }
    ]);
    __publicField(this, "userNotificationTypes", [
      { value: null, text: "All notification types" },
      { value: "created", text: "New Item" },
      { value: "routed", text: "Item Routed" },
      { value: "reactivated", text: "Item Reactivated" }
    ]);
    __publicField(this, "secondsInMinute", 60);
    __publicField(this, "secondsInHour", 3600);
    __publicField(this, "secondsInDay", 86400);
    __publicField(this, "pageOptions", []);
    __publicField(this, "durationSelected", null);
    __publicField(this, "configurationTemplate", null);
    __publicField(this, "durationMultiplier", 1);
  }
  mounted() {
    this.getAvailablePages();
  }
  setDurationMultiplier() {
    switch (this.durationSelected) {
      case null:
        this.editing.notificationFrequency = null;
      case "seconds":
        this.durationMultiplier = 1;
        break;
      case "minutes":
        this.durationMultiplier = this.secondsInMinute;
        break;
      case "hours":
        this.durationMultiplier = this.secondsInHour;
        break;
      case "days":
        this.durationMultiplier = this.secondsInDay;
        break;
    }
  }
  setEditingAsTemplate() {
    this.configurationTemplate === "custom" && (this.editing.pageId = null, this.editing.notificationType = null, this.editing.enabled = !0, this.editing.notificationFrequency = null), this.configurationTemplate === "enable" && (this.editing.pageId = null, this.editing.notificationType = null, this.editing.enabled = !0, this.editing.notificationFrequency = null), this.configurationTemplate === "disable" && (this.editing.pageId = null, this.editing.notificationType = null, this.editing.enabled = !1, this.editing.notificationFrequency = null);
  }
  async saveUserNotification() {
    this.editing.pageId === "" && (this.editing.pageId = null), this.editing.notificationFrequency = this.editing.notificationFrequency * this.durationMultiplier, this.save(), this.$root.$emit("bv::hide::modal", "notificationsModal"), this.configurationTemplate = null;
  }
  async addNotificationSetting() {
    this.durationSelected = null, this.addNotificationConfiguration();
  }
  async cancel() {
    this.cancelUpdate();
  }
  async deleteNotification(notificationId) {
    this.delete(notificationId);
  }
  async validate() {
    let validators = this.$children.map((c) => c.$validator);
    return await Promise.all(validators.map((v) => v.validateAll())).then((r) => r.every((v) => v));
  }
  hideModal() {
    this.$root.$emit("bv::hide::modal", "notificationsModal");
  }
  async getAvailablePages() {
    await new IndexingClient(new Transformer(), baseUrl()).getPages().then((pages) => {
      this.pageOptions = pages.map((page) => ({ text: page.name, value: page.id }));
    });
  }
  duplicateRuleConflict(userNotification) {
    let conflictMessage = "";
    return this.notifications.forEach((notification) => {
      notification.id != userNotification.id && (notification.pageId === userNotification.pageId && notification.notificationType == userNotification.notificationType && notification.enabled != userNotification.enabled && (conflictMessage = "There is a duplicate rule that could override this rule"), notification.pageId === userNotification.pageId && notification.notificationType == userNotification.notificationType && notification.enabled === userNotification.enabled && (conflictMessage = "There is an duplicate of this rule"));
    }), conflictMessage;
  }
}, __name(_a2, "UserNotificationModal"), _a2);
__decorateClass([
  Action("account/notifications/action/add")
], UserNotificationModal$1.prototype, "addNotificationConfiguration", 2);
__decorateClass([
  Action("account/notifications/action/cancel")
], UserNotificationModal$1.prototype, "cancelUpdate", 2);
__decorateClass([
  Action("account/notifications/action/refresh")
], UserNotificationModal$1.prototype, "refresh", 2);
__decorateClass([
  Action("account/notifications/action/update")
], UserNotificationModal$1.prototype, "updateNotification", 2);
__decorateClass([
  Action("account/notifications/action/save")
], UserNotificationModal$1.prototype, "save", 2);
__decorateClass([
  Action("account/notifications/action/delete")
], UserNotificationModal$1.prototype, "delete", 2);
__decorateClass([
  Getter("account/notifications/getters/notifications")
], UserNotificationModal$1.prototype, "notifications", 2);
__decorateClass([
  Getter("account/notifications/getters/editing")
], UserNotificationModal$1.prototype, "editing", 2);
__decorateClass([
  Getter("account/notifications/getters/loading")
], UserNotificationModal$1.prototype, "loading", 2);
__decorateClass([
  Mutation("account/notifications/commit/editingChanged")
], UserNotificationModal$1.prototype, "editingChanged", 2);
UserNotificationModal$1 = __decorateClass([
  Component({
    components: { PageIdSelect }
  })
], UserNotificationModal$1);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "notifications" }, [_c("b-modal", { attrs: { id: "notificationsModal", "no-close-on-backdrop": "", "hide-footer": "" }, scopedSlots: _vm._u([{ key: "modal-header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "envelope" } }), _vm._v(" Add notification configuration")], 1)];
  }, "fn"), proxy: !0 }, { key: "default", fn: /* @__PURE__ */ __name(function() {
    return [_vm.editing ? _c("b-form", { on: { submit: /* @__PURE__ */ __name(function($event) {
      return $event.stopPropagation(), $event.preventDefault(), _vm.saveUserNotification.apply(null, arguments);
    }, "submit") } }, [_c("b-form-group", { attrs: { id: "pageIdGroup", label: "Template", "label-for": "templateId", description: "Generic templates of popular notification settings" } }, [_c("b-form-select", { attrs: { options: _vm.configurationTemplates }, on: { change: _vm.setEditingAsTemplate }, model: { value: _vm.configurationTemplate, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.configurationTemplate = $$v;
    }, "callback"), expression: "configurationTemplate" } })], 1), _vm._v(" "), _vm.configurationTemplate === null ? _c("span", [_c("b-form-group", { attrs: { id: "pageIdGroup", label: "Indexing Page", "label-for": "pageInputId", description: "The page that is generating the notifications" } }, [_c("page-id-select", { attrs: { "placeholder-text": "All Pages", "all-pages": !0, "available-pages": _vm.pageOptions, "select-first-or-default": !1 }, model: { value: _vm.editing.pageId, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(_vm.editing, "pageId", $$v);
    }, "callback"), expression: "editing.pageId" } })], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "pageIdGroup", label: "Notification Type", "label-for": "pageInputId", description: "Types of events that will generate notifications" } }, [_c("b-form-select", { attrs: { options: _vm.userNotificationTypes }, model: { value: _vm.editing.notificationType, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(_vm.editing, "notificationType", $$v);
    }, "callback"), expression: "editing.notificationType" } })], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "pageIdGroup", description: "Enable or disable notifications from being sent" } }, [_c("b-form-checkbox", { staticClass: "my-2", attrs: { name: "userNotificationEnabled", switch: "" }, model: { value: _vm.editing.enabled, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(_vm.editing, "enabled", $$v);
    }, "callback"), expression: "editing.enabled" } }, [_c("b", [_vm._v("Send notifications")])])], 1), _vm._v(" "), _vm.editing.enabled ? _c("b-form-group", { attrs: { id: "pageIdGroup", label: "Suppress notifications for", "label-for": "pageInputId", description: "Further notifications of the selected type will be suppressed for this time period" } }, [_c("b-input-group", [_c("b-form-input", { attrs: { disabled: _vm.durationSelected === null, id: "frequencyInput", type: "number" }, model: { value: _vm.editing.notificationFrequency, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(_vm.editing, "notificationFrequency", $$v);
    }, "callback"), expression: "editing.notificationFrequency" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-form-select", { staticClass: "flatLeftCorners", attrs: { options: _vm.durationOptions }, on: { change: _vm.setDurationMultiplier }, model: { value: _vm.durationSelected, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.durationSelected = $$v;
    }, "callback"), expression: "durationSelected" } })], 1)], 1)], 1) : _vm._e()], 1) : _vm._e(), _vm._v(" "), _c("b-button", { staticClass: "float-left", attrs: { variant: "outline-secondary" }, on: { click: _vm.hideModal } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { type: "submit", variant: "success", disabled: _vm.loading } }, [_vm.loading ? _c("span", [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Saving")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1)])], 1) : _vm._e()];
  }, "fn"), proxy: !0 }]) })], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  UserNotificationModal$1,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "cae3daaa"
);
const UserNotificationModal = __component__.exports;
export {
  UserNotificationModal as U,
  UserNotificationsTable as a
};
