var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, cF as IndexingManagementUsageStatisticType, cG as IndexingUsageClient, T as Transformer, b as baseUrl, M as Moment, g as v4, C as Component, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { f as Bar, g as Line, C as Chart, p as plugin_title, a as plugin_tooltip, b as plugin_legend, L as LineElement, c as LinearScale, d as CategoryScale, e as PointElement, B as BarElement } from "./index-CL7C-Mhu.js";
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a;
let UsageRouteComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !0);
    __publicField(this, "graphType", IndexingManagementUsageStatisticType.Last24Hours);
    __publicField(this, "chart", "bar");
    __publicField(this, "model", null);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "barComponent", Bar);
    __publicField(this, "lineComponent", Line);
    __publicField(this, "showChart", !1);
    __publicField(this, "usageTypes", [
      { value: IndexingManagementUsageStatisticType.Last24Hours, text: "Last 24 hours" },
      { value: IndexingManagementUsageStatisticType.Today, text: "Today" },
      { value: IndexingManagementUsageStatisticType.LastWeek, text: "Last week" },
      { value: IndexingManagementUsageStatisticType.ThisWeek, text: "This week" },
      { value: IndexingManagementUsageStatisticType.LastMonth, text: "Last month" },
      { value: IndexingManagementUsageStatisticType.ThisMonth, text: "This month" },
      { value: IndexingManagementUsageStatisticType.Last3Months, text: "Last 3 months" },
      { value: IndexingManagementUsageStatisticType.LastYear, text: "Last year" },
      { value: IndexingManagementUsageStatisticType.ThisYear, text: "This year" }
    ]);
    __publicField(this, "chartTypes", [
      { value: "bar", text: "Bar" },
      { value: "line", text: "Line" }
    ]);
  }
  get page() {
    return this.$store.getters["pages/indexing/getters/page"];
  }
  async mounted() {
    await new IndexingUsageClient(new Transformer(), baseUrl()).getCanUseUsage(this.page.id) ? (this.showChart = !0, Chart.register(plugin_title, plugin_tooltip, plugin_legend, LineElement, LinearScale, CategoryScale, PointElement, BarElement, CategoryScale, LinearScale), this.reloadTimer = setInterval(() => this.refresh(), 3e4), await this.refresh()) : this.loading = !1;
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer), this.loading = !1;
  }
  get usageType() {
    return this.graphType;
  }
  set usageType(value) {
    this.graphType = value, this.refresh();
  }
  get chartType() {
    return this.chart;
  }
  set chartType(value) {
    this.loading = !0, this.chart = value, this.loading = !1;
  }
  async refresh() {
    try {
      this.loading = !0;
      let results = await new IndexingUsageClient(new Transformer(), baseUrl()).getUsageStatistics(this.page.id, this.graphType);
      this.model = results;
    } catch {
    } finally {
      this.loading = !1;
    }
  }
  get labels() {
    return this.model.results.map((y) => this.mapDate(y.dateData));
  }
  mapDate(date) {
    switch (this.graphType) {
      case IndexingManagementUsageStatisticType.Last24Hours:
      case IndexingManagementUsageStatisticType.Today:
        return Moment(date).local().format("hA");
      case IndexingManagementUsageStatisticType.LastWeek:
      case IndexingManagementUsageStatisticType.ThisWeek:
        return Moment(date).local().format("dddd");
      case IndexingManagementUsageStatisticType.LastMonth:
      case IndexingManagementUsageStatisticType.ThisMonth:
        return "Week " + Moment(date).local().format("W");
      case IndexingManagementUsageStatisticType.Last3Months:
        return "Week " + Moment(date).local().format("W");
      case IndexingManagementUsageStatisticType.LastYear:
      case IndexingManagementUsageStatisticType.ThisYear:
        return Moment(date).local().format("MMMM");
    }
  }
  get chartData() {
    return {
      labels: this.labels,
      datasets: [
        {
          label: "Added",
          backgroundColor: "#7ecbf1",
          data: this.model.results.map((y) => y.itemsUploaded)
        },
        {
          label: "Indexed",
          backgroundColor: "#76b245",
          data: this.model.results.map((y) => y.itemsIndexed)
        }
      ]
    };
  }
  get chartOptions() {
    return {
      responsive: !0,
      maintainAspectRatio: !1
    };
  }
  get canvasId() {
    return v4();
  }
}, __name(_a, "UsageRouteComponent"), _a);
UsageRouteComponent = __decorateClass([
  Component({
    components: {}
  })
], UsageRouteComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h2", [_vm._v(_vm._s(_vm.page.name)), _c("small", [_vm._v(" - Usage")])]), _vm._v(" "), _vm.page.permissions.overview ? _c("div", [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _vm._e(), _vm._v(" "), _vm.showChart ? _c("b-card", { scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("span", { staticClass: "align-middle" }, [_c("font-awesome-icon", { attrs: { icon: "chart-simple" } }), _vm._v(`
              Usage
              `)], 1), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.refresh(!0);
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)])], 1)];
  }, "fn"), proxy: !0 }], null, !1, 79696856) }, [_vm._v(" "), !_vm.model && _vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _vm._e(), _vm._v(" "), _c("b-form-select", { staticClass: "col-md-1 mr-1", attrs: { options: _vm.chartTypes }, model: { value: _vm.chartType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.chartType = $$v;
  }, "callback"), expression: "chartType" } }), _vm._v(" "), _c("b-form-select", { staticClass: "col-md-2 mr-1", attrs: { options: _vm.usageTypes }, model: { value: _vm.usageType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.usageType = $$v;
  }, "callback"), expression: "usageType" } }), _vm._v(" "), _vm.model && !_vm.loading && _vm.chart == "bar" ? _c(_vm.barComponent, { tag: "component", attrs: { "chart-data": _vm.chartData, "chart-id": _vm.canvasId, "dataset-id-key": "dateData", "chart-options": _vm.chartOptions } }) : _vm._e(), _vm._v(" "), _vm.model && !_vm.loading && _vm.chart == "line" ? _c(_vm.lineComponent, { tag: "component", attrs: { "chart-data": _vm.chartData, "chart-id": _vm.canvasId, "dataset-id-key": "dateData", "chart-options": _vm.chartOptions } }) : _vm._e()], 1) : _vm.loading ? _vm._e() : _c("b-alert", { attrs: { show: "", variant: "warning", id: "notSupportedAlert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
          You must configure your EWA instance to use SQL Server to access the indexing usage graphs.
      `)], 1)], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  UsageRouteComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "cc7b81c2"
);
const usage = __component__.exports;
export {
  usage as default
};
