var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, n as normalizeComponent, k as Keys, b as baseUrl, br as $, bz as $store, p as Keys$1, co as globalMethods, cp as UploadsClient, T as Transformer, P as Prop, C as Component } from "./main-DAVWuHbi.js";
import EwaForm from "./ewaForm-lSjlCSb4.js";
import EwaFieldSection from "./ewaFieldSection-DXWTGb7d.js";
import ValidationProgress from "./validationProgress-B_jQ44I4.js";
import { c as createRegExpFromLiteral } from "./regexHelpers-D8RHIfkG.js";
const _UploadTemplatesComponent = class _UploadTemplatesComponent extends Vue {
};
__name(_UploadTemplatesComponent, "UploadTemplatesComponent");
let UploadTemplatesComponent = _UploadTemplatesComponent;
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this;
  return _vm._self._c, _vm._self._setupProxy, _vm._m(0);
}, "render"), _sfc_staticRenderFns$1 = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "upload-templates" }, [_c("script", { attrs: { id: "template-upload", type: "text/template" } }, [_vm._v(`    
      {% for (var i=0, file; file=o.files[i]; i++) { %}
      <tr class="template-upload">
          <td>
              <span class="preview"></span>
          </td>
          <td>
              <p class="name">{%=file.name%}</p>
              <strong class="error text-danger"></strong>
          </td>
          <td>
              <p class="size">Processing...</p>
              <div class="progress progress-striped active" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0"><div class="progress-bar progress-bar-success" style="width:0%;"></div></div>
          </td>
          <td>
              {% if (!i && !o.options.autoUpload) { %}
              <button class="btn btn-primary start" disabled>
                  <i class="fas fa-upload"></i>
              <span>Start</span>
              </button>
              {% } %}
              {% if (!i) { %}
              <button class="btn btn-warning cancel">
                  <i class="fas fa-ban"></i>
              <span>Cancel</span>
              </button>
              {% } %}
          </td>
      </tr>
      {% } %}
  `)]), _vm._v(" "), _c("script", { attrs: { id: "template-download", type: "text/template" } }, [_vm._v(`
      {% for (var i=0, file; file=o.files[i]; i++) { %}
      <tr class="template-download">
          <td>
              <span class="preview">
                  {% if (file.thumbnailUrl) { %}
                  <a href="{%=file.url%}" title="{%=file.name%}" download="{%=file.name%}" data-gallery><img src="{%=file.thumbnailUrl%}"></a>
                  {% } %}
              </span>
          </td>
          <td>
              <p class="name">
                  {% if (file.url) { %}
                  <a href="{%=file.url%}" title="{%=file.name%}" download="{%=file.name%}" {%=file.thumbnailUrl?'data-gallery':''%}>{%=file.name%}</a>
                  {% } else { %}
                  <span>{%=file.name%}</span>
                  {% } %}
              </p>
              {% if (file.error) { %}
              <div><span class="badge badge-danger">Error</span> {%=file.error%}</div>
              {% } %}
          </td>
          <td>
              <span class="size">{%=o.formatFileSize(file.size)%}</span>
          </td>
          <td>
              {% if (file.deleteUrl) { %}
              <button class="btn btn-danger delete" data-type="{%=file.deleteType%}" data-url="{%=file.deleteUrl%}" {% if (file.deletewithcredentials) { %} data-xhr-fields='{"withCredentials":true}' {% } %}>
                  <i class="fas fa-trash"></i>
                  <span>Delete</span>
              </button>
              <input type="checkbox" name="delete" value="1" class="toggle">
              {% } else { %}
              <button class="btn btn-warning cancel">
                  <i class="fas fa-ban"></i>
                  <span>Cancel</span>
              </button>
              {% } %}
          </td>
      </tr>
      {% } %}
  `)])]);
}], __component__$1 = /* @__PURE__ */ normalizeComponent(
  UploadTemplatesComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const UploadTemplates = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let UploadFilesPage = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "pageId");
    __publicField(this, "sessionId");
    __publicField(this, "fieldContainerId");
    __publicField(this, "fieldColumnCount");
    __publicField(this, "outputButtonText");
    __publicField(this, "restrictFileTypeRegex");
    __publicField(this, "restrictFileSize");
    __publicField(this, "restrictFileCount");
    __publicField(this, "fieldsData");
    __publicField(this, "uploadObserver", null);
    __publicField(this, "loadingExistingFiles", !1);
    __publicField(this, "filesCount", 0);
  }
  created() {
    this.$store.commit(Keys.mutations.GLOBAL_STORE_FIELDS_MODEL, {
      container: this.fieldContainerId,
      fields: this.fieldsData
    });
  }
  async mounted() {
    this.initFileUploadWidget(), this.updateFilesCount(), await this.loadExistingFiles();
  }
  unmounted() {
    this.uploadObserver.disconnect();
  }
  get filesUploadUrl() {
    const encodedPageId = encodeURIComponent(this.pageId), encodedSessionId = encodeURIComponent(this.sessionId);
    return `${baseUrl()}/app/upload/page/${encodedPageId}/file?sessionId=${encodedSessionId}`;
  }
  get processUploadUrl() {
    const encodedPageId = encodeURIComponent(this.pageId), encodedSessionId = encodeURIComponent(this.sessionId);
    return `${baseUrl()}/app/upload/page/${encodedPageId}?sessionId=${encodedSessionId}`;
  }
  get outputButtonTextOrDefault() {
    return this.outputButtonText ?? "Send files to output";
  }
  get submitEnabled() {
    return this.filesCount > 0;
  }
  updateFilesCount() {
    this.filesCount = $(".template-download > td > .delete").length ?? 0;
  }
  async submitAsync() {
    const valid = await $store.dispatch(Keys$1.actions.RUN_VALIDATION_CONTAINER, { container: this.pageId });
    if (console.log(`form.valid = ${valid}`), valid) {
      $("#btnSubmit").prop("disabled", !0), await $store.dispatch(Keys.actions.GLOBAL_POPULATE_GRID);
      const form = $("#EWA-MetaData-Form");
      globalMethods.DisableEWAIgnoreFields(form), form.submit();
    }
  }
  initFileUploadWidget() {
    $(this.$refs.fileUploadWidget).fileupload({
      url: this.filesUploadUrl,
      autoUpload: !0,
      acceptFileTypes: this.restrictFileTypeRegex && this.restrictFileTypeRegex.length > 0 ? createRegExpFromLiteral(this.restrictFileTypeRegex) : void 0,
      maxFileSize: this.restrictFileSize > 0 ? this.restrictFileSize : void 0,
      maxNumberOfFiles: this.restrictFileCount > 0 ? this.restrictFileCount : void 0,
      sequentialUploads: !0,
      maxRetries: 5,
      retryTimeout: 500
    }).on("fileuploadfail", this.onFileUploadFail);
    const _this = this, uploadCallback = /* @__PURE__ */ __name(function(mutationsList, observer) {
      _this.updateFilesCount();
    }, "uploadCallback"), filesTableBody = $(".files")[0], observerOptions = {
      attributes: !0,
      childList: !0,
      subtree: !0
    };
    this.uploadObserver = new MutationObserver(uploadCallback), this.uploadObserver.observe(filesTableBody, observerOptions);
  }
  onFileUploadFail(e, data) {
    const _this = this, fileUpload = $(this).data("blueimp-fileupload") ?? $(this).data("fileupload");
    let retries = data.context.data("retries") ?? 0;
    const retry = /* @__PURE__ */ __name(function() {
      $.ajax({
        url: _this.filesUploadUrl,
        type: "POST",
        files: data.files[0],
        error: /* @__PURE__ */ __name(function(xhr, ajaxOptions, thrownError) {
          fileUpload._trigger("fail", e, data);
        }, "error")
      }).done(function(result) {
        const file = result.file;
        data.uploadedBytes = file && file.size, data.data = null, data.submit();
      });
    }, "retry");
    if (data.errorThrown !== "abort" && data.uploadedBytes < data.files[0].size && retries < fileUpload.options.maxRetries) {
      retries += 1, data.context.data("retries", retries), window.setTimeout(retry, retries * fileUpload.options.retryTimeout);
      return;
    }
    data.context.removeData("retries");
  }
  async loadExistingFiles() {
    this.loadingExistingFiles = !0;
    try {
      const sessionResult = await new UploadsClient(new Transformer(), baseUrl()).session(this.pageId, this.sessionId), widget = $(this.$refs.fileUploadWidget);
      widget.fileupload("option", "done").call(widget, $.Event("done"), {
        result: {
          files: sessionResult.files
        }
      });
    } catch (ex) {
      console.error(ex);
    } finally {
      this.loadingExistingFiles = !1;
    }
  }
}, __name(_a, "UploadFilesPage"), _a);
__decorateClass([
  Prop({
    required: !0
  })
], UploadFilesPage.prototype, "pageId", 2);
__decorateClass([
  Prop({
    required: !0
  })
], UploadFilesPage.prototype, "sessionId", 2);
__decorateClass([
  Prop({
    required: !0
  })
], UploadFilesPage.prototype, "fieldContainerId", 2);
__decorateClass([
  Prop({
    required: !0,
    default: 0
  })
], UploadFilesPage.prototype, "fieldColumnCount", 2);
__decorateClass([
  Prop({
    required: !1,
    default: null
  })
], UploadFilesPage.prototype, "outputButtonText", 2);
__decorateClass([
  Prop({
    required: !1,
    default: null
  })
], UploadFilesPage.prototype, "restrictFileTypeRegex", 2);
__decorateClass([
  Prop({
    required: !1,
    default: 0
  })
], UploadFilesPage.prototype, "restrictFileSize", 2);
__decorateClass([
  Prop({
    required: !1,
    default: 0
  })
], UploadFilesPage.prototype, "restrictFileCount", 2);
__decorateClass([
  Prop({ required: !0 })
], UploadFilesPage.prototype, "fieldsData", 2);
UploadFilesPage = __decorateClass([
  Component({
    components: {
      EwaFieldSection,
      EwaForm,
      ValidationProgress,
      UploadTemplates
    }
  })
], UploadFilesPage);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("UploadTemplates"), _vm._v(" "), _c("EwaForm", [_vm._t("result"), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-8" }, [_c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header" }, [_vm._v("Upload Files")]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("form", { ref: "fileUploadWidget", class: { "fileupload-processing": _vm.loadingExistingFiles }, attrs: { id: "fileupload", action: _vm.filesUploadUrl, method: "POST", enctype: "multipart/form-data" } }, [_c("noscript", [_c("input", { attrs: { type: "hidden", name: "redirect", value: "" } })]), _vm._v(" "), _c("div", { staticClass: "row fileupload-buttonbar" }, [_c("div", { staticClass: "col-lg-12" }, [_c("span", { staticClass: "btn btn-success fileinput-button" }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(" "), _c("span", [_vm._v("Add files...")]), _vm._v(" "), _c("input", { attrs: { type: "file", name: "files[]", multiple: "" } })], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-primary start", attrs: { type: "submit", id: "btnStartUpload" } }, [_c("font-awesome-icon", { attrs: { icon: "upload" } }), _vm._v(" "), _c("span", [_vm._v("Start upload")])], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-warning cancel", attrs: { type: "reset" } }, [_c("font-awesome-icon", { attrs: { icon: "ban" } }), _vm._v(" "), _c("span", [_vm._v("Cancel upload")])], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-danger delete", attrs: { type: "button" } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" "), _c("span", [_vm._v("Delete")])], 1), _vm._v(" "), _c("input", { staticClass: "toggle", attrs: { type: "checkbox" } }), _vm._v(" "), _c("span", { staticClass: "fileupload-process" })]), _vm._v(" "), _c("div", { staticClass: "col-lg-8 mt-2 mb-1 fileupload-progress fade" }, [_c("div", { staticClass: "progress progress-striped active", attrs: { role: "progressbar", "aria-valuemin": "0", "aria-valuemax": "100" } }, [_c("div", { staticClass: "progress-bar progress-bar-success", staticStyle: { width: "0%" } })]), _vm._v(" "), _c("div", { staticClass: "progress-extended" }, [_vm._v(" ")])])]), _vm._v(" "), _c("table", { staticClass: "table table-striped", attrs: { role: "presentation" } }, [_c("tbody", { staticClass: "files" })])])])])]), _vm._v(" "), _c("div", { staticClass: "col-md-4" }, [_c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header" }, [_vm._v("Fields")]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("form", { attrs: { action: _vm.processUploadUrl, method: "post", id: "EWA-MetaData-Form", name: "DetailsForm" } }, [_c("EwaFieldSection", { attrs: { "page-id": _vm.pageId, container: _vm.fieldContainerId, "column-count": _vm.fieldColumnCount, showEditButton: !0 } }), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("button", { staticClass: "btn btn-primary", attrs: { id: "btnSubmit", type: "button", disabled: !_vm.submitEnabled }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.submitAsync();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "file-export" } }), _vm._v(" " + _vm._s(_vm.outputButtonTextOrDefault) + `
                `)], 1)])], 1)]), _vm._v(" "), _c("ValidationProgress", { attrs: { container: _vm.pageId } })], 1)])])], 2)], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  UploadFilesPage,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "bd2fe84a"
);
const uploadFilesPage = __component__.exports;
export {
  uploadFilesPage as default
};
