var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, cH as Keys, t as toastr, cj as URI, b as baseUrl, W as Watch, C as Component, L as LoadingBarComponent } from "./main-DAVWuHbi.js";
const template = `<div>\r
    <loading-bar v-if="loading"></loading-bar>\r
    <div v-else>\r
        <table v-if="templates && templates.length > 0" class="table table-striped">\r
            <caption>My Templates</caption>\r
            <thead>\r
            <tr>\r
                <th>\r
                    Name\r
                </th>\r
                <th>\r
                    Edit\r
                </th>\r
            </tr>\r
            </thead>\r
            <tbody>\r
            <tr v-for="template in templates">\r
                <td>\r
                    <a href="javascript:void(0)" @click="viewTemplate(template)">{{template.name}}</a>\r
                </td>\r
                <td>\r
                    <button @click="openDeleteTemplate(template)" class="btn btn-danger" type="button"><font-awesome-icon icon="trash"></font-awesome-icon> Remove\r
                    </button>\r
                    <button @click="editTemplate(template)" class="btn btn-info" type="button"><font-awesome-icon icon="edit"></font-awesome-icon> Edit\r
                    </button>\r
                </td>\r
            </tr>\r
            </tbody>\r
        </table>\r
        <div v-else class="alert alert-info">\r
            Seems as if you don't have any templates available. Click <a href="javascript:void(0)"\r
                                                                         @click="openAddTemplate">here</a> to create\r
            a new one!\r
        </div>\r
        <button @click="openAddTemplate" type="button" class="btn btn-success">\r
            <font-awesome-icon icon="plus"></font-awesome-icon> New template\r
        </button>\r
    </div>\r
\r
    <!-- Delete template dialog -->\r
    <div class="modal modal-fade deleteModal" role="dialog">\r
        <div class="modal-dialog" role="document">\r
            <div class="modal-content">\r
                <div class="modal-header">\r
                    <h1>Delete template?</h1>\r
                </div>\r
                <div class="modal-body">\r
                    <div class="alert alert-danger" v-if="deleteTemplate">\r
                        Are you sure you want to delete the template "{{deleteTemplate.name}}"?\r
                    </div>\r
                </div>\r
                <div class="modal-footer">\r
                    <button @click="submitDeleteTemplate" type="button" class="btn btn-danger"\r
                            :disabled="deletingTemplate">Delete\r
                    </button>\r
                    <button @click="cancelDeleteTemplate" type="button" class="btn btn-delete">Cancel</button>\r
                </div>\r
                <div v-if="deleteError" class="alert alert-danger">\r
                    Error deleting key\r
                </div>\r
            </div>\r
        </div>\r
    </div>\r
\r
    <!-- Add template dialog -->\r
    <div class="modal modal-fade addModal" role="dialog">\r
        <div class="modal-dialog" role="document">\r
            <div class="modal-content">\r
                <div class="modal-header">\r
                    <h1>Add template</h1>\r
                </div>\r
                <div class="modal-body">\r
                    <div class="alert alert-success" v-if="templateAdded">\r
                        Template successfully added!\r
                        <a class="alert-link" @click="openNewTemplate(addTemplate)" href="javascript:void(0)">Edit new template</a>\r
                    </div>\r
                    <div v-else>\r
                        <div v-if="addError" class="alert alert-danger">\r
                            Error adding key\r
                        </div>\r
                        <form data-vv-scope="add" v-if="addTemplate">\r
                            <div class="form-group" :class="{'has-error': errors.has('add.name')}">\r
                                <label>New Template Name</label>\r
                                <input name="name" class="form-control" type="text" v-validate="'required|unique'"\r
                                       placeholder="Template name" v-model="addTemplate.name"/>\r
                                <span v-show="errors.has('add.name:required')"\r
                                      class="text-muted text-danger">Required</span>\r
                                <span v-show="errors.has('add.name:unique')" class="text-muted text-danger">Template name is already being used.</span>\r
                            </div>\r
                            <div class="checkbox">\r
                                <label>\r
                                    <input type="checkbox" v-model="addTemplate.enabled"> Enabled\r
                                </label>\r
                            </div>\r
                        </form>\r
                    </div>\r
                    <div class="modal-footer">\r
                        <button @click="submitAddTemplate" type="button" class="btn btn-success"\r
                                :disabled="addingTemplate" v-if="!templateAdded">Create\r
                        </button>\r
                        <button @click="cancelAddTemplate" type="button" class="btn btn-delete">\r
                            <span v-if="templateAdded">\r
                                Close\r
                            </span>\r
                            <span v-else>\r
                            Cancel\r
                            </span>\r
                        </button>\r
                    </div>\r
                </div>\r
            </div>\r
        </div>\r
    </div>\r
</div>`;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let DfaTemplatesRoute = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "loadError", null);
    __publicField(this, "page", null);
    __publicField(this, "addModal");
    __publicField(this, "addTemplate", null);
    __publicField(this, "addError", null);
    __publicField(this, "addingTemplate", !1);
    __publicField(this, "templateAdded", null);
    __publicField(this, "deleteModal");
    __publicField(this, "deleteTemplate", null);
    __publicField(this, "deletingTemplate", !1);
    __publicField(this, "deleteError", null);
  }
  created() {
    this.page = this.$store.state.account.pages.pages.find((value) => value.id == this.$router.currentRoute.params.id), this.refresh(), this.$validator.extend("unique", this.unique);
  }
  mounted() {
    this.addModal = $(this.$el).find(".addModal").modal({ show: !1, backdrop: "static", keyboard: !1 }), this.deleteModal = $(this.$el).find(".deleteModal").modal({ show: !1, backdrop: "static", keyboard: !1 });
  }
  unique(value, args) {
    return this.templates.filter((f) => f.name == value).length == 0;
  }
  refresh() {
    this.loading = !0, this.$store.dispatch(Keys.actions.LOAD_TEMPLATES, this.page.id).then(
      (value) => {
        this.loading = !1, this.loadError = null;
      },
      (reason) => {
        this.loading = !1, this.loadError = reason;
      }
    );
  }
  get templates() {
    return this.$store.state.account.pages.dfa.templates;
  }
  confirmDeleteTemplate(template2) {
    this.$store.dispatch(Keys.actions.DELETE_TEMPLATE, {
      templateId: this.deleteTemplate.id,
      pageId: this.page.id
    });
  }
  editTemplate(template2) {
    navigateToTemplate(this.page.id, template2.id, !0);
  }
  viewTemplate(template2) {
    navigateToTemplate(this.page.id, template2.id, !1);
  }
  openDeleteTemplate(template2) {
    this.deleteTemplate = template2;
  }
  openAddTemplate() {
    this.addTemplate = {
      enabled: !0,
      name: "",
      pageId: this.page.id
    };
  }
  watchDeleteTemplate(value) {
    value ? this.deleteModal.modal("show") : this.deleteModal.modal("hide");
  }
  submitDeleteTemplate() {
    this.deletingTemplate = !0, this.$store.dispatch(Keys.actions.DELETE_TEMPLATE, {
      pageId: this.page.id,
      templateId: this.deleteTemplate.id
    }).then((value) => {
      toastr.success("Template successfully deleted"), this.deleteTemplate = null;
    }).finally(() => this.deletingTemplate = !1);
  }
  cancelDeleteTemplate() {
    this.deleteTemplate = null;
  }
  watchAddTemplate(value) {
    value ? (this.templateAdded = null, this.addModal.modal("show")) : this.addModal.modal("hide");
  }
  submitAddTemplate() {
    this.addError = !1, this.$validator.validateAll("add").then(
      (value) => {
        value && (this.addingTemplate = !0, this.$store.dispatch(Keys.actions.CREATE_TEMPLATE, this.addTemplate).then((_) => {
          this.addingTemplate = !1, this.templateAdded = _.id;
        }, (error) => {
          this.addError = error, this.addingTemplate = !1;
        }));
      }
    );
  }
  cancelAddTemplate() {
    this.addTemplate = null;
  }
  openNewTemplate(addTemplate) {
    navigateToTemplate(this.page.id, this.templateAdded, !0);
  }
}, __name(_a, "DfaTemplatesRoute"), _a);
__decorateClass([
  Watch("deleteTemplate")
], DfaTemplatesRoute.prototype, "watchDeleteTemplate", 1);
__decorateClass([
  Watch("addTemplate")
], DfaTemplatesRoute.prototype, "watchAddTemplate", 1);
DfaTemplatesRoute = __decorateClass([
  Component({
    template,
    components: {
      "loading-bar": LoadingBarComponent
    }
  })
], DfaTemplatesRoute);
function navigateToTemplate(pageId, id, edit) {
  const target = new URI(baseUrl() + "/forms/" + pageId);
  edit ? target.query({ editing: id }) : target.query({ templateId: id }), window.location.href = target.toString();
}
__name(navigateToTemplate, "navigateToTemplate");
export {
  DfaTemplatesRoute as default
};
