var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, b as baseUrl, cx as Keys, g as v4, t as toastr, _, c as Action, G as Getter, C as Component, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { U as UploadTemplateModal, E as EditTemplateModal, C as ConfirmDeleteTemplateModal } from "./uploadTemplateModal-BGRuTCg5.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let UserTemplatesRoute = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "deletingTemplate", null);
    __publicField(this, "editingTemplate", null);
    __publicField(this, "load");
    __publicField(this, "deleteTemplateAction");
    __publicField(this, "saveTemplateAction");
    __publicField(this, "templates");
    __publicField(this, "isLoading");
  }
  async mounted() {
    await this.load();
  }
  get tableFields() {
    return [
      { key: "name", tdClass: "align-middle" },
      { key: "description", tdClass: "align-middle" },
      { key: "autoSubmit", tdClass: "align-middle text-center", thClass: "text-center" },
      { key: "created", tdClass: "align-middle" },
      { key: "modified", tdClass: "align-middle" },
      { key: "user", tdClass: "align-middle" },
      { key: "actions", label: "", tdClass: "align-middle" }
    ];
  }
  downloadTemplateUrl(template) {
    return baseUrl() + "/api/page/forms/userControlPanel/templates/" + this.pageId + "/" + template.id + "/download";
  }
  get currentUserId() {
    var _a2;
    return (_a2 = this.$store.getters[Keys.getters.GET_PROFILE]) == null ? void 0 : _a2.id;
  }
  get canUpload() {
    return this.$store.getters["page/forms/userControlPanel/getters/canUpload"];
  }
  get loading() {
    return this.isLoading;
  }
  get pageId() {
    var _a2;
    return (_a2 = this.$store.getters["page/forms/userControlPanel/getters/page"]) == null ? void 0 : _a2.id;
  }
  addTemplate() {
    let newTemplate = {};
    newTemplate.id = v4(), this.editTemplate(newTemplate);
  }
  editUrl(template) {
    let uri = new URL(baseUrl() + "/app/forms/page/" + this.pageId);
    return uri.searchParams.set("editing", template.id), uri.href;
  }
  async copyTemplateLink(template) {
    try {
      await navigator.clipboard.writeText(this.openUrl(template)), toastr.success("Copied '" + template.name + "' link to clipboard");
    } catch {
      toastr.error("Unable to copy template url");
    }
  }
  openUrl(template) {
    let uri = new URL(baseUrl() + "/app/forms/page/" + this.pageId);
    return uri.searchParams.set("templateId", template.id), uri.href;
  }
  deleteTemplate(template) {
    this.deletingTemplate = template, this.$bvModal.show("delete-template-modal");
  }
  async confirmDeleteTemplate() {
    await this.deleteTemplateAction(this.deletingTemplate.id), this.deleteTemplate = null;
  }
  editTemplate(template) {
    this.editingTemplate = _.cloneDeep(template), this.$bvModal.show("edit-template-modal");
  }
  showImportTemplate() {
    this.$bvModal.show("upload-template-modal");
  }
  async saveTemplate(template) {
    try {
      await this.saveTemplateAction(template);
    } catch {
    } finally {
      this.editingTemplate = null;
    }
  }
}, __name(_a, "UserTemplatesRoute"), _a);
__decorateClass([
  Action("page/forms/userControlPanel/templates/actions/load")
], UserTemplatesRoute.prototype, "load", 2);
__decorateClass([
  Action("page/forms/userControlPanel/templates/actions/deleteTemplate")
], UserTemplatesRoute.prototype, "deleteTemplateAction", 2);
__decorateClass([
  Action("page/forms/userControlPanel/templates/actions/createSave")
], UserTemplatesRoute.prototype, "saveTemplateAction", 2);
__decorateClass([
  Getter("page/forms/userControlPanel/templates/getters/templates")
], UserTemplatesRoute.prototype, "templates", 2);
__decorateClass([
  Getter("page/forms/userControlPanel/templates/getters/loading")
], UserTemplatesRoute.prototype, "isLoading", 2);
UserTemplatesRoute = __decorateClass([
  Component({
    components: {
      DateDisplay,
      ConfirmDeleteTemplateModal,
      EditTemplateModal,
      UploadTemplateModal
    }
  })
], UserTemplatesRoute);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("h3", [_vm._v(`Form Templates
              `), _c("b-button", { attrs: { variant: "success", size: "sm" }, on: { click: _vm.addTemplate } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add Template
              `)], 1), _vm._v(" "), _vm.canUpload ? _c("b-button", { attrs: { variant: "info", size: "sm" }, on: { click: _vm.showImportTemplate } }, [_c("font-awesome-icon", { attrs: { icon: "upload" } }), _vm._v(` Upload
              `)], 1) : _vm._e(), _vm._v(" "), _c("span", { staticClass: "float-right" }, [_c("b-button", { attrs: { size: "sm", variant: "outline-secondary", disabled: _vm.loading }, on: { click: _vm.load } }, [_c("font-awesome-icon", { attrs: { icon: "sync", spin: _vm.loading } })], 1)], 1)], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", [_c("b-table", { attrs: { items: _vm.templates, fields: _vm.tableFields, "show-empty": "", emptyText: "No templates found", busy: _vm.loading, hover: "" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(autoSubmit)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("div", { class: data.item.autoSubmit ? "text-success" : "text-danger" }, [_c("font-awesome-icon", { attrs: { icon: data.item.autoSubmit ? "check" : "times" } })], 1)];
  }, "fn") }, { key: "cell(name)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-button", { attrs: { variant: "link", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editTemplate(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "edit" } }), _vm._v(`
            ` + _vm._s(data.item.name) + `
          `)], 1)];
  }, "fn") }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.created } })];
  }, "fn") }, { key: "cell(user)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.userId ? _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "badge badge-secondary", attrs: { title: data.item.userId } }, [_c("font-awesome-icon", { attrs: { icon: "user" } }), _vm._v(` 
              ` + _vm._s(data.item.userDisplayName) + `
            `)], 1) : _c("span", { staticClass: "badge badge-primary" }, [_vm._v(`
                Shared
            `)])];
  }, "fn") }, { key: "cell(modified)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.modified } })];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_c("b-button", { attrs: { variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.copyTemplateLink(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "link" } }), _vm._v(`
              Copy Link
            `)], 1), _vm._v(" "), _c("b-dropdown", { attrs: { "no-flip": "", variant: "primary", size: "sm", "no-caret": "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { attrs: { href: _vm.openUrl(data.item), target: "_blank" } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "file-plus" } }), _vm._v(` Generate Form
                `)], 1), _vm._v(" "), data.item.userId == _vm.currentUserId ? _c("b-dropdown-item", { attrs: { href: _vm.editUrl(data.item), target: "_blank" } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "file-edit" } }), _vm._v(` Edit Form
                `)], 1) : _vm._e(), _vm._v(" "), _vm.canUpload ? _c("b-dropdown-item", { attrs: { href: _vm.downloadTemplateUrl(data.item), target: "_blank" } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "download" } }), _vm._v(` Export Template
                `)], 1) : _vm._e(), _vm._v(" "), data.item.userId == _vm.currentUserId ? _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteTemplate(data.item);
    }, "click") } }, [_c("span", { staticClass: "text-danger" }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "trash" } }), _vm._v(` Delete Template
                  `)], 1)]) : _vm._e()], 1)], 1)];
  }, "fn") }]) })], 1)], 1), _vm._v(" "), _c("confirm-delete-template-modal", { on: { confirm: _vm.confirmDeleteTemplate } }), _vm._v(" "), _c("edit-template-modal", { on: { confirm: _vm.saveTemplate }, model: { value: _vm.editingTemplate, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editingTemplate = $$v;
  }, "callback"), expression: "editingTemplate" } }), _vm._v(" "), _c("upload-template-modal", { attrs: { adminClient: !1 }, on: { uploaded: _vm.load } })], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  UserTemplatesRoute,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "994b2cfe"
);
const templates = __component__.exports;
export {
  templates as default
};
