var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, d as IndexingClient, T as Transformer, b as baseUrl, _, r as namespace, S as State, P as Prop, W as Watch, C as Component, v as vSelect, s as SortableHeader, L as LoadingBarComponent, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { I as ItemIcon } from "./itemIcon-6OcVSOiI.js";
import { b as bytesToSize } from "./fileSizeHelpers-DezEXWHc.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { I as ItemHistoryModal } from "./itemHistoryModal-BQOXXlR-.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { M as MetadataSummary } from "./metadataSummary-BcmsGCgw.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass");
const state = namespace("search", State);
var _a;
let SearchRIAComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "term");
    __publicField(this, "constraintParams");
    __publicField(this, "pageIdsParam");
    __publicField(this, "includeProcessedParam");
    __publicField(this, "searchAllOnLoad");
    __publicField(this, "originalSearchTerm", "");
    __publicField(this, "loadingResults", !1);
    __publicField(this, "riaResults");
    __publicField(this, "historyItem", null);
    __publicField(this, "searchAllPages", !0);
    __publicField(this, "pageOptions", []);
    __publicField(this, "availablePages", []);
    __publicField(this, "metadataIds", []);
    __publicField(this, "showRelevantMetadata", !1);
    __publicField(this, "currentResultConstraints", []);
    __publicField(this, "selectedPages", []);
    __publicField(this, "selectedPage", "");
    __publicField(this, "errorMessages", []);
    __publicField(this, "showAllMetadata", !1);
    __publicField(this, "itemNameConstraintOption", { text: "Item Name", type: "ItemName", id: "ItemName" });
    __publicField(this, "allConstraintOption", { text: "All", type: "All", id: "All" });
  }
  get fields() {
    return [
      { key: "thumbnail", label: "", tdClass: "align-middle" },
      { key: "name", label: "Name", tdClass: "align-middle" },
      { key: "size", label: "Size", tdClass: "align-middle" },
      { key: "timestamp", label: "Created", tdClass: "align-middle" },
      { key: "modified", label: "Modified", tdClass: "align-middle" },
      { key: "history", label: "", tdClass: "align-middle" },
      { key: "page", label: "Page", tdClass: "align-middle" },
      { key: "queue", label: "Queue", tdClass: "align-middle" }
    ];
  }
  watchShowAllMetadata(newVal) {
    this.riaResults.results.forEach((item) => {
      item._showDetails = newVal;
    });
  }
  async mounted() {
    this.term || this.setDefaultConstraints([{ id: { type: "ItemName", id: "ItemName" }, value: "" }]), this.setDefaultConstraints(), await this.getAvailablePages(), this.executeSearchOnLoad() && !this.constraints.length && this.constraints.push({ id: { type: "ItemName", id: "ItemName" }, value: "" }), this.pageIdsParam && this.setSelectedPagesFromParams(), this.constraintParams && this.setConstraintsFromParams(), this.includeProcessedParam && (this.includeProcessed = !0), this.searchTerm = this.term, !this.executeSearchOnLoad() && !this.constraints.length && (this.searchAllOnLoad ? this.constraints.push({ id: { type: "All", id: "All" }, value: this.term }) : this.constraints.push({ id: { type: "ItemName", id: "ItemName" }, value: this.term })), this.setPageMetadataFromPages(this.pageIdsParam === ""), !this.executeSearchOnLoad() && this.term && await this.executeSearch(), this.$nextTick(() => this.$refs.constraintValue[this.constraints.length - 1].$el.focus());
  }
  executeSearchOnLoad() {
    return this.pageIdsParam.length && !this.constraintParams.length;
  }
  setDefaultConstraints(constraintsArray = []) {
    this.constraints = constraintsArray, this.constraintOptions = [this.allConstraintOption, this.itemNameConstraintOption];
  }
  setConstraintsFromParams() {
    let constraintObj = this.constraintParams.split(";");
    this.constraints = constraintObj.filter((conObj) => conObj).map((conObj) => {
      let constraintOjbItems = conObj.split("|");
      return { id: { type: constraintOjbItems[0], id: constraintOjbItems[1] }, value: constraintOjbItems[2] };
    });
  }
  setSelectedPagesFromParams() {
    this.searchAllPages = !1;
    let splitPageIds = this.pageIdsParam.split("|");
    this.selectedPages = splitPageIds.map((pageId) => this.availablePages.find((page) => page.id === pageId)).map((page) => ({ name: page.name, id: page.id }));
  }
  async getAvailablePages() {
    await new IndexingClient(new Transformer(), baseUrl()).getPages().then((pages) => {
      this.availablePages = pages, this.setPageOptions();
    });
    let promises = this.availablePages.map((page) => (page.fields = [], this.getPage(page.id).then((indexingPage) => {
      indexingPage.fields.forEach((field) => {
        page.fields.push(field);
      });
    })));
    await Promise.all(promises);
  }
  pageSelectIsValid() {
    return !this.selectedPages.length && !this.searchAllPages ? !1 : null;
  }
  constraintOptionIsValid(constraint) {
    return this.constraintOptions.find((co) => co.id === constraint.id.id) ? null : !1;
  }
  setPageMetadataFromPages(allPages) {
    allPages ? this.availablePages.forEach((page) => {
      this.setPageFields(page);
    }) : this.setSelectedPagesAsConstraintOptions();
  }
  async getPage(pageId) {
    return await new IndexingClient(new Transformer(), baseUrl()).getPageConfiguration(pageId);
  }
  setSelectedPagesAsConstraintOptions() {
    this.constraintOptions = [this.allConstraintOption, this.itemNameConstraintOption], this.selectedPages.forEach((page) => {
      this.setPageFields({ id: page.id });
    });
  }
  setPageFields(page) {
    this.availablePages.find((p) => p.id == page.id).fields.forEach((field) => {
      this.constraintOptions.find((co) => co.id === field.id && co.text === field.name) == null && this.constraintOptions.push({ text: field.name, type: "Metadata", id: field.id });
    });
  }
  selectPage(page) {
    this.selectedPages.find((p) => p.id == page.id) || (this.selectedPages.push(page), this.setSelectedPagesAsConstraintOptions()), this.selectedPage = "";
  }
  removePage(index) {
    this.selectedPages.splice(index, 1), this.setSelectedPagesAsConstraintOptions();
  }
  setPageOptions() {
    this.pageOptions = this.availablePages.map((page) => ({ text: page.name, value: { name: page.name, id: page.id } }));
  }
  selectAllPages() {
    this.selectedPages = this.availablePages.map((page) => ({ name: page.name, id: page.id })), this.setSelectedPagesAsConstraintOptions();
  }
  flattenConstraints() {
    return this.constraints.map((constraint) => ({ id: constraint.id.id, type: constraint.id.type, value: constraint.value }));
  }
  async executeSearch(newSearch = !1) {
    if (newSearch && await this.$store.dispatch("search/changePage", 1), this.errorMessages = [], this.loadingResults = !0, this.currentResultConstraints = [], this.searchAllPages ? this.pageIds = this.availablePages.map((page) => page.id) : this.selectedPages.length ? this.pageIds = this.selectedPages.map((page) => page.id) : this.errorMessages.push("No pages have been selected"), this.constraints.forEach((constraint) => {
      if (this.constraintOptionIsValid(constraint) != null)
        this.errorMessages.push("The constraint '" + constraint.value + "' has no type set"), this.riaResults.results = [], this.loadingResults = !1;
      else if (!constraint.value) {
        let constraintOption = this.constraintOptions.find((co) => co.id === constraint.id.id);
        this.errorMessages.push("The constraint '" + constraintOption.text + "' has no value"), this.riaResults.results = [], this.loadingResults = !1;
      }
    }), !this.errorMessages.length) {
      await this.$store.dispatch("search/executeRIASearch", this.flattenConstraints()).catch((data) => {
        this.riaResults.results = [], this.errorMessages.push("The search could not execute: " + data);
      }).finally(() => {
        this.loadingResults = !1;
      }), this.showRelevantMetadata = this.constraints.find((con) => con.id.type === "Metadata") != null;
      let cloned = _.cloneDeep(this.riaResults.results);
      this.showAllMetadata ? await cloned.forEach((item) => {
        item._showDetails = !0;
      }) : this.showRelevantMetadata && await cloned.forEach((item) => {
        item._showDetails = this.showRelevantMetadata;
      }), this.riaResults.results = cloned;
      let urlString = "?constraintParams=";
      this.constraints.forEach((constraint) => {
        urlString += encodeURIComponent(constraint.id.type + "|" + constraint.id.id + "|" + constraint.value + ";"), this.currentResultConstraints.push({
          id: { type: constraint.id.type, id: constraint.id.id },
          value: constraint.value
        });
      }), !this.searchAllPages && this.pageIds && this.pageIds.length && (urlString += "&pageIdsParam=", this.pageIds.forEach((pageId, index) => {
        let pageIdsParam = pageId;
        index != this.pageIds.length - 1 && (pageIdsParam += "|"), urlString += encodeURIComponent(pageIdsParam);
      })), this.includeProcessed && (urlString += "&includeProcessed=true"), history.pushState({}, "Indexing Search", urlString);
    }
  }
  removeConstraint(index) {
    this.constraints.splice(index, 1);
  }
  deselectAllPages() {
    this.selectedPages = [], this.setSelectedPagesAsConstraintOptions();
  }
  getGridRowMetadataValue(gridRow) {
    let result = "";
    for (var key in gridRow.value)
      result != "" && (result += ","), gridRow.value[key].value ? result += gridRow.value[key].value : gridRow.value[key].values && (result += "(" + gridRow.value[key].values.map((y) => y.value).join(",") + ")");
    return result;
  }
  findDisplayNameForMetadataItem(metadataItem, pageId) {
    let foundPage = this.availablePages.find((page) => page.id === pageId);
    if (foundPage && foundPage.fields) {
      let foundField = foundPage.fields.find((field) => field.id == metadataItem.id);
      return foundField ? foundField.name : metadataItem.name;
    } else
      return metadataItem.name;
  }
  get constraintOptions() {
    return this.metadataIds;
  }
  set constraintOptions(value) {
    this.metadataIds = value;
  }
  async addConstraint() {
    this.constraints.push({ id: { type: "ItemName", id: "ItemName" }, value: "" }), this.$nextTick(() => this.$refs.constraintValue[this.constraints.length - 1].$el.focus());
  }
  itemUrl(itemId) {
    return new URL(baseUrl() + "/app/indexing/items/" + itemId).href;
  }
  pageUrl(pageId) {
    return new URL(baseUrl() + "/app/indexing/pages/" + pageId + "/defaultQueue/").href;
  }
  queueUrl(queueId, pageId) {
    return new URL(baseUrl() + "/app/indexing/queues/" + queueId + "/list#/").href;
  }
  itemThumbnail(result) {
    var _a2;
    return result.item.isIndexed ? (_a2 = result.item.thumbnail) == null ? void 0 : _a2.fallback : result.item.thumbnail;
  }
  get constraints() {
    return this.$store.getters["search/constraints"];
  }
  set constraints(value) {
    this.$store.dispatch("search/setConstraints", value);
  }
  get includeProcessed() {
    return this.$store.getters["search/includeProcessed"];
  }
  set includeProcessed(value) {
    this.$store.dispatch("search/setIncludeProcessed", value);
  }
  get sort() {
    return this.$store.getters["search/sort"];
  }
  set sort(value) {
    this.$store.dispatch("search/sortItems", value), this.executeSearch(!0);
  }
  set pageIds(value) {
    this.$store.dispatch("search/setPageIds", value);
  }
  get pageIds() {
    return this.$store.getters["search/pageIds"];
  }
  set searchTerm(value) {
    this.$store.commit("search/updateRiaSearchTerm", value);
  }
  get pageNumber() {
    return this.$store.getters["search/pageNumber"] || 1;
  }
  set pageNumber(value) {
    this.$store.dispatch("search/changePage", value), this.executeSearch();
  }
  get searchTerm() {
    return this.$store.getters["search/riaSearchTerm"];
  }
  get totalPages() {
    return this.$store.getters["search/totalPages"] || 1;
  }
  watchSort(oldVal, newVal) {
    this.$emit("sort", oldVal);
  }
}, __name(_a, "SearchRIAComponent"), _a);
__decorateClass([
  Prop({
    required: !1
  })
], SearchRIAComponent.prototype, "term", 2);
__decorateClass([
  Prop({
    required: !1
  })
], SearchRIAComponent.prototype, "constraintParams", 2);
__decorateClass([
  Prop({
    required: !1
  })
], SearchRIAComponent.prototype, "pageIdsParam", 2);
__decorateClass([
  Prop({
    required: !1
  })
], SearchRIAComponent.prototype, "includeProcessedParam", 2);
__decorateClass([
  Prop({
    required: !1,
    default: !1
  })
], SearchRIAComponent.prototype, "searchAllOnLoad", 2);
__decorateClass([
  state
], SearchRIAComponent.prototype, "riaResults", 2);
__decorateClass([
  Watch("showAllMetadata")
], SearchRIAComponent.prototype, "watchShowAllMetadata", 1);
__decorateClass([
  Watch("sort")
], SearchRIAComponent.prototype, "watchSort", 1);
SearchRIAComponent = __decorateClass([
  Component({
    components: {
      SortableHeaderLink,
      MetadataSummary,
      LoadingBar: LoadingBarComponent,
      DateDisplay,
      SortableHeader,
      ItemThumbnail: ItemIcon,
      ItemHistoryModal,
      PaginationControls,
      vSelect
    },
    filters: { convertBytesToSize: /* @__PURE__ */ __name((bytes) => bytesToSize(bytes), "convertBytesToSize") }
  })
], SearchRIAComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_vm.errorMessages.length ? _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-sm-12" }, [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "danger", show: "", dismissible: "" } }, [_c("span", { staticClass: "font-weight-bold" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" The search result could not be executed")], 1), _vm._v(" "), _c("ul", _vm._l(_vm.errorMessages, function(errorMessage) {
    return _c("li", [_vm._v(_vm._s(errorMessage))]);
  }), 0)])], 1)]) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("form", { staticClass: "input-group", attrs: { action: "javascript:void(0);" } }, [_c("div", { staticClass: "col-sm-12 pb-2" }, [_c("b-form-tags", { staticClass: "tag-select-slim pt-2", attrs: { id: "tags-component-select", "add-on-change": "", "no-outer-focus": "" }, scopedSlots: _vm._u([{ key: "default", fn: /* @__PURE__ */ __name(function({ disabled }) {
    return [_c("b-input-group", [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("b-form-checkbox", { attrs: { switch: "" }, on: { change: _vm.setPageMetadataFromPages }, model: { value: _vm.searchAllPages, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.searchAllPages = $$v;
    }, "callback"), expression: "searchAllPages" } }, [_c("b", [_vm._v("All Pages")])])], 1), _vm._v(" "), _c("b-form-select", { attrs: { state: _vm.pageSelectIsValid(), disabled: _vm.pageOptions.length === 0 || _vm.searchAllPages, options: _vm.pageOptions }, on: { change: _vm.selectPage }, scopedSlots: _vm._u([{ key: "first", fn: /* @__PURE__ */ __name(function() {
      return [_c("option", { attrs: { disabled: "", value: "" } }, [_vm.searchAllPages ? _c("span", [_vm._v("Searching all pages")]) : _c("span", [_vm._v("Select pages...")])])];
    }, "fn"), proxy: !0 }], null, !0), model: { value: _vm.selectedPage, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.selectedPage = $$v;
    }, "callback"), expression: "selectedPage" } }), _vm._v(" "), _vm.searchAllPages ? _vm._e() : _c("b-input-group-append", [_c("b-button", { directives: [{ name: "tooltip", rawName: "v-tooltip", value: "Deselect all pages", expression: "'Deselect all pages'" }], attrs: { variant: "outline-primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deselectAllPages();
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: ["far", "square"] } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "tooltip", rawName: "v-tooltip", value: "Select all pages", expression: "'Select all pages'" }], attrs: { variant: "outline-primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.selectAllPages();
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "check-square" } })], 1)], 1)], 1), _vm._v(" "), !_vm.searchAllPages && _vm.selectedPages.length > 0 ? _c("ul", { staticClass: "list-inline d-inline-block mt-2 mb-0" }, _vm._l(_vm.selectedPages, function(page, index) {
      return _c("li", { key: page.id, staticClass: "list-inline-item" }, [_c("b-form-tag", { attrs: { variant: "info" }, on: { remove: /* @__PURE__ */ __name(function($event) {
        return _vm.removePage(index);
      }, "remove") } }, [_vm._v(_vm._s(page.name))])], 1);
    }), 0) : _vm._e()];
  }, "fn") }]) })], 1), _vm._v(" "), _c("div", { staticClass: "col-md-12" }, _vm._l(_vm.constraints, function(constraint, index) {
    return _c("b-input-group", { staticClass: "pb-2" }, [_c("b-input-group-prepend", { staticClass: "list-selector" }, [_vm.constraintOptions.length ? _c("v-select", { attrs: { clearable: !1, label: "text", options: _vm.constraintOptions }, scopedSlots: _vm._u([{ key: "selected-option", fn: /* @__PURE__ */ __name(function(option) {
      return [option.type === "ItemName" ? _c("font-awesome-icon", { attrs: { icon: "info-circle" } }) : option.type === "All" ? _c("font-awesome-icon", { attrs: { icon: "maximize" } }) : _c("font-awesome-icon", { attrs: { icon: "tag" } }), _vm._v(`
                     
                    `), _vm.constraintOptions.find((co) => co.id === option.id) ? _c("span", [_vm._v(_vm._s(_vm.constraintOptions.find((co) => co.id === option.id).text))]) : _vm._e()];
    }, "fn") }, { key: "option", fn: /* @__PURE__ */ __name(function(option) {
      return [option.type === "ItemName" ? _c("font-awesome-icon", { attrs: { icon: "info-circle" } }) : option.type === "All" ? _c("font-awesome-icon", { attrs: { icon: "maximize" } }) : _c("font-awesome-icon", { attrs: { icon: "tag" } }), _vm._v(`
                     
                    `), option.text ? _c("span", [_vm._v(_vm._s(option.text))]) : _vm._e()];
    }, "fn") }], null, !0), model: { value: constraint.id, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(constraint, "id", $$v);
    }, "callback"), expression: "constraint.id" } }) : _vm._e()], 1), _vm._v(" "), _c("b-form-input", { ref: "constraintValue", refInFor: !0, staticClass: "form-control", attrs: { state: _vm.constraintOptionIsValid(constraint), type: "text", placeholder: "Constraint value...", id: "constraintValue" + index }, model: { value: constraint.value, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(constraint, "value", $$v);
    }, "callback"), expression: "constraint.value" } }), _vm._v(" "), _vm.constraints.length > 1 ? _c("b-input-group-append", [_c("button", { staticClass: "btn btn-outline-secondary", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.removeConstraint(index);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "minus" } })], 1)]) : _vm._e()], 1);
  }), 1), _vm._v(" "), _c("div", { staticClass: "col-sm-6" }, [_c("b-form-checkbox", { staticClass: "input-group ml-2 mt-1", attrs: { size: "md" }, model: { value: _vm.includeProcessed, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.includeProcessed = $$v;
  }, "callback"), expression: "includeProcessed" } }, [_vm._v("Include processed items")])], 1), _vm._v(" "), _c("div", { staticClass: "col-sm-6" }, [_c("button", { staticClass: "btn btn-link btn-sm float-right", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.addConstraint();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(" Add constraint")], 1)]), _vm._v(" "), _c("div", { staticClass: "col-sm-12" }, [_c("span", { staticClass: "float-right py-2" }, [_c("button", { staticClass: "btn btn-primary", attrs: { type: "submit" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return $event.preventDefault(), _vm.executeSearch(!0);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "search" } }), _vm._v(` Search
              `)], 1)])])])]), _vm._v(" "), _vm.loadingResults ? _c("loading-bar", [_vm._v("Searching...")]) : _vm._e(), _vm._v(" "), _vm.riaResults && _vm.riaResults.results && !_vm.loadingResults ? _c("div", [_vm.riaResults.results && _vm.riaResults.results.length > 0 ? _c("div", { staticClass: "table" }, [_c("div", { staticClass: "row" }, [!_vm.loadingResults && _vm.riaResults && _vm.riaResults.results ? _c("span", { staticClass: "col-sm-6 font-weight-bold py-2" }, [_vm._v(`
                ` + _vm._s(_vm.riaResults.totalCount) + ` results
              `)]) : _vm._e(), _vm._v(" "), _vm.totalPages > 1 ? _c("span", { staticClass: "col-sm-6" }, [_c("span", { staticClass: "float-right" }, [_c("pagination-controls", { attrs: { count: _vm.totalPages, justifyContent: !1 }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } })], 1)]) : _vm._e()]), _vm._v(" "), _c("b-table", { attrs: { items: _vm.riaResults.results, fields: _vm.fields, striped: "", responsive: "", "details-td-class": "halfWidth py-0" }, scopedSlots: _vm._u([{ key: "head(thumbnail)", fn: /* @__PURE__ */ __name(function(data) {
  }, "fn") }, { key: "head(name)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("sortable-header-link", { attrs: { id: "name", label: "Name" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(size)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("sortable-header-link", { attrs: { id: "size", label: "Size" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(timestamp)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("sortable-header-link", { attrs: { id: "timestamp", label: "Created" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(modified)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("sortable-header-link", { attrs: { id: "modified", label: "Modified" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(history)", fn: /* @__PURE__ */ __name(function(data) {
  }, "fn") }, { key: "head(page)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v("Page")];
  }, "fn") }, { key: "head(queue)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("sortable-header-link", { attrs: { id: "queue", label: "Queue" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } }), _vm._v(" "), _c("b-badge", { directives: [{ name: "tooltip", rawName: "v-tooltip", value: "Show/Hide Metadata", expression: "'Show/Hide Metadata'" }], staticClass: "float-right", attrs: { href: "#", variant: "info", pill: "" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.showAllMetadata = !_vm.showAllMetadata;
    }, "click") } }, [_vm.showAllMetadata ? _c("font-awesome-icon", { attrs: { icon: "eye-slash" } }) : _c("font-awesome-icon", { attrs: { icon: "eye" } })], 1)];
  }, "fn") }, { key: "cell(thumbnail)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("item-thumbnail", { attrs: { value: _vm.itemThumbnail(data.item), lazy: !0, size: "s" } })];
  }, "fn") }, { key: "cell(name)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.item.isIndexed ? _c("span", [_c("span", [_vm._v(_vm._s(data.item.item.name))]), _vm._v(`
                 `), _c("font-awesome-icon", { directives: [{ name: "tooltip", rawName: "v-tooltip", value: "Item has been indexed", expression: "'Item has been indexed'" }], attrs: { icon: "file-export" } })], 1) : _c("a", { attrs: { href: _vm.itemUrl(data.item.item.id) } }, [_vm._v(_vm._s(data.item.item.name))])];
  }, "fn") }, { key: "cell(size)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(_vm._s(_vm._f("convertBytesToSize")(data.item.item.size)))];
  }, "fn") }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.item.created } })];
  }, "fn") }, { key: "cell(modified)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.item.modified } })];
  }, "fn") }, { key: "cell(history)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("button", { staticClass: "btn btn-link pl-3", attrs: { title: "Show history" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.historyItem = data.item.item.id;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "history" } })], 1), _vm._v(" "), _c("item-history-modal", { attrs: { item: data.item.item, shouldShow: _vm.historyItem == data.item.item.id }, on: { close: /* @__PURE__ */ __name(function($event) {
      _vm.historyItem = null;
    }, "close") } })];
  }, "fn") }, { key: "cell(page)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("a", { attrs: { href: _vm.pageUrl(data.item.page.id) } }, [_vm._v(_vm._s(data.item.page.name))])];
  }, "fn") }, { key: "cell(queue)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("a", { attrs: { href: _vm.queueUrl(data.item.queue.id, data.item.page.id) } }, [_vm._v(_vm._s(data.item.queue.name))])];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._l(_vm.currentResultConstraints.filter((con) => con.id.type === "Metadata"), function(constraint) {
      return _vm.showRelevantMetadata && !_vm.showAllMetadata ? _c("div", [_c("metadata-summary", { attrs: { value: [data.item.item.metadata.find((md) => md.id === constraint.id.id)] } })], 1) : _vm._e();
    }), _vm._v(" "), _vm.showAllMetadata ? _c("div", [_c("metadata-summary", { attrs: { value: data.item.item.metadata } })], 1) : _vm._e()];
  }, "fn") }], null, !1, 2309425070) }), _vm._v(" "), _vm.totalPages > 1 ? _c("div", { staticClass: "text-center" }, [_c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } })], 1) : _vm._e()], 1) : _vm._e()]) : _vm._e(), _vm._v(" "), !_vm.loadingResults && _vm.currentResultConstraints.length > 0 && !_vm.riaResults.results.length ? _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-sm-12" }, [_c("b-alert", { attrs: { variant: "warning", show: "" } }, [_c("font-awesome-icon", { staticClass: "font-weight-bold", attrs: { icon: "exclamation-triangle" } }), _vm._v(` No results were returned from the search
              `)], 1)], 1)])]) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  SearchRIAComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "c1680319"
);
const searchAll = __component__.exports;
export {
  searchAll as default
};
