var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, d as IndexingClient, T as Transformer, b as baseUrl, q as SearchClient, t as toastr, r as namespace, P as Prop, W as Watch, C as Component, S as State, v as vSelect, s as SortableHeader, L as LoadingBarComponent, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { I as ItemIcon } from "./itemIcon-6OcVSOiI.js";
import { b as bytesToSize } from "./fileSizeHelpers-DezEXWHc.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { V as VueMultiselect } from "./vue-multiselect.min-BYrAqjX1.js";
import { I as ItemHistoryModal } from "./itemHistoryModal-BQOXXlR-.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { M as MetadataSummary } from "./metadataSummary-BcmsGCgw.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass");
namespace("search", State);
var _a;
let GlobalSearchComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "term");
    __publicField(this, "advancedMode", !1);
    __publicField(this, "loadingResults", !1);
    __publicField(this, "responseModel", null);
    __publicField(this, "searchResults", []);
    __publicField(this, "searchTerm", "");
    __publicField(this, "historyItem", null);
    __publicField(this, "showRelevantMetadata", !1);
    __publicField(this, "currentResultConstraints", []);
    __publicField(this, "showAllMetadata", !1);
    __publicField(this, "selectedPages", []);
    __publicField(this, "availablePages", []);
    __publicField(this, "totalCount", 0);
    __publicField(this, "pageNumber", 1);
    __publicField(this, "itemsPerPage", 25);
    __publicField(this, "sort", { by: "timestamp", descending: !1 });
  }
  watchselectedPages() {
    this.executeSearch();
  }
  watchShowAllMetadata(newVal) {
    this.searchResults.forEach((item) => {
      item._showDetails = newVal;
    });
  }
  watchpageNumber() {
    this.executeSearch();
  }
  watchSort(oldVal, newVal) {
    this.executeSearch();
  }
  get fields() {
    return [
      { key: "thumbnail", label: "", tdClass: "align-middle" },
      { key: "name", label: "Name", tdClass: "align-middle" },
      { key: "size", label: "Size", tdClass: "align-middle" },
      { key: "created", label: "Created", tdClass: "align-middle" },
      { key: "modified", label: "Modified", tdClass: "align-middle" },
      { key: "history", label: "", tdClass: "align-middle" },
      { key: "page", label: "Page", tdClass: "align-middle" },
      { key: "queue", label: "Queue", tdClass: "align-middle" }
    ];
  }
  async mounted() {
    this.searchTerm = this.term, await this.executeSearch(), await this.getAvailablePages();
  }
  async getAvailablePages() {
    await new IndexingClient(new Transformer(), baseUrl()).getPages().then((pages) => {
      this.availablePages = pages.map((page) => ({ text: page.name, value: page.id }));
    });
  }
  async executeSearch() {
    this.totalCount = 0, this.searchResults = [], this.loadingResults = !0;
    let searchTermExtended = "*" + this.searchTerm.replace(/ /g, "?") + "*", pageIds = this.selectedPages.map((sp) => sp), sortString = this.sort.by;
    this.sort.descending && (sortString = "-" + sortString);
    let searchRequest = { searchTerm: searchTermExtended, pageIds, page: this.pageNumber, pageSize: this.itemsPerPage, sort: sortString };
    new SearchClient(new Transformer(), baseUrl()).executeSearch(searchRequest).then((model) => {
      this.responseModel = model, this.searchResults = model.results, this.totalCount = model.totalCount;
    }).catch((e) => {
      toastr.error("Something has gone wrong while loading the authentication provider: " + e);
    }).finally(() => {
      this.loadingResults = !1;
    });
  }
  itemUrl(itemId) {
    return new URL(baseUrl() + "/app/indexing/items/" + itemId).href;
  }
  pageUrl(pageId) {
    return new URL(baseUrl() + "/app/indexing/pages/" + pageId + "/defaultQueue/").href;
  }
  queueUrl(queueId, pageId) {
    return new URL(baseUrl() + "/app/indexing/queues/" + queueId + "/list#/").href;
  }
  itemThumbnail(result) {
    var _a2;
    return result.item.isIndexed ? (_a2 = result.item.thumbnail) == null ? void 0 : _a2.fallback : result.item.thumbnail;
  }
  get filteredAvailablePages() {
    return this.availablePages.filter((page) => this.selectedPages.indexOf(page.value) === -1);
  }
  get totalPages() {
    return Math.max(1, Math.ceil(this.totalCount / this.itemsPerPage));
  }
}, __name(_a, "GlobalSearchComponent"), _a);
__decorateClass([
  Prop({ required: !1 })
], GlobalSearchComponent.prototype, "term", 2);
__decorateClass([
  Watch("selectedPages")
], GlobalSearchComponent.prototype, "watchselectedPages", 1);
__decorateClass([
  Watch("showAllMetadata")
], GlobalSearchComponent.prototype, "watchShowAllMetadata", 1);
__decorateClass([
  Watch("pageNumber")
], GlobalSearchComponent.prototype, "watchpageNumber", 1);
__decorateClass([
  Watch("sort")
], GlobalSearchComponent.prototype, "watchSort", 1);
GlobalSearchComponent = __decorateClass([
  Component({
    components: {
      SortableHeaderLink,
      MetadataSummary,
      LoadingBar: LoadingBarComponent,
      DateDisplay,
      SortableHeader,
      ItemThumbnail: ItemIcon,
      ItemHistoryModal,
      PaginationControls,
      vSelect,
      VueMultiselect
    },
    filters: { convertBytesToSize: /* @__PURE__ */ __name((bytes) => bytesToSize(bytes), "convertBytesToSize") }
  })
], GlobalSearchComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-form", { on: { submit: _vm.executeSearch } }, [_c("b-input-group", { staticClass: "mt-3", scopedSlots: _vm._u([{ key: "append", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-btn", { attrs: { type: "submit", disabled: _vm.loadingResults, variant: "outline-primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return $event.preventDefault(), _vm.executeSearch(!0);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "search" } }), _vm._v(`
          Search
        `)], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-form-input", { model: { value: _vm.searchTerm, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.searchTerm = $$v;
  }, "callback"), expression: "searchTerm" } })], 1)], 1), _vm._v(" "), _c("div", { staticClass: "multi-select mt-2" }, [_c("b-form-tags", { staticClass: "tag-select-slim", attrs: { id: "selectPagesFormTags", size: "sm", "add-on-change": "", "no-outer-focus": "" }, scopedSlots: _vm._u([{ key: "default", fn: /* @__PURE__ */ __name(function({ tags, inputAttrs, inputHandlers, disabled, removeTag }) {
    return [_c("b-form-select", _vm._g(_vm._b({ attrs: { disabled: _vm.filteredAvailablePages.length === 0, options: _vm.filteredAvailablePages }, scopedSlots: _vm._u([{ key: "first", fn: /* @__PURE__ */ __name(function() {
      return [_vm.selectedPages.length === 0 ? _c("option", { attrs: { disabled: "", value: "" } }, [_vm._v("All Pages")]) : _c("option", { attrs: { disabled: "", value: "" } }, [_vm._v(_vm._s(_vm.selectedPages.length) + " pages selected")])];
    }, "fn"), proxy: !0 }], null, !0) }, "b-form-select", inputAttrs, !1), inputHandlers)), _vm._v(" "), _c("ul", { staticClass: "list-inline d-inline-block mb-2 mt-1" }, _vm._l(tags, function(tag) {
      return _c("li", { key: tag, staticClass: "list-inline-item" }, [_c("b-form-tag", { attrs: { title: tag, disabled, variant: "info" }, on: { remove: /* @__PURE__ */ __name(function($event) {
        return removeTag(tag);
      }, "remove") } }, [_vm._v(_vm._s(_vm.availablePages.find((page) => page.value == tag).text))])], 1);
    }), 0), _vm._v(" "), _vm.totalCount ? _c("b-badge", { staticClass: "float-right mt-2 mb-2", attrs: { variant: "primary" } }, [_vm._v(`
        ` + _vm._s(_vm.totalCount) + " results")]) : _vm._e()];
  }, "fn") }]), model: { value: _vm.selectedPages, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.selectedPages = $$v;
  }, "callback"), expression: "selectedPages" } })], 1), _vm._v(" "), _vm.loadingResults ? _c("div", { staticClass: "pt-3" }, [_c("loading-bar", [_vm._v("Searching...")])], 1) : _vm._e(), _vm._v(" "), _vm.responseModel && _vm.searchResults ? _c("div", [_vm.searchResults.length > 0 ? _c("div", { staticClass: "table" }, [_c("div", { staticClass: "row" }), _vm._v(" "), _c("b-table", { attrs: { items: _vm.searchResults, fields: _vm.fields, striped: "", responsive: "", "details-td-class": "halfWidth py-0" }, scopedSlots: _vm._u([{ key: "head(thumbnail)", fn: /* @__PURE__ */ __name(function(data) {
  }, "fn") }, { key: "head(name)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("sortable-header-link", { attrs: { id: "name", label: "Name" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(size)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("sortable-header-link", { attrs: { id: "size", label: "Size" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(created)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("sortable-header-link", { attrs: { id: "created", label: "Created" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(modified)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("sortable-header-link", { attrs: { id: "modified", label: "Modified" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(history)", fn: /* @__PURE__ */ __name(function(data) {
  }, "fn") }, { key: "head(page)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(`
              Page
            `)];
  }, "fn") }, { key: "head(queue)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("sortable-header-link", { attrs: { id: "queue", label: "Queue" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } }), _vm._v(" "), _c("b-badge", { directives: [{ name: "tooltip", rawName: "v-tooltip", value: "Show/Hide Metadata", expression: "'Show/Hide Metadata'" }], staticClass: "float-right", attrs: { href: "#", variant: "info", pill: "" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.showAllMetadata = !_vm.showAllMetadata;
    }, "click") } }, [_vm.showAllMetadata ? _c("font-awesome-icon", { attrs: { icon: "eye-slash" } }) : _c("font-awesome-icon", { attrs: { icon: "eye" } })], 1)];
  }, "fn") }, { key: "cell(thumbnail)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("item-thumbnail", { attrs: { value: _vm.itemThumbnail(data.item), lazy: !0, size: "s" } })];
  }, "fn") }, { key: "cell(name)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.item.isIndexed ? _c("span", [_c("span", [_vm._v(_vm._s(data.item.item.name))]), _vm._v(`
                 `), _c("font-awesome-icon", { directives: [{ name: "tooltip", rawName: "v-tooltip", value: "Item has been indexed", expression: "'Item has been indexed'" }], attrs: { icon: "file-export" } })], 1) : _c("a", { attrs: { href: _vm.itemUrl(data.item.item.id) } }, [_vm._v(_vm._s(data.item.item.name))])];
  }, "fn") }, { key: "cell(size)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(_vm._s(_vm._f("convertBytesToSize")(data.item.item.size)))];
  }, "fn") }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.item.created } })];
  }, "fn") }, { key: "cell(modified)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.item.modified } })];
  }, "fn") }, { key: "cell(history)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("button", { staticClass: "btn btn-link pl-3", attrs: { title: "Show history" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.historyItem = data.item.item.id;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "history" } })], 1), _vm._v(" "), _c("item-history-modal", { attrs: { item: data.item.item, shouldShow: _vm.historyItem == data.item.item.id }, on: { close: /* @__PURE__ */ __name(function($event) {
      _vm.historyItem = null;
    }, "close") } })];
  }, "fn") }, { key: "cell(page)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("a", { attrs: { href: _vm.pageUrl(data.item.page.id) } }, [_vm._v(_vm._s(data.item.page.name))])];
  }, "fn") }, { key: "cell(queue)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("a", { attrs: { href: _vm.queueUrl(data.item.queue.id, data.item.page.id) } }, [_vm._v(_vm._s(data.item.queue.name))])];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._l(_vm.currentResultConstraints.filter((con) => con.id.type === "Metadata"), function(constraint) {
      return _vm.showRelevantMetadata && !_vm.showAllMetadata ? _c("div", [_c("metadata-summary", { attrs: { value: [data.item.item.metadata.find((md) => md.id === constraint.id.id)] } })], 1) : _vm._e();
    }), _vm._v(" "), _vm.showAllMetadata ? _c("div", [_c("metadata-summary", { attrs: { value: data.item.item.metadata } })], 1) : _vm._e()];
  }, "fn") }], null, !1, 3811922158) }), _vm._v(" "), _vm.totalCount && _vm.totalPages ? _c("div", { staticClass: "text-center" }, [_c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } })], 1) : _vm._e()], 1) : _vm.loadingResults ? _vm._e() : _c("div", [_c("b-alert", { attrs: { show: "", variant: "warning" } }, [_vm._v("No search results found.")])], 1)]) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  GlobalSearchComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "ecd56cc2"
);
const search = __component__.exports;
export {
  search as default
};
