var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, bE as AdministrationSchedulingClient, T as Transformer, b as baseUrl, t as toastr, C as Component, N as CheckIcon, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { H as HourPicker } from "./hourPicker-B5b_o7dz.js";
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$1"), _a;
let AdministrationClassificationsComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "saving", !1);
    __publicField(this, "value", null);
  }
  get daysOfTheWeek() {
    return [{ number: 1, name: "Monday" }, { number: 2, name: "Tuesday" }, { number: 3, name: "Wednesday" }, { number: 4, name: "Thursday" }, { number: 5, name: "Friday" }, { number: 6, name: "Saturday" }, { number: 7, name: "Sunday" }];
  }
  mounted() {
    this.load();
  }
  async load() {
    try {
      let config = await new AdministrationSchedulingClient(new Transformer(), baseUrl()).getClassificationScheduleConfig();
      this.model = config;
    } catch (ex) {
      toastr.error(ex, "An error occurred while loading the classification config");
    }
  }
  async save() {
    try {
      this.saving = !0;
      let config = await new AdministrationSchedulingClient(new Transformer(), baseUrl()).setClassificationScheduleConfig(this.model);
      this.model = config, toastr.success("Classification Schedule saved!");
    } catch (ex) {
      toastr.error(ex, "An error occurred while saving the classification config");
    } finally {
      this.saving = !1;
    }
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.value = value;
  }
  get scheduleEnabled() {
    return this.model.scheduleEnabled;
  }
  set scheduleEnabled(value) {
    this.model.scheduleEnabled = value;
  }
  get trainingDays() {
    return this.model.trainingDays;
  }
  set trainingDays(value) {
    this.model.trainingDays = value;
  }
  get trainingTime() {
    return this.model.trainingTime;
  }
  set trainingTime(value) {
    this.model.trainingTime = value;
  }
}, __name(_a, "AdministrationClassificationsComponent"), _a);
AdministrationClassificationsComponent = __decorateClass$1([
  Component({
    components: {
      HourPicker,
      CheckIcon
    }
  })
], AdministrationClassificationsComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_vm.model ? _c("div", { staticClass: "col-md-6" }, [_c("b-card", { staticClass: "noRoundedCorner", attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-form-checkbox", { staticClass: "mt-2 float-right", attrs: { switch: "" }, model: { value: _vm.scheduleEnabled, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.scheduleEnabled = $$v;
    }, "callback"), expression: "scheduleEnabled" } }), _vm._v(" "), _c("h4", { staticClass: "mb-0" }, [_vm._v("Scheduled Training")])];
  }, "fn"), proxy: !0 }], null, !1, 2079246343) }, [_vm._v(" "), _vm.scheduleEnabled ? _c("b-card-body", [_c("b-alert", { attrs: { show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Allowes for scheduled training of classification pages during off-peak usage
                `)], 1), _vm._v(" "), _c("b-form-group", [_c("label", { attrs: { for: "TrainingDaysInput" } }, [_vm._v("Training Days")]), _vm._v(" "), _c("br"), _vm._v(" "), _vm._l(_vm.daysOfTheWeek, function(day) {
    return _c("div", { key: day.name, staticClass: "pretty p-svg p-curve p-smooth" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.trainingDays, expression: "trainingDays" }], staticClass: "form-check-input", class: { disabled: _vm.saving }, attrs: { type: "checkbox", id: "trainingDayCheckbox", disabled: _vm.saving }, domProps: { value: day.number, checked: Array.isArray(_vm.trainingDays) ? _vm._i(_vm.trainingDays, day.number) > -1 : _vm.trainingDays }, on: { change: /* @__PURE__ */ __name(function($event) {
      var $$a = _vm.trainingDays, $$el = $event.target, $$c = !!$$el.checked;
      if (Array.isArray($$a)) {
        var $$v = day.number, $$i = _vm._i($$a, $$v);
        $$el.checked ? $$i < 0 && (_vm.trainingDays = $$a.concat([$$v])) : $$i > -1 && (_vm.trainingDays = $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
      } else
        _vm.trainingDays = $$c;
    }, "change") } }), _vm._v(" "), _c("div", { staticClass: "state p-primary" }, [_c("span", { staticClass: "svg svg-icon" }, [_c("CheckIcon")], 1), _vm._v(" "), _c("label", [_vm._v(_vm._s(day.name))])])]);
  }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "trainingDaysHelp" } }, [_vm._v("The days of the week that training will occur.")])], 2), _vm._v(" "), _c("b-form-group", [_c("label", { attrs: { for: "trainingTimeInput" } }, [_vm._v("Training time")]), _vm._v(" "), _c("hour-picker", { class: { disabled: _vm.trainingDays.length === 0, disabled: _vm.saving }, attrs: { disabled: _vm.trainingDays.length === 0 || _vm.saving, id: "trainingTimeInput", "aria-describedby": "trainingTimeHelp", name: "trainingTime" }, model: { value: _vm.trainingTime, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.trainingTime = $$v;
  }, "callback"), expression: "trainingTime" } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "trainingTimeHelp" } }, [_vm._v("Time of the day to train classification page models.")])], 1)], 1) : _vm._e(), _vm._v(" "), _c("b-card-footer", [_c("button", { staticClass: "btn btn-success float-right", class: { disabled: _vm.saving }, attrs: { disabled: _vm.saving }, on: { click: _vm.save } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.saving, expression: "!saving" }] }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.saving, expression: "saving" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Saving")], 1)])])], 1)], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  AdministrationClassificationsComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const ClassificationScheduling = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a2;
let AdministrationSchedulingManagementComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "tab", "classifications");
    __publicField(this, "tabs", [
      {
        id: "classifications",
        name: "Classifications",
        icon: "microchip-ai",
        description: "",
        show: !0,
        component: ClassificationScheduling
      }
    ]);
  }
  get activeTab() {
    return this.tab ? this.tab : (this.tabs.find((t) => t.show) || { id: null }).id;
  }
  selectTab(tabId) {
    this.tabs.find((t) => t.id === tabId && t.show) && (this.tab = tabId);
  }
}, __name(_a2, "AdministrationSchedulingManagementComponent"), _a2);
AdministrationSchedulingManagementComponent = __decorateClass([
  Component({
    components: {
      ClassificationScheduling
    }
  })
], AdministrationSchedulingManagementComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "calendar" } }), _vm._v(" Scheduling")], 1)]), _vm._v(" "), _c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs", attrs: { id: "myTab", role: "tablist" } }, _vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item" }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab === tab.id }, attrs: { id: tab.id + "tab", "data-toggle": "tab", role: "tab", "aria-selected": "true" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(" " + _vm._s(tab.name) + `
                    `)], 1)]);
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_c("div", { staticClass: "container-fluid" }, [_vm.activeTab === "classifications" ? _c("classification-scheduling", { key: "classifications" }) : _vm._e()], 1)])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationSchedulingManagementComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "2603371e"
);
const schedulingManagement = __component__.exports;
export {
  schedulingManagement as default
};
