var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, e as bus, j as getQueueName, d as IndexingClient, T as Transformer, b as baseUrl, P as Prop, W as Watch, C as Component, E as ErrorPanel, n as normalizeComponent } from "./main-DAVWuHbi.js";
import ErrorModal from "./errorModal-BqEHnF6f.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let RouteModalComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "canRouteToPage");
    __publicField(this, "mandatoryComments");
    __publicField(this, "shouldShow");
    __publicField(this, "propItems");
    __publicField(this, "defaultPage");
    __publicField(this, "actionName");
    __publicField(this, "pageFilterText", null);
    __publicField(this, "queueFilterText", null);
    __publicField(this, "comments", null);
    __publicField(this, "selectedPage", null);
    __publicField(this, "selectedQueue", null);
    __publicField(this, "submitting", !1);
    __publicField(this, "loadingPages", !1);
    __publicField(this, "loadingPagesError", null);
    __publicField(this, "availablePages", null);
    __publicField(this, "loadingQueues", !1);
    __publicField(this, "loadingQueuesError", null);
    __publicField(this, "availableQueues", null);
  }
  mounted() {
    bus.on("indexing-route", this.showModal), $(this.$el).on("hidden.bs.modal", () => this.$emit("hidden")), $(this.$el).on("shown.bs.modal", () => {
      this.$emit("shown"), $("#routeCommentsTextArea").focus();
    });
  }
  beforeDestroy() {
    bus.off("indexing-route", this.showModal);
  }
  watchShouldShow(newVal, oldVal) {
    newVal !== oldVal && (newVal ? this.showModal() : this.closeModal());
  }
  async showModal() {
    await this.$nextTick(), $(this.$el).modal({
      backdrop: "static",
      show: !0,
      keyboard: !1
    }), this.canRouteToPage && (this.selectedPage = this.defaultPage || this.$store.state.page.pageId), this.reloadTargets();
  }
  async closeModal() {
    await this.$nextTick(), $(this.$el).modal("hide");
  }
  saveModal() {
    this.submitting || (this.submitting = !0, bus.send("indexing-routed", this.payload), this.$emit("selected", this.payload));
  }
  get payload() {
    return {
      queueId: this.selectedQueue,
      pageId: this.selectedPage,
      comments: this.comments
    };
  }
  queueName(queue) {
    return getQueueName(queue);
  }
  get filteredAvailablePages() {
    return this.pageFilterText ? this.availablePages.filter((a) => a.name.toLocaleLowerCase().includes(this.pageFilterText.toLocaleLowerCase()) || a.id === this.selectedPage) : this.availablePages;
  }
  get filteredAvailableQueues() {
    return this.queueFilterText ? this.availableQueuesMapped.filter((a) => a.name.toLocaleLowerCase().includes(this.queueFilterText.toLocaleLowerCase()) || a.id === this.selectedQueue) : this.availableQueuesMapped;
  }
  get availableQueuesMapped() {
    if (this.availableQueues) {
      var queues = this.availableQueues.map((a) => ({ ...a, name: getQueueName(a) }));
      return queues.sort((a, b) => a.name > b.name ? 1 : b.name > a.name ? -1 : 0), queues;
    }
    return [];
  }
  get canComment() {
    return !0;
  }
  get itemId() {
    return this.propItems ? this.propItems[0].id : this.$store.state.page.ria && this.$store.state.page.ria.item ? this.$store.state.page.ria.item.id : null;
  }
  selectPage(pageId) {
    this.selectedPage != pageId && (this.selectedPage = pageId, this.selectedQueue = null, this.reloadQueues());
  }
  selectQueueAndSubmit(queueId) {
    this.submitting || (this.selectedQueue = queueId, this.saveModal());
  }
  selectQueue(queueId) {
    this.submitting || (this.selectedQueue = queueId);
  }
  async reloadTargets() {
    this.canRouteToPage ? await this.reloadPages() : await this.reloadQueues();
  }
  getQueueIcon(queue) {
    if (queue && queue.type)
      switch (queue.type.type) {
        case "personal":
          return "user";
        case "shared":
          return "users";
      }
    return "question";
  }
  async reloadPages() {
    this.loadingPages = !0, this.loadingPagesError = null;
    try {
      this.availablePages = await new IndexingClient(new Transformer(), baseUrl()).getRouteTargetPages(this.itemId);
    } catch (e) {
      this.loadingPagesError = e;
    } finally {
      this.loadingPages = !1;
    }
    await this.reloadQueues();
  }
  async reloadQueues() {
    if (this.availableQueues = null, !(this.canRouteToPage && !this.selectedPage)) {
      this.loadingQueues = !0, this.loadingQueuesError = null;
      try {
        this.availableQueues = await new IndexingClient(new Transformer(), baseUrl()).getRouteTargetQueues(this.itemId, this.selectedPage || void 0);
      } catch (e) {
        this.loadingQueuesError = e;
      } finally {
        this.availableQueues && this.availableQueues.length === 1 && this.selectQueue(this.availableQueues[0].id), this.loadingQueues = !1;
      }
    }
  }
  get canRoute() {
    return (!this.routeCommentsMandatory || this.hasComments) && this.selectedQueue;
  }
  get modalTitle() {
    return this.propItems && this.propItems.length > 1 ? this.actionName + " Items (" + this.propItems.length + ")" : this.actionName + " Item";
  }
  get hasComments() {
    return this.comments && this.comments.length;
  }
}, __name(_a, "RouteModalComponent"), _a);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], RouteModalComponent.prototype, "canRouteToPage", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], RouteModalComponent.prototype, "mandatoryComments", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], RouteModalComponent.prototype, "shouldShow", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], RouteModalComponent.prototype, "propItems", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], RouteModalComponent.prototype, "defaultPage", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], RouteModalComponent.prototype, "actionName", 2);
__decorateClass([
  Watch("shouldShow", { immediate: !0 })
], RouteModalComponent.prototype, "watchShouldShow", 1);
RouteModalComponent = __decorateClass([
  Component({
    components: { ErrorPanel, ErrorModal }
  })
], RouteModalComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal fade", attrs: { tabindex: "-1", role: "dialog" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h4", { staticClass: "modal-title" }, [_vm._v(_vm._s(_vm.modalTitle))]), _vm._v(" "), _vm._m(0)]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("div", { staticClass: "container-fluid" }, [_c("b-alert", { attrs: { show: _vm.mandatoryComments, variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" You must enter comments to " + _vm._s(_vm.actionName) + " this file.")], 1), _vm._v(" "), _vm.canComment ? _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Comments")]), _vm._v(" "), _c("textarea", { directives: [{ name: "model", rawName: "v-model", value: _vm.comments, expression: "comments" }], staticClass: "form-control", attrs: { id: "routeCommentsTextArea", placeholder: "Enter any comments here..." }, domProps: { value: _vm.comments }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.comments = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Place any comments for the document here")])]) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "selection form-group row" }, [_vm.canRouteToPage ? _c("div", { staticClass: "col-md-6" }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Page")]), _vm._v(" "), _vm.availablePages ? _c("div", [_c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("div", { staticClass: "input-group-prepend" }, [_c("span", { staticClass: "input-group-text" }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.pageFilterText, expression: "pageFilterText" }], staticClass: "form-control", attrs: { type: "text", placeholder: "filter...." }, domProps: { value: _vm.pageFilterText }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.pageFilterText = $event.target.value);
  }, "input") } })])]), _vm._v(" "), _c("table", { staticClass: "table table-sm" }, [_c("tbody", _vm._l(_vm.filteredAvailablePages, function(page) {
    return _c("tr", { key: page.id, staticClass: "selectable-row", class: { "boostrap-3-info-colour": _vm.selectedPage === page.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.selectPage(page.id);
    }, "click") } }, [_c("td", [_vm._v(_vm._s(page.name))])]);
  }), 0)])]) : _vm._e(), _vm._v(" "), _vm.loadingPagesError ? _c("error-panel", { attrs: { error: _vm.loadingPagesError } }, [_vm._v("Failed to load pages for routing")]) : _vm._e()], 1) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "col-md-6" }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Queue")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("div", { staticClass: "input-group-prepend" }, [_c("span", { staticClass: "input-group-text" }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.queueFilterText, expression: "queueFilterText" }], staticClass: "form-control", attrs: { type: "text", placeholder: "filter...." }, domProps: { value: _vm.queueFilterText }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.queueFilterText = $event.target.value);
  }, "input") } })])]), _vm._v(" "), _vm.canRouteToPage && !_vm.selectedPage ? _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
                                Please select a page
                            `)]) : _vm.loadingQueues ? _c("div", { staticStyle: { "text-align": "center" } }, [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _c("br"), _vm._v(`
                                Loading Queues
                            `)], 1) : _c("div", [_c("table", { staticClass: "table table-sm" }, [_c("tbody", _vm._l(_vm.filteredAvailableQueues, function(queue) {
    return _c("tr", { key: queue.id, staticClass: "selectable-row noTextSelect", class: { "boostrap-3-info-colour": _vm.selectedQueue === queue.id }, on: { dblclick: /* @__PURE__ */ __name(function($event) {
      return _vm.selectQueueAndSubmit(queue.id);
    }, "dblclick"), click: /* @__PURE__ */ __name(function($event) {
      return _vm.selectQueue(queue.id);
    }, "click") } }, [_c("td", [_c("font-awesome-icon", { attrs: { icon: _vm.getQueueIcon(queue) } })], 1), _vm._v(" "), _c("td", [_vm._v(`
                                            ` + _vm._s(queue.name) + `
                                             `), _vm.submitting && _vm.selectedQueue === queue.id ? _c("span", { staticClass: "float-right mr-1" }, [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } })], 1) : _vm._e()])]);
  }), 0)])])])])], 1)]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: _vm.closeModal } }, [_vm._v("Close")]), _vm._v(" "), _c("b-button", { attrs: { variant: "primary", disabled: _vm.submitting || !_vm.canRoute || _vm.mandatoryComments && !_vm.comments }, on: { click: _vm.saveModal } }, [_c("font-awesome-icon", { attrs: { icon: _vm.submitting ? "sync" : "share", spin: _vm.submitting } }), _vm._v(`
                ` + _vm._s(_vm.actionName) + `
              `)], 1)], 1)])])]);
}, "render"), _sfc_staticRenderFns = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}], __component__ = /* @__PURE__ */ normalizeComponent(
  RouteModalComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "b0d59be8"
);
const routeModal = __component__.exports;
export {
  routeModal as default
};
