var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, P as Prop, C as Component, n as normalizeComponent, t as toastr, L as LoadingBarComponent } from "./main-DAVWuHbi.js";
import { P as PermissionEditor } from "./permissionEditor-CEAGzDpF.js";
import { P as PageColumnCount, H as HomePageConfiguration } from "./homePageConfiguration-DYnOH1wA.js";
import { G as GeneralPageSettings } from "./generalPageSettings-D4XSKedw.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
import { D as DefaultableTextbox } from "./defaultableTextbox-DRxGWG_3.js";
import { I as IconSelect } from "./iconSelect-BeUqYgP_.js";
import { C as ColourSelect } from "./colourSelect-CPGyerOT.js";
import PageFields from "./fields-CDjhj8cM.js";
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$3"), _a;
let BarcodesGeneral$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get requiresAuthentication() {
    return this.model.permissions.requiresAuthentication;
  }
  set requiresAuthentication(value) {
    this.model = { ...this.model, permissions: { ...this.model.permissions, requiresAuthentication: value } };
  }
  get users() {
    return this.model.permissions.users;
  }
  set users(users) {
    this.model = { ...this.model, ...this.model, permissions: { ...this.model.permissions, users } };
  }
  get owners() {
    return this.model.permissions.owners;
  }
  set owners(owners) {
    this.model = { ...this.model, ...this.model, permissions: { ...this.model.permissions, owners } };
  }
}, __name(_a, "BarcodesGeneral"), _a);
__decorateClass$3([
  Prop({
    required: !0
  })
], BarcodesGeneral$1.prototype, "value", 2);
BarcodesGeneral$1 = __decorateClass$3([
  Component({
    components: {
      GeneralPageSettings,
      PageColumnCount,
      PermissionsEditor: PermissionEditor
    }
  })
], BarcodesGeneral$1);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _a5;
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("general-page-settings", { model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } })], 1), _vm._v(" "), _c("div", { staticClass: "col" }, [_c("h3", [_vm._v("Permissions")]), _vm._v(" "), (_a5 = _vm.users) != null && _a5.length ? _vm._e() : _c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" "), _vm.requiresAuthentication ? _c("span", [_vm._v(`
          If no permissions are set for Users, any authenticated user will be able to access this page.
         `)]) : _c("span", [_vm._v(`
           This page is public to any unauthenticated user. If no permissions are set for Managers, any Manager user will be able to manage this page.
         `)])], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "requiresAuthenticationSwitch", switch: "" }, model: { value: _vm.requiresAuthentication, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.requiresAuthentication = $$v;
  }, "callback"), expression: "requiresAuthentication" } }, [_c("b", [_vm._v("Requires Authentication")])])], 1)]), _vm._v(" "), _vm.requiresAuthentication ? [_c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header" }, [_c("b", [_vm._v("Users")]), _vm._v(" "), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "Users will be able to access this page and generate barcodes" } }, [_c("font-awesome-icon", { staticClass: "text-info", attrs: { icon: "question-circle" } })], 1)]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("permissions-editor", { attrs: { "element-id": "bcgUsers" }, model: { value: _vm.users, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.users = $$v;
  }, "callback"), expression: "users" } })], 1)])] : [_c("div", { staticClass: "alert alert-info" }, [_c("a", { attrs: { role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.requiresAuthentication = !0;
  }, "click") } }, [_vm._v("Enable")]), _vm._v(` authentication to control user
                permissions
            `)])], _vm._v(" "), _c("div", { staticClass: "card mt-2" }, [_c("div", { staticClass: "card-header" }, [_c("b", [_vm._v("Owners")]), _vm._v(" "), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "Owners have the highest level of permissions and can edit the page." } }, [_c("font-awesome-icon", { staticClass: "text-info", attrs: { icon: "question-circle" } })], 1)]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("permissions-editor", { attrs: { "element-id": "bcgOwners" }, model: { value: _vm.owners, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.owners = $$v;
  }, "callback"), expression: "owners" } })], 1)])], 2)]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  BarcodesGeneral$1,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  "90a0a939"
);
const BarcodesGeneral = __component__$3.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$2"), _a2;
let BarcodesSettings$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get settings() {
    return this.model.settings;
  }
  set settings(value) {
    this.model = { ...this.model, settings: value };
  }
  get barcodeColumns() {
    return this.settings.barcodeColumns;
  }
  set barcodeColumns(barcodeColumns) {
    this.settings = Object.assign({}, this.settings, { barcodeColumns });
  }
  get barcodeDpi() {
    return this.settings.barcodeDpi;
  }
  set barcodeDpi(barcodeDpi) {
    this.settings = Object.assign({}, this.settings, { barcodeDpi });
  }
  get defaultAuditLogPath() {
    return "~/App_Data/Logging/BCG-" + this.model.name + ".txt";
  }
  get auditLogFilePath() {
    return this.settings ? this.settings.auditLogFilePath : "";
  }
  set auditLogFilePath(auditLogFilePath) {
    this.settings = Object.assign({}, this.settings, { auditLogFilePath });
  }
  get barcodeType() {
    return this.settings.barcodeType;
  }
  set barcodeType(barcodeType) {
    this.settings = Object.assign({}, this.settings, { barcodeType });
  }
  get generatedByField() {
    return this.settings.generatedByField;
  }
  set generatedByField(generatedByField) {
    this.settings = Object.assign({}, this.settings, { generatedByField });
  }
  get outputFormat() {
    return this.settings.outputFormat;
  }
  set outputFormat(outputFormat) {
    this.settings = Object.assign({}, this.settings, { outputFormat });
  }
  get automaticallyPrint() {
    return this.settings.automaticallyPrint;
  }
  set automaticallyPrint(automaticallyPrint) {
    this.settings = Object.assign({}, this.settings, { automaticallyPrint });
  }
  get generateButtonText() {
    return this.settings.generateButtonText;
  }
  set generateButtonText(buttonText) {
    this.settings = Object.assign({}, this.settings, { generateButtonText: buttonText });
  }
  get barcodeDataLabel() {
    return this.settings.barcodeDataLabel;
  }
  set barcodeDataLabel(textValue) {
    this.settings = Object.assign({}, this.settings, { barcodeDataLabel: textValue });
  }
  get footerText() {
    return this.settings.footerText;
  }
  set footerText(textValue) {
    this.settings = Object.assign({}, this.settings, { footerText: textValue });
  }
  get coversheetTitle() {
    return this.model.coversheetTitle;
  }
  set coversheetTitle(title) {
    this.model = Object.assign({}, this.model, { coversheetTitle: title });
  }
  get dataFormat() {
    return this.settings.dataFormat;
  }
  set dataFormat(dataFormat) {
    this.settings = Object.assign({}, this.settings, { dataFormat });
  }
  get generatedByFieldOptions() {
    return [
      {
        id: "none",
        name: "None"
      },
      {
        id: "emailAddress",
        name: "Email Address"
      },
      {
        id: "userName",
        name: "User Name"
      }
    ];
  }
  get outputFormatOptions() {
    return [
      {
        id: "pdf",
        name: "PDF"
      },
      {
        id: "webPage",
        name: "WebPage"
      }
    ];
  }
  get dataFormatOptions() {
    return [
      {
        id: "value",
        name: "Values"
      },
      {
        id: "keyValuePair",
        name: "Key Value Pairs"
      }
    ];
  }
  get barcodeFormatOptions() {
    return [
      {
        id: "Code39",
        name: "Code39"
      },
      {
        id: "Code128",
        name: "Code128"
      },
      {
        id: "DataMatrix",
        name: "DataMatrix"
      },
      {
        id: "Pdf417",
        name: "Pdf417"
      },
      {
        id: "QR",
        name: "QR"
      }
    ];
  }
}, __name(_a2, "BarcodesSettings"), _a2);
__decorateClass$2([
  Prop({
    required: !0
  })
], BarcodesSettings$1.prototype, "value", 2);
BarcodesSettings$1 = __decorateClass$2([
  Component({
    components: { ReactiveDropdown, DefaultableTextbox }
  })
], BarcodesSettings$1);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-6" }, [_c("h3", [_vm._v("Barcode Settings")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Barcode type")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("reactive-dropdown", { attrs: { options: _vm.barcodeFormatOptions }, model: { value: _vm.barcodeType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.barcodeType = $$v;
  }, "callback"), expression: "barcodeType" } })], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Barcode type to use on the coversheet.")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.first("barcodeDpi") } }, [_c("label", [_vm._v("DPI")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.barcodeDpi, expression: "barcodeDpi" }, { name: "validate", rawName: "v-validate", value: "required|numeric|between:64,1000", expression: "'required|numeric|between:64,1000'" }], staticClass: "form-control", attrs: { type: "number", min: "64", max: "1000", step: "1", name: "barcodeDpi" }, domProps: { value: _vm.barcodeDpi }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.barcodeDpi = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("DPI to use for generated barcode. Default is 96.")]), _vm._v(" "), _vm.errors.first("barcodeDpi") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("barcodeDpi")))]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.first("barcodeColumns") } }, [_c("label", [_vm._v("Columns")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.barcodeColumns, expression: "barcodeColumns" }, { name: "validate", rawName: "v-validate", value: "required|numeric|between:4,20", expression: "'required|numeric|between:4,20'" }], staticClass: "form-control", attrs: { type: "number", min: "4", max: "20", step: "1", name: "barcodeColumns" }, domProps: { value: _vm.barcodeColumns }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.barcodeColumns = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Number of columns to use in supported barcode types.")]), _vm._v(" "), _vm.errors.first("barcodeColumns") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("barcodeColumns")))]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Generated by field")]), _vm._v(" "), _c("div", { staticClass: "form-group mb-0" }, [_c("reactive-dropdown", { attrs: { options: _vm.generatedByFieldOptions }, model: { value: _vm.generatedByField, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.generatedByField = $$v;
  }, "callback"), expression: "generatedByField" } })], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Add current user information to barcode.")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Data Format")]), _vm._v(" "), _c("div", { staticClass: "form-group mb-0" }, [_c("reactive-dropdown", { attrs: { options: _vm.dataFormatOptions }, model: { value: _vm.dataFormat, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.dataFormat = $$v;
  }, "callback"), expression: "dataFormat" } })], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Determines how the barcode data is generated")])]), _vm._v(" "), _vm.dataFormat == "value" ? _c("b-alert", { attrs: { show: "" } }, [_c("b", [_vm._v("Example output: ")]), _vm._v(" "), _c("br"), _vm._v(`
        value 1%value 2%value 3
      `)]) : _vm._e(), _vm._v(" "), _vm.dataFormat == "keyValuePair" ? _c("b-alert", { attrs: { show: "" } }, [_c("b", [_vm._v("Example output")]), _vm._v(" "), _c("br"), _vm._v(`
        field1=value 1%field2=value 2%field3=value 3
      `)]) : _vm._e()], 1), _vm._v(" "), _c("div", { staticClass: "col-md-6" }, [_c("h3", [_vm._v("Output Display")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Output Format")]), _vm._v(" "), _c("div", { staticClass: "form-group mb-0" }, [_c("reactive-dropdown", { attrs: { options: _vm.outputFormatOptions, id: "outputFormatDropdown" }, model: { value: _vm.outputFormat, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.outputFormat = $$v;
  }, "callback"), expression: "outputFormat" } })], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("What type of coversheet do you want to generate?")])]), _vm._v(" "), _vm.outputFormat == "webPage" ? _c("div", { staticClass: "form-group" }, [_c("b-form-checkbox", { attrs: { switch: "" }, model: { value: _vm.automaticallyPrint, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.automaticallyPrint = $$v;
  }, "callback"), expression: "automaticallyPrint" } }, [_c("b", [_vm._v("Automatically Print")])]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("If enabled, the web page output will automatically attempt to print.")])], 1) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Title")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.coversheetTitle, expression: "coversheetTitle" }], staticClass: "form-control", attrs: { type: "text" }, domProps: { value: _vm.coversheetTitle }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.coversheetTitle = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Title of the page that will appear on the coversheet")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Barcode Data Label")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.barcodeDataLabel, expression: "barcodeDataLabel" }], staticClass: "form-control", attrs: { type: "text", placeholder: "Barcode Data" }, domProps: { value: _vm.barcodeDataLabel }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.barcodeDataLabel = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("The text to display above the table of barcode data values. If left blank, the default will be used.")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Footer Text")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.footerText, expression: "footerText" }], staticClass: "form-control", attrs: { type: "text", placeholder: "Place this coversheet in front of your original document and then scan to EzeScan Server." }, domProps: { value: _vm.footerText }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.footerText = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("The text to display at the bottom of the coversheet. If left blank, the default will be used.")])]), _vm._v(" "), _c("h3", [_vm._v("Generate Page Display")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Generate Button Text")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.generateButtonText, expression: "generateButtonText" }], staticClass: "form-control", attrs: { type: "text", placeholder: "Generate Barcode Coversheet" }, domProps: { value: _vm.generateButtonText }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.generateButtonText = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("The frontend button text for submitting the fields. If left blank, the default will be used.")])])])]);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  BarcodesSettings$1,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "8f4d35b7"
);
const BarcodesSettings = __component__$2.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a3;
let DisplaySettings$1 = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "selectedTab", "homePage");
    __publicField(this, "tabs", [
      { id: "homePage", name: "Home Page", icon: "display-code", indent: !1 }
    ]);
  }
  setSelected(tab) {
    this.selectedTab = tab;
  }
  isSelected(tab) {
    return this.selectedTab === tab;
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
}, __name(_a3, "DisplaySettings"), _a3);
__decorateClass$1([
  Prop({ required: !0 })
], DisplaySettings$1.prototype, "value", 2);
DisplaySettings$1 = __decorateClass$1([
  Component({
    components: { HomePageConfiguration, IconSelect, ColourSelect }
  })
], DisplaySettings$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("h3", [_c("font-awesome-icon", { attrs: { icon: "desktop" } }), _vm._v(`
        Display Settings
      `)], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", { staticClass: "mb-3", attrs: { xl: "3", lg: "4", md: "5", sm: "12" } }, [_c("b-list-group", { ref: "display" }, _vm._l(_vm.tabs, function(tab) {
    return _c("b-list-group-item", { ref: "action", refInFor: !0, staticClass: "d-flex justify-content-between align-items-center", class: tab.indent ? "pl-5" : "", attrs: { button: "", active: _vm.isSelected(tab.id) }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setSelected(tab.id);
    }, "click") } }, [_c("span", [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: tab.icon } }), _vm._v(_vm._s(tab.name) + `
          `)], 1)]);
  }), 1)], 1), _vm._v(" "), _c("b-col", { attrs: { xl: "5", lg: "6", md: "7", sm: "12" } }, [_c("home-page-configuration", { attrs: { "hide-heading": !0 }, model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } })], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  DisplaySettings$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "69cdada3"
);
const DisplaySettings = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a4;
let BarcodeConfigurationComponent = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "pageId");
    __publicField(this, "currentTab", null);
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "availableFields", fields);
  }
  created() {
    let load;
    this.pageId ? load = this.loadPage(this.pageId) : load = this.createPage(), load.then(() => {
      this.currentTab = "general";
    });
  }
  get model() {
    return this.$store.getters["administration/pages/barcodes/current"]();
  }
  set model(page) {
    this.$store.dispatch("administration/pages/barcodes/update", page);
  }
  get saving() {
    return this.$store.getters["administration/app/getters/saving"];
  }
  loadPage(pageId) {
    return this.loading = !0, this.loadingError = null, this.$store.dispatch("administration/pages/barcodes/load", pageId).catch((e) => this.loadingError = e).finally(() => this.loading = !1);
  }
  createPage() {
    return this.$store.dispatch("administration/pages/barcodes/create").catch((e) => {
      this.loadingError = e;
    }).finally(() => this.loading = !1);
  }
  get tabs() {
    return tabs;
  }
  get canSave() {
    return this.$store.getters["administration/pages/barcodes/canSave"];
  }
  activeTab(id) {
    return id === this.currentTab;
  }
  selectTab(tab) {
    this.currentTab = tab;
  }
  save() {
    this.validate().then((valid) => {
      if (!valid) {
        toastr.error("Errors in configuration. Check tabs marked");
        return;
      }
      this.$store.commit("administration/app/mutations/saving", !0), this.$store.dispatch("administration/pages/barcodes/save").then(() => {
        toastr.success("Page saved");
      }).catch((e) => {
        toastr.error(e);
      }).finally(() => {
        this.$store.commit("administration/app/mutations/saving", !1);
      });
    });
  }
  hasError(id) {
    let refs = this.$refs[id];
    if (!refs)
      return !1;
    let component = refs.find(() => !0);
    return component && component.$validator ? component.$validator.errors.any() : !1;
  }
  get hasErrors() {
    return !!this.$children.map((c) => c.$validator).find((v) => v.errors.any());
  }
  validate() {
    let validators = this.$children.map((c) => c.$validator);
    return Promise.all(validators.map((v) => v.validateAll())).then((r) => r.every((v) => v));
  }
}, __name(_a4, "BarcodeConfigurationComponent"), _a4);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], BarcodeConfigurationComponent.prototype, "pageId", 2);
BarcodeConfigurationComponent = __decorateClass([
  Component({
    components: { LoadingBar: LoadingBarComponent }
  })
], BarcodeConfigurationComponent);
const fields = [
  "custom",
  "idCounter",
  "datetime",
  "integration-find",
  "integration-lookup",
  "lookup",
  "time",
  "numeric"
], tabs = [
  {
    id: "general",
    name: "General",
    icon: "edit",
    description: "General page settings",
    component: BarcodesGeneral,
    show: !0
  },
  {
    id: "fields",
    name: "Fields",
    icon: "keyboard",
    description: "Fields configured for each item",
    component: PageFields,
    show: !0
  },
  {
    id: "display",
    name: "Display",
    icon: "display",
    description: "Display settings",
    component: DisplaySettings,
    show: !0
  },
  {
    id: "barcode",
    name: "Barcode Settings",
    icon: "barcode",
    description: "Barcode settings",
    component: BarcodesSettings,
    show: !0
  }
];
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "container-fluid" }, [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_vm._v("Edit Barcode Coversheet Page: "), _vm.model ? _c("small", [_vm._v(_vm._s(_vm.model.name))]) : _vm._e()])]), _vm._v(" "), _c("div", { staticClass: "row" }, [_vm.loading ? _c("div", { staticClass: "col" }, [_c("loading-bar")], 1) : _vm.loadingError ? _c("div", [_c("div", { staticClass: "alert alert-danger" }, [_c("strong", [_vm._v("Oh no!")]), _vm._v(" Failed to load the page. "), _c("a", { attrs: { role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.loadPage(_vm.pageId);
  }, "click") } }, [_vm._v("Try again?")])])]) : _c("div", { staticClass: "col mb-4" }, [_c("ul", { staticClass: "nav nav-tabs unselectable" }, [_vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item", attrs: { role: "presentation" } }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab(tab.id), disabled: !tab.show, "has-error": _vm.hasError(tab.id) }, attrs: { role: "tab", title: tab.description, id: tab.id, "data-toggle": "tab" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(`
                        ` + _vm._s(tab.name) + `
                        `), _vm.hasError(tab.id) ? _c("span", [_vm._v(`
                             
                            `), _c("font-awesome-icon", { staticClass: "text-danger", attrs: { icon: "exclamation" } })], 1) : _vm._e()], 1)]);
  }), _vm._v(" "), _c("li", { staticClass: "ml-auto nav-item" }, [_c("button", { staticClass: "btn btn-success", attrs: { disabled: !_vm.canSave || _vm.saving || _vm.hasErrors, id: "savePage" }, on: { click: _vm.save } }, [_vm.saving ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(` Saving...
                        `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save
                        `)], 1)])])], 2)])]), _vm._v(" "), _vm.model ? _c("div", { staticClass: "tab-content" }, _vm._l(_vm.tabs, function(tab) {
    return tab.show ? _c(tab.component, { directives: [{ name: "show", rawName: "v-show", value: tab.id === _vm.currentTab, expression: "tab.id === currentTab" }], key: tab.id, ref: tab.id, refInFor: !0, tag: "component", attrs: { "page-id": _vm.pageId, "available-fields": _vm.availableFields }, on: { trySavePage: _vm.save }, model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.model = $$v;
    }, "callback"), expression: "model" } }) : _vm._e();
  }), 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  BarcodeConfigurationComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "99ac164e"
);
const root = __component__.exports;
export {
  root as default
};
