var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, P as Prop, C as Component, n as normalizeComponent, z as systemInAzureMode, t as toastr, f as draggable, L as LoadingBarComponent } from "./main-DAVWuHbi.js";
import { g as getReplacedName } from "./regexHelpers-D8RHIfkG.js";
import { P as PermissionEditor } from "./permissionEditor-CEAGzDpF.js";
import { G as GeneralPageSettings } from "./generalPageSettings-D4XSKedw.js";
import { I as IndexingPageReactiveDropdown } from "./indexingPageReactiveDropdown-BBO81Kq4.js";
import { E as ExternalConnectionDropDown } from "./externalConnectionDropDown-Du88bMty.js";
import { C as ContainerSelectionComponent } from "./containerSelector-DJmnNR6h.js";
import { I as IconSelect } from "./iconSelect-BeUqYgP_.js";
import { C as ColourSelect } from "./colourSelect-CPGyerOT.js";
import { H as HomePageConfiguration } from "./homePageConfiguration-DYnOH1wA.js";
var __defProp$8 = Object.defineProperty, __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor, __decorateClass$8 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$8(target, key, result), result;
}, "__decorateClass$8"), _a;
let MonitorGeneral = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get users() {
    return this.model.permissions.users;
  }
  set users(users) {
    this.model = { ...this.model, ...this.model, permissions: { ...this.model.permissions, users } };
  }
  get managers() {
    return this.model.permissions.managers;
  }
  set managers(managers) {
    this.model = {
      ...this.model,
      ...this.model,
      permissions: { ...this.model.permissions, managers }
    };
  }
  get owners() {
    return this.model.permissions.owners;
  }
  set owners(owners) {
    this.model = { ...this.model, ...this.model, permissions: { ...this.model.permissions, owners } };
  }
}, __name(_a, "MonitorGeneral"), _a);
__decorateClass$8([
  Prop({
    required: !0
  })
], MonitorGeneral.prototype, "value", 2);
MonitorGeneral = __decorateClass$8([
  Component({
    components: { GeneralPageSettings, PermissionsEditor: PermissionEditor }
  })
], MonitorGeneral);
var _sfc_render$8 = /* @__PURE__ */ __name(function() {
  var _a10;
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-6" }, [_c("general-page-settings", { model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } })], 1), _vm._v(" "), _c("div", { staticClass: "col-md-6" }, [_c("h3", [_vm._v("Permissions")]), _vm._v(" "), (_a10 = _vm.users) != null && _a10.length ? _vm._e() : _c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
          If no permissions are set for Users, any authenticated user will be able to access this page.
        `)], 1), _vm._v(" "), _c("div", { staticClass: "card mb-2" }, [_c("div", { staticClass: "card-header" }, [_c("b", [_vm._v("Users")]), _vm._v(" "), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "Users can access the page and view configured observees" } }, [_c("font-awesome-icon", { staticClass: "text-info", attrs: { icon: "question-circle" } })], 1)]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("permissions-editor", { attrs: { "element-id": "mtfUsers" }, model: { value: _vm.users, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.users = $$v;
  }, "callback"), expression: "users" } })], 1)]), _vm._v(" "), _c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header" }, [_c("b", [_vm._v("Managers")]), _vm._v(" "), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "Managers are able to delete items in observees (If configured)" } }, [_c("font-awesome-icon", { staticClass: "text-info", attrs: { icon: "question-circle" } })], 1)]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("permissions-editor", { attrs: { "element-id": "mtfManagers" }, model: { value: _vm.managers, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.managers = $$v;
  }, "callback"), expression: "managers" } })], 1)]), _vm._v(" "), _c("div", { staticClass: "card mt-2" }, [_c("div", { staticClass: "card-header" }, [_c("b", [_vm._v("Owners")]), _vm._v(" "), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "Owners have the highest level of permissions and can edit the page." } }, [_c("font-awesome-icon", { staticClass: "text-info", attrs: { icon: "question-circle" } })], 1)]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("permissions-editor", { attrs: { "element-id": "mtfOwners" }, model: { value: _vm.owners, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.owners = $$v;
  }, "callback"), expression: "owners" } })], 1)])], 1)]);
}, "render"), _sfc_staticRenderFns$8 = [], __component__$8 = /* @__PURE__ */ normalizeComponent(
  MonitorGeneral,
  _sfc_render$8,
  _sfc_staticRenderFns$8,
  !1,
  null,
  "2f699610"
);
const MonitorGeneralConfigurationComponent = __component__$8.exports;
var __defProp$7 = Object.defineProperty, __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor, __decorateClass$7 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$7(target, key, result), result;
}, "__decorateClass$7"), _a2;
let MonitorSettings = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get refresh() {
    return this.model.autoRefreshInterval;
  }
  set refresh(refresh) {
    this.model = { ...this.model, autoRefreshInterval: refresh };
  }
}, __name(_a2, "MonitorSettings"), _a2);
__decorateClass$7([
  Prop({
    required: !0
  })
], MonitorSettings.prototype, "value", 2);
MonitorSettings = __decorateClass$7([
  Component({})
], MonitorSettings);
var _sfc_render$7 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-6" }, [_c("h3", [_vm._v("Monitor Settings")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Auto-refresh")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.refresh, expression: "refresh" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", attrs: { type: "number", min: "0" }, domProps: { value: _vm.refresh }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.refresh = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Auto-refresh timer (in seconds)")])])])]);
}, "render"), _sfc_staticRenderFns$7 = [], __component__$7 = /* @__PURE__ */ normalizeComponent(
  MonitorSettings,
  _sfc_render$7,
  _sfc_staticRenderFns$7,
  !1,
  null,
  "697ed9a6"
);
const MonitorSettingsConfigurationComponent = __component__$7.exports;
var __defProp$6 = Object.defineProperty, __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$6(target, key, result), result;
}, "__decorateClass$6"), _a3;
let BasicObserveeSettings = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get name() {
    return this.model.name;
  }
  set name(value) {
    this.model = { ...this.model, name: value };
  }
  get description() {
    return this.model.description;
  }
  set description(value) {
    this.model = { ...this.model, description: value };
  }
  get excludedFileExtensions() {
    return this.model.excludedFileExtensions;
  }
  set excludedFileExtensions(value) {
    this.model = { ...this.model, excludedFileExtensions: value };
  }
  get includedFileExtensions() {
    return this.model.includedFileExtensions;
  }
  set includedFileExtensions(value) {
    this.model = { ...this.model, includedFileExtensions: value };
  }
  get allowDownloadingFiles() {
    return this.model.allowDownloadingFiles;
  }
  set allowDownloadingFiles(value) {
    this.model = { ...this.model, allowDownloadingFiles: value };
  }
  get enabled() {
    return this.model.enabled;
  }
  set enabled(value) {
    this.model = { ...this.model, enabled: value };
  }
}, __name(_a3, "BasicObserveeSettings"), _a3);
__decorateClass$6([
  Prop({
    required: !0
  })
], BasicObserveeSettings.prototype, "value", 2);
BasicObserveeSettings = __decorateClass$6([
  Component({
    components: {}
  })
], BasicObserveeSettings);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.name, expression: "name" }], staticClass: "form-control", attrs: { type: "text" }, domProps: { value: _vm.name }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.name = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Name for the observee")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Description")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.description, expression: "description" }], staticClass: "form-control", attrs: { type: "text", placeholder: "Optional description" }, domProps: { value: _vm.description }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.description = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("A description of this directory and why it is being monitored")])]), _vm._v(" "), _c("b-form-group", { attrs: { id: "enabledSwitchGroup", "label-for": "enabledSwitch" } }, [_c("b-form-checkbox", { attrs: { name: "enabledSwitch", switch: "" }, model: { value: _vm.enabled, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.enabled = $$v;
  }, "callback"), expression: "enabled" } }, [_c("b", [_vm._v("Enabled")])]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Allow users with admin or manager permissions to delete files")])], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Included File Extensions")]), _vm._v(" "), _c("b-form-tags", { attrs: { "add-on-change": "", "input-id": "included-file-extensions-tags-separators", placeholder: "Enter file extensions..." }, model: { value: _vm.includedFileExtensions, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.includedFileExtensions = $$v;
  }, "callback"), expression: "includedFileExtensions" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("When set only files with these extensions will be included for display. eg (pdf, docx, xlsx)")])], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Excluded File Extensions")]), _vm._v(" "), _c("b-form-tags", { attrs: { "add-on-change": "", "input-id": "excluded-file-extensions-tags-separators", placeholder: "Enter file extensions..." }, model: { value: _vm.excludedFileExtensions, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.excludedFileExtensions = $$v;
  }, "callback"), expression: "excludedFileExtensions" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Files with these extensions will be excluded from display. eg (xml, exe, txt)")])], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "allowDownloadingSwitchGroup", "label-for": "allowDownloadingSwitch" } }, [_c("b-form-checkbox", { attrs: { name: "allowDownloadingSwitch", switch: "" }, model: { value: _vm.allowDownloadingFiles, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.allowDownloadingFiles = $$v;
  }, "callback"), expression: "allowDownloadingFiles" } }, [_c("b", [_vm._v("Allow Downloading Files")])]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Allow all users to download files")])], 1)], 1);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  BasicObserveeSettings,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  "e3c7fc45"
);
const Basic = __component__$6.exports;
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$5"), _a4;
let DirectoryObserveeComponent$1 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get allowDeletingFiles() {
    return this.model.allowDeletingFiles;
  }
  set allowDeletingFiles(value) {
    this.model = { ...this.model, allowDeletingFiles: value };
  }
  get excludeSubFolders() {
    return this.model.excludeSubFolders;
  }
  set excludeSubFolders(value) {
    this.model = { ...this.model, excludeSubFolders: value };
  }
  get excludedFileExtensions() {
    return this.model.excludedFileExtensions;
  }
  get includedFileExtensions() {
    return this.model.includedFileExtensions;
  }
  get directory() {
    return this.model.path;
  }
  set directory(value) {
    this.model = { ...this.model, path: value };
  }
}, __name(_a4, "DirectoryObserveeComponent"), _a4);
__decorateClass$5([
  Prop({
    required: !0,
    validator: /* @__PURE__ */ __name((value) => value.type === "directory", "validator")
  })
], DirectoryObserveeComponent$1.prototype, "value", 2);
DirectoryObserveeComponent$1 = __decorateClass$5([
  Component({
    components: { BasicObserveeSettings: Basic }
  })
], DirectoryObserveeComponent$1);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v("Edit Directory Observee")]), _vm._v(" "), _c("basic-observee-settings", { model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } }), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "allowDeletingFilesSwitch", switch: "" }, model: { value: _vm.allowDeletingFiles, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.allowDeletingFiles = $$v;
  }, "callback"), expression: "allowDeletingFiles" } }, [_c("b", [_vm._v("Allow Deleting")])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Allow users with admin or manager permissions to delete files and folders that are empty")]), _vm._v(" "), _vm.excludedFileExtensions.length || _vm.includedFileExtensions.length ? _c("b-alert", { attrs: { variant: "warning", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` 
        Users may run into problems when trying to delete empty folders if the folder contains files that are hidden by the `), _c("strong", [_vm._v("Excluded File Extensions")]), _vm._v(" or "), _c("strong", [_vm._v("Included File Extensions")]), _vm._v(` lists.
      `)], 1) : _vm._e()], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "excludeSubFoldersSwitch", switch: "" }, model: { value: _vm.excludeSubFolders, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.excludeSubFolders = $$v;
  }, "callback"), expression: "excludeSubFolders" } }, [_c("b", [_vm._v("Exclude Sub-Folders")])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Only show files that are within the specified directory")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Directory")]), _vm._v(" "), _c("div", { staticClass: "alert alert-info", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` The path for directory observees must be specificied in your settings file
        `)], 1), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.directory, expression: "directory" }], staticClass: "form-control", attrs: { type: "text" }, domProps: { value: _vm.directory }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.directory = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Relative path of the directory to browse")])])], 1);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  DirectoryObserveeComponent$1,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  "56707bb8"
);
const DirectoryObserveeComponent = __component__$5.exports;
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$4"), _a5;
let IndexingObserveeComponent$1 = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  mounted() {
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get pageId() {
    return this.model.pageId;
  }
  set pageId(value) {
    this.model = { ...this.model, pageId: value };
  }
}, __name(_a5, "IndexingObserveeComponent"), _a5);
__decorateClass$4([
  Prop({
    required: !0,
    validator: /* @__PURE__ */ __name((value) => value.type === "indexing", "validator")
  })
], IndexingObserveeComponent$1.prototype, "value", 2);
IndexingObserveeComponent$1 = __decorateClass$4([
  Component({
    components: { Basic, IndexingPageReactiveDropdown }
  })
], IndexingObserveeComponent$1);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v("Edit Indexing Page Observee")]), _vm._v(" "), _c("basic", { model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } }), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Page")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("indexing-page-reactive-dropdown", { model: { value: _vm.pageId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageId = $$v;
  }, "callback"), expression: "pageId" } }), _vm._v(" "), _vm.errors.has("indexingPage") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("indexingPage")))]) : _vm._e(), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Select the page to browse")])], 1)], 1);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  IndexingObserveeComponent$1,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  "2b56e63b"
);
const IndexingObserveeComponent = __component__$4.exports;
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$3"), _a6;
let AzureObserveeComponent$1 = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  mounted() {
  }
  get model() {
    return this.value;
  }
  get allowDeletingFiles() {
    return this.model.allowDeletingFiles;
  }
  set allowDeletingFiles(value) {
    this.model = { ...this.model, allowDeletingFiles: value };
  }
  get path() {
    return this.model.path;
  }
  set path(value) {
    this.model = { ...this.model, path: value };
  }
  set model(value) {
    this.$emit("input", value);
  }
  get container() {
    return this.model.container;
  }
  set container(value) {
    this.model = { ...this.model, container: value };
  }
  get externalConnectionId() {
    return this.model.externalConnectionId;
  }
  set externalConnectionId(value) {
    this.model = { ...this.model, externalConnectionId: value };
  }
}, __name(_a6, "AzureObserveeComponent"), _a6);
__decorateClass$3([
  Prop({
    required: !0,
    validator: /* @__PURE__ */ __name((value) => value.type === "azureBlobStorage", "validator")
  })
], AzureObserveeComponent$1.prototype, "value", 2);
AzureObserveeComponent$1 = __decorateClass$3([
  Component({
    components: { Basic, ExternalConnectionDropDown, ContainerSelectionComponent }
  })
], AzureObserveeComponent$1);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v("Edit Azure Blob Storage Observee")]), _vm._v(" "), _c("basic", { model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } }), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "allowDeletingFilesSwitch", switch: "" }, model: { value: _vm.allowDeletingFiles, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.allowDeletingFiles = $$v;
  }, "callback"), expression: "allowDeletingFiles" } }, [_c("b", [_vm._v("Allow Deleting")])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Allow users with admin or manager permissions to delete files")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Azure Storage Connection")]), _vm._v(" "), _c("external-connection-drop-down", { attrs: { types: ["ExternalConnection.AzureStorage", "ExternalConnection.AzureStorageBuiltIn"] }, model: { value: _vm.externalConnectionId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.externalConnectionId = $$v;
  }, "callback"), expression: "externalConnectionId" } })], 1), _vm._v(" "), _c("container-selection-component", { attrs: { externalConnectionId: _vm.externalConnectionId, defaultMode: "simple" }, model: { value: _vm.container, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.container = $$v;
  }, "callback"), expression: "container" } }), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Directory")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.path, expression: "path" }], staticClass: "form-control", attrs: { type: "text" }, domProps: { value: _vm.path }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.path = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Relative path of the directory to browse")])])], 1);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  AzureObserveeComponent$1,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  "60d6fda4"
);
const AzureObserveeComponent = __component__$3.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$2"), _a7;
let MonitorObserveeConfigurationComponent$1 = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "isAzureMode", !1);
    __publicField(this, "edit", null);
    __publicField(this, "deleteIndex", null);
    __publicField(this, "saving", !1);
    __publicField(this, "loadingPage", !1);
    __publicField(this, "loadingPageError", null);
    __publicField(this, "moving", !1);
  }
  async mounted() {
    this.isAzureMode = await systemInAzureMode();
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  add(type) {
    let obs = null;
    switch (type) {
      case "directory":
        obs = {
          path: null,
          type: "directory",
          name: null,
          id: null,
          enabled: !0,
          allowDownloadingFiles: !1,
          allowDeletingFiles: !1,
          excludeSubFolders: !1,
          excludedFileExtensions: [],
          includedFileExtensions: []
        };
        break;
      case "indexing":
        obs = {
          type: "indexing",
          pageId: null,
          queueTypeId: null,
          queueId: null,
          enabled: !0,
          allowDownloadingFiles: !1,
          excludedFileExtensions: [],
          includedFileExtensions: []
        };
        break;
      case "azureBlobStorage":
        obs = {
          type: "azureBlobStorage",
          path: null,
          container: null,
          externalConnectionId: null,
          enabled: !0,
          excludedFileExtensions: [],
          includedFileExtensions: [],
          allowDownloadingFiles: !1,
          allowDeletingFiles: !1
        };
        break;
    }
    obs && (this.edit = this.observees.push(obs) - 1);
  }
  getObserveeIcon(type) {
    switch (type) {
      case "directory":
        return "folder";
      case "indexing":
        return "inbox";
      case "azureBlobStorage":
        return "clouds";
    }
    return "question";
  }
  editObservee(obs) {
    let index = this.observees.indexOf(obs);
    index > -1 && (this.edit = index);
  }
  deleteObservee(obs) {
    if (this.deleteIndex === this.observees.indexOf(obs)) {
      let newObs = [...this.observees];
      newObs.splice(this.deleteIndex, 1), this.observees = newObs, this.deleteIndex = null;
    } else {
      let deleteIndex = this.observees.indexOf(obs);
      if (deleteIndex < 0)
        return;
      this.deleteIndex = deleteIndex;
    }
  }
  get editor() {
    if (!this.editing)
      return null;
    switch (this.editing.type) {
      case "directory":
        return DirectoryObserveeComponent;
      case "indexing":
        return IndexingObserveeComponent;
      case "azureBlobStorage":
        return AzureObserveeComponent;
    }
  }
  async onUpdate(e) {
    let observee = this.observees[e.oldIndex];
    this.observees.splice(e.oldIndex, 1), this.observees.splice(e.newIndex, 0, observee);
  }
  get observees() {
    return this.model.observee;
  }
  set observees(obs) {
    this.model = { ...this.model, observee: obs };
  }
  get editing() {
    return this.edit !== null ? this.observees[this.edit] : null;
  }
  set editing(obs) {
    if (this.edit !== null) {
      let newObs = [...this.observees];
      newObs.splice(this.edit, 1, obs), this.observees = newObs;
    }
  }
  async cancel() {
    this.moving = !0;
    try {
      await this.$store.dispatch("administration/smtp/rules/actions/cancel");
    } catch (e) {
      toastr.error(e, "Failed to reorder items");
    } finally {
      this.moving = !1;
    }
  }
}, __name(_a7, "MonitorObserveeConfigurationComponent"), _a7);
__decorateClass$2([
  Prop({
    required: !0
  })
], MonitorObserveeConfigurationComponent$1.prototype, "value", 2);
MonitorObserveeConfigurationComponent$1 = __decorateClass$2([
  Component({
    components: { DirectoryObserveeComponent, IndexingObserveeComponent, draggable },
    methods: { systemInAzureMode }
  })
], MonitorObserveeConfigurationComponent$1);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-sm-12" }, [_c("h3", [_vm._v("Observees")]), _vm._v(" "), _c("div", { staticClass: "dropdown" }, [_c("button", { staticClass: "btn btn-default dropdown-toggle", attrs: { type: "button", "data-toggle": "dropdown" } }, [_c("span", { staticClass: "caret" }), _c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add Observee
            `)], 1), _vm._v(" "), _c("ul", { staticClass: "dropdown-menu" }, [_c("li", [_c("button", { staticClass: "dropdown-item", attrs: { role: "button", disabled: _vm.isAzureMode }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.add("directory");
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "folder" } }), _vm._v(` Directory
                    `)], 1)]), _vm._v(" "), _c("li", [_c("button", { staticClass: "dropdown-item", attrs: { role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.add("indexing");
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "inbox" } }), _vm._v(` Remote Indexing
                    `)], 1)]), _vm._v(" "), _c("li", [_c("button", { staticClass: "dropdown-item", attrs: { role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.add("azureBlobStorage");
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "clouds" } }), _vm._v(` Azure Blob Storage
                    `)], 1)])])]), _vm._v(" "), _c("br")]), _vm._v(" "), _c("div", { staticClass: "col-sm-4" }, [_c("div", { staticClass: "list-group", attrs: { id: "list-tab", role: "tablist" } }, [_c("draggable", { staticClass: "list-group mb-2", attrs: { value: _vm.observees, tag: "div", options: { disabled: _vm.moving } }, on: { update: _vm.onUpdate } }, _vm._l(_vm.observees, function(observee, id) {
    return _c("a", { key: id, staticClass: "list-group-item list-group-item-action", class: { active: _vm.edit === id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editObservee(observee);
    }, "click") } }, [_c("h4", { staticClass: "list-group-item-heading" }, [_c("font-awesome-icon", { attrs: { icon: _vm.getObserveeIcon(observee.type) } }), _vm._v(` 
                        `), observee.name ? _c("span", [_vm._v(_vm._s(observee.name))]) : _c("span", [_c("i", [_vm._v("No observee name")])]), _vm._v(" "), observee.type == "directory" && _vm.isAzureMode ? _c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", value: "This observee type isn't supported when running in Azure Mode", expression: "'This observee type isn\\'t supported when running in Azure Mode'", modifiers: { hover: !0 } }], attrs: { pill: "", variant: "warning" } }, [_vm._v("Disabled")]) : _vm._e(), _vm._v(" "), _c("span", { staticClass: "float-right" }, [_c("div", { staticClass: "float-right", attrs: { role: "group" } }, [_c("button", { staticClass: "btn btn-danger btn-sm", on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteObservee(observee);
    }, "click") } }, [_vm.deleteIndex !== null && _vm.deleteIndex === id ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Are you sure?
                                `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)])])])], 1), _vm._v(" "), _c("span", { staticClass: "clearfix" }), _vm._v(" "), observee.description ? _c("p", { staticClass: "list-group-item-text" }, [_vm._v(_vm._s(observee.description))]) : _vm._e()]);
  }), 0)], 1)]), _vm._v(" "), _vm.editing ? _c("div", { staticClass: "col-sm-8" }, [_c(_vm.editor, { tag: "component", model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } }, [_c("div", { staticClass: "alert alert-danger" }, [_vm._v(`
                Observee type not recognised
            `)])]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.edit = null;
  }, "click") } }, [_vm._v("Save")])], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  MonitorObserveeConfigurationComponent$1,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "b479c1ff"
);
const MonitorObserveeConfigurationComponent = __component__$2.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a8;
let DisplaySettings$1 = (_a8 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "selectedTab", "homePage");
    __publicField(this, "tabs", [
      { id: "homePage", name: "Home Page", icon: "display-code", indent: !1 }
    ]);
  }
  setSelected(tab) {
    this.selectedTab = tab;
  }
  isSelected(tab) {
    return this.selectedTab === tab;
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
}, __name(_a8, "DisplaySettings"), _a8);
__decorateClass$1([
  Prop({ required: !0 })
], DisplaySettings$1.prototype, "value", 2);
DisplaySettings$1 = __decorateClass$1([
  Component({
    components: { HomePageConfiguration, IconSelect, ColourSelect }
  })
], DisplaySettings$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("h3", [_c("font-awesome-icon", { attrs: { icon: "desktop" } }), _vm._v(`
        Display Settings
      `)], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", { staticClass: "mb-3", attrs: { xl: "3", lg: "4", md: "5", sm: "12" } }, [_c("b-list-group", { ref: "display" }, _vm._l(_vm.tabs, function(tab) {
    return _c("b-list-group-item", { ref: "action", refInFor: !0, staticClass: "d-flex justify-content-between align-items-center", class: tab.indent ? "pl-5" : "", attrs: { button: "", active: _vm.isSelected(tab.id) }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setSelected(tab.id);
    }, "click") } }, [_c("span", [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: tab.icon } }), _vm._v(_vm._s(tab.name) + `
          `)], 1)]);
  }), 1)], 1), _vm._v(" "), _c("b-col", { attrs: { xl: "5", lg: "6", md: "7", sm: "12" } }, [_c("home-page-configuration", { attrs: { "hide-heading": !0 }, model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } })], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  DisplaySettings$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "d7f9235d"
);
const DisplaySettings = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a9;
let MonitorConfigurationComponent = (_a9 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "pageId");
    __publicField(this, "page", null);
    __publicField(this, "edit", null);
    __publicField(this, "deleteIndex", null);
    __publicField(this, "saving", !1);
    __publicField(this, "loadingPage", !1);
    __publicField(this, "loadingPageError", null);
    __publicField(this, "currentTab", null);
    __publicField(this, "storedId", null);
  }
  created() {
    let load;
    this.pageId ? load = this.loadPage(this.pageId) : load = this.createPage(), load.then(() => {
      this.currentTab = "general";
    });
  }
  loadPage(pageId) {
    return this.loadingPage = !0, this.loadingPageError = null, this.$store.dispatch("administration/pages/monitor/load", pageId).catch((e) => this.loadingPageError = e).finally(() => this.loadingPage = !1);
  }
  createPage() {
    return this.$store.dispatch("administration/pages/monitor/create").catch((e) => {
      this.loadingPageError = e;
    }).finally(() => this.loadingPage = !1);
  }
  get model() {
    return this.$store.getters["administration/pages/monitor/current"]();
  }
  set model(page) {
    this.$store.dispatch("administration/pages/monitor/update", page);
  }
  get tabs() {
    return tabs;
  }
  activeTab(id) {
    return id === this.currentTab;
  }
  selectTab(tab) {
    this.currentTab = tab;
  }
  hasError(id) {
    let refs = this.$refs[id];
    if (!refs)
      return !1;
    let component = refs.find(() => !0);
    return component && component.$validator ? component.$validator.errors.any() : !1;
  }
  get hasErrors() {
    return !!this.$children.map((c) => c.$validator).find((v) => v.errors.any());
  }
  validate() {
    let validators = this.$children.map((c) => c.$validator);
    return Promise.all(validators.map((v) => v.validateAll())).then((r) => r.every((v) => v));
  }
  get canSave() {
    return this.$store.getters["administration/pages/monitor/canSave"];
  }
  get id() {
    return this.model.id;
  }
  set id(id) {
    this.model = { ...this.model, id };
  }
  get name() {
    return this.model.name;
  }
  set name(name) {
    !this.model.id || this.model.id == getReplacedName(this.model.name) && this.storedId ? (this.storedId = getReplacedName(name), this.model = { ...this.model, id: this.storedId, name }, this.$validator.validate("id")) : this.model = Object.assign({}, this.model, { name });
  }
  get description() {
    return this.model.description;
  }
  set description(description) {
    this.model = { ...this.model, description };
  }
  get menuItemHidden() {
    return this.model.menuItemHidden;
  }
  set menuItemHidden(menuItemHidden) {
    this.model = { ...this.model, menuItemHidden };
  }
  get permissions() {
    return this.model.permissions;
  }
  set permissions(permissions) {
    this.model = { ...this.model, permissions };
  }
  save() {
    this.validate().then((valid) => {
      if (!valid) {
        toastr.error("Errors in configuration. Check tabs marked");
        return;
      }
      this.$store.commit("administration/app/mutations/saving", !0), this.$store.dispatch("administration/pages/monitor/save").then(() => {
        toastr.success("Page saved");
      }).catch((e) => {
        toastr.error("Error: " + (e == null ? void 0 : e.response) || "Failed to save the page. Please check settings try again.");
      }).finally(() => this.$store.commit("administration/app/mutations/saving", !1));
    });
  }
}, __name(_a9, "MonitorConfigurationComponent"), _a9);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], MonitorConfigurationComponent.prototype, "pageId", 2);
MonitorConfigurationComponent = __decorateClass([
  Component({
    components: { LoadingBar: LoadingBarComponent }
  })
], MonitorConfigurationComponent);
const tabs = [
  {
    id: "general",
    name: "General",
    icon: "edit",
    description: "General page settings",
    component: MonitorGeneralConfigurationComponent,
    show: !0
  },
  {
    id: "display",
    name: "Display",
    icon: "display",
    description: "Display settings",
    component: DisplaySettings,
    show: !0
  },
  {
    id: "settings",
    name: "Settings",
    icon: "cog",
    description: "Monitoring Settings",
    component: MonitorSettingsConfigurationComponent,
    show: !0
  },
  {
    id: "observees",
    name: "Observees",
    icon: "folder",
    description: "Observee Settings",
    component: MonitorObserveeConfigurationComponent,
    show: !0
  }
];
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "container-fluid" }, [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_vm._v("Edit Monitoring Page: "), _vm.model ? _c("small", [_vm._v(_vm._s(_vm.model.name))]) : _vm._e()])]), _vm._v(" "), _c("div", { staticClass: "row" }, [_vm.loadingPage ? _c("div", { staticClass: "col" }, [_c("loading-bar")], 1) : _vm.loadingPageError ? _c("div", { staticClass: "alert alert-danger" }, [_c("strong", [_vm._v("Oh no!")]), _vm._v(" Failed to load the page. "), _c("a", { attrs: { role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.loadPage(_vm.pageId);
  }, "click") } }, [_vm._v("Try again?")])]) : _c("div", { staticClass: "col mb-4" }, [_c("ul", { staticClass: "nav nav-tabs unselectable" }, [_vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item", attrs: { role: "presentation" } }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab(tab.id), disabled: !tab.show, "has-error": _vm.hasError(tab.id) }, attrs: { role: "tab", title: tab.description, id: tab.id, "data-toggle": "tab" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(`
                        ` + _vm._s(tab.name) + `
                        `), _vm.hasError(tab.id) ? _c("span", [_vm._v(`
                             
                            `), _c("font-awesome-icon", { staticClass: "text-danger", attrs: { icon: "exclamation" } })], 1) : _vm._e()], 1)]);
  }), _vm._v(" "), _c("li", { staticClass: "ml-auto nav-item" }, [_c("button", { staticClass: "btn btn-success", attrs: { disabled: !_vm.canSave || _vm.saving || _vm.hasErrors, id: "savePage" }, on: { click: _vm.save } }, [_vm.saving ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(` Saving...
                        `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save
                        `)], 1)])])], 2)])]), _vm._v(" "), _vm.model ? _c("div", { staticClass: "tab-content" }, _vm._l(_vm.tabs, function(tab) {
    return tab.show ? _c(tab.component, { directives: [{ name: "show", rawName: "v-show", value: tab.id === _vm.currentTab, expression: "tab.id === currentTab" }], key: tab.id, ref: tab.id, refInFor: !0, tag: "component", model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.model = $$v;
    }, "callback"), expression: "model" } }) : _vm._e();
  }), 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  MonitorConfigurationComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "d470f3c4"
);
const root = __component__.exports;
export {
  root as default
};
