var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, d as IndexingClient, T as Transformer, b as baseUrl, t as toastr, n as normalizeComponent, e as bus$1, v as vSelect, W as Watch, l as lozad, f as draggable, g as v4, h as PdfModificationTypeModel, i as Keys, _, j as getQueueName, G as Getter, S as State, E as ErrorPanel } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { I as ItemHistoryModal$2 } from "./itemHistoryModal-BQOXXlR-.js";
import { I as ItemNoteModal } from "./itemNoteModal-DI9RlC8E.js";
import { m as modalCommon } from "./modalCommon-CzcVAzcj.js";
import { I as ItemNoteAlert } from "./itemNoteAlert-Do9RDMvA.js";
var __defProp$a = Object.defineProperty, __getOwnPropDesc$a = Object.getOwnPropertyDescriptor, __decorateClass$a = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$a(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$a(target, key, result), result;
}, "__decorateClass$a"), _a;
let MovePageModal$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "shouldShow");
    __publicField(this, "item");
    __publicField(this, "movePageNumber");
    __publicField(this, "totalPages");
    __publicField(this, "isSubjectFile");
    __publicField(this, "sourcePageNumber", 0);
    __publicField(this, "targetPageNumber", 0);
    __publicField(this, "loading", !1);
  }
  mounted() {
    this.$watch("shouldShow", modalCommon.listenForShow(this.$el)), this.$watch("movePageNumber", () => {
      this.sourcePageNumber = this.movePageNumber, this.targetPageNumber = 1;
    });
  }
  closeModal() {
    this.$emit("close");
  }
  async movePage() {
    if (await this.$validator.validateAll())
      try {
        this.loading = !0;
        let response = await new IndexingClient(new Transformer(), baseUrl()).moveItemPage(this.item.id, this.sourcePageNumber, this.targetPageNumber);
        if (!response)
          window.location.reload();
        else {
          let url = new URL(baseUrl() + "/app/indexing/items/" + this.item.id + "/pending");
          url.searchParams.set("processorId", response.processorId), window.location.href = url.href;
        }
      } catch (ex) {
        toastr.error(ex, "An error occurred while moving the page"), this.loading = !1, this.closeModal();
      } finally {
      }
  }
}, __name(_a, "MovePageModal"), _a);
__decorateClass$a([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], MovePageModal$1.prototype, "shouldShow", 2);
__decorateClass$a([
  Prop({
    required: !0
  })
], MovePageModal$1.prototype, "item", 2);
__decorateClass$a([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], MovePageModal$1.prototype, "movePageNumber", 2);
__decorateClass$a([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], MovePageModal$1.prototype, "totalPages", 2);
__decorateClass$a([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], MovePageModal$1.prototype, "isSubjectFile", 2);
MovePageModal$1 = __decorateClass$a([
  Component({})
], MovePageModal$1);
var _sfc_render$a = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "modal fade movePageModal", staticStyle: { "overflow-x": "auto" }, attrs: { tabindex: "-1", role: "dialog", "data-backdrop": "static", "data-keyboard": "false", id: "movePageModal" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "sort-size-up-alt" } }), _vm._v(" Move page")], 1), _vm._v(" "), _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", disabled: _vm.loading, "aria-label": "Close" }, on: { click: _vm.closeModal } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_vm.isSubjectFile ? _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-12" }, [_vm.totalPages < 2 ? _c("b-alert", { staticClass: "mb-1", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` Cannot move pages on a document with only one page.
                            `)], 1) : _c("div", [_c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" "), _c("span", { staticClass: "font-weight-bold" }, [_vm._v(_vm._s(_vm.totalPages) + " Pages total ")]), _c("span", { staticClass: "text-muted small" }, [_vm._v("- " + _vm._s(_vm.item.name))])], 1), _vm._v(" "), _c("label", { staticClass: "font-weight-bold" }, [_vm._v("Page number to move")]), _vm._v(" "), _c("b-input-group", { attrs: { id: "sourcePageNumberGroup", label: "Source Page Number", "label-for": "sourcePageNumber" } }, [_c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required|numeric|max_value:" + _vm.totalPages + "|min_value:1", expression: "'required|numeric|max_value:' + totalPages + '|min_value:1'" }], attrs: { id: "sourcePageNumber", name: "sourcePageNumber", type: "number", "data-vv-as": "page number to move" }, model: { value: _vm.sourcePageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sourcePageNumber = $$v;
  }, "callback"), expression: "sourcePageNumber" } })], 1), _vm._v(" "), _vm.errors.first("sourcePageNumber") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("sourcePageNumber")))]) : _vm._e(), _vm._v(" "), _c("label", { staticClass: "font-weight-bold" }, [_vm._v("New page number")]), _vm._v(" "), _c("b-input-group", { attrs: { id: "targetPageNumberGroup", label: "Target Page Number", "label-for": "targetPageNumber" } }, [_c("b-input-group-prepend", [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "outline-primary", disabled: _vm.loading, title: "Start of document" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.targetPageNumber = 1;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "backward-fast" } })], 1)], 1), _vm._v(" "), _c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required|numeric|max_value:" + _vm.totalPages + "|min_value:1", expression: "'required|numeric|max_value:' + totalPages + '|min_value:1'" }], attrs: { id: "targetPageNumber", name: "targetPageNumber", type: "number", "data-vv-as": "new page number" }, model: { value: _vm.targetPageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.targetPageNumber = $$v;
  }, "callback"), expression: "targetPageNumber" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "outline-primary", disabled: _vm.loading, title: "End of document" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.targetPageNumber = _vm.totalPages;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "forward-fast" } })], 1)], 1)], 1), _vm._v(" "), _vm.errors.first("targetPageNumber") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("targetPageNumber")))]) : _vm._e()], 1)], 1)])]) : _c("div", [_c("b-alert", { attrs: { variant: "warning", show: !0 } }, [_c("p", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" You cannot move pages from the selected item because it is not the subject file.")], 1), _vm._v(`
                        This can occur because the selected item...
                        `), _c("ul", [_c("li", [_vm._v("is not a PDF.")]), _vm._v(" "), _c("li", [_vm._v("is an attachment.")]), _vm._v(" "), _c("li", [_vm._v("was generated by a file converter.")])]), _vm._v(" "), _c("p", [_vm._v("Make sure you have select the item with a "), _c("font-awesome-icon", { attrs: { icon: "star" } }), _vm._v(" next to the name, that it is a PDF file and has not been generated by a processor.")], 1)])], 1)]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("b-button", { attrs: { variant: "outline-secondary", disabled: _vm.loading }, on: { click: _vm.closeModal } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "primary", disabled: _vm.loading || !_vm.isSubjectFile || _vm.totalPages < 2 || _vm.sourcePageNumber == _vm.targetPageNumber, id: "movePageConfirm" }, on: { click: _vm.movePage } }, [_c("font-awesome-icon", { attrs: { icon: _vm.loading ? "sync" : "sort-size-up-alt", spin: _vm.loading } }), _vm._v(" "), _vm.loading ? _c("span", [_vm._v("Moving...")]) : _c("span", [_vm._v("Move page ")])], 1)], 1)])])])]);
}, "render"), _sfc_staticRenderFns$a = [], __component__$a = /* @__PURE__ */ normalizeComponent(
  MovePageModal$1,
  _sfc_render$a,
  _sfc_staticRenderFns$a,
  !1,
  null,
  "c36e0c54"
);
const MovePageModal = __component__$a.exports;
var __defProp$9 = Object.defineProperty, __getOwnPropDesc$9 = Object.getOwnPropertyDescriptor, __decorateClass$9 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$9(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$9(target, key, result), result;
}, "__decorateClass$9"), _a2;
let SplitItemModal$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "shouldShow");
    __publicField(this, "item");
    __publicField(this, "splitOnPageNumber");
    __publicField(this, "totalPages");
    __publicField(this, "isSubjectFile");
    __publicField(this, "newDocName", "");
    __publicField(this, "metadata", this.$store.state.page.ria.viewer.splitCopyMetadataDefault);
    __publicField(this, "loading", !1);
  }
  mounted() {
    this.$watch("shouldShow", modalCommon.listenForShow(this.$el));
    var extensionlessName = this.item.name.split(".").slice(0, -1).join(".");
    this.newDocName = extensionlessName + " (split)";
  }
  closeModal() {
    this.$emit("close");
  }
  get docOnePages() {
    return this.splitOnPageNumber < 2 ? "1 - 1" : "1 - " + (this.splitOnPageNumber - 1);
  }
  get newDocumentName() {
    return this.newDocName;
  }
  set newDocumentName(value) {
    this.newDocName = value;
  }
  get copyMetadata() {
    return this.metadata;
  }
  set copyMetadata(value) {
    this.metadata = value;
  }
  get docTwoPages() {
    return parseInt(this.splitOnPageNumber) + " - " + this.totalPages;
  }
  get canSave() {
    return !this.$validator.errors.any();
  }
  splitDocument() {
    this.$validator.validateAll().then((valid) => {
      if (valid) {
        this.loading = !0;
        let payload = { pageNumber: this.splitOnPageNumber, newDocumentName: this.newDocumentName, copyMetadata: this.copyMetadata };
        bus.send("split-document", payload), this.$emit("selected", payload);
      } else
        return;
    });
  }
}, __name(_a2, "SplitItemModal"), _a2);
__decorateClass$9([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], SplitItemModal$1.prototype, "shouldShow", 2);
__decorateClass$9([
  Prop({
    required: !0
  })
], SplitItemModal$1.prototype, "item", 2);
__decorateClass$9([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], SplitItemModal$1.prototype, "splitOnPageNumber", 2);
__decorateClass$9([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], SplitItemModal$1.prototype, "totalPages", 2);
__decorateClass$9([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], SplitItemModal$1.prototype, "isSubjectFile", 2);
SplitItemModal$1 = __decorateClass$9([
  Component({})
], SplitItemModal$1);
var _sfc_render$9 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "modal fade splitConfirmModal", staticStyle: { "overflow-x": "auto" }, attrs: { tabindex: "-1", role: "dialog", "data-backdrop": "static", "data-keyboard": "false", id: "splitConfirmModal" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "file-dashed-line" } }), _vm._v("Split Document: "), _c("span", { staticClass: "text-muted" }, [_vm._v(_vm._s(_vm.item.name))])], 1), _vm._v(" "), _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" }, on: { click: _vm.closeModal } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_vm.isSubjectFile ? _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-12" }, [this.totalPages < 2 ? _c("div", { staticClass: "alert alert-warning" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` Cannot split a document with only one page.
                                `)], 1) : _c("div", { staticClass: "alert alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` This will split the pdf document. The selected page will be the first page of the new document.
                                `)], 1)])]), _vm._v(" "), this.totalPages >= 2 ? _c("div", { staticClass: "row" }, [_vm._m(0), _vm._v(" "), _c("div", { staticClass: "col-6" }, [_c("div", { staticClass: "form-group ml-2" }, [_c("label", [_vm._v("Original document")]), _vm._v(" "), _c("div", { staticClass: "input-group" }, [_vm._v(`
                                        ` + _vm._s(_vm.docOnePages) + `
                                    `)])]), _vm._v(" "), _vm._e()]), _vm._v(" "), _c("div", { staticClass: "col-6" }, [_c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("New document")]), _vm._v(" "), _c("div", { staticClass: "input-group" }, [_vm._v(`
                                        ` + _vm._s(_vm.docTwoPages) + `
                                    `)])])]), _vm._v(" "), _c("div", { staticClass: "col-12" }, [_c("hr"), _vm._v(" "), _c("h5", [_vm._v("Split settings")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("div", { staticClass: "input-group" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.newDocumentName, expression: "newDocumentName" }], staticClass: "form-control", attrs: { type: "text", id: "docName1" }, domProps: { value: _vm.newDocumentName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.newDocumentName = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm._m(1)])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "form-inline" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { staticClass: "mx-1", attrs: { disabled: !this.$store.state.page.ria.viewer.splitCopyMetadataUserAccess, name: "splitEnabledSwitch", switch: "" }, model: { value: _vm.copyMetadata, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.copyMetadata = $$v;
  }, "callback"), expression: "copyMetadata" } }, [_c("b", [_vm._v("Copy Metadata")])])], 1), _vm._v(" "), _c("font-awesome-icon", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { icon: "question-circle", title: "Copy the saved metadata to the new document" } })], 1)])])]) : _vm._e()]) : _c("div", { staticClass: "alert alert-danger" }, [_c("p", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" You cannot split the selected item because it is not the subject file.")], 1), _vm._v(`
                        This can occur because the selected item...
                        `), _vm._m(2), _vm._v(" "), _c("p", [_vm._v("Make sure you have select the item with a "), _c("font-awesome-icon", { attrs: { icon: "star" } }), _vm._v(" next to the name, that it is a PDF file and has not been generated by a processor.")], 1)])]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button" }, on: { click: _vm.closeModal } }, [_vm._v("Cancel")]), _vm._v(" "), _vm.isSubjectFile ? _c("button", { staticClass: "btn btn-primary split", attrs: { type: "button", disabled: !_vm.canSave || _vm.totalPages < 2 || _vm.loading, id: "splitDocumentConfirm" }, on: { click: _vm.splitDocument } }, [_c("font-awesome-icon", { attrs: { icon: "file-dashed-line" } }), _vm._v(` Split Document
                    `)], 1) : _vm._e()])])])])]);
}, "render"), _sfc_staticRenderFns$9 = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-12" }, [_c("h5", [_vm._v("Pages")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "input-group-append" }, [_c("span", { staticClass: "input-group-text", attrs: { id: "docName1-addon" } }, [_vm._v(".pdf")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("ul", [_c("li", [_vm._v("is not a PDF.")]), _vm._v(" "), _c("li", [_vm._v("is an attachment.")]), _vm._v(" "), _c("li", [_vm._v("was generated by a file converter.")])]);
}], __component__$9 = /* @__PURE__ */ normalizeComponent(
  SplitItemModal$1,
  _sfc_render$9,
  _sfc_staticRenderFns$9,
  !1,
  null,
  "66edae92"
);
const SplitItemModal = __component__$9.exports;
var __defProp$8 = Object.defineProperty, __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor, __decorateClass$8 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$8(target, key, result), result;
}, "__decorateClass$8"), _a3;
let ItemHistoryModal$1 = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "shouldShow");
    __publicField(this, "item");
    __publicField(this, "deletePageNumber");
    __publicField(this, "totalPages");
    __publicField(this, "isSubjectFile");
    __publicField(this, "loading", !1);
    __publicField(this, "pageNumbers", []);
  }
  mounted() {
    this.$watch("shouldShow", modalCommon.listenForShow(this.$el)), this.$watch("deletePageNumber", () => this.pageNumbers = [this.deletePageNumber]);
  }
  get deletePageNumbers() {
    return this.pageNumbers;
  }
  set deletePageNumbers(value) {
    this.pageNumbers = value;
  }
  closeModal() {
    this.$emit("close");
  }
  get canSave() {
    return !this.$validator.errors.any();
  }
  deleteDocumentPage() {
    this.$validator.validateAll().then((valid) => {
      if (valid) {
        this.loading = !0;
        let payload = { pageNumbers: this.deletePageNumbers };
        bus$1.send("delete-document-page", payload), this.$emit("selected", payload);
      } else
        return;
    });
  }
}, __name(_a3, "ItemHistoryModal"), _a3);
__decorateClass$8([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], ItemHistoryModal$1.prototype, "shouldShow", 2);
__decorateClass$8([
  Prop({
    required: !0
  })
], ItemHistoryModal$1.prototype, "item", 2);
__decorateClass$8([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], ItemHistoryModal$1.prototype, "deletePageNumber", 2);
__decorateClass$8([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], ItemHistoryModal$1.prototype, "totalPages", 2);
__decorateClass$8([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], ItemHistoryModal$1.prototype, "isSubjectFile", 2);
ItemHistoryModal$1 = __decorateClass$8([
  Component({})
], ItemHistoryModal$1);
var _sfc_render$8 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "modal fade splitConfirmModal", staticStyle: { "overflow-x": "auto" }, attrs: { tabindex: "-1", role: "dialog", "data-backdrop": "static", "data-keyboard": "false", id: "splitConfirmModal" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "file-excel" } }), _vm._v(" Delete page")], 1), _vm._v(" "), _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", disabled: _vm.loading, "aria-label": "Close" }, on: { click: _vm.closeModal } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_vm.isSubjectFile ? _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-12" }, [_vm.totalPages < 2 ? _c("b-alert", { staticClass: "mb-1", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` Cannot delete pages from a document with only one page.
                            `)], 1) : _c("div", [_c("b-alert", { attrs: { variant: "info", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Deleting pages from an item
                                `), _c("ul", [_c("li", [_vm._v("This will delete page "), _c("b", [_vm._v(_vm._s(_vm.deletePageNumber))]), _vm._v(" from the item")]), _vm._v(" "), _c("li", [_vm._v("This is irreversible")]), _vm._v(" "), _c("li", [_vm._v("Please ensure you have the correct page number")])])], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "ItemNameGroup", label: "Item", "label-for": "itemName" } }, [_c("b-form-input", { attrs: { id: "itemName", type: "text", disabled: "" }, model: { value: _vm.item.name, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.item, "name", $$v);
  }, "callback"), expression: "item.name" } })], 1)], 1)], 1)])]) : _c("div", [_c("b-alert", { attrs: { variant: "warning", show: !0 } }, [_c("p", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" You cannot delete pages from the selected item because it is not the subject file.")], 1), _vm._v(`
                        This can occur because the selected item...
                        `), _c("ul", [_c("li", [_vm._v("is not a PDF.")]), _vm._v(" "), _c("li", [_vm._v("is an attachment.")]), _vm._v(" "), _c("li", [_vm._v("was generated by a file converter.")])]), _vm._v(" "), _c("p", [_vm._v("Make sure you have select the item with a "), _c("font-awesome-icon", { attrs: { icon: "star" } }), _vm._v(" next to the name, that it is a PDF file and has not been generated by a processor.")], 1)])], 1)]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("b-button", { attrs: { variant: "outline-secondary", disabled: _vm.loading }, on: { click: _vm.closeModal } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "danger", disabled: _vm.loading || !_vm.isSubjectFile || _vm.totalPages < 2, id: "deleteDocumentPageConfirm" }, on: { click: _vm.deleteDocumentPage } }, [_c("font-awesome-icon", { attrs: { icon: _vm.loading ? "sync" : "file-excel", spin: _vm.loading } }), _vm._v(" "), _vm.loading ? _c("span", [_vm._v("Deleting")]) : _c("span", [_vm._v("Delete page " + _vm._s(_vm.deletePageNumber))])], 1)], 1)])])])]);
}, "render"), _sfc_staticRenderFns$8 = [], __component__$8 = /* @__PURE__ */ normalizeComponent(
  ItemHistoryModal$1,
  _sfc_render$8,
  _sfc_staticRenderFns$8,
  !1,
  null,
  "627d4457"
);
const DeletePageModal = __component__$8.exports;
var __defProp$7 = Object.defineProperty, __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor, __decorateClass$7 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$7(target, key, result), result;
}, "__decorateClass$7"), _a4;
let ItemHistoryModal = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "shouldShow");
    __publicField(this, "item");
    __publicField(this, "rotatePageNumber");
    __publicField(this, "totalPages");
    __publicField(this, "isSubjectFile");
    __publicField(this, "pageNumbers", []);
    __publicField(this, "rotateDegrees", 90);
    __publicField(this, "rotateOptions", [{ html: "90 &deg;", value: 90 }, { html: "180 &deg;", value: 180 }, { html: "270 &deg;", value: 270 }]);
    __publicField(this, "pageNumberOptions", []);
    __publicField(this, "loading", !1);
  }
  mounted() {
    this.$watch("shouldShow", modalCommon.listenForShow(this.$el)), this.$watch("rotatePageNumber", () => this.pageNumbers = [this.rotatePageNumber]);
  }
  get rotatePageNumbers() {
    return this.pageNumbers;
  }
  set rotatePageNumbers(value) {
    this.pageNumbers = value;
  }
  closeModal() {
    this.$emit("close");
  }
  get canSave() {
    return !this.$validator.errors.any();
  }
  get generatedPageNumberOptions() {
    for (let i = 0; i < this.totalPages; i++)
      this.pageNumberOptions.push(i + 1);
    return this.pageNumberOptions;
  }
  selectAllPages() {
    this.rotatePageNumbers = [];
    for (let i = 0; i < this.totalPages; i++)
      this.rotatePageNumbers.push(i + 1);
  }
  deselectAllPages() {
    this.rotatePageNumbers = [];
  }
  rotateDocumentPage() {
    this.$validator.validateAll().then((valid) => {
      if (valid) {
        this.loading = !0;
        let payload = { pageNumbers: this.rotatePageNumbers, rotateDegrees: this.rotateDegrees };
        bus$1.send("rotate-document-page", payload), this.$emit("selected", payload);
      } else
        return;
    });
  }
}, __name(_a4, "ItemHistoryModal"), _a4);
__decorateClass$7([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], ItemHistoryModal.prototype, "shouldShow", 2);
__decorateClass$7([
  Prop({
    required: !0
  })
], ItemHistoryModal.prototype, "item", 2);
__decorateClass$7([
  Prop({
    default: 0,
    required: !0
  })
], ItemHistoryModal.prototype, "rotatePageNumber", 2);
__decorateClass$7([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], ItemHistoryModal.prototype, "totalPages", 2);
__decorateClass$7([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => 0, "default")
  })
], ItemHistoryModal.prototype, "isSubjectFile", 2);
ItemHistoryModal = __decorateClass$7([
  Component({
    components: { vSelect }
  })
], ItemHistoryModal);
var _sfc_render$7 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "modal fade rotateDocumentPageModal", staticStyle: { "overflow-x": "auto" }, attrs: { tabindex: "-1", role: "dialog", "data-backdrop": "static", "data-keyboard": "false", id: "rotateDocumentPageModal" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "undo", flip: "horizontal" } }), _vm._v(" Rotate page"), _vm.pageNumbers.length > 1 ? _c("span", [_vm._v("s")]) : _vm._e()], 1), _vm._v(" "), _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", disabled: _vm.loading, "aria-label": "Close" }, on: { click: _vm.closeModal } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-12" }, [_c("b-form-group", { attrs: { id: "ItemNameGroup", label: "Item", "label-for": "itemName" } }, [_c("b-form-input", { attrs: { id: "itemName", type: "text", disabled: "" }, model: { value: _vm.item.name, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.item, "name", $$v);
  }, "callback"), expression: "item.name" } })], 1), _vm._v(" "), _vm.isSubjectFile ? _c("div", [_c("b-alert", { attrs: { variant: "info", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` This will rotate the selected pages of the PDF document.
                              `)], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "rotatePageNumbersGroup" } }, [_c("label", { staticClass: "font-weight-bold", attrs: { for: "rotatePageNumbers" } }, [_vm._v("Rotate Page"), _vm.pageNumbers.length > 1 ? _c("span", [_vm._v("s")]) : _vm._e(), _vm._v(` 
                                  `), _vm.totalPages > 1 ? _c("span", [_vm.pageNumbers.length < _vm.totalPages ? _c("b-button", { attrs: { disabled: _vm.loading, variant: "outline-primary", pill: "", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.selectAllPages();
  }, "click") } }, [_vm._v("Select all")]) : _vm._e(), _vm._v(" "), _vm.pageNumbers.length === _vm.totalPages ? _c("b-button", { attrs: { disabled: _vm.loading, variant: "outline-primary", pill: "", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.deselectAllPages();
  }, "click") } }, [_vm._v("Deselect all")]) : _vm._e()], 1) : _vm._e()]), _vm._v(" "), _c("v-select", { attrs: { id: "rotatePageNumbers", multiple: "", options: _vm.generatedPageNumberOptions, disabled: _vm.loading, "close-on-select": !1 }, model: { value: _vm.rotatePageNumbers, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.rotatePageNumbers = $$v;
  }, "callback"), expression: "rotatePageNumbers" } }), _vm._v(" "), _vm.rotatePageNumbers.length ? _c("p", { staticClass: "text-muted" }, [_vm._v("The pages to rotate, you can select multiple to rotate from here")]) : _c("p", { staticClass: "text-danger" }, [_vm._v("You must select at least one page to rotate")])], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "rotateDegreesGroups", label: "Rotation amount", "label-for": "rotateDegrees" } }, [_c("b-form-select", { attrs: { id: "rotateDegrees", options: _vm.rotateOptions, disabled: _vm.loading }, model: { value: _vm.rotateDegrees, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.rotateDegrees = $$v;
  }, "callback"), expression: "rotateDegrees" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("The degrees to rotate the page"), _vm.pageNumbers.length > 1 ? _c("span", [_vm._v("s")]) : _vm._e(), _vm._v(" by")])], 1)], 1) : _c("div", [_c("b-alert", { attrs: { variant: "warning", show: !0 } }, [_c("p", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" You cannot rotate pages from the selected item because it is not the subject file.")], 1), _vm._v(`
                                This can occur because the selected item...
                                `), _c("ul", [_c("li", [_vm._v("is not a PDF.")]), _vm._v(" "), _c("li", [_vm._v("is an attachment.")]), _vm._v(" "), _c("li", [_vm._v("was generated by a file converter.")])]), _vm._v(" "), _c("p", [_vm._v("Make sure you have select the item with a "), _c("font-awesome-icon", { attrs: { icon: "star" } }), _vm._v(" next to the name, that it is a PDF file and has not been generated by a processor.")], 1)])], 1)], 1)])]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("b-button", { attrs: { variant: "outline-secondary", disabled: _vm.loading }, on: { click: _vm.closeModal } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "primary", disabled: _vm.loading || !_vm.isSubjectFile || !_vm.pageNumbers.length }, on: { click: _vm.rotateDocumentPage } }, [_c("font-awesome-icon", { attrs: { icon: _vm.loading ? "sync" : "undo", flip: _vm.loading ? "" : "horizontal", spin: _vm.loading } }), _vm._v(" "), _vm.loading ? _c("span", [_vm._v("Rotating")]) : _c("span", [_vm._v("Rotate page"), _vm.pageNumbers.length > 1 ? _c("span", [_vm._v("s")]) : _vm._e()])], 1)], 1)])])])]);
}, "render"), _sfc_staticRenderFns$7 = [], __component__$7 = /* @__PURE__ */ normalizeComponent(
  ItemHistoryModal,
  _sfc_render$7,
  _sfc_staticRenderFns$7,
  !1,
  null,
  "35e95201"
);
const RotatePageModal = __component__$7.exports;
var __defProp$6 = Object.defineProperty, __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$6(target, key, result), result;
}, "__decorateClass$6"), _a5;
let ClaimLostModal$1 = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "$store");
    __publicField(this, "shouldShow");
    __publicField(this, "pageId");
  }
  mounted() {
    this.$watch("shouldShow", modalCommon.listenForShow(this.$el));
  }
  watchSort(oldVal, newVal) {
    this.$emit("sort", oldVal);
  }
  goToQueue() {
    let uri = new URL(baseUrl() + "/app/indexing/queues/" + this.$store.state.page.ria.queueId + "/list");
    window.location.href = uri.href;
  }
  closeModal() {
    this.$emit("close");
  }
}, __name(_a5, "ClaimLostModal"), _a5);
__decorateClass$6([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  }),
  Prop({
    required: !0
  })
], ClaimLostModal$1.prototype, "shouldShow", 2);
__decorateClass$6([
  Watch("sort")
], ClaimLostModal$1.prototype, "watchSort", 1);
ClaimLostModal$1 = __decorateClass$6([
  Component({
    components: {}
  })
], ClaimLostModal$1);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "modal fade", attrs: { tabindex: "-1", role: "dialog", "data-backdrop": "static", "data-keyboard": "false" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h4", { staticClass: "modal-title" }, [_c("font-awesome-icon", { staticClass: "warning", attrs: { icon: "exclamation-triangle" } }), _vm._v(` You do not have a claim on this item
                    `)], 1), _vm._v(" "), _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" }, on: { click: _vm.closeModal } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_c("p", [_vm._v("This means that someone else has already claimed it and may be working on the item.")]), _vm._v(" "), _c("p", [_vm._v("Continuing to work on this item may cause a conflict.")]), _vm._v(" "), _c("p", [_vm._v("What should I do?")]), _vm._v(" "), _c("ul", [_c("li", [_c("a", { staticClass: "btn btn-link", on: { click: _vm.goToQueue } }, [_vm._v("Go back to the list of items")])]), _vm._v(" "), _c("li", [_c("a", { staticClass: "btn btn-link", attrs: { "data-dismiss": "modal" }, on: { click: _vm.closeModal } }, [_vm._v("Continue anyway")])])])])])])])])])]);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  ClaimLostModal$1,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  "649d1072"
);
const ClaimLostModal = __component__$6.exports;
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$5"), _a6;
let ItemFailedActionModal$1 = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "item");
    __publicField(this, "failedAction", null);
    __publicField(this, "loading", !1);
  }
  async mounted() {
    await this.getFailedActionInfo();
  }
  get openUrl() {
    return new URL(baseUrl() + "/app/indexing/queues/" + this.failedAction.queueId + "/processing?processorId=" + this.failedAction.processorId).href;
  }
  closeModal() {
    this.$emit("close");
  }
  async getFailedActionInfo() {
    try {
      this.loading = !0, this.failedAction = await new IndexingClient(new Transformer(), baseUrl()).getItemFailedActionDetails(this.item.id);
    } catch {
    } finally {
      this.loading = !1;
    }
  }
}, __name(_a6, "ItemFailedActionModal"), _a6);
__decorateClass$5([
  Prop({
    required: !0
  })
], ItemFailedActionModal$1.prototype, "item", 2);
ItemFailedActionModal$1 = __decorateClass$5([
  Component({
    components: { DateDisplay }
  })
], ItemFailedActionModal$1);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { id: _vm.item.id + "failed-action-modal", size: "xl" }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h4", { staticClass: "modal-title" }, [_c("span", { staticClass: "text-danger" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } })], 1), _vm._v(" " + _vm._s(_vm.failedAction.actionName) + " Failed")])];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ cancel }) {
    return [_c("a", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-primary", attrs: { href: _vm.openUrl, target: "_blank", title: "View Processor" } }, [_c("font-awesome-icon", { attrs: { icon: "external-link-alt" } }), _vm._v(` 
          View Processor
      `)], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return cancel();
    }, "click") } }, [_vm._v(`
          Close
      `)])];
  }, "fn") }]) }, [_vm._v(" "), _vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _vm.failedAction ? _c("div", { attrs: { id: "failedNote" } }, [_c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" The action "), _c("b", [_vm._v("'" + _vm._s(_vm.failedAction.actionName) + "'")]), _vm._v(` has failed, please review the error log below.
    `)], 1), _vm._v(" "), _c("b", [_vm._v("Error Log")]), _vm._v(" "), _c("b-form-textarea", { attrs: { id: "failedActionLog", placeholder: "Auto height textarea", "max-rows": "15", rows: "3" }, model: { value: _vm.failedAction.errorLog, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.failedAction, "errorLog", $$v);
  }, "callback"), expression: "failedAction.errorLog" } })], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  ItemFailedActionModal$1,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  null
);
const ItemFailedActionModal = __component__$5.exports;
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$4"), _a7;
let UploadAttachmentModal$1 = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "itemId");
    __publicField(this, "loading", !1);
    __publicField(this, "errorMessage", null);
    __publicField(this, "uploadAttachmentFile", null);
  }
  modalShown() {
    this.uploadAttachmentFile = null;
  }
  async onFileChange(e) {
    let files = e.target.files || e.dataTransfer.files;
    if (!files.length)
      return;
    let newFile = files[0];
    this.uploadAttachmentFile = newFile;
  }
  get uploadAttachmentFileTypeWhiteList() {
    return this.$store.state.page.ria.pageDisplay.uploadAttachmentFileTypeWhitelist;
  }
  get allowedFileTypes() {
    return this.uploadAttachmentFileTypeWhiteList ? this.uploadAttachmentFileTypeWhiteList.map((v) => "." + v).join(", ") : "*";
  }
  async uploadAttachment() {
    this.errorMessage = null;
    try {
      this.loading = !0;
      let response = await new IndexingClient(new Transformer(), baseUrl()).uploadAttachment(
        this.itemId,
        { fileName: this.uploadAttachmentFile.name, data: this.uploadAttachmentFile }
      );
      response.success ? window.location.reload() : (this.errorMessage = response.response, this.loading = !1);
    } catch (ex) {
      toastr.warning(ex);
    }
  }
  async confirm() {
    await this.uploadAttachment();
  }
}, __name(_a7, "UploadAttachmentModal"), _a7);
__decorateClass$4([
  Prop({ required: !0 })
], UploadAttachmentModal$1.prototype, "itemId", 2);
UploadAttachmentModal$1 = __decorateClass$4([
  Component({})
], UploadAttachmentModal$1);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "upload-attachment-modal", title: "Upload Attachment", "no-close-on-backdrop": "", "cancel-variant": "" }, on: { show: _vm.modalShown }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
          Cancel
      `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "primary", disabled: !_vm.uploadAttachmentFile || _vm.loading }, on: { click: _vm.confirm } }, [_vm.loading ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: !0 } }), _vm._v(` Uploading...
          `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "upload" } }), _vm._v(` Upload
          `)], 1)])];
  }, "fn") }]) }, [_c("div", [_c("b-alert", { attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "exclamation-circle" } }), _vm._v(`
       The page will reload after uploading the attachment, any unsaved field changes will be lost.
      `)], 1), _vm._v(" "), _c("b-form-group", { attrs: { description: "Select the file to upload as an attachment" } }, [_c("b-form-file", { attrs: { placeholder: "Select a file to upload", id: "attachmentUpload", disabled: _vm.loading, "drop-placeholder": "Drop file here...", accept: _vm.allowedFileTypes }, on: { change: _vm.onFileChange }, model: { value: _vm.uploadAttachmentFile, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.uploadAttachmentFile = $$v;
  }, "callback"), expression: "uploadAttachmentFile" } })], 1), _vm._v(" "), _vm.errorMessage ? _c("b-alert", { attrs: { variant: "danger", show: !0 } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "exclamation-triangle" } }), _vm._v(`
        ` + _vm._s(_vm.errorMessage) + `
      `)], 1) : _vm._e()], 1)]);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  UploadAttachmentModal$1,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  null
);
const UploadAttachmentModal = __component__$4.exports;
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$3"), _a8;
let PdfThumbnailComponent = (_a8 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "page");
    __publicField(this, "deleted");
    __publicField(this, "thumbnailSize");
    __publicField(this, "canvasPrefixId");
    __publicField(this, "rotation");
    __publicField(this, "loadedThumbnail", !1);
    __publicField(this, "pageViewWidth", 0);
    __publicField(this, "pageViewHeight", 0);
    __publicField(this, "alteredScale", 0);
  }
  mounted() {
    this.setBaseCanvasSize(), this.lazyLoadThumbnails();
  }
  lazyLoadThumbnails() {
    lozad("#thumbnail-loader-" + this.page, {
      load: (async function() {
        this.loadedThumbnail == !1 && await this.loadThumbnail();
      }).bind(this)
    }).observe();
  }
  watchThumbnailSize() {
    this.setBaseCanvasSize(), this.loadedThumbnail == !0 && this.loadThumbnail();
  }
  setBaseCanvasSize() {
    const canvas = document.getElementById(this.canvasPrefixId + this.page);
    canvas.width = this.canvasWidthDimension, canvas.height = this.canvasDimension;
  }
  async loadThumbnail() {
    console.log("loading thumbnail page: " + this.page), this.loadedThumbnail = !1;
    const canvas = document.getElementById(this.canvasPrefixId + this.page), url = window[0].PDFViewerApplication.url, pdfPage = await (await window[0].pdfjsLib.getDocument({ url, ownerDocument: globalThis.document }).promise).getPage(this.page + 1);
    this.pageViewWidth = pdfPage.view[2], this.pageViewHeight = pdfPage.view[3];
    let viewport = {};
    if (this.thumbnailSize === "full") {
      let scale = this.thumbnailScale;
      viewport = pdfPage.getViewport({ scale }), canvas.width = viewport.width, canvas.height = viewport.height;
    } else {
      this.alteredScale = this.canvasDimension / this.pageViewHeight;
      let scale = this.alteredScale.toFixed(2);
      viewport = pdfPage.getViewport({ scale }), viewport.width > viewport.height ? (canvas.width = this.canvasDimension, canvas.height = this.canvasWidthDimension) : (canvas.width = this.canvasWidthDimension, canvas.height = this.canvasDimension);
    }
    const context = canvas.getContext("2d");
    return this.loadedThumbnail = !0, pdfPage.render({ canvasContext: context, viewport }).promise.then(function() {
      return canvas;
    });
  }
  get canvasDimension() {
    switch (this.thumbnailSize) {
      case "s":
        return 44;
      case "m":
        return 128;
      case "l":
        return 336;
      case "xl":
        return 442;
      default:
        return 128;
    }
  }
  get canvasWidthDimension() {
    switch (this.thumbnailSize) {
      case "s":
        return 29;
      case "m":
        return 89;
      case "l":
        return 238;
      case "xl":
        return 309;
      default:
        return 89;
    }
  }
  get thumbnailScale() {
    switch (this.thumbnailSize) {
      case "s":
        return 0.05;
      case "m":
        return 0.15;
      case "l":
        return 0.4;
      case "xl":
        return 0.52;
      case "full":
        return 1;
      default:
        return 0.15;
    }
  }
}, __name(_a8, "PdfThumbnailComponent"), _a8);
__decorateClass$3([
  Prop({ required: !0 })
], PdfThumbnailComponent.prototype, "page", 2);
__decorateClass$3([
  Prop({ required: !1, default: !1 })
], PdfThumbnailComponent.prototype, "deleted", 2);
__decorateClass$3([
  Prop({ required: !1, default: "md" })
], PdfThumbnailComponent.prototype, "thumbnailSize", 2);
__decorateClass$3([
  Prop({ required: !1, default: "canvas-" })
], PdfThumbnailComponent.prototype, "canvasPrefixId", 2);
__decorateClass$3([
  Prop()
], PdfThumbnailComponent.prototype, "rotation", 2);
__decorateClass$3([
  Watch("thumbnailSize")
], PdfThumbnailComponent.prototype, "watchThumbnailSize", 1);
PdfThumbnailComponent = __decorateClass$3([
  Component({ components: {} })
], PdfThumbnailComponent);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "field-handle pt-2 image-container", class: _vm.deleted ? "deletedPage" : "" }, [_vm.deleted ? _c("div", { staticClass: "centered text-danger" }, [_c("font-awesome-icon", { attrs: { size: _vm.thumbnailSize != "s" ? "2x" : "", icon: "trash" } })], 1) : _vm._e(), _vm._v(" "), !_vm.loadedThumbnail && !_vm.deleted ? _c("div", { staticClass: "centered text-primary", style: "width: " + _vm.canvasDimension + "px; height: " + _vm.canvasDimension + "px;", attrs: { id: "thumbnail-loader-" + _vm.page } }, [_c("div", { staticClass: "d-flex centered" }, [_c("div", { staticClass: "align-self-center" }, [_c("b-spinner")], 1)])]) : _vm._e(), _vm._v(" "), _c("div", { style: "width: " + _vm.canvasDimension + "px; height: " + _vm.canvasDimension + "px;" }, [_c("canvas", { staticClass: "img", class: "rotate" + _vm.rotation, attrs: { id: _vm.canvasPrefixId + _vm.page } })])])]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  PdfThumbnailComponent,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  "aacd073a"
);
const pdfThumbnail = __component__$3.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$2"), _a9;
let ImageThumbnailComponent = (_a9 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "pageNumber");
    __publicField(this, "rotated");
  }
}, __name(_a9, "ImageThumbnailComponent"), _a9);
__decorateClass$2([
  Prop({ required: !1, default: 1 })
], ImageThumbnailComponent.prototype, "pageNumber", 2);
__decorateClass$2([
  Prop({ required: !1, default: 0 })
], ImageThumbnailComponent.prototype, "rotated", 2);
ImageThumbnailComponent = __decorateClass$2([
  Component({ components: { PdfThumbnail: pdfThumbnail } })
], ImageThumbnailComponent);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("span", [_c("font-awesome-icon", { staticClass: "text-primary searchIcon", attrs: { id: "popover-target-" + _vm.pageNumber, icon: "search" } }), _vm._v(" "), _c("b-popover", { attrs: { target: "popover-target-" + _vm.pageNumber, triggers: "hover", placement: "right", "custom-class": "popover-invisible-background thumbnailPopover", container: "body" } }, [_c("pdf-thumbnail", { key: _vm.pageNumber, attrs: { "canvas-prefix-id": "popover-canvas", page: _vm.pageNumber - 1, thumbnailSize: "full", rotation: _vm.rotated } })], 1)], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  ImageThumbnailComponent,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "5002c115"
);
const ItemPageThumbnailComponent = __component__$2.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a10;
let EditPdfModal$1 = (_a10 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "shouldShow");
    __publicField(this, "item");
    __publicField(this, "startOnPageNumber");
    __publicField(this, "totalPages");
    __publicField(this, "isSubjectFile");
    __publicField(this, "pagesLoaded", 0);
    __publicField(this, "documentPages", []);
    __publicField(this, "loading", !1);
    __publicField(this, "loadingPages", !1);
    __publicField(this, "thumbnailSize", "m");
    __publicField(this, "metadata", this.$store.state.page.ria.viewer.splitCopyMetadataDefault);
  }
  async shouldShowWatch(showing) {
    showing && !this.documentPages.length && (this.pagesLoaded = 0, await this.loadPages());
  }
  async mounted() {
  }
  selectAllPages() {
    this.documentPages.filter((pageDoc) => pageDoc.selected).length === this.documentPages.length ? this.documentPages.map((docPage) => docPage.selected = !1) : this.documentPages.map((docPage) => docPage.selected = !0);
  }
  async loadPages() {
    this.loadingPages = !0;
    try {
      for (let page = 1; page < this.totalPages + 1; page++) {
        var documentPage = { id: v4(), originalIndex: page, newPageIndex: null, deleted: !1, rotated: 0, thumbnailUrl: null, isSplitPage: !1, selected: !1 };
        this.documentPages.push(documentPage);
      }
    } catch (ex) {
      console.error(ex);
    } finally {
      this.loadingPages = !1;
    }
  }
  movePage(event) {
    event.moved.element.newPageIndex = event.moved.newIndex + 1;
  }
  pageNumberFromSplit(index) {
    return index === 0 ? index + 1 : this.documentPages[index - 1].isSplitPage ? 1 : this.pageNumberFromSplit(index - 1) + 1;
  }
  get iconImgSizeOptions() {
    return [
      { value: "s", text: "Small" },
      { value: "m", text: "Medium" },
      { value: "l", text: "Large" },
      { value: "xl", text: "Extra Large" }
    ];
  }
  splitSelectedPages() {
    for (let i = 0; i < this.documentPages.length; i++) {
      let docPage = this.documentPages[i];
      docPage.selected && !docPage.isSplitPage && this.splitAfterPage(i);
    }
  }
  rotateSelected(rotateDirection) {
    this.documentPages.forEach((docPage) => {
      docPage.selected && (rotateDirection === "left" && this.rotateLeft(docPage), rotateDirection === "right" && this.rotateRight(docPage));
    });
  }
  async deleteSelected() {
    for (let i = 0; i < this.documentPages.length; i++) {
      let docPage = this.documentPages[i];
      docPage.selected && !docPage.isSplitPage ? docPage.deleted = !0 : docPage.selected && docPage.isSplitPage && this.deleteSplitPage(i);
    }
  }
  rotateLeft(page) {
    page.rotated === 0 ? page.rotated = 270 : page.rotated -= 90;
  }
  rotateRight(page) {
    page.rotated === 270 ? page.rotated = 0 : page.rotated += 90;
  }
  splitAfterPage(index) {
    this.documentPages.splice(index + 1, 0, { id: v4(), originalIndex: index + 1, newPageIndex: null, deleted: !1, rotated: 0, thumbnailUrl: "", isSplitPage: !0, selected: !1 });
  }
  deleteSplitPage(index) {
    this.documentPages.splice(index, 1);
  }
  close() {
    this.$emit("close");
  }
  get editPdfPayload() {
    let payload = { modifications: [], copyMetadata: this.metadata };
    return this.documentPages.forEach((docPage, index) => {
      if (!docPage.isSplitPage) {
        let modification = { originalPageNumber: docPage.originalIndex, moveTargetPageNumber: docPage.newPageIndex, rotateDegrees: docPage.rotated, action: [] };
        docPage.newPageIndex != null && modification.action.push(PdfModificationTypeModel.Move), docPage.deleted && modification.action.push(PdfModificationTypeModel.Delete), docPage.rotated != 0 && modification.action.push(PdfModificationTypeModel.Rotate), index != 0 && this.documentPages[index - 1].isSplitPage && modification.action.push(PdfModificationTypeModel.Split), modification.action.length && payload.modifications.push(modification);
      }
    }), payload;
  }
  editDocument() {
    this.loading = !0, this.$emit("processing", !0), bus$1.send("edit-pdf", this.editPdfPayload);
  }
}, __name(_a10, "EditPdfModal"), _a10);
__decorateClass$1([
  Prop({ required: !1, default: /* @__PURE__ */ __name(() => !1, "default") })
], EditPdfModal$1.prototype, "shouldShow", 2);
__decorateClass$1([
  Prop({ required: !0 })
], EditPdfModal$1.prototype, "item", 2);
__decorateClass$1([
  Prop({ required: !0, default: /* @__PURE__ */ __name(() => 0, "default") })
], EditPdfModal$1.prototype, "startOnPageNumber", 2);
__decorateClass$1([
  Prop({ required: !0, default: /* @__PURE__ */ __name(() => 0, "default") })
], EditPdfModal$1.prototype, "totalPages", 2);
__decorateClass$1([
  Prop({ required: !0, default: /* @__PURE__ */ __name(() => 0, "default") })
], EditPdfModal$1.prototype, "isSubjectFile", 2);
__decorateClass$1([
  Watch("shouldShow", { immediate: !0 })
], EditPdfModal$1.prototype, "shouldShowWatch", 1);
EditPdfModal$1 = __decorateClass$1([
  Component({ components: { ItemPageThumbnailComponent, draggable, pdfThumbnail } })
], EditPdfModal$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-modal", { attrs: { scrollable: "", "no-close-on-backdrop": "", "header-class": "display-block pb-2" }, scopedSlots: _vm._u([{ key: "modal-header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "modal-title" }, [_c("button", { staticClass: "close float-right", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return $event.stopPropagation(), _vm.close.apply(null, arguments);
    }, "click") } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]), _vm._v(" "), _c("font-awesome-icon", { attrs: { icon: "edit" } }), _vm._v(" "), _c("span", [_vm._v("Edit Document: "), _c("span", { staticClass: "text-muted" }, [_vm._v(_vm._s(_vm.item.name))])])], 1), _vm._v(" "), _c("hr", { staticClass: "row my-2" }), _vm._v(" "), _vm.documentPages ? _c("div", { staticClass: "w-100" }, [_c("b-button", { staticClass: "float-right", attrs: { size: "sm", variant: "outline-danger", disabled: !_vm.documentPages.filter((pageDoc) => pageDoc.selected).length || _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteSelected();
    }, "click") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "trash" } })], 1), _vm._v(" "), _c("b-form", { attrs: { inline: "" } }, [_c("b-input-group", { staticStyle: { "max-width": "130px" }, attrs: { size: "sm" }, scopedSlots: _vm._u([{ key: "prepend", fn: /* @__PURE__ */ __name(function() {
      return [_c("b-input-group-text", { staticClass: "pt-1 pb-0 pl-1 pr-0" }, [_c("b-form-checkbox", { attrs: { name: "selectAllPages", checked: _vm.documentPages.filter((pageDoc) => pageDoc.selected).length === _vm.documentPages.length, disabled: _vm.loading }, on: { change: _vm.selectAllPages } })], 1)];
    }, "fn"), proxy: !0 }], null, !1, 3489158281) }, [_vm._v(" "), _c("b-form-input", { attrs: { value: _vm.documentPages.filter((pageDoc) => pageDoc.selected).length + " selected", readonly: "", disabled: _vm.loading } })], 1), _vm._v(" "), _c("b-input-group", { staticClass: "ml-1", attrs: { size: "sm" }, scopedSlots: _vm._u([{ key: "prepend", fn: /* @__PURE__ */ __name(function() {
      return [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "image" } })], 1)];
    }, "fn"), proxy: !0 }], null, !1, 1946133822) }, [_vm._v(" "), _c("b-form-select", { attrs: { options: _vm.iconImgSizeOptions, disabled: _vm.loading }, model: { value: _vm.thumbnailSize, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.thumbnailSize = $$v;
    }, "callback"), expression: "thumbnailSize" } })], 1), _vm._v(" "), _c("b-button", { staticClass: "ml-1", attrs: { size: "sm", variant: "outline-secondary", disabled: !_vm.documentPages.filter((pageDoc) => pageDoc.selected).length || _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.rotateSelected("left");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "rotate-left" } })], 1), _vm._v(" "), _c("b-button", { staticClass: "ml-1", attrs: { size: "sm", variant: "outline-secondary", disabled: !_vm.documentPages.filter((pageDoc) => pageDoc.selected).length || _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.rotateSelected("right");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "rotate-right" } })], 1), _vm._v(" "), _c("b-button", { staticClass: "ml-1", attrs: { size: "sm", variant: "outline-secondary", disabled: !_vm.documentPages.filter((pageDoc) => pageDoc.selected).length || _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.splitSelectedPages();
    }, "click") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "file-dashed-line" } })], 1)], 1)], 1) : _vm._e()];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function() {
    return [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", disabled: _vm.loading }, on: { click: _vm.close } }, [_vm._v("Cancel")]), _vm._v(" "), _vm.isSubjectFile ? _c("button", { staticClass: "btn btn-success edit", attrs: { type: "button", disabled: _vm.loading, id: "editDocumentConfirm" }, on: { click: _vm.editDocument } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.loading, expression: "!loading" }] }, [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(" Save Document")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.loading, expression: "loading" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Saving Changes...")], 1)]) : _vm._e()];
  }, "fn"), proxy: !0 }]), model: { value: _vm.shouldShow, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.shouldShow = $$v;
  }, "callback"), expression: "shouldShow" } }, [_vm._v(" "), _vm.isSubjectFile ? _c("div", [_c("b-list-group", [_c("draggable", { attrs: { handle: ".field-handle", disable: _vm.loading }, on: { change: _vm.movePage }, model: { value: _vm.documentPages, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.documentPages = $$v;
  }, "callback"), expression: "documentPages" } }, _vm._l(_vm.documentPages, function(page, index) {
    return _c("b-list-group-item", { key: page.id, ref: "action", refInFor: !0, staticClass: "px-0", class: page.isSplitPage ? "bg-white" : "bg-light", attrs: { active: page.selected, disabled: _vm.loading }, on: { dblclick: /* @__PURE__ */ __name(function($event) {
      page.selected = !page.selected;
    }, "dblclick") } }, [page.isSplitPage ? _c("div", [_c("div", { staticClass: "d-flex justify-content-between font-weight-bold" }, [_c("div", { staticClass: "ml-2 pt-2" }, [_c("b-form-checkbox", { staticClass: "pt-1", attrs: { disabled: _vm.loading }, model: { value: page.selected, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(page, "selected", $$v);
    }, "callback"), expression: "page.selected" } })], 1), _vm._v(" "), _c("div", [_c("font-awesome-icon", { staticClass: "field-handle my-2 text-dark", attrs: { icon: "arrows-from-line", size: "2x" } })], 1), _vm._v(" "), _c("div", { staticClass: "pt-2" }, [_c("b-button", { staticClass: "mr-2", attrs: { size: "sm", variant: "outline-danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteSplitPage(index);
    }, "click"), dblclick: /* @__PURE__ */ __name(function($event) {
      $event.stopPropagation();
    }, "dblclick") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "trash" } })], 1)], 1)])]) : _c("span", [_c("div", { staticClass: "d-flex justify-content-between font-weight-bold" }, [_c("div", { staticClass: "ml-2 align-middle", staticStyle: { "min-width": "75px" } }, [_c("b-form-checkbox", { model: { value: page.selected, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(page, "selected", $$v);
    }, "callback"), expression: "page.selected" } })], 1), _vm._v(" "), _c("div", { staticClass: "text-dark" }, [_c("b-button", { staticClass: "mr-4", attrs: { size: "sm", variant: "outline-secondary", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.rotateLeft(page);
    }, "click"), dblclick: /* @__PURE__ */ __name(function($event) {
      $event.stopPropagation();
    }, "dblclick") } }, [_c("font-awesome-icon", { attrs: { icon: "rotate-left" } })], 1), _vm._v(`
                  Page ` + _vm._s(_vm.pageNumberFromSplit(index)) + `
                  `), _c("item-page-thumbnail-component", { key: page.originalIndex, attrs: { size: _vm.thumbnailSize, "page-number": page.originalIndex, rotated: page.rotated, id: page.originalIndex + "-" + _vm.item.id } }), _vm._v(" "), _c("b-button", { staticClass: "ml-4", attrs: { size: "sm", variant: "outline-secondary", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.rotateRight(page);
    }, "click"), dblclick: /* @__PURE__ */ __name(function($event) {
      $event.stopPropagation();
    }, "dblclick") } }, [_c("font-awesome-icon", { attrs: { icon: "rotate-right" } })], 1)], 1), _vm._v(" "), _c("div", { staticClass: "mr-2" }, [_c("b-button", { staticClass: "float-right", attrs: { size: "sm", variant: page.deleted ? "outline-info" : "outline-danger", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      page.deleted = !page.deleted;
    }, "click"), dblclick: /* @__PURE__ */ __name(function($event) {
      $event.stopPropagation();
    }, "dblclick") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: page.deleted ? "trash-slash" : "trash" } })], 1), _vm._v(" "), _c("b-button", { staticClass: "float-right mr-1", attrs: { size: "sm", variant: "outline-secondary", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.splitAfterPage(index);
    }, "click"), dblclick: /* @__PURE__ */ __name(function($event) {
      $event.stopPropagation();
    }, "dblclick") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "file-dashed-line" } })], 1)], 1)]), _vm._v(" "), _c("div", { staticClass: "d-flex justify-content-center" }, [_c("pdf-thumbnail", { key: page.originalIndex, attrs: { deleted: page.deleted, page: page.originalIndex - 1, rotation: page.rotated, thumbnailSize: _vm.thumbnailSize } })], 1)])]);
  }), 1)], 1)], 1) : _c("div", { staticClass: "alert alert-danger" }, [_c("p", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" You cannot edit the selected item because it is not the subject file.")], 1), _vm._v(`
      This can occur because the selected item...
      `), _c("ul", [_c("li", [_vm._v("is not a PDF.")]), _vm._v(" "), _c("li", [_vm._v("is an attachment.")]), _vm._v(" "), _c("li", [_vm._v("was generated by a file converter.")])]), _vm._v(" "), _c("p", [_vm._v("Make sure you have select the item with a "), _c("font-awesome-icon", { attrs: { icon: "star" } }), _vm._v(" next to the name, that it is a PDF file and has not been generated by a processor.")], 1)])])], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  EditPdfModal$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "9c9993c4"
);
const EditPdfModal = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a11;
let RiaViewerComponent = (_a11 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "$store");
    __publicField(this, "payload");
    __publicField(this, "showEditPdf", !1);
    __publicField(this, "showHistory", !1);
    __publicField(this, "showSplit", !1);
    __publicField(this, "showMovePage", !1);
    __publicField(this, "movePageNumber", 0);
    __publicField(this, "splitOnPageNumber", 0);
    __publicField(this, "startingPageNumber", 0);
    __publicField(this, "totalPages", 0);
    __publicField(this, "claimed", !0);
    __publicField(this, "editingPdfProcessing", !1);
    __publicField(this, "historyEvents", []);
    __publicField(this, "itemState", null);
    __publicField(this, "lastProcessor", null);
    __publicField(this, "iframeHeightStyle", null);
    __publicField(this, "showDeletePage", !1);
    __publicField(this, "deletePageNumber", 0);
    __publicField(this, "showRotatePage", !1);
    __publicField(this, "rotatePageNumber", 0);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "initialised");
    __publicField(this, "files");
    __publicField(this, "name");
    __publicField(this, "expanded", !1);
  }
  mounted() {
    this.$store.dispatch(Keys.actions.INITIALISE, JSON.parse(_.unescape(this.payload))).then(() => {
      this.resetNotesHeight(), this.getLastProcessorEvent(), this.changeContent(this.contents.find((_2) => !0)), this.itemState = this.$store.state.page.ria.itemState, new IndexingClient(new Transformer(), baseUrl()).getItemHistory(this.item.id).then((data) => {
        this.historyEvents = data.events.sort((a, b) => new Date(a.timestamp).getTime() - new Date(b.timestamp).getTime()).reverse();
      });
    }), this.reloadTimer = setInterval(this.pollTemporaryClaim, 1e4);
    let $this = this, eventMethod = window.addEventListener ? "addEventListener" : "attachEvent", eventer = window[eventMethod], messageEvent = eventMethod == "attachEvent" ? "onmessage" : "message";
    eventer(messageEvent, (function(e) {
      try {
        if (typeof e.data == "string") {
          this.$store.dispatch("GLOBAL_POPULATE_GRID");
          let splitData = e.data.split("|");
          splitData[0] === "EditDocument" && ($this.showEditPdf = !0, $this.startingPageNumber = parseInt(splitData[1]), $this.totalPages = parseInt(splitData[2])), splitData[0] === "SplitDocument" && ($this.splitOnPageNumber = parseInt(splitData[1]), $this.splitOnPageNumber < 2 && ($this.splitOnPageNumber = 2), $this.totalPages = parseInt(splitData[2]), $this.splitOnPageNumber > $this.totalPages && ($this.splitOnPageNumber = $this.totalPages - 1), $this.showSplit = !0), splitData[0] === "DeletePage" && ($this.deletePageNumber = parseInt(splitData[1]), $this.totalPages = parseInt(splitData[2]), $this.showDeletePage = !0), splitData[0] === "RotatePage" && ($this.rotatePageNumber = parseInt(splitData[1]), $this.totalPages = parseInt(splitData[2]), $this.showRotatePage = !0), splitData[0] === "MovePage" && ($this.movePageNumber = parseInt(splitData[1]), $this.totalPages = parseInt(splitData[2]), $this.showMovePage = !0);
        }
      } catch (err) {
        console.debug(err);
      }
    }).bind(this), !1);
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
  watchItemState() {
    this.$nextTick(function() {
      this.setIframeHeightStyle();
    });
  }
  watchItemNotes() {
    this.resetNotesHeight();
  }
  itemNoteDismissed() {
    this.resetNotesHeight();
  }
  resetNotesHeight() {
    let $this = this;
    this.$nextTick(function() {
      setTimeout(function() {
        $this.setIframeHeightStyle();
      }, 150);
    });
  }
  setIframeHeightStyle() {
    let height = 0;
    this.$refs.noteBox && (height += this.$refs.noteBox.clientHeight + 1), this.$refs.claimedBox && (height += this.$refs.claimedBox.clientHeight + 1), this.$refs.infoBox && this.$refs.claimedBox && (height = height + 1), this.iframeHeightStyle = "height: calc(100% - " + height + "px);";
  }
  get notes() {
    if (this.item)
      return this.item.notes;
  }
  htmlDecode(str) {
    return new DOMParser().parseFromString(str, "text/html").documentElement.textContent;
  }
  getLastProcessorEvent() {
    if (this.item.processors) {
      var orderedProcessors = this.item.processors.sort(function(a, b) {
        return new Date(b.started) - new Date(a.started);
      });
      this.lastProcessor = orderedProcessors.find((r) => !0);
    }
  }
  queueName(queue) {
    return getQueueName(queue);
  }
  pageUrl() {
    return new URL(baseUrl() + "/app/indexing/pages/" + this.$store.state.page.ria.list.page.id + "/defaultQueue/").href;
  }
  queueUrl() {
    return new URL(baseUrl() + "/app/indexing/queues/" + this.$store.state.page.ria.list.queue.id + "/list#/").href;
  }
  previousItemUrl() {
    var queueId = this.$store.state.page.ria.list.queue.id, previousQueueId = this.$store.state.page.ria.sourceQueueId;
    previousQueueId && (queueId = previousQueueId);
    let url = new URL(baseUrl() + "/app/indexing/items/" + this.item.id + "/" + queueId + "/previous");
    return this.$store.state.page.ria.filter && url.searchParams.set("filter", this.$store.state.page.ria.filter), url.href;
  }
  nextItemUrl() {
    var queueId = this.$store.state.page.ria.list.queue.id, previousQueueId = this.$store.state.page.ria.sourceQueueId;
    previousQueueId && (queueId = previousQueueId);
    let url = new URL(baseUrl() + "/app/indexing/items/" + this.item.id + "/" + queueId + "/next");
    return this.$store.state.page.ria.filter && url.searchParams.set("filter", this.$store.state.page.ria.filter), url.href;
  }
  get showDownloadFile() {
    return this.$store.state.page.ria.pageDisplay.canDownload;
  }
  get showUploadAttachment() {
    return this.$store.state.page.ria.pageDisplay.canUpload;
  }
  downloadFile() {
    let downloadUrl = this.currentFile.src, anchor = document.createElement("a");
    anchor.href = downloadUrl, anchor.download = this.currentFile.file.name, document.body.appendChild(anchor), anchor.click(), anchor.remove();
  }
  changeSelected(fileId) {
    this.$store.dispatch(Keys.actions.SELECT_FILE, fileId);
  }
  get objectViewer() {
    return `<object id='objectViewer' class='objectViewer'
                            data='` + this.currentFile.src + `'
                            type='` + this.currentFile.mime + `'
                            style='width:95vw;height:95vh;object-fit: scale-down;` + this.imageRotation + `'
                            <p>It seems you can't view the file within the browser. 
                            <a href='` + this.currentFile.src + "' download='" + this.currentFile.file.name + `'>Click here to download the file.</a>
                            </p>
                        </object>`;
  }
  pollTemporaryClaim() {
    this.editingPdfProcessing || this.$store.dispatch("indexing/items/claim", this.item.id).then(() => {
      this.claimed = !0;
    }).catch(() => {
      this.claimed = !1;
    });
  }
  expand(expand = !0) {
    this.expanded = expand;
  }
  getIcon(type) {
    switch (type) {
      case "subject":
        return "star";
      case "attachment":
        return "paperclip";
      case "artefact":
        return "gift";
      case "preview":
        return "eye";
      default:
        return "";
    }
  }
  includeAll() {
    this.$store.dispatch(Keys.actions.INCLUDE_ALL);
  }
  excludeAll() {
    this.$store.dispatch(Keys.actions.EXCLUDE_ALL);
  }
  includeFile(file) {
    file.include ? this.$store.dispatch(Keys.actions.EXCLUDE_FILE, file.id) : this.$store.dispatch(Keys.actions.INCLUDE_FILE, file.id);
  }
  get item() {
    return this.$store.state.page.ria.item ? this.$store.state.page.ria.item : null;
  }
  get currentFile() {
    if (!this.$store.state.page.ria.selectedFile)
      return null;
    const file = this.$store.getters[Keys.getters.FILE](this.$store.state.page.ria.selectedFile);
    return file ? {
      error: file.loading instanceof Error ? file.loading : null,
      loading: typeof file.loading == "number" ? file.loading : null,
      mime: file.data && file.data.type,
      src: file && file.data ? URL.createObjectURL(file.data) : null,
      file,
      exif: file.exif,
      parent: file.parent
    } : null;
  }
  get isPdfFile() {
    return this.currentFile.mime == "application/pdf";
  }
  get exif() {
    if (this.currentFile)
      return this.currentFile.exif;
  }
  get allowInclude() {
    return this.$store.state.page.ria.viewer.canInclude;
  }
  get viewerData() {
    return JSON.stringify(
      {
        include: this.files.map((f) => ({
          id: f.id,
          include: f.include
        }))
      }
    );
  }
  get contents() {
    const contentItems = this.files.filter((f) => f.type != "preview").map((f) => {
      let previews = this.getPreviews(f);
      return {
        id: f.id,
        name: f.name,
        previews,
        subject: f,
        type: f.type,
        selected: this.contentIsSelected(f, previews),
        include: this.contentInclude(f, previews),
        parent: f.parent
      };
    }), structuredContentItems = this.assignChildren(contentItems);
    let level = 0;
    return structuredContentItems.forEach((x) => this.assignLevelsRecursive(x, level)), this.flattenContentItems(structuredContentItems);
  }
  flattenContentItems(rootItems) {
    const result = [];
    function traverseItem(item) {
      result.push(item), item.children && item.children.length > 0 && item.children.sort((a, b) => {
        var _a12, _b;
        return ((_a12 = a == null ? void 0 : a.children) == null ? void 0 : _a12.length) ?? 0 - ((_b = b == null ? void 0 : b.children) == null ? void 0 : _b.length) ?? 0;
      }).forEach(traverseItem);
    }
    return __name(traverseItem, "traverseItem"), rootItems.forEach((x) => traverseItem(x)), result;
  }
  assignLevelsRecursive(contentItem, level) {
    contentItem.level = level, contentItem.children && contentItem.children.length > 0 && (level++, contentItem.children = contentItem.children.map((x) => (this.assignLevelsRecursive(x, level), x)));
  }
  assignChildren(contentItems) {
    const roots = contentItems.filter((x) => !x.parent);
    function core(item) {
      const children = contentItems.filter((x) => x.parent == item.id);
      children.length && (item.children = children, item.children.forEach(core));
    }
    return __name(core, "core"), roots.forEach(core), roots;
  }
  calculateLeftPadding(contentItem) {
    return `${20 + contentItem.level * 15}px`;
  }
  get selected() {
    return this.contents.find((c) => c.selected);
  }
  contentIsSelected(file, previews) {
    return this.currentFile ? this.currentFile.file == file || previews && previews.includes(this.currentFile.file) : !1;
  }
  contentInclude(file, previews) {
    return previews && previews.length > 0 ? previews.every((p) => p.include) && file.include ? "all" : this.getPreviews(file).every((value) => !value.include) && !file.include ? "none" : "partial" : file.include ? "all" : "none";
  }
  getPreviews(file) {
    let previews = this.files.filter((f) => f.type == "preview" && f.parent == file.id);
    return previews && previews.length > 0 ? [...previews, file] : null;
  }
  changeContent(item) {
    item.previews && item.previews.length > 0 ? this.changeSelected(item.previews.find(() => !0).id) : this.changeSelected(item.subject.id);
  }
  get pdfJsViewer() {
    const rawBaseUrl = baseUrl(), buildVersion = this.$store.state.page.ria.viewer.buildVersion, pdfJSViewer = "/content/pdfjs/web/viewer.html";
    let file = "?file=" + this.currentFile.src, viewerSettings = "#zoom=" + this.$store.state.page.ria.viewer.pdfViewerZoom + "&pagemode=" + this.$store.state.page.ria.viewer.pdfSidebar, canEdit = "&edit=" + this.$store.state.page.ria.viewer.canEdit, canSplit = "&split=" + this.$store.state.page.ria.viewer.canSplit, canMove = "&move=" + this.$store.state.page.ria.viewer.canMove, canDelete = "&delete=" + this.$store.state.page.ria.viewer.canDelete, canRotate = "&rotate=" + this.$store.state.page.ria.viewer.canRotate, pageNumber = "&page=" + this.$store.state.page.ria.viewer.pageNumber;
    return rawBaseUrl.concat("/", buildVersion, pdfJSViewer, file, viewerSettings, pageNumber, canSplit, canDelete, canRotate, canMove, canEdit);
  }
  get singleFile() {
    return this.contents.length == 1;
  }
  get imageRotation() {
    if (this.currentFile.exif && this.currentFile.exif.Orientation)
      switch (this.currentFile.exif.Orientation) {
        case 3:
          return "transform:rotate(180deg)";
        case 6:
          return "transform:rotate(90deg)";
        case 8:
          return "transform:rotate(270deg)";
      }
    return "";
  }
  toggleContent(item) {
    item.include == "none" ? item.previews ? item.previews.forEach((p) => this.$store.dispatch(Keys.actions.INCLUDE_FILE, p.id)) : this.$store.dispatch(Keys.actions.INCLUDE_FILE, item.id) : item.previews ? item.previews.forEach((p) => this.$store.dispatch(Keys.actions.EXCLUDE_FILE, p.id)) : this.$store.dispatch(Keys.actions.EXCLUDE_FILE, item.id);
  }
}, __name(_a11, "RiaViewerComponent"), _a11);
__decorateClass([
  Prop({
    required: !0
  })
], RiaViewerComponent.prototype, "payload", 2);
__decorateClass([
  Watch("itemState")
], RiaViewerComponent.prototype, "watchItemState", 1);
__decorateClass([
  Watch("notes")
], RiaViewerComponent.prototype, "watchItemNotes", 1);
__decorateClass([
  Getter(Keys.getters.HAS_INITIALISED)
], RiaViewerComponent.prototype, "initialised", 2);
__decorateClass([
  Getter(Keys.getters.FILES)
], RiaViewerComponent.prototype, "files", 2);
__decorateClass([
  State((state) => state.page.ria && state.page.ria.item && state.page.ria.item.name || null)
], RiaViewerComponent.prototype, "name", 2);
RiaViewerComponent = __decorateClass([
  Component({
    components: {
      error: ErrorPanel,
      ItemHistoryModal: ItemHistoryModal$2,
      ClaimLostModal,
      DateDisplay,
      SplitItemModal,
      ItemNoteAlert,
      ItemNoteModal,
      DeletePageModal,
      RotatePageModal,
      ItemFailedActionModal,
      MovePageModal,
      EditPdfModal,
      UploadAttachmentModal
    },
    filters: {
      getExtension: /* @__PURE__ */ __name((input) => input.substr(input.lastIndexOf(".")), "getExtension")
    }
  })
], RiaViewerComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("span", [_c("b-skeleton-wrapper", { attrs: { loading: !_vm.item }, scopedSlots: _vm._u([{ key: "loading", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-card", { staticClass: "vh-100", attrs: { "no-body": "" } }, [_c("b-card-body", { staticClass: "d-flex" }, [_c("div", { staticClass: "text-center text-primary my-auto mx-auto" }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v("Loading...")])], 1)])], 1)];
  }, "fn"), proxy: !0 }]) }), _vm._v(" "), _vm.item && _vm.currentFile ? _c("div", { staticClass: "row h-100" }, [_c("edit-pdf-modal", { attrs: { item: _vm.item, shouldShow: _vm.showEditPdf, "start-on-page-number": _vm.startingPageNumber, "total-pages": _vm.totalPages, isSubjectFile: this.currentFile.file.type === "subject" && this.selected.type === "subject" }, on: { processing: /* @__PURE__ */ __name(function($event) {
    _vm.editingPdfProcessing = !0;
  }, "processing"), close: /* @__PURE__ */ __name(function($event) {
    _vm.showEditPdf = !1;
  }, "close") } }), _vm._v(" "), _c("split-item-modal", { attrs: { item: _vm.item, shouldShow: _vm.showSplit, splitOnPageNumber: _vm.splitOnPageNumber, totalPages: _vm.totalPages, isSubjectFile: this.currentFile.file.type === "subject" && this.selected.type === "subject" }, on: { close: /* @__PURE__ */ __name(function($event) {
    _vm.showSplit = !1;
  }, "close") } }), _vm._v(" "), _c("delete-page-modal", { attrs: { item: _vm.item, shouldShow: _vm.showDeletePage, deletePageNumber: _vm.deletePageNumber, isSubjectFile: this.currentFile.file.type === "subject" && this.selected.type === "subject", totalPages: _vm.totalPages }, on: { close: /* @__PURE__ */ __name(function($event) {
    _vm.showDeletePage = !1;
  }, "close") } }), _vm._v(" "), _c("rotate-page-modal", { attrs: { item: _vm.item, shouldShow: _vm.showRotatePage, rotatePageNumber: _vm.rotatePageNumber, totalPages: _vm.totalPages, isSubjectFile: this.currentFile.file.type === "subject" && this.selected.type === "subject" }, on: { close: /* @__PURE__ */ __name(function($event) {
    _vm.showRotatePage = !1;
  }, "close") } }), _vm._v(" "), _c("move-page-modal", { attrs: { item: _vm.item, shouldShow: _vm.showMovePage, movePageNumber: _vm.movePageNumber, totalPages: _vm.totalPages, isSubjectFile: this.currentFile.file.type === "subject" && this.selected.type === "subject" }, on: { close: /* @__PURE__ */ __name(function($event) {
    _vm.showMovePage = !1;
  }, "close") } }), _vm._v(" "), _c("item-history-modal", { attrs: { item: _vm.item, shouldShow: _vm.showHistory, events: _vm.historyEvents }, on: { close: /* @__PURE__ */ __name(function($event) {
    _vm.showHistory = !1;
  }, "close") } }), _vm._v(" "), _c("upload-attachment-modal", { attrs: { itemId: _vm.item.id } }), _vm._v(" "), _c("item-note-modal", { attrs: { item: _vm.item, "parse-title-and-message": !0 } }), _vm._v(" "), _c("item-failed-action-modal", { attrs: { item: _vm.item } }), _vm._v(" "), _c("claim-lost-modal", { attrs: { shouldShow: !_vm.claimed } }), _vm._v(" "), _vm.singleFile ? _vm._e() : _c("div", { directives: [{ name: "show", rawName: "v-show", value: !_vm.expanded, expression: "!expanded" }], staticClass: "col-sm-12 col-lg-3 mb-1" }, [_vm.allowInclude ? _c("div", { staticClass: "form-group" }, [this.files.filter((value) => value.include).length === this.files.length ? _c("b-button", { attrs: { variant: "link" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.excludeAll();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "square" } }), _vm._v(` Uncheck All
      `)], 1) : _c("b-button", { attrs: { variant: "link" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.includeAll();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "check-square" } }), _vm._v(` Check All
      `)], 1)], 1) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "list-group word-wrap", attrs: { id: "fileList" } }, _vm._l(_vm.contents, function(item) {
    return _c("button", { key: item.id, staticClass: "list-group-item list-group-item-action", class: { active: item.selected }, style: { "padding-left": _vm.calculateLeftPadding(item) }, attrs: { type: "button", id: item.id, onclick: "return false;" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.changeContent(item);
    }, "click") } }, [_vm.allowInclude ? _c("input", { attrs: { type: "checkbox" }, domProps: { checked: item.include === "all", indeterminate: item.include === "partial" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return $event.stopPropagation(), _vm.toggleContent(item);
    }, "click") } }) : _vm._e(), _vm._v(" "), _c("font-awesome-icon", { attrs: { icon: _vm.getIcon(item.type) } }), _vm._v(" "), _c("span", { staticClass: "float-right" }, [item.previews && item.previews.length > 0 ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "eye" } })], 1) : _vm._e(), _vm._v(" "), _vm.currentFile && item.subject.id === _vm.currentFile.file.parent ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "code-branch" } })], 1) : _vm._e()]), _vm._v(" "), _c("span", [_vm._v(_vm._s(item && item.name))])], 1);
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "col h-100" }, [_c("div", { staticClass: "card h-100" }, [_c("div", { staticClass: "card-header p-0 clearfix" }, [_c("span", { staticClass: "card-header-text" }, [_c("nav", { attrs: { "aria-label": "breadcrumb d-flex justify-content-between" } }, [_c("ol", { staticClass: "breadcrumb" }, [_c("li", { staticClass: "breadcrumb-item panel-front-text-trim" }, [_c("a", { attrs: { href: _vm.pageUrl() } }, [_vm._v(_vm._s(this.$store.state.page.ria.list.page.name))])]), _vm._v(" "), _c("li", { staticClass: "breadcrumb-item panel-front-text-trim" }, [_c("a", { attrs: { href: _vm.queueUrl() } }, [_vm._v(_vm._s(_vm.queueName(this.$store.state.page.ria.list.queue)))])]), _vm._v(" "), _c("li", { staticClass: "breadcrumb-item active panel-front-text-trim", attrs: { "aria-current": "page" } }, [_c("span", { domProps: { innerHTML: _vm._s(_vm.name) } })]), _vm._v(" "), _c("li", { staticClass: "ml-auto" }, [_vm.currentFile && _vm.item.latestActionFailed ? _c("b-button", { attrs: { size: "sm", id: "failedActionBtn", variant: "danger", title: "Failed Action" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.$bvModal.show(_vm.item.id + "failed-action-modal");
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "triangle-exclamation" } })], 1) : _vm._e(), _vm._v(" "), _vm.currentFile && _vm.showDownloadFile ? _c("b-button", { staticClass: "btn-default", attrs: { size: "sm", id: "download-btn", title: "Download File" }, on: { click: _vm.downloadFile } }, [_c("font-awesome-icon", { attrs: { icon: "download" } })], 1) : _vm._e(), _vm._v(" "), _vm.showUploadAttachment ? _c("b-button", { staticClass: "btn-default", attrs: { size: "sm", id: "upload-attachment-btn", title: "Upload Attachment" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.$bvModal.show("upload-attachment-modal");
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "upload" } })], 1) : _vm._e(), _vm._v(" "), _vm.currentFile ? _c("b-button", { staticClass: "btn-default", attrs: { size: "sm", id: "previous-btn", title: "Previous item in queue", href: _vm.previousItemUrl() } }, [_c("font-awesome-icon", { attrs: { icon: "arrow-left" } })], 1) : _vm._e(), _vm._v(" "), _vm.currentFile ? _c("b-button", { staticClass: "btn-default", attrs: { size: "sm", id: "next-btn", title: "Next item in queue", href: _vm.nextItemUrl() } }, [_c("font-awesome-icon", { attrs: { icon: "arrow-right" } })], 1) : _vm._e(), _vm._v(" "), _vm.currentFile ? _c("b-button", { staticClass: "btn-default", attrs: { size: "sm", id: "show-btn", title: "Notes" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.$bvModal.show(_vm.item.id + "notes-modal");
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sticky-note" } }), _vm._v(" "), _vm.notes && _vm.notes.length > 0 ? _c("b-badge", { attrs: { variant: "light" } }, [_vm._v(_vm._s(_vm.notes.length))]) : _vm._e()], 1) : _vm._e(), _vm._v(" "), _vm.currentFile ? _c("button", { staticClass: "btn btn-sm btn-default", attrs: { title: "Show history", type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.showHistory = !0;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "history" } })], 1) : _vm._e(), _vm._v(" "), _vm.selected && _vm.selected.previews && _vm.selected.previews.length > 1 ? _c("span", { staticClass: "dropdown" }, [_c("button", { staticClass: "btn btn-default btn-sm dropdown-toggle", attrs: { type: "button", "data-toggle": "dropdown" } }, [_c("span", { staticClass: "caret" }), _vm._v(" "), _vm.currentFile.file.type == "subject" ? _c("span", [_vm._v(`
                              Subject
                          `)]) : _vm.currentFile.file.type == "preview" ? _c("span", [_vm._v(`
                              Artefact
                          `)]) : _vm._e(), _vm._v(`
                          (` + _vm._s(_vm._f("getExtension")(_vm.currentFile.file.name)) + `)
                      `)]), _vm._v(" "), _c("ul", { staticClass: "dropdown-menu" }, _vm._l(_vm.selected.previews, function(preview) {
    return _c("li", { key: preview.id }, [_c("a", { staticClass: "dropdown-item", attrs: { role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.changeSelected(preview.id);
    }, "click") } }, [_vm.allowInclude ? _c("input", { attrs: { type: "checkbox" }, domProps: { checked: preview.include }, on: { click: /* @__PURE__ */ __name(function($event) {
      return $event.stopPropagation(), _vm.includeFile(preview);
    }, "click") } }) : _vm._e(), _vm._v(" "), preview.type == "subject" ? _c("span", [_vm._v(`
                                      Subject (` + _vm._s(_vm._f("getExtension")(preview.name)) + `)
                                  `)]) : _c("span", [_vm._v(`
                                      Artefact (` + _vm._s(_vm._f("getExtension")(preview.name)) + `)
                                  `)])])]);
  }), 0)]) : _vm._e(), _vm._v(" "), _vm.singleFile ? _vm._e() : _c("button", { staticClass: "btn btn-default btn-sm", attrs: { type: "button", title: "Show or hide the bundled files" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.expand(!_vm.expanded);
  }, "click") } }, [_vm.expanded ? _c("font-awesome-icon", { attrs: { icon: "eye" } }) : _vm._e(), _vm._v(" "), _vm.expanded ? _vm._e() : _c("font-awesome-icon", { attrs: { icon: "eye-slash" } })], 1)], 1)])])])]), _vm._v(" "), _c("div", { staticClass: "card-body p-0 h-100" }, [_vm.itemState ? _c("div", { ref: "claimedBox", staticClass: "alert alert-warning alert-dismissible mb-0 py-2", attrs: { role: "alert" } }, [_c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "alert", "aria-label": "Close" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.itemState = null;
  }, "click") } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]), _vm._v(" "), _c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" "), _c("strong", [_vm._v(" This item is being processed by another user")]), _vm._v(" "), _c("p", { staticClass: "mb-0" }, [_vm._v(_vm._s(_vm.htmlDecode(_vm.itemState.message)))])], 1) : _vm._e(), _vm._v(" "), _vm.item && _vm.notes ? _c("div", { ref: "noteBox" }, [_c("item-note-alert", { attrs: { id: "itemNoteBox", "item-id": _vm.item.id, value: _vm.notes, "parse-title-and-message": !0 }, on: { openNotesModal: /* @__PURE__ */ __name(function($event) {
    return _vm.$bvModal.show(_vm.item.id + "notes-modal");
  }, "openNotesModal"), alertDismissed: /* @__PURE__ */ __name(function($event) {
    return _vm.itemNoteDismissed();
  }, "alertDismissed") } })], 1) : _vm._e(), _vm._v(" "), _vm.lastProcessor && _vm.lastProcessor.status === "failed" ? _c("div", { staticClass: "alert alert-danger alert-dismissible", attrs: { role: "alert" } }, [_vm._m(0), _vm._v(" "), _c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" "), _c("strong", [_vm._v(`This item failed
            processing`)]), _vm._v(" "), _c("br"), _vm._v(`
            ` + _vm._s(_vm.$options.filters.toHumanReadableDateTime(_vm.lastProcessor.finished)) + `
            `), _c("p", [_vm._v("This item previously failed, please check the fields and try again.")])], 1) : _vm._e(), _vm._v(" "), _c("b-skeleton-wrapper", { attrs: { loading: _vm.currentFile && _vm.currentFile.loading !== null }, scopedSlots: _vm._u([{ key: "loading", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-card", { staticClass: "vh-100", attrs: { "no-body": "" } }, [_c("b-card-body", { staticClass: "d-flex" }, [_c("div", { staticClass: "text-center text-primary my-auto mx-auto", attrs: { id: "riaViewerLoading" } }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v("Loading...")])], 1)])], 1)];
  }, "fn"), proxy: !0 }], null, !1, 2395887681) }), _vm._v(" "), _c("div", { staticClass: "embed-responsive embed-responsive-16by9", style: _vm.iframeHeightStyle }, [_vm.currentFile && _vm.currentFile.error ? _c("div", [_c("error", { attrs: { error: _vm.currentFile.error } })], 1) : _vm._e(), _vm._v(" "), _vm.currentFile && !_vm.currentFile.loading && _vm.currentFile.src ? [_vm.isPdfFile ? _c("iframe", { staticClass: "pdfViewer", attrs: { id: "pdfViewer", src: _vm.pdfJsViewer } }) : _c("div", [_c("iframe", { staticStyle: { "object-fit": "scale-down" }, attrs: { sandbox: "allow-same-origin allow-downloads", srcdoc: _vm.objectViewer } })])] : _vm._e()], 2)], 1)])]), _vm._v(" "), _c("input", { attrs: { type: "hidden", id: "data.viewer", name: "data.viewer" }, domProps: { value: _vm.viewerData } })], 1) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "alert", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}], __component__ = /* @__PURE__ */ normalizeComponent(
  RiaViewerComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  null
);
const riaViewer = __component__.exports;
export {
  riaViewer as default
};
