var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, cw as AccountClient, T as Transformer, b as baseUrl, cx as Keys, C as Component, N as CheckIcon, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { P as PasswordComplexityRules } from "./passwordComplexityRules-BxrFfrmN.js";
import { H as HourPicker } from "./hourPicker-B5b_o7dz.js";
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a;
let ProfileSummaryRoute = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "localUserChangePasswordRequest", { currentPassword: "", newPassword: "" });
    __publicField(this, "changePasswordRequestConfirmPassword", "");
    __publicField(this, "changePasswordLoading", !1);
    __publicField(this, "enforcedPasswords", !1);
    __publicField(this, "digestEnabled", !1);
    __publicField(this, "intraySummaryEnabled", !1);
    __publicField(this, "errors");
    __publicField(this, "homepageOptions", [
      { value: "Index", text: "Index" },
      { value: "Intray", text: "Intray" }
    ]);
  }
  async mounted() {
    this.enforcePasswordComplexityRules = await new AccountClient(new Transformer(), baseUrl()).getEnforcePasswordComplexityRules(), this.digestEnabled = await new AccountClient(new Transformer(), baseUrl()).getDigestEnabled(), this.intraySummaryEnabled = await new AccountClient(new Transformer(), baseUrl()).getIntraySummaryEnabled();
  }
  validatePasswordState(ref) {
    return this.veeFields[ref] && (this.veeFields[ref].dirty || this.veeFields[ref].validated) && this.$validator.errors.has(ref) ? !1 : null;
  }
  validateState(ref) {
    return this.veeFields[ref] && (this.veeFields[ref].dirty || this.veeFields[ref].validated) ? !this.errors.has(ref) : null;
  }
  created() {
    this.$store.dispatch(Keys.actions.REFRESH_PROFILE);
  }
  get loaded() {
    return this.$store.state.account.profile.user !== null;
  }
  get loading() {
    return this.$store.state.account.profile.loading;
  }
  get user() {
    return this.$store.state.account.profile.user;
  }
  get changePasswordRequest() {
    return this.localUserChangePasswordRequest;
  }
  set changePasswordRequest(value) {
    this.localUserChangePasswordRequest = value;
  }
  get currentPassword() {
    return this.changePasswordRequest.currentPassword;
  }
  set currentPassword(value) {
    this.changePasswordRequest.currentPassword = value;
  }
  get currentDigestTime() {
    return this.user.digestTime;
  }
  get currentIntrayTime() {
    return this.user.intrayTime;
  }
  get currentIntrayDays() {
    return this.user.intrayDays ?? [];
  }
  set currentIntrayDays(value) {
    this.user.intrayDays = value, this.changeIntrayDays(value);
  }
  get currentHomepage() {
    return this.user.homepage;
  }
  get newPassword() {
    return this.changePasswordRequest.newPassword;
  }
  set newPassword(value) {
    this.changePasswordRequest.newPassword = value;
  }
  get confirmNewPassword() {
    return this.changePasswordRequestConfirmPassword;
  }
  set confirmNewPassword(value) {
    this.changePasswordRequestConfirmPassword = value;
  }
  get enforcePasswordComplexityRules() {
    return this.enforcedPasswords;
  }
  set enforcePasswordComplexityRules(value) {
    this.enforcedPasswords = value;
  }
  get daysOfTheWeek() {
    return [{ number: "1", name: "Monday" }, { number: "2", name: "Tuesday" }, { number: "3", name: "Wednesday" }, { number: "4", name: "Thursday" }, { number: "5", name: "Friday" }, { number: "6", name: "Saturday" }, { number: "7", name: "Sunday" }];
  }
  hideModal() {
    this.resetChangePasswordParams(), this.$root.$emit("bv::hide::modal", "changePasswordModal");
  }
  resetChangePasswordParams() {
    this.changePasswordRequest = { currentPassword: "", newPassword: "" }, this.confirmNewPassword = "", this.newPassword = "", this.currentPassword = "";
  }
  async changeHomepage(accountHomepage) {
    try {
      await new AccountClient(new Transformer(), baseUrl()).setUserHomepage(accountHomepage), this.$bvToast.toast("Homepage for " + this.user.id + " has been successfully updated", { title: "Success", variant: "success", autoHideDelay: 5e3, solid: !0 });
    } catch (ex) {
      this.$bvToast.toast(ex, { title: "An error occured", variant: "danger", autoHideDelay: 5e3, solid: !0 });
    }
  }
  async changeDigestTime(digestTime) {
    try {
      await new AccountClient(new Transformer(), baseUrl()).setDigestTime(digestTime), this.$bvToast.toast("Digest Time for " + this.user.id + " has been successfully updated", { title: "Success", variant: "success", autoHideDelay: 5e3, solid: !0 });
    } catch (ex) {
      this.$bvToast.toast(ex, { title: "An error occured", variant: "danger", autoHideDelay: 5e3, solid: !0 });
    }
  }
  async changeIntrayTime(intrayTime) {
    try {
      await new AccountClient(new Transformer(), baseUrl()).setIntrayDaysTime(this.user.intrayDays, intrayTime), this.user.intrayTime = intrayTime, this.$bvToast.toast("Intray Time has been successfully updated", { title: "Success", variant: "success", autoHideDelay: 5e3, solid: !0 });
    } catch (ex) {
      this.$bvToast.toast(ex, { title: "An error occured", variant: "danger", autoHideDelay: 5e3, solid: !0 });
    }
  }
  async changeIntrayDays(intrayDays) {
    try {
      await new AccountClient(new Transformer(), baseUrl()).setIntrayDaysTime(intrayDays, this.user.intrayTime), this.$bvToast.toast("Intray Days has been successfully updated", { title: "Success", variant: "success", autoHideDelay: 5e3, solid: !0 });
    } catch (ex) {
      this.$bvToast.toast(ex, { title: "An error occured", variant: "danger", autoHideDelay: 5e3, solid: !0 });
    }
  }
  changePassword() {
    this.$validator.validateAll().then((result) => {
      result && (this.changePasswordLoading = !0, this.newPassword === this.confirmNewPassword ? new AccountClient(new Transformer(), baseUrl()).changePassword(this.changePasswordRequest).then(() => {
        this.$bvToast.toast("Password for " + this.user.id + " has been successfully updated", { title: "Success", variant: "success", autoHideDelay: 5e3, solid: !0 }), this.resetChangePasswordParams(), this.$root.$emit("bv::hide::modal", "changePasswordModal");
      }).catch((e) => {
        this.$bvToast.toast(e.response, { title: "Could not update password", variant: "danger", autoHideDelay: 5e3, solid: !0 });
      }).finally(() => {
        this.changePasswordLoading = !1;
      }) : (this.changePasswordLoading = !1, this.$bvToast.toast("The new passwords do not match.", { title: "Error", variant: "danger", autoHideDelay: 5e3, solid: !0 })));
    });
  }
}, __name(_a, "ProfileSummaryRoute"), _a);
ProfileSummaryRoute = __decorateClass([
  Component({
    components: {
      PasswordComplexityRules,
      HourPicker,
      CheckIcon
    }
  })
], ProfileSummaryRoute);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "profile-summary" }, [_c("b-modal", { attrs: { id: "changePasswordModal", "hide-footer": "" }, scopedSlots: _vm._u([{ key: "modal-header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "lock" } }), _vm._v(" Change Password")], 1)];
  }, "fn"), proxy: !0 }, { key: "default", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-form", { on: { submit: /* @__PURE__ */ __name(function($event) {
      return $event.stopPropagation(), $event.preventDefault(), _vm.changePassword.apply(null, arguments);
    }, "submit") } }, [_vm.enforcePasswordComplexityRules ? _c("span", [_c("password-complexity-rules")], 1) : _vm._e(), _vm._v(" "), _c("b-form-group", { attrs: { id: "currentPasswordInputGroup", label: "Current Password", "label-for": "currentPasswordInput" } }, [_c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], ref: "currentPasswordInput", attrs: { id: "currentPasswordInput", type: "password", state: _vm.validatePasswordState("currentPasswordInput"), "data-vv-as": "current password" }, model: { value: _vm.currentPassword, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.currentPassword = $$v;
    }, "callback"), expression: "currentPassword" } }), _vm._v(" "), _vm.errors.first("currentPasswordInput") ? _c("b-form-invalid-feedback", { attrs: { id: "currentPasswordInputFeedback" } }, [_vm._v(_vm._s(_vm.errors.first("currentPasswordInput")))]) : _c("small", { staticClass: "form-text text-muted", attrs: { id: "currentPasswordInputHelp" } }, [_vm._v("Enter your current password, for security reasons.")])], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "passwordGroup", label: "New Password", "label-for": "password" } }, [_c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], ref: "password", attrs: { id: "password", name: "password", type: "password", state: _vm.validateState("password"), "data-vv-as": "new password" }, model: { value: _vm.newPassword, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.newPassword = $$v;
    }, "callback"), expression: "newPassword" } }), _vm._v(" "), _vm.errors.first("password") ? _c("b-form-invalid-feedback", { attrs: { id: "passwordFeedback" } }, [_vm._v(_vm._s(_vm.errors.first("password")))]) : _c("small", { staticClass: "form-text text-muted", attrs: { id: "passwordHelp" } }, [_vm._v("The new password that will authenticate you.")])], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "passwordConfirmationGroup", name: "passwordConfirmationGroup", label: "Confirm New Password", "label-for": "passwordConfirmation" } }, [_c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required|confirmed:password", expression: "'required|confirmed:password'" }], attrs: { id: "passwordConfirmation", name: "passwordConfirmation", type: "password", state: _vm.validateState("passwordConfirmation"), "data-vv-as": "password" }, model: { value: _vm.confirmNewPassword, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.confirmNewPassword = $$v;
    }, "callback"), expression: "confirmNewPassword" } }), _vm._v(" "), _vm.errors.first("passwordConfirmation") ? _c("b-form-invalid-feedback", { attrs: { id: "confirmNewPasswordInputFeedback" } }, [_vm._v(_vm._s(_vm.errors.first("passwordConfirmation")))]) : _c("small", { staticClass: "form-text text-muted", attrs: { id: "confirmNewPasswordInputHelp" } }, [_vm._v("Confirm your new password to ensure it is correct.")])], 1), _vm._v(" "), _c("b-button", { staticClass: "float-left", attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.hideModal();
    }, "click") } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { type: "submit", id: "submitPasswordChange", variant: "success", disabled: _vm.changePasswordLoading } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.changePasswordLoading, expression: "!changePasswordLoading" }] }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.changePasswordLoading, expression: "changePasswordLoading" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Saving")], 1)])], 1)];
  }, "fn"), proxy: !0 }]) }), _vm._v(" "), _vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-lg-6" }, [_c("h2", [_c("span", { staticClass: "align-middle" }, [_c("font-awesome-icon", { attrs: { icon: "user" } }), _vm._v(" " + _vm._s(_vm.user.name) + `
                            `), _vm.user.source === "http://ewa.ezescan.com.au/security/authenticationTypes/local" || _vm.user.name === "admin" ? _c("b-button", { directives: [{ name: "b-modal", rawName: "v-b-modal.changePasswordModal", modifiers: { changePasswordModal: !0 } }], staticClass: "float-right", attrs: { id: "btnChangePassword", variant: "outline-primary" } }, [_c("font-awesome-icon", { attrs: { icon: "lock" } }), _vm._v(` Change Password
                        `)], 1) : _vm._e()], 1)]), _vm._v(" "), _c("b-form-group", { attrs: { id: "userIdGroup", label: "User Id", "label-for": "userIdInput" } }, [_c("b-form-input", { attrs: { id: "userIdInput", disabled: "", type: "text" }, model: { value: _vm.user.id, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.user, "id", $$v);
  }, "callback"), expression: "user.id" } }), _vm._v(" "), _c("small", { staticClass: "form-text text-muted", attrs: { id: "emailInputHelp" } }, [_vm._v("This is the Id of the currently logged in user.")])], 1), _vm._v(" "), _c("span", { staticClass: "text-muted small", staticStyle: { "font-size": "16px" } }), _vm._v(" "), _c("b-form-group", { attrs: { id: "homepageInputGroup", label: "Home page", "label-for": "homepageInput" } }, [_c("b-form-select", { attrs: { options: _vm.homepageOptions, id: "homepageInput" }, on: { change: _vm.changeHomepage }, model: { value: _vm.currentHomepage, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.currentHomepage = $$v;
  }, "callback"), expression: "currentHomepage" } }), _vm._v(" "), _c("small", { staticClass: "form-text text-muted", attrs: { id: "homepageInputHelp" } }, [_vm._v("This is the page the user will be redirected to after logging in.")])], 1), _vm._v(" "), _vm.digestEnabled ? _c("b-form-group", { attrs: { id: "digestTimeInputGroup", label: "Digest Time", "label-for": "digestTimeInput" } }, [_c("hour-picker", { attrs: { name: "digestTimeInput", "include-disabled": !0, "include-system-default": !0 }, on: { change: _vm.changeDigestTime }, model: { value: _vm.currentDigestTime, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.currentDigestTime = $$v;
  }, "callback"), expression: "currentDigestTime" } }), _vm._v(" "), _c("small", { staticClass: "form-text text-muted", attrs: { id: "digestTimeInputHelp" } }, [_vm._v("Configure the time which personalised digest emails will be sent to you.")])], 1) : _vm._e(), _vm._v(" "), _vm.intraySummaryEnabled ? _c("b-form-group", { attrs: { id: "intraySummaryTimeInputGroup", label: "Intray Summary Time", "label-for": "intraySummaryTimeInput" } }, [_c("hour-picker", { attrs: { name: "intraySummaryInput", "include-disabled": !0, "include-system-default": !0 }, on: { change: _vm.changeIntrayTime }, model: { value: _vm.currentIntrayTime, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.currentIntrayTime = $$v;
  }, "callback"), expression: "currentIntrayTime" } }), _vm._v(" "), _c("small", { staticClass: "form-text text-muted", attrs: { id: "intraySummaryInputHelp" } }, [_vm._v("Configure the time which personalised intray summary emails will be sent to you.")])], 1) : _vm._e(), _vm._v(" "), _vm.intraySummaryEnabled && _vm.currentIntrayTime != "Disabled" ? _c("b-form-group", [_c("label", { staticClass: "font-weight-bold", attrs: { for: "intraySummaryIntervalInput" } }, [_vm._v("Intray Summary Days")]), _vm._v(" "), _c("br"), _vm._v(" "), _vm._l(_vm.daysOfTheWeek, function(day) {
    return _c("div", { key: day.name, staticClass: "pretty p-svg p-curve p-smooth" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.currentIntrayDays, expression: "currentIntrayDays" }], staticClass: "form-check-input", attrs: { type: "checkbox", id: "intrayDay" }, domProps: { value: day.number, checked: Array.isArray(_vm.currentIntrayDays) ? _vm._i(_vm.currentIntrayDays, day.number) > -1 : _vm.currentIntrayDays }, on: { change: /* @__PURE__ */ __name(function($event) {
      var $$a = _vm.currentIntrayDays, $$el = $event.target, $$c = !!$$el.checked;
      if (Array.isArray($$a)) {
        var $$v = day.number, $$i = _vm._i($$a, $$v);
        $$el.checked ? $$i < 0 && (_vm.currentIntrayDays = $$a.concat([$$v])) : $$i > -1 && (_vm.currentIntrayDays = $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
      } else
        _vm.currentIntrayDays = $$c;
    }, "change") } }), _vm._v(" "), _c("div", { staticClass: "state p-primary" }, [_c("span", { staticClass: "svg svg-icon" }, [_c("CheckIcon")], 1), _vm._v(" "), _c("label", [_vm._v(_vm._s(day.name))])])]);
  }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "intraySummaryDaysHelp" } }, [_vm._v("The days of the week that Intray Summary emails will be sent. Users are able to configure their own personal days.")])], 2) : _vm._e(), _vm._v(" "), _c("b-form-group", { attrs: { id: "emailInputGroup", label: "Email address", "label-for": "emailInput" } }, [_c("b-form-input", { attrs: { id: "emailInput", disabled: "", type: "text" }, model: { value: _vm.user.email, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.user, "email", $$v);
  }, "callback"), expression: "user.email" } }), _vm._v(" "), _c("small", { staticClass: "form-text text-muted", attrs: { id: "emailInputHelp" } }, [_vm._v("This is the email address used to log in and also how we will send notifications to you.")])], 1), _vm._v(" "), _vm.user.groups ? _c("div", [_c("b-form-group", { attrs: { id: "authenticatedByInputGroup", label: "Authenticated By", "label-for": "emailInput" } }, [_c("b-form-input", { attrs: { id: "authenticatedByInput", disabled: "", type: "text" }, model: { value: _vm.user.source, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.user, "source", $$v);
  }, "callback"), expression: "user.source" } }), _vm._v(" "), _c("small", { staticClass: "form-text text-muted", attrs: { id: "authenticatedByInputHelp" } }, [_vm._v("This is how your EWA is configured to allow authentication.")])], 1), _vm._v(" "), _c("strong", [_vm._v("Groups")]), _vm._v(" "), _vm.user.groups.length > 0 || _vm.user.ewaGroups.length > 0 ? _c("b-list-group", [_c("small", { staticClass: "form-text text-muted", attrs: { id: "emailHelp" } }, [_vm._v("The groups you are currently assigned to.")]), _vm._v(" "), _vm._l(_vm.user.groups, function(group, index) {
    return _c("b-list-group-item", { key: index, staticClass: "p-2" }, [_vm._v(_vm._s(group))]);
  }), _vm._v(" "), _vm._l(_vm.user.ewaGroups, function(ewaGroup, index) {
    return _c("b-list-group-item", { key: index, staticClass: "p-2" }, [_c("font-awesome-icon", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { icon: "users-class", title: "EWA Group" } }), _vm._v(` 
                             ` + _vm._s(ewaGroup) + `
                        `)], 1);
  })], 2) : _c("p", { staticClass: "text-muted" }, [_vm._v("No groups")])], 1) : _vm._e(), _vm._v(" "), _vm.user.ewaDefinedValues ? _c("div", { staticClass: "pt-2" }, [_c("strong", [_vm._v("User defined values")]), _vm._v(" "), _c("b-list-group", [_c("small", { staticClass: "form-text text-muted", attrs: { id: "definedValuesHelp" } }, [_vm._v("The user defined values assigned to your account:")]), _vm._v(" "), _vm._l(_vm.user.ewaDefinedValues, function(definedValue, index) {
    return _c("b-list-group-item", { key: index, staticClass: "p-2" }, [_vm._v(_vm._s(definedValue.displayName) + ": " + _vm._s(definedValue.value))]);
  })], 2)], 1) : _vm._e()], 1)])])], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  ProfileSummaryRoute,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "9f804b7d"
);
const profileSummaryRoute = __component__.exports;
export {
  profileSummaryRoute as default
};
