var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, aZ as ItemProcessingStatus, aV as IndexingProcessingClient, T as Transformer, b as baseUrl, a_ as ProcessorStageStatus, a$ as ProcessingJobStatus, t as toastr, cr as BulkProcessorAction, P as Prop, W as Watch, C as Component, ck as getQueueTypeIcon, j as getQueueName, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { I as ItemHistoryModal } from "./itemHistoryModal-BQOXXlR-.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let ProcessingPage = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "queueId");
    __publicField(this, "processorId");
    __publicField(this, "filterModel", { filterStatus: null, sort: {} });
    __publicField(this, "model", null);
    __publicField(this, "tableItems", []);
    __publicField(this, "rowDetailIds", []);
    __publicField(this, "loading", !0);
    __publicField(this, "page", 1);
    __publicField(this, "pageSize", 50);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "itemIdHistoryToShow", "");
    __publicField(this, "itemNameHistoryToShow", "");
    __publicField(this, "showItemHistoryModal", !1);
    __publicField(this, "selectedProcessorIds", []);
  }
  mounted() {
    this.reloadTimer = setInterval(() => {
      this.selectedProcessorIds.length > 0 || this.getProcessorInfo(!1);
    }, 3e4), this.getProcessorInfo(!0);
  }
  setHistoryToShow(item) {
    this.itemIdHistoryToShow = item.item.id, this.itemNameHistoryToShow = item.name, this.showItemHistoryModal = !0;
  }
  closeHistoryModal() {
    this.itemIdHistoryToShow = null, this.itemNameHistoryToShow = null, this.showItemHistoryModal = !1;
  }
  get filterOptions() {
    return [
      { value: null, text: "All" },
      { value: ItemProcessingStatus.Failed, text: "Returned to Queue" },
      { value: ItemProcessingStatus.Cancelled, text: "Cancelled" },
      { value: ItemProcessingStatus.Running, text: "Failed" },
      { value: ItemProcessingStatus.Successful, text: "Successful" }
    ];
  }
  async pageChanged() {
    await this.getProcessorInfo(!0);
  }
  async getProcessorInfo(setLoading) {
    this.loading = setLoading;
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    this.model = await processingClient.getProcessingSummary(this.queueId, this.processorId, this.page, this.pageSize, this.filterModel), this.cleanSelected(), this.tableItems = this.model.processors.map((t) => ({
      id: t.id,
      item: t.item,
      name: t.name,
      finished: t.finished,
      started: t.started,
      status: t.status,
      stages: t.stages,
      action: t.action,
      _showDetails: this.rowDetailIds.includes(t.id)
    })), this.loading = !1;
  }
  getQueueUrl(queueId) {
    return new URL(baseUrl() + "/app/indexing/queues/" + queueId + "/list").href;
  }
  getDetailUrl(itemId) {
    return new URL(baseUrl() + "/app/indexing/items/" + itemId).href;
  }
  get totalPages() {
    if (this.model)
      return this.model.totalPages;
  }
  toggleRowDetails(row) {
    row.toggleDetails(), this.rowDetailIds.includes(row.item.id) ? this.rowDetailIds = this.rowDetailIds.filter(function(i) {
      return i !== row.item.id;
    }) : this.rowDetailIds.push(row.item.id);
  }
  getStatusText(processor) {
    switch (processor.status) {
      case ItemProcessingStatus.Running:
        return processor.stages.filter((stage) => stage.status === ProcessorStageStatus.Failed).length ? "Stage Failed" : this.$options.filters.capitaliseFirstLetter(processor.status);
      case ItemProcessingStatus.Cancelled:
      case ItemProcessingStatus.Successful:
        return this.$options.filters.capitaliseFirstLetter(processor.status);
      case ItemProcessingStatus.Failed:
        return "Returned to queue";
      default:
        return "Unknown";
    }
  }
  getProcessorStatusClass(processor) {
    switch (processor.status) {
      case ItemProcessingStatus.Running:
        return processor.stages.filter((stage) => stage.status === ProcessorStageStatus.Failed).length ? "danger" : "primary";
      case ItemProcessingStatus.Successful:
        return "success";
      case ItemProcessingStatus.Failed:
        return "warning";
      default:
        return "";
    }
  }
  getProcessorIcon(processor) {
    switch (processor.status) {
      case ItemProcessingStatus.Running:
        return processor.stages.filter((stage) => stage.status === ProcessorStageStatus.Failed).length ? "times-circle" : "circle-ellipsis";
      case ItemProcessingStatus.Successful:
        return "check-circle";
      case ItemProcessingStatus.Cancelled:
        return "ban";
      case ItemProcessingStatus.Failed:
        return "inbox-in";
      default:
        return "question";
    }
  }
  getJobClass(job) {
    switch (job.status) {
      case ProcessingJobStatus.Successful:
        return "success";
      case ProcessingJobStatus.Failed:
        return "danger";
      case ProcessingJobStatus.Skipped:
        return "muted";
      case ProcessingJobStatus.Cancelled:
        return "muted";
      case ProcessingJobStatus.Running:
        return "primary";
      default:
        return "";
    }
  }
  getJobIcon(job) {
    switch (job.status) {
      case ProcessingJobStatus.Successful:
        return "check-circle";
      case ProcessingJobStatus.Failed:
        return "times-circle";
      case ProcessingJobStatus.Skipped:
        return "circle-chevron-right";
      case ProcessingJobStatus.Cancelled:
        return "ban";
      case ProcessingJobStatus.Running:
        return "circle-ellipsis";
      default:
        return "";
    }
  }
  getStageName(stage) {
    return stage.name ? stage.name : "Stage not found";
  }
  getStageClass(stage) {
    let stageButtonClass = "";
    switch (stage.status) {
      case ProcessorStageStatus.Running:
        stageButtonClass += "primary";
        break;
      case ProcessorStageStatus.Successful:
        stageButtonClass += "success";
        break;
      case ProcessorStageStatus.Queued:
      case ProcessorStageStatus.Cancelled:
      case ProcessorStageStatus.Skipped:
        stageButtonClass += "secondary";
        break;
      case ProcessorStageStatus.Failed:
        stageButtonClass += "danger";
        break;
    }
    return stageButtonClass;
  }
  getStageStatusTitle(stage) {
    switch (stage.status) {
      case ProcessorStageStatus.Queued:
        return "Queued to run";
      default:
        return this.$options.filters.capitaliseFirstLetter(stage.status ? stage.status : "Unknown");
    }
  }
  getStageIcon(stage) {
    switch (stage.status) {
      case ProcessorStageStatus.Queued:
        return "clock";
      case ProcessorStageStatus.Running:
        return "circle-ellipsis";
      case ProcessorStageStatus.Successful:
        return "check-circle";
      case ProcessorStageStatus.Skipped:
        return "circle-chevron-right";
      case ProcessorStageStatus.Cancelled:
        return "ban";
      case ProcessorStageStatus.Failed:
        return "times-circle";
    }
  }
  getProcessorFinalStage(item) {
    return item.stages.find((y) => y.order == item.stages.length);
  }
  downloadJobLog(job) {
    return new URL(baseUrl() + "/api/processing/processing/jobs/" + job.id).href;
  }
  viewProcessorLog(processorId) {
    return new URL(baseUrl() + "/api/processing/processors/" + processorId + "/log").href;
  }
  async cancelProcessor(processorId) {
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    try {
      await processingClient.cancelProcessor(processorId), toastr.info("The processor has been cancelled");
    } catch (ex) {
      toastr.error(ex, "An error occurred while cancelling the processor");
    }
    await this.$nextTick(), await this.getProcessorInfo(!1);
  }
  async retryProcessor(processorId) {
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    try {
      await processingClient.retryProcessor(processorId), toastr.info("The processor has been marked to retry");
    } catch (ex) {
      toastr.error(ex, "An error occurred while retrying the processor");
    }
    await this.$nextTick(), await this.getProcessorInfo(!1);
  }
  async failProcessor(processorId) {
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    try {
      await processingClient.failProcessor(processorId), toastr.info("The processor has been marked as failed");
    } catch (ex) {
      toastr.error(ex, "An error occurred while failing the processor");
    }
    await this.$nextTick(), await this.getProcessorInfo(!1);
  }
  get sort() {
    let sort = this.filterModel.sort;
    return sort || null;
  }
  set sort(sort) {
    this.filterModel.sort = sort, this.getProcessorInfo(!0);
  }
  isProcessorSelected(processorId) {
    var _a2;
    return (_a2 = this.selectedProcessorIds) == null ? void 0 : _a2.includes(processorId);
  }
  get selectedProcessors() {
    return this.selectedProcessorIds;
  }
  set selectedProcessors(value) {
    this.selectedProcessorIds = value;
  }
  get partiallySelectedProcessors() {
    var _a2;
    return ((_a2 = this.selectedProcessorIds) == null ? void 0 : _a2.length) > 0 && this.selectedProcessorIds.length < this.model.processors.length;
  }
  toggleProcessorSelected(processorId) {
    var _a2;
    ((_a2 = this.selectedProcessorIds) == null ? void 0 : _a2.find((x) => x == processorId)) ? this.selectedProcessorIds = this.selectedProcessorIds.filter((x) => x != processorId) : this.selectedProcessorIds = this.selectedProcessorIds.concat([processorId]);
  }
  toggleAllProcessorsSelected() {
    var _a2;
    ((_a2 = this.selectedProcessorIds) == null ? void 0 : _a2.length) == 0 ? this.selectedProcessorIds = this.model.processors.map((x) => x.id) : this.selectedProcessorIds = [];
  }
  async bulkActionProcessors(action) {
    let bulkAction = BulkProcessorAction.Cancel;
    switch (action) {
      case "cancel":
        bulkAction = BulkProcessorAction.Cancel;
        break;
      case "fail":
        bulkAction = BulkProcessorAction.Fail;
        break;
      case "retry":
        bulkAction = BulkProcessorAction.Retry;
        break;
    }
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    try {
      this.loading = !0, await processingClient.bulkActionProcessors({ processorIds: this.selectedProcessorIds, action: bulkAction }), toastr.info("The selected processors have been actioned."), this.cleanSelected();
    } catch (ex) {
      toastr.error(ex, "An error occurred while actioning the processors");
    } finally {
      this.loading = !1;
    }
  }
  checkProcessorsCanAction(action) {
    switch (action) {
      case "cancel":
        return this.model.processors.filter((y) => this.selectedProcessorIds.indexOf(y.id) > -1).every((y) => {
          var _a2, _b;
          return ((_a2 = this.getProcessorFinalStage(y)) == null ? void 0 : _a2.status) == "queued" || ((_b = this.getProcessorFinalStage(y)) == null ? void 0 : _b.status) == "running";
        });
      case "retry":
      case "fail":
        return this.model.processors.filter((y) => this.selectedProcessorIds.indexOf(y.id) > -1).every((y) => {
          var _a2, _b, _c;
          return ((_a2 = this.getProcessorFinalStage(y)) == null ? void 0 : _a2.status) != "queued" && y.status == "running" && (((_b = this.getProcessorFinalStage(y)) == null ? void 0 : _b.status) == "failed" || ((_c = this.getProcessorFinalStage(y)) == null ? void 0 : _c.status) == "cancelled");
        });
    }
  }
  cleanSelected() {
    this.selectedProcessorIds.length && (this.selectedProcessorIds = this.selectedProcessorIds.filter((y) => this.model.processors.some((x) => x.processorId == y)));
  }
  get tableFields() {
    return [
      { key: "select", label: "", sortable: !1 },
      { key: "action", label: "Action", sortable: !1, thClass: "align-middle" },
      { key: "item", label: "Item", sortable: !1, thClass: "align-middle" },
      { key: "started", label: "Started", sortable: !1, thClass: "align-middle" },
      { key: "status", label: "Status", sortable: !1, thClass: "align-middle" },
      { key: "completed", label: "Completed", sortable: !1, thClass: "align-middle" },
      { key: "actions", label: "", sortable: !1, thClass: "align-middle" }
    ];
  }
}, __name(_a, "ProcessingPage"), _a);
__decorateClass([
  Prop({ required: !0 })
], ProcessingPage.prototype, "queueId", 2);
__decorateClass([
  Prop({ required: !1 })
], ProcessingPage.prototype, "processorId", 2);
__decorateClass([
  Watch("page")
], ProcessingPage.prototype, "pageChanged", 1);
ProcessingPage = __decorateClass([
  Component({ components: { DateDisplay, PaginationControls, ItemHistoryModal, SortableHeaderLink }, methods: { getQueueName, getQueueTypeIcon } })
], ProcessingPage);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_vm.model ? _c("a", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover.bottom", modifiers: { hover: !0, bottom: !0 } }], staticClass: "align-middle", attrs: { href: _vm.getQueueUrl(_vm.model.queue.id), title: "Back to queue" } }, [_vm.model ? _c("span", [_c("font-awesome-icon", { attrs: { icon: _vm.getQueueTypeIcon(_vm.model.queue.type.type) } }), _vm._v(" " + _vm._s(_vm.model.queue.name))], 1) : _vm._e()]) : _vm._e(), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.getProcessorInfo(!0);
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)])];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.tableItems, striped: "", busy: _vm.loading, "details-td-class": "pt-0 pb-2", "show-empty": "", emptyText: "No processing items could be found" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "head(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_c("sortable-header-link", { staticClass: "mb-1", attrs: { id: "status", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } }), _vm._v(`
                 
                `), _c("b-form-select", { attrs: { size: "sm", options: _vm.filterOptions }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.getProcessorInfo(!0);
    }, "change") }, model: { value: _vm.filterModel.filterStatus, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(_vm.filterModel, "filterStatus", $$v);
    }, "callback"), expression: "filterModel.filterStatus" } })], 1)])];
  }, "fn") }, { key: "head(item)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "item", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(started)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "started", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(completed)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "completed", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(select)", fn: /* @__PURE__ */ __name(function(row) {
    var _a2;
    return [_c("b-checkbox", { attrs: { indeterminate: _vm.partiallySelectedProcessors, checked: !!((_a2 = _vm.selectedProcessorIds) != null && _a2.length) }, on: { change: _vm.toggleAllProcessorsSelected } })];
  }, "fn") }, { key: "head(actions)", fn: /* @__PURE__ */ __name(function(row) {
    var _a2;
    return [(_a2 = _vm.selectedProcessorIds) != null && _a2.length ? _c("div", [_c("b-dropdown", { staticClass: "float-right", attrs: { variant: "primary", size: "sm", id: "bulkActionProcessors", disabled: _vm.loading, "no-caret": "", right: "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("cancel") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("cancel");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "ban" } }), _vm._v(" Cancel (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("retry") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("retry");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Retry (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("fail") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("fail");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "inbox-in" } }), _vm._v(" Return to Queue (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1)], 1)], 1) : _vm._e()];
  }, "fn") }, { key: "cell(select)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "d-inline-flex" }, [_c("b-checkbox", { attrs: { checked: _vm.isProcessorSelected(row.item.id), size: "sm" }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleProcessorSelected(row.item.id);
    }, "change") } })], 1)];
  }, "fn") }, { key: "cell(action)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("span", { class: "text-" + row.item.action.colour }, [_c("font-awesome-icon", { attrs: { icon: row.item.action && row.item.action.icon ? row.item.action.icon : "question" } }), _vm._v(`
            ` + _vm._s(row.item.action && row.item.action.name ? row.item.action.name : "Unknown") + `
          `)], 1)];
  }, "fn") }, { key: "cell(started)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.started ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.started } }) : _vm._e()];
  }, "fn") }, { key: "cell(item)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.item.status == "enqueued" && row.item.item.queueId == _vm.model.queue.id ? _c("span", [_c("a", { attrs: { href: _vm.getDetailUrl(row.item.item.id) } }, [_vm._v(_vm._s(row.item.name))])]) : _c("span", [_vm._v(_vm._s(row.item.name))]), _vm._v(" "), _c("span", [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "link", size: "sm", title: "View item history" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setHistoryToShow(row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "history" } })], 1)], 1)];
  }, "fn") }, { key: "cell(completed)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.finished ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.finished } }) : _vm._e(), _vm._v(" "), row.item.finished ? _c("span", { staticClass: "small text-muted" }, [_vm._v("(took " + _vm._s(_vm.$options.filters.datetimeDifference(row.item.started, row.item.finished)) + ")")]) : _vm._e()];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(row) {
    var _a2, _b, _c2, _d, _e;
    return [row.item.stages ? _c("span", { staticClass: "float-right" }, [((_a2 = _vm.getProcessorFinalStage(row.item)) == null ? void 0 : _a2.status) == "queued" || ((_b = _vm.getProcessorFinalStage(row.item)) == null ? void 0 : _b.status) == "running" ? _c("b-button", { attrs: { size: "sm", variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.cancelProcessor(row.item.id);
    }, "click") } }, [_vm._v("Cancel Processor")]) : ((_c2 = _vm.getProcessorFinalStage(row.item)) == null ? void 0 : _c2.status) != "queued" && row.item.status == "running" && (((_d = _vm.getProcessorFinalStage(row.item)) == null ? void 0 : _d.status) == "cancelled" || ((_e = _vm.getProcessorFinalStage(row.item)) == null ? void 0 : _e.status) == "failed") ? _c("b-dropdown", { attrs: { "no-flip": "", right: "", size: "sm", variant: "outline-primary" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(` Actions
                  `)];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.retryProcessor(row.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Retry failed stage")], 1), _vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.failProcessor(row.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "inbox-in" } }), _vm._v(" Return to Queue")], 1)], 1) : _vm._e()], 1) : _vm._e()];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "text-nowrap" }, [_c("b-badge", { attrs: { variant: _vm.getProcessorStatusClass(row.item), pill: "", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.getProcessorIcon(row.item) } }), _vm._v(`
            ` + _vm._s(_vm.getStatusText(row.item)) + `
          `)], 1), _vm._v(" "), _vm._l(row.item.stages, function(stage) {
      return _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { title: _vm.getStageName(stage) + " - " + _vm.getStageStatusTitle(stage) }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.toggleRowDetails(row);
      }, "click") } }, [_c("font-awesome-icon", { class: "text-" + _vm.getStageClass(stage), attrs: { icon: _vm.getStageIcon(stage) } })], 1);
    }), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { variant: "link", size: "sm", title: "Show stage details" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: row.detailsShowing ? "caret-down" : "caret-right" } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "ml-2 align-middle", attrs: { variant: "link", size: "sm", target: "_blank", href: _vm.viewProcessorLog(row.item.id), title: "View Processor Log" } }, [_c("font-awesome-icon", { attrs: { icon: "up-right-from-square" } })], 1)], 2)];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-card", { attrs: { "body-class": "p-3 mx-auto" } }, [_c("b-row", { staticClass: "py-0" }, [_c("b-col", _vm._l(row.item.stages, function(stage, index) {
      return _c("span", { staticClass: "center" }, [_c("b-dropdown", { class: { "mx-1": index + 1 != row.item.stages.length }, attrs: { "no-flip": "", size: "sm", right: "", variant: "outline-" + _vm.getStageClass(stage) }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
        return [_c("font-awesome-icon", { attrs: { icon: _vm.getStageIcon(stage) } }), _vm._v(`
                    ` + _vm._s(_vm.getStageName(stage)) + `
                     `), stage.type == "ConditionProcessorStage" ? _c("b-badge", { attrs: { pill: "", variant: "info" } }, [_vm._v("Start")]) : _vm._e(), _vm._v(" "), stage.type == "ConditionEndProcessorStage" ? _c("b-badge", { attrs: { pill: "", variant: "info" } }, [_vm._v("End")]) : _vm._e()];
      }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _vm._l(stage.jobs, function(job, jobIndex) {
        return _c("b-dropdown-item", { key: jobIndex, attrs: { pill: "", href: _vm.downloadJobLog(job), target: "_blank" } }, [_c("font-awesome-icon", { class: "text-" + _vm.getJobClass(job), attrs: { icon: _vm.getJobIcon(job) } }), _vm._v(`
                    View Log file #` + _vm._s(jobIndex + 1) + `
                  `)], 1);
      })], 2), _vm._v(" "), index + 1 != row.item.stages.length ? _c("font-awesome-icon", { staticClass: "align-middle", attrs: { size: "xs", icon: "chevron-right" } }) : _vm._e(), _vm._v(` 
              `)], 1);
    }), 0)], 1)], 1)];
  }, "fn") }]) }), _vm._v(" "), _vm.model ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.page, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.page = $$v;
  }, "callback"), expression: "page" } }) : _vm._e(), _vm._v(" "), _c("item-history-modal", { attrs: { item: { id: _vm.itemIdHistoryToShow, name: _vm.itemNameHistoryToShow }, shouldShow: _vm.showItemHistoryModal }, on: { close: _vm.closeHistoryModal } })], 1)], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  ProcessingPage,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "a017b1bb"
);
const processingPage = __component__.exports;
export {
  processingPage as default
};
