var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, aV as IndexingProcessingClient, T as Transformer, b as baseUrl, aW as ItemPreProcessingStatus, aX as StageStatus, aY as JobStatus, t as toastr, cq as BulkPreProcessorAction, P as Prop, W as Watch, C as Component, ck as getQueueTypeIcon, j as getQueueName, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { I as ItemHistoryModal } from "./itemHistoryModal-BQOXXlR-.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let PreProcessingPage = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "queueId");
    __publicField(this, "preProcessorId");
    __publicField(this, "model", null);
    __publicField(this, "filterModel", { filterStatus: null, sort: {} });
    __publicField(this, "tableItems", []);
    __publicField(this, "loading", !0);
    __publicField(this, "page", 1);
    __publicField(this, "pageSize", 50);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "rowDetailIds", []);
    __publicField(this, "itemIdHistoryToShow", "");
    __publicField(this, "itemNameHistoryToShow", "");
    __publicField(this, "showItemHistoryModal", !1);
    __publicField(this, "selectedProcessorIds", []);
  }
  mounted() {
    this.reloadTimer = setInterval(() => {
      this.selectedProcessorIds.length > 0 || this.getPreProcessingInfo(!1);
    }, 3e4), this.getPreProcessingInfo(!0);
  }
  async pageChanged() {
    await this.getPreProcessingInfo(!0);
  }
  async getPreProcessingInfo(setLoading) {
    this.loading = setLoading;
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    this.model = await processingClient.getPreProcessingSummary(this.queueId, this.preProcessorId, this.page, this.pageSize, this.filterModel), this.cleanSelected(), this.tableItems = this.model.items.map((t) => ({
      id: t.id,
      item: t.item,
      name: t.name,
      finished: t.finished,
      started: t.started,
      status: t.status,
      stages: t.stages,
      _showDetails: this.rowDetailIds.includes(t.id)
    })), this.loading = !1;
  }
  getQueueUrl(queueId) {
    return new URL(baseUrl() + "/app/indexing/queues/" + queueId + "/list").href;
  }
  getDetailUrl(itemId) {
    return new URL(baseUrl() + "/app/indexing/items/" + itemId).href;
  }
  setHistoryToShow(item) {
    this.itemIdHistoryToShow = item.item.id, this.itemNameHistoryToShow = item.name, this.showItemHistoryModal = !0;
  }
  closeHistoryModal() {
    this.itemIdHistoryToShow = null, this.itemNameHistoryToShow = null, this.showItemHistoryModal = !1;
  }
  downloadJobLog(job) {
    return new URL(baseUrl() + "/api/processing/preProcessing/jobs/" + job.id).href;
  }
  viewPreProcessorLog(processorId) {
    return new URL(baseUrl() + "/api/processing/preProcessing/processor/" + processorId + "/log").href;
  }
  toggleRowDetails(row) {
    row.toggleDetails(), this.rowDetailIds.includes(row.item.id) ? this.rowDetailIds = this.rowDetailIds.filter(function(i) {
      return i !== row.item.id;
    }) : this.rowDetailIds.push(row.item.id);
  }
  getStageName(stage) {
    return stage.name ? stage.name : "Pre-Processor not found";
  }
  get totalPages() {
    if (this.model)
      return this.model.totalPages;
  }
  get filterOptions() {
    return [
      { value: null, text: "All" },
      { value: ItemPreProcessingStatus.Pending, text: "Pending" },
      { value: ItemPreProcessingStatus.Running, text: "Running" },
      { value: ItemPreProcessingStatus.Successful, text: "Successful" },
      { value: ItemPreProcessingStatus.Cancelled, text: "Cancelled" },
      { value: ItemPreProcessingStatus.Skipped, text: "Skipped" },
      { value: ItemPreProcessingStatus.Failed, text: "Failed" }
    ];
  }
  getPreProcessorStatusClass(processor) {
    let buttonClass = "";
    switch (processor.status) {
      case ItemPreProcessingStatus.Pending:
        buttonClass += "warning";
        break;
      case ItemPreProcessingStatus.Running:
        buttonClass += "primary";
        break;
      case ItemPreProcessingStatus.Successful:
      case ItemPreProcessingStatus.Skipped:
      case ItemPreProcessingStatus.Split:
        buttonClass += "success";
        break;
      case ItemPreProcessingStatus.Failed:
        buttonClass += "danger";
        break;
      case ItemPreProcessingStatus.Queued:
      case ItemPreProcessingStatus.Cancelled:
        buttonClass += "secondary";
        break;
    }
    return buttonClass;
  }
  getStatusIcon(processor) {
    switch (processor.status) {
      case ItemPreProcessingStatus.Pending:
      case ItemPreProcessingStatus.Queued:
        return "clock";
      case ItemPreProcessingStatus.Running:
        return "circle-ellipsis";
      case ItemPreProcessingStatus.Successful:
        return "check-circle";
      case ItemPreProcessingStatus.Split:
        return "clone";
      case ItemPreProcessingStatus.Cancelled:
        return "ban";
      case ItemPreProcessingStatus.Skipped:
        return "circle-chevron-right";
      case ItemPreProcessingStatus.Failed:
        return "times-circle";
      default:
        return "question";
    }
  }
  getStatusTitle(processor) {
    switch (processor.status) {
      case ItemPreProcessingStatus.Pending:
        return "Waiting to start";
      case ItemPreProcessingStatus.Queued:
        return "Queued to run";
      default:
        return this.$options.filters.capitaliseFirstLetter(processor.status ? processor.status : "Unknown");
    }
  }
  getStageIcon(stage) {
    switch (stage.status) {
      case StageStatus.Pending:
      case StageStatus.Queued:
        return "clock";
      case StageStatus.Running:
        return "circle-ellipsis";
      case StageStatus.Success:
        return "check-circle";
      case StageStatus.Skipped:
        return "circle-chevron-right";
      case StageStatus.Cancelled:
        return "ban";
      case StageStatus.Failed:
        return "times-circle";
      case StageStatus.Split:
        return "clone";
    }
  }
  getJobIcon(job) {
    switch (job.status) {
      case JobStatus.Success:
        return "check-circle";
      case JobStatus.Failed:
        return "times-circle";
      case JobStatus.Skipped:
        return "circle-chevron-right";
      case JobStatus.Cancelled:
        return "ban";
      case JobStatus.Running:
        return "circle-ellipsis";
      default:
        return "";
    }
  }
  getStageItemProcessingStatusTitle(processorStage) {
    switch (processorStage.status) {
      case StageStatus.Pending:
        return "Waiting to start";
      case StageStatus.Queued:
        return "Queued to run";
      default:
        return this.$options.filters.capitaliseFirstLetter(processorStage.status ? processorStage.status : "Unknown");
    }
  }
  getStageClass(stage) {
    let stageButtonClass = "";
    switch (stage.status) {
      case StageStatus.Pending:
        stageButtonClass += "warning";
        break;
      case StageStatus.Running:
        stageButtonClass += "primary";
        break;
      case StageStatus.Success:
        stageButtonClass += "success";
        break;
      case StageStatus.Queued:
      case StageStatus.Cancelled:
      case StageStatus.Skipped:
        stageButtonClass += "secondary";
        break;
      case StageStatus.Failed:
        stageButtonClass += "danger";
        break;
      case StageStatus.Split:
        stageButtonClass += "success";
        break;
    }
    return stageButtonClass;
  }
  getJobTextClass(job) {
    switch (job.status) {
      case JobStatus.Success:
        return "success";
      case JobStatus.Failed:
        return "danger";
      case JobStatus.Skipped:
      case JobStatus.Cancelled:
        return "secondary";
      case JobStatus.Running:
        return "primary";
      default:
        return "";
    }
  }
  async cancelPreProcessor(processorId) {
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    try {
      await processingClient.cancelPreProcessor(processorId), toastr.info("The pre-processor has been cancelled");
    } catch (ex) {
      toastr.error(ex, "An error occurred while cancelling the pre-processor");
    }
  }
  async retryPreProcessor(processorId) {
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    try {
      await processingClient.retryPreProcessor(processorId), toastr.info("The pre-processor has been marked to retry");
    } catch (ex) {
      toastr.error(ex, "An error occurred while retrying the pre-processor");
    }
  }
  async skipPreProcessor(processorId) {
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    try {
      await processingClient.skipPreProcessor(processorId), toastr.info("The pre-processor has been skipped");
    } catch (ex) {
      toastr.error(ex, "An error occurred while skipping the pre-processor");
    }
  }
  get sort() {
    let sort = this.filterModel.sort;
    return sort || null;
  }
  set sort(sort) {
    this.filterModel.sort = sort, this.getPreProcessingInfo(!0);
  }
  isProcessorSelected(processorId) {
    var _a2;
    return (_a2 = this.selectedProcessorIds) == null ? void 0 : _a2.includes(processorId);
  }
  get selectedProcessors() {
    return this.selectedProcessorIds;
  }
  set selectedProcessors(value) {
    this.selectedProcessorIds = value;
  }
  get partiallySelectedProcessors() {
    var _a2;
    return ((_a2 = this.selectedProcessorIds) == null ? void 0 : _a2.length) > 0 && this.selectedProcessorIds.length < this.model.items.length;
  }
  toggleProcessorSelected(processorId) {
    var _a2;
    ((_a2 = this.selectedProcessorIds) == null ? void 0 : _a2.find((x) => x == processorId)) ? this.selectedProcessorIds = this.selectedProcessorIds.filter((x) => x != processorId) : this.selectedProcessorIds = this.selectedProcessorIds.concat([processorId]);
  }
  toggleAllProcessorsSelected() {
    var _a2;
    ((_a2 = this.selectedProcessorIds) == null ? void 0 : _a2.length) == 0 ? this.selectedProcessorIds = this.model.items.map((x) => x.id) : this.selectedProcessorIds = [];
  }
  async bulkActionProcessors(action) {
    let bulkAction = BulkPreProcessorAction.Cancel;
    switch (action) {
      case "cancel":
        bulkAction = BulkPreProcessorAction.Cancel;
        break;
      case "skip":
        bulkAction = BulkPreProcessorAction.Skip;
        break;
      case "retry":
        bulkAction = BulkPreProcessorAction.Retry;
        break;
    }
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    try {
      this.loading = !0, await processingClient.bulkActionPreProcessors({ processorIds: this.selectedProcessorIds, action: bulkAction }), toastr.info("The selected pre-processors have been actioned."), this.cleanSelected();
    } catch (ex) {
      toastr.error(ex, "An error occurred while actioning the pre-processors");
    } finally {
      this.loading = !1;
    }
  }
  checkProcessorsCanAction(action) {
    switch (action) {
      case "cancel":
        return this.model.items.filter((y) => this.selectedProcessorIds.indexOf(y.id) > -1).every((y) => y.status == "running" || y.status == "queued");
      case "retry":
        return this.model.items.filter((y) => this.selectedProcessorIds.indexOf(y.id) > -1).every((y) => y.status == "cancelled" || y.status == "failed");
      case "skip":
        return this.model.canManage && this.model.items.filter((y) => this.selectedProcessorIds.indexOf(y.id) > -1).every((y) => y.status == "cancelled" || y.status == "failed");
    }
  }
  cleanSelected() {
    this.selectedProcessorIds.length && (this.selectedProcessorIds = this.selectedProcessorIds.filter((y) => this.model.items.some((x) => x.processorId == y)));
  }
  get tableFields() {
    return [
      { key: "select", label: "", sortable: !1 },
      { key: "item", label: "Item", sortable: !1, thClass: "align-middle" },
      { key: "started", label: "Started", sortable: !1, thClass: "align-middle" },
      { key: "status", label: "Status", sortable: !1, thClass: "align-middle" },
      { key: "completed", label: "Completed", sortable: !1, thClass: "align-middle" },
      { key: "actions", label: "", sortable: !1 }
    ];
  }
}, __name(_a, "PreProcessingPage"), _a);
__decorateClass([
  Prop()
], PreProcessingPage.prototype, "queueId", 2);
__decorateClass([
  Prop()
], PreProcessingPage.prototype, "preProcessorId", 2);
__decorateClass([
  Watch("page")
], PreProcessingPage.prototype, "pageChanged", 1);
PreProcessingPage = __decorateClass([
  Component({ components: { DateDisplay, PaginationControls, ItemHistoryModal, SortableHeaderLink }, methods: { getQueueName, getQueueTypeIcon } })
], PreProcessingPage);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_vm.model ? _c("a", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover.bottom", modifiers: { hover: !0, bottom: !0 } }], attrs: { href: _vm.getQueueUrl(_vm.model.queue.id), title: "Back to queue" } }, [_vm.model ? _c("span", [_c("font-awesome-icon", { attrs: { icon: _vm.getQueueTypeIcon(_vm.model.queue.type.type) } }), _vm._v(" " + _vm._s(_vm.model.queue.name))], 1) : _vm._e()]) : _vm._e(), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.getPreProcessingInfo(!0);
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)])];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.tableItems, striped: "", busy: _vm.loading, "details-td-class": "pt-0 pb-2", "show-empty": "", emptyText: "No pre-processing items could be found" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "head(item)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "item", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(started)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "started", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(completed)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "completed", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_c("sortable-header-link", { staticClass: "mb-1", attrs: { id: "status", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } }), _vm._v(`
                 
                `), _c("b-form-select", { attrs: { size: "sm", options: _vm.filterOptions }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.getPreProcessingInfo(!0);
    }, "change") }, model: { value: _vm.filterModel.filterStatus, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(_vm.filterModel, "filterStatus", $$v);
    }, "callback"), expression: "filterModel.filterStatus" } })], 1)])];
  }, "fn") }, { key: "head(select)", fn: /* @__PURE__ */ __name(function(row) {
    var _a2;
    return [_c("b-checkbox", { attrs: { indeterminate: _vm.partiallySelectedProcessors, checked: !!((_a2 = _vm.selectedProcessorIds) != null && _a2.length) }, on: { change: _vm.toggleAllProcessorsSelected } })];
  }, "fn") }, { key: "head(actions)", fn: /* @__PURE__ */ __name(function(row) {
    var _a2;
    return [(_a2 = _vm.selectedProcessorIds) != null && _a2.length ? _c("div", [_c("b-dropdown", { staticClass: "float-right", attrs: { variant: "primary", size: "sm", id: "bulkActionPreProcessors", disabled: _vm.loading, "no-caret": "", right: "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("cancel") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("cancel");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "ban" } }), _vm._v(" Cancel Processors (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("retry") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("retry");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Retry Processors (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("skip") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("skip");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "forward" } }), _vm._v(" Skip Processors (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1)], 1)], 1) : _vm._e()];
  }, "fn") }, { key: "cell(select)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "d-inline-flex" }, [_c("b-checkbox", { attrs: { checked: _vm.isProcessorSelected(row.item.id), size: "sm" }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleProcessorSelected(row.item.id);
    }, "change") } })], 1)];
  }, "fn") }, { key: "cell(started)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.started ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.started } }) : _vm._e()];
  }, "fn") }, { key: "cell(item)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.item.status == "enqueued" && row.item.item.queueId == _vm.model.queue.id ? _c("span", [_c("a", { attrs: { href: _vm.getDetailUrl(row.item.item.id) } }, [_vm._v(_vm._s(row.item.name))])]) : _c("span", [_vm._v(_vm._s(row.item.name))]), _vm._v(" "), _c("span", [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "link", size: "sm", title: "View item history" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setHistoryToShow(row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "history" } })], 1)], 1)];
  }, "fn") }, { key: "cell(completed)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.finished ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.finished } }) : _vm._e(), _vm._v(" "), row.item.finished ? _c("span", { staticClass: "small text-muted" }, [_vm._v("(took " + _vm._s(_vm.$options.filters.datetimeDifference(row.item.started, row.item.finished)) + ")")]) : _vm._e()];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.stages ? _c("span", { staticClass: "float-right" }, [row.item.status == "running" || row.item.status == "queued" ? _c("b-button", { attrs: { size: "sm", variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.cancelPreProcessor(row.item.id);
    }, "click") } }, [_vm._v(`
                 Cancel Pre-Processor
               `)]) : row.item.status == "cancelled" || row.item.status == "failed" ? _c("b-dropdown", { attrs: { "no-flip": "", size: "sm", variant: "outline-primary" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(` Actions
                  `)];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.retryPreProcessor(row.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Retry")], 1), _vm._v(" "), _vm.model.canManage ? _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.skipPreProcessor(row.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "forward" } }), _vm._v(" Skip")], 1) : _vm._e()], 1) : _vm._e()], 1) : _vm._e()];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "text-nowrap" }, [_c("b-badge", { attrs: { variant: _vm.getPreProcessorStatusClass(row.item), pill: "", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.getStatusIcon(row.item) } }), _vm._v(`
            ` + _vm._s(_vm.getStatusTitle(row.item)) + `
          `)], 1), _vm._v(" "), _vm._l(row.item.stages, function(stage) {
      return _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { title: _vm.getStageName(stage) + " - " + _vm.getStageItemProcessingStatusTitle(stage) }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.toggleRowDetails(row);
      }, "click") } }, [_c("font-awesome-icon", { class: "text-" + _vm.getStageClass(stage), attrs: { icon: _vm.getStageIcon(stage) } })], 1);
    }), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { variant: "link", size: "sm", title: "Show stage details" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: row.detailsShowing ? "caret-down" : "caret-right" } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "ml-2 align-middle", attrs: { variant: "link", size: "sm", target: "_blank", href: _vm.viewPreProcessorLog(row.item.id), title: "View Pre-Processor Log" } }, [_c("font-awesome-icon", { attrs: { icon: "up-right-from-square" } })], 1)], 2)];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-card", { attrs: { "body-class": "p-3 mx-auto" } }, [_c("b-row", { staticClass: "py-0" }, [_c("b-col", _vm._l(row.item.stages, function(stage, index) {
      return _c("span", { staticClass: "center" }, [_c("b-dropdown", { class: { "mx-1": index + 1 != row.item.stages.length }, attrs: { "no-flip": "", size: "sm", right: "", variant: "outline-" + _vm.getStageClass(stage) }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
        return [_c("font-awesome-icon", { attrs: { icon: _vm.getStageIcon(stage) } }), _vm._v(`
                    ` + _vm._s(_vm.getStageName(stage)) + `
                  `)];
      }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _vm._l(stage.jobs, function(job, jobIndex) {
        return _c("b-dropdown-item", { key: jobIndex, attrs: { pill: "", href: _vm.downloadJobLog(job), target: "_blank" } }, [_c("font-awesome-icon", { class: "text-" + _vm.getJobTextClass(job), attrs: { icon: _vm.getJobIcon(job) } }), _vm._v(`
                    View Log file #` + _vm._s(jobIndex + 1) + `
                  `)], 1);
      })], 2), _vm._v(" "), index + 1 != row.item.stages.length ? _c("font-awesome-icon", { staticClass: "align-middle", attrs: { size: "xs", icon: "chevron-right" } }) : _vm._e(), _vm._v(` 
              `)], 1);
    }), 0)], 1)], 1)];
  }, "fn") }]) }), _vm._v(" "), _vm.model ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.page, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.page = $$v;
  }, "callback"), expression: "page" } }) : _vm._e(), _vm._v(" "), _c("item-history-modal", { attrs: { item: { id: _vm.itemIdHistoryToShow, name: _vm.itemNameHistoryToShow }, shouldShow: _vm.showItemHistoryModal }, on: { close: _vm.closeHistoryModal } })], 1)], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  PreProcessingPage,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "0f52dec6"
);
const preProcessingPage = __component__.exports;
export {
  preProcessingPage as default
};
