var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, cD as AdministrationIntegrationsEzeScanClient, T as Transformer, b as baseUrl, cE as Routes, C as Component, L as LoadingBarComponent, n as normalizeComponent } from "./main-DAVWuHbi.js";
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a;
let AdministrationEzeScanListRoute = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "pools", null);
    __publicField(this, "instances", null);
    __publicField(this, "loadError", null);
    __publicField(this, "loading", !1);
    __publicField(this, "confirmDelete", null);
    __publicField(this, "routesModal", null);
    __publicField(this, "routesModalId", null);
    __publicField(this, "poolRoutesResponse", null);
    __publicField(this, "poolRoutesLoading", !1);
    __publicField(this, "poolRoutesError", null);
  }
  mounted() {
    this.load(), this.routesModal = $(this.$refs.routesModal), this.routesModal.on("hidden.bs.modal", (t) => {
      this.routesModalId = null;
    });
  }
  async load() {
    this.loading = !0;
    try {
      let pools2 = await new AdministrationIntegrationsEzeScanClient(new Transformer(), baseUrl()).getPools();
      this.pools = pools2.pools.sort((a, b) => a.name.localeCompare(b.name)), this.instances = pools2.instances;
    } catch (e) {
      this.loadError = e;
    } finally {
      this.loading = !1;
    }
  }
  onEdit(pool) {
    this.$router.push({ name: Routes.EditPool, params: { id: pool.id } });
  }
  onCreate() {
    this.$router.push({ name: Routes.CreatePool });
  }
  onDelete(pool) {
    this.confirmDelete && pool.id === this.confirmDelete ? this.delete(this.confirmDelete) : this.confirmDelete = pool.id;
  }
  async delete(id) {
    await new AdministrationIntegrationsEzeScanClient(new Transformer(), baseUrl()).deletePool(id), await this.load();
  }
  async showRoutes(pool) {
    this.routesModalId = pool.id, this.routesModal.modal("show"), this.poolRoutesLoading = !0, this.poolRoutesError = null, this.poolRoutesResponse = null;
    try {
      this.poolRoutesResponse = await new AdministrationIntegrationsEzeScanClient(new Transformer(), baseUrl()).getRoutesForPool(this.routesModalId);
    } catch (e) {
      this.poolRoutesError = e;
    } finally {
      this.poolRoutesLoading = !1;
    }
  }
  get routesPool() {
    if (this.routesModalId) {
      let pool = this.pools.find((p) => p.id === this.routesModalId);
      if (pool)
        return { ...pool, members: pool.members.map((m) => this.instances.find((i) => i.id === m)) };
    }
  }
  get poolRoutes() {
    if (!(!this.poolRoutesResponse || this.poolRoutesResponse.pool.id !== this.routesModalId))
      return this.poolRoutesResponse.route.map((r) => ({
        ...r,
        members: this.poolRoutesResponse.pool.members.map((m) => ({
          instance: this.instances.find((i) => i.id === m),
          route: r.members.find((rm) => m === rm.instanceId)
        }))
      })).sort((a, b) => a.name.localeCompare(b.name));
  }
}, __name(_a, "AdministrationEzeScanListRoute"), _a);
AdministrationEzeScanListRoute = __decorateClass([
  Component({
    components: { LoadingBar: LoadingBarComponent }
  })
], AdministrationEzeScanListRoute);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-6 col-sm-12" }, [_c("h4", [_vm._v(`EzeScan Pools 
            `), _c("button", { staticClass: "btn btn-success", on: { click: _vm.onCreate } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add Pool
            `)], 1)]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v(`
            Pools are groups of EzeScan server instances which can be dispatched work as a single unit
        `)]), _vm._v(" "), !_vm.loadError && !_vm.loading ? _c("div", [_vm.pools && _vm.pools.length > 0 ? _c("table", { staticClass: "table" }, [_vm._m(0), _vm._v(" "), _c("tbody", _vm._l(_vm.pools, function(pool) {
    return _c("tr", [_c("td", [_vm._v(_vm._s(pool.name))]), _vm._v(" "), _c("td", [_vm._v(_vm._s(pool.description))]), _vm._v(" "), _c("td", [_vm._v(`
                        ` + _vm._s(pool.members.length) + ` 
                         `), pool.members.length > 0 ? _c("button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-sm btn-default", attrs: { type: "button", title: "Show route information" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showRoutes(pool);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "clipboard-list" } })], 1) : _vm._e()]), _vm._v(" "), _c("td", [_c("span", { staticClass: "float-right" }, [_vm.confirmDelete != pool.id ? _c("span", [_c("button", { staticClass: "btn btn-sm btn-primary", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.onEdit(pool);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(` Edit
                                `)], 1)]) : _vm._e(), _vm._v(" "), _vm.confirmDelete === pool.id ? _c("span", [_c("button", { staticClass: "btn btn-sm btn-default", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.confirmDelete = null;
    }, "click") } }, [_vm._v("Cancel")])]) : _vm._e(), _vm._v(" "), _c("button", { staticClass: "btn btn-sm btn-danger", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.onDelete(pool);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` 
                                `), _vm.confirmDelete === pool.id ? _c("span", [_vm._v("Confirm")]) : _c("span", [_vm._v("Delete")])], 1)])])]);
  }), 0)]) : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
                No EzeScan Instances currently configured. `), _c("a", { staticClass: "alert-link", attrs: { href: "javascript:void(0)", role: "button" }, on: { click: _vm.onCreate } }, [_vm._v("Create one?")])])]) : _vm.loadError && !_vm.loading ? _c("div", [_vm._v(`
            Some error
        `)]) : _c("div", [_vm._v(`
            Loading...
        `)])]), _vm._v(" "), _c("div", { ref: "routesModal", staticClass: "modal", attrs: { tabindex: "-1", role: "dialog" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_vm.routesPool ? _c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title" }, [_vm._v("Routes for Pool - " + _vm._s(_vm.routesPool.name))]), _vm._v(" "), _vm._m(1)]) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_vm.poolRoutesLoading ? _c("loading-bar") : _vm.poolRoutes ? _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_c("table", { staticClass: "table table-responsive" }, [_c("thead", [_c("tr", [_c("th", [_vm._v("Route")]), _vm._v(" "), _c("th")])]), _vm._v(" "), _c("tbody", _vm._l(_vm.poolRoutes, function(route) {
    return _c("tr", [_c("td", [_vm._v(`
                                        ` + _vm._s(route.name) + `
                                    `)]), _vm._v(" "), _c("td", [_vm._l(route.members, function(member) {
      return [_c("div", { staticClass: "badge", class: { "badge-success": member.route, "badge-danger": !member.route } }, [_vm._v(`
                                                ` + _vm._s(member.instance.name) + `
                                            `)]), _vm._v(` 
                                        `)];
    })], 2)]);
  }), 0)])])]) : _vm._e()], 1), _vm._v(" "), _vm._m(2)])])])]);
}, "render"), _sfc_staticRenderFns = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("thead", [_c("tr", [_c("th", [_vm._v("Name")]), _vm._v(" "), _c("th", [_vm._v("Description")]), _vm._v(" "), _c("th", [_vm._v("# Instances")]), _vm._v(" "), _c("th")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-secondary", attrs: { type: "button", "data-dismiss": "modal" } }, [_vm._v("Close")])]);
}], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationEzeScanListRoute,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "bc608116"
);
const pools = __component__.exports;
export {
  pools as default
};
