var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, cD as AdministrationIntegrationsEzeScanClient, T as Transformer, b as baseUrl, cE as Routes, C as Component, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { i as isUrl } from "./isURL-BKWXD2PE.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a;
let AdministrationEzeScanPoolRoute = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "saving", !1);
    __publicField(this, "savingError", null);
    __publicField(this, "pool", { id: null, name: null, description: null, members: [], disabled: !1 });
    __publicField(this, "testing", !1);
    __publicField(this, "testSuccess", !1);
    __publicField(this, "testFailure", null);
    __publicField(this, "cachedServers", []);
    __publicField(this, "loadingServers", !1);
  }
  async created() {
    this.poolId && await this.load(), await this.loadServers(), this.$validator.extend("localUrl", url);
  }
  async load() {
    this.loading = !0, this.loadingError = null;
    try {
      this.pool = await new AdministrationIntegrationsEzeScanClient(new Transformer(), baseUrl()).getPool(this.poolId);
    } catch (e) {
      this.loadingError = e;
    } finally {
      this.loading = !1;
    }
  }
  get poolId() {
    return this.$router.currentRoute.params.id;
  }
  get canSubmit() {
    return !this.$validator.errors.any();
  }
  onSave() {
    return this.save();
  }
  async save() {
    this.saving = !0;
    let client = new AdministrationIntegrationsEzeScanClient(new Transformer(), baseUrl()), update = {
      name: this.pool.name,
      description: this.pool.description,
      members: this.pool.members,
      enabled: !0
    };
    try {
      this.poolId ? await client.updatePool(this.poolId, update) : await client.createPool(update), this.$router.push({ name: Routes.Pools });
    } catch (e) {
      this.savingError = e;
    } finally {
      this.saving = !1;
    }
  }
  onCancel() {
    this.$router.back();
  }
  get members() {
    return this.pool.members.map((m) => this.cachedServers.find((i) => i.id == m) || { id: m, name: m });
  }
  get serverOptions() {
    return this.cachedServers.filter((s) => !this.pool.members.includes(s.id)).map((s) => ({
      id: s.id,
      name: s.name
    }));
  }
  async loadServers() {
    this.loadingServers = !0;
    let servers = await new AdministrationIntegrationsEzeScanClient(new Transformer(), baseUrl()).getInstances();
    this.cachedServers = servers, this.loadingServers = !1;
  }
  selectedServer(server) {
    this.pool.members.includes(server) || this.pool.members.push(server);
  }
  removeMember(id) {
    let matched = this.pool.members.findIndex((value) => value === id);
    matched !== -1 && this.pool.members.splice(matched, 1);
  }
}, __name(_a, "AdministrationEzeScanPoolRoute"), _a);
AdministrationEzeScanPoolRoute = __decorateClass([
  Component({
    components: { ReactiveDropdown }
  })
], AdministrationEzeScanPoolRoute);
function url(value) {
  return isUrl(value, {
    require_tld: !1,
    require_protocol: !0
  });
}
__name(url, "url");
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_vm.poolId ? _c("h4", [_vm._v("Edit EzeScan Server Pool")]) : _c("h4", [_vm._v("Create new EzeScan Server Pool")])]), _vm._v(" "), _c("div", { staticClass: "col-md-6 col-sm-12" }, [_vm.loading ? _c("div", [_vm._v(`
            Loading
            `), _c("br"), _vm._v(" "), _c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } })], 1) : _vm.loadingError ? _c("div", [_vm._v(`
            ` + _vm._s(_vm.loadingError) + `
        `)]) : [_c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("name") } }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }, { name: "model", rawName: "v-model", value: _vm.pool.name, expression: "pool.name" }], staticClass: "form-control", attrs: { type: "text", "data-vv-as": "EzeScan Instance Name", name: "name" }, domProps: { value: _vm.pool.name }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.pool, "name", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Name for the EzeScan pool")]), _vm._v(" "), _vm.errors.has("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("name")))]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("endpoint") } }, [_c("label", [_vm._v("Description")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.pool.description, expression: "pool.description" }], staticClass: "form-control", attrs: { name: "description", type: "text" }, domProps: { value: _vm.pool.description }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.pool, "description", $event.target.value);
  }, "input") } })]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Instances")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { loading: _vm.loadingServers, options: _vm.serverOptions }, on: { click: _vm.loadServers, input: _vm.selectedServer } }, [_vm._v("Add Instance")])], 1), _vm._v(" "), _vm.members && _vm.members.length > 0 ? [_c("table", { staticClass: "table table-responsive" }, [_c("th", { staticClass: "col" }, [_vm._v("Name")]), _vm._v(" "), _c("th", { staticClass: "col" }), _vm._v(" "), _vm._l(_vm.members, function(member) {
    return _c("tr", [_c("td", [_vm._v(_vm._s(member.name))]), _vm._v(" "), _c("td", [_c("span", { staticClass: "float-right" }, [_c("button", { staticClass: "btn btn-sm btn-danger" }, [_c("font-awesome-icon", { attrs: { icon: "trash" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.removeMember(member.id);
    }, "click") } })], 1)])])]);
  })], 2)] : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
                No members in this pool
            `)]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button" }, on: { click: _vm.onCancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", attrs: { type: "button", disabled: _vm.saving || !_vm.canSubmit }, on: { click: _vm.onSave } }, [_vm.saving ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(`
                     Saving...
                `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(`
                     Save
                `)], 1)])]), _vm._v(" "), _vm.savingError ? _c("div", [_vm._v(`
                ` + _vm._s(_vm.savingError) + `
            `)]) : _vm._e()]], 2)]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationEzeScanPoolRoute,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "278bad3f"
);
const pool = __component__.exports;
export {
  pool as default
};
