var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { bq as AdministrationAuthorisationClient, T as Transformer, b as baseUrl, P as Prop, C as Component, L as LoadingBarComponent, V as Vue, br as $, a2 as AdministrationAuthenticationClient, ag as AuthenticationProviders, t as toastr, n as normalizeComponent } from "./main-DAVWuHbi.js";
import TemplateSummary from "./templateSummary-BsyF-Lep.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
async function queryAuthorisation(searchTerm) {
  return await new AdministrationAuthorisationClient(new Transformer(), baseUrl()).queryAuthorisation({ Terms: [{ Term: searchTerm }] });
}
__name(queryAuthorisation, "queryAuthorisation");
async function checkProviderQuery() {
  return await new AdministrationAuthorisationClient(new Transformer(), baseUrl()).canQuery();
}
__name(checkProviderQuery, "checkProviderQuery");
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let PermissionsEditor = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "restricted");
    __publicField(this, "hideRevoke");
    __publicField(this, "header");
    __publicField(this, "resource");
    __publicField(this, "filterText");
    __publicField(this, "elementId");
    __publicField(this, "searchTerm", null);
    __publicField(this, "results", null);
    __publicField(this, "searching", !1);
    __publicField(this, "searchingError", null);
    __publicField(this, "canQuery", !0);
    __publicField(this, "advanced", !1);
    __publicField(this, "usingEIM", !1);
    __publicField(this, "modalShown", !1);
    __publicField(this, "principalOptions", [
      {
        id: "user",
        name: "User",
        icon: "user"
      }
    ]);
  }
  async mounted() {
    $(this.$el).find(".modal.user-modal").on("shown.bs.modal", () => {
      this.modalShown = !0;
    }), $(this.$el).find(".modal.user-modal").on("hidden.bs.modal", () => {
      this.modalShown = !1;
    }), await this.setAuthenticationProvider();
  }
  get permissions() {
    return this.value;
  }
  set permissions(value) {
    this.$emit("input", value);
  }
  addPermission() {
    this.showModal();
  }
  addPermissionEntry() {
    this.permissions = [...this.permissions, { principal: { type: "user", id: null, name: null }, grant: !0 }];
  }
  allow(entry) {
    let existingPermission = this.permissions.find((p) => p.principal.id == entry.id && p.principal.type == entry.type), newPermissions = this.permissions.slice();
    if (!existingPermission)
      newPermissions.push({ grant: !0, principal: entry });
    else {
      let newEntry = { ...existingPermission, grant: !0 };
      newPermissions.splice(newPermissions.findIndex((v) => v.principal.type == entry.type && v.principal.id == entry.id), 1, newEntry);
    }
    this.permissions = newPermissions;
  }
  deny(entry) {
    let newPermissions = this.permissions.slice(), existingPermission = this.permissions.find((p) => p.principal.id == entry.id && p.principal.type == entry.type);
    if (!existingPermission)
      newPermissions.push({ grant: !1, principal: entry });
    else {
      let newEntry = { ...existingPermission, grant: !1 };
      newPermissions.splice(newPermissions.findIndex((v) => v.principal.type == entry.type && v.principal.id == entry.id), 1, newEntry);
    }
    this.permissions = newPermissions;
  }
  remove(entry) {
    let newPermissions = this.permissions.slice(), index = newPermissions.findIndex((g) => g.principal.type === entry.type && g.principal.id === entry.id);
    index < 0 || (newPermissions.splice(index, 1), this.permissions = newPermissions);
  }
  async search() {
    this.searching = !0, this.results = null, this.searchingError = null;
    try {
      this.results = await queryAuthorisation(this.searchTerm);
    } catch (ex) {
      this.searchingError = ex;
    } finally {
      this.searching = !1;
    }
  }
  isAllowed(result) {
    let permission = this.permissions.find((v) => v.principal.type == result.type && v.principal.id == result.id);
    return permission ? permission.grant : !1;
  }
  hasPermission(entry) {
    return !!this.permissions.find((v) => v.principal.type == entry.type && v.principal.id == entry.id);
  }
  getPermissionIcon(entry) {
    switch (entry.type) {
      case "user":
        return "user";
      case "profile":
        return "user-cog";
      case "role":
        return "users";
      case "ewaGroup":
        return "users-class";
      default:
        return "question";
    }
  }
  showModal() {
    this.modalShown || ($(this.$el).find(".modal.user-modal").modal("show"), this.checkProviderQuery());
  }
  hideModal() {
    this.modalShown && $(this.$el).find(".modal.user-modal").modal("hide");
  }
  async checkProviderQuery() {
    if (this.canQuery === null)
      try {
        this.canQuery = await new AdministrationAuthorisationClient(new Transformer(), baseUrl()).canQuery();
      } catch (e) {
        throw e;
      }
  }
  async setAuthenticationProvider() {
    new AdministrationAuthenticationClient(new Transformer(), baseUrl()).getAuthenticationSettings().then((model) => {
      model.provider === AuthenticationProviders.EzeScanIdentityManagement && (this.usingEIM = !0);
    }).catch((e) => {
      toastr.error("Something has gone wrong while loading the Authentication settings: " + e);
    }).finally(() => {
      this.usingEIM || (this.principalOptions.push({ id: "role", name: "Group", icon: "users" }), this.principalOptions.push({ id: "ewaGroup", name: "EWA Group", icon: "users-class" }));
    });
  }
}, __name(_a, "PermissionsEditor"), _a);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => [], "default")
  })
], PermissionsEditor.prototype, "value", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], PermissionsEditor.prototype, "restricted", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], PermissionsEditor.prototype, "hideRevoke", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => "Permissions", "default")
  })
], PermissionsEditor.prototype, "header", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], PermissionsEditor.prototype, "resource", 2);
__decorateClass([
  Prop({
    required: !1,
    default: ""
  })
], PermissionsEditor.prototype, "filterText", 2);
__decorateClass([
  Prop({
    required: !1,
    default: ""
  })
], PermissionsEditor.prototype, "elementId", 2);
PermissionsEditor = __decorateClass([
  Component({
    components: { ReactiveDropdown, TemplateSummary, LoadingBar: LoadingBarComponent }
  })
], PermissionsEditor);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "permissions", attrs: { id: _vm.elementId + "permissions" } }, [_c("div", [_c("h5", [_vm._v(_vm._s(_vm.header) + ` 
            `), _c("button", { staticClass: "btn btn-sm btn-success", attrs: { disabled: _vm.modalShown, type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return $event.stopPropagation(), _vm.addPermission.apply(null, arguments);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add Permission
            `)], 1)]), _vm._v(" "), _vm.value && _vm.value.length > 0 ? _c("div", [_c("table", { staticClass: "table table-sm table-striped mb-0" }, [_vm._m(0), _vm._v(" "), _c("tbody", _vm._l(_vm.permissions, function(permission, index) {
    return _c("tr", { key: index }, [_c("td", [_c("span", { staticClass: "align-middle" }, [permission.principal.type == "role" ? _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "Role permissions have been deprecated. It is recommended to use EWA Groups instead." } }, [_c("font-awesome-icon", { staticClass: "text-warning", attrs: { icon: "exclamation-triangle" } })], 1) : _vm._e(), _vm._v(" "), _c("font-awesome-icon", { attrs: { icon: _vm.getPermissionIcon(permission.principal) } }), _vm._v(` 
                            `), permission.principal.name ? _c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(permission.principal.name, _vm.filterText)) } }) : _c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(permission.principal.id, _vm.filterText)) } })], 1)]), _vm._v(" "), _c("td", [_c("span", { staticClass: "align-middle" }, [permission.principal.email ? _c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(permission.principal.email, _vm.filterText)) } }) : _c("span")])]), _vm._v(" "), _c("td", [_c("span", { staticClass: "float-right" }, [_c("button", { staticClass: "btn btn-sm", class: {
      "btn-default": _vm.hasPermission(permission.principal) && !_vm.isAllowed(permission.principal),
      "btn-success": _vm.hasPermission(permission.principal) && _vm.isAllowed(permission.principal)
    }, attrs: { type: "button", id: "grant" + permission.principal.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.allow(permission.principal);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(` Grant
                            `)], 1), _vm._v(" "), _vm.hideRevoke ? _vm._e() : _c("button", { staticClass: "btn btn-sm", class: {
      "btn-default": _vm.hasPermission(permission.principal) && _vm.isAllowed(permission.principal),
      "btn-danger": _vm.hasPermission(permission.principal) && !_vm.isAllowed(permission.principal)
    }, attrs: { type: "button", id: "deny" + permission.principal.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deny(permission.principal);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Revoke
                            `)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default btn-sm", attrs: { type: "button", id: "remove" + permission.principal.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.remove(permission.principal);
    }, "click") } }, [_vm._v(`
                                Remove
                            `)])])])]);
  }), 0)])]) : _c("p", { staticClass: "text-muted" }, [_c("i", [_vm._v("No permissions set")])]), _vm._v(" "), _c("div", { staticClass: "modal fade user-modal", attrs: { tabindex: "-1", role: "dialog" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_vm._m(1), _vm._v(" "), _c("div", { staticClass: "modal-body", attrs: { id: _vm.elementId + "Modal" } }, [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-sm-12" }, [_vm.canQuery && _vm.advanced ? _c("a", { attrs: { href: "#", role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.advanced = !1;
  }, "click") } }, [_vm._v("Basic editor")]) : _vm._e(), _vm._v(" "), _vm.advanced ? _vm._e() : _c("a", { attrs: { href: "#", role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.advanced = !0;
  }, "click") } }, [_vm._v("Advanced editor")])])]), _vm._v(" "), _vm.canQuery === !0 && !_vm.advanced ? [_c("div", { staticClass: "permission-search" }, [_c("div", { staticClass: "input-group" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.searchTerm, expression: "searchTerm" }], staticClass: "form-control", attrs: { type: "text", placeholder: "Find permissible entity...", id: _vm.elementId + "SearchInput" }, domProps: { value: _vm.searchTerm }, on: { keyup: /* @__PURE__ */ __name(function($event) {
    return !$event.type.indexOf("key") && _vm._k($event.keyCode, "enter", 13, $event.key, "Enter") ? null : _vm.search.apply(null, arguments);
  }, "keyup"), input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.searchTerm = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("div", { staticClass: "input-group-append" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", id: _vm.elementId + "Search" }, on: { click: _vm.search } }, [_c("font-awesome-icon", { attrs: { icon: "search" } })], 1)])])]), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12 form-group" }, [_vm.searching ? _c("div", { staticClass: "text-center" }, [_c("loading-bar", [_vm._v("Loading results")])], 1) : _vm.searchingError ? _c("div", [_vm._v(_vm._s(_vm.searchingError))]) : _vm.results ? _c("div", [_c("b-table", { attrs: { striped: "", hover: "", fields: [{ key: "name" }, { key: "email" }, { key: "actions", label: "" }], items: _vm.results }, scopedSlots: _vm._u([{ key: "cell(name)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("font-awesome-icon", { attrs: { icon: _vm.getPermissionIcon(data.item) } }), _vm._v(`
                                           `), _c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(data.item.name, _vm.filterText)) } })];
  }, "fn") }, { key: "cell(email)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(`
                                         `), _c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(data.item.email, _vm.filterText)) } })];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_c("b-button", { class: { "btn-default": !_vm.isAllowed(data.item), "btn-success": _vm.hasPermission(data.item) && _vm.isAllowed(data.item) }, attrs: { size: "sm", id: "searchGrant" + data.item.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.allow(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(` Grant
                                            `)], 1), _vm._v(" "), _vm.hideRevoke ? _vm._e() : _c("b-button", { class: { "btn-default": !_vm.hasPermission(data.item) == !_vm.isAllowed(data.item), "btn-danger": _vm.hasPermission(data.item) && !_vm.isAllowed(data.item) }, attrs: { size: "sm", id: "searchDeny" + data.item.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deny(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Revoke
                                            `)], 1), _vm._v(" "), _vm.hasPermission(data.item) ? _c("b-button", { staticClass: "btn btn-sm btn-default", attrs: { size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.remove(data.item);
    }, "click") } }, [_vm._v("Remove")]) : _vm._e()], 1)];
  }, "fn") }], null, !1, 477868638) })], 1) : _vm._e()])])] : _vm.canQuery === !1 || _vm.advanced ? [_c("table", { staticClass: "table table-striped" }, [_vm._m(2), _vm._v(" "), _c("tbody", _vm._l(_vm.permissions, function(permission, idx) {
    return _c("tr", [_c("td", [_c("reactive-dropdown", { attrs: { value: permission.principal.type, options: _vm.principalOptions }, on: { input: /* @__PURE__ */ __name(function($event) {
      permission.principal.type = $event;
    }, "input") } })], 1), _vm._v(" "), _c("td", [_c("span", { staticClass: "align-middle" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: permission.principal.id, expression: "permission.principal.id" }], staticClass: "form-control", attrs: { type: "text" }, domProps: { value: permission.principal.id }, on: { input: /* @__PURE__ */ __name(function($event) {
      $event.target.composing || _vm.$set(permission.principal, "id", $event.target.value);
    }, "input") } })])]), _vm._v(" "), _c("td", [_c("span", { staticClass: "float-right" }, [_c("button", { staticClass: "btn btn-sm", class: {
      "btn-default": _vm.hasPermission(permission.principal) && !_vm.isAllowed(permission.principal),
      "btn-success": _vm.hasPermission(permission.principal) && _vm.isAllowed(permission.principal)
    }, attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      permission.grant = !0;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(` Grant
                                            `)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-sm", class: {
      "btn-default": _vm.hasPermission(permission.principal) && _vm.isAllowed(permission.principal),
      "btn-danger": _vm.hasPermission(permission.principal) && !_vm.isAllowed(permission.principal)
    }, attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      permission.grant = !1;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Deny
                                            `)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default btn-sm", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.permissions.splice(idx, 1);
    }, "click") } }, [_vm._v(`
                                                Remove
                                            `)])])])]);
  }), 0)]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.addPermissionEntry();
  }, "click") } }, [_vm._v("Add")])] : [_c("loading-bar")]], 2), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-primary", attrs: { type: "button" }, on: { click: _vm.hideModal } }, [_vm._v("Done")])])])])])])]);
}, "render"), _sfc_staticRenderFns = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("thead", [_c("tr", [_c("th", [_vm._v("Name")]), _vm._v(" "), _c("th", [_vm._v("Email")]), _vm._v(" "), _c("th")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal-header" }, [_c("h4", { staticClass: "modal-title" }, [_vm._v("Modify Permissions")]), _vm._v(" "), _c("a", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("thead", [_c("tr", [_c("th", [_vm._v("Type")]), _vm._v(" "), _c("th", [_vm._v("Value")]), _vm._v(" "), _c("th", [_vm._v(" ")])])]);
}], __component__ = /* @__PURE__ */ normalizeComponent(
  PermissionsEditor,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "fc012ad2"
);
const PermissionEditor = __component__.exports;
export {
  PermissionEditor as P,
  checkProviderQuery as c,
  queryAuthorisation as q
};
