var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, cg as ItemProcessorStageStatus, n as normalizeComponent, d as IndexingClient, T as Transformer, b as baseUrl } from "./main-DAVWuHbi.js";
import { P as ProcessorStageStatusIcon } from "./processorStageStatusIcon-CqRJC9mu.js";
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a;
let ProcessorStageStatusIconComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "status");
    __publicField(this, "name");
  }
  get icon() {
    switch (this.status) {
      case ItemProcessorStageStatus.Queued:
        return "pause-circle";
      case ItemProcessorStageStatus.Running:
        return "circle-ellipsis";
      case ItemProcessorStageStatus.Successful:
        return "check-circle";
      case ItemProcessorStageStatus.Cancelled:
        return "ban";
      case ItemProcessorStageStatus.Skipped:
        return "circle-chevron-right";
      case ItemProcessorStageStatus.Failed:
        return "times-circle";
    }
  }
  get colour() {
    switch (this.status) {
      case ItemProcessorStageStatus.Running:
        return "primary";
      case ItemProcessorStageStatus.Successful:
        return "success";
      case ItemProcessorStageStatus.Queued:
      case ItemProcessorStageStatus.Cancelled:
      case ItemProcessorStageStatus.Skipped:
        return "secondary";
      case ItemProcessorStageStatus.Failed:
        return "danger";
    }
  }
  get tooltip() {
    switch (this.status) {
      case ItemProcessorStageStatus.Queued:
        return "Queued";
      case ItemProcessorStageStatus.Running:
        return "Running";
      case ItemProcessorStageStatus.Successful:
        return "Successful";
      case ItemProcessorStageStatus.Cancelled:
        return "Cancelled";
      case ItemProcessorStageStatus.Skipped:
        return "Skipped";
      case ItemProcessorStageStatus.Failed:
        return "Failed";
    }
  }
  stageName() {
    return this.name ? this.name : "Stage not found";
  }
}, __name(_a, "ProcessorStageStatusIconComponent"), _a);
__decorateClass$1([
  Prop({
    required: !0
  })
], ProcessorStageStatusIconComponent.prototype, "status", 2);
__decorateClass$1([
  Prop({
    required: !0
  })
], ProcessorStageStatusIconComponent.prototype, "name", 2);
ProcessorStageStatusIconComponent = __decorateClass$1([
  Component({
    components: { ProcessorStageStatusIcon }
  })
], ProcessorStageStatusIconComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("span", { class: "text-" + _vm.colour }, [_c("processor-stage-status-icon", { attrs: { status: _vm.status } }), _vm._v(`
  ` + _vm._s(_vm.stageName()) + `
`)], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  ProcessorStageStatusIconComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "f87d9147"
);
const ProcessorStageDisplay = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a2;
let PendingItemComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
    __publicField(this, "itemStatusModel", null);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "errorMessage", null);
  }
  mounted() {
    this.GetItemStatus(), this.reloadTimer = setInterval(() => this.GetItemStatus(), 500);
  }
  async GetItemStatus() {
    var _a3, _b, _c, _d;
    try {
      let client = new IndexingClient(new Transformer(), baseUrl());
      this.itemStatusModel = await client.getItemStatus(this.model.processorId, this.model.itemId, this.model.enqueued);
    } catch (ex) {
      ex && ex.message && ex.message != "NetworkError when attempting to fetch resource." && (this.errorMessage = ex.message);
    } finally {
      if (((_b = (_a3 = this.itemStatusModel) == null ? void 0 : _a3.item) == null ? void 0 : _b.status) === "indexed" && (this.redirectToQueue(), clearTimeout(this.reloadTimer)), ((_d = (_c = this.itemStatusModel) == null ? void 0 : _c.item) == null ? void 0 : _d.status) === "enqueued") {
        if (!this.itemStatusModel.processor && this.model.enqueued) {
          this.reloadTimer && clearTimeout(this.reloadTimer), this.redirectToItem();
          return;
        }
        if (this.itemStatusModel.processor.runsPreProcessors && !this.itemStatusModel.processor.preProcessorComplete)
          return;
        this.reloadTimer && clearTimeout(this.reloadTimer), this.redirectToItem();
      }
    }
  }
  redirectToItem() {
    let url = baseUrl();
    url += "/app/indexing/items/" + this.model.itemId + "#/", this.model.filter && this.model.sourceQueueId ? url += "?filter=" + this.model.filter + "&sourceQueueId=" + this.model.sourceQueueId : (this.model.filter && (url += "?filter=" + this.model.filter), this.model.sourceQueueId && (url += "?sourceQueueId=" + this.model.sourceQueueId)), window.location.href = url;
  }
  redirectToQueue() {
    let url = baseUrl();
    url += "/app/indexing/queues/" + this.itemStatusModel.item.queueId + "/list/", this.model.filter && (url += "?filter=" + this.model.filter), this.model.sourceQueueId && (url += "?sourceQueueId=" + this.model.sourceQueueId), window.location.href = url;
  }
}, __name(_a2, "PendingItemComponent"), _a2);
__decorateClass([
  Prop({ required: !0 })
], PendingItemComponent.prototype, "model", 2);
PendingItemComponent = __decorateClass([
  Component({
    components: { ProcessorStageDisplay, ProcessorStageStatusIcon }
  })
], PendingItemComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-card", { staticStyle: { border: "0px", height: "75vh!important" }, attrs: { "no-body": "" } }, [_c("b-card-body", { staticClass: "d-flex p-0" }, [_c("div", { staticClass: "my-auto mx-auto" }, [_vm.errorMessage ? _c("span", [_c("b-alert", { attrs: { show: "", variant: "danger" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
          ` + _vm._s(_vm.errorMessage) + `
        `)], 1)], 1) : _c("span", { staticClass: "text-center" }, [_c("h5", { staticClass: "mb-4" }, [_vm._v("Processing...")]), _vm._v(" "), _c("div", { staticClass: "text-primary my-3" }, [_c("b-spinner", { staticStyle: { width: "5rem", height: "5rem" } })], 1), _vm._v(" "), _vm.itemStatusModel && _vm.itemStatusModel.processor && _vm.itemStatusModel.processor.stages ? _c("div", _vm._l(_vm.itemStatusModel.processor.stages, function(stage, index) {
    return _c("span", [_c("processor-stage-display", { attrs: { status: stage.status, name: stage.details.name } }), _vm._v(" "), index + 1 != _vm.itemStatusModel.processor.stages.length ? _c("span", { staticClass: "mr-1" }, [_c("font-awesome-icon", { attrs: { icon: "arrow-right" } })], 1) : _vm._e()], 1);
  }), 0) : _vm._e()])])])], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  PendingItemComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  null
);
const pendingItem = __component__.exports;
export {
  pendingItem as default
};
