var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, cB as Keys, cC as Routes, C as Component, L as LoadingBarComponent } from "./main-DAVWuHbi.js";
const template = `<div>\r
    <loading-bar v-if="refreshing"></loading-bar>\r
    <div class="content" v-if="pages.length > 0">\r
        <table class="table">\r
            <thead>\r
                <tr>\r
                    <th>Page</th>\r
                    <th>Type</th>\r
                    <th></th>\r
                </tr>\r
            </thead>\r
            <tbody>\r
                <tr v-for="page in pages">\r
                    <td>{{page.name}}</td>\r
                    <td>{{page.type}}</td>\r
                    <td>\r
                        <button class="btn btn-info" @click="managePage(page)"><font-awesome-icon icon="cog"></font-awesome-icon>&nbsp;Manage</button>\r
                    </td>\r
                </tr>\r
            </tbody>\r
        </table>\r
    </div>\r
    <!--TODO add error alert component?-->\r
    <div v-else-if="loadError" class="alert alert-danger">\r
        Failed to load pages. Contact administrator for assistance.\r
    </div>\r
    <div class="alert alert-info" v-else>\r
        You currently don't have access to any pages. Contact your WebApps administrator to gain access to pages.\r
    </div>\r
</div>\r
`;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a;
let PagesListRoute = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "refreshing", !1);
    __publicField(this, "loadError", null);
  }
  mounted() {
    this.refreshing = !0, this.$store.dispatch(Keys.actions.REFRESH_PAGES).catch((reason) => {
      this.loadError = reason;
    }).then(() => this.refreshing = !1);
  }
  get pages() {
    return this.$store.state.account.pages.pages || [];
  }
  managePage(page) {
    this.$router.push({ name: Routes.Page, params: {
      id: page.id
    } });
  }
}, __name(_a, "PagesListRoute"), _a);
PagesListRoute = __decorateClass([
  Component({
    template,
    name: "account-pages",
    components: {
      "loading-bar": LoadingBarComponent
    }
  })
], PagesListRoute);
export {
  PagesListRoute as default
};
