var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, a7 as AdministrationPagesClient, T as Transformer, b as baseUrl, t as toastr, C as Component, N as CheckIcon, f as draggable, L as LoadingBarComponent, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { I as IconSelect } from "./iconSelect-BeUqYgP_.js";
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a;
let AppPageGroupsConfigurationComponent$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "configModel", {});
    __publicField(this, "newGroupName", "");
    __publicField(this, "loading", !1);
    __publicField(this, "saving", !1);
    __publicField(this, "editingGroup", null);
    __publicField(this, "moving", !1);
    __publicField(this, "confirmDeleteId", null);
    __publicField(this, "sortOrderAsc", !0);
  }
  async mounted() {
    this.loading = !0, this.saving = !0;
    try {
      let model = await new AdministrationPagesClient(new Transformer(), baseUrl()).getAppPageGroups();
      this.configModel = model;
    } catch (e) {
      toastr.error("Something has gone wrong while loading the AppPage Groups: " + e);
    } finally {
      this.loading = !1, this.saving = !1;
    }
  }
  get model() {
    return this.configModel;
  }
  set model(value) {
    this.configModel = value;
  }
  get editing() {
    return this.editingGroup;
  }
  set editing(value) {
    this.editingGroup = value;
  }
  get configuredGroups() {
    return this.model.groups;
  }
  set configuredGroups(value) {
    this.model.groups = value;
  }
  get availablePages() {
    return this.model.ungroupedPages;
  }
  set availablePages(value) {
    this.model.ungroupedPages = value;
  }
  sortPages() {
    var _a2;
    this.editing.pages.sort((a, b) => a.name.localeCompare(b.name)), this.sortOrderAsc || (_a2 = this.editing.pages) == null || _a2.reverse(), this.sortOrderAsc = !this.sortOrderAsc;
  }
  async saveGroups(showMessage = !0) {
    this.loading = !0;
    try {
      let model = await new AdministrationPagesClient(new Transformer(), baseUrl()).setAppPageGroups(this.configModel);
      showMessage && toastr.success("AppPage groups successfully saved");
    } catch (e) {
      toastr.error("Something has gone wrong while saving the AppPage groups: " + e);
    } finally {
      this.loading = !1;
    }
  }
  addPageToGroup(page, group) {
    console.log("Adding page " + page.name + " to group " + group.groupName), group.pages.push(page), this.availablePages = this.availablePages.filter((obj) => obj !== page);
  }
  removePageFromGroup(page, group) {
    console.log("Removing page " + page.name + " from group " + group.groupName), group.pages = group.pages.filter((obj) => obj !== page), this.availablePages.push(page);
  }
  addGroup() {
    let newGroup = {};
    newGroup.groupName = "", newGroup.pages = [], newGroup.enableMoveItems = !1, newGroup.moveItemsName = "", newGroup.icon = "", this.configuredGroups.push(newGroup), this.newGroupName = "", this.editing = newGroup;
  }
  async removeGroup(group) {
    this.configuredGroups = this.configuredGroups.filter((obj) => obj !== group), this.confirmDeleteId = null, group.pages.forEach((obj) => this.availablePages.push(obj)), await this.saveGroups(!1), toastr.info((this.editing.groupName == "" ? "The group" : this.editing.groupName) + " has been deleted"), this.editing = null;
  }
  removePageFromAvailablePages(page) {
    this.availablePages.forEach((item, index) => {
      item === page && this.availablePages.splice(index, 1);
    });
  }
  async cancel() {
    this.moving = !0;
    try {
    } catch (e) {
      toastr.error(e, "Failed to reorder items");
    } finally {
      this.moving = !1;
    }
  }
}, __name(_a, "AppPageGroupsConfigurationComponent"), _a);
AppPageGroupsConfigurationComponent$1 = __decorateClass([
  Component({
    components: {
      LoadingBar: LoadingBarComponent,
      IconSelect,
      draggable,
      CheckIcon
    }
  })
], AppPageGroupsConfigurationComponent$1);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_vm.loading ? _c("div", [_c("loading-bar")], 1) : _vm._e(), _vm._v(" "), _c("b-row", [_c("b-col", [_c("h4", [_c("font-awesome-icon", { attrs: { icon: "list" } }), _vm._v(` App Page Groups
      `), _c("b-button", { attrs: { variant: "primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.addGroup();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(" Add Group")], 1), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { variant: "success", disabled: _vm.saving }, on: { click: _vm.saveGroups } }, [_vm.saving ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(" Saving...")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1)])], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", { attrs: { cols: "6" } }, [_vm.configuredGroups && _vm.configuredGroups.length ? _c("div", [_c("draggable", { staticClass: "list-group mb-2", attrs: { name: "configuredGroupsDraggable", tag: "div", options: { disabled: _vm.moving } }, model: { value: _vm.configuredGroups, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.configuredGroups = $$v;
  }, "callback"), expression: "configuredGroups" } }, _vm._l(_vm.configuredGroups, function(group, index) {
    return _c("a", { key: group.groupName, staticClass: "list-group-item list-group-item-action smtp-rule", class: { active: group === _vm.editing }, attrs: { href: "javascript:void(0)" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.editing = group;
    }, "click") } }, [_c("h4", { staticClass: "list-group-item-heading" }, [group.icon ? _c("font-awesome-icon", { attrs: { icon: group.icon } }) : _vm._e(), _vm._v(" "), group.groupName ? [_vm._v(_vm._s(group.groupName) + " "), _c("b-badge", { attrs: { variant: "info", size: "sm", pill: "" } }, [_vm._v(_vm._s(group.pages.length))])] : [_vm._v("Unnamed Group")], _vm._v(" "), _c("span", { staticClass: "float-right" }, [group === _vm.editing ? _c("font-awesome-icon", { attrs: { icon: "arrow-right" } }) : _vm._e()], 1)], 2), _vm._v(" "), _c("span", { staticClass: "clearfix" }), _vm._v(" "), _vm._l(group.pages, function(page) {
      return _c("span", [_c("b-badge", { staticClass: "mr-1", attrs: { variant: "info", size: "sm", pill: "" } }, [_vm._v(_vm._s(page.name))])], 1);
    })], 2);
  }), 0)], 1) : _c("div", { staticClass: "alert alert-info" }, [_vm._v("No groups are currently configured")])]), _vm._v(" "), _vm.editing ? _c("b-col", { attrs: { cols: "6" } }, [_c("h4", [_vm._v(`
      Edit Group
      `), _c("span", { staticClass: "float-right" }, [_vm.confirmDeleteId === _vm.editing.groupName ? _c("span", [_c("b-button", { attrs: { variant: "danger", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.removeGroup(_vm.editing);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Confirm
              `)], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.confirmDeleteId = null;
  }, "click") } }, [_vm._v("Cancel")])], 1) : _c("span", [_c("b-button", { attrs: { variant: "danger", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.confirmDeleteId = _vm.editing.groupName;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(`
              Delete Group
            `)], 1)], 1)])]), _vm._v(" "), _c("b-form-group", { attrs: { id: "groupNameInputLabel", label: "Group Name", "label-for": "groupNameInputLabel" } }, [_c("b-form-input", { attrs: { id: "groupNameInput", type: "text" }, model: { value: _vm.editing.groupName, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.editing, "groupName", $$v);
  }, "callback"), expression: "editing.groupName" } })], 1), _vm._v(" "), _c("icon-select", { model: { value: _vm.editing.icon, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.editing, "icon", $$v);
  }, "callback"), expression: "editing.icon" } }), _vm._v(" "), _c("h5", [_vm._v("Group settings")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "pretty p-svg p-curve p-smooth" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.editing.enableMoveItems, expression: "editing.enableMoveItems" }], staticClass: "form-check-input", attrs: { type: "checkbox", id: "allowMoveCheckBox" }, domProps: { checked: Array.isArray(_vm.editing.enableMoveItems) ? _vm._i(_vm.editing.enableMoveItems, null) > -1 : _vm.editing.enableMoveItems }, on: { change: /* @__PURE__ */ __name(function($event) {
    var $$a = _vm.editing.enableMoveItems, $$el = $event.target, $$c = !!$$el.checked;
    if (Array.isArray($$a)) {
      var $$v = null, $$i = _vm._i($$a, $$v);
      $$el.checked ? $$i < 0 && _vm.$set(_vm.editing, "enableMoveItems", $$a.concat([$$v])) : $$i > -1 && _vm.$set(_vm.editing, "enableMoveItems", $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
    } else
      _vm.$set(_vm.editing, "enableMoveItems", $$c);
  }, "change") } }), _vm._v(" "), _c("div", { staticClass: "state p-primary" }, [_c("span", { staticClass: "svg svg-icon" }, [_c("CheckIcon")], 1), _vm._v(" "), _c("label", [_vm._v("Enable Move Items")])])]), _vm._v(" "), _c("p", { staticClass: "form-text text-muted" }, [_vm._v("Allow users to move indexing items between the linked pages")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "pretty p-svg p-curve p-smooth" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.editing.singleMenuItem, expression: "editing.singleMenuItem" }], staticClass: "form-check-input", attrs: { type: "checkbox", id: "singleMenuitemCheckBox" }, domProps: { checked: Array.isArray(_vm.editing.singleMenuItem) ? _vm._i(_vm.editing.singleMenuItem, null) > -1 : _vm.editing.singleMenuItem }, on: { change: /* @__PURE__ */ __name(function($event) {
    var $$a = _vm.editing.singleMenuItem, $$el = $event.target, $$c = !!$$el.checked;
    if (Array.isArray($$a)) {
      var $$v = null, $$i = _vm._i($$a, $$v);
      $$el.checked ? $$i < 0 && _vm.$set(_vm.editing, "singleMenuItem", $$a.concat([$$v])) : $$i > -1 && _vm.$set(_vm.editing, "singleMenuItem", $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
    } else
      _vm.$set(_vm.editing, "singleMenuItem", $$c);
  }, "change") } }), _vm._v(" "), _c("div", { staticClass: "state p-primary" }, [_c("span", { staticClass: "svg svg-icon" }, [_c("CheckIcon")], 1), _vm._v(" "), _c("label", [_vm._v("Single Menu Item")])])]), _vm._v(" "), _c("p", { staticClass: "form-text text-muted" }, [_vm._v("When displaying in the navigation menu, this item will display as a standalone dropdown, rather than grouped with other groups")])]), _vm._v(" "), _vm.editing.enableMoveItems ? _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "moveItemsNameInput" } }, [_vm._v("Dropdown label")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.editing.moveItemsName, expression: "editing.moveItemsName" }], staticClass: "form-control", attrs: { placeholder: "Select an page", type: "text", id: "moveItemsNameInput", "aria-describedby": "moveItemsNameHelp" }, domProps: { value: _vm.editing.moveItemsName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.editing, "moveItemsName", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "form-text text-muted", attrs: { id: "moveItemsNameHelp" } }, [_vm._v(`This text will appear above the dropdown that
          users will use to move items.`)])]) : _vm._e(), _vm._v(" "), _c("h5", [_vm._v(`Linked Pages
          `), _c("button", { staticClass: "btn btn-primary btn-sm dropdown-toggle", attrs: { disabled: _vm.availablePages.length == 0, type: "button", "data-toggle": "dropdown", id: "addPageToGroup", "aria-haspopup": "true", "aria-expanded": "true" } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(`
            Add Page
            `), _c("ul", { staticClass: "dropdown-menu" }, _vm._l(_vm.availablePages, function(page, index) {
    return _c("li", { key: index, attrs: { id: page.identifier + "-group" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.addPageToGroup(page, _vm.editing);
    }, "click") } }, [_c("a", { staticClass: "dropdown-item" }, [_vm._v(_vm._s(page.name) + " (" + _vm._s(page.type) + ")")])]);
  }), 0)], 1)]), _vm._v(" "), _c("b-alert", { attrs: { show: _vm.availablePages.length == 0, variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
          There are no App Pages available to link.
        `)], 1), _vm._v(" "), _vm.editing.pages.length === 0 ? _c("span", { staticClass: "font-italic" }, [_vm._v("No pages currently linked")]) : _c("table", { staticClass: "table table-striped table-hover" }, [_c("thead", [_c("tr", [_c("th", { staticClass: "icon-column" }, [_c("b-button", { staticClass: "p-0", attrs: { size: "sm", variant: "link" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.sortPages();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.sortOrderAsc ? "arrow-down-a-z" : "arrow-up-a-z" } })], 1)], 1), _vm._v(" "), _c("th", [_vm._v("Name")]), _vm._v(" "), _c("th", [_vm._v("Status")]), _vm._v(" "), _c("th", [_vm._v("Identifier")]), _vm._v(" "), _c("th", [_vm._v("Type")]), _vm._v(" "), _c("th")])]), _vm._v(" "), _c("draggable", { attrs: { handle: ".field-handle", tag: "tbody", name: _vm.editing.groupName + "Draggable" }, model: { value: _vm.editing.pages, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.editing, "pages", $$v);
  }, "callback"), expression: "editing.pages" } }, _vm._l(_vm.editing.pages, function(page) {
    return _c("tr", { key: page.identifier }, [_c("td", { staticClass: "icon-column" }, [_c("span", { staticClass: "field-handle" }, [_c("font-awesome-icon", { attrs: { icon: "grip-vertical" } })], 1)]), _vm._v(" "), _c("td", [_vm._v(_vm._s(page.name))]), _vm._v(" "), _c("td", [page.enabled ? _c("b-badge", { attrs: { variant: "success", pill: "" } }, [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(" Enabled")], 1) : _c("b-badge", { attrs: { variant: "danger", pill: "" } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(" Disabled")], 1)], 1), _vm._v(" "), _c("td", [_vm._v(_vm._s(page.identifier))]), _vm._v(" "), _c("td", [_vm._v(_vm._s(page.type))]), _vm._v(" "), _c("td", [_c("button", { staticClass: "btn btn-danger btn-sm float-right", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.removePageFromGroup(page, _vm.editing);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)])]);
  }), 0)], 1)], 1) : _vm._e()], 1)], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AppPageGroupsConfigurationComponent$1,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "b16a3227"
);
const AppPageGroupsConfigurationComponent = __component__.exports;
export {
  AppPageGroupsConfigurationComponent as default
};
