var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, ck as getQueueTypeIcon, b as baseUrl, j as getQueueName, C as Component, M as Moment, L as LoadingBarComponent, E as ErrorPanel, s as SortableHeader, n as normalizeComponent } from "./main-DAVWuHbi.js";
import ErrorModal from "./errorModal-BqEHnF6f.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a;
let OverviewRouteComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "pageSizeOptions", [
      { value: 25, text: "25 queues" },
      { value: 50, text: "50 queues" },
      { value: 100, text: "100 queues" },
      { value: 250, text: "250 queues" },
      { value: -1, text: "All queues" }
    ]);
  }
  mounted() {
    this.$store.dispatch("pages/indexing/overview/actions/load"), this.loadTypes();
  }
  get page() {
    return this.$store.getters["pages/indexing/getters/page"];
  }
  get filterName() {
    return this.$store.getters["pages/indexing/overview/getters/filter"].name;
  }
  set filterName(input) {
    this.$store.dispatch("pages/indexing/overview/actions/updateNameFilter", input);
  }
  get pageNumber() {
    return this.$store.getters["pages/indexing/overview/getters/pageNumber"];
  }
  set pageNumber(value) {
    this.$store.dispatch("pages/indexing/overview/actions/changePage", value);
  }
  get totalPages() {
    return this.$store.getters["pages/indexing/overview/getters/totalPages"];
  }
  get queues() {
    return this.$store.getters["pages/indexing/overview/getters/queues"];
  }
  get hasResults() {
    return !!this.queues && this.queues.length;
  }
  get loading() {
    return this.$store.getters["pages/indexing/overview/getters/loading"];
  }
  get loadingError() {
    return this.$store.getters["pages/indexing/overview/getters/loadingError"];
  }
  async loadTypes() {
    await this.$store.dispatch("pages/indexing/overview/actions/loadTypes");
  }
  get loadingTypes() {
    return this.$store.getters["pages/indexing/overview/actions/loadingTypes"];
  }
  get includeEmpty() {
    return this.$store.getters["pages/indexing/overview/getters/filter"].includeEmpty;
  }
  set includeEmpty(value) {
    this.$store.dispatch("pages/indexing/overview/actions/updateIncludeEmpty", value);
  }
  get typeOptions() {
    let options = this.$store.getters["pages/indexing/overview/getters/types"];
    return options ? options.map((o) => ({
      name: o.name,
      id: o.id,
      icon: this.getTypeIcon(o.type)
    })).concat([{ id: null, name: "All", icon: null }]) : [];
  }
  get filterType() {
    return this.$store.getters["pages/indexing/overview/getters/filter"].type;
  }
  set filterType(value) {
    this.$store.dispatch("pages/indexing/overview/actions/updateType", value);
  }
  get sort() {
    return this.$store.getters["pages/indexing/overview/getters/sort"];
  }
  set sort(value) {
    this.$store.dispatch("pages/indexing/overview/actions/sort", value);
  }
  get pageSize() {
    return this.$store.getters["pages/indexing/overview/getters/pageSize"];
  }
  set pageSize(value) {
    this.$store.dispatch("pages/indexing/overview/actions/updatePageSize", value);
  }
  get includeCounts() {
    return this.$store.getters["pages/indexing/overview/getters/includeCounts"];
  }
  get includeDates() {
    return this.$store.getters["pages/indexing/overview/getters/includeDates"];
  }
  getTypeIcon(queueType) {
    return getQueueTypeIcon(queueType);
  }
  getQueueLink(queue) {
    return baseUrl() + "/app/indexing/queues/" + queue.id + "/list";
  }
  queueName(queue) {
    return getQueueName(queue);
  }
}, __name(_a, "OverviewRouteComponent"), _a);
OverviewRouteComponent = __decorateClass([
  Component({
    components: { ReactiveDropdown, SortableHeader, PaginationControls, ErrorPanel, ErrorModal, LoadingBar: LoadingBarComponent },
    filters: {
      fromNow: /* @__PURE__ */ __name((value) => value ? Moment(value).fromNow() : null, "fromNow"),
      humanDate: /* @__PURE__ */ __name((value) => value ? Moment(value).calendar() : null, "humanDate")
    }
  })
], OverviewRouteComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h2", [_vm._v(_vm._s(_vm.page.name)), _c("small", [_vm._v(" - Overview")])]), _vm._v(" "), _vm.page.permissions.overview ? _c("div", [_c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header" }, [_c("div", { staticClass: "input-group" }, [_c("div", { staticClass: "input-group-prepend" }, [_c("div", { staticClass: "input-group-text", attrs: { id: "btnGroupAddon" } }, [_c("font-awesome-icon", { attrs: { icon: "filter", placeholder: "Filter list" } })], 1)]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.filterName, expression: "filterName" }], staticClass: "form-control", attrs: { placeholder: "Filter name..." }, domProps: { value: _vm.filterName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.filterName = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("div", { staticClass: "input-group-append" }, [_c("b-form-select", { attrs: { options: _vm.pageSizeOptions }, model: { value: _vm.pageSize, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageSize = $$v;
  }, "callback"), expression: "pageSize" } }), _vm._v(" "), _c("button", { staticClass: "btn btn-default", on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.includeEmpty = !_vm.includeEmpty;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.includeEmpty ? "envelope-open" : "envelope-open-text" } })], 1), _vm._v(" "), _c("reactive-dropdown", { attrs: { options: _vm.typeOptions, loading: _vm.loadingTypes, "empty-clickable": "", title: "Queue Type", menuRight: !0 }, on: { shown: _vm.loadTypes }, model: { value: _vm.filterType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterType = $$v;
  }, "callback"), expression: "filterType" } })], 1)]), _vm._v(" "), _c("span", { staticClass: "clearfix" })]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_vm.loading ? _c("div", { staticClass: "mb-2" }, [_c("loading-bar")], 1) : _vm._e(), _vm._v(" "), _vm.loadingError ? [_c("error-panel", { attrs: { error: _vm.loadingError } })] : _vm.hasResults ? [_c("div", { staticClass: "table-responsive" }, [_c("table", { staticClass: "table table-hover" }, [_c("thead", [_c("tr", [_c("sortable-header", { attrs: { id: "name" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v("Name")]), _vm._v(" "), _c("sortable-header", { attrs: { id: "count" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v(`Count
                                    `)]), _vm._v(" "), _vm.pageSize != -1 ? _c("sortable-header", { attrs: { id: "oldest" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v(`
                                      Oldest
                                    `)]) : _c("th", [_c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "The Oldest item date time cannot be displayed while showing all available queues" } }, [_vm._v(`
                                      Oldest
                                      `), _c("font-awesome-icon", { attrs: { icon: "question-circle" } })], 1)])], 1)]), _vm._v(" "), _c("tbody", _vm._l(_vm.queues, function(queue) {
    return _c("tr", { key: queue.id }, [_c("td", [_c("font-awesome-icon", { attrs: { icon: _vm.getTypeIcon(queue.type.type) } }), _vm._v(` 
                                    `), _c("a", { attrs: { href: _vm.getQueueLink(queue) }, domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(_vm.queueName(queue), _vm.filterName)) } })], 1), _vm._v(" "), _c("td", [_vm.includeCounts ? _c("span", [_vm._v(_vm._s(queue.count))]) : _vm._e()]), _vm._v(" "), _c("td", [_vm.includeDates ? _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: _vm.$options.filters.formatDateTime(queue.oldest) } }, [_vm._v(_vm._s(_vm._f("fromNow")(queue.oldest)))]) : _vm._e()])]);
  }), 0)])])] : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
                    No queues to show
                `)]), _vm._v(" "), _vm.pageSize != -1 ? _c("div", { staticClass: "text-center" }, [_vm.totalPages > 1 ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } }) : _vm._e()], 1) : _vm._e()], 2)])]) : _vm._e()]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  OverviewRouteComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "ce54e095"
);
const overview = __component__.exports;
export {
  overview as default
};
