var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, P as Prop, C as Component, n as normalizeComponent, z as systemInAzureMode, _ } from "./main-DAVWuHbi.js";
import { P as PlaceholderInformation } from "./placeholderInformation-CJo0noa4.js";
import { D as DefaultableTextbox } from "./defaultableTextbox-DRxGWG_3.js";
import { E as EzescanServerInstanceComponent } from "./ezescan-DEc8zQSg.js";
import { E as ExternalConnectionDropDown } from "./externalConnectionDropDown-Du88bMty.js";
import { C as ContainerSelectionComponent } from "./containerSelector-DJmnNR6h.js";
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$3"), _a;
let FileSystemUploadComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "pageId");
    __publicField(this, "uniquePlaceHolderInfo", [
      { syntax: "{{filename}}", description: "The name of the submitted file." },
      { syntax: "{{filenameNoExtension}}", description: "The name of the submitted file with the extension removed." },
      { syntax: "{{filenameExtension}}", description: "The file extension of the submitted file." },
      { syntax: "{{filenameExtensionNoDot}}", description: "The file extension of the submitted file without the dot." }
    ]);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get defaultCompletedDirectory() {
    return "~/App_Data/FUA/" + this.pageIdStore + "/Completed/";
  }
  get pageIdStore() {
    return this.$store.getters["administration/pages/uploads/current"]().id;
  }
  get outputDirectory() {
    return this.model.outputDirectory;
  }
  set outputDirectory(outputDirectory) {
    this.model = { ...this.model, outputDirectory };
  }
  get outputFilename() {
    return this.model.outputFileName;
  }
  set outputFilename(outputFileName) {
    this.model = { ...this.model, outputFileName };
  }
}, __name(_a, "FileSystemUploadComponent"), _a);
__decorateClass$3([
  Prop({
    required: !0
  })
], FileSystemUploadComponent.prototype, "value", 2);
__decorateClass$3([
  Prop({
    required: !1,
    default: null
  })
], FileSystemUploadComponent.prototype, "pageId", 2);
FileSystemUploadComponent = __decorateClass$3([
  Component({
    components: {
      DefaultableTextbox,
      PlaceholderInformation
    }
  })
], FileSystemUploadComponent);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h4", [_vm._v("Output to Filesystem")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Output Directory")]), _vm._v(" "), _c("defaultable-textbox", { attrs: { placeholder: "Enter a path...", defaultValue: _vm.defaultCompletedDirectory }, model: { value: _vm.outputDirectory, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.outputDirectory = $$v;
  }, "callback"), expression: "outputDirectory" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Directory on the server to keep the completed file uploads. Supports "), _c("placeholder-information")], 1)], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Filename")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.outputFilename, expression: "outputFilename" }], staticClass: "form-control", attrs: { placeholder: "Output Filename" }, domProps: { value: _vm.outputFilename }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.outputFilename = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Customise output filename. If left blank, original name is used. The file extension will always be applied to the end of the filename. This field supports "), _c("placeholder-information", { attrs: { "unique-placeholders": _vm.uniquePlaceHolderInfo } })], 1)])]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  FileSystemUploadComponent,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const FilesystemOutputComponent = __component__$3.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$2"), _a2;
let EzeScanUploadComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "pageId");
    __publicField(this, "uniquePlaceHolderInfo", [
      { syntax: "{{filename}}", description: "The name of the submitted file." },
      { syntax: "{{filenameNoExtension}}", description: "The name of the submitted file with the extension removed." },
      { syntax: "{{filenameExtension}}", description: "The file extension of the submitted file." },
      { syntax: "{{filenameExtensionNoDot}}", description: "The file extension of the submitted file without the dot." }
    ]);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get configuration() {
    return this.model.configuration;
  }
  set configuration(configuration) {
    this.model = { ...this.model, configuration };
  }
}, __name(_a2, "EzeScanUploadComponent"), _a2);
__decorateClass$2([
  Prop({
    required: !0
  })
], EzeScanUploadComponent.prototype, "value", 2);
__decorateClass$2([
  Prop({
    required: !1,
    default: null
  })
], EzeScanUploadComponent.prototype, "pageId", 2);
EzeScanUploadComponent = __decorateClass$2([
  Component({
    components: {
      DefaultableTextbox,
      PlaceholderInformation,
      EzescanServerInstanceComponent
    }
  })
], EzeScanUploadComponent);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h4", [_vm._v("Output to EzeScan Server")]), _vm._v(" "), _c("ezescan-server-instance-component", { model: { value: _vm.configuration, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.configuration = $$v;
  }, "callback"), expression: "configuration" } })], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  EzeScanUploadComponent,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  null
);
const EzeScanOutputComponent = __component__$2.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a3;
let AzureBlobStorageUploadComponent = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "pageId");
    __publicField(this, "uniquePlaceHolderInfo", [
      { syntax: "{{filename}}", description: "The name of the submitted file." },
      { syntax: "{{filenameNoExtension}}", description: "The name of the submitted file with the extension removed." },
      { syntax: "{{filenameExtension}}", description: "The file extension of the submitted file." },
      { syntax: "{{filenameExtensionNoDot}}", description: "The file extension of the submitted file without the dot." }
    ]);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get defaultDirectory() {
    return "FUA/" + this.pageIdStore + "/Completed/";
  }
  get pageIdStore() {
    return this.$store.getters["administration/pages/uploads/current"]().id;
  }
  get container() {
    return this.model.container;
  }
  set container(value) {
    this.model = { ...this.model, container: value };
  }
  get externalConnectionId() {
    return this.model.externalConnectionId;
  }
  set externalConnectionId(value) {
    this.model = { ...this.model, externalConnectionId: value };
  }
  get directory() {
    return this.model.directory;
  }
  set directory(directory) {
    this.model = { ...this.model, directory };
  }
  get outputFilename() {
    return this.model.outputFileName;
  }
  set outputFilename(outputFileName) {
    this.model = { ...this.model, outputFileName };
  }
}, __name(_a3, "AzureBlobStorageUploadComponent"), _a3);
__decorateClass$1([
  Prop({
    required: !0
  })
], AzureBlobStorageUploadComponent.prototype, "value", 2);
__decorateClass$1([
  Prop({
    required: !1,
    default: null
  })
], AzureBlobStorageUploadComponent.prototype, "pageId", 2);
AzureBlobStorageUploadComponent = __decorateClass$1([
  Component({
    components: {
      ContainerSelectionComponent,
      ExternalConnectionDropDown,
      PlaceholderInformation,
      DefaultableTextbox
    }
  })
], AzureBlobStorageUploadComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h4", [_vm._v("Output to Azure Blob Storage")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Azure Connection")]), _vm._v(" "), _c("external-connection-drop-down", { attrs: { types: ["ExternalConnection.AzureStorage", "ExternalConnection.AzureStorageBuiltIn"] }, model: { value: _vm.externalConnectionId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.externalConnectionId = $$v;
  }, "callback"), expression: "externalConnectionId" } })], 1), _vm._v(" "), _c("container-selection-component", { attrs: { externalConnectionId: _vm.externalConnectionId }, model: { value: _vm.container, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.container = $$v;
  }, "callback"), expression: "container" } }), _vm._v(" "), _c("b-form-group", { attrs: { label: "Output Directory" } }, [_c("defaultable-textbox", { attrs: { placeholder: "Enter a path...", defaultValue: _vm.defaultDirectory }, model: { value: _vm.directory, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.directory = $$v;
  }, "callback"), expression: "directory" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v(`This field supports
            `), _c("placeholder-information", { attrs: { "unique-placeholders": _vm.uniquePlaceHolderInfo } })], 1)], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Filename")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.outputFilename, expression: "outputFilename" }], staticClass: "form-control", attrs: { placeholder: "Output Filename" }, domProps: { value: _vm.outputFilename }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.outputFilename = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Customise output filename. If left blank, original name is used. The file extension will always be applied to the end of the filename. This field supports "), _c("placeholder-information", { attrs: { "unique-placeholders": _vm.uniquePlaceHolderInfo } })], 1)])], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  AzureBlobStorageUploadComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const AzureBlobStorageOutputComponent = __component__$1.exports, outputConfigurations = [
  {
    id: "EzeScan.FUA.OutputDestination.FileSystem",
    name: "File System",
    icon: "folder",
    component: FilesystemOutputComponent,
    factory: /* @__PURE__ */ __name(() => ({
      typeId: "EzeScan.FUA.OutputDestination.FileSystem",
      enabled: !0,
      discriminator: "EzeScan.FUA.OutputDestination.FileSystem",
      outputDirectory: null,
      outputFileName: null
    }), "factory")
  },
  {
    id: "EzeScan.FUA.OutputDestination.EzeScanServer",
    name: "EzeScan Server",
    icon: "server",
    component: EzeScanOutputComponent,
    factory: /* @__PURE__ */ __name(() => ({
      typeId: "EzeScan.FUA.OutputDestination.EzeScanServer",
      enabled: !0,
      discriminator: "EzeScan.FUA.OutputDestination.EzeScanServer",
      configuration: {}
    }), "factory")
  },
  {
    id: "EzeScan.FUA.OutputDestination.AzureBlobStorage",
    name: "Azure Blob Storage",
    icon: "database",
    component: AzureBlobStorageOutputComponent,
    factory: /* @__PURE__ */ __name(() => ({
      enabled: !0,
      typeId: "EzeScan.FUA.OutputDestination.AzureBlobStorage",
      discriminator: "EzeScan.FUA.OutputDestination.AzureBlobStorage"
    }), "factory")
  }
], outputConfigurations$1 = outputConfigurations.sort(function(a, b) {
  return a.name.localeCompare(b.name);
});
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a4;
let OutputConfigurationComponent = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "isAzureMode", !1);
    __publicField(this, "value");
    __publicField(this, "pageId");
    __publicField(this, "editing", null);
    __publicField(this, "editingIndex", null);
  }
  async mounted() {
    this.isAzureMode = await systemInAzureMode();
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get outputDestinations() {
    return this.model.outputDestinations;
  }
  set outputDestinations(value) {
    this.model = { ...this.model, outputDestinations: value };
  }
  get outputTypes() {
    return outputConfigurations$1;
  }
  edit(item) {
    let index = this.outputDestinations.indexOf(item);
    index < 0 || (this.editing = _.cloneDeep(this.outputDestinations[index]), this.editingIndex = index);
  }
  remove(item) {
    let index = this.outputDestinations.indexOf(item);
    if (index < 0)
      return;
    let newModel = this.outputDestinations.slice();
    newModel.splice(index, 1), this.outputDestinations = newModel;
  }
  add(typeId) {
    let newOutput = this.outputTypes.find((o) => o.id === typeId).factory();
    this.editing = newOutput;
  }
  getOutputTypeName(type) {
    let matched = this.outputTypes.find((t) => t.id == type.discriminator);
    return matched ? matched.name : null;
  }
  save() {
    this.validate().then((valid) => {
      if (valid) {
        let updatedModel = this.outputDestinations.slice();
        this.editingIndex === null ? updatedModel.push(this.editing) : updatedModel.splice(this.editingIndex, 1, this.editing), this.outputDestinations = updatedModel, this.editing = null, this.editingIndex = null;
      }
    });
  }
  cancel() {
    this.editing = null, this.editingIndex = null;
  }
  get component() {
    if (!this.editing)
      return null;
    let matched = this.outputTypes.find((t) => t.id === this.editing.discriminator);
    return matched ? matched.component : null;
  }
  async validate() {
    let validators = this.$children.map((c) => c.$validator);
    return Promise.all(validators.map((v) => v.validateAll())).then((r) => r.every((v) => v));
  }
  getOutputEnabled(output) {
    return output.enabled ? "Enabled" : "Disabled";
  }
  async toggleOutputEnabled(output) {
    output.enabled = !output.enabled;
  }
}, __name(_a4, "OutputConfigurationComponent"), _a4);
__decorateClass([
  Prop({
    required: !0
  })
], OutputConfigurationComponent.prototype, "value", 2);
__decorateClass([
  Prop({
    required: !1,
    default: null
  })
], OutputConfigurationComponent.prototype, "pageId", 2);
OutputConfigurationComponent = __decorateClass([
  Component({ methods: { systemInAzureMode } })
], OutputConfigurationComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header" }, [_c("div", { staticClass: "row" }, [_vm._m(0), _vm._v(" "), _c("div", { staticClass: "col-md-4 col-sm-6" }, [_vm.editing ? _vm._e() : _c("div", { staticClass: "dropdown" }, [_c("button", { staticClass: "btn btn-success btn-block dropdown-toggle", attrs: { disabled: _vm.outputTypes.length === 0, id: "outputConfigurations", type: "button", "data-toggle": "dropdown", "aria-haspopup": "true", "aria-expanded": "true" } }, [_c("span", { staticClass: "caret" }), _vm._v(`
                        Add Output
                    `)]), _vm._v(" "), _c("ul", { staticClass: "dropdown-menu" }, _vm._l(_vm.outputTypes, function(outputType) {
    return _c("li", { key: outputType.name }, [_c("button", { staticClass: "dropdown-item", attrs: { role: "button", id: outputType.id, disabled: _vm.isAzureMode && outputType.id == "EzeScan.FUA.OutputDestination.FileSystem" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.add(outputType.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: outputType.icon } }), _vm._v(` 
                                ` + _vm._s(outputType.name) + `
                            `)], 1)]);
  }), 0)])])])]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_vm.editing ? _c("div", { key: "edit" }, [_vm.component ? _c("div", [_c(_vm.component, { ref: "editor", tag: "component", attrs: { pageId: _vm.pageId }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } }), _vm._v(" "), _c("span", { staticClass: "float-right" }, [_c("button", { staticClass: "btn btn-default", attrs: { id: "cancelOutput" }, on: { click: _vm.cancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", attrs: { id: "saveOutput" }, on: { click: _vm.save } }, [_vm._v("Save")])])], 1) : _c("div", { staticClass: "alert alert-danger" }, [_vm._v(`
                Editor not available. `), _c("a", { attrs: { role: "button" }, on: { click: _vm.cancel } }, [_vm._v("Close")])])]) : _c("div", { key: "list" }, [_vm.outputDestinations.length > 0 ? _c("table", { staticClass: "table" }, [_vm._m(1), _vm._v(" "), _c("tbody", _vm._l(_vm.outputDestinations, function(output) {
    return _c("tr", { key: output.id }, [_c("td", { staticClass: "col align-middle" }, [_vm._v(`
                        ` + _vm._s(_vm.getOutputTypeName(output)) + `
                        `), output.discriminator == "EzeScan.FUA.OutputDestination.FileSystem" && _vm.isAzureMode ? _c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", value: "This upload type isn't supported when running in Azure Mode", expression: "'This upload type isn\\'t supported when running in Azure Mode'", modifiers: { hover: !0 } }], attrs: { pill: "", variant: "warning" } }, [_vm._v("Disabled")]) : _vm._e()], 1), _vm._v(" "), _c("td", { staticClass: "col align-middle" }, [output.discriminator == "EzeScan.FUA.OutputDestination.FileSystem" && _vm.isAzureMode ? _c("b-form-checkbox", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "ml-1", attrs: { checked: !1, disabled: "", size: "sm", name: "outputEnabledButton", title: "Disabled", switch: "" } }) : _c("b-form-checkbox", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "ml-1", attrs: { checked: output.enabled, size: "sm", name: "outputEnabledButton", title: _vm.getOutputEnabled(output), switch: "" }, nativeOn: { click: /* @__PURE__ */ __name(function($event) {
      return $event.preventDefault(), _vm.toggleOutputEnabled(output);
    }, "click") } })], 1), _vm._v(" "), _c("td", { staticClass: "col align-middle" }, [_c("div", { staticClass: "btn-group", attrs: { role: "group" } }, [_c("button", { staticClass: "btn btn-danger", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.remove(output);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-info", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.edit(output);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } })], 1)])])]);
  }), 0)]) : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
                No outputs configured
            `)])])])]);
}, "render"), _sfc_staticRenderFns = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-md-8 col-sm-6" }, [_c("h4", [_vm._v("Output Configurations")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("thead", [_c("tr", [_c("th", { staticClass: "col" }, [_vm._v("Type")]), _vm._v(" "), _c("th", { staticClass: "col" }, [_vm._v("Enabled")]), _vm._v(" "), _c("th", { staticClass: "col" })])]);
}], __component__ = /* @__PURE__ */ normalizeComponent(
  OutputConfigurationComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  null
);
const FileOutputSettings = __component__.exports;
export {
  FileOutputSettings as F
};
