var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, R as Routes, W as Watch, C as Component, s as SortableHeader, L as LoadingBarComponent, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let MonitorObserveeRouteComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loadingNode", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "autoRefresh");
    __publicField(this, "breadCrumbMessage", "");
    __publicField(this, "sort", null);
    __publicField(this, "selectedObservee", "");
    __publicField(this, "selectedNodes", []);
    __publicField(this, "deleting", !1);
    __publicField(this, "allItemsChecked", !1);
    __publicField(this, "deletingErrors", []);
    __publicField(this, "deletingSuccesses", []);
  }
  mounted() {
    this.loadNode(!0);
  }
  reloadRouter() {
    this.loadNode(!0);
  }
  pageChanged() {
    this.loadNode(!0);
  }
  getCountOfContainerItems() {
    let containerItems = 0;
    return this.node ? (this.node.children.forEach((childNode) => {
      childNode.subType === "directory" && containerItems++;
    }), containerItems) : [];
  }
  get getCountOfChildItems() {
    if (!this.node)
      return 0;
    let childItems = this.node.children.map((c) => c.children).reduce((total, current) => total + current, 0);
    return childItems += this.node.totalChildren, childItems;
  }
  get breadCrumbBadgeMessage() {
    return this.breadCrumbMessage;
  }
  set breadCrumbBadgeMessage(value) {
    this.breadCrumbMessage = value;
  }
  setNextAutoReload() {
    this.autoRefresh && clearTimeout(this.autoRefresh), this.refreshInterval && (this.autoRefresh = setTimeout(() => this.loadNode(!1), this.refreshInterval * 1e3));
  }
  calculateSort(sort) {
    if (sort)
      return (sort.descending ? "-" : "+") + sort.by;
  }
  sortChanged() {
    this.loadNode(!1);
  }
  loadNode(setLoading) {
    this.autoRefresh && clearTimeout(this.autoRefresh), this.breadCrumbBadgeMessage = null, this.loadingNode = setLoading, this.$route.params.observeeId && this.$store.dispatch("loadNodeForObservee", {
      pageId: this.$route.params.pageId,
      observeeId: this.$route.params.observeeId,
      nodeId: this.$route.query.nodeId,
      sort: this.calculateSort(this.sort)
    }).then(() => {
      this.loadingError = null;
    }).catch((e) => {
      this.loadingError = e;
    }).finally(() => {
      this.$nextTick(() => {
        setLoading && (this.deleting = !1, this.allItemsChecked = !1, this.selectedNodes = [], this.deletingErrors = [], this.deletingSuccesses = []);
      }), this.loadingNode = !1, this.setNextAutoReload(), this.breadCrumbBadgeMessage = this.getCountOfContainerItems() + " container(s) and " + this.getCountOfChildItems + " child items total";
    });
  }
  get nodeId() {
    return this.node ? this.node.node.id : null;
  }
  get observeeId() {
    return this.node ? this.node.observee.id : null;
  }
  get pageId() {
    return this.$route.params.pageId;
  }
  get pageTotal() {
    return this.$store.getters.getPageTotal;
  }
  get pageSize() {
    return this.$store.getters.getPageSize;
  }
  set pageSize(value) {
    this.$store.dispatch("setPageSize", value);
  }
  get pageNumber() {
    return this.$store.getters.getPageNumber || 1;
  }
  set pageNumber(value) {
    this.$store.dispatch("setPage", value);
  }
  get refreshInterval() {
    let param = this.$route.query.refreshInterval, parsed = param ? parseInt(param) : 0;
    return parsed > 0 ? parsed : 0;
  }
  get deletingNodeIds() {
    return this.selectedNodes.map((md) => md.id);
  }
  get node() {
    let node = this.$store.getters.getCurrentObserveeNode;
    return node && (node.observee.type === "directory" || node.observee.type === "azureBlobStorage") && node.children.forEach((child) => {
      child.subType === "file" && (child.checked = this.deletingNodeIds.includes(child.id), child.allowDeletingFiles = node.allowDeletingFiles), child.subType === "directory" && (child.checked = this.deletingNodeIds.includes(child.id), child.allowDeletingFiles = node.allowDeletingFiles && child.children === 0);
    }), node;
  }
  get showDeleteCheckbox() {
    return this.node.allowDeletingFiles;
  }
  goToNode(node) {
    if (this.selectedObservee = node.id, this.pageNumber = 1, this.node.observee.type === "indexing" && node.subType === "item") {
      this.downloadNode(node);
      return;
    }
    if ((this.node.observee.type === "directory" || this.node.observee.type === "azureBlobStorage") && node.subType === "file") {
      this.downloadNode(node);
      return;
    }
    let route = { name: Routes.Observee, params: { pageId: this.pageId, observeeId: this.observeeId }, query: { refreshInterval: this.refreshInterval ? this.refreshInterval.toString() : void 0 } };
    node.id && (route.query = { nodeId: node.id, refreshInterval: this.refreshInterval ? this.refreshInterval.toString() : void 0 }), this.$router.push(route);
  }
  showDeletingModal(node) {
    node != null && (this.selectedNodes = [node]), $("#deleteNodeModal").modal("show");
  }
  async deleteNodes() {
    this.deletingErrors = [], this.deletingSuccesses = [], this.deleting = !0;
    let $this = this;
    await Promise.all(this.selectedNodes.map(async (node) => {
      await $this.deleteNode(node);
    })).finally(() => {
      this.deleting = !1, $("#deleteNodeModal").modal("hide"), this.allItemsChecked = !1, this.loadNode(!1);
    });
  }
  async deleteNode(deleteNode) {
    try {
      await this.$store.dispatch("deleteObserveeNode", {
        pageId: this.pageId,
        observeeId: this.observeeId,
        nodeId: deleteNode.id
      }), this.deletingSuccesses.push(deleteNode), this.selectedNodes.splice($.inArray(deleteNode, this.selectedNodes), 1), this.node.children.splice($.inArray(deleteNode, this.node.children), 1), this.loadNode(!1);
    } catch (error) {
      this.deletingErrors.push("Could not delete item: " + deleteNode.name + ". " + error.response);
    }
  }
  allowLinkingToFile(node) {
    return !(!this.node.allowDownloadingFiles && (this.node.observee.type === "indexing" && node.subType === "item" || (this.node.observee.type === "directory" || this.node.observee.type === "azureBlobStorage") && node.subType === "file"));
  }
  checkAllItems() {
    this.node && this.node.children.forEach((childNode) => {
      (childNode.allowDeletingFiles || childNode.subType === "file") && this.addOrRemoveDeletingNode(childNode, this.allItemsChecked, !1);
    });
  }
  updateCheckAllItemsCheckbox() {
    let total = this.node.children.filter((node) => node.subType === "file").length;
    this.allItemsChecked = this.selectedNodes.length === total;
  }
  checkItem(node) {
    this.addOrRemoveDeletingNode(node, node.checked, !0);
  }
  addOrRemoveDeletingNode(node, checked, updateCheckAll) {
    let foundNode = this.selectedNodes.find((n) => n.id === node.id), index = this.selectedNodes.indexOf(foundNode);
    checked && index === -1 && this.selectedNodes.push(node), !checked && index > -1 && this.selectedNodes.splice(index, 1), updateCheckAll && this.updateCheckAllItemsCheckbox();
  }
  downloadNode(node) {
    return this.$store.dispatch("downloadObserveeNode", {
      pageId: this.pageId,
      observeeId: this.observeeId,
      nodeId: node.id
    });
  }
  async downloadAllFilesInNode() {
    let filesToDownload = null;
    this.nodeId != null && (filesToDownload = [this.nodeId]), await this.downloadItems(filesToDownload, !0);
  }
  async downloadList() {
    let filesToDownload = this.node.children.filter((y) => y.checked).map((n) => n.id);
    await this.downloadItems(filesToDownload, !1);
  }
  async downloadItems(filesToDownload, downloadNode) {
    await this.$store.dispatch("downloadObserveeNodeList", {
      pageId: this.pageId,
      observeeId: this.observeeId,
      fileIds: filesToDownload,
      downloadNode
    });
  }
  home() {
    this.$router.push({ name: Routes.Home, params: { pageId: this.pageId }, query: { refreshInterval: this.refreshInterval ? this.refreshInterval.toString() : void 0 } });
  }
  getNodeIcon(node) {
    switch (this.node.observee.type) {
      case "directory": {
        switch (node.subType) {
          case "directory":
            return "folder";
          case "file":
            return "file";
        }
        break;
      }
      case "azureBlobStorage": {
        switch (node.subType) {
          case "directory":
            return "folder";
          case "file":
            return "file";
        }
        break;
      }
      case "indexing": {
        switch (node.subType) {
          case "queueType-shared":
            return "users";
          case "queueType-personal":
            return "user";
          case "queue-shared":
            return "inbox";
          case "queue-personal":
            return "inbox";
          case "item":
            return "file";
        }
        break;
      }
    }
    return "";
  }
}, __name(_a, "MonitorObserveeRouteComponent"), _a);
__decorateClass([
  Watch("$route")
], MonitorObserveeRouteComponent.prototype, "reloadRouter", 1);
__decorateClass([
  Watch("pageNumber")
], MonitorObserveeRouteComponent.prototype, "pageChanged", 1);
__decorateClass([
  Watch("sort")
], MonitorObserveeRouteComponent.prototype, "sortChanged", 1);
MonitorObserveeRouteComponent = __decorateClass([
  Component({ components: { LoadingBar: LoadingBarComponent, DateDisplay, SortableHeader, PaginationControls } })
], MonitorObserveeRouteComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_vm.loadingNode && !_vm.node ? _c("div", { staticClass: "text-center text-primary my-auto mx-auto" }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v("Loading " + _vm._s(_vm.$router.currentRoute.query.nodeId || "root") + "...")])], 1) : _vm._e(), _vm._v(" "), _vm.deletingErrors.length ? _c("b-alert", { attrs: { variant: "danger", show: "", dismissible: "" } }, _vm._l(_vm.deletingErrors, function(error) {
    return _c("span", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" " + _vm._s(error) + `
            `), _c("br")], 1);
  }), 0) : _vm._e(), _vm._v(" "), _vm.deletingSuccesses.length ? _c("b-alert", { attrs: { variant: "info", show: "", dismissible: "" } }, [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(" "), _vm.deletingSuccesses.length === 1 ? _c("span", [_vm._v("Successfully deleted " + _vm._s(_vm.deletingSuccesses[0].name))]) : _c("span", [_vm._v("Successfully deleted " + _vm._s(_vm.deletingSuccesses.length) + " items")])], 1) : _vm._e(), _vm._v(" "), _vm.node ? _c("b-row", [_c("b-col", [_c("b-breadcrumb", [_c("b-breadcrumb-item", [_vm.loadingNode ? _c("span", { staticClass: "text-muted" }, [_c("font-awesome-icon", { attrs: { icon: "home" } })], 1) : _c("a", { staticClass: "mr-1", attrs: { role: "button", href: "javascript:void(0);" }, on: { click: _vm.home } }, [_c("font-awesome-icon", { attrs: { icon: "home" } })], 1), _vm._v(` 
          `)]), _vm._v(" "), _vm._l(_vm.node.parents, function(parent) {
    return _c("b-breadcrumb-item", [_vm.loadingNode ? _c("span", { staticClass: "text-muted" }, [_vm._v(_vm._s(parent.name))]) : _c("a", { attrs: { role: "button", href: "javascript:void(0);" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.goToNode(parent);
    }, "click") } }, [_vm._v(_vm._s(parent.name))])]);
  }), _vm._v(" "), _c("b-breadcrumb-item", { attrs: { active: "" } }, [_vm._v(`
            ` + _vm._s(_vm.node.node.name) + ` 
            `), _c("b-badge", { staticClass: "badge badge-secondary", attrs: { pilln: "", title: _vm.breadCrumbMessage } }, [_vm._v(_vm._s(_vm.getCountOfChildItems))])], 1)], 2)], 1)], 1) : _vm._e(), _vm._v(" "), _vm.loadingError ? _c("b-alert", { attrs: { show: "", variant: "danger" } }, [_c("p", { staticClass: "alert-heading" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" An error has occurred while loading the page: " + _vm._s(_vm.loadingError))], 1), _vm._v(" "), _c("b-button", { attrs: { size: "sm", variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.loadNode(!0);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-warning" } }), _vm._v(" Reload page")], 1)], 1) : _c("b-row", [_c("b-col", { staticClass: "my-1" }, [_vm.pageTotal > 1 && _vm.pageSize != 0 ? _c("div", { staticClass: "float-right" }, [_c("pagination-controls", { attrs: { count: _vm.pageTotal }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } })], 1) : _vm._e(), _vm._v(" "), _vm.node && _vm.node.totalChildren > _vm.pageSize ? _c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_vm._v("Showing " + _vm._s(_vm.pageSize) + " of " + _vm._s(_vm.node.totalChildren) + " results")])]) : _vm._e()], 1)], 1), _vm._v(" "), _c("b-row", [_c("b-col", [_c("table", { staticClass: "table table-striped table-vertical-align-content" }, [_c("thead", [_c("tr", [_vm.node && (_vm.showDeleteCheckbox || _vm.node.allowDownloadingFiles) ? _c("th", { staticClass: "checkboxColumn" }, [_c("div", { staticClass: "custom-control custom-checkbox" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.allItemsChecked, expression: "allItemsChecked" }], staticClass: "custom-control-input", attrs: { type: "checkbox", id: "selectAllCheckbox" }, domProps: { checked: Array.isArray(_vm.allItemsChecked) ? _vm._i(_vm.allItemsChecked, null) > -1 : _vm.allItemsChecked }, on: { change: [function($event) {
    var $$a = _vm.allItemsChecked, $$el = $event.target, $$c = !!$$el.checked;
    if (Array.isArray($$a)) {
      var $$v = null, $$i = _vm._i($$a, $$v);
      $$el.checked ? $$i < 0 && (_vm.allItemsChecked = $$a.concat([$$v])) : $$i > -1 && (_vm.allItemsChecked = $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
    } else
      _vm.allItemsChecked = $$c;
  }, _vm.checkAllItems] } }), _vm._v(" "), _c("label", { staticClass: "custom-control-label", attrs: { for: "selectAllCheckbox" } })])]) : _vm._e(), _vm._v(" "), _c("sortable-header", { attrs: { id: "name" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v("Name")]), _vm._v(" "), _c("sortable-header", { attrs: { id: "lastUpdated" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v("Last Updated")]), _vm._v(" "), _c("sortable-header", { attrs: { id: "count" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v("Count")]), _vm._v(" "), _c("th", [_c("div", { staticClass: "float-right" }, [!_vm.selectedNodes.length && _vm.node && _vm.node.allowDownloadingFiles ? _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { size: "sm", variant: "outline-primary", title: "Download all files in the current folder" }, on: { click: _vm.downloadAllFilesInNode } }, [_c("font-awesome-icon", { attrs: { icon: "download" } }), _vm._v(` Download all files
                `)], 1) : _vm._e(), _vm._v(" "), _vm.selectedNodes.filter((node) => node.subType === "file").length && _vm.node && _vm.node.allowDownloadingFiles ? _c("b-button", { attrs: { size: "sm", variant: "outline-primary" }, on: { click: _vm.downloadList } }, [_c("font-awesome-icon", { attrs: { icon: "download" } }), _vm._v(" Download " + _vm._s(_vm.selectedNodes.filter((node) => node.subType === "file").length) + ` files
                `)], 1) : _vm._e(), _vm._v(" "), _vm.selectedNodes.length && _vm.showDeleteCheckbox ? _c("b-button", { attrs: { size: "sm", variant: "outline-danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.showDeletingModal(null);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
                `)], 1) : _vm._e(), _vm._v(" "), _c("button", { staticClass: "btn btn-default btn-sm", attrs: { disabled: _vm.loadingNode }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.loadNode(!0);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync", spin: _vm.loadingNode } })], 1)], 1)])], 1)]), _vm._v(" "), _vm.node ? _c("tbody", _vm._l(_vm.node.children, function(item) {
    return _c("tr", { key: item.id }, [_vm.showDeleteCheckbox || _vm.node && _vm.node.allowDownloadingFiles ? _c("td", { staticClass: "checkboxColumn" }, [item.allowDeletingFiles ? _c("div", { staticClass: "custom-control custom-checkbox" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: item.checked, expression: "item.checked" }], staticClass: "custom-control-input", attrs: { type: "checkbox", id: "checkbox" + item.id }, domProps: { checked: Array.isArray(item.checked) ? _vm._i(item.checked, null) > -1 : item.checked }, on: { change: [function($event) {
      var $$a = item.checked, $$el = $event.target, $$c = !!$$el.checked;
      if (Array.isArray($$a)) {
        var $$v = null, $$i = _vm._i($$a, $$v);
        $$el.checked ? $$i < 0 && _vm.$set(item, "checked", $$a.concat([$$v])) : $$i > -1 && _vm.$set(item, "checked", $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
      } else
        _vm.$set(item, "checked", $$c);
    }, function($event) {
      return _vm.checkItem(item);
    }] } }), _vm._v(" "), _c("label", { staticClass: "custom-control-label", attrs: { for: "checkbox" + item.id } })]) : _vm._e()]) : _vm._e(), _vm._v(" "), _c("td", [_vm.allowLinkingToFile(item) ? _c("span", [_c("font-awesome-icon", { attrs: { icon: _vm.getNodeIcon(item) } }), _vm._v(" "), _vm.loadingNode ? _c("span", { staticClass: "text-muted" }, [_vm._v(_vm._s(item.name))]) : _c("b-link", { attrs: { href: "#" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.goToNode(item);
    }, "click") } }, [_vm._v(_vm._s(item.name))])], 1) : _c("div", [_c("font-awesome-icon", { attrs: { icon: _vm.getNodeIcon(item) } }), _vm._v(" " + _vm._s(item.name) + `
            `)], 1)]), _vm._v(" "), _c("td", [item.modified ? _c("span", [_c("date-display", { attrs: { value: item.modified } })], 1) : _vm._e()]), _vm._v(" "), _c("td", [_vm._v(_vm._s(item.children))]), _vm._v(" "), _c("td", [_vm.allowLinkingToFile(item) ? _c("div", { staticClass: "btn-group btn-group-sm float-right", attrs: { role: "group" } }, [_c("b-button", { attrs: { variant: "primary", disabled: _vm.loadingNode }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.goToNode(item);
    }, "click") } }, [_vm.selectedObservee === item.id && _vm.loadingNode ? _c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }) : _c("font-awesome-icon", { attrs: { icon: "eye" } }), _vm._v(` View
              `)], 1), _vm._v(" "), item.allowDeletingFiles ? _c("div", { staticClass: "btn-group btn-group-sm", attrs: { role: "group" } }, [_c("button", { staticClass: "btn btn-primary dropdown-toggle", attrs: { id: "btnGroup", type: "button", "data-toggle": "dropdown", "aria-haspopup": "true", "aria-expanded": "false" } }), _vm._v(" "), _c("div", { staticClass: "dropdown-menu", attrs: { "aria-labelledby": "btnGroup" } }, [_c("a", { staticClass: "dropdown-item", staticStyle: { color: "red" }, attrs: { role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showDeletingModal(item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v("  Delete")], 1)])]) : _vm._e()], 1) : _vm._e()])]);
  }), 0) : _vm._e()])])], 1), _vm._v(" "), _vm.loadingError ? _vm._e() : _c("b-row", [_c("b-col", { staticClass: "my-1" }, [_vm.pageTotal > 1 && _vm.pageSize != 0 ? _c("div", { staticClass: "float-right" }, [_c("pagination-controls", { attrs: { count: _vm.pageTotal }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } })], 1) : _vm._e(), _vm._v(" "), _vm.node && _vm.node.totalChildren > _vm.pageSize ? _c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_vm._v("Showing " + _vm._s(_vm.pageSize) + " of " + _vm._s(_vm.node.totalChildren) + " results")])]) : _vm._e()], 1)], 1), _vm._v(" "), _c("div", { staticClass: "modal fade", attrs: { "data-backdrop": "static", id: "deleteNodeModal", tabindex: "-1", role: "dialog", "aria-labelledby": "deleteNodeModal", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_vm.selectedNodes.length ? _c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title", attrs: { id: "deleteNodeLabel" } }, [_c("font-awesome-icon", { attrs: { icon: "file" } }), _vm._v(" Delete item")], 1), _vm._v(" "), _vm._m(0)]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("p", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` Are you sure you want to delete the following items? You will not be able to reverse this.
                    `)], 1), _vm._v(" "), _c("ul", _vm._l(_vm.selectedNodes, function(node) {
    return _c("li", { key: node.id }, [_vm._v(_vm._s(node.name))]);
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", class: { disabled: _vm.deleting }, attrs: { type: "button", "data-dismiss": "modal", disabled: _vm.deleting } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-danger", class: { disabled: _vm.deleting }, attrs: { type: "button", disabled: _vm.deleting }, on: { click: _vm.deleteNodes } }, [_vm.deleting ? _vm._e() : [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Delete")], _vm._v(" "), _vm.deleting ? [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Deleting")] : _vm._e()], 2)])]) : _vm._e()])])], 1);
}, "render"), _sfc_staticRenderFns = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}], __component__ = /* @__PURE__ */ normalizeComponent(
  MonitorObserveeRouteComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "49dcf29a"
);
const observee = __component__.exports;
export {
  observee as default
};
