var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { A as AttributesValue } from "./attributesValue-DfDlL_KB.js";
function getTableHeaders(item) {
  if (item.type == "collection") {
    let keys = [];
    for (let row in item.values)
      for (let prop in item.values[row].value)
        if (keys.find((k) => k.id == prop) == null) {
          let col = item.values[row].value[prop];
          keys.push({ id: col.id, name: col.name || col.id });
        }
    return keys;
  }
  return [];
}
__name(getTableHeaders, "getTableHeaders");
function getObjectValues(item) {
  return Object.keys(item.value).map((v) => {
    let value = item.value[v];
    if (value)
      return value;
  });
}
__name(getObjectValues, "getObjectValues");
function isTable(item) {
  if (item.type === "collection")
    return !item.values.find((v) => v.type !== "object");
}
__name(isTable, "isTable");
function differenceIsTable(item) {
  if (item.type === "collection") {
    let originalValuesAreSingle = !1, updatedValuesAreSingles = !1;
    return item.originalValue && (originalValuesAreSingle = !item.originalValue.values.find((v) => v.type !== "object")), item.updatedValue && (updatedValuesAreSingles = !item.updatedValue.values.find((v) => v.type !== "object")), originalValuesAreSingle || updatedValuesAreSingles;
  }
}
__name(differenceIsTable, "differenceIsTable");
function isMultiple(item) {
  if (item.type === "collection")
    return !item.values.find((v) => v.type !== "single");
}
__name(isMultiple, "isMultiple");
function differenceIsMultiple(item) {
  if (item.type === "collection") {
    let originalValuesAreSingle = !1, updatedValuesAreSingles = !1;
    return item.originalValue && (originalValuesAreSingle = !item.originalValue.values.find((v) => v.type !== "single")), item.updatedValue && (updatedValuesAreSingles = !item.updatedValue.values.find((v) => v.type !== "single")), originalValuesAreSingle || updatedValuesAreSingles;
  }
}
__name(differenceIsMultiple, "differenceIsMultiple");
function isSingle(item) {
  return item.type === "single";
}
__name(isSingle, "isSingle");
function isObject(item) {
  return item.type === "object";
}
__name(isObject, "isObject");
function isSignature(item) {
  return item.type === "single" && item.value && item.value.indexOf("data:image/png") == 0;
}
__name(isSignature, "isSignature");
function getMultiple(item) {
  return item.type == "collection" ? item.id === "preprocessing.stages" ? item.values.filter((v) => v.type === "single").map((v) => v.id) : item.values.filter((v) => v.type === "single").map((v) => v.value) : [];
}
__name(getMultiple, "getMultiple");
function getTableValue(item, header) {
  if (item.type !== "object")
    return null;
  let matched = item.value[header.id];
  return matched && (matched.type === "single" || matched.type === "collection") ? matched : null;
}
__name(getTableValue, "getTableValue");
async function createdSingleSourceModels(sourceMetadataItems, metadataDifferenceModels) {
  await Promise.all(sourceMetadataItems.map(async (metadataItem) => {
    if (metadataItem) {
      let metadataItemValue = metadataItem.value;
      metadataItem.type === "collection" && (metadataItemValue = metadataItem);
      let newDifferenceModel = {
        id: metadataItem.id,
        name: metadataItem.name,
        type: metadataItem.type,
        originalValue: metadataItemValue,
        updatedValue: null
      };
      metadataDifferenceModels.push(newDifferenceModel);
    } else {
      let updatedDifferenceModel = { id: "", name: "", type: "", originalValue: null, updatedValue: null };
      metadataDifferenceModels.push(updatedDifferenceModel);
    }
  }));
}
__name(createdSingleSourceModels, "createdSingleSourceModels");
async function createdSingleUpdatedModels(metadataItems, metadataDifferenceModels) {
  await Promise.all(metadataItems.map(async (metadataItem) => {
    if (metadataItem) {
      let metadataItemValue = metadataItem.value;
      if (metadataItem.type === "collection" && (metadataItemValue = metadataItem), metadataItem.type === "object")
        for (const [key, payloadMetadataItem] of Object.entries(metadataItem.value)) {
          let existingUpdatedValueIndex = metadataDifferenceModels.findIndex((mdm) => mdm.id === payloadMetadataItem.id);
          if (existingUpdatedValueIndex > -1)
            metadataDifferenceModels[existingUpdatedValueIndex].updatedValue = payloadMetadataItem.value;
          else {
            let updatedDifferenceModel = { id: payloadMetadataItem.id, name: payloadMetadataItem.name, type: payloadMetadataItem.type, originalValue: null, updatedValue: payloadMetadataItem.value };
            metadataDifferenceModels.push(updatedDifferenceModel);
          }
        }
      else {
        let existingUpdatedValueIndex = metadataDifferenceModels.findIndex((mdm) => mdm.id === metadataItem.id);
        if (existingUpdatedValueIndex > -1)
          metadataDifferenceModels[existingUpdatedValueIndex].updatedValue = metadataItemValue;
        else {
          let updatedDifferenceModel = { id: metadataItem.id, name: metadataItem.name, type: metadataItem.type, originalValue: null, updatedValue: metadataItemValue };
          metadataDifferenceModels.push(updatedDifferenceModel);
        }
      }
    } else {
      let updatedDifferenceModel = { id: "", name: "", type: "", originalValue: null, updatedValue: null };
      metadataDifferenceModels.push(updatedDifferenceModel);
    }
  }));
}
__name(createdSingleUpdatedModels, "createdSingleUpdatedModels");
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a;
let MetadataValueComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "showAttributes");
    __publicField(this, "filter");
    __publicField(this, "forceColumnId");
  }
  get item() {
    return this.value;
  }
  openSignature(item) {
    let newTab = window.open();
    newTab.document.body.innerHTML = '<img src="' + item.value + '">';
  }
}, __name(_a, "MetadataValueComponent"), _a);
__decorateClass$1([
  Prop({
    required: !0
  })
], MetadataValueComponent.prototype, "value", 2);
__decorateClass$1([
  Prop({ required: !1, default: !1 })
], MetadataValueComponent.prototype, "showAttributes", 2);
__decorateClass$1([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], MetadataValueComponent.prototype, "filter", 2);
__decorateClass$1([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], MetadataValueComponent.prototype, "forceColumnId", 2);
MetadataValueComponent = __decorateClass$1([
  Component({
    name: "metadata-value",
    methods: {
      isObject,
      isSingle,
      isSignature,
      getMultiple,
      isMultiple,
      isTable,
      getObjectValues,
      getTableValue,
      getTableHeaders
    },
    components: { AttributesValue }
  })
], MetadataValueComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _vm.item ? _c("div", [_vm.isSignature(_vm.item) ? _c("span", [_c("a", { staticClass: "link-opacity-100", staticStyle: { cursor: "pointer" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.openSignature(_vm.item);
  }, "click") } }, [_vm._v(`
            View
        `)])]) : _vm._e(), _vm._v(" "), _vm.isSingle(_vm.item) && !_vm.isSignature(_vm.item) ? _c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(_vm.item.value, _vm.filter)) } }) : _vm.isTable(_vm.item) ? _c("span", [_c("table", { staticClass: "table table-sm table-bordered" }, [_c("thead", [_c("tr", _vm._l(_vm.getTableHeaders(_vm.item), function(header) {
    return _c("th", { staticStyle: { "word-break": "keep-all", "white-space": "nowrap" } }, [_vm.forceColumnId ? [_vm._v(`
                        ` + _vm._s(header.id) + `
                    `)] : [_vm._v(`
                        ` + _vm._s(header.name) + `
                    `)]], 2);
  }), 0)]), _vm._v(" "), _c("tbody", _vm._l(_vm.item.values, function(tableRow) {
    return _c("tr", _vm._l(_vm.getTableHeaders(_vm.item), function(header) {
      return _c("td", { staticStyle: { "word-break": "keep-all", "white-space": "nowrap" } }, [_vm.getTableValue(tableRow, header) ? _c("metadata-value", { attrs: { value: _vm.getTableValue(tableRow, header), filter: _vm.filter, "show-attributes": _vm.showAttributes } }) : _vm._e()], 1);
    }), 0);
  }), 0)])]) : _vm.isMultiple(_vm.item) ? _c("span", [_c("ul", { staticClass: "list-unstyled" }, _vm._l(_vm.getMultiple(_vm.item), function(multipleValue) {
    return _c("li", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(multipleValue, _vm.filter)) } });
  }), 0)]) : _vm.isObject(_vm.item) ? _c("span", [_c("table", { staticClass: "table table-sm table-bordered" }, _vm._l(_vm.getObjectValues(_vm.item), function(value) {
    return _c("tr", [_c("th", { staticClass: "text-nowrap" }, [_vm._v(`
                    ` + _vm._s(value.id) + `
                `)]), _vm._v(" "), _c("td", { staticClass: "text-wrap" }, [_c("metadata-value", { attrs: { value, "show-attributes": _vm.showAttributes } })], 1)]);
  }), 0)]) : _vm._e(), _vm._v(" "), _vm.showAttributes ? _c("attributes-value", { staticClass: "float-right", attrs: { value: _vm.item } }) : _vm._e()], 1) : _vm._e();
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  MetadataValueComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "e7ed1019"
);
const MetadataValue = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a2;
let MetadataSummaryComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "showDisplayName");
    __publicField(this, "filter");
    __publicField(this, "forceColumnId");
    __publicField(this, "showAttributes");
  }
}, __name(_a2, "MetadataSummaryComponent"), _a2);
__decorateClass([
  Prop({ required: !0 })
], MetadataSummaryComponent.prototype, "value", 2);
__decorateClass([
  Prop({ required: !1, default: !0 })
], MetadataSummaryComponent.prototype, "showDisplayName", 2);
__decorateClass([
  Prop({ required: !1, default: "" })
], MetadataSummaryComponent.prototype, "filter", 2);
__decorateClass([
  Prop({ required: !1, default: /* @__PURE__ */ __name(() => !1, "default") })
], MetadataSummaryComponent.prototype, "forceColumnId", 2);
__decorateClass([
  Prop({ required: !1, default: !1 })
], MetadataSummaryComponent.prototype, "showAttributes", 2);
MetadataSummaryComponent = __decorateClass([
  Component({
    components: { AttributesValue, MetadataValue }
  })
], MetadataSummaryComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticStyle: { "overflow-x": "auto" } }, [!_vm.value || _vm.value.length === 0 ? _c("div", [_c("em", [_vm._v("No Metadata")])]) : _c("b-table-simple", { staticClass: "mb-0", attrs: { small: "" } }, _vm._l(_vm.value, function(item, index) {
    return _c("tr", [_c("td", { staticClass: "w-25" }, [_vm.showDisplayName ? _c("div", { staticClass: "text-right font-weight-bold", staticStyle: { "word-break": "keep-all", "white-space": "nowrap" } }, [_vm._v(_vm._s(item.name))]) : _c("div", { staticClass: "text-right font-weight-bold", staticStyle: { "word-break": "keep-all", "white-space": "nowrap" } }, [_vm._v(_vm._s(item.id))])]), _vm._v(" "), _c("td", [_c("metadata-value", { attrs: { value: item, filter: _vm.filter, forceColumnId: _vm.forceColumnId, "show-attributes": _vm.showAttributes } })], 1)]);
  }), 0)], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  MetadataSummaryComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "a6544a6a"
);
const MetadataSummary = __component__.exports;
export {
  MetadataSummary as M,
  MetadataValue as a,
  getTableValue as b,
  getMultiple as c,
  differenceIsMultiple as d,
  createdSingleSourceModels as e,
  createdSingleUpdatedModels as f,
  getTableHeaders as g,
  isTable as h,
  isSingle as i,
  isObject as j,
  isMultiple as k,
  differenceIsTable as l,
  getObjectValues as m
};
