var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { aE as defineComponent, aF as ref$1, aH as computed, aG as onMounted, bv as BModal, n as normalizeComponent, bw as inject, bx as toRef, by as provide, bz as $store, a4 as IntegrationActionTypes, aw as AdministrationIntegrationsFacadeClient, T as Transformer, b as baseUrl, bA as StatusCode, t as toastr, P as Prop, C as Component, f as draggable, V as Vue } from "./main-DAVWuHbi.js";
import { I as IntegrationSettingsCollection } from "./configuration-CoROFe-z.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
import { P as PlaceholderInformation } from "./placeholderInformation-CJo0noa4.js";
import { L as LoginBoxModal } from "./loginBoxModal-1oA1OVrR.js";
import { I as IntegrationInstanceDropdown } from "./IntegrationInstanceDropdown-DCcBBPtX.js";
import { V as VModel } from "./VModel-D6nuZPuz.js";
const serviceKey$1 = Symbol(), serviceKey = Symbol(), _StaticValueBrowsePageResult = class _StaticValueBrowsePageResult {
  constructor(items, hasMorePages, totalPages, currentPageDescriptor, nextPageDescriptor) {
    __publicField(this, "items");
    __publicField(this, "hasMorePages");
    __publicField(this, "totalPages");
    __publicField(this, "currentPageDescriptor");
    __publicField(this, "nextPageDescriptor");
    this.items = items, this.hasMorePages = hasMorePages, this.totalPages = totalPages, this.currentPageDescriptor = currentPageDescriptor, this.nextPageDescriptor = nextPageDescriptor;
  }
};
__name(_StaticValueBrowsePageResult, "StaticValueBrowsePageResult");
let StaticValueBrowsePageResult = _StaticValueBrowsePageResult;
const _StaticValueBrowsePageError = class _StaticValueBrowsePageError {
  constructor(messages) {
    __publicField(this, "messages");
    this.messages = messages;
  }
};
__name(_StaticValueBrowsePageError, "StaticValueBrowsePageError");
let StaticValueBrowsePageError = _StaticValueBrowsePageError;
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "staticValueBrowseModal",
  props: {
    title: null,
    browseProvider: null
  },
  emits: ["closed"],
  setup(__props, { emit }) {
    const props = __props, browseModal = ref$1(null), isBusy = ref$1(!1), fields = ref$1([]), items = ref$1([]), pagingEnabled = ref$1(!1), pageNumber = ref$1(1), isFirstPage = computed(() => pageNumber.value == 1), hasMorePages = ref$1(!1), totalPages = ref$1(null), previousPageDescriptors = ref$1([]), currentPageDescriptor = ref$1(null), nextPageDescriptor = ref$1(null), selectedItem = ref$1(null), canAccept = computed(() => !isBusy.value && selectedItem.value);
    onMounted(async () => {
      browseModal.value.show(), await loadFirstPage();
    });
    async function loadFirstPage() {
      var _a2;
      isBusy.value = !0;
      try {
        const pageResult = await props.browseProvider.getItems(null);
        pageResult instanceof StaticValueBrowsePageResult && (fields.value = getTableFields(pageResult.items), items.value = pageResult.items, pageNumber.value = ((_a2 = pageResult.currentPageDescriptor) == null ? void 0 : _a2.number) ?? 1, pagingEnabled.value = pageResult.hasMorePages || pageNumber.value > 1, hasMorePages.value = pageResult.hasMorePages, totalPages.value = pageResult.totalPages, previousPageDescriptors.value = [], currentPageDescriptor.value = pageResult.currentPageDescriptor, nextPageDescriptor.value = pageResult.nextPageDescriptor);
      } catch (ex) {
        console.error(ex);
      } finally {
        isBusy.value = !1;
      }
    }
    __name(loadFirstPage, "loadFirstPage");
    async function navigateToPreviousPage() {
      var _a2;
      isBusy.value = !0;
      try {
        const previousPageDescriptor = previousPageDescriptors.value.at(-1), pageResult = await props.browseProvider.getItems(previousPageDescriptor);
        pageResult instanceof StaticValueBrowsePageResult && (fields.value = getTableFields(pageResult.items), items.value = pageResult.items, pageNumber.value = ((_a2 = pageResult.currentPageDescriptor) == null ? void 0 : _a2.number) ?? 1, pagingEnabled.value = pageResult.hasMorePages || pageNumber.value > 1, hasMorePages.value = pageResult.hasMorePages, totalPages.value = pageResult.totalPages, previousPageDescriptors.value.pop(), currentPageDescriptor.value = pageResult.currentPageDescriptor, nextPageDescriptor.value = pageResult.nextPageDescriptor);
      } catch (ex) {
        console.error(ex);
      } finally {
        isBusy.value = !1;
      }
    }
    __name(navigateToPreviousPage, "navigateToPreviousPage");
    async function navigateToNextPage() {
      var _a2;
      isBusy.value = !0;
      try {
        const pageResult = await props.browseProvider.getItems(nextPageDescriptor.value);
        pageResult instanceof StaticValueBrowsePageResult && (fields.value = getTableFields(pageResult.items), items.value = pageResult.items, pageNumber.value = ((_a2 = pageResult.currentPageDescriptor) == null ? void 0 : _a2.number) ?? 1, pagingEnabled.value = pageResult.hasMorePages || pageNumber.value > 1, hasMorePages.value = pageResult.hasMorePages, totalPages.value = pageResult.totalPages, previousPageDescriptors.value.push(currentPageDescriptor.value), currentPageDescriptor.value = pageResult.currentPageDescriptor, nextPageDescriptor.value = pageResult.nextPageDescriptor);
      } catch (ex) {
        console.error(ex);
      } finally {
        isBusy.value = !1;
      }
    }
    __name(navigateToNextPage, "navigateToNextPage");
    function getTableFields(items2) {
      const propertyNames = /* @__PURE__ */ new Set();
      for (const item of items2 ?? [])
        for (const propertyName of Object.keys(item.properties))
          propertyNames.add(propertyName);
      const tableFields = [];
      for (const propertyName of propertyNames)
        tableFields.push({
          key: `properties.${propertyName}`,
          label: propertyName
        });
      return tableFields;
    }
    __name(getTableFields, "getTableFields");
    function onRowSelected(rows) {
      const item = (rows == null ? void 0 : rows.length) > 0 ? rows[0] : null;
      if (item != null && item.selectable) {
        selectedItem.value = item;
        return;
      }
      selectedItem.value = null;
    }
    __name(onRowSelected, "onRowSelected");
    function accept() {
      selectedItem.value && (browseModal.value.hide(), emit("closed", selectedItem.value.value));
    }
    __name(accept, "accept");
    function cancel() {
      browseModal.value.hide(), emit("closed");
    }
    return __name(cancel, "cancel"), { __sfc: !0, emit, props, browseModal, isBusy, fields, items, pagingEnabled, pageNumber, isFirstPage, hasMorePages, totalPages, previousPageDescriptors, currentPageDescriptor, nextPageDescriptor, selectedItem, canAccept, loadFirstPage, navigateToPreviousPage, navigateToNextPage, getTableFields, onRowSelected, accept, cancel, BModal };
  }
});
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c, _setup = _vm._self._setupProxy;
  return _c(_setup.BModal, { ref: "browseModal", attrs: { size: "lg" }, on: { onclose: _setup.cancel }, scopedSlots: _vm._u([{ key: "modal-header", fn: /* @__PURE__ */ __name(function({ close }) {
    return [_c("h5", [_c("span", [_c("font-awesome-icon", { attrs: { icon: "list" } }), _vm._v(" " + _vm._s(_vm.title) + `
      `)], 1)]), _vm._v(" "), _c("button", { staticClass: "close float-right", attrs: { type: "button" }, on: { click: _setup.cancel } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])];
  }, "fn") }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: _setup.cancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "success", disabled: !_setup.canAccept }, on: { click: _setup.accept } }, [_vm._v("Select Item")])];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("div", [_setup.isBusy ? [_c("span", [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { size: "xl", icon: "sync" } })], 1)] : [_c("b-table", { attrs: { items: _setup.items, fields: _setup.fields, "sticky-header": !0, selectable: !0, "select-mode": "single", "selected-variant": "primary", "head-variant": "light" }, on: { "row-selected": _setup.onRowSelected } }), _vm._v(" "), _setup.pagingEnabled ? [_c("ul", { staticClass: "pagination justify-content-center" }, [_c("li", { staticClass: "page-item", class: { disabled: _setup.isFirstPage } }, [_c("a", { staticClass: "page-link", attrs: { href: "#" }, on: { click: _setup.navigateToPreviousPage } }, [_c("font-awesome-icon", { attrs: { icon: "angle-left" } })], 1)]), _vm._v(" "), _c("li", { staticClass: "page-item disabled" }, [_c("span", { staticClass: "page-link" }, [_vm._v(`
              ` + _vm._s(_setup.pageNumber) + `
            `)])]), _vm._v(" "), _c("li", { staticClass: "page-item" }, [_c("a", { staticClass: "page-link", class: { disabled: _setup.hasMorePages }, on: { click: _setup.navigateToNextPage } }, [_c("font-awesome-icon", { attrs: { icon: "angle-right" } })], 1)])])] : _vm._e()]], 2)]);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  _sfc_main$5,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  "6db71550"
);
const StaticValueBrowseModal = __component__$6.exports, _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "uploadField",
  props: {
    configuration: null,
    template: null,
    index: null
  },
  emits: ["update:configuration", "removed"],
  setup(__props, { emit }) {
    const props = __props, viewPathAccessor = inject(serviceKey$1), browseProviderFactory = inject(serviceKey), configuration = toRef(props, "configuration"), template = toRef(props, "template"), showBrowseModal = ref$1(!1), browseModalTitle = computed(() => `Browse field ${configuration.value.name}`), browseProvider = ref$1(null), name = computed({
      get() {
        return configuration.value.name ?? "";
      },
      set(value2) {
        isUserCustom.value && emit("update:configuration", { name: value2 });
      }
    }), isUserCustom = computed(() => {
      var _a2;
      return ((_a2 = template.value) == null ? void 0 : _a2.isUserCustom) ?? configuration.value.isUserCustom ?? !1;
    }), fieldNameReadOnly = computed(() => !isUserCustom.value), isBrowsable = computed(() => configuration.value.isBrowsable ?? !1), isEnabled = computed({
      get: /* @__PURE__ */ __name(() => !(configuration.value.isIgnored ?? !1), "get"),
      set: /* @__PURE__ */ __name((value2) => emit("update:configuration", { isIgnored: !value2 }), "set")
    }), value = computed({
      get: /* @__PURE__ */ __name(() => configuration.value.value ?? "", "get"),
      set: /* @__PURE__ */ __name((value2) => emit("update:configuration", { value: value2 }), "set")
    }), fieldTypes = computed({
      get: /* @__PURE__ */ __name(() => configuration.value.fieldTypes ?? [], "get"),
      set: /* @__PURE__ */ __name((value2) => emit("update:configuration", { fieldTypes: value2 }), "set")
    }), selectedType = computed({
      get: /* @__PURE__ */ __name(() => configuration.value.selectedType ?? "", "get"),
      set: /* @__PURE__ */ __name((value2) => emit("update:configuration", { selectedType: value2 }), "set")
    }), isMandatory = computed({
      get() {
        var _a2;
        return (_a2 = template.value) != null && _a2.systemMandatory ? !0 : configuration.value.mandatory ?? !1;
      },
      set(value2) {
        var _a2;
        (_a2 = template.value) != null && _a2.systemMandatory || emit("update:configuration", { mandatory: value2 });
      }
    }), maxLength = computed({
      get() {
        return configuration.value.maxLength ?? 0;
      },
      set(value2) {
        value2 >= 0 && emit("update:configuration", { maxLength: value2 });
      }
    });
    async function browseValue() {
      const viewPath = viewPathAccessor.viewPath;
      browseProvider.value = browseProviderFactory.create(configuration.value, viewPath), showBrowseModal.value = !0;
    }
    __name(browseValue, "browseValue");
    function onBrowseModalClosed(selectedValue) {
      showBrowseModal.value = !1, browseProvider.value = null, selectedValue && (console.log("User selected: ", selectedValue), value.value = selectedValue);
    }
    return __name(onBrowseModalClosed, "onBrowseModalClosed"), { __sfc: !0, viewPathAccessor, browseProviderFactory, emit, props, configuration, template, showBrowseModal, browseModalTitle, browseProvider, name, isUserCustom, fieldNameReadOnly, isBrowsable, isEnabled, value, fieldTypes, selectedType, isMandatory, maxLength, browseValue, onBrowseModalClosed, StaticValueBrowseModal };
  }
});
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c, _setup = _vm._self._setupProxy;
  return _c("tr", [_c("td", { staticClass: "align-middle" }, [_c("b-checkbox", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "text-center", attrs: { switch: "", title: "Enabled" }, model: { value: _setup.isEnabled, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.isEnabled = $$v;
  }, "callback"), expression: "isEnabled" } })], 1), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_setup.isBrowsable ? [_c("b-input-group", [_c("b-input", { attrs: { disabled: !_setup.isEnabled, type: "text", size: "sm" }, model: { value: _setup.value, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.value = $$v;
  }, "callback"), expression: "value" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-button", { directives: [{ name: "b-hover", rawName: "v-b-hover" }], attrs: { size: "sm", variant: "success", disabled: !_setup.isEnabled, tooltip: "", title: "Browse field values." }, on: { click: _setup.browseValue } }, [_vm._v("...")])], 1), _vm._v(" "), _setup.showBrowseModal ? [_c(_setup.StaticValueBrowseModal, { attrs: { title: _setup.browseModalTitle, "browse-provider": _setup.browseProvider }, on: { closed: _setup.onBrowseModalClosed } })] : _vm._e()], 2)] : [_c("b-input", { attrs: { disabled: !_setup.isEnabled, type: "text", size: "sm" }, model: { value: _setup.value, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.value = $$v;
  }, "callback"), expression: "value" } })]], 2), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_c("b-input", { attrs: { disabled: !_setup.isEnabled, readonly: _setup.fieldNameReadOnly, type: "text", size: "sm" }, model: { value: _setup.name, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.name = $$v;
  }, "callback"), expression: "name" } })], 1), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_c("b-form-select", { staticClass: "v-select w-100 align-middle", attrs: { size: "sm", disabled: !_setup.isEnabled }, model: { value: _setup.selectedType, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.selectedType = $$v;
  }, "callback"), expression: "selectedType" } }, _vm._l(_setup.fieldTypes, function(fieldType) {
    return _c("option", [_vm._v(`
                ` + _vm._s(fieldType) + `
            `)]);
  }), 0)], 1), _vm._v(" "), _c("td", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { title: "Mandatory" } }, [_c("b-checkbox", { staticClass: "text-center", attrs: { disabled: !_setup.isEnabled }, model: { value: _setup.isMandatory, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.isMandatory = $$v;
  }, "callback"), expression: "isMandatory" } })], 1), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_c("b-input", { attrs: { disabled: !_setup.isEnabled, type: "number", size: "sm", min: "0" }, model: { value: _setup.maxLength, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.maxLength = $$v;
  }, "callback"), expression: "maxLength" } })], 1), _vm._v(" "), _c("td", [_setup.isUserCustom ? _c("b-button", { staticClass: "float-right", attrs: { size: "sm", variant: "danger", type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _setup.emit("removed");
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1) : _vm._e()], 1)]);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  _sfc_main$4,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  "9c32b945"
);
const UploadFieldComponent = __component__$5.exports, _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "uploadFieldSet",
  props: {
    configuration: null,
    template: null,
    index: null
  },
  emits: ["update:configuration", "open", "removed"],
  setup(__props, { emit }) {
    const props = __props, configuration = toRef(props, "configuration"), template = toRef(props, "template"), name = computed({
      get() {
        return configuration.value.name;
      },
      set(value2) {
        isUserCustom.value && emit("update:configuration", { name: value2 });
      }
    }), value = computed({
      get: /* @__PURE__ */ __name(() => configuration.value.value ?? "", "get"),
      set: /* @__PURE__ */ __name((value2) => emit("update:configuration", { value: value2 }), "set")
    }), isUserCustom = computed(() => {
      var _a2;
      return ((_a2 = template.value) == null ? void 0 : _a2.isUserCustom) ?? configuration.value.isUserCustom ?? !1;
    }), fieldNameReadOnly = computed(() => !isUserCustom.value), isEnabled = computed({
      get: /* @__PURE__ */ __name(() => !(configuration.value.isIgnored ?? !1), "get"),
      set: /* @__PURE__ */ __name((value2) => emit("update:configuration", { isIgnored: !value2 }), "set")
    });
    return { __sfc: !0, emit, props, configuration, template, name, value, isUserCustom, fieldNameReadOnly, isEnabled };
  }
});
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c, _setup = _vm._self._setupProxy;
  return _c("tr", [_c("td", { staticClass: "align-middle" }, [_c("b-checkbox", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "text-center", attrs: { switch: "", title: "Enabled" }, model: { value: _setup.isEnabled, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.isEnabled = $$v;
  }, "callback"), expression: "isEnabled" } })], 1), _vm._v(" "), _c("td", [_c("b-input", { attrs: { disabled: !_setup.isEnabled, type: "text", size: "sm" }, model: { value: _setup.value, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.value = $$v;
  }, "callback"), expression: "value" } })], 1), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_c("b-input-group", { attrs: { size: "sm" }, scopedSlots: _vm._u([{ key: "append", fn: /* @__PURE__ */ __name(function() {
    return [_c("button", { staticClass: "btn btn-success", on: { click: /* @__PURE__ */ __name(function($event) {
      return _setup.emit("open");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "arrow-right" } })], 1)];
  }, "fn"), proxy: !0 }]) }, [_c("b-form-input", { attrs: { disabled: !_setup.isEnabled, readonly: _setup.fieldNameReadOnly, type: "text" }, model: { value: _setup.name, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.name = $$v;
  }, "callback"), expression: "name" } })], 1)], 1), _vm._v(" "), _c("td"), _vm._v(" "), _c("td"), _vm._v(" "), _c("td"), _vm._v(" "), _c("td", [_setup.isUserCustom ? _c("b-button", { staticClass: "float-right", attrs: { size: "sm", variant: "danger", type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _setup.emit("removed");
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1) : _vm._e()], 1)]);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  _sfc_main$3,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  "e5ae9233"
);
const UploadFieldSetComponent = __component__$4.exports, _UploadFieldFactory = class _UploadFieldFactory {
  static createConfigurationFromTemplate(template, isUserCustom, templateName) {
    switch (template.discriminator) {
      case "Field":
        return this.createFieldConfigurationFromTemplate(template, isUserCustom, templateName);
      case "FieldSet":
        return this.createFieldSetConfigurationFromTemplate(template, isUserCustom, templateName);
      default:
        throw `Unexpected field type '${template.discriminator}'`;
    }
  }
  static createFieldConfigurationFromTemplate(template, isUserCustom, templateName) {
    return {
      discriminator: "Field",
      fieldTypes: template.fieldTypes,
      isBrowsable: template.isBrowsable,
      isIgnored: !template.defaultToStaticValue,
      isUserCustom,
      mandatory: template.systemMandatory || template.userMandatoryDefault,
      maxLength: template.systemMaxLength || template.userMaxLengthDefault,
      name: template.name,
      selectedType: template.selectedType,
      templateName,
      value: template.defaultToStaticValue ? template.staticValueDefault : ""
    };
  }
  static createFieldSetConfigurationFromTemplate(template, isUserCustom, templateName) {
    var _a2;
    const configuration = {
      discriminator: "FieldSet",
      fieldTypes: template.fieldTypes,
      isIgnored: !0,
      isUserCustom,
      templateName,
      name: template.name,
      items: []
    };
    return (_a2 = template.items) == null || _a2.forEach((childTemplate) => {
      const childItem = this.createConfigurationFromTemplate(childTemplate, isUserCustom, templateName);
      configuration.items.push(childItem);
    }), configuration;
  }
};
__name(_UploadFieldFactory, "UploadFieldFactory");
let UploadFieldFactory = _UploadFieldFactory;
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "uploadFieldsView",
  props: {
    items: null,
    definitions: null,
    templates: null,
    fieldTypes: null,
    allowUserAddFields: { type: Boolean }
  },
  emits: ["update:items", "navigate", "populateCustomFields"],
  setup(__props, { emit }) {
    const props = __props, items = toRef(props, "items"), definitions = toRef(props, "definitions"), loadingCustomFields = ref$1(!1);
    function navigateTo(target) {
      emit("navigate", target);
    }
    __name(navigateTo, "navigateTo");
    function removeItem(index) {
      items.value.splice(index, 1), emit("update:items", items.value);
    }
    __name(removeItem, "removeItem");
    function uploadFieldChanged(field, payload) {
      console.debug("uploadFieldChanged(): ", payload), Object.assign(field, payload), emit("update:items", items.value);
    }
    __name(uploadFieldChanged, "uploadFieldChanged");
    function uploadFieldSetChanged(fieldSet, payload) {
      console.debug("uploadFieldSetChanged(): ", payload), Object.assign(fieldSet, payload), emit("update:items", items.value);
    }
    __name(uploadFieldSetChanged, "uploadFieldSetChanged");
    function getItemType(field) {
      return field.discriminator;
    }
    __name(getItemType, "getItemType");
    function getTemplate(field) {
      var _a2;
      return field.isUserCustom ? null : ((_a2 = definitions.value) == null ? void 0 : _a2.find((t) => t.name.toLowerCase() == field.name.toLowerCase())) ?? field;
    }
    __name(getTemplate, "getTemplate");
    function addCustomField() {
      const fieldTypesOrDefault = props.fieldTypes ?? ["String"], customField = {
        discriminator: "Field",
        fieldTypes: fieldTypesOrDefault,
        isIgnored: !1,
        isUserCustom: !0,
        mandatory: !1,
        maxLength: 0,
        name: "New Field",
        selectedType: fieldTypesOrDefault[0],
        templateName: "",
        value: ""
      };
      items.value.push(customField), emit("update:items", items.value);
    }
    __name(addCustomField, "addCustomField");
    function addCustomFieldFromTemplate(template) {
      const customField = UploadFieldFactory.createConfigurationFromTemplate(template, !0, template.name);
      customField.templateName = template.name, items.value.push(customField), emit("update:items", items.value);
    }
    __name(addCustomFieldFromTemplate, "addCustomFieldFromTemplate");
    function populateCustomFields() {
      loadingCustomFields.value = !0, emit("populateCustomFields", populateCustomFieldsCompleted);
    }
    __name(populateCustomFields, "populateCustomFields");
    function populateCustomFieldsCompleted() {
      loadingCustomFields.value = !1;
    }
    return __name(populateCustomFieldsCompleted, "populateCustomFieldsCompleted"), { __sfc: !0, emit, props, items, definitions, loadingCustomFields, navigateTo, removeItem, uploadFieldChanged, uploadFieldSetChanged, getItemType, getTemplate, addCustomField, addCustomFieldFromTemplate, populateCustomFields, populateCustomFieldsCompleted, UploadFieldComponent, UploadFieldSetComponent };
  }
});
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _a2;
  var _vm = this, _c = _vm._self._c, _setup = _vm._self._setupProxy;
  return (_a2 = _setup.items) != null && _a2.length ? _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-12" }, [_c("table", { staticClass: "table table-sm table-hover" }, [_c("thead", [_c("tr", [_c("th", { staticStyle: { width: "28px" }, attrs: { scope: "col" } }), _vm._v(" "), _c("th", { attrs: { scope: "col" } }, [_vm._v("Source")]), _vm._v(" "), _c("th", { attrs: { scope: "col" } }, [_vm._v("Target Field")]), _vm._v(" "), _c("th", { staticStyle: { width: "150px" }, attrs: { scope: "col" } }, [_vm._v("Type")]), _vm._v(" "), _c("th", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticStyle: { width: "28px" }, attrs: { scope: "col", title: "Mandatory" } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "circle-check" } })], 1), _vm._v(" "), _c("th", { staticStyle: { width: "90px" }, attrs: { scope: "col" } }, [_vm._v("Max Length")]), _vm._v(" "), _c("th", { staticStyle: { width: "34px" }, attrs: { scope: "col" } })])]), _vm._v(" "), _c("tbody", [_vm._l(_setup.items, function(field, index) {
    return [_setup.getItemType(field) == "Field" ? _c(_setup.UploadFieldComponent, { key: index, attrs: { configuration: field, index, template: _setup.getTemplate(field) }, on: { removed: /* @__PURE__ */ __name(function($event) {
      return _setup.removeItem(index);
    }, "removed"), "update:configuration": /* @__PURE__ */ __name(function($event) {
      return _setup.uploadFieldChanged(field, $event);
    }, "update:configuration"), browseValue: /* @__PURE__ */ __name(function($event) {
      return _vm.browseFieldValue(field);
    }, "browseValue") } }) : _setup.getItemType(field) == "FieldSet" ? _c(_setup.UploadFieldSetComponent, { key: index, attrs: { configuration: field, index, template: _setup.getTemplate(field) }, on: { removed: /* @__PURE__ */ __name(function($event) {
      return _setup.removeItem(index);
    }, "removed"), "update:configuration": /* @__PURE__ */ __name(function($event) {
      return _setup.uploadFieldSetChanged(field, $event);
    }, "update:configuration"), open: /* @__PURE__ */ __name(function($event) {
      return _setup.navigateTo(field);
    }, "open") } }) : [_c("label", [_vm._v("Unknown metadata item type.")])]];
  }), _vm._v(" "), _vm.allowUserAddFields ? _c("tr", [_c("td", { attrs: { colspan: "7" } }, [_setup.props.templates && _setup.props.templates.length ? _c("b-dropdown", { attrs: { "no-flip": "", size: "sm", variant: "outline-primary", "no-caret": "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "plus" } })];
  }, "fn"), proxy: !0 }], null, !1, 2748827064) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: _setup.addCustomField } }, [_vm._v(`
              Custom Field
            `)]), _vm._v(" "), _vm._l(_setup.props.templates, function(template) {
    return _c("b-dropdown-item", { key: template.name, on: { click: /* @__PURE__ */ __name(function($event) {
      return _setup.addCustomFieldFromTemplate(template);
    }, "click") } }, [_vm._v(`
              ` + _vm._s(template.name) + `
            `)]);
  })], 2) : _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { size: "sm", variant: "outline-primary", disabled: _setup.loadingCustomFields, title: "This will create a new custom field" }, on: { click: _setup.addCustomField } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { size: "sm", variant: "outline-primary", disabled: _setup.loadingCustomFields, title: "This will attempt to create the Custom Fields from the integration" }, on: { click: _setup.populateCustomFields } }, [_setup.loadingCustomFields ? _c("span", [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Populating...")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "list" } }), _vm._v(" Auto Populate")], 1)])], 1)]) : _vm._e()], 2)])])]) : _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-auto" }, [_c("label", { staticClass: "text-muted" }, [_vm._v("(no fields)")]), _vm._v(" "), _vm.allowUserAddFields ? _c("div", [_setup.props.templates && _setup.props.templates.length ? _c("b-dropdown", { attrs: { "no-flip": "", size: "sm", variant: "outline-primary", "no-caret": "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "plus" } })];
  }, "fn"), proxy: !0 }], null, !1, 2748827064) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: _setup.addCustomField } }, [_vm._v(`
          Custom Field
        `)]), _vm._v(" "), _vm._l(_setup.props.templates, function(template) {
    return _c("b-dropdown-item", { key: template.name, on: { click: /* @__PURE__ */ __name(function($event) {
      return _setup.addCustomFieldFromTemplate(template);
    }, "click") } }, [_vm._v(`
          ` + _vm._s(template.name) + `
        `)]);
  })], 2) : _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { size: "sm", variant: "outline-primary", disabled: _setup.loadingCustomFields, title: "This will create a new custom field" }, on: { click: _setup.addCustomField } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { size: "sm", variant: "outline-primary", disabled: _setup.loadingCustomFields, title: "This will attempt to create the Custom Fields from the integration" }, on: { click: _setup.populateCustomFields } }, [_setup.loadingCustomFields ? _c("span", [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Populating...")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "list" } }), _vm._v(" Auto Populate")], 1)])], 1) : _vm._e()])]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  _sfc_main$2,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const UploadFieldsView = __component__$3.exports, _UploadBreadcrumbItem = class _UploadBreadcrumbItem {
  constructor(item, definition, ancestors) {
    __publicField(this, "item");
    __publicField(this, "definition");
    __publicField(this, "ancestors");
    this.item = item, this.definition = definition, this.ancestors = ancestors;
  }
  ancestorsAndSelf() {
    const items = this.ancestors.slice();
    return items.push(this), items;
  }
  printablePath() {
    return this.ancestorsAndSelf().map((x) => x.item.name).join(" -> ");
  }
};
__name(_UploadBreadcrumbItem, "UploadBreadcrumbItem");
let UploadBreadcrumbItem = _UploadBreadcrumbItem;
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "uploadFieldsNavigator",
  props: {
    items: null,
    template: null
  },
  emits: ["update:items", "populateCustomFields"],
  setup(__props, { emit }) {
    const props = __props;
    provide(serviceKey$1, createViewPathAccessor());
    const breadcrumbs = ref$1([]), currentView = ref$1(null);
    onMounted(() => {
      navigateToRoot();
    });
    function navigateToRoot() {
      var _a2;
      console.info(`Navigating to root upload fields (Count = ${((_a2 = props.items) == null ? void 0 : _a2.length) ?? 0})`), breadcrumbs.value = [], currentView.value = {
        items: props.items,
        definitions: props.template.fields ?? [],
        templates: props.template.templates ?? [],
        fieldTypes: props.template.fieldTypes ?? [],
        allowUserAddFields: props.template.allowUser ?? !1
      };
    }
    __name(navigateToRoot, "navigateToRoot");
    function isActiveBreadcrumb(breadcrumb) {
      return breadcrumbs.value.indexOf(breadcrumb) == breadcrumbs.value.length - 1;
    }
    __name(isActiveBreadcrumb, "isActiveBreadcrumb");
    function navigateBackTo(breadcrumbItem) {
      var _a2;
      console.info("Navigating back to:", breadcrumbItem.printablePath()), (_a2 = breadcrumbItem.item).items ?? (_a2.items = []), breadcrumbs.value = breadcrumbItem.ancestorsAndSelf(), currentView.value = {
        items: breadcrumbItem.item.items,
        definitions: breadcrumbItem.definition.items ?? [],
        templates: breadcrumbItem.definition.templates ?? [],
        fieldTypes: breadcrumbItem.definition.fieldTypes ?? [],
        allowUserAddFields: breadcrumbItem.definition.allowUserDefinedFields ?? !1
      };
    }
    __name(navigateBackTo, "navigateBackTo");
    function navigateTo(item) {
      var _a2, _b;
      breadcrumbs.value ?? (breadcrumbs.value = []), item.items ?? (item.items = []);
      const ancestors = breadcrumbs.value.slice(), definition = (_a2 = currentView.value.definitions) == null ? void 0 : _a2.find((x) => x.discriminator == "FieldSet" && x.name.toLowerCase() == item.name.toLowerCase()), template = item.templateName && item.templateName.length > 0 ? (_b = currentView.value.templates) == null ? void 0 : _b.find((x) => x.discriminator == "FieldSet" && x.name.toLowerCase() == item.templateName.toLowerCase()) : void 0, definitionOrTemplate = definition ?? template ?? item, breadcrumbItem = new UploadBreadcrumbItem(item, definitionOrTemplate, ancestors);
      console.info("Navigating to:", breadcrumbItem.printablePath()), breadcrumbs.value.push(breadcrumbItem), currentView.value = {
        items: item.items,
        definitions: definitionOrTemplate.items ?? [],
        templates: definitionOrTemplate.templates ?? [],
        fieldTypes: definitionOrTemplate.fieldTypes ?? [],
        allowUserAddFields: definitionOrTemplate.allowUserDefinedFields ?? !1
      };
    }
    __name(navigateTo, "navigateTo");
    function onItemsChanged() {
      emit("update:items", props.items);
    }
    __name(onItemsChanged, "onItemsChanged");
    function populateCustomFields(completedCallback) {
      const viewPath = breadcrumbs.value.map((x) => x.item.name);
      emit("populateCustomFields", viewPath, currentView.value.items, completedCallback);
    }
    __name(populateCustomFields, "populateCustomFields");
    function createViewPathAccessor() {
      return {
        get viewPath() {
          return breadcrumbs.value.map((x) => x.item.name);
        }
      };
    }
    return __name(createViewPathAccessor, "createViewPathAccessor"), { __sfc: !0, emit, props, breadcrumbs, currentView, navigateToRoot, isActiveBreadcrumb, navigateBackTo, navigateTo, onItemsChanged, populateCustomFields, createViewPathAccessor, UploadFieldsView };
  }
});
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _a2;
  var _vm = this, _c = _vm._self._c, _setup = _vm._self._setupProxy;
  return _c("div", { staticClass: "container-fluid" }, [(_a2 = _setup.breadcrumbs) != null && _a2.length ? _c("b-breadcrumb", { staticClass: "mb-2" }, [_c("b-breadcrumb-item", { on: { click: /* @__PURE__ */ __name(function($event) {
    return _setup.navigateToRoot();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "home" } })], 1), _vm._v(" "), _vm._l(_setup.breadcrumbs, function(breadcrumb, index) {
    return _c("b-breadcrumb-item", { key: index, attrs: { active: _setup.isActiveBreadcrumb(breadcrumb) }, on: { click: /* @__PURE__ */ __name(function($event) {
      return $event.stopPropagation(), _setup.navigateBackTo(breadcrumb);
    }, "click") } }, [_vm._v(`
      ` + _vm._s(breadcrumb.item.name) + `
    `)]);
  })], 2) : _vm._e(), _vm._v(" "), _setup.currentView ? _c(_setup.UploadFieldsView, { attrs: { items: _setup.currentView.items, definitions: _setup.currentView.definitions, "field-types": _setup.currentView.fieldTypes, "allow-user-add-fields": _setup.currentView.allowUserAddFields, templates: _setup.currentView.templates }, on: { "update:items": _setup.onItemsChanged, navigate: /* @__PURE__ */ __name(function($event) {
    return _setup.navigateTo($event);
  }, "navigate"), populateCustomFields: /* @__PURE__ */ __name(function($event) {
    return _setup.populateCustomFields($event);
  }, "populateCustomFields") } }) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  _sfc_main$1,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  null
);
const UploadFieldsNavigator = __component__$2.exports, _UploadFieldsDefaults = class _UploadFieldsDefaults {
  static populateDefaults(sourceItems, builtInItems, templates, customFieldTypes, allowArbitraryFieldNames) {
    const returnItems = sourceItems.slice(), fieldSetsSupported = builtInItems.some((x) => x.discriminator == "FieldSet") || templates.some((x) => x.discriminator == "FieldSet");
    return sourceItems.forEach((sourceItem) => {
      const definition = builtInItems.find((x) => x.name.toLowerCase() == sourceItem.name.toLowerCase());
      if (definition)
        this.applyBuiltInDefaults(sourceItem, definition, customFieldTypes);
      else if (allowArbitraryFieldNames)
        if (sourceItem.discriminator == "FieldSet" && !fieldSetsSupported) {
          const itemIndex = returnItems.indexOf(sourceItem);
          returnItems.splice(itemIndex, 1), console.warn(`Removing unsupported field set '${sourceItem.name}'`);
        } else
          this.applyCustomDefaults(sourceItem, templates, customFieldTypes);
      else {
        const itemIndex = returnItems.indexOf(sourceItem);
        returnItems.splice(itemIndex, 1), console.warn(`Removing orphaned field '${sourceItem.name}'`);
      }
    }), builtInItems.forEach((definition) => {
      if (!returnItems.find((x) => x.name.toLowerCase() == definition.name.toLowerCase())) {
        const newItem = UploadFieldFactory.createConfigurationFromTemplate(definition, !1, definition.templateName);
        returnItems.push(newItem);
      }
    }), returnItems;
  }
  static applyBuiltInDefaults(configuration, template, customFieldTypes) {
    switch (template.discriminator) {
      case "Field":
        {
          configuration.discriminator !== template.discriminator && (console.warn(`Converting builtin '${configuration.name}' from ${configuration.discriminator} to template type ${template.discriminator}`), configuration.discriminator = template.discriminator);
          const fieldConfiguration = configuration, fieldTemplate = template;
          this.applyBuiltInFieldDefaults(fieldConfiguration, fieldTemplate, customFieldTypes);
        }
        break;
      case "FieldSet":
        {
          configuration.discriminator !== template.discriminator && (console.warn(`Converting builtin '${configuration.name}' from ${configuration.discriminator} to template type ${template.discriminator}`), configuration.discriminator = template.discriminator);
          const fieldSetConfiguration = configuration, fieldSetTemplate = template;
          this.applyBuiltInFieldSetDefaults(fieldSetConfiguration, fieldSetTemplate);
        }
        break;
      default:
        throw `Unexpected field type '${configuration.discriminator}'`;
    }
  }
  static applyBuiltInFieldDefaults(field, template, customFieldTypes) {
    const defaultType = "String", fieldTypes = template.fieldTypes ?? customFieldTypes ?? [defaultType];
    field.fieldTypes = fieldTypes, field.selectedType = this.selectFieldTypeOrDefault(fieldTypes, field.selectedType ?? defaultType, template.selectedType ?? defaultType), field.templateName = template.templateName, field.mandatory = this.getMandatoryDefault(template), field.maxLength = this.getMaxLengthDefault(template), field.isBrowsable = template.isBrowsable, field.isUserCustom = !1;
  }
  static applyBuiltInFieldSetDefaults(configuration, template) {
    configuration.items = this.populateDefaults(configuration.items ?? [], template.items ?? [], template.templates ?? [], template.fieldTypes ?? [], template.allowUserDefinedFields ?? !0);
  }
  static applyCustomDefaults(configuration, templates, customFieldTypes) {
    if (configuration.templateName) {
      const template = templates.find((x) => x.name.toLowerCase() == configuration.templateName.toLowerCase());
      if (template) {
        this.applyCustomDefaultsFromTemplate(configuration, template, customFieldTypes);
        return;
      }
    }
    switch (configuration.discriminator) {
      case "Field":
        {
          const fieldConfiguration = configuration;
          this.applyCustomFieldDefaults(fieldConfiguration, customFieldTypes);
        }
        break;
      case "FieldSet":
        {
          const fieldSetConfiguration = configuration;
          fieldSetConfiguration.items = this.populateDefaults(fieldSetConfiguration.items ?? [], [], [], customFieldTypes, !0), fieldSetConfiguration.isUserCustom = !0;
        }
        break;
      default:
        throw `Unexpected field type '${configuration.discriminator}'`;
    }
  }
  static applyCustomDefaultsFromTemplate(configuration, template, customFieldTypes) {
    switch (template.discriminator) {
      case "Field":
        {
          configuration.discriminator !== template.discriminator && (console.warn(`Converting custom '${configuration.name}' from ${configuration.discriminator} to template type ${template.discriminator}`), configuration.discriminator = template.discriminator);
          const fieldConfiguration = configuration, fieldTemplate = template;
          this.applyCustomFieldDefaults(fieldConfiguration, fieldTemplate.fieldTypes ?? customFieldTypes), fieldConfiguration.templateName = template.name;
        }
        break;
      case "FieldSet":
        {
          configuration.discriminator !== template.discriminator && (console.warn(`Converting custom '${configuration.name}' from ${configuration.discriminator} to template type ${template.discriminator}`), configuration.discriminator = template.discriminator);
          const fieldSetConfiguration = configuration, fieldSetTemplate = template;
          this.applyCustomFieldSetDefaultsFromTemplate(fieldSetConfiguration, fieldSetTemplate), fieldSetConfiguration.templateName = template.name;
        }
        break;
      default:
        throw `Unexpected field type '${configuration.discriminator}'`;
    }
  }
  static applyCustomFieldDefaults(field, customFieldTypes) {
    const defaultType = "String", fieldTypes = customFieldTypes ?? [defaultType];
    field.fieldTypes ?? (field.fieldTypes = fieldTypes), field.selectedType = this.selectFieldTypeOrDefault(field.fieldTypes, field.selectedType ?? defaultType, fieldTypes[0]), field.isUserCustom = !0;
  }
  static applyCustomFieldSetDefaultsFromTemplate(configuration, template) {
    configuration.items = this.populateDefaults(configuration.items ?? [], template.items ?? [], template.templates ?? [], template.fieldTypes ?? [], template.allowUserDefinedFields ?? !0);
  }
  static selectFieldTypeOrDefault(availableTypes, selectType, defaultType) {
    return selectType && availableTypes.findIndex((t) => t.toLowerCase() == selectType.toLowerCase()) > -1 ? selectType : defaultType;
  }
  // Returns true if the configuration item has the same values as the built-in definition's defaults
  static builtInFieldHasDefaults(configuration, builtInItems) {
    var _a2, _b, _c;
    const definition = builtInItems.find((x) => x.name.toLowerCase() == configuration.name.toLowerCase());
    if (!definition || configuration.discriminator !== definition.discriminator)
      return !1;
    switch (definition.discriminator) {
      case "Field":
        {
          const fieldConfiguration = configuration, fieldTemplate = definition;
          if (fieldTemplate.defaultToStaticValue) {
            if (fieldConfiguration.isIgnored)
              return !1;
            if (fieldConfiguration.value != fieldTemplate.staticValueDefault)
              return !1;
          } else if ((((_a2 = fieldConfiguration.value) == null ? void 0 : _a2.length) ?? 0) > 0)
            return !1;
          if (fieldConfiguration.selectedType == fieldTemplate.selectedType && fieldConfiguration.mandatory == this.getMandatoryDefault(fieldTemplate) && fieldConfiguration.maxLength == this.getMaxLengthDefault(fieldTemplate))
            return !0;
        }
        break;
      case "FieldSet":
        {
          const fieldSetConfiguration = configuration, fieldSetTemplate = definition;
          if (!fieldSetConfiguration.value && (((_b = fieldSetConfiguration.items) == null ? void 0 : _b.length) ?? 0) == (((_c = fieldSetTemplate.items) == null ? void 0 : _c.length) ?? 0) && (fieldSetConfiguration.items ?? []).every((x) => this.builtInFieldHasDefaults(x, builtInItems)))
            return !0;
        }
        break;
    }
    return !1;
  }
  static getMaxLengthDefault(template) {
    const userMaxLength = Math.max(0, template.userMaxLengthDefault ?? 0), systemMaxLength = Math.max(0, template.systemMaxLength ?? 0);
    return userMaxLength == 0 ? systemMaxLength : userMaxLength > 0 && systemMaxLength > 0 ? Math.min(userMaxLength, systemMaxLength) : userMaxLength;
  }
  static getMandatoryDefault(template) {
    return template.userMandatoryDefault || template.systemMandatory || !1;
  }
};
__name(_UploadFieldsDefaults, "UploadFieldsDefaults");
let UploadFieldsDefaults = _UploadFieldsDefaults;
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "uploadSettings",
  props: {
    value: null,
    freeform: { type: Boolean, default: !1 }
  },
  emits: ["input"],
  setup(__props, { emit }) {
    const props = __props;
    provide(serviceKey, createBrowseProviderFactory());
    const actions = ref$1([]), template = ref$1(null), integrationsLoading = ref$1(!1), integrationsError = ref$1(null), integrationsWarning = ref$1(null), actionsLoading = ref$1(!1), actionsError = ref$1(null), templateLoading = ref$1(!1);
    function updateModel(changes) {
      const payload = {
        ...props.value,
        ...changes
      };
      emit("input", payload);
    }
    __name(updateModel, "updateModel");
    function showLoginModal(integrationId) {
      $store.dispatch("app/integration/sessions/showLoginModal", integrationId);
    }
    __name(showLoginModal, "showLoginModal");
    function hideLoginModal() {
      $store.dispatch("app/integration/sessions/hideLoginModal");
    }
    __name(hideLoginModal, "hideLoginModal");
    function setModalName(modalName) {
      $store.dispatch("app/integration/sessions/changeIntegrationName", modalName);
    }
    __name(setModalName, "setModalName"), onMounted(() => {
      loadIntegrations();
    });
    const model = toRef(props, "value");
    function integrationChanged(integrationId) {
      return console.debug(`Upload integration changed from ${model.value.instanceId} to ${integrationId}`), updateModel({
        instanceId: integrationId
      }), loadActions(integrationId);
    }
    __name(integrationChanged, "integrationChanged");
    async function actionChanged(actionId) {
      console.debug(`Upload action changed from ${model.value.actionId} to ${actionId}`), updateModel({
        actionId
      }), await loadTemplate(model.value.instanceId, actionId);
    }
    __name(actionChanged, "actionChanged");
    async function loadTemplate(instanceId, actionId) {
      var _a2;
      templateLoading.value = !0;
      try {
        const previousTemplate = template.value;
        try {
          template.value = await new AdministrationIntegrationsFacadeClient(new Transformer(), baseUrl()).getUploadTemplate(instanceId, actionId);
        } catch (e) {
          console.error("Load upload template failed.", e), template.value = null;
          return;
        }
        const savedFields = ((_a2 = model.value.fields) == null ? void 0 : _a2.slice()) ?? [];
        let transformedFields;
        previousTemplate ? previousTemplate.typeId == template.value.typeId && previousTemplate.actionId == previousTemplate.actionId ? transformedFields = applyTemplateToSavedFields(savedFields, template.value) : transformedFields = applyNewTemplateToSavedFields(savedFields, previousTemplate, template.value) : transformedFields = applyTemplateToSavedFields(savedFields, template.value), updateModel({
          fields: transformedFields
        });
      } finally {
        templateLoading.value = !1;
      }
    }
    __name(loadTemplate, "loadTemplate");
    function applyTemplateToSavedFields(savedFields, template2) {
      const builtInItems = template2.fields ?? [], templates = template2.templates ?? [], customFieldTypes = template2.fieldTypes ?? [], allowArbitraryFieldNames = template2.allowUser ?? !1;
      return UploadFieldsDefaults.populateDefaults(savedFields, builtInItems, templates, customFieldTypes, allowArbitraryFieldNames);
    }
    __name(applyTemplateToSavedFields, "applyTemplateToSavedFields");
    function applyNewTemplateToSavedFields(savedFields, oldTemplate, newTemplate) {
      console.info(`Changing upload template '${oldTemplate.typeId}|${oldTemplate.actionId}' to '${newTemplate.typeId}|${newTemplate.actionId}'`);
      const retainedFields = [], oldBuiltInItems = oldTemplate.fields ?? [];
      savedFields.forEach((savedField) => {
        savedField.isUserCustom ? savedField.isIgnored || retainedFields.push(savedField) : UploadFieldsDefaults.builtInFieldHasDefaults(savedField, oldBuiltInItems) || retainedFields.push(savedField);
      });
      const builtInItems = newTemplate.fields ?? [], templates = newTemplate.templates ?? [], customFieldTypes = newTemplate.fieldTypes ?? [], allowArbitraryFieldNames = newTemplate.allowUser ?? !1;
      return UploadFieldsDefaults.populateDefaults(retainedFields, builtInItems, templates, customFieldTypes, allowArbitraryFieldNames);
    }
    __name(applyNewTemplateToSavedFields, "applyNewTemplateToSavedFields");
    async function checkSessionForCustomTemplate() {
      hideLoginModal();
    }
    __name(checkSessionForCustomTemplate, "checkSessionForCustomTemplate");
    function onFieldsChanged(config) {
      fields.value = config;
    }
    __name(onFieldsChanged, "onFieldsChanged");
    const integrationInstances = computed(() => $store.state.administration.integrations.instances ?? []);
    async function loadIntegrations() {
      var _a2;
      integrationsLoading.value = !0, integrationsError.value = null, integrationsWarning.value = null;
      try {
        if (await $store.dispatch("administration/integrations/getIntegrations").catch((e) => integrationsError.value = e).finally(() => integrationsLoading.value = !1), model.value.instanceId)
          return integrationChanged(model.value.instanceId);
        {
          const instanceId = ((_a2 = integrationInstances.value.find(() => !0)) == null ? void 0 : _a2.id) ?? "";
          return integrationChanged(instanceId);
        }
      } catch {
        integrationsWarning.value = "There are no integrations configured.";
      } finally {
        integrationsLoading.value = !1;
      }
    }
    __name(loadIntegrations, "loadIntegrations");
    async function loadActions(instanceId) {
      actionsLoading.value = !0;
      try {
        if (actions.value = await new AdministrationIntegrationsFacadeClient(new Transformer(), baseUrl()).getUploadActions(instanceId), props.value.actionId && actions.value.find((v) => v.id == props.value.actionId))
          return actionChanged(model.value.actionId);
        if (actions.value.length === 1) {
          const defaultAction = actions.value.find((v) => !0);
          return actionChanged((defaultAction == null ? void 0 : defaultAction.id) ?? "");
        }
      } finally {
        actionsLoading.value = !1;
      }
    }
    __name(loadActions, "loadActions");
    const actionsButton = computed(() => ({
      icon: "sync-alt",
      name: "",
      disabled: actionsLoading.value,
      spin: actionsLoading.value,
      class: {
        btn: !0,
        "btn-success": !actionsError.value,
        "btn-danger": actionsError.value
      }
    }));
    function createUrl(pageName) {
      return new URL(baseUrl + pageName);
    }
    __name(createUrl, "createUrl");
    const fields = computed({
      get() {
        return model.value.fields ?? [];
      },
      set(fields2) {
        updateModel({
          fields: fields2
        });
      }
    }), uploadSettings = computed({
      get() {
        return model.value.upload ?? [];
      },
      set(upload) {
        updateModel({
          upload
        });
      }
    });
    async function populateCustomFields(viewPath, currentView, completedCallback) {
      var _a2, _b;
      try {
        const request = {
          fields: fields.value,
          settings: uploadSettings.value,
          viewPath
        }, customFieldsResult = await new AdministrationIntegrationsFacadeClient(new Transformer(), baseUrl()).getUploadCustomTemplate(model.value.instanceId, request, model.value.actionId);
        if (customFieldsResult.statusCode == StatusCode.SUCCESS)
          (_a2 = customFieldsResult.uploadFields) == null || _a2.forEach((customFieldTemplate) => {
            if (!currentView.some((x) => x.name.toLowerCase() === customFieldTemplate.name.toLowerCase())) {
              const customField = UploadFieldFactory.createConfigurationFromTemplate(customFieldTemplate, !0);
              currentView.push(customField);
            }
          });
        else if (customFieldsResult.interactiveAuthorisationRequired || customFieldsResult.statusCode == StatusCode.UNAUTHORISED) {
          const integrationInstance = integrationInstances.value.find((y) => y.id == model.value.instanceId);
          setModalName(integrationInstance.name), showLoginModal(model.value.instanceId);
          return;
        } else {
          const message = ((_b = customFieldsResult.errors) == null ? void 0 : _b.join(`
`)) ?? "Auto populate custom upload fields failed with unknown error.";
          toastr.error(message, "Populate Custom Fields Error");
        }
      } catch (ex) {
        console.error(ex), toastr.error("Auto populate custom upload fields encountered an error", "Populate Custom Fields Error");
      } finally {
        completedCallback();
      }
    }
    __name(populateCustomFields, "populateCustomFields");
    function createBrowseProviderFactory() {
      return {
        create: createBrowseProvider
      };
    }
    __name(createBrowseProviderFactory, "createBrowseProviderFactory");
    function createBrowseProvider(targetField, viewPath) {
      return {
        getItems: /* @__PURE__ */ __name((pageDescriptor) => browseFieldValue(targetField, viewPath, pageDescriptor), "getItems")
      };
    }
    __name(createBrowseProvider, "createBrowseProvider");
    async function browseFieldValue(targetField, viewPath, pageDescriptor) {
      var _a2;
      try {
        const request = {
          fields: fields.value,
          settings: uploadSettings.value,
          viewPath,
          targetFieldName: targetField.name,
          pageDescriptor: pageDescriptor ?? void 0
        }, browseValueResult = await new AdministrationIntegrationsFacadeClient(new Transformer(), baseUrl()).browseUploadFieldValue(model.value.instanceId, request, model.value.actionId);
        if (browseValueResult.statusCode == StatusCode.SUCCESS)
          return new StaticValueBrowsePageResult(
            browseValueResult.items ?? [],
            browseValueResult.hasMorePages ?? !1,
            browseValueResult.totalPages ?? null,
            browseValueResult.currentPageDescriptor ?? null,
            browseValueResult.nextPageDescriptor ?? null
          );
        if (browseValueResult.interactiveAuthorisationRequired || browseValueResult.statusCode == StatusCode.UNAUTHORISED) {
          const integrationInstance = integrationInstances.value.find((y) => y.id == model.value.instanceId);
          setModalName(integrationInstance.name), showLoginModal(model.value.instanceId);
        } else {
          const message = ((_a2 = browseValueResult.errors) == null ? void 0 : _a2.join(`
`)) ?? "Browse field value failed with unknown error.";
          return toastr.error(message, "Browse Field Value Error"), new StaticValueBrowsePageError(
            browseValueResult.errors ?? []
          );
        }
      } catch (ex) {
        return console.error(ex), toastr.error("Browse field value encountered an error", "Browse Field Value Error"), new StaticValueBrowsePageError([`${ex}`]);
      }
    }
    return __name(browseFieldValue, "browseFieldValue"), { __sfc: !0, emit, props, actions, template, integrationsLoading, integrationsError, integrationsWarning, actionsLoading, actionsError, templateLoading, updateModel, showLoginModal, hideLoginModal, setModalName, model, integrationChanged, actionChanged, loadTemplate, applyTemplateToSavedFields, applyNewTemplateToSavedFields, checkSessionForCustomTemplate, onFieldsChanged, integrationInstances, loadIntegrations, loadActions, actionsButton, createUrl, fields, uploadSettings, populateCustomFields, createBrowseProviderFactory, createBrowseProvider, browseFieldValue, IntegrationSettingsCollection, ReactiveDropdown, IntegrationActionTypes, PlaceholderInformation, LoginBoxModal, IntegrationInstanceDropdown, UploadFieldsNavigator };
  }
});
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c, _setup = _vm._self._setupProxy;
  return _c("div", [_c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Integration")]), _vm._v(" "), _c("br"), _vm._v(" "), _c(_setup.IntegrationInstanceDropdown, { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], attrs: { value: _setup.model.instanceId, "action-filter": [_setup.IntegrationActionTypes.Upload], name: "integration" }, on: { input: _setup.integrationChanged } }), _vm._v(" "), _setup.integrationsError ? _vm._e() : _c("span", { staticClass: "help-text text-muted" }, [_c("p", [_vm._v("Integration that will be targeted for this upload")])])], 1), _vm._v(" "), _setup.integrationsError ? _c("div", { staticClass: "form-group" }, [_c("span", { staticClass: "alert alert-danger", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" Check your "), _c("a", { staticClass: "alert-link", attrs: { target: "_blank", href: _setup.createUrl("/Admin/Integrations") } }, [_c("font-awesome-icon", { attrs: { icon: "share-alt" } }), _vm._v(" Integration")], 1), _vm._v(` settings to ensure that the integrations endpoint is correct and running.
    `)], 1)]) : _vm._e(), _vm._v(" "), _setup.integrationsWarning ? _c("div", { staticClass: "form-group" }, [_c("span", { staticClass: "alert alert-warning", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" There are no integrations configured, you can add them in the "), _c("a", { staticClass: "alert-link", attrs: { target: "_blank", href: _setup.createUrl("/Admin/Integrations") } }, [_c("font-awesome-icon", { attrs: { icon: "share-alt" } }), _vm._v(" Integration")], 1), _vm._v(` settings menu.
    `)], 1)]) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Action")]), _vm._v(" "), _c("br"), _vm._v(" "), _setup.actions ? _c("div", [_c(_setup.ReactiveDropdown, { attrs: { title: "Select Action", value: _setup.model.actionId, button: _setup.actionsButton, options: _setup.actions, loading: _setup.actionsLoading }, on: { input: _setup.actionChanged, button: _setup.loadActions } }), _vm._v(" "), _c("p", { staticClass: "help-text" }, [_vm._v("Action to run for this upload")])], 1) : _c("div", { staticClass: "alert alert-warning" }, [_vm._v(`
      Please select an integration to load actions
    `)])]), _vm._v(" "), _setup.integrationsLoading || _setup.actionsLoading || _setup.templateLoading ? _c("div", [_c("div", { staticClass: "alert alert-info" }, [_vm._v("Loading configuration...")])]) : _setup.model && _setup.template ? _c("div", { staticClass: "card mb-3" }, [_vm._m(0), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("h5", [_vm._v("Upload Settings")]), _vm._v(" "), _c(_setup.IntegrationSettingsCollection, { attrs: { template: _setup.template.settings }, model: { value: _setup.uploadSettings, callback: /* @__PURE__ */ __name(function($$v) {
    _setup.uploadSettings = $$v;
  }, "callback"), expression: "uploadSettings" } }), _vm._v(" "), _c("hr"), _vm._v(" "), _c("h5", [_vm._v("Upload Fields")]), _vm._v(" "), _c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
        You can use
        `), _c(_setup.PlaceholderInformation), _vm._v(`
        here to enhance the integrations functionality.
      `)], 1), _vm._v(" "), _c(_setup.UploadFieldsNavigator, { attrs: { items: _setup.fields, template: _setup.template }, on: { "update:items": _setup.onFieldsChanged, populateCustomFields: _setup.populateCustomFields } })], 1)]) : _vm._e(), _vm._v(" "), _c(_setup.LoginBoxModal, { on: { completed: _setup.checkSessionForCustomTemplate } })], 1);
}, "render"), _sfc_staticRenderFns$1 = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "card-header" }, [_c("h4", [_vm._v("Settings")])]);
}], __component__$1 = /* @__PURE__ */ normalizeComponent(
  _sfc_main,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "355a40c8"
);
const UploadConfigurationComponent = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let MetadataFileConfigurationComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
    __publicField(this, "showIncludeMetadata");
    __publicField(this, "showFileName");
    __publicField(this, "showTypeSelector");
    __publicField(this, "showLabel");
    __publicField(this, "selectedRowIndexes", []);
    __publicField(this, "rowTypeOptions", [
      { text: "--Select--", value: null },
      { text: "Header", value: "header" },
      { text: "Data", value: "data" },
      { text: "Grid", value: "grid" }
    ]);
  }
  get metadataFileName() {
    return this.model.metadataFileName;
  }
  set metadataFileName(metadataFileName) {
    this.model = { ...this.model, metadataFileName };
  }
  get includeMetadata() {
    return this.model.includeMetadata;
  }
  set includeMetadata(includeMetadata) {
    this.model = { ...this.model, includeMetadata };
  }
  get metadataFileType() {
    return this.model.metadataExportType;
  }
  set metadataFileType(metadataExportType) {
    this.model = { ...this.model, metadataExportType };
  }
  get csvMetadataTableRows() {
    return this.model.csvMetadataTableRows;
  }
  set csvMetadataTableRows(value) {
    this.model = { ...this.model, csvMetadataTableRows: value };
  }
  addRow(addColumns) {
    let cells = [];
    if (addColumns)
      for (let i = 0; i < this.highestRowCount; i++)
        cells.push("");
    let row = { rowType: null, cell: cells }, rows = this.csvMetadataTableRows.slice();
    rows.push(row), this.csvMetadataTableRows = rows;
  }
  deleteRows() {
    let rowIndexToDelete = this.selectedRowIndexes, rows = this.csvMetadataTableRows.slice();
    for (let i = rowIndexToDelete.length - 1; i >= 0; i--)
      rows.splice(rowIndexToDelete[i], 1);
    this.selectedRowIndexes = [], this.csvMetadataTableRows = rows;
  }
  addColumn() {
    let rows = this.csvMetadataTableRows.slice();
    this.selectedRowIndexes.length > 0 ? rows.forEach((row, index) => {
      this.selectedRowIndexes.filter((i) => i === index).length && row.cell.push("");
    }) : rows.forEach((row) => {
      row.cell.push("");
    }), this.csvMetadataTableRows = rows;
  }
  get highestRowCount() {
    let highest = Math.max.apply(Math, this.csvMetadataTableRows.map(function(el) {
      return el.cell.length;
    }));
    return highest < 0 ? 0 : highest;
  }
  deleteCell(rowIndex, index) {
    let rows = this.csvMetadataTableRows.slice(), row = rows[rowIndex], cells = row.cell;
    cells.splice(index, 1), row.cell = cells, this.csvMetadataTableRows = rows;
  }
  addCell(index, row) {
    let rows = this.csvMetadataTableRows.slice();
    rows[index].cell.push(""), this.csvMetadataTableRows = rows;
  }
  selectAllRow() {
    this.selectedRowIndexes.length != this.csvMetadataTableRows.length ? (this.selectedRowIndexes = [], this.csvMetadataTableRows.forEach((row, index) => {
      this.selectedRowIndexes.push(index);
    })) : this.selectedRowIndexes = [];
  }
  selectRowIndex(index) {
    if (!this.selectedRowIndexes.filter((i) => i === index).length)
      this.selectedRowIndexes.push(index);
    else {
      let spliceIndex = this.selectedRowIndexes.indexOf(index);
      this.selectedRowIndexes.splice(spliceIndex, 1);
    }
  }
  updateCell() {
    let rows = this.csvMetadataTableRows.slice();
    this.csvMetadataTableRows = rows;
  }
}, __name(_a, "MetadataFileConfigurationComponent"), _a);
__decorateClass([
  VModel({ required: !0 })
], MetadataFileConfigurationComponent.prototype, "model", 2);
__decorateClass([
  Prop({ required: !1, default: !1 })
], MetadataFileConfigurationComponent.prototype, "showIncludeMetadata", 2);
__decorateClass([
  Prop({ required: !1, default: !1 })
], MetadataFileConfigurationComponent.prototype, "showFileName", 2);
__decorateClass([
  Prop({ required: !1, default: !0 })
], MetadataFileConfigurationComponent.prototype, "showTypeSelector", 2);
__decorateClass([
  Prop({ required: !1, default: !0 })
], MetadataFileConfigurationComponent.prototype, "showLabel", 2);
MetadataFileConfigurationComponent = __decorateClass([
  Component({
    components: { PlaceholderInformation, draggable }
  })
], MetadataFileConfigurationComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "mb-2" }, [_vm.showIncludeMetadata ? _c("b-form-group", { attrs: { id: "includeMetadata", description: "Include Metadata file in the output", "label-for": "includeMetadataInput" } }, [_c("b-form-checkbox", { attrs: { id: "includeMetadataInput", switch: "" }, model: { value: _vm.includeMetadata, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.includeMetadata = $$v;
  }, "callback"), expression: "includeMetadata" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Output Metadata")])])], 1) : _vm._e(), _vm._v(" "), _vm.showFileName && (!_vm.showIncludeMetadata || _vm.showIncludeMetadata && _vm.includeMetadata) ? _c("b-form-group", { attrs: { id: "metadataFileName", label: "Metadata File Name", "label-for": "metadataFileNameInput" } }, [_c("b-form-input", { attrs: { id: "metadataFileNameInput", type: "text" }, model: { value: _vm.metadataFileName, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.metadataFileName = $$v;
  }, "callback"), expression: "metadataFileName" } }), _vm._v(" "), _c("small", { staticClass: "form-text text-muted" }, [_vm._v("Customise output filename. If left blank, original name is used. The file extension will always be applied to the end of the filename. This field supports placeholders")])], 1) : _vm._e(), _vm._v(" "), !_vm.showIncludeMetadata || _vm.showIncludeMetadata && _vm.includeMetadata ? _c("b-form-group", { attrs: { label: _vm.showLabel ? "Metadata Output" : "", "label-class": "font-weight-bold" } }, [_vm.showTypeSelector ? _c("b-input-group", { staticClass: "csv-table-cell", attrs: { size: "sm" }, scopedSlots: _vm._u([_vm.metadataFileType === "csv" ? { key: "append", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-button", { directives: [{ name: "b-modal", rawName: "v-b-modal.modal-1", modifiers: { "modal-1": !0 } }], attrs: { variant: "primary" } }, [_vm._v("Configure CSV file")])];
  }, "fn"), proxy: !0 } : null], null, !0) }, [_c("b-form-select", { attrs: { options: ["xml", "csv"] }, on: { change: /* @__PURE__ */ __name(function($event) {
  }, "change") }, model: { value: _vm.metadataFileType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.metadataFileType = $$v;
  }, "callback"), expression: "metadataFileType" } })], 1) : _c("b-input-group", { staticClass: "csv-table-cell", attrs: { size: "sm" } }, [_c("b-button", { directives: [{ name: "b-modal", rawName: "v-b-modal.modal-1", modifiers: { "modal-1": !0 } }], attrs: { variant: "primary" } }, [_vm._v("Configure CSV file")])], 1)], 1) : _vm._e(), _vm._v(" "), _c("b-modal", { attrs: { id: "modal-1", size: "xl", title: "CSV Output Configuration" }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok }) {
    return [_c("b-button", { attrs: { variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return ok();
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(`
        Apply
      `)], 1)];
  }, "fn") }]) }, [_c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
      You can set up the template for the CSV output with the use of  `), _c("placeholder-information"), _vm._v(` and static values.
    `)], 1), _vm._v(" "), _c("b-table-simple", { staticClass: "csv-table-height", attrs: { responsive: "", small: "", borderless: "" } }, [_c("b-thead", [_c("b-tr", [_c("b-th", { attrs: { colspan: _vm.highestRowCount + 3 } }, [_c("b-form-checkbox", { staticClass: "align-middle mr-0", attrs: { inline: "" }, on: { change: /* @__PURE__ */ __name(function($event) {
    return _vm.selectAllRow();
  }, "change") }, model: { value: _vm.csvMetadataTableRows.length !== 0 && _vm.selectedRowIndexes.length === _vm.csvMetadataTableRows.length, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.csvMetadataTableRows.length !== 0 && _vm.selectedRowIndexes.length === _vm.csvMetadataTableRows, "length", $$v);
  }, "callback"), expression: "csvMetadataTableRows.length !== 0 && selectedRowIndexes.length === csvMetadataTableRows.length" } }), _vm._v(`
            Type
            `), _c("b-dropdown", { attrs: { "no-flip": "", id: "addRowDropdown", variant: "outline-primary", size: "sm" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(`
                Add Row
              `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.addRow(!0);
  }, "click") } }, [_c("span", { staticClass: "text-primary" }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(`
                  Add Row
                `)], 1)]), _vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.addRow(!1);
  }, "click") } }, [_c("span", { staticClass: "text-primary" }, [_c("font-awesome-icon", { staticClass: "text-primary", attrs: { icon: "plus" } }), _vm._v(`
                  Add Row without cells
                `)], 1)])], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "outline-primary", size: "sm", title: "If rows are select they will be added just to the selected rows, if not it will add a column to all rows" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.addColumn();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(`
              Add Columns
            `)], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-danger", size: "sm", disabled: !_vm.selectedRowIndexes.length }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.deleteRows();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(`
              Delete Selected Rows
            `)], 1)], 1)], 1)], 1), _vm._v(" "), _c("draggable", { attrs: { handle: ".field-handle", tag: "tbody" }, model: { value: _vm.csvMetadataTableRows, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.csvMetadataTableRows = $$v;
  }, "callback"), expression: "csvMetadataTableRows" } }, _vm._l(_vm.csvMetadataTableRows, function(row, index) {
    return _vm.csvMetadataTableRows.length ? _c("b-tr", [_c("b-td", { staticClass: "align-middle csv-table-actions pt-0" }, [_c("b-button-group", [_c("b-form-checkbox", { on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.selectRowIndex(index);
    }, "change") }, model: { value: _vm.selectedRowIndexes.filter((i) => i === index).length > 0, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(_vm.selectedRowIndexes.filter((i) => i === index), "length > 0", $$v);
    }, "callback"), expression: "selectedRowIndexes.filter(i => i === index).length > 0" } })], 1), _vm._v(" "), _c("span", { staticClass: "field-handle mr-1" }, [_c("font-awesome-icon", { attrs: { icon: "grip-vertical" } })], 1)], 1), _vm._v(" "), _c("b-td", { staticClass: "pr-0 csv-table-select-td pt-0" }, [_c("b-form-select", { staticClass: "csv-table-select", attrs: { size: "sm", options: _vm.rowTypeOptions }, model: { value: row.rowType, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(row, "rowType", $$v);
    }, "callback"), expression: "row.rowType" } }), _vm._v(" "), row.rowType === "grid" ? _c("b-input", { attrs: { size: "sm", placeholder: "Grid Field Id" }, model: { value: row.gridFieldId, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(row, "gridFieldId", $$v);
    }, "callback"), expression: "row.gridFieldId" } }) : _vm._e()], 1), _vm._v(" "), _vm._l(row.cell, function(cell, cellIndex) {
      return _c("b-td", { key: cellIndex, staticClass: "px-0 pt-0" }, [_c("b-input-group", { staticClass: "csv-table-cell", attrs: { size: "sm" }, scopedSlots: _vm._u([{ key: "prepend", fn: /* @__PURE__ */ __name(function() {
        return [_c("b-input-group-text", { staticClass: "px-1", staticStyle: { "border-radius": "0" } }, [_vm._v(_vm._s(cellIndex))])];
      }, "fn"), proxy: !0 }, { key: "append", fn: /* @__PURE__ */ __name(function() {
        return [_c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle clearValueButtonNormalRightAlignment", attrs: { title: "Delete this cell from the row" }, on: { click: /* @__PURE__ */ __name(function($event) {
          return _vm.deleteCell(index, cellIndex);
        }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)];
      }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-input", { staticStyle: { "border-radius": "0" }, attrs: { size: "sm" }, on: { input: _vm.updateCell }, model: { value: row.cell[cellIndex], callback: /* @__PURE__ */ __name(function($$v) {
        _vm.$set(row.cell, cellIndex, $$v);
      }, "callback"), expression: "row.cell[cellIndex]" } })], 1)], 1);
    }), _vm._v(" "), _c("b-td", { staticClass: "px-0 pt-0" }, [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "csv-table-add-cell", attrs: { variant: "outline-primary", size: "sm", title: "Add a column to this row" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.addCell(index, row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } })], 1)], 1)], 2) : _vm._e();
  }), 1), _vm._v(" "), _vm.csvMetadataTableRows.length === 0 ? _c("b-tr", [_c("b-td", { staticClass: "font-italic", attrs: { colspan: "4" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
          No rows configured
        `)], 1)], 1) : _vm._e()], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  MetadataFileConfigurationComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "92ab058a"
);
const MetadataFileConfiguration = __component__.exports;
export {
  MetadataFileConfiguration as M,
  UploadConfigurationComponent as U
};
