var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, W as Watch, C as Component, V as Vue, n as normalizeComponent, j as getQueueName, ck as getQueueTypeIcon, t as toastr, b as baseUrl, v as vSelect, s as SortableHeader, L as LoadingBarComponent, E as ErrorPanel } from "./main-DAVWuHbi.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a;
let ModalComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "closable");
    __publicField(this, "static");
    __publicField(this, "title");
    __publicField(this, "value");
  }
  mounted() {
    let el = $(this.$el);
    el.modal({
      backdrop: this.static ? "static" : !0,
      keyboard: this.static,
      show: !1
    }), el.on("shown.bs.modal", () => this.$emit("shown")), el.on("hidden.bs.modal", () => this.$emit("closed"));
  }
  watchShow(newVal) {
    newVal ? $(this.$el).modal("show") : $(this.$el).modal("hide");
  }
  close() {
    this.closable && this.$emit("close");
  }
}, __name(_a, "ModalComponent"), _a);
__decorateClass$1([
  Prop({
    type: Boolean,
    required: !1,
    default: /* @__PURE__ */ __name(() => !0, "default")
  })
], ModalComponent.prototype, "closable", 2);
__decorateClass$1([
  Prop({
    type: Boolean,
    required: !1,
    default: /* @__PURE__ */ __name(() => !0, "default")
  })
], ModalComponent.prototype, "static", 2);
__decorateClass$1([
  Prop({
    type: String,
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], ModalComponent.prototype, "title", 2);
__decorateClass$1([
  Prop({
    required: !0
  })
], ModalComponent.prototype, "value", 2);
__decorateClass$1([
  Watch("value")
], ModalComponent.prototype, "watchShow", 1);
ModalComponent = __decorateClass$1([
  Component
], ModalComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal fade", attrs: { tabindex: "-1", role: "dialog" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_vm.closable || _vm.title ? _c("div", { staticClass: "modal-header" }, [_vm.title ? _c("h4", { staticClass: "modal-title" }, [_vm._v(_vm._s(_vm.title))]) : _vm._e(), _vm._v(" "), _vm.closable ? _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" }, on: { click: _vm.close } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]) : _vm._e()]) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_vm._t("default")], 2), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_vm._t("footer")], 2)])])]);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  ModalComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "beee890b"
);
const Modal = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a2;
let ManagementRouteComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "closing", !1);
    __publicField(this, "suspending", []);
    __publicField(this, "resuming", []);
    __publicField(this, "reopening", []);
    __publicField(this, "queueToClose", null);
    __publicField(this, "sort", null);
  }
  mounted() {
    var _a3, _b;
    (_b = (_a3 = this.page) == null ? void 0 : _a3.permissions) != null && _b.manage && this.$store.dispatch("pages/indexing/management/actions/load");
  }
  get page() {
    return this.$store.getters["pages/indexing/getters/page"];
  }
  get filterText() {
    return this.$store.getters["pages/indexing/management/getters/filter"].name;
  }
  set filterText(value) {
    this.$store.dispatch("pages/indexing/management/actions/updateNameFilter", value);
  }
  get queues() {
    return this.$store.getters["pages/indexing/management/getters/queues"];
  }
  get pageNumber() {
    return this.$store.getters["pages/indexing/management/getters/pageNumber"];
  }
  set pageNumber(value) {
    this.$store.dispatch("pages/indexing/management/actions/changePage", value);
  }
  get statusFilter() {
    return this.$store.getters["pages/indexing/management/getters/statusFilter"];
  }
  set statusFilter(value) {
    this.$store.dispatch("pages/indexing/management/actions/updateStatusFilter", value);
  }
  get totalPages() {
    return this.$store.getters["pages/indexing/management/getters/totalPages"];
  }
  get loading() {
    return this.$store.getters["pages/indexing/management/getters/loading"];
  }
  get loadingError() {
    return this.$store.getters["pages/indexing/management/getters/loadingError"];
  }
  get statusOptions() {
    let options = ["Open", "Closed", "Suspended"];
    return options = options.filter((o) => !this.statusFilter.includes(o)), options;
  }
  watchSort(oldVal, newVal) {
    this.$emit("sort", oldVal);
  }
  get sorted() {
    if (this.sort) {
      let sorted = this.queues.sort((a, b) => {
        switch (this.sort.by) {
          case "name":
            return this.queueName(a).toLowerCase() > this.queueName(b).toLowerCase() ? -1 : 1;
        }
        switch (this.sort.by) {
          case "status":
            return a.status.toLowerCase() > b.status.toLowerCase() ? -1 : 1;
        }
        switch (this.sort.by) {
          case "items":
            return a.count > b.count ? -1 : 1;
        }
        return 0;
      });
      return this.sort.descending ? sorted.reverse() : sorted;
    } else
      return this.queues;
  }
  queueName(queue) {
    return getQueueName(queue);
  }
  getTypeIcon(queueType) {
    return getQueueTypeIcon(queueType);
  }
  isSuspending(queueId) {
    return this.suspending.includes(queueId);
  }
  async suspendQueue(queueId) {
    this.suspending.push(queueId);
    try {
      await this.$store.dispatch("pages/indexing/management/actions/suspendQueue", queueId);
    } catch (e) {
      toastr.error(e, "Failed to suspend queue");
    } finally {
      this.suspending.splice(this.suspending.indexOf(queueId), 1);
    }
  }
  isResuming(queueId) {
    return this.resuming.includes(queueId);
  }
  async resumeQueue(queueId) {
    this.resuming.push(queueId);
    try {
      await this.$store.dispatch("pages/indexing/management/actions/resumeQueue", queueId);
    } catch (e) {
      toastr.error(e, "Failed to resume queue");
    } finally {
      this.resuming.splice(this.resuming.indexOf(queueId), 1);
    }
  }
  isReopening(queueId) {
    return this.reopening.includes(queueId);
  }
  async reopenQueue(queueId) {
    this.reopening.push(queueId);
    try {
      await this.$store.dispatch("pages/indexing/management/actions/reopenQueue", queueId);
    } catch (e) {
      toastr.error(e, "Failed to reopen queue");
    } finally {
      this.reopening.splice(this.reopening.indexOf(queueId), 1);
    }
  }
  async closeQueue(queueId) {
    this.queueToClose = queueId;
  }
  async confirmClose() {
    this.closing = !0;
    try {
      await this.$store.dispatch("pages/indexing/management/actions/closeQueue", this.queueToClose), this.queueToClose = null;
    } catch (e) {
      toastr.error(e, "Failed to close queue");
    } finally {
      this.closing = !1;
    }
  }
  goToQueue(queue) {
    return new URL(baseUrl() + "/app/indexing/queues/" + queue.id + "/list").href;
  }
}, __name(_a2, "ManagementRouteComponent"), _a2);
__decorateClass([
  Watch("sort")
], ManagementRouteComponent.prototype, "watchSort", 1);
ManagementRouteComponent = __decorateClass([
  Component({
    components: { PaginationControls, Modal, ErrorPanel, LoadingBar: LoadingBarComponent, SortableHeader, vSelect }
  })
], ManagementRouteComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h2", [_vm._v(_vm._s(_vm.page.name)), _c("small", [_vm._v(" - Manage")])]), _vm._v(" "), _vm.page.permissions.manage ? _c("div", [_c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header" }, [_c("div", { staticClass: "input-group" }, [_c("div", { staticClass: "input-group-prepend" }, [_c("div", { staticClass: "input-group-text", attrs: { id: "btnGroupAddon" } }, [_c("font-awesome-icon", { attrs: { icon: "filter", placeholder: "Filter list" } })], 1)]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.filterText, expression: "filterText" }], staticClass: "form-control", staticStyle: { "max-width": "75%" }, attrs: { placeholder: "Filter name..." }, domProps: { value: _vm.filterText }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.filterText = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("div", { staticClass: "list-selector" }, [_c("v-select", { staticStyle: { "min-width": "25%" }, attrs: { multiple: "", options: _vm.statusOptions, "close-on-select": !1, placeholder: "Select status..." }, model: { value: _vm.statusFilter, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.statusFilter = $$v;
  }, "callback"), expression: "statusFilter" } })], 1)]), _vm._v(" "), _c("transition", { attrs: { name: "fade" } }, [_vm.loading ? _c("div", { staticClass: "input-group" }, [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } })], 1) : _vm._e()]), _vm._v(" "), _c("span", { staticClass: "clearfix" })], 1), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_vm.loading ? [_c("loading-bar", [_vm._v("Loading queues")])] : _vm.loadingError ? [_c("error-panel", { attrs: { error: _vm.loadingError } })] : [_vm.queues && _vm.queues.length ? _c("div", { staticClass: "table-responsive" }, [_c("table", { staticClass: "table table-hover" }, [_c("thead", [_c("tr", [_c("sortable-header", { attrs: { id: "name" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v("Name")]), _vm._v(" "), _c("sortable-header", { attrs: { id: "status" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v("Status")]), _vm._v(" "), _c("sortable-header", { attrs: { id: "items" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v("Items")]), _vm._v(" "), _c("th", [_vm._v(" ")])], 1)]), _vm._v(" "), _c("tbody", _vm._l(_vm.sorted, function(queue) {
    return _c("tr", { key: queue.id }, [_c("td", [_c("font-awesome-icon", { attrs: { icon: _vm.getTypeIcon(queue.type.type) } }), _vm._v(` 
                  `), _c("a", { attrs: { href: _vm.goToQueue(queue) }, domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(_vm.queueName(queue), _vm.filterText)) } })], 1), _vm._v(" "), _c("td", [queue.status === "open" ? _c("div", { staticClass: "badge badge-success" }, [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(" Open")], 1) : _vm._e(), _vm._v(" "), queue.status === "suspended" ? _c("div", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "badge badge-warning", attrs: { title: "A suspended queue cannot have any items added into it, but can still be accessed by users" } }, [_c("font-awesome-icon", { attrs: { icon: "lock" } }), _vm._v(` Suspended
                  `)], 1) : _vm._e(), _vm._v(" "), queue.status === "closed" ? _c("div", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "badge badge-danger", attrs: { title: "A closed queue cannot have items added into it or be accessed by users" } }, [_c("font-awesome-icon", { attrs: { icon: "times-circle" } }), _vm._v(` Closed
                  `)], 1) : _vm._e()]), _vm._v(" "), _c("td", [_vm._v(`
                  ` + _vm._s(queue.count) + `
                `)]), _vm._v(" "), _c("td", [_c("div", { staticClass: "float-right" }, [queue.status !== "closed" ? [queue.status === "suspended" ? _c("button", { staticClass: "btn btn-outline-primary btn-sm", class: { disabled: _vm.isResuming(queue.id) }, attrs: { disabled: _vm.isResuming(queue.id) }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.resumeQueue(queue.id);
    }, "click") } }, [_vm.isResuming(queue.id) ? _c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }) : _c("font-awesome-icon", { attrs: { icon: "lock-open" } }), _vm._v(`
                         Resume
                      `)], 1) : _c("button", { staticClass: "btn btn-default btn-sm", class: { disabled: _vm.isSuspending(queue.id) }, attrs: { disabled: _vm.isSuspending(queue.id) }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.suspendQueue(queue.id);
    }, "click") } }, [_vm.isSuspending(queue.id) ? _c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }) : _c("font-awesome-icon", { attrs: { icon: "lock" } }), _vm._v(`
                         Suspend
                      `)], 1), _vm._v(" "), _c("span", { staticClass: "d-inline-block", attrs: { id: "closeQueueButton" + queue.id, tabindex: "0" } }, [_c("button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover.top", modifiers: { hover: !0, top: !0 } }], staticClass: "btn btn-outline-danger btn-sm", attrs: { disabled: queue.count !== 0 }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.closeQueue(queue.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(`
                           Close
                        `)], 1), _vm._v(" "), queue.count !== 0 ? _c("b-tooltip", { attrs: { target: "closeQueueButton" + queue.id, variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` You cannot close a queue that still has items in it
                        `)], 1) : _vm._e()], 1)] : _vm._e(), _vm._v(" "), queue.status === "closed" ? [queue.status === "closed" ? _c("button", { staticClass: "btn btn-outline-primary btn-sm", class: { disabled: _vm.isReopening(queue.id) }, attrs: { disabled: _vm.isReopening(queue.id) }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.reopenQueue(queue.id);
    }, "click") } }, [_vm.isReopening(queue.id) ? _c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }) : _c("font-awesome-icon", { attrs: { icon: "recycle" } }), _vm._v(`
                         Reopen
                      `)], 1) : _vm._e()] : _vm._e()], 2)])]);
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "text-center" }, [_vm.totalPages > 1 ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } }) : _vm._e()], 1)]) : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
            No queues
          `)])]], 2)]), _vm._v(" "), _c("modal", { attrs: { title: "Close Queue" }, on: { closed: /* @__PURE__ */ __name(function($event) {
    _vm.queueToClose = null;
  }, "closed") }, scopedSlots: _vm._u([{ key: "footer", fn: /* @__PURE__ */ __name(function() {
    return [_c("button", { staticClass: "btn btn-danger", attrs: { disabled: _vm.closing }, on: { click: /* @__PURE__ */ __name(function($event) {
      return $event.preventDefault(), _vm.confirmClose.apply(null, arguments);
    }, "click") } }, [_vm.closing ? _c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }) : _vm._e(), _vm._v(`
          Close Queue
        `)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default", on: { click: /* @__PURE__ */ __name(function($event) {
      $event.preventDefault(), _vm.queueToClose = null;
    }, "click") } }, [_vm._v("Cancel")])];
  }, "fn"), proxy: !0 }], null, !1, 1150414165), model: { value: _vm.queueToClose, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.queueToClose = $$v;
  }, "callback"), expression: "queueToClose" } }, [_c("div", [_vm._v(`
        Closing a queue prevents it from being used, and removes it from viewing.
        Are you sure you wish to proceed?
      `)])])], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  ManagementRouteComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "aba9563f"
);
const management = __component__.exports;
export {
  management as default
};
