var __defProp = Object.defineProperty;
var __defNormalProp = (obj2, key, value3) => key in obj2 ? __defProp(obj2, key, { enumerable: !0, configurable: !0, writable: !0, value: value3 }) : obj2[key] = value3;
var __name = (target2, value3) => __defProp(target2, "name", { value: value3, configurable: !0 });
var __publicField = (obj2, key, value3) => __defNormalProp(obj2, typeof key != "symbol" ? key + "" : key, value3);
import { l as library$1, i as icons$4, F as FontAwesomeIcon, a as FontAwesomeLayers } from "./fortawesome-CAVs-14_.js";
import { i as icons } from "./fortawesome-pro-solid-BsiY0_wv.js";
import { i as icons$1 } from "./fortawesome-pro-regular-C-z9BlP-.js";
import { i as icons$2 } from "./fortawesome-pro-duotone-CI88-bkT.js";
import { i as icons$3 } from "./fortawesome-pro-light-HTWX_xwR.js";
(/* @__PURE__ */ __name(function() {
  const relList = document.createElement("link").relList;
  if (relList && relList.supports && relList.supports("modulepreload"))
    return;
  for (const link of document.querySelectorAll('link[rel="modulepreload"]'))
    processPreload(link);
  new MutationObserver((mutations2) => {
    for (const mutation of mutations2)
      if (mutation.type === "childList")
        for (const node of mutation.addedNodes)
          node.tagName === "LINK" && node.rel === "modulepreload" && processPreload(node);
  }).observe(document, { childList: !0, subtree: !0 });
  function getFetchOpts(link) {
    const fetchOpts = {};
    return link.integrity && (fetchOpts.integrity = link.integrity), link.referrerPolicy && (fetchOpts.referrerPolicy = link.referrerPolicy), link.crossOrigin === "use-credentials" ? fetchOpts.credentials = "include" : link.crossOrigin === "anonymous" ? fetchOpts.credentials = "omit" : fetchOpts.credentials = "same-origin", fetchOpts;
  }
  __name(getFetchOpts, "getFetchOpts");
  function processPreload(link) {
    if (link.ep)
      return;
    link.ep = !0;
    const fetchOpts = getFetchOpts(link);
    fetch(link.href, fetchOpts);
  }
  __name(processPreload, "processPreload");
}, "polyfill"))();
(function() {
  if (typeof window != "object")
    return;
  if ("IntersectionObserver" in window && "IntersectionObserverEntry" in window && "intersectionRatio" in window.IntersectionObserverEntry.prototype) {
    "isIntersecting" in window.IntersectionObserverEntry.prototype || Object.defineProperty(
      window.IntersectionObserverEntry.prototype,
      "isIntersecting",
      {
        get: /* @__PURE__ */ __name(function() {
          return this.intersectionRatio > 0;
        }, "get")
      }
    );
    return;
  }
  function getFrameElement(doc) {
    try {
      return doc.defaultView && doc.defaultView.frameElement || null;
    } catch {
      return null;
    }
  }
  __name(getFrameElement, "getFrameElement");
  var document2 = function(startDoc) {
    for (var doc = startDoc, frame = getFrameElement(doc); frame; )
      doc = frame.ownerDocument, frame = getFrameElement(doc);
    return doc;
  }(window.document), registry2 = [], crossOriginUpdater = null, crossOriginRect = null;
  function IntersectionObserverEntry(entry) {
    this.time = entry.time, this.target = entry.target, this.rootBounds = ensureDOMRect(entry.rootBounds), this.boundingClientRect = ensureDOMRect(entry.boundingClientRect), this.intersectionRect = ensureDOMRect(entry.intersectionRect || getEmptyRect()), this.isIntersecting = !!entry.intersectionRect;
    var targetRect = this.boundingClientRect, targetArea = targetRect.width * targetRect.height, intersectionRect = this.intersectionRect, intersectionArea = intersectionRect.width * intersectionRect.height;
    targetArea ? this.intersectionRatio = Number((intersectionArea / targetArea).toFixed(4)) : this.intersectionRatio = this.isIntersecting ? 1 : 0;
  }
  __name(IntersectionObserverEntry, "IntersectionObserverEntry");
  function IntersectionObserver2(callback, opt_options) {
    var options2 = opt_options || {};
    if (typeof callback != "function")
      throw new Error("callback must be a function");
    if (options2.root && options2.root.nodeType != 1 && options2.root.nodeType != 9)
      throw new Error("root must be a Document or Element");
    this._checkForIntersections = throttle2(
      this._checkForIntersections.bind(this),
      this.THROTTLE_TIMEOUT
    ), this._callback = callback, this._observationTargets = [], this._queuedEntries = [], this._rootMarginValues = this._parseRootMargin(options2.rootMargin), this.thresholds = this._initThresholds(options2.threshold), this.root = options2.root || null, this.rootMargin = this._rootMarginValues.map(function(margin) {
      return margin.value + margin.unit;
    }).join(" "), this._monitoringDocuments = [], this._monitoringUnsubscribes = [];
  }
  __name(IntersectionObserver2, "IntersectionObserver"), IntersectionObserver2.prototype.THROTTLE_TIMEOUT = 100, IntersectionObserver2.prototype.POLL_INTERVAL = null, IntersectionObserver2.prototype.USE_MUTATION_OBSERVER = !0, IntersectionObserver2._setupCrossOriginUpdater = function() {
    return crossOriginUpdater || (crossOriginUpdater = /* @__PURE__ */ __name(function(boundingClientRect, intersectionRect) {
      !boundingClientRect || !intersectionRect ? crossOriginRect = getEmptyRect() : crossOriginRect = convertFromParentRect(boundingClientRect, intersectionRect), registry2.forEach(function(observer) {
        observer._checkForIntersections();
      });
    }, "crossOriginUpdater")), crossOriginUpdater;
  }, IntersectionObserver2._resetCrossOriginUpdater = function() {
    crossOriginUpdater = null, crossOriginRect = null;
  }, IntersectionObserver2.prototype.observe = function(target2) {
    var isTargetAlreadyObserved = this._observationTargets.some(function(item) {
      return item.element == target2;
    });
    if (!isTargetAlreadyObserved) {
      if (!(target2 && target2.nodeType == 1))
        throw new Error("target must be an Element");
      this._registerInstance(), this._observationTargets.push({ element: target2, entry: null }), this._monitorIntersections(target2.ownerDocument), this._checkForIntersections();
    }
  }, IntersectionObserver2.prototype.unobserve = function(target2) {
    this._observationTargets = this._observationTargets.filter(function(item) {
      return item.element != target2;
    }), this._unmonitorIntersections(target2.ownerDocument), this._observationTargets.length == 0 && this._unregisterInstance();
  }, IntersectionObserver2.prototype.disconnect = function() {
    this._observationTargets = [], this._unmonitorAllIntersections(), this._unregisterInstance();
  }, IntersectionObserver2.prototype.takeRecords = function() {
    var records = this._queuedEntries.slice();
    return this._queuedEntries = [], records;
  }, IntersectionObserver2.prototype._initThresholds = function(opt_threshold) {
    var threshold = opt_threshold || [0];
    return Array.isArray(threshold) || (threshold = [threshold]), threshold.sort().filter(function(t2, i, a2) {
      if (typeof t2 != "number" || isNaN(t2) || t2 < 0 || t2 > 1)
        throw new Error("threshold must be a number between 0 and 1 inclusively");
      return t2 !== a2[i - 1];
    });
  }, IntersectionObserver2.prototype._parseRootMargin = function(opt_rootMargin) {
    var marginString = opt_rootMargin || "0px", margins = marginString.split(/\s+/).map(function(margin) {
      var parts = /^(-?\d*\.?\d+)(px|%)$/.exec(margin);
      if (!parts)
        throw new Error("rootMargin must be specified in pixels or percent");
      return { value: parseFloat(parts[1]), unit: parts[2] };
    });
    return margins[1] = margins[1] || margins[0], margins[2] = margins[2] || margins[0], margins[3] = margins[3] || margins[1], margins;
  }, IntersectionObserver2.prototype._monitorIntersections = function(doc) {
    var win = doc.defaultView;
    if (win && this._monitoringDocuments.indexOf(doc) == -1) {
      var callback = this._checkForIntersections, monitoringInterval = null, domObserver = null;
      this.POLL_INTERVAL ? monitoringInterval = win.setInterval(callback, this.POLL_INTERVAL) : (addEvent(win, "resize", callback, !0), addEvent(doc, "scroll", callback, !0), this.USE_MUTATION_OBSERVER && "MutationObserver" in win && (domObserver = new win.MutationObserver(callback), domObserver.observe(doc, {
        attributes: !0,
        childList: !0,
        characterData: !0,
        subtree: !0
      }))), this._monitoringDocuments.push(doc), this._monitoringUnsubscribes.push(function() {
        var win2 = doc.defaultView;
        win2 && (monitoringInterval && win2.clearInterval(monitoringInterval), removeEvent(win2, "resize", callback, !0)), removeEvent(doc, "scroll", callback, !0), domObserver && domObserver.disconnect();
      });
      var rootDoc = this.root && (this.root.ownerDocument || this.root) || document2;
      if (doc != rootDoc) {
        var frame = getFrameElement(doc);
        frame && this._monitorIntersections(frame.ownerDocument);
      }
    }
  }, IntersectionObserver2.prototype._unmonitorIntersections = function(doc) {
    var index3 = this._monitoringDocuments.indexOf(doc);
    if (index3 != -1) {
      var rootDoc = this.root && (this.root.ownerDocument || this.root) || document2, hasDependentTargets = this._observationTargets.some(function(item) {
        var itemDoc = item.element.ownerDocument;
        if (itemDoc == doc)
          return !0;
        for (; itemDoc && itemDoc != rootDoc; ) {
          var frame2 = getFrameElement(itemDoc);
          if (itemDoc = frame2 && frame2.ownerDocument, itemDoc == doc)
            return !0;
        }
        return !1;
      });
      if (!hasDependentTargets) {
        var unsubscribe2 = this._monitoringUnsubscribes[index3];
        if (this._monitoringDocuments.splice(index3, 1), this._monitoringUnsubscribes.splice(index3, 1), unsubscribe2(), doc != rootDoc) {
          var frame = getFrameElement(doc);
          frame && this._unmonitorIntersections(frame.ownerDocument);
        }
      }
    }
  }, IntersectionObserver2.prototype._unmonitorAllIntersections = function() {
    var unsubscribes = this._monitoringUnsubscribes.slice(0);
    this._monitoringDocuments.length = 0, this._monitoringUnsubscribes.length = 0;
    for (var i = 0; i < unsubscribes.length; i++)
      unsubscribes[i]();
  }, IntersectionObserver2.prototype._checkForIntersections = function() {
    if (!(!this.root && crossOriginUpdater && !crossOriginRect)) {
      var rootIsInDom = this._rootIsInDom(), rootRect = rootIsInDom ? this._getRootRect() : getEmptyRect();
      this._observationTargets.forEach(function(item) {
        var target2 = item.element, targetRect = getBoundingClientRect2(target2), rootContainsTarget = this._rootContainsTarget(target2), oldEntry = item.entry, intersectionRect = rootIsInDom && rootContainsTarget && this._computeTargetAndRootIntersection(target2, targetRect, rootRect), rootBounds = null;
        this._rootContainsTarget(target2) ? (!crossOriginUpdater || this.root) && (rootBounds = rootRect) : rootBounds = getEmptyRect();
        var newEntry = item.entry = new IntersectionObserverEntry({
          time: now(),
          target: target2,
          boundingClientRect: targetRect,
          rootBounds,
          intersectionRect
        });
        oldEntry ? rootIsInDom && rootContainsTarget ? this._hasCrossedThreshold(oldEntry, newEntry) && this._queuedEntries.push(newEntry) : oldEntry && oldEntry.isIntersecting && this._queuedEntries.push(newEntry) : this._queuedEntries.push(newEntry);
      }, this), this._queuedEntries.length && this._callback(this.takeRecords(), this);
    }
  }, IntersectionObserver2.prototype._computeTargetAndRootIntersection = function(target2, targetRect, rootRect) {
    if (window.getComputedStyle(target2).display != "none") {
      for (var intersectionRect = targetRect, parent = getParentNode2(target2), atRoot = !1; !atRoot && parent; ) {
        var parentRect = null, parentComputedStyle = parent.nodeType == 1 ? window.getComputedStyle(parent) : {};
        if (parentComputedStyle.display == "none") return null;
        if (parent == this.root || parent.nodeType == /* DOCUMENT */
        9)
          if (atRoot = !0, parent == this.root || parent == document2)
            crossOriginUpdater && !this.root ? !crossOriginRect || crossOriginRect.width == 0 && crossOriginRect.height == 0 ? (parent = null, parentRect = null, intersectionRect = null) : parentRect = crossOriginRect : parentRect = rootRect;
          else {
            var frame = getParentNode2(parent), frameRect = frame && getBoundingClientRect2(frame), frameIntersect = frame && this._computeTargetAndRootIntersection(frame, frameRect, rootRect);
            frameRect && frameIntersect ? (parent = frame, parentRect = convertFromParentRect(frameRect, frameIntersect)) : (parent = null, intersectionRect = null);
          }
        else {
          var doc = parent.ownerDocument;
          parent != doc.body && parent != doc.documentElement && parentComputedStyle.overflow != "visible" && (parentRect = getBoundingClientRect2(parent));
        }
        if (parentRect && (intersectionRect = computeRectIntersection(parentRect, intersectionRect)), !intersectionRect) break;
        parent = parent && getParentNode2(parent);
      }
      return intersectionRect;
    }
  }, IntersectionObserver2.prototype._getRootRect = function() {
    var rootRect;
    if (this.root && !isDoc(this.root))
      rootRect = getBoundingClientRect2(this.root);
    else {
      var doc = isDoc(this.root) ? this.root : document2, html2 = doc.documentElement, body = doc.body;
      rootRect = {
        top: 0,
        left: 0,
        right: html2.clientWidth || body.clientWidth,
        width: html2.clientWidth || body.clientWidth,
        bottom: html2.clientHeight || body.clientHeight,
        height: html2.clientHeight || body.clientHeight
      };
    }
    return this._expandRectByRootMargin(rootRect);
  }, IntersectionObserver2.prototype._expandRectByRootMargin = function(rect) {
    var margins = this._rootMarginValues.map(function(margin, i) {
      return margin.unit == "px" ? margin.value : margin.value * (i % 2 ? rect.width : rect.height) / 100;
    }), newRect = {
      top: rect.top - margins[0],
      right: rect.right + margins[1],
      bottom: rect.bottom + margins[2],
      left: rect.left - margins[3]
    };
    return newRect.width = newRect.right - newRect.left, newRect.height = newRect.bottom - newRect.top, newRect;
  }, IntersectionObserver2.prototype._hasCrossedThreshold = function(oldEntry, newEntry) {
    var oldRatio = oldEntry && oldEntry.isIntersecting ? oldEntry.intersectionRatio || 0 : -1, newRatio = newEntry.isIntersecting ? newEntry.intersectionRatio || 0 : -1;
    if (oldRatio !== newRatio)
      for (var i = 0; i < this.thresholds.length; i++) {
        var threshold = this.thresholds[i];
        if (threshold == oldRatio || threshold == newRatio || threshold < oldRatio != threshold < newRatio)
          return !0;
      }
  }, IntersectionObserver2.prototype._rootIsInDom = function() {
    return !this.root || containsDeep(document2, this.root);
  }, IntersectionObserver2.prototype._rootContainsTarget = function(target2) {
    var rootDoc = this.root && (this.root.ownerDocument || this.root) || document2;
    return containsDeep(rootDoc, target2) && (!this.root || rootDoc == target2.ownerDocument);
  }, IntersectionObserver2.prototype._registerInstance = function() {
    registry2.indexOf(this) < 0 && registry2.push(this);
  }, IntersectionObserver2.prototype._unregisterInstance = function() {
    var index3 = registry2.indexOf(this);
    index3 != -1 && registry2.splice(index3, 1);
  };
  function now() {
    return window.performance && performance.now && performance.now();
  }
  __name(now, "now");
  function throttle2(fn2, timeout) {
    var timer = null;
    return function() {
      timer || (timer = setTimeout(function() {
        fn2(), timer = null;
      }, timeout));
    };
  }
  __name(throttle2, "throttle");
  function addEvent(node, event2, fn2, opt_useCapture) {
    typeof node.addEventListener == "function" ? node.addEventListener(event2, fn2, opt_useCapture) : typeof node.attachEvent == "function" && node.attachEvent("on" + event2, fn2);
  }
  __name(addEvent, "addEvent");
  function removeEvent(node, event2, fn2, opt_useCapture) {
    typeof node.removeEventListener == "function" ? node.removeEventListener(event2, fn2, opt_useCapture) : typeof node.detachEvent == "function" && node.detachEvent("on" + event2, fn2);
  }
  __name(removeEvent, "removeEvent");
  function computeRectIntersection(rect1, rect2) {
    var top2 = Math.max(rect1.top, rect2.top), bottom2 = Math.min(rect1.bottom, rect2.bottom), left2 = Math.max(rect1.left, rect2.left), right2 = Math.min(rect1.right, rect2.right), width = right2 - left2, height = bottom2 - top2;
    return width >= 0 && height >= 0 && {
      top: top2,
      bottom: bottom2,
      left: left2,
      right: right2,
      width,
      height
    } || null;
  }
  __name(computeRectIntersection, "computeRectIntersection");
  function getBoundingClientRect2(el) {
    var rect;
    try {
      rect = el.getBoundingClientRect();
    } catch {
    }
    return rect ? (rect.width && rect.height || (rect = {
      top: rect.top,
      right: rect.right,
      bottom: rect.bottom,
      left: rect.left,
      width: rect.right - rect.left,
      height: rect.bottom - rect.top
    }), rect) : getEmptyRect();
  }
  __name(getBoundingClientRect2, "getBoundingClientRect");
  function getEmptyRect() {
    return {
      top: 0,
      bottom: 0,
      left: 0,
      right: 0,
      width: 0,
      height: 0
    };
  }
  __name(getEmptyRect, "getEmptyRect");
  function ensureDOMRect(rect) {
    return !rect || "x" in rect ? rect : {
      top: rect.top,
      y: rect.top,
      bottom: rect.bottom,
      left: rect.left,
      x: rect.left,
      right: rect.right,
      width: rect.width,
      height: rect.height
    };
  }
  __name(ensureDOMRect, "ensureDOMRect");
  function convertFromParentRect(parentBoundingRect, parentIntersectionRect) {
    var top2 = parentIntersectionRect.top - parentBoundingRect.top, left2 = parentIntersectionRect.left - parentBoundingRect.left;
    return {
      top: top2,
      left: left2,
      height: parentIntersectionRect.height,
      width: parentIntersectionRect.width,
      bottom: top2 + parentIntersectionRect.height,
      right: left2 + parentIntersectionRect.width
    };
  }
  __name(convertFromParentRect, "convertFromParentRect");
  function containsDeep(parent, child) {
    for (var node = child; node; ) {
      if (node == parent) return !0;
      node = getParentNode2(node);
    }
    return !1;
  }
  __name(containsDeep, "containsDeep");
  function getParentNode2(node) {
    var parent = node.parentNode;
    return node.nodeType == /* DOCUMENT */
    9 && node != document2 ? getFrameElement(node) : (parent && parent.assignedSlot && (parent = parent.assignedSlot.parentNode), parent && parent.nodeType == 11 && parent.host ? parent.host : parent);
  }
  __name(getParentNode2, "getParentNode");
  function isDoc(node) {
    return node && node.nodeType === 9;
  }
  __name(isDoc, "isDoc"), window.IntersectionObserver = IntersectionObserver2, window.IntersectionObserverEntry = IntersectionObserverEntry;
})();
Object.assign(window, {
  process: {
    env: {
      NODE_ENV: "production"
    }
  }
});
var commonjsGlobal = typeof globalThis < "u" ? globalThis : typeof window < "u" ? window : typeof global < "u" ? global : typeof self < "u" ? self : {};
function getDefaultExportFromCjs(x) {
  return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x.default : x;
}
__name(getDefaultExportFromCjs, "getDefaultExportFromCjs");
function getAugmentedNamespace(n2) {
  if (n2.__esModule) return n2;
  var f = n2.default;
  if (typeof f == "function") {
    var a2 = /* @__PURE__ */ __name(function a3() {
      return this instanceof a3 ? Reflect.construct(f, arguments, this.constructor) : f.apply(this, arguments);
    }, "a");
    a2.prototype = f.prototype;
  } else a2 = {};
  return Object.defineProperty(a2, "__esModule", { value: !0 }), Object.keys(n2).forEach(function(k) {
    var d = Object.getOwnPropertyDescriptor(n2, k);
    Object.defineProperty(a2, k, d.get ? d : {
      enumerable: !0,
      get: /* @__PURE__ */ __name(function() {
        return n2[k];
      }, "get")
    });
  }), a2;
}
__name(getAugmentedNamespace, "getAugmentedNamespace");
var jquery = { exports: {} };
/*!
 * jQuery JavaScript Library v3.7.1
 * https://jquery.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2023-08-28T13:37Z
 */
var hasRequiredJquery;
function requireJquery() {
  return hasRequiredJquery || (hasRequiredJquery = 1, function(module2) {
    (function(global2, factory2) {
      module2.exports = global2.document ? factory2(global2, !0) : function(w) {
        if (!w.document)
          throw new Error("jQuery requires a window with a document");
        return factory2(w);
      };
    })(typeof window < "u" ? window : commonjsGlobal, function(window2, noGlobal) {
      var arr = [], getProto = Object.getPrototypeOf, slice = arr.slice, flat = arr.flat ? function(array) {
        return arr.flat.call(array);
      } : function(array) {
        return arr.concat.apply([], array);
      }, push4 = arr.push, indexOf = arr.indexOf, class2type = {}, toString4 = class2type.toString, hasOwn2 = class2type.hasOwnProperty, fnToString = hasOwn2.toString, ObjectFunctionString = fnToString.call(Object), support2 = {}, isFunction3 = /* @__PURE__ */ __name(function(obj2) {
        return typeof obj2 == "function" && typeof obj2.nodeType != "number" && typeof obj2.item != "function";
      }, "isFunction"), isWindow = /* @__PURE__ */ __name(function(obj2) {
        return obj2 != null && obj2 === obj2.window;
      }, "isWindow"), document2 = window2.document, preservedScriptAttributes = {
        type: !0,
        src: !0,
        nonce: !0,
        noModule: !0
      };
      function DOMEval(code, node, doc) {
        doc = doc || document2;
        var i, val, script2 = doc.createElement("script");
        if (script2.text = code, node)
          for (i in preservedScriptAttributes)
            val = node[i] || node.getAttribute && node.getAttribute(i), val && script2.setAttribute(i, val);
        doc.head.appendChild(script2).parentNode.removeChild(script2);
      }
      __name(DOMEval, "DOMEval");
      function toType4(obj2) {
        return obj2 == null ? obj2 + "" : typeof obj2 == "object" || typeof obj2 == "function" ? class2type[toString4.call(obj2)] || "object" : typeof obj2;
      }
      __name(toType4, "toType");
      var version2 = "3.7.1", rhtmlSuffix = /HTML$/i, jQuery2 = /* @__PURE__ */ __name(function(selector, context7) {
        return new jQuery2.fn.init(selector, context7);
      }, "jQuery");
      jQuery2.fn = jQuery2.prototype = {
        // The current version of jQuery being used
        jquery: version2,
        constructor: jQuery2,
        // The default length of a jQuery object is 0
        length: 0,
        toArray: /* @__PURE__ */ __name(function() {
          return slice.call(this);
        }, "toArray"),
        // Get the Nth element in the matched element set OR
        // Get the whole matched element set as a clean array
        get: /* @__PURE__ */ __name(function(num) {
          return num == null ? slice.call(this) : num < 0 ? this[num + this.length] : this[num];
        }, "get"),
        // Take an array of elements and push it onto the stack
        // (returning the new matched element set)
        pushStack: /* @__PURE__ */ __name(function(elems) {
          var ret = jQuery2.merge(this.constructor(), elems);
          return ret.prevObject = this, ret;
        }, "pushStack"),
        // Execute a callback for every element in the matched set.
        each: /* @__PURE__ */ __name(function(callback) {
          return jQuery2.each(this, callback);
        }, "each"),
        map: /* @__PURE__ */ __name(function(callback) {
          return this.pushStack(jQuery2.map(this, function(elem, i) {
            return callback.call(elem, i, elem);
          }));
        }, "map"),
        slice: /* @__PURE__ */ __name(function() {
          return this.pushStack(slice.apply(this, arguments));
        }, "slice"),
        first: /* @__PURE__ */ __name(function() {
          return this.eq(0);
        }, "first"),
        last: /* @__PURE__ */ __name(function() {
          return this.eq(-1);
        }, "last"),
        even: /* @__PURE__ */ __name(function() {
          return this.pushStack(jQuery2.grep(this, function(_elem, i) {
            return (i + 1) % 2;
          }));
        }, "even"),
        odd: /* @__PURE__ */ __name(function() {
          return this.pushStack(jQuery2.grep(this, function(_elem, i) {
            return i % 2;
          }));
        }, "odd"),
        eq: /* @__PURE__ */ __name(function(i) {
          var len2 = this.length, j = +i + (i < 0 ? len2 : 0);
          return this.pushStack(j >= 0 && j < len2 ? [this[j]] : []);
        }, "eq"),
        end: /* @__PURE__ */ __name(function() {
          return this.prevObject || this.constructor();
        }, "end"),
        // For internal use only.
        // Behaves like an Array's method, not like a jQuery method.
        push: push4,
        sort: arr.sort,
        splice: arr.splice
      }, jQuery2.extend = jQuery2.fn.extend = function() {
        var options2, name2, src2, copy, copyIsArray, clone3, target2 = arguments[0] || {}, i = 1, length2 = arguments.length, deep = !1;
        for (typeof target2 == "boolean" && (deep = target2, target2 = arguments[i] || {}, i++), typeof target2 != "object" && !isFunction3(target2) && (target2 = {}), i === length2 && (target2 = this, i--); i < length2; i++)
          if ((options2 = arguments[i]) != null)
            for (name2 in options2)
              copy = options2[name2], !(name2 === "__proto__" || target2 === copy) && (deep && copy && (jQuery2.isPlainObject(copy) || (copyIsArray = Array.isArray(copy))) ? (src2 = target2[name2], copyIsArray && !Array.isArray(src2) ? clone3 = [] : !copyIsArray && !jQuery2.isPlainObject(src2) ? clone3 = {} : clone3 = src2, copyIsArray = !1, target2[name2] = jQuery2.extend(deep, clone3, copy)) : copy !== void 0 && (target2[name2] = copy));
        return target2;
      }, jQuery2.extend({
        // Unique for each copy of jQuery on the page
        expando: "jQuery" + (version2 + Math.random()).replace(/\D/g, ""),
        // Assume jQuery is ready without the ready module
        isReady: !0,
        error: /* @__PURE__ */ __name(function(msg) {
          throw new Error(msg);
        }, "error"),
        noop: /* @__PURE__ */ __name(function() {
        }, "noop"),
        isPlainObject: /* @__PURE__ */ __name(function(obj2) {
          var proto, Ctor;
          return !obj2 || toString4.call(obj2) !== "[object Object]" ? !1 : (proto = getProto(obj2), proto ? (Ctor = hasOwn2.call(proto, "constructor") && proto.constructor, typeof Ctor == "function" && fnToString.call(Ctor) === ObjectFunctionString) : !0);
        }, "isPlainObject"),
        isEmptyObject: /* @__PURE__ */ __name(function(obj2) {
          var name2;
          for (name2 in obj2)
            return !1;
          return !0;
        }, "isEmptyObject"),
        // Evaluates a script in a provided context; falls back to the global one
        // if not specified.
        globalEval: /* @__PURE__ */ __name(function(code, options2, doc) {
          DOMEval(code, { nonce: options2 && options2.nonce }, doc);
        }, "globalEval"),
        each: /* @__PURE__ */ __name(function(obj2, callback) {
          var length2, i = 0;
          if (isArrayLike(obj2))
            for (length2 = obj2.length; i < length2 && callback.call(obj2[i], i, obj2[i]) !== !1; i++)
              ;
          else
            for (i in obj2)
              if (callback.call(obj2[i], i, obj2[i]) === !1)
                break;
          return obj2;
        }, "each"),
        // Retrieve the text value of an array of DOM nodes
        text: /* @__PURE__ */ __name(function(elem) {
          var node, ret = "", i = 0, nodeType = elem.nodeType;
          if (!nodeType)
            for (; node = elem[i++]; )
              ret += jQuery2.text(node);
          return nodeType === 1 || nodeType === 11 ? elem.textContent : nodeType === 9 ? elem.documentElement.textContent : nodeType === 3 || nodeType === 4 ? elem.nodeValue : ret;
        }, "text"),
        // results is for internal usage only
        makeArray: /* @__PURE__ */ __name(function(arr2, results) {
          var ret = results || [];
          return arr2 != null && (isArrayLike(Object(arr2)) ? jQuery2.merge(
            ret,
            typeof arr2 == "string" ? [arr2] : arr2
          ) : push4.call(ret, arr2)), ret;
        }, "makeArray"),
        inArray: /* @__PURE__ */ __name(function(elem, arr2, i) {
          return arr2 == null ? -1 : indexOf.call(arr2, elem, i);
        }, "inArray"),
        isXMLDoc: /* @__PURE__ */ __name(function(elem) {
          var namespace2 = elem && elem.namespaceURI, docElem = elem && (elem.ownerDocument || elem).documentElement;
          return !rhtmlSuffix.test(namespace2 || docElem && docElem.nodeName || "HTML");
        }, "isXMLDoc"),
        // Support: Android <=4.0 only, PhantomJS 1 only
        // push.apply(_, arraylike) throws on ancient WebKit
        merge: /* @__PURE__ */ __name(function(first2, second) {
          for (var len2 = +second.length, j = 0, i = first2.length; j < len2; j++)
            first2[i++] = second[j];
          return first2.length = i, first2;
        }, "merge"),
        grep: /* @__PURE__ */ __name(function(elems, callback, invert) {
          for (var callbackInverse, matches4 = [], i = 0, length2 = elems.length, callbackExpect = !invert; i < length2; i++)
            callbackInverse = !callback(elems[i], i), callbackInverse !== callbackExpect && matches4.push(elems[i]);
          return matches4;
        }, "grep"),
        // arg is for internal usage only
        map: /* @__PURE__ */ __name(function(elems, callback, arg) {
          var length2, value3, i = 0, ret = [];
          if (isArrayLike(elems))
            for (length2 = elems.length; i < length2; i++)
              value3 = callback(elems[i], i, arg), value3 != null && ret.push(value3);
          else
            for (i in elems)
              value3 = callback(elems[i], i, arg), value3 != null && ret.push(value3);
          return flat(ret);
        }, "map"),
        // A global GUID counter for objects
        guid: 1,
        // jQuery.support is not used in Core but other projects attach their
        // properties to it so it needs to exist.
        support: support2
      }), typeof Symbol == "function" && (jQuery2.fn[Symbol.iterator] = arr[Symbol.iterator]), jQuery2.each(
        "Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),
        function(_i, name2) {
          class2type["[object " + name2 + "]"] = name2.toLowerCase();
        }
      );
      function isArrayLike(obj2) {
        var length2 = !!obj2 && "length" in obj2 && obj2.length, type2 = toType4(obj2);
        return isFunction3(obj2) || isWindow(obj2) ? !1 : type2 === "array" || length2 === 0 || typeof length2 == "number" && length2 > 0 && length2 - 1 in obj2;
      }
      __name(isArrayLike, "isArrayLike");
      function nodeName(elem, name2) {
        return elem.nodeName && elem.nodeName.toLowerCase() === name2.toLowerCase();
      }
      __name(nodeName, "nodeName");
      var pop = arr.pop, sort2 = arr.sort, splice = arr.splice, whitespace = "[\\x20\\t\\r\\n\\f]", rtrimCSS = new RegExp(
        "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$",
        "g"
      );
      jQuery2.contains = function(a2, b) {
        var bup = b && b.parentNode;
        return a2 === bup || !!(bup && bup.nodeType === 1 && // Support: IE 9 - 11+
        // IE doesn't have `contains` on SVG.
        (a2.contains ? a2.contains(bup) : a2.compareDocumentPosition && a2.compareDocumentPosition(bup) & 16));
      };
      var rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g;
      function fcssescape(ch, asCodePoint) {
        return asCodePoint ? ch === "\0" ? "�" : ch.slice(0, -1) + "\\" + ch.charCodeAt(ch.length - 1).toString(16) + " " : "\\" + ch;
      }
      __name(fcssescape, "fcssescape"), jQuery2.escapeSelector = function(sel) {
        return (sel + "").replace(rcssescape, fcssescape);
      };
      var preferredDoc = document2, pushNative = push4;
      (function() {
        var i, Expr, outermostContext, sortInput, hasDuplicate, push5 = pushNative, document3, documentElement2, documentIsHTML, rbuggyQSA, matches4, expando2 = jQuery2.expando, dirruns = 0, done = 0, classCache = createCache(), tokenCache = createCache(), compilerCache = createCache(), nonnativeSelectorCache = createCache(), sortOrder = /* @__PURE__ */ __name(function(a2, b) {
          return a2 === b && (hasDuplicate = !0), 0;
        }, "sortOrder"), booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped", identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace + "?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+", attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace + // Operator (capture 2)
        "*([*^$|!~]?=)" + whitespace + // "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
        `*(?:'((?:\\\\.|[^\\\\'])*)'|"((?:\\\\.|[^\\\\"])*)"|(` + identifier + "))|)" + whitespace + "*\\]", pseudos = ":(" + identifier + `)(?:\\((('((?:\\\\.|[^\\\\'])*)'|"((?:\\\\.|[^\\\\"])*)")|((?:\\\\.|[^\\\\()[\\]]|` + attributes + ")*)|.*)\\)|)", rwhitespace = new RegExp(whitespace + "+", "g"), rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"), rleadingCombinator = new RegExp("^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*"), rdescend = new RegExp(whitespace + "|>"), rpseudo = new RegExp(pseudos), ridentifier = new RegExp("^" + identifier + "$"), matchExpr = {
          ID: new RegExp("^#(" + identifier + ")"),
          CLASS: new RegExp("^\\.(" + identifier + ")"),
          TAG: new RegExp("^(" + identifier + "|[*])"),
          ATTR: new RegExp("^" + attributes),
          PSEUDO: new RegExp("^" + pseudos),
          CHILD: new RegExp(
            "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace + "*(\\d+)|))" + whitespace + "*\\)|)",
            "i"
          ),
          bool: new RegExp("^(?:" + booleans + ")$", "i"),
          // For use in libraries implementing .is()
          // We use this for POS matching in `select`
          needsContext: new RegExp("^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i")
        }, rinputs = /^(?:input|select|textarea|button)$/i, rheader = /^h\d$/i, rquickExpr2 = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/, rsibling = /[+~]/, runescape = new RegExp("\\\\[\\da-fA-F]{1,6}" + whitespace + "?|\\\\([^\\r\\n\\f])", "g"), funescape = /* @__PURE__ */ __name(function(escape2, nonHex) {
          var high = "0x" + escape2.slice(1) - 65536;
          return nonHex || (high < 0 ? String.fromCharCode(high + 65536) : String.fromCharCode(high >> 10 | 55296, high & 1023 | 56320));
        }, "funescape"), unloadHandler = /* @__PURE__ */ __name(function() {
          setDocument();
        }, "unloadHandler"), inDisabledFieldset = addCombinator(
          function(elem) {
            return elem.disabled === !0 && nodeName(elem, "fieldset");
          },
          { dir: "parentNode", next: "legend" }
        );
        function safeActiveElement() {
          try {
            return document3.activeElement;
          } catch {
          }
        }
        __name(safeActiveElement, "safeActiveElement");
        try {
          push5.apply(
            arr = slice.call(preferredDoc.childNodes),
            preferredDoc.childNodes
          ), arr[preferredDoc.childNodes.length].nodeType;
        } catch {
          push5 = {
            apply: /* @__PURE__ */ __name(function(target2, els) {
              pushNative.apply(target2, slice.call(els));
            }, "apply"),
            call: /* @__PURE__ */ __name(function(target2) {
              pushNative.apply(target2, slice.call(arguments, 1));
            }, "call")
          };
        }
        function find2(selector, context7, results, seed) {
          var m, i2, elem, nid, match3, groups2, newSelector, newContext = context7 && context7.ownerDocument, nodeType = context7 ? context7.nodeType : 9;
          if (results = results || [], typeof selector != "string" || !selector || nodeType !== 1 && nodeType !== 9 && nodeType !== 11)
            return results;
          if (!seed && (setDocument(context7), context7 = context7 || document3, documentIsHTML)) {
            if (nodeType !== 11 && (match3 = rquickExpr2.exec(selector)))
              if (m = match3[1]) {
                if (nodeType === 9)
                  if (elem = context7.getElementById(m)) {
                    if (elem.id === m)
                      return push5.call(results, elem), results;
                  } else
                    return results;
                else if (newContext && (elem = newContext.getElementById(m)) && find2.contains(context7, elem) && elem.id === m)
                  return push5.call(results, elem), results;
              } else {
                if (match3[2])
                  return push5.apply(results, context7.getElementsByTagName(selector)), results;
                if ((m = match3[3]) && context7.getElementsByClassName)
                  return push5.apply(results, context7.getElementsByClassName(m)), results;
              }
            if (!nonnativeSelectorCache[selector + " "] && (!rbuggyQSA || !rbuggyQSA.test(selector))) {
              if (newSelector = selector, newContext = context7, nodeType === 1 && (rdescend.test(selector) || rleadingCombinator.test(selector))) {
                for (newContext = rsibling.test(selector) && testContext(context7.parentNode) || context7, (newContext != context7 || !support2.scope) && ((nid = context7.getAttribute("id")) ? nid = jQuery2.escapeSelector(nid) : context7.setAttribute("id", nid = expando2)), groups2 = tokenize(selector), i2 = groups2.length; i2--; )
                  groups2[i2] = (nid ? "#" + nid : ":scope") + " " + toSelector(groups2[i2]);
                newSelector = groups2.join(",");
              }
              try {
                return push5.apply(
                  results,
                  newContext.querySelectorAll(newSelector)
                ), results;
              } catch {
                nonnativeSelectorCache(selector, !0);
              } finally {
                nid === expando2 && context7.removeAttribute("id");
              }
            }
          }
          return select4(selector.replace(rtrimCSS, "$1"), context7, results, seed);
        }
        __name(find2, "find");
        function createCache() {
          var keys3 = [];
          function cache(key, value3) {
            return keys3.push(key + " ") > Expr.cacheLength && delete cache[keys3.shift()], cache[key + " "] = value3;
          }
          return __name(cache, "cache"), cache;
        }
        __name(createCache, "createCache");
        function markFunction(fn2) {
          return fn2[expando2] = !0, fn2;
        }
        __name(markFunction, "markFunction");
        function assert2(fn2) {
          var el = document3.createElement("fieldset");
          try {
            return !!fn2(el);
          } catch {
            return !1;
          } finally {
            el.parentNode && el.parentNode.removeChild(el), el = null;
          }
        }
        __name(assert2, "assert");
        function createInputPseudo(type2) {
          return function(elem) {
            return nodeName(elem, "input") && elem.type === type2;
          };
        }
        __name(createInputPseudo, "createInputPseudo");
        function createButtonPseudo(type2) {
          return function(elem) {
            return (nodeName(elem, "input") || nodeName(elem, "button")) && elem.type === type2;
          };
        }
        __name(createButtonPseudo, "createButtonPseudo");
        function createDisabledPseudo(disabled6) {
          return function(elem) {
            return "form" in elem ? elem.parentNode && elem.disabled === !1 ? "label" in elem ? "label" in elem.parentNode ? elem.parentNode.disabled === disabled6 : elem.disabled === disabled6 : elem.isDisabled === disabled6 || // Where there is no isDisabled, check manually
            elem.isDisabled !== !disabled6 && inDisabledFieldset(elem) === disabled6 : elem.disabled === disabled6 : "label" in elem ? elem.disabled === disabled6 : !1;
          };
        }
        __name(createDisabledPseudo, "createDisabledPseudo");
        function createPositionalPseudo(fn2) {
          return markFunction(function(argument) {
            return argument = +argument, markFunction(function(seed, matches5) {
              for (var j, matchIndexes = fn2([], seed.length, argument), i2 = matchIndexes.length; i2--; )
                seed[j = matchIndexes[i2]] && (seed[j] = !(matches5[j] = seed[j]));
            });
          });
        }
        __name(createPositionalPseudo, "createPositionalPseudo");
        function testContext(context7) {
          return context7 && typeof context7.getElementsByTagName < "u" && context7;
        }
        __name(testContext, "testContext");
        function setDocument(node) {
          var subWindow, doc = node ? node.ownerDocument || node : preferredDoc;
          return doc == document3 || doc.nodeType !== 9 || !doc.documentElement || (document3 = doc, documentElement2 = document3.documentElement, documentIsHTML = !jQuery2.isXMLDoc(document3), matches4 = documentElement2.matches || documentElement2.webkitMatchesSelector || documentElement2.msMatchesSelector, documentElement2.msMatchesSelector && // Support: IE 11+, Edge 17 - 18+
          // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
          // two documents; shallow comparisons work.
          // eslint-disable-next-line eqeqeq
          preferredDoc != document3 && (subWindow = document3.defaultView) && subWindow.top !== subWindow && subWindow.addEventListener("unload", unloadHandler), support2.getById = assert2(function(el) {
            return documentElement2.appendChild(el).id = jQuery2.expando, !document3.getElementsByName || !document3.getElementsByName(jQuery2.expando).length;
          }), support2.disconnectedMatch = assert2(function(el) {
            return matches4.call(el, "*");
          }), support2.scope = assert2(function() {
            return document3.querySelectorAll(":scope");
          }), support2.cssHas = assert2(function() {
            try {
              return document3.querySelector(":has(*,:jqfake)"), !1;
            } catch {
              return !0;
            }
          }), support2.getById ? (Expr.filter.ID = function(id2) {
            var attrId = id2.replace(runescape, funescape);
            return function(elem) {
              return elem.getAttribute("id") === attrId;
            };
          }, Expr.find.ID = function(id2, context7) {
            if (typeof context7.getElementById < "u" && documentIsHTML) {
              var elem = context7.getElementById(id2);
              return elem ? [elem] : [];
            }
          }) : (Expr.filter.ID = function(id2) {
            var attrId = id2.replace(runescape, funescape);
            return function(elem) {
              var node2 = typeof elem.getAttributeNode < "u" && elem.getAttributeNode("id");
              return node2 && node2.value === attrId;
            };
          }, Expr.find.ID = function(id2, context7) {
            if (typeof context7.getElementById < "u" && documentIsHTML) {
              var node2, i2, elems, elem = context7.getElementById(id2);
              if (elem) {
                if (node2 = elem.getAttributeNode("id"), node2 && node2.value === id2)
                  return [elem];
                for (elems = context7.getElementsByName(id2), i2 = 0; elem = elems[i2++]; )
                  if (node2 = elem.getAttributeNode("id"), node2 && node2.value === id2)
                    return [elem];
              }
              return [];
            }
          }), Expr.find.TAG = function(tag3, context7) {
            return typeof context7.getElementsByTagName < "u" ? context7.getElementsByTagName(tag3) : context7.querySelectorAll(tag3);
          }, Expr.find.CLASS = function(className, context7) {
            if (typeof context7.getElementsByClassName < "u" && documentIsHTML)
              return context7.getElementsByClassName(className);
          }, rbuggyQSA = [], assert2(function(el) {
            var input;
            documentElement2.appendChild(el).innerHTML = "<a id='" + expando2 + "' href='' disabled='disabled'></a><select id='" + expando2 + "-\r\\' disabled='disabled'><option selected=''></option></select>", el.querySelectorAll("[selected]").length || rbuggyQSA.push("\\[" + whitespace + "*(?:value|" + booleans + ")"), el.querySelectorAll("[id~=" + expando2 + "-]").length || rbuggyQSA.push("~="), el.querySelectorAll("a#" + expando2 + "+*").length || rbuggyQSA.push(".#.+[+~]"), el.querySelectorAll(":checked").length || rbuggyQSA.push(":checked"), input = document3.createElement("input"), input.setAttribute("type", "hidden"), el.appendChild(input).setAttribute("name", "D"), documentElement2.appendChild(el).disabled = !0, el.querySelectorAll(":disabled").length !== 2 && rbuggyQSA.push(":enabled", ":disabled"), input = document3.createElement("input"), input.setAttribute("name", ""), el.appendChild(input), el.querySelectorAll("[name='']").length || rbuggyQSA.push("\\[" + whitespace + "*name" + whitespace + "*=" + whitespace + `*(?:''|"")`);
          }), support2.cssHas || rbuggyQSA.push(":has"), rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join("|")), sortOrder = /* @__PURE__ */ __name(function(a2, b) {
            if (a2 === b)
              return hasDuplicate = !0, 0;
            var compare2 = !a2.compareDocumentPosition - !b.compareDocumentPosition;
            return compare2 || (compare2 = (a2.ownerDocument || a2) == (b.ownerDocument || b) ? a2.compareDocumentPosition(b) : (
              // Otherwise we know they are disconnected
              1
            ), compare2 & 1 || !support2.sortDetached && b.compareDocumentPosition(a2) === compare2 ? a2 === document3 || a2.ownerDocument == preferredDoc && find2.contains(preferredDoc, a2) ? -1 : b === document3 || b.ownerDocument == preferredDoc && find2.contains(preferredDoc, b) ? 1 : sortInput ? indexOf.call(sortInput, a2) - indexOf.call(sortInput, b) : 0 : compare2 & 4 ? -1 : 1);
          }, "sortOrder")), document3;
        }
        __name(setDocument, "setDocument"), find2.matches = function(expr, elements) {
          return find2(expr, null, null, elements);
        }, find2.matchesSelector = function(elem, expr) {
          if (setDocument(elem), documentIsHTML && !nonnativeSelectorCache[expr + " "] && (!rbuggyQSA || !rbuggyQSA.test(expr)))
            try {
              var ret = matches4.call(elem, expr);
              if (ret || support2.disconnectedMatch || // As well, disconnected nodes are said to be in a document
              // fragment in IE 9
              elem.document && elem.document.nodeType !== 11)
                return ret;
            } catch {
              nonnativeSelectorCache(expr, !0);
            }
          return find2(expr, document3, null, [elem]).length > 0;
        }, find2.contains = function(context7, elem) {
          return (context7.ownerDocument || context7) != document3 && setDocument(context7), jQuery2.contains(context7, elem);
        }, find2.attr = function(elem, name2) {
          (elem.ownerDocument || elem) != document3 && setDocument(elem);
          var fn2 = Expr.attrHandle[name2.toLowerCase()], val = fn2 && hasOwn2.call(Expr.attrHandle, name2.toLowerCase()) ? fn2(elem, name2, !documentIsHTML) : void 0;
          return val !== void 0 ? val : elem.getAttribute(name2);
        }, find2.error = function(msg) {
          throw new Error("Syntax error, unrecognized expression: " + msg);
        }, jQuery2.uniqueSort = function(results) {
          var elem, duplicates = [], j = 0, i2 = 0;
          if (hasDuplicate = !support2.sortStable, sortInput = !support2.sortStable && slice.call(results, 0), sort2.call(results, sortOrder), hasDuplicate) {
            for (; elem = results[i2++]; )
              elem === results[i2] && (j = duplicates.push(i2));
            for (; j--; )
              splice.call(results, duplicates[j], 1);
          }
          return sortInput = null, results;
        }, jQuery2.fn.uniqueSort = function() {
          return this.pushStack(jQuery2.uniqueSort(slice.apply(this)));
        }, Expr = jQuery2.expr = {
          // Can be adjusted by the user
          cacheLength: 50,
          createPseudo: markFunction,
          match: matchExpr,
          attrHandle: {},
          find: {},
          relative: {
            ">": { dir: "parentNode", first: !0 },
            " ": { dir: "parentNode" },
            "+": { dir: "previousSibling", first: !0 },
            "~": { dir: "previousSibling" }
          },
          preFilter: {
            ATTR: /* @__PURE__ */ __name(function(match3) {
              return match3[1] = match3[1].replace(runescape, funescape), match3[3] = (match3[3] || match3[4] || match3[5] || "").replace(runescape, funescape), match3[2] === "~=" && (match3[3] = " " + match3[3] + " "), match3.slice(0, 4);
            }, "ATTR"),
            CHILD: /* @__PURE__ */ __name(function(match3) {
              return match3[1] = match3[1].toLowerCase(), match3[1].slice(0, 3) === "nth" ? (match3[3] || find2.error(match3[0]), match3[4] = +(match3[4] ? match3[5] + (match3[6] || 1) : 2 * (match3[3] === "even" || match3[3] === "odd")), match3[5] = +(match3[7] + match3[8] || match3[3] === "odd")) : match3[3] && find2.error(match3[0]), match3;
            }, "CHILD"),
            PSEUDO: /* @__PURE__ */ __name(function(match3) {
              var excess, unquoted = !match3[6] && match3[2];
              return matchExpr.CHILD.test(match3[0]) ? null : (match3[3] ? match3[2] = match3[4] || match3[5] || "" : unquoted && rpseudo.test(unquoted) && // Get excess from tokenize (recursively)
              (excess = tokenize(unquoted, !0)) && // advance to the next closing parenthesis
              (excess = unquoted.indexOf(")", unquoted.length - excess) - unquoted.length) && (match3[0] = match3[0].slice(0, excess), match3[2] = unquoted.slice(0, excess)), match3.slice(0, 3));
            }, "PSEUDO")
          },
          filter: {
            TAG: /* @__PURE__ */ __name(function(nodeNameSelector) {
              var expectedNodeName = nodeNameSelector.replace(runescape, funescape).toLowerCase();
              return nodeNameSelector === "*" ? function() {
                return !0;
              } : function(elem) {
                return nodeName(elem, expectedNodeName);
              };
            }, "TAG"),
            CLASS: /* @__PURE__ */ __name(function(className) {
              var pattern = classCache[className + " "];
              return pattern || (pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) && classCache(className, function(elem) {
                return pattern.test(
                  typeof elem.className == "string" && elem.className || typeof elem.getAttribute < "u" && elem.getAttribute("class") || ""
                );
              });
            }, "CLASS"),
            ATTR: /* @__PURE__ */ __name(function(name2, operator, check) {
              return function(elem) {
                var result = find2.attr(elem, name2);
                return result == null ? operator === "!=" : operator ? (result += "", operator === "=" ? result === check : operator === "!=" ? result !== check : operator === "^=" ? check && result.indexOf(check) === 0 : operator === "*=" ? check && result.indexOf(check) > -1 : operator === "$=" ? check && result.slice(-check.length) === check : operator === "~=" ? (" " + result.replace(rwhitespace, " ") + " ").indexOf(check) > -1 : operator === "|=" ? result === check || result.slice(0, check.length + 1) === check + "-" : !1) : !0;
              };
            }, "ATTR"),
            CHILD: /* @__PURE__ */ __name(function(type2, what, _argument, first2, last) {
              var simple = type2.slice(0, 3) !== "nth", forward2 = type2.slice(-4) !== "last", ofType = what === "of-type";
              return first2 === 1 && last === 0 ? (
                // Shortcut for :nth-*(n)
                function(elem) {
                  return !!elem.parentNode;
                }
              ) : function(elem, _context, xml) {
                var cache, outerCache, node, nodeIndex, start3, dir2 = simple !== forward2 ? "nextSibling" : "previousSibling", parent = elem.parentNode, name2 = ofType && elem.nodeName.toLowerCase(), useCache = !xml && !ofType, diff = !1;
                if (parent) {
                  if (simple) {
                    for (; dir2; ) {
                      for (node = elem; node = node[dir2]; )
                        if (ofType ? nodeName(node, name2) : node.nodeType === 1)
                          return !1;
                      start3 = dir2 = type2 === "only" && !start3 && "nextSibling";
                    }
                    return !0;
                  }
                  if (start3 = [forward2 ? parent.firstChild : parent.lastChild], forward2 && useCache) {
                    for (outerCache = parent[expando2] || (parent[expando2] = {}), cache = outerCache[type2] || [], nodeIndex = cache[0] === dirruns && cache[1], diff = nodeIndex && cache[2], node = nodeIndex && parent.childNodes[nodeIndex]; node = ++nodeIndex && node && node[dir2] || // Fallback to seeking `elem` from the start
                    (diff = nodeIndex = 0) || start3.pop(); )
                      if (node.nodeType === 1 && ++diff && node === elem) {
                        outerCache[type2] = [dirruns, nodeIndex, diff];
                        break;
                      }
                  } else if (useCache && (outerCache = elem[expando2] || (elem[expando2] = {}), cache = outerCache[type2] || [], nodeIndex = cache[0] === dirruns && cache[1], diff = nodeIndex), diff === !1)
                    for (; (node = ++nodeIndex && node && node[dir2] || (diff = nodeIndex = 0) || start3.pop()) && !((ofType ? nodeName(node, name2) : node.nodeType === 1) && ++diff && (useCache && (outerCache = node[expando2] || (node[expando2] = {}), outerCache[type2] = [dirruns, diff]), node === elem)); )
                      ;
                  return diff -= last, diff === first2 || diff % first2 === 0 && diff / first2 >= 0;
                }
              };
            }, "CHILD"),
            PSEUDO: /* @__PURE__ */ __name(function(pseudo, argument) {
              var args, fn2 = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] || find2.error("unsupported pseudo: " + pseudo);
              return fn2[expando2] ? fn2(argument) : fn2.length > 1 ? (args = [pseudo, pseudo, "", argument], Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ? markFunction(function(seed, matches5) {
                for (var idx, matched = fn2(seed, argument), i2 = matched.length; i2--; )
                  idx = indexOf.call(seed, matched[i2]), seed[idx] = !(matches5[idx] = matched[i2]);
              }) : function(elem) {
                return fn2(elem, 0, args);
              }) : fn2;
            }, "PSEUDO")
          },
          pseudos: {
            // Potentially complex pseudos
            not: markFunction(function(selector) {
              var input = [], results = [], matcher = compile2(selector.replace(rtrimCSS, "$1"));
              return matcher[expando2] ? markFunction(function(seed, matches5, _context, xml) {
                for (var elem, unmatched = matcher(seed, null, xml, []), i2 = seed.length; i2--; )
                  (elem = unmatched[i2]) && (seed[i2] = !(matches5[i2] = elem));
              }) : function(elem, _context, xml) {
                return input[0] = elem, matcher(input, null, xml, results), input[0] = null, !results.pop();
              };
            }),
            has: markFunction(function(selector) {
              return function(elem) {
                return find2(selector, elem).length > 0;
              };
            }),
            contains: markFunction(function(text2) {
              return text2 = text2.replace(runescape, funescape), function(elem) {
                return (elem.textContent || jQuery2.text(elem)).indexOf(text2) > -1;
              };
            }),
            // "Whether an element is represented by a :lang() selector
            // is based solely on the element's language value
            // being equal to the identifier C,
            // or beginning with the identifier C immediately followed by "-".
            // The matching of C against the element's language value is performed case-insensitively.
            // The identifier C does not have to be a valid language name."
            // https://www.w3.org/TR/selectors/#lang-pseudo
            lang: markFunction(function(lang) {
              return ridentifier.test(lang || "") || find2.error("unsupported lang: " + lang), lang = lang.replace(runescape, funescape).toLowerCase(), function(elem) {
                var elemLang;
                do
                  if (elemLang = documentIsHTML ? elem.lang : elem.getAttribute("xml:lang") || elem.getAttribute("lang"))
                    return elemLang = elemLang.toLowerCase(), elemLang === lang || elemLang.indexOf(lang + "-") === 0;
                while ((elem = elem.parentNode) && elem.nodeType === 1);
                return !1;
              };
            }),
            // Miscellaneous
            target: /* @__PURE__ */ __name(function(elem) {
              var hash2 = window2.location && window2.location.hash;
              return hash2 && hash2.slice(1) === elem.id;
            }, "target"),
            root: /* @__PURE__ */ __name(function(elem) {
              return elem === documentElement2;
            }, "root"),
            focus: /* @__PURE__ */ __name(function(elem) {
              return elem === safeActiveElement() && document3.hasFocus() && !!(elem.type || elem.href || ~elem.tabIndex);
            }, "focus"),
            // Boolean properties
            enabled: createDisabledPseudo(!1),
            disabled: createDisabledPseudo(!0),
            checked: /* @__PURE__ */ __name(function(elem) {
              return nodeName(elem, "input") && !!elem.checked || nodeName(elem, "option") && !!elem.selected;
            }, "checked"),
            selected: /* @__PURE__ */ __name(function(elem) {
              return elem.parentNode && elem.parentNode.selectedIndex, elem.selected === !0;
            }, "selected"),
            // Contents
            empty: /* @__PURE__ */ __name(function(elem) {
              for (elem = elem.firstChild; elem; elem = elem.nextSibling)
                if (elem.nodeType < 6)
                  return !1;
              return !0;
            }, "empty"),
            parent: /* @__PURE__ */ __name(function(elem) {
              return !Expr.pseudos.empty(elem);
            }, "parent"),
            // Element/input types
            header: /* @__PURE__ */ __name(function(elem) {
              return rheader.test(elem.nodeName);
            }, "header"),
            input: /* @__PURE__ */ __name(function(elem) {
              return rinputs.test(elem.nodeName);
            }, "input"),
            button: /* @__PURE__ */ __name(function(elem) {
              return nodeName(elem, "input") && elem.type === "button" || nodeName(elem, "button");
            }, "button"),
            text: /* @__PURE__ */ __name(function(elem) {
              var attr;
              return nodeName(elem, "input") && elem.type === "text" && // Support: IE <10 only
              // New HTML5 attribute values (e.g., "search") appear
              // with elem.type === "text"
              ((attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text");
            }, "text"),
            // Position-in-collection
            first: createPositionalPseudo(function() {
              return [0];
            }),
            last: createPositionalPseudo(function(_matchIndexes, length2) {
              return [length2 - 1];
            }),
            eq: createPositionalPseudo(function(_matchIndexes, length2, argument) {
              return [argument < 0 ? argument + length2 : argument];
            }),
            even: createPositionalPseudo(function(matchIndexes, length2) {
              for (var i2 = 0; i2 < length2; i2 += 2)
                matchIndexes.push(i2);
              return matchIndexes;
            }),
            odd: createPositionalPseudo(function(matchIndexes, length2) {
              for (var i2 = 1; i2 < length2; i2 += 2)
                matchIndexes.push(i2);
              return matchIndexes;
            }),
            lt: createPositionalPseudo(function(matchIndexes, length2, argument) {
              var i2;
              for (argument < 0 ? i2 = argument + length2 : argument > length2 ? i2 = length2 : i2 = argument; --i2 >= 0; )
                matchIndexes.push(i2);
              return matchIndexes;
            }),
            gt: createPositionalPseudo(function(matchIndexes, length2, argument) {
              for (var i2 = argument < 0 ? argument + length2 : argument; ++i2 < length2; )
                matchIndexes.push(i2);
              return matchIndexes;
            })
          }
        }, Expr.pseudos.nth = Expr.pseudos.eq;
        for (i in { radio: !0, checkbox: !0, file: !0, password: !0, image: !0 })
          Expr.pseudos[i] = createInputPseudo(i);
        for (i in { submit: !0, reset: !0 })
          Expr.pseudos[i] = createButtonPseudo(i);
        function setFilters() {
        }
        __name(setFilters, "setFilters"), setFilters.prototype = Expr.filters = Expr.pseudos, Expr.setFilters = new setFilters();
        function tokenize(selector, parseOnly) {
          var matched, match3, tokens, type2, soFar, groups2, preFilters, cached2 = tokenCache[selector + " "];
          if (cached2)
            return parseOnly ? 0 : cached2.slice(0);
          for (soFar = selector, groups2 = [], preFilters = Expr.preFilter; soFar; ) {
            (!matched || (match3 = rcomma.exec(soFar))) && (match3 && (soFar = soFar.slice(match3[0].length) || soFar), groups2.push(tokens = [])), matched = !1, (match3 = rleadingCombinator.exec(soFar)) && (matched = match3.shift(), tokens.push({
              value: matched,
              // Cast descendant combinators to space
              type: match3[0].replace(rtrimCSS, " ")
            }), soFar = soFar.slice(matched.length));
            for (type2 in Expr.filter)
              (match3 = matchExpr[type2].exec(soFar)) && (!preFilters[type2] || (match3 = preFilters[type2](match3))) && (matched = match3.shift(), tokens.push({
                value: matched,
                type: type2,
                matches: match3
              }), soFar = soFar.slice(matched.length));
            if (!matched)
              break;
          }
          return parseOnly ? soFar.length : soFar ? find2.error(selector) : (
            // Cache the tokens
            tokenCache(selector, groups2).slice(0)
          );
        }
        __name(tokenize, "tokenize");
        function toSelector(tokens) {
          for (var i2 = 0, len2 = tokens.length, selector = ""; i2 < len2; i2++)
            selector += tokens[i2].value;
          return selector;
        }
        __name(toSelector, "toSelector");
        function addCombinator(matcher, combinator, base) {
          var dir2 = combinator.dir, skip = combinator.next, key = skip || dir2, checkNonElements = base && key === "parentNode", doneName = done++;
          return combinator.first ? (
            // Check against closest ancestor/preceding element
            function(elem, context7, xml) {
              for (; elem = elem[dir2]; )
                if (elem.nodeType === 1 || checkNonElements)
                  return matcher(elem, context7, xml);
              return !1;
            }
          ) : (
            // Check against all ancestor/preceding elements
            function(elem, context7, xml) {
              var oldCache, outerCache, newCache = [dirruns, doneName];
              if (xml) {
                for (; elem = elem[dir2]; )
                  if ((elem.nodeType === 1 || checkNonElements) && matcher(elem, context7, xml))
                    return !0;
              } else
                for (; elem = elem[dir2]; )
                  if (elem.nodeType === 1 || checkNonElements)
                    if (outerCache = elem[expando2] || (elem[expando2] = {}), skip && nodeName(elem, skip))
                      elem = elem[dir2] || elem;
                    else {
                      if ((oldCache = outerCache[key]) && oldCache[0] === dirruns && oldCache[1] === doneName)
                        return newCache[2] = oldCache[2];
                      if (outerCache[key] = newCache, newCache[2] = matcher(elem, context7, xml))
                        return !0;
                    }
              return !1;
            }
          );
        }
        __name(addCombinator, "addCombinator");
        function elementMatcher(matchers) {
          return matchers.length > 1 ? function(elem, context7, xml) {
            for (var i2 = matchers.length; i2--; )
              if (!matchers[i2](elem, context7, xml))
                return !1;
            return !0;
          } : matchers[0];
        }
        __name(elementMatcher, "elementMatcher");
        function multipleContexts(selector, contexts, results) {
          for (var i2 = 0, len2 = contexts.length; i2 < len2; i2++)
            find2(selector, contexts[i2], results);
          return results;
        }
        __name(multipleContexts, "multipleContexts");
        function condense(unmatched, map2, filter2, context7, xml) {
          for (var elem, newUnmatched = [], i2 = 0, len2 = unmatched.length, mapped = map2 != null; i2 < len2; i2++)
            (elem = unmatched[i2]) && (!filter2 || filter2(elem, context7, xml)) && (newUnmatched.push(elem), mapped && map2.push(i2));
          return newUnmatched;
        }
        __name(condense, "condense");
        function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
          return postFilter && !postFilter[expando2] && (postFilter = setMatcher(postFilter)), postFinder && !postFinder[expando2] && (postFinder = setMatcher(postFinder, postSelector)), markFunction(function(seed, results, context7, xml) {
            var temp, i2, elem, matcherOut, preMap = [], postMap = [], preexisting = results.length, elems = seed || multipleContexts(
              selector || "*",
              context7.nodeType ? [context7] : context7,
              []
            ), matcherIn = preFilter && (seed || !selector) ? condense(elems, preMap, preFilter, context7, xml) : elems;
            if (matcher ? (matcherOut = postFinder || (seed ? preFilter : preexisting || postFilter) ? (
              // ...intermediate processing is necessary
              []
            ) : (
              // ...otherwise use results directly
              results
            ), matcher(matcherIn, matcherOut, context7, xml)) : matcherOut = matcherIn, postFilter)
              for (temp = condense(matcherOut, postMap), postFilter(temp, [], context7, xml), i2 = temp.length; i2--; )
                (elem = temp[i2]) && (matcherOut[postMap[i2]] = !(matcherIn[postMap[i2]] = elem));
            if (seed) {
              if (postFinder || preFilter) {
                if (postFinder) {
                  for (temp = [], i2 = matcherOut.length; i2--; )
                    (elem = matcherOut[i2]) && temp.push(matcherIn[i2] = elem);
                  postFinder(null, matcherOut = [], temp, xml);
                }
                for (i2 = matcherOut.length; i2--; )
                  (elem = matcherOut[i2]) && (temp = postFinder ? indexOf.call(seed, elem) : preMap[i2]) > -1 && (seed[temp] = !(results[temp] = elem));
              }
            } else
              matcherOut = condense(
                matcherOut === results ? matcherOut.splice(preexisting, matcherOut.length) : matcherOut
              ), postFinder ? postFinder(null, results, matcherOut, xml) : push5.apply(results, matcherOut);
          });
        }
        __name(setMatcher, "setMatcher");
        function matcherFromTokens(tokens) {
          for (var checkContext, matcher, j, len2 = tokens.length, leadingRelative = Expr.relative[tokens[0].type], implicitRelative = leadingRelative || Expr.relative[" "], i2 = leadingRelative ? 1 : 0, matchContext = addCombinator(function(elem) {
            return elem === checkContext;
          }, implicitRelative, !0), matchAnyContext = addCombinator(function(elem) {
            return indexOf.call(checkContext, elem) > -1;
          }, implicitRelative, !0), matchers = [function(elem, context7, xml) {
            var ret = !leadingRelative && (xml || context7 != outermostContext) || ((checkContext = context7).nodeType ? matchContext(elem, context7, xml) : matchAnyContext(elem, context7, xml));
            return checkContext = null, ret;
          }]; i2 < len2; i2++)
            if (matcher = Expr.relative[tokens[i2].type])
              matchers = [addCombinator(elementMatcher(matchers), matcher)];
            else {
              if (matcher = Expr.filter[tokens[i2].type].apply(null, tokens[i2].matches), matcher[expando2]) {
                for (j = ++i2; j < len2 && !Expr.relative[tokens[j].type]; j++)
                  ;
                return setMatcher(
                  i2 > 1 && elementMatcher(matchers),
                  i2 > 1 && toSelector(
                    // If the preceding token was a descendant combinator, insert an implicit any-element `*`
                    tokens.slice(0, i2 - 1).concat({ value: tokens[i2 - 2].type === " " ? "*" : "" })
                  ).replace(rtrimCSS, "$1"),
                  matcher,
                  i2 < j && matcherFromTokens(tokens.slice(i2, j)),
                  j < len2 && matcherFromTokens(tokens = tokens.slice(j)),
                  j < len2 && toSelector(tokens)
                );
              }
              matchers.push(matcher);
            }
          return elementMatcher(matchers);
        }
        __name(matcherFromTokens, "matcherFromTokens");
        function matcherFromGroupMatchers(elementMatchers, setMatchers) {
          var bySet = setMatchers.length > 0, byElement = elementMatchers.length > 0, superMatcher = /* @__PURE__ */ __name(function(seed, context7, xml, results, outermost) {
            var elem, j, matcher, matchedCount = 0, i2 = "0", unmatched = seed && [], setMatched = [], contextBackup = outermostContext, elems = seed || byElement && Expr.find.TAG("*", outermost), dirrunsUnique = dirruns += contextBackup == null ? 1 : Math.random() || 0.1, len2 = elems.length;
            for (outermost && (outermostContext = context7 == document3 || context7 || outermost); i2 !== len2 && (elem = elems[i2]) != null; i2++) {
              if (byElement && elem) {
                for (j = 0, !context7 && elem.ownerDocument != document3 && (setDocument(elem), xml = !documentIsHTML); matcher = elementMatchers[j++]; )
                  if (matcher(elem, context7 || document3, xml)) {
                    push5.call(results, elem);
                    break;
                  }
                outermost && (dirruns = dirrunsUnique);
              }
              bySet && ((elem = !matcher && elem) && matchedCount--, seed && unmatched.push(elem));
            }
            if (matchedCount += i2, bySet && i2 !== matchedCount) {
              for (j = 0; matcher = setMatchers[j++]; )
                matcher(unmatched, setMatched, context7, xml);
              if (seed) {
                if (matchedCount > 0)
                  for (; i2--; )
                    unmatched[i2] || setMatched[i2] || (setMatched[i2] = pop.call(results));
                setMatched = condense(setMatched);
              }
              push5.apply(results, setMatched), outermost && !seed && setMatched.length > 0 && matchedCount + setMatchers.length > 1 && jQuery2.uniqueSort(results);
            }
            return outermost && (dirruns = dirrunsUnique, outermostContext = contextBackup), unmatched;
          }, "superMatcher");
          return bySet ? markFunction(superMatcher) : superMatcher;
        }
        __name(matcherFromGroupMatchers, "matcherFromGroupMatchers");
        function compile2(selector, match3) {
          var i2, setMatchers = [], elementMatchers = [], cached2 = compilerCache[selector + " "];
          if (!cached2) {
            for (match3 || (match3 = tokenize(selector)), i2 = match3.length; i2--; )
              cached2 = matcherFromTokens(match3[i2]), cached2[expando2] ? setMatchers.push(cached2) : elementMatchers.push(cached2);
            cached2 = compilerCache(
              selector,
              matcherFromGroupMatchers(elementMatchers, setMatchers)
            ), cached2.selector = selector;
          }
          return cached2;
        }
        __name(compile2, "compile");
        function select4(selector, context7, results, seed) {
          var i2, tokens, token, type2, find3, compiled = typeof selector == "function" && selector, match3 = !seed && tokenize(selector = compiled.selector || selector);
          if (results = results || [], match3.length === 1) {
            if (tokens = match3[0] = match3[0].slice(0), tokens.length > 2 && (token = tokens[0]).type === "ID" && context7.nodeType === 9 && documentIsHTML && Expr.relative[tokens[1].type]) {
              if (context7 = (Expr.find.ID(
                token.matches[0].replace(runescape, funescape),
                context7
              ) || [])[0], context7)
                compiled && (context7 = context7.parentNode);
              else return results;
              selector = selector.slice(tokens.shift().value.length);
            }
            for (i2 = matchExpr.needsContext.test(selector) ? 0 : tokens.length; i2-- && (token = tokens[i2], !Expr.relative[type2 = token.type]); )
              if ((find3 = Expr.find[type2]) && (seed = find3(
                token.matches[0].replace(runescape, funescape),
                rsibling.test(tokens[0].type) && testContext(context7.parentNode) || context7
              ))) {
                if (tokens.splice(i2, 1), selector = seed.length && toSelector(tokens), !selector)
                  return push5.apply(results, seed), results;
                break;
              }
          }
          return (compiled || compile2(selector, match3))(
            seed,
            context7,
            !documentIsHTML,
            results,
            !context7 || rsibling.test(selector) && testContext(context7.parentNode) || context7
          ), results;
        }
        __name(select4, "select"), support2.sortStable = expando2.split("").sort(sortOrder).join("") === expando2, setDocument(), support2.sortDetached = assert2(function(el) {
          return el.compareDocumentPosition(document3.createElement("fieldset")) & 1;
        }), jQuery2.find = find2, jQuery2.expr[":"] = jQuery2.expr.pseudos, jQuery2.unique = jQuery2.uniqueSort, find2.compile = compile2, find2.select = select4, find2.setDocument = setDocument, find2.tokenize = tokenize, find2.escape = jQuery2.escapeSelector, find2.getText = jQuery2.text, find2.isXML = jQuery2.isXMLDoc, find2.selectors = jQuery2.expr, find2.support = jQuery2.support, find2.uniqueSort = jQuery2.uniqueSort;
      })();
      var dir = /* @__PURE__ */ __name(function(elem, dir2, until) {
        for (var matched = [], truncate = until !== void 0; (elem = elem[dir2]) && elem.nodeType !== 9; )
          if (elem.nodeType === 1) {
            if (truncate && jQuery2(elem).is(until))
              break;
            matched.push(elem);
          }
        return matched;
      }, "dir"), siblings = /* @__PURE__ */ __name(function(n2, elem) {
        for (var matched = []; n2; n2 = n2.nextSibling)
          n2.nodeType === 1 && n2 !== elem && matched.push(n2);
        return matched;
      }, "siblings"), rneedsContext = jQuery2.expr.match.needsContext, rsingleTag = /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;
      function winnow(elements, qualifier, not) {
        return isFunction3(qualifier) ? jQuery2.grep(elements, function(elem, i) {
          return !!qualifier.call(elem, i, elem) !== not;
        }) : qualifier.nodeType ? jQuery2.grep(elements, function(elem) {
          return elem === qualifier !== not;
        }) : typeof qualifier != "string" ? jQuery2.grep(elements, function(elem) {
          return indexOf.call(qualifier, elem) > -1 !== not;
        }) : jQuery2.filter(qualifier, elements, not);
      }
      __name(winnow, "winnow"), jQuery2.filter = function(expr, elems, not) {
        var elem = elems[0];
        return not && (expr = ":not(" + expr + ")"), elems.length === 1 && elem.nodeType === 1 ? jQuery2.find.matchesSelector(elem, expr) ? [elem] : [] : jQuery2.find.matches(expr, jQuery2.grep(elems, function(elem2) {
          return elem2.nodeType === 1;
        }));
      }, jQuery2.fn.extend({
        find: /* @__PURE__ */ __name(function(selector) {
          var i, ret, len2 = this.length, self2 = this;
          if (typeof selector != "string")
            return this.pushStack(jQuery2(selector).filter(function() {
              for (i = 0; i < len2; i++)
                if (jQuery2.contains(self2[i], this))
                  return !0;
            }));
          for (ret = this.pushStack([]), i = 0; i < len2; i++)
            jQuery2.find(selector, self2[i], ret);
          return len2 > 1 ? jQuery2.uniqueSort(ret) : ret;
        }, "find"),
        filter: /* @__PURE__ */ __name(function(selector) {
          return this.pushStack(winnow(this, selector || [], !1));
        }, "filter"),
        not: /* @__PURE__ */ __name(function(selector) {
          return this.pushStack(winnow(this, selector || [], !0));
        }, "not"),
        is: /* @__PURE__ */ __name(function(selector) {
          return !!winnow(
            this,
            // If this is a positional/relative selector, check membership in the returned set
            // so $("p:first").is("p:last") won't return true for a doc with two "p".
            typeof selector == "string" && rneedsContext.test(selector) ? jQuery2(selector) : selector || [],
            !1
          ).length;
        }, "is")
      });
      var rootjQuery, rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/, init2 = jQuery2.fn.init = function(selector, context7, root) {
        var match3, elem;
        if (!selector)
          return this;
        if (root = root || rootjQuery, typeof selector == "string")
          if (selector[0] === "<" && selector[selector.length - 1] === ">" && selector.length >= 3 ? match3 = [null, selector, null] : match3 = rquickExpr.exec(selector), match3 && (match3[1] || !context7))
            if (match3[1]) {
              if (context7 = context7 instanceof jQuery2 ? context7[0] : context7, jQuery2.merge(this, jQuery2.parseHTML(
                match3[1],
                context7 && context7.nodeType ? context7.ownerDocument || context7 : document2,
                !0
              )), rsingleTag.test(match3[1]) && jQuery2.isPlainObject(context7))
                for (match3 in context7)
                  isFunction3(this[match3]) ? this[match3](context7[match3]) : this.attr(match3, context7[match3]);
              return this;
            } else
              return elem = document2.getElementById(match3[2]), elem && (this[0] = elem, this.length = 1), this;
          else return !context7 || context7.jquery ? (context7 || root).find(selector) : this.constructor(context7).find(selector);
        else {
          if (selector.nodeType)
            return this[0] = selector, this.length = 1, this;
          if (isFunction3(selector))
            return root.ready !== void 0 ? root.ready(selector) : (
              // Execute immediately if ready is not present
              selector(jQuery2)
            );
        }
        return jQuery2.makeArray(selector, this);
      };
      init2.prototype = jQuery2.fn, rootjQuery = jQuery2(document2);
      var rparentsprev = /^(?:parents|prev(?:Until|All))/, guaranteedUnique = {
        children: !0,
        contents: !0,
        next: !0,
        prev: !0
      };
      jQuery2.fn.extend({
        has: /* @__PURE__ */ __name(function(target2) {
          var targets2 = jQuery2(target2, this), l = targets2.length;
          return this.filter(function() {
            for (var i = 0; i < l; i++)
              if (jQuery2.contains(this, targets2[i]))
                return !0;
          });
        }, "has"),
        closest: /* @__PURE__ */ __name(function(selectors, context7) {
          var cur, i = 0, l = this.length, matched = [], targets2 = typeof selectors != "string" && jQuery2(selectors);
          if (!rneedsContext.test(selectors)) {
            for (; i < l; i++)
              for (cur = this[i]; cur && cur !== context7; cur = cur.parentNode)
                if (cur.nodeType < 11 && (targets2 ? targets2.index(cur) > -1 : (
                  // Don't pass non-elements to jQuery#find
                  cur.nodeType === 1 && jQuery2.find.matchesSelector(cur, selectors)
                ))) {
                  matched.push(cur);
                  break;
                }
          }
          return this.pushStack(matched.length > 1 ? jQuery2.uniqueSort(matched) : matched);
        }, "closest"),
        // Determine the position of an element within the set
        index: /* @__PURE__ */ __name(function(elem) {
          return elem ? typeof elem == "string" ? indexOf.call(jQuery2(elem), this[0]) : indexOf.call(
            this,
            // If it receives a jQuery object, the first element is used
            elem.jquery ? elem[0] : elem
          ) : this[0] && this[0].parentNode ? this.first().prevAll().length : -1;
        }, "index"),
        add: /* @__PURE__ */ __name(function(selector, context7) {
          return this.pushStack(
            jQuery2.uniqueSort(
              jQuery2.merge(this.get(), jQuery2(selector, context7))
            )
          );
        }, "add"),
        addBack: /* @__PURE__ */ __name(function(selector) {
          return this.add(
            selector == null ? this.prevObject : this.prevObject.filter(selector)
          );
        }, "addBack")
      });
      function sibling(cur, dir2) {
        for (; (cur = cur[dir2]) && cur.nodeType !== 1; )
          ;
        return cur;
      }
      __name(sibling, "sibling"), jQuery2.each({
        parent: /* @__PURE__ */ __name(function(elem) {
          var parent = elem.parentNode;
          return parent && parent.nodeType !== 11 ? parent : null;
        }, "parent"),
        parents: /* @__PURE__ */ __name(function(elem) {
          return dir(elem, "parentNode");
        }, "parents"),
        parentsUntil: /* @__PURE__ */ __name(function(elem, _i, until) {
          return dir(elem, "parentNode", until);
        }, "parentsUntil"),
        next: /* @__PURE__ */ __name(function(elem) {
          return sibling(elem, "nextSibling");
        }, "next"),
        prev: /* @__PURE__ */ __name(function(elem) {
          return sibling(elem, "previousSibling");
        }, "prev"),
        nextAll: /* @__PURE__ */ __name(function(elem) {
          return dir(elem, "nextSibling");
        }, "nextAll"),
        prevAll: /* @__PURE__ */ __name(function(elem) {
          return dir(elem, "previousSibling");
        }, "prevAll"),
        nextUntil: /* @__PURE__ */ __name(function(elem, _i, until) {
          return dir(elem, "nextSibling", until);
        }, "nextUntil"),
        prevUntil: /* @__PURE__ */ __name(function(elem, _i, until) {
          return dir(elem, "previousSibling", until);
        }, "prevUntil"),
        siblings: /* @__PURE__ */ __name(function(elem) {
          return siblings((elem.parentNode || {}).firstChild, elem);
        }, "siblings"),
        children: /* @__PURE__ */ __name(function(elem) {
          return siblings(elem.firstChild);
        }, "children"),
        contents: /* @__PURE__ */ __name(function(elem) {
          return elem.contentDocument != null && // Support: IE 11+
          // <object> elements with no `data` attribute has an object
          // `contentDocument` with a `null` prototype.
          getProto(elem.contentDocument) ? elem.contentDocument : (nodeName(elem, "template") && (elem = elem.content || elem), jQuery2.merge([], elem.childNodes));
        }, "contents")
      }, function(name2, fn2) {
        jQuery2.fn[name2] = function(until, selector) {
          var matched = jQuery2.map(this, fn2, until);
          return name2.slice(-5) !== "Until" && (selector = until), selector && typeof selector == "string" && (matched = jQuery2.filter(selector, matched)), this.length > 1 && (guaranteedUnique[name2] || jQuery2.uniqueSort(matched), rparentsprev.test(name2) && matched.reverse()), this.pushStack(matched);
        };
      });
      var rnothtmlwhite = /[^\x20\t\r\n\f]+/g;
      function createOptions(options2) {
        var object = {};
        return jQuery2.each(options2.match(rnothtmlwhite) || [], function(_2, flag3) {
          object[flag3] = !0;
        }), object;
      }
      __name(createOptions, "createOptions"), jQuery2.Callbacks = function(options2) {
        options2 = typeof options2 == "string" ? createOptions(options2) : jQuery2.extend({}, options2);
        var firing, memory, fired, locked, list = [], queue2 = [], firingIndex = -1, fire = /* @__PURE__ */ __name(function() {
          for (locked = locked || options2.once, fired = firing = !0; queue2.length; firingIndex = -1)
            for (memory = queue2.shift(); ++firingIndex < list.length; )
              list[firingIndex].apply(memory[0], memory[1]) === !1 && options2.stopOnFalse && (firingIndex = list.length, memory = !1);
          options2.memory || (memory = !1), firing = !1, locked && (memory ? list = [] : list = "");
        }, "fire"), self2 = {
          // Add a callback or a collection of callbacks to the list
          add: /* @__PURE__ */ __name(function() {
            return list && (memory && !firing && (firingIndex = list.length - 1, queue2.push(memory)), (/* @__PURE__ */ __name(function add4(args) {
              jQuery2.each(args, function(_2, arg) {
                isFunction3(arg) ? (!options2.unique || !self2.has(arg)) && list.push(arg) : arg && arg.length && toType4(arg) !== "string" && add4(arg);
              });
            }, "add"))(arguments), memory && !firing && fire()), this;
          }, "add"),
          // Remove a callback from the list
          remove: /* @__PURE__ */ __name(function() {
            return jQuery2.each(arguments, function(_2, arg) {
              for (var index3; (index3 = jQuery2.inArray(arg, list, index3)) > -1; )
                list.splice(index3, 1), index3 <= firingIndex && firingIndex--;
            }), this;
          }, "remove"),
          // Check if a given callback is in the list.
          // If no argument is given, return whether or not list has callbacks attached.
          has: /* @__PURE__ */ __name(function(fn2) {
            return fn2 ? jQuery2.inArray(fn2, list) > -1 : list.length > 0;
          }, "has"),
          // Remove all callbacks from the list
          empty: /* @__PURE__ */ __name(function() {
            return list && (list = []), this;
          }, "empty"),
          // Disable .fire and .add
          // Abort any current/pending executions
          // Clear all callbacks and values
          disable: /* @__PURE__ */ __name(function() {
            return locked = queue2 = [], list = memory = "", this;
          }, "disable"),
          disabled: /* @__PURE__ */ __name(function() {
            return !list;
          }, "disabled"),
          // Disable .fire
          // Also disable .add unless we have memory (since it would have no effect)
          // Abort any pending executions
          lock: /* @__PURE__ */ __name(function() {
            return locked = queue2 = [], !memory && !firing && (list = memory = ""), this;
          }, "lock"),
          locked: /* @__PURE__ */ __name(function() {
            return !!locked;
          }, "locked"),
          // Call all callbacks with the given context and arguments
          fireWith: /* @__PURE__ */ __name(function(context7, args) {
            return locked || (args = args || [], args = [context7, args.slice ? args.slice() : args], queue2.push(args), firing || fire()), this;
          }, "fireWith"),
          // Call all the callbacks with the given arguments
          fire: /* @__PURE__ */ __name(function() {
            return self2.fireWith(this, arguments), this;
          }, "fire"),
          // To know if the callbacks have already been called at least once
          fired: /* @__PURE__ */ __name(function() {
            return !!fired;
          }, "fired")
        };
        return self2;
      };
      function Identity(v) {
        return v;
      }
      __name(Identity, "Identity");
      function Thrower(ex) {
        throw ex;
      }
      __name(Thrower, "Thrower");
      function adoptValue(value3, resolve2, reject, noValue) {
        var method;
        try {
          value3 && isFunction3(method = value3.promise) ? method.call(value3).done(resolve2).fail(reject) : value3 && isFunction3(method = value3.then) ? method.call(value3, resolve2, reject) : resolve2.apply(void 0, [value3].slice(noValue));
        } catch (value4) {
          reject.apply(void 0, [value4]);
        }
      }
      __name(adoptValue, "adoptValue"), jQuery2.extend({
        Deferred: /* @__PURE__ */ __name(function(func) {
          var tuples = [
            // action, add listener, callbacks,
            // ... .then handlers, argument index, [final state]
            [
              "notify",
              "progress",
              jQuery2.Callbacks("memory"),
              jQuery2.Callbacks("memory"),
              2
            ],
            [
              "resolve",
              "done",
              jQuery2.Callbacks("once memory"),
              jQuery2.Callbacks("once memory"),
              0,
              "resolved"
            ],
            [
              "reject",
              "fail",
              jQuery2.Callbacks("once memory"),
              jQuery2.Callbacks("once memory"),
              1,
              "rejected"
            ]
          ], state = "pending", promise = {
            state: /* @__PURE__ */ __name(function() {
              return state;
            }, "state"),
            always: /* @__PURE__ */ __name(function() {
              return deferred.done(arguments).fail(arguments), this;
            }, "always"),
            catch: /* @__PURE__ */ __name(function(fn2) {
              return promise.then(null, fn2);
            }, "catch"),
            // Keep pipe for back-compat
            pipe: /* @__PURE__ */ __name(function() {
              var fns = arguments;
              return jQuery2.Deferred(function(newDefer) {
                jQuery2.each(tuples, function(_i, tuple) {
                  var fn2 = isFunction3(fns[tuple[4]]) && fns[tuple[4]];
                  deferred[tuple[1]](function() {
                    var returned = fn2 && fn2.apply(this, arguments);
                    returned && isFunction3(returned.promise) ? returned.promise().progress(newDefer.notify).done(newDefer.resolve).fail(newDefer.reject) : newDefer[tuple[0] + "With"](
                      this,
                      fn2 ? [returned] : arguments
                    );
                  });
                }), fns = null;
              }).promise();
            }, "pipe"),
            then: /* @__PURE__ */ __name(function(onFulfilled, onRejected, onProgress) {
              var maxDepth = 0;
              function resolve2(depth, deferred2, handler4, special) {
                return function() {
                  var that = this, args = arguments, mightThrow = /* @__PURE__ */ __name(function() {
                    var returned, then;
                    if (!(depth < maxDepth)) {
                      if (returned = handler4.apply(that, args), returned === deferred2.promise())
                        throw new TypeError("Thenable self-resolution");
                      then = returned && // Support: Promises/A+ section 2.3.4
                      // https://promisesaplus.com/#point-64
                      // Only check objects and functions for thenability
                      (typeof returned == "object" || typeof returned == "function") && returned.then, isFunction3(then) ? special ? then.call(
                        returned,
                        resolve2(maxDepth, deferred2, Identity, special),
                        resolve2(maxDepth, deferred2, Thrower, special)
                      ) : (maxDepth++, then.call(
                        returned,
                        resolve2(maxDepth, deferred2, Identity, special),
                        resolve2(maxDepth, deferred2, Thrower, special),
                        resolve2(
                          maxDepth,
                          deferred2,
                          Identity,
                          deferred2.notifyWith
                        )
                      )) : (handler4 !== Identity && (that = void 0, args = [returned]), (special || deferred2.resolveWith)(that, args));
                    }
                  }, "mightThrow"), process2 = special ? mightThrow : function() {
                    try {
                      mightThrow();
                    } catch (e2) {
                      jQuery2.Deferred.exceptionHook && jQuery2.Deferred.exceptionHook(
                        e2,
                        process2.error
                      ), depth + 1 >= maxDepth && (handler4 !== Thrower && (that = void 0, args = [e2]), deferred2.rejectWith(that, args));
                    }
                  };
                  depth ? process2() : (jQuery2.Deferred.getErrorHook ? process2.error = jQuery2.Deferred.getErrorHook() : jQuery2.Deferred.getStackHook && (process2.error = jQuery2.Deferred.getStackHook()), window2.setTimeout(process2));
                };
              }
              return __name(resolve2, "resolve"), jQuery2.Deferred(function(newDefer) {
                tuples[0][3].add(
                  resolve2(
                    0,
                    newDefer,
                    isFunction3(onProgress) ? onProgress : Identity,
                    newDefer.notifyWith
                  )
                ), tuples[1][3].add(
                  resolve2(
                    0,
                    newDefer,
                    isFunction3(onFulfilled) ? onFulfilled : Identity
                  )
                ), tuples[2][3].add(
                  resolve2(
                    0,
                    newDefer,
                    isFunction3(onRejected) ? onRejected : Thrower
                  )
                );
              }).promise();
            }, "then"),
            // Get a promise for this deferred
            // If obj is provided, the promise aspect is added to the object
            promise: /* @__PURE__ */ __name(function(obj2) {
              return obj2 != null ? jQuery2.extend(obj2, promise) : promise;
            }, "promise")
          }, deferred = {};
          return jQuery2.each(tuples, function(i, tuple) {
            var list = tuple[2], stateString = tuple[5];
            promise[tuple[1]] = list.add, stateString && list.add(
              function() {
                state = stateString;
              },
              // rejected_callbacks.disable
              // fulfilled_callbacks.disable
              tuples[3 - i][2].disable,
              // rejected_handlers.disable
              // fulfilled_handlers.disable
              tuples[3 - i][3].disable,
              // progress_callbacks.lock
              tuples[0][2].lock,
              // progress_handlers.lock
              tuples[0][3].lock
            ), list.add(tuple[3].fire), deferred[tuple[0]] = function() {
              return deferred[tuple[0] + "With"](this === deferred ? void 0 : this, arguments), this;
            }, deferred[tuple[0] + "With"] = list.fireWith;
          }), promise.promise(deferred), func && func.call(deferred, deferred), deferred;
        }, "Deferred"),
        // Deferred helper
        when: /* @__PURE__ */ __name(function(singleValue) {
          var remaining = arguments.length, i = remaining, resolveContexts = Array(i), resolveValues = slice.call(arguments), primary = jQuery2.Deferred(), updateFunc = /* @__PURE__ */ __name(function(i2) {
            return function(value3) {
              resolveContexts[i2] = this, resolveValues[i2] = arguments.length > 1 ? slice.call(arguments) : value3, --remaining || primary.resolveWith(resolveContexts, resolveValues);
            };
          }, "updateFunc");
          if (remaining <= 1 && (adoptValue(
            singleValue,
            primary.done(updateFunc(i)).resolve,
            primary.reject,
            !remaining
          ), primary.state() === "pending" || isFunction3(resolveValues[i] && resolveValues[i].then)))
            return primary.then();
          for (; i--; )
            adoptValue(resolveValues[i], updateFunc(i), primary.reject);
          return primary.promise();
        }, "when")
      });
      var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;
      jQuery2.Deferred.exceptionHook = function(error2, asyncError) {
        window2.console && window2.console.warn && error2 && rerrorNames.test(error2.name) && window2.console.warn(
          "jQuery.Deferred exception: " + error2.message,
          error2.stack,
          asyncError
        );
      }, jQuery2.readyException = function(error2) {
        window2.setTimeout(function() {
          throw error2;
        });
      };
      var readyList = jQuery2.Deferred();
      jQuery2.fn.ready = function(fn2) {
        return readyList.then(fn2).catch(function(error2) {
          jQuery2.readyException(error2);
        }), this;
      }, jQuery2.extend({
        // Is the DOM ready to be used? Set to true once it occurs.
        isReady: !1,
        // A counter to track how many items to wait for before
        // the ready event fires. See trac-6781
        readyWait: 1,
        // Handle when the DOM is ready
        ready: /* @__PURE__ */ __name(function(wait) {
          (wait === !0 ? --jQuery2.readyWait : jQuery2.isReady) || (jQuery2.isReady = !0, !(wait !== !0 && --jQuery2.readyWait > 0) && readyList.resolveWith(document2, [jQuery2]));
        }, "ready")
      }), jQuery2.ready.then = readyList.then;
      function completed() {
        document2.removeEventListener("DOMContentLoaded", completed), window2.removeEventListener("load", completed), jQuery2.ready();
      }
      __name(completed, "completed"), document2.readyState === "complete" || document2.readyState !== "loading" && !document2.documentElement.doScroll ? window2.setTimeout(jQuery2.ready) : (document2.addEventListener("DOMContentLoaded", completed), window2.addEventListener("load", completed));
      var access = /* @__PURE__ */ __name(function(elems, fn2, key, value3, chainable, emptyGet, raw) {
        var i = 0, len2 = elems.length, bulk = key == null;
        if (toType4(key) === "object") {
          chainable = !0;
          for (i in key)
            access(elems, fn2, i, key[i], !0, emptyGet, raw);
        } else if (value3 !== void 0 && (chainable = !0, isFunction3(value3) || (raw = !0), bulk && (raw ? (fn2.call(elems, value3), fn2 = null) : (bulk = fn2, fn2 = /* @__PURE__ */ __name(function(elem, _key2, value4) {
          return bulk.call(jQuery2(elem), value4);
        }, "fn"))), fn2))
          for (; i < len2; i++)
            fn2(
              elems[i],
              key,
              raw ? value3 : value3.call(elems[i], i, fn2(elems[i], key))
            );
        return chainable ? elems : bulk ? fn2.call(elems) : len2 ? fn2(elems[0], key) : emptyGet;
      }, "access"), rmsPrefix = /^-ms-/, rdashAlpha = /-([a-z])/g;
      function fcamelCase(_all, letter) {
        return letter.toUpperCase();
      }
      __name(fcamelCase, "fcamelCase");
      function camelCase(string) {
        return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase);
      }
      __name(camelCase, "camelCase");
      var acceptData = /* @__PURE__ */ __name(function(owner) {
        return owner.nodeType === 1 || owner.nodeType === 9 || !+owner.nodeType;
      }, "acceptData");
      function Data() {
        this.expando = jQuery2.expando + Data.uid++;
      }
      __name(Data, "Data"), Data.uid = 1, Data.prototype = {
        cache: /* @__PURE__ */ __name(function(owner) {
          var value3 = owner[this.expando];
          return value3 || (value3 = {}, acceptData(owner) && (owner.nodeType ? owner[this.expando] = value3 : Object.defineProperty(owner, this.expando, {
            value: value3,
            configurable: !0
          }))), value3;
        }, "cache"),
        set: /* @__PURE__ */ __name(function(owner, data49, value3) {
          var prop2, cache = this.cache(owner);
          if (typeof data49 == "string")
            cache[camelCase(data49)] = value3;
          else
            for (prop2 in data49)
              cache[camelCase(prop2)] = data49[prop2];
          return cache;
        }, "set"),
        get: /* @__PURE__ */ __name(function(owner, key) {
          return key === void 0 ? this.cache(owner) : (
            // Always use camelCase key (gh-2257)
            owner[this.expando] && owner[this.expando][camelCase(key)]
          );
        }, "get"),
        access: /* @__PURE__ */ __name(function(owner, key, value3) {
          return key === void 0 || key && typeof key == "string" && value3 === void 0 ? this.get(owner, key) : (this.set(owner, key, value3), value3 !== void 0 ? value3 : key);
        }, "access"),
        remove: /* @__PURE__ */ __name(function(owner, key) {
          var i, cache = owner[this.expando];
          if (cache !== void 0) {
            if (key !== void 0)
              for (Array.isArray(key) ? key = key.map(camelCase) : (key = camelCase(key), key = key in cache ? [key] : key.match(rnothtmlwhite) || []), i = key.length; i--; )
                delete cache[key[i]];
            (key === void 0 || jQuery2.isEmptyObject(cache)) && (owner.nodeType ? owner[this.expando] = void 0 : delete owner[this.expando]);
          }
        }, "remove"),
        hasData: /* @__PURE__ */ __name(function(owner) {
          var cache = owner[this.expando];
          return cache !== void 0 && !jQuery2.isEmptyObject(cache);
        }, "hasData")
      };
      var dataPriv = new Data(), dataUser = new Data(), rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/, rmultiDash = /[A-Z]/g;
      function getData2(data49) {
        return data49 === "true" ? !0 : data49 === "false" ? !1 : data49 === "null" ? null : data49 === +data49 + "" ? +data49 : rbrace.test(data49) ? JSON.parse(data49) : data49;
      }
      __name(getData2, "getData");
      function dataAttr(elem, key, data49) {
        var name2;
        if (data49 === void 0 && elem.nodeType === 1)
          if (name2 = "data-" + key.replace(rmultiDash, "-$&").toLowerCase(), data49 = elem.getAttribute(name2), typeof data49 == "string") {
            try {
              data49 = getData2(data49);
            } catch {
            }
            dataUser.set(elem, key, data49);
          } else
            data49 = void 0;
        return data49;
      }
      __name(dataAttr, "dataAttr"), jQuery2.extend({
        hasData: /* @__PURE__ */ __name(function(elem) {
          return dataUser.hasData(elem) || dataPriv.hasData(elem);
        }, "hasData"),
        data: /* @__PURE__ */ __name(function(elem, name2, data49) {
          return dataUser.access(elem, name2, data49);
        }, "data"),
        removeData: /* @__PURE__ */ __name(function(elem, name2) {
          dataUser.remove(elem, name2);
        }, "removeData"),
        // TODO: Now that all calls to _data and _removeData have been replaced
        // with direct calls to dataPriv methods, these can be deprecated.
        _data: /* @__PURE__ */ __name(function(elem, name2, data49) {
          return dataPriv.access(elem, name2, data49);
        }, "_data"),
        _removeData: /* @__PURE__ */ __name(function(elem, name2) {
          dataPriv.remove(elem, name2);
        }, "_removeData")
      }), jQuery2.fn.extend({
        data: /* @__PURE__ */ __name(function(key, value3) {
          var i, name2, data49, elem = this[0], attrs2 = elem && elem.attributes;
          if (key === void 0) {
            if (this.length && (data49 = dataUser.get(elem), elem.nodeType === 1 && !dataPriv.get(elem, "hasDataAttrs"))) {
              for (i = attrs2.length; i--; )
                attrs2[i] && (name2 = attrs2[i].name, name2.indexOf("data-") === 0 && (name2 = camelCase(name2.slice(5)), dataAttr(elem, name2, data49[name2])));
              dataPriv.set(elem, "hasDataAttrs", !0);
            }
            return data49;
          }
          return typeof key == "object" ? this.each(function() {
            dataUser.set(this, key);
          }) : access(this, function(value4) {
            var data50;
            if (elem && value4 === void 0)
              return data50 = dataUser.get(elem, key), data50 !== void 0 || (data50 = dataAttr(elem, key), data50 !== void 0) ? data50 : void 0;
            this.each(function() {
              dataUser.set(this, key, value4);
            });
          }, null, value3, arguments.length > 1, null, !0);
        }, "data"),
        removeData: /* @__PURE__ */ __name(function(key) {
          return this.each(function() {
            dataUser.remove(this, key);
          });
        }, "removeData")
      }), jQuery2.extend({
        queue: /* @__PURE__ */ __name(function(elem, type2, data49) {
          var queue2;
          if (elem)
            return type2 = (type2 || "fx") + "queue", queue2 = dataPriv.get(elem, type2), data49 && (!queue2 || Array.isArray(data49) ? queue2 = dataPriv.access(elem, type2, jQuery2.makeArray(data49)) : queue2.push(data49)), queue2 || [];
        }, "queue"),
        dequeue: /* @__PURE__ */ __name(function(elem, type2) {
          type2 = type2 || "fx";
          var queue2 = jQuery2.queue(elem, type2), startLength = queue2.length, fn2 = queue2.shift(), hooks2 = jQuery2._queueHooks(elem, type2), next3 = /* @__PURE__ */ __name(function() {
            jQuery2.dequeue(elem, type2);
          }, "next");
          fn2 === "inprogress" && (fn2 = queue2.shift(), startLength--), fn2 && (type2 === "fx" && queue2.unshift("inprogress"), delete hooks2.stop, fn2.call(elem, next3, hooks2)), !startLength && hooks2 && hooks2.empty.fire();
        }, "dequeue"),
        // Not public - generate a queueHooks object, or return the current one
        _queueHooks: /* @__PURE__ */ __name(function(elem, type2) {
          var key = type2 + "queueHooks";
          return dataPriv.get(elem, key) || dataPriv.access(elem, key, {
            empty: jQuery2.Callbacks("once memory").add(function() {
              dataPriv.remove(elem, [type2 + "queue", key]);
            })
          });
        }, "_queueHooks")
      }), jQuery2.fn.extend({
        queue: /* @__PURE__ */ __name(function(type2, data49) {
          var setter = 2;
          return typeof type2 != "string" && (data49 = type2, type2 = "fx", setter--), arguments.length < setter ? jQuery2.queue(this[0], type2) : data49 === void 0 ? this : this.each(function() {
            var queue2 = jQuery2.queue(this, type2, data49);
            jQuery2._queueHooks(this, type2), type2 === "fx" && queue2[0] !== "inprogress" && jQuery2.dequeue(this, type2);
          });
        }, "queue"),
        dequeue: /* @__PURE__ */ __name(function(type2) {
          return this.each(function() {
            jQuery2.dequeue(this, type2);
          });
        }, "dequeue"),
        clearQueue: /* @__PURE__ */ __name(function(type2) {
          return this.queue(type2 || "fx", []);
        }, "clearQueue"),
        // Get a promise resolved when queues of a certain type
        // are emptied (fx is the type by default)
        promise: /* @__PURE__ */ __name(function(type2, obj2) {
          var tmp, count2 = 1, defer = jQuery2.Deferred(), elements = this, i = this.length, resolve2 = /* @__PURE__ */ __name(function() {
            --count2 || defer.resolveWith(elements, [elements]);
          }, "resolve");
          for (typeof type2 != "string" && (obj2 = type2, type2 = void 0), type2 = type2 || "fx"; i--; )
            tmp = dataPriv.get(elements[i], type2 + "queueHooks"), tmp && tmp.empty && (count2++, tmp.empty.add(resolve2));
          return resolve2(), defer.promise(obj2);
        }, "promise")
      });
      var pnum = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source, rcssNum = new RegExp("^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i"), cssExpand = ["Top", "Right", "Bottom", "Left"], documentElement = document2.documentElement, isAttached = /* @__PURE__ */ __name(function(elem) {
        return jQuery2.contains(elem.ownerDocument, elem);
      }, "isAttached"), composed = { composed: !0 };
      documentElement.getRootNode && (isAttached = /* @__PURE__ */ __name(function(elem) {
        return jQuery2.contains(elem.ownerDocument, elem) || elem.getRootNode(composed) === elem.ownerDocument;
      }, "isAttached"));
      var isHiddenWithinTree = /* @__PURE__ */ __name(function(elem, el) {
        return elem = el || elem, elem.style.display === "none" || elem.style.display === "" && // Otherwise, check computed style
        // Support: Firefox <=43 - 45
        // Disconnected elements can have computed display: none, so first confirm that elem is
        // in the document.
        isAttached(elem) && jQuery2.css(elem, "display") === "none";
      }, "isHiddenWithinTree");
      function adjustCSS(elem, prop2, valueParts, tween) {
        var adjusted, scale, maxIterations = 20, currentValue = tween ? function() {
          return tween.cur();
        } : function() {
          return jQuery2.css(elem, prop2, "");
        }, initial2 = currentValue(), unit = valueParts && valueParts[3] || (jQuery2.cssNumber[prop2] ? "" : "px"), initialInUnit = elem.nodeType && (jQuery2.cssNumber[prop2] || unit !== "px" && +initial2) && rcssNum.exec(jQuery2.css(elem, prop2));
        if (initialInUnit && initialInUnit[3] !== unit) {
          for (initial2 = initial2 / 2, unit = unit || initialInUnit[3], initialInUnit = +initial2 || 1; maxIterations--; )
            jQuery2.style(elem, prop2, initialInUnit + unit), (1 - scale) * (1 - (scale = currentValue() / initial2 || 0.5)) <= 0 && (maxIterations = 0), initialInUnit = initialInUnit / scale;
          initialInUnit = initialInUnit * 2, jQuery2.style(elem, prop2, initialInUnit + unit), valueParts = valueParts || [];
        }
        return valueParts && (initialInUnit = +initialInUnit || +initial2 || 0, adjusted = valueParts[1] ? initialInUnit + (valueParts[1] + 1) * valueParts[2] : +valueParts[2], tween && (tween.unit = unit, tween.start = initialInUnit, tween.end = adjusted)), adjusted;
      }
      __name(adjustCSS, "adjustCSS");
      var defaultDisplayMap = {};
      function getDefaultDisplay(elem) {
        var temp, doc = elem.ownerDocument, nodeName2 = elem.nodeName, display = defaultDisplayMap[nodeName2];
        return display || (temp = doc.body.appendChild(doc.createElement(nodeName2)), display = jQuery2.css(temp, "display"), temp.parentNode.removeChild(temp), display === "none" && (display = "block"), defaultDisplayMap[nodeName2] = display, display);
      }
      __name(getDefaultDisplay, "getDefaultDisplay");
      function showHide(elements, show7) {
        for (var display, elem, values2 = [], index3 = 0, length2 = elements.length; index3 < length2; index3++)
          elem = elements[index3], elem.style && (display = elem.style.display, show7 ? (display === "none" && (values2[index3] = dataPriv.get(elem, "display") || null, values2[index3] || (elem.style.display = "")), elem.style.display === "" && isHiddenWithinTree(elem) && (values2[index3] = getDefaultDisplay(elem))) : display !== "none" && (values2[index3] = "none", dataPriv.set(elem, "display", display)));
        for (index3 = 0; index3 < length2; index3++)
          values2[index3] != null && (elements[index3].style.display = values2[index3]);
        return elements;
      }
      __name(showHide, "showHide"), jQuery2.fn.extend({
        show: /* @__PURE__ */ __name(function() {
          return showHide(this, !0);
        }, "show"),
        hide: /* @__PURE__ */ __name(function() {
          return showHide(this);
        }, "hide"),
        toggle: /* @__PURE__ */ __name(function(state) {
          return typeof state == "boolean" ? state ? this.show() : this.hide() : this.each(function() {
            isHiddenWithinTree(this) ? jQuery2(this).show() : jQuery2(this).hide();
          });
        }, "toggle")
      });
      var rcheckableType = /^(?:checkbox|radio)$/i, rtagName = /<([a-z][^\/\0>\x20\t\r\n\f]*)/i, rscriptType = /^$|^module$|\/(?:java|ecma)script/i;
      (function() {
        var fragment = document2.createDocumentFragment(), div2 = fragment.appendChild(document2.createElement("div")), input = document2.createElement("input");
        input.setAttribute("type", "radio"), input.setAttribute("checked", "checked"), input.setAttribute("name", "t"), div2.appendChild(input), support2.checkClone = div2.cloneNode(!0).cloneNode(!0).lastChild.checked, div2.innerHTML = "<textarea>x</textarea>", support2.noCloneChecked = !!div2.cloneNode(!0).lastChild.defaultValue, div2.innerHTML = "<option></option>", support2.option = !!div2.lastChild;
      })();
      var wrapMap = {
        // XHTML parsers do not magically insert elements in the
        // same way that tag soup parsers do. So we cannot shorten
        // this by omitting <tbody> or other required elements.
        thead: [1, "<table>", "</table>"],
        col: [2, "<table><colgroup>", "</colgroup></table>"],
        tr: [2, "<table><tbody>", "</tbody></table>"],
        td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
        _default: [0, "", ""]
      };
      wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead, wrapMap.th = wrapMap.td, support2.option || (wrapMap.optgroup = wrapMap.option = [1, "<select multiple='multiple'>", "</select>"]);
      function getAll(context7, tag3) {
        var ret;
        return typeof context7.getElementsByTagName < "u" ? ret = context7.getElementsByTagName(tag3 || "*") : typeof context7.querySelectorAll < "u" ? ret = context7.querySelectorAll(tag3 || "*") : ret = [], tag3 === void 0 || tag3 && nodeName(context7, tag3) ? jQuery2.merge([context7], ret) : ret;
      }
      __name(getAll, "getAll");
      function setGlobalEval(elems, refElements) {
        for (var i = 0, l = elems.length; i < l; i++)
          dataPriv.set(
            elems[i],
            "globalEval",
            !refElements || dataPriv.get(refElements[i], "globalEval")
          );
      }
      __name(setGlobalEval, "setGlobalEval");
      var rhtml = /<|&#?\w+;/;
      function buildFragment(elems, context7, scripts, selection, ignored) {
        for (var elem, tmp, tag3, wrap, attached, j, fragment = context7.createDocumentFragment(), nodes = [], i = 0, l = elems.length; i < l; i++)
          if (elem = elems[i], elem || elem === 0)
            if (toType4(elem) === "object")
              jQuery2.merge(nodes, elem.nodeType ? [elem] : elem);
            else if (!rhtml.test(elem))
              nodes.push(context7.createTextNode(elem));
            else {
              for (tmp = tmp || fragment.appendChild(context7.createElement("div")), tag3 = (rtagName.exec(elem) || ["", ""])[1].toLowerCase(), wrap = wrapMap[tag3] || wrapMap._default, tmp.innerHTML = wrap[1] + jQuery2.htmlPrefilter(elem) + wrap[2], j = wrap[0]; j--; )
                tmp = tmp.lastChild;
              jQuery2.merge(nodes, tmp.childNodes), tmp = fragment.firstChild, tmp.textContent = "";
            }
        for (fragment.textContent = "", i = 0; elem = nodes[i++]; ) {
          if (selection && jQuery2.inArray(elem, selection) > -1) {
            ignored && ignored.push(elem);
            continue;
          }
          if (attached = isAttached(elem), tmp = getAll(fragment.appendChild(elem), "script"), attached && setGlobalEval(tmp), scripts)
            for (j = 0; elem = tmp[j++]; )
              rscriptType.test(elem.type || "") && scripts.push(elem);
        }
        return fragment;
      }
      __name(buildFragment, "buildFragment");
      var rtypenamespace = /^([^.]*)(?:\.(.+)|)/;
      function returnTrue() {
        return !0;
      }
      __name(returnTrue, "returnTrue");
      function returnFalse() {
        return !1;
      }
      __name(returnFalse, "returnFalse");
      function on2(elem, types2, selector, data49, fn2, one) {
        var origFn, type2;
        if (typeof types2 == "object") {
          typeof selector != "string" && (data49 = data49 || selector, selector = void 0);
          for (type2 in types2)
            on2(elem, type2, selector, data49, types2[type2], one);
          return elem;
        }
        if (data49 == null && fn2 == null ? (fn2 = selector, data49 = selector = void 0) : fn2 == null && (typeof selector == "string" ? (fn2 = data49, data49 = void 0) : (fn2 = data49, data49 = selector, selector = void 0)), fn2 === !1)
          fn2 = returnFalse;
        else if (!fn2)
          return elem;
        return one === 1 && (origFn = fn2, fn2 = /* @__PURE__ */ __name(function(event2) {
          return jQuery2().off(event2), origFn.apply(this, arguments);
        }, "fn"), fn2.guid = origFn.guid || (origFn.guid = jQuery2.guid++)), elem.each(function() {
          jQuery2.event.add(this, types2, fn2, data49, selector);
        });
      }
      __name(on2, "on"), jQuery2.event = {
        global: {},
        add: /* @__PURE__ */ __name(function(elem, types2, handler4, data49, selector) {
          var handleObjIn, eventHandle, tmp, events2, t2, handleObj, special, handlers, type2, namespaces, origType, elemData = dataPriv.get(elem);
          if (acceptData(elem))
            for (handler4.handler && (handleObjIn = handler4, handler4 = handleObjIn.handler, selector = handleObjIn.selector), selector && jQuery2.find.matchesSelector(documentElement, selector), handler4.guid || (handler4.guid = jQuery2.guid++), (events2 = elemData.events) || (events2 = elemData.events = /* @__PURE__ */ Object.create(null)), (eventHandle = elemData.handle) || (eventHandle = elemData.handle = function(e2) {
              return typeof jQuery2 < "u" && jQuery2.event.triggered !== e2.type ? jQuery2.event.dispatch.apply(elem, arguments) : void 0;
            }), types2 = (types2 || "").match(rnothtmlwhite) || [""], t2 = types2.length; t2--; )
              tmp = rtypenamespace.exec(types2[t2]) || [], type2 = origType = tmp[1], namespaces = (tmp[2] || "").split(".").sort(), type2 && (special = jQuery2.event.special[type2] || {}, type2 = (selector ? special.delegateType : special.bindType) || type2, special = jQuery2.event.special[type2] || {}, handleObj = jQuery2.extend({
                type: type2,
                origType,
                data: data49,
                handler: handler4,
                guid: handler4.guid,
                selector,
                needsContext: selector && jQuery2.expr.match.needsContext.test(selector),
                namespace: namespaces.join(".")
              }, handleObjIn), (handlers = events2[type2]) || (handlers = events2[type2] = [], handlers.delegateCount = 0, (!special.setup || special.setup.call(elem, data49, namespaces, eventHandle) === !1) && elem.addEventListener && elem.addEventListener(type2, eventHandle)), special.add && (special.add.call(elem, handleObj), handleObj.handler.guid || (handleObj.handler.guid = handler4.guid)), selector ? handlers.splice(handlers.delegateCount++, 0, handleObj) : handlers.push(handleObj), jQuery2.event.global[type2] = !0);
        }, "add"),
        // Detach an event or set of events from an element
        remove: /* @__PURE__ */ __name(function(elem, types2, handler4, selector, mappedTypes) {
          var j, origCount, tmp, events2, t2, handleObj, special, handlers, type2, namespaces, origType, elemData = dataPriv.hasData(elem) && dataPriv.get(elem);
          if (!(!elemData || !(events2 = elemData.events))) {
            for (types2 = (types2 || "").match(rnothtmlwhite) || [""], t2 = types2.length; t2--; ) {
              if (tmp = rtypenamespace.exec(types2[t2]) || [], type2 = origType = tmp[1], namespaces = (tmp[2] || "").split(".").sort(), !type2) {
                for (type2 in events2)
                  jQuery2.event.remove(elem, type2 + types2[t2], handler4, selector, !0);
                continue;
              }
              for (special = jQuery2.event.special[type2] || {}, type2 = (selector ? special.delegateType : special.bindType) || type2, handlers = events2[type2] || [], tmp = tmp[2] && new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)"), origCount = j = handlers.length; j--; )
                handleObj = handlers[j], (mappedTypes || origType === handleObj.origType) && (!handler4 || handler4.guid === handleObj.guid) && (!tmp || tmp.test(handleObj.namespace)) && (!selector || selector === handleObj.selector || selector === "**" && handleObj.selector) && (handlers.splice(j, 1), handleObj.selector && handlers.delegateCount--, special.remove && special.remove.call(elem, handleObj));
              origCount && !handlers.length && ((!special.teardown || special.teardown.call(elem, namespaces, elemData.handle) === !1) && jQuery2.removeEvent(elem, type2, elemData.handle), delete events2[type2]);
            }
            jQuery2.isEmptyObject(events2) && dataPriv.remove(elem, "handle events");
          }
        }, "remove"),
        dispatch: /* @__PURE__ */ __name(function(nativeEvent) {
          var i, j, ret, matched, handleObj, handlerQueue, args = new Array(arguments.length), event2 = jQuery2.event.fix(nativeEvent), handlers = (dataPriv.get(this, "events") || /* @__PURE__ */ Object.create(null))[event2.type] || [], special = jQuery2.event.special[event2.type] || {};
          for (args[0] = event2, i = 1; i < arguments.length; i++)
            args[i] = arguments[i];
          if (event2.delegateTarget = this, !(special.preDispatch && special.preDispatch.call(this, event2) === !1)) {
            for (handlerQueue = jQuery2.event.handlers.call(this, event2, handlers), i = 0; (matched = handlerQueue[i++]) && !event2.isPropagationStopped(); )
              for (event2.currentTarget = matched.elem, j = 0; (handleObj = matched.handlers[j++]) && !event2.isImmediatePropagationStopped(); )
                (!event2.rnamespace || handleObj.namespace === !1 || event2.rnamespace.test(handleObj.namespace)) && (event2.handleObj = handleObj, event2.data = handleObj.data, ret = ((jQuery2.event.special[handleObj.origType] || {}).handle || handleObj.handler).apply(matched.elem, args), ret !== void 0 && (event2.result = ret) === !1 && (event2.preventDefault(), event2.stopPropagation()));
            return special.postDispatch && special.postDispatch.call(this, event2), event2.result;
          }
        }, "dispatch"),
        handlers: /* @__PURE__ */ __name(function(event2, handlers) {
          var i, handleObj, sel, matchedHandlers, matchedSelectors, handlerQueue = [], delegateCount = handlers.delegateCount, cur = event2.target;
          if (delegateCount && // Support: IE <=9
          // Black-hole SVG <use> instance trees (trac-13180)
          cur.nodeType && // Support: Firefox <=42
          // Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
          // https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
          // Support: IE 11 only
          // ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
          !(event2.type === "click" && event2.button >= 1)) {
            for (; cur !== this; cur = cur.parentNode || this)
              if (cur.nodeType === 1 && !(event2.type === "click" && cur.disabled === !0)) {
                for (matchedHandlers = [], matchedSelectors = {}, i = 0; i < delegateCount; i++)
                  handleObj = handlers[i], sel = handleObj.selector + " ", matchedSelectors[sel] === void 0 && (matchedSelectors[sel] = handleObj.needsContext ? jQuery2(sel, this).index(cur) > -1 : jQuery2.find(sel, this, null, [cur]).length), matchedSelectors[sel] && matchedHandlers.push(handleObj);
                matchedHandlers.length && handlerQueue.push({ elem: cur, handlers: matchedHandlers });
              }
          }
          return cur = this, delegateCount < handlers.length && handlerQueue.push({ elem: cur, handlers: handlers.slice(delegateCount) }), handlerQueue;
        }, "handlers"),
        addProp: /* @__PURE__ */ __name(function(name2, hook) {
          Object.defineProperty(jQuery2.Event.prototype, name2, {
            enumerable: !0,
            configurable: !0,
            get: isFunction3(hook) ? function() {
              if (this.originalEvent)
                return hook(this.originalEvent);
            } : function() {
              if (this.originalEvent)
                return this.originalEvent[name2];
            },
            set: /* @__PURE__ */ __name(function(value3) {
              Object.defineProperty(this, name2, {
                enumerable: !0,
                configurable: !0,
                writable: !0,
                value: value3
              });
            }, "set")
          });
        }, "addProp"),
        fix: /* @__PURE__ */ __name(function(originalEvent) {
          return originalEvent[jQuery2.expando] ? originalEvent : new jQuery2.Event(originalEvent);
        }, "fix"),
        special: {
          load: {
            // Prevent triggered image.load events from bubbling to window.load
            noBubble: !0
          },
          click: {
            // Utilize native event to ensure correct state for checkable inputs
            setup: /* @__PURE__ */ __name(function(data49) {
              var el = this || data49;
              return rcheckableType.test(el.type) && el.click && nodeName(el, "input") && leverageNative(el, "click", !0), !1;
            }, "setup"),
            trigger: /* @__PURE__ */ __name(function(data49) {
              var el = this || data49;
              return rcheckableType.test(el.type) && el.click && nodeName(el, "input") && leverageNative(el, "click"), !0;
            }, "trigger"),
            // For cross-browser consistency, suppress native .click() on links
            // Also prevent it if we're currently inside a leveraged native-event stack
            _default: /* @__PURE__ */ __name(function(event2) {
              var target2 = event2.target;
              return rcheckableType.test(target2.type) && target2.click && nodeName(target2, "input") && dataPriv.get(target2, "click") || nodeName(target2, "a");
            }, "_default")
          },
          beforeunload: {
            postDispatch: /* @__PURE__ */ __name(function(event2) {
              event2.result !== void 0 && event2.originalEvent && (event2.originalEvent.returnValue = event2.result);
            }, "postDispatch")
          }
        }
      };
      function leverageNative(el, type2, isSetup) {
        if (!isSetup) {
          dataPriv.get(el, type2) === void 0 && jQuery2.event.add(el, type2, returnTrue);
          return;
        }
        dataPriv.set(el, type2, !1), jQuery2.event.add(el, type2, {
          namespace: !1,
          handler: /* @__PURE__ */ __name(function(event2) {
            var result, saved = dataPriv.get(this, type2);
            if (event2.isTrigger & 1 && this[type2]) {
              if (saved)
                (jQuery2.event.special[type2] || {}).delegateType && event2.stopPropagation();
              else if (saved = slice.call(arguments), dataPriv.set(this, type2, saved), this[type2](), result = dataPriv.get(this, type2), dataPriv.set(this, type2, !1), saved !== result)
                return event2.stopImmediatePropagation(), event2.preventDefault(), result;
            } else saved && (dataPriv.set(this, type2, jQuery2.event.trigger(
              saved[0],
              saved.slice(1),
              this
            )), event2.stopPropagation(), event2.isImmediatePropagationStopped = returnTrue);
          }, "handler")
        });
      }
      __name(leverageNative, "leverageNative"), jQuery2.removeEvent = function(elem, type2, handle) {
        elem.removeEventListener && elem.removeEventListener(type2, handle);
      }, jQuery2.Event = function(src2, props2) {
        if (!(this instanceof jQuery2.Event))
          return new jQuery2.Event(src2, props2);
        src2 && src2.type ? (this.originalEvent = src2, this.type = src2.type, this.isDefaultPrevented = src2.defaultPrevented || src2.defaultPrevented === void 0 && // Support: Android <=2.3 only
        src2.returnValue === !1 ? returnTrue : returnFalse, this.target = src2.target && src2.target.nodeType === 3 ? src2.target.parentNode : src2.target, this.currentTarget = src2.currentTarget, this.relatedTarget = src2.relatedTarget) : this.type = src2, props2 && jQuery2.extend(this, props2), this.timeStamp = src2 && src2.timeStamp || Date.now(), this[jQuery2.expando] = !0;
      }, jQuery2.Event.prototype = {
        constructor: jQuery2.Event,
        isDefaultPrevented: returnFalse,
        isPropagationStopped: returnFalse,
        isImmediatePropagationStopped: returnFalse,
        isSimulated: !1,
        preventDefault: /* @__PURE__ */ __name(function() {
          var e2 = this.originalEvent;
          this.isDefaultPrevented = returnTrue, e2 && !this.isSimulated && e2.preventDefault();
        }, "preventDefault"),
        stopPropagation: /* @__PURE__ */ __name(function() {
          var e2 = this.originalEvent;
          this.isPropagationStopped = returnTrue, e2 && !this.isSimulated && e2.stopPropagation();
        }, "stopPropagation"),
        stopImmediatePropagation: /* @__PURE__ */ __name(function() {
          var e2 = this.originalEvent;
          this.isImmediatePropagationStopped = returnTrue, e2 && !this.isSimulated && e2.stopImmediatePropagation(), this.stopPropagation();
        }, "stopImmediatePropagation")
      }, jQuery2.each({
        altKey: !0,
        bubbles: !0,
        cancelable: !0,
        changedTouches: !0,
        ctrlKey: !0,
        detail: !0,
        eventPhase: !0,
        metaKey: !0,
        pageX: !0,
        pageY: !0,
        shiftKey: !0,
        view: !0,
        char: !0,
        code: !0,
        charCode: !0,
        key: !0,
        keyCode: !0,
        button: !0,
        buttons: !0,
        clientX: !0,
        clientY: !0,
        offsetX: !0,
        offsetY: !0,
        pointerId: !0,
        pointerType: !0,
        screenX: !0,
        screenY: !0,
        targetTouches: !0,
        toElement: !0,
        touches: !0,
        which: !0
      }, jQuery2.event.addProp), jQuery2.each({ focus: "focusin", blur: "focusout" }, function(type2, delegateType) {
        function focusMappedHandler(nativeEvent) {
          if (document2.documentMode) {
            var handle = dataPriv.get(this, "handle"), event2 = jQuery2.event.fix(nativeEvent);
            event2.type = nativeEvent.type === "focusin" ? "focus" : "blur", event2.isSimulated = !0, handle(nativeEvent), event2.target === event2.currentTarget && handle(event2);
          } else
            jQuery2.event.simulate(
              delegateType,
              nativeEvent.target,
              jQuery2.event.fix(nativeEvent)
            );
        }
        __name(focusMappedHandler, "focusMappedHandler"), jQuery2.event.special[type2] = {
          // Utilize native event if possible so blur/focus sequence is correct
          setup: /* @__PURE__ */ __name(function() {
            var attaches;
            if (leverageNative(this, type2, !0), document2.documentMode)
              attaches = dataPriv.get(this, delegateType), attaches || this.addEventListener(delegateType, focusMappedHandler), dataPriv.set(this, delegateType, (attaches || 0) + 1);
            else
              return !1;
          }, "setup"),
          trigger: /* @__PURE__ */ __name(function() {
            return leverageNative(this, type2), !0;
          }, "trigger"),
          teardown: /* @__PURE__ */ __name(function() {
            var attaches;
            if (document2.documentMode)
              attaches = dataPriv.get(this, delegateType) - 1, attaches ? dataPriv.set(this, delegateType, attaches) : (this.removeEventListener(delegateType, focusMappedHandler), dataPriv.remove(this, delegateType));
            else
              return !1;
          }, "teardown"),
          // Suppress native focus or blur if we're currently inside
          // a leveraged native-event stack
          _default: /* @__PURE__ */ __name(function(event2) {
            return dataPriv.get(event2.target, type2);
          }, "_default"),
          delegateType
        }, jQuery2.event.special[delegateType] = {
          setup: /* @__PURE__ */ __name(function() {
            var doc = this.ownerDocument || this.document || this, dataHolder = document2.documentMode ? this : doc, attaches = dataPriv.get(dataHolder, delegateType);
            attaches || (document2.documentMode ? this.addEventListener(delegateType, focusMappedHandler) : doc.addEventListener(type2, focusMappedHandler, !0)), dataPriv.set(dataHolder, delegateType, (attaches || 0) + 1);
          }, "setup"),
          teardown: /* @__PURE__ */ __name(function() {
            var doc = this.ownerDocument || this.document || this, dataHolder = document2.documentMode ? this : doc, attaches = dataPriv.get(dataHolder, delegateType) - 1;
            attaches ? dataPriv.set(dataHolder, delegateType, attaches) : (document2.documentMode ? this.removeEventListener(delegateType, focusMappedHandler) : doc.removeEventListener(type2, focusMappedHandler, !0), dataPriv.remove(dataHolder, delegateType));
          }, "teardown")
        };
      }), jQuery2.each({
        mouseenter: "mouseover",
        mouseleave: "mouseout",
        pointerenter: "pointerover",
        pointerleave: "pointerout"
      }, function(orig, fix) {
        jQuery2.event.special[orig] = {
          delegateType: fix,
          bindType: fix,
          handle: /* @__PURE__ */ __name(function(event2) {
            var ret, target2 = this, related = event2.relatedTarget, handleObj = event2.handleObj;
            return (!related || related !== target2 && !jQuery2.contains(target2, related)) && (event2.type = handleObj.origType, ret = handleObj.handler.apply(this, arguments), event2.type = fix), ret;
          }, "handle")
        };
      }), jQuery2.fn.extend({
        on: /* @__PURE__ */ __name(function(types2, selector, data49, fn2) {
          return on2(this, types2, selector, data49, fn2);
        }, "on"),
        one: /* @__PURE__ */ __name(function(types2, selector, data49, fn2) {
          return on2(this, types2, selector, data49, fn2, 1);
        }, "one"),
        off: /* @__PURE__ */ __name(function(types2, selector, fn2) {
          var handleObj, type2;
          if (types2 && types2.preventDefault && types2.handleObj)
            return handleObj = types2.handleObj, jQuery2(types2.delegateTarget).off(
              handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType,
              handleObj.selector,
              handleObj.handler
            ), this;
          if (typeof types2 == "object") {
            for (type2 in types2)
              this.off(type2, selector, types2[type2]);
            return this;
          }
          return (selector === !1 || typeof selector == "function") && (fn2 = selector, selector = void 0), fn2 === !1 && (fn2 = returnFalse), this.each(function() {
            jQuery2.event.remove(this, types2, fn2, selector);
          });
        }, "off")
      });
      var rnoInnerhtml = /<script|<style|<link/i, rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i, rcleanScript = /^\s*<!\[CDATA\[|\]\]>\s*$/g;
      function manipulationTarget(elem, content) {
        return nodeName(elem, "table") && nodeName(content.nodeType !== 11 ? content : content.firstChild, "tr") && jQuery2(elem).children("tbody")[0] || elem;
      }
      __name(manipulationTarget, "manipulationTarget");
      function disableScript(elem) {
        return elem.type = (elem.getAttribute("type") !== null) + "/" + elem.type, elem;
      }
      __name(disableScript, "disableScript");
      function restoreScript(elem) {
        return (elem.type || "").slice(0, 5) === "true/" ? elem.type = elem.type.slice(5) : elem.removeAttribute("type"), elem;
      }
      __name(restoreScript, "restoreScript");
      function cloneCopyEvent(src2, dest) {
        var i, l, type2, pdataOld, udataOld, udataCur, events2;
        if (dest.nodeType === 1) {
          if (dataPriv.hasData(src2) && (pdataOld = dataPriv.get(src2), events2 = pdataOld.events, events2)) {
            dataPriv.remove(dest, "handle events");
            for (type2 in events2)
              for (i = 0, l = events2[type2].length; i < l; i++)
                jQuery2.event.add(dest, type2, events2[type2][i]);
          }
          dataUser.hasData(src2) && (udataOld = dataUser.access(src2), udataCur = jQuery2.extend({}, udataOld), dataUser.set(dest, udataCur));
        }
      }
      __name(cloneCopyEvent, "cloneCopyEvent");
      function fixInput(src2, dest) {
        var nodeName2 = dest.nodeName.toLowerCase();
        nodeName2 === "input" && rcheckableType.test(src2.type) ? dest.checked = src2.checked : (nodeName2 === "input" || nodeName2 === "textarea") && (dest.defaultValue = src2.defaultValue);
      }
      __name(fixInput, "fixInput");
      function domManip(collection, args, callback, ignored) {
        args = flat(args);
        var fragment, first2, scripts, hasScripts, node, doc, i = 0, l = collection.length, iNoClone = l - 1, value3 = args[0], valueIsFunction = isFunction3(value3);
        if (valueIsFunction || l > 1 && typeof value3 == "string" && !support2.checkClone && rchecked.test(value3))
          return collection.each(function(index3) {
            var self2 = collection.eq(index3);
            valueIsFunction && (args[0] = value3.call(this, index3, self2.html())), domManip(self2, args, callback, ignored);
          });
        if (l && (fragment = buildFragment(args, collection[0].ownerDocument, !1, collection, ignored), first2 = fragment.firstChild, fragment.childNodes.length === 1 && (fragment = first2), first2 || ignored)) {
          for (scripts = jQuery2.map(getAll(fragment, "script"), disableScript), hasScripts = scripts.length; i < l; i++)
            node = fragment, i !== iNoClone && (node = jQuery2.clone(node, !0, !0), hasScripts && jQuery2.merge(scripts, getAll(node, "script"))), callback.call(collection[i], node, i);
          if (hasScripts)
            for (doc = scripts[scripts.length - 1].ownerDocument, jQuery2.map(scripts, restoreScript), i = 0; i < hasScripts; i++)
              node = scripts[i], rscriptType.test(node.type || "") && !dataPriv.access(node, "globalEval") && jQuery2.contains(doc, node) && (node.src && (node.type || "").toLowerCase() !== "module" ? jQuery2._evalUrl && !node.noModule && jQuery2._evalUrl(node.src, {
                nonce: node.nonce || node.getAttribute("nonce")
              }, doc) : DOMEval(node.textContent.replace(rcleanScript, ""), node, doc));
        }
        return collection;
      }
      __name(domManip, "domManip");
      function remove8(elem, selector, keepData) {
        for (var node, nodes = selector ? jQuery2.filter(selector, elem) : elem, i = 0; (node = nodes[i]) != null; i++)
          !keepData && node.nodeType === 1 && jQuery2.cleanData(getAll(node)), node.parentNode && (keepData && isAttached(node) && setGlobalEval(getAll(node, "script")), node.parentNode.removeChild(node));
        return elem;
      }
      __name(remove8, "remove"), jQuery2.extend({
        htmlPrefilter: /* @__PURE__ */ __name(function(html2) {
          return html2;
        }, "htmlPrefilter"),
        clone: /* @__PURE__ */ __name(function(elem, dataAndEvents, deepDataAndEvents) {
          var i, l, srcElements, destElements, clone3 = elem.cloneNode(!0), inPage = isAttached(elem);
          if (!support2.noCloneChecked && (elem.nodeType === 1 || elem.nodeType === 11) && !jQuery2.isXMLDoc(elem))
            for (destElements = getAll(clone3), srcElements = getAll(elem), i = 0, l = srcElements.length; i < l; i++)
              fixInput(srcElements[i], destElements[i]);
          if (dataAndEvents)
            if (deepDataAndEvents)
              for (srcElements = srcElements || getAll(elem), destElements = destElements || getAll(clone3), i = 0, l = srcElements.length; i < l; i++)
                cloneCopyEvent(srcElements[i], destElements[i]);
            else
              cloneCopyEvent(elem, clone3);
          return destElements = getAll(clone3, "script"), destElements.length > 0 && setGlobalEval(destElements, !inPage && getAll(elem, "script")), clone3;
        }, "clone"),
        cleanData: /* @__PURE__ */ __name(function(elems) {
          for (var data49, elem, type2, special = jQuery2.event.special, i = 0; (elem = elems[i]) !== void 0; i++)
            if (acceptData(elem)) {
              if (data49 = elem[dataPriv.expando]) {
                if (data49.events)
                  for (type2 in data49.events)
                    special[type2] ? jQuery2.event.remove(elem, type2) : jQuery2.removeEvent(elem, type2, data49.handle);
                elem[dataPriv.expando] = void 0;
              }
              elem[dataUser.expando] && (elem[dataUser.expando] = void 0);
            }
        }, "cleanData")
      }), jQuery2.fn.extend({
        detach: /* @__PURE__ */ __name(function(selector) {
          return remove8(this, selector, !0);
        }, "detach"),
        remove: /* @__PURE__ */ __name(function(selector) {
          return remove8(this, selector);
        }, "remove"),
        text: /* @__PURE__ */ __name(function(value3) {
          return access(this, function(value4) {
            return value4 === void 0 ? jQuery2.text(this) : this.empty().each(function() {
              (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) && (this.textContent = value4);
            });
          }, null, value3, arguments.length);
        }, "text"),
        append: /* @__PURE__ */ __name(function() {
          return domManip(this, arguments, function(elem) {
            if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
              var target2 = manipulationTarget(this, elem);
              target2.appendChild(elem);
            }
          });
        }, "append"),
        prepend: /* @__PURE__ */ __name(function() {
          return domManip(this, arguments, function(elem) {
            if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
              var target2 = manipulationTarget(this, elem);
              target2.insertBefore(elem, target2.firstChild);
            }
          });
        }, "prepend"),
        before: /* @__PURE__ */ __name(function() {
          return domManip(this, arguments, function(elem) {
            this.parentNode && this.parentNode.insertBefore(elem, this);
          });
        }, "before"),
        after: /* @__PURE__ */ __name(function() {
          return domManip(this, arguments, function(elem) {
            this.parentNode && this.parentNode.insertBefore(elem, this.nextSibling);
          });
        }, "after"),
        empty: /* @__PURE__ */ __name(function() {
          for (var elem, i = 0; (elem = this[i]) != null; i++)
            elem.nodeType === 1 && (jQuery2.cleanData(getAll(elem, !1)), elem.textContent = "");
          return this;
        }, "empty"),
        clone: /* @__PURE__ */ __name(function(dataAndEvents, deepDataAndEvents) {
          return dataAndEvents = dataAndEvents ?? !1, deepDataAndEvents = deepDataAndEvents ?? dataAndEvents, this.map(function() {
            return jQuery2.clone(this, dataAndEvents, deepDataAndEvents);
          });
        }, "clone"),
        html: /* @__PURE__ */ __name(function(value3) {
          return access(this, function(value4) {
            var elem = this[0] || {}, i = 0, l = this.length;
            if (value4 === void 0 && elem.nodeType === 1)
              return elem.innerHTML;
            if (typeof value4 == "string" && !rnoInnerhtml.test(value4) && !wrapMap[(rtagName.exec(value4) || ["", ""])[1].toLowerCase()]) {
              value4 = jQuery2.htmlPrefilter(value4);
              try {
                for (; i < l; i++)
                  elem = this[i] || {}, elem.nodeType === 1 && (jQuery2.cleanData(getAll(elem, !1)), elem.innerHTML = value4);
                elem = 0;
              } catch {
              }
            }
            elem && this.empty().append(value4);
          }, null, value3, arguments.length);
        }, "html"),
        replaceWith: /* @__PURE__ */ __name(function() {
          var ignored = [];
          return domManip(this, arguments, function(elem) {
            var parent = this.parentNode;
            jQuery2.inArray(this, ignored) < 0 && (jQuery2.cleanData(getAll(this)), parent && parent.replaceChild(elem, this));
          }, ignored);
        }, "replaceWith")
      }), jQuery2.each({
        appendTo: "append",
        prependTo: "prepend",
        insertBefore: "before",
        insertAfter: "after",
        replaceAll: "replaceWith"
      }, function(name2, original) {
        jQuery2.fn[name2] = function(selector) {
          for (var elems, ret = [], insert = jQuery2(selector), last = insert.length - 1, i = 0; i <= last; i++)
            elems = i === last ? this : this.clone(!0), jQuery2(insert[i])[original](elems), push4.apply(ret, elems.get());
          return this.pushStack(ret);
        };
      });
      var rnumnonpx = new RegExp("^(" + pnum + ")(?!px)[a-z%]+$", "i"), rcustomProp = /^--/, getStyles = /* @__PURE__ */ __name(function(elem) {
        var view = elem.ownerDocument.defaultView;
        return (!view || !view.opener) && (view = window2), view.getComputedStyle(elem);
      }, "getStyles"), swap = /* @__PURE__ */ __name(function(elem, options2, callback) {
        var ret, name2, old = {};
        for (name2 in options2)
          old[name2] = elem.style[name2], elem.style[name2] = options2[name2];
        ret = callback.call(elem);
        for (name2 in options2)
          elem.style[name2] = old[name2];
        return ret;
      }, "swap"), rboxStyle = new RegExp(cssExpand.join("|"), "i");
      (function() {
        function computeStyleTests() {
          if (div2) {
            container.style.cssText = "position:absolute;left:-11111px;width:60px;margin-top:1px;padding:0;border:0", div2.style.cssText = "position:relative;display:block;box-sizing:border-box;overflow:scroll;margin:auto;border:1px;padding:1px;width:60%;top:1%", documentElement.appendChild(container).appendChild(div2);
            var divStyle = window2.getComputedStyle(div2);
            pixelPositionVal = divStyle.top !== "1%", reliableMarginLeftVal = roundPixelMeasures(divStyle.marginLeft) === 12, div2.style.right = "60%", pixelBoxStylesVal = roundPixelMeasures(divStyle.right) === 36, boxSizingReliableVal = roundPixelMeasures(divStyle.width) === 36, div2.style.position = "absolute", scrollboxSizeVal = roundPixelMeasures(div2.offsetWidth / 3) === 12, documentElement.removeChild(container), div2 = null;
          }
        }
        __name(computeStyleTests, "computeStyleTests");
        function roundPixelMeasures(measure2) {
          return Math.round(parseFloat(measure2));
        }
        __name(roundPixelMeasures, "roundPixelMeasures");
        var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal, reliableTrDimensionsVal, reliableMarginLeftVal, container = document2.createElement("div"), div2 = document2.createElement("div");
        div2.style && (div2.style.backgroundClip = "content-box", div2.cloneNode(!0).style.backgroundClip = "", support2.clearCloneStyle = div2.style.backgroundClip === "content-box", jQuery2.extend(support2, {
          boxSizingReliable: /* @__PURE__ */ __name(function() {
            return computeStyleTests(), boxSizingReliableVal;
          }, "boxSizingReliable"),
          pixelBoxStyles: /* @__PURE__ */ __name(function() {
            return computeStyleTests(), pixelBoxStylesVal;
          }, "pixelBoxStyles"),
          pixelPosition: /* @__PURE__ */ __name(function() {
            return computeStyleTests(), pixelPositionVal;
          }, "pixelPosition"),
          reliableMarginLeft: /* @__PURE__ */ __name(function() {
            return computeStyleTests(), reliableMarginLeftVal;
          }, "reliableMarginLeft"),
          scrollboxSize: /* @__PURE__ */ __name(function() {
            return computeStyleTests(), scrollboxSizeVal;
          }, "scrollboxSize"),
          // Support: IE 9 - 11+, Edge 15 - 18+
          // IE/Edge misreport `getComputedStyle` of table rows with width/height
          // set in CSS while `offset*` properties report correct values.
          // Behavior in IE 9 is more subtle than in newer versions & it passes
          // some versions of this test; make sure not to make it pass there!
          //
          // Support: Firefox 70+
          // Only Firefox includes border widths
          // in computed dimensions. (gh-4529)
          reliableTrDimensions: /* @__PURE__ */ __name(function() {
            var table, tr, trChild, trStyle;
            return reliableTrDimensionsVal == null && (table = document2.createElement("table"), tr = document2.createElement("tr"), trChild = document2.createElement("div"), table.style.cssText = "position:absolute;left:-11111px;border-collapse:separate", tr.style.cssText = "box-sizing:content-box;border:1px solid", tr.style.height = "1px", trChild.style.height = "9px", trChild.style.display = "block", documentElement.appendChild(table).appendChild(tr).appendChild(trChild), trStyle = window2.getComputedStyle(tr), reliableTrDimensionsVal = parseInt(trStyle.height, 10) + parseInt(trStyle.borderTopWidth, 10) + parseInt(trStyle.borderBottomWidth, 10) === tr.offsetHeight, documentElement.removeChild(table)), reliableTrDimensionsVal;
          }, "reliableTrDimensions")
        }));
      })();
      function curCSS(elem, name2, computed2) {
        var width, minWidth, maxWidth, ret, isCustomProp = rcustomProp.test(name2), style2 = elem.style;
        return computed2 = computed2 || getStyles(elem), computed2 && (ret = computed2.getPropertyValue(name2) || computed2[name2], isCustomProp && ret && (ret = ret.replace(rtrimCSS, "$1") || void 0), ret === "" && !isAttached(elem) && (ret = jQuery2.style(elem, name2)), !support2.pixelBoxStyles() && rnumnonpx.test(ret) && rboxStyle.test(name2) && (width = style2.width, minWidth = style2.minWidth, maxWidth = style2.maxWidth, style2.minWidth = style2.maxWidth = style2.width = ret, ret = computed2.width, style2.width = width, style2.minWidth = minWidth, style2.maxWidth = maxWidth)), ret !== void 0 ? (
          // Support: IE <=9 - 11 only
          // IE returns zIndex value as an integer.
          ret + ""
        ) : ret;
      }
      __name(curCSS, "curCSS");
      function addGetHookIf(conditionFn, hookFn) {
        return {
          get: /* @__PURE__ */ __name(function() {
            if (conditionFn()) {
              delete this.get;
              return;
            }
            return (this.get = hookFn).apply(this, arguments);
          }, "get")
        };
      }
      __name(addGetHookIf, "addGetHookIf");
      var cssPrefixes = ["Webkit", "Moz", "ms"], emptyStyle2 = document2.createElement("div").style, vendorProps = {};
      function vendorPropName(name2) {
        for (var capName = name2[0].toUpperCase() + name2.slice(1), i = cssPrefixes.length; i--; )
          if (name2 = cssPrefixes[i] + capName, name2 in emptyStyle2)
            return name2;
      }
      __name(vendorPropName, "vendorPropName");
      function finalPropName(name2) {
        var final = jQuery2.cssProps[name2] || vendorProps[name2];
        return final || (name2 in emptyStyle2 ? name2 : vendorProps[name2] = vendorPropName(name2) || name2);
      }
      __name(finalPropName, "finalPropName");
      var rdisplayswap = /^(none|table(?!-c[ea]).+)/, cssShow = { position: "absolute", visibility: "hidden", display: "block" }, cssNormalTransform = {
        letterSpacing: "0",
        fontWeight: "400"
      };
      function setPositiveNumber(_elem, value3, subtract) {
        var matches4 = rcssNum.exec(value3);
        return matches4 ? (
          // Guard against undefined "subtract", e.g., when used as in cssHooks
          Math.max(0, matches4[2] - (subtract || 0)) + (matches4[3] || "px")
        ) : value3;
      }
      __name(setPositiveNumber, "setPositiveNumber");
      function boxModelAdjustment(elem, dimension, box, isBorderBox, styles2, computedVal) {
        var i = dimension === "width" ? 1 : 0, extra = 0, delta = 0, marginDelta = 0;
        if (box === (isBorderBox ? "border" : "content"))
          return 0;
        for (; i < 4; i += 2)
          box === "margin" && (marginDelta += jQuery2.css(elem, box + cssExpand[i], !0, styles2)), isBorderBox ? (box === "content" && (delta -= jQuery2.css(elem, "padding" + cssExpand[i], !0, styles2)), box !== "margin" && (delta -= jQuery2.css(elem, "border" + cssExpand[i] + "Width", !0, styles2))) : (delta += jQuery2.css(elem, "padding" + cssExpand[i], !0, styles2), box !== "padding" ? delta += jQuery2.css(elem, "border" + cssExpand[i] + "Width", !0, styles2) : extra += jQuery2.css(elem, "border" + cssExpand[i] + "Width", !0, styles2));
        return !isBorderBox && computedVal >= 0 && (delta += Math.max(0, Math.ceil(
          elem["offset" + dimension[0].toUpperCase() + dimension.slice(1)] - computedVal - delta - extra - 0.5
          // If offsetWidth/offsetHeight is unknown, then we can't determine content-box scroll gutter
          // Use an explicit zero to avoid NaN (gh-3964)
        )) || 0), delta + marginDelta;
      }
      __name(boxModelAdjustment, "boxModelAdjustment");
      function getWidthOrHeight(elem, dimension, extra) {
        var styles2 = getStyles(elem), boxSizingNeeded = !support2.boxSizingReliable() || extra, isBorderBox = boxSizingNeeded && jQuery2.css(elem, "boxSizing", !1, styles2) === "border-box", valueIsBorderBox = isBorderBox, val = curCSS(elem, dimension, styles2), offsetProp = "offset" + dimension[0].toUpperCase() + dimension.slice(1);
        if (rnumnonpx.test(val)) {
          if (!extra)
            return val;
          val = "auto";
        }
        return (!support2.boxSizingReliable() && isBorderBox || // Support: IE 10 - 11+, Edge 15 - 18+
        // IE/Edge misreport `getComputedStyle` of table rows with width/height
        // set in CSS while `offset*` properties report correct values.
        // Interestingly, in some cases IE 9 doesn't suffer from this issue.
        !support2.reliableTrDimensions() && nodeName(elem, "tr") || // Fall back to offsetWidth/offsetHeight when value is "auto"
        // This happens for inline elements with no explicit setting (gh-3571)
        val === "auto" || // Support: Android <=4.1 - 4.3 only
        // Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)
        !parseFloat(val) && jQuery2.css(elem, "display", !1, styles2) === "inline") && // Make sure the element is visible & connected
        elem.getClientRects().length && (isBorderBox = jQuery2.css(elem, "boxSizing", !1, styles2) === "border-box", valueIsBorderBox = offsetProp in elem, valueIsBorderBox && (val = elem[offsetProp])), val = parseFloat(val) || 0, val + boxModelAdjustment(
          elem,
          dimension,
          extra || (isBorderBox ? "border" : "content"),
          valueIsBorderBox,
          styles2,
          // Provide the current computed size to request scroll gutter calculation (gh-3589)
          val
        ) + "px";
      }
      __name(getWidthOrHeight, "getWidthOrHeight"), jQuery2.extend({
        // Add in style property hooks for overriding the default
        // behavior of getting and setting a style property
        cssHooks: {
          opacity: {
            get: /* @__PURE__ */ __name(function(elem, computed2) {
              if (computed2) {
                var ret = curCSS(elem, "opacity");
                return ret === "" ? "1" : ret;
              }
            }, "get")
          }
        },
        // Don't automatically add "px" to these possibly-unitless properties
        cssNumber: {
          animationIterationCount: !0,
          aspectRatio: !0,
          borderImageSlice: !0,
          columnCount: !0,
          flexGrow: !0,
          flexShrink: !0,
          fontWeight: !0,
          gridArea: !0,
          gridColumn: !0,
          gridColumnEnd: !0,
          gridColumnStart: !0,
          gridRow: !0,
          gridRowEnd: !0,
          gridRowStart: !0,
          lineHeight: !0,
          opacity: !0,
          order: !0,
          orphans: !0,
          scale: !0,
          widows: !0,
          zIndex: !0,
          zoom: !0,
          // SVG-related
          fillOpacity: !0,
          floodOpacity: !0,
          stopOpacity: !0,
          strokeMiterlimit: !0,
          strokeOpacity: !0
        },
        // Add in properties whose names you wish to fix before
        // setting or getting the value
        cssProps: {},
        // Get and set the style property on a DOM Node
        style: /* @__PURE__ */ __name(function(elem, name2, value3, extra) {
          if (!(!elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style)) {
            var ret, type2, hooks2, origName = camelCase(name2), isCustomProp = rcustomProp.test(name2), style2 = elem.style;
            if (isCustomProp || (name2 = finalPropName(origName)), hooks2 = jQuery2.cssHooks[name2] || jQuery2.cssHooks[origName], value3 !== void 0) {
              if (type2 = typeof value3, type2 === "string" && (ret = rcssNum.exec(value3)) && ret[1] && (value3 = adjustCSS(elem, name2, ret), type2 = "number"), value3 == null || value3 !== value3)
                return;
              type2 === "number" && !isCustomProp && (value3 += ret && ret[3] || (jQuery2.cssNumber[origName] ? "" : "px")), !support2.clearCloneStyle && value3 === "" && name2.indexOf("background") === 0 && (style2[name2] = "inherit"), (!hooks2 || !("set" in hooks2) || (value3 = hooks2.set(elem, value3, extra)) !== void 0) && (isCustomProp ? style2.setProperty(name2, value3) : style2[name2] = value3);
            } else
              return hooks2 && "get" in hooks2 && (ret = hooks2.get(elem, !1, extra)) !== void 0 ? ret : style2[name2];
          }
        }, "style"),
        css: /* @__PURE__ */ __name(function(elem, name2, extra, styles2) {
          var val, num, hooks2, origName = camelCase(name2), isCustomProp = rcustomProp.test(name2);
          return isCustomProp || (name2 = finalPropName(origName)), hooks2 = jQuery2.cssHooks[name2] || jQuery2.cssHooks[origName], hooks2 && "get" in hooks2 && (val = hooks2.get(elem, !0, extra)), val === void 0 && (val = curCSS(elem, name2, styles2)), val === "normal" && name2 in cssNormalTransform && (val = cssNormalTransform[name2]), extra === "" || extra ? (num = parseFloat(val), extra === !0 || isFinite(num) ? num || 0 : val) : val;
        }, "css")
      }), jQuery2.each(["height", "width"], function(_i, dimension) {
        jQuery2.cssHooks[dimension] = {
          get: /* @__PURE__ */ __name(function(elem, computed2, extra) {
            if (computed2)
              return rdisplayswap.test(jQuery2.css(elem, "display")) && // Support: Safari 8+
              // Table columns in Safari have non-zero offsetWidth & zero
              // getBoundingClientRect().width unless display is changed.
              // Support: IE <=11 only
              // Running getBoundingClientRect on a disconnected node
              // in IE throws an error.
              (!elem.getClientRects().length || !elem.getBoundingClientRect().width) ? swap(elem, cssShow, function() {
                return getWidthOrHeight(elem, dimension, extra);
              }) : getWidthOrHeight(elem, dimension, extra);
          }, "get"),
          set: /* @__PURE__ */ __name(function(elem, value3, extra) {
            var matches4, styles2 = getStyles(elem), scrollboxSizeBuggy = !support2.scrollboxSize() && styles2.position === "absolute", boxSizingNeeded = scrollboxSizeBuggy || extra, isBorderBox = boxSizingNeeded && jQuery2.css(elem, "boxSizing", !1, styles2) === "border-box", subtract = extra ? boxModelAdjustment(
              elem,
              dimension,
              extra,
              isBorderBox,
              styles2
            ) : 0;
            return isBorderBox && scrollboxSizeBuggy && (subtract -= Math.ceil(
              elem["offset" + dimension[0].toUpperCase() + dimension.slice(1)] - parseFloat(styles2[dimension]) - boxModelAdjustment(elem, dimension, "border", !1, styles2) - 0.5
            )), subtract && (matches4 = rcssNum.exec(value3)) && (matches4[3] || "px") !== "px" && (elem.style[dimension] = value3, value3 = jQuery2.css(elem, dimension)), setPositiveNumber(elem, value3, subtract);
          }, "set")
        };
      }), jQuery2.cssHooks.marginLeft = addGetHookIf(
        support2.reliableMarginLeft,
        function(elem, computed2) {
          if (computed2)
            return (parseFloat(curCSS(elem, "marginLeft")) || elem.getBoundingClientRect().left - swap(elem, { marginLeft: 0 }, function() {
              return elem.getBoundingClientRect().left;
            })) + "px";
        }
      ), jQuery2.each({
        margin: "",
        padding: "",
        border: "Width"
      }, function(prefix, suffix) {
        jQuery2.cssHooks[prefix + suffix] = {
          expand: /* @__PURE__ */ __name(function(value3) {
            for (var i = 0, expanded = {}, parts = typeof value3 == "string" ? value3.split(" ") : [value3]; i < 4; i++)
              expanded[prefix + cssExpand[i] + suffix] = parts[i] || parts[i - 2] || parts[0];
            return expanded;
          }, "expand")
        }, prefix !== "margin" && (jQuery2.cssHooks[prefix + suffix].set = setPositiveNumber);
      }), jQuery2.fn.extend({
        css: /* @__PURE__ */ __name(function(name2, value3) {
          return access(this, function(elem, name3, value4) {
            var styles2, len2, map2 = {}, i = 0;
            if (Array.isArray(name3)) {
              for (styles2 = getStyles(elem), len2 = name3.length; i < len2; i++)
                map2[name3[i]] = jQuery2.css(elem, name3[i], !1, styles2);
              return map2;
            }
            return value4 !== void 0 ? jQuery2.style(elem, name3, value4) : jQuery2.css(elem, name3);
          }, name2, value3, arguments.length > 1);
        }, "css")
      });
      function Tween(elem, options2, prop2, end2, easing) {
        return new Tween.prototype.init(elem, options2, prop2, end2, easing);
      }
      __name(Tween, "Tween"), jQuery2.Tween = Tween, Tween.prototype = {
        constructor: Tween,
        init: /* @__PURE__ */ __name(function(elem, options2, prop2, end2, easing, unit) {
          this.elem = elem, this.prop = prop2, this.easing = easing || jQuery2.easing._default, this.options = options2, this.start = this.now = this.cur(), this.end = end2, this.unit = unit || (jQuery2.cssNumber[prop2] ? "" : "px");
        }, "init"),
        cur: /* @__PURE__ */ __name(function() {
          var hooks2 = Tween.propHooks[this.prop];
          return hooks2 && hooks2.get ? hooks2.get(this) : Tween.propHooks._default.get(this);
        }, "cur"),
        run: /* @__PURE__ */ __name(function(percent) {
          var eased, hooks2 = Tween.propHooks[this.prop];
          return this.options.duration ? this.pos = eased = jQuery2.easing[this.easing](
            percent,
            this.options.duration * percent,
            0,
            1,
            this.options.duration
          ) : this.pos = eased = percent, this.now = (this.end - this.start) * eased + this.start, this.options.step && this.options.step.call(this.elem, this.now, this), hooks2 && hooks2.set ? hooks2.set(this) : Tween.propHooks._default.set(this), this;
        }, "run")
      }, Tween.prototype.init.prototype = Tween.prototype, Tween.propHooks = {
        _default: {
          get: /* @__PURE__ */ __name(function(tween) {
            var result;
            return tween.elem.nodeType !== 1 || tween.elem[tween.prop] != null && tween.elem.style[tween.prop] == null ? tween.elem[tween.prop] : (result = jQuery2.css(tween.elem, tween.prop, ""), !result || result === "auto" ? 0 : result);
          }, "get"),
          set: /* @__PURE__ */ __name(function(tween) {
            jQuery2.fx.step[tween.prop] ? jQuery2.fx.step[tween.prop](tween) : tween.elem.nodeType === 1 && (jQuery2.cssHooks[tween.prop] || tween.elem.style[finalPropName(tween.prop)] != null) ? jQuery2.style(tween.elem, tween.prop, tween.now + tween.unit) : tween.elem[tween.prop] = tween.now;
          }, "set")
        }
      }, Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
        set: /* @__PURE__ */ __name(function(tween) {
          tween.elem.nodeType && tween.elem.parentNode && (tween.elem[tween.prop] = tween.now);
        }, "set")
      }, jQuery2.easing = {
        linear: /* @__PURE__ */ __name(function(p) {
          return p;
        }, "linear"),
        swing: /* @__PURE__ */ __name(function(p) {
          return 0.5 - Math.cos(p * Math.PI) / 2;
        }, "swing"),
        _default: "swing"
      }, jQuery2.fx = Tween.prototype.init, jQuery2.fx.step = {};
      var fxNow, inProgress, rfxtypes = /^(?:toggle|show|hide)$/, rrun = /queueHooks$/;
      function schedule() {
        inProgress && (document2.hidden === !1 && window2.requestAnimationFrame ? window2.requestAnimationFrame(schedule) : window2.setTimeout(schedule, jQuery2.fx.interval), jQuery2.fx.tick());
      }
      __name(schedule, "schedule");
      function createFxNow() {
        return window2.setTimeout(function() {
          fxNow = void 0;
        }), fxNow = Date.now();
      }
      __name(createFxNow, "createFxNow");
      function genFx(type2, includeWidth) {
        var which, i = 0, attrs2 = { height: type2 };
        for (includeWidth = includeWidth ? 1 : 0; i < 4; i += 2 - includeWidth)
          which = cssExpand[i], attrs2["margin" + which] = attrs2["padding" + which] = type2;
        return includeWidth && (attrs2.opacity = attrs2.width = type2), attrs2;
      }
      __name(genFx, "genFx");
      function createTween(value3, prop2, animation) {
        for (var tween, collection = (Animation.tweeners[prop2] || []).concat(Animation.tweeners["*"]), index3 = 0, length2 = collection.length; index3 < length2; index3++)
          if (tween = collection[index3].call(animation, prop2, value3))
            return tween;
      }
      __name(createTween, "createTween");
      function defaultPrefilter(elem, props2, opts) {
        var prop2, value3, toggle5, hooks2, oldfire, propTween, restoreDisplay, display, isBox = "width" in props2 || "height" in props2, anim = this, orig = {}, style2 = elem.style, hidden2 = elem.nodeType && isHiddenWithinTree(elem), dataShow = dataPriv.get(elem, "fxshow");
        opts.queue || (hooks2 = jQuery2._queueHooks(elem, "fx"), hooks2.unqueued == null && (hooks2.unqueued = 0, oldfire = hooks2.empty.fire, hooks2.empty.fire = function() {
          hooks2.unqueued || oldfire();
        }), hooks2.unqueued++, anim.always(function() {
          anim.always(function() {
            hooks2.unqueued--, jQuery2.queue(elem, "fx").length || hooks2.empty.fire();
          });
        }));
        for (prop2 in props2)
          if (value3 = props2[prop2], rfxtypes.test(value3)) {
            if (delete props2[prop2], toggle5 = toggle5 || value3 === "toggle", value3 === (hidden2 ? "hide" : "show"))
              if (value3 === "show" && dataShow && dataShow[prop2] !== void 0)
                hidden2 = !0;
              else
                continue;
            orig[prop2] = dataShow && dataShow[prop2] || jQuery2.style(elem, prop2);
          }
        if (propTween = !jQuery2.isEmptyObject(props2), !(!propTween && jQuery2.isEmptyObject(orig))) {
          isBox && elem.nodeType === 1 && (opts.overflow = [style2.overflow, style2.overflowX, style2.overflowY], restoreDisplay = dataShow && dataShow.display, restoreDisplay == null && (restoreDisplay = dataPriv.get(elem, "display")), display = jQuery2.css(elem, "display"), display === "none" && (restoreDisplay ? display = restoreDisplay : (showHide([elem], !0), restoreDisplay = elem.style.display || restoreDisplay, display = jQuery2.css(elem, "display"), showHide([elem]))), (display === "inline" || display === "inline-block" && restoreDisplay != null) && jQuery2.css(elem, "float") === "none" && (propTween || (anim.done(function() {
            style2.display = restoreDisplay;
          }), restoreDisplay == null && (display = style2.display, restoreDisplay = display === "none" ? "" : display)), style2.display = "inline-block")), opts.overflow && (style2.overflow = "hidden", anim.always(function() {
            style2.overflow = opts.overflow[0], style2.overflowX = opts.overflow[1], style2.overflowY = opts.overflow[2];
          })), propTween = !1;
          for (prop2 in orig)
            propTween || (dataShow ? "hidden" in dataShow && (hidden2 = dataShow.hidden) : dataShow = dataPriv.access(elem, "fxshow", { display: restoreDisplay }), toggle5 && (dataShow.hidden = !hidden2), hidden2 && showHide([elem], !0), anim.done(function() {
              hidden2 || showHide([elem]), dataPriv.remove(elem, "fxshow");
              for (prop2 in orig)
                jQuery2.style(elem, prop2, orig[prop2]);
            })), propTween = createTween(hidden2 ? dataShow[prop2] : 0, prop2, anim), prop2 in dataShow || (dataShow[prop2] = propTween.start, hidden2 && (propTween.end = propTween.start, propTween.start = 0));
        }
      }
      __name(defaultPrefilter, "defaultPrefilter");
      function propFilter(props2, specialEasing) {
        var index3, name2, easing, value3, hooks2;
        for (index3 in props2)
          if (name2 = camelCase(index3), easing = specialEasing[name2], value3 = props2[index3], Array.isArray(value3) && (easing = value3[1], value3 = props2[index3] = value3[0]), index3 !== name2 && (props2[name2] = value3, delete props2[index3]), hooks2 = jQuery2.cssHooks[name2], hooks2 && "expand" in hooks2) {
            value3 = hooks2.expand(value3), delete props2[name2];
            for (index3 in value3)
              index3 in props2 || (props2[index3] = value3[index3], specialEasing[index3] = easing);
          } else
            specialEasing[name2] = easing;
      }
      __name(propFilter, "propFilter");
      function Animation(elem, properties, options2) {
        var result, stopped, index3 = 0, length2 = Animation.prefilters.length, deferred = jQuery2.Deferred().always(function() {
          delete tick.elem;
        }), tick = /* @__PURE__ */ __name(function() {
          if (stopped)
            return !1;
          for (var currentTime = fxNow || createFxNow(), remaining = Math.max(0, animation.startTime + animation.duration - currentTime), temp = remaining / animation.duration || 0, percent = 1 - temp, index4 = 0, length3 = animation.tweens.length; index4 < length3; index4++)
            animation.tweens[index4].run(percent);
          return deferred.notifyWith(elem, [animation, percent, remaining]), percent < 1 && length3 ? remaining : (length3 || deferred.notifyWith(elem, [animation, 1, 0]), deferred.resolveWith(elem, [animation]), !1);
        }, "tick"), animation = deferred.promise({
          elem,
          props: jQuery2.extend({}, properties),
          opts: jQuery2.extend(!0, {
            specialEasing: {},
            easing: jQuery2.easing._default
          }, options2),
          originalProperties: properties,
          originalOptions: options2,
          startTime: fxNow || createFxNow(),
          duration: options2.duration,
          tweens: [],
          createTween: /* @__PURE__ */ __name(function(prop2, end2) {
            var tween = jQuery2.Tween(
              elem,
              animation.opts,
              prop2,
              end2,
              animation.opts.specialEasing[prop2] || animation.opts.easing
            );
            return animation.tweens.push(tween), tween;
          }, "createTween"),
          stop: /* @__PURE__ */ __name(function(gotoEnd) {
            var index4 = 0, length3 = gotoEnd ? animation.tweens.length : 0;
            if (stopped)
              return this;
            for (stopped = !0; index4 < length3; index4++)
              animation.tweens[index4].run(1);
            return gotoEnd ? (deferred.notifyWith(elem, [animation, 1, 0]), deferred.resolveWith(elem, [animation, gotoEnd])) : deferred.rejectWith(elem, [animation, gotoEnd]), this;
          }, "stop")
        }), props2 = animation.props;
        for (propFilter(props2, animation.opts.specialEasing); index3 < length2; index3++)
          if (result = Animation.prefilters[index3].call(animation, elem, props2, animation.opts), result)
            return isFunction3(result.stop) && (jQuery2._queueHooks(animation.elem, animation.opts.queue).stop = result.stop.bind(result)), result;
        return jQuery2.map(props2, createTween, animation), isFunction3(animation.opts.start) && animation.opts.start.call(elem, animation), animation.progress(animation.opts.progress).done(animation.opts.done, animation.opts.complete).fail(animation.opts.fail).always(animation.opts.always), jQuery2.fx.timer(
          jQuery2.extend(tick, {
            elem,
            anim: animation,
            queue: animation.opts.queue
          })
        ), animation;
      }
      __name(Animation, "Animation"), jQuery2.Animation = jQuery2.extend(Animation, {
        tweeners: {
          "*": [function(prop2, value3) {
            var tween = this.createTween(prop2, value3);
            return adjustCSS(tween.elem, prop2, rcssNum.exec(value3), tween), tween;
          }]
        },
        tweener: /* @__PURE__ */ __name(function(props2, callback) {
          isFunction3(props2) ? (callback = props2, props2 = ["*"]) : props2 = props2.match(rnothtmlwhite);
          for (var prop2, index3 = 0, length2 = props2.length; index3 < length2; index3++)
            prop2 = props2[index3], Animation.tweeners[prop2] = Animation.tweeners[prop2] || [], Animation.tweeners[prop2].unshift(callback);
        }, "tweener"),
        prefilters: [defaultPrefilter],
        prefilter: /* @__PURE__ */ __name(function(callback, prepend) {
          prepend ? Animation.prefilters.unshift(callback) : Animation.prefilters.push(callback);
        }, "prefilter")
      }), jQuery2.speed = function(speed, easing, fn2) {
        var opt = speed && typeof speed == "object" ? jQuery2.extend({}, speed) : {
          complete: fn2 || !fn2 && easing || isFunction3(speed) && speed,
          duration: speed,
          easing: fn2 && easing || easing && !isFunction3(easing) && easing
        };
        return jQuery2.fx.off ? opt.duration = 0 : typeof opt.duration != "number" && (opt.duration in jQuery2.fx.speeds ? opt.duration = jQuery2.fx.speeds[opt.duration] : opt.duration = jQuery2.fx.speeds._default), (opt.queue == null || opt.queue === !0) && (opt.queue = "fx"), opt.old = opt.complete, opt.complete = function() {
          isFunction3(opt.old) && opt.old.call(this), opt.queue && jQuery2.dequeue(this, opt.queue);
        }, opt;
      }, jQuery2.fn.extend({
        fadeTo: /* @__PURE__ */ __name(function(speed, to2, easing, callback) {
          return this.filter(isHiddenWithinTree).css("opacity", 0).show().end().animate({ opacity: to2 }, speed, easing, callback);
        }, "fadeTo"),
        animate: /* @__PURE__ */ __name(function(prop2, speed, easing, callback) {
          var empty = jQuery2.isEmptyObject(prop2), optall = jQuery2.speed(speed, easing, callback), doAnimation = /* @__PURE__ */ __name(function() {
            var anim = Animation(this, jQuery2.extend({}, prop2), optall);
            (empty || dataPriv.get(this, "finish")) && anim.stop(!0);
          }, "doAnimation");
          return doAnimation.finish = doAnimation, empty || optall.queue === !1 ? this.each(doAnimation) : this.queue(optall.queue, doAnimation);
        }, "animate"),
        stop: /* @__PURE__ */ __name(function(type2, clearQueue, gotoEnd) {
          var stopQueue = /* @__PURE__ */ __name(function(hooks2) {
            var stop = hooks2.stop;
            delete hooks2.stop, stop(gotoEnd);
          }, "stopQueue");
          return typeof type2 != "string" && (gotoEnd = clearQueue, clearQueue = type2, type2 = void 0), clearQueue && this.queue(type2 || "fx", []), this.each(function() {
            var dequeue = !0, index3 = type2 != null && type2 + "queueHooks", timers = jQuery2.timers, data49 = dataPriv.get(this);
            if (index3)
              data49[index3] && data49[index3].stop && stopQueue(data49[index3]);
            else
              for (index3 in data49)
                data49[index3] && data49[index3].stop && rrun.test(index3) && stopQueue(data49[index3]);
            for (index3 = timers.length; index3--; )
              timers[index3].elem === this && (type2 == null || timers[index3].queue === type2) && (timers[index3].anim.stop(gotoEnd), dequeue = !1, timers.splice(index3, 1));
            (dequeue || !gotoEnd) && jQuery2.dequeue(this, type2);
          });
        }, "stop"),
        finish: /* @__PURE__ */ __name(function(type2) {
          return type2 !== !1 && (type2 = type2 || "fx"), this.each(function() {
            var index3, data49 = dataPriv.get(this), queue2 = data49[type2 + "queue"], hooks2 = data49[type2 + "queueHooks"], timers = jQuery2.timers, length2 = queue2 ? queue2.length : 0;
            for (data49.finish = !0, jQuery2.queue(this, type2, []), hooks2 && hooks2.stop && hooks2.stop.call(this, !0), index3 = timers.length; index3--; )
              timers[index3].elem === this && timers[index3].queue === type2 && (timers[index3].anim.stop(!0), timers.splice(index3, 1));
            for (index3 = 0; index3 < length2; index3++)
              queue2[index3] && queue2[index3].finish && queue2[index3].finish.call(this);
            delete data49.finish;
          });
        }, "finish")
      }), jQuery2.each(["toggle", "show", "hide"], function(_i, name2) {
        var cssFn = jQuery2.fn[name2];
        jQuery2.fn[name2] = function(speed, easing, callback) {
          return speed == null || typeof speed == "boolean" ? cssFn.apply(this, arguments) : this.animate(genFx(name2, !0), speed, easing, callback);
        };
      }), jQuery2.each({
        slideDown: genFx("show"),
        slideUp: genFx("hide"),
        slideToggle: genFx("toggle"),
        fadeIn: { opacity: "show" },
        fadeOut: { opacity: "hide" },
        fadeToggle: { opacity: "toggle" }
      }, function(name2, props2) {
        jQuery2.fn[name2] = function(speed, easing, callback) {
          return this.animate(props2, speed, easing, callback);
        };
      }), jQuery2.timers = [], jQuery2.fx.tick = function() {
        var timer, i = 0, timers = jQuery2.timers;
        for (fxNow = Date.now(); i < timers.length; i++)
          timer = timers[i], !timer() && timers[i] === timer && timers.splice(i--, 1);
        timers.length || jQuery2.fx.stop(), fxNow = void 0;
      }, jQuery2.fx.timer = function(timer) {
        jQuery2.timers.push(timer), jQuery2.fx.start();
      }, jQuery2.fx.interval = 13, jQuery2.fx.start = function() {
        inProgress || (inProgress = !0, schedule());
      }, jQuery2.fx.stop = function() {
        inProgress = null;
      }, jQuery2.fx.speeds = {
        slow: 600,
        fast: 200,
        // Default speed
        _default: 400
      }, jQuery2.fn.delay = function(time, type2) {
        return time = jQuery2.fx && jQuery2.fx.speeds[time] || time, type2 = type2 || "fx", this.queue(type2, function(next3, hooks2) {
          var timeout = window2.setTimeout(next3, time);
          hooks2.stop = function() {
            window2.clearTimeout(timeout);
          };
        });
      }, function() {
        var input = document2.createElement("input"), select4 = document2.createElement("select"), opt = select4.appendChild(document2.createElement("option"));
        input.type = "checkbox", support2.checkOn = input.value !== "", support2.optSelected = opt.selected, input = document2.createElement("input"), input.value = "t", input.type = "radio", support2.radioValue = input.value === "t";
      }();
      var boolHook, attrHandle = jQuery2.expr.attrHandle;
      jQuery2.fn.extend({
        attr: /* @__PURE__ */ __name(function(name2, value3) {
          return access(this, jQuery2.attr, name2, value3, arguments.length > 1);
        }, "attr"),
        removeAttr: /* @__PURE__ */ __name(function(name2) {
          return this.each(function() {
            jQuery2.removeAttr(this, name2);
          });
        }, "removeAttr")
      }), jQuery2.extend({
        attr: /* @__PURE__ */ __name(function(elem, name2, value3) {
          var ret, hooks2, nType = elem.nodeType;
          if (!(nType === 3 || nType === 8 || nType === 2)) {
            if (typeof elem.getAttribute > "u")
              return jQuery2.prop(elem, name2, value3);
            if ((nType !== 1 || !jQuery2.isXMLDoc(elem)) && (hooks2 = jQuery2.attrHooks[name2.toLowerCase()] || (jQuery2.expr.match.bool.test(name2) ? boolHook : void 0)), value3 !== void 0) {
              if (value3 === null) {
                jQuery2.removeAttr(elem, name2);
                return;
              }
              return hooks2 && "set" in hooks2 && (ret = hooks2.set(elem, value3, name2)) !== void 0 ? ret : (elem.setAttribute(name2, value3 + ""), value3);
            }
            return hooks2 && "get" in hooks2 && (ret = hooks2.get(elem, name2)) !== null ? ret : (ret = jQuery2.find.attr(elem, name2), ret ?? void 0);
          }
        }, "attr"),
        attrHooks: {
          type: {
            set: /* @__PURE__ */ __name(function(elem, value3) {
              if (!support2.radioValue && value3 === "radio" && nodeName(elem, "input")) {
                var val = elem.value;
                return elem.setAttribute("type", value3), val && (elem.value = val), value3;
              }
            }, "set")
          }
        },
        removeAttr: /* @__PURE__ */ __name(function(elem, value3) {
          var name2, i = 0, attrNames = value3 && value3.match(rnothtmlwhite);
          if (attrNames && elem.nodeType === 1)
            for (; name2 = attrNames[i++]; )
              elem.removeAttribute(name2);
        }, "removeAttr")
      }), boolHook = {
        set: /* @__PURE__ */ __name(function(elem, value3, name2) {
          return value3 === !1 ? jQuery2.removeAttr(elem, name2) : elem.setAttribute(name2, name2), name2;
        }, "set")
      }, jQuery2.each(jQuery2.expr.match.bool.source.match(/\w+/g), function(_i, name2) {
        var getter = attrHandle[name2] || jQuery2.find.attr;
        attrHandle[name2] = function(elem, name3, isXML) {
          var ret, handle, lowercaseName = name3.toLowerCase();
          return isXML || (handle = attrHandle[lowercaseName], attrHandle[lowercaseName] = ret, ret = getter(elem, name3, isXML) != null ? lowercaseName : null, attrHandle[lowercaseName] = handle), ret;
        };
      });
      var rfocusable = /^(?:input|select|textarea|button)$/i, rclickable = /^(?:a|area)$/i;
      jQuery2.fn.extend({
        prop: /* @__PURE__ */ __name(function(name2, value3) {
          return access(this, jQuery2.prop, name2, value3, arguments.length > 1);
        }, "prop"),
        removeProp: /* @__PURE__ */ __name(function(name2) {
          return this.each(function() {
            delete this[jQuery2.propFix[name2] || name2];
          });
        }, "removeProp")
      }), jQuery2.extend({
        prop: /* @__PURE__ */ __name(function(elem, name2, value3) {
          var ret, hooks2, nType = elem.nodeType;
          if (!(nType === 3 || nType === 8 || nType === 2))
            return (nType !== 1 || !jQuery2.isXMLDoc(elem)) && (name2 = jQuery2.propFix[name2] || name2, hooks2 = jQuery2.propHooks[name2]), value3 !== void 0 ? hooks2 && "set" in hooks2 && (ret = hooks2.set(elem, value3, name2)) !== void 0 ? ret : elem[name2] = value3 : hooks2 && "get" in hooks2 && (ret = hooks2.get(elem, name2)) !== null ? ret : elem[name2];
        }, "prop"),
        propHooks: {
          tabIndex: {
            get: /* @__PURE__ */ __name(function(elem) {
              var tabindex = jQuery2.find.attr(elem, "tabindex");
              return tabindex ? parseInt(tabindex, 10) : rfocusable.test(elem.nodeName) || rclickable.test(elem.nodeName) && elem.href ? 0 : -1;
            }, "get")
          }
        },
        propFix: {
          for: "htmlFor",
          class: "className"
        }
      }), support2.optSelected || (jQuery2.propHooks.selected = {
        get: /* @__PURE__ */ __name(function(elem) {
          var parent = elem.parentNode;
          return parent && parent.parentNode && parent.parentNode.selectedIndex, null;
        }, "get"),
        set: /* @__PURE__ */ __name(function(elem) {
          var parent = elem.parentNode;
          parent && (parent.selectedIndex, parent.parentNode && parent.parentNode.selectedIndex);
        }, "set")
      }), jQuery2.each([
        "tabIndex",
        "readOnly",
        "maxLength",
        "cellSpacing",
        "cellPadding",
        "rowSpan",
        "colSpan",
        "useMap",
        "frameBorder",
        "contentEditable"
      ], function() {
        jQuery2.propFix[this.toLowerCase()] = this;
      });
      function stripAndCollapse(value3) {
        var tokens = value3.match(rnothtmlwhite) || [];
        return tokens.join(" ");
      }
      __name(stripAndCollapse, "stripAndCollapse");
      function getClass(elem) {
        return elem.getAttribute && elem.getAttribute("class") || "";
      }
      __name(getClass, "getClass");
      function classesToArray(value3) {
        return Array.isArray(value3) ? value3 : typeof value3 == "string" ? value3.match(rnothtmlwhite) || [] : [];
      }
      __name(classesToArray, "classesToArray"), jQuery2.fn.extend({
        addClass: /* @__PURE__ */ __name(function(value3) {
          var classNames, cur, curValue, className, i, finalValue;
          return isFunction3(value3) ? this.each(function(j) {
            jQuery2(this).addClass(value3.call(this, j, getClass(this)));
          }) : (classNames = classesToArray(value3), classNames.length ? this.each(function() {
            if (curValue = getClass(this), cur = this.nodeType === 1 && " " + stripAndCollapse(curValue) + " ", cur) {
              for (i = 0; i < classNames.length; i++)
                className = classNames[i], cur.indexOf(" " + className + " ") < 0 && (cur += className + " ");
              finalValue = stripAndCollapse(cur), curValue !== finalValue && this.setAttribute("class", finalValue);
            }
          }) : this);
        }, "addClass"),
        removeClass: /* @__PURE__ */ __name(function(value3) {
          var classNames, cur, curValue, className, i, finalValue;
          return isFunction3(value3) ? this.each(function(j) {
            jQuery2(this).removeClass(value3.call(this, j, getClass(this)));
          }) : arguments.length ? (classNames = classesToArray(value3), classNames.length ? this.each(function() {
            if (curValue = getClass(this), cur = this.nodeType === 1 && " " + stripAndCollapse(curValue) + " ", cur) {
              for (i = 0; i < classNames.length; i++)
                for (className = classNames[i]; cur.indexOf(" " + className + " ") > -1; )
                  cur = cur.replace(" " + className + " ", " ");
              finalValue = stripAndCollapse(cur), curValue !== finalValue && this.setAttribute("class", finalValue);
            }
          }) : this) : this.attr("class", "");
        }, "removeClass"),
        toggleClass: /* @__PURE__ */ __name(function(value3, stateVal) {
          var classNames, className, i, self2, type2 = typeof value3, isValidValue3 = type2 === "string" || Array.isArray(value3);
          return isFunction3(value3) ? this.each(function(i2) {
            jQuery2(this).toggleClass(
              value3.call(this, i2, getClass(this), stateVal),
              stateVal
            );
          }) : typeof stateVal == "boolean" && isValidValue3 ? stateVal ? this.addClass(value3) : this.removeClass(value3) : (classNames = classesToArray(value3), this.each(function() {
            if (isValidValue3)
              for (self2 = jQuery2(this), i = 0; i < classNames.length; i++)
                className = classNames[i], self2.hasClass(className) ? self2.removeClass(className) : self2.addClass(className);
            else (value3 === void 0 || type2 === "boolean") && (className = getClass(this), className && dataPriv.set(this, "__className__", className), this.setAttribute && this.setAttribute(
              "class",
              className || value3 === !1 ? "" : dataPriv.get(this, "__className__") || ""
            ));
          }));
        }, "toggleClass"),
        hasClass: /* @__PURE__ */ __name(function(selector) {
          var className, elem, i = 0;
          for (className = " " + selector + " "; elem = this[i++]; )
            if (elem.nodeType === 1 && (" " + stripAndCollapse(getClass(elem)) + " ").indexOf(className) > -1)
              return !0;
          return !1;
        }, "hasClass")
      });
      var rreturn = /\r/g;
      jQuery2.fn.extend({
        val: /* @__PURE__ */ __name(function(value3) {
          var hooks2, ret, valueIsFunction, elem = this[0];
          return arguments.length ? (valueIsFunction = isFunction3(value3), this.each(function(i) {
            var val;
            this.nodeType === 1 && (valueIsFunction ? val = value3.call(this, i, jQuery2(this).val()) : val = value3, val == null ? val = "" : typeof val == "number" ? val += "" : Array.isArray(val) && (val = jQuery2.map(val, function(value4) {
              return value4 == null ? "" : value4 + "";
            })), hooks2 = jQuery2.valHooks[this.type] || jQuery2.valHooks[this.nodeName.toLowerCase()], (!hooks2 || !("set" in hooks2) || hooks2.set(this, val, "value") === void 0) && (this.value = val));
          })) : elem ? (hooks2 = jQuery2.valHooks[elem.type] || jQuery2.valHooks[elem.nodeName.toLowerCase()], hooks2 && "get" in hooks2 && (ret = hooks2.get(elem, "value")) !== void 0 ? ret : (ret = elem.value, typeof ret == "string" ? ret.replace(rreturn, "") : ret ?? "")) : void 0;
        }, "val")
      }), jQuery2.extend({
        valHooks: {
          option: {
            get: /* @__PURE__ */ __name(function(elem) {
              var val = jQuery2.find.attr(elem, "value");
              return val ?? // Support: IE <=10 - 11 only
              // option.text throws exceptions (trac-14686, trac-14858)
              // Strip and collapse whitespace
              // https://html.spec.whatwg.org/#strip-and-collapse-whitespace
              stripAndCollapse(jQuery2.text(elem));
            }, "get")
          },
          select: {
            get: /* @__PURE__ */ __name(function(elem) {
              var value3, option2, i, options2 = elem.options, index3 = elem.selectedIndex, one = elem.type === "select-one", values2 = one ? null : [], max2 = one ? index3 + 1 : options2.length;
              for (index3 < 0 ? i = max2 : i = one ? index3 : 0; i < max2; i++)
                if (option2 = options2[i], (option2.selected || i === index3) && // Don't return options that are disabled or in a disabled optgroup
                !option2.disabled && (!option2.parentNode.disabled || !nodeName(option2.parentNode, "optgroup"))) {
                  if (value3 = jQuery2(option2).val(), one)
                    return value3;
                  values2.push(value3);
                }
              return values2;
            }, "get"),
            set: /* @__PURE__ */ __name(function(elem, value3) {
              for (var optionSet, option2, options2 = elem.options, values2 = jQuery2.makeArray(value3), i = options2.length; i--; )
                option2 = options2[i], (option2.selected = jQuery2.inArray(jQuery2.valHooks.option.get(option2), values2) > -1) && (optionSet = !0);
              return optionSet || (elem.selectedIndex = -1), values2;
            }, "set")
          }
        }
      }), jQuery2.each(["radio", "checkbox"], function() {
        jQuery2.valHooks[this] = {
          set: /* @__PURE__ */ __name(function(elem, value3) {
            if (Array.isArray(value3))
              return elem.checked = jQuery2.inArray(jQuery2(elem).val(), value3) > -1;
          }, "set")
        }, support2.checkOn || (jQuery2.valHooks[this].get = function(elem) {
          return elem.getAttribute("value") === null ? "on" : elem.value;
        });
      });
      var location2 = window2.location, nonce = { guid: Date.now() }, rquery = /\?/;
      jQuery2.parseXML = function(data49) {
        var xml, parserErrorElem;
        if (!data49 || typeof data49 != "string")
          return null;
        try {
          xml = new window2.DOMParser().parseFromString(data49, "text/xml");
        } catch {
        }
        return parserErrorElem = xml && xml.getElementsByTagName("parsererror")[0], (!xml || parserErrorElem) && jQuery2.error("Invalid XML: " + (parserErrorElem ? jQuery2.map(parserErrorElem.childNodes, function(el) {
          return el.textContent;
        }).join(`
`) : data49)), xml;
      };
      var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/, stopPropagationCallback = /* @__PURE__ */ __name(function(e2) {
        e2.stopPropagation();
      }, "stopPropagationCallback");
      jQuery2.extend(jQuery2.event, {
        trigger: /* @__PURE__ */ __name(function(event2, data49, elem, onlyHandlers) {
          var i, cur, tmp, bubbleType, ontype, handle, special, lastElement, eventPath = [elem || document2], type2 = hasOwn2.call(event2, "type") ? event2.type : event2, namespaces = hasOwn2.call(event2, "namespace") ? event2.namespace.split(".") : [];
          if (cur = lastElement = tmp = elem = elem || document2, !(elem.nodeType === 3 || elem.nodeType === 8) && !rfocusMorph.test(type2 + jQuery2.event.triggered) && (type2.indexOf(".") > -1 && (namespaces = type2.split("."), type2 = namespaces.shift(), namespaces.sort()), ontype = type2.indexOf(":") < 0 && "on" + type2, event2 = event2[jQuery2.expando] ? event2 : new jQuery2.Event(type2, typeof event2 == "object" && event2), event2.isTrigger = onlyHandlers ? 2 : 3, event2.namespace = namespaces.join("."), event2.rnamespace = event2.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null, event2.result = void 0, event2.target || (event2.target = elem), data49 = data49 == null ? [event2] : jQuery2.makeArray(data49, [event2]), special = jQuery2.event.special[type2] || {}, !(!onlyHandlers && special.trigger && special.trigger.apply(elem, data49) === !1))) {
            if (!onlyHandlers && !special.noBubble && !isWindow(elem)) {
              for (bubbleType = special.delegateType || type2, rfocusMorph.test(bubbleType + type2) || (cur = cur.parentNode); cur; cur = cur.parentNode)
                eventPath.push(cur), tmp = cur;
              tmp === (elem.ownerDocument || document2) && eventPath.push(tmp.defaultView || tmp.parentWindow || window2);
            }
            for (i = 0; (cur = eventPath[i++]) && !event2.isPropagationStopped(); )
              lastElement = cur, event2.type = i > 1 ? bubbleType : special.bindType || type2, handle = (dataPriv.get(cur, "events") || /* @__PURE__ */ Object.create(null))[event2.type] && dataPriv.get(cur, "handle"), handle && handle.apply(cur, data49), handle = ontype && cur[ontype], handle && handle.apply && acceptData(cur) && (event2.result = handle.apply(cur, data49), event2.result === !1 && event2.preventDefault());
            return event2.type = type2, !onlyHandlers && !event2.isDefaultPrevented() && (!special._default || special._default.apply(eventPath.pop(), data49) === !1) && acceptData(elem) && ontype && isFunction3(elem[type2]) && !isWindow(elem) && (tmp = elem[ontype], tmp && (elem[ontype] = null), jQuery2.event.triggered = type2, event2.isPropagationStopped() && lastElement.addEventListener(type2, stopPropagationCallback), elem[type2](), event2.isPropagationStopped() && lastElement.removeEventListener(type2, stopPropagationCallback), jQuery2.event.triggered = void 0, tmp && (elem[ontype] = tmp)), event2.result;
          }
        }, "trigger"),
        // Piggyback on a donor event to simulate a different one
        // Used only for `focus(in | out)` events
        simulate: /* @__PURE__ */ __name(function(type2, elem, event2) {
          var e2 = jQuery2.extend(
            new jQuery2.Event(),
            event2,
            {
              type: type2,
              isSimulated: !0
            }
          );
          jQuery2.event.trigger(e2, null, elem);
        }, "simulate")
      }), jQuery2.fn.extend({
        trigger: /* @__PURE__ */ __name(function(type2, data49) {
          return this.each(function() {
            jQuery2.event.trigger(type2, data49, this);
          });
        }, "trigger"),
        triggerHandler: /* @__PURE__ */ __name(function(type2, data49) {
          var elem = this[0];
          if (elem)
            return jQuery2.event.trigger(type2, data49, elem, !0);
        }, "triggerHandler")
      });
      var rbracket = /\[\]$/, rCRLF = /\r?\n/g, rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i, rsubmittable = /^(?:input|select|textarea|keygen)/i;
      function buildParams(prefix, obj2, traditional, add4) {
        var name2;
        if (Array.isArray(obj2))
          jQuery2.each(obj2, function(i, v) {
            traditional || rbracket.test(prefix) ? add4(prefix, v) : buildParams(
              prefix + "[" + (typeof v == "object" && v != null ? i : "") + "]",
              v,
              traditional,
              add4
            );
          });
        else if (!traditional && toType4(obj2) === "object")
          for (name2 in obj2)
            buildParams(prefix + "[" + name2 + "]", obj2[name2], traditional, add4);
        else
          add4(prefix, obj2);
      }
      __name(buildParams, "buildParams"), jQuery2.param = function(a2, traditional) {
        var prefix, s2 = [], add4 = /* @__PURE__ */ __name(function(key, valueOrFunction) {
          var value3 = isFunction3(valueOrFunction) ? valueOrFunction() : valueOrFunction;
          s2[s2.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value3 ?? "");
        }, "add");
        if (a2 == null)
          return "";
        if (Array.isArray(a2) || a2.jquery && !jQuery2.isPlainObject(a2))
          jQuery2.each(a2, function() {
            add4(this.name, this.value);
          });
        else
          for (prefix in a2)
            buildParams(prefix, a2[prefix], traditional, add4);
        return s2.join("&");
      }, jQuery2.fn.extend({
        serialize: /* @__PURE__ */ __name(function() {
          return jQuery2.param(this.serializeArray());
        }, "serialize"),
        serializeArray: /* @__PURE__ */ __name(function() {
          return this.map(function() {
            var elements = jQuery2.prop(this, "elements");
            return elements ? jQuery2.makeArray(elements) : this;
          }).filter(function() {
            var type2 = this.type;
            return this.name && !jQuery2(this).is(":disabled") && rsubmittable.test(this.nodeName) && !rsubmitterTypes.test(type2) && (this.checked || !rcheckableType.test(type2));
          }).map(function(_i, elem) {
            var val = jQuery2(this).val();
            return val == null ? null : Array.isArray(val) ? jQuery2.map(val, function(val2) {
              return { name: elem.name, value: val2.replace(rCRLF, `\r
`) };
            }) : { name: elem.name, value: val.replace(rCRLF, `\r
`) };
          }).get();
        }, "serializeArray")
      });
      var r20 = /%20/g, rhash = /#.*$/, rantiCache = /([?&])_=[^&]*/, rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg, rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/, rnoContent = /^(?:GET|HEAD)$/, rprotocol = /^\/\//, prefilters = {}, transports2 = {}, allTypes = "*/".concat("*"), originAnchor = document2.createElement("a");
      originAnchor.href = location2.href;
      function addToPrefiltersOrTransports(structure) {
        return function(dataTypeExpression, func) {
          typeof dataTypeExpression != "string" && (func = dataTypeExpression, dataTypeExpression = "*");
          var dataType, i = 0, dataTypes = dataTypeExpression.toLowerCase().match(rnothtmlwhite) || [];
          if (isFunction3(func))
            for (; dataType = dataTypes[i++]; )
              dataType[0] === "+" ? (dataType = dataType.slice(1) || "*", (structure[dataType] = structure[dataType] || []).unshift(func)) : (structure[dataType] = structure[dataType] || []).push(func);
        };
      }
      __name(addToPrefiltersOrTransports, "addToPrefiltersOrTransports");
      function inspectPrefiltersOrTransports(structure, options2, originalOptions, jqXHR) {
        var inspected = {}, seekingTransport = structure === transports2;
        function inspect(dataType) {
          var selected;
          return inspected[dataType] = !0, jQuery2.each(structure[dataType] || [], function(_2, prefilterOrFactory) {
            var dataTypeOrTransport = prefilterOrFactory(options2, originalOptions, jqXHR);
            if (typeof dataTypeOrTransport == "string" && !seekingTransport && !inspected[dataTypeOrTransport])
              return options2.dataTypes.unshift(dataTypeOrTransport), inspect(dataTypeOrTransport), !1;
            if (seekingTransport)
              return !(selected = dataTypeOrTransport);
          }), selected;
        }
        return __name(inspect, "inspect"), inspect(options2.dataTypes[0]) || !inspected["*"] && inspect("*");
      }
      __name(inspectPrefiltersOrTransports, "inspectPrefiltersOrTransports");
      function ajaxExtend(target2, src2) {
        var key, deep, flatOptions = jQuery2.ajaxSettings.flatOptions || {};
        for (key in src2)
          src2[key] !== void 0 && ((flatOptions[key] ? target2 : deep || (deep = {}))[key] = src2[key]);
        return deep && jQuery2.extend(!0, target2, deep), target2;
      }
      __name(ajaxExtend, "ajaxExtend");
      function ajaxHandleResponses(s2, jqXHR, responses) {
        for (var ct, type2, finalDataType, firstDataType, contents = s2.contents, dataTypes = s2.dataTypes; dataTypes[0] === "*"; )
          dataTypes.shift(), ct === void 0 && (ct = s2.mimeType || jqXHR.getResponseHeader("Content-Type"));
        if (ct) {
          for (type2 in contents)
            if (contents[type2] && contents[type2].test(ct)) {
              dataTypes.unshift(type2);
              break;
            }
        }
        if (dataTypes[0] in responses)
          finalDataType = dataTypes[0];
        else {
          for (type2 in responses) {
            if (!dataTypes[0] || s2.converters[type2 + " " + dataTypes[0]]) {
              finalDataType = type2;
              break;
            }
            firstDataType || (firstDataType = type2);
          }
          finalDataType = finalDataType || firstDataType;
        }
        if (finalDataType)
          return finalDataType !== dataTypes[0] && dataTypes.unshift(finalDataType), responses[finalDataType];
      }
      __name(ajaxHandleResponses, "ajaxHandleResponses");
      function ajaxConvert(s2, response, jqXHR, isSuccess) {
        var conv2, current, conv, tmp, prev2, converters = {}, dataTypes = s2.dataTypes.slice();
        if (dataTypes[1])
          for (conv in s2.converters)
            converters[conv.toLowerCase()] = s2.converters[conv];
        for (current = dataTypes.shift(); current; )
          if (s2.responseFields[current] && (jqXHR[s2.responseFields[current]] = response), !prev2 && isSuccess && s2.dataFilter && (response = s2.dataFilter(response, s2.dataType)), prev2 = current, current = dataTypes.shift(), current) {
            if (current === "*")
              current = prev2;
            else if (prev2 !== "*" && prev2 !== current) {
              if (conv = converters[prev2 + " " + current] || converters["* " + current], !conv) {
                for (conv2 in converters)
                  if (tmp = conv2.split(" "), tmp[1] === current && (conv = converters[prev2 + " " + tmp[0]] || converters["* " + tmp[0]], conv)) {
                    conv === !0 ? conv = converters[conv2] : converters[conv2] !== !0 && (current = tmp[0], dataTypes.unshift(tmp[1]));
                    break;
                  }
              }
              if (conv !== !0)
                if (conv && s2.throws)
                  response = conv(response);
                else
                  try {
                    response = conv(response);
                  } catch (e2) {
                    return {
                      state: "parsererror",
                      error: conv ? e2 : "No conversion from " + prev2 + " to " + current
                    };
                  }
            }
          }
        return { state: "success", data: response };
      }
      __name(ajaxConvert, "ajaxConvert"), jQuery2.extend({
        // Counter for holding the number of active queries
        active: 0,
        // Last-Modified header cache for next request
        lastModified: {},
        etag: {},
        ajaxSettings: {
          url: location2.href,
          type: "GET",
          isLocal: rlocalProtocol.test(location2.protocol),
          global: !0,
          processData: !0,
          async: !0,
          contentType: "application/x-www-form-urlencoded; charset=UTF-8",
          /*
          timeout: 0,
          data: null,
          dataType: null,
          username: null,
          password: null,
          cache: null,
          throws: false,
          traditional: false,
          headers: {},
          */
          accepts: {
            "*": allTypes,
            text: "text/plain",
            html: "text/html",
            xml: "application/xml, text/xml",
            json: "application/json, text/javascript"
          },
          contents: {
            xml: /\bxml\b/,
            html: /\bhtml/,
            json: /\bjson\b/
          },
          responseFields: {
            xml: "responseXML",
            text: "responseText",
            json: "responseJSON"
          },
          // Data converters
          // Keys separate source (or catchall "*") and destination types with a single space
          converters: {
            // Convert anything to text
            "* text": String,
            // Text to html (true = no transformation)
            "text html": !0,
            // Evaluate text as a json expression
            "text json": JSON.parse,
            // Parse text as xml
            "text xml": jQuery2.parseXML
          },
          // For options that shouldn't be deep extended:
          // you can add your own custom options here if
          // and when you create one that shouldn't be
          // deep extended (see ajaxExtend)
          flatOptions: {
            url: !0,
            context: !0
          }
        },
        // Creates a full fledged settings object into target
        // with both ajaxSettings and settings fields.
        // If target is omitted, writes into ajaxSettings.
        ajaxSetup: /* @__PURE__ */ __name(function(target2, settings) {
          return settings ? (
            // Building a settings object
            ajaxExtend(ajaxExtend(target2, jQuery2.ajaxSettings), settings)
          ) : (
            // Extending ajaxSettings
            ajaxExtend(jQuery2.ajaxSettings, target2)
          );
        }, "ajaxSetup"),
        ajaxPrefilter: addToPrefiltersOrTransports(prefilters),
        ajaxTransport: addToPrefiltersOrTransports(transports2),
        // Main method
        ajax: /* @__PURE__ */ __name(function(url2, options2) {
          typeof url2 == "object" && (options2 = url2, url2 = void 0), options2 = options2 || {};
          var transport, cacheURL, responseHeadersString, responseHeaders, timeoutTimer, urlAnchor, completed2, fireGlobals, i, uncached, s2 = jQuery2.ajaxSetup({}, options2), callbackContext = s2.context || s2, globalEventContext = s2.context && (callbackContext.nodeType || callbackContext.jquery) ? jQuery2(callbackContext) : jQuery2.event, deferred = jQuery2.Deferred(), completeDeferred = jQuery2.Callbacks("once memory"), statusCode = s2.statusCode || {}, requestHeaders = {}, requestHeadersNames = {}, strAbort = "canceled", jqXHR = {
            readyState: 0,
            // Builds headers hashtable if needed
            getResponseHeader: /* @__PURE__ */ __name(function(key) {
              var match3;
              if (completed2) {
                if (!responseHeaders)
                  for (responseHeaders = {}; match3 = rheaders.exec(responseHeadersString); )
                    responseHeaders[match3[1].toLowerCase() + " "] = (responseHeaders[match3[1].toLowerCase() + " "] || []).concat(match3[2]);
                match3 = responseHeaders[key.toLowerCase() + " "];
              }
              return match3 == null ? null : match3.join(", ");
            }, "getResponseHeader"),
            // Raw string
            getAllResponseHeaders: /* @__PURE__ */ __name(function() {
              return completed2 ? responseHeadersString : null;
            }, "getAllResponseHeaders"),
            // Caches the header
            setRequestHeader: /* @__PURE__ */ __name(function(name2, value3) {
              return completed2 == null && (name2 = requestHeadersNames[name2.toLowerCase()] = requestHeadersNames[name2.toLowerCase()] || name2, requestHeaders[name2] = value3), this;
            }, "setRequestHeader"),
            // Overrides response content-type header
            overrideMimeType: /* @__PURE__ */ __name(function(type2) {
              return completed2 == null && (s2.mimeType = type2), this;
            }, "overrideMimeType"),
            // Status-dependent callbacks
            statusCode: /* @__PURE__ */ __name(function(map2) {
              var code;
              if (map2)
                if (completed2)
                  jqXHR.always(map2[jqXHR.status]);
                else
                  for (code in map2)
                    statusCode[code] = [statusCode[code], map2[code]];
              return this;
            }, "statusCode"),
            // Cancel the request
            abort: /* @__PURE__ */ __name(function(statusText) {
              var finalText = statusText || strAbort;
              return transport && transport.abort(finalText), done(0, finalText), this;
            }, "abort")
          };
          if (deferred.promise(jqXHR), s2.url = ((url2 || s2.url || location2.href) + "").replace(rprotocol, location2.protocol + "//"), s2.type = options2.method || options2.type || s2.method || s2.type, s2.dataTypes = (s2.dataType || "*").toLowerCase().match(rnothtmlwhite) || [""], s2.crossDomain == null) {
            urlAnchor = document2.createElement("a");
            try {
              urlAnchor.href = s2.url, urlAnchor.href = urlAnchor.href, s2.crossDomain = originAnchor.protocol + "//" + originAnchor.host != urlAnchor.protocol + "//" + urlAnchor.host;
            } catch {
              s2.crossDomain = !0;
            }
          }
          if (s2.data && s2.processData && typeof s2.data != "string" && (s2.data = jQuery2.param(s2.data, s2.traditional)), inspectPrefiltersOrTransports(prefilters, s2, options2, jqXHR), completed2)
            return jqXHR;
          fireGlobals = jQuery2.event && s2.global, fireGlobals && jQuery2.active++ === 0 && jQuery2.event.trigger("ajaxStart"), s2.type = s2.type.toUpperCase(), s2.hasContent = !rnoContent.test(s2.type), cacheURL = s2.url.replace(rhash, ""), s2.hasContent ? s2.data && s2.processData && (s2.contentType || "").indexOf("application/x-www-form-urlencoded") === 0 && (s2.data = s2.data.replace(r20, "+")) : (uncached = s2.url.slice(cacheURL.length), s2.data && (s2.processData || typeof s2.data == "string") && (cacheURL += (rquery.test(cacheURL) ? "&" : "?") + s2.data, delete s2.data), s2.cache === !1 && (cacheURL = cacheURL.replace(rantiCache, "$1"), uncached = (rquery.test(cacheURL) ? "&" : "?") + "_=" + nonce.guid++ + uncached), s2.url = cacheURL + uncached), s2.ifModified && (jQuery2.lastModified[cacheURL] && jqXHR.setRequestHeader("If-Modified-Since", jQuery2.lastModified[cacheURL]), jQuery2.etag[cacheURL] && jqXHR.setRequestHeader("If-None-Match", jQuery2.etag[cacheURL])), (s2.data && s2.hasContent && s2.contentType !== !1 || options2.contentType) && jqXHR.setRequestHeader("Content-Type", s2.contentType), jqXHR.setRequestHeader(
            "Accept",
            s2.dataTypes[0] && s2.accepts[s2.dataTypes[0]] ? s2.accepts[s2.dataTypes[0]] + (s2.dataTypes[0] !== "*" ? ", " + allTypes + "; q=0.01" : "") : s2.accepts["*"]
          );
          for (i in s2.headers)
            jqXHR.setRequestHeader(i, s2.headers[i]);
          if (s2.beforeSend && (s2.beforeSend.call(callbackContext, jqXHR, s2) === !1 || completed2))
            return jqXHR.abort();
          if (strAbort = "abort", completeDeferred.add(s2.complete), jqXHR.done(s2.success), jqXHR.fail(s2.error), transport = inspectPrefiltersOrTransports(transports2, s2, options2, jqXHR), !transport)
            done(-1, "No Transport");
          else {
            if (jqXHR.readyState = 1, fireGlobals && globalEventContext.trigger("ajaxSend", [jqXHR, s2]), completed2)
              return jqXHR;
            s2.async && s2.timeout > 0 && (timeoutTimer = window2.setTimeout(function() {
              jqXHR.abort("timeout");
            }, s2.timeout));
            try {
              completed2 = !1, transport.send(requestHeaders, done);
            } catch (e2) {
              if (completed2)
                throw e2;
              done(-1, e2);
            }
          }
          function done(status, nativeStatusText, responses, headers) {
            var isSuccess, success, error2, response, modified, statusText = nativeStatusText;
            completed2 || (completed2 = !0, timeoutTimer && window2.clearTimeout(timeoutTimer), transport = void 0, responseHeadersString = headers || "", jqXHR.readyState = status > 0 ? 4 : 0, isSuccess = status >= 200 && status < 300 || status === 304, responses && (response = ajaxHandleResponses(s2, jqXHR, responses)), !isSuccess && jQuery2.inArray("script", s2.dataTypes) > -1 && jQuery2.inArray("json", s2.dataTypes) < 0 && (s2.converters["text script"] = function() {
            }), response = ajaxConvert(s2, response, jqXHR, isSuccess), isSuccess ? (s2.ifModified && (modified = jqXHR.getResponseHeader("Last-Modified"), modified && (jQuery2.lastModified[cacheURL] = modified), modified = jqXHR.getResponseHeader("etag"), modified && (jQuery2.etag[cacheURL] = modified)), status === 204 || s2.type === "HEAD" ? statusText = "nocontent" : status === 304 ? statusText = "notmodified" : (statusText = response.state, success = response.data, error2 = response.error, isSuccess = !error2)) : (error2 = statusText, (status || !statusText) && (statusText = "error", status < 0 && (status = 0))), jqXHR.status = status, jqXHR.statusText = (nativeStatusText || statusText) + "", isSuccess ? deferred.resolveWith(callbackContext, [success, statusText, jqXHR]) : deferred.rejectWith(callbackContext, [jqXHR, statusText, error2]), jqXHR.statusCode(statusCode), statusCode = void 0, fireGlobals && globalEventContext.trigger(
              isSuccess ? "ajaxSuccess" : "ajaxError",
              [jqXHR, s2, isSuccess ? success : error2]
            ), completeDeferred.fireWith(callbackContext, [jqXHR, statusText]), fireGlobals && (globalEventContext.trigger("ajaxComplete", [jqXHR, s2]), --jQuery2.active || jQuery2.event.trigger("ajaxStop")));
          }
          return __name(done, "done"), jqXHR;
        }, "ajax"),
        getJSON: /* @__PURE__ */ __name(function(url2, data49, callback) {
          return jQuery2.get(url2, data49, callback, "json");
        }, "getJSON"),
        getScript: /* @__PURE__ */ __name(function(url2, callback) {
          return jQuery2.get(url2, void 0, callback, "script");
        }, "getScript")
      }), jQuery2.each(["get", "post"], function(_i, method) {
        jQuery2[method] = function(url2, data49, callback, type2) {
          return isFunction3(data49) && (type2 = type2 || callback, callback = data49, data49 = void 0), jQuery2.ajax(jQuery2.extend({
            url: url2,
            type: method,
            dataType: type2,
            data: data49,
            success: callback
          }, jQuery2.isPlainObject(url2) && url2));
        };
      }), jQuery2.ajaxPrefilter(function(s2) {
        var i;
        for (i in s2.headers)
          i.toLowerCase() === "content-type" && (s2.contentType = s2.headers[i] || "");
      }), jQuery2._evalUrl = function(url2, options2, doc) {
        return jQuery2.ajax({
          url: url2,
          // Make this explicit, since user can override this through ajaxSetup (trac-11264)
          type: "GET",
          dataType: "script",
          cache: !0,
          async: !1,
          global: !1,
          // Only evaluate the response if it is successful (gh-4126)
          // dataFilter is not invoked for failure responses, so using it instead
          // of the default converter is kludgy but it works.
          converters: {
            "text script": /* @__PURE__ */ __name(function() {
            }, "text script")
          },
          dataFilter: /* @__PURE__ */ __name(function(response) {
            jQuery2.globalEval(response, options2, doc);
          }, "dataFilter")
        });
      }, jQuery2.fn.extend({
        wrapAll: /* @__PURE__ */ __name(function(html2) {
          var wrap;
          return this[0] && (isFunction3(html2) && (html2 = html2.call(this[0])), wrap = jQuery2(html2, this[0].ownerDocument).eq(0).clone(!0), this[0].parentNode && wrap.insertBefore(this[0]), wrap.map(function() {
            for (var elem = this; elem.firstElementChild; )
              elem = elem.firstElementChild;
            return elem;
          }).append(this)), this;
        }, "wrapAll"),
        wrapInner: /* @__PURE__ */ __name(function(html2) {
          return isFunction3(html2) ? this.each(function(i) {
            jQuery2(this).wrapInner(html2.call(this, i));
          }) : this.each(function() {
            var self2 = jQuery2(this), contents = self2.contents();
            contents.length ? contents.wrapAll(html2) : self2.append(html2);
          });
        }, "wrapInner"),
        wrap: /* @__PURE__ */ __name(function(html2) {
          var htmlIsFunction = isFunction3(html2);
          return this.each(function(i) {
            jQuery2(this).wrapAll(htmlIsFunction ? html2.call(this, i) : html2);
          });
        }, "wrap"),
        unwrap: /* @__PURE__ */ __name(function(selector) {
          return this.parent(selector).not("body").each(function() {
            jQuery2(this).replaceWith(this.childNodes);
          }), this;
        }, "unwrap")
      }), jQuery2.expr.pseudos.hidden = function(elem) {
        return !jQuery2.expr.pseudos.visible(elem);
      }, jQuery2.expr.pseudos.visible = function(elem) {
        return !!(elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length);
      }, jQuery2.ajaxSettings.xhr = function() {
        try {
          return new window2.XMLHttpRequest();
        } catch {
        }
      };
      var xhrSuccessStatus = {
        // File protocol always yields status code 0, assume 200
        0: 200,
        // Support: IE <=9 only
        // trac-1450: sometimes IE returns 1223 when it should be 204
        1223: 204
      }, xhrSupported = jQuery2.ajaxSettings.xhr();
      support2.cors = !!xhrSupported && "withCredentials" in xhrSupported, support2.ajax = xhrSupported = !!xhrSupported, jQuery2.ajaxTransport(function(options2) {
        var callback, errorCallback;
        if (support2.cors || xhrSupported && !options2.crossDomain)
          return {
            send: /* @__PURE__ */ __name(function(headers, complete) {
              var i, xhr = options2.xhr();
              if (xhr.open(
                options2.type,
                options2.url,
                options2.async,
                options2.username,
                options2.password
              ), options2.xhrFields)
                for (i in options2.xhrFields)
                  xhr[i] = options2.xhrFields[i];
              options2.mimeType && xhr.overrideMimeType && xhr.overrideMimeType(options2.mimeType), !options2.crossDomain && !headers["X-Requested-With"] && (headers["X-Requested-With"] = "XMLHttpRequest");
              for (i in headers)
                xhr.setRequestHeader(i, headers[i]);
              callback = /* @__PURE__ */ __name(function(type2) {
                return function() {
                  callback && (callback = errorCallback = xhr.onload = xhr.onerror = xhr.onabort = xhr.ontimeout = xhr.onreadystatechange = null, type2 === "abort" ? xhr.abort() : type2 === "error" ? typeof xhr.status != "number" ? complete(0, "error") : complete(
                    // File: protocol always yields status 0; see trac-8605, trac-14207
                    xhr.status,
                    xhr.statusText
                  ) : complete(
                    xhrSuccessStatus[xhr.status] || xhr.status,
                    xhr.statusText,
                    // Support: IE <=9 only
                    // IE9 has no XHR2 but throws on binary (trac-11426)
                    // For XHR2 non-text, let the caller handle it (gh-2498)
                    (xhr.responseType || "text") !== "text" || typeof xhr.responseText != "string" ? { binary: xhr.response } : { text: xhr.responseText },
                    xhr.getAllResponseHeaders()
                  ));
                };
              }, "callback"), xhr.onload = callback(), errorCallback = xhr.onerror = xhr.ontimeout = callback("error"), xhr.onabort !== void 0 ? xhr.onabort = errorCallback : xhr.onreadystatechange = function() {
                xhr.readyState === 4 && window2.setTimeout(function() {
                  callback && errorCallback();
                });
              }, callback = callback("abort");
              try {
                xhr.send(options2.hasContent && options2.data || null);
              } catch (e2) {
                if (callback)
                  throw e2;
              }
            }, "send"),
            abort: /* @__PURE__ */ __name(function() {
              callback && callback();
            }, "abort")
          };
      }), jQuery2.ajaxPrefilter(function(s2) {
        s2.crossDomain && (s2.contents.script = !1);
      }), jQuery2.ajaxSetup({
        accepts: {
          script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"
        },
        contents: {
          script: /\b(?:java|ecma)script\b/
        },
        converters: {
          "text script": /* @__PURE__ */ __name(function(text2) {
            return jQuery2.globalEval(text2), text2;
          }, "text script")
        }
      }), jQuery2.ajaxPrefilter("script", function(s2) {
        s2.cache === void 0 && (s2.cache = !1), s2.crossDomain && (s2.type = "GET");
      }), jQuery2.ajaxTransport("script", function(s2) {
        if (s2.crossDomain || s2.scriptAttrs) {
          var script2, callback;
          return {
            send: /* @__PURE__ */ __name(function(_2, complete) {
              script2 = jQuery2("<script>").attr(s2.scriptAttrs || {}).prop({ charset: s2.scriptCharset, src: s2.url }).on("load error", callback = /* @__PURE__ */ __name(function(evt) {
                script2.remove(), callback = null, evt && complete(evt.type === "error" ? 404 : 200, evt.type);
              }, "callback")), document2.head.appendChild(script2[0]);
            }, "send"),
            abort: /* @__PURE__ */ __name(function() {
              callback && callback();
            }, "abort")
          };
        }
      });
      var oldCallbacks = [], rjsonp = /(=)\?(?=&|$)|\?\?/;
      jQuery2.ajaxSetup({
        jsonp: "callback",
        jsonpCallback: /* @__PURE__ */ __name(function() {
          var callback = oldCallbacks.pop() || jQuery2.expando + "_" + nonce.guid++;
          return this[callback] = !0, callback;
        }, "jsonpCallback")
      }), jQuery2.ajaxPrefilter("json jsonp", function(s2, originalSettings, jqXHR) {
        var callbackName, overwritten, responseContainer, jsonProp = s2.jsonp !== !1 && (rjsonp.test(s2.url) ? "url" : typeof s2.data == "string" && (s2.contentType || "").indexOf("application/x-www-form-urlencoded") === 0 && rjsonp.test(s2.data) && "data");
        if (jsonProp || s2.dataTypes[0] === "jsonp")
          return callbackName = s2.jsonpCallback = isFunction3(s2.jsonpCallback) ? s2.jsonpCallback() : s2.jsonpCallback, jsonProp ? s2[jsonProp] = s2[jsonProp].replace(rjsonp, "$1" + callbackName) : s2.jsonp !== !1 && (s2.url += (rquery.test(s2.url) ? "&" : "?") + s2.jsonp + "=" + callbackName), s2.converters["script json"] = function() {
            return responseContainer || jQuery2.error(callbackName + " was not called"), responseContainer[0];
          }, s2.dataTypes[0] = "json", overwritten = window2[callbackName], window2[callbackName] = function() {
            responseContainer = arguments;
          }, jqXHR.always(function() {
            overwritten === void 0 ? jQuery2(window2).removeProp(callbackName) : window2[callbackName] = overwritten, s2[callbackName] && (s2.jsonpCallback = originalSettings.jsonpCallback, oldCallbacks.push(callbackName)), responseContainer && isFunction3(overwritten) && overwritten(responseContainer[0]), responseContainer = overwritten = void 0;
          }), "script";
      }), support2.createHTMLDocument = function() {
        var body = document2.implementation.createHTMLDocument("").body;
        return body.innerHTML = "<form></form><form></form>", body.childNodes.length === 2;
      }(), jQuery2.parseHTML = function(data49, context7, keepScripts) {
        if (typeof data49 != "string")
          return [];
        typeof context7 == "boolean" && (keepScripts = context7, context7 = !1);
        var base, parsed, scripts;
        return context7 || (support2.createHTMLDocument ? (context7 = document2.implementation.createHTMLDocument(""), base = context7.createElement("base"), base.href = document2.location.href, context7.head.appendChild(base)) : context7 = document2), parsed = rsingleTag.exec(data49), scripts = !keepScripts && [], parsed ? [context7.createElement(parsed[1])] : (parsed = buildFragment([data49], context7, scripts), scripts && scripts.length && jQuery2(scripts).remove(), jQuery2.merge([], parsed.childNodes));
      }, jQuery2.fn.load = function(url2, params, callback) {
        var selector, type2, response, self2 = this, off2 = url2.indexOf(" ");
        return off2 > -1 && (selector = stripAndCollapse(url2.slice(off2)), url2 = url2.slice(0, off2)), isFunction3(params) ? (callback = params, params = void 0) : params && typeof params == "object" && (type2 = "POST"), self2.length > 0 && jQuery2.ajax({
          url: url2,
          // If "type" variable is undefined, then "GET" method will be used.
          // Make value of this field explicit since
          // user can override it through ajaxSetup method
          type: type2 || "GET",
          dataType: "html",
          data: params
        }).done(function(responseText) {
          response = arguments, self2.html(selector ? (
            // If a selector was specified, locate the right elements in a dummy div
            // Exclude scripts to avoid IE 'Permission Denied' errors
            jQuery2("<div>").append(jQuery2.parseHTML(responseText)).find(selector)
          ) : (
            // Otherwise use the full result
            responseText
          ));
        }).always(callback && function(jqXHR, status) {
          self2.each(function() {
            callback.apply(this, response || [jqXHR.responseText, status, jqXHR]);
          });
        }), this;
      }, jQuery2.expr.pseudos.animated = function(elem) {
        return jQuery2.grep(jQuery2.timers, function(fn2) {
          return elem === fn2.elem;
        }).length;
      }, jQuery2.offset = {
        setOffset: /* @__PURE__ */ __name(function(elem, options2, i) {
          var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition, position3 = jQuery2.css(elem, "position"), curElem = jQuery2(elem), props2 = {};
          position3 === "static" && (elem.style.position = "relative"), curOffset = curElem.offset(), curCSSTop = jQuery2.css(elem, "top"), curCSSLeft = jQuery2.css(elem, "left"), calculatePosition = (position3 === "absolute" || position3 === "fixed") && (curCSSTop + curCSSLeft).indexOf("auto") > -1, calculatePosition ? (curPosition = curElem.position(), curTop = curPosition.top, curLeft = curPosition.left) : (curTop = parseFloat(curCSSTop) || 0, curLeft = parseFloat(curCSSLeft) || 0), isFunction3(options2) && (options2 = options2.call(elem, i, jQuery2.extend({}, curOffset))), options2.top != null && (props2.top = options2.top - curOffset.top + curTop), options2.left != null && (props2.left = options2.left - curOffset.left + curLeft), "using" in options2 ? options2.using.call(elem, props2) : curElem.css(props2);
        }, "setOffset")
      }, jQuery2.fn.extend({
        // offset() relates an element's border box to the document origin
        offset: /* @__PURE__ */ __name(function(options2) {
          if (arguments.length)
            return options2 === void 0 ? this : this.each(function(i) {
              jQuery2.offset.setOffset(this, options2, i);
            });
          var rect, win, elem = this[0];
          if (elem)
            return elem.getClientRects().length ? (rect = elem.getBoundingClientRect(), win = elem.ownerDocument.defaultView, {
              top: rect.top + win.pageYOffset,
              left: rect.left + win.pageXOffset
            }) : { top: 0, left: 0 };
        }, "offset"),
        // position() relates an element's margin box to its offset parent's padding box
        // This corresponds to the behavior of CSS absolute positioning
        position: /* @__PURE__ */ __name(function() {
          if (this[0]) {
            var offsetParent, offset3, doc, elem = this[0], parentOffset = { top: 0, left: 0 };
            if (jQuery2.css(elem, "position") === "fixed")
              offset3 = elem.getBoundingClientRect();
            else {
              for (offset3 = this.offset(), doc = elem.ownerDocument, offsetParent = elem.offsetParent || doc.documentElement; offsetParent && (offsetParent === doc.body || offsetParent === doc.documentElement) && jQuery2.css(offsetParent, "position") === "static"; )
                offsetParent = offsetParent.parentNode;
              offsetParent && offsetParent !== elem && offsetParent.nodeType === 1 && (parentOffset = jQuery2(offsetParent).offset(), parentOffset.top += jQuery2.css(offsetParent, "borderTopWidth", !0), parentOffset.left += jQuery2.css(offsetParent, "borderLeftWidth", !0));
            }
            return {
              top: offset3.top - parentOffset.top - jQuery2.css(elem, "marginTop", !0),
              left: offset3.left - parentOffset.left - jQuery2.css(elem, "marginLeft", !0)
            };
          }
        }, "position"),
        // This method will return documentElement in the following cases:
        // 1) For the element inside the iframe without offsetParent, this method will return
        //    documentElement of the parent window
        // 2) For the hidden or detached element
        // 3) For body or html element, i.e. in case of the html node - it will return itself
        //
        // but those exceptions were never presented as a real life use-cases
        // and might be considered as more preferable results.
        //
        // This logic, however, is not guaranteed and can change at any point in the future
        offsetParent: /* @__PURE__ */ __name(function() {
          return this.map(function() {
            for (var offsetParent = this.offsetParent; offsetParent && jQuery2.css(offsetParent, "position") === "static"; )
              offsetParent = offsetParent.offsetParent;
            return offsetParent || documentElement;
          });
        }, "offsetParent")
      }), jQuery2.each({ scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function(method, prop2) {
        var top2 = prop2 === "pageYOffset";
        jQuery2.fn[method] = function(val) {
          return access(this, function(elem, method2, val2) {
            var win;
            if (isWindow(elem) ? win = elem : elem.nodeType === 9 && (win = elem.defaultView), val2 === void 0)
              return win ? win[prop2] : elem[method2];
            win ? win.scrollTo(
              top2 ? win.pageXOffset : val2,
              top2 ? val2 : win.pageYOffset
            ) : elem[method2] = val2;
          }, method, val, arguments.length);
        };
      }), jQuery2.each(["top", "left"], function(_i, prop2) {
        jQuery2.cssHooks[prop2] = addGetHookIf(
          support2.pixelPosition,
          function(elem, computed2) {
            if (computed2)
              return computed2 = curCSS(elem, prop2), rnumnonpx.test(computed2) ? jQuery2(elem).position()[prop2] + "px" : computed2;
          }
        );
      }), jQuery2.each({ Height: "height", Width: "width" }, function(name2, type2) {
        jQuery2.each({
          padding: "inner" + name2,
          content: type2,
          "": "outer" + name2
        }, function(defaultExtra, funcName) {
          jQuery2.fn[funcName] = function(margin, value3) {
            var chainable = arguments.length && (defaultExtra || typeof margin != "boolean"), extra = defaultExtra || (margin === !0 || value3 === !0 ? "margin" : "border");
            return access(this, function(elem, type3, value4) {
              var doc;
              return isWindow(elem) ? funcName.indexOf("outer") === 0 ? elem["inner" + name2] : elem.document.documentElement["client" + name2] : elem.nodeType === 9 ? (doc = elem.documentElement, Math.max(
                elem.body["scroll" + name2],
                doc["scroll" + name2],
                elem.body["offset" + name2],
                doc["offset" + name2],
                doc["client" + name2]
              )) : value4 === void 0 ? (
                // Get width or height on the element, requesting but not forcing parseFloat
                jQuery2.css(elem, type3, extra)
              ) : (
                // Set width or height on the element
                jQuery2.style(elem, type3, value4, extra)
              );
            }, type2, chainable ? margin : void 0, chainable);
          };
        });
      }), jQuery2.each([
        "ajaxStart",
        "ajaxStop",
        "ajaxComplete",
        "ajaxError",
        "ajaxSuccess",
        "ajaxSend"
      ], function(_i, type2) {
        jQuery2.fn[type2] = function(fn2) {
          return this.on(type2, fn2);
        };
      }), jQuery2.fn.extend({
        bind: /* @__PURE__ */ __name(function(types2, data49, fn2) {
          return this.on(types2, null, data49, fn2);
        }, "bind"),
        unbind: /* @__PURE__ */ __name(function(types2, fn2) {
          return this.off(types2, null, fn2);
        }, "unbind"),
        delegate: /* @__PURE__ */ __name(function(selector, types2, data49, fn2) {
          return this.on(types2, selector, data49, fn2);
        }, "delegate"),
        undelegate: /* @__PURE__ */ __name(function(selector, types2, fn2) {
          return arguments.length === 1 ? this.off(selector, "**") : this.off(types2, selector || "**", fn2);
        }, "undelegate"),
        hover: /* @__PURE__ */ __name(function(fnOver, fnOut) {
          return this.on("mouseenter", fnOver).on("mouseleave", fnOut || fnOver);
        }, "hover")
      }), jQuery2.each(
        "blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),
        function(_i, name2) {
          jQuery2.fn[name2] = function(data49, fn2) {
            return arguments.length > 0 ? this.on(name2, null, data49, fn2) : this.trigger(name2);
          };
        }
      );
      var rtrim = /^[\s\uFEFF\xA0]+|([^\s\uFEFF\xA0])[\s\uFEFF\xA0]+$/g;
      jQuery2.proxy = function(fn2, context7) {
        var tmp, args, proxy2;
        if (typeof context7 == "string" && (tmp = fn2[context7], context7 = fn2, fn2 = tmp), !!isFunction3(fn2))
          return args = slice.call(arguments, 2), proxy2 = /* @__PURE__ */ __name(function() {
            return fn2.apply(context7 || this, args.concat(slice.call(arguments)));
          }, "proxy"), proxy2.guid = fn2.guid = fn2.guid || jQuery2.guid++, proxy2;
      }, jQuery2.holdReady = function(hold) {
        hold ? jQuery2.readyWait++ : jQuery2.ready(!0);
      }, jQuery2.isArray = Array.isArray, jQuery2.parseJSON = JSON.parse, jQuery2.nodeName = nodeName, jQuery2.isFunction = isFunction3, jQuery2.isWindow = isWindow, jQuery2.camelCase = camelCase, jQuery2.type = toType4, jQuery2.now = Date.now, jQuery2.isNumeric = function(obj2) {
        var type2 = jQuery2.type(obj2);
        return (type2 === "number" || type2 === "string") && // parseFloat NaNs numeric-cast false positives ("")
        // ...but misinterprets leading-number strings, particularly hex literals ("0x...")
        // subtraction forces infinities to NaN
        !isNaN(obj2 - parseFloat(obj2));
      }, jQuery2.trim = function(text2) {
        return text2 == null ? "" : (text2 + "").replace(rtrim, "$1");
      };
      var _jQuery = window2.jQuery, _$ = window2.$;
      return jQuery2.noConflict = function(deep) {
        return window2.$ === jQuery2 && (window2.$ = _$), deep && window2.jQuery === jQuery2 && (window2.jQuery = _jQuery), jQuery2;
      }, typeof noGlobal > "u" && (window2.jQuery = window2.$ = jQuery2), jQuery2;
    });
  }(jquery)), jquery.exports;
}
__name(requireJquery, "requireJquery");
var jqueryExports = requireJquery();
const $$1 = /* @__PURE__ */ getDefaultExportFromCjs(jqueryExports);
Object.assign(window, {
  $: $$1,
  jQuery: $$1,
  jquery: $$1
});
/**!
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 1.16.1
 * @license
 * Copyright (c) 2016 Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
var isBrowser = typeof window < "u" && typeof document < "u" && typeof navigator < "u", timeoutDuration = function() {
  for (var longerTimeoutBrowsers = ["Edge", "Trident", "Firefox"], i = 0; i < longerTimeoutBrowsers.length; i += 1)
    if (isBrowser && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0)
      return 1;
  return 0;
}();
function microtaskDebounce(fn2) {
  var called = !1;
  return function() {
    called || (called = !0, window.Promise.resolve().then(function() {
      called = !1, fn2();
    }));
  };
}
__name(microtaskDebounce, "microtaskDebounce");
function taskDebounce(fn2) {
  var scheduled = !1;
  return function() {
    scheduled || (scheduled = !0, setTimeout(function() {
      scheduled = !1, fn2();
    }, timeoutDuration));
  };
}
__name(taskDebounce, "taskDebounce");
var supportsMicroTasks = isBrowser && window.Promise, debounce$2 = supportsMicroTasks ? microtaskDebounce : taskDebounce;
function isFunction$3(functionToCheck) {
  var getType2 = {};
  return functionToCheck && getType2.toString.call(functionToCheck) === "[object Function]";
}
__name(isFunction$3, "isFunction$3");
function getStyleComputedProperty(element, property) {
  if (element.nodeType !== 1)
    return [];
  var window2 = element.ownerDocument.defaultView, css2 = window2.getComputedStyle(element, null);
  return property ? css2[property] : css2;
}
__name(getStyleComputedProperty, "getStyleComputedProperty");
function getParentNode$1(element) {
  return element.nodeName === "HTML" ? element : element.parentNode || element.host;
}
__name(getParentNode$1, "getParentNode$1");
function getScrollParent$1(element) {
  if (!element)
    return document.body;
  switch (element.nodeName) {
    case "HTML":
    case "BODY":
      return element.ownerDocument.body;
    case "#document":
      return element.body;
  }
  var _getStyleComputedProp = getStyleComputedProperty(element), overflow = _getStyleComputedProp.overflow, overflowX = _getStyleComputedProp.overflowX, overflowY = _getStyleComputedProp.overflowY;
  return /(auto|scroll|overlay)/.test(overflow + overflowY + overflowX) ? element : getScrollParent$1(getParentNode$1(element));
}
__name(getScrollParent$1, "getScrollParent$1");
function getReferenceNode(reference2) {
  return reference2 && reference2.referenceNode ? reference2.referenceNode : reference2;
}
__name(getReferenceNode, "getReferenceNode");
var isIE11 = isBrowser && !!(window.MSInputMethodContext && document.documentMode), isIE10 = isBrowser && /MSIE 10/.test(navigator.userAgent);
function isIE$2(version2) {
  return version2 === 11 ? isIE11 : version2 === 10 ? isIE10 : isIE11 || isIE10;
}
__name(isIE$2, "isIE$2");
function getOffsetParent$1(element) {
  if (!element)
    return document.documentElement;
  for (var noOffsetParent = isIE$2(10) ? document.body : null, offsetParent = element.offsetParent || null; offsetParent === noOffsetParent && element.nextElementSibling; )
    offsetParent = (element = element.nextElementSibling).offsetParent;
  var nodeName = offsetParent && offsetParent.nodeName;
  return !nodeName || nodeName === "BODY" || nodeName === "HTML" ? element ? element.ownerDocument.documentElement : document.documentElement : ["TH", "TD", "TABLE"].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, "position") === "static" ? getOffsetParent$1(offsetParent) : offsetParent;
}
__name(getOffsetParent$1, "getOffsetParent$1");
function isOffsetContainer(element) {
  var nodeName = element.nodeName;
  return nodeName === "BODY" ? !1 : nodeName === "HTML" || getOffsetParent$1(element.firstElementChild) === element;
}
__name(isOffsetContainer, "isOffsetContainer");
function getRoot(node) {
  return node.parentNode !== null ? getRoot(node.parentNode) : node;
}
__name(getRoot, "getRoot");
function findCommonOffsetParent(element1, element2) {
  if (!element1 || !element1.nodeType || !element2 || !element2.nodeType)
    return document.documentElement;
  var order2 = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING, start3 = order2 ? element1 : element2, end2 = order2 ? element2 : element1, range2 = document.createRange();
  range2.setStart(start3, 0), range2.setEnd(end2, 0);
  var commonAncestorContainer = range2.commonAncestorContainer;
  if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start3.contains(end2))
    return isOffsetContainer(commonAncestorContainer) ? commonAncestorContainer : getOffsetParent$1(commonAncestorContainer);
  var element1root = getRoot(element1);
  return element1root.host ? findCommonOffsetParent(element1root.host, element2) : findCommonOffsetParent(element1, getRoot(element2).host);
}
__name(findCommonOffsetParent, "findCommonOffsetParent");
function getScroll(element) {
  var side = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "top", upperSide = side === "top" ? "scrollTop" : "scrollLeft", nodeName = element.nodeName;
  if (nodeName === "BODY" || nodeName === "HTML") {
    var html2 = element.ownerDocument.documentElement, scrollingElement = element.ownerDocument.scrollingElement || html2;
    return scrollingElement[upperSide];
  }
  return element[upperSide];
}
__name(getScroll, "getScroll");
function includeScroll(rect, element) {
  var subtract = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : !1, scrollTop = getScroll(element, "top"), scrollLeft = getScroll(element, "left"), modifier = subtract ? -1 : 1;
  return rect.top += scrollTop * modifier, rect.bottom += scrollTop * modifier, rect.left += scrollLeft * modifier, rect.right += scrollLeft * modifier, rect;
}
__name(includeScroll, "includeScroll");
function getBordersSize(styles2, axis) {
  var sideA = axis === "x" ? "Left" : "Top", sideB = sideA === "Left" ? "Right" : "Bottom";
  return parseFloat(styles2["border" + sideA + "Width"]) + parseFloat(styles2["border" + sideB + "Width"]);
}
__name(getBordersSize, "getBordersSize");
function getSize(axis, body, html2, computedStyle2) {
  return Math.max(body["offset" + axis], body["scroll" + axis], html2["client" + axis], html2["offset" + axis], html2["scroll" + axis], isIE$2(10) ? parseInt(html2["offset" + axis]) + parseInt(computedStyle2["margin" + (axis === "Height" ? "Top" : "Left")]) + parseInt(computedStyle2["margin" + (axis === "Height" ? "Bottom" : "Right")]) : 0);
}
__name(getSize, "getSize");
function getWindowSizes(document2) {
  var body = document2.body, html2 = document2.documentElement, computedStyle2 = isIE$2(10) && getComputedStyle(html2);
  return {
    height: getSize("Height", body, html2, computedStyle2),
    width: getSize("Width", body, html2, computedStyle2)
  };
}
__name(getWindowSizes, "getWindowSizes");
var classCallCheck = /* @__PURE__ */ __name(function(instance, Constructor) {
  if (!(instance instanceof Constructor))
    throw new TypeError("Cannot call a class as a function");
}, "classCallCheck"), createClass = function() {
  function defineProperties3(target2, props2) {
    for (var i = 0; i < props2.length; i++) {
      var descriptor = props2[i];
      descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target2, descriptor.key, descriptor);
    }
  }
  return __name(defineProperties3, "defineProperties"), function(Constructor, protoProps, staticProps) {
    return protoProps && defineProperties3(Constructor.prototype, protoProps), staticProps && defineProperties3(Constructor, staticProps), Constructor;
  };
}(), defineProperty$2 = /* @__PURE__ */ __name(function(obj2, key, value3) {
  return key in obj2 ? Object.defineProperty(obj2, key, {
    value: value3,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : obj2[key] = value3, obj2;
}, "defineProperty$2"), _extends$1 = Object.assign || function(target2) {
  for (var i = 1; i < arguments.length; i++) {
    var source2 = arguments[i];
    for (var key in source2)
      Object.prototype.hasOwnProperty.call(source2, key) && (target2[key] = source2[key]);
  }
  return target2;
};
function getClientRect(offsets) {
  return _extends$1({}, offsets, {
    right: offsets.left + offsets.width,
    bottom: offsets.top + offsets.height
  });
}
__name(getClientRect, "getClientRect");
function getBoundingClientRect$1(element) {
  var rect = {};
  try {
    if (isIE$2(10)) {
      rect = element.getBoundingClientRect();
      var scrollTop = getScroll(element, "top"), scrollLeft = getScroll(element, "left");
      rect.top += scrollTop, rect.left += scrollLeft, rect.bottom += scrollTop, rect.right += scrollLeft;
    } else
      rect = element.getBoundingClientRect();
  } catch {
  }
  var result = {
    left: rect.left,
    top: rect.top,
    width: rect.right - rect.left,
    height: rect.bottom - rect.top
  }, sizes = element.nodeName === "HTML" ? getWindowSizes(element.ownerDocument) : {}, width = sizes.width || element.clientWidth || result.width, height = sizes.height || element.clientHeight || result.height, horizScrollbar = element.offsetWidth - width, vertScrollbar = element.offsetHeight - height;
  if (horizScrollbar || vertScrollbar) {
    var styles2 = getStyleComputedProperty(element);
    horizScrollbar -= getBordersSize(styles2, "x"), vertScrollbar -= getBordersSize(styles2, "y"), result.width -= horizScrollbar, result.height -= vertScrollbar;
  }
  return getClientRect(result);
}
__name(getBoundingClientRect$1, "getBoundingClientRect$1");
function getOffsetRectRelativeToArbitraryNode(children2, parent) {
  var fixedPosition = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : !1, isIE102 = isIE$2(10), isHTML = parent.nodeName === "HTML", childrenRect = getBoundingClientRect$1(children2), parentRect = getBoundingClientRect$1(parent), scrollParent = getScrollParent$1(children2), styles2 = getStyleComputedProperty(parent), borderTopWidth = parseFloat(styles2.borderTopWidth), borderLeftWidth = parseFloat(styles2.borderLeftWidth);
  fixedPosition && isHTML && (parentRect.top = Math.max(parentRect.top, 0), parentRect.left = Math.max(parentRect.left, 0));
  var offsets = getClientRect({
    top: childrenRect.top - parentRect.top - borderTopWidth,
    left: childrenRect.left - parentRect.left - borderLeftWidth,
    width: childrenRect.width,
    height: childrenRect.height
  });
  if (offsets.marginTop = 0, offsets.marginLeft = 0, !isIE102 && isHTML) {
    var marginTop = parseFloat(styles2.marginTop), marginLeft = parseFloat(styles2.marginLeft);
    offsets.top -= borderTopWidth - marginTop, offsets.bottom -= borderTopWidth - marginTop, offsets.left -= borderLeftWidth - marginLeft, offsets.right -= borderLeftWidth - marginLeft, offsets.marginTop = marginTop, offsets.marginLeft = marginLeft;
  }
  return (isIE102 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== "BODY") && (offsets = includeScroll(offsets, parent)), offsets;
}
__name(getOffsetRectRelativeToArbitraryNode, "getOffsetRectRelativeToArbitraryNode");
function getViewportOffsetRectRelativeToArtbitraryNode(element) {
  var excludeScroll = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : !1, html2 = element.ownerDocument.documentElement, relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html2), width = Math.max(html2.clientWidth, window.innerWidth || 0), height = Math.max(html2.clientHeight, window.innerHeight || 0), scrollTop = excludeScroll ? 0 : getScroll(html2), scrollLeft = excludeScroll ? 0 : getScroll(html2, "left"), offset3 = {
    top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
    left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
    width,
    height
  };
  return getClientRect(offset3);
}
__name(getViewportOffsetRectRelativeToArtbitraryNode, "getViewportOffsetRectRelativeToArtbitraryNode");
function isFixed(element) {
  var nodeName = element.nodeName;
  if (nodeName === "BODY" || nodeName === "HTML")
    return !1;
  if (getStyleComputedProperty(element, "position") === "fixed")
    return !0;
  var parentNode2 = getParentNode$1(element);
  return parentNode2 ? isFixed(parentNode2) : !1;
}
__name(isFixed, "isFixed");
function getFixedPositionOffsetParent(element) {
  if (!element || !element.parentElement || isIE$2())
    return document.documentElement;
  for (var el = element.parentElement; el && getStyleComputedProperty(el, "transform") === "none"; )
    el = el.parentElement;
  return el || document.documentElement;
}
__name(getFixedPositionOffsetParent, "getFixedPositionOffsetParent");
function getBoundaries(popper2, reference2, padding2, boundariesElement) {
  var fixedPosition = arguments.length > 4 && arguments[4] !== void 0 ? arguments[4] : !1, boundaries = { top: 0, left: 0 }, offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper2) : findCommonOffsetParent(popper2, getReferenceNode(reference2));
  if (boundariesElement === "viewport")
    boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
  else {
    var boundariesNode = void 0;
    boundariesElement === "scrollParent" ? (boundariesNode = getScrollParent$1(getParentNode$1(reference2)), boundariesNode.nodeName === "BODY" && (boundariesNode = popper2.ownerDocument.documentElement)) : boundariesElement === "window" ? boundariesNode = popper2.ownerDocument.documentElement : boundariesNode = boundariesElement;
    var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition);
    if (boundariesNode.nodeName === "HTML" && !isFixed(offsetParent)) {
      var _getWindowSizes = getWindowSizes(popper2.ownerDocument), height = _getWindowSizes.height, width = _getWindowSizes.width;
      boundaries.top += offsets.top - offsets.marginTop, boundaries.bottom = height + offsets.top, boundaries.left += offsets.left - offsets.marginLeft, boundaries.right = width + offsets.left;
    } else
      boundaries = offsets;
  }
  padding2 = padding2 || 0;
  var isPaddingNumber = typeof padding2 == "number";
  return boundaries.left += isPaddingNumber ? padding2 : padding2.left || 0, boundaries.top += isPaddingNumber ? padding2 : padding2.top || 0, boundaries.right -= isPaddingNumber ? padding2 : padding2.right || 0, boundaries.bottom -= isPaddingNumber ? padding2 : padding2.bottom || 0, boundaries;
}
__name(getBoundaries, "getBoundaries");
function getArea(_ref) {
  var width = _ref.width, height = _ref.height;
  return width * height;
}
__name(getArea, "getArea");
function computeAutoPlacement$1(placement, refRect, popper2, reference2, boundariesElement) {
  var padding2 = arguments.length > 5 && arguments[5] !== void 0 ? arguments[5] : 0;
  if (placement.indexOf("auto") === -1)
    return placement;
  var boundaries = getBoundaries(popper2, reference2, padding2, boundariesElement), rects = {
    top: {
      width: boundaries.width,
      height: refRect.top - boundaries.top
    },
    right: {
      width: boundaries.right - refRect.right,
      height: boundaries.height
    },
    bottom: {
      width: boundaries.width,
      height: boundaries.bottom - refRect.bottom
    },
    left: {
      width: refRect.left - boundaries.left,
      height: boundaries.height
    }
  }, sortedAreas = Object.keys(rects).map(function(key) {
    return _extends$1({
      key
    }, rects[key], {
      area: getArea(rects[key])
    });
  }).sort(function(a2, b) {
    return b.area - a2.area;
  }), filteredAreas = sortedAreas.filter(function(_ref2) {
    var width = _ref2.width, height = _ref2.height;
    return width >= popper2.clientWidth && height >= popper2.clientHeight;
  }), computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key, variation = placement.split("-")[1];
  return computedPlacement + (variation ? "-" + variation : "");
}
__name(computeAutoPlacement$1, "computeAutoPlacement$1");
function getReferenceOffsets(state, popper2, reference2) {
  var fixedPosition = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : null, commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper2) : findCommonOffsetParent(popper2, getReferenceNode(reference2));
  return getOffsetRectRelativeToArbitraryNode(reference2, commonOffsetParent, fixedPosition);
}
__name(getReferenceOffsets, "getReferenceOffsets");
function getOuterSizes(element) {
  var window2 = element.ownerDocument.defaultView, styles2 = window2.getComputedStyle(element), x = parseFloat(styles2.marginTop || 0) + parseFloat(styles2.marginBottom || 0), y = parseFloat(styles2.marginLeft || 0) + parseFloat(styles2.marginRight || 0), result = {
    width: element.offsetWidth + y,
    height: element.offsetHeight + x
  };
  return result;
}
__name(getOuterSizes, "getOuterSizes");
function getOppositePlacement$1(placement) {
  var hash2 = { left: "right", right: "left", bottom: "top", top: "bottom" };
  return placement.replace(/left|right|bottom|top/g, function(matched) {
    return hash2[matched];
  });
}
__name(getOppositePlacement$1, "getOppositePlacement$1");
function getPopperOffsets(popper2, referenceOffsets, placement) {
  placement = placement.split("-")[0];
  var popperRect = getOuterSizes(popper2), popperOffsets2 = {
    width: popperRect.width,
    height: popperRect.height
  }, isHoriz = ["right", "left"].indexOf(placement) !== -1, mainSide = isHoriz ? "top" : "left", secondarySide = isHoriz ? "left" : "top", measurement = isHoriz ? "height" : "width", secondaryMeasurement = isHoriz ? "width" : "height";
  return popperOffsets2[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2, placement === secondarySide ? popperOffsets2[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement] : popperOffsets2[secondarySide] = referenceOffsets[getOppositePlacement$1(secondarySide)], popperOffsets2;
}
__name(getPopperOffsets, "getPopperOffsets");
function find$3(arr, check) {
  return Array.prototype.find ? arr.find(check) : arr.filter(check)[0];
}
__name(find$3, "find$3");
function findIndex$1(arr, prop2, value3) {
  if (Array.prototype.findIndex)
    return arr.findIndex(function(cur) {
      return cur[prop2] === value3;
    });
  var match3 = find$3(arr, function(obj2) {
    return obj2[prop2] === value3;
  });
  return arr.indexOf(match3);
}
__name(findIndex$1, "findIndex$1");
function runModifiers(modifiers2, data49, ends) {
  var modifiersToRun = ends === void 0 ? modifiers2 : modifiers2.slice(0, findIndex$1(modifiers2, "name", ends));
  return modifiersToRun.forEach(function(modifier) {
    modifier.function && console.warn("`modifier.function` is deprecated, use `modifier.fn`!");
    var fn2 = modifier.function || modifier.fn;
    modifier.enabled && isFunction$3(fn2) && (data49.offsets.popper = getClientRect(data49.offsets.popper), data49.offsets.reference = getClientRect(data49.offsets.reference), data49 = fn2(data49, modifier));
  }), data49;
}
__name(runModifiers, "runModifiers");
function update$1() {
  if (!this.state.isDestroyed) {
    var data49 = {
      instance: this,
      styles: {},
      arrowStyles: {},
      attributes: {},
      flipped: !1,
      offsets: {}
    };
    data49.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed), data49.placement = computeAutoPlacement$1(this.options.placement, data49.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding), data49.originalPlacement = data49.placement, data49.positionFixed = this.options.positionFixed, data49.offsets.popper = getPopperOffsets(this.popper, data49.offsets.reference, data49.placement), data49.offsets.popper.position = this.options.positionFixed ? "fixed" : "absolute", data49 = runModifiers(this.modifiers, data49), this.state.isCreated ? this.options.onUpdate(data49) : (this.state.isCreated = !0, this.options.onCreate(data49));
  }
}
__name(update$1, "update$1");
function isModifierEnabled(modifiers2, modifierName) {
  return modifiers2.some(function(_ref) {
    var name2 = _ref.name, enabled = _ref.enabled;
    return enabled && name2 === modifierName;
  });
}
__name(isModifierEnabled, "isModifierEnabled");
function getSupportedPropertyName(property) {
  for (var prefixes = [!1, "ms", "Webkit", "Moz", "O"], upperProp = property.charAt(0).toUpperCase() + property.slice(1), i = 0; i < prefixes.length; i++) {
    var prefix = prefixes[i], toCheck = prefix ? "" + prefix + upperProp : property;
    if (typeof document.body.style[toCheck] < "u")
      return toCheck;
  }
  return null;
}
__name(getSupportedPropertyName, "getSupportedPropertyName");
function destroy$1() {
  return this.state.isDestroyed = !0, isModifierEnabled(this.modifiers, "applyStyle") && (this.popper.removeAttribute("x-placement"), this.popper.style.position = "", this.popper.style.top = "", this.popper.style.left = "", this.popper.style.right = "", this.popper.style.bottom = "", this.popper.style.willChange = "", this.popper.style[getSupportedPropertyName("transform")] = ""), this.disableEventListeners(), this.options.removeOnDestroy && this.popper.parentNode.removeChild(this.popper), this;
}
__name(destroy$1, "destroy$1");
function getWindow$1(element) {
  var ownerDocument = element.ownerDocument;
  return ownerDocument ? ownerDocument.defaultView : window;
}
__name(getWindow$1, "getWindow$1");
function attachToScrollParents(scrollParent, event2, callback, scrollParents) {
  var isBody = scrollParent.nodeName === "BODY", target2 = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
  target2.addEventListener(event2, callback, { passive: !0 }), isBody || attachToScrollParents(getScrollParent$1(target2.parentNode), event2, callback, scrollParents), scrollParents.push(target2);
}
__name(attachToScrollParents, "attachToScrollParents");
function setupEventListeners(reference2, options2, state, updateBound) {
  state.updateBound = updateBound, getWindow$1(reference2).addEventListener("resize", state.updateBound, { passive: !0 });
  var scrollElement = getScrollParent$1(reference2);
  return attachToScrollParents(scrollElement, "scroll", state.updateBound, state.scrollParents), state.scrollElement = scrollElement, state.eventsEnabled = !0, state;
}
__name(setupEventListeners, "setupEventListeners");
function enableEventListeners() {
  this.state.eventsEnabled || (this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate));
}
__name(enableEventListeners, "enableEventListeners");
function removeEventListeners(reference2, state) {
  return getWindow$1(reference2).removeEventListener("resize", state.updateBound), state.scrollParents.forEach(function(target2) {
    target2.removeEventListener("scroll", state.updateBound);
  }), state.updateBound = null, state.scrollParents = [], state.scrollElement = null, state.eventsEnabled = !1, state;
}
__name(removeEventListeners, "removeEventListeners");
function disableEventListeners() {
  this.state.eventsEnabled && (cancelAnimationFrame(this.scheduleUpdate), this.state = removeEventListeners(this.reference, this.state));
}
__name(disableEventListeners, "disableEventListeners");
function isNumeric$1(n2) {
  return n2 !== "" && !isNaN(parseFloat(n2)) && isFinite(n2);
}
__name(isNumeric$1, "isNumeric$1");
function setStyles(element, styles2) {
  Object.keys(styles2).forEach(function(prop2) {
    var unit = "";
    ["width", "height", "top", "right", "bottom", "left"].indexOf(prop2) !== -1 && isNumeric$1(styles2[prop2]) && (unit = "px"), element.style[prop2] = styles2[prop2] + unit;
  });
}
__name(setStyles, "setStyles");
function setAttributes(element, attributes) {
  Object.keys(attributes).forEach(function(prop2) {
    var value3 = attributes[prop2];
    value3 !== !1 ? element.setAttribute(prop2, attributes[prop2]) : element.removeAttribute(prop2);
  });
}
__name(setAttributes, "setAttributes");
function applyStyle(data49) {
  return setStyles(data49.instance.popper, data49.styles), setAttributes(data49.instance.popper, data49.attributes), data49.arrowElement && Object.keys(data49.arrowStyles).length && setStyles(data49.arrowElement, data49.arrowStyles), data49;
}
__name(applyStyle, "applyStyle");
function applyStyleOnLoad(reference2, popper2, options2, modifierOptions, state) {
  var referenceOffsets = getReferenceOffsets(state, popper2, reference2, options2.positionFixed), placement = computeAutoPlacement$1(options2.placement, referenceOffsets, popper2, reference2, options2.modifiers.flip.boundariesElement, options2.modifiers.flip.padding);
  return popper2.setAttribute("x-placement", placement), setStyles(popper2, { position: options2.positionFixed ? "fixed" : "absolute" }), options2;
}
__name(applyStyleOnLoad, "applyStyleOnLoad");
function getRoundedOffsets(data49, shouldRound) {
  var _data$offsets = data49.offsets, popper2 = _data$offsets.popper, reference2 = _data$offsets.reference, round2 = Math.round, floor = Math.floor, noRound = /* @__PURE__ */ __name(function(v) {
    return v;
  }, "noRound"), referenceWidth = round2(reference2.width), popperWidth = round2(popper2.width), isVertical = ["left", "right"].indexOf(data49.placement) !== -1, isVariation = data49.placement.indexOf("-") !== -1, sameWidthParity = referenceWidth % 2 === popperWidth % 2, bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1, horizontalToInteger = shouldRound ? isVertical || isVariation || sameWidthParity ? round2 : floor : noRound, verticalToInteger = shouldRound ? round2 : noRound;
  return {
    left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper2.left - 1 : popper2.left),
    top: verticalToInteger(popper2.top),
    bottom: verticalToInteger(popper2.bottom),
    right: horizontalToInteger(popper2.right)
  };
}
__name(getRoundedOffsets, "getRoundedOffsets");
var isFirefox = isBrowser && /Firefox/i.test(navigator.userAgent);
function computeStyle(data49, options2) {
  var x = options2.x, y = options2.y, popper2 = data49.offsets.popper, legacyGpuAccelerationOption = find$3(data49.instance.modifiers, function(modifier) {
    return modifier.name === "applyStyle";
  }).gpuAcceleration;
  legacyGpuAccelerationOption !== void 0 && console.warn("WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!");
  var gpuAcceleration = legacyGpuAccelerationOption !== void 0 ? legacyGpuAccelerationOption : options2.gpuAcceleration, offsetParent = getOffsetParent$1(data49.instance.popper), offsetParentRect = getBoundingClientRect$1(offsetParent), styles2 = {
    position: popper2.position
  }, offsets = getRoundedOffsets(data49, window.devicePixelRatio < 2 || !isFirefox), sideA = x === "bottom" ? "top" : "bottom", sideB = y === "right" ? "left" : "right", prefixedProperty = getSupportedPropertyName("transform"), left2 = void 0, top2 = void 0;
  if (sideA === "bottom" ? offsetParent.nodeName === "HTML" ? top2 = -offsetParent.clientHeight + offsets.bottom : top2 = -offsetParentRect.height + offsets.bottom : top2 = offsets.top, sideB === "right" ? offsetParent.nodeName === "HTML" ? left2 = -offsetParent.clientWidth + offsets.right : left2 = -offsetParentRect.width + offsets.right : left2 = offsets.left, gpuAcceleration && prefixedProperty)
    styles2[prefixedProperty] = "translate3d(" + left2 + "px, " + top2 + "px, 0)", styles2[sideA] = 0, styles2[sideB] = 0, styles2.willChange = "transform";
  else {
    var invertTop = sideA === "bottom" ? -1 : 1, invertLeft = sideB === "right" ? -1 : 1;
    styles2[sideA] = top2 * invertTop, styles2[sideB] = left2 * invertLeft, styles2.willChange = sideA + ", " + sideB;
  }
  var attributes = {
    "x-placement": data49.placement
  };
  return data49.attributes = _extends$1({}, attributes, data49.attributes), data49.styles = _extends$1({}, styles2, data49.styles), data49.arrowStyles = _extends$1({}, data49.offsets.arrow, data49.arrowStyles), data49;
}
__name(computeStyle, "computeStyle");
function isModifierRequired(modifiers2, requestingName, requestedName) {
  var requesting = find$3(modifiers2, function(_ref) {
    var name2 = _ref.name;
    return name2 === requestingName;
  }), isRequired3 = !!requesting && modifiers2.some(function(modifier) {
    return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
  });
  if (!isRequired3) {
    var _requesting = "`" + requestingName + "`", requested = "`" + requestedName + "`";
    console.warn(requested + " modifier is required by " + _requesting + " modifier in order to work, be sure to include it before " + _requesting + "!");
  }
  return isRequired3;
}
__name(isModifierRequired, "isModifierRequired");
function arrow$2(data49, options2) {
  var _data$offsets$arrow;
  if (!isModifierRequired(data49.instance.modifiers, "arrow", "keepTogether"))
    return data49;
  var arrowElement = options2.element;
  if (typeof arrowElement == "string") {
    if (arrowElement = data49.instance.popper.querySelector(arrowElement), !arrowElement)
      return data49;
  } else if (!data49.instance.popper.contains(arrowElement))
    return console.warn("WARNING: `arrow.element` must be child of its popper element!"), data49;
  var placement = data49.placement.split("-")[0], _data$offsets = data49.offsets, popper2 = _data$offsets.popper, reference2 = _data$offsets.reference, isVertical = ["left", "right"].indexOf(placement) !== -1, len2 = isVertical ? "height" : "width", sideCapitalized = isVertical ? "Top" : "Left", side = sideCapitalized.toLowerCase(), altSide = isVertical ? "left" : "top", opSide = isVertical ? "bottom" : "right", arrowElementSize = getOuterSizes(arrowElement)[len2];
  reference2[opSide] - arrowElementSize < popper2[side] && (data49.offsets.popper[side] -= popper2[side] - (reference2[opSide] - arrowElementSize)), reference2[side] + arrowElementSize > popper2[opSide] && (data49.offsets.popper[side] += reference2[side] + arrowElementSize - popper2[opSide]), data49.offsets.popper = getClientRect(data49.offsets.popper);
  var center = reference2[side] + reference2[len2] / 2 - arrowElementSize / 2, css2 = getStyleComputedProperty(data49.instance.popper), popperMarginSide = parseFloat(css2["margin" + sideCapitalized]), popperBorderSide = parseFloat(css2["border" + sideCapitalized + "Width"]), sideValue = center - data49.offsets.popper[side] - popperMarginSide - popperBorderSide;
  return sideValue = Math.max(Math.min(popper2[len2] - arrowElementSize, sideValue), 0), data49.arrowElement = arrowElement, data49.offsets.arrow = (_data$offsets$arrow = {}, defineProperty$2(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty$2(_data$offsets$arrow, altSide, ""), _data$offsets$arrow), data49;
}
__name(arrow$2, "arrow$2");
function getOppositeVariation(variation) {
  return variation === "end" ? "start" : variation === "start" ? "end" : variation;
}
__name(getOppositeVariation, "getOppositeVariation");
var placements$1 = ["auto-start", "auto", "auto-end", "top-start", "top", "top-end", "right-start", "right", "right-end", "bottom-end", "bottom", "bottom-start", "left-end", "left", "left-start"], validPlacements = placements$1.slice(3);
function clockwise(placement) {
  var counter = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : !1, index3 = validPlacements.indexOf(placement), arr = validPlacements.slice(index3 + 1).concat(validPlacements.slice(0, index3));
  return counter ? arr.reverse() : arr;
}
__name(clockwise, "clockwise");
var BEHAVIORS = {
  FLIP: "flip",
  CLOCKWISE: "clockwise",
  COUNTERCLOCKWISE: "counterclockwise"
};
function flip$2(data49, options2) {
  if (isModifierEnabled(data49.instance.modifiers, "inner") || data49.flipped && data49.placement === data49.originalPlacement)
    return data49;
  var boundaries = getBoundaries(data49.instance.popper, data49.instance.reference, options2.padding, options2.boundariesElement, data49.positionFixed), placement = data49.placement.split("-")[0], placementOpposite = getOppositePlacement$1(placement), variation = data49.placement.split("-")[1] || "", flipOrder = [];
  switch (options2.behavior) {
    case BEHAVIORS.FLIP:
      flipOrder = [placement, placementOpposite];
      break;
    case BEHAVIORS.CLOCKWISE:
      flipOrder = clockwise(placement);
      break;
    case BEHAVIORS.COUNTERCLOCKWISE:
      flipOrder = clockwise(placement, !0);
      break;
    default:
      flipOrder = options2.behavior;
  }
  return flipOrder.forEach(function(step, index3) {
    if (placement !== step || flipOrder.length === index3 + 1)
      return data49;
    placement = data49.placement.split("-")[0], placementOpposite = getOppositePlacement$1(placement);
    var popperOffsets2 = data49.offsets.popper, refOffsets = data49.offsets.reference, floor = Math.floor, overlapsRef = placement === "left" && floor(popperOffsets2.right) > floor(refOffsets.left) || placement === "right" && floor(popperOffsets2.left) < floor(refOffsets.right) || placement === "top" && floor(popperOffsets2.bottom) > floor(refOffsets.top) || placement === "bottom" && floor(popperOffsets2.top) < floor(refOffsets.bottom), overflowsLeft = floor(popperOffsets2.left) < floor(boundaries.left), overflowsRight = floor(popperOffsets2.right) > floor(boundaries.right), overflowsTop = floor(popperOffsets2.top) < floor(boundaries.top), overflowsBottom = floor(popperOffsets2.bottom) > floor(boundaries.bottom), overflowsBoundaries = placement === "left" && overflowsLeft || placement === "right" && overflowsRight || placement === "top" && overflowsTop || placement === "bottom" && overflowsBottom, isVertical = ["top", "bottom"].indexOf(placement) !== -1, flippedVariationByRef = !!options2.flipVariations && (isVertical && variation === "start" && overflowsLeft || isVertical && variation === "end" && overflowsRight || !isVertical && variation === "start" && overflowsTop || !isVertical && variation === "end" && overflowsBottom), flippedVariationByContent = !!options2.flipVariationsByContent && (isVertical && variation === "start" && overflowsRight || isVertical && variation === "end" && overflowsLeft || !isVertical && variation === "start" && overflowsBottom || !isVertical && variation === "end" && overflowsTop), flippedVariation = flippedVariationByRef || flippedVariationByContent;
    (overlapsRef || overflowsBoundaries || flippedVariation) && (data49.flipped = !0, (overlapsRef || overflowsBoundaries) && (placement = flipOrder[index3 + 1]), flippedVariation && (variation = getOppositeVariation(variation)), data49.placement = placement + (variation ? "-" + variation : ""), data49.offsets.popper = _extends$1({}, data49.offsets.popper, getPopperOffsets(data49.instance.popper, data49.offsets.reference, data49.placement)), data49 = runModifiers(data49.instance.modifiers, data49, "flip"));
  }), data49;
}
__name(flip$2, "flip$2");
function keepTogether(data49) {
  var _data$offsets = data49.offsets, popper2 = _data$offsets.popper, reference2 = _data$offsets.reference, placement = data49.placement.split("-")[0], floor = Math.floor, isVertical = ["top", "bottom"].indexOf(placement) !== -1, side = isVertical ? "right" : "bottom", opSide = isVertical ? "left" : "top", measurement = isVertical ? "width" : "height";
  return popper2[side] < floor(reference2[opSide]) && (data49.offsets.popper[opSide] = floor(reference2[opSide]) - popper2[measurement]), popper2[opSide] > floor(reference2[side]) && (data49.offsets.popper[opSide] = floor(reference2[side])), data49;
}
__name(keepTogether, "keepTogether");
function toValue(str2, measurement, popperOffsets2, referenceOffsets) {
  var split = str2.match(/((?:\-|\+)?\d*\.?\d*)(.*)/), value3 = +split[1], unit = split[2];
  if (!value3)
    return str2;
  if (unit.indexOf("%") === 0) {
    var element = void 0;
    switch (unit) {
      case "%p":
        element = popperOffsets2;
        break;
      case "%":
      case "%r":
      default:
        element = referenceOffsets;
    }
    var rect = getClientRect(element);
    return rect[measurement] / 100 * value3;
  } else if (unit === "vh" || unit === "vw") {
    var size2 = void 0;
    return unit === "vh" ? size2 = Math.max(document.documentElement.clientHeight, window.innerHeight || 0) : size2 = Math.max(document.documentElement.clientWidth, window.innerWidth || 0), size2 / 100 * value3;
  } else
    return value3;
}
__name(toValue, "toValue");
function parseOffset(offset3, popperOffsets2, referenceOffsets, basePlacement) {
  var offsets = [0, 0], useHeight = ["right", "left"].indexOf(basePlacement) !== -1, fragments = offset3.split(/(\+|\-)/).map(function(frag) {
    return frag.trim();
  }), divider = fragments.indexOf(find$3(fragments, function(frag) {
    return frag.search(/,|\s/) !== -1;
  }));
  fragments[divider] && fragments[divider].indexOf(",") === -1 && console.warn("Offsets separated by white space(s) are deprecated, use a comma (,) instead.");
  var splitRegex = /\s*,\s*|\s+/, ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments];
  return ops = ops.map(function(op, index3) {
    var measurement = (index3 === 1 ? !useHeight : useHeight) ? "height" : "width", mergeWithPrevious = !1;
    return op.reduce(function(a2, b) {
      return a2[a2.length - 1] === "" && ["+", "-"].indexOf(b) !== -1 ? (a2[a2.length - 1] = b, mergeWithPrevious = !0, a2) : mergeWithPrevious ? (a2[a2.length - 1] += b, mergeWithPrevious = !1, a2) : a2.concat(b);
    }, []).map(function(str2) {
      return toValue(str2, measurement, popperOffsets2, referenceOffsets);
    });
  }), ops.forEach(function(op, index3) {
    op.forEach(function(frag, index22) {
      isNumeric$1(frag) && (offsets[index3] += frag * (op[index22 - 1] === "-" ? -1 : 1));
    });
  }), offsets;
}
__name(parseOffset, "parseOffset");
function offset$3(data49, _ref) {
  var offset3 = _ref.offset, placement = data49.placement, _data$offsets = data49.offsets, popper2 = _data$offsets.popper, reference2 = _data$offsets.reference, basePlacement = placement.split("-")[0], offsets = void 0;
  return isNumeric$1(+offset3) ? offsets = [+offset3, 0] : offsets = parseOffset(offset3, popper2, reference2, basePlacement), basePlacement === "left" ? (popper2.top += offsets[0], popper2.left -= offsets[1]) : basePlacement === "right" ? (popper2.top += offsets[0], popper2.left += offsets[1]) : basePlacement === "top" ? (popper2.left += offsets[0], popper2.top -= offsets[1]) : basePlacement === "bottom" && (popper2.left += offsets[0], popper2.top += offsets[1]), data49.popper = popper2, data49;
}
__name(offset$3, "offset$3");
function preventOverflow$2(data49, options2) {
  var boundariesElement = options2.boundariesElement || getOffsetParent$1(data49.instance.popper);
  data49.instance.reference === boundariesElement && (boundariesElement = getOffsetParent$1(boundariesElement));
  var transformProp = getSupportedPropertyName("transform"), popperStyles = data49.instance.popper.style, top2 = popperStyles.top, left2 = popperStyles.left, transform = popperStyles[transformProp];
  popperStyles.top = "", popperStyles.left = "", popperStyles[transformProp] = "";
  var boundaries = getBoundaries(data49.instance.popper, data49.instance.reference, options2.padding, boundariesElement, data49.positionFixed);
  popperStyles.top = top2, popperStyles.left = left2, popperStyles[transformProp] = transform, options2.boundaries = boundaries;
  var order2 = options2.priority, popper2 = data49.offsets.popper, check = {
    primary: /* @__PURE__ */ __name(function(placement) {
      var value3 = popper2[placement];
      return popper2[placement] < boundaries[placement] && !options2.escapeWithReference && (value3 = Math.max(popper2[placement], boundaries[placement])), defineProperty$2({}, placement, value3);
    }, "primary"),
    secondary: /* @__PURE__ */ __name(function(placement) {
      var mainSide = placement === "right" ? "left" : "top", value3 = popper2[mainSide];
      return popper2[placement] > boundaries[placement] && !options2.escapeWithReference && (value3 = Math.min(popper2[mainSide], boundaries[placement] - (placement === "right" ? popper2.width : popper2.height))), defineProperty$2({}, mainSide, value3);
    }, "secondary")
  };
  return order2.forEach(function(placement) {
    var side = ["left", "top"].indexOf(placement) !== -1 ? "primary" : "secondary";
    popper2 = _extends$1({}, popper2, check[side](placement));
  }), data49.offsets.popper = popper2, data49;
}
__name(preventOverflow$2, "preventOverflow$2");
function shift(data49) {
  var placement = data49.placement, basePlacement = placement.split("-")[0], shiftvariation = placement.split("-")[1];
  if (shiftvariation) {
    var _data$offsets = data49.offsets, reference2 = _data$offsets.reference, popper2 = _data$offsets.popper, isVertical = ["bottom", "top"].indexOf(basePlacement) !== -1, side = isVertical ? "left" : "top", measurement = isVertical ? "width" : "height", shiftOffsets = {
      start: defineProperty$2({}, side, reference2[side]),
      end: defineProperty$2({}, side, reference2[side] + reference2[measurement] - popper2[measurement])
    };
    data49.offsets.popper = _extends$1({}, popper2, shiftOffsets[shiftvariation]);
  }
  return data49;
}
__name(shift, "shift");
function hide$2(data49) {
  if (!isModifierRequired(data49.instance.modifiers, "hide", "preventOverflow"))
    return data49;
  var refRect = data49.offsets.reference, bound = find$3(data49.instance.modifiers, function(modifier) {
    return modifier.name === "preventOverflow";
  }).boundaries;
  if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
    if (data49.hide === !0)
      return data49;
    data49.hide = !0, data49.attributes["x-out-of-boundaries"] = "";
  } else {
    if (data49.hide === !1)
      return data49;
    data49.hide = !1, data49.attributes["x-out-of-boundaries"] = !1;
  }
  return data49;
}
__name(hide$2, "hide$2");
function inner(data49) {
  var placement = data49.placement, basePlacement = placement.split("-")[0], _data$offsets = data49.offsets, popper2 = _data$offsets.popper, reference2 = _data$offsets.reference, isHoriz = ["left", "right"].indexOf(basePlacement) !== -1, subtractLength = ["top", "left"].indexOf(basePlacement) === -1;
  return popper2[isHoriz ? "left" : "top"] = reference2[basePlacement] - (subtractLength ? popper2[isHoriz ? "width" : "height"] : 0), data49.placement = getOppositePlacement$1(placement), data49.offsets.popper = getClientRect(popper2), data49;
}
__name(inner, "inner");
var modifiers = {
  /**
   * Modifier used to shift the popper on the start or end of its reference
   * element.<br />
   * It will read the variation of the `placement` property.<br />
   * It can be one either `-end` or `-start`.
   * @memberof modifiers
   * @inner
   */
  shift: {
    /** @prop {number} order=100 - Index used to define the order of execution */
    order: 100,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: !0,
    /** @prop {ModifierFn} */
    fn: shift
  },
  /**
   * The `offset` modifier can shift your popper on both its axis.
   *
   * It accepts the following units:
   * - `px` or unit-less, interpreted as pixels
   * - `%` or `%r`, percentage relative to the length of the reference element
   * - `%p`, percentage relative to the length of the popper element
   * - `vw`, CSS viewport width unit
   * - `vh`, CSS viewport height unit
   *
   * For length is intended the main axis relative to the placement of the popper.<br />
   * This means that if the placement is `top` or `bottom`, the length will be the
   * `width`. In case of `left` or `right`, it will be the `height`.
   *
   * You can provide a single value (as `Number` or `String`), or a pair of values
   * as `String` divided by a comma or one (or more) white spaces.<br />
   * The latter is a deprecated method because it leads to confusion and will be
   * removed in v2.<br />
   * Additionally, it accepts additions and subtractions between different units.
   * Note that multiplications and divisions aren't supported.
   *
   * Valid examples are:
   * ```
   * 10
   * '10%'
   * '10, 10'
   * '10%, 10'
   * '10 + 10%'
   * '10 - 5vh + 3%'
   * '-10px + 5vh, 5px - 6%'
   * ```
   * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
   * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
   * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
   *
   * @memberof modifiers
   * @inner
   */
  offset: {
    /** @prop {number} order=200 - Index used to define the order of execution */
    order: 200,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: !0,
    /** @prop {ModifierFn} */
    fn: offset$3,
    /** @prop {Number|String} offset=0
     * The offset value as described in the modifier description
     */
    offset: 0
  },
  /**
   * Modifier used to prevent the popper from being positioned outside the boundary.
   *
   * A scenario exists where the reference itself is not within the boundaries.<br />
   * We can say it has "escaped the boundaries" — or just "escaped".<br />
   * In this case we need to decide whether the popper should either:
   *
   * - detach from the reference and remain "trapped" in the boundaries, or
   * - if it should ignore the boundary and "escape with its reference"
   *
   * When `escapeWithReference` is set to`true` and reference is completely
   * outside its boundaries, the popper will overflow (or completely leave)
   * the boundaries in order to remain attached to the edge of the reference.
   *
   * @memberof modifiers
   * @inner
   */
  preventOverflow: {
    /** @prop {number} order=300 - Index used to define the order of execution */
    order: 300,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: !0,
    /** @prop {ModifierFn} */
    fn: preventOverflow$2,
    /**
     * @prop {Array} [priority=['left','right','top','bottom']]
     * Popper will try to prevent overflow following these priorities by default,
     * then, it could overflow on the left and on top of the `boundariesElement`
     */
    priority: ["left", "right", "top", "bottom"],
    /**
     * @prop {number} padding=5
     * Amount of pixel used to define a minimum distance between the boundaries
     * and the popper. This makes sure the popper always has a little padding
     * between the edges of its container
     */
    padding: 5,
    /**
     * @prop {String|HTMLElement} boundariesElement='scrollParent'
     * Boundaries used by the modifier. Can be `scrollParent`, `window`,
     * `viewport` or any DOM element.
     */
    boundariesElement: "scrollParent"
  },
  /**
   * Modifier used to make sure the reference and its popper stay near each other
   * without leaving any gap between the two. Especially useful when the arrow is
   * enabled and you want to ensure that it points to its reference element.
   * It cares only about the first axis. You can still have poppers with margin
   * between the popper and its reference element.
   * @memberof modifiers
   * @inner
   */
  keepTogether: {
    /** @prop {number} order=400 - Index used to define the order of execution */
    order: 400,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: !0,
    /** @prop {ModifierFn} */
    fn: keepTogether
  },
  /**
   * This modifier is used to move the `arrowElement` of the popper to make
   * sure it is positioned between the reference element and its popper element.
   * It will read the outer size of the `arrowElement` node to detect how many
   * pixels of conjunction are needed.
   *
   * It has no effect if no `arrowElement` is provided.
   * @memberof modifiers
   * @inner
   */
  arrow: {
    /** @prop {number} order=500 - Index used to define the order of execution */
    order: 500,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: !0,
    /** @prop {ModifierFn} */
    fn: arrow$2,
    /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
    element: "[x-arrow]"
  },
  /**
   * Modifier used to flip the popper's placement when it starts to overlap its
   * reference element.
   *
   * Requires the `preventOverflow` modifier before it in order to work.
   *
   * **NOTE:** this modifier will interrupt the current update cycle and will
   * restart it if it detects the need to flip the placement.
   * @memberof modifiers
   * @inner
   */
  flip: {
    /** @prop {number} order=600 - Index used to define the order of execution */
    order: 600,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: !0,
    /** @prop {ModifierFn} */
    fn: flip$2,
    /**
     * @prop {String|Array} behavior='flip'
     * The behavior used to change the popper's placement. It can be one of
     * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
     * placements (with optional variations)
     */
    behavior: "flip",
    /**
     * @prop {number} padding=5
     * The popper will flip if it hits the edges of the `boundariesElement`
     */
    padding: 5,
    /**
     * @prop {String|HTMLElement} boundariesElement='viewport'
     * The element which will define the boundaries of the popper position.
     * The popper will never be placed outside of the defined boundaries
     * (except if `keepTogether` is enabled)
     */
    boundariesElement: "viewport",
    /**
     * @prop {Boolean} flipVariations=false
     * The popper will switch placement variation between `-start` and `-end` when
     * the reference element overlaps its boundaries.
     *
     * The original placement should have a set variation.
     */
    flipVariations: !1,
    /**
     * @prop {Boolean} flipVariationsByContent=false
     * The popper will switch placement variation between `-start` and `-end` when
     * the popper element overlaps its reference boundaries.
     *
     * The original placement should have a set variation.
     */
    flipVariationsByContent: !1
  },
  /**
   * Modifier used to make the popper flow toward the inner of the reference element.
   * By default, when this modifier is disabled, the popper will be placed outside
   * the reference element.
   * @memberof modifiers
   * @inner
   */
  inner: {
    /** @prop {number} order=700 - Index used to define the order of execution */
    order: 700,
    /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
    enabled: !1,
    /** @prop {ModifierFn} */
    fn: inner
  },
  /**
   * Modifier used to hide the popper when its reference element is outside of the
   * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
   * be used to hide with a CSS selector the popper when its reference is
   * out of boundaries.
   *
   * Requires the `preventOverflow` modifier before it in order to work.
   * @memberof modifiers
   * @inner
   */
  hide: {
    /** @prop {number} order=800 - Index used to define the order of execution */
    order: 800,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: !0,
    /** @prop {ModifierFn} */
    fn: hide$2
  },
  /**
   * Computes the style that will be applied to the popper element to gets
   * properly positioned.
   *
   * Note that this modifier will not touch the DOM, it just prepares the styles
   * so that `applyStyle` modifier can apply it. This separation is useful
   * in case you need to replace `applyStyle` with a custom implementation.
   *
   * This modifier has `850` as `order` value to maintain backward compatibility
   * with previous versions of Popper.js. Expect the modifiers ordering method
   * to change in future major versions of the library.
   *
   * @memberof modifiers
   * @inner
   */
  computeStyle: {
    /** @prop {number} order=850 - Index used to define the order of execution */
    order: 850,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: !0,
    /** @prop {ModifierFn} */
    fn: computeStyle,
    /**
     * @prop {Boolean} gpuAcceleration=true
     * If true, it uses the CSS 3D transformation to position the popper.
     * Otherwise, it will use the `top` and `left` properties
     */
    gpuAcceleration: !0,
    /**
     * @prop {string} [x='bottom']
     * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
     * Change this if your popper should grow in a direction different from `bottom`
     */
    x: "bottom",
    /**
     * @prop {string} [x='left']
     * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
     * Change this if your popper should grow in a direction different from `right`
     */
    y: "right"
  },
  /**
   * Applies the computed styles to the popper element.
   *
   * All the DOM manipulations are limited to this modifier. This is useful in case
   * you want to integrate Popper.js inside a framework or view library and you
   * want to delegate all the DOM manipulations to it.
   *
   * Note that if you disable this modifier, you must make sure the popper element
   * has its position set to `absolute` before Popper.js can do its work!
   *
   * Just disable this modifier and define your own to achieve the desired effect.
   *
   * @memberof modifiers
   * @inner
   */
  applyStyle: {
    /** @prop {number} order=900 - Index used to define the order of execution */
    order: 900,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: !0,
    /** @prop {ModifierFn} */
    fn: applyStyle,
    /** @prop {Function} */
    onLoad: applyStyleOnLoad,
    /**
     * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
     * @prop {Boolean} gpuAcceleration=true
     * If true, it uses the CSS 3D transformation to position the popper.
     * Otherwise, it will use the `top` and `left` properties
     */
    gpuAcceleration: void 0
  }
}, Defaults = {
  /**
   * Popper's placement.
   * @prop {Popper.placements} placement='bottom'
   */
  placement: "bottom",
  /**
   * Set this to true if you want popper to position it self in 'fixed' mode
   * @prop {Boolean} positionFixed=false
   */
  positionFixed: !1,
  /**
   * Whether events (resize, scroll) are initially enabled.
   * @prop {Boolean} eventsEnabled=true
   */
  eventsEnabled: !0,
  /**
   * Set to true if you want to automatically remove the popper when
   * you call the `destroy` method.
   * @prop {Boolean} removeOnDestroy=false
   */
  removeOnDestroy: !1,
  /**
   * Callback called when the popper is created.<br />
   * By default, it is set to no-op.<br />
   * Access Popper.js instance with `data.instance`.
   * @prop {onCreate}
   */
  onCreate: /* @__PURE__ */ __name(function() {
  }, "onCreate"),
  /**
   * Callback called when the popper is updated. This callback is not called
   * on the initialization/creation of the popper, but only on subsequent
   * updates.<br />
   * By default, it is set to no-op.<br />
   * Access Popper.js instance with `data.instance`.
   * @prop {onUpdate}
   */
  onUpdate: /* @__PURE__ */ __name(function() {
  }, "onUpdate"),
  /**
   * List of modifiers used to modify the offsets before they are applied to the popper.
   * They provide most of the functionalities of Popper.js.
   * @prop {modifiers}
   */
  modifiers
}, Popper = function() {
  function Popper2(reference2, popper2) {
    var _this = this, options2 = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    classCallCheck(this, Popper2), this.scheduleUpdate = function() {
      return requestAnimationFrame(_this.update);
    }, this.update = debounce$2(this.update.bind(this)), this.options = _extends$1({}, Popper2.Defaults, options2), this.state = {
      isDestroyed: !1,
      isCreated: !1,
      scrollParents: []
    }, this.reference = reference2 && reference2.jquery ? reference2[0] : reference2, this.popper = popper2 && popper2.jquery ? popper2[0] : popper2, this.options.modifiers = {}, Object.keys(_extends$1({}, Popper2.Defaults.modifiers, options2.modifiers)).forEach(function(name2) {
      _this.options.modifiers[name2] = _extends$1({}, Popper2.Defaults.modifiers[name2] || {}, options2.modifiers ? options2.modifiers[name2] : {});
    }), this.modifiers = Object.keys(this.options.modifiers).map(function(name2) {
      return _extends$1({
        name: name2
      }, _this.options.modifiers[name2]);
    }).sort(function(a2, b) {
      return a2.order - b.order;
    }), this.modifiers.forEach(function(modifierOptions) {
      modifierOptions.enabled && isFunction$3(modifierOptions.onLoad) && modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
    }), this.update();
    var eventsEnabled = this.options.eventsEnabled;
    eventsEnabled && this.enableEventListeners(), this.state.eventsEnabled = eventsEnabled;
  }
  return __name(Popper2, "Popper"), createClass(Popper2, [{
    key: "update",
    value: /* @__PURE__ */ __name(function() {
      return update$1.call(this);
    }, "update$$1")
  }, {
    key: "destroy",
    value: /* @__PURE__ */ __name(function() {
      return destroy$1.call(this);
    }, "destroy$$1")
  }, {
    key: "enableEventListeners",
    value: /* @__PURE__ */ __name(function() {
      return enableEventListeners.call(this);
    }, "enableEventListeners$$1")
  }, {
    key: "disableEventListeners",
    value: /* @__PURE__ */ __name(function() {
      return disableEventListeners.call(this);
    }, "disableEventListeners$$1")
    /**
     * Schedules an update. It will run on the next UI update available.
     * @method scheduleUpdate
     * @memberof Popper
     */
    /**
     * Collection of utilities useful when writing custom modifiers.
     * Starting from version 1.7, this method is available only if you
     * include `popper-utils.js` before `popper.js`.
     *
     * **DEPRECATION**: This way to access PopperUtils is deprecated
     * and will be removed in v2! Use the PopperUtils module directly instead.
     * Due to the high instability of the methods contained in Utils, we can't
     * guarantee them to follow semver. Use them at your own risk!
     * @static
     * @private
     * @type {Object}
     * @deprecated since version 1.8
     * @member Utils
     * @memberof Popper
     */
  }]), Popper2;
}();
Popper.Utils = (typeof window < "u" ? window : global).PopperUtils;
Popper.placements = placements$1;
Popper.Defaults = Defaults;
const popper$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: Popper
}, Symbol.toStringTag, { value: "Module" }));
var g = typeof globalThis < "u" && globalThis || typeof self < "u" && self || // eslint-disable-next-line no-undef
typeof global < "u" && global || {}, support = {
  searchParams: "URLSearchParams" in g,
  iterable: "Symbol" in g && "iterator" in Symbol,
  blob: "FileReader" in g && "Blob" in g && function() {
    try {
      return new Blob(), !0;
    } catch {
      return !1;
    }
  }(),
  formData: "FormData" in g,
  arrayBuffer: "ArrayBuffer" in g
};
function isDataView(obj2) {
  return obj2 && DataView.prototype.isPrototypeOf(obj2);
}
__name(isDataView, "isDataView");
if (support.arrayBuffer)
  var viewClasses = [
    "[object Int8Array]",
    "[object Uint8Array]",
    "[object Uint8ClampedArray]",
    "[object Int16Array]",
    "[object Uint16Array]",
    "[object Int32Array]",
    "[object Uint32Array]",
    "[object Float32Array]",
    "[object Float64Array]"
  ], isArrayBufferView = ArrayBuffer.isView || function(obj2) {
    return obj2 && viewClasses.indexOf(Object.prototype.toString.call(obj2)) > -1;
  };
function normalizeName(name2) {
  if (typeof name2 != "string" && (name2 = String(name2)), /[^a-z0-9\-#$%&'*+.^_`|~!]/i.test(name2) || name2 === "")
    throw new TypeError('Invalid character in header field name: "' + name2 + '"');
  return name2.toLowerCase();
}
__name(normalizeName, "normalizeName");
function normalizeValue$2(value3) {
  return typeof value3 != "string" && (value3 = String(value3)), value3;
}
__name(normalizeValue$2, "normalizeValue$2");
function iteratorFor(items3) {
  var iterator = {
    next: /* @__PURE__ */ __name(function() {
      var value3 = items3.shift();
      return { done: value3 === void 0, value: value3 };
    }, "next")
  };
  return support.iterable && (iterator[Symbol.iterator] = function() {
    return iterator;
  }), iterator;
}
__name(iteratorFor, "iteratorFor");
function Headers(headers) {
  this.map = {}, headers instanceof Headers ? headers.forEach(function(value3, name2) {
    this.append(name2, value3);
  }, this) : Array.isArray(headers) ? headers.forEach(function(header) {
    if (header.length != 2)
      throw new TypeError("Headers constructor: expected name/value pair to be length 2, found" + header.length);
    this.append(header[0], header[1]);
  }, this) : headers && Object.getOwnPropertyNames(headers).forEach(function(name2) {
    this.append(name2, headers[name2]);
  }, this);
}
__name(Headers, "Headers");
Headers.prototype.append = function(name2, value3) {
  name2 = normalizeName(name2), value3 = normalizeValue$2(value3);
  var oldValue = this.map[name2];
  this.map[name2] = oldValue ? oldValue + ", " + value3 : value3;
};
Headers.prototype.delete = function(name2) {
  delete this.map[normalizeName(name2)];
};
Headers.prototype.get = function(name2) {
  return name2 = normalizeName(name2), this.has(name2) ? this.map[name2] : null;
};
Headers.prototype.has = function(name2) {
  return this.map.hasOwnProperty(normalizeName(name2));
};
Headers.prototype.set = function(name2, value3) {
  this.map[normalizeName(name2)] = normalizeValue$2(value3);
};
Headers.prototype.forEach = function(callback, thisArg) {
  for (var name2 in this.map)
    this.map.hasOwnProperty(name2) && callback.call(thisArg, this.map[name2], name2, this);
};
Headers.prototype.keys = function() {
  var items3 = [];
  return this.forEach(function(value3, name2) {
    items3.push(name2);
  }), iteratorFor(items3);
};
Headers.prototype.values = function() {
  var items3 = [];
  return this.forEach(function(value3) {
    items3.push(value3);
  }), iteratorFor(items3);
};
Headers.prototype.entries = function() {
  var items3 = [];
  return this.forEach(function(value3, name2) {
    items3.push([name2, value3]);
  }), iteratorFor(items3);
};
support.iterable && (Headers.prototype[Symbol.iterator] = Headers.prototype.entries);
function consumed(body) {
  if (!body._noBody) {
    if (body.bodyUsed)
      return Promise.reject(new TypeError("Already read"));
    body.bodyUsed = !0;
  }
}
__name(consumed, "consumed");
function fileReaderReady(reader) {
  return new Promise(function(resolve2, reject) {
    reader.onload = function() {
      resolve2(reader.result);
    }, reader.onerror = function() {
      reject(reader.error);
    };
  });
}
__name(fileReaderReady, "fileReaderReady");
function readBlobAsArrayBuffer(blob) {
  var reader = new FileReader(), promise = fileReaderReady(reader);
  return reader.readAsArrayBuffer(blob), promise;
}
__name(readBlobAsArrayBuffer, "readBlobAsArrayBuffer");
function readBlobAsText(blob) {
  var reader = new FileReader(), promise = fileReaderReady(reader), match3 = /charset=([A-Za-z0-9_-]+)/.exec(blob.type), encoding = match3 ? match3[1] : "utf-8";
  return reader.readAsText(blob, encoding), promise;
}
__name(readBlobAsText, "readBlobAsText");
function readArrayBufferAsText(buf) {
  for (var view = new Uint8Array(buf), chars = new Array(view.length), i = 0; i < view.length; i++)
    chars[i] = String.fromCharCode(view[i]);
  return chars.join("");
}
__name(readArrayBufferAsText, "readArrayBufferAsText");
function bufferClone(buf) {
  if (buf.slice)
    return buf.slice(0);
  var view = new Uint8Array(buf.byteLength);
  return view.set(new Uint8Array(buf)), view.buffer;
}
__name(bufferClone, "bufferClone");
function Body() {
  return this.bodyUsed = !1, this._initBody = function(body) {
    this.bodyUsed = this.bodyUsed, this._bodyInit = body, body ? typeof body == "string" ? this._bodyText = body : support.blob && Blob.prototype.isPrototypeOf(body) ? this._bodyBlob = body : support.formData && FormData.prototype.isPrototypeOf(body) ? this._bodyFormData = body : support.searchParams && URLSearchParams.prototype.isPrototypeOf(body) ? this._bodyText = body.toString() : support.arrayBuffer && support.blob && isDataView(body) ? (this._bodyArrayBuffer = bufferClone(body.buffer), this._bodyInit = new Blob([this._bodyArrayBuffer])) : support.arrayBuffer && (ArrayBuffer.prototype.isPrototypeOf(body) || isArrayBufferView(body)) ? this._bodyArrayBuffer = bufferClone(body) : this._bodyText = body = Object.prototype.toString.call(body) : (this._noBody = !0, this._bodyText = ""), this.headers.get("content-type") || (typeof body == "string" ? this.headers.set("content-type", "text/plain;charset=UTF-8") : this._bodyBlob && this._bodyBlob.type ? this.headers.set("content-type", this._bodyBlob.type) : support.searchParams && URLSearchParams.prototype.isPrototypeOf(body) && this.headers.set("content-type", "application/x-www-form-urlencoded;charset=UTF-8"));
  }, support.blob && (this.blob = function() {
    var rejected = consumed(this);
    if (rejected)
      return rejected;
    if (this._bodyBlob)
      return Promise.resolve(this._bodyBlob);
    if (this._bodyArrayBuffer)
      return Promise.resolve(new Blob([this._bodyArrayBuffer]));
    if (this._bodyFormData)
      throw new Error("could not read FormData body as blob");
    return Promise.resolve(new Blob([this._bodyText]));
  }), this.arrayBuffer = function() {
    if (this._bodyArrayBuffer) {
      var isConsumed = consumed(this);
      return isConsumed || (ArrayBuffer.isView(this._bodyArrayBuffer) ? Promise.resolve(
        this._bodyArrayBuffer.buffer.slice(
          this._bodyArrayBuffer.byteOffset,
          this._bodyArrayBuffer.byteOffset + this._bodyArrayBuffer.byteLength
        )
      ) : Promise.resolve(this._bodyArrayBuffer));
    } else {
      if (support.blob)
        return this.blob().then(readBlobAsArrayBuffer);
      throw new Error("could not read as ArrayBuffer");
    }
  }, this.text = function() {
    var rejected = consumed(this);
    if (rejected)
      return rejected;
    if (this._bodyBlob)
      return readBlobAsText(this._bodyBlob);
    if (this._bodyArrayBuffer)
      return Promise.resolve(readArrayBufferAsText(this._bodyArrayBuffer));
    if (this._bodyFormData)
      throw new Error("could not read FormData body as text");
    return Promise.resolve(this._bodyText);
  }, support.formData && (this.formData = function() {
    return this.text().then(decode$2);
  }), this.json = function() {
    return this.text().then(JSON.parse);
  }, this;
}
__name(Body, "Body");
var methods = ["CONNECT", "DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT", "TRACE"];
function normalizeMethod(method) {
  var upcased = method.toUpperCase();
  return methods.indexOf(upcased) > -1 ? upcased : method;
}
__name(normalizeMethod, "normalizeMethod");
function Request(input, options2) {
  if (!(this instanceof Request))
    throw new TypeError('Please use the "new" operator, this DOM object constructor cannot be called as a function.');
  options2 = options2 || {};
  var body = options2.body;
  if (input instanceof Request) {
    if (input.bodyUsed)
      throw new TypeError("Already read");
    this.url = input.url, this.credentials = input.credentials, options2.headers || (this.headers = new Headers(input.headers)), this.method = input.method, this.mode = input.mode, this.signal = input.signal, !body && input._bodyInit != null && (body = input._bodyInit, input.bodyUsed = !0);
  } else
    this.url = String(input);
  if (this.credentials = options2.credentials || this.credentials || "same-origin", (options2.headers || !this.headers) && (this.headers = new Headers(options2.headers)), this.method = normalizeMethod(options2.method || this.method || "GET"), this.mode = options2.mode || this.mode || null, this.signal = options2.signal || this.signal || function() {
    if ("AbortController" in g) {
      var ctrl = new AbortController();
      return ctrl.signal;
    }
  }(), this.referrer = null, (this.method === "GET" || this.method === "HEAD") && body)
    throw new TypeError("Body not allowed for GET or HEAD requests");
  if (this._initBody(body), (this.method === "GET" || this.method === "HEAD") && (options2.cache === "no-store" || options2.cache === "no-cache")) {
    var reParamSearch = /([?&])_=[^&]*/;
    if (reParamSearch.test(this.url))
      this.url = this.url.replace(reParamSearch, "$1_=" + (/* @__PURE__ */ new Date()).getTime());
    else {
      var reQueryString = /\?/;
      this.url += (reQueryString.test(this.url) ? "&" : "?") + "_=" + (/* @__PURE__ */ new Date()).getTime();
    }
  }
}
__name(Request, "Request");
Request.prototype.clone = function() {
  return new Request(this, { body: this._bodyInit });
};
function decode$2(body) {
  var form2 = new FormData();
  return body.trim().split("&").forEach(function(bytes) {
    if (bytes) {
      var split = bytes.split("="), name2 = split.shift().replace(/\+/g, " "), value3 = split.join("=").replace(/\+/g, " ");
      form2.append(decodeURIComponent(name2), decodeURIComponent(value3));
    }
  }), form2;
}
__name(decode$2, "decode$2");
function parseHeaders(rawHeaders) {
  var headers = new Headers(), preProcessedHeaders = rawHeaders.replace(/\r?\n[\t ]+/g, " ");
  return preProcessedHeaders.split("\r").map(function(header) {
    return header.indexOf(`
`) === 0 ? header.substr(1, header.length) : header;
  }).forEach(function(line) {
    var parts = line.split(":"), key = parts.shift().trim();
    if (key) {
      var value3 = parts.join(":").trim();
      try {
        headers.append(key, value3);
      } catch (error2) {
        console.warn("Response " + error2.message);
      }
    }
  }), headers;
}
__name(parseHeaders, "parseHeaders");
Body.call(Request.prototype);
function Response$1(bodyInit, options2) {
  if (!(this instanceof Response$1))
    throw new TypeError('Please use the "new" operator, this DOM object constructor cannot be called as a function.');
  if (options2 || (options2 = {}), this.type = "default", this.status = options2.status === void 0 ? 200 : options2.status, this.status < 200 || this.status > 599)
    throw new RangeError("Failed to construct 'Response': The status provided (0) is outside the range [200, 599].");
  this.ok = this.status >= 200 && this.status < 300, this.statusText = options2.statusText === void 0 ? "" : "" + options2.statusText, this.headers = new Headers(options2.headers), this.url = options2.url || "", this._initBody(bodyInit);
}
__name(Response$1, "Response$1");
Body.call(Response$1.prototype);
Response$1.prototype.clone = function() {
  return new Response$1(this._bodyInit, {
    status: this.status,
    statusText: this.statusText,
    headers: new Headers(this.headers),
    url: this.url
  });
};
Response$1.error = function() {
  var response = new Response$1(null, { status: 200, statusText: "" });
  return response.ok = !1, response.status = 0, response.type = "error", response;
};
var redirectStatuses = [301, 302, 303, 307, 308];
Response$1.redirect = function(url2, status) {
  if (redirectStatuses.indexOf(status) === -1)
    throw new RangeError("Invalid status code");
  return new Response$1(null, { status, headers: { location: url2 } });
};
var DOMException = g.DOMException;
try {
  new DOMException();
} catch {
  DOMException = /* @__PURE__ */ __name(function(message, name2) {
    this.message = message, this.name = name2;
    var error2 = Error(message);
    this.stack = error2.stack;
  }, "DOMException"), DOMException.prototype = Object.create(Error.prototype), DOMException.prototype.constructor = DOMException;
}
function fetch$1(input, init2) {
  return new Promise(function(resolve2, reject) {
    var request = new Request(input, init2);
    if (request.signal && request.signal.aborted)
      return reject(new DOMException("Aborted", "AbortError"));
    var xhr = new XMLHttpRequest();
    function abortXhr() {
      xhr.abort();
    }
    __name(abortXhr, "abortXhr"), xhr.onload = function() {
      var options2 = {
        statusText: xhr.statusText,
        headers: parseHeaders(xhr.getAllResponseHeaders() || "")
      };
      request.url.indexOf("file://") === 0 && (xhr.status < 200 || xhr.status > 599) ? options2.status = 200 : options2.status = xhr.status, options2.url = "responseURL" in xhr ? xhr.responseURL : options2.headers.get("X-Request-URL");
      var body = "response" in xhr ? xhr.response : xhr.responseText;
      setTimeout(function() {
        resolve2(new Response$1(body, options2));
      }, 0);
    }, xhr.onerror = function() {
      setTimeout(function() {
        reject(new TypeError("Network request failed"));
      }, 0);
    }, xhr.ontimeout = function() {
      setTimeout(function() {
        reject(new TypeError("Network request timed out"));
      }, 0);
    }, xhr.onabort = function() {
      setTimeout(function() {
        reject(new DOMException("Aborted", "AbortError"));
      }, 0);
    };
    function fixUrl(url2) {
      try {
        return url2 === "" && g.location.href ? g.location.href : url2;
      } catch {
        return url2;
      }
    }
    if (__name(fixUrl, "fixUrl"), xhr.open(request.method, fixUrl(request.url), !0), request.credentials === "include" ? xhr.withCredentials = !0 : request.credentials === "omit" && (xhr.withCredentials = !1), "responseType" in xhr && (support.blob ? xhr.responseType = "blob" : support.arrayBuffer && (xhr.responseType = "arraybuffer")), init2 && typeof init2.headers == "object" && !(init2.headers instanceof Headers || g.Headers && init2.headers instanceof g.Headers)) {
      var names = [];
      Object.getOwnPropertyNames(init2.headers).forEach(function(name2) {
        names.push(normalizeName(name2)), xhr.setRequestHeader(name2, normalizeValue$2(init2.headers[name2]));
      }), request.headers.forEach(function(value3, name2) {
        names.indexOf(name2) === -1 && xhr.setRequestHeader(name2, value3);
      });
    } else
      request.headers.forEach(function(value3, name2) {
        xhr.setRequestHeader(name2, value3);
      });
    request.signal && (request.signal.addEventListener("abort", abortXhr), xhr.onreadystatechange = function() {
      xhr.readyState === 4 && request.signal.removeEventListener("abort", abortXhr);
    }), xhr.send(typeof request._bodyInit > "u" ? null : request._bodyInit);
  });
}
__name(fetch$1, "fetch$1");
fetch$1.polyfill = !0;
g.fetch || (g.fetch = fetch$1, g.Headers = Headers, g.Request = Request, g.Response = Response$1);
/*! jQuery UI - v1.14.1 - 2024-10-30
* https://jqueryui.com
* Includes: widget.js, position.js, data.js, disable-selection.js, effect.js, effects/effect-blind.js, effects/effect-bounce.js, effects/effect-clip.js, effects/effect-drop.js, effects/effect-explode.js, effects/effect-fade.js, effects/effect-fold.js, effects/effect-highlight.js, effects/effect-puff.js, effects/effect-pulsate.js, effects/effect-scale.js, effects/effect-shake.js, effects/effect-size.js, effects/effect-slide.js, effects/effect-transfer.js, focusable.js, form-reset-mixin.js, jquery-patch.js, keycode.js, labels.js, scroll-parent.js, tabbable.js, unique-id.js, widgets/accordion.js, widgets/autocomplete.js, widgets/button.js, widgets/checkboxradio.js, widgets/controlgroup.js, widgets/datepicker.js, widgets/dialog.js, widgets/draggable.js, widgets/droppable.js, widgets/menu.js, widgets/mouse.js, widgets/progressbar.js, widgets/resizable.js, widgets/selectable.js, widgets/selectmenu.js, widgets/slider.js, widgets/sortable.js, widgets/spinner.js, widgets/tabs.js, widgets/tooltip.js
* Copyright OpenJS Foundation and other contributors; Licensed MIT */
(function(factory2) {
  typeof define == "function" && define.amd ? define(["jquery"], factory2) : factory2(jQuery);
})(function($2) {
  $2.ui = $2.ui || {}, $2.ui.version = "1.14.1";
  /*!
   * jQuery UI Widget 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  var widgetUuid = 0, widgetHasOwnProperty = Array.prototype.hasOwnProperty, widgetSlice = Array.prototype.slice;
  $2.cleanData = /* @__PURE__ */ function(orig) {
    return function(elems) {
      var events2, elem, i;
      for (i = 0; (elem = elems[i]) != null; i++)
        events2 = $2._data(elem, "events"), events2 && events2.remove && $2(elem).triggerHandler("remove");
      orig(elems);
    };
  }($2.cleanData), $2.widget = function(name2, base, prototype) {
    var existingConstructor, constructor, basePrototype, proxiedPrototype = {}, namespace2 = name2.split(".")[0];
    if (name2 = name2.split(".")[1], name2 === "__proto__" || name2 === "constructor")
      return $2.error("Invalid widget name: " + name2);
    var fullName = namespace2 + "-" + name2;
    return prototype || (prototype = base, base = $2.Widget), Array.isArray(prototype) && (prototype = $2.extend.apply(null, [{}].concat(prototype))), $2.expr.pseudos[fullName.toLowerCase()] = function(elem) {
      return !!$2.data(elem, fullName);
    }, $2[namespace2] = $2[namespace2] || {}, existingConstructor = $2[namespace2][name2], constructor = $2[namespace2][name2] = function(options2, element) {
      if (!this || !this._createWidget)
        return new constructor(options2, element);
      arguments.length && this._createWidget(options2, element);
    }, $2.extend(constructor, existingConstructor, {
      version: prototype.version,
      // Copy the object used to create the prototype in case we need to
      // redefine the widget later
      _proto: $2.extend({}, prototype),
      // Track widgets that inherit from this widget in case this widget is
      // redefined after a widget inherits from it
      _childConstructors: []
    }), basePrototype = new base(), basePrototype.options = $2.widget.extend({}, basePrototype.options), $2.each(prototype, function(prop2, value3) {
      if (typeof value3 != "function") {
        proxiedPrototype[prop2] = value3;
        return;
      }
      proxiedPrototype[prop2] = function() {
        function _super() {
          return base.prototype[prop2].apply(this, arguments);
        }
        __name(_super, "_super");
        function _superApply(args) {
          return base.prototype[prop2].apply(this, args);
        }
        return __name(_superApply, "_superApply"), function() {
          var __super = this._super, __superApply = this._superApply, returnValue;
          return this._super = _super, this._superApply = _superApply, returnValue = value3.apply(this, arguments), this._super = __super, this._superApply = __superApply, returnValue;
        };
      }();
    }), constructor.prototype = $2.widget.extend(basePrototype, {
      // TODO: remove support for widgetEventPrefix
      // always use the name + a colon as the prefix, e.g., draggable:start
      // don't prefix for widgets that aren't DOM-based
      widgetEventPrefix: existingConstructor && basePrototype.widgetEventPrefix || name2
    }, proxiedPrototype, {
      constructor,
      namespace: namespace2,
      widgetName: name2,
      widgetFullName: fullName
    }), existingConstructor ? ($2.each(existingConstructor._childConstructors, function(i, child) {
      var childPrototype = child.prototype;
      $2.widget(
        childPrototype.namespace + "." + childPrototype.widgetName,
        constructor,
        child._proto
      );
    }), delete existingConstructor._childConstructors) : base._childConstructors.push(constructor), $2.widget.bridge(name2, constructor), constructor;
  }, $2.widget.extend = function(target2) {
    for (var input = widgetSlice.call(arguments, 1), inputIndex = 0, inputLength = input.length, key, value3; inputIndex < inputLength; inputIndex++)
      for (key in input[inputIndex])
        value3 = input[inputIndex][key], widgetHasOwnProperty.call(input[inputIndex], key) && value3 !== void 0 && ($2.isPlainObject(value3) ? target2[key] = $2.isPlainObject(target2[key]) ? $2.widget.extend({}, target2[key], value3) : (
          // Don't extend strings, arrays, etc. with objects
          $2.widget.extend({}, value3)
        ) : target2[key] = value3);
    return target2;
  }, $2.widget.bridge = function(name2, object) {
    var fullName = object.prototype.widgetFullName || name2;
    $2.fn[name2] = function(options2) {
      var isMethodCall = typeof options2 == "string", args = widgetSlice.call(arguments, 1), returnValue = this;
      return isMethodCall ? !this.length && options2 === "instance" ? returnValue = void 0 : this.each(function() {
        var methodValue, instance = $2.data(this, fullName);
        if (options2 === "instance")
          return returnValue = instance, !1;
        if (!instance)
          return $2.error("cannot call methods on " + name2 + " prior to initialization; attempted to call method '" + options2 + "'");
        if (typeof instance[options2] != "function" || options2.charAt(0) === "_")
          return $2.error("no such method '" + options2 + "' for " + name2 + " widget instance");
        if (methodValue = instance[options2].apply(instance, args), methodValue !== instance && methodValue !== void 0)
          return returnValue = methodValue && methodValue.jquery ? returnValue.pushStack(methodValue.get()) : methodValue, !1;
      }) : (args.length && (options2 = $2.widget.extend.apply(null, [options2].concat(args))), this.each(function() {
        var instance = $2.data(this, fullName);
        instance ? (instance.option(options2 || {}), instance._init && instance._init()) : $2.data(this, fullName, new object(options2, this));
      })), returnValue;
    };
  }, $2.Widget = function() {
  }, $2.Widget._childConstructors = [], $2.Widget.prototype = {
    widgetName: "widget",
    widgetEventPrefix: "",
    defaultElement: "<div>",
    options: {
      classes: {},
      disabled: !1,
      // Callbacks
      create: null
    },
    _createWidget: /* @__PURE__ */ __name(function(options2, element) {
      element = $2(element || this.defaultElement || this)[0], this.element = $2(element), this.uuid = widgetUuid++, this.eventNamespace = "." + this.widgetName + this.uuid, this.bindings = $2(), this.hoverable = $2(), this.focusable = $2(), this.classesElementLookup = {}, element !== this && ($2.data(element, this.widgetFullName, this), this._on(!0, this.element, {
        remove: /* @__PURE__ */ __name(function(event2) {
          event2.target === element && this.destroy();
        }, "remove")
      }), this.document = $2(element.style ? (
        // Element within the document
        element.ownerDocument
      ) : (
        // Element is window or document
        element.document || element
      )), this.window = $2(this.document[0].defaultView || this.document[0].parentWindow)), this.options = $2.widget.extend(
        {},
        this.options,
        this._getCreateOptions(),
        options2
      ), this._create(), this.options.disabled && this._setOptionDisabled(this.options.disabled), this._trigger("create", null, this._getCreateEventData()), this._init();
    }, "_createWidget"),
    _getCreateOptions: /* @__PURE__ */ __name(function() {
      return {};
    }, "_getCreateOptions"),
    _getCreateEventData: $2.noop,
    _create: $2.noop,
    _init: $2.noop,
    destroy: /* @__PURE__ */ __name(function() {
      var that = this;
      this._destroy(), $2.each(this.classesElementLookup, function(key, value3) {
        that._removeClass(value3, key);
      }), this.element.off(this.eventNamespace).removeData(this.widgetFullName), this.widget().off(this.eventNamespace).removeAttr("aria-disabled"), this.bindings.off(this.eventNamespace);
    }, "destroy"),
    _destroy: $2.noop,
    widget: /* @__PURE__ */ __name(function() {
      return this.element;
    }, "widget"),
    option: /* @__PURE__ */ __name(function(key, value3) {
      var options2 = key, parts, curOption, i;
      if (arguments.length === 0)
        return $2.widget.extend({}, this.options);
      if (typeof key == "string")
        if (options2 = {}, parts = key.split("."), key = parts.shift(), parts.length) {
          for (curOption = options2[key] = $2.widget.extend({}, this.options[key]), i = 0; i < parts.length - 1; i++)
            curOption[parts[i]] = curOption[parts[i]] || {}, curOption = curOption[parts[i]];
          if (key = parts.pop(), arguments.length === 1)
            return curOption[key] === void 0 ? null : curOption[key];
          curOption[key] = value3;
        } else {
          if (arguments.length === 1)
            return this.options[key] === void 0 ? null : this.options[key];
          options2[key] = value3;
        }
      return this._setOptions(options2), this;
    }, "option"),
    _setOptions: /* @__PURE__ */ __name(function(options2) {
      var key;
      for (key in options2)
        this._setOption(key, options2[key]);
      return this;
    }, "_setOptions"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      return key === "classes" && this._setOptionClasses(value3), this.options[key] = value3, key === "disabled" && this._setOptionDisabled(value3), this;
    }, "_setOption"),
    _setOptionClasses: /* @__PURE__ */ __name(function(value3) {
      var classKey, elements, currentElements;
      for (classKey in value3)
        currentElements = this.classesElementLookup[classKey], !(value3[classKey] === this.options.classes[classKey] || !currentElements || !currentElements.length) && (elements = $2(currentElements.get()), this._removeClass(currentElements, classKey), elements.addClass(this._classes({
          element: elements,
          keys: classKey,
          classes: value3,
          add: !0
        })));
    }, "_setOptionClasses"),
    _setOptionDisabled: /* @__PURE__ */ __name(function(value3) {
      this._toggleClass(this.widget(), this.widgetFullName + "-disabled", null, !!value3), value3 && (this._removeClass(this.hoverable, null, "ui-state-hover"), this._removeClass(this.focusable, null, "ui-state-focus"));
    }, "_setOptionDisabled"),
    enable: /* @__PURE__ */ __name(function() {
      return this._setOptions({ disabled: !1 });
    }, "enable"),
    disable: /* @__PURE__ */ __name(function() {
      return this._setOptions({ disabled: !0 });
    }, "disable"),
    _classes: /* @__PURE__ */ __name(function(options2) {
      var full = [], that = this;
      options2 = $2.extend({
        element: this.element,
        classes: this.options.classes || {}
      }, options2);
      function bindRemoveEvent() {
        var nodesToBind = [];
        options2.element.each(function(_2, element) {
          var isTracked = $2.map(that.classesElementLookup, function(elements) {
            return elements;
          }).some(function(elements) {
            return elements.is(element);
          });
          isTracked || nodesToBind.push(element);
        }), that._on($2(nodesToBind), {
          remove: "_untrackClassesElement"
        });
      }
      __name(bindRemoveEvent, "bindRemoveEvent");
      function processClassString(classes2, checkOption) {
        var current, i;
        for (i = 0; i < classes2.length; i++)
          current = that.classesElementLookup[classes2[i]] || $2(), options2.add ? (bindRemoveEvent(), current = $2($2.uniqueSort(current.get().concat(options2.element.get())))) : current = $2(current.not(options2.element).get()), that.classesElementLookup[classes2[i]] = current, full.push(classes2[i]), checkOption && options2.classes[classes2[i]] && full.push(options2.classes[classes2[i]]);
      }
      return __name(processClassString, "processClassString"), options2.keys && processClassString(options2.keys.match(/\S+/g) || [], !0), options2.extra && processClassString(options2.extra.match(/\S+/g) || []), full.join(" ");
    }, "_classes"),
    _untrackClassesElement: /* @__PURE__ */ __name(function(event2) {
      var that = this;
      $2.each(that.classesElementLookup, function(key, value3) {
        $2.inArray(event2.target, value3) !== -1 && (that.classesElementLookup[key] = $2(value3.not(event2.target).get()));
      }), this._off($2(event2.target));
    }, "_untrackClassesElement"),
    _removeClass: /* @__PURE__ */ __name(function(element, keys3, extra) {
      return this._toggleClass(element, keys3, extra, !1);
    }, "_removeClass"),
    _addClass: /* @__PURE__ */ __name(function(element, keys3, extra) {
      return this._toggleClass(element, keys3, extra, !0);
    }, "_addClass"),
    _toggleClass: /* @__PURE__ */ __name(function(element, keys3, extra, add4) {
      add4 = typeof add4 == "boolean" ? add4 : extra;
      var shift2 = typeof element == "string" || element === null, options2 = {
        extra: shift2 ? keys3 : extra,
        keys: shift2 ? element : keys3,
        element: shift2 ? this.element : element,
        add: add4
      };
      return options2.element.toggleClass(this._classes(options2), add4), this;
    }, "_toggleClass"),
    _on: /* @__PURE__ */ __name(function(suppressDisabledCheck, element, handlers) {
      var delegateElement, instance = this;
      typeof suppressDisabledCheck != "boolean" && (handlers = element, element = suppressDisabledCheck, suppressDisabledCheck = !1), handlers ? (element = delegateElement = $2(element), this.bindings = this.bindings.add(element)) : (handlers = element, element = this.element, delegateElement = this.widget()), $2.each(handlers, function(event2, handler4) {
        function handlerProxy() {
          if (!(!suppressDisabledCheck && (instance.options.disabled === !0 || $2(this).hasClass("ui-state-disabled"))))
            return (typeof handler4 == "string" ? instance[handler4] : handler4).apply(instance, arguments);
        }
        __name(handlerProxy, "handlerProxy"), typeof handler4 != "string" && (handlerProxy.guid = handler4.guid = handler4.guid || handlerProxy.guid || $2.guid++);
        var match3 = event2.match(/^([\w:-]*)\s*(.*)$/), eventName = match3[1] + instance.eventNamespace, selector = match3[2];
        selector ? delegateElement.on(eventName, selector, handlerProxy) : element.on(eventName, handlerProxy);
      });
    }, "_on"),
    _off: /* @__PURE__ */ __name(function(element, eventName) {
      eventName = (eventName || "").split(" ").join(this.eventNamespace + " ") + this.eventNamespace, element.off(eventName), this.bindings = $2(this.bindings.not(element).get()), this.focusable = $2(this.focusable.not(element).get()), this.hoverable = $2(this.hoverable.not(element).get());
    }, "_off"),
    _delay: /* @__PURE__ */ __name(function(handler4, delay) {
      function handlerProxy() {
        return (typeof handler4 == "string" ? instance[handler4] : handler4).apply(instance, arguments);
      }
      __name(handlerProxy, "handlerProxy");
      var instance = this;
      return setTimeout(handlerProxy, delay || 0);
    }, "_delay"),
    _hoverable: /* @__PURE__ */ __name(function(element) {
      this.hoverable = this.hoverable.add(element), this._on(element, {
        mouseenter: /* @__PURE__ */ __name(function(event2) {
          this._addClass($2(event2.currentTarget), null, "ui-state-hover");
        }, "mouseenter"),
        mouseleave: /* @__PURE__ */ __name(function(event2) {
          this._removeClass($2(event2.currentTarget), null, "ui-state-hover");
        }, "mouseleave")
      });
    }, "_hoverable"),
    _focusable: /* @__PURE__ */ __name(function(element) {
      this.focusable = this.focusable.add(element), this._on(element, {
        focusin: /* @__PURE__ */ __name(function(event2) {
          this._addClass($2(event2.currentTarget), null, "ui-state-focus");
        }, "focusin"),
        focusout: /* @__PURE__ */ __name(function(event2) {
          this._removeClass($2(event2.currentTarget), null, "ui-state-focus");
        }, "focusout")
      });
    }, "_focusable"),
    _trigger: /* @__PURE__ */ __name(function(type2, event2, data49) {
      var prop2, orig, callback = this.options[type2];
      if (data49 = data49 || {}, event2 = $2.Event(event2), event2.type = (type2 === this.widgetEventPrefix ? type2 : this.widgetEventPrefix + type2).toLowerCase(), event2.target = this.element[0], orig = event2.originalEvent, orig)
        for (prop2 in orig)
          prop2 in event2 || (event2[prop2] = orig[prop2]);
      return this.element.trigger(event2, data49), !(typeof callback == "function" && callback.apply(this.element[0], [event2].concat(data49)) === !1 || event2.isDefaultPrevented());
    }, "_trigger")
  }, $2.each({ show: "fadeIn", hide: "fadeOut" }, function(method, defaultEffect) {
    $2.Widget.prototype["_" + method] = function(element, options2, callback) {
      typeof options2 == "string" && (options2 = { effect: options2 });
      var hasOptions, effectName = options2 ? options2 === !0 || typeof options2 == "number" ? defaultEffect : options2.effect || defaultEffect : method;
      options2 = options2 || {}, typeof options2 == "number" ? options2 = { duration: options2 } : options2 === !0 && (options2 = {}), hasOptions = !$2.isEmptyObject(options2), options2.complete = callback, options2.delay && element.delay(options2.delay), hasOptions && $2.effects && $2.effects.effect[effectName] ? element[method](options2) : effectName !== method && element[effectName] ? element[effectName](options2.duration, options2.easing, callback) : element.queue(function(next3) {
        $2(this)[method](), callback && callback.call(element[0]), next3();
      });
    };
  }), $2.widget;
  /*!
   * jQuery UI Position 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   *
   * https://api.jqueryui.com/position/
   */
  (function() {
    var cachedScrollbarWidth, max2 = Math.max, abs = Math.abs, rhorizontal = /left|center|right/, rvertical = /top|center|bottom/, roffset = /[\+\-]\d+(\.[\d]+)?%?/, rposition = /^\w+/, rpercent = /%$/, _position = $2.fn.position;
    function getOffsets(offsets, width, height) {
      return [
        parseFloat(offsets[0]) * (rpercent.test(offsets[0]) ? width / 100 : 1),
        parseFloat(offsets[1]) * (rpercent.test(offsets[1]) ? height / 100 : 1)
      ];
    }
    __name(getOffsets, "getOffsets");
    function parseCss(element, property) {
      return parseInt($2.css(element, property), 10) || 0;
    }
    __name(parseCss, "parseCss");
    function isWindow(obj2) {
      return obj2 != null && obj2 === obj2.window;
    }
    __name(isWindow, "isWindow");
    function getDimensions(elem) {
      var raw = elem[0];
      return raw.nodeType === 9 ? {
        width: elem.width(),
        height: elem.height(),
        offset: { top: 0, left: 0 }
      } : isWindow(raw) ? {
        width: elem.width(),
        height: elem.height(),
        offset: { top: elem.scrollTop(), left: elem.scrollLeft() }
      } : raw.preventDefault ? {
        width: 0,
        height: 0,
        offset: { top: raw.pageY, left: raw.pageX }
      } : {
        width: elem.outerWidth(),
        height: elem.outerHeight(),
        offset: elem.offset()
      };
    }
    __name(getDimensions, "getDimensions"), $2.position = {
      scrollbarWidth: /* @__PURE__ */ __name(function() {
        if (cachedScrollbarWidth !== void 0)
          return cachedScrollbarWidth;
        var w1, w2, div2 = $2("<div style='display:block;position:absolute;width:200px;height:200px;overflow:hidden;'><div style='height:300px;width:auto;'></div></div>"), innerDiv = div2.children()[0];
        return $2("body").append(div2), w1 = innerDiv.offsetWidth, div2.css("overflow", "scroll"), w2 = innerDiv.offsetWidth, w1 === w2 && (w2 = div2[0].clientWidth), div2.remove(), cachedScrollbarWidth = w1 - w2;
      }, "scrollbarWidth"),
      getScrollInfo: /* @__PURE__ */ __name(function(within2) {
        var overflowX = within2.isWindow || within2.isDocument ? "" : within2.element.css("overflow-x"), overflowY = within2.isWindow || within2.isDocument ? "" : within2.element.css("overflow-y"), hasOverflowX = overflowX === "scroll" || overflowX === "auto" && within2.width < within2.element[0].scrollWidth, hasOverflowY = overflowY === "scroll" || overflowY === "auto" && within2.height < within2.element[0].scrollHeight;
        return {
          width: hasOverflowY ? $2.position.scrollbarWidth() : 0,
          height: hasOverflowX ? $2.position.scrollbarWidth() : 0
        };
      }, "getScrollInfo"),
      getWithinInfo: /* @__PURE__ */ __name(function(element) {
        var withinElement = $2(element || window), isElemWindow = isWindow(withinElement[0]), isDocument = !!withinElement[0] && withinElement[0].nodeType === 9, hasOffset = !isElemWindow && !isDocument;
        return {
          element: withinElement,
          isWindow: isElemWindow,
          isDocument,
          offset: hasOffset ? $2(element).offset() : { left: 0, top: 0 },
          scrollLeft: withinElement.scrollLeft(),
          scrollTop: withinElement.scrollTop(),
          width: withinElement.outerWidth(),
          height: withinElement.outerHeight()
        };
      }, "getWithinInfo")
    }, $2.fn.position = function(options2) {
      if (!options2 || !options2.of)
        return _position.apply(this, arguments);
      options2 = $2.extend({}, options2);
      var atOffset, targetWidth, targetHeight, targetOffset, basePosition, dimensions2, target2 = typeof options2.of == "string" ? $2(document).find(options2.of) : $2(options2.of), within2 = $2.position.getWithinInfo(options2.within), scrollInfo = $2.position.getScrollInfo(within2), collision = (options2.collision || "flip").split(" "), offsets = {};
      return dimensions2 = getDimensions(target2), target2[0].preventDefault && (options2.at = "left top"), targetWidth = dimensions2.width, targetHeight = dimensions2.height, targetOffset = dimensions2.offset, basePosition = $2.extend({}, targetOffset), $2.each(["my", "at"], function() {
        var pos = (options2[this] || "").split(" "), horizontalOffset, verticalOffset;
        pos.length === 1 && (pos = rhorizontal.test(pos[0]) ? pos.concat(["center"]) : rvertical.test(pos[0]) ? ["center"].concat(pos) : ["center", "center"]), pos[0] = rhorizontal.test(pos[0]) ? pos[0] : "center", pos[1] = rvertical.test(pos[1]) ? pos[1] : "center", horizontalOffset = roffset.exec(pos[0]), verticalOffset = roffset.exec(pos[1]), offsets[this] = [
          horizontalOffset ? horizontalOffset[0] : 0,
          verticalOffset ? verticalOffset[0] : 0
        ], options2[this] = [
          rposition.exec(pos[0])[0],
          rposition.exec(pos[1])[0]
        ];
      }), collision.length === 1 && (collision[1] = collision[0]), options2.at[0] === "right" ? basePosition.left += targetWidth : options2.at[0] === "center" && (basePosition.left += targetWidth / 2), options2.at[1] === "bottom" ? basePosition.top += targetHeight : options2.at[1] === "center" && (basePosition.top += targetHeight / 2), atOffset = getOffsets(offsets.at, targetWidth, targetHeight), basePosition.left += atOffset[0], basePosition.top += atOffset[1], this.each(function() {
        var collisionPosition, using, elem = $2(this), elemWidth = elem.outerWidth(), elemHeight = elem.outerHeight(), marginLeft = parseCss(this, "marginLeft"), marginTop = parseCss(this, "marginTop"), collisionWidth = elemWidth + marginLeft + parseCss(this, "marginRight") + scrollInfo.width, collisionHeight = elemHeight + marginTop + parseCss(this, "marginBottom") + scrollInfo.height, position3 = $2.extend({}, basePosition), myOffset = getOffsets(offsets.my, elem.outerWidth(), elem.outerHeight());
        options2.my[0] === "right" ? position3.left -= elemWidth : options2.my[0] === "center" && (position3.left -= elemWidth / 2), options2.my[1] === "bottom" ? position3.top -= elemHeight : options2.my[1] === "center" && (position3.top -= elemHeight / 2), position3.left += myOffset[0], position3.top += myOffset[1], collisionPosition = {
          marginLeft,
          marginTop
        }, $2.each(["left", "top"], function(i, dir) {
          $2.ui.position[collision[i]] && $2.ui.position[collision[i]][dir](position3, {
            targetWidth,
            targetHeight,
            elemWidth,
            elemHeight,
            collisionPosition,
            collisionWidth,
            collisionHeight,
            offset: [atOffset[0] + myOffset[0], atOffset[1] + myOffset[1]],
            my: options2.my,
            at: options2.at,
            within: within2,
            elem
          });
        }), options2.using && (using = /* @__PURE__ */ __name(function(props2) {
          var left2 = targetOffset.left - position3.left, right2 = left2 + targetWidth - elemWidth, top2 = targetOffset.top - position3.top, bottom2 = top2 + targetHeight - elemHeight, feedback = {
            target: {
              element: target2,
              left: targetOffset.left,
              top: targetOffset.top,
              width: targetWidth,
              height: targetHeight
            },
            element: {
              element: elem,
              left: position3.left,
              top: position3.top,
              width: elemWidth,
              height: elemHeight
            },
            horizontal: right2 < 0 ? "left" : left2 > 0 ? "right" : "center",
            vertical: bottom2 < 0 ? "top" : top2 > 0 ? "bottom" : "middle"
          };
          targetWidth < elemWidth && abs(left2 + right2) < targetWidth && (feedback.horizontal = "center"), targetHeight < elemHeight && abs(top2 + bottom2) < targetHeight && (feedback.vertical = "middle"), max2(abs(left2), abs(right2)) > max2(abs(top2), abs(bottom2)) ? feedback.important = "horizontal" : feedback.important = "vertical", options2.using.call(this, props2, feedback);
        }, "using")), elem.offset($2.extend(position3, { using }));
      });
    }, $2.ui.position = {
      fit: {
        left: /* @__PURE__ */ __name(function(position3, data49) {
          var within2 = data49.within, withinOffset = within2.isWindow ? within2.scrollLeft : within2.offset.left, outerWidth = within2.width, collisionPosLeft = position3.left - data49.collisionPosition.marginLeft, overLeft = withinOffset - collisionPosLeft, overRight = collisionPosLeft + data49.collisionWidth - outerWidth - withinOffset, newOverRight;
          data49.collisionWidth > outerWidth ? overLeft > 0 && overRight <= 0 ? (newOverRight = position3.left + overLeft + data49.collisionWidth - outerWidth - withinOffset, position3.left += overLeft - newOverRight) : overRight > 0 && overLeft <= 0 ? position3.left = withinOffset : overLeft > overRight ? position3.left = withinOffset + outerWidth - data49.collisionWidth : position3.left = withinOffset : overLeft > 0 ? position3.left += overLeft : overRight > 0 ? position3.left -= overRight : position3.left = max2(position3.left - collisionPosLeft, position3.left);
        }, "left"),
        top: /* @__PURE__ */ __name(function(position3, data49) {
          var within2 = data49.within, withinOffset = within2.isWindow ? within2.scrollTop : within2.offset.top, outerHeight = data49.within.height, collisionPosTop = position3.top - data49.collisionPosition.marginTop, overTop = withinOffset - collisionPosTop, overBottom = collisionPosTop + data49.collisionHeight - outerHeight - withinOffset, newOverBottom;
          data49.collisionHeight > outerHeight ? overTop > 0 && overBottom <= 0 ? (newOverBottom = position3.top + overTop + data49.collisionHeight - outerHeight - withinOffset, position3.top += overTop - newOverBottom) : overBottom > 0 && overTop <= 0 ? position3.top = withinOffset : overTop > overBottom ? position3.top = withinOffset + outerHeight - data49.collisionHeight : position3.top = withinOffset : overTop > 0 ? position3.top += overTop : overBottom > 0 ? position3.top -= overBottom : position3.top = max2(position3.top - collisionPosTop, position3.top);
        }, "top")
      },
      flip: {
        left: /* @__PURE__ */ __name(function(position3, data49) {
          var within2 = data49.within, withinOffset = within2.offset.left + within2.scrollLeft, outerWidth = within2.width, offsetLeft = within2.isWindow ? within2.scrollLeft : within2.offset.left, collisionPosLeft = position3.left - data49.collisionPosition.marginLeft, overLeft = collisionPosLeft - offsetLeft, overRight = collisionPosLeft + data49.collisionWidth - outerWidth - offsetLeft, myOffset = data49.my[0] === "left" ? -data49.elemWidth : data49.my[0] === "right" ? data49.elemWidth : 0, atOffset = data49.at[0] === "left" ? data49.targetWidth : data49.at[0] === "right" ? -data49.targetWidth : 0, offset3 = -2 * data49.offset[0], newOverRight, newOverLeft;
          overLeft < 0 ? (newOverRight = position3.left + myOffset + atOffset + offset3 + data49.collisionWidth - outerWidth - withinOffset, (newOverRight < 0 || newOverRight < abs(overLeft)) && (position3.left += myOffset + atOffset + offset3)) : overRight > 0 && (newOverLeft = position3.left - data49.collisionPosition.marginLeft + myOffset + atOffset + offset3 - offsetLeft, (newOverLeft > 0 || abs(newOverLeft) < overRight) && (position3.left += myOffset + atOffset + offset3));
        }, "left"),
        top: /* @__PURE__ */ __name(function(position3, data49) {
          var within2 = data49.within, withinOffset = within2.offset.top + within2.scrollTop, outerHeight = within2.height, offsetTop = within2.isWindow ? within2.scrollTop : within2.offset.top, collisionPosTop = position3.top - data49.collisionPosition.marginTop, overTop = collisionPosTop - offsetTop, overBottom = collisionPosTop + data49.collisionHeight - outerHeight - offsetTop, top2 = data49.my[1] === "top", myOffset = top2 ? -data49.elemHeight : data49.my[1] === "bottom" ? data49.elemHeight : 0, atOffset = data49.at[1] === "top" ? data49.targetHeight : data49.at[1] === "bottom" ? -data49.targetHeight : 0, offset3 = -2 * data49.offset[1], newOverTop, newOverBottom;
          overTop < 0 ? (newOverBottom = position3.top + myOffset + atOffset + offset3 + data49.collisionHeight - outerHeight - withinOffset, (newOverBottom < 0 || newOverBottom < abs(overTop)) && (position3.top += myOffset + atOffset + offset3)) : overBottom > 0 && (newOverTop = position3.top - data49.collisionPosition.marginTop + myOffset + atOffset + offset3 - offsetTop, (newOverTop > 0 || abs(newOverTop) < overBottom) && (position3.top += myOffset + atOffset + offset3));
        }, "top")
      },
      flipfit: {
        left: /* @__PURE__ */ __name(function() {
          $2.ui.position.flip.left.apply(this, arguments), $2.ui.position.fit.left.apply(this, arguments);
        }, "left"),
        top: /* @__PURE__ */ __name(function() {
          $2.ui.position.flip.top.apply(this, arguments), $2.ui.position.fit.top.apply(this, arguments);
        }, "top")
      }
    };
  })(), $2.ui.position;
  /*!
   * jQuery UI :data 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.extend($2.expr.pseudos, {
    data: $2.expr.createPseudo(function(dataName) {
      return function(elem) {
        return !!$2.data(elem, dataName);
      };
    })
  });
  /*!
   * jQuery UI Disable Selection 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.fn.extend({
    disableSelection: function() {
      var eventType = "onselectstart" in document.createElement("div") ? "selectstart" : "mousedown";
      return function() {
        return this.on(eventType + ".ui-disableSelection", function(event2) {
          event2.preventDefault();
        });
      };
    }(),
    enableSelection: /* @__PURE__ */ __name(function() {
      return this.off(".ui-disableSelection");
    }, "enableSelection")
  });
  var jQuery2 = $2;
  /*!
   * jQuery Color Animations v3.0.0
   * https://github.com/jquery/jquery-color
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   *
   * Date: Wed May 15 16:49:44 2024 +0200
   */
  var stepHooks = "backgroundColor borderBottomColor borderLeftColor borderRightColor borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor", class2type = {}, toString4 = class2type.toString, rplusequals = /^([\-+])=\s*(\d+\.?\d*)/, stringParsers = [{
    re: /rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,
    parse: /* @__PURE__ */ __name(function(execResult) {
      return [
        execResult[1],
        execResult[2],
        execResult[3],
        execResult[4]
      ];
    }, "parse")
  }, {
    re: /rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,
    parse: /* @__PURE__ */ __name(function(execResult) {
      return [
        execResult[1] * 2.55,
        execResult[2] * 2.55,
        execResult[3] * 2.55,
        execResult[4]
      ];
    }, "parse")
  }, {
    // this regex ignores A-F because it's compared against an already lowercased string
    re: /#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?/,
    parse: /* @__PURE__ */ __name(function(execResult) {
      return [
        parseInt(execResult[1], 16),
        parseInt(execResult[2], 16),
        parseInt(execResult[3], 16),
        execResult[4] ? (parseInt(execResult[4], 16) / 255).toFixed(2) : 1
      ];
    }, "parse")
  }, {
    // this regex ignores A-F because it's compared against an already lowercased string
    re: /#([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?/,
    parse: /* @__PURE__ */ __name(function(execResult) {
      return [
        parseInt(execResult[1] + execResult[1], 16),
        parseInt(execResult[2] + execResult[2], 16),
        parseInt(execResult[3] + execResult[3], 16),
        execResult[4] ? (parseInt(execResult[4] + execResult[4], 16) / 255).toFixed(2) : 1
      ];
    }, "parse")
  }, {
    re: /hsla?\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,
    space: "hsla",
    parse: /* @__PURE__ */ __name(function(execResult) {
      return [
        execResult[1],
        execResult[2] / 100,
        execResult[3] / 100,
        execResult[4]
      ];
    }, "parse")
  }], color = jQuery2.Color = function(color2, green, blue, alpha2) {
    return new jQuery2.Color.fn.parse(color2, green, blue, alpha2);
  }, spaces = {
    rgba: {
      props: {
        red: {
          idx: 0,
          type: "byte"
        },
        green: {
          idx: 1,
          type: "byte"
        },
        blue: {
          idx: 2,
          type: "byte"
        }
      }
    },
    hsla: {
      props: {
        hue: {
          idx: 0,
          type: "degrees"
        },
        saturation: {
          idx: 1,
          type: "percent"
        },
        lightness: {
          idx: 2,
          type: "percent"
        }
      }
    }
  }, propTypes = {
    byte: {
      floor: !0,
      max: 255
    },
    percent: {
      max: 1
    },
    degrees: {
      mod: 360,
      floor: !0
    }
  }, colors, each = jQuery2.each;
  each(spaces, function(spaceName, space) {
    space.cache = "_" + spaceName, space.props.alpha = {
      idx: 3,
      type: "percent",
      def: 1
    };
  }), jQuery2.each(
    "Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),
    function(_i, name2) {
      class2type["[object " + name2 + "]"] = name2.toLowerCase();
    }
  );
  function getType2(obj2) {
    return obj2 == null ? obj2 + "" : typeof obj2 == "object" ? class2type[toString4.call(obj2)] || "object" : typeof obj2;
  }
  __name(getType2, "getType");
  function clamp(value3, prop2, allowEmpty) {
    var type2 = propTypes[prop2.type] || {};
    return value3 == null ? allowEmpty || !prop2.def ? null : prop2.def : (value3 = type2.floor ? ~~value3 : parseFloat(value3), type2.mod ? (value3 + type2.mod) % type2.mod : Math.min(type2.max, Math.max(0, value3)));
  }
  __name(clamp, "clamp");
  function stringParse(string) {
    var inst = color(), rgba = inst._rgba = [];
    return string = string.toLowerCase(), each(stringParsers, function(_i, parser) {
      var parsed, match3 = parser.re.exec(string), values2 = match3 && parser.parse(match3), spaceName = parser.space || "rgba";
      if (values2)
        return parsed = inst[spaceName](values2), inst[spaces[spaceName].cache] = parsed[spaces[spaceName].cache], rgba = inst._rgba = parsed._rgba, !1;
    }), rgba.length ? (rgba.join() === "0,0,0,0" && jQuery2.extend(rgba, colors.transparent), inst) : colors[string];
  }
  __name(stringParse, "stringParse"), color.fn = jQuery2.extend(color.prototype, {
    parse: /* @__PURE__ */ __name(function(red, green, blue, alpha2) {
      if (red === void 0)
        return this._rgba = [null, null, null, null], this;
      (red.jquery || red.nodeType) && (red = jQuery2(red).css(green), green = void 0);
      var inst = this, type2 = getType2(red), rgba = this._rgba = [];
      if (green !== void 0 && (red = [red, green, blue, alpha2], type2 = "array"), type2 === "string")
        return this.parse(stringParse(red) || colors._default);
      if (type2 === "array")
        return each(spaces.rgba.props, function(_key2, prop2) {
          rgba[prop2.idx] = clamp(red[prop2.idx], prop2);
        }), this;
      if (type2 === "object")
        return red instanceof color ? each(spaces, function(_spaceName, space) {
          red[space.cache] && (inst[space.cache] = red[space.cache].slice());
        }) : each(spaces, function(_spaceName, space) {
          var cache = space.cache;
          each(space.props, function(key, prop2) {
            if (!inst[cache] && space.to) {
              if (key === "alpha" || red[key] == null)
                return;
              inst[cache] = space.to(inst._rgba);
            }
            inst[cache][prop2.idx] = clamp(red[key], prop2, !0);
          }), inst[cache] && jQuery2.inArray(
            null,
            inst[cache].slice(0, 3)
          ) < 0 && (inst[cache][3] == null && (inst[cache][3] = 1), space.from && (inst._rgba = space.from(inst[cache])));
        }), this;
    }, "parse"),
    is: /* @__PURE__ */ __name(function(compare2) {
      var is3 = color(compare2), same = !0, inst = this;
      return each(spaces, function(_2, space) {
        var localCache, isCache = is3[space.cache];
        return isCache && (localCache = inst[space.cache] || space.to && space.to(inst._rgba) || [], each(space.props, function(_3, prop2) {
          if (isCache[prop2.idx] != null)
            return same = isCache[prop2.idx] === localCache[prop2.idx], same;
        })), same;
      }), same;
    }, "is"),
    _space: /* @__PURE__ */ __name(function() {
      var used = [], inst = this;
      return each(spaces, function(spaceName, space) {
        inst[space.cache] && used.push(spaceName);
      }), used.pop();
    }, "_space"),
    transition: /* @__PURE__ */ __name(function(other, distance) {
      var end2 = color(other), spaceName = end2._space(), space = spaces[spaceName], startColor = this.alpha() === 0 ? color("transparent") : this, start3 = startColor[space.cache] || space.to(startColor._rgba), result = start3.slice();
      return end2 = end2[space.cache], each(space.props, function(_key2, prop2) {
        var index3 = prop2.idx, startValue = start3[index3], endValue = end2[index3], type2 = propTypes[prop2.type] || {};
        endValue !== null && (startValue === null ? result[index3] = endValue : (type2.mod && (endValue - startValue > type2.mod / 2 ? startValue += type2.mod : startValue - endValue > type2.mod / 2 && (startValue -= type2.mod)), result[index3] = clamp((endValue - startValue) * distance + startValue, prop2)));
      }), this[spaceName](result);
    }, "transition"),
    blend: /* @__PURE__ */ __name(function(opaque) {
      if (this._rgba[3] === 1)
        return this;
      var rgb = this._rgba.slice(), a2 = rgb.pop(), blend = color(opaque)._rgba;
      return color(jQuery2.map(rgb, function(v, i) {
        return (1 - a2) * blend[i] + a2 * v;
      }));
    }, "blend"),
    toRgbaString: /* @__PURE__ */ __name(function() {
      var prefix = "rgba(", rgba = jQuery2.map(this._rgba, function(v, i) {
        return v ?? (i > 2 ? 1 : 0);
      });
      return rgba[3] === 1 && (rgba.pop(), prefix = "rgb("), prefix + rgba.join(", ") + ")";
    }, "toRgbaString"),
    toHslaString: /* @__PURE__ */ __name(function() {
      var prefix = "hsla(", hsla = jQuery2.map(this.hsla(), function(v, i) {
        return v == null && (v = i > 2 ? 1 : 0), i && i < 3 && (v = Math.round(v * 100) + "%"), v;
      });
      return hsla[3] === 1 && (hsla.pop(), prefix = "hsl("), prefix + hsla.join(", ") + ")";
    }, "toHslaString"),
    toHexString: /* @__PURE__ */ __name(function(includeAlpha) {
      var rgba = this._rgba.slice(), alpha2 = rgba.pop();
      return includeAlpha && rgba.push(~~(alpha2 * 255)), "#" + jQuery2.map(rgba, function(v) {
        return ("0" + (v || 0).toString(16)).substr(-2);
      }).join("");
    }, "toHexString"),
    toString: /* @__PURE__ */ __name(function() {
      return this.toRgbaString();
    }, "toString")
  }), color.fn.parse.prototype = color.fn;
  function hue2rgb(p, q, h) {
    return h = (h + 1) % 1, h * 6 < 1 ? p + (q - p) * h * 6 : h * 2 < 1 ? q : h * 3 < 2 ? p + (q - p) * (2 / 3 - h) * 6 : p;
  }
  __name(hue2rgb, "hue2rgb"), spaces.hsla.to = function(rgba) {
    if (rgba[0] == null || rgba[1] == null || rgba[2] == null)
      return [null, null, null, rgba[3]];
    var r2 = rgba[0] / 255, g2 = rgba[1] / 255, b = rgba[2] / 255, a2 = rgba[3], max2 = Math.max(r2, g2, b), min2 = Math.min(r2, g2, b), diff = max2 - min2, add4 = max2 + min2, l = add4 * 0.5, h, s2;
    return min2 === max2 ? h = 0 : r2 === max2 ? h = 60 * (g2 - b) / diff + 360 : g2 === max2 ? h = 60 * (b - r2) / diff + 120 : h = 60 * (r2 - g2) / diff + 240, diff === 0 ? s2 = 0 : l <= 0.5 ? s2 = diff / add4 : s2 = diff / (2 - add4), [Math.round(h) % 360, s2, l, a2 ?? 1];
  }, spaces.hsla.from = function(hsla) {
    if (hsla[0] == null || hsla[1] == null || hsla[2] == null)
      return [null, null, null, hsla[3]];
    var h = hsla[0] / 360, s2 = hsla[1], l = hsla[2], a2 = hsla[3], q = l <= 0.5 ? l * (1 + s2) : l + s2 - l * s2, p = 2 * l - q;
    return [
      Math.round(hue2rgb(p, q, h + 1 / 3) * 255),
      Math.round(hue2rgb(p, q, h) * 255),
      Math.round(hue2rgb(p, q, h - 1 / 3) * 255),
      a2
    ];
  }, each(spaces, function(spaceName, space) {
    var props2 = space.props, cache = space.cache, to2 = space.to, from3 = space.from;
    color.fn[spaceName] = function(value3) {
      if (to2 && !this[cache] && (this[cache] = to2(this._rgba)), value3 === void 0)
        return this[cache].slice();
      var ret, type2 = getType2(value3), arr = type2 === "array" || type2 === "object" ? value3 : arguments, local = this[cache].slice();
      return each(props2, function(key, prop2) {
        var val = arr[type2 === "object" ? key : prop2.idx];
        val == null && (val = local[prop2.idx]), local[prop2.idx] = clamp(val, prop2);
      }), from3 ? (ret = color(from3(local)), ret[cache] = local, ret) : color(local);
    }, each(props2, function(key, prop2) {
      color.fn[key] || (color.fn[key] = function(value3) {
        var local, cur, match3, fn2, vtype = getType2(value3);
        return key === "alpha" ? fn2 = this._hsla ? "hsla" : "rgba" : fn2 = spaceName, local = this[fn2](), cur = local[prop2.idx], vtype === "undefined" ? cur : (vtype === "function" && (value3 = value3.call(this, cur), vtype = getType2(value3)), value3 == null && prop2.empty ? this : (vtype === "string" && (match3 = rplusequals.exec(value3), match3 && (value3 = cur + parseFloat(match3[2]) * (match3[1] === "+" ? 1 : -1))), local[prop2.idx] = value3, this[fn2](local)));
      });
    });
  }), color.hook = function(hook) {
    var hooks2 = hook.split(" ");
    each(hooks2, function(_i, hook2) {
      jQuery2.cssHooks[hook2] = {
        set: /* @__PURE__ */ __name(function(elem, value3) {
          var parsed;
          value3 !== "transparent" && (getType2(value3) !== "string" || (parsed = stringParse(value3))) && (value3 = color(parsed || value3), value3 = value3.toRgbaString()), elem.style[hook2] = value3;
        }, "set")
      }, jQuery2.fx.step[hook2] = function(fx) {
        fx.colorInit || (fx.start = color(fx.elem, hook2), fx.end = color(fx.end), fx.colorInit = !0), jQuery2.cssHooks[hook2].set(fx.elem, fx.start.transition(fx.end, fx.pos));
      };
    });
  }, color.hook(stepHooks), jQuery2.cssHooks.borderColor = {
    expand: /* @__PURE__ */ __name(function(value3) {
      var expanded = {};
      return each(["Top", "Right", "Bottom", "Left"], function(_i, part) {
        expanded["border" + part + "Color"] = value3;
      }), expanded;
    }, "expand")
  }, colors = jQuery2.Color.names = {
    // 4.1. Basic color keywords
    aqua: "#00ffff",
    black: "#000000",
    blue: "#0000ff",
    fuchsia: "#ff00ff",
    gray: "#808080",
    green: "#008000",
    lime: "#00ff00",
    maroon: "#800000",
    navy: "#000080",
    olive: "#808000",
    purple: "#800080",
    red: "#ff0000",
    silver: "#c0c0c0",
    teal: "#008080",
    white: "#ffffff",
    yellow: "#ffff00",
    // 4.2.3. "transparent" color keyword
    transparent: [null, null, null, 0],
    _default: "#ffffff"
  };
  /*!
   * jQuery UI Effects 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  var dataSpace = "ui-effects-", dataSpaceStyle = "ui-effects-style", dataSpaceAnimated = "ui-effects-animated";
  $2.effects = {
    effect: {}
  }, function() {
    var classAnimationActions = ["add", "remove", "toggle"], shorthandStyles = {
      border: 1,
      borderBottom: 1,
      borderColor: 1,
      borderLeft: 1,
      borderRight: 1,
      borderTop: 1,
      borderWidth: 1,
      margin: 1,
      padding: 1
    };
    $2.each(
      ["borderLeftStyle", "borderRightStyle", "borderBottomStyle", "borderTopStyle"],
      function(_2, prop2) {
        $2.fx.step[prop2] = function(fx) {
          (fx.end !== "none" && !fx.setAttr || fx.pos === 1 && !fx.setAttr) && (jQuery2.style(fx.elem, prop2, fx.end), fx.setAttr = !0);
        };
      }
    );
    function camelCase(string) {
      return string.replace(/-([\da-z])/gi, function(all2, letter) {
        return letter.toUpperCase();
      });
    }
    __name(camelCase, "camelCase");
    function getElementStyles(elem) {
      var key, len2, style2 = elem.ownerDocument.defaultView.getComputedStyle(elem), styles2 = {};
      for (len2 = style2.length; len2--; )
        key = style2[len2], typeof style2[key] == "string" && (styles2[camelCase(key)] = style2[key]);
      return styles2;
    }
    __name(getElementStyles, "getElementStyles");
    function styleDifference(oldStyle, newStyle) {
      var diff = {}, name2, value3;
      for (name2 in newStyle)
        value3 = newStyle[name2], oldStyle[name2] !== value3 && (shorthandStyles[name2] || ($2.fx.step[name2] || !isNaN(parseFloat(value3))) && (diff[name2] = value3));
      return diff;
    }
    __name(styleDifference, "styleDifference"), $2.effects.animateClass = function(value3, duration, easing, callback) {
      var o = $2.speed(duration, easing, callback);
      return this.queue(function() {
        var animated = $2(this), baseClass = animated.attr("class") || "", applyClassChange, allAnimations = o.children ? animated.find("*").addBack() : animated;
        allAnimations = allAnimations.map(function() {
          var el = $2(this);
          return {
            el,
            start: getElementStyles(this)
          };
        }), applyClassChange = /* @__PURE__ */ __name(function() {
          $2.each(classAnimationActions, function(i, action) {
            value3[action] && animated[action + "Class"](value3[action]);
          });
        }, "applyClassChange"), applyClassChange(), allAnimations = allAnimations.map(function() {
          return this.end = getElementStyles(this.el[0]), this.diff = styleDifference(this.start, this.end), this;
        }), animated.attr("class", baseClass), allAnimations = allAnimations.map(function() {
          var styleInfo = this, dfd = $2.Deferred(), opts = $2.extend({}, o, {
            queue: !1,
            complete: /* @__PURE__ */ __name(function() {
              dfd.resolve(styleInfo);
            }, "complete")
          });
          return this.el.animate(this.diff, opts), dfd.promise();
        }), $2.when.apply($2, allAnimations.get()).done(function() {
          applyClassChange(), $2.each(arguments, function() {
            var el = this.el;
            $2.each(this.diff, function(key) {
              el.css(key, "");
            });
          }), o.complete.call(animated[0]);
        });
      });
    }, $2.fn.extend({
      addClass: /* @__PURE__ */ function(orig) {
        return function(classNames, speed, easing, callback) {
          return speed ? $2.effects.animateClass.call(
            this,
            { add: classNames },
            speed,
            easing,
            callback
          ) : orig.apply(this, arguments);
        };
      }($2.fn.addClass),
      removeClass: /* @__PURE__ */ function(orig) {
        return function(classNames, speed, easing, callback) {
          return arguments.length > 1 ? $2.effects.animateClass.call(
            this,
            { remove: classNames },
            speed,
            easing,
            callback
          ) : orig.apply(this, arguments);
        };
      }($2.fn.removeClass),
      toggleClass: /* @__PURE__ */ function(orig) {
        return function(classNames, force, speed, easing, callback) {
          return typeof force == "boolean" || force === void 0 ? speed ? $2.effects.animateClass.call(
            this,
            force ? { add: classNames } : { remove: classNames },
            speed,
            easing,
            callback
          ) : orig.apply(this, arguments) : $2.effects.animateClass.call(
            this,
            { toggle: classNames },
            force,
            speed,
            easing
          );
        };
      }($2.fn.toggleClass),
      switchClass: /* @__PURE__ */ __name(function(remove8, add4, speed, easing, callback) {
        return $2.effects.animateClass.call(this, {
          add: add4,
          remove: remove8
        }, speed, easing, callback);
      }, "switchClass")
    });
  }(), function() {
    $2.expr && $2.expr.pseudos && $2.expr.pseudos.animated && ($2.expr.pseudos.animated = /* @__PURE__ */ function(orig) {
      return function(elem) {
        return !!$2(elem).data(dataSpaceAnimated) || orig(elem);
      };
    }($2.expr.pseudos.animated)), $2.uiBackCompat === !0 && $2.extend($2.effects, {
      // Saves a set of properties in a data storage
      save: /* @__PURE__ */ __name(function(element, set6) {
        for (var i = 0, length2 = set6.length; i < length2; i++)
          set6[i] !== null && element.data(dataSpace + set6[i], element[0].style[set6[i]]);
      }, "save"),
      // Restores a set of previously saved properties from a data storage
      restore: /* @__PURE__ */ __name(function(element, set6) {
        for (var val, i = 0, length2 = set6.length; i < length2; i++)
          set6[i] !== null && (val = element.data(dataSpace + set6[i]), element.css(set6[i], val));
      }, "restore"),
      setMode: /* @__PURE__ */ __name(function(el, mode) {
        return mode === "toggle" && (mode = el.is(":hidden") ? "show" : "hide"), mode;
      }, "setMode"),
      // Wraps the element around a wrapper that copies position properties
      createWrapper: /* @__PURE__ */ __name(function(element) {
        if (element.parent().is(".ui-effects-wrapper"))
          return element.parent();
        var props2 = {
          width: element.outerWidth(!0),
          height: element.outerHeight(!0),
          float: element.css("float")
        }, wrapper = $2("<div></div>").addClass("ui-effects-wrapper").css({
          fontSize: "100%",
          background: "transparent",
          border: "none",
          margin: 0,
          padding: 0
        }), size2 = {
          width: element.width(),
          height: element.height()
        }, active = document.activeElement;
        try {
          active.id;
        } catch {
          active = document.body;
        }
        return element.wrap(wrapper), (element[0] === active || $2.contains(element[0], active)) && $2(active).trigger("focus"), wrapper = element.parent(), element.css("position") === "static" ? (wrapper.css({ position: "relative" }), element.css({ position: "relative" })) : ($2.extend(props2, {
          position: element.css("position"),
          zIndex: element.css("z-index")
        }), $2.each(["top", "left", "bottom", "right"], function(i, pos) {
          props2[pos] = element.css(pos), isNaN(parseInt(props2[pos], 10)) && (props2[pos] = "auto");
        }), element.css({
          position: "relative",
          top: 0,
          left: 0,
          right: "auto",
          bottom: "auto"
        })), element.css(size2), wrapper.css(props2).show();
      }, "createWrapper"),
      removeWrapper: /* @__PURE__ */ __name(function(element) {
        var active = document.activeElement;
        return element.parent().is(".ui-effects-wrapper") && (element.parent().replaceWith(element), (element[0] === active || $2.contains(element[0], active)) && $2(active).trigger("focus")), element;
      }, "removeWrapper")
    }), $2.extend($2.effects, {
      version: "1.14.1",
      define: /* @__PURE__ */ __name(function(name2, mode, effect2) {
        return effect2 || (effect2 = mode, mode = "effect"), $2.effects.effect[name2] = effect2, $2.effects.effect[name2].mode = mode, effect2;
      }, "define"),
      scaledDimensions: /* @__PURE__ */ __name(function(element, percent, direction) {
        if (percent === 0)
          return {
            height: 0,
            width: 0,
            outerHeight: 0,
            outerWidth: 0
          };
        var x = direction !== "horizontal" ? (percent || 100) / 100 : 1, y = direction !== "vertical" ? (percent || 100) / 100 : 1;
        return {
          height: element.height() * y,
          width: element.width() * x,
          outerHeight: element.outerHeight() * y,
          outerWidth: element.outerWidth() * x
        };
      }, "scaledDimensions"),
      clipToBox: /* @__PURE__ */ __name(function(animation) {
        return {
          width: animation.clip.right - animation.clip.left,
          height: animation.clip.bottom - animation.clip.top,
          left: animation.clip.left,
          top: animation.clip.top
        };
      }, "clipToBox"),
      // Injects recently queued functions to be first in line (after "inprogress")
      unshift: /* @__PURE__ */ __name(function(element, queueLength, count2) {
        var queue2 = element.queue();
        queueLength > 1 && queue2.splice.apply(
          queue2,
          [1, 0].concat(queue2.splice(queueLength, count2))
        ), element.dequeue();
      }, "unshift"),
      saveStyle: /* @__PURE__ */ __name(function(element) {
        element.data(dataSpaceStyle, element[0].style.cssText);
      }, "saveStyle"),
      restoreStyle: /* @__PURE__ */ __name(function(element) {
        element[0].style.cssText = element.data(dataSpaceStyle) || "", element.removeData(dataSpaceStyle);
      }, "restoreStyle"),
      mode: /* @__PURE__ */ __name(function(element, mode) {
        var hidden2 = element.is(":hidden");
        return mode === "toggle" && (mode = hidden2 ? "show" : "hide"), (hidden2 ? mode === "hide" : mode === "show") && (mode = "none"), mode;
      }, "mode"),
      // Translates a [top,left] array into a baseline value
      getBaseline: /* @__PURE__ */ __name(function(origin, original) {
        var y, x;
        switch (origin[0]) {
          case "top":
            y = 0;
            break;
          case "middle":
            y = 0.5;
            break;
          case "bottom":
            y = 1;
            break;
          default:
            y = origin[0] / original.height;
        }
        switch (origin[1]) {
          case "left":
            x = 0;
            break;
          case "center":
            x = 0.5;
            break;
          case "right":
            x = 1;
            break;
          default:
            x = origin[1] / original.width;
        }
        return {
          x,
          y
        };
      }, "getBaseline"),
      // Creates a placeholder element so that the original element can be made absolute
      createPlaceholder: /* @__PURE__ */ __name(function(element) {
        var placeholder2, cssPosition = element.css("position"), position3 = element.position();
        return element.css({
          marginTop: element.css("marginTop"),
          marginBottom: element.css("marginBottom"),
          marginLeft: element.css("marginLeft"),
          marginRight: element.css("marginRight")
        }).outerWidth(element.outerWidth()).outerHeight(element.outerHeight()), /^(static|relative)/.test(cssPosition) && (cssPosition = "absolute", placeholder2 = $2("<" + element[0].nodeName + ">").insertAfter(element).css({
          // Convert inline to inline block to account for inline elements
          // that turn to inline block based on content (like img)
          display: /^(inline|ruby)/.test(element.css("display")) ? "inline-block" : "block",
          visibility: "hidden",
          // Margins need to be set to account for margin collapse
          marginTop: element.css("marginTop"),
          marginBottom: element.css("marginBottom"),
          marginLeft: element.css("marginLeft"),
          marginRight: element.css("marginRight"),
          float: element.css("float")
        }).outerWidth(element.outerWidth()).outerHeight(element.outerHeight()).addClass("ui-effects-placeholder"), element.data(dataSpace + "placeholder", placeholder2)), element.css({
          position: cssPosition,
          left: position3.left,
          top: position3.top
        }), placeholder2;
      }, "createPlaceholder"),
      removePlaceholder: /* @__PURE__ */ __name(function(element) {
        var dataKey = dataSpace + "placeholder", placeholder2 = element.data(dataKey);
        placeholder2 && (placeholder2.remove(), element.removeData(dataKey));
      }, "removePlaceholder"),
      // Removes a placeholder if it exists and restores
      // properties that were modified during placeholder creation
      cleanUp: /* @__PURE__ */ __name(function(element) {
        $2.effects.restoreStyle(element), $2.effects.removePlaceholder(element);
      }, "cleanUp"),
      setTransition: /* @__PURE__ */ __name(function(element, list, factor, value3) {
        return value3 = value3 || {}, $2.each(list, function(i, x) {
          var unit = element.cssUnit(x);
          unit[0] > 0 && (value3[x] = unit[0] * factor + unit[1]);
        }), value3;
      }, "setTransition")
    });
    function _normalizeArguments(effect2, options2, speed, callback) {
      return $2.isPlainObject(effect2) && (options2 = effect2, effect2 = effect2.effect), effect2 = { effect: effect2 }, options2 == null && (options2 = {}), typeof options2 == "function" && (callback = options2, speed = null, options2 = {}), (typeof options2 == "number" || $2.fx.speeds[options2]) && (callback = speed, speed = options2, options2 = {}), typeof speed == "function" && (callback = speed, speed = null), options2 && $2.extend(effect2, options2), speed = speed || options2.duration, effect2.duration = $2.fx.off ? 0 : typeof speed == "number" ? speed : speed in $2.fx.speeds ? $2.fx.speeds[speed] : $2.fx.speeds._default, effect2.complete = callback || options2.complete, effect2;
    }
    __name(_normalizeArguments, "_normalizeArguments");
    function standardAnimationOption(option2) {
      return !!(!option2 || typeof option2 == "number" || $2.fx.speeds[option2] || typeof option2 == "string" && !$2.effects.effect[option2] || typeof option2 == "function" || typeof option2 == "object" && !option2.effect);
    }
    __name(standardAnimationOption, "standardAnimationOption"), $2.fn.extend({
      effect: /* @__PURE__ */ __name(function() {
        var args = _normalizeArguments.apply(this, arguments), effectMethod = $2.effects.effect[args.effect], defaultMode = effectMethod.mode, queue2 = args.queue, queueName = queue2 || "fx", complete = args.complete, mode = args.mode, modes2 = [], prefilter = /* @__PURE__ */ __name(function(next3) {
          var el = $2(this), normalizedMode = $2.effects.mode(el, mode) || defaultMode;
          el.data(dataSpaceAnimated, !0), modes2.push(normalizedMode), defaultMode && (normalizedMode === "show" || normalizedMode === defaultMode && normalizedMode === "hide") && el.show(), (!defaultMode || normalizedMode !== "none") && $2.effects.saveStyle(el), typeof next3 == "function" && next3();
        }, "prefilter");
        if ($2.fx.off || !effectMethod)
          return mode ? this[mode](args.duration, complete) : this.each(function() {
            complete && complete.call(this);
          });
        function run(next3) {
          var elem = $2(this);
          function cleanup() {
            elem.removeData(dataSpaceAnimated), $2.effects.cleanUp(elem), args.mode === "hide" && elem.hide(), done();
          }
          __name(cleanup, "cleanup");
          function done() {
            typeof complete == "function" && complete.call(elem[0]), typeof next3 == "function" && next3();
          }
          __name(done, "done"), args.mode = modes2.shift(), $2.uiBackCompat === !0 && !defaultMode ? (elem.is(":hidden") ? mode === "hide" : mode === "show") ? (elem[mode](), done()) : effectMethod.call(elem[0], args, done) : args.mode === "none" ? (elem[mode](), done()) : effectMethod.call(elem[0], args, cleanup);
        }
        return __name(run, "run"), queue2 === !1 ? this.each(prefilter).each(run) : this.queue(queueName, prefilter).queue(queueName, run);
      }, "effect"),
      show: /* @__PURE__ */ function(orig) {
        return function(option2) {
          if (standardAnimationOption(option2))
            return orig.apply(this, arguments);
          var args = _normalizeArguments.apply(this, arguments);
          return args.mode = "show", this.effect.call(this, args);
        };
      }($2.fn.show),
      hide: /* @__PURE__ */ function(orig) {
        return function(option2) {
          if (standardAnimationOption(option2))
            return orig.apply(this, arguments);
          var args = _normalizeArguments.apply(this, arguments);
          return args.mode = "hide", this.effect.call(this, args);
        };
      }($2.fn.hide),
      toggle: /* @__PURE__ */ function(orig) {
        return function(option2) {
          if (standardAnimationOption(option2) || typeof option2 == "boolean")
            return orig.apply(this, arguments);
          var args = _normalizeArguments.apply(this, arguments);
          return args.mode = "toggle", this.effect.call(this, args);
        };
      }($2.fn.toggle),
      cssUnit: /* @__PURE__ */ __name(function(key) {
        var style2 = this.css(key), val = [];
        return $2.each(["em", "px", "%", "pt"], function(i, unit) {
          style2.indexOf(unit) > 0 && (val = [parseFloat(style2), unit]);
        }), val;
      }, "cssUnit"),
      cssClip: /* @__PURE__ */ __name(function(clipObj) {
        return clipObj ? this.css("clip", "rect(" + clipObj.top + "px " + clipObj.right + "px " + clipObj.bottom + "px " + clipObj.left + "px)") : parseClip(this.css("clip"), this);
      }, "cssClip"),
      transfer: /* @__PURE__ */ __name(function(options2, done) {
        var element = $2(this), target2 = $2(options2.to), targetFixed = target2.css("position") === "fixed", body = $2("body"), fixTop = targetFixed ? body.scrollTop() : 0, fixLeft = targetFixed ? body.scrollLeft() : 0, endPosition = target2.offset(), animation = {
          top: endPosition.top - fixTop,
          left: endPosition.left - fixLeft,
          height: target2.innerHeight(),
          width: target2.innerWidth()
        }, startPosition = element.offset(), transfer = $2("<div class='ui-effects-transfer'></div>");
        transfer.appendTo("body").addClass(options2.className).css({
          top: startPosition.top - fixTop,
          left: startPosition.left - fixLeft,
          height: element.innerHeight(),
          width: element.innerWidth(),
          position: targetFixed ? "fixed" : "absolute"
        }).animate(animation, options2.duration, options2.easing, function() {
          transfer.remove(), typeof done == "function" && done();
        });
      }, "transfer")
    });
    function parseClip(str2, element) {
      var outerWidth = element.outerWidth(), outerHeight = element.outerHeight(), clipRegex = /^rect\((-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto)\)$/, values2 = clipRegex.exec(str2) || ["", 0, outerWidth, outerHeight, 0];
      return {
        top: parseFloat(values2[1]) || 0,
        right: values2[2] === "auto" ? outerWidth : parseFloat(values2[2]),
        bottom: values2[3] === "auto" ? outerHeight : parseFloat(values2[3]),
        left: parseFloat(values2[4]) || 0
      };
    }
    __name(parseClip, "parseClip"), $2.fx.step.clip = function(fx) {
      fx.clipInit || (fx.start = $2(fx.elem).cssClip(), typeof fx.end == "string" && (fx.end = parseClip(fx.end, fx.elem)), fx.clipInit = !0), $2(fx.elem).cssClip({
        top: fx.pos * (fx.end.top - fx.start.top) + fx.start.top,
        right: fx.pos * (fx.end.right - fx.start.right) + fx.start.right,
        bottom: fx.pos * (fx.end.bottom - fx.start.bottom) + fx.start.bottom,
        left: fx.pos * (fx.end.left - fx.start.left) + fx.start.left
      });
    };
  }(), function() {
    var baseEasings = {};
    $2.each(["Quad", "Cubic", "Quart", "Quint", "Expo"], function(i, name2) {
      baseEasings[name2] = function(p) {
        return Math.pow(p, i + 2);
      };
    }), $2.extend(baseEasings, {
      Sine: /* @__PURE__ */ __name(function(p) {
        return 1 - Math.cos(p * Math.PI / 2);
      }, "Sine"),
      Circ: /* @__PURE__ */ __name(function(p) {
        return 1 - Math.sqrt(1 - p * p);
      }, "Circ"),
      Elastic: /* @__PURE__ */ __name(function(p) {
        return p === 0 || p === 1 ? p : -Math.pow(2, 8 * (p - 1)) * Math.sin(((p - 1) * 80 - 7.5) * Math.PI / 15);
      }, "Elastic"),
      Back: /* @__PURE__ */ __name(function(p) {
        return p * p * (3 * p - 2);
      }, "Back"),
      Bounce: /* @__PURE__ */ __name(function(p) {
        for (var pow2, bounce = 4; p < ((pow2 = Math.pow(2, --bounce)) - 1) / 11; )
          ;
        return 1 / Math.pow(4, 3 - bounce) - 7.5625 * Math.pow((pow2 * 3 - 2) / 22 - p, 2);
      }, "Bounce")
    }), $2.each(baseEasings, function(name2, easeIn) {
      $2.easing["easeIn" + name2] = easeIn, $2.easing["easeOut" + name2] = function(p) {
        return 1 - easeIn(1 - p);
      }, $2.easing["easeInOut" + name2] = function(p) {
        return p < 0.5 ? easeIn(p * 2) / 2 : 1 - easeIn(p * -2 + 2) / 2;
      };
    });
  }(), $2.effects;
  /*!
   * jQuery UI Effects Blind 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("blind", "hide", function(options2, done) {
    var map2 = {
      up: ["bottom", "top"],
      vertical: ["bottom", "top"],
      down: ["top", "bottom"],
      left: ["right", "left"],
      horizontal: ["right", "left"],
      right: ["left", "right"]
    }, element = $2(this), direction = options2.direction || "up", start3 = element.cssClip(), animate = { clip: $2.extend({}, start3) }, placeholder2 = $2.effects.createPlaceholder(element);
    animate.clip[map2[direction][0]] = animate.clip[map2[direction][1]], options2.mode === "show" && (element.cssClip(animate.clip), placeholder2 && placeholder2.css($2.effects.clipToBox(animate)), animate.clip = start3), placeholder2 && placeholder2.animate($2.effects.clipToBox(animate), options2.duration, options2.easing), element.animate(animate, {
      queue: !1,
      duration: options2.duration,
      easing: options2.easing,
      complete: done
    });
  });
  /*!
   * jQuery UI Effects Bounce 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("bounce", function(options2, done) {
    var upAnim, downAnim, refValue, element = $2(this), mode = options2.mode, hide8 = mode === "hide", show7 = mode === "show", direction = options2.direction || "up", distance = options2.distance, times = options2.times || 5, anims = times * 2 + (show7 || hide8 ? 1 : 0), speed = options2.duration / anims, easing = options2.easing, ref2 = direction === "up" || direction === "down" ? "top" : "left", motion = direction === "up" || direction === "left", i = 0, queuelen = element.queue().length;
    for ($2.effects.createPlaceholder(element), refValue = element.css(ref2), distance || (distance = element[ref2 === "top" ? "outerHeight" : "outerWidth"]() / 3), show7 && (downAnim = { opacity: 1 }, downAnim[ref2] = refValue, element.css("opacity", 0).css(ref2, motion ? -distance * 2 : distance * 2).animate(downAnim, speed, easing)), hide8 && (distance = distance / Math.pow(2, times - 1)), downAnim = {}, downAnim[ref2] = refValue; i < times; i++)
      upAnim = {}, upAnim[ref2] = (motion ? "-=" : "+=") + distance, element.animate(upAnim, speed, easing).animate(downAnim, speed, easing), distance = hide8 ? distance * 2 : distance / 2;
    hide8 && (upAnim = { opacity: 0 }, upAnim[ref2] = (motion ? "-=" : "+=") + distance, element.animate(upAnim, speed, easing)), element.queue(done), $2.effects.unshift(element, queuelen, anims + 1);
  });
  /*!
   * jQuery UI Effects Clip 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("clip", "hide", function(options2, done) {
    var start3, animate = {}, element = $2(this), direction = options2.direction || "vertical", both = direction === "both", horizontal = both || direction === "horizontal", vertical = both || direction === "vertical";
    start3 = element.cssClip(), animate.clip = {
      top: vertical ? (start3.bottom - start3.top) / 2 : start3.top,
      right: horizontal ? (start3.right - start3.left) / 2 : start3.right,
      bottom: vertical ? (start3.bottom - start3.top) / 2 : start3.bottom,
      left: horizontal ? (start3.right - start3.left) / 2 : start3.left
    }, $2.effects.createPlaceholder(element), options2.mode === "show" && (element.cssClip(animate.clip), animate.clip = start3), element.animate(animate, {
      queue: !1,
      duration: options2.duration,
      easing: options2.easing,
      complete: done
    });
  });
  /*!
   * jQuery UI Effects Drop 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("drop", "hide", function(options2, done) {
    var distance, element = $2(this), mode = options2.mode, show7 = mode === "show", direction = options2.direction || "left", ref2 = direction === "up" || direction === "down" ? "top" : "left", motion = direction === "up" || direction === "left" ? "-=" : "+=", oppositeMotion = motion === "+=" ? "-=" : "+=", animation = {
      opacity: 0
    };
    $2.effects.createPlaceholder(element), distance = options2.distance || element[ref2 === "top" ? "outerHeight" : "outerWidth"](!0) / 2, animation[ref2] = motion + distance, show7 && (element.css(animation), animation[ref2] = oppositeMotion + distance, animation.opacity = 1), element.animate(animation, {
      queue: !1,
      duration: options2.duration,
      easing: options2.easing,
      complete: done
    });
  });
  /*!
   * jQuery UI Effects Explode 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("explode", "hide", function(options2, done) {
    var i, j, left2, top2, mx, my, rows = options2.pieces ? Math.round(Math.sqrt(options2.pieces)) : 3, cells = rows, element = $2(this), mode = options2.mode, show7 = mode === "show", offset3 = element.show().css("visibility", "hidden").offset(), width = Math.ceil(element.outerWidth() / cells), height = Math.ceil(element.outerHeight() / rows), pieces = [];
    function childComplete() {
      pieces.push(this), pieces.length === rows * cells && animComplete();
    }
    for (__name(childComplete, "childComplete"), i = 0; i < rows; i++)
      for (top2 = offset3.top + i * height, my = i - (rows - 1) / 2, j = 0; j < cells; j++)
        left2 = offset3.left + j * width, mx = j - (cells - 1) / 2, element.clone().appendTo("body").wrap("<div></div>").css({
          position: "absolute",
          visibility: "visible",
          left: -j * width,
          top: -i * height
        }).parent().addClass("ui-effects-explode").css({
          position: "absolute",
          overflow: "hidden",
          width,
          height,
          left: left2 + (show7 ? mx * width : 0),
          top: top2 + (show7 ? my * height : 0),
          opacity: show7 ? 0 : 1
        }).animate({
          left: left2 + (show7 ? 0 : mx * width),
          top: top2 + (show7 ? 0 : my * height),
          opacity: show7 ? 1 : 0
        }, options2.duration || 500, options2.easing, childComplete);
    function animComplete() {
      element.css({
        visibility: "visible"
      }), $2(pieces).remove(), done();
    }
    __name(animComplete, "animComplete");
  });
  /*!
   * jQuery UI Effects Fade 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("fade", "toggle", function(options2, done) {
    var show7 = options2.mode === "show";
    $2(this).css("opacity", show7 ? 0 : 1).animate({
      opacity: show7 ? 1 : 0
    }, {
      queue: !1,
      duration: options2.duration,
      easing: options2.easing,
      complete: done
    });
  });
  /*!
   * jQuery UI Effects Fold 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("fold", "hide", function(options2, done) {
    var element = $2(this), mode = options2.mode, show7 = mode === "show", hide8 = mode === "hide", size2 = options2.size || 15, percent = /([0-9]+)%/.exec(size2), horizFirst = !!options2.horizFirst, ref2 = horizFirst ? ["right", "bottom"] : ["bottom", "right"], duration = options2.duration / 2, placeholder2 = $2.effects.createPlaceholder(element), start3 = element.cssClip(), animation1 = { clip: $2.extend({}, start3) }, animation2 = { clip: $2.extend({}, start3) }, distance = [start3[ref2[0]], start3[ref2[1]]], queuelen = element.queue().length;
    percent && (size2 = parseInt(percent[1], 10) / 100 * distance[hide8 ? 0 : 1]), animation1.clip[ref2[0]] = size2, animation2.clip[ref2[0]] = size2, animation2.clip[ref2[1]] = 0, show7 && (element.cssClip(animation2.clip), placeholder2 && placeholder2.css($2.effects.clipToBox(animation2)), animation2.clip = start3), element.queue(function(next3) {
      placeholder2 && placeholder2.animate($2.effects.clipToBox(animation1), duration, options2.easing).animate($2.effects.clipToBox(animation2), duration, options2.easing), next3();
    }).animate(animation1, duration, options2.easing).animate(animation2, duration, options2.easing).queue(done), $2.effects.unshift(element, queuelen, 4);
  });
  /*!
   * jQuery UI Effects Highlight 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("highlight", "show", function(options2, done) {
    var element = $2(this), animation = {
      backgroundColor: element.css("backgroundColor")
    };
    options2.mode === "hide" && (animation.opacity = 0), $2.effects.saveStyle(element), element.css({
      backgroundImage: "none",
      backgroundColor: options2.color || "#ffff99"
    }).animate(animation, {
      queue: !1,
      duration: options2.duration,
      easing: options2.easing,
      complete: done
    });
  });
  /*!
   * jQuery UI Effects Size 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("size", function(options2, done) {
    var baseline, factor, temp, element = $2(this), cProps = ["fontSize"], vProps = ["borderTopWidth", "borderBottomWidth", "paddingTop", "paddingBottom"], hProps = ["borderLeftWidth", "borderRightWidth", "paddingLeft", "paddingRight"], mode = options2.mode, restore = mode !== "effect", scale = options2.scale || "both", origin = options2.origin || ["middle", "center"], position3 = element.css("position"), pos = element.position(), original = $2.effects.scaledDimensions(element), from3 = options2.from || original, to2 = options2.to || $2.effects.scaledDimensions(element, 0);
    $2.effects.createPlaceholder(element), mode === "show" && (temp = from3, from3 = to2, to2 = temp), factor = {
      from: {
        y: from3.height / original.height,
        x: from3.width / original.width
      },
      to: {
        y: to2.height / original.height,
        x: to2.width / original.width
      }
    }, (scale === "box" || scale === "both") && (factor.from.y !== factor.to.y && (from3 = $2.effects.setTransition(element, vProps, factor.from.y, from3), to2 = $2.effects.setTransition(element, vProps, factor.to.y, to2)), factor.from.x !== factor.to.x && (from3 = $2.effects.setTransition(element, hProps, factor.from.x, from3), to2 = $2.effects.setTransition(element, hProps, factor.to.x, to2))), (scale === "content" || scale === "both") && factor.from.y !== factor.to.y && (from3 = $2.effects.setTransition(element, cProps, factor.from.y, from3), to2 = $2.effects.setTransition(element, cProps, factor.to.y, to2)), origin && (baseline = $2.effects.getBaseline(origin, original), from3.top = (original.outerHeight - from3.outerHeight) * baseline.y + pos.top, from3.left = (original.outerWidth - from3.outerWidth) * baseline.x + pos.left, to2.top = (original.outerHeight - to2.outerHeight) * baseline.y + pos.top, to2.left = (original.outerWidth - to2.outerWidth) * baseline.x + pos.left), delete from3.outerHeight, delete from3.outerWidth, element.css(from3), (scale === "content" || scale === "both") && (vProps = vProps.concat(["marginTop", "marginBottom"]).concat(cProps), hProps = hProps.concat(["marginLeft", "marginRight"]), element.find("*[width]").each(function() {
      var child = $2(this), childOriginal = $2.effects.scaledDimensions(child), childFrom = {
        height: childOriginal.height * factor.from.y,
        width: childOriginal.width * factor.from.x,
        outerHeight: childOriginal.outerHeight * factor.from.y,
        outerWidth: childOriginal.outerWidth * factor.from.x
      }, childTo = {
        height: childOriginal.height * factor.to.y,
        width: childOriginal.width * factor.to.x,
        outerHeight: childOriginal.height * factor.to.y,
        outerWidth: childOriginal.width * factor.to.x
      };
      factor.from.y !== factor.to.y && (childFrom = $2.effects.setTransition(child, vProps, factor.from.y, childFrom), childTo = $2.effects.setTransition(child, vProps, factor.to.y, childTo)), factor.from.x !== factor.to.x && (childFrom = $2.effects.setTransition(child, hProps, factor.from.x, childFrom), childTo = $2.effects.setTransition(child, hProps, factor.to.x, childTo)), restore && $2.effects.saveStyle(child), child.css(childFrom), child.animate(childTo, options2.duration, options2.easing, function() {
        restore && $2.effects.restoreStyle(child);
      });
    })), element.animate(to2, {
      queue: !1,
      duration: options2.duration,
      easing: options2.easing,
      complete: /* @__PURE__ */ __name(function() {
        var offset3 = element.offset();
        to2.opacity === 0 && element.css("opacity", from3.opacity), restore || (element.css("position", position3 === "static" ? "relative" : position3).offset(offset3), $2.effects.saveStyle(element)), done();
      }, "complete")
    });
  });
  /*!
   * jQuery UI Effects Scale 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("scale", function(options2, done) {
    var el = $2(this), mode = options2.mode, percent = parseInt(options2.percent, 10) || (parseInt(options2.percent, 10) === 0 || mode !== "effect" ? 0 : 100), newOptions = $2.extend(!0, {
      from: $2.effects.scaledDimensions(el),
      to: $2.effects.scaledDimensions(el, percent, options2.direction || "both"),
      origin: options2.origin || ["middle", "center"]
    }, options2);
    options2.fade && (newOptions.from.opacity = 1, newOptions.to.opacity = 0), $2.effects.effect.size.call(this, newOptions, done);
  });
  /*!
   * jQuery UI Effects Puff 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("puff", "hide", function(options2, done) {
    var newOptions = $2.extend(!0, {}, options2, {
      fade: !0,
      percent: parseInt(options2.percent, 10) || 150
    });
    $2.effects.effect.scale.call(this, newOptions, done);
  });
  /*!
   * jQuery UI Effects Pulsate 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("pulsate", "show", function(options2, done) {
    var element = $2(this), mode = options2.mode, show7 = mode === "show", hide8 = mode === "hide", showhide = show7 || hide8, anims = (options2.times || 5) * 2 + (showhide ? 1 : 0), duration = options2.duration / anims, animateTo = 0, i = 1, queuelen = element.queue().length;
    for ((show7 || !element.is(":visible")) && (element.css("opacity", 0).show(), animateTo = 1); i < anims; i++)
      element.animate({ opacity: animateTo }, duration, options2.easing), animateTo = 1 - animateTo;
    element.animate({ opacity: animateTo }, duration, options2.easing), element.queue(done), $2.effects.unshift(element, queuelen, anims + 1);
  });
  /*!
   * jQuery UI Effects Shake 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("shake", function(options2, done) {
    var i = 1, element = $2(this), direction = options2.direction || "left", distance = options2.distance || 20, times = options2.times || 3, anims = times * 2 + 1, speed = Math.round(options2.duration / anims), ref2 = direction === "up" || direction === "down" ? "top" : "left", positiveMotion = direction === "up" || direction === "left", animation = {}, animation1 = {}, animation2 = {}, queuelen = element.queue().length;
    for ($2.effects.createPlaceholder(element), animation[ref2] = (positiveMotion ? "-=" : "+=") + distance, animation1[ref2] = (positiveMotion ? "+=" : "-=") + distance * 2, animation2[ref2] = (positiveMotion ? "-=" : "+=") + distance * 2, element.animate(animation, speed, options2.easing); i < times; i++)
      element.animate(animation1, speed, options2.easing).animate(animation2, speed, options2.easing);
    element.animate(animation1, speed, options2.easing).animate(animation, speed / 2, options2.easing).queue(done), $2.effects.unshift(element, queuelen, anims + 1);
  });
  /*!
   * jQuery UI Effects Slide 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.effects.define("slide", "show", function(options2, done) {
    var startClip, startRef, element = $2(this), map2 = {
      up: ["bottom", "top"],
      down: ["top", "bottom"],
      left: ["right", "left"],
      right: ["left", "right"]
    }, mode = options2.mode, direction = options2.direction || "left", ref2 = direction === "up" || direction === "down" ? "top" : "left", positiveMotion = direction === "up" || direction === "left", distance = options2.distance || element[ref2 === "top" ? "outerHeight" : "outerWidth"](!0), animation = {};
    $2.effects.createPlaceholder(element), startClip = element.cssClip(), startRef = element.position()[ref2], animation[ref2] = (positiveMotion ? -1 : 1) * distance + startRef, animation.clip = element.cssClip(), animation.clip[map2[direction][1]] = animation.clip[map2[direction][0]], mode === "show" && (element.cssClip(animation.clip), element.css(ref2, animation[ref2]), animation.clip = startClip, animation[ref2] = startRef), element.animate(animation, {
      queue: !1,
      duration: options2.duration,
      easing: options2.easing,
      complete: done
    });
  }), $2.uiBackCompat === !0 && $2.effects.define("transfer", function(options2, done) {
    $2(this).transfer(options2, done);
  });
  /*!
   * jQuery UI Focusable 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.ui.focusable = function(element, hasTabindex) {
    var map2, mapName, img, focusableIfVisible, fieldset, nodeName = element.nodeName.toLowerCase();
    return nodeName === "area" ? (map2 = element.parentNode, mapName = map2.name, !element.href || !mapName || map2.nodeName.toLowerCase() !== "map" ? !1 : (img = $2("img[usemap='#" + mapName + "']"), img.length > 0 && img.is(":visible"))) : (/^(input|select|textarea|button|object)$/.test(nodeName) ? (focusableIfVisible = !element.disabled, focusableIfVisible && (fieldset = $2(element).closest("fieldset")[0], fieldset && (focusableIfVisible = !fieldset.disabled))) : nodeName === "a" ? focusableIfVisible = element.href || hasTabindex : focusableIfVisible = hasTabindex, focusableIfVisible && $2(element).is(":visible") && $2(element).css("visibility") === "visible");
  }, $2.extend($2.expr.pseudos, {
    focusable: /* @__PURE__ */ __name(function(element) {
      return $2.ui.focusable(element, $2.attr(element, "tabindex") != null);
    }, "focusable")
  }), $2.ui.focusable;
  /*!
   * jQuery UI Form Reset Mixin 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.ui.formResetMixin = {
    _formResetHandler: /* @__PURE__ */ __name(function() {
      var form2 = $2(this);
      setTimeout(function() {
        var instances = form2.data("ui-form-reset-instances");
        $2.each(instances, function() {
          this.refresh();
        });
      });
    }, "_formResetHandler"),
    _bindFormResetHandler: /* @__PURE__ */ __name(function() {
      if (this.form = $2(this.element.prop("form")), !!this.form.length) {
        var instances = this.form.data("ui-form-reset-instances") || [];
        instances.length || this.form.on("reset.ui-form-reset", this._formResetHandler), instances.push(this), this.form.data("ui-form-reset-instances", instances);
      }
    }, "_bindFormResetHandler"),
    _unbindFormResetHandler: /* @__PURE__ */ __name(function() {
      if (this.form.length) {
        var instances = this.form.data("ui-form-reset-instances");
        instances.splice($2.inArray(this, instances), 1), instances.length ? this.form.data("ui-form-reset-instances", instances) : this.form.removeData("ui-form-reset-instances").off("reset.ui-form-reset");
      }
    }, "_unbindFormResetHandler")
  };
  /*!
   * jQuery UI Legacy jQuery Core patches 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   *
   */
  $2.escapeSelector || ($2.escapeSelector = function(id2) {
    return CSS.escape(id2 + "");
  }), (!$2.fn.even || !$2.fn.odd) && $2.fn.extend({
    even: /* @__PURE__ */ __name(function() {
      return this.filter(function(i) {
        return i % 2 === 0;
      });
    }, "even"),
    odd: /* @__PURE__ */ __name(function() {
      return this.filter(function(i) {
        return i % 2 === 1;
      });
    }, "odd")
  });
  /*!
   * jQuery UI Keycode 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.ui.keyCode = {
    BACKSPACE: 8,
    COMMA: 188,
    DELETE: 46,
    DOWN: 40,
    END: 35,
    ENTER: 13,
    ESCAPE: 27,
    HOME: 36,
    LEFT: 37,
    PAGE_DOWN: 34,
    PAGE_UP: 33,
    PERIOD: 190,
    RIGHT: 39,
    SPACE: 32,
    TAB: 9,
    UP: 38
  };
  /*!
   * jQuery UI Labels 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.fn.labels = function() {
    var ancestor, selector, id2, labels, ancestors;
    return this.length ? this[0].labels && this[0].labels.length ? this.pushStack(this[0].labels) : (labels = this.eq(0).parents("label"), id2 = this.attr("id"), id2 && (ancestor = this.eq(0).parents().last(), ancestors = ancestor.add(ancestor.length ? ancestor.siblings() : this.siblings()), selector = "label[for='" + CSS.escape(id2) + "']", labels = labels.add(ancestors.find(selector).addBack(selector))), this.pushStack(labels)) : this.pushStack([]);
  };
  /*!
   * jQuery UI Scroll Parent 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.fn.scrollParent = function(includeHidden) {
    var position3 = this.css("position"), excludeStaticParent = position3 === "absolute", overflowRegex = includeHidden ? /(auto|scroll|hidden)/ : /(auto|scroll)/, scrollParent = this.parents().filter(function() {
      var parent = $2(this);
      return excludeStaticParent && parent.css("position") === "static" ? !1 : overflowRegex.test(parent.css("overflow") + parent.css("overflow-y") + parent.css("overflow-x"));
    }).eq(0);
    return position3 === "fixed" || !scrollParent.length ? $2(this[0].ownerDocument || document) : scrollParent;
  };
  /*!
   * jQuery UI Tabbable 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.extend($2.expr.pseudos, {
    tabbable: /* @__PURE__ */ __name(function(element) {
      var tabIndex = $2.attr(element, "tabindex"), hasTabindex = tabIndex != null;
      return (!hasTabindex || tabIndex >= 0) && $2.ui.focusable(element, hasTabindex);
    }, "tabbable")
  });
  /*!
   * jQuery UI Unique ID 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.fn.extend({
    uniqueId: /* @__PURE__ */ function() {
      var uuid = 0;
      return function() {
        return this.each(function() {
          this.id || (this.id = "ui-id-" + ++uuid);
        });
      };
    }(),
    removeUniqueId: /* @__PURE__ */ __name(function() {
      return this.each(function() {
        /^ui-id-\d+$/.test(this.id) && $2(this).removeAttr("id");
      });
    }, "removeUniqueId")
  });
  /*!
   * jQuery UI Accordion 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.accordion", {
    version: "1.14.1",
    options: {
      active: 0,
      animate: {},
      classes: {
        "ui-accordion-header": "ui-corner-top",
        "ui-accordion-header-collapsed": "ui-corner-all",
        "ui-accordion-content": "ui-corner-bottom"
      },
      collapsible: !1,
      event: "click",
      header: /* @__PURE__ */ __name(function(elem) {
        return elem.find("> li > :first-child").add(
          elem.find("> :not(li)").filter(function(i) {
            return i % 2 === 0;
          })
        );
      }, "header"),
      heightStyle: "auto",
      icons: {
        activeHeader: "ui-icon-triangle-1-s",
        header: "ui-icon-triangle-1-e"
      },
      // Callbacks
      activate: null,
      beforeActivate: null
    },
    hideProps: {
      borderTopWidth: "hide",
      borderBottomWidth: "hide",
      paddingTop: "hide",
      paddingBottom: "hide",
      height: "hide"
    },
    showProps: {
      borderTopWidth: "show",
      borderBottomWidth: "show",
      paddingTop: "show",
      paddingBottom: "show",
      height: "show"
    },
    _create: /* @__PURE__ */ __name(function() {
      var options2 = this.options;
      this.prevShow = this.prevHide = $2(), this._addClass("ui-accordion", "ui-widget ui-helper-reset"), this.element.attr("role", "tablist"), !options2.collapsible && (options2.active === !1 || options2.active == null) && (options2.active = 0), this._processPanels(), options2.active < 0 && (options2.active += this.headers.length), this._refresh();
    }, "_create"),
    _getCreateEventData: /* @__PURE__ */ __name(function() {
      return {
        header: this.active,
        panel: this.active.length ? this.active.next() : $2()
      };
    }, "_getCreateEventData"),
    _createIcons: /* @__PURE__ */ __name(function() {
      var icon, children2, icons2 = this.options.icons;
      icons2 && (icon = $2("<span>"), this._addClass(icon, "ui-accordion-header-icon", "ui-icon " + icons2.header), icon.prependTo(this.headers), children2 = this.active.children(".ui-accordion-header-icon"), this._removeClass(children2, icons2.header)._addClass(children2, null, icons2.activeHeader)._addClass(this.headers, "ui-accordion-icons"));
    }, "_createIcons"),
    _destroyIcons: /* @__PURE__ */ __name(function() {
      this._removeClass(this.headers, "ui-accordion-icons"), this.headers.children(".ui-accordion-header-icon").remove();
    }, "_destroyIcons"),
    _destroy: /* @__PURE__ */ __name(function() {
      var contents;
      this.element.removeAttr("role"), this.headers.removeAttr("role aria-expanded aria-selected aria-controls tabIndex").removeUniqueId(), this._destroyIcons(), contents = this.headers.next().css("display", "").removeAttr("role aria-hidden aria-labelledby").removeUniqueId(), this.options.heightStyle !== "content" && contents.css("height", "");
    }, "_destroy"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      if (key === "active") {
        this._activate(value3);
        return;
      }
      key === "event" && (this.options.event && this._off(this.headers, this.options.event), this._setupEvents(value3)), this._super(key, value3), key === "collapsible" && !value3 && this.options.active === !1 && this._activate(0), key === "icons" && (this._destroyIcons(), value3 && this._createIcons());
    }, "_setOption"),
    _setOptionDisabled: /* @__PURE__ */ __name(function(value3) {
      this._super(value3), this.element.attr("aria-disabled", value3), this._toggleClass(null, "ui-state-disabled", !!value3);
    }, "_setOptionDisabled"),
    _keydown: /* @__PURE__ */ __name(function(event2) {
      if (!(event2.altKey || event2.ctrlKey)) {
        var keyCode = $2.ui.keyCode, length2 = this.headers.length, currentIndex = this.headers.index(event2.target), toFocus = !1;
        switch (event2.keyCode) {
          case keyCode.RIGHT:
          case keyCode.DOWN:
            toFocus = this.headers[(currentIndex + 1) % length2];
            break;
          case keyCode.LEFT:
          case keyCode.UP:
            toFocus = this.headers[(currentIndex - 1 + length2) % length2];
            break;
          case keyCode.SPACE:
          case keyCode.ENTER:
            this._eventHandler(event2);
            break;
          case keyCode.HOME:
            toFocus = this.headers[0];
            break;
          case keyCode.END:
            toFocus = this.headers[length2 - 1];
            break;
        }
        toFocus && ($2(event2.target).attr("tabIndex", -1), $2(toFocus).attr("tabIndex", 0), $2(toFocus).trigger("focus"), event2.preventDefault());
      }
    }, "_keydown"),
    _panelKeyDown: /* @__PURE__ */ __name(function(event2) {
      event2.keyCode === $2.ui.keyCode.UP && event2.ctrlKey && $2(event2.currentTarget).prev().trigger("focus");
    }, "_panelKeyDown"),
    refresh: /* @__PURE__ */ __name(function() {
      var options2 = this.options;
      this._processPanels(), options2.active === !1 && options2.collapsible === !0 || !this.headers.length ? (options2.active = !1, this.active = $2()) : options2.active === !1 ? this._activate(0) : this.active.length && !$2.contains(this.element[0], this.active[0]) ? this.headers.length === this.headers.find(".ui-state-disabled").length ? (options2.active = !1, this.active = $2()) : this._activate(Math.max(0, options2.active - 1)) : options2.active = this.headers.index(this.active), this._destroyIcons(), this._refresh();
    }, "refresh"),
    _processPanels: /* @__PURE__ */ __name(function() {
      var prevHeaders = this.headers, prevPanels = this.panels;
      typeof this.options.header == "function" ? this.headers = this.options.header(this.element) : this.headers = this.element.find(this.options.header), this._addClass(
        this.headers,
        "ui-accordion-header ui-accordion-header-collapsed",
        "ui-state-default"
      ), this.panels = this.headers.next().filter(":not(.ui-accordion-content-active)").hide(), this._addClass(this.panels, "ui-accordion-content", "ui-helper-reset ui-widget-content"), prevPanels && (this._off(prevHeaders.not(this.headers)), this._off(prevPanels.not(this.panels)));
    }, "_processPanels"),
    _refresh: /* @__PURE__ */ __name(function() {
      var maxHeight, options2 = this.options, heightStyle = options2.heightStyle, parent = this.element.parent();
      this.active = this._findActive(options2.active), this._addClass(this.active, "ui-accordion-header-active", "ui-state-active")._removeClass(this.active, "ui-accordion-header-collapsed"), this._addClass(this.active.next(), "ui-accordion-content-active"), this.active.next().show(), this.headers.attr("role", "tab").each(function() {
        var header = $2(this), headerId = header.uniqueId().attr("id"), panel = header.next(), panelId = panel.uniqueId().attr("id");
        header.attr("aria-controls", panelId), panel.attr("aria-labelledby", headerId);
      }).next().attr("role", "tabpanel"), this.headers.not(this.active).attr({
        "aria-selected": "false",
        "aria-expanded": "false",
        tabIndex: -1
      }).next().attr({
        "aria-hidden": "true"
      }).hide(), this.active.length ? this.active.attr({
        "aria-selected": "true",
        "aria-expanded": "true",
        tabIndex: 0
      }).next().attr({
        "aria-hidden": "false"
      }) : this.headers.eq(0).attr("tabIndex", 0), this._createIcons(), this._setupEvents(options2.event), heightStyle === "fill" ? (maxHeight = parent.height(), this.element.siblings(":visible").each(function() {
        var elem = $2(this), position3 = elem.css("position");
        position3 === "absolute" || position3 === "fixed" || (maxHeight -= elem.outerHeight(!0));
      }), this.headers.each(function() {
        maxHeight -= $2(this).outerHeight(!0);
      }), this.headers.next().each(function() {
        $2(this).height(Math.max(0, maxHeight - $2(this).innerHeight() + $2(this).height()));
      }).css("overflow", "auto")) : heightStyle === "auto" && (maxHeight = 0, this.headers.next().each(function() {
        var isVisible3 = $2(this).is(":visible");
        isVisible3 || $2(this).show(), maxHeight = Math.max(maxHeight, $2(this).css("height", "").height()), isVisible3 || $2(this).hide();
      }).height(maxHeight));
    }, "_refresh"),
    _activate: /* @__PURE__ */ __name(function(index3) {
      var active = this._findActive(index3)[0];
      active !== this.active[0] && (active = active || this.active[0], this._eventHandler({
        target: active,
        currentTarget: active,
        preventDefault: $2.noop
      }));
    }, "_activate"),
    _findActive: /* @__PURE__ */ __name(function(selector) {
      return typeof selector == "number" ? this.headers.eq(selector) : $2();
    }, "_findActive"),
    _setupEvents: /* @__PURE__ */ __name(function(event2) {
      var events2 = {
        keydown: "_keydown"
      };
      event2 && $2.each(event2.split(" "), function(index3, eventName) {
        events2[eventName] = "_eventHandler";
      }), this._off(this.headers.add(this.headers.next())), this._on(this.headers, events2), this._on(this.headers.next(), { keydown: "_panelKeyDown" }), this._hoverable(this.headers), this._focusable(this.headers);
    }, "_setupEvents"),
    _eventHandler: /* @__PURE__ */ __name(function(event2) {
      var activeChildren, clickedChildren, options2 = this.options, active = this.active, clicked = $2(event2.currentTarget), clickedIsActive = clicked[0] === active[0], collapsing = clickedIsActive && options2.collapsible, toShow = collapsing ? $2() : clicked.next(), toHide = active.next(), eventData = {
        oldHeader: active,
        oldPanel: toHide,
        newHeader: collapsing ? $2() : clicked,
        newPanel: toShow
      };
      event2.preventDefault(), // click on active header, but not collapsible
      !(clickedIsActive && !options2.collapsible || // allow canceling activation
      this._trigger("beforeActivate", event2, eventData) === !1) && (options2.active = collapsing ? !1 : this.headers.index(clicked), this.active = clickedIsActive ? $2() : clicked, this._toggle(eventData), this._removeClass(active, "ui-accordion-header-active", "ui-state-active"), options2.icons && (activeChildren = active.children(".ui-accordion-header-icon"), this._removeClass(activeChildren, null, options2.icons.activeHeader)._addClass(activeChildren, null, options2.icons.header)), clickedIsActive || (this._removeClass(clicked, "ui-accordion-header-collapsed")._addClass(clicked, "ui-accordion-header-active", "ui-state-active"), options2.icons && (clickedChildren = clicked.children(".ui-accordion-header-icon"), this._removeClass(clickedChildren, null, options2.icons.header)._addClass(clickedChildren, null, options2.icons.activeHeader)), this._addClass(clicked.next(), "ui-accordion-content-active")));
    }, "_eventHandler"),
    _toggle: /* @__PURE__ */ __name(function(data49) {
      var toShow = data49.newPanel, toHide = this.prevShow.length ? this.prevShow : data49.oldPanel;
      this.prevShow.add(this.prevHide).stop(!0, !0), this.prevShow = toShow, this.prevHide = toHide, this.options.animate ? this._animate(toShow, toHide, data49) : (toHide.hide(), toShow.show(), this._toggleComplete(data49)), toHide.attr({
        "aria-hidden": "true"
      }), toHide.prev().attr({
        "aria-selected": "false",
        "aria-expanded": "false"
      }), toShow.length && toHide.length ? toHide.prev().attr({
        tabIndex: -1,
        "aria-expanded": "false"
      }) : toShow.length && this.headers.filter(function() {
        return parseInt($2(this).attr("tabIndex"), 10) === 0;
      }).attr("tabIndex", -1), toShow.attr("aria-hidden", "false").prev().attr({
        "aria-selected": "true",
        "aria-expanded": "true",
        tabIndex: 0
      });
    }, "_toggle"),
    _animate: /* @__PURE__ */ __name(function(toShow, toHide, data49) {
      var total, easing, duration, that = this, adjust = 0, boxSizing = toShow.css("box-sizing"), down = toShow.length && (!toHide.length || toShow.index() < toHide.index()), animate = this.options.animate || {}, options2 = down && animate.down || animate, complete = /* @__PURE__ */ __name(function() {
        that._toggleComplete(data49);
      }, "complete");
      if (typeof options2 == "number" && (duration = options2), typeof options2 == "string" && (easing = options2), easing = easing || options2.easing || animate.easing, duration = duration || options2.duration || animate.duration, !toHide.length)
        return toShow.animate(this.showProps, duration, easing, complete);
      if (!toShow.length)
        return toHide.animate(this.hideProps, duration, easing, complete);
      total = toShow.show().outerHeight(), toHide.animate(this.hideProps, {
        duration,
        easing,
        step: /* @__PURE__ */ __name(function(now, fx) {
          fx.now = Math.round(now);
        }, "step")
      }), toShow.hide().animate(this.showProps, {
        duration,
        easing,
        complete,
        step: /* @__PURE__ */ __name(function(now, fx) {
          fx.now = Math.round(now), fx.prop !== "height" ? boxSizing === "content-box" && (adjust += fx.now) : that.options.heightStyle !== "content" && (fx.now = Math.round(total - toHide.outerHeight() - adjust), adjust = 0);
        }, "step")
      });
    }, "_animate"),
    _toggleComplete: /* @__PURE__ */ __name(function(data49) {
      var toHide = data49.oldPanel, prev2 = toHide.prev();
      this._removeClass(toHide, "ui-accordion-content-active"), this._removeClass(prev2, "ui-accordion-header-active")._addClass(prev2, "ui-accordion-header-collapsed"), this._trigger("activate", null, data49);
    }, "_toggleComplete")
  });
  /*!
   * jQuery UI Menu 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.menu", {
    version: "1.14.1",
    defaultElement: "<ul>",
    delay: 300,
    options: {
      icons: {
        submenu: "ui-icon-caret-1-e"
      },
      items: "> *",
      menus: "ul",
      position: {
        my: "left top",
        at: "right top"
      },
      role: "menu",
      // Callbacks
      blur: null,
      focus: null,
      select: null
    },
    _create: /* @__PURE__ */ __name(function() {
      this.activeMenu = this.element, this.mouseHandled = !1, this.lastMousePosition = { x: null, y: null }, this.element.uniqueId().attr({
        role: this.options.role,
        tabIndex: 0
      }), this._addClass("ui-menu", "ui-widget ui-widget-content"), this._on({
        // Prevent focus from sticking to links inside menu after clicking
        // them (focus should always stay on UL during navigation).
        "mousedown .ui-menu-item": /* @__PURE__ */ __name(function(event2) {
          event2.preventDefault(), this._activateItem(event2);
        }, "mousedown .ui-menu-item"),
        "click .ui-menu-item": /* @__PURE__ */ __name(function(event2) {
          var target2 = $2(event2.target), active = $2(this.document[0].activeElement);
          !this.mouseHandled && target2.not(".ui-state-disabled").length && (this.select(event2), event2.isPropagationStopped() || (this.mouseHandled = !0), target2.has(".ui-menu").length ? this.expand(event2) : !this.element.is(":focus") && active.closest(".ui-menu").length && (this.element.trigger("focus", [!0]), this.active && this.active.parents(".ui-menu").length === 1 && clearTimeout(this.timer)));
        }, "click .ui-menu-item"),
        "mouseenter .ui-menu-item": "_activateItem",
        "mousemove .ui-menu-item": "_activateItem",
        mouseleave: "collapseAll",
        "mouseleave .ui-menu": "collapseAll",
        focus: /* @__PURE__ */ __name(function(event2, keepActiveItem) {
          var item = this.active || this._menuItems().first();
          keepActiveItem || this.focus(event2, item);
        }, "focus"),
        blur: /* @__PURE__ */ __name(function(event2) {
          this._delay(function() {
            var notContained = !$2.contains(
              this.element[0],
              this.document[0].activeElement
            );
            notContained && this.collapseAll(event2);
          });
        }, "blur"),
        keydown: "_keydown"
      }), this.refresh(), this._on(this.document, {
        click: /* @__PURE__ */ __name(function(event2) {
          this._closeOnDocumentClick(event2) && this.collapseAll(event2, !0), this.mouseHandled = !1;
        }, "click")
      });
    }, "_create"),
    _activateItem: /* @__PURE__ */ __name(function(event2) {
      if (!this.previousFilter && !(event2.clientX === this.lastMousePosition.x && event2.clientY === this.lastMousePosition.y)) {
        this.lastMousePosition = {
          x: event2.clientX,
          y: event2.clientY
        };
        var actualTarget = $2(event2.target).closest(".ui-menu-item"), target2 = $2(event2.currentTarget);
        actualTarget[0] === target2[0] && (target2.is(".ui-state-active") || (this._removeClass(
          target2.siblings().children(".ui-state-active"),
          null,
          "ui-state-active"
        ), this.focus(event2, target2)));
      }
    }, "_activateItem"),
    _destroy: /* @__PURE__ */ __name(function() {
      var items3 = this.element.find(".ui-menu-item").removeAttr("role aria-disabled"), submenus = items3.children(".ui-menu-item-wrapper").removeUniqueId().removeAttr("tabIndex role aria-haspopup");
      this.element.removeAttr("aria-activedescendant").find(".ui-menu").addBack().removeAttr("role aria-labelledby aria-expanded aria-hidden aria-disabled tabIndex").removeUniqueId().show(), submenus.children().each(function() {
        var elem = $2(this);
        elem.data("ui-menu-submenu-caret") && elem.remove();
      });
    }, "_destroy"),
    _keydown: /* @__PURE__ */ __name(function(event2) {
      var match3, prev2, character, skip, preventDefault = !0;
      switch (event2.keyCode) {
        case $2.ui.keyCode.PAGE_UP:
          this.previousPage(event2);
          break;
        case $2.ui.keyCode.PAGE_DOWN:
          this.nextPage(event2);
          break;
        case $2.ui.keyCode.HOME:
          this._move("first", "first", event2);
          break;
        case $2.ui.keyCode.END:
          this._move("last", "last", event2);
          break;
        case $2.ui.keyCode.UP:
          this.previous(event2);
          break;
        case $2.ui.keyCode.DOWN:
          this.next(event2);
          break;
        case $2.ui.keyCode.LEFT:
          this.collapse(event2);
          break;
        case $2.ui.keyCode.RIGHT:
          this.active && !this.active.is(".ui-state-disabled") && this.expand(event2);
          break;
        case $2.ui.keyCode.ENTER:
        case $2.ui.keyCode.SPACE:
          this._activate(event2);
          break;
        case $2.ui.keyCode.ESCAPE:
          this.collapse(event2);
          break;
        default:
          preventDefault = !1, prev2 = this.previousFilter || "", skip = !1, character = event2.keyCode >= 96 && event2.keyCode <= 105 ? (event2.keyCode - 96).toString() : String.fromCharCode(event2.keyCode), clearTimeout(this.filterTimer), character === prev2 ? skip = !0 : character = prev2 + character, match3 = this._filterMenuItems(character), match3 = skip && match3.index(this.active.next()) !== -1 ? this.active.nextAll(".ui-menu-item") : match3, match3.length || (character = String.fromCharCode(event2.keyCode), match3 = this._filterMenuItems(character)), match3.length ? (this.focus(event2, match3), this.previousFilter = character, this.filterTimer = this._delay(function() {
            delete this.previousFilter;
          }, 1e3)) : delete this.previousFilter;
      }
      preventDefault && event2.preventDefault();
    }, "_keydown"),
    _activate: /* @__PURE__ */ __name(function(event2) {
      this.active && !this.active.is(".ui-state-disabled") && (this.active.children("[aria-haspopup='true']").length ? this.expand(event2) : this.select(event2));
    }, "_activate"),
    refresh: /* @__PURE__ */ __name(function() {
      var menus, items3, newSubmenus, newItems, newWrappers, that = this, icon = this.options.icons.submenu, submenus = this.element.find(this.options.menus);
      this._toggleClass("ui-menu-icons", null, !!this.element.find(".ui-icon").length), newSubmenus = submenus.filter(":not(.ui-menu)").hide().attr({
        role: this.options.role,
        "aria-hidden": "true",
        "aria-expanded": "false"
      }).each(function() {
        var menu = $2(this), item = menu.prev(), submenuCaret = $2("<span>").data("ui-menu-submenu-caret", !0);
        that._addClass(submenuCaret, "ui-menu-icon", "ui-icon " + icon), item.attr("aria-haspopup", "true").prepend(submenuCaret), menu.attr("aria-labelledby", item.attr("id"));
      }), this._addClass(newSubmenus, "ui-menu", "ui-widget ui-widget-content ui-front"), menus = submenus.add(this.element), items3 = menus.find(this.options.items), items3.not(".ui-menu-item").each(function() {
        var item = $2(this);
        that._isDivider(item) && that._addClass(item, "ui-menu-divider", "ui-widget-content");
      }), newItems = items3.not(".ui-menu-item, .ui-menu-divider"), newWrappers = newItems.children().not(".ui-menu").uniqueId().attr({
        tabIndex: -1,
        role: this._itemRole()
      }), this._addClass(newItems, "ui-menu-item")._addClass(newWrappers, "ui-menu-item-wrapper"), items3.filter(".ui-state-disabled").attr("aria-disabled", "true"), this.active && !$2.contains(this.element[0], this.active[0]) && this.blur();
    }, "refresh"),
    _itemRole: /* @__PURE__ */ __name(function() {
      return {
        menu: "menuitem",
        listbox: "option"
      }[this.options.role];
    }, "_itemRole"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      if (key === "icons") {
        var icons2 = this.element.find(".ui-menu-icon");
        this._removeClass(icons2, null, this.options.icons.submenu)._addClass(icons2, null, value3.submenu);
      }
      this._super(key, value3);
    }, "_setOption"),
    _setOptionDisabled: /* @__PURE__ */ __name(function(value3) {
      this._super(value3), this.element.attr("aria-disabled", String(value3)), this._toggleClass(null, "ui-state-disabled", !!value3);
    }, "_setOptionDisabled"),
    focus: /* @__PURE__ */ __name(function(event2, item) {
      var nested, focused, activeParent;
      this.blur(event2, event2 && event2.type === "focus"), this._scrollIntoView(item), this.active = item.first(), focused = this.active.children(".ui-menu-item-wrapper"), this._addClass(focused, null, "ui-state-active"), this.options.role && this.element.attr("aria-activedescendant", focused.attr("id")), activeParent = this.active.parent().closest(".ui-menu-item").children(".ui-menu-item-wrapper"), this._addClass(activeParent, null, "ui-state-active"), event2 && event2.type === "keydown" ? this._close() : this.timer = this._delay(function() {
        this._close();
      }, this.delay), nested = item.children(".ui-menu"), nested.length && event2 && /^mouse/.test(event2.type) && this._startOpening(nested), this.activeMenu = item.parent(), this._trigger("focus", event2, { item });
    }, "focus"),
    _scrollIntoView: /* @__PURE__ */ __name(function(item) {
      var borderTop, paddingTop, offset3, scroll, elementHeight, itemHeight;
      this._hasScroll() && (borderTop = parseFloat($2.css(this.activeMenu[0], "borderTopWidth")) || 0, paddingTop = parseFloat($2.css(this.activeMenu[0], "paddingTop")) || 0, offset3 = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop, scroll = this.activeMenu.scrollTop(), elementHeight = this.activeMenu.height(), itemHeight = item.outerHeight(), offset3 < 0 ? this.activeMenu.scrollTop(scroll + offset3) : offset3 + itemHeight > elementHeight && this.activeMenu.scrollTop(scroll + offset3 - elementHeight + itemHeight));
    }, "_scrollIntoView"),
    blur: /* @__PURE__ */ __name(function(event2, fromFocus) {
      fromFocus || clearTimeout(this.timer), this.active && (this._removeClass(
        this.active.children(".ui-menu-item-wrapper"),
        null,
        "ui-state-active"
      ), this._trigger("blur", event2, { item: this.active }), this.active = null);
    }, "blur"),
    _startOpening: /* @__PURE__ */ __name(function(submenu) {
      clearTimeout(this.timer), submenu.attr("aria-hidden") === "true" && (this.timer = this._delay(function() {
        this._close(), this._open(submenu);
      }, this.delay));
    }, "_startOpening"),
    _open: /* @__PURE__ */ __name(function(submenu) {
      var position3 = $2.extend({
        of: this.active
      }, this.options.position);
      clearTimeout(this.timer), this.element.find(".ui-menu").not(submenu.parents(".ui-menu")).hide().attr("aria-hidden", "true"), submenu.show().removeAttr("aria-hidden").attr("aria-expanded", "true").position(position3);
    }, "_open"),
    collapseAll: /* @__PURE__ */ __name(function(event2, all2) {
      clearTimeout(this.timer), this.timer = this._delay(function() {
        var currentMenu = all2 ? this.element : $2(event2 && event2.target).closest(this.element.find(".ui-menu"));
        currentMenu.length || (currentMenu = this.element), this._close(currentMenu), this.blur(event2), this._removeClass(currentMenu.find(".ui-state-active"), null, "ui-state-active"), this.activeMenu = currentMenu;
      }, all2 ? 0 : this.delay);
    }, "collapseAll"),
    // With no arguments, closes the currently active menu - if nothing is active
    // it closes all menus.  If passed an argument, it will search for menus BELOW
    _close: /* @__PURE__ */ __name(function(startMenu) {
      startMenu || (startMenu = this.active ? this.active.parent() : this.element), startMenu.find(".ui-menu").hide().attr("aria-hidden", "true").attr("aria-expanded", "false");
    }, "_close"),
    _closeOnDocumentClick: /* @__PURE__ */ __name(function(event2) {
      return !$2(event2.target).closest(".ui-menu").length;
    }, "_closeOnDocumentClick"),
    _isDivider: /* @__PURE__ */ __name(function(item) {
      return !/[^\-\u2014\u2013\s]/.test(item.text());
    }, "_isDivider"),
    collapse: /* @__PURE__ */ __name(function(event2) {
      var newItem = this.active && this.active.parent().closest(".ui-menu-item", this.element);
      newItem && newItem.length && (this._close(), this.focus(event2, newItem));
    }, "collapse"),
    expand: /* @__PURE__ */ __name(function(event2) {
      var newItem = this.active && this._menuItems(this.active.children(".ui-menu")).first();
      newItem && newItem.length && (this._open(newItem.parent()), this._delay(function() {
        this.focus(event2, newItem);
      }));
    }, "expand"),
    next: /* @__PURE__ */ __name(function(event2) {
      this._move("next", "first", event2);
    }, "next"),
    previous: /* @__PURE__ */ __name(function(event2) {
      this._move("prev", "last", event2);
    }, "previous"),
    isFirstItem: /* @__PURE__ */ __name(function() {
      return this.active && !this.active.prevAll(".ui-menu-item").length;
    }, "isFirstItem"),
    isLastItem: /* @__PURE__ */ __name(function() {
      return this.active && !this.active.nextAll(".ui-menu-item").length;
    }, "isLastItem"),
    _menuItems: /* @__PURE__ */ __name(function(menu) {
      return (menu || this.element).find(this.options.items).filter(".ui-menu-item");
    }, "_menuItems"),
    _move: /* @__PURE__ */ __name(function(direction, filter2, event2) {
      var next3;
      this.active && (direction === "first" || direction === "last" ? next3 = this.active[direction === "first" ? "prevAll" : "nextAll"](".ui-menu-item").last() : next3 = this.active[direction + "All"](".ui-menu-item").first()), (!next3 || !next3.length || !this.active) && (next3 = this._menuItems(this.activeMenu)[filter2]()), this.focus(event2, next3);
    }, "_move"),
    nextPage: /* @__PURE__ */ __name(function(event2) {
      var item, base, height;
      if (!this.active) {
        this.next(event2);
        return;
      }
      this.isLastItem() || (this._hasScroll() ? (base = this.active.offset().top, height = this.element.innerHeight(), $2.fn.jquery.indexOf("3.2.") === 0 && (height += this.element[0].offsetHeight - this.element.outerHeight()), this.active.nextAll(".ui-menu-item").each(function() {
        return item = $2(this), item.offset().top - base - height < 0;
      }), this.focus(event2, item)) : this.focus(event2, this._menuItems(this.activeMenu)[this.active ? "last" : "first"]()));
    }, "nextPage"),
    previousPage: /* @__PURE__ */ __name(function(event2) {
      var item, base, height;
      if (!this.active) {
        this.next(event2);
        return;
      }
      this.isFirstItem() || (this._hasScroll() ? (base = this.active.offset().top, height = this.element.innerHeight(), $2.fn.jquery.indexOf("3.2.") === 0 && (height += this.element[0].offsetHeight - this.element.outerHeight()), this.active.prevAll(".ui-menu-item").each(function() {
        return item = $2(this), item.offset().top - base + height > 0;
      }), this.focus(event2, item)) : this.focus(event2, this._menuItems(this.activeMenu).first()));
    }, "previousPage"),
    _hasScroll: /* @__PURE__ */ __name(function() {
      return this.element.outerHeight() < this.element.prop("scrollHeight");
    }, "_hasScroll"),
    select: /* @__PURE__ */ __name(function(event2) {
      this.active = this.active || $2(event2.target).closest(".ui-menu-item");
      var ui = { item: this.active };
      this.active.has(".ui-menu").length || this.collapseAll(event2, !0), this._trigger("select", event2, ui);
    }, "select"),
    _filterMenuItems: /* @__PURE__ */ __name(function(character) {
      var escapedCharacter = character.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&"), regex2 = new RegExp("^" + escapedCharacter, "i");
      return this.activeMenu.find(this.options.items).filter(".ui-menu-item").filter(function() {
        return regex2.test(
          String.prototype.trim.call(
            $2(this).children(".ui-menu-item-wrapper").text()
          )
        );
      });
    }, "_filterMenuItems")
  });
  /*!
   * jQuery UI Autocomplete 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.autocomplete", {
    version: "1.14.1",
    defaultElement: "<input>",
    options: {
      appendTo: null,
      autoFocus: !1,
      delay: 300,
      minLength: 1,
      position: {
        my: "left top",
        at: "left bottom",
        collision: "none"
      },
      source: null,
      // Callbacks
      change: null,
      close: null,
      focus: null,
      open: null,
      response: null,
      search: null,
      select: null
    },
    requestIndex: 0,
    pending: 0,
    liveRegionTimer: null,
    _create: /* @__PURE__ */ __name(function() {
      var suppressKeyPress, suppressKeyPressRepeat, suppressInput, nodeName = this.element[0].nodeName.toLowerCase(), isTextarea = nodeName === "textarea", isInput = nodeName === "input";
      this.isMultiLine = isTextarea || !isInput && this.element.prop("contentEditable") === "true", this.valueMethod = this.element[isTextarea || isInput ? "val" : "text"], this.isNewMenu = !0, this._addClass("ui-autocomplete-input"), this.element.attr("autocomplete", "off"), this._on(this.element, {
        keydown: /* @__PURE__ */ __name(function(event2) {
          if (this.element.prop("readOnly")) {
            suppressKeyPress = !0, suppressInput = !0, suppressKeyPressRepeat = !0;
            return;
          }
          suppressKeyPress = !1, suppressInput = !1, suppressKeyPressRepeat = !1;
          var keyCode = $2.ui.keyCode;
          switch (event2.keyCode) {
            case keyCode.PAGE_UP:
              suppressKeyPress = !0, this._move("previousPage", event2);
              break;
            case keyCode.PAGE_DOWN:
              suppressKeyPress = !0, this._move("nextPage", event2);
              break;
            case keyCode.UP:
              suppressKeyPress = !0, this._keyEvent("previous", event2);
              break;
            case keyCode.DOWN:
              suppressKeyPress = !0, this._keyEvent("next", event2);
              break;
            case keyCode.ENTER:
              this.menu.active && (suppressKeyPress = !0, event2.preventDefault(), this.menu.select(event2));
              break;
            case keyCode.TAB:
              this.menu.active && this.menu.select(event2);
              break;
            case keyCode.ESCAPE:
              this.menu.element.is(":visible") && (this.isMultiLine || this._value(this.term), this.close(event2), event2.preventDefault());
              break;
            default:
              suppressKeyPressRepeat = !0, this._searchTimeout(event2);
              break;
          }
        }, "keydown"),
        keypress: /* @__PURE__ */ __name(function(event2) {
          if (suppressKeyPress) {
            suppressKeyPress = !1, (!this.isMultiLine || this.menu.element.is(":visible")) && event2.preventDefault();
            return;
          }
          if (!suppressKeyPressRepeat) {
            var keyCode = $2.ui.keyCode;
            switch (event2.keyCode) {
              case keyCode.PAGE_UP:
                this._move("previousPage", event2);
                break;
              case keyCode.PAGE_DOWN:
                this._move("nextPage", event2);
                break;
              case keyCode.UP:
                this._keyEvent("previous", event2);
                break;
              case keyCode.DOWN:
                this._keyEvent("next", event2);
                break;
            }
          }
        }, "keypress"),
        input: /* @__PURE__ */ __name(function(event2) {
          if (suppressInput) {
            suppressInput = !1, event2.preventDefault();
            return;
          }
          this._searchTimeout(event2);
        }, "input"),
        focus: /* @__PURE__ */ __name(function() {
          this.selectedItem = null, this.previous = this._value();
        }, "focus"),
        blur: /* @__PURE__ */ __name(function(event2) {
          clearTimeout(this.searching), this.close(event2), this._change(event2);
        }, "blur")
      }), this._initSource(), this.menu = $2("<ul>").appendTo(this._appendTo()).menu({
        // disable ARIA support, the live region takes care of that
        role: null
      }).hide().menu("instance"), this._addClass(this.menu.element, "ui-autocomplete", "ui-front"), this._on(this.menu.element, {
        mousedown: /* @__PURE__ */ __name(function(event2) {
          event2.preventDefault();
        }, "mousedown"),
        menufocus: /* @__PURE__ */ __name(function(event2, ui) {
          var label, item;
          if (this.isNewMenu && (this.isNewMenu = !1, event2.originalEvent && /^mouse/.test(event2.originalEvent.type))) {
            this.menu.blur(), this.document.one("mousemove", function() {
              $2(event2.target).trigger(event2.originalEvent);
            });
            return;
          }
          item = ui.item.data("ui-autocomplete-item"), this._trigger("focus", event2, { item }) !== !1 && event2.originalEvent && /^key/.test(event2.originalEvent.type) && this._value(item.value), label = ui.item.attr("aria-label") || item.value, label && String.prototype.trim.call(label).length && (clearTimeout(this.liveRegionTimer), this.liveRegionTimer = this._delay(function() {
            this.liveRegion.html($2("<div>").text(label));
          }, 100));
        }, "menufocus"),
        menuselect: /* @__PURE__ */ __name(function(event2, ui) {
          var item = ui.item.data("ui-autocomplete-item"), previous = this.previous;
          this.element[0] !== this.document[0].activeElement && (this.element.trigger("focus"), this.previous = previous), this._trigger("select", event2, { item }) !== !1 && this._value(item.value), this.term = this._value(), this.close(event2), this.selectedItem = item;
        }, "menuselect")
      }), this.liveRegion = $2("<div>", {
        role: "status",
        "aria-live": "assertive",
        "aria-relevant": "additions"
      }).appendTo(this.document[0].body), this._addClass(this.liveRegion, null, "ui-helper-hidden-accessible"), this._on(this.window, {
        beforeunload: /* @__PURE__ */ __name(function() {
          this.element.removeAttr("autocomplete");
        }, "beforeunload")
      });
    }, "_create"),
    _destroy: /* @__PURE__ */ __name(function() {
      clearTimeout(this.searching), this.element.removeAttr("autocomplete"), this.menu.element.remove(), this.liveRegion.remove();
    }, "_destroy"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      this._super(key, value3), key === "source" && this._initSource(), key === "appendTo" && this.menu.element.appendTo(this._appendTo()), key === "disabled" && value3 && this.xhr && this.xhr.abort();
    }, "_setOption"),
    _isEventTargetInWidget: /* @__PURE__ */ __name(function(event2) {
      var menuElement = this.menu.element[0];
      return event2.target === this.element[0] || event2.target === menuElement || $2.contains(menuElement, event2.target);
    }, "_isEventTargetInWidget"),
    _closeOnClickOutside: /* @__PURE__ */ __name(function(event2) {
      this._isEventTargetInWidget(event2) || this.close();
    }, "_closeOnClickOutside"),
    _appendTo: /* @__PURE__ */ __name(function() {
      var element = this.options.appendTo;
      return element && (element = element.jquery || element.nodeType ? $2(element) : this.document.find(element).eq(0)), (!element || !element[0]) && (element = this.element.closest(".ui-front, dialog")), element.length || (element = this.document[0].body), element;
    }, "_appendTo"),
    _initSource: /* @__PURE__ */ __name(function() {
      var array, url2, that = this;
      Array.isArray(this.options.source) ? (array = this.options.source, this.source = function(request, response) {
        response($2.ui.autocomplete.filter(array, request.term));
      }) : typeof this.options.source == "string" ? (url2 = this.options.source, this.source = function(request, response) {
        that.xhr && that.xhr.abort(), that.xhr = $2.ajax({
          url: url2,
          data: request,
          dataType: "json",
          success: /* @__PURE__ */ __name(function(data49) {
            response(data49);
          }, "success"),
          error: /* @__PURE__ */ __name(function() {
            response([]);
          }, "error")
        });
      }) : this.source = this.options.source;
    }, "_initSource"),
    _searchTimeout: /* @__PURE__ */ __name(function(event2) {
      clearTimeout(this.searching), this.searching = this._delay(function() {
        var equalValues = this.term === this._value(), menuVisible = this.menu.element.is(":visible"), modifierKey = event2.altKey || event2.ctrlKey || event2.metaKey || event2.shiftKey;
        (!equalValues || equalValues && !menuVisible && !modifierKey) && (this.selectedItem = null, this.search(null, event2));
      }, this.options.delay);
    }, "_searchTimeout"),
    search: /* @__PURE__ */ __name(function(value3, event2) {
      if (value3 = value3 ?? this._value(), this.term = this._value(), value3.length < this.options.minLength)
        return this.close(event2);
      if (this._trigger("search", event2) !== !1)
        return this._search(value3);
    }, "search"),
    _search: /* @__PURE__ */ __name(function(value3) {
      this.pending++, this._addClass("ui-autocomplete-loading"), this.cancelSearch = !1, this.source({ term: value3 }, this._response());
    }, "_search"),
    _response: /* @__PURE__ */ __name(function() {
      var index3 = ++this.requestIndex;
      return (function(content) {
        index3 === this.requestIndex && this.__response(content), this.pending--, this.pending || this._removeClass("ui-autocomplete-loading");
      }).bind(this);
    }, "_response"),
    __response: /* @__PURE__ */ __name(function(content) {
      content && (content = this._normalize(content)), this._trigger("response", null, { content }), !this.options.disabled && content && content.length && !this.cancelSearch ? (this._suggest(content), this._trigger("open")) : this._close();
    }, "__response"),
    close: /* @__PURE__ */ __name(function(event2) {
      this.cancelSearch = !0, this._close(event2);
    }, "close"),
    _close: /* @__PURE__ */ __name(function(event2) {
      this._off(this.document, "mousedown"), this.menu.element.is(":visible") && (this.menu.element.hide(), this.menu.blur(), this.isNewMenu = !0, this._trigger("close", event2));
    }, "_close"),
    _change: /* @__PURE__ */ __name(function(event2) {
      this.previous !== this._value() && this._trigger("change", event2, { item: this.selectedItem });
    }, "_change"),
    _normalize: /* @__PURE__ */ __name(function(items3) {
      return items3.length && items3[0].label && items3[0].value ? items3 : $2.map(items3, function(item) {
        return typeof item == "string" ? {
          label: item,
          value: item
        } : $2.extend({}, item, {
          label: item.label || item.value,
          value: item.value || item.label
        });
      });
    }, "_normalize"),
    _suggest: /* @__PURE__ */ __name(function(items3) {
      var ul = this.menu.element.empty();
      this._renderMenu(ul, items3), this.isNewMenu = !0, this.menu.refresh(), ul.show(), this._resizeMenu(), ul.position($2.extend({
        of: this.element
      }, this.options.position)), this.options.autoFocus && this.menu.next(), this._on(this.document, {
        mousedown: "_closeOnClickOutside"
      });
    }, "_suggest"),
    _resizeMenu: /* @__PURE__ */ __name(function() {
      var ul = this.menu.element;
      ul.outerWidth(Math.max(
        // Firefox wraps long text (possibly a rounding bug)
        // so we add 1px to avoid the wrapping (#7513)
        ul.width("").outerWidth() + 1,
        this.element.outerWidth()
      ));
    }, "_resizeMenu"),
    _renderMenu: /* @__PURE__ */ __name(function(ul, items3) {
      var that = this;
      $2.each(items3, function(index3, item) {
        that._renderItemData(ul, item);
      });
    }, "_renderMenu"),
    _renderItemData: /* @__PURE__ */ __name(function(ul, item) {
      return this._renderItem(ul, item).data("ui-autocomplete-item", item);
    }, "_renderItemData"),
    _renderItem: /* @__PURE__ */ __name(function(ul, item) {
      return $2("<li>").append($2("<div>").text(item.label)).appendTo(ul);
    }, "_renderItem"),
    _move: /* @__PURE__ */ __name(function(direction, event2) {
      if (!this.menu.element.is(":visible")) {
        this.search(null, event2);
        return;
      }
      if (this.menu.isFirstItem() && /^previous/.test(direction) || this.menu.isLastItem() && /^next/.test(direction)) {
        this.isMultiLine || this._value(this.term), this.menu.blur();
        return;
      }
      this.menu[direction](event2);
    }, "_move"),
    widget: /* @__PURE__ */ __name(function() {
      return this.menu.element;
    }, "widget"),
    _value: /* @__PURE__ */ __name(function() {
      return this.valueMethod.apply(this.element, arguments);
    }, "_value"),
    _keyEvent: /* @__PURE__ */ __name(function(keyEvent, event2) {
      (!this.isMultiLine || this.menu.element.is(":visible")) && (this._move(keyEvent, event2), event2.preventDefault());
    }, "_keyEvent")
  }), $2.extend($2.ui.autocomplete, {
    escapeRegex: /* @__PURE__ */ __name(function(value3) {
      return value3.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&");
    }, "escapeRegex"),
    filter: /* @__PURE__ */ __name(function(array, term) {
      var matcher = new RegExp($2.ui.autocomplete.escapeRegex(term), "i");
      return $2.grep(array, function(value3) {
        return matcher.test(value3.label || value3.value || value3);
      });
    }, "filter")
  }), $2.widget("ui.autocomplete", $2.ui.autocomplete, {
    options: {
      messages: {
        noResults: "No search results.",
        results: /* @__PURE__ */ __name(function(amount) {
          return amount + (amount > 1 ? " results are" : " result is") + " available, use up and down arrow keys to navigate.";
        }, "results")
      }
    },
    __response: /* @__PURE__ */ __name(function(content) {
      var message;
      this._superApply(arguments), !(this.options.disabled || this.cancelSearch) && (content && content.length ? message = this.options.messages.results(content.length) : message = this.options.messages.noResults, clearTimeout(this.liveRegionTimer), this.liveRegionTimer = this._delay(function() {
        this.liveRegion.html($2("<div>").text(message));
      }, 100));
    }, "__response")
  }), $2.ui.autocomplete;
  /*!
   * jQuery UI Controlgroup 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  var controlgroupCornerRegex = /ui-corner-([a-z]){2,6}/g;
  $2.widget("ui.controlgroup", {
    version: "1.14.1",
    defaultElement: "<div>",
    options: {
      direction: "horizontal",
      disabled: null,
      onlyVisible: !0,
      items: {
        button: "input[type=button], input[type=submit], input[type=reset], button, a",
        controlgroupLabel: ".ui-controlgroup-label",
        checkboxradio: "input[type='checkbox'], input[type='radio']",
        selectmenu: "select",
        spinner: ".ui-spinner-input"
      }
    },
    _create: /* @__PURE__ */ __name(function() {
      this._enhance();
    }, "_create"),
    // To support the enhanced option in jQuery Mobile, we isolate DOM manipulation
    _enhance: /* @__PURE__ */ __name(function() {
      this.element.attr("role", "toolbar"), this.refresh();
    }, "_enhance"),
    _destroy: /* @__PURE__ */ __name(function() {
      this._callChildMethod("destroy"), this.childWidgets.removeData("ui-controlgroup-data"), this.element.removeAttr("role"), this.options.items.controlgroupLabel && this.element.find(this.options.items.controlgroupLabel).find(".ui-controlgroup-label-contents").contents().unwrap();
    }, "_destroy"),
    _initWidgets: /* @__PURE__ */ __name(function() {
      var that = this, childWidgets = [];
      $2.each(this.options.items, function(widget, selector) {
        var labels, options2 = {};
        if (selector) {
          if (widget === "controlgroupLabel") {
            labels = that.element.find(selector), labels.each(function() {
              var element = $2(this);
              element.children(".ui-controlgroup-label-contents").length || element.contents().wrapAll("<span class='ui-controlgroup-label-contents'></span>");
            }), that._addClass(labels, null, "ui-widget ui-widget-content ui-state-default"), childWidgets = childWidgets.concat(labels.get());
            return;
          }
          $2.fn[widget] && (that["_" + widget + "Options"] ? options2 = that["_" + widget + "Options"]("middle") : options2 = { classes: {} }, that.element.find(selector).each(function() {
            var element = $2(this), instance = element[widget]("instance"), instanceOptions = $2.widget.extend({}, options2);
            if (!(widget === "button" && element.parent(".ui-spinner").length)) {
              instance || (instance = element[widget]()[widget]("instance")), instance && (instanceOptions.classes = that._resolveClassesValues(instanceOptions.classes, instance)), element[widget](instanceOptions);
              var widgetElement = element[widget]("widget");
              $2.data(
                widgetElement[0],
                "ui-controlgroup-data",
                instance || element[widget]("instance")
              ), childWidgets.push(widgetElement[0]);
            }
          }));
        }
      }), this.childWidgets = $2($2.uniqueSort(childWidgets)), this._addClass(this.childWidgets, "ui-controlgroup-item");
    }, "_initWidgets"),
    _callChildMethod: /* @__PURE__ */ __name(function(method) {
      this.childWidgets.each(function() {
        var element = $2(this), data49 = element.data("ui-controlgroup-data");
        data49 && data49[method] && data49[method]();
      });
    }, "_callChildMethod"),
    _updateCornerClass: /* @__PURE__ */ __name(function(element, position3) {
      var remove8 = "ui-corner-top ui-corner-bottom ui-corner-left ui-corner-right ui-corner-all", add4 = this._buildSimpleOptions(position3, "label").classes.label;
      this._removeClass(element, null, remove8), this._addClass(element, null, add4);
    }, "_updateCornerClass"),
    _buildSimpleOptions: /* @__PURE__ */ __name(function(position3, key) {
      var direction = this.options.direction === "vertical", result = {
        classes: {}
      };
      return result.classes[key] = {
        middle: "",
        first: "ui-corner-" + (direction ? "top" : "left"),
        last: "ui-corner-" + (direction ? "bottom" : "right"),
        only: "ui-corner-all"
      }[position3], result;
    }, "_buildSimpleOptions"),
    _spinnerOptions: /* @__PURE__ */ __name(function(position3) {
      var options2 = this._buildSimpleOptions(position3, "ui-spinner");
      return options2.classes["ui-spinner-up"] = "", options2.classes["ui-spinner-down"] = "", options2;
    }, "_spinnerOptions"),
    _buttonOptions: /* @__PURE__ */ __name(function(position3) {
      return this._buildSimpleOptions(position3, "ui-button");
    }, "_buttonOptions"),
    _checkboxradioOptions: /* @__PURE__ */ __name(function(position3) {
      return this._buildSimpleOptions(position3, "ui-checkboxradio-label");
    }, "_checkboxradioOptions"),
    _selectmenuOptions: /* @__PURE__ */ __name(function(position3) {
      var direction = this.options.direction === "vertical";
      return {
        width: direction ? "auto" : !1,
        classes: {
          middle: {
            "ui-selectmenu-button-open": "",
            "ui-selectmenu-button-closed": ""
          },
          first: {
            "ui-selectmenu-button-open": "ui-corner-" + (direction ? "top" : "tl"),
            "ui-selectmenu-button-closed": "ui-corner-" + (direction ? "top" : "left")
          },
          last: {
            "ui-selectmenu-button-open": direction ? "" : "ui-corner-tr",
            "ui-selectmenu-button-closed": "ui-corner-" + (direction ? "bottom" : "right")
          },
          only: {
            "ui-selectmenu-button-open": "ui-corner-top",
            "ui-selectmenu-button-closed": "ui-corner-all"
          }
        }[position3]
      };
    }, "_selectmenuOptions"),
    _resolveClassesValues: /* @__PURE__ */ __name(function(classes2, instance) {
      var result = {};
      return $2.each(classes2, function(key) {
        var current = instance.options.classes[key] || "";
        current = String.prototype.trim.call(current.replace(controlgroupCornerRegex, "")), result[key] = (current + " " + classes2[key]).replace(/\s+/g, " ");
      }), result;
    }, "_resolveClassesValues"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      if (key === "direction" && this._removeClass("ui-controlgroup-" + this.options.direction), this._super(key, value3), key === "disabled") {
        this._callChildMethod(value3 ? "disable" : "enable");
        return;
      }
      this.refresh();
    }, "_setOption"),
    refresh: /* @__PURE__ */ __name(function() {
      var children2, that = this;
      this._addClass("ui-controlgroup ui-controlgroup-" + this.options.direction), this.options.direction === "horizontal" && this._addClass(null, "ui-helper-clearfix"), this._initWidgets(), children2 = this.childWidgets, this.options.onlyVisible && (children2 = children2.filter(":visible")), children2.length && ($2.each(["first", "last"], function(index3, value3) {
        var instance = children2[value3]().data("ui-controlgroup-data");
        if (instance && that["_" + instance.widgetName + "Options"]) {
          var options2 = that["_" + instance.widgetName + "Options"](
            children2.length === 1 ? "only" : value3
          );
          options2.classes = that._resolveClassesValues(options2.classes, instance), instance.element[instance.widgetName](options2);
        } else
          that._updateCornerClass(children2[value3](), value3);
      }), this._callChildMethod("refresh"));
    }, "refresh")
  });
  /*!
   * jQuery UI Checkboxradio 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.checkboxradio", [$2.ui.formResetMixin, {
    version: "1.14.1",
    options: {
      disabled: null,
      label: null,
      icon: !0,
      classes: {
        "ui-checkboxradio-label": "ui-corner-all",
        "ui-checkboxradio-icon": "ui-corner-all"
      }
    },
    _getCreateOptions: /* @__PURE__ */ __name(function() {
      var disabled6, labels, labelContents, options2 = this._super() || {};
      return this._readType(), labels = this.element.labels(), this.label = $2(labels[labels.length - 1]), this.label.length || $2.error("No label found for checkboxradio widget"), this.originalLabel = "", labelContents = this.label.contents().not(this.element[0]), labelContents.length && (this.originalLabel += labelContents.clone().wrapAll("<div></div>").parent().html()), this.originalLabel && (options2.label = this.originalLabel), disabled6 = this.element[0].disabled, disabled6 != null && (options2.disabled = disabled6), options2;
    }, "_getCreateOptions"),
    _create: /* @__PURE__ */ __name(function() {
      var checked = this.element[0].checked;
      this._bindFormResetHandler(), this.options.disabled == null && (this.options.disabled = this.element[0].disabled), this._setOption("disabled", this.options.disabled), this._addClass("ui-checkboxradio", "ui-helper-hidden-accessible"), this._addClass(this.label, "ui-checkboxradio-label", "ui-button ui-widget"), this.type === "radio" && this._addClass(this.label, "ui-checkboxradio-radio-label"), this.options.label && this.options.label !== this.originalLabel ? this._updateLabel() : this.originalLabel && (this.options.label = this.originalLabel), this._enhance(), checked && this._addClass(this.label, "ui-checkboxradio-checked", "ui-state-active"), this._on({
        change: "_toggleClasses",
        focus: /* @__PURE__ */ __name(function() {
          this._addClass(this.label, null, "ui-state-focus ui-visual-focus");
        }, "focus"),
        blur: /* @__PURE__ */ __name(function() {
          this._removeClass(this.label, null, "ui-state-focus ui-visual-focus");
        }, "blur")
      });
    }, "_create"),
    _readType: /* @__PURE__ */ __name(function() {
      var nodeName = this.element[0].nodeName.toLowerCase();
      this.type = this.element[0].type, (nodeName !== "input" || !/radio|checkbox/.test(this.type)) && $2.error("Can't create checkboxradio on element.nodeName=" + nodeName + " and element.type=" + this.type);
    }, "_readType"),
    // Support jQuery Mobile enhanced option
    _enhance: /* @__PURE__ */ __name(function() {
      this._updateIcon(this.element[0].checked);
    }, "_enhance"),
    widget: /* @__PURE__ */ __name(function() {
      return this.label;
    }, "widget"),
    _getRadioGroup: /* @__PURE__ */ __name(function() {
      var group, name2 = this.element[0].name, nameSelector = "input[name='" + CSS.escape(name2) + "']";
      return name2 ? (this.form.length ? group = $2(this.form[0].elements).filter(nameSelector) : group = $2(nameSelector).filter(function() {
        return $2($2(this).prop("form")).length === 0;
      }), group.not(this.element)) : $2([]);
    }, "_getRadioGroup"),
    _toggleClasses: /* @__PURE__ */ __name(function() {
      var checked = this.element[0].checked;
      this._toggleClass(this.label, "ui-checkboxradio-checked", "ui-state-active", checked), this.options.icon && this.type === "checkbox" && this._toggleClass(this.icon, null, "ui-icon-check ui-state-checked", checked)._toggleClass(this.icon, null, "ui-icon-blank", !checked), this.type === "radio" && this._getRadioGroup().each(function() {
        var instance = $2(this).checkboxradio("instance");
        instance && instance._removeClass(
          instance.label,
          "ui-checkboxradio-checked",
          "ui-state-active"
        );
      });
    }, "_toggleClasses"),
    _destroy: /* @__PURE__ */ __name(function() {
      this._unbindFormResetHandler(), this.icon && (this.icon.remove(), this.iconSpace.remove());
    }, "_destroy"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      if (!(key === "label" && !value3)) {
        if (this._super(key, value3), key === "disabled") {
          this._toggleClass(this.label, null, "ui-state-disabled", value3), this.element[0].disabled = value3;
          return;
        }
        this.refresh();
      }
    }, "_setOption"),
    _updateIcon: /* @__PURE__ */ __name(function(checked) {
      var toAdd = "ui-icon ui-icon-background ";
      this.options.icon ? (this.icon || (this.icon = $2("<span>"), this.iconSpace = $2("<span> </span>"), this._addClass(this.iconSpace, "ui-checkboxradio-icon-space")), this.type === "checkbox" ? (toAdd += checked ? "ui-icon-check ui-state-checked" : "ui-icon-blank", this._removeClass(this.icon, null, checked ? "ui-icon-blank" : "ui-icon-check")) : toAdd += "ui-icon-blank", this._addClass(this.icon, "ui-checkboxradio-icon", toAdd), checked || this._removeClass(this.icon, null, "ui-icon-check ui-state-checked"), this.icon.prependTo(this.label).after(this.iconSpace)) : this.icon !== void 0 && (this.icon.remove(), this.iconSpace.remove(), delete this.icon);
    }, "_updateIcon"),
    _updateLabel: /* @__PURE__ */ __name(function() {
      var contents = this.label.contents().not(this.element[0]);
      this.icon && (contents = contents.not(this.icon[0])), this.iconSpace && (contents = contents.not(this.iconSpace[0])), contents.remove(), this.label.append(this.options.label);
    }, "_updateLabel"),
    refresh: /* @__PURE__ */ __name(function() {
      var checked = this.element[0].checked, isDisabled4 = this.element[0].disabled;
      this._updateIcon(checked), this._toggleClass(this.label, "ui-checkboxradio-checked", "ui-state-active", checked), this.options.label !== null && this._updateLabel(), isDisabled4 !== this.options.disabled && this._setOptions({ disabled: isDisabled4 });
    }, "refresh")
  }]), $2.ui.checkboxradio;
  /*!
   * jQuery UI Button 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.button", {
    version: "1.14.1",
    defaultElement: "<button>",
    options: {
      classes: {
        "ui-button": "ui-corner-all"
      },
      disabled: null,
      icon: null,
      iconPosition: "beginning",
      label: null,
      showLabel: !0
    },
    _getCreateOptions: /* @__PURE__ */ __name(function() {
      var disabled6, options2 = this._super() || {};
      return this.isInput = this.element.is("input"), disabled6 = this.element[0].disabled, disabled6 != null && (options2.disabled = disabled6), this.originalLabel = this.isInput ? this.element.val() : this.element.html(), this.originalLabel && (options2.label = this.originalLabel), options2;
    }, "_getCreateOptions"),
    _create: /* @__PURE__ */ __name(function() {
      !this.option.showLabel & !this.options.icon && (this.options.showLabel = !0), this.options.disabled == null && (this.options.disabled = this.element[0].disabled || !1), this.hasTitle = !!this.element.attr("title"), this.options.label && this.options.label !== this.originalLabel && (this.isInput ? this.element.val(this.options.label) : this.element.html(this.options.label)), this._addClass("ui-button", "ui-widget"), this._setOption("disabled", this.options.disabled), this._enhance(), this.element.is("a") && this._on({
        keyup: /* @__PURE__ */ __name(function(event2) {
          event2.keyCode === $2.ui.keyCode.SPACE && (event2.preventDefault(), this.element[0].click ? this.element[0].click() : this.element.trigger("click"));
        }, "keyup")
      });
    }, "_create"),
    _enhance: /* @__PURE__ */ __name(function() {
      this.element.is("button") || this.element.attr("role", "button"), this.options.icon && (this._updateIcon("icon", this.options.icon), this._updateTooltip());
    }, "_enhance"),
    _updateTooltip: /* @__PURE__ */ __name(function() {
      this.title = this.element.attr("title"), !this.options.showLabel && !this.title && this.element.attr("title", this.options.label);
    }, "_updateTooltip"),
    _updateIcon: /* @__PURE__ */ __name(function(option2, value3) {
      var icon = option2 !== "iconPosition", position3 = icon ? this.options.iconPosition : value3, displayBlock = position3 === "top" || position3 === "bottom";
      this.icon ? icon && this._removeClass(this.icon, null, this.options.icon) : (this.icon = $2("<span>"), this._addClass(this.icon, "ui-button-icon", "ui-icon"), this.options.showLabel || this._addClass("ui-button-icon-only")), icon && this._addClass(this.icon, null, value3), this._attachIcon(position3), displayBlock ? (this._addClass(this.icon, null, "ui-widget-icon-block"), this.iconSpace && this.iconSpace.remove()) : (this.iconSpace || (this.iconSpace = $2("<span> </span>"), this._addClass(this.iconSpace, "ui-button-icon-space")), this._removeClass(this.icon, null, "ui-wiget-icon-block"), this._attachIconSpace(position3));
    }, "_updateIcon"),
    _destroy: /* @__PURE__ */ __name(function() {
      this.element.removeAttr("role"), this.icon && this.icon.remove(), this.iconSpace && this.iconSpace.remove(), this.hasTitle || this.element.removeAttr("title");
    }, "_destroy"),
    _attachIconSpace: /* @__PURE__ */ __name(function(iconPosition) {
      this.icon[/^(?:end|bottom)/.test(iconPosition) ? "before" : "after"](this.iconSpace);
    }, "_attachIconSpace"),
    _attachIcon: /* @__PURE__ */ __name(function(iconPosition) {
      this.element[/^(?:end|bottom)/.test(iconPosition) ? "append" : "prepend"](this.icon);
    }, "_attachIcon"),
    _setOptions: /* @__PURE__ */ __name(function(options2) {
      var newShowLabel = options2.showLabel === void 0 ? this.options.showLabel : options2.showLabel, newIcon = options2.icon === void 0 ? this.options.icon : options2.icon;
      !newShowLabel && !newIcon && (options2.showLabel = !0), this._super(options2);
    }, "_setOptions"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      key === "icon" && (value3 ? this._updateIcon(key, value3) : this.icon && (this.icon.remove(), this.iconSpace && this.iconSpace.remove())), key === "iconPosition" && this._updateIcon(key, value3), key === "showLabel" && (this._toggleClass("ui-button-icon-only", null, !value3), this._updateTooltip()), key === "label" && (this.isInput ? this.element.val(value3) : (this.element.html(value3), this.icon && (this._attachIcon(this.options.iconPosition), this._attachIconSpace(this.options.iconPosition)))), this._super(key, value3), key === "disabled" && (this._toggleClass(null, "ui-state-disabled", value3), this.element[0].disabled = value3, value3 && this.element.trigger("blur"));
    }, "_setOption"),
    refresh: /* @__PURE__ */ __name(function() {
      var isDisabled4 = this.element.is("input, button") ? this.element[0].disabled : this.element.hasClass("ui-button-disabled");
      isDisabled4 !== this.options.disabled && this._setOptions({ disabled: isDisabled4 }), this._updateTooltip();
    }, "refresh")
  }), $2.uiBackCompat === !0 && ($2.widget("ui.button", $2.ui.button, {
    options: {
      text: !0,
      icons: {
        primary: null,
        secondary: null
      }
    },
    _create: /* @__PURE__ */ __name(function() {
      this.options.showLabel && !this.options.text && (this.options.showLabel = this.options.text), !this.options.showLabel && this.options.text && (this.options.text = this.options.showLabel), !this.options.icon && (this.options.icons.primary || this.options.icons.secondary) ? this.options.icons.primary ? this.options.icon = this.options.icons.primary : (this.options.icon = this.options.icons.secondary, this.options.iconPosition = "end") : this.options.icon && (this.options.icons.primary = this.options.icon), this._super();
    }, "_create"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      if (key === "text") {
        this._super("showLabel", value3);
        return;
      }
      key === "showLabel" && (this.options.text = value3), key === "icon" && (this.options.icons.primary = value3), key === "icons" && (value3.primary ? (this._super("icon", value3.primary), this._super("iconPosition", "beginning")) : value3.secondary && (this._super("icon", value3.secondary), this._super("iconPosition", "end"))), this._superApply(arguments);
    }, "_setOption")
  }), $2.fn.button = /* @__PURE__ */ function(orig) {
    return function(options2) {
      var isMethodCall = typeof options2 == "string", args = Array.prototype.slice.call(arguments, 1), returnValue = this;
      return isMethodCall ? !this.length && options2 === "instance" ? returnValue = void 0 : this.each(function() {
        var methodValue, type2 = $2(this).attr("type"), name2 = type2 !== "checkbox" && type2 !== "radio" ? "button" : "checkboxradio", instance = $2.data(this, "ui-" + name2);
        if (options2 === "instance")
          return returnValue = instance, !1;
        if (!instance)
          return $2.error("cannot call methods on button prior to initialization; attempted to call method '" + options2 + "'");
        if (typeof instance[options2] != "function" || options2.charAt(0) === "_")
          return $2.error("no such method '" + options2 + "' for button widget instance");
        if (methodValue = instance[options2].apply(instance, args), methodValue !== instance && methodValue !== void 0)
          return returnValue = methodValue && methodValue.jquery ? returnValue.pushStack(methodValue.get()) : methodValue, !1;
      }) : (args.length && (options2 = $2.widget.extend.apply(null, [options2].concat(args))), this.each(function() {
        var type2 = $2(this).attr("type"), name2 = type2 !== "checkbox" && type2 !== "radio" ? "button" : "checkboxradio", instance = $2.data(this, "ui-" + name2);
        if (instance)
          instance.option(options2 || {}), instance._init && instance._init();
        else {
          if (name2 === "button") {
            orig.call($2(this), options2);
            return;
          }
          $2(this).checkboxradio($2.extend({ icon: !1 }, options2));
        }
      })), returnValue;
    };
  }($2.fn.button), $2.fn.buttonset = function() {
    return $2.ui.controlgroup || $2.error("Controlgroup widget missing"), arguments[0] === "option" && arguments[1] === "items" && arguments[2] ? this.controlgroup.apply(
      this,
      [arguments[0], "items.button", arguments[2]]
    ) : arguments[0] === "option" && arguments[1] === "items" ? this.controlgroup.apply(this, [arguments[0], "items.button"]) : (typeof arguments[0] == "object" && arguments[0].items && (arguments[0].items = {
      button: arguments[0].items
    }), this.controlgroup.apply(this, arguments));
  }), $2.ui.button;
  /*!
   * jQuery UI Datepicker 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.extend($2.ui, { datepicker: { version: "1.14.1" } });
  var datepicker_instActive;
  function datepicker_getZindex(elem) {
    for (var position3, value3; elem.length && elem[0] !== document; ) {
      if (position3 = elem.css("position"), (position3 === "absolute" || position3 === "relative" || position3 === "fixed") && (value3 = parseInt(elem.css("zIndex"), 10), !isNaN(value3) && value3 !== 0))
        return value3;
      elem = elem.parent();
    }
    return 0;
  }
  __name(datepicker_getZindex, "datepicker_getZindex");
  function Datepicker() {
    this._curInst = null, this._keyEvent = !1, this._disabledInputs = [], this._datepickerShowing = !1, this._inDialog = !1, this._mainDivId = "ui-datepicker-div", this._inlineClass = "ui-datepicker-inline", this._appendClass = "ui-datepicker-append", this._triggerClass = "ui-datepicker-trigger", this._dialogClass = "ui-datepicker-dialog", this._disableClass = "ui-datepicker-disabled", this._unselectableClass = "ui-datepicker-unselectable", this._currentClass = "ui-datepicker-current-day", this._dayOverClass = "ui-datepicker-days-cell-over", this.regional = [], this.regional[""] = {
      // Default regional settings
      closeText: "Done",
      // Display text for close link
      prevText: "Prev",
      // Display text for previous month link
      nextText: "Next",
      // Display text for next month link
      currentText: "Today",
      // Display text for current month link
      monthNames: [
        "January",
        "February",
        "March",
        "April",
        "May",
        "June",
        "July",
        "August",
        "September",
        "October",
        "November",
        "December"
      ],
      // Names of months for drop-down and formatting
      monthNamesShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
      // For formatting
      dayNames: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
      // For formatting
      dayNamesShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
      // For formatting
      dayNamesMin: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
      // Column headings for days starting at Sunday
      weekHeader: "Wk",
      // Column header for week of the year
      dateFormat: "mm/dd/yy",
      // See format options on parseDate
      firstDay: 0,
      // The first day of the week, Sun = 0, Mon = 1, ...
      isRTL: !1,
      // True if right-to-left language, false if left-to-right
      showMonthAfterYear: !1,
      // True if the year select precedes month, false for month then year
      yearSuffix: "",
      // Additional text to append to the year in the month headers,
      selectMonthLabel: "Select month",
      // Invisible label for month selector
      selectYearLabel: "Select year"
      // Invisible label for year selector
    }, this._defaults = {
      // Global defaults for all the date picker instances
      showOn: "focus",
      // "focus" for popup on focus,
      // "button" for trigger button, or "both" for either
      showAnim: "fadeIn",
      // Name of jQuery animation for popup
      showOptions: {},
      // Options for enhanced animations
      defaultDate: null,
      // Used when field is blank: actual date,
      // +/-number for offset from today, null for today
      appendText: "",
      // Display text following the input box, e.g. showing the format
      buttonText: "...",
      // Text for trigger button
      buttonImage: "",
      // URL for trigger button image
      buttonImageOnly: !1,
      // True if the image appears alone, false if it appears on a button
      hideIfNoPrevNext: !1,
      // True to hide next/previous month links
      // if not applicable, false to just disable them
      navigationAsDateFormat: !1,
      // True if date formatting applied to prev/today/next links
      gotoCurrent: !1,
      // True if today link goes back to current selection instead
      changeMonth: !1,
      // True if month can be selected directly, false if only prev/next
      changeYear: !1,
      // True if year can be selected directly, false if only prev/next
      yearRange: "c-10:c+10",
      // Range of years to display in drop-down,
      // either relative to today's year (-nn:+nn), relative to currently displayed year
      // (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)
      showOtherMonths: !1,
      // True to show dates in other months, false to leave blank
      selectOtherMonths: !1,
      // True to allow selection of dates in other months, false for unselectable
      showWeek: !1,
      // True to show week of the year, false to not show it
      calculateWeek: this.iso8601Week,
      // How to calculate the week of the year,
      // takes a Date and returns the number of the week for it
      shortYearCutoff: "+10",
      // Short year values < this are in the current century,
      // > this are in the previous century,
      // string value starting with "+" for current year + value
      minDate: null,
      // The earliest selectable date, or null for no limit
      maxDate: null,
      // The latest selectable date, or null for no limit
      duration: "fast",
      // Duration of display/closure
      beforeShowDay: null,
      // Function that takes a date and returns an array with
      // [0] = true if selectable, false if not, [1] = custom CSS class name(s) or "",
      // [2] = cell title (optional), e.g. $.datepicker.noWeekends
      beforeShow: null,
      // Function that takes an input field and
      // returns a set of custom settings for the date picker
      onSelect: null,
      // Define a callback function when a date is selected
      onChangeMonthYear: null,
      // Define a callback function when the month or year is changed
      onClose: null,
      // Define a callback function when the datepicker is closed
      onUpdateDatepicker: null,
      // Define a callback function when the datepicker is updated
      numberOfMonths: 1,
      // Number of months to show at a time
      showCurrentAtPos: 0,
      // The position in multipe months at which to show the current month (starting at 0)
      stepMonths: 1,
      // Number of months to step back/forward
      stepBigMonths: 12,
      // Number of months to step back/forward for the big links
      altField: "",
      // Selector for an alternate field to store selected dates into
      altFormat: "",
      // The date format to use for the alternate field
      constrainInput: !0,
      // The input is constrained by the current date format
      showButtonPanel: !1,
      // True to show button panel, false to not show it
      autoSize: !1,
      // True to size the input for the date format, false to leave as is
      disabled: !1
      // The initial disabled state
    }, $2.extend(this._defaults, this.regional[""]), this.regional.en = $2.extend(!0, {}, this.regional[""]), this.regional["en-US"] = $2.extend(!0, {}, this.regional.en), this.dpDiv = datepicker_bindHover($2("<div id='" + this._mainDivId + "' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"));
  }
  __name(Datepicker, "Datepicker"), $2.extend(Datepicker.prototype, {
    /* Class name added to elements to indicate already configured with a date picker. */
    markerClassName: "hasDatepicker",
    //Keep track of the maximum number of rows displayed (see #7043)
    maxRows: 4,
    // TODO rename to "widget" when switching to widget factory
    _widgetDatepicker: /* @__PURE__ */ __name(function() {
      return this.dpDiv;
    }, "_widgetDatepicker"),
    /* Override the default settings for all instances of the date picker.
     * @param  settings  object - the new settings to use as defaults (anonymous object)
     * @return the manager object
     */
    setDefaults: /* @__PURE__ */ __name(function(settings) {
      return datepicker_extendRemove(this._defaults, settings || {}), this;
    }, "setDefaults"),
    /* Attach the date picker to a jQuery selection.
     * @param  target	element - the target input field or division or span
     * @param  settings  object - the new settings to use for this date picker instance (anonymous)
     */
    _attachDatepicker: /* @__PURE__ */ __name(function(target2, settings) {
      var nodeName, inline2, inst;
      nodeName = target2.nodeName.toLowerCase(), inline2 = nodeName === "div" || nodeName === "span", target2.id || (this.uuid += 1, target2.id = "dp" + this.uuid), inst = this._newInst($2(target2), inline2), inst.settings = $2.extend({}, settings || {}), nodeName === "input" ? this._connectDatepicker(target2, inst) : inline2 && this._inlineDatepicker(target2, inst);
    }, "_attachDatepicker"),
    /* Create a new instance object. */
    _newInst: /* @__PURE__ */ __name(function(target2, inline2) {
      var id2 = target2[0].id.replace(/([^A-Za-z0-9_\-])/g, "\\\\$1");
      return {
        id: id2,
        input: target2,
        // associated target
        selectedDay: 0,
        selectedMonth: 0,
        selectedYear: 0,
        // current selection
        drawMonth: 0,
        drawYear: 0,
        // month being drawn
        inline: inline2,
        // is datepicker inline or not
        dpDiv: inline2 ? (
          // presentation div
          datepicker_bindHover($2("<div class='" + this._inlineClass + " ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"))
        ) : this.dpDiv
      };
    }, "_newInst"),
    /* Attach the date picker to an input field. */
    _connectDatepicker: /* @__PURE__ */ __name(function(target2, inst) {
      var input = $2(target2);
      inst.append = $2([]), inst.trigger = $2([]), !input.hasClass(this.markerClassName) && (this._attachments(input, inst), input.addClass(this.markerClassName).on("keydown", this._doKeyDown).on("keypress", this._doKeyPress).on("keyup", this._doKeyUp), this._autoSize(inst), $2.data(target2, "datepicker", inst), inst.settings.disabled && this._disableDatepicker(target2));
    }, "_connectDatepicker"),
    /* Make attachments based on settings. */
    _attachments: /* @__PURE__ */ __name(function(input, inst) {
      var showOn, buttonText, buttonImage, appendText = this._get(inst, "appendText"), isRTL3 = this._get(inst, "isRTL");
      inst.append && inst.append.remove(), appendText && (inst.append = $2("<span>").addClass(this._appendClass).text(appendText), input[isRTL3 ? "before" : "after"](inst.append)), input.off("focus", this._showDatepicker), inst.trigger && inst.trigger.remove(), showOn = this._get(inst, "showOn"), (showOn === "focus" || showOn === "both") && input.on("focus", this._showDatepicker), (showOn === "button" || showOn === "both") && (buttonText = this._get(inst, "buttonText"), buttonImage = this._get(inst, "buttonImage"), this._get(inst, "buttonImageOnly") ? inst.trigger = $2("<img>").addClass(this._triggerClass).attr({
        src: buttonImage,
        alt: buttonText,
        title: buttonText
      }) : (inst.trigger = $2("<button type='button'>").addClass(this._triggerClass), buttonImage ? inst.trigger.html(
        $2("<img>").attr({
          src: buttonImage,
          alt: buttonText,
          title: buttonText
        })
      ) : inst.trigger.text(buttonText)), input[isRTL3 ? "before" : "after"](inst.trigger), inst.trigger.on("click", function() {
        return $2.datepicker._datepickerShowing && $2.datepicker._lastInput === input[0] ? $2.datepicker._hideDatepicker() : ($2.datepicker._datepickerShowing && $2.datepicker._lastInput !== input[0] && $2.datepicker._hideDatepicker(), $2.datepicker._showDatepicker(input[0])), !1;
      }));
    }, "_attachments"),
    /* Apply the maximum length for the date format. */
    _autoSize: /* @__PURE__ */ __name(function(inst) {
      if (this._get(inst, "autoSize") && !inst.inline) {
        var findMax, max2, maxI, i, date = new Date(2009, 11, 20), dateFormat = this._get(inst, "dateFormat");
        dateFormat.match(/[DM]/) && (findMax = /* @__PURE__ */ __name(function(names) {
          for (max2 = 0, maxI = 0, i = 0; i < names.length; i++)
            names[i].length > max2 && (max2 = names[i].length, maxI = i);
          return maxI;
        }, "findMax"), date.setMonth(findMax(this._get(inst, dateFormat.match(/MM/) ? "monthNames" : "monthNamesShort"))), date.setDate(findMax(this._get(inst, dateFormat.match(/DD/) ? "dayNames" : "dayNamesShort")) + 20 - date.getDay())), inst.input.attr("size", this._formatDate(inst, date).length);
      }
    }, "_autoSize"),
    /* Attach an inline date picker to a div. */
    _inlineDatepicker: /* @__PURE__ */ __name(function(target2, inst) {
      var divSpan = $2(target2);
      divSpan.hasClass(this.markerClassName) || (divSpan.addClass(this.markerClassName).append(inst.dpDiv), $2.data(target2, "datepicker", inst), this._setDate(inst, this._getDefaultDate(inst), !0), this._updateDatepicker(inst), this._updateAlternate(inst), inst.settings.disabled && this._disableDatepicker(target2), inst.dpDiv.css("display", "block"));
    }, "_inlineDatepicker"),
    /* Pop-up the date picker in a "dialog" box.
     * @param  input element - ignored
     * @param  date	string or Date - the initial date to display
     * @param  onSelect  function - the function to call when a date is selected
     * @param  settings  object - update the dialog date picker instance's settings (anonymous object)
     * @param  pos int[2] - coordinates for the dialog's position within the screen or
     *					event - with x/y coordinates or
     *					leave empty for default (screen centre)
     * @return the manager object
     */
    _dialogDatepicker: /* @__PURE__ */ __name(function(input, date, onSelect, settings, pos) {
      var id2, browserWidth, browserHeight, scrollX, scrollY, inst = this._dialogInst;
      return inst || (this.uuid += 1, id2 = "dp" + this.uuid, this._dialogInput = $2("<input type='text' id='" + id2 + "' style='position: absolute; top: -100px; width: 0px;'/>"), this._dialogInput.on("keydown", this._doKeyDown), $2("body").append(this._dialogInput), inst = this._dialogInst = this._newInst(this._dialogInput, !1), inst.settings = {}, $2.data(this._dialogInput[0], "datepicker", inst)), datepicker_extendRemove(inst.settings, settings || {}), date = date && date.constructor === Date ? this._formatDate(inst, date) : date, this._dialogInput.val(date), this._pos = pos ? pos.length ? pos : [pos.pageX, pos.pageY] : null, this._pos || (browserWidth = document.documentElement.clientWidth, browserHeight = document.documentElement.clientHeight, scrollX = document.documentElement.scrollLeft || document.body.scrollLeft, scrollY = document.documentElement.scrollTop || document.body.scrollTop, this._pos = // should use actual width/height below
      [browserWidth / 2 - 100 + scrollX, browserHeight / 2 - 150 + scrollY]), this._dialogInput.css("left", this._pos[0] + 20 + "px").css("top", this._pos[1] + "px"), inst.settings.onSelect = onSelect, this._inDialog = !0, this.dpDiv.addClass(this._dialogClass), this._showDatepicker(this._dialogInput[0]), $2.blockUI && $2.blockUI(this.dpDiv), $2.data(this._dialogInput[0], "datepicker", inst), this;
    }, "_dialogDatepicker"),
    /* Detach a datepicker from its control.
     * @param  target	element - the target input field or division or span
     */
    _destroyDatepicker: /* @__PURE__ */ __name(function(target2) {
      var nodeName, $target = $2(target2), inst = $2.data(target2, "datepicker");
      $target.hasClass(this.markerClassName) && (nodeName = target2.nodeName.toLowerCase(), $2.removeData(target2, "datepicker"), nodeName === "input" ? (inst.append.remove(), inst.trigger.remove(), $target.removeClass(this.markerClassName).off("focus", this._showDatepicker).off("keydown", this._doKeyDown).off("keypress", this._doKeyPress).off("keyup", this._doKeyUp)) : (nodeName === "div" || nodeName === "span") && $target.removeClass(this.markerClassName).empty(), $2.datepicker._hideDatepicker(), datepicker_instActive === inst && (datepicker_instActive = null, this._curInst = null));
    }, "_destroyDatepicker"),
    /* Enable the date picker to a jQuery selection.
     * @param  target	element - the target input field or division or span
     */
    _enableDatepicker: /* @__PURE__ */ __name(function(target2) {
      var nodeName, inline2, $target = $2(target2), inst = $2.data(target2, "datepicker");
      $target.hasClass(this.markerClassName) && (nodeName = target2.nodeName.toLowerCase(), nodeName === "input" ? (target2.disabled = !1, inst.trigger.filter("button").each(function() {
        this.disabled = !1;
      }).end().filter("img").css({ opacity: "1.0", cursor: "" })) : (nodeName === "div" || nodeName === "span") && (inline2 = $target.children("." + this._inlineClass), inline2.children().removeClass("ui-state-disabled"), inline2.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled", !1)), this._disabledInputs = $2.map(
        this._disabledInputs,
        // Delete entry
        function(value3) {
          return value3 === target2 ? null : value3;
        }
      ));
    }, "_enableDatepicker"),
    /* Disable the date picker to a jQuery selection.
     * @param  target	element - the target input field or division or span
     */
    _disableDatepicker: /* @__PURE__ */ __name(function(target2) {
      var nodeName, inline2, $target = $2(target2), inst = $2.data(target2, "datepicker");
      $target.hasClass(this.markerClassName) && (nodeName = target2.nodeName.toLowerCase(), nodeName === "input" ? (target2.disabled = !0, inst.trigger.filter("button").each(function() {
        this.disabled = !0;
      }).end().filter("img").css({ opacity: "0.5", cursor: "default" })) : (nodeName === "div" || nodeName === "span") && (inline2 = $target.children("." + this._inlineClass), inline2.children().addClass("ui-state-disabled"), inline2.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled", !0)), this._disabledInputs = $2.map(
        this._disabledInputs,
        // Delete entry
        function(value3) {
          return value3 === target2 ? null : value3;
        }
      ), this._disabledInputs[this._disabledInputs.length] = target2);
    }, "_disableDatepicker"),
    /* Is the first field in a jQuery collection disabled as a datepicker?
     * @param  target	element - the target input field or division or span
     * @return boolean - true if disabled, false if enabled
     */
    _isDisabledDatepicker: /* @__PURE__ */ __name(function(target2) {
      if (!target2)
        return !1;
      for (var i = 0; i < this._disabledInputs.length; i++)
        if (this._disabledInputs[i] === target2)
          return !0;
      return !1;
    }, "_isDisabledDatepicker"),
    /* Retrieve the instance data for the target control.
     * @param  target  element - the target input field or division or span
     * @return  object - the associated instance data
     * @throws  error if a jQuery problem getting data
     */
    _getInst: /* @__PURE__ */ __name(function(target2) {
      try {
        return $2.data(target2, "datepicker");
      } catch {
        throw "Missing instance data for this datepicker";
      }
    }, "_getInst"),
    /* Update or retrieve the settings for a date picker attached to an input field or division.
     * @param  target  element - the target input field or division or span
     * @param  name	object - the new settings to update or
     *				string - the name of the setting to change or retrieve,
     *				when retrieving also "all" for all instance settings or
     *				"defaults" for all global defaults
     * @param  value   any - the new value for the setting
     *				(omit if above is an object or to retrieve a value)
     */
    _optionDatepicker: /* @__PURE__ */ __name(function(target2, name2, value3) {
      var settings, date, minDate, maxDate, inst = this._getInst(target2);
      if (arguments.length === 2 && typeof name2 == "string")
        return name2 === "defaults" ? $2.extend({}, $2.datepicker._defaults) : inst ? name2 === "all" ? $2.extend({}, inst.settings) : this._get(inst, name2) : null;
      settings = name2 || {}, typeof name2 == "string" && (settings = {}, settings[name2] = value3), inst && (this._curInst === inst && this._hideDatepicker(), date = this._getDateDatepicker(target2, !0), minDate = this._getMinMaxDate(inst, "min"), maxDate = this._getMinMaxDate(inst, "max"), datepicker_extendRemove(inst.settings, settings), minDate !== null && settings.dateFormat !== void 0 && settings.minDate === void 0 && (inst.settings.minDate = this._formatDate(inst, minDate)), maxDate !== null && settings.dateFormat !== void 0 && settings.maxDate === void 0 && (inst.settings.maxDate = this._formatDate(inst, maxDate)), "disabled" in settings && (settings.disabled ? this._disableDatepicker(target2) : this._enableDatepicker(target2)), this._attachments($2(target2), inst), this._autoSize(inst), this._setDate(inst, date), this._updateAlternate(inst), this._updateDatepicker(inst));
    }, "_optionDatepicker"),
    // Change method deprecated
    _changeDatepicker: /* @__PURE__ */ __name(function(target2, name2, value3) {
      this._optionDatepicker(target2, name2, value3);
    }, "_changeDatepicker"),
    /* Redraw the date picker attached to an input field or division.
     * @param  target  element - the target input field or division or span
     */
    _refreshDatepicker: /* @__PURE__ */ __name(function(target2) {
      var inst = this._getInst(target2);
      inst && this._updateDatepicker(inst);
    }, "_refreshDatepicker"),
    /* Set the dates for a jQuery selection.
     * @param  target element - the target input field or division or span
     * @param  date	Date - the new date
     */
    _setDateDatepicker: /* @__PURE__ */ __name(function(target2, date) {
      var inst = this._getInst(target2);
      inst && (this._setDate(inst, date), this._updateDatepicker(inst), this._updateAlternate(inst));
    }, "_setDateDatepicker"),
    /* Get the date(s) for the first entry in a jQuery selection.
     * @param  target element - the target input field or division or span
     * @param  noDefault boolean - true if no default date is to be used
     * @return Date - the current date
     */
    _getDateDatepicker: /* @__PURE__ */ __name(function(target2, noDefault) {
      var inst = this._getInst(target2);
      return inst && !inst.inline && this._setDateFromField(inst, noDefault), inst ? this._getDate(inst) : null;
    }, "_getDateDatepicker"),
    /* Handle keystrokes. */
    _doKeyDown: /* @__PURE__ */ __name(function(event2) {
      var onSelect, dateStr, sel, inst = $2.datepicker._getInst(event2.target), handled = !0, isRTL3 = inst.dpDiv.is(".ui-datepicker-rtl");
      if (inst._keyEvent = !0, $2.datepicker._datepickerShowing)
        switch (event2.keyCode) {
          case 9:
            $2.datepicker._hideDatepicker(), handled = !1;
            break;
          case 13:
            return sel = $2("td." + $2.datepicker._dayOverClass + ":not(." + $2.datepicker._currentClass + ")", inst.dpDiv), sel[0] && $2.datepicker._selectDay(event2.target, inst.selectedMonth, inst.selectedYear, sel[0]), onSelect = $2.datepicker._get(inst, "onSelect"), onSelect ? (dateStr = $2.datepicker._formatDate(inst), onSelect.apply(inst.input ? inst.input[0] : null, [dateStr, inst])) : $2.datepicker._hideDatepicker(), !1;
          case 27:
            $2.datepicker._hideDatepicker();
            break;
          case 33:
            $2.datepicker._adjustDate(event2.target, event2.ctrlKey ? -$2.datepicker._get(inst, "stepBigMonths") : -$2.datepicker._get(inst, "stepMonths"), "M");
            break;
          case 34:
            $2.datepicker._adjustDate(event2.target, event2.ctrlKey ? +$2.datepicker._get(inst, "stepBigMonths") : +$2.datepicker._get(inst, "stepMonths"), "M");
            break;
          case 35:
            (event2.ctrlKey || event2.metaKey) && $2.datepicker._clearDate(event2.target), handled = event2.ctrlKey || event2.metaKey;
            break;
          case 36:
            (event2.ctrlKey || event2.metaKey) && $2.datepicker._gotoToday(event2.target), handled = event2.ctrlKey || event2.metaKey;
            break;
          case 37:
            (event2.ctrlKey || event2.metaKey) && $2.datepicker._adjustDate(event2.target, isRTL3 ? 1 : -1, "D"), handled = event2.ctrlKey || event2.metaKey, event2.originalEvent.altKey && $2.datepicker._adjustDate(event2.target, event2.ctrlKey ? -$2.datepicker._get(inst, "stepBigMonths") : -$2.datepicker._get(inst, "stepMonths"), "M");
            break;
          case 38:
            (event2.ctrlKey || event2.metaKey) && $2.datepicker._adjustDate(event2.target, -7, "D"), handled = event2.ctrlKey || event2.metaKey;
            break;
          case 39:
            (event2.ctrlKey || event2.metaKey) && $2.datepicker._adjustDate(event2.target, isRTL3 ? -1 : 1, "D"), handled = event2.ctrlKey || event2.metaKey, event2.originalEvent.altKey && $2.datepicker._adjustDate(event2.target, event2.ctrlKey ? +$2.datepicker._get(inst, "stepBigMonths") : +$2.datepicker._get(inst, "stepMonths"), "M");
            break;
          case 40:
            (event2.ctrlKey || event2.metaKey) && $2.datepicker._adjustDate(event2.target, 7, "D"), handled = event2.ctrlKey || event2.metaKey;
            break;
          default:
            handled = !1;
        }
      else event2.keyCode === 36 && event2.ctrlKey ? $2.datepicker._showDatepicker(this) : handled = !1;
      handled && (event2.preventDefault(), event2.stopPropagation());
    }, "_doKeyDown"),
    /* Filter entered characters - based on date format. */
    _doKeyPress: /* @__PURE__ */ __name(function(event2) {
      var chars, chr2, inst = $2.datepicker._getInst(event2.target);
      if ($2.datepicker._get(inst, "constrainInput"))
        return chars = $2.datepicker._possibleChars($2.datepicker._get(inst, "dateFormat")), chr2 = String.fromCharCode(event2.charCode == null ? event2.keyCode : event2.charCode), event2.ctrlKey || event2.metaKey || chr2 < " " || !chars || chars.indexOf(chr2) > -1;
    }, "_doKeyPress"),
    /* Synchronise manual entry and field/alternate field. */
    _doKeyUp: /* @__PURE__ */ __name(function(event2) {
      var date, inst = $2.datepicker._getInst(event2.target);
      if (inst.input.val() !== inst.lastVal)
        try {
          date = $2.datepicker.parseDate(
            $2.datepicker._get(inst, "dateFormat"),
            inst.input ? inst.input.val() : null,
            $2.datepicker._getFormatConfig(inst)
          ), date && ($2.datepicker._setDateFromField(inst), $2.datepicker._updateAlternate(inst), $2.datepicker._updateDatepicker(inst));
        } catch {
        }
      return !0;
    }, "_doKeyUp"),
    /* Pop-up the date picker for a given input field.
     * If false returned from beforeShow event handler do not show.
     * @param  input  element - the input field attached to the date picker or
     *					event - if triggered by focus
     */
    _showDatepicker: /* @__PURE__ */ __name(function(input) {
      if (input = input.target || input, input.nodeName.toLowerCase() !== "input" && (input = $2("input", input.parentNode)[0]), !($2.datepicker._isDisabledDatepicker(input) || $2.datepicker._lastInput === input)) {
        var inst, beforeShow, beforeShowSettings, isFixed2, offset3, showAnim, duration;
        inst = $2.datepicker._getInst(input), $2.datepicker._curInst && $2.datepicker._curInst !== inst && ($2.datepicker._curInst.dpDiv.stop(!0, !0), inst && $2.datepicker._datepickerShowing && $2.datepicker._hideDatepicker($2.datepicker._curInst.input[0])), beforeShow = $2.datepicker._get(inst, "beforeShow"), beforeShowSettings = beforeShow ? beforeShow.apply(input, [input, inst]) : {}, beforeShowSettings !== !1 && (datepicker_extendRemove(inst.settings, beforeShowSettings), inst.lastVal = null, $2.datepicker._lastInput = input, $2.datepicker._setDateFromField(inst), $2.datepicker._inDialog && (input.value = ""), $2.datepicker._pos || ($2.datepicker._pos = $2.datepicker._findPos(input), $2.datepicker._pos[1] += input.offsetHeight), isFixed2 = !1, $2(input).parents().each(function() {
          return isFixed2 |= $2(this).css("position") === "fixed", !isFixed2;
        }), offset3 = { left: $2.datepicker._pos[0], top: $2.datepicker._pos[1] }, $2.datepicker._pos = null, inst.dpDiv.empty(), inst.dpDiv.css({ position: "absolute", display: "block", top: "-1000px" }), $2.datepicker._updateDatepicker(inst), offset3 = $2.datepicker._checkOffset(inst, offset3, isFixed2), inst.dpDiv.css({
          position: $2.datepicker._inDialog && $2.blockUI ? "static" : isFixed2 ? "fixed" : "absolute",
          display: "none",
          left: offset3.left + "px",
          top: offset3.top + "px"
        }), inst.inline || (showAnim = $2.datepicker._get(inst, "showAnim"), duration = $2.datepicker._get(inst, "duration"), inst.dpDiv.css("z-index", datepicker_getZindex($2(input)) + 1), $2.datepicker._datepickerShowing = !0, $2.effects && $2.effects.effect[showAnim] ? inst.dpDiv.show(showAnim, $2.datepicker._get(inst, "showOptions"), duration) : inst.dpDiv[showAnim || "show"](showAnim ? duration : null), $2.datepicker._shouldFocusInput(inst) && inst.input.trigger("focus"), $2.datepicker._curInst = inst));
      }
    }, "_showDatepicker"),
    /* Generate the date picker content. */
    _updateDatepicker: /* @__PURE__ */ __name(function(inst) {
      this.maxRows = 4, datepicker_instActive = inst, inst.dpDiv.empty().append(this._generateHTML(inst)), this._attachHandlers(inst);
      var origyearshtml, numMonths = this._getNumberOfMonths(inst), cols = numMonths[1], width = 17, activeCell = inst.dpDiv.find("." + this._dayOverClass + " a"), onUpdateDatepicker = $2.datepicker._get(inst, "onUpdateDatepicker");
      activeCell.length > 0 && datepicker_handleMouseover.apply(activeCell.get(0)), inst.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width(""), cols > 1 && inst.dpDiv.addClass("ui-datepicker-multi-" + cols).css("width", width * cols + "em"), inst.dpDiv[(numMonths[0] !== 1 || numMonths[1] !== 1 ? "add" : "remove") + "Class"]("ui-datepicker-multi"), inst.dpDiv[(this._get(inst, "isRTL") ? "add" : "remove") + "Class"]("ui-datepicker-rtl"), inst === $2.datepicker._curInst && $2.datepicker._datepickerShowing && $2.datepicker._shouldFocusInput(inst) && inst.input.trigger("focus"), inst.yearshtml && (origyearshtml = inst.yearshtml, setTimeout(function() {
        origyearshtml === inst.yearshtml && inst.yearshtml && inst.dpDiv.find("select.ui-datepicker-year").first().replaceWith(inst.yearshtml), origyearshtml = inst.yearshtml = null;
      }, 0)), onUpdateDatepicker && onUpdateDatepicker.apply(inst.input ? inst.input[0] : null, [inst]);
    }, "_updateDatepicker"),
    _shouldFocusInput: /* @__PURE__ */ __name(function(inst) {
      return inst.input && inst.input.is(":visible") && !inst.input.is(":disabled");
    }, "_shouldFocusInput"),
    /* Check positioning to remain on screen. */
    _checkOffset: /* @__PURE__ */ __name(function(inst, offset3, isFixed2) {
      var dpWidth = inst.dpDiv.outerWidth(), dpHeight = inst.dpDiv.outerHeight(), inputWidth = inst.input ? inst.input.outerWidth() : 0, inputHeight = inst.input ? inst.input.outerHeight() : 0, viewWidth = document.documentElement.clientWidth + (isFixed2 ? 0 : $2(document).scrollLeft()), viewHeight = document.documentElement.clientHeight + (isFixed2 ? 0 : $2(document).scrollTop());
      return offset3.left -= this._get(inst, "isRTL") ? dpWidth - inputWidth : 0, offset3.left -= isFixed2 && offset3.left === inst.input.offset().left ? $2(document).scrollLeft() : 0, offset3.top -= isFixed2 && offset3.top === inst.input.offset().top + inputHeight ? $2(document).scrollTop() : 0, offset3.left -= Math.min(offset3.left, offset3.left + dpWidth > viewWidth && viewWidth > dpWidth ? Math.abs(offset3.left + dpWidth - viewWidth) : 0), offset3.top -= Math.min(offset3.top, offset3.top + dpHeight > viewHeight && viewHeight > dpHeight ? Math.abs(dpHeight + inputHeight) : 0), offset3;
    }, "_checkOffset"),
    /* Find an object's position on the screen. */
    _findPos: /* @__PURE__ */ __name(function(obj2) {
      for (var position3, inst = this._getInst(obj2), isRTL3 = this._get(inst, "isRTL"); obj2 && (obj2.type === "hidden" || obj2.nodeType !== 1 || $2.expr.pseudos.hidden(obj2)); )
        obj2 = obj2[isRTL3 ? "previousSibling" : "nextSibling"];
      return position3 = $2(obj2).offset(), [position3.left, position3.top];
    }, "_findPos"),
    /* Hide the date picker from view.
     * @param  input  element - the input field attached to the date picker
     */
    _hideDatepicker: /* @__PURE__ */ __name(function(input) {
      var showAnim, duration, postProcess, onClose2, inst = this._curInst;
      !inst || input && inst !== $2.data(input, "datepicker") || this._datepickerShowing && (showAnim = this._get(inst, "showAnim"), duration = this._get(inst, "duration"), postProcess = /* @__PURE__ */ __name(function() {
        $2.datepicker._tidyDialog(inst);
      }, "postProcess"), $2.effects && $2.effects.effect[showAnim] ? inst.dpDiv.hide(showAnim, $2.datepicker._get(inst, "showOptions"), duration, postProcess) : inst.dpDiv[showAnim === "slideDown" ? "slideUp" : showAnim === "fadeIn" ? "fadeOut" : "hide"](showAnim ? duration : null, postProcess), showAnim || postProcess(), this._datepickerShowing = !1, onClose2 = this._get(inst, "onClose"), onClose2 && onClose2.apply(inst.input ? inst.input[0] : null, [inst.input ? inst.input.val() : "", inst]), this._lastInput = null, this._inDialog && (this._dialogInput.css({ position: "absolute", left: "0", top: "-100px" }), $2.blockUI && ($2.unblockUI(), $2("body").append(this.dpDiv))), this._inDialog = !1);
    }, "_hideDatepicker"),
    /* Tidy up after a dialog display. */
    _tidyDialog: /* @__PURE__ */ __name(function(inst) {
      inst.dpDiv.removeClass(this._dialogClass).off(".ui-datepicker-calendar");
    }, "_tidyDialog"),
    /* Close date picker if clicked elsewhere. */
    _checkExternalClick: /* @__PURE__ */ __name(function(event2) {
      if ($2.datepicker._curInst) {
        var $target = $2(event2.target), inst = $2.datepicker._getInst($target[0]);
        ($target[0].id !== $2.datepicker._mainDivId && $target.parents("#" + $2.datepicker._mainDivId).length === 0 && !$target.hasClass($2.datepicker.markerClassName) && !$target.closest("." + $2.datepicker._triggerClass).length && $2.datepicker._datepickerShowing && !($2.datepicker._inDialog && $2.blockUI) || $target.hasClass($2.datepicker.markerClassName) && $2.datepicker._curInst !== inst) && $2.datepicker._hideDatepicker();
      }
    }, "_checkExternalClick"),
    /* Adjust one of the date sub-fields. */
    _adjustDate: /* @__PURE__ */ __name(function(id2, offset3, period) {
      var target2 = $2(id2), inst = this._getInst(target2[0]);
      this._isDisabledDatepicker(target2[0]) || (this._adjustInstDate(inst, offset3, period), this._updateDatepicker(inst));
    }, "_adjustDate"),
    /* Action for current link. */
    _gotoToday: /* @__PURE__ */ __name(function(id2) {
      var date, target2 = $2(id2), inst = this._getInst(target2[0]);
      this._get(inst, "gotoCurrent") && inst.currentDay ? (inst.selectedDay = inst.currentDay, inst.drawMonth = inst.selectedMonth = inst.currentMonth, inst.drawYear = inst.selectedYear = inst.currentYear) : (date = /* @__PURE__ */ new Date(), inst.selectedDay = date.getDate(), inst.drawMonth = inst.selectedMonth = date.getMonth(), inst.drawYear = inst.selectedYear = date.getFullYear()), this._notifyChange(inst), this._adjustDate(target2);
    }, "_gotoToday"),
    /* Action for selecting a new month/year. */
    _selectMonthYear: /* @__PURE__ */ __name(function(id2, select4, period) {
      var target2 = $2(id2), inst = this._getInst(target2[0]);
      inst["selected" + (period === "M" ? "Month" : "Year")] = inst["draw" + (period === "M" ? "Month" : "Year")] = parseInt(select4.options[select4.selectedIndex].value, 10), this._notifyChange(inst), this._adjustDate(target2);
    }, "_selectMonthYear"),
    /* Action for selecting a day. */
    _selectDay: /* @__PURE__ */ __name(function(id2, month, year, td) {
      var inst, target2 = $2(id2);
      $2(td).hasClass(this._unselectableClass) || this._isDisabledDatepicker(target2[0]) || (inst = this._getInst(target2[0]), inst.selectedDay = inst.currentDay = parseInt($2("a", td).attr("data-date")), inst.selectedMonth = inst.currentMonth = month, inst.selectedYear = inst.currentYear = year, this._selectDate(id2, this._formatDate(
        inst,
        inst.currentDay,
        inst.currentMonth,
        inst.currentYear
      )));
    }, "_selectDay"),
    /* Erase the input field and hide the date picker. */
    _clearDate: /* @__PURE__ */ __name(function(id2) {
      var target2 = $2(id2);
      this._selectDate(target2, "");
    }, "_clearDate"),
    /* Update the input field with the selected date. */
    _selectDate: /* @__PURE__ */ __name(function(id2, dateStr) {
      var onSelect, target2 = $2(id2), inst = this._getInst(target2[0]);
      dateStr = dateStr ?? this._formatDate(inst), inst.input && inst.input.val(dateStr), this._updateAlternate(inst), onSelect = this._get(inst, "onSelect"), onSelect ? onSelect.apply(inst.input ? inst.input[0] : null, [dateStr, inst]) : inst.input && inst.input.trigger("change"), inst.inline ? this._updateDatepicker(inst) : (this._hideDatepicker(), this._lastInput = inst.input[0], typeof inst.input[0] != "object" && inst.input.trigger("focus"), this._lastInput = null);
    }, "_selectDate"),
    /* Update any alternate field to synchronise with the main field. */
    _updateAlternate: /* @__PURE__ */ __name(function(inst) {
      var altFormat, date, dateStr, altField = this._get(inst, "altField");
      altField && (altFormat = this._get(inst, "altFormat") || this._get(inst, "dateFormat"), date = this._getDate(inst), dateStr = this.formatDate(altFormat, date, this._getFormatConfig(inst)), $2(document).find(altField).val(dateStr));
    }, "_updateAlternate"),
    /* Set as beforeShowDay function to prevent selection of weekends.
     * @param  date  Date - the date to customise
     * @return [boolean, string] - is this date selectable?, what is its CSS class?
     */
    noWeekends: /* @__PURE__ */ __name(function(date) {
      var day = date.getDay();
      return [day > 0 && day < 6, ""];
    }, "noWeekends"),
    /* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.
     * @param  date  Date - the date to get the week for
     * @return  number - the number of the week within the year that contains this date
     */
    iso8601Week: /* @__PURE__ */ __name(function(date) {
      var time, checkDate = new Date(date.getTime());
      return checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7)), time = checkDate.getTime(), checkDate.setMonth(0), checkDate.setDate(1), Math.floor(Math.round((time - checkDate) / 864e5) / 7) + 1;
    }, "iso8601Week"),
    /* Parse a string value into a date object.
     * See formatDate below for the possible formats.
     *
     * @param  format string - the expected format of the date
     * @param  value string - the date in the above format
     * @param  settings Object - attributes include:
     *					shortYearCutoff  number - the cutoff year for determining the century (optional)
     *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
     *					dayNames		string[7] - names of the days from Sunday (optional)
     *					monthNamesShort string[12] - abbreviated names of the months (optional)
     *					monthNames		string[12] - names of the months (optional)
     * @return  Date - the extracted date value or null if value is blank
     */
    parseDate: /* @__PURE__ */ __name(function(format2, value3, settings) {
      if (format2 == null || value3 == null)
        throw "Invalid arguments";
      if (value3 = typeof value3 == "object" ? value3.toString() : value3 + "", value3 === "")
        return null;
      var iFormat, dim, extra, iValue = 0, shortYearCutoffTemp = (settings ? settings.shortYearCutoff : null) || this._defaults.shortYearCutoff, shortYearCutoff = typeof shortYearCutoffTemp != "string" ? shortYearCutoffTemp : (/* @__PURE__ */ new Date()).getFullYear() % 100 + parseInt(shortYearCutoffTemp, 10), dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort, dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames, monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort, monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames, year = -1, month = -1, day = -1, doy = -1, literal = !1, date, lookAhead = /* @__PURE__ */ __name(function(match3) {
        var matches4 = iFormat + 1 < format2.length && format2.charAt(iFormat + 1) === match3;
        return matches4 && iFormat++, matches4;
      }, "lookAhead"), getNumber = /* @__PURE__ */ __name(function(match3) {
        var isDoubled = lookAhead(match3), size2 = match3 === "@" ? 14 : match3 === "!" ? 20 : match3 === "y" && isDoubled ? 4 : match3 === "o" ? 3 : 2, minSize = match3 === "y" ? size2 : 1, digits2 = new RegExp("^\\d{" + minSize + "," + size2 + "}"), num = value3.substring(iValue).match(digits2);
        if (!num)
          throw "Missing number at position " + iValue;
        return iValue += num[0].length, parseInt(num[0], 10);
      }, "getNumber"), getName = /* @__PURE__ */ __name(function(match3, shortNames, longNames) {
        var index3 = -1, names = $2.map(lookAhead(match3) ? longNames : shortNames, function(v, k) {
          return [[k, v]];
        }).sort(function(a2, b) {
          return -(a2[1].length - b[1].length);
        });
        if ($2.each(names, function(i, pair) {
          var name2 = pair[1];
          if (value3.substr(iValue, name2.length).toLowerCase() === name2.toLowerCase())
            return index3 = pair[0], iValue += name2.length, !1;
        }), index3 !== -1)
          return index3 + 1;
        throw "Unknown name at position " + iValue;
      }, "getName"), checkLiteral = /* @__PURE__ */ __name(function() {
        if (value3.charAt(iValue) !== format2.charAt(iFormat))
          throw "Unexpected literal at position " + iValue;
        iValue++;
      }, "checkLiteral");
      for (iFormat = 0; iFormat < format2.length; iFormat++)
        if (literal)
          format2.charAt(iFormat) === "'" && !lookAhead("'") ? literal = !1 : checkLiteral();
        else
          switch (format2.charAt(iFormat)) {
            case "d":
              day = getNumber("d");
              break;
            case "D":
              getName("D", dayNamesShort, dayNames);
              break;
            case "o":
              doy = getNumber("o");
              break;
            case "m":
              month = getNumber("m");
              break;
            case "M":
              month = getName("M", monthNamesShort, monthNames);
              break;
            case "y":
              year = getNumber("y");
              break;
            case "@":
              date = new Date(getNumber("@")), year = date.getFullYear(), month = date.getMonth() + 1, day = date.getDate();
              break;
            case "!":
              date = new Date((getNumber("!") - this._ticksTo1970) / 1e4), year = date.getFullYear(), month = date.getMonth() + 1, day = date.getDate();
              break;
            case "'":
              lookAhead("'") ? checkLiteral() : literal = !0;
              break;
            default:
              checkLiteral();
          }
      if (iValue < value3.length && (extra = value3.substr(iValue), !/^\s+/.test(extra)))
        throw "Extra/unparsed characters found in date: " + extra;
      if (year === -1 ? year = (/* @__PURE__ */ new Date()).getFullYear() : year < 100 && (year += (/* @__PURE__ */ new Date()).getFullYear() - (/* @__PURE__ */ new Date()).getFullYear() % 100 + (year <= shortYearCutoff ? 0 : -100)), doy > -1) {
        month = 1, day = doy;
        do {
          if (dim = this._getDaysInMonth(year, month - 1), day <= dim)
            break;
          month++, day -= dim;
        } while (!0);
      }
      if (date = this._daylightSavingAdjust(new Date(year, month - 1, day)), date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day)
        throw "Invalid date";
      return date;
    }, "parseDate"),
    /* Standard date formats. */
    ATOM: "yy-mm-dd",
    // RFC 3339 (ISO 8601)
    COOKIE: "D, dd M yy",
    ISO_8601: "yy-mm-dd",
    RFC_822: "D, d M y",
    RFC_850: "DD, dd-M-y",
    RFC_1036: "D, d M y",
    RFC_1123: "D, d M yy",
    RFC_2822: "D, d M yy",
    RSS: "D, d M y",
    // RFC 822
    TICKS: "!",
    TIMESTAMP: "@",
    W3C: "yy-mm-dd",
    // ISO 8601
    _ticksTo1970: (1969 * 365 + Math.floor(1970 / 4) - Math.floor(1970 / 100) + Math.floor(1970 / 400)) * 24 * 60 * 60 * 1e7,
    /* Format a date object into a string value.
     * The format can be combinations of the following:
     * d  - day of month (no leading zero)
     * dd - day of month (two digit)
     * o  - day of year (no leading zeros)
     * oo - day of year (three digit)
     * D  - day name short
     * DD - day name long
     * m  - month of year (no leading zero)
     * mm - month of year (two digit)
     * M  - month name short
     * MM - month name long
     * y  - year (two digit)
     * yy - year (four digit)
     * @ - Unix timestamp (ms since 01/01/1970)
     * ! - Windows ticks (100ns since 01/01/0001)
     * "..." - literal text
     * '' - single quote
     *
     * @param  format string - the desired format of the date
     * @param  date Date - the date value to format
     * @param  settings Object - attributes include:
     *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
     *					dayNames		string[7] - names of the days from Sunday (optional)
     *					monthNamesShort string[12] - abbreviated names of the months (optional)
     *					monthNames		string[12] - names of the months (optional)
     * @return  string - the date in the above format
     */
    formatDate: /* @__PURE__ */ __name(function(format2, date, settings) {
      if (!date)
        return "";
      var iFormat, dayNamesShort = (settings ? settings.dayNamesShort : null) || this._defaults.dayNamesShort, dayNames = (settings ? settings.dayNames : null) || this._defaults.dayNames, monthNamesShort = (settings ? settings.monthNamesShort : null) || this._defaults.monthNamesShort, monthNames = (settings ? settings.monthNames : null) || this._defaults.monthNames, lookAhead = /* @__PURE__ */ __name(function(match3) {
        var matches4 = iFormat + 1 < format2.length && format2.charAt(iFormat + 1) === match3;
        return matches4 && iFormat++, matches4;
      }, "lookAhead"), formatNumber = /* @__PURE__ */ __name(function(match3, value3, len2) {
        var num = "" + value3;
        if (lookAhead(match3))
          for (; num.length < len2; )
            num = "0" + num;
        return num;
      }, "formatNumber"), formatName2 = /* @__PURE__ */ __name(function(match3, value3, shortNames, longNames) {
        return lookAhead(match3) ? longNames[value3] : shortNames[value3];
      }, "formatName"), output = "", literal = !1;
      if (date)
        for (iFormat = 0; iFormat < format2.length; iFormat++)
          if (literal)
            format2.charAt(iFormat) === "'" && !lookAhead("'") ? literal = !1 : output += format2.charAt(iFormat);
          else
            switch (format2.charAt(iFormat)) {
              case "d":
                output += formatNumber("d", date.getDate(), 2);
                break;
              case "D":
                output += formatName2("D", date.getDay(), dayNamesShort, dayNames);
                break;
              case "o":
                output += formatNumber(
                  "o",
                  Math.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 864e5),
                  3
                );
                break;
              case "m":
                output += formatNumber("m", date.getMonth() + 1, 2);
                break;
              case "M":
                output += formatName2("M", date.getMonth(), monthNamesShort, monthNames);
                break;
              case "y":
                output += lookAhead("y") ? date.getFullYear() : (date.getFullYear() % 100 < 10 ? "0" : "") + date.getFullYear() % 100;
                break;
              case "@":
                output += date.getTime();
                break;
              case "!":
                output += date.getTime() * 1e4 + this._ticksTo1970;
                break;
              case "'":
                lookAhead("'") ? output += "'" : literal = !0;
                break;
              default:
                output += format2.charAt(iFormat);
            }
      return output;
    }, "formatDate"),
    /* Extract all possible characters from the date format. */
    _possibleChars: /* @__PURE__ */ __name(function(format2) {
      var iFormat, chars = "", literal = !1, lookAhead = /* @__PURE__ */ __name(function(match3) {
        var matches4 = iFormat + 1 < format2.length && format2.charAt(iFormat + 1) === match3;
        return matches4 && iFormat++, matches4;
      }, "lookAhead");
      for (iFormat = 0; iFormat < format2.length; iFormat++)
        if (literal)
          format2.charAt(iFormat) === "'" && !lookAhead("'") ? literal = !1 : chars += format2.charAt(iFormat);
        else
          switch (format2.charAt(iFormat)) {
            case "d":
            case "m":
            case "y":
            case "@":
              chars += "0123456789";
              break;
            case "D":
            case "M":
              return null;
            case "'":
              lookAhead("'") ? chars += "'" : literal = !0;
              break;
            default:
              chars += format2.charAt(iFormat);
          }
      return chars;
    }, "_possibleChars"),
    /* Get a setting value, defaulting if necessary. */
    _get: /* @__PURE__ */ __name(function(inst, name2) {
      return inst.settings[name2] !== void 0 ? inst.settings[name2] : this._defaults[name2];
    }, "_get"),
    /* Parse existing date and initialise date picker. */
    _setDateFromField: /* @__PURE__ */ __name(function(inst, noDefault) {
      if (inst.input.val() !== inst.lastVal) {
        var dateFormat = this._get(inst, "dateFormat"), dates = inst.lastVal = inst.input ? inst.input.val() : null, defaultDate = this._getDefaultDate(inst), date = defaultDate, settings = this._getFormatConfig(inst);
        try {
          date = this.parseDate(dateFormat, dates, settings) || defaultDate;
        } catch {
          dates = noDefault ? "" : dates;
        }
        inst.selectedDay = date.getDate(), inst.drawMonth = inst.selectedMonth = date.getMonth(), inst.drawYear = inst.selectedYear = date.getFullYear(), inst.currentDay = dates ? date.getDate() : 0, inst.currentMonth = dates ? date.getMonth() : 0, inst.currentYear = dates ? date.getFullYear() : 0, this._adjustInstDate(inst);
      }
    }, "_setDateFromField"),
    /* Retrieve the default date shown on opening. */
    _getDefaultDate: /* @__PURE__ */ __name(function(inst) {
      return this._restrictMinMax(
        inst,
        this._determineDate(inst, this._get(inst, "defaultDate"), /* @__PURE__ */ new Date())
      );
    }, "_getDefaultDate"),
    /* A date may be specified as an exact value or a relative one. */
    _determineDate: /* @__PURE__ */ __name(function(inst, date, defaultDate) {
      var offsetNumeric = /* @__PURE__ */ __name(function(offset3) {
        var date2 = /* @__PURE__ */ new Date();
        return date2.setDate(date2.getDate() + offset3), date2;
      }, "offsetNumeric"), offsetString = /* @__PURE__ */ __name(function(offset3) {
        try {
          return $2.datepicker.parseDate(
            $2.datepicker._get(inst, "dateFormat"),
            offset3,
            $2.datepicker._getFormatConfig(inst)
          );
        } catch {
        }
        for (var date2 = (offset3.toLowerCase().match(/^c/) ? $2.datepicker._getDate(inst) : null) || /* @__PURE__ */ new Date(), year = date2.getFullYear(), month = date2.getMonth(), day = date2.getDate(), pattern = /([+\-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g, matches4 = pattern.exec(offset3); matches4; ) {
          switch (matches4[2] || "d") {
            case "d":
            case "D":
              day += parseInt(matches4[1], 10);
              break;
            case "w":
            case "W":
              day += parseInt(matches4[1], 10) * 7;
              break;
            case "m":
            case "M":
              month += parseInt(matches4[1], 10), day = Math.min(day, $2.datepicker._getDaysInMonth(year, month));
              break;
            case "y":
            case "Y":
              year += parseInt(matches4[1], 10), day = Math.min(day, $2.datepicker._getDaysInMonth(year, month));
              break;
          }
          matches4 = pattern.exec(offset3);
        }
        return new Date(year, month, day);
      }, "offsetString"), newDate = date == null || date === "" ? defaultDate : typeof date == "string" ? offsetString(date) : typeof date == "number" ? isNaN(date) ? defaultDate : offsetNumeric(date) : new Date(date.getTime());
      return newDate = newDate && newDate.toString() === "Invalid Date" ? defaultDate : newDate, newDate && (newDate.setHours(0), newDate.setMinutes(0), newDate.setSeconds(0), newDate.setMilliseconds(0)), this._daylightSavingAdjust(newDate);
    }, "_determineDate"),
    /* Handle switch to/from daylight saving.
     * Hours may be non-zero on daylight saving cut-over:
     * > 12 when midnight changeover, but then cannot generate
     * midnight datetime, so jump to 1AM, otherwise reset.
     * @param  date  (Date) the date to check
     * @return  (Date) the corrected date
     */
    _daylightSavingAdjust: /* @__PURE__ */ __name(function(date) {
      return date ? (date.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0), date) : null;
    }, "_daylightSavingAdjust"),
    /* Set the date(s) directly. */
    _setDate: /* @__PURE__ */ __name(function(inst, date, noChange) {
      var clear3 = !date, origMonth = inst.selectedMonth, origYear = inst.selectedYear, newDate = this._restrictMinMax(inst, this._determineDate(inst, date, /* @__PURE__ */ new Date()));
      inst.selectedDay = inst.currentDay = newDate.getDate(), inst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth(), inst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear(), (origMonth !== inst.selectedMonth || origYear !== inst.selectedYear) && !noChange && this._notifyChange(inst), this._adjustInstDate(inst), inst.input && inst.input.val(clear3 ? "" : this._formatDate(inst));
    }, "_setDate"),
    /* Retrieve the date(s) directly. */
    _getDate: /* @__PURE__ */ __name(function(inst) {
      var startDate = !inst.currentYear || inst.input && inst.input.val() === "" ? null : this._daylightSavingAdjust(new Date(
        inst.currentYear,
        inst.currentMonth,
        inst.currentDay
      ));
      return startDate;
    }, "_getDate"),
    /* Attach the onxxx handlers.  These are declared statically so
     * they work with static code transformers like Caja.
     */
    _attachHandlers: /* @__PURE__ */ __name(function(inst) {
      var stepMonths = this._get(inst, "stepMonths"), id2 = "#" + inst.id.replace(/\\\\/g, "\\");
      inst.dpDiv.find("[data-handler]").map(function() {
        var handler4 = {
          prev: /* @__PURE__ */ __name(function() {
            $2.datepicker._adjustDate(id2, -stepMonths, "M");
          }, "prev"),
          next: /* @__PURE__ */ __name(function() {
            $2.datepicker._adjustDate(id2, +stepMonths, "M");
          }, "next"),
          hide: /* @__PURE__ */ __name(function() {
            $2.datepicker._hideDatepicker();
          }, "hide"),
          today: /* @__PURE__ */ __name(function() {
            $2.datepicker._gotoToday(id2);
          }, "today"),
          selectDay: /* @__PURE__ */ __name(function() {
            return $2.datepicker._selectDay(id2, +this.getAttribute("data-month"), +this.getAttribute("data-year"), this), !1;
          }, "selectDay"),
          selectMonth: /* @__PURE__ */ __name(function() {
            return $2.datepicker._selectMonthYear(id2, this, "M"), !1;
          }, "selectMonth"),
          selectYear: /* @__PURE__ */ __name(function() {
            return $2.datepicker._selectMonthYear(id2, this, "Y"), !1;
          }, "selectYear")
        };
        $2(this).on(this.getAttribute("data-event"), handler4[this.getAttribute("data-handler")]);
      });
    }, "_attachHandlers"),
    /* Generate the HTML for the current state of the date picker. */
    _generateHTML: /* @__PURE__ */ __name(function(inst) {
      var maxDraw, prevText, prev2, nextText, next3, currentText, gotoDate, controls, buttonPanel, firstDay, showWeek, dayNames, dayNamesMin, monthNames, monthNamesShort, beforeShowDay, showOtherMonths, selectOtherMonths, defaultDate, html2, dow, row, group, col, selectedDate2, cornerClass, calender, thead, day, daysInMonth, leadDays, curRows, numRows, printDate, dRow, tbody, daySettings, otherMonth, unselectable, tempDate = /* @__PURE__ */ new Date(), today = this._daylightSavingAdjust(
        new Date(tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate())
      ), isRTL3 = this._get(inst, "isRTL"), showButtonPanel = this._get(inst, "showButtonPanel"), hideIfNoPrevNext = this._get(inst, "hideIfNoPrevNext"), navigationAsDateFormat = this._get(inst, "navigationAsDateFormat"), numMonths = this._getNumberOfMonths(inst), showCurrentAtPos = this._get(inst, "showCurrentAtPos"), stepMonths = this._get(inst, "stepMonths"), isMultiMonth = numMonths[0] !== 1 || numMonths[1] !== 1, currentDate = this._daylightSavingAdjust(inst.currentDay ? new Date(inst.currentYear, inst.currentMonth, inst.currentDay) : new Date(9999, 9, 9)), minDate = this._getMinMaxDate(inst, "min"), maxDate = this._getMinMaxDate(inst, "max"), drawMonth = inst.drawMonth - showCurrentAtPos, drawYear = inst.drawYear;
      if (drawMonth < 0 && (drawMonth += 12, drawYear--), maxDate)
        for (maxDraw = this._daylightSavingAdjust(new Date(
          maxDate.getFullYear(),
          maxDate.getMonth() - numMonths[0] * numMonths[1] + 1,
          maxDate.getDate()
        )), maxDraw = minDate && maxDraw < minDate ? minDate : maxDraw; this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw; )
          drawMonth--, drawMonth < 0 && (drawMonth = 11, drawYear--);
      for (inst.drawMonth = drawMonth, inst.drawYear = drawYear, prevText = this._get(inst, "prevText"), prevText = navigationAsDateFormat ? this.formatDate(
        prevText,
        this._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)),
        this._getFormatConfig(inst)
      ) : prevText, this._canAdjustMonth(inst, -1, drawYear, drawMonth) ? prev2 = $2("<a>").attr({
        class: "ui-datepicker-prev ui-corner-all",
        "data-handler": "prev",
        "data-event": "click",
        title: prevText
      }).append(
        $2("<span>").addClass("ui-icon ui-icon-circle-triangle-" + (isRTL3 ? "e" : "w")).text(prevText)
      )[0].outerHTML : hideIfNoPrevNext ? prev2 = "" : prev2 = $2("<a>").attr({
        class: "ui-datepicker-prev ui-corner-all ui-state-disabled",
        title: prevText
      }).append(
        $2("<span>").addClass("ui-icon ui-icon-circle-triangle-" + (isRTL3 ? "e" : "w")).text(prevText)
      )[0].outerHTML, nextText = this._get(inst, "nextText"), nextText = navigationAsDateFormat ? this.formatDate(
        nextText,
        this._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)),
        this._getFormatConfig(inst)
      ) : nextText, this._canAdjustMonth(inst, 1, drawYear, drawMonth) ? next3 = $2("<a>").attr({
        class: "ui-datepicker-next ui-corner-all",
        "data-handler": "next",
        "data-event": "click",
        title: nextText
      }).append(
        $2("<span>").addClass("ui-icon ui-icon-circle-triangle-" + (isRTL3 ? "w" : "e")).text(nextText)
      )[0].outerHTML : hideIfNoPrevNext ? next3 = "" : next3 = $2("<a>").attr({
        class: "ui-datepicker-next ui-corner-all ui-state-disabled",
        title: nextText
      }).append(
        $2("<span>").attr("class", "ui-icon ui-icon-circle-triangle-" + (isRTL3 ? "w" : "e")).text(nextText)
      )[0].outerHTML, currentText = this._get(inst, "currentText"), gotoDate = this._get(inst, "gotoCurrent") && inst.currentDay ? currentDate : today, currentText = navigationAsDateFormat ? this.formatDate(currentText, gotoDate, this._getFormatConfig(inst)) : currentText, controls = "", inst.inline || (controls = $2("<button>").attr({
        type: "button",
        class: "ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all",
        "data-handler": "hide",
        "data-event": "click"
      }).text(this._get(inst, "closeText"))[0].outerHTML), buttonPanel = "", showButtonPanel && (buttonPanel = $2("<div class='ui-datepicker-buttonpane ui-widget-content'>").append(isRTL3 ? controls : "").append(this._isInRange(inst, gotoDate) ? $2("<button>").attr({
        type: "button",
        class: "ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all",
        "data-handler": "today",
        "data-event": "click"
      }).text(currentText) : "").append(isRTL3 ? "" : controls)[0].outerHTML), firstDay = parseInt(this._get(inst, "firstDay"), 10), firstDay = isNaN(firstDay) ? 0 : firstDay, showWeek = this._get(inst, "showWeek"), dayNames = this._get(inst, "dayNames"), dayNamesMin = this._get(inst, "dayNamesMin"), monthNames = this._get(inst, "monthNames"), monthNamesShort = this._get(inst, "monthNamesShort"), beforeShowDay = this._get(inst, "beforeShowDay"), showOtherMonths = this._get(inst, "showOtherMonths"), selectOtherMonths = this._get(inst, "selectOtherMonths"), defaultDate = this._getDefaultDate(inst), html2 = "", row = 0; row < numMonths[0]; row++) {
        for (group = "", this.maxRows = 4, col = 0; col < numMonths[1]; col++) {
          if (selectedDate2 = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay)), cornerClass = " ui-corner-all", calender = "", isMultiMonth) {
            if (calender += "<div class='ui-datepicker-group", numMonths[1] > 1)
              switch (col) {
                case 0:
                  calender += " ui-datepicker-group-first", cornerClass = " ui-corner-" + (isRTL3 ? "right" : "left");
                  break;
                case numMonths[1] - 1:
                  calender += " ui-datepicker-group-last", cornerClass = " ui-corner-" + (isRTL3 ? "left" : "right");
                  break;
                default:
                  calender += " ui-datepicker-group-middle", cornerClass = "";
                  break;
              }
            calender += "'>";
          }
          for (calender += "<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix" + cornerClass + "'>" + (/all|left/.test(cornerClass) && row === 0 ? isRTL3 ? next3 : prev2 : "") + (/all|right/.test(cornerClass) && row === 0 ? isRTL3 ? prev2 : next3 : "") + this._generateMonthYearHeader(
            inst,
            drawMonth,
            drawYear,
            minDate,
            maxDate,
            row > 0 || col > 0,
            monthNames,
            monthNamesShort
          ) + // draw month headers
          "</div><table class='ui-datepicker-calendar'><thead><tr>", thead = showWeek ? "<th class='ui-datepicker-week-col'>" + this._get(inst, "weekHeader") + "</th>" : "", dow = 0; dow < 7; dow++)
            day = (dow + firstDay) % 7, thead += "<th scope='col'" + ((dow + firstDay + 6) % 7 >= 5 ? " class='ui-datepicker-week-end'" : "") + "><span title='" + dayNames[day] + "'>" + dayNamesMin[day] + "</span></th>";
          for (calender += thead + "</tr></thead><tbody>", daysInMonth = this._getDaysInMonth(drawYear, drawMonth), drawYear === inst.selectedYear && drawMonth === inst.selectedMonth && (inst.selectedDay = Math.min(inst.selectedDay, daysInMonth)), leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7, curRows = Math.ceil((leadDays + daysInMonth) / 7), numRows = isMultiMonth && this.maxRows > curRows ? this.maxRows : curRows, this.maxRows = numRows, printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays)), dRow = 0; dRow < numRows; dRow++) {
            for (calender += "<tr>", tbody = showWeek ? "<td class='ui-datepicker-week-col'>" + this._get(inst, "calculateWeek")(printDate) + "</td>" : "", dow = 0; dow < 7; dow++)
              daySettings = beforeShowDay ? beforeShowDay.apply(inst.input ? inst.input[0] : null, [printDate]) : [!0, ""], otherMonth = printDate.getMonth() !== drawMonth, unselectable = otherMonth && !selectOtherMonths || !daySettings[0] || minDate && printDate < minDate || maxDate && printDate > maxDate, tbody += "<td class='" + ((dow + firstDay + 6) % 7 >= 5 ? " ui-datepicker-week-end" : "") + // highlight weekends
              (otherMonth ? " ui-datepicker-other-month" : "") + // highlight days from other months
              (printDate.getTime() === selectedDate2.getTime() && drawMonth === inst.selectedMonth && inst._keyEvent || // user pressed key
              defaultDate.getTime() === printDate.getTime() && defaultDate.getTime() === selectedDate2.getTime() ? (
                // or defaultDate is current printedDate and defaultDate is selectedDate
                " " + this._dayOverClass
              ) : "") + // highlight selected day
              (unselectable ? " " + this._unselectableClass + " ui-state-disabled" : "") + // highlight unselectable days
              (otherMonth && !showOtherMonths ? "" : " " + daySettings[1] + // highlight custom dates
              (printDate.getTime() === currentDate.getTime() ? " " + this._currentClass : "") + // highlight selected day
              (printDate.getTime() === today.getTime() ? " ui-datepicker-today" : "")) + "'" + // highlight today (if different)
              ((!otherMonth || showOtherMonths) && daySettings[2] ? " title='" + daySettings[2].replace(/'/g, "&#39;") + "'" : "") + // cell title
              (unselectable ? "" : " data-handler='selectDay' data-event='click' data-month='" + printDate.getMonth() + "' data-year='" + printDate.getFullYear() + "'") + ">" + // actions
              (otherMonth && !showOtherMonths ? "&#xa0;" : (
                // display for other months
                unselectable ? "<span class='ui-state-default'>" + printDate.getDate() + "</span>" : "<a class='ui-state-default" + (printDate.getTime() === today.getTime() ? " ui-state-highlight" : "") + (printDate.getTime() === currentDate.getTime() ? " ui-state-active" : "") + // highlight selected day
                (otherMonth ? " ui-priority-secondary" : "") + // distinguish dates from other months
                "' href='#' aria-current='" + (printDate.getTime() === currentDate.getTime() ? "true" : "false") + // mark date as selected for screen reader
                "' data-date='" + printDate.getDate() + // store date as data
                "'>" + printDate.getDate() + "</a>"
              )) + "</td>", printDate.setDate(printDate.getDate() + 1), printDate = this._daylightSavingAdjust(printDate);
            calender += tbody + "</tr>";
          }
          drawMonth++, drawMonth > 11 && (drawMonth = 0, drawYear++), calender += "</tbody></table>" + (isMultiMonth ? "</div>" + (numMonths[0] > 0 && col === numMonths[1] - 1 ? "<div class='ui-datepicker-row-break'></div>" : "") : ""), group += calender;
        }
        html2 += group;
      }
      return html2 += buttonPanel, inst._keyEvent = !1, html2;
    }, "_generateHTML"),
    /* Generate the month and year header. */
    _generateMonthYearHeader: /* @__PURE__ */ __name(function(inst, drawMonth, drawYear, minDate, maxDate, secondary, monthNames, monthNamesShort) {
      var inMinYear, inMaxYear, month, years, thisYear, determineYear, year, endYear, changeMonth = this._get(inst, "changeMonth"), changeYear = this._get(inst, "changeYear"), showMonthAfterYear = this._get(inst, "showMonthAfterYear"), selectMonthLabel = this._get(inst, "selectMonthLabel"), selectYearLabel = this._get(inst, "selectYearLabel"), html2 = "<div class='ui-datepicker-title'>", monthHtml = "";
      if (secondary || !changeMonth)
        monthHtml += "<span class='ui-datepicker-month'>" + monthNames[drawMonth] + "</span>";
      else {
        for (inMinYear = minDate && minDate.getFullYear() === drawYear, inMaxYear = maxDate && maxDate.getFullYear() === drawYear, monthHtml += "<select class='ui-datepicker-month' aria-label='" + selectMonthLabel + "' data-handler='selectMonth' data-event='change'>", month = 0; month < 12; month++)
          (!inMinYear || month >= minDate.getMonth()) && (!inMaxYear || month <= maxDate.getMonth()) && (monthHtml += "<option value='" + month + "'" + (month === drawMonth ? " selected='selected'" : "") + ">" + monthNamesShort[month] + "</option>");
        monthHtml += "</select>";
      }
      if (showMonthAfterYear || (html2 += monthHtml + (secondary || !(changeMonth && changeYear) ? "&#xa0;" : "")), !inst.yearshtml)
        if (inst.yearshtml = "", secondary || !changeYear)
          html2 += "<span class='ui-datepicker-year'>" + drawYear + "</span>";
        else {
          for (years = this._get(inst, "yearRange").split(":"), thisYear = (/* @__PURE__ */ new Date()).getFullYear(), determineYear = /* @__PURE__ */ __name(function(value3) {
            var year2 = value3.match(/c[+\-].*/) ? drawYear + parseInt(value3.substring(1), 10) : value3.match(/[+\-].*/) ? thisYear + parseInt(value3, 10) : parseInt(value3, 10);
            return isNaN(year2) ? thisYear : year2;
          }, "determineYear"), year = determineYear(years[0]), endYear = Math.max(year, determineYear(years[1] || "")), year = minDate ? Math.max(year, minDate.getFullYear()) : year, endYear = maxDate ? Math.min(endYear, maxDate.getFullYear()) : endYear, inst.yearshtml += "<select class='ui-datepicker-year' aria-label='" + selectYearLabel + "' data-handler='selectYear' data-event='change'>"; year <= endYear; year++)
            inst.yearshtml += "<option value='" + year + "'" + (year === drawYear ? " selected='selected'" : "") + ">" + year + "</option>";
          inst.yearshtml += "</select>", html2 += inst.yearshtml, inst.yearshtml = null;
        }
      return html2 += this._get(inst, "yearSuffix"), showMonthAfterYear && (html2 += (secondary || !(changeMonth && changeYear) ? "&#xa0;" : "") + monthHtml), html2 += "</div>", html2;
    }, "_generateMonthYearHeader"),
    /* Adjust one of the date sub-fields. */
    _adjustInstDate: /* @__PURE__ */ __name(function(inst, offset3, period) {
      var year = inst.selectedYear + (period === "Y" ? offset3 : 0), month = inst.selectedMonth + (period === "M" ? offset3 : 0), day = Math.min(inst.selectedDay, this._getDaysInMonth(year, month)) + (period === "D" ? offset3 : 0), date = this._restrictMinMax(inst, this._daylightSavingAdjust(new Date(year, month, day)));
      inst.selectedDay = date.getDate(), inst.drawMonth = inst.selectedMonth = date.getMonth(), inst.drawYear = inst.selectedYear = date.getFullYear(), (period === "M" || period === "Y") && this._notifyChange(inst);
    }, "_adjustInstDate"),
    /* Ensure a date is within any min/max bounds. */
    _restrictMinMax: /* @__PURE__ */ __name(function(inst, date) {
      var minDate = this._getMinMaxDate(inst, "min"), maxDate = this._getMinMaxDate(inst, "max"), newDate = minDate && date < minDate ? minDate : date;
      return maxDate && newDate > maxDate ? maxDate : newDate;
    }, "_restrictMinMax"),
    /* Notify change of month/year. */
    _notifyChange: /* @__PURE__ */ __name(function(inst) {
      var onChange4 = this._get(inst, "onChangeMonthYear");
      onChange4 && onChange4.apply(
        inst.input ? inst.input[0] : null,
        [inst.selectedYear, inst.selectedMonth + 1, inst]
      );
    }, "_notifyChange"),
    /* Determine the number of months to show. */
    _getNumberOfMonths: /* @__PURE__ */ __name(function(inst) {
      var numMonths = this._get(inst, "numberOfMonths");
      return numMonths == null ? [1, 1] : typeof numMonths == "number" ? [1, numMonths] : numMonths;
    }, "_getNumberOfMonths"),
    /* Determine the current maximum date - ensure no time components are set. */
    _getMinMaxDate: /* @__PURE__ */ __name(function(inst, minMax) {
      return this._determineDate(inst, this._get(inst, minMax + "Date"), null);
    }, "_getMinMaxDate"),
    /* Find the number of days in a given month. */
    _getDaysInMonth: /* @__PURE__ */ __name(function(year, month) {
      return 32 - this._daylightSavingAdjust(new Date(year, month, 32)).getDate();
    }, "_getDaysInMonth"),
    /* Find the day of the week of the first of a month. */
    _getFirstDayOfMonth: /* @__PURE__ */ __name(function(year, month) {
      return new Date(year, month, 1).getDay();
    }, "_getFirstDayOfMonth"),
    /* Determines if we should allow a "next/prev" month display change. */
    _canAdjustMonth: /* @__PURE__ */ __name(function(inst, offset3, curYear, curMonth) {
      var numMonths = this._getNumberOfMonths(inst), date = this._daylightSavingAdjust(new Date(
        curYear,
        curMonth + (offset3 < 0 ? offset3 : numMonths[0] * numMonths[1]),
        1
      ));
      return offset3 < 0 && date.setDate(this._getDaysInMonth(date.getFullYear(), date.getMonth())), this._isInRange(inst, date);
    }, "_canAdjustMonth"),
    /* Is the given date in the accepted range? */
    _isInRange: /* @__PURE__ */ __name(function(inst, date) {
      var yearSplit, currentYear, minDate = this._getMinMaxDate(inst, "min"), maxDate = this._getMinMaxDate(inst, "max"), minYear = null, maxYear = null, years = this._get(inst, "yearRange");
      return years && (yearSplit = years.split(":"), currentYear = (/* @__PURE__ */ new Date()).getFullYear(), minYear = parseInt(yearSplit[0], 10), maxYear = parseInt(yearSplit[1], 10), yearSplit[0].match(/[+\-].*/) && (minYear += currentYear), yearSplit[1].match(/[+\-].*/) && (maxYear += currentYear)), (!minDate || date.getTime() >= minDate.getTime()) && (!maxDate || date.getTime() <= maxDate.getTime()) && (!minYear || date.getFullYear() >= minYear) && (!maxYear || date.getFullYear() <= maxYear);
    }, "_isInRange"),
    /* Provide the configuration settings for formatting/parsing. */
    _getFormatConfig: /* @__PURE__ */ __name(function(inst) {
      var shortYearCutoff = this._get(inst, "shortYearCutoff");
      return shortYearCutoff = typeof shortYearCutoff != "string" ? shortYearCutoff : (/* @__PURE__ */ new Date()).getFullYear() % 100 + parseInt(shortYearCutoff, 10), {
        shortYearCutoff,
        dayNamesShort: this._get(inst, "dayNamesShort"),
        dayNames: this._get(inst, "dayNames"),
        monthNamesShort: this._get(inst, "monthNamesShort"),
        monthNames: this._get(inst, "monthNames")
      };
    }, "_getFormatConfig"),
    /* Format the given date for display. */
    _formatDate: /* @__PURE__ */ __name(function(inst, day, month, year) {
      day || (inst.currentDay = inst.selectedDay, inst.currentMonth = inst.selectedMonth, inst.currentYear = inst.selectedYear);
      var date = day ? typeof day == "object" ? day : this._daylightSavingAdjust(new Date(year, month, day)) : this._daylightSavingAdjust(new Date(inst.currentYear, inst.currentMonth, inst.currentDay));
      return this.formatDate(this._get(inst, "dateFormat"), date, this._getFormatConfig(inst));
    }, "_formatDate")
  });
  function datepicker_bindHover(dpDiv) {
    var selector = "button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a";
    return dpDiv.on("mouseout", selector, function() {
      $2(this).removeClass("ui-state-hover"), this.className.indexOf("ui-datepicker-prev") !== -1 && $2(this).removeClass("ui-datepicker-prev-hover"), this.className.indexOf("ui-datepicker-next") !== -1 && $2(this).removeClass("ui-datepicker-next-hover");
    }).on("mouseover", selector, datepicker_handleMouseover);
  }
  __name(datepicker_bindHover, "datepicker_bindHover");
  function datepicker_handleMouseover() {
    $2.datepicker._isDisabledDatepicker(datepicker_instActive.inline ? datepicker_instActive.dpDiv.parent()[0] : datepicker_instActive.input[0]) || ($2(this).parents(".ui-datepicker-calendar").find("a").removeClass("ui-state-hover"), $2(this).addClass("ui-state-hover"), this.className.indexOf("ui-datepicker-prev") !== -1 && $2(this).addClass("ui-datepicker-prev-hover"), this.className.indexOf("ui-datepicker-next") !== -1 && $2(this).addClass("ui-datepicker-next-hover"));
  }
  __name(datepicker_handleMouseover, "datepicker_handleMouseover");
  function datepicker_extendRemove(target2, props2) {
    $2.extend(target2, props2);
    for (var name2 in props2)
      props2[name2] == null && (target2[name2] = props2[name2]);
    return target2;
  }
  __name(datepicker_extendRemove, "datepicker_extendRemove"), $2.fn.datepicker = function(options2) {
    if (!this.length)
      return this;
    $2.datepicker.initialized || ($2(document).on("mousedown", $2.datepicker._checkExternalClick), $2.datepicker.initialized = !0), $2("#" + $2.datepicker._mainDivId).length === 0 && $2("body").append($2.datepicker.dpDiv);
    var otherArgs = Array.prototype.slice.call(arguments, 1);
    return typeof options2 == "string" && (options2 === "isDisabled" || options2 === "getDate" || options2 === "widget") ? $2.datepicker["_" + options2 + "Datepicker"].apply($2.datepicker, [this[0]].concat(otherArgs)) : options2 === "option" && arguments.length === 2 && typeof arguments[1] == "string" ? $2.datepicker["_" + options2 + "Datepicker"].apply($2.datepicker, [this[0]].concat(otherArgs)) : this.each(function() {
      typeof options2 == "string" ? $2.datepicker["_" + options2 + "Datepicker"].apply($2.datepicker, [this].concat(otherArgs)) : $2.datepicker._attachDatepicker(this, options2);
    });
  }, $2.datepicker = new Datepicker(), $2.datepicker.initialized = !1, $2.datepicker.uuid = (/* @__PURE__ */ new Date()).getTime(), $2.datepicker.version = "1.14.1", $2.datepicker;
  /*!
   * jQuery UI Mouse 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  var mouseHandled = !1;
  $2(document).on("mouseup", function() {
    mouseHandled = !1;
  }), $2.widget("ui.mouse", {
    version: "1.14.1",
    options: {
      cancel: "input, textarea, button, select, option",
      distance: 1,
      delay: 0
    },
    _mouseInit: /* @__PURE__ */ __name(function() {
      var that = this;
      this.element.on("mousedown." + this.widgetName, function(event2) {
        return that._mouseDown(event2);
      }).on("click." + this.widgetName, function(event2) {
        if ($2.data(event2.target, that.widgetName + ".preventClickEvent") === !0)
          return $2.removeData(event2.target, that.widgetName + ".preventClickEvent"), event2.stopImmediatePropagation(), !1;
      }), this.started = !1;
    }, "_mouseInit"),
    // TODO: make sure destroying one instance of mouse doesn't mess with
    // other instances of mouse
    _mouseDestroy: /* @__PURE__ */ __name(function() {
      this.element.off("." + this.widgetName), this._mouseMoveDelegate && this.document.off("mousemove." + this.widgetName, this._mouseMoveDelegate).off("mouseup." + this.widgetName, this._mouseUpDelegate);
    }, "_mouseDestroy"),
    _mouseDown: /* @__PURE__ */ __name(function(event2) {
      if (!mouseHandled) {
        this._mouseMoved = !1, this._mouseStarted && this._mouseUp(event2), this._mouseDownEvent = event2;
        var that = this, btnIsLeft = event2.which === 1, elIsCancel = typeof this.options.cancel == "string" ? $2(event2.target).closest(this.options.cancel).length : !1;
        return !btnIsLeft || elIsCancel || !this._mouseCapture(event2) ? !0 : (this.mouseDelayMet = !this.options.delay, this.mouseDelayMet || (this._mouseDelayTimer = setTimeout(function() {
          that.mouseDelayMet = !0;
        }, this.options.delay)), this._mouseDistanceMet(event2) && this._mouseDelayMet(event2) && (this._mouseStarted = this._mouseStart(event2) !== !1, !this._mouseStarted) ? (event2.preventDefault(), !0) : ($2.data(event2.target, this.widgetName + ".preventClickEvent") === !0 && $2.removeData(event2.target, this.widgetName + ".preventClickEvent"), this._mouseMoveDelegate = function(event3) {
          return that._mouseMove(event3);
        }, this._mouseUpDelegate = function(event3) {
          return that._mouseUp(event3);
        }, this.document.on("mousemove." + this.widgetName, this._mouseMoveDelegate).on("mouseup." + this.widgetName, this._mouseUpDelegate), event2.preventDefault(), mouseHandled = !0, !0));
      }
    }, "_mouseDown"),
    _mouseMove: /* @__PURE__ */ __name(function(event2) {
      if (this._mouseMoved && !event2.which) {
        if (event2.originalEvent.altKey || event2.originalEvent.ctrlKey || event2.originalEvent.metaKey || event2.originalEvent.shiftKey)
          this.ignoreMissingWhich = !0;
        else if (!this.ignoreMissingWhich)
          return this._mouseUp(event2);
      }
      return (event2.which || event2.button) && (this._mouseMoved = !0), this._mouseStarted ? (this._mouseDrag(event2), event2.preventDefault()) : (this._mouseDistanceMet(event2) && this._mouseDelayMet(event2) && (this._mouseStarted = this._mouseStart(this._mouseDownEvent, event2) !== !1, this._mouseStarted ? this._mouseDrag(event2) : this._mouseUp(event2)), !this._mouseStarted);
    }, "_mouseMove"),
    _mouseUp: /* @__PURE__ */ __name(function(event2) {
      this.document.off("mousemove." + this.widgetName, this._mouseMoveDelegate).off("mouseup." + this.widgetName, this._mouseUpDelegate), this._mouseStarted && (this._mouseStarted = !1, event2.target === this._mouseDownEvent.target && $2.data(event2.target, this.widgetName + ".preventClickEvent", !0), this._mouseStop(event2)), this._mouseDelayTimer && (clearTimeout(this._mouseDelayTimer), delete this._mouseDelayTimer), this.ignoreMissingWhich = !1, mouseHandled = !1, event2.preventDefault();
    }, "_mouseUp"),
    _mouseDistanceMet: /* @__PURE__ */ __name(function(event2) {
      return Math.max(
        Math.abs(this._mouseDownEvent.pageX - event2.pageX),
        Math.abs(this._mouseDownEvent.pageY - event2.pageY)
      ) >= this.options.distance;
    }, "_mouseDistanceMet"),
    _mouseDelayMet: /* @__PURE__ */ __name(function() {
      return this.mouseDelayMet;
    }, "_mouseDelayMet"),
    // These are placeholder methods, to be overriden by extending plugin
    _mouseStart: /* @__PURE__ */ __name(function() {
    }, "_mouseStart"),
    _mouseDrag: /* @__PURE__ */ __name(function() {
    }, "_mouseDrag"),
    _mouseStop: /* @__PURE__ */ __name(function() {
    }, "_mouseStop"),
    _mouseCapture: /* @__PURE__ */ __name(function() {
      return !0;
    }, "_mouseCapture")
  }), $2.ui.plugin = {
    add: /* @__PURE__ */ __name(function(module2, option2, set6) {
      var i, proto = $2.ui[module2].prototype;
      for (i in set6)
        proto.plugins[i] = proto.plugins[i] || [], proto.plugins[i].push([option2, set6[i]]);
    }, "add"),
    call: /* @__PURE__ */ __name(function(instance, name2, args, allowDisconnected) {
      var i, set6 = instance.plugins[name2];
      if (set6 && !(!allowDisconnected && (!instance.element[0].parentNode || instance.element[0].parentNode.nodeType === 11)))
        for (i = 0; i < set6.length; i++)
          instance.options[set6[i][0]] && set6[i][1].apply(instance.element, args);
    }, "call")
  };
  /*!
   * jQuery UI Draggable 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.draggable", $2.ui.mouse, {
    version: "1.14.1",
    widgetEventPrefix: "drag",
    options: {
      addClasses: !0,
      appendTo: "parent",
      axis: !1,
      connectToSortable: !1,
      containment: !1,
      cursor: "auto",
      cursorAt: !1,
      grid: !1,
      handle: !1,
      helper: "original",
      iframeFix: !1,
      opacity: !1,
      refreshPositions: !1,
      revert: !1,
      revertDuration: 500,
      scope: "default",
      scroll: !0,
      scrollSensitivity: 20,
      scrollSpeed: 20,
      snap: !1,
      snapMode: "both",
      snapTolerance: 20,
      stack: !1,
      zIndex: !1,
      // Callbacks
      drag: null,
      start: null,
      stop: null
    },
    _create: /* @__PURE__ */ __name(function() {
      this.options.helper === "original" && this._setPositionRelative(), this.options.addClasses && this._addClass("ui-draggable"), this._setHandleClassName(), this._mouseInit();
    }, "_create"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      this._super(key, value3), key === "handle" && (this._removeHandleClassName(), this._setHandleClassName());
    }, "_setOption"),
    _destroy: /* @__PURE__ */ __name(function() {
      if ((this.helper || this.element).is(".ui-draggable-dragging")) {
        this.destroyOnClear = !0;
        return;
      }
      this._removeHandleClassName(), this._mouseDestroy();
    }, "_destroy"),
    _mouseCapture: /* @__PURE__ */ __name(function(event2) {
      var o = this.options;
      return this.helper || o.disabled || $2(event2.target).closest(".ui-resizable-handle").length > 0 || (this.handle = this._getHandle(event2), !this.handle) ? !1 : (this._blurActiveElement(event2), this._blockFrames(o.iframeFix === !0 ? "iframe" : o.iframeFix), !0);
    }, "_mouseCapture"),
    _blockFrames: /* @__PURE__ */ __name(function(selector) {
      this.iframeBlocks = this.document.find(selector).map(function() {
        var iframe = $2(this);
        return $2("<div>").css("position", "absolute").appendTo(iframe.parent()).outerWidth(iframe.outerWidth()).outerHeight(iframe.outerHeight()).offset(iframe.offset())[0];
      });
    }, "_blockFrames"),
    _unblockFrames: /* @__PURE__ */ __name(function() {
      this.iframeBlocks && (this.iframeBlocks.remove(), delete this.iframeBlocks);
    }, "_unblockFrames"),
    _blurActiveElement: /* @__PURE__ */ __name(function(event2) {
      var activeElement = this.document[0].activeElement, target2 = $2(event2.target);
      target2.closest(activeElement).length || $2(activeElement).trigger("blur");
    }, "_blurActiveElement"),
    _mouseStart: /* @__PURE__ */ __name(function(event2) {
      var o = this.options;
      return this.helper = this._createHelper(event2), this._addClass(this.helper, "ui-draggable-dragging"), this._cacheHelperProportions(), $2.ui.ddmanager && ($2.ui.ddmanager.current = this), this._cacheMargins(), this.cssPosition = this.helper.css("position"), this.scrollParent = this.helper.scrollParent(!0), this.offsetParent = this.helper.offsetParent(), this.hasFixedAncestor = this.helper.parents().filter(function() {
        return $2(this).css("position") === "fixed";
      }).length > 0, this.positionAbs = this.element.offset(), this._refreshOffsets(event2), this.originalPosition = this.position = this._generatePosition(event2, !1), this.originalPageX = event2.pageX, this.originalPageY = event2.pageY, o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt), this._setContainment(), this._trigger("start", event2) === !1 ? (this._clear(), !1) : (this._cacheHelperProportions(), $2.ui.ddmanager && !o.dropBehaviour && $2.ui.ddmanager.prepareOffsets(this, event2), this._mouseDrag(event2, !0), $2.ui.ddmanager && $2.ui.ddmanager.dragStart(this, event2), !0);
    }, "_mouseStart"),
    _refreshOffsets: /* @__PURE__ */ __name(function(event2) {
      this.offset = {
        top: this.positionAbs.top - this.margins.top,
        left: this.positionAbs.left - this.margins.left,
        scroll: !1,
        parent: this._getParentOffset(),
        relative: this._getRelativeOffset()
      }, this.offset.click = {
        left: event2.pageX - this.offset.left,
        top: event2.pageY - this.offset.top
      };
    }, "_refreshOffsets"),
    _mouseDrag: /* @__PURE__ */ __name(function(event2, noPropagation) {
      if (this.hasFixedAncestor && (this.offset.parent = this._getParentOffset()), this.position = this._generatePosition(event2, !0), this.positionAbs = this._convertPositionTo("absolute"), !noPropagation) {
        var ui = this._uiHash();
        if (this._trigger("drag", event2, ui) === !1)
          return this._mouseUp(new $2.Event("mouseup", event2)), !1;
        this.position = ui.position;
      }
      return this.helper[0].style.left = this.position.left + "px", this.helper[0].style.top = this.position.top + "px", $2.ui.ddmanager && $2.ui.ddmanager.drag(this, event2), !1;
    }, "_mouseDrag"),
    _mouseStop: /* @__PURE__ */ __name(function(event2) {
      var that = this, dropped = !1;
      return $2.ui.ddmanager && !this.options.dropBehaviour && (dropped = $2.ui.ddmanager.drop(this, event2)), this.dropped && (dropped = this.dropped, this.dropped = !1), this.options.revert === "invalid" && !dropped || this.options.revert === "valid" && dropped || this.options.revert === !0 || typeof this.options.revert == "function" && this.options.revert.call(this.element, dropped) ? $2(this.helper).animate(
        this.originalPosition,
        parseInt(this.options.revertDuration, 10),
        function() {
          that._trigger("stop", event2) !== !1 && that._clear();
        }
      ) : this._trigger("stop", event2) !== !1 && this._clear(), !1;
    }, "_mouseStop"),
    _mouseUp: /* @__PURE__ */ __name(function(event2) {
      return this._unblockFrames(), $2.ui.ddmanager && $2.ui.ddmanager.dragStop(this, event2), this.handleElement.is(event2.target) && this.element.trigger("focus"), $2.ui.mouse.prototype._mouseUp.call(this, event2);
    }, "_mouseUp"),
    cancel: /* @__PURE__ */ __name(function() {
      return this.helper.is(".ui-draggable-dragging") ? this._mouseUp(new $2.Event("mouseup", { target: this.element[0] })) : this._clear(), this;
    }, "cancel"),
    _getHandle: /* @__PURE__ */ __name(function(event2) {
      return this.options.handle ? !!$2(event2.target).closest(this.element.find(this.options.handle)).length : !0;
    }, "_getHandle"),
    _setHandleClassName: /* @__PURE__ */ __name(function() {
      this.handleElement = this.options.handle ? this.element.find(this.options.handle) : this.element, this._addClass(this.handleElement, "ui-draggable-handle");
    }, "_setHandleClassName"),
    _removeHandleClassName: /* @__PURE__ */ __name(function() {
      this._removeClass(this.handleElement, "ui-draggable-handle");
    }, "_removeHandleClassName"),
    _createHelper: /* @__PURE__ */ __name(function(event2) {
      var o = this.options, helperIsFunction = typeof o.helper == "function", helper = helperIsFunction ? $2(o.helper.apply(this.element[0], [event2])) : o.helper === "clone" ? this.element.clone().removeAttr("id") : this.element;
      return helper.parents("body").length || helper.appendTo(o.appendTo === "parent" ? this.element[0].parentNode : o.appendTo), helperIsFunction && helper[0] === this.element[0] && this._setPositionRelative(), helper[0] !== this.element[0] && !/(fixed|absolute)/.test(helper.css("position")) && helper.css("position", "absolute"), helper;
    }, "_createHelper"),
    _setPositionRelative: /* @__PURE__ */ __name(function() {
      /^(?:r|a|f)/.test(this.element.css("position")) || (this.element[0].style.position = "relative");
    }, "_setPositionRelative"),
    _adjustOffsetFromHelper: /* @__PURE__ */ __name(function(obj2) {
      typeof obj2 == "string" && (obj2 = obj2.split(" ")), Array.isArray(obj2) && (obj2 = { left: +obj2[0], top: +obj2[1] || 0 }), "left" in obj2 && (this.offset.click.left = obj2.left + this.margins.left), "right" in obj2 && (this.offset.click.left = this.helperProportions.width - obj2.right + this.margins.left), "top" in obj2 && (this.offset.click.top = obj2.top + this.margins.top), "bottom" in obj2 && (this.offset.click.top = this.helperProportions.height - obj2.bottom + this.margins.top);
    }, "_adjustOffsetFromHelper"),
    _isRootNode: /* @__PURE__ */ __name(function(element) {
      return /(html|body)/i.test(element.tagName) || element === this.document[0];
    }, "_isRootNode"),
    _getParentOffset: /* @__PURE__ */ __name(function() {
      var po = this.offsetParent.offset(), document2 = this.document[0];
      return this.cssPosition === "absolute" && this.scrollParent[0] !== document2 && $2.contains(this.scrollParent[0], this.offsetParent[0]) && (po.left += this.scrollParent.scrollLeft(), po.top += this.scrollParent.scrollTop()), this._isRootNode(this.offsetParent[0]) && (po = { top: 0, left: 0 }), {
        top: po.top + (parseInt(this.offsetParent.css("borderTopWidth"), 10) || 0),
        left: po.left + (parseInt(this.offsetParent.css("borderLeftWidth"), 10) || 0)
      };
    }, "_getParentOffset"),
    _getRelativeOffset: /* @__PURE__ */ __name(function() {
      if (this.cssPosition !== "relative")
        return { top: 0, left: 0 };
      var p = this.element.position(), scrollIsRootNode = this._isRootNode(this.scrollParent[0]);
      return {
        top: p.top - (parseInt(this.helper.css("top"), 10) || 0) + (scrollIsRootNode ? 0 : this.scrollParent.scrollTop()),
        left: p.left - (parseInt(this.helper.css("left"), 10) || 0) + (scrollIsRootNode ? 0 : this.scrollParent.scrollLeft())
      };
    }, "_getRelativeOffset"),
    _cacheMargins: /* @__PURE__ */ __name(function() {
      this.margins = {
        left: parseInt(this.element.css("marginLeft"), 10) || 0,
        top: parseInt(this.element.css("marginTop"), 10) || 0,
        right: parseInt(this.element.css("marginRight"), 10) || 0,
        bottom: parseInt(this.element.css("marginBottom"), 10) || 0
      };
    }, "_cacheMargins"),
    _cacheHelperProportions: /* @__PURE__ */ __name(function() {
      this.helperProportions = {
        width: this.helper.outerWidth(),
        height: this.helper.outerHeight()
      };
    }, "_cacheHelperProportions"),
    _setContainment: /* @__PURE__ */ __name(function() {
      var isUserScrollable, c, ce, o = this.options, document2 = this.document[0];
      if (this.relativeContainer = null, !o.containment) {
        this.containment = null;
        return;
      }
      if (o.containment === "window") {
        this.containment = [
          $2(window).scrollLeft() - this.offset.relative.left - this.offset.parent.left,
          $2(window).scrollTop() - this.offset.relative.top - this.offset.parent.top,
          $2(window).scrollLeft() + $2(window).width() - this.helperProportions.width - this.margins.left,
          $2(window).scrollTop() + ($2(window).height() || document2.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top
        ];
        return;
      }
      if (o.containment === "document") {
        this.containment = [
          0,
          0,
          $2(document2).width() - this.helperProportions.width - this.margins.left,
          ($2(document2).height() || document2.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top
        ];
        return;
      }
      if (o.containment.constructor === Array) {
        this.containment = o.containment;
        return;
      }
      o.containment === "parent" && (o.containment = this.helper[0].parentNode), c = $2(o.containment), ce = c[0], ce && (isUserScrollable = /(scroll|auto)/.test(c.css("overflow")), this.containment = [
        (parseInt(c.css("borderLeftWidth"), 10) || 0) + (parseInt(c.css("paddingLeft"), 10) || 0),
        (parseInt(c.css("borderTopWidth"), 10) || 0) + (parseInt(c.css("paddingTop"), 10) || 0),
        (isUserScrollable ? Math.max(ce.scrollWidth, ce.offsetWidth) : ce.offsetWidth) - (parseInt(c.css("borderRightWidth"), 10) || 0) - (parseInt(c.css("paddingRight"), 10) || 0) - this.helperProportions.width - this.margins.left - this.margins.right,
        (isUserScrollable ? Math.max(ce.scrollHeight, ce.offsetHeight) : ce.offsetHeight) - (parseInt(c.css("borderBottomWidth"), 10) || 0) - (parseInt(c.css("paddingBottom"), 10) || 0) - this.helperProportions.height - this.margins.top - this.margins.bottom
      ], this.relativeContainer = c);
    }, "_setContainment"),
    _convertPositionTo: /* @__PURE__ */ __name(function(d, pos) {
      pos || (pos = this.position);
      var mod = d === "absolute" ? 1 : -1, scrollIsRootNode = this._isRootNode(this.scrollParent[0]);
      return {
        top: (
          // The absolute mouse position
          pos.top + // Only for relative positioned nodes: Relative offset from element to offset parent
          this.offset.relative.top * mod + // The offsetParent's offset without borders (offset + border)
          this.offset.parent.top * mod - (this.cssPosition === "fixed" ? -this.offset.scroll.top : scrollIsRootNode ? 0 : this.offset.scroll.top) * mod
        ),
        left: (
          // The absolute mouse position
          pos.left + // Only for relative positioned nodes: Relative offset from element to offset parent
          this.offset.relative.left * mod + // The offsetParent's offset without borders (offset + border)
          this.offset.parent.left * mod - (this.cssPosition === "fixed" ? -this.offset.scroll.left : scrollIsRootNode ? 0 : this.offset.scroll.left) * mod
        )
      };
    }, "_convertPositionTo"),
    _generatePosition: /* @__PURE__ */ __name(function(event2, constrainPosition) {
      var containment, co, top2, left2, o = this.options, scrollIsRootNode = this._isRootNode(this.scrollParent[0]), pageX = event2.pageX, pageY = event2.pageY;
      return (!scrollIsRootNode || !this.offset.scroll) && (this.offset.scroll = {
        top: this.scrollParent.scrollTop(),
        left: this.scrollParent.scrollLeft()
      }), constrainPosition && (this.containment && (this.relativeContainer ? (co = this.relativeContainer.offset(), containment = [
        this.containment[0] + co.left,
        this.containment[1] + co.top,
        this.containment[2] + co.left,
        this.containment[3] + co.top
      ]) : containment = this.containment, event2.pageX - this.offset.click.left < containment[0] && (pageX = containment[0] + this.offset.click.left), event2.pageY - this.offset.click.top < containment[1] && (pageY = containment[1] + this.offset.click.top), event2.pageX - this.offset.click.left > containment[2] && (pageX = containment[2] + this.offset.click.left), event2.pageY - this.offset.click.top > containment[3] && (pageY = containment[3] + this.offset.click.top)), o.grid && (top2 = o.grid[1] ? this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1] : this.originalPageY, pageY = containment ? top2 - this.offset.click.top >= containment[1] || top2 - this.offset.click.top > containment[3] ? top2 : top2 - this.offset.click.top >= containment[1] ? top2 - o.grid[1] : top2 + o.grid[1] : top2, left2 = o.grid[0] ? this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0] : this.originalPageX, pageX = containment ? left2 - this.offset.click.left >= containment[0] || left2 - this.offset.click.left > containment[2] ? left2 : left2 - this.offset.click.left >= containment[0] ? left2 - o.grid[0] : left2 + o.grid[0] : left2), o.axis === "y" && (pageX = this.originalPageX), o.axis === "x" && (pageY = this.originalPageY)), {
        top: (
          // The absolute mouse position
          pageY - // Click offset (relative to the element)
          this.offset.click.top - // Only for relative positioned nodes: Relative offset from element to offset parent
          this.offset.relative.top - // The offsetParent's offset without borders (offset + border)
          this.offset.parent.top + (this.cssPosition === "fixed" ? -this.offset.scroll.top : scrollIsRootNode ? 0 : this.offset.scroll.top)
        ),
        left: (
          // The absolute mouse position
          pageX - // Click offset (relative to the element)
          this.offset.click.left - // Only for relative positioned nodes: Relative offset from element to offset parent
          this.offset.relative.left - // The offsetParent's offset without borders (offset + border)
          this.offset.parent.left + (this.cssPosition === "fixed" ? -this.offset.scroll.left : scrollIsRootNode ? 0 : this.offset.scroll.left)
        )
      };
    }, "_generatePosition"),
    _clear: /* @__PURE__ */ __name(function() {
      this._removeClass(this.helper, "ui-draggable-dragging"), this.helper[0] !== this.element[0] && !this.cancelHelperRemoval && this.helper.remove(), this.helper = null, this.cancelHelperRemoval = !1, this.destroyOnClear && this.destroy();
    }, "_clear"),
    // From now on bulk stuff - mainly helpers
    _trigger: /* @__PURE__ */ __name(function(type2, event2, ui) {
      return ui = ui || this._uiHash(), $2.ui.plugin.call(this, type2, [event2, ui, this], !0), /^(drag|start|stop)/.test(type2) && (this.positionAbs = this._convertPositionTo("absolute"), ui.offset = this.positionAbs), $2.Widget.prototype._trigger.call(this, type2, event2, ui);
    }, "_trigger"),
    plugins: {},
    _uiHash: /* @__PURE__ */ __name(function() {
      return {
        helper: this.helper,
        position: this.position,
        originalPosition: this.originalPosition,
        offset: this.positionAbs
      };
    }, "_uiHash")
  }), $2.ui.plugin.add("draggable", "connectToSortable", {
    start: /* @__PURE__ */ __name(function(event2, ui, draggable2) {
      var uiSortable = $2.extend({}, ui, {
        item: draggable2.element
      });
      draggable2.sortables = [], $2(draggable2.options.connectToSortable).each(function() {
        var sortable = $2(this).sortable("instance");
        sortable && !sortable.options.disabled && (draggable2.sortables.push(sortable), sortable.refreshPositions(), sortable._trigger("activate", event2, uiSortable));
      });
    }, "start"),
    stop: /* @__PURE__ */ __name(function(event2, ui, draggable2) {
      var uiSortable = $2.extend({}, ui, {
        item: draggable2.element
      });
      draggable2.cancelHelperRemoval = !1, $2.each(draggable2.sortables, function() {
        var sortable = this;
        sortable.isOver ? (sortable.isOver = 0, draggable2.cancelHelperRemoval = !0, sortable.cancelHelperRemoval = !1, sortable._storedCSS = {
          position: sortable.placeholder.css("position"),
          top: sortable.placeholder.css("top"),
          left: sortable.placeholder.css("left")
        }, sortable._mouseStop(event2), sortable.options.helper = sortable.options._helper) : (sortable.cancelHelperRemoval = !0, sortable._trigger("deactivate", event2, uiSortable));
      });
    }, "stop"),
    drag: /* @__PURE__ */ __name(function(event2, ui, draggable2) {
      $2.each(draggable2.sortables, function() {
        var innermostIntersecting = !1, sortable = this;
        sortable.positionAbs = draggable2.positionAbs, sortable.helperProportions = draggable2.helperProportions, sortable.offset.click = draggable2.offset.click, sortable._intersectsWith(sortable.containerCache) && (innermostIntersecting = !0, $2.each(draggable2.sortables, function() {
          return this.positionAbs = draggable2.positionAbs, this.helperProportions = draggable2.helperProportions, this.offset.click = draggable2.offset.click, this !== sortable && this._intersectsWith(this.containerCache) && $2.contains(sortable.element[0], this.element[0]) && (innermostIntersecting = !1), innermostIntersecting;
        })), innermostIntersecting ? (sortable.isOver || (sortable.isOver = 1, draggable2._parent = ui.helper.parent(), sortable.currentItem = ui.helper.appendTo(sortable.element).data("ui-sortable-item", !0), sortable.options._helper = sortable.options.helper, sortable.options.helper = function() {
          return ui.helper[0];
        }, event2.target = sortable.currentItem[0], sortable._mouseCapture(event2, !0), sortable._mouseStart(event2, !0, !0), sortable.offset.click.top = draggable2.offset.click.top, sortable.offset.click.left = draggable2.offset.click.left, sortable.offset.parent.left -= draggable2.offset.parent.left - sortable.offset.parent.left, sortable.offset.parent.top -= draggable2.offset.parent.top - sortable.offset.parent.top, draggable2._trigger("toSortable", event2), draggable2.dropped = sortable.element, $2.each(draggable2.sortables, function() {
          this.refreshPositions();
        }), draggable2.currentItem = draggable2.element, sortable.fromOutside = draggable2), sortable.currentItem && (sortable._mouseDrag(event2), ui.position = sortable.position)) : sortable.isOver && (sortable.isOver = 0, sortable.cancelHelperRemoval = !0, sortable.options._revert = sortable.options.revert, sortable.options.revert = !1, sortable._trigger("out", event2, sortable._uiHash(sortable)), sortable._mouseStop(event2, !0), sortable.options.revert = sortable.options._revert, sortable.options.helper = sortable.options._helper, sortable.placeholder && sortable.placeholder.remove(), ui.helper.appendTo(draggable2._parent), draggable2._refreshOffsets(event2), ui.position = draggable2._generatePosition(event2, !0), draggable2._trigger("fromSortable", event2), draggable2.dropped = !1, $2.each(draggable2.sortables, function() {
          this.refreshPositions();
        }));
      });
    }, "drag")
  }), $2.ui.plugin.add("draggable", "cursor", {
    start: /* @__PURE__ */ __name(function(event2, ui, instance) {
      var t2 = $2("body"), o = instance.options;
      t2.css("cursor") && (o._cursor = t2.css("cursor")), t2.css("cursor", o.cursor);
    }, "start"),
    stop: /* @__PURE__ */ __name(function(event2, ui, instance) {
      var o = instance.options;
      o._cursor && $2("body").css("cursor", o._cursor);
    }, "stop")
  }), $2.ui.plugin.add("draggable", "opacity", {
    start: /* @__PURE__ */ __name(function(event2, ui, instance) {
      var t2 = $2(ui.helper), o = instance.options;
      t2.css("opacity") && (o._opacity = t2.css("opacity")), t2.css("opacity", o.opacity);
    }, "start"),
    stop: /* @__PURE__ */ __name(function(event2, ui, instance) {
      var o = instance.options;
      o._opacity && $2(ui.helper).css("opacity", o._opacity);
    }, "stop")
  }), $2.ui.plugin.add("draggable", "scroll", {
    start: /* @__PURE__ */ __name(function(event2, ui, i) {
      i.scrollParentNotHidden || (i.scrollParentNotHidden = i.helper.scrollParent(!1)), i.scrollParentNotHidden[0] !== i.document[0] && i.scrollParentNotHidden[0].tagName !== "HTML" && (i.overflowOffset = i.scrollParentNotHidden.offset());
    }, "start"),
    drag: /* @__PURE__ */ __name(function(event2, ui, i) {
      var o = i.options, scrolled = !1, scrollParent = i.scrollParentNotHidden[0], document2 = i.document[0];
      scrollParent !== document2 && scrollParent.tagName !== "HTML" ? ((!o.axis || o.axis !== "x") && (i.overflowOffset.top + scrollParent.offsetHeight - event2.pageY < o.scrollSensitivity ? scrollParent.scrollTop = scrolled = scrollParent.scrollTop + o.scrollSpeed : event2.pageY - i.overflowOffset.top < o.scrollSensitivity && (scrollParent.scrollTop = scrolled = scrollParent.scrollTop - o.scrollSpeed)), (!o.axis || o.axis !== "y") && (i.overflowOffset.left + scrollParent.offsetWidth - event2.pageX < o.scrollSensitivity ? scrollParent.scrollLeft = scrolled = scrollParent.scrollLeft + o.scrollSpeed : event2.pageX - i.overflowOffset.left < o.scrollSensitivity && (scrollParent.scrollLeft = scrolled = scrollParent.scrollLeft - o.scrollSpeed))) : ((!o.axis || o.axis !== "x") && (event2.pageY - $2(document2).scrollTop() < o.scrollSensitivity ? scrolled = $2(document2).scrollTop($2(document2).scrollTop() - o.scrollSpeed) : $2(window).height() - (event2.pageY - $2(document2).scrollTop()) < o.scrollSensitivity && (scrolled = $2(document2).scrollTop($2(document2).scrollTop() + o.scrollSpeed))), (!o.axis || o.axis !== "y") && (event2.pageX - $2(document2).scrollLeft() < o.scrollSensitivity ? scrolled = $2(document2).scrollLeft(
        $2(document2).scrollLeft() - o.scrollSpeed
      ) : $2(window).width() - (event2.pageX - $2(document2).scrollLeft()) < o.scrollSensitivity && (scrolled = $2(document2).scrollLeft(
        $2(document2).scrollLeft() + o.scrollSpeed
      )))), scrolled !== !1 && $2.ui.ddmanager && !o.dropBehaviour && $2.ui.ddmanager.prepareOffsets(i, event2);
    }, "drag")
  }), $2.ui.plugin.add("draggable", "snap", {
    start: /* @__PURE__ */ __name(function(event2, ui, i) {
      var o = i.options;
      i.snapElements = [], $2(o.snap.constructor !== String ? o.snap.items || ":data(ui-draggable)" : o.snap).each(function() {
        var $t = $2(this), $o = $t.offset();
        this !== i.element[0] && i.snapElements.push({
          item: this,
          width: $t.outerWidth(),
          height: $t.outerHeight(),
          top: $o.top,
          left: $o.left
        });
      });
    }, "start"),
    drag: /* @__PURE__ */ __name(function(event2, ui, inst) {
      var ts, bs, ls, rs, l, r2, t2, b, i, first2, o = inst.options, d = o.snapTolerance, x1 = ui.offset.left, x2 = x1 + inst.helperProportions.width, y1 = ui.offset.top, y2 = y1 + inst.helperProportions.height;
      for (i = inst.snapElements.length - 1; i >= 0; i--) {
        if (l = inst.snapElements[i].left - inst.margins.left, r2 = l + inst.snapElements[i].width, t2 = inst.snapElements[i].top - inst.margins.top, b = t2 + inst.snapElements[i].height, x2 < l - d || x1 > r2 + d || y2 < t2 - d || y1 > b + d || !$2.contains(
          inst.snapElements[i].item.ownerDocument,
          inst.snapElements[i].item
        )) {
          inst.snapElements[i].snapping && inst.options.snap.release && inst.options.snap.release.call(
            inst.element,
            event2,
            $2.extend(inst._uiHash(), { snapItem: inst.snapElements[i].item })
          ), inst.snapElements[i].snapping = !1;
          continue;
        }
        o.snapMode !== "inner" && (ts = Math.abs(t2 - y2) <= d, bs = Math.abs(b - y1) <= d, ls = Math.abs(l - x2) <= d, rs = Math.abs(r2 - x1) <= d, ts && (ui.position.top = inst._convertPositionTo("relative", {
          top: t2 - inst.helperProportions.height,
          left: 0
        }).top), bs && (ui.position.top = inst._convertPositionTo("relative", {
          top: b,
          left: 0
        }).top), ls && (ui.position.left = inst._convertPositionTo("relative", {
          top: 0,
          left: l - inst.helperProportions.width
        }).left), rs && (ui.position.left = inst._convertPositionTo("relative", {
          top: 0,
          left: r2
        }).left)), first2 = ts || bs || ls || rs, o.snapMode !== "outer" && (ts = Math.abs(t2 - y1) <= d, bs = Math.abs(b - y2) <= d, ls = Math.abs(l - x1) <= d, rs = Math.abs(r2 - x2) <= d, ts && (ui.position.top = inst._convertPositionTo("relative", {
          top: t2,
          left: 0
        }).top), bs && (ui.position.top = inst._convertPositionTo("relative", {
          top: b - inst.helperProportions.height,
          left: 0
        }).top), ls && (ui.position.left = inst._convertPositionTo("relative", {
          top: 0,
          left: l
        }).left), rs && (ui.position.left = inst._convertPositionTo("relative", {
          top: 0,
          left: r2 - inst.helperProportions.width
        }).left)), !inst.snapElements[i].snapping && (ts || bs || ls || rs || first2) && inst.options.snap.snap && inst.options.snap.snap.call(
          inst.element,
          event2,
          $2.extend(inst._uiHash(), {
            snapItem: inst.snapElements[i].item
          })
        ), inst.snapElements[i].snapping = ts || bs || ls || rs || first2;
      }
    }, "drag")
  }), $2.ui.plugin.add("draggable", "stack", {
    start: /* @__PURE__ */ __name(function(event2, ui, instance) {
      var min2, o = instance.options, group = $2.makeArray($2(o.stack)).sort(function(a2, b) {
        return (parseInt($2(a2).css("zIndex"), 10) || 0) - (parseInt($2(b).css("zIndex"), 10) || 0);
      });
      group.length && (min2 = parseInt($2(group[0]).css("zIndex"), 10) || 0, $2(group).each(function(i) {
        $2(this).css("zIndex", min2 + i);
      }), this.css("zIndex", min2 + group.length));
    }, "start")
  }), $2.ui.plugin.add("draggable", "zIndex", {
    start: /* @__PURE__ */ __name(function(event2, ui, instance) {
      var t2 = $2(ui.helper), o = instance.options;
      t2.css("zIndex") && (o._zIndex = t2.css("zIndex")), t2.css("zIndex", o.zIndex);
    }, "start"),
    stop: /* @__PURE__ */ __name(function(event2, ui, instance) {
      var o = instance.options;
      o._zIndex && $2(ui.helper).css("zIndex", o._zIndex);
    }, "stop")
  }), $2.ui.draggable;
  /*!
   * jQuery UI Resizable 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.resizable", $2.ui.mouse, {
    version: "1.14.1",
    widgetEventPrefix: "resize",
    options: {
      alsoResize: !1,
      animate: !1,
      animateDuration: "slow",
      animateEasing: "swing",
      aspectRatio: !1,
      autoHide: !1,
      classes: {
        "ui-resizable-se": "ui-icon ui-icon-gripsmall-diagonal-se"
      },
      containment: !1,
      ghost: !1,
      grid: !1,
      handles: "e,s,se",
      helper: !1,
      maxHeight: null,
      maxWidth: null,
      minHeight: 10,
      minWidth: 10,
      // See #7960
      zIndex: 90,
      // Callbacks
      resize: null,
      start: null,
      stop: null
    },
    _num: /* @__PURE__ */ __name(function(value3) {
      return parseFloat(value3) || 0;
    }, "_num"),
    _isNumber: /* @__PURE__ */ __name(function(value3) {
      return !isNaN(parseFloat(value3));
    }, "_isNumber"),
    _hasScroll: /* @__PURE__ */ __name(function(el, a2) {
      var scroll, has4 = !1, overflow = $2(el).css("overflow");
      if (overflow === "hidden")
        return !1;
      if (overflow === "scroll" || (scroll = a2 && a2 === "left" ? "scrollLeft" : "scrollTop", el[scroll] > 0))
        return !0;
      try {
        el[scroll] = 1, has4 = el[scroll] > 0, el[scroll] = 0;
      } catch {
      }
      return has4;
    }, "_hasScroll"),
    _create: /* @__PURE__ */ __name(function() {
      var margins, o = this.options, that = this;
      this._addClass("ui-resizable"), $2.extend(this, {
        _aspectRatio: !!o.aspectRatio,
        aspectRatio: o.aspectRatio,
        originalElement: this.element,
        _proportionallyResizeElements: [],
        _helper: o.helper || o.ghost || o.animate ? o.helper || "ui-resizable-helper" : null
      }), this.element[0].nodeName.match(/^(canvas|textarea|input|select|button|img)$/i) && (this.element.wrap(
        $2("<div class='ui-wrapper'></div>").css({
          overflow: "hidden",
          position: this.element.css("position"),
          width: this.element.outerWidth(),
          height: this.element.outerHeight(),
          top: this.element.css("top"),
          left: this.element.css("left")
        })
      ), this.element = this.element.parent().data(
        "ui-resizable",
        this.element.resizable("instance")
      ), this.elementIsWrapper = !0, margins = {
        marginTop: this.originalElement.css("marginTop"),
        marginRight: this.originalElement.css("marginRight"),
        marginBottom: this.originalElement.css("marginBottom"),
        marginLeft: this.originalElement.css("marginLeft")
      }, this.element.css(margins), this.originalResizeStyle = this.originalElement.css("resize"), this.originalElement.css("resize", "none"), this._proportionallyResizeElements.push(this.originalElement.css({
        position: "static",
        zoom: 1,
        display: "block"
      })), this._proportionallyResize()), this._setupHandles(), o.autoHide && $2(this.element).on("mouseenter", function() {
        o.disabled || (that._removeClass("ui-resizable-autohide"), that._handles.show());
      }).on("mouseleave", function() {
        o.disabled || that.resizing || (that._addClass("ui-resizable-autohide"), that._handles.hide());
      }), this._mouseInit();
    }, "_create"),
    _destroy: /* @__PURE__ */ __name(function() {
      this._mouseDestroy(), this._addedHandles.remove();
      var wrapper, _destroy = /* @__PURE__ */ __name(function(exp) {
        $2(exp).removeData("resizable").removeData("ui-resizable").off(".resizable");
      }, "_destroy");
      return this.elementIsWrapper && (_destroy(this.element), wrapper = this.element, this.originalElement.css({
        position: wrapper.css("position"),
        width: wrapper.outerWidth(),
        height: wrapper.outerHeight(),
        top: wrapper.css("top"),
        left: wrapper.css("left")
      }).insertAfter(wrapper), wrapper.remove()), this.originalElement.css("resize", this.originalResizeStyle), _destroy(this.originalElement), this;
    }, "_destroy"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      switch (this._super(key, value3), key) {
        case "handles":
          this._removeHandles(), this._setupHandles();
          break;
        case "aspectRatio":
          this._aspectRatio = !!value3;
          break;
      }
    }, "_setOption"),
    _setupHandles: /* @__PURE__ */ __name(function() {
      var o = this.options, handle, i, n2, hname, axis, that = this;
      if (this.handles = o.handles || ($2(".ui-resizable-handle", this.element).length ? {
        n: ".ui-resizable-n",
        e: ".ui-resizable-e",
        s: ".ui-resizable-s",
        w: ".ui-resizable-w",
        se: ".ui-resizable-se",
        sw: ".ui-resizable-sw",
        ne: ".ui-resizable-ne",
        nw: ".ui-resizable-nw"
      } : "e,s,se"), this._handles = $2(), this._addedHandles = $2(), this.handles.constructor === String)
        for (this.handles === "all" && (this.handles = "n,e,s,w,se,sw,ne,nw"), n2 = this.handles.split(","), this.handles = {}, i = 0; i < n2.length; i++)
          handle = String.prototype.trim.call(n2[i]), hname = "ui-resizable-" + handle, axis = $2("<div>"), this._addClass(axis, "ui-resizable-handle " + hname), axis.css({ zIndex: o.zIndex }), this.handles[handle] = ".ui-resizable-" + handle, this.element.children(this.handles[handle]).length || (this.element.append(axis), this._addedHandles = this._addedHandles.add(axis));
      this._renderAxis = function(target2) {
        var i2, axis2, padPos, padWrapper;
        target2 = target2 || this.element;
        for (i2 in this.handles)
          this.handles[i2].constructor === String ? this.handles[i2] = this.element.children(this.handles[i2]).first().show() : (this.handles[i2].jquery || this.handles[i2].nodeType) && (this.handles[i2] = $2(this.handles[i2]), this._on(this.handles[i2], { mousedown: that._mouseDown })), this.elementIsWrapper && this.originalElement[0].nodeName.match(/^(textarea|input|select|button)$/i) && (axis2 = $2(this.handles[i2], this.element), padWrapper = /sw|ne|nw|se|n|s/.test(i2) ? axis2.outerHeight() : axis2.outerWidth(), padPos = [
            "padding",
            /ne|nw|n/.test(i2) ? "Top" : /se|sw|s/.test(i2) ? "Bottom" : /^e$/.test(i2) ? "Right" : "Left"
          ].join(""), target2.css(padPos, padWrapper), this._proportionallyResize()), this._handles = this._handles.add(this.handles[i2]);
      }, this._renderAxis(this.element), this._handles = this._handles.add(this.element.find(".ui-resizable-handle")), this._handles.disableSelection(), this._handles.on("mouseover", function() {
        that.resizing || (this.className && (axis = this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i)), that.axis = axis && axis[1] ? axis[1] : "se");
      }), o.autoHide && (this._handles.hide(), this._addClass("ui-resizable-autohide"));
    }, "_setupHandles"),
    _removeHandles: /* @__PURE__ */ __name(function() {
      this._addedHandles.remove();
    }, "_removeHandles"),
    _mouseCapture: /* @__PURE__ */ __name(function(event2) {
      var i, handle, capture2 = !1;
      for (i in this.handles)
        handle = $2(this.handles[i])[0], (handle === event2.target || $2.contains(handle, event2.target)) && (capture2 = !0);
      return !this.options.disabled && capture2;
    }, "_mouseCapture"),
    _mouseStart: /* @__PURE__ */ __name(function(event2) {
      var curleft, curtop, cursor, calculatedSize, o = this.options, el = this.element;
      return this.resizing = !0, this._renderProxy(), curleft = this._num(this.helper.css("left")), curtop = this._num(this.helper.css("top")), o.containment && (curleft += $2(o.containment).scrollLeft() || 0, curtop += $2(o.containment).scrollTop() || 0), this.offset = this.helper.offset(), this.position = { left: curleft, top: curtop }, this._helper || (calculatedSize = this._calculateAdjustedElementDimensions(el)), this.size = this._helper ? {
        width: this.helper.width(),
        height: this.helper.height()
      } : {
        width: calculatedSize.width,
        height: calculatedSize.height
      }, this.originalSize = this._helper ? {
        width: el.outerWidth(),
        height: el.outerHeight()
      } : {
        width: calculatedSize.width,
        height: calculatedSize.height
      }, this.sizeDiff = {
        width: el.outerWidth() - el.width(),
        height: el.outerHeight() - el.height()
      }, this.originalPosition = { left: curleft, top: curtop }, this.originalMousePosition = { left: event2.pageX, top: event2.pageY }, this.aspectRatio = typeof o.aspectRatio == "number" ? o.aspectRatio : this.originalSize.width / this.originalSize.height || 1, cursor = $2(".ui-resizable-" + this.axis).css("cursor"), $2("body").css("cursor", cursor === "auto" ? this.axis + "-resize" : cursor), this._addClass("ui-resizable-resizing"), this._propagate("start", event2), !0;
    }, "_mouseStart"),
    _mouseDrag: /* @__PURE__ */ __name(function(event2) {
      var data49, props2, smp = this.originalMousePosition, a2 = this.axis, dx = event2.pageX - smp.left || 0, dy = event2.pageY - smp.top || 0, trigger2 = this._change[a2];
      return this._updatePrevProperties(), trigger2 && (data49 = trigger2.apply(this, [event2, dx, dy]), this._updateVirtualBoundaries(event2.shiftKey), (this._aspectRatio || event2.shiftKey) && (data49 = this._updateRatio(data49, event2)), data49 = this._respectSize(data49, event2), this._updateCache(data49), this._propagate("resize", event2), props2 = this._applyChanges(), !this._helper && this._proportionallyResizeElements.length && this._proportionallyResize(), $2.isEmptyObject(props2) || (this._updatePrevProperties(), this._trigger("resize", event2, this.ui()), this._applyChanges())), !1;
    }, "_mouseDrag"),
    _mouseStop: /* @__PURE__ */ __name(function(event2) {
      this.resizing = !1;
      var pr, ista, soffseth, soffsetw, s2, left2, top2, o = this.options, that = this;
      return this._helper && (pr = this._proportionallyResizeElements, ista = pr.length && /textarea/i.test(pr[0].nodeName), soffseth = ista && this._hasScroll(pr[0], "left") ? 0 : that.sizeDiff.height, soffsetw = ista ? 0 : that.sizeDiff.width, s2 = {
        width: that.helper.width() - soffsetw,
        height: that.helper.height() - soffseth
      }, left2 = parseFloat(that.element.css("left")) + (that.position.left - that.originalPosition.left) || null, top2 = parseFloat(that.element.css("top")) + (that.position.top - that.originalPosition.top) || null, o.animate || this.element.css($2.extend(s2, { top: top2, left: left2 })), that.helper.height(that.size.height), that.helper.width(that.size.width), this._helper && !o.animate && this._proportionallyResize()), $2("body").css("cursor", "auto"), this._removeClass("ui-resizable-resizing"), this._propagate("stop", event2), this._helper && this.helper.remove(), !1;
    }, "_mouseStop"),
    _updatePrevProperties: /* @__PURE__ */ __name(function() {
      this.prevPosition = {
        top: this.position.top,
        left: this.position.left
      }, this.prevSize = {
        width: this.size.width,
        height: this.size.height
      };
    }, "_updatePrevProperties"),
    _applyChanges: /* @__PURE__ */ __name(function() {
      var props2 = {};
      return this.position.top !== this.prevPosition.top && (props2.top = this.position.top + "px"), this.position.left !== this.prevPosition.left && (props2.left = this.position.left + "px"), this.helper.css(props2), this.size.width !== this.prevSize.width && (props2.width = this.size.width + "px", this.helper.width(props2.width)), this.size.height !== this.prevSize.height && (props2.height = this.size.height + "px", this.helper.height(props2.height)), props2;
    }, "_applyChanges"),
    _updateVirtualBoundaries: /* @__PURE__ */ __name(function(forceAspectRatio) {
      var pMinWidth, pMaxWidth, pMinHeight, pMaxHeight, b, o = this.options;
      b = {
        minWidth: this._isNumber(o.minWidth) ? o.minWidth : 0,
        maxWidth: this._isNumber(o.maxWidth) ? o.maxWidth : 1 / 0,
        minHeight: this._isNumber(o.minHeight) ? o.minHeight : 0,
        maxHeight: this._isNumber(o.maxHeight) ? o.maxHeight : 1 / 0
      }, (this._aspectRatio || forceAspectRatio) && (pMinWidth = b.minHeight * this.aspectRatio, pMinHeight = b.minWidth / this.aspectRatio, pMaxWidth = b.maxHeight * this.aspectRatio, pMaxHeight = b.maxWidth / this.aspectRatio, pMinWidth > b.minWidth && (b.minWidth = pMinWidth), pMinHeight > b.minHeight && (b.minHeight = pMinHeight), pMaxWidth < b.maxWidth && (b.maxWidth = pMaxWidth), pMaxHeight < b.maxHeight && (b.maxHeight = pMaxHeight)), this._vBoundaries = b;
    }, "_updateVirtualBoundaries"),
    _updateCache: /* @__PURE__ */ __name(function(data49) {
      this.offset = this.helper.offset(), this._isNumber(data49.left) && (this.position.left = data49.left), this._isNumber(data49.top) && (this.position.top = data49.top), this._isNumber(data49.height) && (this.size.height = data49.height), this._isNumber(data49.width) && (this.size.width = data49.width);
    }, "_updateCache"),
    _updateRatio: /* @__PURE__ */ __name(function(data49) {
      var cpos = this.position, csize = this.size, a2 = this.axis;
      return this._isNumber(data49.height) ? data49.width = data49.height * this.aspectRatio : this._isNumber(data49.width) && (data49.height = data49.width / this.aspectRatio), a2 === "sw" && (data49.left = cpos.left + (csize.width - data49.width), data49.top = null), a2 === "nw" && (data49.top = cpos.top + (csize.height - data49.height), data49.left = cpos.left + (csize.width - data49.width)), data49;
    }, "_updateRatio"),
    _respectSize: /* @__PURE__ */ __name(function(data49) {
      var o = this._vBoundaries, a2 = this.axis, ismaxw = this._isNumber(data49.width) && o.maxWidth && o.maxWidth < data49.width, ismaxh = this._isNumber(data49.height) && o.maxHeight && o.maxHeight < data49.height, isminw = this._isNumber(data49.width) && o.minWidth && o.minWidth > data49.width, isminh = this._isNumber(data49.height) && o.minHeight && o.minHeight > data49.height, dw = this.originalPosition.left + this.originalSize.width, dh = this.originalPosition.top + this.originalSize.height, cw = /sw|nw|w/.test(a2), ch = /nw|ne|n/.test(a2);
      return isminw && (data49.width = o.minWidth), isminh && (data49.height = o.minHeight), ismaxw && (data49.width = o.maxWidth), ismaxh && (data49.height = o.maxHeight), isminw && cw && (data49.left = dw - o.minWidth), ismaxw && cw && (data49.left = dw - o.maxWidth), isminh && ch && (data49.top = dh - o.minHeight), ismaxh && ch && (data49.top = dh - o.maxHeight), !data49.width && !data49.height && !data49.left && data49.top ? data49.top = null : !data49.width && !data49.height && !data49.top && data49.left && (data49.left = null), data49;
    }, "_respectSize"),
    _getPaddingPlusBorderDimensions: /* @__PURE__ */ __name(function(element) {
      for (var i = 0, widths = [], borders = [
        element.css("borderTopWidth"),
        element.css("borderRightWidth"),
        element.css("borderBottomWidth"),
        element.css("borderLeftWidth")
      ], paddings = [
        element.css("paddingTop"),
        element.css("paddingRight"),
        element.css("paddingBottom"),
        element.css("paddingLeft")
      ]; i < 4; i++)
        widths[i] = parseFloat(borders[i]) || 0, widths[i] += parseFloat(paddings[i]) || 0;
      return {
        height: widths[0] + widths[2],
        width: widths[1] + widths[3]
      };
    }, "_getPaddingPlusBorderDimensions"),
    _calculateAdjustedElementDimensions: /* @__PURE__ */ __name(function(element) {
      var elWidth, elHeight, paddingBorder, ce = element.get(0);
      return element.css("box-sizing") !== "content-box" || !this._hasScroll(ce) && !this._hasScroll(ce, "left") ? {
        height: parseFloat(element.css("height")),
        width: parseFloat(element.css("width"))
      } : (elWidth = parseFloat(ce.style.width), elHeight = parseFloat(ce.style.height), paddingBorder = this._getPaddingPlusBorderDimensions(element), elWidth = isNaN(elWidth) ? this._getElementTheoreticalSize(element, paddingBorder, "width") : elWidth, elHeight = isNaN(elHeight) ? this._getElementTheoreticalSize(element, paddingBorder, "height") : elHeight, {
        height: elHeight,
        width: elWidth
      });
    }, "_calculateAdjustedElementDimensions"),
    _getElementTheoreticalSize: /* @__PURE__ */ __name(function(element, extraSize, dimension) {
      var size2 = Math.max(0, Math.ceil(
        element.get(0)["offset" + dimension[0].toUpperCase() + dimension.slice(1)] - extraSize[dimension] - 0.5
        // If offsetWidth/offsetHeight is unknown, then we can't determine theoretical size.
        // Use an explicit zero to avoid NaN.
        // See https://github.com/jquery/jquery/issues/3964
      )) || 0;
      return size2;
    }, "_getElementTheoreticalSize"),
    _proportionallyResize: /* @__PURE__ */ __name(function() {
      if (this._proportionallyResizeElements.length)
        for (var prel, i = 0, element = this.helper || this.element; i < this._proportionallyResizeElements.length; i++)
          prel = this._proportionallyResizeElements[i], this.outerDimensions || (this.outerDimensions = this._getPaddingPlusBorderDimensions(prel)), prel.css({
            height: element.height() - this.outerDimensions.height || 0,
            width: element.width() - this.outerDimensions.width || 0
          });
    }, "_proportionallyResize"),
    _renderProxy: /* @__PURE__ */ __name(function() {
      var el = this.element, o = this.options;
      this.elementOffset = el.offset(), this._helper ? (this.helper = this.helper || $2("<div></div>").css({ overflow: "hidden" }), this._addClass(this.helper, this._helper), this.helper.css({
        width: this.element.outerWidth(),
        height: this.element.outerHeight(),
        position: "absolute",
        left: this.elementOffset.left + "px",
        top: this.elementOffset.top + "px",
        zIndex: ++o.zIndex
        //TODO: Don't modify option
      }), this.helper.appendTo("body").disableSelection()) : this.helper = this.element;
    }, "_renderProxy"),
    _change: {
      e: /* @__PURE__ */ __name(function(event2, dx) {
        return { width: this.originalSize.width + dx };
      }, "e"),
      w: /* @__PURE__ */ __name(function(event2, dx) {
        var cs = this.originalSize, sp = this.originalPosition;
        return { left: sp.left + dx, width: cs.width - dx };
      }, "w"),
      n: /* @__PURE__ */ __name(function(event2, dx, dy) {
        var cs = this.originalSize, sp = this.originalPosition;
        return { top: sp.top + dy, height: cs.height - dy };
      }, "n"),
      s: /* @__PURE__ */ __name(function(event2, dx, dy) {
        return { height: this.originalSize.height + dy };
      }, "s"),
      se: /* @__PURE__ */ __name(function(event2, dx, dy) {
        return $2.extend(
          this._change.s.apply(this, arguments),
          this._change.e.apply(this, [event2, dx, dy])
        );
      }, "se"),
      sw: /* @__PURE__ */ __name(function(event2, dx, dy) {
        return $2.extend(
          this._change.s.apply(this, arguments),
          this._change.w.apply(this, [event2, dx, dy])
        );
      }, "sw"),
      ne: /* @__PURE__ */ __name(function(event2, dx, dy) {
        return $2.extend(
          this._change.n.apply(this, arguments),
          this._change.e.apply(this, [event2, dx, dy])
        );
      }, "ne"),
      nw: /* @__PURE__ */ __name(function(event2, dx, dy) {
        return $2.extend(
          this._change.n.apply(this, arguments),
          this._change.w.apply(this, [event2, dx, dy])
        );
      }, "nw")
    },
    _propagate: /* @__PURE__ */ __name(function(n2, event2) {
      $2.ui.plugin.call(this, n2, [event2, this.ui()]), n2 !== "resize" && this._trigger(n2, event2, this.ui());
    }, "_propagate"),
    plugins: {},
    ui: /* @__PURE__ */ __name(function() {
      return {
        originalElement: this.originalElement,
        element: this.element,
        helper: this.helper,
        position: this.position,
        size: this.size,
        originalSize: this.originalSize,
        originalPosition: this.originalPosition
      };
    }, "ui")
  }), $2.ui.plugin.add("resizable", "animate", {
    stop: /* @__PURE__ */ __name(function(event2) {
      var that = $2(this).resizable("instance"), o = that.options, pr = that._proportionallyResizeElements, ista = pr.length && /textarea/i.test(pr[0].nodeName), soffseth = ista && that._hasScroll(pr[0], "left") ? 0 : that.sizeDiff.height, soffsetw = ista ? 0 : that.sizeDiff.width, style2 = {
        width: that.size.width - soffsetw,
        height: that.size.height - soffseth
      }, left2 = parseFloat(that.element.css("left")) + (that.position.left - that.originalPosition.left) || null, top2 = parseFloat(that.element.css("top")) + (that.position.top - that.originalPosition.top) || null;
      that.element.animate(
        $2.extend(style2, top2 && left2 ? { top: top2, left: left2 } : {}),
        {
          duration: o.animateDuration,
          easing: o.animateEasing,
          step: /* @__PURE__ */ __name(function() {
            var data49 = {
              width: parseFloat(that.element.css("width")),
              height: parseFloat(that.element.css("height")),
              top: parseFloat(that.element.css("top")),
              left: parseFloat(that.element.css("left"))
            };
            pr && pr.length && $2(pr[0]).css({ width: data49.width, height: data49.height }), that._updateCache(data49), that._propagate("resize", event2);
          }, "step")
        }
      );
    }, "stop")
  }), $2.ui.plugin.add("resizable", "containment", {
    start: /* @__PURE__ */ __name(function() {
      var element, p, co, ch, cw, width, height, that = $2(this).resizable("instance"), o = that.options, el = that.element, oc = o.containment, ce = oc instanceof $2 ? oc.get(0) : /parent/.test(oc) ? el.parent().get(0) : oc;
      ce && (that.containerElement = $2(ce), /document/.test(oc) || oc === document ? (that.containerOffset = {
        left: 0,
        top: 0
      }, that.containerPosition = {
        left: 0,
        top: 0
      }, that.parentData = {
        element: $2(document),
        left: 0,
        top: 0,
        width: $2(document).width(),
        height: $2(document).height() || document.body.parentNode.scrollHeight
      }) : (element = $2(ce), p = [], $2(["Top", "Right", "Left", "Bottom"]).each(function(i, name2) {
        p[i] = that._num(element.css("padding" + name2));
      }), that.containerOffset = element.offset(), that.containerPosition = element.position(), that.containerSize = {
        height: element.innerHeight() - p[3],
        width: element.innerWidth() - p[1]
      }, co = that.containerOffset, ch = that.containerSize.height, cw = that.containerSize.width, width = that._hasScroll(ce, "left") ? ce.scrollWidth : cw, height = that._hasScroll(ce) ? ce.scrollHeight : ch, that.parentData = {
        element: ce,
        left: co.left,
        top: co.top,
        width,
        height
      }));
    }, "start"),
    resize: /* @__PURE__ */ __name(function(event2) {
      var woset, hoset, isParent, isOffsetRelative, that = $2(this).resizable("instance"), o = that.options, co = that.containerOffset, cp = that.position, pRatio = that._aspectRatio || event2.shiftKey, cop = {
        top: 0,
        left: 0
      }, ce = that.containerElement, continueResize = !0;
      ce[0] !== document && /static/.test(ce.css("position")) && (cop = co), cp.left < (that._helper ? co.left : 0) && (that.size.width = that.size.width + (that._helper ? that.position.left - co.left : that.position.left - cop.left), pRatio && (that.size.height = that.size.width / that.aspectRatio, continueResize = !1), that.position.left = o.helper ? co.left : 0), cp.top < (that._helper ? co.top : 0) && (that.size.height = that.size.height + (that._helper ? that.position.top - co.top : that.position.top), pRatio && (that.size.width = that.size.height * that.aspectRatio, continueResize = !1), that.position.top = that._helper ? co.top : 0), isParent = that.containerElement.get(0) === that.element.parent().get(0), isOffsetRelative = /relative|absolute/.test(that.containerElement.css("position")), isParent && isOffsetRelative ? (that.offset.left = that.parentData.left + that.position.left, that.offset.top = that.parentData.top + that.position.top) : (that.offset.left = that.element.offset().left, that.offset.top = that.element.offset().top), woset = Math.abs(that.sizeDiff.width + (that._helper ? that.offset.left - cop.left : that.offset.left - co.left)), hoset = Math.abs(that.sizeDiff.height + (that._helper ? that.offset.top - cop.top : that.offset.top - co.top)), woset + that.size.width >= that.parentData.width && (that.size.width = that.parentData.width - woset, pRatio && (that.size.height = that.size.width / that.aspectRatio, continueResize = !1)), hoset + that.size.height >= that.parentData.height && (that.size.height = that.parentData.height - hoset, pRatio && (that.size.width = that.size.height * that.aspectRatio, continueResize = !1)), continueResize || (that.position.left = that.prevPosition.left, that.position.top = that.prevPosition.top, that.size.width = that.prevSize.width, that.size.height = that.prevSize.height);
    }, "resize"),
    stop: /* @__PURE__ */ __name(function() {
      var that = $2(this).resizable("instance"), o = that.options, co = that.containerOffset, cop = that.containerPosition, ce = that.containerElement, helper = $2(that.helper), ho = helper.offset(), w = helper.outerWidth() - that.sizeDiff.width, h = helper.outerHeight() - that.sizeDiff.height;
      that._helper && !o.animate && /relative/.test(ce.css("position")) && $2(this).css({
        left: ho.left - cop.left - co.left,
        width: w,
        height: h
      }), that._helper && !o.animate && /static/.test(ce.css("position")) && $2(this).css({
        left: ho.left - cop.left - co.left,
        width: w,
        height: h
      });
    }, "stop")
  }), $2.ui.plugin.add("resizable", "alsoResize", {
    start: /* @__PURE__ */ __name(function() {
      var that = $2(this).resizable("instance"), o = that.options;
      $2(o.alsoResize).each(function() {
        var el = $2(this), elSize = that._calculateAdjustedElementDimensions(el);
        el.data("ui-resizable-alsoresize", {
          width: elSize.width,
          height: elSize.height,
          left: parseFloat(el.css("left")),
          top: parseFloat(el.css("top"))
        });
      });
    }, "start"),
    resize: /* @__PURE__ */ __name(function(event2, ui) {
      var that = $2(this).resizable("instance"), o = that.options, os = that.originalSize, op = that.originalPosition, delta = {
        height: that.size.height - os.height || 0,
        width: that.size.width - os.width || 0,
        top: that.position.top - op.top || 0,
        left: that.position.left - op.left || 0
      };
      $2(o.alsoResize).each(function() {
        var el = $2(this), start3 = $2(this).data("ui-resizable-alsoresize"), style2 = {}, css2 = el.parents(ui.originalElement[0]).length ? ["width", "height"] : ["width", "height", "top", "left"];
        $2.each(css2, function(i, prop2) {
          var sum = (start3[prop2] || 0) + (delta[prop2] || 0);
          sum && sum >= 0 && (style2[prop2] = sum || null);
        }), el.css(style2);
      });
    }, "resize"),
    stop: /* @__PURE__ */ __name(function() {
      $2(this).removeData("ui-resizable-alsoresize");
    }, "stop")
  }), $2.ui.plugin.add("resizable", "ghost", {
    start: /* @__PURE__ */ __name(function() {
      var that = $2(this).resizable("instance"), cs = that.size;
      that.ghost = that.originalElement.clone(), that.ghost.css({
        opacity: 0.25,
        display: "block",
        position: "relative",
        height: cs.height,
        width: cs.width,
        margin: 0,
        left: 0,
        top: 0
      }), that._addClass(that.ghost, "ui-resizable-ghost"), $2.uiBackCompat === !0 && typeof that.options.ghost == "string" && that.ghost.addClass(this.options.ghost), that.ghost.appendTo(that.helper);
    }, "start"),
    resize: /* @__PURE__ */ __name(function() {
      var that = $2(this).resizable("instance");
      that.ghost && that.ghost.css({
        position: "relative",
        height: that.size.height,
        width: that.size.width
      });
    }, "resize"),
    stop: /* @__PURE__ */ __name(function() {
      var that = $2(this).resizable("instance");
      that.ghost && that.helper && that.helper.get(0).removeChild(that.ghost.get(0));
    }, "stop")
  }), $2.ui.plugin.add("resizable", "grid", {
    resize: /* @__PURE__ */ __name(function() {
      var outerDimensions, that = $2(this).resizable("instance"), o = that.options, cs = that.size, os = that.originalSize, op = that.originalPosition, a2 = that.axis, grid = typeof o.grid == "number" ? [o.grid, o.grid] : o.grid, gridX = grid[0] || 1, gridY = grid[1] || 1, ox = Math.round((cs.width - os.width) / gridX) * gridX, oy = Math.round((cs.height - os.height) / gridY) * gridY, newWidth = os.width + ox, newHeight = os.height + oy, isMaxWidth = o.maxWidth && o.maxWidth < newWidth, isMaxHeight = o.maxHeight && o.maxHeight < newHeight, isMinWidth = o.minWidth && o.minWidth > newWidth, isMinHeight = o.minHeight && o.minHeight > newHeight;
      o.grid = grid, isMinWidth && (newWidth += gridX), isMinHeight && (newHeight += gridY), isMaxWidth && (newWidth -= gridX), isMaxHeight && (newHeight -= gridY), /^(se|s|e)$/.test(a2) ? (that.size.width = newWidth, that.size.height = newHeight) : /^(ne)$/.test(a2) ? (that.size.width = newWidth, that.size.height = newHeight, that.position.top = op.top - oy) : /^(sw)$/.test(a2) ? (that.size.width = newWidth, that.size.height = newHeight, that.position.left = op.left - ox) : ((newHeight - gridY <= 0 || newWidth - gridX <= 0) && (outerDimensions = that._getPaddingPlusBorderDimensions(this)), newHeight - gridY > 0 ? (that.size.height = newHeight, that.position.top = op.top - oy) : (newHeight = gridY - outerDimensions.height, that.size.height = newHeight, that.position.top = op.top + os.height - newHeight), newWidth - gridX > 0 ? (that.size.width = newWidth, that.position.left = op.left - ox) : (newWidth = gridX - outerDimensions.width, that.size.width = newWidth, that.position.left = op.left + os.width - newWidth));
    }, "resize")
  }), $2.ui.resizable;
  /*!
   * jQuery UI Dialog 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.dialog", {
    version: "1.14.1",
    options: {
      appendTo: "body",
      autoOpen: !0,
      buttons: [],
      classes: {
        "ui-dialog": "ui-corner-all",
        "ui-dialog-titlebar": "ui-corner-all"
      },
      closeOnEscape: !0,
      closeText: "Close",
      draggable: !0,
      hide: null,
      height: "auto",
      maxHeight: null,
      maxWidth: null,
      minHeight: 150,
      minWidth: 150,
      modal: !1,
      position: {
        my: "center",
        at: "center",
        of: window,
        collision: "fit",
        // Ensure the titlebar is always visible
        using: /* @__PURE__ */ __name(function(pos) {
          var topOffset = $2(this).css(pos).offset().top;
          topOffset < 0 && $2(this).css("top", pos.top - topOffset);
        }, "using")
      },
      resizable: !0,
      show: null,
      title: null,
      uiDialogTitleHeadingLevel: 0,
      width: 300,
      // Callbacks
      beforeClose: null,
      close: null,
      drag: null,
      dragStart: null,
      dragStop: null,
      focus: null,
      open: null,
      resize: null,
      resizeStart: null,
      resizeStop: null
    },
    sizeRelatedOptions: {
      buttons: !0,
      height: !0,
      maxHeight: !0,
      maxWidth: !0,
      minHeight: !0,
      minWidth: !0,
      width: !0
    },
    resizableRelatedOptions: {
      maxHeight: !0,
      maxWidth: !0,
      minHeight: !0,
      minWidth: !0
    },
    _create: /* @__PURE__ */ __name(function() {
      this.originalCss = {
        display: this.element[0].style.display,
        width: this.element[0].style.width,
        minHeight: this.element[0].style.minHeight,
        maxHeight: this.element[0].style.maxHeight,
        height: this.element[0].style.height
      }, this.originalPosition = {
        parent: this.element.parent(),
        index: this.element.parent().children().index(this.element)
      }, this.originalTitle = this.element.attr("title"), this.options.title == null && this.originalTitle != null && (this.options.title = this.originalTitle), this.options.disabled && (this.options.disabled = !1), this._createWrapper(), this.element.show().removeAttr("title").appendTo(this.uiDialog), this._addClass("ui-dialog-content", "ui-widget-content"), this._createTitlebar(), this._createButtonPane(), this.options.draggable && $2.fn.draggable && this._makeDraggable(), this.options.resizable && $2.fn.resizable && this._makeResizable(), this._isOpen = !1, this._trackFocus();
    }, "_create"),
    _init: /* @__PURE__ */ __name(function() {
      this.options.autoOpen && this.open();
    }, "_init"),
    _appendTo: /* @__PURE__ */ __name(function() {
      var element = this.options.appendTo;
      return element && (element.jquery || element.nodeType) ? $2(element) : this.document.find(element || "body").eq(0);
    }, "_appendTo"),
    _destroy: /* @__PURE__ */ __name(function() {
      var next3, originalPosition = this.originalPosition;
      this._untrackInstance(), this._destroyOverlay(), this.element.removeUniqueId().css(this.originalCss).detach(), this.uiDialog.remove(), this.originalTitle && this.element.attr("title", this.originalTitle), next3 = originalPosition.parent.children().eq(originalPosition.index), next3.length && next3[0] !== this.element[0] ? next3.before(this.element) : originalPosition.parent.append(this.element);
    }, "_destroy"),
    widget: /* @__PURE__ */ __name(function() {
      return this.uiDialog;
    }, "widget"),
    disable: $2.noop,
    enable: $2.noop,
    close: /* @__PURE__ */ __name(function(event2) {
      var that = this;
      !this._isOpen || this._trigger("beforeClose", event2) === !1 || (this._isOpen = !1, this._focusedElement = null, this._destroyOverlay(), this._untrackInstance(), this.opener.filter(":focusable").trigger("focus").length || $2(this.document[0].activeElement).trigger("blur"), this._hide(this.uiDialog, this.options.hide, function() {
        that._trigger("close", event2);
      }));
    }, "close"),
    isOpen: /* @__PURE__ */ __name(function() {
      return this._isOpen;
    }, "isOpen"),
    moveToTop: /* @__PURE__ */ __name(function() {
      this._moveToTop();
    }, "moveToTop"),
    _moveToTop: /* @__PURE__ */ __name(function(event2, silent) {
      var moved2 = !1, zIndices = this.uiDialog.siblings(".ui-front:visible").map(function() {
        return +$2(this).css("z-index");
      }).get(), zIndexMax = Math.max.apply(null, zIndices);
      return zIndexMax >= +this.uiDialog.css("z-index") && (this.uiDialog.css("z-index", zIndexMax + 1), moved2 = !0), moved2 && !silent && this._trigger("focus", event2), moved2;
    }, "_moveToTop"),
    open: /* @__PURE__ */ __name(function() {
      var that = this;
      if (this._isOpen) {
        this._moveToTop() && this._focusTabbable();
        return;
      }
      this._isOpen = !0, this.opener = $2(this.document[0].activeElement), this._size(), this._position(), this._createOverlay(), this._moveToTop(null, !0), this.overlay && this.overlay.css("z-index", this.uiDialog.css("z-index") - 1), this._show(this.uiDialog, this.options.show, function() {
        that._focusTabbable(), that._trigger("focus");
      }), this._makeFocusTarget(), this._trigger("open");
    }, "open"),
    _focusTabbable: /* @__PURE__ */ __name(function() {
      var hasFocus = this._focusedElement;
      hasFocus || (hasFocus = this.element.find("[autofocus]")), hasFocus.length || (hasFocus = this.element.find(":tabbable")), hasFocus.length || (hasFocus = this.uiDialogButtonPane.find(":tabbable")), hasFocus.length || (hasFocus = this.uiDialogTitlebarClose.filter(":tabbable")), hasFocus.length || (hasFocus = this.uiDialog), hasFocus.eq(0).trigger("focus");
    }, "_focusTabbable"),
    _restoreTabbableFocus: /* @__PURE__ */ __name(function() {
      var activeElement = this.document[0].activeElement, isActive = this.uiDialog[0] === activeElement || $2.contains(this.uiDialog[0], activeElement);
      isActive || this._focusTabbable();
    }, "_restoreTabbableFocus"),
    _keepFocus: /* @__PURE__ */ __name(function(event2) {
      event2.preventDefault(), this._restoreTabbableFocus();
    }, "_keepFocus"),
    _createWrapper: /* @__PURE__ */ __name(function() {
      this.uiDialog = $2("<div>").hide().attr({
        // Setting tabIndex makes the div focusable
        tabIndex: -1,
        role: "dialog",
        "aria-modal": this.options.modal ? "true" : null
      }).appendTo(this._appendTo()), this._addClass(this.uiDialog, "ui-dialog", "ui-widget ui-widget-content ui-front"), this._on(this.uiDialog, {
        keydown: /* @__PURE__ */ __name(function(event2) {
          if (this.options.closeOnEscape && !event2.isDefaultPrevented() && event2.keyCode && event2.keyCode === $2.ui.keyCode.ESCAPE) {
            event2.preventDefault(), this.close(event2);
            return;
          }
          if (!(event2.keyCode !== $2.ui.keyCode.TAB || event2.isDefaultPrevented())) {
            var tabbables = this.uiDialog.find(":tabbable"), first2 = tabbables.first(), last = tabbables.last();
            (event2.target === last[0] || event2.target === this.uiDialog[0]) && !event2.shiftKey ? (this._delay(function() {
              first2.trigger("focus");
            }), event2.preventDefault()) : (event2.target === first2[0] || event2.target === this.uiDialog[0]) && event2.shiftKey && (this._delay(function() {
              last.trigger("focus");
            }), event2.preventDefault());
          }
        }, "keydown"),
        mousedown: /* @__PURE__ */ __name(function(event2) {
          this._moveToTop(event2) && this._focusTabbable();
        }, "mousedown")
      }), this.element.find("[aria-describedby]").length || this.uiDialog.attr({
        "aria-describedby": this.element.uniqueId().attr("id")
      });
    }, "_createWrapper"),
    _createTitlebar: /* @__PURE__ */ __name(function() {
      var uiDialogTitle;
      this.uiDialogTitlebar = $2("<div>"), this._addClass(
        this.uiDialogTitlebar,
        "ui-dialog-titlebar",
        "ui-widget-header ui-helper-clearfix"
      ), this._on(this.uiDialogTitlebar, {
        mousedown: /* @__PURE__ */ __name(function(event2) {
          $2(event2.target).closest(".ui-dialog-titlebar-close") || this.uiDialog.trigger("focus");
        }, "mousedown")
      }), this.uiDialogTitlebarClose = $2("<button type='button'></button>").button({
        label: $2("<a>").text(this.options.closeText).html(),
        icon: "ui-icon-closethick",
        showLabel: !1
      }).appendTo(this.uiDialogTitlebar), this._addClass(this.uiDialogTitlebarClose, "ui-dialog-titlebar-close"), this._on(this.uiDialogTitlebarClose, {
        click: /* @__PURE__ */ __name(function(event2) {
          event2.preventDefault(), this.close(event2);
        }, "click")
      });
      var uiDialogHeadingLevel = Number.isInteger(this.options.uiDialogTitleHeadingLevel) && this.options.uiDialogTitleHeadingLevel > 0 && this.options.uiDialogTitleHeadingLevel <= 6 ? "h" + this.options.uiDialogTitleHeadingLevel : "span";
      uiDialogTitle = $2("<" + uiDialogHeadingLevel + ">").uniqueId().prependTo(this.uiDialogTitlebar), this._addClass(uiDialogTitle, "ui-dialog-title"), this._title(uiDialogTitle), this.uiDialogTitlebar.prependTo(this.uiDialog), this.uiDialog.attr({
        "aria-labelledby": uiDialogTitle.attr("id")
      });
    }, "_createTitlebar"),
    _title: /* @__PURE__ */ __name(function(title2) {
      this.options.title ? title2.text(this.options.title) : title2.html("&#160;");
    }, "_title"),
    _createButtonPane: /* @__PURE__ */ __name(function() {
      this.uiDialogButtonPane = $2("<div>"), this._addClass(
        this.uiDialogButtonPane,
        "ui-dialog-buttonpane",
        "ui-widget-content ui-helper-clearfix"
      ), this.uiButtonSet = $2("<div>").appendTo(this.uiDialogButtonPane), this._addClass(this.uiButtonSet, "ui-dialog-buttonset"), this._createButtons();
    }, "_createButtonPane"),
    _createButtons: /* @__PURE__ */ __name(function() {
      var that = this, buttons = this.options.buttons;
      if (this.uiDialogButtonPane.remove(), this.uiButtonSet.empty(), $2.isEmptyObject(buttons) || Array.isArray(buttons) && !buttons.length) {
        this._removeClass(this.uiDialog, "ui-dialog-buttons");
        return;
      }
      $2.each(buttons, function(name2, props2) {
        var click2, buttonOptions;
        props2 = typeof props2 == "function" ? { click: props2, text: name2 } : props2, props2 = $2.extend({ type: "button" }, props2), click2 = props2.click, buttonOptions = {
          icon: props2.icon,
          iconPosition: props2.iconPosition,
          showLabel: props2.showLabel,
          // Deprecated options
          icons: props2.icons,
          text: props2.text
        }, delete props2.click, delete props2.icon, delete props2.iconPosition, delete props2.showLabel, delete props2.icons, typeof props2.text == "boolean" && delete props2.text, $2("<button></button>", props2).button(buttonOptions).appendTo(that.uiButtonSet).on("click", function() {
          click2.apply(that.element[0], arguments);
        });
      }), this._addClass(this.uiDialog, "ui-dialog-buttons"), this.uiDialogButtonPane.appendTo(this.uiDialog);
    }, "_createButtons"),
    _makeDraggable: /* @__PURE__ */ __name(function() {
      var that = this, options2 = this.options;
      function filteredUi(ui) {
        return {
          position: ui.position,
          offset: ui.offset
        };
      }
      __name(filteredUi, "filteredUi"), this.uiDialog.draggable({
        cancel: ".ui-dialog-content, .ui-dialog-titlebar-close",
        handle: ".ui-dialog-titlebar",
        containment: "document",
        start: /* @__PURE__ */ __name(function(event2, ui) {
          that._addClass($2(this), "ui-dialog-dragging"), that._blockFrames(), that._trigger("dragStart", event2, filteredUi(ui));
        }, "start"),
        drag: /* @__PURE__ */ __name(function(event2, ui) {
          that._trigger("drag", event2, filteredUi(ui));
        }, "drag"),
        stop: /* @__PURE__ */ __name(function(event2, ui) {
          var left2 = ui.offset.left - that.document.scrollLeft(), top2 = ui.offset.top - that.document.scrollTop();
          options2.position = {
            my: "left top",
            at: "left" + (left2 >= 0 ? "+" : "") + left2 + " top" + (top2 >= 0 ? "+" : "") + top2,
            of: that.window
          }, that._removeClass($2(this), "ui-dialog-dragging"), that._unblockFrames(), that._trigger("dragStop", event2, filteredUi(ui));
        }, "stop")
      });
    }, "_makeDraggable"),
    _makeResizable: /* @__PURE__ */ __name(function() {
      var that = this, options2 = this.options, handles = options2.resizable, position3 = this.uiDialog.css("position"), resizeHandles = typeof handles == "string" ? handles : "n,e,s,w,se,sw,ne,nw";
      function filteredUi(ui) {
        return {
          originalPosition: ui.originalPosition,
          originalSize: ui.originalSize,
          position: ui.position,
          size: ui.size
        };
      }
      __name(filteredUi, "filteredUi"), this.uiDialog.resizable({
        cancel: ".ui-dialog-content",
        containment: "document",
        alsoResize: this.element,
        maxWidth: options2.maxWidth,
        maxHeight: options2.maxHeight,
        minWidth: options2.minWidth,
        minHeight: this._minHeight(),
        handles: resizeHandles,
        start: /* @__PURE__ */ __name(function(event2, ui) {
          that._addClass($2(this), "ui-dialog-resizing"), that._blockFrames(), that._trigger("resizeStart", event2, filteredUi(ui));
        }, "start"),
        resize: /* @__PURE__ */ __name(function(event2, ui) {
          that._trigger("resize", event2, filteredUi(ui));
        }, "resize"),
        stop: /* @__PURE__ */ __name(function(event2, ui) {
          var offset3 = that.uiDialog.offset(), left2 = offset3.left - that.document.scrollLeft(), top2 = offset3.top - that.document.scrollTop();
          options2.height = that.uiDialog.height(), options2.width = that.uiDialog.width(), options2.position = {
            my: "left top",
            at: "left" + (left2 >= 0 ? "+" : "") + left2 + " top" + (top2 >= 0 ? "+" : "") + top2,
            of: that.window
          }, that._removeClass($2(this), "ui-dialog-resizing"), that._unblockFrames(), that._trigger("resizeStop", event2, filteredUi(ui));
        }, "stop")
      }).css("position", position3);
    }, "_makeResizable"),
    _trackFocus: /* @__PURE__ */ __name(function() {
      this._on(this.widget(), {
        focusin: /* @__PURE__ */ __name(function(event2) {
          this._makeFocusTarget(), this._focusedElement = $2(event2.target);
        }, "focusin")
      });
    }, "_trackFocus"),
    _makeFocusTarget: /* @__PURE__ */ __name(function() {
      this._untrackInstance(), this._trackingInstances().unshift(this);
    }, "_makeFocusTarget"),
    _untrackInstance: /* @__PURE__ */ __name(function() {
      var instances = this._trackingInstances(), exists = $2.inArray(this, instances);
      exists !== -1 && instances.splice(exists, 1);
    }, "_untrackInstance"),
    _trackingInstances: /* @__PURE__ */ __name(function() {
      var instances = this.document.data("ui-dialog-instances");
      return instances || (instances = [], this.document.data("ui-dialog-instances", instances)), instances;
    }, "_trackingInstances"),
    _minHeight: /* @__PURE__ */ __name(function() {
      var options2 = this.options;
      return options2.height === "auto" ? options2.minHeight : Math.min(options2.minHeight, options2.height);
    }, "_minHeight"),
    _position: /* @__PURE__ */ __name(function() {
      var isVisible3 = this.uiDialog.is(":visible");
      isVisible3 || this.uiDialog.show(), this.uiDialog.position(this.options.position), isVisible3 || this.uiDialog.hide();
    }, "_position"),
    _setOptions: /* @__PURE__ */ __name(function(options2) {
      var that = this, resize = !1, resizableOptions = {};
      $2.each(options2, function(key, value3) {
        that._setOption(key, value3), key in that.sizeRelatedOptions && (resize = !0), key in that.resizableRelatedOptions && (resizableOptions[key] = value3);
      }), resize && (this._size(), this._position()), this.uiDialog.is(":data(ui-resizable)") && this.uiDialog.resizable("option", resizableOptions);
    }, "_setOptions"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      var isDraggable, isResizable, uiDialog = this.uiDialog;
      key !== "disabled" && (this._super(key, value3), key === "appendTo" && this.uiDialog.appendTo(this._appendTo()), key === "buttons" && this._createButtons(), key === "closeText" && this.uiDialogTitlebarClose.button({
        // Ensure that we always pass a string
        label: $2("<a>").text("" + this.options.closeText).html()
      }), key === "draggable" && (isDraggable = uiDialog.is(":data(ui-draggable)"), isDraggable && !value3 && uiDialog.draggable("destroy"), !isDraggable && value3 && this._makeDraggable()), key === "position" && this._position(), key === "resizable" && (isResizable = uiDialog.is(":data(ui-resizable)"), isResizable && !value3 && uiDialog.resizable("destroy"), isResizable && typeof value3 == "string" && uiDialog.resizable("option", "handles", value3), !isResizable && value3 !== !1 && this._makeResizable()), key === "title" && this._title(this.uiDialogTitlebar.find(".ui-dialog-title")), key === "modal" && uiDialog.attr("aria-modal", value3 ? "true" : null));
    }, "_setOption"),
    _size: /* @__PURE__ */ __name(function() {
      var nonContentHeight, minContentHeight, maxContentHeight, options2 = this.options;
      this.element.show().css({
        width: "auto",
        minHeight: 0,
        maxHeight: "none",
        height: 0
      }), options2.minWidth > options2.width && (options2.width = options2.minWidth), nonContentHeight = this.uiDialog.css({
        height: "auto",
        width: options2.width
      }).outerHeight(), minContentHeight = Math.max(0, options2.minHeight - nonContentHeight), maxContentHeight = typeof options2.maxHeight == "number" ? Math.max(0, options2.maxHeight - nonContentHeight) : "none", options2.height === "auto" ? this.element.css({
        minHeight: minContentHeight,
        maxHeight: maxContentHeight,
        height: "auto"
      }) : this.element.height(Math.max(0, options2.height - nonContentHeight)), this.uiDialog.is(":data(ui-resizable)") && this.uiDialog.resizable("option", "minHeight", this._minHeight());
    }, "_size"),
    _blockFrames: /* @__PURE__ */ __name(function() {
      this.iframeBlocks = this.document.find("iframe").map(function() {
        var iframe = $2(this);
        return $2("<div>").css({
          position: "absolute",
          width: iframe.outerWidth(),
          height: iframe.outerHeight()
        }).appendTo(iframe.parent()).offset(iframe.offset())[0];
      });
    }, "_blockFrames"),
    _unblockFrames: /* @__PURE__ */ __name(function() {
      this.iframeBlocks && (this.iframeBlocks.remove(), delete this.iframeBlocks);
    }, "_unblockFrames"),
    _allowInteraction: /* @__PURE__ */ __name(function(event2) {
      return $2(event2.target).closest(".ui-dialog").length ? !0 : !!$2(event2.target).closest(".ui-datepicker").length;
    }, "_allowInteraction"),
    _createOverlay: /* @__PURE__ */ __name(function() {
      if (this.options.modal) {
        var isOpening = !0;
        this._delay(function() {
          isOpening = !1;
        }), this.document.data("ui-dialog-overlays") || this.document.on("focusin.ui-dialog", (function(event2) {
          if (!isOpening) {
            var instance = this._trackingInstances()[0];
            instance._allowInteraction(event2) || (event2.preventDefault(), instance._focusTabbable());
          }
        }).bind(this)), this.overlay = $2("<div>").appendTo(this._appendTo()), this._addClass(this.overlay, null, "ui-widget-overlay ui-front"), this._on(this.overlay, {
          mousedown: "_keepFocus"
        }), this.document.data(
          "ui-dialog-overlays",
          (this.document.data("ui-dialog-overlays") || 0) + 1
        );
      }
    }, "_createOverlay"),
    _destroyOverlay: /* @__PURE__ */ __name(function() {
      if (this.options.modal && this.overlay) {
        var overlays = this.document.data("ui-dialog-overlays") - 1;
        overlays ? this.document.data("ui-dialog-overlays", overlays) : (this.document.off("focusin.ui-dialog"), this.document.removeData("ui-dialog-overlays")), this.overlay.remove(), this.overlay = null;
      }
    }, "_destroyOverlay")
  }), $2.uiBackCompat === !0 && $2.widget("ui.dialog", $2.ui.dialog, {
    options: {
      dialogClass: ""
    },
    _createWrapper: /* @__PURE__ */ __name(function() {
      this._super(), this.uiDialog.addClass(this.options.dialogClass);
    }, "_createWrapper"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      key === "dialogClass" && this.uiDialog.removeClass(this.options.dialogClass).addClass(value3), this._superApply(arguments);
    }, "_setOption")
  }), $2.ui.dialog;
  /*!
   * jQuery UI Droppable 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.droppable", {
    version: "1.14.1",
    widgetEventPrefix: "drop",
    options: {
      accept: "*",
      addClasses: !0,
      greedy: !1,
      scope: "default",
      tolerance: "intersect",
      // Callbacks
      activate: null,
      deactivate: null,
      drop: null,
      out: null,
      over: null
    },
    _create: /* @__PURE__ */ __name(function() {
      var proportions, o = this.options, accept = o.accept;
      this.isover = !1, this.isout = !0, this.accept = typeof accept == "function" ? accept : function(d) {
        return d.is(accept);
      }, this.proportions = function() {
        if (arguments.length)
          proportions = arguments[0];
        else
          return proportions || (proportions = {
            width: this.element[0].offsetWidth,
            height: this.element[0].offsetHeight
          });
      }, this._addToManager(o.scope), o.addClasses && this._addClass("ui-droppable");
    }, "_create"),
    _addToManager: /* @__PURE__ */ __name(function(scope) {
      $2.ui.ddmanager.droppables[scope] = $2.ui.ddmanager.droppables[scope] || [], $2.ui.ddmanager.droppables[scope].push(this);
    }, "_addToManager"),
    _splice: /* @__PURE__ */ __name(function(drop3) {
      for (var i = 0; i < drop3.length; i++)
        drop3[i] === this && drop3.splice(i, 1);
    }, "_splice"),
    _destroy: /* @__PURE__ */ __name(function() {
      var drop3 = $2.ui.ddmanager.droppables[this.options.scope];
      this._splice(drop3);
    }, "_destroy"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      if (key === "accept")
        this.accept = typeof value3 == "function" ? value3 : function(d) {
          return d.is(value3);
        };
      else if (key === "scope") {
        var drop3 = $2.ui.ddmanager.droppables[this.options.scope];
        this._splice(drop3), this._addToManager(value3);
      }
      this._super(key, value3);
    }, "_setOption"),
    _activate: /* @__PURE__ */ __name(function(event2) {
      var draggable2 = $2.ui.ddmanager.current;
      this._addActiveClass(), draggable2 && this._trigger("activate", event2, this.ui(draggable2));
    }, "_activate"),
    _deactivate: /* @__PURE__ */ __name(function(event2) {
      var draggable2 = $2.ui.ddmanager.current;
      this._removeActiveClass(), draggable2 && this._trigger("deactivate", event2, this.ui(draggable2));
    }, "_deactivate"),
    _over: /* @__PURE__ */ __name(function(event2) {
      var draggable2 = $2.ui.ddmanager.current;
      !draggable2 || (draggable2.currentItem || draggable2.element)[0] === this.element[0] || this.accept.call(this.element[0], draggable2.currentItem || draggable2.element) && (this._addHoverClass(), this._trigger("over", event2, this.ui(draggable2)));
    }, "_over"),
    _out: /* @__PURE__ */ __name(function(event2) {
      var draggable2 = $2.ui.ddmanager.current;
      !draggable2 || (draggable2.currentItem || draggable2.element)[0] === this.element[0] || this.accept.call(this.element[0], draggable2.currentItem || draggable2.element) && (this._removeHoverClass(), this._trigger("out", event2, this.ui(draggable2)));
    }, "_out"),
    _drop: /* @__PURE__ */ __name(function(event2, custom2) {
      var draggable2 = custom2 || $2.ui.ddmanager.current, childrenIntersection = !1;
      return !draggable2 || (draggable2.currentItem || draggable2.element)[0] === this.element[0] || (this.element.find(":data(ui-droppable)").not(".ui-draggable-dragging").each(function() {
        var inst = $2(this).droppable("instance");
        if (inst.options.greedy && !inst.options.disabled && inst.options.scope === draggable2.options.scope && inst.accept.call(
          inst.element[0],
          draggable2.currentItem || draggable2.element
        ) && $2.ui.intersect(
          draggable2,
          $2.extend(inst, { offset: inst.element.offset() }),
          inst.options.tolerance,
          event2
        ))
          return childrenIntersection = !0, !1;
      }), childrenIntersection) ? !1 : this.accept.call(
        this.element[0],
        draggable2.currentItem || draggable2.element
      ) ? (this._removeActiveClass(), this._removeHoverClass(), this._trigger("drop", event2, this.ui(draggable2)), this.element) : !1;
    }, "_drop"),
    ui: /* @__PURE__ */ __name(function(c) {
      return {
        draggable: c.currentItem || c.element,
        helper: c.helper,
        position: c.position,
        offset: c.positionAbs
      };
    }, "ui"),
    // Extension points just to make backcompat sane and avoid duplicating logic
    // TODO: Remove in 1.14 along with call to it below
    _addHoverClass: /* @__PURE__ */ __name(function() {
      this._addClass("ui-droppable-hover");
    }, "_addHoverClass"),
    _removeHoverClass: /* @__PURE__ */ __name(function() {
      this._removeClass("ui-droppable-hover");
    }, "_removeHoverClass"),
    _addActiveClass: /* @__PURE__ */ __name(function() {
      this._addClass("ui-droppable-active");
    }, "_addActiveClass"),
    _removeActiveClass: /* @__PURE__ */ __name(function() {
      this._removeClass("ui-droppable-active");
    }, "_removeActiveClass")
  }), $2.ui.intersect = function() {
    function isOverAxis(x, reference2, size2) {
      return x >= reference2 && x < reference2 + size2;
    }
    return __name(isOverAxis, "isOverAxis"), function(draggable2, droppable, toleranceMode, event2) {
      if (!droppable.offset)
        return !1;
      var x1 = (draggable2.positionAbs || draggable2.position.absolute).left + draggable2.margins.left, y1 = (draggable2.positionAbs || draggable2.position.absolute).top + draggable2.margins.top, x2 = x1 + draggable2.helperProportions.width, y2 = y1 + draggable2.helperProportions.height, l = droppable.offset.left, t2 = droppable.offset.top, r2 = l + droppable.proportions().width, b = t2 + droppable.proportions().height;
      switch (toleranceMode) {
        case "fit":
          return l <= x1 && x2 <= r2 && t2 <= y1 && y2 <= b;
        case "intersect":
          return l < x1 + draggable2.helperProportions.width / 2 && // Right Half
          x2 - draggable2.helperProportions.width / 2 < r2 && // Left Half
          t2 < y1 + draggable2.helperProportions.height / 2 && // Bottom Half
          y2 - draggable2.helperProportions.height / 2 < b;
        case "pointer":
          return isOverAxis(event2.pageY, t2, droppable.proportions().height) && isOverAxis(event2.pageX, l, droppable.proportions().width);
        case "touch":
          return (y1 >= t2 && y1 <= b || // Top edge touching
          y2 >= t2 && y2 <= b || // Bottom edge touching
          y1 < t2 && y2 > b) && (x1 >= l && x1 <= r2 || // Left edge touching
          x2 >= l && x2 <= r2 || // Right edge touching
          x1 < l && x2 > r2);
        default:
          return !1;
      }
    };
  }(), $2.ui.ddmanager = {
    current: null,
    droppables: { default: [] },
    prepareOffsets: /* @__PURE__ */ __name(function(t2, event2) {
      var i, j, m = $2.ui.ddmanager.droppables[t2.options.scope] || [], type2 = event2 ? event2.type : null, list = (t2.currentItem || t2.element).find(":data(ui-droppable)").addBack();
      droppablesLoop: for (i = 0; i < m.length; i++)
        if (!(m[i].options.disabled || t2 && !m[i].accept.call(
          m[i].element[0],
          t2.currentItem || t2.element
        ))) {
          for (j = 0; j < list.length; j++)
            if (list[j] === m[i].element[0]) {
              m[i].proportions().height = 0;
              continue droppablesLoop;
            }
          m[i].visible = m[i].element.css("display") !== "none", m[i].visible && (type2 === "mousedown" && m[i]._activate.call(m[i], event2), m[i].offset = m[i].element.offset(), m[i].proportions({
            width: m[i].element[0].offsetWidth,
            height: m[i].element[0].offsetHeight
          }));
        }
    }, "prepareOffsets"),
    drop: /* @__PURE__ */ __name(function(draggable2, event2) {
      var dropped = !1;
      return $2.each(($2.ui.ddmanager.droppables[draggable2.options.scope] || []).slice(), function() {
        this.options && (!this.options.disabled && this.visible && $2.ui.intersect(draggable2, this, this.options.tolerance, event2) && (dropped = this._drop.call(this, event2) || dropped), !this.options.disabled && this.visible && this.accept.call(
          this.element[0],
          draggable2.currentItem || draggable2.element
        ) && (this.isout = !0, this.isover = !1, this._deactivate.call(this, event2)));
      }), dropped;
    }, "drop"),
    dragStart: /* @__PURE__ */ __name(function(draggable2, event2) {
      draggable2.element.parentsUntil("body").on("scroll.droppable", function() {
        draggable2.options.refreshPositions || $2.ui.ddmanager.prepareOffsets(draggable2, event2);
      });
    }, "dragStart"),
    drag: /* @__PURE__ */ __name(function(draggable2, event2) {
      draggable2.options.refreshPositions && $2.ui.ddmanager.prepareOffsets(draggable2, event2), $2.each($2.ui.ddmanager.droppables[draggable2.options.scope] || [], function() {
        if (!(this.options.disabled || this.greedyChild || !this.visible)) {
          var parentInstance, scope, parent, intersects = $2.ui.intersect(draggable2, this, this.options.tolerance, event2), c = !intersects && this.isover ? "isout" : intersects && !this.isover ? "isover" : null;
          c && (this.options.greedy && (scope = this.options.scope, parent = this.element.parents(":data(ui-droppable)").filter(function() {
            return $2(this).droppable("instance").options.scope === scope;
          }), parent.length && (parentInstance = $2(parent[0]).droppable("instance"), parentInstance.greedyChild = c === "isover")), parentInstance && c === "isover" && (parentInstance.isover = !1, parentInstance.isout = !0, parentInstance._out.call(parentInstance, event2)), this[c] = !0, this[c === "isout" ? "isover" : "isout"] = !1, this[c === "isover" ? "_over" : "_out"].call(this, event2), parentInstance && c === "isout" && (parentInstance.isout = !1, parentInstance.isover = !0, parentInstance._over.call(parentInstance, event2)));
        }
      });
    }, "drag"),
    dragStop: /* @__PURE__ */ __name(function(draggable2, event2) {
      draggable2.element.parentsUntil("body").off("scroll.droppable"), draggable2.options.refreshPositions || $2.ui.ddmanager.prepareOffsets(draggable2, event2);
    }, "dragStop")
  }, $2.uiBackCompat === !0 && $2.widget("ui.droppable", $2.ui.droppable, {
    options: {
      hoverClass: !1,
      activeClass: !1
    },
    _addActiveClass: /* @__PURE__ */ __name(function() {
      this._super(), this.options.activeClass && this.element.addClass(this.options.activeClass);
    }, "_addActiveClass"),
    _removeActiveClass: /* @__PURE__ */ __name(function() {
      this._super(), this.options.activeClass && this.element.removeClass(this.options.activeClass);
    }, "_removeActiveClass"),
    _addHoverClass: /* @__PURE__ */ __name(function() {
      this._super(), this.options.hoverClass && this.element.addClass(this.options.hoverClass);
    }, "_addHoverClass"),
    _removeHoverClass: /* @__PURE__ */ __name(function() {
      this._super(), this.options.hoverClass && this.element.removeClass(this.options.hoverClass);
    }, "_removeHoverClass")
  }), $2.ui.droppable;
  /*!
   * jQuery UI Progressbar 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.progressbar", {
    version: "1.14.1",
    options: {
      classes: {
        "ui-progressbar": "ui-corner-all",
        "ui-progressbar-value": "ui-corner-left",
        "ui-progressbar-complete": "ui-corner-right"
      },
      max: 100,
      value: 0,
      change: null,
      complete: null
    },
    min: 0,
    _create: /* @__PURE__ */ __name(function() {
      this.oldValue = this.options.value = this._constrainedValue(), this.element.attr({
        // Only set static values; aria-valuenow and aria-valuemax are
        // set inside _refreshValue()
        role: "progressbar",
        "aria-valuemin": this.min
      }), this._addClass("ui-progressbar", "ui-widget ui-widget-content"), this.valueDiv = $2("<div>").appendTo(this.element), this._addClass(this.valueDiv, "ui-progressbar-value", "ui-widget-header"), this._refreshValue();
    }, "_create"),
    _destroy: /* @__PURE__ */ __name(function() {
      this.element.removeAttr("role aria-valuemin aria-valuemax aria-valuenow"), this.valueDiv.remove();
    }, "_destroy"),
    value: /* @__PURE__ */ __name(function(newValue) {
      if (newValue === void 0)
        return this.options.value;
      this.options.value = this._constrainedValue(newValue), this._refreshValue();
    }, "value"),
    _constrainedValue: /* @__PURE__ */ __name(function(newValue) {
      return newValue === void 0 && (newValue = this.options.value), this.indeterminate = newValue === !1, typeof newValue != "number" && (newValue = 0), this.indeterminate ? !1 : Math.min(this.options.max, Math.max(this.min, newValue));
    }, "_constrainedValue"),
    _setOptions: /* @__PURE__ */ __name(function(options2) {
      var value3 = options2.value;
      delete options2.value, this._super(options2), this.options.value = this._constrainedValue(value3), this._refreshValue();
    }, "_setOptions"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      key === "max" && (value3 = Math.max(this.min, value3)), this._super(key, value3);
    }, "_setOption"),
    _setOptionDisabled: /* @__PURE__ */ __name(function(value3) {
      this._super(value3), this.element.attr("aria-disabled", value3), this._toggleClass(null, "ui-state-disabled", !!value3);
    }, "_setOptionDisabled"),
    _percentage: /* @__PURE__ */ __name(function() {
      return this.indeterminate ? 100 : 100 * (this.options.value - this.min) / (this.options.max - this.min);
    }, "_percentage"),
    _refreshValue: /* @__PURE__ */ __name(function() {
      var value3 = this.options.value, percentage = this._percentage();
      this.valueDiv.toggle(this.indeterminate || value3 > this.min).width(percentage.toFixed(0) + "%"), this._toggleClass(
        this.valueDiv,
        "ui-progressbar-complete",
        null,
        value3 === this.options.max
      )._toggleClass("ui-progressbar-indeterminate", null, this.indeterminate), this.indeterminate ? (this.element.removeAttr("aria-valuenow"), this.overlayDiv || (this.overlayDiv = $2("<div>").appendTo(this.valueDiv), this._addClass(this.overlayDiv, "ui-progressbar-overlay"))) : (this.element.attr({
        "aria-valuemax": this.options.max,
        "aria-valuenow": value3
      }), this.overlayDiv && (this.overlayDiv.remove(), this.overlayDiv = null)), this.oldValue !== value3 && (this.oldValue = value3, this._trigger("change")), value3 === this.options.max && this._trigger("complete");
    }, "_refreshValue")
  });
  /*!
   * jQuery UI Selectable 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.selectable", $2.ui.mouse, {
    version: "1.14.1",
    options: {
      appendTo: "body",
      autoRefresh: !0,
      distance: 0,
      filter: "*",
      tolerance: "touch",
      // Callbacks
      selected: null,
      selecting: null,
      start: null,
      stop: null,
      unselected: null,
      unselecting: null
    },
    _create: /* @__PURE__ */ __name(function() {
      var that = this;
      this._addClass("ui-selectable"), this.dragged = !1, this.refresh = function() {
        that.elementPos = $2(that.element[0]).offset(), that.selectees = $2(that.options.filter, that.element[0]), that._addClass(that.selectees, "ui-selectee"), that.selectees.each(function() {
          var $this = $2(this), selecteeOffset = $this.offset(), pos = {
            left: selecteeOffset.left - that.elementPos.left,
            top: selecteeOffset.top - that.elementPos.top
          };
          $2.data(this, "selectable-item", {
            element: this,
            $element: $this,
            left: pos.left,
            top: pos.top,
            right: pos.left + $this.outerWidth(),
            bottom: pos.top + $this.outerHeight(),
            startselected: !1,
            selected: $this.hasClass("ui-selected"),
            selecting: $this.hasClass("ui-selecting"),
            unselecting: $this.hasClass("ui-unselecting")
          });
        });
      }, this.refresh(), this._mouseInit(), this.helper = $2("<div>"), this._addClass(this.helper, "ui-selectable-helper");
    }, "_create"),
    _destroy: /* @__PURE__ */ __name(function() {
      this.selectees.removeData("selectable-item"), this._mouseDestroy();
    }, "_destroy"),
    _mouseStart: /* @__PURE__ */ __name(function(event2) {
      var that = this, options2 = this.options;
      this.opos = [event2.pageX, event2.pageY], this.elementPos = $2(this.element[0]).offset(), !this.options.disabled && (this.selectees = $2(options2.filter, this.element[0]), this._trigger("start", event2), $2(options2.appendTo).append(this.helper), this.helper.css({
        left: event2.pageX,
        top: event2.pageY,
        width: 0,
        height: 0
      }), options2.autoRefresh && this.refresh(), this.selectees.filter(".ui-selected").each(function() {
        var selectee = $2.data(this, "selectable-item");
        selectee.startselected = !0, !event2.metaKey && !event2.ctrlKey && (that._removeClass(selectee.$element, "ui-selected"), selectee.selected = !1, that._addClass(selectee.$element, "ui-unselecting"), selectee.unselecting = !0, that._trigger("unselecting", event2, {
          unselecting: selectee.element
        }));
      }), $2(event2.target).parents().addBack().each(function() {
        var doSelect, selectee = $2.data(this, "selectable-item");
        if (selectee)
          return doSelect = !event2.metaKey && !event2.ctrlKey || !selectee.$element.hasClass("ui-selected"), that._removeClass(selectee.$element, doSelect ? "ui-unselecting" : "ui-selected")._addClass(selectee.$element, doSelect ? "ui-selecting" : "ui-unselecting"), selectee.unselecting = !doSelect, selectee.selecting = doSelect, selectee.selected = doSelect, doSelect ? that._trigger("selecting", event2, {
            selecting: selectee.element
          }) : that._trigger("unselecting", event2, {
            unselecting: selectee.element
          }), !1;
      }));
    }, "_mouseStart"),
    _mouseDrag: /* @__PURE__ */ __name(function(event2) {
      if (this.dragged = !0, !this.options.disabled) {
        var tmp, that = this, options2 = this.options, x1 = this.opos[0], y1 = this.opos[1], x2 = event2.pageX, y2 = event2.pageY;
        return x1 > x2 && (tmp = x2, x2 = x1, x1 = tmp), y1 > y2 && (tmp = y2, y2 = y1, y1 = tmp), this.helper.css({ left: x1, top: y1, width: x2 - x1, height: y2 - y1 }), this.selectees.each(function() {
          var selectee = $2.data(this, "selectable-item"), hit = !1, offset3 = {};
          !selectee || selectee.element === that.element[0] || (offset3.left = selectee.left + that.elementPos.left, offset3.right = selectee.right + that.elementPos.left, offset3.top = selectee.top + that.elementPos.top, offset3.bottom = selectee.bottom + that.elementPos.top, options2.tolerance === "touch" ? hit = !(offset3.left > x2 || offset3.right < x1 || offset3.top > y2 || offset3.bottom < y1) : options2.tolerance === "fit" && (hit = offset3.left > x1 && offset3.right < x2 && offset3.top > y1 && offset3.bottom < y2), hit ? (selectee.selected && (that._removeClass(selectee.$element, "ui-selected"), selectee.selected = !1), selectee.unselecting && (that._removeClass(selectee.$element, "ui-unselecting"), selectee.unselecting = !1), selectee.selecting || (that._addClass(selectee.$element, "ui-selecting"), selectee.selecting = !0, that._trigger("selecting", event2, {
            selecting: selectee.element
          }))) : (selectee.selecting && ((event2.metaKey || event2.ctrlKey) && selectee.startselected ? (that._removeClass(selectee.$element, "ui-selecting"), selectee.selecting = !1, that._addClass(selectee.$element, "ui-selected"), selectee.selected = !0) : (that._removeClass(selectee.$element, "ui-selecting"), selectee.selecting = !1, selectee.startselected && (that._addClass(selectee.$element, "ui-unselecting"), selectee.unselecting = !0), that._trigger("unselecting", event2, {
            unselecting: selectee.element
          }))), selectee.selected && !event2.metaKey && !event2.ctrlKey && !selectee.startselected && (that._removeClass(selectee.$element, "ui-selected"), selectee.selected = !1, that._addClass(selectee.$element, "ui-unselecting"), selectee.unselecting = !0, that._trigger("unselecting", event2, {
            unselecting: selectee.element
          }))));
        }), !1;
      }
    }, "_mouseDrag"),
    _mouseStop: /* @__PURE__ */ __name(function(event2) {
      var that = this;
      return this.dragged = !1, $2(".ui-unselecting", this.element[0]).each(function() {
        var selectee = $2.data(this, "selectable-item");
        that._removeClass(selectee.$element, "ui-unselecting"), selectee.unselecting = !1, selectee.startselected = !1, that._trigger("unselected", event2, {
          unselected: selectee.element
        });
      }), $2(".ui-selecting", this.element[0]).each(function() {
        var selectee = $2.data(this, "selectable-item");
        that._removeClass(selectee.$element, "ui-selecting")._addClass(selectee.$element, "ui-selected"), selectee.selecting = !1, selectee.selected = !0, selectee.startselected = !0, that._trigger("selected", event2, {
          selected: selectee.element
        });
      }), this._trigger("stop", event2), this.helper.remove(), !1;
    }, "_mouseStop")
  });
  /*!
   * jQuery UI Selectmenu 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.selectmenu", [$2.ui.formResetMixin, {
    version: "1.14.1",
    defaultElement: "<select>",
    options: {
      appendTo: null,
      classes: {
        "ui-selectmenu-button-open": "ui-corner-top",
        "ui-selectmenu-button-closed": "ui-corner-all"
      },
      disabled: null,
      icons: {
        button: "ui-icon-triangle-1-s"
      },
      position: {
        my: "left top",
        at: "left bottom",
        collision: "none"
      },
      width: !1,
      // Callbacks
      change: null,
      close: null,
      focus: null,
      open: null,
      select: null
    },
    _create: /* @__PURE__ */ __name(function() {
      var selectmenuId = this.element.uniqueId().attr("id");
      this.ids = {
        element: selectmenuId,
        button: selectmenuId + "-button",
        menu: selectmenuId + "-menu"
      }, this._drawButton(), this._drawMenu(), this._bindFormResetHandler(), this._rendered = !1, this.menuItems = $2();
    }, "_create"),
    _drawButton: /* @__PURE__ */ __name(function() {
      var icon, that = this, item = this._parseOption(
        this.element.find("option:selected"),
        this.element[0].selectedIndex
      );
      this.labels = this.element.labels().attr("for", this.ids.button), this._on(this.labels, {
        click: /* @__PURE__ */ __name(function(event2) {
          this.button.trigger("focus"), event2.preventDefault();
        }, "click")
      }), this.element.hide(), this.button = $2("<span>", {
        tabindex: this.options.disabled ? -1 : 0,
        id: this.ids.button,
        role: "combobox",
        "aria-expanded": "false",
        "aria-autocomplete": "list",
        "aria-owns": this.ids.menu,
        "aria-haspopup": "true",
        title: this.element.attr("title")
      }).insertAfter(this.element), this._addClass(
        this.button,
        "ui-selectmenu-button ui-selectmenu-button-closed",
        "ui-button ui-widget"
      ), icon = $2("<span>").appendTo(this.button), this._addClass(icon, "ui-selectmenu-icon", "ui-icon " + this.options.icons.button), this.buttonItem = this._renderButtonItem(item).appendTo(this.button), this.options.width !== !1 && this._resizeButton(), this._on(this.button, this._buttonEvents), this.button.one("focusin", function() {
        that._rendered || that._refreshMenu();
      });
    }, "_drawButton"),
    _drawMenu: /* @__PURE__ */ __name(function() {
      var that = this;
      this.menu = $2("<ul>", {
        "aria-hidden": "true",
        "aria-labelledby": this.ids.button,
        id: this.ids.menu
      }), this.menuWrap = $2("<div>").append(this.menu), this._addClass(this.menuWrap, "ui-selectmenu-menu", "ui-front"), this.menuWrap.appendTo(this._appendTo()), this.menuInstance = this.menu.menu({
        classes: {
          "ui-menu": "ui-corner-bottom"
        },
        role: "listbox",
        select: /* @__PURE__ */ __name(function(event2, ui) {
          event2.preventDefault(), that._select(ui.item.data("ui-selectmenu-item"), event2);
        }, "select"),
        focus: /* @__PURE__ */ __name(function(event2, ui) {
          var item = ui.item.data("ui-selectmenu-item");
          that.focusIndex != null && item.index !== that.focusIndex && (that._trigger("focus", event2, { item }), that.isOpen || that._select(item, event2)), that.focusIndex = item.index, that.button.attr(
            "aria-activedescendant",
            that.menuItems.eq(item.index).attr("id")
          );
        }, "focus")
      }).menu("instance"), this.menuInstance._off(this.menu, "mouseleave"), this.menuInstance._closeOnDocumentClick = function() {
        return !1;
      }, this.menuInstance._isDivider = function() {
        return !1;
      };
    }, "_drawMenu"),
    refresh: /* @__PURE__ */ __name(function() {
      this._refreshMenu(), this.buttonItem.replaceWith(
        this.buttonItem = this._renderButtonItem(
          // Fall back to an empty object in case there are no options
          this._getSelectedItem().data("ui-selectmenu-item") || {}
        )
      ), this.options.width === null && this._resizeButton();
    }, "refresh"),
    _refreshMenu: /* @__PURE__ */ __name(function() {
      var item, options2 = this.element.find("option");
      this.menu.empty(), this._parseOptions(options2), this._renderMenu(this.menu, this.items), this.menuInstance.refresh(), this.menuItems = this.menu.find("li").not(".ui-selectmenu-optgroup").find(".ui-menu-item-wrapper"), this._rendered = !0, options2.length && (item = this._getSelectedItem(), this.menuInstance.focus(null, item), this._setAria(item.data("ui-selectmenu-item")), this._setOption("disabled", this.element.prop("disabled")));
    }, "_refreshMenu"),
    open: /* @__PURE__ */ __name(function(event2) {
      this.options.disabled || (this._rendered ? (this._removeClass(this.menu.find(".ui-state-active"), null, "ui-state-active"), this.menuInstance.focus(null, this._getSelectedItem())) : this._refreshMenu(), this.menuItems.length && (this.isOpen = !0, this._toggleAttr(), this._resizeMenu(), this._position(), this._on(this.document, this._documentClick), this._trigger("open", event2)));
    }, "open"),
    _position: /* @__PURE__ */ __name(function() {
      this.menuWrap.position($2.extend({ of: this.button }, this.options.position));
    }, "_position"),
    close: /* @__PURE__ */ __name(function(event2) {
      this.isOpen && (this.isOpen = !1, this._toggleAttr(), this.range = null, this._off(this.document), this._trigger("close", event2));
    }, "close"),
    widget: /* @__PURE__ */ __name(function() {
      return this.button;
    }, "widget"),
    menuWidget: /* @__PURE__ */ __name(function() {
      return this.menu;
    }, "menuWidget"),
    _renderButtonItem: /* @__PURE__ */ __name(function(item) {
      var buttonItem = $2("<span>");
      return this._setText(buttonItem, item.label), this._addClass(buttonItem, "ui-selectmenu-text"), buttonItem;
    }, "_renderButtonItem"),
    _renderMenu: /* @__PURE__ */ __name(function(ul, items3) {
      var that = this, currentOptgroup = "";
      $2.each(items3, function(index3, item) {
        var li;
        item.optgroup !== currentOptgroup && (li = $2("<li>", {
          text: item.optgroup
        }), that._addClass(li, "ui-selectmenu-optgroup", "ui-menu-divider" + (item.element.parent("optgroup").prop("disabled") ? " ui-state-disabled" : "")), li.appendTo(ul), currentOptgroup = item.optgroup), that._renderItemData(ul, item);
      });
    }, "_renderMenu"),
    _renderItemData: /* @__PURE__ */ __name(function(ul, item) {
      return this._renderItem(ul, item).data("ui-selectmenu-item", item);
    }, "_renderItemData"),
    _renderItem: /* @__PURE__ */ __name(function(ul, item) {
      var li = $2("<li>"), wrapper = $2("<div>", {
        title: item.element.attr("title")
      });
      return item.disabled && this._addClass(li, null, "ui-state-disabled"), item.hidden ? li.prop("hidden", !0) : this._setText(wrapper, item.label), li.append(wrapper).appendTo(ul);
    }, "_renderItem"),
    _setText: /* @__PURE__ */ __name(function(element, value3) {
      value3 ? element.text(value3) : element.html("&#160;");
    }, "_setText"),
    _move: /* @__PURE__ */ __name(function(direction, event2) {
      var item, next3, filter2 = ".ui-menu-item";
      this.isOpen ? item = this.menuItems.eq(this.focusIndex).parent("li") : (item = this.menuItems.eq(this.element[0].selectedIndex).parent("li"), filter2 += ":not(.ui-state-disabled)"), direction === "first" || direction === "last" ? next3 = item[direction === "first" ? "prevAll" : "nextAll"](filter2).eq(-1) : next3 = item[direction + "All"](filter2).eq(0), next3.length && this.menuInstance.focus(event2, next3);
    }, "_move"),
    _getSelectedItem: /* @__PURE__ */ __name(function() {
      return this.menuItems.eq(this.element[0].selectedIndex).parent("li");
    }, "_getSelectedItem"),
    _toggle: /* @__PURE__ */ __name(function(event2) {
      this[this.isOpen ? "close" : "open"](event2);
    }, "_toggle"),
    _setSelection: /* @__PURE__ */ __name(function() {
      var selection;
      this.range && (selection = window.getSelection(), selection.removeAllRanges(), selection.addRange(this.range));
    }, "_setSelection"),
    _documentClick: {
      mousedown: /* @__PURE__ */ __name(function(event2) {
        this.isOpen && ($2(event2.target).closest(".ui-selectmenu-menu, #" + CSS.escape(this.ids.button)).length || this.close(event2));
      }, "mousedown")
    },
    _buttonEvents: {
      // Prevent text selection from being reset when interacting with the selectmenu (#10144)
      mousedown: /* @__PURE__ */ __name(function() {
        var selection = window.getSelection();
        selection.rangeCount && (this.range = selection.getRangeAt(0));
      }, "mousedown"),
      click: /* @__PURE__ */ __name(function(event2) {
        this._setSelection(), this._toggle(event2);
      }, "click"),
      keydown: /* @__PURE__ */ __name(function(event2) {
        var preventDefault = !0;
        switch (event2.keyCode) {
          case $2.ui.keyCode.TAB:
          case $2.ui.keyCode.ESCAPE:
            this.close(event2), preventDefault = !1;
            break;
          case $2.ui.keyCode.ENTER:
            this.isOpen && this._selectFocusedItem(event2);
            break;
          case $2.ui.keyCode.UP:
            event2.altKey ? this._toggle(event2) : this._move("prev", event2);
            break;
          case $2.ui.keyCode.DOWN:
            event2.altKey ? this._toggle(event2) : this._move("next", event2);
            break;
          case $2.ui.keyCode.SPACE:
            this.isOpen ? this._selectFocusedItem(event2) : this._toggle(event2);
            break;
          case $2.ui.keyCode.LEFT:
            this._move("prev", event2);
            break;
          case $2.ui.keyCode.RIGHT:
            this._move("next", event2);
            break;
          case $2.ui.keyCode.HOME:
          case $2.ui.keyCode.PAGE_UP:
            this._move("first", event2);
            break;
          case $2.ui.keyCode.END:
          case $2.ui.keyCode.PAGE_DOWN:
            this._move("last", event2);
            break;
          default:
            this.menu.trigger(event2), preventDefault = !1;
        }
        preventDefault && event2.preventDefault();
      }, "keydown")
    },
    _selectFocusedItem: /* @__PURE__ */ __name(function(event2) {
      var item = this.menuItems.eq(this.focusIndex).parent("li");
      item.hasClass("ui-state-disabled") || this._select(item.data("ui-selectmenu-item"), event2);
    }, "_selectFocusedItem"),
    _select: /* @__PURE__ */ __name(function(item, event2) {
      var oldIndex2 = this.element[0].selectedIndex;
      this.element[0].selectedIndex = item.index, this.buttonItem.replaceWith(this.buttonItem = this._renderButtonItem(item)), this._setAria(item), this._trigger("select", event2, { item }), item.index !== oldIndex2 && this._trigger("change", event2, { item }), this.close(event2);
    }, "_select"),
    _setAria: /* @__PURE__ */ __name(function(item) {
      var id2 = this.menuItems.eq(item.index).attr("id");
      this.button.attr({
        "aria-labelledby": id2,
        "aria-activedescendant": id2
      }), this.menu.attr("aria-activedescendant", id2);
    }, "_setAria"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      if (key === "icons") {
        var icon = this.button.find("span.ui-icon");
        this._removeClass(icon, null, this.options.icons.button)._addClass(icon, null, value3.button);
      }
      this._super(key, value3), key === "appendTo" && this.menuWrap.appendTo(this._appendTo()), key === "width" && this._resizeButton();
    }, "_setOption"),
    _setOptionDisabled: /* @__PURE__ */ __name(function(value3) {
      this._super(value3), this.menuInstance.option("disabled", value3), this.button.attr("aria-disabled", value3), this._toggleClass(this.button, null, "ui-state-disabled", value3), this.element.prop("disabled", value3), value3 ? (this.button.attr("tabindex", -1), this.close()) : this.button.attr("tabindex", 0);
    }, "_setOptionDisabled"),
    _appendTo: /* @__PURE__ */ __name(function() {
      var element = this.options.appendTo;
      return element && (element = element.jquery || element.nodeType ? $2(element) : this.document.find(element).eq(0)), (!element || !element[0]) && (element = this.element.closest(".ui-front, dialog")), element.length || (element = this.document[0].body), element;
    }, "_appendTo"),
    _toggleAttr: /* @__PURE__ */ __name(function() {
      this.button.attr("aria-expanded", this.isOpen), this._removeClass(this.button, "ui-selectmenu-button-" + (this.isOpen ? "closed" : "open"))._addClass(this.button, "ui-selectmenu-button-" + (this.isOpen ? "open" : "closed"))._toggleClass(this.menuWrap, "ui-selectmenu-open", null, this.isOpen), this.menu.attr("aria-hidden", !this.isOpen);
    }, "_toggleAttr"),
    _resizeButton: /* @__PURE__ */ __name(function() {
      var width = this.options.width;
      if (width === !1) {
        this.button.css("width", "");
        return;
      }
      width === null && (width = this.element.show().outerWidth(), this.element.hide()), this.button.outerWidth(width);
    }, "_resizeButton"),
    _resizeMenu: /* @__PURE__ */ __name(function() {
      this.menu.outerWidth(Math.max(
        this.button.outerWidth(),
        this.menu.width("").outerWidth()
      ));
    }, "_resizeMenu"),
    _getCreateOptions: /* @__PURE__ */ __name(function() {
      var options2 = this._super();
      return options2.disabled = this.element.prop("disabled"), options2;
    }, "_getCreateOptions"),
    _parseOptions: /* @__PURE__ */ __name(function(options2) {
      var that = this, data49 = [];
      options2.each(function(index3, item) {
        data49.push(that._parseOption($2(item), index3));
      }), this.items = data49;
    }, "_parseOptions"),
    _parseOption: /* @__PURE__ */ __name(function(option2, index3) {
      var optgroup = option2.parent("optgroup");
      return {
        element: option2,
        index: index3,
        value: option2.val(),
        label: option2.text(),
        hidden: optgroup.prop("hidden") || option2.prop("hidden"),
        optgroup: optgroup.attr("label") || "",
        disabled: optgroup.prop("disabled") || option2.prop("disabled")
      };
    }, "_parseOption"),
    _destroy: /* @__PURE__ */ __name(function() {
      this._unbindFormResetHandler(), this.menuWrap.remove(), this.button.remove(), this.element.show(), this.element.removeUniqueId(), this.labels.attr("for", this.ids.element);
    }, "_destroy")
  }]);
  /*!
   * jQuery UI Slider 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.slider", $2.ui.mouse, {
    version: "1.14.1",
    widgetEventPrefix: "slide",
    options: {
      animate: !1,
      classes: {
        "ui-slider": "ui-corner-all",
        "ui-slider-handle": "ui-corner-all",
        // Note: ui-widget-header isn't the most fittingly semantic framework class for this
        // element, but worked best visually with a variety of themes
        "ui-slider-range": "ui-corner-all ui-widget-header"
      },
      distance: 0,
      max: 100,
      min: 0,
      orientation: "horizontal",
      range: !1,
      step: 1,
      value: 0,
      values: null,
      // Callbacks
      change: null,
      slide: null,
      start: null,
      stop: null
    },
    // Number of pages in a slider
    // (how many times can you page up/down to go through the whole range)
    numPages: 5,
    _create: /* @__PURE__ */ __name(function() {
      this._keySliding = !1, this._mouseSliding = !1, this._animateOff = !0, this._handleIndex = null, this._detectOrientation(), this._mouseInit(), this._calculateNewMax(), this._addClass(
        "ui-slider ui-slider-" + this.orientation,
        "ui-widget ui-widget-content"
      ), this._refresh(), this._animateOff = !1;
    }, "_create"),
    _refresh: /* @__PURE__ */ __name(function() {
      this._createRange(), this._createHandles(), this._setupEvents(), this._refreshValue();
    }, "_refresh"),
    _createHandles: /* @__PURE__ */ __name(function() {
      var i, handleCount, options2 = this.options, existingHandles = this.element.find(".ui-slider-handle"), handle = "<span tabindex='0'></span>", handles = [];
      for (handleCount = options2.values && options2.values.length || 1, existingHandles.length > handleCount && (existingHandles.slice(handleCount).remove(), existingHandles = existingHandles.slice(0, handleCount)), i = existingHandles.length; i < handleCount; i++)
        handles.push(handle);
      this.handles = existingHandles.add($2(handles.join("")).appendTo(this.element)), this._addClass(this.handles, "ui-slider-handle", "ui-state-default"), this.handle = this.handles.eq(0), this.handles.each(function(i2) {
        $2(this).data("ui-slider-handle-index", i2).attr("tabIndex", 0);
      });
    }, "_createHandles"),
    _createRange: /* @__PURE__ */ __name(function() {
      var options2 = this.options;
      options2.range ? (options2.range === !0 && (options2.values ? options2.values.length && options2.values.length !== 2 ? options2.values = [options2.values[0], options2.values[0]] : Array.isArray(options2.values) && (options2.values = options2.values.slice(0)) : options2.values = [this._valueMin(), this._valueMin()]), !this.range || !this.range.length ? (this.range = $2("<div>").appendTo(this.element), this._addClass(this.range, "ui-slider-range")) : (this._removeClass(this.range, "ui-slider-range-min ui-slider-range-max"), this.range.css({
        left: "",
        bottom: ""
      })), (options2.range === "min" || options2.range === "max") && this._addClass(this.range, "ui-slider-range-" + options2.range)) : (this.range && this.range.remove(), this.range = null);
    }, "_createRange"),
    _setupEvents: /* @__PURE__ */ __name(function() {
      this._off(this.handles), this._on(this.handles, this._handleEvents), this._hoverable(this.handles), this._focusable(this.handles);
    }, "_setupEvents"),
    _destroy: /* @__PURE__ */ __name(function() {
      this.handles.remove(), this.range && this.range.remove(), this._mouseDestroy();
    }, "_destroy"),
    _mouseCapture: /* @__PURE__ */ __name(function(event2) {
      var position3, normValue, distance, closestHandle, index3, allowed, offset3, mouseOverHandle, that = this, o = this.options;
      return o.disabled || (this.elementSize = {
        width: this.element.outerWidth(),
        height: this.element.outerHeight()
      }, this.elementOffset = this.element.offset(), position3 = { x: event2.pageX, y: event2.pageY }, normValue = this._normValueFromMouse(position3), distance = this._valueMax() - this._valueMin() + 1, this.handles.each(function(i) {
        var thisDistance = Math.abs(normValue - that.values(i));
        (distance > thisDistance || distance === thisDistance && (i === that._lastChangedValue || that.values(i) === o.min)) && (distance = thisDistance, closestHandle = $2(this), index3 = i);
      }), allowed = this._start(event2, index3), allowed === !1) ? !1 : (this._mouseSliding = !0, this._handleIndex = index3, this._addClass(closestHandle, null, "ui-state-active"), closestHandle.trigger("focus"), offset3 = closestHandle.offset(), mouseOverHandle = !$2(event2.target).parents().addBack().is(".ui-slider-handle"), this._clickOffset = mouseOverHandle ? { left: 0, top: 0 } : {
        left: event2.pageX - offset3.left - closestHandle.width() / 2,
        top: event2.pageY - offset3.top - closestHandle.height() / 2 - (parseInt(closestHandle.css("borderTopWidth"), 10) || 0) - (parseInt(closestHandle.css("borderBottomWidth"), 10) || 0) + (parseInt(closestHandle.css("marginTop"), 10) || 0)
      }, this.handles.hasClass("ui-state-hover") || this._slide(event2, index3, normValue), this._animateOff = !0, !0);
    }, "_mouseCapture"),
    _mouseStart: /* @__PURE__ */ __name(function() {
      return !0;
    }, "_mouseStart"),
    _mouseDrag: /* @__PURE__ */ __name(function(event2) {
      var position3 = { x: event2.pageX, y: event2.pageY }, normValue = this._normValueFromMouse(position3);
      return this._slide(event2, this._handleIndex, normValue), !1;
    }, "_mouseDrag"),
    _mouseStop: /* @__PURE__ */ __name(function(event2) {
      return this._removeClass(this.handles, null, "ui-state-active"), this._mouseSliding = !1, this._stop(event2, this._handleIndex), this._change(event2, this._handleIndex), this._handleIndex = null, this._clickOffset = null, this._animateOff = !1, !1;
    }, "_mouseStop"),
    _detectOrientation: /* @__PURE__ */ __name(function() {
      this.orientation = this.options.orientation === "vertical" ? "vertical" : "horizontal";
    }, "_detectOrientation"),
    _normValueFromMouse: /* @__PURE__ */ __name(function(position3) {
      var pixelTotal, pixelMouse, percentMouse, valueTotal, valueMouse;
      return this.orientation === "horizontal" ? (pixelTotal = this.elementSize.width, pixelMouse = position3.x - this.elementOffset.left - (this._clickOffset ? this._clickOffset.left : 0)) : (pixelTotal = this.elementSize.height, pixelMouse = position3.y - this.elementOffset.top - (this._clickOffset ? this._clickOffset.top : 0)), percentMouse = pixelMouse / pixelTotal, percentMouse > 1 && (percentMouse = 1), percentMouse < 0 && (percentMouse = 0), this.orientation === "vertical" && (percentMouse = 1 - percentMouse), valueTotal = this._valueMax() - this._valueMin(), valueMouse = this._valueMin() + percentMouse * valueTotal, this._trimAlignValue(valueMouse);
    }, "_normValueFromMouse"),
    _uiHash: /* @__PURE__ */ __name(function(index3, value3, values2) {
      var uiHash = {
        handle: this.handles[index3],
        handleIndex: index3,
        value: value3 !== void 0 ? value3 : this.value()
      };
      return this._hasMultipleValues() && (uiHash.value = value3 !== void 0 ? value3 : this.values(index3), uiHash.values = values2 || this.values()), uiHash;
    }, "_uiHash"),
    _hasMultipleValues: /* @__PURE__ */ __name(function() {
      return this.options.values && this.options.values.length;
    }, "_hasMultipleValues"),
    _start: /* @__PURE__ */ __name(function(event2, index3) {
      return this._trigger("start", event2, this._uiHash(index3));
    }, "_start"),
    _slide: /* @__PURE__ */ __name(function(event2, index3, newVal) {
      var allowed, otherVal, currentValue = this.value(), newValues = this.values();
      this._hasMultipleValues() && (otherVal = this.values(index3 ? 0 : 1), currentValue = this.values(index3), this.options.values.length === 2 && this.options.range === !0 && (newVal = index3 === 0 ? Math.min(otherVal, newVal) : Math.max(otherVal, newVal)), newValues[index3] = newVal), newVal !== currentValue && (allowed = this._trigger("slide", event2, this._uiHash(index3, newVal, newValues)), allowed !== !1 && (this._hasMultipleValues() ? this.values(index3, newVal) : this.value(newVal)));
    }, "_slide"),
    _stop: /* @__PURE__ */ __name(function(event2, index3) {
      this._trigger("stop", event2, this._uiHash(index3));
    }, "_stop"),
    _change: /* @__PURE__ */ __name(function(event2, index3) {
      !this._keySliding && !this._mouseSliding && (this._lastChangedValue = index3, this._trigger("change", event2, this._uiHash(index3)));
    }, "_change"),
    value: /* @__PURE__ */ __name(function(newValue) {
      if (arguments.length) {
        this.options.value = this._trimAlignValue(newValue), this._refreshValue(), this._change(null, 0);
        return;
      }
      return this._value();
    }, "value"),
    values: /* @__PURE__ */ __name(function(index3, newValue) {
      var vals, newValues, i;
      if (arguments.length > 1) {
        this.options.values[index3] = this._trimAlignValue(newValue), this._refreshValue(), this._change(null, index3);
        return;
      }
      if (arguments.length)
        if (Array.isArray(arguments[0])) {
          for (vals = this.options.values, newValues = arguments[0], i = 0; i < vals.length; i += 1)
            vals[i] = this._trimAlignValue(newValues[i]), this._change(null, i);
          this._refreshValue();
        } else
          return this._hasMultipleValues() ? this._values(index3) : this.value();
      else
        return this._values();
    }, "values"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      var i, valsLength = 0;
      switch (key === "range" && this.options.range === !0 && (value3 === "min" ? (this.options.value = this._values(0), this.options.values = null) : value3 === "max" && (this.options.value = this._values(this.options.values.length - 1), this.options.values = null)), Array.isArray(this.options.values) && (valsLength = this.options.values.length), this._super(key, value3), key) {
        case "orientation":
          this._detectOrientation(), this._removeClass("ui-slider-horizontal ui-slider-vertical")._addClass("ui-slider-" + this.orientation), this._refreshValue(), this.options.range && this._refreshRange(value3), this.handles.css(value3 === "horizontal" ? "bottom" : "left", "");
          break;
        case "value":
          this._animateOff = !0, this._refreshValue(), this._change(null, 0), this._animateOff = !1;
          break;
        case "values":
          for (this._animateOff = !0, this._refreshValue(), i = valsLength - 1; i >= 0; i--)
            this._change(null, i);
          this._animateOff = !1;
          break;
        case "step":
        case "min":
        case "max":
          this._animateOff = !0, this._calculateNewMax(), this._refreshValue(), this._animateOff = !1;
          break;
        case "range":
          this._animateOff = !0, this._refresh(), this._animateOff = !1;
          break;
      }
    }, "_setOption"),
    _setOptionDisabled: /* @__PURE__ */ __name(function(value3) {
      this._super(value3), this._toggleClass(null, "ui-state-disabled", !!value3);
    }, "_setOptionDisabled"),
    //internal value getter
    // _value() returns value trimmed by min and max, aligned by step
    _value: /* @__PURE__ */ __name(function() {
      var val = this.options.value;
      return val = this._trimAlignValue(val), val;
    }, "_value"),
    //internal values getter
    // _values() returns array of values trimmed by min and max, aligned by step
    // _values( index ) returns single value trimmed by min and max, aligned by step
    _values: /* @__PURE__ */ __name(function(index3) {
      var val, vals, i;
      if (arguments.length)
        return val = this.options.values[index3], val = this._trimAlignValue(val), val;
      if (this._hasMultipleValues()) {
        for (vals = this.options.values.slice(), i = 0; i < vals.length; i += 1)
          vals[i] = this._trimAlignValue(vals[i]);
        return vals;
      } else
        return [];
    }, "_values"),
    // Returns the step-aligned value that val is closest to, between (inclusive) min and max
    _trimAlignValue: /* @__PURE__ */ __name(function(val) {
      if (val <= this._valueMin())
        return this._valueMin();
      if (val >= this._valueMax())
        return this._valueMax();
      var step = this.options.step > 0 ? this.options.step : 1, valModStep = (val - this._valueMin()) % step, alignValue = val - valModStep;
      return Math.abs(valModStep) * 2 >= step && (alignValue += valModStep > 0 ? step : -step), parseFloat(alignValue.toFixed(5));
    }, "_trimAlignValue"),
    _calculateNewMax: /* @__PURE__ */ __name(function() {
      var max2 = this.options.max, min2 = this._valueMin(), step = this.options.step, aboveMin = Math.round((max2 - min2) / step) * step;
      max2 = aboveMin + min2, max2 > this.options.max && (max2 -= step), this.max = parseFloat(max2.toFixed(this._precision()));
    }, "_calculateNewMax"),
    _precision: /* @__PURE__ */ __name(function() {
      var precision = this._precisionOf(this.options.step);
      return this.options.min !== null && (precision = Math.max(precision, this._precisionOf(this.options.min))), precision;
    }, "_precision"),
    _precisionOf: /* @__PURE__ */ __name(function(num) {
      var str2 = num.toString(), decimal2 = str2.indexOf(".");
      return decimal2 === -1 ? 0 : str2.length - decimal2 - 1;
    }, "_precisionOf"),
    _valueMin: /* @__PURE__ */ __name(function() {
      return this.options.min;
    }, "_valueMin"),
    _valueMax: /* @__PURE__ */ __name(function() {
      return this.max;
    }, "_valueMax"),
    _refreshRange: /* @__PURE__ */ __name(function(orientation) {
      orientation === "vertical" && this.range.css({ width: "", left: "" }), orientation === "horizontal" && this.range.css({ height: "", bottom: "" });
    }, "_refreshRange"),
    _refreshValue: /* @__PURE__ */ __name(function() {
      var lastValPercent, valPercent, value3, valueMin, valueMax, oRange = this.options.range, o = this.options, that = this, animate = this._animateOff ? !1 : o.animate, _set = {};
      this._hasMultipleValues() ? this.handles.each(function(i) {
        valPercent = (that.values(i) - that._valueMin()) / (that._valueMax() - that._valueMin()) * 100, _set[that.orientation === "horizontal" ? "left" : "bottom"] = valPercent + "%", $2(this).stop(1, 1)[animate ? "animate" : "css"](_set, o.animate), that.options.range === !0 && (that.orientation === "horizontal" ? (i === 0 && that.range.stop(1, 1)[animate ? "animate" : "css"]({
          left: valPercent + "%"
        }, o.animate), i === 1 && that.range[animate ? "animate" : "css"]({
          width: valPercent - lastValPercent + "%"
        }, {
          queue: !1,
          duration: o.animate
        })) : (i === 0 && that.range.stop(1, 1)[animate ? "animate" : "css"]({
          bottom: valPercent + "%"
        }, o.animate), i === 1 && that.range[animate ? "animate" : "css"]({
          height: valPercent - lastValPercent + "%"
        }, {
          queue: !1,
          duration: o.animate
        }))), lastValPercent = valPercent;
      }) : (value3 = this.value(), valueMin = this._valueMin(), valueMax = this._valueMax(), valPercent = valueMax !== valueMin ? (value3 - valueMin) / (valueMax - valueMin) * 100 : 0, _set[this.orientation === "horizontal" ? "left" : "bottom"] = valPercent + "%", this.handle.stop(1, 1)[animate ? "animate" : "css"](_set, o.animate), oRange === "min" && this.orientation === "horizontal" && this.range.stop(1, 1)[animate ? "animate" : "css"]({
        width: valPercent + "%"
      }, o.animate), oRange === "max" && this.orientation === "horizontal" && this.range.stop(1, 1)[animate ? "animate" : "css"]({
        width: 100 - valPercent + "%"
      }, o.animate), oRange === "min" && this.orientation === "vertical" && this.range.stop(1, 1)[animate ? "animate" : "css"]({
        height: valPercent + "%"
      }, o.animate), oRange === "max" && this.orientation === "vertical" && this.range.stop(1, 1)[animate ? "animate" : "css"]({
        height: 100 - valPercent + "%"
      }, o.animate));
    }, "_refreshValue"),
    _handleEvents: {
      keydown: /* @__PURE__ */ __name(function(event2) {
        var allowed, curVal, newVal, step, index3 = $2(event2.target).data("ui-slider-handle-index");
        switch (event2.keyCode) {
          case $2.ui.keyCode.HOME:
          case $2.ui.keyCode.END:
          case $2.ui.keyCode.PAGE_UP:
          case $2.ui.keyCode.PAGE_DOWN:
          case $2.ui.keyCode.UP:
          case $2.ui.keyCode.RIGHT:
          case $2.ui.keyCode.DOWN:
          case $2.ui.keyCode.LEFT:
            if (event2.preventDefault(), !this._keySliding && (this._keySliding = !0, this._addClass($2(event2.target), null, "ui-state-active"), allowed = this._start(event2, index3), allowed === !1))
              return;
            break;
        }
        switch (step = this.options.step, this._hasMultipleValues() ? curVal = newVal = this.values(index3) : curVal = newVal = this.value(), event2.keyCode) {
          case $2.ui.keyCode.HOME:
            newVal = this._valueMin();
            break;
          case $2.ui.keyCode.END:
            newVal = this._valueMax();
            break;
          case $2.ui.keyCode.PAGE_UP:
            newVal = this._trimAlignValue(
              curVal + (this._valueMax() - this._valueMin()) / this.numPages
            );
            break;
          case $2.ui.keyCode.PAGE_DOWN:
            newVal = this._trimAlignValue(
              curVal - (this._valueMax() - this._valueMin()) / this.numPages
            );
            break;
          case $2.ui.keyCode.UP:
          case $2.ui.keyCode.RIGHT:
            if (curVal === this._valueMax())
              return;
            newVal = this._trimAlignValue(curVal + step);
            break;
          case $2.ui.keyCode.DOWN:
          case $2.ui.keyCode.LEFT:
            if (curVal === this._valueMin())
              return;
            newVal = this._trimAlignValue(curVal - step);
            break;
        }
        this._slide(event2, index3, newVal);
      }, "keydown"),
      keyup: /* @__PURE__ */ __name(function(event2) {
        var index3 = $2(event2.target).data("ui-slider-handle-index");
        this._keySliding && (this._keySliding = !1, this._stop(event2, index3), this._change(event2, index3), this._removeClass($2(event2.target), null, "ui-state-active"));
      }, "keyup")
    }
  });
  /*!
   * jQuery UI Sortable 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.sortable", $2.ui.mouse, {
    version: "1.14.1",
    widgetEventPrefix: "sort",
    ready: !1,
    options: {
      appendTo: "parent",
      axis: !1,
      connectWith: !1,
      containment: !1,
      cursor: "auto",
      cursorAt: !1,
      dropOnEmpty: !0,
      forcePlaceholderSize: !1,
      forceHelperSize: !1,
      grid: !1,
      handle: !1,
      helper: "original",
      items: "> *",
      opacity: !1,
      placeholder: !1,
      revert: !1,
      scroll: !0,
      scrollSensitivity: 20,
      scrollSpeed: 20,
      scope: "default",
      tolerance: "intersect",
      zIndex: 1e3,
      // Callbacks
      activate: null,
      beforeStop: null,
      change: null,
      deactivate: null,
      out: null,
      over: null,
      receive: null,
      remove: null,
      sort: null,
      start: null,
      stop: null,
      update: null
    },
    _isOverAxis: /* @__PURE__ */ __name(function(x, reference2, size2) {
      return x >= reference2 && x < reference2 + size2;
    }, "_isOverAxis"),
    _isFloating: /* @__PURE__ */ __name(function(item) {
      return /left|right/.test(item.css("float")) || /inline|table-cell/.test(item.css("display"));
    }, "_isFloating"),
    _create: /* @__PURE__ */ __name(function() {
      this.containerCache = {}, this._addClass("ui-sortable"), this.refresh(), this.offset = this.element.offset(), this._mouseInit(), this._setHandleClassName(), this.ready = !0;
    }, "_create"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      this._super(key, value3), key === "handle" && this._setHandleClassName();
    }, "_setOption"),
    _setHandleClassName: /* @__PURE__ */ __name(function() {
      var that = this;
      this._removeClass(this.element.find(".ui-sortable-handle"), "ui-sortable-handle"), $2.each(this.items, function() {
        that._addClass(
          this.instance.options.handle ? this.item.find(this.instance.options.handle) : this.item,
          "ui-sortable-handle"
        );
      });
    }, "_setHandleClassName"),
    _destroy: /* @__PURE__ */ __name(function() {
      this._mouseDestroy();
      for (var i = this.items.length - 1; i >= 0; i--)
        this.items[i].item.removeData(this.widgetName + "-item");
      return this;
    }, "_destroy"),
    _mouseCapture: /* @__PURE__ */ __name(function(event2, overrideHandle) {
      var currentItem = null, validHandle = !1, that = this;
      return this.reverting || this.options.disabled || this.options.type === "static" || (this._refreshItems(event2), $2(event2.target).parents().each(function() {
        if ($2.data(this, that.widgetName + "-item") === that)
          return currentItem = $2(this), !1;
      }), $2.data(event2.target, that.widgetName + "-item") === that && (currentItem = $2(event2.target)), !currentItem) || this.options.handle && !overrideHandle && ($2(this.options.handle, currentItem).find("*").addBack().each(function() {
        this === event2.target && (validHandle = !0);
      }), !validHandle) ? !1 : (this.currentItem = currentItem, this._removeCurrentsFromItems(), !0);
    }, "_mouseCapture"),
    _mouseStart: /* @__PURE__ */ __name(function(event2, overrideHandle, noActivation) {
      var i, body, o = this.options;
      if (this.currentContainer = this, this.refreshPositions(), this.appendTo = $2(o.appendTo !== "parent" ? o.appendTo : this.currentItem.parent()), this.helper = this._createHelper(event2), this._cacheHelperProportions(), this._cacheMargins(), this.offset = this.currentItem.offset(), this.offset = {
        top: this.offset.top - this.margins.top,
        left: this.offset.left - this.margins.left
      }, $2.extend(this.offset, {
        click: {
          //Where the click happened, relative to the element
          left: event2.pageX - this.offset.left,
          top: event2.pageY - this.offset.top
        },
        // This is a relative to absolute position minus the actual position calculation -
        // only used for relative positioned helper
        relative: this._getRelativeOffset()
      }), this.helper.css("position", "absolute"), this.cssPosition = this.helper.css("position"), o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt), this.domPosition = {
        prev: this.currentItem.prev()[0],
        parent: this.currentItem.parent()[0]
      }, this.helper[0] !== this.currentItem[0] && this.currentItem.hide(), this._createPlaceholder(), this.scrollParent = this.placeholder.scrollParent(), $2.extend(this.offset, {
        parent: this._getParentOffset()
      }), o.containment && this._setContainment(), o.cursor && o.cursor !== "auto" && (body = this.document.find("body"), this._storedStylesheet = $2("<style>*{ cursor: " + o.cursor + " !important; }</style>").appendTo(body)), o.zIndex && (this.helper.css("zIndex") && (this._storedZIndex = this.helper.css("zIndex")), this.helper.css("zIndex", o.zIndex)), o.opacity && (this.helper.css("opacity") && (this._storedOpacity = this.helper.css("opacity")), this.helper.css("opacity", o.opacity)), this.scrollParent[0] !== this.document[0] && this.scrollParent[0].tagName !== "HTML" && (this.overflowOffset = this.scrollParent.offset()), this._trigger("start", event2, this._uiHash()), this._preserveHelperProportions || this._cacheHelperProportions(), !noActivation)
        for (i = this.containers.length - 1; i >= 0; i--)
          this.containers[i]._trigger("activate", event2, this._uiHash(this));
      return $2.ui.ddmanager && ($2.ui.ddmanager.current = this), $2.ui.ddmanager && !o.dropBehaviour && $2.ui.ddmanager.prepareOffsets(this, event2), this.dragging = !0, this._addClass(this.helper, "ui-sortable-helper"), this.helper.parent().is(this.appendTo) || (this.helper.detach().appendTo(this.appendTo), this.offset.parent = this._getParentOffset()), this.position = this.originalPosition = this._generatePosition(event2), this.originalPageX = event2.pageX, this.originalPageY = event2.pageY, this.lastPositionAbs = this.positionAbs = this._convertPositionTo("absolute"), this._mouseDrag(event2), !0;
    }, "_mouseStart"),
    _scroll: /* @__PURE__ */ __name(function(event2) {
      var o = this.options, scrolled = !1;
      return this.scrollParent[0] !== this.document[0] && this.scrollParent[0].tagName !== "HTML" ? (this.overflowOffset.top + this.scrollParent[0].offsetHeight - event2.pageY < o.scrollSensitivity ? this.scrollParent[0].scrollTop = scrolled = this.scrollParent[0].scrollTop + o.scrollSpeed : event2.pageY - this.overflowOffset.top < o.scrollSensitivity && (this.scrollParent[0].scrollTop = scrolled = this.scrollParent[0].scrollTop - o.scrollSpeed), this.overflowOffset.left + this.scrollParent[0].offsetWidth - event2.pageX < o.scrollSensitivity ? this.scrollParent[0].scrollLeft = scrolled = this.scrollParent[0].scrollLeft + o.scrollSpeed : event2.pageX - this.overflowOffset.left < o.scrollSensitivity && (this.scrollParent[0].scrollLeft = scrolled = this.scrollParent[0].scrollLeft - o.scrollSpeed)) : (event2.pageY - this.document.scrollTop() < o.scrollSensitivity ? scrolled = this.document.scrollTop(this.document.scrollTop() - o.scrollSpeed) : this.window.height() - (event2.pageY - this.document.scrollTop()) < o.scrollSensitivity && (scrolled = this.document.scrollTop(this.document.scrollTop() + o.scrollSpeed)), event2.pageX - this.document.scrollLeft() < o.scrollSensitivity ? scrolled = this.document.scrollLeft(
        this.document.scrollLeft() - o.scrollSpeed
      ) : this.window.width() - (event2.pageX - this.document.scrollLeft()) < o.scrollSensitivity && (scrolled = this.document.scrollLeft(
        this.document.scrollLeft() + o.scrollSpeed
      ))), scrolled;
    }, "_scroll"),
    _mouseDrag: /* @__PURE__ */ __name(function(event2) {
      var i, item, itemElement, intersection, o = this.options;
      for (this.position = this._generatePosition(event2), this.positionAbs = this._convertPositionTo("absolute"), (!this.options.axis || this.options.axis !== "y") && (this.helper[0].style.left = this.position.left + "px"), (!this.options.axis || this.options.axis !== "x") && (this.helper[0].style.top = this.position.top + "px"), o.scroll && this._scroll(event2) !== !1 && (this._refreshItemPositions(!0), $2.ui.ddmanager && !o.dropBehaviour && $2.ui.ddmanager.prepareOffsets(this, event2)), this.dragDirection = {
        vertical: this._getDragVerticalDirection(),
        horizontal: this._getDragHorizontalDirection()
      }, i = this.items.length - 1; i >= 0; i--)
        if (item = this.items[i], itemElement = item.item[0], intersection = this._intersectsWithPointer(item), !!intersection && item.instance === this.currentContainer && itemElement !== this.currentItem[0] && this.placeholder[intersection === 1 ? "next" : "prev"]()[0] !== itemElement && !$2.contains(this.placeholder[0], itemElement) && (this.options.type !== "semi-dynamic" || !$2.contains(this.element[0], itemElement))) {
          if (this.direction = intersection === 1 ? "down" : "up", this.options.tolerance === "pointer" || this._intersectsWithSides(item))
            this._rearrange(event2, item);
          else
            break;
          this._trigger("change", event2, this._uiHash());
          break;
        }
      return this._contactContainers(event2), $2.ui.ddmanager && $2.ui.ddmanager.drag(this, event2), this._trigger("sort", event2, this._uiHash()), this.lastPositionAbs = this.positionAbs, !1;
    }, "_mouseDrag"),
    _mouseStop: /* @__PURE__ */ __name(function(event2, noPropagation) {
      if (event2) {
        if ($2.ui.ddmanager && !this.options.dropBehaviour && $2.ui.ddmanager.drop(this, event2), this.options.revert) {
          var that = this, cur = this.placeholder.offset(), axis = this.options.axis, animation = {};
          (!axis || axis === "x") && (animation.left = cur.left - this.offset.parent.left - this.margins.left + (this.offsetParent[0] === this.document[0].body ? 0 : this.offsetParent[0].scrollLeft)), (!axis || axis === "y") && (animation.top = cur.top - this.offset.parent.top - this.margins.top + (this.offsetParent[0] === this.document[0].body ? 0 : this.offsetParent[0].scrollTop)), this.reverting = !0, $2(this.helper).animate(
            animation,
            parseInt(this.options.revert, 10) || 500,
            function() {
              that._clear(event2);
            }
          );
        } else
          this._clear(event2, noPropagation);
        return !1;
      }
    }, "_mouseStop"),
    cancel: /* @__PURE__ */ __name(function() {
      if (this.dragging) {
        this._mouseUp(new $2.Event("mouseup", { target: null })), this.options.helper === "original" ? (this.currentItem.css(this._storedCSS), this._removeClass(this.currentItem, "ui-sortable-helper")) : this.currentItem.show();
        for (var i = this.containers.length - 1; i >= 0; i--)
          this.containers[i]._trigger("deactivate", null, this._uiHash(this)), this.containers[i].containerCache.over && (this.containers[i]._trigger("out", null, this._uiHash(this)), this.containers[i].containerCache.over = 0);
      }
      return this.placeholder && (this.placeholder[0].parentNode && this.placeholder[0].parentNode.removeChild(this.placeholder[0]), this.options.helper !== "original" && this.helper && this.helper[0].parentNode && this.helper.remove(), $2.extend(this, {
        helper: null,
        dragging: !1,
        reverting: !1,
        _noFinalSort: null
      }), this.domPosition.prev ? $2(this.domPosition.prev).after(this.currentItem) : $2(this.domPosition.parent).prepend(this.currentItem)), this;
    }, "cancel"),
    serialize: /* @__PURE__ */ __name(function(o) {
      var items3 = this._getItemsAsjQuery(o && o.connected), str2 = [];
      return o = o || {}, $2(items3).each(function() {
        var res = ($2(o.item || this).attr(o.attribute || "id") || "").match(o.expression || /(.+)[\-=_](.+)/);
        res && str2.push(
          (o.key || res[1] + "[]") + "=" + (o.key && o.expression ? res[1] : res[2])
        );
      }), !str2.length && o.key && str2.push(o.key + "="), str2.join("&");
    }, "serialize"),
    toArray: /* @__PURE__ */ __name(function(o) {
      var items3 = this._getItemsAsjQuery(o && o.connected), ret = [];
      return o = o || {}, items3.each(function() {
        ret.push($2(o.item || this).attr(o.attribute || "id") || "");
      }), ret;
    }, "toArray"),
    /* Be careful with the following core functions */
    _intersectsWith: /* @__PURE__ */ __name(function(item) {
      var x1 = this.positionAbs.left, x2 = x1 + this.helperProportions.width, y1 = this.positionAbs.top, y2 = y1 + this.helperProportions.height, l = item.left, r2 = l + item.width, t2 = item.top, b = t2 + item.height, dyClick = this.offset.click.top, dxClick = this.offset.click.left, isOverElementHeight = this.options.axis === "x" || y1 + dyClick > t2 && y1 + dyClick < b, isOverElementWidth = this.options.axis === "y" || x1 + dxClick > l && x1 + dxClick < r2, isOverElement = isOverElementHeight && isOverElementWidth;
      return this.options.tolerance === "pointer" || this.options.forcePointerForContainers || this.options.tolerance !== "pointer" && this.helperProportions[this.floating ? "width" : "height"] > item[this.floating ? "width" : "height"] ? isOverElement : l < x1 + this.helperProportions.width / 2 && // Right Half
      x2 - this.helperProportions.width / 2 < r2 && // Left Half
      t2 < y1 + this.helperProportions.height / 2 && // Bottom Half
      y2 - this.helperProportions.height / 2 < b;
    }, "_intersectsWith"),
    _intersectsWithPointer: /* @__PURE__ */ __name(function(item) {
      var verticalDirection, horizontalDirection, isOverElementHeight = this.options.axis === "x" || this._isOverAxis(
        this.positionAbs.top + this.offset.click.top,
        item.top,
        item.height
      ), isOverElementWidth = this.options.axis === "y" || this._isOverAxis(
        this.positionAbs.left + this.offset.click.left,
        item.left,
        item.width
      ), isOverElement = isOverElementHeight && isOverElementWidth;
      return isOverElement ? (verticalDirection = this.dragDirection.vertical, horizontalDirection = this.dragDirection.horizontal, this.floating ? horizontalDirection === "right" || verticalDirection === "down" ? 2 : 1 : verticalDirection && (verticalDirection === "down" ? 2 : 1)) : !1;
    }, "_intersectsWithPointer"),
    _intersectsWithSides: /* @__PURE__ */ __name(function(item) {
      var isOverBottomHalf = this._isOverAxis(this.positionAbs.top + this.offset.click.top, item.top + item.height / 2, item.height), isOverRightHalf = this._isOverAxis(this.positionAbs.left + this.offset.click.left, item.left + item.width / 2, item.width), verticalDirection = this.dragDirection.vertical, horizontalDirection = this.dragDirection.horizontal;
      return this.floating && horizontalDirection ? horizontalDirection === "right" && isOverRightHalf || horizontalDirection === "left" && !isOverRightHalf : verticalDirection && (verticalDirection === "down" && isOverBottomHalf || verticalDirection === "up" && !isOverBottomHalf);
    }, "_intersectsWithSides"),
    _getDragVerticalDirection: /* @__PURE__ */ __name(function() {
      var delta = this.positionAbs.top - this.lastPositionAbs.top;
      return delta !== 0 && (delta > 0 ? "down" : "up");
    }, "_getDragVerticalDirection"),
    _getDragHorizontalDirection: /* @__PURE__ */ __name(function() {
      var delta = this.positionAbs.left - this.lastPositionAbs.left;
      return delta !== 0 && (delta > 0 ? "right" : "left");
    }, "_getDragHorizontalDirection"),
    refresh: /* @__PURE__ */ __name(function(event2) {
      return this._refreshItems(event2), this._setHandleClassName(), this.refreshPositions(), this;
    }, "refresh"),
    _connectWith: /* @__PURE__ */ __name(function() {
      var options2 = this.options;
      return options2.connectWith.constructor === String ? [options2.connectWith] : options2.connectWith;
    }, "_connectWith"),
    _getItemsAsjQuery: /* @__PURE__ */ __name(function(connected) {
      var i, j, cur, inst, items3 = [], queries = [], connectWith = this._connectWith();
      if (connectWith && connected)
        for (i = connectWith.length - 1; i >= 0; i--)
          for (cur = $2(connectWith[i], this.document[0]), j = cur.length - 1; j >= 0; j--)
            inst = $2.data(cur[j], this.widgetFullName), inst && inst !== this && !inst.options.disabled && queries.push([typeof inst.options.items == "function" ? inst.options.items.call(inst.element) : $2(inst.options.items, inst.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"), inst]);
      queries.push([typeof this.options.items == "function" ? this.options.items.call(this.element, null, { options: this.options, item: this.currentItem }) : $2(this.options.items, this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"), this]);
      function addItems() {
        items3.push(this);
      }
      for (__name(addItems, "addItems"), i = queries.length - 1; i >= 0; i--)
        queries[i][0].each(addItems);
      return $2(items3);
    }, "_getItemsAsjQuery"),
    _removeCurrentsFromItems: /* @__PURE__ */ __name(function() {
      var list = this.currentItem.find(":data(" + this.widgetName + "-item)");
      this.items = $2.grep(this.items, function(item) {
        for (var j = 0; j < list.length; j++)
          if (list[j] === item.item[0])
            return !1;
        return !0;
      });
    }, "_removeCurrentsFromItems"),
    _refreshItems: /* @__PURE__ */ __name(function(event2) {
      this.items = [], this.containers = [this];
      var i, j, cur, inst, targetData, _queries, item, queriesLength, items3 = this.items, queries = [[typeof this.options.items == "function" ? this.options.items.call(this.element[0], event2, { item: this.currentItem }) : $2(this.options.items, this.element), this]], connectWith = this._connectWith();
      if (connectWith && this.ready)
        for (i = connectWith.length - 1; i >= 0; i--)
          for (cur = $2(connectWith[i], this.document[0]), j = cur.length - 1; j >= 0; j--)
            inst = $2.data(cur[j], this.widgetFullName), inst && inst !== this && !inst.options.disabled && (queries.push([typeof inst.options.items == "function" ? inst.options.items.call(inst.element[0], event2, { item: this.currentItem }) : $2(inst.options.items, inst.element), inst]), this.containers.push(inst));
      for (i = queries.length - 1; i >= 0; i--)
        for (targetData = queries[i][1], _queries = queries[i][0], j = 0, queriesLength = _queries.length; j < queriesLength; j++)
          item = $2(_queries[j]), item.data(this.widgetName + "-item", targetData), items3.push({
            item,
            instance: targetData,
            width: 0,
            height: 0,
            left: 0,
            top: 0
          });
    }, "_refreshItems"),
    _refreshItemPositions: /* @__PURE__ */ __name(function(fast) {
      var i, item, t2, p;
      for (i = this.items.length - 1; i >= 0; i--)
        item = this.items[i], !(this.currentContainer && item.instance !== this.currentContainer && item.item[0] !== this.currentItem[0]) && (t2 = this.options.toleranceElement ? $2(this.options.toleranceElement, item.item) : item.item, fast || (item.width = t2.outerWidth(), item.height = t2.outerHeight()), p = t2.offset(), item.left = p.left, item.top = p.top);
    }, "_refreshItemPositions"),
    refreshPositions: /* @__PURE__ */ __name(function(fast) {
      this.floating = this.items.length ? this.options.axis === "x" || this._isFloating(this.items[0].item) : !1, this.offsetParent && this.helper && (this.offset.parent = this._getParentOffset()), this._refreshItemPositions(fast);
      var i, p;
      if (this.options.custom && this.options.custom.refreshContainers)
        this.options.custom.refreshContainers.call(this);
      else
        for (i = this.containers.length - 1; i >= 0; i--)
          p = this.containers[i].element.offset(), this.containers[i].containerCache.left = p.left, this.containers[i].containerCache.top = p.top, this.containers[i].containerCache.width = this.containers[i].element.outerWidth(), this.containers[i].containerCache.height = this.containers[i].element.outerHeight();
      return this;
    }, "refreshPositions"),
    _createPlaceholder: /* @__PURE__ */ __name(function(that) {
      that = that || this;
      var className, nodeName, o = that.options;
      (!o.placeholder || o.placeholder.constructor === String) && (className = o.placeholder, nodeName = that.currentItem[0].nodeName.toLowerCase(), o.placeholder = {
        element: /* @__PURE__ */ __name(function() {
          var element = $2("<" + nodeName + ">", that.document[0]);
          return that._addClass(
            element,
            "ui-sortable-placeholder",
            className || that.currentItem[0].className
          )._removeClass(element, "ui-sortable-helper"), nodeName === "tbody" ? that._createTrPlaceholder(
            that.currentItem.find("tr").eq(0),
            $2("<tr>", that.document[0]).appendTo(element)
          ) : nodeName === "tr" ? that._createTrPlaceholder(that.currentItem, element) : nodeName === "img" && element.attr("src", that.currentItem.attr("src")), className || element.css("visibility", "hidden"), element;
        }, "element"),
        update: /* @__PURE__ */ __name(function(container, p) {
          className && !o.forcePlaceholderSize || ((!p.height() || o.forcePlaceholderSize && (nodeName === "tbody" || nodeName === "tr")) && p.height(
            that.currentItem.innerHeight() - parseInt(that.currentItem.css("paddingTop") || 0, 10) - parseInt(that.currentItem.css("paddingBottom") || 0, 10)
          ), p.width() || p.width(
            that.currentItem.innerWidth() - parseInt(that.currentItem.css("paddingLeft") || 0, 10) - parseInt(that.currentItem.css("paddingRight") || 0, 10)
          ));
        }, "update")
      }), that.placeholder = $2(o.placeholder.element.call(that.element, that.currentItem)), that.currentItem.after(that.placeholder), o.placeholder.update(that, that.placeholder);
    }, "_createPlaceholder"),
    _createTrPlaceholder: /* @__PURE__ */ __name(function(sourceTr, targetTr) {
      var that = this;
      sourceTr.children().each(function() {
        $2("<td>&#160;</td>", that.document[0]).attr("colspan", $2(this).attr("colspan") || 1).appendTo(targetTr);
      });
    }, "_createTrPlaceholder"),
    _contactContainers: /* @__PURE__ */ __name(function(event2) {
      var i, j, dist2, itemWithLeastDistance, posProperty, sizeProperty, cur, nearBottom, floating, axis, innermostContainer = null, innermostIndex = null;
      for (i = this.containers.length - 1; i >= 0; i--)
        if (!$2.contains(this.currentItem[0], this.containers[i].element[0]))
          if (this._intersectsWith(this.containers[i].containerCache)) {
            if (innermostContainer && $2.contains(
              this.containers[i].element[0],
              innermostContainer.element[0]
            ))
              continue;
            innermostContainer = this.containers[i], innermostIndex = i;
          } else
            this.containers[i].containerCache.over && (this.containers[i]._trigger("out", event2, this._uiHash(this)), this.containers[i].containerCache.over = 0);
      if (innermostContainer)
        if (this.containers.length === 1)
          this.containers[innermostIndex].containerCache.over || (this.containers[innermostIndex]._trigger("over", event2, this._uiHash(this)), this.containers[innermostIndex].containerCache.over = 1);
        else {
          for (dist2 = 1e4, itemWithLeastDistance = null, floating = innermostContainer.floating || this._isFloating(this.currentItem), posProperty = floating ? "left" : "top", sizeProperty = floating ? "width" : "height", axis = floating ? "pageX" : "pageY", j = this.items.length - 1; j >= 0; j--)
            $2.contains(
              this.containers[innermostIndex].element[0],
              this.items[j].item[0]
            ) && this.items[j].item[0] !== this.currentItem[0] && (cur = this.items[j].item.offset()[posProperty], nearBottom = !1, event2[axis] - cur > this.items[j][sizeProperty] / 2 && (nearBottom = !0), Math.abs(event2[axis] - cur) < dist2 && (dist2 = Math.abs(event2[axis] - cur), itemWithLeastDistance = this.items[j], this.direction = nearBottom ? "up" : "down"));
          if (!itemWithLeastDistance && !this.options.dropOnEmpty)
            return;
          if (this.currentContainer === this.containers[innermostIndex]) {
            this.currentContainer.containerCache.over || (this.containers[innermostIndex]._trigger("over", event2, this._uiHash()), this.currentContainer.containerCache.over = 1);
            return;
          }
          itemWithLeastDistance ? this._rearrange(event2, itemWithLeastDistance, null, !0) : this._rearrange(event2, null, this.containers[innermostIndex].element, !0), this._trigger("change", event2, this._uiHash()), this.containers[innermostIndex]._trigger("change", event2, this._uiHash(this)), this.currentContainer = this.containers[innermostIndex], this.options.placeholder.update(this.currentContainer, this.placeholder), this.scrollParent = this.placeholder.scrollParent(), this.scrollParent[0] !== this.document[0] && this.scrollParent[0].tagName !== "HTML" && (this.overflowOffset = this.scrollParent.offset()), this.containers[innermostIndex]._trigger("over", event2, this._uiHash(this)), this.containers[innermostIndex].containerCache.over = 1;
        }
    }, "_contactContainers"),
    _createHelper: /* @__PURE__ */ __name(function(event2) {
      var o = this.options, helper = typeof o.helper == "function" ? $2(o.helper.apply(this.element[0], [event2, this.currentItem])) : o.helper === "clone" ? this.currentItem.clone() : this.currentItem;
      return helper.parents("body").length || this.appendTo[0].appendChild(helper[0]), helper[0] === this.currentItem[0] && (this._storedCSS = {
        width: this.currentItem[0].style.width,
        height: this.currentItem[0].style.height,
        position: this.currentItem.css("position"),
        top: this.currentItem.css("top"),
        left: this.currentItem.css("left")
      }), (!helper[0].style.width || o.forceHelperSize) && helper.width(this.currentItem.width()), (!helper[0].style.height || o.forceHelperSize) && helper.height(this.currentItem.height()), helper;
    }, "_createHelper"),
    _adjustOffsetFromHelper: /* @__PURE__ */ __name(function(obj2) {
      typeof obj2 == "string" && (obj2 = obj2.split(" ")), Array.isArray(obj2) && (obj2 = { left: +obj2[0], top: +obj2[1] || 0 }), "left" in obj2 && (this.offset.click.left = obj2.left + this.margins.left), "right" in obj2 && (this.offset.click.left = this.helperProportions.width - obj2.right + this.margins.left), "top" in obj2 && (this.offset.click.top = obj2.top + this.margins.top), "bottom" in obj2 && (this.offset.click.top = this.helperProportions.height - obj2.bottom + this.margins.top);
    }, "_adjustOffsetFromHelper"),
    _getParentOffset: /* @__PURE__ */ __name(function() {
      this.offsetParent = this.helper.offsetParent();
      var po = this.offsetParent.offset();
      return this.cssPosition === "absolute" && this.scrollParent[0] !== this.document[0] && $2.contains(this.scrollParent[0], this.offsetParent[0]) && (po.left += this.scrollParent.scrollLeft(), po.top += this.scrollParent.scrollTop()), this.offsetParent[0] === this.document[0].body && (po = { top: 0, left: 0 }), {
        top: po.top + (parseInt(this.offsetParent.css("borderTopWidth"), 10) || 0),
        left: po.left + (parseInt(this.offsetParent.css("borderLeftWidth"), 10) || 0)
      };
    }, "_getParentOffset"),
    _getRelativeOffset: /* @__PURE__ */ __name(function() {
      if (this.cssPosition === "relative") {
        var p = this.currentItem.position();
        return {
          top: p.top - (parseInt(this.helper.css("top"), 10) || 0) + this.scrollParent.scrollTop(),
          left: p.left - (parseInt(this.helper.css("left"), 10) || 0) + this.scrollParent.scrollLeft()
        };
      } else
        return { top: 0, left: 0 };
    }, "_getRelativeOffset"),
    _cacheMargins: /* @__PURE__ */ __name(function() {
      this.margins = {
        left: parseInt(this.currentItem.css("marginLeft"), 10) || 0,
        top: parseInt(this.currentItem.css("marginTop"), 10) || 0
      };
    }, "_cacheMargins"),
    _cacheHelperProportions: /* @__PURE__ */ __name(function() {
      this.helperProportions = {
        width: this.helper.outerWidth(),
        height: this.helper.outerHeight()
      };
    }, "_cacheHelperProportions"),
    _setContainment: /* @__PURE__ */ __name(function() {
      var ce, co, over, o = this.options;
      o.containment === "parent" && (o.containment = this.helper[0].parentNode), (o.containment === "document" || o.containment === "window") && (this.containment = [
        0 - this.offset.relative.left - this.offset.parent.left,
        0 - this.offset.relative.top - this.offset.parent.top,
        o.containment === "document" ? this.document.width() : this.window.width() - this.helperProportions.width - this.margins.left,
        (o.containment === "document" ? this.document.height() || document.body.parentNode.scrollHeight : this.window.height() || this.document[0].body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top
      ]), /^(document|window|parent)$/.test(o.containment) || (ce = $2(o.containment)[0], co = $2(o.containment).offset(), over = $2(ce).css("overflow") !== "hidden", this.containment = [
        co.left + (parseInt($2(ce).css("borderLeftWidth"), 10) || 0) + (parseInt($2(ce).css("paddingLeft"), 10) || 0) - this.margins.left,
        co.top + (parseInt($2(ce).css("borderTopWidth"), 10) || 0) + (parseInt($2(ce).css("paddingTop"), 10) || 0) - this.margins.top,
        co.left + (over ? Math.max(ce.scrollWidth, ce.offsetWidth) : ce.offsetWidth) - (parseInt($2(ce).css("borderLeftWidth"), 10) || 0) - (parseInt($2(ce).css("paddingRight"), 10) || 0) - this.helperProportions.width - this.margins.left,
        co.top + (over ? Math.max(ce.scrollHeight, ce.offsetHeight) : ce.offsetHeight) - (parseInt($2(ce).css("borderTopWidth"), 10) || 0) - (parseInt($2(ce).css("paddingBottom"), 10) || 0) - this.helperProportions.height - this.margins.top
      ]);
    }, "_setContainment"),
    _convertPositionTo: /* @__PURE__ */ __name(function(d, pos) {
      pos || (pos = this.position);
      var mod = d === "absolute" ? 1 : -1, scroll = this.cssPosition === "absolute" && !(this.scrollParent[0] !== this.document[0] && $2.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent, scrollIsRootNode = /(html|body)/i.test(scroll[0].tagName);
      return {
        top: (
          // The absolute mouse position
          pos.top + // Only for relative positioned nodes: Relative offset from element to offset parent
          this.offset.relative.top * mod + // The offsetParent's offset without borders (offset + border)
          this.offset.parent.top * mod - (this.cssPosition === "fixed" ? -this.scrollParent.scrollTop() : scrollIsRootNode ? 0 : scroll.scrollTop()) * mod
        ),
        left: (
          // The absolute mouse position
          pos.left + // Only for relative positioned nodes: Relative offset from element to offset parent
          this.offset.relative.left * mod + // The offsetParent's offset without borders (offset + border)
          this.offset.parent.left * mod - (this.cssPosition === "fixed" ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft()) * mod
        )
      };
    }, "_convertPositionTo"),
    _generatePosition: /* @__PURE__ */ __name(function(event2) {
      var top2, left2, o = this.options, pageX = event2.pageX, pageY = event2.pageY, scroll = this.cssPosition === "absolute" && !(this.scrollParent[0] !== this.document[0] && $2.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent, scrollIsRootNode = /(html|body)/i.test(scroll[0].tagName);
      return this.cssPosition === "relative" && !(this.scrollParent[0] !== this.document[0] && this.scrollParent[0] !== this.offsetParent[0]) && (this.offset.relative = this._getRelativeOffset()), this.originalPosition && (this.containment && (event2.pageX - this.offset.click.left < this.containment[0] && (pageX = this.containment[0] + this.offset.click.left), event2.pageY - this.offset.click.top < this.containment[1] && (pageY = this.containment[1] + this.offset.click.top), event2.pageX - this.offset.click.left > this.containment[2] && (pageX = this.containment[2] + this.offset.click.left), event2.pageY - this.offset.click.top > this.containment[3] && (pageY = this.containment[3] + this.offset.click.top)), o.grid && (top2 = this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1], pageY = this.containment ? top2 - this.offset.click.top >= this.containment[1] && top2 - this.offset.click.top <= this.containment[3] ? top2 : top2 - this.offset.click.top >= this.containment[1] ? top2 - o.grid[1] : top2 + o.grid[1] : top2, left2 = this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0], pageX = this.containment ? left2 - this.offset.click.left >= this.containment[0] && left2 - this.offset.click.left <= this.containment[2] ? left2 : left2 - this.offset.click.left >= this.containment[0] ? left2 - o.grid[0] : left2 + o.grid[0] : left2)), {
        top: (
          // The absolute mouse position
          pageY - // Click offset (relative to the element)
          this.offset.click.top - // Only for relative positioned nodes: Relative offset from element to offset parent
          this.offset.relative.top - // The offsetParent's offset without borders (offset + border)
          this.offset.parent.top + (this.cssPosition === "fixed" ? -this.scrollParent.scrollTop() : scrollIsRootNode ? 0 : scroll.scrollTop())
        ),
        left: (
          // The absolute mouse position
          pageX - // Click offset (relative to the element)
          this.offset.click.left - // Only for relative positioned nodes: Relative offset from element to offset parent
          this.offset.relative.left - // The offsetParent's offset without borders (offset + border)
          this.offset.parent.left + (this.cssPosition === "fixed" ? -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 : scroll.scrollLeft())
        )
      };
    }, "_generatePosition"),
    _rearrange: /* @__PURE__ */ __name(function(event2, i, a2, hardRefresh) {
      a2 ? a2[0].appendChild(this.placeholder[0]) : i.item[0].parentNode.insertBefore(
        this.placeholder[0],
        this.direction === "down" ? i.item[0] : i.item[0].nextSibling
      ), this.counter = this.counter ? ++this.counter : 1;
      var counter = this.counter;
      this._delay(function() {
        counter === this.counter && this.refreshPositions(!hardRefresh);
      });
    }, "_rearrange"),
    _clear: /* @__PURE__ */ __name(function(event2, noPropagation) {
      this.reverting = !1;
      var i, delayedTriggers = [];
      if (!this._noFinalSort && this.currentItem.parent().length && this.placeholder.before(this.currentItem), this._noFinalSort = null, this.helper[0] === this.currentItem[0]) {
        for (i in this._storedCSS)
          (this._storedCSS[i] === "auto" || this._storedCSS[i] === "static") && (this._storedCSS[i] = "");
        this.currentItem.css(this._storedCSS), this._removeClass(this.currentItem, "ui-sortable-helper");
      } else
        this.currentItem.show();
      this.fromOutside && !noPropagation && delayedTriggers.push(function(event3) {
        this._trigger("receive", event3, this._uiHash(this.fromOutside));
      }), (this.fromOutside || this.domPosition.prev !== this.currentItem.prev().not(".ui-sortable-helper")[0] || this.domPosition.parent !== this.currentItem.parent()[0]) && !noPropagation && delayedTriggers.push(function(event3) {
        this._trigger("update", event3, this._uiHash());
      }), this !== this.currentContainer && (noPropagation || (delayedTriggers.push(function(event3) {
        this._trigger("remove", event3, this._uiHash());
      }), delayedTriggers.push((function(c) {
        return function(event3) {
          c._trigger("receive", event3, this._uiHash(this));
        };
      }).call(this, this.currentContainer)), delayedTriggers.push((function(c) {
        return function(event3) {
          c._trigger("update", event3, this._uiHash(this));
        };
      }).call(this, this.currentContainer))));
      function delayEvent(type2, instance, container) {
        return function(event3) {
          container._trigger(type2, event3, instance._uiHash(instance));
        };
      }
      for (__name(delayEvent, "delayEvent"), i = this.containers.length - 1; i >= 0; i--)
        noPropagation || delayedTriggers.push(delayEvent("deactivate", this, this.containers[i])), this.containers[i].containerCache.over && (delayedTriggers.push(delayEvent("out", this, this.containers[i])), this.containers[i].containerCache.over = 0);
      if (this._storedStylesheet && (this._storedStylesheet.remove(), this._storedStylesheet = null), this._storedOpacity && this.helper.css("opacity", this._storedOpacity), this._storedZIndex && this.helper.css("zIndex", this._storedZIndex === "auto" ? "" : this._storedZIndex), this.dragging = !1, noPropagation || this._trigger("beforeStop", event2, this._uiHash()), this.placeholder[0].parentNode.removeChild(this.placeholder[0]), this.cancelHelperRemoval || (this.helper[0] !== this.currentItem[0] && this.helper.remove(), this.helper = null), !noPropagation) {
        for (i = 0; i < delayedTriggers.length; i++)
          delayedTriggers[i].call(this, event2);
        this._trigger("stop", event2, this._uiHash());
      }
      return this.fromOutside = !1, !this.cancelHelperRemoval;
    }, "_clear"),
    _trigger: /* @__PURE__ */ __name(function() {
      $2.Widget.prototype._trigger.apply(this, arguments) === !1 && this.cancel();
    }, "_trigger"),
    _uiHash: /* @__PURE__ */ __name(function(_inst) {
      var inst = _inst || this;
      return {
        helper: inst.helper,
        placeholder: inst.placeholder || $2([]),
        position: inst.position,
        originalPosition: inst.originalPosition,
        offset: inst.positionAbs,
        item: inst.currentItem,
        sender: _inst ? _inst.element : null
      };
    }, "_uiHash")
  });
  /*!
   * jQuery UI Spinner 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  function spinnerModifier(fn2) {
    return function() {
      var previous = this.element.val();
      fn2.apply(this, arguments), this._refresh(), previous !== this.element.val() && this._trigger("change");
    };
  }
  __name(spinnerModifier, "spinnerModifier"), $2.widget("ui.spinner", {
    version: "1.14.1",
    defaultElement: "<input>",
    widgetEventPrefix: "spin",
    options: {
      classes: {
        "ui-spinner": "ui-corner-all",
        "ui-spinner-down": "ui-corner-br",
        "ui-spinner-up": "ui-corner-tr"
      },
      culture: null,
      icons: {
        down: "ui-icon-triangle-1-s",
        up: "ui-icon-triangle-1-n"
      },
      incremental: !0,
      max: null,
      min: null,
      numberFormat: null,
      page: 10,
      step: 1,
      change: null,
      spin: null,
      start: null,
      stop: null
    },
    _create: /* @__PURE__ */ __name(function() {
      this._setOption("max", this.options.max), this._setOption("min", this.options.min), this._setOption("step", this.options.step), this.value() !== "" && this._value(this.element.val(), !0), this._draw(), this._on(this._events), this._refresh(), this._on(this.window, {
        beforeunload: /* @__PURE__ */ __name(function() {
          this.element.removeAttr("autocomplete");
        }, "beforeunload")
      });
    }, "_create"),
    _getCreateOptions: /* @__PURE__ */ __name(function() {
      var options2 = this._super(), element = this.element;
      return $2.each(["min", "max", "step"], function(i, option2) {
        var value3 = element.attr(option2);
        value3 != null && value3.length && (options2[option2] = value3);
      }), options2;
    }, "_getCreateOptions"),
    _events: {
      keydown: /* @__PURE__ */ __name(function(event2) {
        this._start(event2) && this._keydown(event2) && event2.preventDefault();
      }, "keydown"),
      keyup: "_stop",
      focus: /* @__PURE__ */ __name(function() {
        this.previous = this.element.val();
      }, "focus"),
      blur: /* @__PURE__ */ __name(function(event2) {
        this._stop(), this._refresh(), this.previous !== this.element.val() && this._trigger("change", event2);
      }, "blur"),
      mousewheel: /* @__PURE__ */ __name(function(event2, delta) {
        var activeElement = this.document[0].activeElement, isActive = this.element[0] === activeElement;
        if (!(!isActive || !delta)) {
          if (!this.spinning && !this._start(event2))
            return !1;
          this._spin((delta > 0 ? 1 : -1) * this.options.step, event2), clearTimeout(this.mousewheelTimer), this.mousewheelTimer = this._delay(function() {
            this.spinning && this._stop(event2);
          }, 100), event2.preventDefault();
        }
      }, "mousewheel"),
      "mousedown .ui-spinner-button": /* @__PURE__ */ __name(function(event2) {
        var previous;
        previous = this.element[0] === this.document[0].activeElement ? this.previous : this.element.val();
        function checkFocus() {
          var isActive = this.element[0] === this.document[0].activeElement;
          isActive || (this.element.trigger("focus"), this.previous = previous);
        }
        __name(checkFocus, "checkFocus"), event2.preventDefault(), checkFocus.call(this), this._start(event2) !== !1 && this._repeat(null, $2(event2.currentTarget).hasClass("ui-spinner-up") ? 1 : -1, event2);
      }, "mousedown .ui-spinner-button"),
      "mouseup .ui-spinner-button": "_stop",
      "mouseenter .ui-spinner-button": /* @__PURE__ */ __name(function(event2) {
        if ($2(event2.currentTarget).hasClass("ui-state-active")) {
          if (this._start(event2) === !1)
            return !1;
          this._repeat(null, $2(event2.currentTarget).hasClass("ui-spinner-up") ? 1 : -1, event2);
        }
      }, "mouseenter .ui-spinner-button"),
      // TODO: do we really want to consider this a stop?
      // shouldn't we just stop the repeater and wait until mouseup before
      // we trigger the stop event?
      "mouseleave .ui-spinner-button": "_stop"
    },
    // Support mobile enhanced option and make backcompat more sane
    _enhance: /* @__PURE__ */ __name(function() {
      this.uiSpinner = this.element.attr("autocomplete", "off").wrap("<span>").parent().append(
        "<a></a><a></a>"
      );
    }, "_enhance"),
    _draw: /* @__PURE__ */ __name(function() {
      this._enhance(), this._addClass(this.uiSpinner, "ui-spinner", "ui-widget ui-widget-content"), this._addClass("ui-spinner-input"), this.element.attr("role", "spinbutton"), this.buttons = this.uiSpinner.children("a").attr("tabIndex", -1).attr("aria-hidden", !0).button({
        classes: {
          "ui-button": ""
        }
      }), this._removeClass(this.buttons, "ui-corner-all"), this._addClass(this.buttons.first(), "ui-spinner-button ui-spinner-up"), this._addClass(this.buttons.last(), "ui-spinner-button ui-spinner-down"), this.buttons.first().button({
        icon: this.options.icons.up,
        showLabel: !1
      }), this.buttons.last().button({
        icon: this.options.icons.down,
        showLabel: !1
      }), this.buttons.height() > Math.ceil(this.uiSpinner.height() * 0.5) && this.uiSpinner.height() > 0 && this.uiSpinner.height(this.uiSpinner.height());
    }, "_draw"),
    _keydown: /* @__PURE__ */ __name(function(event2) {
      var options2 = this.options, keyCode = $2.ui.keyCode;
      switch (event2.keyCode) {
        case keyCode.UP:
          return this._repeat(null, 1, event2), !0;
        case keyCode.DOWN:
          return this._repeat(null, -1, event2), !0;
        case keyCode.PAGE_UP:
          return this._repeat(null, options2.page, event2), !0;
        case keyCode.PAGE_DOWN:
          return this._repeat(null, -options2.page, event2), !0;
      }
      return !1;
    }, "_keydown"),
    _start: /* @__PURE__ */ __name(function(event2) {
      return !this.spinning && this._trigger("start", event2) === !1 ? !1 : (this.counter || (this.counter = 1), this.spinning = !0, !0);
    }, "_start"),
    _repeat: /* @__PURE__ */ __name(function(i, steps, event2) {
      i = i || 500, clearTimeout(this.timer), this.timer = this._delay(function() {
        this._repeat(40, steps, event2);
      }, i), this._spin(steps * this.options.step, event2);
    }, "_repeat"),
    _spin: /* @__PURE__ */ __name(function(step, event2) {
      var value3 = this.value() || 0;
      this.counter || (this.counter = 1), value3 = this._adjustValue(value3 + step * this._increment(this.counter)), (!this.spinning || this._trigger("spin", event2, { value: value3 }) !== !1) && (this._value(value3), this.counter++);
    }, "_spin"),
    _increment: /* @__PURE__ */ __name(function(i) {
      var incremental = this.options.incremental;
      return incremental ? typeof incremental == "function" ? incremental(i) : Math.floor(i * i * i / 5e4 - i * i / 500 + 17 * i / 200 + 1) : 1;
    }, "_increment"),
    _precision: /* @__PURE__ */ __name(function() {
      var precision = this._precisionOf(this.options.step);
      return this.options.min !== null && (precision = Math.max(precision, this._precisionOf(this.options.min))), precision;
    }, "_precision"),
    _precisionOf: /* @__PURE__ */ __name(function(num) {
      var str2 = num.toString(), decimal2 = str2.indexOf(".");
      return decimal2 === -1 ? 0 : str2.length - decimal2 - 1;
    }, "_precisionOf"),
    _adjustValue: /* @__PURE__ */ __name(function(value3) {
      var base, aboveMin, options2 = this.options;
      return base = options2.min !== null ? options2.min : 0, aboveMin = value3 - base, aboveMin = Math.round(aboveMin / options2.step) * options2.step, value3 = base + aboveMin, value3 = parseFloat(value3.toFixed(this._precision())), options2.max !== null && value3 > options2.max ? options2.max : options2.min !== null && value3 < options2.min ? options2.min : value3;
    }, "_adjustValue"),
    _stop: /* @__PURE__ */ __name(function(event2) {
      this.spinning && (clearTimeout(this.timer), clearTimeout(this.mousewheelTimer), this.counter = 0, this.spinning = !1, this._trigger("stop", event2));
    }, "_stop"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      var prevValue, first2, last;
      if (key === "culture" || key === "numberFormat") {
        prevValue = this._parse(this.element.val()), this.options[key] = value3, this.element.val(this._format(prevValue));
        return;
      }
      (key === "max" || key === "min" || key === "step") && typeof value3 == "string" && (value3 = this._parse(value3)), key === "icons" && (first2 = this.buttons.first().find(".ui-icon"), this._removeClass(first2, null, this.options.icons.up), this._addClass(first2, null, value3.up), last = this.buttons.last().find(".ui-icon"), this._removeClass(last, null, this.options.icons.down), this._addClass(last, null, value3.down)), this._super(key, value3);
    }, "_setOption"),
    _setOptionDisabled: /* @__PURE__ */ __name(function(value3) {
      this._super(value3), this._toggleClass(this.uiSpinner, null, "ui-state-disabled", !!value3), this.element.prop("disabled", !!value3), this.buttons.button(value3 ? "disable" : "enable");
    }, "_setOptionDisabled"),
    _setOptions: spinnerModifier(function(options2) {
      this._super(options2);
    }),
    _parse: /* @__PURE__ */ __name(function(val) {
      return typeof val == "string" && val !== "" && (val = window.Globalize && this.options.numberFormat ? Globalize.parseFloat(val, 10, this.options.culture) : +val), val === "" || isNaN(val) ? null : val;
    }, "_parse"),
    _format: /* @__PURE__ */ __name(function(value3) {
      return value3 === "" ? "" : window.Globalize && this.options.numberFormat ? Globalize.format(value3, this.options.numberFormat, this.options.culture) : value3;
    }, "_format"),
    _refresh: /* @__PURE__ */ __name(function() {
      this.element.attr({
        "aria-valuemin": this.options.min,
        "aria-valuemax": this.options.max,
        // TODO: what should we do with values that can't be parsed?
        "aria-valuenow": this._parse(this.element.val())
      });
    }, "_refresh"),
    isValid: /* @__PURE__ */ __name(function() {
      var value3 = this.value();
      return value3 === null ? !1 : value3 === this._adjustValue(value3);
    }, "isValid"),
    // Update the value without triggering change
    _value: /* @__PURE__ */ __name(function(value3, allowAny) {
      var parsed;
      value3 !== "" && (parsed = this._parse(value3), parsed !== null && (allowAny || (parsed = this._adjustValue(parsed)), value3 = this._format(parsed))), this.element.val(value3), this._refresh();
    }, "_value"),
    _destroy: /* @__PURE__ */ __name(function() {
      this.element.prop("disabled", !1).removeAttr("autocomplete role aria-valuemin aria-valuemax aria-valuenow"), this.uiSpinner.replaceWith(this.element);
    }, "_destroy"),
    stepUp: spinnerModifier(function(steps) {
      this._stepUp(steps);
    }),
    _stepUp: /* @__PURE__ */ __name(function(steps) {
      this._start() && (this._spin((steps || 1) * this.options.step), this._stop());
    }, "_stepUp"),
    stepDown: spinnerModifier(function(steps) {
      this._stepDown(steps);
    }),
    _stepDown: /* @__PURE__ */ __name(function(steps) {
      this._start() && (this._spin((steps || 1) * -this.options.step), this._stop());
    }, "_stepDown"),
    pageUp: spinnerModifier(function(pages2) {
      this._stepUp((pages2 || 1) * this.options.page);
    }),
    pageDown: spinnerModifier(function(pages2) {
      this._stepDown((pages2 || 1) * this.options.page);
    }),
    value: /* @__PURE__ */ __name(function(newVal) {
      if (!arguments.length)
        return this._parse(this.element.val());
      spinnerModifier(this._value).call(this, newVal);
    }, "value"),
    widget: /* @__PURE__ */ __name(function() {
      return this.uiSpinner;
    }, "widget")
  }), $2.uiBackCompat === !0 && $2.widget("ui.spinner", $2.ui.spinner, {
    _enhance: /* @__PURE__ */ __name(function() {
      this.uiSpinner = this.element.attr("autocomplete", "off").wrap(this._uiSpinnerHtml()).parent().append(this._buttonHtml());
    }, "_enhance"),
    _uiSpinnerHtml: /* @__PURE__ */ __name(function() {
      return "<span>";
    }, "_uiSpinnerHtml"),
    _buttonHtml: /* @__PURE__ */ __name(function() {
      return "<a></a><a></a>";
    }, "_buttonHtml")
  }), $2.ui.spinner;
  /*!
   * jQuery UI Tabs 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.tabs", {
    version: "1.14.1",
    delay: 300,
    options: {
      active: null,
      classes: {
        "ui-tabs": "ui-corner-all",
        "ui-tabs-nav": "ui-corner-all",
        "ui-tabs-panel": "ui-corner-bottom",
        "ui-tabs-tab": "ui-corner-top"
      },
      collapsible: !1,
      event: "click",
      heightStyle: "content",
      hide: null,
      show: null,
      // Callbacks
      activate: null,
      beforeActivate: null,
      beforeLoad: null,
      load: null
    },
    _isLocal: /* @__PURE__ */ function() {
      var rhash = /#.*$/;
      return function(anchor) {
        var anchorUrl, locationUrl;
        anchorUrl = anchor.href.replace(rhash, ""), locationUrl = location.href.replace(rhash, "");
        try {
          anchorUrl = decodeURIComponent(anchorUrl);
        } catch {
        }
        try {
          locationUrl = decodeURIComponent(locationUrl);
        } catch {
        }
        return anchor.hash.length > 1 && anchorUrl === locationUrl;
      };
    }(),
    _create: /* @__PURE__ */ __name(function() {
      var that = this, options2 = this.options;
      this.running = !1, this._addClass("ui-tabs", "ui-widget ui-widget-content"), this._toggleClass("ui-tabs-collapsible", null, options2.collapsible), this._processTabs(), options2.active = this._initialActive(), Array.isArray(options2.disabled) && (options2.disabled = $2.uniqueSort(options2.disabled.concat(
        $2.map(this.tabs.filter(".ui-state-disabled"), function(li) {
          return that.tabs.index(li);
        })
      )).sort()), this.options.active !== !1 && this.anchors.length ? this.active = this._findActive(options2.active) : this.active = $2(), this._refresh(), this.active.length && this.load(options2.active);
    }, "_create"),
    _initialActive: /* @__PURE__ */ __name(function() {
      var active = this.options.active, collapsible = this.options.collapsible, locationHashDecoded = decodeURIComponent(location.hash.substring(1));
      return active === null && (locationHashDecoded && this.tabs.each(function(i, tab) {
        if ($2(tab).attr("aria-controls") === locationHashDecoded)
          return active = i, !1;
      }), active === null && (active = this.tabs.index(this.tabs.filter(".ui-tabs-active"))), (active === null || active === -1) && (active = this.tabs.length ? 0 : !1)), active !== !1 && (active = this.tabs.index(this.tabs.eq(active)), active === -1 && (active = collapsible ? !1 : 0)), !collapsible && active === !1 && this.anchors.length && (active = 0), active;
    }, "_initialActive"),
    _getCreateEventData: /* @__PURE__ */ __name(function() {
      return {
        tab: this.active,
        panel: this.active.length ? this._getPanelForTab(this.active) : $2()
      };
    }, "_getCreateEventData"),
    _tabKeydown: /* @__PURE__ */ __name(function(event2) {
      var focusedTab = $2(this.document[0].activeElement).closest("li"), selectedIndex = this.tabs.index(focusedTab), goingForward = !0;
      if (!this._handlePageNav(event2)) {
        switch (event2.keyCode) {
          case $2.ui.keyCode.RIGHT:
          case $2.ui.keyCode.DOWN:
            selectedIndex++;
            break;
          case $2.ui.keyCode.UP:
          case $2.ui.keyCode.LEFT:
            goingForward = !1, selectedIndex--;
            break;
          case $2.ui.keyCode.END:
            selectedIndex = this.anchors.length - 1;
            break;
          case $2.ui.keyCode.HOME:
            selectedIndex = 0;
            break;
          case $2.ui.keyCode.SPACE:
            event2.preventDefault(), clearTimeout(this.activating), this._activate(selectedIndex);
            return;
          case $2.ui.keyCode.ENTER:
            event2.preventDefault(), clearTimeout(this.activating), this._activate(selectedIndex === this.options.active ? !1 : selectedIndex);
            return;
          default:
            return;
        }
        event2.preventDefault(), clearTimeout(this.activating), selectedIndex = this._focusNextTab(selectedIndex, goingForward), !event2.ctrlKey && !event2.metaKey && (focusedTab.attr("aria-selected", "false"), this.tabs.eq(selectedIndex).attr("aria-selected", "true"), this.activating = this._delay(function() {
          this.option("active", selectedIndex);
        }, this.delay));
      }
    }, "_tabKeydown"),
    _panelKeydown: /* @__PURE__ */ __name(function(event2) {
      this._handlePageNav(event2) || event2.ctrlKey && event2.keyCode === $2.ui.keyCode.UP && (event2.preventDefault(), this.active.trigger("focus"));
    }, "_panelKeydown"),
    // Alt+page up/down moves focus to the previous/next tab (and activates)
    _handlePageNav: /* @__PURE__ */ __name(function(event2) {
      if (event2.altKey && event2.keyCode === $2.ui.keyCode.PAGE_UP)
        return this._activate(this._focusNextTab(this.options.active - 1, !1)), !0;
      if (event2.altKey && event2.keyCode === $2.ui.keyCode.PAGE_DOWN)
        return this._activate(this._focusNextTab(this.options.active + 1, !0)), !0;
    }, "_handlePageNav"),
    _findNextTab: /* @__PURE__ */ __name(function(index3, goingForward) {
      var lastTabIndex = this.tabs.length - 1;
      function constrain() {
        return index3 > lastTabIndex && (index3 = 0), index3 < 0 && (index3 = lastTabIndex), index3;
      }
      for (__name(constrain, "constrain"); $2.inArray(constrain(), this.options.disabled) !== -1; )
        index3 = goingForward ? index3 + 1 : index3 - 1;
      return index3;
    }, "_findNextTab"),
    _focusNextTab: /* @__PURE__ */ __name(function(index3, goingForward) {
      return index3 = this._findNextTab(index3, goingForward), this.tabs.eq(index3).trigger("focus"), index3;
    }, "_focusNextTab"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      if (key === "active") {
        this._activate(value3);
        return;
      }
      this._super(key, value3), key === "collapsible" && (this._toggleClass("ui-tabs-collapsible", null, value3), !value3 && this.options.active === !1 && this._activate(0)), key === "event" && this._setupEvents(value3), key === "heightStyle" && this._setupHeightStyle(value3);
    }, "_setOption"),
    refresh: /* @__PURE__ */ __name(function() {
      var options2 = this.options, lis = this.tablist.children(":has(a[href])");
      options2.disabled = $2.map(lis.filter(".ui-state-disabled"), function(tab) {
        return lis.index(tab);
      }), this._processTabs(), options2.active === !1 || !this.anchors.length ? (options2.active = !1, this.active = $2()) : this.active.length && !$2.contains(this.tablist[0], this.active[0]) ? this.tabs.length === options2.disabled.length ? (options2.active = !1, this.active = $2()) : this._activate(this._findNextTab(Math.max(0, options2.active - 1), !1)) : options2.active = this.tabs.index(this.active), this._refresh();
    }, "refresh"),
    _refresh: /* @__PURE__ */ __name(function() {
      this._setOptionDisabled(this.options.disabled), this._setupEvents(this.options.event), this._setupHeightStyle(this.options.heightStyle), this.tabs.not(this.active).attr({
        "aria-selected": "false",
        "aria-expanded": "false",
        tabIndex: -1
      }), this.panels.not(this._getPanelForTab(this.active)).hide().attr({
        "aria-hidden": "true"
      }), this.active.length ? (this.active.attr({
        "aria-selected": "true",
        "aria-expanded": "true",
        tabIndex: 0
      }), this._addClass(this.active, "ui-tabs-active", "ui-state-active"), this._getPanelForTab(this.active).show().attr({
        "aria-hidden": "false"
      })) : this.tabs.eq(0).attr("tabIndex", 0);
    }, "_refresh"),
    _processTabs: /* @__PURE__ */ __name(function() {
      var that = this, prevTabs = this.tabs, prevAnchors = this.anchors, prevPanels = this.panels;
      this.tablist = this._getList().attr("role", "tablist"), this._addClass(
        this.tablist,
        "ui-tabs-nav",
        "ui-helper-reset ui-helper-clearfix ui-widget-header"
      ), this.tablist.on("mousedown" + this.eventNamespace, "> li", function(event2) {
        $2(this).is(".ui-state-disabled") && event2.preventDefault();
      }), this.tabs = this.tablist.find("> li:has(a[href])").attr({
        role: "tab",
        tabIndex: -1
      }), this._addClass(this.tabs, "ui-tabs-tab", "ui-state-default"), this.anchors = this.tabs.map(function() {
        return $2("a", this)[0];
      }).attr({
        tabIndex: -1
      }), this._addClass(this.anchors, "ui-tabs-anchor"), this.panels = $2(), this.anchors.each(function(i, anchor) {
        var selector, panel, panelId, anchorId = $2(anchor).uniqueId().attr("id"), tab = $2(anchor).closest("li"), originalAriaControls = tab.attr("aria-controls");
        that._isLocal(anchor) ? (selector = decodeURIComponent(anchor.hash), panelId = selector.substring(1), panel = that.element.find("#" + CSS.escape(panelId))) : (panelId = tab.attr("aria-controls") || $2({}).uniqueId()[0].id, selector = "#" + panelId, panel = that.element.find(selector), panel.length || (panel = that._createPanel(panelId), panel.insertAfter(that.panels[i - 1] || that.tablist)), panel.attr("aria-live", "polite")), panel.length && (that.panels = that.panels.add(panel)), originalAriaControls && tab.data("ui-tabs-aria-controls", originalAriaControls), tab.attr({
          "aria-controls": panelId,
          "aria-labelledby": anchorId
        }), panel.attr("aria-labelledby", anchorId);
      }), this.panels.attr("role", "tabpanel"), this._addClass(this.panels, "ui-tabs-panel", "ui-widget-content"), prevTabs && (this._off(prevTabs.not(this.tabs)), this._off(prevAnchors.not(this.anchors)), this._off(prevPanels.not(this.panels)));
    }, "_processTabs"),
    // Allow overriding how to find the list for rare usage scenarios (#7715)
    _getList: /* @__PURE__ */ __name(function() {
      return this.tablist || this.element.find("ol, ul").eq(0);
    }, "_getList"),
    _createPanel: /* @__PURE__ */ __name(function(id2) {
      return $2("<div>").attr("id", id2).data("ui-tabs-destroy", !0);
    }, "_createPanel"),
    _setOptionDisabled: /* @__PURE__ */ __name(function(disabled6) {
      var currentItem, li, i;
      for (Array.isArray(disabled6) && (disabled6.length ? disabled6.length === this.anchors.length && (disabled6 = !0) : disabled6 = !1), i = 0; li = this.tabs[i]; i++)
        currentItem = $2(li), disabled6 === !0 || $2.inArray(i, disabled6) !== -1 ? (currentItem.attr("aria-disabled", "true"), this._addClass(currentItem, null, "ui-state-disabled")) : (currentItem.removeAttr("aria-disabled"), this._removeClass(currentItem, null, "ui-state-disabled"));
      this.options.disabled = disabled6, this._toggleClass(
        this.widget(),
        this.widgetFullName + "-disabled",
        null,
        disabled6 === !0
      );
    }, "_setOptionDisabled"),
    _setupEvents: /* @__PURE__ */ __name(function(event2) {
      var events2 = {};
      event2 && $2.each(event2.split(" "), function(index3, eventName) {
        events2[eventName] = "_eventHandler";
      }), this._off(this.anchors.add(this.tabs).add(this.panels)), this._on(!0, this.anchors, {
        click: /* @__PURE__ */ __name(function(event3) {
          event3.preventDefault();
        }, "click")
      }), this._on(this.anchors, events2), this._on(this.tabs, { keydown: "_tabKeydown" }), this._on(this.panels, { keydown: "_panelKeydown" }), this._focusable(this.tabs), this._hoverable(this.tabs);
    }, "_setupEvents"),
    _setupHeightStyle: /* @__PURE__ */ __name(function(heightStyle) {
      var maxHeight, parent = this.element.parent();
      heightStyle === "fill" ? (maxHeight = parent.height(), maxHeight -= this.element.outerHeight() - this.element.height(), this.element.siblings(":visible").each(function() {
        var elem = $2(this), position3 = elem.css("position");
        position3 === "absolute" || position3 === "fixed" || (maxHeight -= elem.outerHeight(!0));
      }), this.element.children().not(this.panels).each(function() {
        maxHeight -= $2(this).outerHeight(!0);
      }), this.panels.each(function() {
        $2(this).height(Math.max(0, maxHeight - $2(this).innerHeight() + $2(this).height()));
      }).css("overflow", "auto")) : heightStyle === "auto" && (maxHeight = 0, this.panels.each(function() {
        maxHeight = Math.max(maxHeight, $2(this).height("").height());
      }).height(maxHeight));
    }, "_setupHeightStyle"),
    _eventHandler: /* @__PURE__ */ __name(function(event2) {
      var options2 = this.options, active = this.active, anchor = $2(event2.currentTarget), tab = anchor.closest("li"), clickedIsActive = tab[0] === active[0], collapsing = clickedIsActive && options2.collapsible, toShow = collapsing ? $2() : this._getPanelForTab(tab), toHide = active.length ? this._getPanelForTab(active) : $2(), eventData = {
        oldTab: active,
        oldPanel: toHide,
        newTab: collapsing ? $2() : tab,
        newPanel: toShow
      };
      event2.preventDefault(), !(tab.hasClass("ui-state-disabled") || // tab is already loading
      tab.hasClass("ui-tabs-loading") || // can't switch durning an animation
      this.running || // click on active header, but not collapsible
      clickedIsActive && !options2.collapsible || // allow canceling activation
      this._trigger("beforeActivate", event2, eventData) === !1) && (options2.active = collapsing ? !1 : this.tabs.index(tab), this.active = clickedIsActive ? $2() : tab, this.xhr && this.xhr.abort(), !toHide.length && !toShow.length && $2.error("jQuery UI Tabs: Mismatching fragment identifier."), toShow.length && this.load(this.tabs.index(tab), event2), this._toggle(event2, eventData));
    }, "_eventHandler"),
    // Handles show/hide for selecting tabs
    _toggle: /* @__PURE__ */ __name(function(event2, eventData) {
      var that = this, toShow = eventData.newPanel, toHide = eventData.oldPanel;
      this.running = !0;
      function complete() {
        that.running = !1, that._trigger("activate", event2, eventData);
      }
      __name(complete, "complete");
      function show7() {
        that._addClass(eventData.newTab.closest("li"), "ui-tabs-active", "ui-state-active"), toShow.length && that.options.show ? that._show(toShow, that.options.show, complete) : (toShow.show(), complete());
      }
      __name(show7, "show"), toHide.length && this.options.hide ? this._hide(toHide, this.options.hide, function() {
        that._removeClass(
          eventData.oldTab.closest("li"),
          "ui-tabs-active",
          "ui-state-active"
        ), show7();
      }) : (this._removeClass(
        eventData.oldTab.closest("li"),
        "ui-tabs-active",
        "ui-state-active"
      ), toHide.hide(), show7()), toHide.attr("aria-hidden", "true"), eventData.oldTab.attr({
        "aria-selected": "false",
        "aria-expanded": "false"
      }), toShow.length && toHide.length ? eventData.oldTab.attr("tabIndex", -1) : toShow.length && this.tabs.filter(function() {
        return $2(this).attr("tabIndex") === 0;
      }).attr("tabIndex", -1), toShow.attr("aria-hidden", "false"), eventData.newTab.attr({
        "aria-selected": "true",
        "aria-expanded": "true",
        tabIndex: 0
      });
    }, "_toggle"),
    _activate: /* @__PURE__ */ __name(function(index3) {
      var anchor, active = this._findActive(index3);
      active[0] !== this.active[0] && (active.length || (active = this.active), anchor = active.find(".ui-tabs-anchor")[0], this._eventHandler({
        target: anchor,
        currentTarget: anchor,
        preventDefault: $2.noop
      }));
    }, "_activate"),
    _findActive: /* @__PURE__ */ __name(function(index3) {
      return index3 === !1 ? $2() : this.tabs.eq(index3);
    }, "_findActive"),
    _getIndex: /* @__PURE__ */ __name(function(index3) {
      return typeof index3 == "string" && (index3 = this.anchors.index(this.anchors.filter("[href$='" + CSS.escape(index3) + "']"))), index3;
    }, "_getIndex"),
    _destroy: /* @__PURE__ */ __name(function() {
      this.xhr && this.xhr.abort(), this.tablist.removeAttr("role").off(this.eventNamespace), this.anchors.removeAttr("role tabIndex").removeUniqueId(), this.tabs.add(this.panels).each(function() {
        $2.data(this, "ui-tabs-destroy") ? $2(this).remove() : $2(this).removeAttr("role tabIndex aria-live aria-busy aria-selected aria-labelledby aria-hidden aria-expanded");
      }), this.tabs.each(function() {
        var li = $2(this), prev2 = li.data("ui-tabs-aria-controls");
        prev2 ? li.attr("aria-controls", prev2).removeData("ui-tabs-aria-controls") : li.removeAttr("aria-controls");
      }), this.panels.show(), this.options.heightStyle !== "content" && this.panels.css("height", "");
    }, "_destroy"),
    enable: /* @__PURE__ */ __name(function(index3) {
      var disabled6 = this.options.disabled;
      disabled6 !== !1 && (index3 === void 0 ? disabled6 = !1 : (index3 = this._getIndex(index3), Array.isArray(disabled6) ? disabled6 = $2.map(disabled6, function(num) {
        return num !== index3 ? num : null;
      }) : disabled6 = $2.map(this.tabs, function(li, num) {
        return num !== index3 ? num : null;
      })), this._setOptionDisabled(disabled6));
    }, "enable"),
    disable: /* @__PURE__ */ __name(function(index3) {
      var disabled6 = this.options.disabled;
      if (disabled6 !== !0) {
        if (index3 === void 0)
          disabled6 = !0;
        else {
          if (index3 = this._getIndex(index3), $2.inArray(index3, disabled6) !== -1)
            return;
          Array.isArray(disabled6) ? disabled6 = $2.merge([index3], disabled6).sort() : disabled6 = [index3];
        }
        this._setOptionDisabled(disabled6);
      }
    }, "disable"),
    load: /* @__PURE__ */ __name(function(index3, event2) {
      index3 = this._getIndex(index3);
      var that = this, tab = this.tabs.eq(index3), anchor = tab.find(".ui-tabs-anchor"), panel = this._getPanelForTab(tab), eventData = {
        tab,
        panel
      }, complete = /* @__PURE__ */ __name(function(jqXHR, status) {
        status === "abort" && that.panels.stop(!1, !0), that._removeClass(tab, "ui-tabs-loading"), panel.removeAttr("aria-busy"), jqXHR === that.xhr && delete that.xhr;
      }, "complete");
      this._isLocal(anchor[0]) || (this.xhr = $2.ajax(this._ajaxSettings(anchor, event2, eventData)), this.xhr.statusText !== "canceled" && (this._addClass(tab, "ui-tabs-loading"), panel.attr("aria-busy", "true"), this.xhr.done(function(response, status, jqXHR) {
        panel.html(response), that._trigger("load", event2, eventData), complete(jqXHR, status);
      }).fail(function(jqXHR, status) {
        complete(jqXHR, status);
      })));
    }, "load"),
    _ajaxSettings: /* @__PURE__ */ __name(function(anchor, event2, eventData) {
      var that = this;
      return {
        url: anchor.attr("href"),
        beforeSend: /* @__PURE__ */ __name(function(jqXHR, settings) {
          return that._trigger(
            "beforeLoad",
            event2,
            $2.extend({ jqXHR, ajaxSettings: settings }, eventData)
          );
        }, "beforeSend")
      };
    }, "_ajaxSettings"),
    _getPanelForTab: /* @__PURE__ */ __name(function(tab) {
      var id2 = $2(tab).attr("aria-controls");
      return this.element.find("#" + CSS.escape(id2));
    }, "_getPanelForTab")
  }), $2.uiBackCompat === !0 && $2.widget("ui.tabs", $2.ui.tabs, {
    _processTabs: /* @__PURE__ */ __name(function() {
      this._superApply(arguments), this._addClass(this.tabs, "ui-tab");
    }, "_processTabs")
  }), $2.ui.tabs;
  /*!
   * jQuery UI Tooltip 1.14.1
   * https://jqueryui.com
   *
   * Copyright OpenJS Foundation and other contributors
   * Released under the MIT license.
   * https://jquery.org/license
   */
  $2.widget("ui.tooltip", {
    version: "1.14.1",
    options: {
      classes: {
        "ui-tooltip": "ui-corner-all ui-widget-shadow"
      },
      content: /* @__PURE__ */ __name(function() {
        var title2 = $2(this).attr("title");
        return $2("<a>").text(title2).html();
      }, "content"),
      hide: !0,
      // Disabled elements have inconsistent behavior across browsers (#8661)
      items: "[title]:not([disabled])",
      position: {
        my: "left top+15",
        at: "left bottom",
        collision: "flipfit flip"
      },
      show: !0,
      track: !1,
      // Callbacks
      close: null,
      open: null
    },
    _addDescribedBy: /* @__PURE__ */ __name(function(elem, id2) {
      var describedby = (elem.attr("aria-describedby") || "").split(/\s+/);
      describedby.push(id2), elem.data("ui-tooltip-id", id2).attr("aria-describedby", String.prototype.trim.call(describedby.join(" ")));
    }, "_addDescribedBy"),
    _removeDescribedBy: /* @__PURE__ */ __name(function(elem) {
      var id2 = elem.data("ui-tooltip-id"), describedby = (elem.attr("aria-describedby") || "").split(/\s+/), index3 = $2.inArray(id2, describedby);
      index3 !== -1 && describedby.splice(index3, 1), elem.removeData("ui-tooltip-id"), describedby = String.prototype.trim.call(describedby.join(" ")), describedby ? elem.attr("aria-describedby", describedby) : elem.removeAttr("aria-describedby");
    }, "_removeDescribedBy"),
    _create: /* @__PURE__ */ __name(function() {
      this._on({
        mouseover: "open",
        focusin: "open"
      }), this.tooltips = {}, this.parents = {}, this.liveRegion = $2("<div>").attr({
        role: "log",
        "aria-live": "assertive",
        "aria-relevant": "additions"
      }).appendTo(this.document[0].body), this._addClass(this.liveRegion, null, "ui-helper-hidden-accessible"), this.disabledTitles = $2([]);
    }, "_create"),
    _setOption: /* @__PURE__ */ __name(function(key, value3) {
      var that = this;
      this._super(key, value3), key === "content" && $2.each(this.tooltips, function(id2, tooltipData) {
        that._updateContent(tooltipData.element);
      });
    }, "_setOption"),
    _setOptionDisabled: /* @__PURE__ */ __name(function(value3) {
      this[value3 ? "_disable" : "_enable"]();
    }, "_setOptionDisabled"),
    _disable: /* @__PURE__ */ __name(function() {
      var that = this;
      $2.each(this.tooltips, function(id2, tooltipData) {
        var event2 = $2.Event("blur");
        event2.target = event2.currentTarget = tooltipData.element[0], that.close(event2, !0);
      }), this.disabledTitles = this.disabledTitles.add(
        this.element.find(this.options.items).addBack().filter(function() {
          var element = $2(this);
          if (element.is("[title]"))
            return element.data("ui-tooltip-title", element.attr("title")).removeAttr("title");
        })
      );
    }, "_disable"),
    _enable: /* @__PURE__ */ __name(function() {
      this.disabledTitles.each(function() {
        var element = $2(this);
        element.data("ui-tooltip-title") && element.attr("title", element.data("ui-tooltip-title"));
      }), this.disabledTitles = $2([]);
    }, "_enable"),
    open: /* @__PURE__ */ __name(function(event2) {
      var that = this, target2 = $2(event2 ? event2.target : this.element).closest(this.options.items);
      !target2.length || target2.data("ui-tooltip-id") || (target2.attr("title") && target2.data("ui-tooltip-title", target2.attr("title")), target2.data("ui-tooltip-open", !0), event2 && event2.type === "mouseover" && target2.parents().each(function() {
        var parent = $2(this), blurEvent;
        parent.data("ui-tooltip-open") && (blurEvent = $2.Event("blur"), blurEvent.target = blurEvent.currentTarget = this, that.close(blurEvent, !0)), parent.attr("title") && (parent.uniqueId(), that.parents[this.id] = {
          element: this,
          title: parent.attr("title")
        }, parent.attr("title", ""));
      }), this._registerCloseHandlers(event2, target2), this._updateContent(target2, event2));
    }, "open"),
    _updateContent: /* @__PURE__ */ __name(function(target2, event2) {
      var content, contentOption = this.options.content, that = this, eventType = event2 ? event2.type : null;
      if (typeof contentOption == "string" || contentOption.nodeType || contentOption.jquery)
        return this._open(event2, target2, contentOption);
      content = contentOption.call(target2[0], function(response) {
        target2.data("ui-tooltip-open") && (event2 && (event2.type = eventType), that._open(event2, target2, response));
      }), content && this._open(event2, target2, content);
    }, "_updateContent"),
    _open: /* @__PURE__ */ __name(function(event2, target2, content) {
      var tooltipData, tooltip, delayedShow, a11yContent, positionOption = $2.extend({}, this.options.position);
      if (!content)
        return;
      if (tooltipData = this._find(target2), tooltipData) {
        tooltipData.tooltip.find(".ui-tooltip-content").html(content);
        return;
      }
      target2.is("[title]") && (event2 && event2.type === "mouseover" ? target2.attr("title", "") : target2.removeAttr("title")), tooltipData = this._tooltip(target2), tooltip = tooltipData.tooltip, this._addDescribedBy(target2, tooltip.attr("id")), tooltip.find(".ui-tooltip-content").html(content), this.liveRegion.children().hide(), a11yContent = $2("<div>").html(tooltip.find(".ui-tooltip-content").html()), a11yContent.removeAttr("name").find("[name]").removeAttr("name"), a11yContent.removeAttr("id").find("[id]").removeAttr("id"), a11yContent.appendTo(this.liveRegion);
      function position3(event3) {
        positionOption.of = event3, !tooltip.is(":hidden") && tooltip.position(positionOption);
      }
      __name(position3, "position"), this.options.track && event2 && /^mouse/.test(event2.type) ? (this._on(this.document, {
        mousemove: position3
      }), position3(event2)) : tooltip.position($2.extend({
        of: target2
      }, this.options.position)), tooltip.hide(), this._show(tooltip, this.options.show), this.options.track && this.options.show && this.options.show.delay && (delayedShow = this.delayedShow = setInterval(function() {
        tooltip.is(":visible") && (position3(positionOption.of), clearInterval(delayedShow));
      }, 13)), this._trigger("open", event2, { tooltip });
    }, "_open"),
    _registerCloseHandlers: /* @__PURE__ */ __name(function(event2, target2) {
      var events2 = {
        keyup: /* @__PURE__ */ __name(function(event3) {
          if (event3.keyCode === $2.ui.keyCode.ESCAPE) {
            var fakeEvent = $2.Event(event3);
            fakeEvent.currentTarget = target2[0], this.close(fakeEvent, !0);
          }
        }, "keyup")
      };
      target2[0] !== this.element[0] && (events2.remove = function() {
        var targetElement = this._find(target2);
        targetElement && this._removeTooltip(targetElement.tooltip);
      }), (!event2 || event2.type === "mouseover") && (events2.mouseleave = "close"), (!event2 || event2.type === "focusin") && (events2.focusout = "close"), this._on(!0, target2, events2);
    }, "_registerCloseHandlers"),
    close: /* @__PURE__ */ __name(function(event2) {
      var tooltip, that = this, target2 = $2(event2 ? event2.currentTarget : this.element), tooltipData = this._find(target2);
      if (!tooltipData) {
        target2.removeData("ui-tooltip-open");
        return;
      }
      tooltip = tooltipData.tooltip, !tooltipData.closing && (clearInterval(this.delayedShow), target2.data("ui-tooltip-title") && !target2.attr("title") && target2.attr("title", target2.data("ui-tooltip-title")), this._removeDescribedBy(target2), tooltipData.hiding = !0, tooltip.stop(!0), this._hide(tooltip, this.options.hide, function() {
        that._removeTooltip($2(this));
      }), target2.removeData("ui-tooltip-open"), this._off(target2, "mouseleave focusout keyup"), target2[0] !== this.element[0] && this._off(target2, "remove"), this._off(this.document, "mousemove"), event2 && event2.type === "mouseleave" && $2.each(this.parents, function(id2, parent) {
        $2(parent.element).attr("title", parent.title), delete that.parents[id2];
      }), tooltipData.closing = !0, this._trigger("close", event2, { tooltip }), tooltipData.hiding || (tooltipData.closing = !1));
    }, "close"),
    _tooltip: /* @__PURE__ */ __name(function(element) {
      var tooltip = $2("<div>").attr("role", "tooltip"), content = $2("<div>").appendTo(tooltip), id2 = tooltip.uniqueId().attr("id");
      return this._addClass(content, "ui-tooltip-content"), this._addClass(tooltip, "ui-tooltip", "ui-widget ui-widget-content"), tooltip.appendTo(this._appendTo(element)), this.tooltips[id2] = {
        element,
        tooltip
      };
    }, "_tooltip"),
    _find: /* @__PURE__ */ __name(function(target2) {
      var id2 = target2.data("ui-tooltip-id");
      return id2 ? this.tooltips[id2] : null;
    }, "_find"),
    _removeTooltip: /* @__PURE__ */ __name(function(tooltip) {
      clearInterval(this.delayedShow), tooltip.remove(), delete this.tooltips[tooltip.attr("id")];
    }, "_removeTooltip"),
    _appendTo: /* @__PURE__ */ __name(function(target2) {
      var element = target2.closest(".ui-front, dialog");
      return element.length || (element = this.document[0].body), element;
    }, "_appendTo"),
    _destroy: /* @__PURE__ */ __name(function() {
      var that = this;
      $2.each(this.tooltips, function(id2, tooltipData) {
        var event2 = $2.Event("blur"), element = tooltipData.element;
        event2.target = event2.currentTarget = element[0], that.close(event2, !0), $2("#" + id2).remove(), element.data("ui-tooltip-title") && (element.attr("title") || element.attr("title", element.data("ui-tooltip-title")), element.removeData("ui-tooltip-title"));
      }), this.liveRegion.remove();
    }, "_destroy")
  }), $2.uiBackCompat === !0 && $2.widget("ui.tooltip", $2.ui.tooltip, {
    options: {
      tooltipClass: null
    },
    _tooltip: /* @__PURE__ */ __name(function() {
      var tooltipData = this._superApply(arguments);
      return this.options.tooltipClass && tooltipData.tooltip.addClass(this.options.tooltipClass), tooltipData;
    }, "_tooltip")
  }), $2.ui.tooltip;
});
var jquery_validate = { exports: {} };
/*!
 * jQuery Validation Plugin v1.21.0
 *
 * https://jqueryvalidation.org/
 *
 * Copyright (c) 2024 Jörn Zaefferer
 * Released under the MIT license
 */
var hasRequiredJquery_validate;
function requireJquery_validate() {
  return hasRequiredJquery_validate || (hasRequiredJquery_validate = 1, function(module2) {
    (function(factory2) {
      module2.exports ? module2.exports = factory2(requireJquery()) : factory2(jQuery);
    })(function($2) {
      $2.extend($2.fn, {
        // https://jqueryvalidation.org/validate/
        validate: /* @__PURE__ */ __name(function(options2) {
          if (!this.length) {
            options2 && options2.debug && window.console && console.warn("Nothing selected, can't validate, returning nothing.");
            return;
          }
          var validator3 = $2.data(this[0], "validator");
          return validator3 || (this.attr("novalidate", "novalidate"), validator3 = new $2.validator(options2, this[0]), $2.data(this[0], "validator", validator3), validator3.settings.onsubmit && (this.on("click.validate", ":submit", function(event2) {
            validator3.submitButton = event2.currentTarget, $2(this).hasClass("cancel") && (validator3.cancelSubmit = !0), $2(this).attr("formnovalidate") !== void 0 && (validator3.cancelSubmit = !0);
          }), this.on("submit.validate", function(event2) {
            validator3.settings.debug && event2.preventDefault();
            function handle() {
              var hidden2, result;
              return validator3.submitButton && (validator3.settings.submitHandler || validator3.formSubmitted) && (hidden2 = $2("<input type='hidden'/>").attr("name", validator3.submitButton.name).val($2(validator3.submitButton).val()).appendTo(validator3.currentForm)), validator3.settings.submitHandler && !validator3.settings.debug ? (result = validator3.settings.submitHandler.call(validator3, validator3.currentForm, event2), hidden2 && hidden2.remove(), result !== void 0 ? result : !1) : !0;
            }
            return __name(handle, "handle"), validator3.cancelSubmit ? (validator3.cancelSubmit = !1, handle()) : validator3.form() ? validator3.pendingRequest ? (validator3.formSubmitted = !0, !1) : handle() : (validator3.focusInvalid(), !1);
          })), validator3);
        }, "validate"),
        // https://jqueryvalidation.org/valid/
        valid: /* @__PURE__ */ __name(function() {
          var valid, validator3, errorList;
          return $2(this[0]).is("form") ? valid = this.validate().form() : (errorList = [], valid = !0, validator3 = $2(this[0].form).validate(), this.each(function() {
            valid = validator3.element(this) && valid, valid || (errorList = errorList.concat(validator3.errorList));
          }), validator3.errorList = errorList), valid;
        }, "valid"),
        // https://jqueryvalidation.org/rules/
        rules: /* @__PURE__ */ __name(function(command, argument) {
          var element = this[0], isContentEditable = typeof this.attr("contenteditable") < "u" && this.attr("contenteditable") !== "false", settings, staticRules, existingRules, data49, param, filtered;
          if (element != null && (!element.form && isContentEditable && (element.form = this.closest("form")[0], element.name = this.attr("name")), element.form != null)) {
            if (command)
              switch (settings = $2.data(element.form, "validator").settings, staticRules = settings.rules, existingRules = $2.validator.staticRules(element), command) {
                case "add":
                  $2.extend(existingRules, $2.validator.normalizeRule(argument)), delete existingRules.messages, staticRules[element.name] = existingRules, argument.messages && (settings.messages[element.name] = $2.extend(settings.messages[element.name], argument.messages));
                  break;
                case "remove":
                  return argument ? (filtered = {}, $2.each(argument.split(/\s/), function(index3, method) {
                    filtered[method] = existingRules[method], delete existingRules[method];
                  }), filtered) : (delete staticRules[element.name], existingRules);
              }
            return data49 = $2.validator.normalizeRules(
              $2.extend(
                {},
                $2.validator.classRules(element),
                $2.validator.attributeRules(element),
                $2.validator.dataRules(element),
                $2.validator.staticRules(element)
              ),
              element
            ), data49.required && (param = data49.required, delete data49.required, data49 = $2.extend({ required: param }, data49)), data49.remote && (param = data49.remote, delete data49.remote, data49 = $2.extend(data49, { remote: param })), data49;
          }
        }, "rules")
      });
      var trim3 = /* @__PURE__ */ __name(function(str2) {
        return str2.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, "");
      }, "trim");
      $2.extend($2.expr.pseudos || $2.expr[":"], {
        // '|| $.expr[ ":" ]' here enables backwards compatibility to jQuery 1.7. Can be removed when dropping jQ 1.7.x support
        // https://jqueryvalidation.org/blank-selector/
        blank: /* @__PURE__ */ __name(function(a2) {
          return !trim3("" + $2(a2).val());
        }, "blank"),
        // https://jqueryvalidation.org/filled-selector/
        filled: /* @__PURE__ */ __name(function(a2) {
          var val = $2(a2).val();
          return val !== null && !!trim3("" + val);
        }, "filled"),
        // https://jqueryvalidation.org/unchecked-selector/
        unchecked: /* @__PURE__ */ __name(function(a2) {
          return !$2(a2).prop("checked");
        }, "unchecked")
      }), $2.validator = function(options2, form2) {
        this.settings = $2.extend(!0, {}, $2.validator.defaults, options2), this.currentForm = form2, this.init();
      }, $2.validator.format = function(source2, params) {
        return arguments.length === 1 ? function() {
          var args = $2.makeArray(arguments);
          return args.unshift(source2), $2.validator.format.apply(this, args);
        } : (params === void 0 || (arguments.length > 2 && params.constructor !== Array && (params = $2.makeArray(arguments).slice(1)), params.constructor !== Array && (params = [params]), $2.each(params, function(i, n2) {
          source2 = source2.replace(new RegExp("\\{" + i + "\\}", "g"), function() {
            return n2;
          });
        })), source2);
      }, $2.extend($2.validator, {
        defaults: {
          messages: {},
          groups: {},
          rules: {},
          errorClass: "error",
          pendingClass: "pending",
          validClass: "valid",
          errorElement: "label",
          focusCleanup: !1,
          focusInvalid: !0,
          errorContainer: $2([]),
          errorLabelContainer: $2([]),
          onsubmit: !0,
          ignore: ":hidden",
          ignoreTitle: !1,
          customElements: [],
          onfocusin: /* @__PURE__ */ __name(function(element) {
            this.lastActive = element, this.settings.focusCleanup && (this.settings.unhighlight && this.settings.unhighlight.call(this, element, this.settings.errorClass, this.settings.validClass), this.hideThese(this.errorsFor(element)));
          }, "onfocusin"),
          onfocusout: /* @__PURE__ */ __name(function(element) {
            !this.checkable(element) && (element.name in this.submitted || !this.optional(element)) && this.element(element);
          }, "onfocusout"),
          onkeyup: /* @__PURE__ */ __name(function(element, event2) {
            var excludedKeys = [
              16,
              17,
              18,
              20,
              35,
              36,
              37,
              38,
              39,
              40,
              45,
              144,
              225
            ];
            event2.which === 9 && this.elementValue(element) === "" || $2.inArray(event2.keyCode, excludedKeys) !== -1 || (element.name in this.submitted || element.name in this.invalid) && this.element(element);
          }, "onkeyup"),
          onclick: /* @__PURE__ */ __name(function(element) {
            element.name in this.submitted ? this.element(element) : element.parentNode.name in this.submitted && this.element(element.parentNode);
          }, "onclick"),
          highlight: /* @__PURE__ */ __name(function(element, errorClass, validClass) {
            element.type === "radio" ? this.findByName(element.name).addClass(errorClass).removeClass(validClass) : $2(element).addClass(errorClass).removeClass(validClass);
          }, "highlight"),
          unhighlight: /* @__PURE__ */ __name(function(element, errorClass, validClass) {
            element.type === "radio" ? this.findByName(element.name).removeClass(errorClass).addClass(validClass) : $2(element).removeClass(errorClass).addClass(validClass);
          }, "unhighlight")
        },
        // https://jqueryvalidation.org/jQuery.validator.setDefaults/
        setDefaults: /* @__PURE__ */ __name(function(settings) {
          $2.extend($2.validator.defaults, settings);
        }, "setDefaults"),
        messages: {
          required: "This field is required.",
          remote: "Please fix this field.",
          email: "Please enter a valid email address.",
          url: "Please enter a valid URL.",
          date: "Please enter a valid date.",
          dateISO: "Please enter a valid date (ISO).",
          number: "Please enter a valid number.",
          digits: "Please enter only digits.",
          equalTo: "Please enter the same value again.",
          maxlength: $2.validator.format("Please enter no more than {0} characters."),
          minlength: $2.validator.format("Please enter at least {0} characters."),
          rangelength: $2.validator.format("Please enter a value between {0} and {1} characters long."),
          range: $2.validator.format("Please enter a value between {0} and {1}."),
          max: $2.validator.format("Please enter a value less than or equal to {0}."),
          min: $2.validator.format("Please enter a value greater than or equal to {0}."),
          step: $2.validator.format("Please enter a multiple of {0}.")
        },
        autoCreateRanges: !1,
        prototype: {
          init: /* @__PURE__ */ __name(function() {
            this.labelContainer = $2(this.settings.errorLabelContainer), this.errorContext = this.labelContainer.length && this.labelContainer || $2(this.currentForm), this.containers = $2(this.settings.errorContainer).add(this.settings.errorLabelContainer), this.submitted = {}, this.valueCache = {}, this.pendingRequest = 0, this.pending = {}, this.invalid = {}, this.reset();
            var currentForm = this.currentForm, groups2 = this.groups = {}, rules2;
            $2.each(this.settings.groups, function(key, value3) {
              typeof value3 == "string" && (value3 = value3.split(/\s/)), $2.each(value3, function(index3, name2) {
                groups2[name2] = key;
              });
            }), rules2 = this.settings.rules, $2.each(rules2, function(key, value3) {
              rules2[key] = $2.validator.normalizeRule(value3);
            });
            function delegate(event2) {
              var isContentEditable = typeof $2(this).attr("contenteditable") < "u" && $2(this).attr("contenteditable") !== "false";
              if (!this.form && isContentEditable && (this.form = $2(this).closest("form")[0], this.name = $2(this).attr("name")), currentForm === this.form) {
                var validator3 = $2.data(this.form, "validator"), eventType = "on" + event2.type.replace(/^validate/, ""), settings = validator3.settings;
                settings[eventType] && !$2(this).is(settings.ignore) && settings[eventType].call(validator3, this, event2);
              }
            }
            __name(delegate, "delegate");
            var focusListeners = [
              ":text",
              "[type='password']",
              "[type='file']",
              "select",
              "textarea",
              "[type='number']",
              "[type='search']",
              "[type='tel']",
              "[type='url']",
              "[type='email']",
              "[type='datetime']",
              "[type='date']",
              "[type='month']",
              "[type='week']",
              "[type='time']",
              "[type='datetime-local']",
              "[type='range']",
              "[type='color']",
              "[type='radio']",
              "[type='checkbox']",
              "[contenteditable]",
              "[type='button']"
            ], clickListeners = ["select", "option", "[type='radio']", "[type='checkbox']"];
            $2(this.currentForm).on("focusin.validate focusout.validate keyup.validate", focusListeners.concat(this.settings.customElements).join(", "), delegate).on("click.validate", clickListeners.concat(this.settings.customElements).join(", "), delegate), this.settings.invalidHandler && $2(this.currentForm).on("invalid-form.validate", this.settings.invalidHandler);
          }, "init"),
          // https://jqueryvalidation.org/Validator.form/
          form: /* @__PURE__ */ __name(function() {
            return this.checkForm(), $2.extend(this.submitted, this.errorMap), this.invalid = $2.extend({}, this.errorMap), this.valid() || $2(this.currentForm).triggerHandler("invalid-form", [this]), this.showErrors(), this.valid();
          }, "form"),
          checkForm: /* @__PURE__ */ __name(function() {
            this.prepareForm();
            for (var i = 0, elements = this.currentElements = this.elements(); elements[i]; i++)
              this.check(elements[i]);
            return this.valid();
          }, "checkForm"),
          // https://jqueryvalidation.org/Validator.element/
          element: /* @__PURE__ */ __name(function(element) {
            var cleanElement = this.clean(element), checkElement = this.validationTargetFor(cleanElement), v = this, result = !0, rs, group;
            return checkElement === void 0 ? delete this.invalid[cleanElement.name] : (this.prepareElement(checkElement), this.currentElements = $2(checkElement), group = this.groups[checkElement.name], group && $2.each(this.groups, function(name2, testgroup) {
              testgroup === group && name2 !== checkElement.name && (cleanElement = v.validationTargetFor(v.clean(v.findByName(name2))), cleanElement && cleanElement.name in v.invalid && (v.currentElements.push(cleanElement), result = v.check(cleanElement) && result));
            }), rs = this.check(checkElement) !== !1, result = result && rs, rs ? this.invalid[checkElement.name] = !1 : this.invalid[checkElement.name] = !0, this.numberOfInvalids() || (this.toHide = this.toHide.add(this.containers)), this.showErrors(), $2(element).attr("aria-invalid", !rs)), result;
          }, "element"),
          // https://jqueryvalidation.org/Validator.showErrors/
          showErrors: /* @__PURE__ */ __name(function(errors) {
            if (errors) {
              var validator3 = this;
              $2.extend(this.errorMap, errors), this.errorList = $2.map(this.errorMap, function(message, name2) {
                return {
                  message,
                  element: validator3.findByName(name2)[0]
                };
              }), this.successList = $2.grep(this.successList, function(element) {
                return !(element.name in errors);
              });
            }
            this.settings.showErrors ? this.settings.showErrors.call(this, this.errorMap, this.errorList) : this.defaultShowErrors();
          }, "showErrors"),
          // https://jqueryvalidation.org/Validator.resetForm/
          resetForm: /* @__PURE__ */ __name(function() {
            $2.fn.resetForm && $2(this.currentForm).resetForm(), this.invalid = {}, this.submitted = {}, this.prepareForm(), this.hideErrors();
            var elements = this.elements().removeData("previousValue").removeAttr("aria-invalid");
            this.resetElements(elements);
          }, "resetForm"),
          resetElements: /* @__PURE__ */ __name(function(elements) {
            var i;
            if (this.settings.unhighlight)
              for (i = 0; elements[i]; i++)
                this.settings.unhighlight.call(
                  this,
                  elements[i],
                  this.settings.errorClass,
                  ""
                ), this.findByName(elements[i].name).removeClass(this.settings.validClass);
            else
              elements.removeClass(this.settings.errorClass).removeClass(this.settings.validClass);
          }, "resetElements"),
          numberOfInvalids: /* @__PURE__ */ __name(function() {
            return this.objectLength(this.invalid);
          }, "numberOfInvalids"),
          objectLength: /* @__PURE__ */ __name(function(obj2) {
            var count2 = 0, i;
            for (i in obj2)
              obj2[i] !== void 0 && obj2[i] !== null && obj2[i] !== !1 && count2++;
            return count2;
          }, "objectLength"),
          hideErrors: /* @__PURE__ */ __name(function() {
            this.hideThese(this.toHide);
          }, "hideErrors"),
          hideThese: /* @__PURE__ */ __name(function(errors) {
            errors.not(this.containers).text(""), this.addWrapper(errors).hide();
          }, "hideThese"),
          valid: /* @__PURE__ */ __name(function() {
            return this.size() === 0;
          }, "valid"),
          size: /* @__PURE__ */ __name(function() {
            return this.errorList.length;
          }, "size"),
          focusInvalid: /* @__PURE__ */ __name(function() {
            if (this.settings.focusInvalid)
              try {
                $2(this.findLastActive() || this.errorList.length && this.errorList[0].element || []).filter(":visible").trigger("focus").trigger("focusin");
              } catch {
              }
          }, "focusInvalid"),
          findLastActive: /* @__PURE__ */ __name(function() {
            var lastActive = this.lastActive;
            return lastActive && $2.grep(this.errorList, function(n2) {
              return n2.element.name === lastActive.name;
            }).length === 1 && lastActive;
          }, "findLastActive"),
          elements: /* @__PURE__ */ __name(function() {
            var validator3 = this, rulesCache = {}, selectors = ["input", "select", "textarea", "[contenteditable]"];
            return $2(this.currentForm).find(selectors.concat(this.settings.customElements).join(", ")).not(":submit, :reset, :image, :disabled").not(this.settings.ignore).filter(function() {
              var name2 = this.name || $2(this).attr("name"), isContentEditable = typeof $2(this).attr("contenteditable") < "u" && $2(this).attr("contenteditable") !== "false";
              return !name2 && validator3.settings.debug && window.console && console.error("%o has no name assigned", this), isContentEditable && (this.form = $2(this).closest("form")[0], this.name = name2), this.form !== validator3.currentForm || name2 in rulesCache || !validator3.objectLength($2(this).rules()) ? !1 : (rulesCache[name2] = !0, !0);
            });
          }, "elements"),
          clean: /* @__PURE__ */ __name(function(selector) {
            return $2(selector)[0];
          }, "clean"),
          errors: /* @__PURE__ */ __name(function() {
            var errorClass = this.settings.errorClass.split(" ").join(".");
            return $2(this.settings.errorElement + "." + errorClass, this.errorContext);
          }, "errors"),
          resetInternals: /* @__PURE__ */ __name(function() {
            this.successList = [], this.errorList = [], this.errorMap = {}, this.toShow = $2([]), this.toHide = $2([]);
          }, "resetInternals"),
          reset: /* @__PURE__ */ __name(function() {
            this.resetInternals(), this.currentElements = $2([]);
          }, "reset"),
          prepareForm: /* @__PURE__ */ __name(function() {
            this.reset(), this.toHide = this.errors().add(this.containers);
          }, "prepareForm"),
          prepareElement: /* @__PURE__ */ __name(function(element) {
            this.reset(), this.toHide = this.errorsFor(element);
          }, "prepareElement"),
          elementValue: /* @__PURE__ */ __name(function(element) {
            var $element = $2(element), type2 = element.type, isContentEditable = typeof $element.attr("contenteditable") < "u" && $element.attr("contenteditable") !== "false", val, idx;
            return type2 === "radio" || type2 === "checkbox" ? this.findByName(element.name).filter(":checked").val() : type2 === "number" && typeof element.validity < "u" ? element.validity.badInput ? "NaN" : $element.val() : (isContentEditable ? val = $element.text() : val = $element.val(), type2 === "file" ? val.substr(0, 12) === "C:\\fakepath\\" ? val.substr(12) : (idx = val.lastIndexOf("/"), idx >= 0 || (idx = val.lastIndexOf("\\"), idx >= 0) ? val.substr(idx + 1) : val) : typeof val == "string" ? val.replace(/\r/g, "") : val);
          }, "elementValue"),
          check: /* @__PURE__ */ __name(function(element) {
            element = this.validationTargetFor(this.clean(element));
            var rules2 = $2(element).rules(), rulesCount = $2.map(rules2, function(n2, i) {
              return i;
            }).length, dependencyMismatch = !1, val = this.elementValue(element), result, method, rule, normalizer;
            this.abortRequest(element), typeof rules2.normalizer == "function" ? normalizer = rules2.normalizer : typeof this.settings.normalizer == "function" && (normalizer = this.settings.normalizer), normalizer && (val = normalizer.call(element, val), delete rules2.normalizer);
            for (method in rules2) {
              rule = { method, parameters: rules2[method] };
              try {
                if (result = $2.validator.methods[method].call(this, val, element, rule.parameters), result === "dependency-mismatch" && rulesCount === 1) {
                  dependencyMismatch = !0;
                  continue;
                }
                if (dependencyMismatch = !1, result === "pending") {
                  this.toHide = this.toHide.not(this.errorsFor(element));
                  return;
                }
                if (!result)
                  return this.formatAndAdd(element, rule), !1;
              } catch (e2) {
                throw this.settings.debug && window.console && console.log("Exception occurred when checking element " + element.id + ", check the '" + rule.method + "' method.", e2), e2 instanceof TypeError && (e2.message += ".  Exception occurred when checking element " + element.id + ", check the '" + rule.method + "' method."), e2;
              }
            }
            if (!dependencyMismatch)
              return this.objectLength(rules2) && this.successList.push(element), !0;
          }, "check"),
          // Return the custom message for the given element and validation method
          // specified in the element's HTML5 data attribute
          // return the generic message if present and no method specific message is present
          customDataMessage: /* @__PURE__ */ __name(function(element, method) {
            return $2(element).data("msg" + method.charAt(0).toUpperCase() + method.substring(1).toLowerCase()) || $2(element).data("msg");
          }, "customDataMessage"),
          // Return the custom message for the given element name and validation method
          customMessage: /* @__PURE__ */ __name(function(name2, method) {
            var m = this.settings.messages[name2];
            return m && (m.constructor === String ? m : m[method]);
          }, "customMessage"),
          // Return the first defined argument, allowing empty strings
          findDefined: /* @__PURE__ */ __name(function() {
            for (var i = 0; i < arguments.length; i++)
              if (arguments[i] !== void 0)
                return arguments[i];
          }, "findDefined"),
          // The second parameter 'rule' used to be a string, and extended to an object literal
          // of the following form:
          // rule = {
          //     method: "method name",
          //     parameters: "the given method parameters"
          // }
          //
          // The old behavior still supported, kept to maintain backward compatibility with
          // old code, and will be removed in the next major release.
          defaultMessage: /* @__PURE__ */ __name(function(element, rule) {
            typeof rule == "string" && (rule = { method: rule });
            var message = this.findDefined(
              this.customMessage(element.name, rule.method),
              this.customDataMessage(element, rule.method),
              // 'title' is never undefined, so handle empty string as undefined
              !this.settings.ignoreTitle && element.title || void 0,
              $2.validator.messages[rule.method],
              "<strong>Warning: No message defined for " + element.name + "</strong>"
            ), theregex = /\$?\{(\d+)\}/g;
            return typeof message == "function" ? message = message.call(this, rule.parameters, element) : theregex.test(message) && (message = $2.validator.format(message.replace(theregex, "{$1}"), rule.parameters)), message;
          }, "defaultMessage"),
          formatAndAdd: /* @__PURE__ */ __name(function(element, rule) {
            var message = this.defaultMessage(element, rule);
            this.errorList.push({
              message,
              element,
              method: rule.method
            }), this.errorMap[element.name] = message, this.submitted[element.name] = message;
          }, "formatAndAdd"),
          addWrapper: /* @__PURE__ */ __name(function(toToggle) {
            return this.settings.wrapper && (toToggle = toToggle.add(toToggle.parent(this.settings.wrapper))), toToggle;
          }, "addWrapper"),
          defaultShowErrors: /* @__PURE__ */ __name(function() {
            var i, elements, error2;
            for (i = 0; this.errorList[i]; i++)
              error2 = this.errorList[i], this.settings.highlight && this.settings.highlight.call(this, error2.element, this.settings.errorClass, this.settings.validClass), this.showLabel(error2.element, error2.message);
            if (this.errorList.length && (this.toShow = this.toShow.add(this.containers)), this.settings.success)
              for (i = 0; this.successList[i]; i++)
                this.showLabel(this.successList[i]);
            if (this.settings.unhighlight)
              for (i = 0, elements = this.validElements(); elements[i]; i++)
                this.settings.unhighlight.call(this, elements[i], this.settings.errorClass, this.settings.validClass);
            this.toHide = this.toHide.not(this.toShow), this.hideErrors(), this.addWrapper(this.toShow).show();
          }, "defaultShowErrors"),
          validElements: /* @__PURE__ */ __name(function() {
            return this.currentElements.not(this.invalidElements());
          }, "validElements"),
          invalidElements: /* @__PURE__ */ __name(function() {
            return $2(this.errorList).map(function() {
              return this.element;
            });
          }, "invalidElements"),
          showLabel: /* @__PURE__ */ __name(function(element, message) {
            var place, group, errorID, v, error2 = this.errorsFor(element), elementID = this.idOrName(element), describedBy = $2(element).attr("aria-describedby");
            error2.length ? (error2.removeClass(this.settings.validClass).addClass(this.settings.errorClass), this.settings && this.settings.escapeHtml ? error2.text(message || "") : error2.html(message || "")) : (error2 = $2("<" + this.settings.errorElement + ">").attr("id", elementID + "-error").addClass(this.settings.errorClass), this.settings && this.settings.escapeHtml ? error2.text(message || "") : error2.html(message || ""), place = error2, this.settings.wrapper && (place = error2.hide().show().wrap("<" + this.settings.wrapper + "/>").parent()), this.labelContainer.length ? this.labelContainer.append(place) : this.settings.errorPlacement ? this.settings.errorPlacement.call(this, place, $2(element)) : place.insertAfter(element), error2.is("label") ? error2.attr("for", elementID) : error2.parents("label[for='" + this.escapeCssMeta(elementID) + "']").length === 0 && (errorID = error2.attr("id"), describedBy ? describedBy.match(new RegExp("\\b" + this.escapeCssMeta(errorID) + "\\b")) || (describedBy += " " + errorID) : describedBy = errorID, $2(element).attr("aria-describedby", describedBy), group = this.groups[element.name], group && (v = this, $2.each(v.groups, function(name2, testgroup) {
              testgroup === group && $2("[name='" + v.escapeCssMeta(name2) + "']", v.currentForm).attr("aria-describedby", error2.attr("id"));
            })))), !message && this.settings.success && (error2.text(""), typeof this.settings.success == "string" ? error2.addClass(this.settings.success) : this.settings.success(error2, element)), this.toShow = this.toShow.add(error2);
          }, "showLabel"),
          errorsFor: /* @__PURE__ */ __name(function(element) {
            var name2 = this.escapeCssMeta(this.idOrName(element)), describer = $2(element).attr("aria-describedby"), selector = "label[for='" + name2 + "'], label[for='" + name2 + "'] *";
            return describer && (selector = selector + ", #" + this.escapeCssMeta(describer).replace(/\s+/g, ", #")), this.errors().filter(selector);
          }, "errorsFor"),
          // See https://api.jquery.com/category/selectors/, for CSS
          // meta-characters that should be escaped in order to be used with JQuery
          // as a literal part of a name/id or any selector.
          escapeCssMeta: /* @__PURE__ */ __name(function(string) {
            return string === void 0 ? "" : string.replace(/([\\!"#$%&'()*+,./:;<=>?@\[\]^`{|}~])/g, "\\$1");
          }, "escapeCssMeta"),
          idOrName: /* @__PURE__ */ __name(function(element) {
            return this.groups[element.name] || (this.checkable(element) ? element.name : element.id || element.name);
          }, "idOrName"),
          validationTargetFor: /* @__PURE__ */ __name(function(element) {
            return this.checkable(element) && (element = this.findByName(element.name)), $2(element).not(this.settings.ignore)[0];
          }, "validationTargetFor"),
          checkable: /* @__PURE__ */ __name(function(element) {
            return /radio|checkbox/i.test(element.type);
          }, "checkable"),
          findByName: /* @__PURE__ */ __name(function(name2) {
            return $2(this.currentForm).find("[name='" + this.escapeCssMeta(name2) + "']");
          }, "findByName"),
          getLength: /* @__PURE__ */ __name(function(value3, element) {
            switch (element.nodeName.toLowerCase()) {
              case "select":
                return $2("option:selected", element).length;
              case "input":
                if (this.checkable(element))
                  return this.findByName(element.name).filter(":checked").length;
            }
            return value3.length;
          }, "getLength"),
          depend: /* @__PURE__ */ __name(function(param, element) {
            return this.dependTypes[typeof param] ? this.dependTypes[typeof param](param, element) : !0;
          }, "depend"),
          dependTypes: {
            boolean: /* @__PURE__ */ __name(function(param) {
              return param;
            }, "boolean"),
            string: /* @__PURE__ */ __name(function(param, element) {
              return !!$2(param, element.form).length;
            }, "string"),
            function: /* @__PURE__ */ __name(function(param, element) {
              return param(element);
            }, "function")
          },
          optional: /* @__PURE__ */ __name(function(element) {
            var val = this.elementValue(element);
            return !$2.validator.methods.required.call(this, val, element) && "dependency-mismatch";
          }, "optional"),
          elementAjaxPort: /* @__PURE__ */ __name(function(element) {
            return "validate" + element.name;
          }, "elementAjaxPort"),
          startRequest: /* @__PURE__ */ __name(function(element) {
            this.pending[element.name] || (this.pendingRequest++, $2(element).addClass(this.settings.pendingClass), this.pending[element.name] = !0);
          }, "startRequest"),
          stopRequest: /* @__PURE__ */ __name(function(element, valid) {
            this.pendingRequest--, this.pendingRequest < 0 && (this.pendingRequest = 0), delete this.pending[element.name], $2(element).removeClass(this.settings.pendingClass), valid && this.pendingRequest === 0 && this.formSubmitted && this.form() && this.pendingRequest === 0 ? ($2(this.currentForm).trigger("submit"), this.submitButton && $2("input:hidden[name='" + this.submitButton.name + "']", this.currentForm).remove(), this.formSubmitted = !1) : !valid && this.pendingRequest === 0 && this.formSubmitted && ($2(this.currentForm).triggerHandler("invalid-form", [this]), this.formSubmitted = !1);
          }, "stopRequest"),
          abortRequest: /* @__PURE__ */ __name(function(element) {
            var port;
            this.pending[element.name] && (port = this.elementAjaxPort(element), $2.ajaxAbort(port), this.pendingRequest--, this.pendingRequest < 0 && (this.pendingRequest = 0), delete this.pending[element.name], $2(element).removeClass(this.settings.pendingClass));
          }, "abortRequest"),
          previousValue: /* @__PURE__ */ __name(function(element, method) {
            return method = typeof method == "string" && method || "remote", $2.data(element, "previousValue") || $2.data(element, "previousValue", {
              old: null,
              valid: !0,
              message: this.defaultMessage(element, { method })
            });
          }, "previousValue"),
          // Cleans up all forms and elements, removes validator-specific events
          destroy: /* @__PURE__ */ __name(function() {
            this.resetForm(), $2(this.currentForm).off(".validate").removeData("validator").find(".validate-equalTo-blur").off(".validate-equalTo").removeClass("validate-equalTo-blur").find(".validate-lessThan-blur").off(".validate-lessThan").removeClass("validate-lessThan-blur").find(".validate-lessThanEqual-blur").off(".validate-lessThanEqual").removeClass("validate-lessThanEqual-blur").find(".validate-greaterThanEqual-blur").off(".validate-greaterThanEqual").removeClass("validate-greaterThanEqual-blur").find(".validate-greaterThan-blur").off(".validate-greaterThan").removeClass("validate-greaterThan-blur");
          }, "destroy")
        },
        classRuleSettings: {
          required: { required: !0 },
          email: { email: !0 },
          url: { url: !0 },
          date: { date: !0 },
          dateISO: { dateISO: !0 },
          number: { number: !0 },
          digits: { digits: !0 },
          creditcard: { creditcard: !0 }
        },
        addClassRules: /* @__PURE__ */ __name(function(className, rules2) {
          className.constructor === String ? this.classRuleSettings[className] = rules2 : $2.extend(this.classRuleSettings, className);
        }, "addClassRules"),
        classRules: /* @__PURE__ */ __name(function(element) {
          var rules2 = {}, classes2 = $2(element).attr("class");
          return classes2 && $2.each(classes2.split(" "), function() {
            this in $2.validator.classRuleSettings && $2.extend(rules2, $2.validator.classRuleSettings[this]);
          }), rules2;
        }, "classRules"),
        normalizeAttributeRule: /* @__PURE__ */ __name(function(rules2, type2, method, value3) {
          /min|max|step/.test(method) && (type2 === null || /number|range|text/.test(type2)) && (value3 = Number(value3), isNaN(value3) && (value3 = void 0)), value3 || value3 === 0 ? rules2[method] = value3 : type2 === method && type2 !== "range" && (rules2[type2 === "date" ? "dateISO" : method] = !0);
        }, "normalizeAttributeRule"),
        attributeRules: /* @__PURE__ */ __name(function(element) {
          var rules2 = {}, $element = $2(element), type2 = element.getAttribute("type"), method, value3;
          for (method in $2.validator.methods)
            method === "required" ? (value3 = element.getAttribute(method), value3 === "" && (value3 = !0), value3 = !!value3) : value3 = $element.attr(method), this.normalizeAttributeRule(rules2, type2, method, value3);
          return rules2.maxlength && /-1|2147483647|524288/.test(rules2.maxlength) && delete rules2.maxlength, rules2;
        }, "attributeRules"),
        dataRules: /* @__PURE__ */ __name(function(element) {
          var rules2 = {}, $element = $2(element), type2 = element.getAttribute("type"), method, value3;
          for (method in $2.validator.methods)
            value3 = $element.data("rule" + method.charAt(0).toUpperCase() + method.substring(1).toLowerCase()), value3 === "" && (value3 = !0), this.normalizeAttributeRule(rules2, type2, method, value3);
          return rules2;
        }, "dataRules"),
        staticRules: /* @__PURE__ */ __name(function(element) {
          var rules2 = {}, validator3 = $2.data(element.form, "validator");
          return validator3.settings.rules && (rules2 = $2.validator.normalizeRule(validator3.settings.rules[element.name]) || {}), rules2;
        }, "staticRules"),
        normalizeRules: /* @__PURE__ */ __name(function(rules2, element) {
          return $2.each(rules2, function(prop2, val) {
            if (val === !1) {
              delete rules2[prop2];
              return;
            }
            if (val.param || val.depends) {
              var keepRule = !0;
              switch (typeof val.depends) {
                case "string":
                  keepRule = !!$2(val.depends, element.form).length;
                  break;
                case "function":
                  keepRule = val.depends.call(element, element);
                  break;
              }
              keepRule ? rules2[prop2] = val.param !== void 0 ? val.param : !0 : ($2.data(element.form, "validator").resetElements($2(element)), delete rules2[prop2]);
            }
          }), $2.each(rules2, function(rule, parameter) {
            rules2[rule] = typeof parameter == "function" && rule !== "normalizer" ? parameter(element) : parameter;
          }), $2.each(["minlength", "maxlength"], function() {
            rules2[this] && (rules2[this] = Number(rules2[this]));
          }), $2.each(["rangelength", "range"], function() {
            var parts;
            rules2[this] && (Array.isArray(rules2[this]) ? rules2[this] = [Number(rules2[this][0]), Number(rules2[this][1])] : typeof rules2[this] == "string" && (parts = rules2[this].replace(/[\[\]]/g, "").split(/[\s,]+/), rules2[this] = [Number(parts[0]), Number(parts[1])]));
          }), $2.validator.autoCreateRanges && (rules2.min != null && rules2.max != null && (rules2.range = [rules2.min, rules2.max], delete rules2.min, delete rules2.max), rules2.minlength != null && rules2.maxlength != null && (rules2.rangelength = [rules2.minlength, rules2.maxlength], delete rules2.minlength, delete rules2.maxlength)), rules2;
        }, "normalizeRules"),
        // Converts a simple string to a {string: true} rule, e.g., "required" to {required:true}
        normalizeRule: /* @__PURE__ */ __name(function(data49) {
          if (typeof data49 == "string") {
            var transformed = {};
            $2.each(data49.split(/\s/), function() {
              transformed[this] = !0;
            }), data49 = transformed;
          }
          return data49;
        }, "normalizeRule"),
        // https://jqueryvalidation.org/jQuery.validator.addMethod/
        addMethod: /* @__PURE__ */ __name(function(name2, method, message) {
          $2.validator.methods[name2] = method, $2.validator.messages[name2] = message !== void 0 ? message : $2.validator.messages[name2], method.length < 3 && $2.validator.addClassRules(name2, $2.validator.normalizeRule(name2));
        }, "addMethod"),
        // https://jqueryvalidation.org/jQuery.validator.methods/
        methods: {
          // https://jqueryvalidation.org/required-method/
          required: /* @__PURE__ */ __name(function(value3, element, param) {
            if (!this.depend(param, element))
              return "dependency-mismatch";
            if (element.nodeName.toLowerCase() === "select") {
              var val = $2(element).val();
              return val && val.length > 0;
            }
            return this.checkable(element) ? this.getLength(value3, element) > 0 : value3 != null && value3.length > 0;
          }, "required"),
          // https://jqueryvalidation.org/email-method/
          email: /* @__PURE__ */ __name(function(value3, element) {
            return this.optional(element) || /^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/.test(value3);
          }, "email"),
          // https://jqueryvalidation.org/url-method/
          url: /* @__PURE__ */ __name(function(value3, element) {
            return this.optional(element) || /^(?:(?:(?:https?|ftp):)?\/\/)(?:(?:[^\]\[?\/<~#`!@$^&*()+=}|:";',>{ ]|%[0-9A-Fa-f]{2})+(?::(?:[^\]\[?\/<~#`!@$^&*()+=}|:";',>{ ]|%[0-9A-Fa-f]{2})*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z0-9\u00a1-\uffff][a-z0-9\u00a1-\uffff_-]{0,62})?[a-z0-9\u00a1-\uffff]\.)+(?:[a-z\u00a1-\uffff]{2,}\.?))(?::\d{2,5})?(?:[/?#]\S*)?$/i.test(value3);
          }, "url"),
          // https://jqueryvalidation.org/date-method/
          date: /* @__PURE__ */ function() {
            var called = !1;
            return function(value3, element) {
              return called || (called = !0, this.settings.debug && window.console && console.warn(
                "The `date` method is deprecated and will be removed in version '2.0.0'.\nPlease don't use it, since it relies on the Date constructor, which\nbehaves very differently across browsers and locales. Use `dateISO`\ninstead or one of the locale specific methods in `localizations/`\nand `additional-methods.js`."
              )), this.optional(element) || !/Invalid|NaN/.test(new Date(value3).toString());
            };
          }(),
          // https://jqueryvalidation.org/dateISO-method/
          dateISO: /* @__PURE__ */ __name(function(value3, element) {
            return this.optional(element) || /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$/.test(value3);
          }, "dateISO"),
          // https://jqueryvalidation.org/number-method/
          number: /* @__PURE__ */ __name(function(value3, element) {
            return this.optional(element) || /^(?:-?\d+|-?\d{1,3}(?:,\d{3})+)?(?:-?\.\d+)?$/.test(value3);
          }, "number"),
          // https://jqueryvalidation.org/digits-method/
          digits: /* @__PURE__ */ __name(function(value3, element) {
            return this.optional(element) || /^\d+$/.test(value3);
          }, "digits"),
          // https://jqueryvalidation.org/minlength-method/
          minlength: /* @__PURE__ */ __name(function(value3, element, param) {
            var length2 = Array.isArray(value3) ? value3.length : this.getLength(value3, element);
            return this.optional(element) || length2 >= param;
          }, "minlength"),
          // https://jqueryvalidation.org/maxlength-method/
          maxlength: /* @__PURE__ */ __name(function(value3, element, param) {
            var length2 = Array.isArray(value3) ? value3.length : this.getLength(value3, element);
            return this.optional(element) || length2 <= param;
          }, "maxlength"),
          // https://jqueryvalidation.org/rangelength-method/
          rangelength: /* @__PURE__ */ __name(function(value3, element, param) {
            var length2 = Array.isArray(value3) ? value3.length : this.getLength(value3, element);
            return this.optional(element) || length2 >= param[0] && length2 <= param[1];
          }, "rangelength"),
          // https://jqueryvalidation.org/min-method/
          min: /* @__PURE__ */ __name(function(value3, element, param) {
            return this.optional(element) || value3 >= param;
          }, "min"),
          // https://jqueryvalidation.org/max-method/
          max: /* @__PURE__ */ __name(function(value3, element, param) {
            return this.optional(element) || value3 <= param;
          }, "max"),
          // https://jqueryvalidation.org/range-method/
          range: /* @__PURE__ */ __name(function(value3, element, param) {
            return this.optional(element) || value3 >= param[0] && value3 <= param[1];
          }, "range"),
          // https://jqueryvalidation.org/step-method/
          step: /* @__PURE__ */ __name(function(value3, element, param) {
            var type2 = $2(element).attr("type"), errorMessage = "Step attribute on input type " + type2 + " is not supported.", supportedTypes = ["text", "number", "range"], re2 = new RegExp("\\b" + type2 + "\\b"), notSupported = type2 && !re2.test(supportedTypes.join()), decimalPlaces = /* @__PURE__ */ __name(function(num) {
              var match3 = ("" + num).match(/(?:\.(\d+))?$/);
              return match3 && match3[1] ? match3[1].length : 0;
            }, "decimalPlaces"), toInt = /* @__PURE__ */ __name(function(num) {
              return Math.round(num * Math.pow(10, decimals));
            }, "toInt"), valid = !0, decimals;
            if (notSupported)
              throw new Error(errorMessage);
            return decimals = decimalPlaces(param), (decimalPlaces(value3) > decimals || toInt(value3) % toInt(param) !== 0) && (valid = !1), this.optional(element) || valid;
          }, "step"),
          // https://jqueryvalidation.org/equalTo-method/
          equalTo: /* @__PURE__ */ __name(function(value3, element, param) {
            var target2 = $2(param);
            return this.settings.onfocusout && target2.not(".validate-equalTo-blur").length && target2.addClass("validate-equalTo-blur").on("blur.validate-equalTo", function() {
              $2(element).valid();
            }), value3 === target2.val();
          }, "equalTo"),
          // https://jqueryvalidation.org/remote-method/
          remote: /* @__PURE__ */ __name(function(value3, element, param, method) {
            if (this.optional(element))
              return "dependency-mismatch";
            method = typeof method == "string" && method || "remote";
            var previous = this.previousValue(element, method), validator3, data49, optionDataString;
            return this.settings.messages[element.name] || (this.settings.messages[element.name] = {}), previous.originalMessage = previous.originalMessage || this.settings.messages[element.name][method], this.settings.messages[element.name][method] = previous.message, param = typeof param == "string" && { url: param } || param, optionDataString = $2.param($2.extend({ data: value3 }, param.data)), previous.valid !== null && previous.old === optionDataString ? previous.valid : (previous.old = optionDataString, previous.valid = null, validator3 = this, this.startRequest(element), data49 = {}, data49[element.name] = value3, $2.ajax($2.extend(!0, {
              mode: "abort",
              port: this.elementAjaxPort(element),
              dataType: "json",
              data: data49,
              context: validator3.currentForm,
              success: /* @__PURE__ */ __name(function(response) {
                var valid = response === !0 || response === "true", errors, message, submitted;
                validator3.settings.messages[element.name][method] = previous.originalMessage, valid ? (submitted = validator3.formSubmitted, validator3.toHide = validator3.errorsFor(element), validator3.formSubmitted = submitted, validator3.successList.push(element), validator3.invalid[element.name] = !1, validator3.showErrors()) : (errors = {}, message = response || validator3.defaultMessage(element, { method, parameters: value3 }), errors[element.name] = previous.message = message, validator3.invalid[element.name] = !0, validator3.showErrors(errors)), previous.valid = valid, validator3.stopRequest(element, valid);
              }, "success")
            }, param)), "pending");
          }, "remote")
        }
      });
      var pendingRequests = {}, ajax;
      return $2.ajaxPrefilter ? $2.ajaxPrefilter(function(settings, _2, xhr) {
        var port = settings.port;
        settings.mode === "abort" && ($2.ajaxAbort(port), pendingRequests[port] = xhr);
      }) : (ajax = $2.ajax, $2.ajax = function(settings) {
        var mode = ("mode" in settings ? settings : $2.ajaxSettings).mode, port = ("port" in settings ? settings : $2.ajaxSettings).port;
        return mode === "abort" ? ($2.ajaxAbort(port), pendingRequests[port] = ajax.apply(this, arguments), pendingRequests[port]) : ajax.apply(this, arguments);
      }), $2.ajaxAbort = function(port) {
        pendingRequests[port] && (pendingRequests[port].abort(), delete pendingRequests[port]);
      }, $2;
    });
  }(jquery_validate)), jquery_validate.exports;
}
__name(requireJquery_validate, "requireJquery_validate");
requireJquery_validate();
var additionalMethods = { exports: {} };
/*!
 * jQuery Validation Plugin v1.21.0
 *
 * https://jqueryvalidation.org/
 *
 * Copyright (c) 2024 Jörn Zaefferer
 * Released under the MIT license
 */
(function(module2) {
  (function(factory2) {
    module2.exports ? module2.exports = factory2(requireJquery()) : factory2(jQuery);
  })(function($2) {
    return function() {
      function stripHtml(value3) {
        return value3.replace(/<.[^<>]*?>/g, " ").replace(/&nbsp;|&#160;/gi, " ").replace(/[.(),;:!?%#$'\"_+=\/\-“”’]*/g, "");
      }
      __name(stripHtml, "stripHtml"), $2.validator.addMethod("maxWords", function(value3, element, params) {
        return this.optional(element) || stripHtml(value3).match(/\b\w+\b/g).length <= params;
      }, $2.validator.format("Please enter {0} words or less.")), $2.validator.addMethod("minWords", function(value3, element, params) {
        return this.optional(element) || stripHtml(value3).match(/\b\w+\b/g).length >= params;
      }, $2.validator.format("Please enter at least {0} words.")), $2.validator.addMethod("rangeWords", function(value3, element, params) {
        var valueStripped = stripHtml(value3), regex2 = /\b\w+\b/g;
        return this.optional(element) || valueStripped.match(regex2).length >= params[0] && valueStripped.match(regex2).length <= params[1];
      }, $2.validator.format("Please enter between {0} and {1} words."));
    }(), $2.validator.addMethod("abaRoutingNumber", function(value3) {
      var checksum = 0, tokens = value3.split(""), length2 = tokens.length;
      if (length2 !== 9)
        return !1;
      for (var i = 0; i < length2; i += 3)
        checksum += parseInt(tokens[i], 10) * 3 + parseInt(tokens[i + 1], 10) * 7 + parseInt(tokens[i + 2], 10);
      return checksum !== 0 && checksum % 10 === 0;
    }, "Please enter a valid routing number."), $2.validator.addMethod("accept", function(value3, element, param) {
      var typeParam = typeof param == "string" ? param.replace(/\s/g, "") : "image/*", optionalValue = this.optional(element), i, file, regex2;
      if (optionalValue)
        return optionalValue;
      if ($2(element).attr("type") === "file" && (typeParam = typeParam.replace(/[\-\[\]\/\{\}\(\)\+\?\.\\\^\$\|]/g, "\\$&").replace(/,/g, "|").replace(/\/\*/g, "/.*"), element.files && element.files.length)) {
        for (regex2 = new RegExp(".?(" + typeParam + ")$", "i"), i = 0; i < element.files.length; i++)
          if (file = element.files[i], !file.type.match(regex2))
            return !1;
      }
      return !0;
    }, $2.validator.format("Please enter a value with a valid mimetype.")), $2.validator.addMethod("alphanumeric", function(value3, element) {
      return this.optional(element) || /^\w+$/i.test(value3);
    }, "Letters, numbers, and underscores only please."), $2.validator.addMethod("bankaccountNL", function(value3, element) {
      if (this.optional(element))
        return !0;
      if (!/^[0-9]{9}|([0-9]{2} ){3}[0-9]{3}$/.test(value3))
        return !1;
      var account2 = value3.replace(/ /g, ""), sum = 0, len2 = account2.length, pos, factor, digit;
      for (pos = 0; pos < len2; pos++)
        factor = len2 - pos, digit = account2.substring(pos, pos + 1), sum = sum + factor * digit;
      return sum % 11 === 0;
    }, "Please specify a valid bank account number."), $2.validator.addMethod("bankorgiroaccountNL", function(value3, element) {
      return this.optional(element) || $2.validator.methods.bankaccountNL.call(this, value3, element) || $2.validator.methods.giroaccountNL.call(this, value3, element);
    }, "Please specify a valid bank or giro account number."), $2.validator.addMethod("bic", function(value3, element) {
      return this.optional(element) || /^([A-Z]{6}[A-Z2-9][A-NP-Z1-9])(X{3}|[A-WY-Z0-9][A-Z0-9]{2})?$/.test(value3.toUpperCase());
    }, "Please specify a valid BIC code."), $2.validator.addMethod("cifES", function(value3, element) {
      if (this.optional(element))
        return !0;
      var cifRegEx = new RegExp(/^([ABCDEFGHJKLMNPQRSUVW])(\d{7})([0-9A-J])$/gi), letter = value3.substring(0, 1), number = value3.substring(1, 8), control = value3.substring(8, 9), all_sum = 0, even_sum = 0, odd_sum = 0, i, n2, control_digit, control_letter;
      function isOdd(n3) {
        return n3 % 2 === 0;
      }
      if (__name(isOdd, "isOdd"), value3.length !== 9 || !cifRegEx.test(value3))
        return !1;
      for (i = 0; i < number.length; i++)
        n2 = parseInt(number[i], 10), isOdd(i) ? (n2 *= 2, odd_sum += n2 < 10 ? n2 : n2 - 9) : even_sum += n2;
      return all_sum = even_sum + odd_sum, control_digit = (10 - all_sum.toString().substr(-1)).toString(), control_digit = parseInt(control_digit, 10) > 9 ? "0" : control_digit, control_letter = "JABCDEFGHI".substr(control_digit, 1).toString(), letter.match(/[ABEH]/) ? control === control_digit : letter.match(/[KPQS]/) ? control === control_letter : control === control_digit || control === control_letter;
    }, "Please specify a valid CIF number."), $2.validator.addMethod("cnhBR", function(value3) {
      if (value3 = value3.replace(/([~!@#$%^&*()_+=`{}\[\]\-|\\:;'<>,.\/? ])+/g, ""), value3.length !== 11)
        return !1;
      var sum = 0, dsc = 0, firstChar, firstCN, secondCN, i, j;
      if (firstChar = value3.charAt(0), new Array(12).join(firstChar) === value3)
        return !1;
      for (i = 0, j = 9, 0; i < 9; ++i, --j)
        sum += +(value3.charAt(i) * j);
      for (firstCN = sum % 11, firstCN >= 10 && (firstCN = 0, dsc = 2), sum = 0, i = 0, j = 1, 0; i < 9; ++i, ++j)
        sum += +(value3.charAt(i) * j);
      return secondCN = sum % 11, secondCN >= 10 ? secondCN = 0 : secondCN = secondCN - dsc, String(firstCN).concat(secondCN) === value3.substr(-2);
    }, "Please specify a valid CNH number."), $2.validator.addMethod("cnpjBR", function(value3, element) {
      if (this.optional(element))
        return !0;
      if (value3 = value3.replace(/[^\d]+/g, ""), value3.length !== 14 || value3 === "00000000000000" || value3 === "11111111111111" || value3 === "22222222222222" || value3 === "33333333333333" || value3 === "44444444444444" || value3 === "55555555555555" || value3 === "66666666666666" || value3 === "77777777777777" || value3 === "88888888888888" || value3 === "99999999999999")
        return !1;
      for (var tamanho = value3.length - 2, numeros = value3.substring(0, tamanho), digitos = value3.substring(tamanho), soma = 0, pos = tamanho - 7, i = tamanho; i >= 1; i--)
        soma += numeros.charAt(tamanho - i) * pos--, pos < 2 && (pos = 9);
      var resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
      if (resultado !== parseInt(digitos.charAt(0), 10))
        return !1;
      tamanho = tamanho + 1, numeros = value3.substring(0, tamanho), soma = 0, pos = tamanho - 7;
      for (var il = tamanho; il >= 1; il--)
        soma += numeros.charAt(tamanho - il) * pos--, pos < 2 && (pos = 9);
      return resultado = soma % 11 < 2 ? 0 : 11 - soma % 11, resultado === parseInt(digitos.charAt(1), 10);
    }, "Please specify a CNPJ value number."), $2.validator.addMethod("cpfBR", function(value3, element) {
      if (this.optional(element))
        return !0;
      if (value3 = value3.replace(/([~!@#$%^&*()_+=`{}\[\]\-|\\:;'<>,.\/? ])+/g, ""), value3.length !== 11)
        return !1;
      var sum = 0, firstCN, secondCN, checkResult, i;
      if (firstCN = parseInt(value3.substring(9, 10), 10), secondCN = parseInt(value3.substring(10, 11), 10), checkResult = /* @__PURE__ */ __name(function(sum2, cn) {
        var result = sum2 * 10 % 11;
        return (result === 10 || result === 11) && (result = 0), result === cn;
      }, "checkResult"), value3 === "" || value3 === "00000000000" || value3 === "11111111111" || value3 === "22222222222" || value3 === "33333333333" || value3 === "44444444444" || value3 === "55555555555" || value3 === "66666666666" || value3 === "77777777777" || value3 === "88888888888" || value3 === "99999999999")
        return !1;
      for (i = 1; i <= 9; i++)
        sum = sum + parseInt(value3.substring(i - 1, i), 10) * (11 - i);
      if (checkResult(sum, firstCN)) {
        for (sum = 0, i = 1; i <= 10; i++)
          sum = sum + parseInt(value3.substring(i - 1, i), 10) * (12 - i);
        return checkResult(sum, secondCN);
      }
      return !1;
    }, "Please specify a valid CPF number."), $2.validator.addMethod("creditcard", function(value3, element) {
      if (this.optional(element))
        return "dependency-mismatch";
      if (/[^0-9 \-]+/.test(value3))
        return !1;
      var nCheck = 0, nDigit = 0, bEven = !1, n2, cDigit;
      if (value3 = value3.replace(/\D/g, ""), value3.length < 13 || value3.length > 19)
        return !1;
      for (n2 = value3.length - 1; n2 >= 0; n2--)
        cDigit = value3.charAt(n2), nDigit = parseInt(cDigit, 10), bEven && (nDigit *= 2) > 9 && (nDigit -= 9), nCheck += nDigit, bEven = !bEven;
      return nCheck % 10 === 0;
    }, "Please enter a valid credit card number."), $2.validator.addMethod("creditcardtypes", function(value3, element, param) {
      if (/[^0-9\-]+/.test(value3))
        return !1;
      value3 = value3.replace(/\D/g, "");
      var validTypes = 0;
      return param.mastercard && (validTypes |= 1), param.visa && (validTypes |= 2), param.amex && (validTypes |= 4), param.dinersclub && (validTypes |= 8), param.enroute && (validTypes |= 16), param.discover && (validTypes |= 32), param.jcb && (validTypes |= 64), param.unknown && (validTypes |= 128), param.all && (validTypes = 255), validTypes & 1 && (/^(5[12345])/.test(value3) || /^(2[234567])/.test(value3)) || validTypes & 2 && /^(4)/.test(value3) ? value3.length === 16 : validTypes & 4 && /^(3[47])/.test(value3) ? value3.length === 15 : validTypes & 8 && /^(3(0[012345]|[68]))/.test(value3) ? value3.length === 14 : validTypes & 16 && /^(2(014|149))/.test(value3) ? value3.length === 15 : validTypes & 32 && /^(6011)/.test(value3) || validTypes & 64 && /^(3)/.test(value3) ? value3.length === 16 : validTypes & 64 && /^(2131|1800)/.test(value3) ? value3.length === 15 : !!(validTypes & 128);
    }, "Please enter a valid credit card number."), $2.validator.addMethod("currency", function(value3, element, param) {
      var isParamString = typeof param == "string", symbol = isParamString ? param : param[0], soft = isParamString ? !0 : param[1], regex2;
      return symbol = symbol.replace(/,/g, ""), symbol = soft ? symbol + "]" : symbol + "]?", regex2 = "^[" + symbol + "([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}[0-9]{0,}(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$", regex2 = new RegExp(regex2), this.optional(element) || regex2.test(value3);
    }, "Please specify a valid currency."), $2.validator.addMethod("dateFA", function(value3, element) {
      return this.optional(element) || /^[1-4]\d{3}\/((0?[1-6]\/((3[0-1])|([1-2][0-9])|(0?[1-9])))|((1[0-2]|(0?[7-9]))\/(30|([1-2][0-9])|(0?[1-9]))))$/.test(value3);
    }, $2.validator.messages.date), $2.validator.addMethod("dateITA", function(value3, element) {
      var check = !1, re2 = /^\d{1,2}\/\d{1,2}\/\d{4}$/, adata, gg, mm, aaaa, xdata;
      return re2.test(value3) ? (adata = value3.split("/"), gg = parseInt(adata[0], 10), mm = parseInt(adata[1], 10), aaaa = parseInt(adata[2], 10), xdata = new Date(Date.UTC(aaaa, mm - 1, gg, 12, 0, 0, 0)), xdata.getUTCFullYear() === aaaa && xdata.getUTCMonth() === mm - 1 && xdata.getUTCDate() === gg ? check = !0 : check = !1) : check = !1, this.optional(element) || check;
    }, $2.validator.messages.date), $2.validator.addMethod("dateNL", function(value3, element) {
      return this.optional(element) || /^(0?[1-9]|[12]\d|3[01])[\.\/\-](0?[1-9]|1[012])[\.\/\-]([12]\d)?(\d\d)$/.test(value3);
    }, $2.validator.messages.date), $2.validator.addMethod("extension", function(value3, element, param) {
      return param = typeof param == "string" ? param.replace(/,/g, "|") : "png|jpe?g|gif", this.optional(element) || value3.match(new RegExp("\\.(" + param + ")$", "i"));
    }, $2.validator.format("Please enter a value with a valid extension.")), $2.validator.addMethod("giroaccountNL", function(value3, element) {
      return this.optional(element) || /^[0-9]{1,7}$/.test(value3);
    }, "Please specify a valid giro account number."), $2.validator.addMethod("greaterThan", function(value3, element, param) {
      var target2 = $2(param);
      return this.settings.onfocusout && target2.not(".validate-greaterThan-blur").length && target2.addClass("validate-greaterThan-blur").on("blur.validate-greaterThan", function() {
        $2(element).valid();
      }), value3 > target2.val();
    }, "Please enter a greater value."), $2.validator.addMethod("greaterThanEqual", function(value3, element, param) {
      var target2 = $2(param);
      return this.settings.onfocusout && target2.not(".validate-greaterThanEqual-blur").length && target2.addClass("validate-greaterThanEqual-blur").on("blur.validate-greaterThanEqual", function() {
        $2(element).valid();
      }), value3 >= target2.val();
    }, "Please enter a greater value."), $2.validator.addMethod("iban", function(value3, element) {
      if (this.optional(element))
        return !0;
      var iban = value3.replace(/ /g, "").toUpperCase(), ibancheckdigits = "", leadingZeroes = !0, cRest = "", cOperator = "", countrycode, ibancheck, charAt, cChar, bbanpattern, bbancountrypatterns, ibanregexp, i, p, minimalIBANlength = 5;
      if (iban.length < minimalIBANlength || (countrycode = iban.substring(0, 2), bbancountrypatterns = {
        AL: "\\d{8}[\\dA-Z]{16}",
        AD: "\\d{8}[\\dA-Z]{12}",
        AT: "\\d{16}",
        AZ: "[\\dA-Z]{4}\\d{20}",
        BE: "\\d{12}",
        BH: "[A-Z]{4}[\\dA-Z]{14}",
        BA: "\\d{16}",
        BR: "\\d{23}[A-Z][\\dA-Z]",
        BG: "[A-Z]{4}\\d{6}[\\dA-Z]{8}",
        CR: "\\d{17}",
        HR: "\\d{17}",
        CY: "\\d{8}[\\dA-Z]{16}",
        CZ: "\\d{20}",
        DK: "\\d{14}",
        DO: "[A-Z]{4}\\d{20}",
        EE: "\\d{16}",
        FO: "\\d{14}",
        FI: "\\d{14}",
        FR: "\\d{10}[\\dA-Z]{11}\\d{2}",
        GE: "[\\dA-Z]{2}\\d{16}",
        DE: "\\d{18}",
        GI: "[A-Z]{4}[\\dA-Z]{15}",
        GR: "\\d{7}[\\dA-Z]{16}",
        GL: "\\d{14}",
        GT: "[\\dA-Z]{4}[\\dA-Z]{20}",
        HU: "\\d{24}",
        IS: "\\d{22}",
        IE: "[\\dA-Z]{4}\\d{14}",
        IL: "\\d{19}",
        IT: "[A-Z]\\d{10}[\\dA-Z]{12}",
        KZ: "\\d{3}[\\dA-Z]{13}",
        KW: "[A-Z]{4}[\\dA-Z]{22}",
        LV: "[A-Z]{4}[\\dA-Z]{13}",
        LB: "\\d{4}[\\dA-Z]{20}",
        LI: "\\d{5}[\\dA-Z]{12}",
        LT: "\\d{16}",
        LU: "\\d{3}[\\dA-Z]{13}",
        MK: "\\d{3}[\\dA-Z]{10}\\d{2}",
        MT: "[A-Z]{4}\\d{5}[\\dA-Z]{18}",
        MR: "\\d{23}",
        MU: "[A-Z]{4}\\d{19}[A-Z]{3}",
        MC: "\\d{10}[\\dA-Z]{11}\\d{2}",
        MD: "[\\dA-Z]{2}\\d{18}",
        ME: "\\d{18}",
        NL: "[A-Z]{4}\\d{10}",
        NO: "\\d{11}",
        PK: "[\\dA-Z]{4}\\d{16}",
        PS: "[\\dA-Z]{4}\\d{21}",
        PL: "\\d{24}",
        PT: "\\d{21}",
        RO: "[A-Z]{4}[\\dA-Z]{16}",
        SM: "[A-Z]\\d{10}[\\dA-Z]{12}",
        SA: "\\d{2}[\\dA-Z]{18}",
        RS: "\\d{18}",
        SK: "\\d{20}",
        SI: "\\d{15}",
        ES: "\\d{20}",
        SE: "\\d{20}",
        CH: "\\d{5}[\\dA-Z]{12}",
        TN: "\\d{20}",
        TR: "\\d{5}[\\dA-Z]{17}",
        AE: "\\d{3}\\d{16}",
        GB: "[A-Z]{4}\\d{14}",
        VG: "[\\dA-Z]{4}\\d{16}"
      }, bbanpattern = bbancountrypatterns[countrycode], typeof bbanpattern < "u" && (ibanregexp = new RegExp("^[A-Z]{2}\\d{2}" + bbanpattern + "$", ""), !ibanregexp.test(iban))))
        return !1;
      for (ibancheck = iban.substring(4, iban.length) + iban.substring(0, 4), i = 0; i < ibancheck.length; i++)
        charAt = ibancheck.charAt(i), charAt !== "0" && (leadingZeroes = !1), leadingZeroes || (ibancheckdigits += "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(charAt));
      for (p = 0; p < ibancheckdigits.length; p++)
        cChar = ibancheckdigits.charAt(p), cOperator = "" + cRest + cChar, cRest = cOperator % 97;
      return cRest === 1;
    }, "Please specify a valid IBAN."), $2.validator.addMethod("integer", function(value3, element) {
      return this.optional(element) || /^-?\d+$/.test(value3);
    }, "A positive or negative non-decimal number please."), $2.validator.addMethod("ipv4", function(value3, element) {
      return this.optional(element) || /^(25[0-5]|2[0-4]\d|[01]?\d\d?)\.(25[0-5]|2[0-4]\d|[01]?\d\d?)\.(25[0-5]|2[0-4]\d|[01]?\d\d?)\.(25[0-5]|2[0-4]\d|[01]?\d\d?)$/i.test(value3);
    }, "Please enter a valid IP v4 address."), $2.validator.addMethod("ipv6", function(value3, element) {
      return this.optional(element) || /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(value3);
    }, "Please enter a valid IP v6 address."), $2.validator.addMethod("lessThan", function(value3, element, param) {
      var target2 = $2(param);
      return this.settings.onfocusout && target2.not(".validate-lessThan-blur").length && target2.addClass("validate-lessThan-blur").on("blur.validate-lessThan", function() {
        $2(element).valid();
      }), value3 < target2.val();
    }, "Please enter a lesser value."), $2.validator.addMethod("lessThanEqual", function(value3, element, param) {
      var target2 = $2(param);
      return this.settings.onfocusout && target2.not(".validate-lessThanEqual-blur").length && target2.addClass("validate-lessThanEqual-blur").on("blur.validate-lessThanEqual", function() {
        $2(element).valid();
      }), value3 <= target2.val();
    }, "Please enter a lesser value."), $2.validator.addMethod("lettersonly", function(value3, element) {
      return this.optional(element) || /^[a-z]+$/i.test(value3);
    }, "Letters only please."), $2.validator.addMethod("letterswithbasicpunc", function(value3, element) {
      return this.optional(element) || /^[a-z\-.,()'"\s]+$/i.test(value3);
    }, "Letters or punctuation only please."), $2.validator.addMethod("maxfiles", function(value3, element, param) {
      return this.optional(element) ? !0 : !($2(element).attr("type") === "file" && element.files && element.files.length > param);
    }, $2.validator.format("Please select no more than {0} files.")), $2.validator.addMethod("maxsize", function(value3, element, param) {
      if (this.optional(element))
        return !0;
      if ($2(element).attr("type") === "file" && element.files && element.files.length) {
        for (var i = 0; i < element.files.length; i++)
          if (element.files[i].size > param)
            return !1;
      }
      return !0;
    }, $2.validator.format("File size must not exceed {0} bytes each.")), $2.validator.addMethod("maxsizetotal", function(value3, element, param) {
      if (this.optional(element))
        return !0;
      if ($2(element).attr("type") === "file" && element.files && element.files.length) {
        for (var totalSize = 0, i = 0; i < element.files.length; i++)
          if (totalSize += element.files[i].size, totalSize > param)
            return !1;
      }
      return !0;
    }, $2.validator.format("Total size of all files must not exceed {0} bytes.")), $2.validator.addMethod("mobileNL", function(value3, element) {
      return this.optional(element) || /^((\+|00(\s|\s?\-\s?)?)31(\s|\s?\-\s?)?(\(0\)[\-\s]?)?|0)6((\s|\s?\-\s?)?[0-9]){8}$/.test(value3);
    }, "Please specify a valid mobile number."), $2.validator.addMethod("mobileRU", function(phone_number, element) {
      var ruPhone_number = phone_number.replace(/\(|\)|\s+|-/g, "");
      return this.optional(element) || ruPhone_number.length > 9 && /^((\+7|7|8)+([0-9]){10})$/.test(ruPhone_number);
    }, "Please specify a valid mobile number."), $2.validator.addMethod("mobileUK", function(phone_number, element) {
      return phone_number = phone_number.replace(/\(|\)|\s+|-/g, ""), this.optional(element) || phone_number.length > 9 && phone_number.match(/^(?:(?:(?:00\s?|\+)44\s?|0)7(?:[1345789]\d{2}|624)\s?\d{3}\s?\d{3})$/);
    }, "Please specify a valid mobile number."), $2.validator.addMethod("netmask", function(value3, element) {
      return this.optional(element) || /^(254|252|248|240|224|192|128)\.0\.0\.0|255\.(254|252|248|240|224|192|128|0)\.0\.0|255\.255\.(254|252|248|240|224|192|128|0)\.0|255\.255\.255\.(254|252|248|240|224|192|128|0)/i.test(value3);
    }, "Please enter a valid netmask."), $2.validator.addMethod("nieES", function(value3, element) {
      if (this.optional(element))
        return !0;
      var nieRegEx = new RegExp(/^[MXYZ]{1}[0-9]{7,8}[TRWAGMYFPDXBNJZSQVHLCKET]{1}$/gi), validChars = "TRWAGMYFPDXBNJZSQVHLCKET", letter = value3.substr(value3.length - 1).toUpperCase(), number;
      return value3 = value3.toString().toUpperCase(), value3.length > 10 || value3.length < 9 || !nieRegEx.test(value3) ? !1 : (value3 = value3.replace(/^[X]/, "0").replace(/^[Y]/, "1").replace(/^[Z]/, "2"), number = value3.length === 9 ? value3.substr(0, 8) : value3.substr(0, 9), validChars.charAt(parseInt(number, 10) % 23) === letter);
    }, "Please specify a valid NIE number."), $2.validator.addMethod("nifES", function(value3, element) {
      return this.optional(element) ? !0 : (value3 = value3.toUpperCase(), value3.match("((^[A-Z]{1}[0-9]{7}[A-Z0-9]{1}$|^[T]{1}[A-Z0-9]{8}$)|^[0-9]{8}[A-Z]{1}$)") ? /^[0-9]{8}[A-Z]{1}$/.test(value3) ? "TRWAGMYFPDXBNJZSQVHLCKE".charAt(value3.substring(8, 0) % 23) === value3.charAt(8) : /^[KLM]{1}/.test(value3) ? value3[8] === "TRWAGMYFPDXBNJZSQVHLCKE".charAt(value3.substring(8, 1) % 23) : !1 : !1);
    }, "Please specify a valid NIF number."), $2.validator.addMethod("nipPL", function(value3) {
      if (value3 = value3.replace(/[^0-9]/g, ""), value3.length !== 10)
        return !1;
      for (var arrSteps = [6, 5, 7, 2, 3, 4, 5, 6, 7], intSum = 0, i = 0; i < 9; i++)
        intSum += arrSteps[i] * value3[i];
      var int2 = intSum % 11, intControlNr = int2 === 10 ? 0 : int2;
      return intControlNr === parseInt(value3[9], 10);
    }, "Please specify a valid NIP number."), $2.validator.addMethod("nisBR", function(value3) {
      var number, cn, sum = 0, dv, count2, multiplier;
      if (value3 = value3.replace(/([~!@#$%^&*()_+=`{}\[\]\-|\\:;'<>,.\/? ])+/g, ""), value3.length !== 11)
        return !1;
      for (cn = parseInt(value3.substring(10, 11), 10), number = parseInt(value3.substring(0, 10), 10), count2 = 2; count2 < 12; count2++)
        multiplier = count2, count2 === 10 && (multiplier = 2), count2 === 11 && (multiplier = 3), sum += number % 10 * multiplier, number = parseInt(number / 10, 10);
      return dv = sum % 11, dv > 1 ? dv = 11 - dv : dv = 0, cn === dv;
    }, "Please specify a valid NIS/PIS number."), $2.validator.addMethod("notEqualTo", function(value3, element, param) {
      return this.optional(element) || !$2.validator.methods.equalTo.call(this, value3, element, param);
    }, "Please enter a different value, values must not be the same."), $2.validator.addMethod("nowhitespace", function(value3, element) {
      return this.optional(element) || /^\S+$/i.test(value3);
    }, "No white space please."), $2.validator.addMethod("pattern", function(value3, element, param) {
      return this.optional(element) ? !0 : (typeof param == "string" && (param = new RegExp("^(?:" + param + ")$")), param.test(value3));
    }, "Invalid format."), $2.validator.addMethod("phoneNL", function(value3, element) {
      return this.optional(element) || /^((\+|00(\s|\s?\-\s?)?)31(\s|\s?\-\s?)?(\(0\)[\-\s]?)?|0)[1-9]((\s|\s?\-\s?)?[0-9]){8}$/.test(value3);
    }, "Please specify a valid phone number."), $2.validator.addMethod("phonePL", function(phone_number, element) {
      phone_number = phone_number.replace(/\s+/g, "");
      var regexp = /^(?:(?:(?:\+|00)?48)|(?:\(\+?48\)))?(?:1[2-8]|2[2-69]|3[2-49]|4[1-68]|5[0-9]|6[0-35-9]|[7-8][1-9]|9[145])\d{7}$/;
      return this.optional(element) || regexp.test(phone_number);
    }, "Please specify a valid phone number."), $2.validator.addMethod("phonesUK", function(phone_number, element) {
      return phone_number = phone_number.replace(/\(|\)|\s+|-/g, ""), this.optional(element) || phone_number.length > 9 && phone_number.match(/^(?:(?:(?:00\s?|\+)44\s?|0)(?:1\d{8,9}|[23]\d{9}|7(?:[1345789]\d{8}|624\d{6})))$/);
    }, "Please specify a valid uk phone number."), $2.validator.addMethod("phoneUK", function(phone_number, element) {
      return phone_number = phone_number.replace(/\(|\)|\s+|-/g, ""), this.optional(element) || phone_number.length > 9 && phone_number.match(/^(?:(?:(?:00\s?|\+)44\s?)|(?:\(?0))(?:\d{2}\)?\s?\d{4}\s?\d{4}|\d{3}\)?\s?\d{3}\s?\d{3,4}|\d{4}\)?\s?(?:\d{5}|\d{3}\s?\d{3})|\d{5}\)?\s?\d{4,5})$/);
    }, "Please specify a valid phone number."), $2.validator.addMethod("phoneUS", function(phone_number, element) {
      return phone_number = phone_number.replace(/\s+/g, ""), this.optional(element) || phone_number.length > 9 && phone_number.match(/^(\+?1-?)?(\([2-9]([02-9]\d|1[02-9])\)|[2-9]([02-9]\d|1[02-9]))-?[2-9]\d{2}-?\d{4}$/);
    }, "Please specify a valid phone number."), $2.validator.addMethod("postalcodeBR", function(cep_value, element) {
      return this.optional(element) || /^\d{2}.\d{3}-\d{3}?$|^\d{5}-?\d{3}?$/.test(cep_value);
    }, "Informe um CEP válido."), $2.validator.addMethod("postalCodeCA", function(value3, element) {
      return this.optional(element) || /^[ABCEGHJKLMNPRSTVXY]\d[ABCEGHJKLMNPRSTVWXYZ] *\d[ABCEGHJKLMNPRSTVWXYZ]\d$/i.test(value3);
    }, "Please specify a valid postal code."), $2.validator.addMethod("postalcodeIT", function(value3, element) {
      return this.optional(element) || /^\d{5}$/.test(value3);
    }, "Please specify a valid postal code."), $2.validator.addMethod("postalcodeNL", function(value3, element) {
      return this.optional(element) || /^[1-9][0-9]{3}\s?[a-zA-Z]{2}$/.test(value3);
    }, "Please specify a valid postal code."), $2.validator.addMethod("postcodeUK", function(value3, element) {
      return this.optional(element) || /^((([A-PR-UWYZ][0-9])|([A-PR-UWYZ][0-9][0-9])|([A-PR-UWYZ][A-HK-Y][0-9])|([A-PR-UWYZ][A-HK-Y][0-9][0-9])|([A-PR-UWYZ][0-9][A-HJKSTUW])|([A-PR-UWYZ][A-HK-Y][0-9][ABEHMNPRVWXY]))\s?([0-9][ABD-HJLNP-UW-Z]{2})|(GIR)\s?(0AA))$/i.test(value3);
    }, "Please specify a valid UK postcode."), $2.validator.addMethod("require_from_group", function(value3, element, options2) {
      var $fields = $2(options2[1], element.form), $fieldsFirst = $fields.eq(0), validator3 = $fieldsFirst.data("valid_req_grp") ? $fieldsFirst.data("valid_req_grp") : $2.extend({}, this), isValid3 = $fields.filter(function() {
        return validator3.elementValue(this);
      }).length >= options2[0];
      return $fieldsFirst.data("valid_req_grp", validator3), $2(element).data("being_validated") || ($fields.data("being_validated", !0), $fields.each(function() {
        validator3.element(this);
      }), $fields.data("being_validated", !1)), isValid3;
    }, $2.validator.format("Please fill at least {0} of these fields.")), $2.validator.addMethod("skip_or_fill_minimum", function(value3, element, options2) {
      var $fields = $2(options2[1], element.form), $fieldsFirst = $fields.eq(0), validator3 = $fieldsFirst.data("valid_skip") ? $fieldsFirst.data("valid_skip") : $2.extend({}, this), numberFilled = $fields.filter(function() {
        return validator3.elementValue(this);
      }).length, isValid3 = numberFilled === 0 || numberFilled >= options2[0];
      return $fieldsFirst.data("valid_skip", validator3), $2(element).data("being_validated") || ($fields.data("being_validated", !0), $fields.each(function() {
        validator3.element(this);
      }), $fields.data("being_validated", !1)), isValid3;
    }, $2.validator.format("Please either skip these fields or fill at least {0} of them.")), $2.validator.addMethod("stateUS", function(value3, element, options2) {
      var isDefault = typeof options2 > "u", caseSensitive = isDefault || typeof options2.caseSensitive > "u" ? !1 : options2.caseSensitive, includeTerritories = isDefault || typeof options2.includeTerritories > "u" ? !1 : options2.includeTerritories, includeMilitary = isDefault || typeof options2.includeMilitary > "u" ? !1 : options2.includeMilitary, regex2;
      return !includeTerritories && !includeMilitary ? regex2 = "^(A[KLRZ]|C[AOT]|D[CE]|FL|GA|HI|I[ADLN]|K[SY]|LA|M[ADEINOST]|N[CDEHJMVY]|O[HKR]|PA|RI|S[CD]|T[NX]|UT|V[AT]|W[AIVY])$" : includeTerritories && includeMilitary ? regex2 = "^(A[AEKLPRSZ]|C[AOT]|D[CE]|FL|G[AU]|HI|I[ADLN]|K[SY]|LA|M[ADEINOPST]|N[CDEHJMVY]|O[HKR]|P[AR]|RI|S[CD]|T[NX]|UT|V[AIT]|W[AIVY])$" : includeTerritories ? regex2 = "^(A[KLRSZ]|C[AOT]|D[CE]|FL|G[AU]|HI|I[ADLN]|K[SY]|LA|M[ADEINOPST]|N[CDEHJMVY]|O[HKR]|P[AR]|RI|S[CD]|T[NX]|UT|V[AIT]|W[AIVY])$" : regex2 = "^(A[AEKLPRZ]|C[AOT]|D[CE]|FL|GA|HI|I[ADLN]|K[SY]|LA|M[ADEINOST]|N[CDEHJMVY]|O[HKR]|PA|RI|S[CD]|T[NX]|UT|V[AT]|W[AIVY])$", regex2 = caseSensitive ? new RegExp(regex2) : new RegExp(regex2, "i"), this.optional(element) || regex2.test(value3);
    }, "Please specify a valid state."), $2.validator.addMethod("strippedminlength", function(value3, element, param) {
      return $2(value3).text().length >= param;
    }, $2.validator.format("Please enter at least {0} characters.")), $2.validator.addMethod("time", function(value3, element) {
      return this.optional(element) || /^([01]\d|2[0-3]|[0-9])(:[0-5]\d){1,2}$/.test(value3);
    }, "Please enter a valid time, between 00:00 and 23:59."), $2.validator.addMethod("time12h", function(value3, element) {
      return this.optional(element) || /^((0?[1-9]|1[012])(:[0-5]\d){1,2}(\ ?[AP]M))$/i.test(value3);
    }, "Please enter a valid time in 12-hour am/pm format."), $2.validator.addMethod("url2", function(value3, element) {
      return this.optional(element) || /^(?:(?:(?:https?|ftp):)?\/\/)(?:(?:[^\]\[?\/<~#`!@$^&*()+=}|:";',>{ ]|%[0-9A-Fa-f]{2})+(?::(?:[^\]\[?\/<~#`!@$^&*()+=}|:";',>{ ]|%[0-9A-Fa-f]{2})*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z0-9\u00a1-\uffff][a-z0-9\u00a1-\uffff_-]{0,62})?[a-z0-9\u00a1-\uffff]\.)+(?:[a-z\u00a1-\uffff]{2,}\.?)|(?:(?:[a-z0-9\u00a1-\uffff][a-z0-9\u00a1-\uffff_-]{0,62})?[a-z0-9\u00a1-\uffff])|(?:(?:[a-z0-9\u00a1-\uffff][a-z0-9\u00a1-\uffff_-]{0,62}\.)))(?::\d{2,5})?(?:[/?#]\S*)?$/i.test(value3);
    }, $2.validator.messages.url), $2.validator.addMethod("vinUS", function(v) {
      if (v.length !== 17)
        return !1;
      var LL = ["A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "P", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"], VL = [1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 7, 9, 2, 3, 4, 5, 6, 7, 8, 9], FL = [8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2], rs = 0, i, n2, d, f, cd, cdv;
      for (i = 0; i < 17; i++)
        f = FL[i], d = v.slice(i, i + 1), isNaN(d) ? (d = d.toUpperCase(), n2 = VL[LL.indexOf(d)]) : n2 = parseInt(d, 10), i === 8 && (cdv = n2, d === "X" && (cdv = 10)), rs += n2 * f;
      return cd = rs % 11, cd === cdv;
    }, "The specified vehicle identification number (VIN) is invalid."), $2.validator.addMethod("zipcodeUS", function(value3, element) {
      return this.optional(element) || /^\d{5}(-\d{4})?$/.test(value3);
    }, "The specified US ZIP Code is invalid."), $2.validator.addMethod("ziprange", function(value3, element) {
      return this.optional(element) || /^90[2-5]\d\{2\}-\d{4}$/.test(value3);
    }, "Your ZIP-code must be in the range 902xx-xxxx to 905xx-xxxx."), $2;
  });
})(additionalMethods);
var jquery_validate_unobtrusive = { exports: {} };
(function(module2) {
  (function(factory2) {
    module2.exports ? module2.exports = factory2(requireJquery_validate()) : jQuery.validator.unobtrusive = factory2(jQuery);
  })(function($2) {
    var $jQval = $2.validator, adapters, data_validation = "unobtrusiveValidation";
    function setValidationValues(options2, ruleName, value3) {
      options2.rules[ruleName] = value3, options2.message && (options2.messages[ruleName] = options2.message);
    }
    __name(setValidationValues, "setValidationValues");
    function splitAndTrim(value3) {
      return value3.replace(/^\s+|\s+$/g, "").split(/\s*,\s*/g);
    }
    __name(splitAndTrim, "splitAndTrim");
    function escapeAttributeValue(value3) {
      return value3.replace(/([!"#$%&'()*+,./:;<=>?@\[\\\]^`{|}~])/g, "\\$1");
    }
    __name(escapeAttributeValue, "escapeAttributeValue");
    function getModelPrefix(fieldName) {
      return fieldName.substr(0, fieldName.lastIndexOf(".") + 1);
    }
    __name(getModelPrefix, "getModelPrefix");
    function appendModelPrefix(value3, prefix) {
      return value3.indexOf("*.") === 0 && (value3 = value3.replace("*.", prefix)), value3;
    }
    __name(appendModelPrefix, "appendModelPrefix");
    function onError3(error2, inputElement) {
      var container = $2(this).find("[data-valmsg-for='" + escapeAttributeValue(inputElement[0].name) + "']"), replaceAttrValue = container.attr("data-valmsg-replace"), replace2 = replaceAttrValue ? $2.parseJSON(replaceAttrValue) !== !1 : null;
      container.removeClass("field-validation-valid").addClass("field-validation-error"), error2.data("unobtrusiveContainer", container), replace2 ? (container.empty(), error2.removeClass("input-validation-error").appendTo(container)) : error2.hide();
    }
    __name(onError3, "onError");
    function onErrors(event2, validator3) {
      var container = $2(this).find("[data-valmsg-summary=true]"), list = container.find("ul");
      list && list.length && validator3.errorList.length && (list.empty(), container.addClass("validation-summary-errors").removeClass("validation-summary-valid"), $2.each(validator3.errorList, function() {
        $2("<li />").html(this.message).appendTo(list);
      }));
    }
    __name(onErrors, "onErrors");
    function onSuccess(error2) {
      var container = error2.data("unobtrusiveContainer");
      if (container) {
        var replaceAttrValue = container.attr("data-valmsg-replace"), replace2 = replaceAttrValue ? $2.parseJSON(replaceAttrValue) : null;
        container.addClass("field-validation-valid").removeClass("field-validation-error"), error2.removeData("unobtrusiveContainer"), replace2 && container.empty();
      }
    }
    __name(onSuccess, "onSuccess");
    function onReset(event2) {
      var $form = $2(this), key = "__jquery_unobtrusive_validation_form_reset";
      if (!$form.data(key)) {
        $form.data(key, !0);
        try {
          $form.data("validator").resetForm();
        } finally {
          $form.removeData(key);
        }
        $form.find(".validation-summary-errors").addClass("validation-summary-valid").removeClass("validation-summary-errors"), $form.find(".field-validation-error").addClass("field-validation-valid").removeClass("field-validation-error").removeData("unobtrusiveContainer").find(">*").removeData("unobtrusiveContainer");
      }
    }
    __name(onReset, "onReset");
    function validationInfo(form2) {
      var $form = $2(form2), result = $form.data(data_validation), onResetProxy = $2.proxy(onReset, form2), defaultOptions = $jQval.unobtrusive.options || {}, execInContext = /* @__PURE__ */ __name(function(name2, args) {
        var func = defaultOptions[name2];
        func && $2.isFunction(func) && func.apply(form2, args);
      }, "execInContext");
      return result || (result = {
        options: {
          // options structure passed to jQuery Validate's validate() method
          errorClass: defaultOptions.errorClass || "input-validation-error",
          errorElement: defaultOptions.errorElement || "span",
          errorPlacement: /* @__PURE__ */ __name(function() {
            onError3.apply(form2, arguments), execInContext("errorPlacement", arguments);
          }, "errorPlacement"),
          invalidHandler: /* @__PURE__ */ __name(function() {
            onErrors.apply(form2, arguments), execInContext("invalidHandler", arguments);
          }, "invalidHandler"),
          messages: {},
          rules: {},
          success: /* @__PURE__ */ __name(function() {
            onSuccess.apply(form2, arguments), execInContext("success", arguments);
          }, "success")
        },
        attachValidation: /* @__PURE__ */ __name(function() {
          $form.off("reset." + data_validation, onResetProxy).on("reset." + data_validation, onResetProxy).validate(this.options);
        }, "attachValidation"),
        validate: /* @__PURE__ */ __name(function() {
          return $form.validate(), $form.valid();
        }, "validate")
      }, $form.data(data_validation, result)), result;
    }
    return __name(validationInfo, "validationInfo"), $jQval.unobtrusive = {
      adapters: [],
      parseElement: /* @__PURE__ */ __name(function(element, skipAttach) {
        var $element = $2(element), form2 = $element.parents("form")[0], valInfo, rules2, messages2;
        form2 && (valInfo = validationInfo(form2), valInfo.options.rules[element.name] = rules2 = {}, valInfo.options.messages[element.name] = messages2 = {}, $2.each(this.adapters, function() {
          var prefix = "data-val-" + this.name, message = $element.attr(prefix), paramValues = {};
          message !== void 0 && (prefix += "-", $2.each(this.params, function() {
            paramValues[this] = $element.attr(prefix + this);
          }), this.adapt({
            element,
            form: form2,
            message,
            params: paramValues,
            rules: rules2,
            messages: messages2
          }));
        }), $2.extend(rules2, { __dummy__: !0 }), skipAttach || valInfo.attachValidation());
      }, "parseElement"),
      parse: /* @__PURE__ */ __name(function(selector) {
        var $selector = $2(selector), $forms = $selector.parents().addBack().filter("form").add($selector.find("form")).has("[data-val=true]");
        $selector.find("[data-val=true]").each(function() {
          $jQval.unobtrusive.parseElement(this, !0);
        }), $forms.each(function() {
          var info = validationInfo(this);
          info && info.attachValidation();
        });
      }, "parse")
    }, adapters = $jQval.unobtrusive.adapters, adapters.add = function(adapterName, params, fn2) {
      return fn2 || (fn2 = params, params = []), this.push({ name: adapterName, params, adapt: fn2 }), this;
    }, adapters.addBool = function(adapterName, ruleName) {
      return this.add(adapterName, function(options2) {
        setValidationValues(options2, ruleName || adapterName, !0);
      });
    }, adapters.addMinMax = function(adapterName, minRuleName, maxRuleName, minMaxRuleName, minAttribute, maxAttribute) {
      return this.add(adapterName, [minAttribute || "min", maxAttribute || "max"], function(options2) {
        var min2 = options2.params.min, max2 = options2.params.max;
        min2 && max2 ? setValidationValues(options2, minMaxRuleName, [min2, max2]) : min2 ? setValidationValues(options2, minRuleName, min2) : max2 && setValidationValues(options2, maxRuleName, max2);
      });
    }, adapters.addSingleVal = function(adapterName, attribute2, ruleName) {
      return this.add(adapterName, [attribute2 || "val"], function(options2) {
        setValidationValues(options2, ruleName || adapterName, options2.params[attribute2]);
      });
    }, $jQval.addMethod("__dummy__", function(value3, element, params) {
      return !0;
    }), $jQval.addMethod("regex", function(value3, element, params) {
      var match3;
      return this.optional(element) ? !0 : (match3 = new RegExp(params).exec(value3), match3 && match3.index === 0 && match3[0].length === value3.length);
    }), $jQval.addMethod("nonalphamin", function(value3, element, nonalphamin) {
      var match3;
      return nonalphamin && (match3 = value3.match(/\W/g), match3 = match3 && match3.length >= nonalphamin), match3;
    }), $jQval.methods.extension ? (adapters.addSingleVal("accept", "mimtype"), adapters.addSingleVal("extension", "extension")) : adapters.addSingleVal("extension", "extension", "accept"), adapters.addSingleVal("regex", "pattern"), adapters.addBool("creditcard").addBool("date").addBool("digits").addBool("email").addBool("number").addBool("url"), adapters.addMinMax("length", "minlength", "maxlength", "rangelength").addMinMax("range", "min", "max", "range"), adapters.addMinMax("minlength", "minlength").addMinMax("maxlength", "minlength", "maxlength"), adapters.add("equalto", ["other"], function(options2) {
      var prefix = getModelPrefix(options2.element.name), other = options2.params.other, fullOtherName = appendModelPrefix(other, prefix), element = $2(options2.form).find(":input").filter("[name='" + escapeAttributeValue(fullOtherName) + "']")[0];
      setValidationValues(options2, "equalTo", element);
    }), adapters.add("required", function(options2) {
      (options2.element.tagName.toUpperCase() !== "INPUT" || options2.element.type.toUpperCase() !== "CHECKBOX") && setValidationValues(options2, "required", !0);
    }), adapters.add("remote", ["url", "type", "additionalfields"], function(options2) {
      var value3 = {
        url: options2.params.url,
        type: options2.params.type || "GET",
        data: {}
      }, prefix = getModelPrefix(options2.element.name);
      $2.each(splitAndTrim(options2.params.additionalfields || options2.element.name), function(i, fieldName) {
        var paramName = appendModelPrefix(fieldName, prefix);
        value3.data[paramName] = function() {
          var field = $2(options2.form).find(":input").filter("[name='" + escapeAttributeValue(paramName) + "']");
          return field.is(":checkbox") ? field.filter(":checked").val() || field.filter(":hidden").val() || "" : field.is(":radio") ? field.filter(":checked").val() || "" : field.val();
        };
      }), setValidationValues(options2, "remote", value3);
    }), adapters.add("password", ["min", "nonalphamin", "regex"], function(options2) {
      options2.params.min && setValidationValues(options2, "minlength", options2.params.min), options2.params.nonalphamin && setValidationValues(options2, "nonalphamin", options2.params.nonalphamin), options2.params.regex && setValidationValues(options2, "regex", options2.params.regex);
    }), adapters.add("fileextensions", ["extensions"], function(options2) {
      setValidationValues(options2, "extension", options2.params.extensions);
    }), $2(function() {
      $jQval.unobtrusive.parse(document);
    }), $jQval.unobtrusive;
  });
})(jquery_validate_unobtrusive);
(function($2) {
  var data_click = "unobtrusiveAjaxClick", data_target = "unobtrusiveAjaxClickTarget", data_validation = "unobtrusiveValidation";
  function getFunction(code, argNames) {
    for (var fn2 = window, parts = (code || "").split("."); fn2 && parts.length; )
      fn2 = fn2[parts.shift()];
    return typeof fn2 == "function" ? fn2 : (argNames.push(code), Function.constructor.apply(null, argNames));
  }
  __name(getFunction, "getFunction");
  function isMethodProxySafe(method) {
    return method === "GET" || method === "POST";
  }
  __name(isMethodProxySafe, "isMethodProxySafe");
  function asyncOnBeforeSend(xhr, method) {
    isMethodProxySafe(method) || xhr.setRequestHeader("X-HTTP-Method-Override", method);
  }
  __name(asyncOnBeforeSend, "asyncOnBeforeSend");
  function asyncOnSuccess(element, data49, contentType) {
    var mode;
    contentType.indexOf("application/x-javascript") === -1 && (mode = (element.getAttribute("data-ajax-mode") || "").toUpperCase(), $2(element.getAttribute("data-ajax-update")).each(function(i, update9) {
      switch (mode) {
        case "BEFORE":
          $2(update9).prepend(data49);
          break;
        case "AFTER":
          $2(update9).append(data49);
          break;
        case "REPLACE-WITH":
          $2(update9).replaceWith(data49);
          break;
        default:
          $2(update9).html(data49);
          break;
      }
    }));
  }
  __name(asyncOnSuccess, "asyncOnSuccess");
  function asyncRequest(element, options2) {
    var confirm, loading, method, duration;
    if (confirm = element.getAttribute("data-ajax-confirm"), !(confirm && !window.confirm(confirm))) {
      loading = $2(element.getAttribute("data-ajax-loading")), duration = parseInt(element.getAttribute("data-ajax-loading-duration"), 10) || 0, $2.extend(options2, {
        type: element.getAttribute("data-ajax-method") || void 0,
        url: element.getAttribute("data-ajax-url") || void 0,
        cache: (element.getAttribute("data-ajax-cache") || "").toLowerCase() === "true",
        beforeSend: /* @__PURE__ */ __name(function(xhr) {
          var result;
          return asyncOnBeforeSend(xhr, method), result = getFunction(element.getAttribute("data-ajax-begin"), ["xhr"]).apply(element, arguments), result !== !1 && loading.show(duration), result;
        }, "beforeSend"),
        complete: /* @__PURE__ */ __name(function() {
          loading.hide(duration), getFunction(element.getAttribute("data-ajax-complete"), ["xhr", "status"]).apply(element, arguments);
        }, "complete"),
        success: /* @__PURE__ */ __name(function(data49, status, xhr) {
          asyncOnSuccess(element, data49, xhr.getResponseHeader("Content-Type") || "text/html"), getFunction(element.getAttribute("data-ajax-success"), ["data", "status", "xhr"]).apply(element, arguments);
        }, "success"),
        error: /* @__PURE__ */ __name(function() {
          getFunction(element.getAttribute("data-ajax-failure"), ["xhr", "status", "error"]).apply(element, arguments);
        }, "error")
      }), options2.data.push({ name: "X-Requested-With", value: "XMLHttpRequest" }), method = options2.type.toUpperCase(), isMethodProxySafe(method) || (options2.type = "POST", options2.data.push({ name: "X-HTTP-Method-Override", value: method }));
      var $element = $2(element);
      if ($element.is("form") && $element.attr("enctype") == "multipart/form-data") {
        var formdata = new FormData();
        $2.each(options2.data, function(i, v) {
          formdata.append(v.name, v.value);
        }), $2("input[type=file]", $element).each(function() {
          var file = this;
          $2.each(file.files, function(n2, v) {
            formdata.append(file.name, v);
          });
        }), $2.extend(options2, {
          processData: !1,
          contentType: !1,
          data: formdata
        });
      }
      $2.ajax(options2);
    }
  }
  __name(asyncRequest, "asyncRequest");
  function validate6(form2) {
    var validationInfo = $2(form2).data(data_validation);
    return !validationInfo || !validationInfo.validate || validationInfo.validate();
  }
  __name(validate6, "validate"), $2(document).on("click", "a[data-ajax=true]", function(evt) {
    evt.preventDefault(), asyncRequest(this, {
      url: this.href,
      type: "GET",
      data: []
    });
  }), $2(document).on("click", "form[data-ajax=true] input[type=image]", function(evt) {
    var name2 = evt.target.name, target2 = $2(evt.target), form2 = $2(target2.parents("form")[0]), offset3 = target2.offset();
    form2.data(data_click, [
      { name: name2 + ".x", value: Math.round(evt.pageX - offset3.left) },
      { name: name2 + ".y", value: Math.round(evt.pageY - offset3.top) }
    ]), setTimeout(function() {
      form2.removeData(data_click);
    }, 0);
  }), $2(document).on("click", "form[data-ajax=true] :submit", function(evt) {
    var name2 = evt.currentTarget.name, target2 = $2(evt.target), form2 = $2(target2.parents("form")[0]);
    form2.data(data_click, name2 ? [{ name: name2, value: evt.currentTarget.value }] : []), form2.data(data_target, target2), setTimeout(function() {
      form2.removeData(data_click), form2.removeData(data_target);
    }, 0);
  }), $2(document).on("submit", "form[data-ajax=true]", function(evt) {
    var clickInfo = $2(this).data(data_click) || [], clickTarget = $2(this).data(data_target), isCancel = clickTarget && (clickTarget.hasClass("cancel") || clickTarget.attr("formnovalidate") !== void 0);
    evt.preventDefault(), !(!isCancel && !validate6(this)) && asyncRequest(this, {
      url: this.action,
      type: this.method || "GET",
      data: clickInfo.concat($2(this).serializeArray())
    });
  });
})(jQuery);
/*!
 * mustache.js - Logic-less {{mustache}} templates with JavaScript
 * http://github.com/janl/mustache.js
 */
var objectToString = Object.prototype.toString, isArray$2 = Array.isArray || /* @__PURE__ */ __name(function(object) {
  return objectToString.call(object) === "[object Array]";
}, "isArrayPolyfill");
function isFunction$2(object) {
  return typeof object == "function";
}
__name(isFunction$2, "isFunction$2");
function typeStr(obj2) {
  return isArray$2(obj2) ? "array" : typeof obj2;
}
__name(typeStr, "typeStr");
function escapeRegExp$2(string) {
  return string.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&");
}
__name(escapeRegExp$2, "escapeRegExp$2");
function hasProperty(obj2, propName) {
  return obj2 != null && typeof obj2 == "object" && propName in obj2;
}
__name(hasProperty, "hasProperty");
function primitiveHasOwnProperty(primitive, propName) {
  return primitive != null && typeof primitive != "object" && primitive.hasOwnProperty && primitive.hasOwnProperty(propName);
}
__name(primitiveHasOwnProperty, "primitiveHasOwnProperty");
var regExpTest = RegExp.prototype.test;
function testRegExp(re2, string) {
  return regExpTest.call(re2, string);
}
__name(testRegExp, "testRegExp");
var nonSpaceRe = /\S/;
function isWhitespace$1(string) {
  return !testRegExp(nonSpaceRe, string);
}
__name(isWhitespace$1, "isWhitespace$1");
var entityMap = {
  "&": "&amp;",
  "<": "&lt;",
  ">": "&gt;",
  '"': "&quot;",
  "'": "&#39;",
  "/": "&#x2F;",
  "`": "&#x60;",
  "=": "&#x3D;"
};
function escapeHtml(string) {
  return String(string).replace(/[&<>"'`=\/]/g, /* @__PURE__ */ __name(function(s2) {
    return entityMap[s2];
  }, "fromEntityMap"));
}
__name(escapeHtml, "escapeHtml");
var whiteRe = /\s*/, spaceRe = /\s+/, equalsRe = /\s*=/, curlyRe = /\s*\}/, tagRe = /#|\^|\/|>|\{|&|=|!/;
function parseTemplate(template2, tags2) {
  if (!template2)
    return [];
  var lineHasNonSpace = !1, sections = [], tokens = [], spaces = [], hasTag = !1, nonSpace = !1, indentation = "", tagIndex = 0;
  function stripSpace() {
    if (hasTag && !nonSpace)
      for (; spaces.length; )
        delete tokens[spaces.pop()];
    else
      spaces = [];
    hasTag = !1, nonSpace = !1;
  }
  __name(stripSpace, "stripSpace");
  var openingTagRe, closingTagRe, closingCurlyRe;
  function compileTags(tagsToCompile) {
    if (typeof tagsToCompile == "string" && (tagsToCompile = tagsToCompile.split(spaceRe, 2)), !isArray$2(tagsToCompile) || tagsToCompile.length !== 2)
      throw new Error("Invalid tags: " + tagsToCompile);
    openingTagRe = new RegExp(escapeRegExp$2(tagsToCompile[0]) + "\\s*"), closingTagRe = new RegExp("\\s*" + escapeRegExp$2(tagsToCompile[1])), closingCurlyRe = new RegExp("\\s*" + escapeRegExp$2("}" + tagsToCompile[1]));
  }
  __name(compileTags, "compileTags"), compileTags(tags2 || mustache.tags);
  for (var scanner = new Scanner(template2), start3, type2, value3, chr2, token, openSection; !scanner.eos(); ) {
    if (start3 = scanner.pos, value3 = scanner.scanUntil(openingTagRe), value3)
      for (var i = 0, valueLength = value3.length; i < valueLength; ++i)
        chr2 = value3.charAt(i), isWhitespace$1(chr2) ? (spaces.push(tokens.length), indentation += chr2) : (nonSpace = !0, lineHasNonSpace = !0, indentation += " "), tokens.push(["text", chr2, start3, start3 + 1]), start3 += 1, chr2 === `
` && (stripSpace(), indentation = "", tagIndex = 0, lineHasNonSpace = !1);
    if (!scanner.scan(openingTagRe))
      break;
    if (hasTag = !0, type2 = scanner.scan(tagRe) || "name", scanner.scan(whiteRe), type2 === "=" ? (value3 = scanner.scanUntil(equalsRe), scanner.scan(equalsRe), scanner.scanUntil(closingTagRe)) : type2 === "{" ? (value3 = scanner.scanUntil(closingCurlyRe), scanner.scan(curlyRe), scanner.scanUntil(closingTagRe), type2 = "&") : value3 = scanner.scanUntil(closingTagRe), !scanner.scan(closingTagRe))
      throw new Error("Unclosed tag at " + scanner.pos);
    if (type2 == ">" ? token = [type2, value3, start3, scanner.pos, indentation, tagIndex, lineHasNonSpace] : token = [type2, value3, start3, scanner.pos], tagIndex++, tokens.push(token), type2 === "#" || type2 === "^")
      sections.push(token);
    else if (type2 === "/") {
      if (openSection = sections.pop(), !openSection)
        throw new Error('Unopened section "' + value3 + '" at ' + start3);
      if (openSection[1] !== value3)
        throw new Error('Unclosed section "' + openSection[1] + '" at ' + start3);
    } else type2 === "name" || type2 === "{" || type2 === "&" ? nonSpace = !0 : type2 === "=" && compileTags(value3);
  }
  if (stripSpace(), openSection = sections.pop(), openSection)
    throw new Error('Unclosed section "' + openSection[1] + '" at ' + scanner.pos);
  return nestTokens(squashTokens(tokens));
}
__name(parseTemplate, "parseTemplate");
function squashTokens(tokens) {
  for (var squashedTokens = [], token, lastToken, i = 0, numTokens = tokens.length; i < numTokens; ++i)
    token = tokens[i], token && (token[0] === "text" && lastToken && lastToken[0] === "text" ? (lastToken[1] += token[1], lastToken[3] = token[3]) : (squashedTokens.push(token), lastToken = token));
  return squashedTokens;
}
__name(squashTokens, "squashTokens");
function nestTokens(tokens) {
  for (var nestedTokens = [], collector = nestedTokens, sections = [], token, section, i = 0, numTokens = tokens.length; i < numTokens; ++i)
    switch (token = tokens[i], token[0]) {
      case "#":
      case "^":
        collector.push(token), sections.push(token), collector = token[4] = [];
        break;
      case "/":
        section = sections.pop(), section[5] = token[2], collector = sections.length > 0 ? sections[sections.length - 1][4] : nestedTokens;
        break;
      default:
        collector.push(token);
    }
  return nestedTokens;
}
__name(nestTokens, "nestTokens");
function Scanner(string) {
  this.string = string, this.tail = string, this.pos = 0;
}
__name(Scanner, "Scanner");
Scanner.prototype.eos = /* @__PURE__ */ __name(function() {
  return this.tail === "";
}, "eos");
Scanner.prototype.scan = /* @__PURE__ */ __name(function(re2) {
  var match3 = this.tail.match(re2);
  if (!match3 || match3.index !== 0)
    return "";
  var string = match3[0];
  return this.tail = this.tail.substring(string.length), this.pos += string.length, string;
}, "scan");
Scanner.prototype.scanUntil = /* @__PURE__ */ __name(function(re2) {
  var index3 = this.tail.search(re2), match3;
  switch (index3) {
    case -1:
      match3 = this.tail, this.tail = "";
      break;
    case 0:
      match3 = "";
      break;
    default:
      match3 = this.tail.substring(0, index3), this.tail = this.tail.substring(index3);
  }
  return this.pos += match3.length, match3;
}, "scanUntil");
function Context(view, parentContext) {
  this.view = view, this.cache = { ".": this.view }, this.parent = parentContext;
}
__name(Context, "Context");
Context.prototype.push = /* @__PURE__ */ __name(function(view) {
  return new Context(view, this);
}, "push");
Context.prototype.lookup = /* @__PURE__ */ __name(function(name2) {
  var cache = this.cache, value3;
  if (cache.hasOwnProperty(name2))
    value3 = cache[name2];
  else {
    for (var context7 = this, intermediateValue, names, index3, lookupHit = !1; context7; ) {
      if (name2.indexOf(".") > 0)
        for (intermediateValue = context7.view, names = name2.split("."), index3 = 0; intermediateValue != null && index3 < names.length; )
          index3 === names.length - 1 && (lookupHit = hasProperty(intermediateValue, names[index3]) || primitiveHasOwnProperty(intermediateValue, names[index3])), intermediateValue = intermediateValue[names[index3++]];
      else
        intermediateValue = context7.view[name2], lookupHit = hasProperty(context7.view, name2);
      if (lookupHit) {
        value3 = intermediateValue;
        break;
      }
      context7 = context7.parent;
    }
    cache[name2] = value3;
  }
  return isFunction$2(value3) && (value3 = value3.call(this.view)), value3;
}, "lookup");
function Writer() {
  this.templateCache = {
    _cache: {},
    set: /* @__PURE__ */ __name(function(key, value3) {
      this._cache[key] = value3;
    }, "set"),
    get: /* @__PURE__ */ __name(function(key) {
      return this._cache[key];
    }, "get"),
    clear: /* @__PURE__ */ __name(function() {
      this._cache = {};
    }, "clear")
  };
}
__name(Writer, "Writer");
Writer.prototype.clearCache = /* @__PURE__ */ __name(function() {
  typeof this.templateCache < "u" && this.templateCache.clear();
}, "clearCache");
Writer.prototype.parse = /* @__PURE__ */ __name(function(template2, tags2) {
  var cache = this.templateCache, cacheKey = template2 + ":" + (tags2 || mustache.tags).join(":"), isCacheEnabled = typeof cache < "u", tokens = isCacheEnabled ? cache.get(cacheKey) : void 0;
  return tokens == null && (tokens = parseTemplate(template2, tags2), isCacheEnabled && cache.set(cacheKey, tokens)), tokens;
}, "parse");
Writer.prototype.render = /* @__PURE__ */ __name(function(template2, view, partials, config2) {
  var tags2 = this.getConfigTags(config2), tokens = this.parse(template2, tags2), context7 = view instanceof Context ? view : new Context(view, void 0);
  return this.renderTokens(tokens, context7, partials, template2, config2);
}, "render");
Writer.prototype.renderTokens = /* @__PURE__ */ __name(function(tokens, context7, partials, originalTemplate, config2) {
  for (var buffer = "", token, symbol, value3, i = 0, numTokens = tokens.length; i < numTokens; ++i)
    value3 = void 0, token = tokens[i], symbol = token[0], symbol === "#" ? value3 = this.renderSection(token, context7, partials, originalTemplate, config2) : symbol === "^" ? value3 = this.renderInverted(token, context7, partials, originalTemplate, config2) : symbol === ">" ? value3 = this.renderPartial(token, context7, partials, config2) : symbol === "&" ? value3 = this.unescapedValue(token, context7) : symbol === "name" ? value3 = this.escapedValue(token, context7, config2) : symbol === "text" && (value3 = this.rawValue(token)), value3 !== void 0 && (buffer += value3);
  return buffer;
}, "renderTokens");
Writer.prototype.renderSection = /* @__PURE__ */ __name(function(token, context7, partials, originalTemplate, config2) {
  var self2 = this, buffer = "", value3 = context7.lookup(token[1]);
  function subRender(template2) {
    return self2.render(template2, context7, partials, config2);
  }
  if (__name(subRender, "subRender"), !!value3) {
    if (isArray$2(value3))
      for (var j = 0, valueLength = value3.length; j < valueLength; ++j)
        buffer += this.renderTokens(token[4], context7.push(value3[j]), partials, originalTemplate, config2);
    else if (typeof value3 == "object" || typeof value3 == "string" || typeof value3 == "number")
      buffer += this.renderTokens(token[4], context7.push(value3), partials, originalTemplate, config2);
    else if (isFunction$2(value3)) {
      if (typeof originalTemplate != "string")
        throw new Error("Cannot use higher-order sections without the original template");
      value3 = value3.call(context7.view, originalTemplate.slice(token[3], token[5]), subRender), value3 != null && (buffer += value3);
    } else
      buffer += this.renderTokens(token[4], context7, partials, originalTemplate, config2);
    return buffer;
  }
}, "renderSection");
Writer.prototype.renderInverted = /* @__PURE__ */ __name(function(token, context7, partials, originalTemplate, config2) {
  var value3 = context7.lookup(token[1]);
  if (!value3 || isArray$2(value3) && value3.length === 0)
    return this.renderTokens(token[4], context7, partials, originalTemplate, config2);
}, "renderInverted");
Writer.prototype.indentPartial = /* @__PURE__ */ __name(function(partial2, indentation, lineHasNonSpace) {
  for (var filteredIndentation = indentation.replace(/[^ \t]/g, ""), partialByNl = partial2.split(`
`), i = 0; i < partialByNl.length; i++)
    partialByNl[i].length && (i > 0 || !lineHasNonSpace) && (partialByNl[i] = filteredIndentation + partialByNl[i]);
  return partialByNl.join(`
`);
}, "indentPartial");
Writer.prototype.renderPartial = /* @__PURE__ */ __name(function(token, context7, partials, config2) {
  if (partials) {
    var tags2 = this.getConfigTags(config2), value3 = isFunction$2(partials) ? partials(token[1]) : partials[token[1]];
    if (value3 != null) {
      var lineHasNonSpace = token[6], tagIndex = token[5], indentation = token[4], indentedValue = value3;
      tagIndex == 0 && indentation && (indentedValue = this.indentPartial(value3, indentation, lineHasNonSpace));
      var tokens = this.parse(indentedValue, tags2);
      return this.renderTokens(tokens, context7, partials, indentedValue, config2);
    }
  }
}, "renderPartial");
Writer.prototype.unescapedValue = /* @__PURE__ */ __name(function(token, context7) {
  var value3 = context7.lookup(token[1]);
  if (value3 != null)
    return value3;
}, "unescapedValue");
Writer.prototype.escapedValue = /* @__PURE__ */ __name(function(token, context7, config2) {
  var escape2 = this.getConfigEscape(config2) || mustache.escape, value3 = context7.lookup(token[1]);
  if (value3 != null)
    return typeof value3 == "number" && escape2 === mustache.escape ? String(value3) : escape2(value3);
}, "escapedValue");
Writer.prototype.rawValue = /* @__PURE__ */ __name(function(token) {
  return token[1];
}, "rawValue");
Writer.prototype.getConfigTags = /* @__PURE__ */ __name(function(config2) {
  return isArray$2(config2) ? config2 : config2 && typeof config2 == "object" ? config2.tags : void 0;
}, "getConfigTags");
Writer.prototype.getConfigEscape = /* @__PURE__ */ __name(function(config2) {
  if (config2 && typeof config2 == "object" && !isArray$2(config2))
    return config2.escape;
}, "getConfigEscape");
var mustache = {
  name: "mustache.js",
  version: "4.2.0",
  tags: ["{{", "}}"],
  clearCache: void 0,
  escape: void 0,
  parse: void 0,
  render: void 0,
  Scanner: void 0,
  Context: void 0,
  Writer: void 0,
  /**
   * Allows a user to override the default caching strategy, by providing an
   * object with set, get and clear methods. This can also be used to disable
   * the cache by setting it to the literal `undefined`.
   */
  set templateCache(cache) {
    defaultWriter.templateCache = cache;
  },
  /**
   * Gets the default or overridden caching object from the default writer.
   */
  get templateCache() {
    return defaultWriter.templateCache;
  }
}, defaultWriter = new Writer();
mustache.clearCache = /* @__PURE__ */ __name(function() {
  return defaultWriter.clearCache();
}, "clearCache");
mustache.parse = /* @__PURE__ */ __name(function(template2, tags2) {
  return defaultWriter.parse(template2, tags2);
}, "parse");
mustache.render = /* @__PURE__ */ __name(function(template2, view, partials, config2) {
  if (typeof template2 != "string")
    throw new TypeError('Invalid template! Template should be a "string" but "' + typeStr(template2) + '" was given as the first argument for mustache#render(template, view, partials)');
  return defaultWriter.render(template2, view, partials, config2);
}, "render");
mustache.escape = escapeHtml;
mustache.Scanner = Scanner;
mustache.Context = Context;
mustache.Writer = Writer;
function range$1(start3, end2, step = 1) {
  let r2 = [];
  for (let i = start3; i <= end2; i += step)
    r2.push(i);
  return r2;
}
__name(range$1, "range$1");
const _Range = class _Range {
  constructor(start3, end2, step = 1) {
    return this.start = start3, this.end = end2, this.step = step, new Proxy(this, {
      get: /* @__PURE__ */ __name(function(target2, prop2) {
        let i = typeof prop2 == "string" ? parseInt(prop2) : prop2;
        return typeof i == "number" && i >= 0 && i <= target2.length ? target2.start + target2.step * i : Reflect.get(...arguments);
      }, "get")
    });
  }
  get length() {
    return parseInt((this.end - this.start) / this.step) + 1;
  }
  [Symbol.iterator]() {
    var index3 = -1;
    return {
      next: /* @__PURE__ */ __name(() => ({ value: this[++index3], done: this[index3 + 1] === void 0 }), "next")
    };
  }
};
__name(_Range, "Range");
let Range = _Range;
function getValue$1(params, key) {
  let keys3 = key.split("."), value3 = params;
  for (let k of keys3)
    value3 = value3[k];
  return value3;
}
__name(getValue$1, "getValue$1");
function format$2(str2, params) {
  let re2 = /\{\{\S+\}\}/gm, m;
  for (; (m = re2.exec(str2)) !== null; ) {
    let key = m[0].substring(2, m[0].length - 2), value3 = getValue$1(params, key);
    str2 = str2.substr(0, m.index) + value3 + str2.substr(m.index + m[0].length), re2.lastIndex = m.index;
  }
  return str2;
}
__name(format$2, "format$2");
function genItems$1(min2, max2, genText2 = (value3) => value3 + "", genAltText = (value3) => value3 + "") {
  let res = [];
  for (let i of new Range(min2, max2)) {
    let item = {};
    item.text = genText2(i), item.alt = genAltText(i), item.value = i, res.push(item);
  }
  return res;
}
__name(genItems$1, "genItems$1");
function pad$1(n2, width) {
  return n2 = n2 + "", n2.length < width ? new Array(width - n2.length).fill("0").join("") + n2 : n2;
}
__name(pad$1, "pad$1");
function isObject$4(value3) {
  return value3 && typeof value3 == "object" && !Array.isArray(value3);
}
__name(isObject$4, "isObject$4");
function deepMerge(target2, ...sources2) {
  if (!isObject$4(target2) || sources2.length == 0) return;
  let source2 = sources2.shift();
  if (isObject$4(source2))
    for (let [key, value3] of Object.entries(source2))
      isObject$4(value3) ? (isObject$4(target2[key]) || (target2[key] = {}), deepMerge(target2[key], source2[key])) : target2[key] = source2[key];
  return sources2.length > 0 && deepMerge(target2, sources2), target2;
}
__name(deepMerge, "deepMerge");
function traverse$1(obj2, ...keys3) {
  if (keys3.length == 0)
    return obj2;
  for (let key of keys3[0])
    if (obj2.hasOwnProperty(key)) {
      let res = traverse$1(obj2[key], ...keys3.slice(1));
      if (res !== void 0)
        return res;
    }
}
__name(traverse$1, "traverse$1");
var util = {
  range: range$1,
  Range,
  format: format$2,
  genItems: genItems$1,
  pad: pad$1,
  deepMerge,
  isObject: isObject$4,
  traverse: traverse$1
}, en$1 = {
  eachPeriod: {
    eachField: {
      empty: "every {{field.id}}",
      value: "{{value.text}}",
      range: "{{start.text}}-{{end.text}}",
      everyX: "every {{every.value}} {{field.id}}(s)",
      everyAt: "every {{every.value}} {{field.id}}(s), starting at {{at.value}} {{field.id}}(s)"
    },
    monthField: {
      prefix: "in",
      value: "{{value.alt}}",
      range: "{{start.alt}}-{{end.alt}}",
      everyAt: "every {{every.value}} {{field.id}}(s), starting in {{at.alt}}"
    },
    dayField: {
      prefix: "on",
      everyAt: "every {{every.value}} {{field.id}}(s), starting on the {{at.alt}} of the month"
    },
    dayOfWeekField: {
      prefix: "on",
      empty: "every day of the week",
      value: "{{value.alt}}",
      range: "{{start.alt}}-{{end.alt}}",
      everyX: "every {{every.value}} day(s) of the week",
      everyAt: "every {{every.value}} day(s) of the week, starting on {{at.alt}}"
    },
    hourField: {
      prefix: "at"
    },
    minuteField: {
      prefix: ":"
    }
  },
  hourPeriod: {
    minuteField: {
      prefix: "at"
    }
  },
  monthPeriod: {
    dayOfWeekField: {
      prefix: "and"
    }
  },
  yearPeriod: {
    dayOfWeekField: {
      prefix: "and"
    }
  },
  periodPrefix: "Every",
  periodSuffix: ""
};
const { genItems, pad: pad$2, traverse: traverse$2 } = util, locales = {
  en: en$1
};
function getLocale$1(locale2) {
  return locales.hasOwnProperty(locale2) ? locales[locale2] : locales.en;
}
__name(getLocale$1, "getLocale$1");
function getLocaleOrdinalSuffix(locale2, value3) {
  const ordRules = new Intl.PluralRules(locale2, { type: "ordinal" }), suffixes = {
    one: "st",
    two: "nd",
    few: "rd",
    other: "th"
  }, category = ordRules.select(value3), suffix = suffixes[category];
  return value3 + suffix;
}
__name(getLocaleOrdinalSuffix, "getLocaleOrdinalSuffix");
function defaultItems$1(locale2) {
  return {
    minuteItems: genItems(0, 59, (value3) => pad$2(value3, 2)),
    hourItems: genItems(0, 23, (value3) => pad$2(value3, 2)),
    dayItems: genItems(
      1,
      31,
      (value3) => value3 + "",
      (value3) => getLocaleOrdinalSuffix(locale2, value3)
    ),
    monthItems: genItems(1, 12, (value3) => new Date(2021, value3 - 1, 1).toLocaleDateString(locale2, { month: "long" }), (value3) => new Date(2021, value3 - 1, 1).toLocaleDateString(locale2, { month: "short" })),
    dayOfWeekItems: genItems(0, 6, (value3) => new Date(2021, 0, 3 + value3).toLocaleDateString(locale2, { weekday: "long" }), (value3) => new Date(2021, 0, 3 + value3).toLocaleDateString(locale2, { weekday: "short" }))
  };
}
__name(defaultItems$1, "defaultItems$1");
var locale$2 = {
  getLocaleStr: /* @__PURE__ */ __name((locale2, periodId, fieldId, localeKey) => traverse$2(locale2, [periodId + "Period", "eachPeriod"], [fieldId + "Field", "eachField"], [localeKey]) || "", "getLocaleStr"),
  getPrefix: /* @__PURE__ */ __name((locale2, periodId, fieldId) => traverse$2(locale2, [periodId + "Period", "eachPeriod"], [fieldId + "Field", "eachField"], ["prefix"]) || "", "getPrefix"),
  getSuffix: /* @__PURE__ */ __name((locale2, periodId, fieldId) => traverse$2(locale2, [periodId + "Period", "eachPeriod"], [fieldId + "Field", "eachField"], ["suffix"]) || "", "getSuffix"),
  defaultItems: defaultItems$1,
  getLocale: getLocale$1
};
const { getLocaleStr } = locale$2, _Field$1 = class _Field$1 {
  /**
   *
   * @param {String} name
   * @param {Array} items
   */
  constructor(id2, items3) {
    this.id = id2, this.items = items3, this.itemMap = this.items.reduce((acc, item) => (acc[item.value] = item, acc), {});
  }
  get min() {
    return this.items[0].value;
  }
  get max() {
    return this.items[this.items.length - 1].value;
  }
  getItem(value3) {
    return this.itemMap[value3];
  }
};
__name(_Field$1, "Field$1");
let Field$1 = _Field$1;
const _CronColumn = class _CronColumn {
  /**
   *
   * @param {Field} field
   */
  constructor(field) {
    this.field = field;
  }
  get localeKey() {
    return "value";
  }
  get localeParams() {
    return {};
  }
  get value() {
    return "*";
  }
  getText(locale2, periodId) {
    let str2 = getLocaleStr(locale2, periodId, this.field.id, this.localeKey), params = this.populate(this.localeParams);
    return mustache.render(str2, params);
  }
  getItem(value3) {
    return this.field.getItem(value3);
  }
  populate(obj2) {
    for (const [key, itemValue] of Object.entries(obj2))
      obj2[key] = this.getItem(itemValue);
    return obj2.field = this.field, obj2;
  }
};
__name(_CronColumn, "CronColumn");
let CronColumn = _CronColumn;
const _AnyColumn$1 = class _AnyColumn$1 extends CronColumn {
  get localeKey() {
    return "empty";
  }
  get value() {
    return "*";
  }
};
__name(_AnyColumn$1, "AnyColumn$1");
let AnyColumn$1 = _AnyColumn$1;
const _RangeColumn$1 = class _RangeColumn$1 extends CronColumn {
  constructor(field, start3, end2) {
    super(field), this.start = start3, this.end = end2;
  }
  get localeKey() {
    return "range";
  }
  get localeParams() {
    return {
      start: this.start,
      end: this.end
    };
  }
  get value() {
    return `${this.start}-${this.end}`;
  }
};
__name(_RangeColumn$1, "RangeColumn$1");
let RangeColumn$1 = _RangeColumn$1;
const _EveryColumn$1 = class _EveryColumn$1 extends CronColumn {
  constructor(field, every2) {
    super(field), this.every = every2;
  }
  get localeKey() {
    return "everyX";
  }
  get localeParams() {
    return {
      every: this.every
    };
  }
  get value() {
    return `*/${this.every}`;
  }
};
__name(_EveryColumn$1, "EveryColumn$1");
let EveryColumn$1 = _EveryColumn$1;
const _EveryAtColumn$1 = class _EveryAtColumn$1 extends CronColumn {
  constructor(field, every2, at) {
    super(field), this.every = every2, this.at = at;
  }
  get localeKey() {
    return "everyAt";
  }
  get localeParams() {
    return {
      every: this.every,
      at: this.at
    };
  }
  get value() {
    return `${this.at}/${this.every}`;
  }
};
__name(_EveryAtColumn$1, "EveryAtColumn$1");
let EveryAtColumn$1 = _EveryAtColumn$1;
const _ValueColumn$2 = class _ValueColumn$2 extends CronColumn {
  constructor(field, value3) {
    super(field), this.v = value3;
  }
  get localeKey() {
    return "value";
  }
  get localeParams() {
    return {
      value: this.v
    };
  }
  get value() {
    return "" + this.v;
  }
};
__name(_ValueColumn$2, "ValueColumn$2");
let ValueColumn$2 = _ValueColumn$2;
const _CombinedColumn$2 = class _CombinedColumn$2 extends CronColumn {
  constructor(field, columns = []) {
    super(field), this.columns = columns;
  }
  addColumn(cronColumn) {
    this.columns.push(cronColumn);
  }
  get value() {
    return this.columns.map((c) => c.value).join(",");
  }
  getText(locale2, periodId) {
    return this.columns.map((c) => c.getText(locale2, periodId)).join(",");
  }
};
__name(_CombinedColumn$2, "CombinedColumn$2");
let CombinedColumn$2 = _CombinedColumn$2;
var types = {
  Field: Field$1,
  AnyColumn: AnyColumn$1,
  RangeColumn: RangeColumn$1,
  ValueColumn: ValueColumn$2,
  EveryColumn: EveryColumn$1,
  EveryAtColumn: EveryAtColumn$1,
  CombinedColumn: CombinedColumn$2
};
const { AnyColumn } = types;
function strToArray$4(str2) {
  return str2 != "*" ? null : [];
}
__name(strToArray$4, "strToArray$4");
function arrayToStr$4(arr, field) {
  let { items: items3 } = field;
  if (arr.length == 0)
    return new AnyColumn(field);
  if (arr.length != items3.length)
    return null;
  for (let item of items3)
    if (!arr.includes(item.value))
      return null;
  return new AnyColumn(field);
}
__name(arrayToStr$4, "arrayToStr$4");
var any = {
  strToArray: strToArray$4,
  arrayToStr: arrayToStr$4
};
const { EveryColumn } = types;
let re$2 = /^\*\/\d+$/;
function strToArray$3(str2, { min: min2, max: max2 }) {
  if (!re$2.test(str2))
    return null;
  let [, everyStr] = str2.split("/"), every2 = parseInt(everyStr), start3 = every2 * parseInt(min2 / every2), res = [];
  for (let i = start3; i <= max2; i += every2)
    i >= min2 && res.push(i);
  return res.length > 0 ? res : null;
}
__name(strToArray$3, "strToArray$3");
function arrayToStr$3(arr, field) {
  let { min: min2, max: max2 } = field;
  if (arr.length < 3)
    return null;
  let step = arr[1] - arr[0];
  if (step <= 1)
    return null;
  let first2 = min2 % step == 0 ? min2 : (parseInt(min2 / step) + 1) * step;
  if (arr.length != parseInt((max2 - first2) / step) + 1)
    return null;
  for (let value3 of arr)
    if (value3 % step != 0)
      return null;
  return new EveryColumn(field, step);
}
__name(arrayToStr$3, "arrayToStr$3");
var every = {
  strToArray: strToArray$3,
  arrayToStr: arrayToStr$3
};
const { EveryAtColumn } = types;
let re$1 = /^\d+\/\d+$/;
function buildArray(min2, max2, at, every2) {
  let res = [];
  for (let i = at; i <= max2; i += every2)
    i >= min2 && res.push(i);
  return res.length > 0 ? res : null;
}
__name(buildArray, "buildArray");
function strToArray$2(str2, { min: min2, max: max2 }) {
  if (!re$1.test(str2))
    return null;
  let [atStr, everyStr] = str2.split("/"), at = parseInt(atStr), every2 = parseInt(everyStr);
  return buildArray(min2, max2, at, every2);
}
__name(strToArray$2, "strToArray$2");
function arrayToStr$2(arr, field) {
  let { min: min2, max: max2 } = field;
  if (arr.length < 3)
    return null;
  let at = arr[0], step = arr[1] - arr[0];
  if (step <= 1)
    return null;
  let computedArray = buildArray(min2, max2, at, step);
  return arr.length !== computedArray.length || arr.filter((i) => !computedArray.includes(i)).length > 0 ? null : new EveryAtColumn(field, step, at);
}
__name(arrayToStr$2, "arrayToStr$2");
var everyAt = {
  strToArray: strToArray$2,
  arrayToStr: arrayToStr$2
};
let { RangeColumn, CombinedColumn: CombinedColumn$1, ValueColumn: ValueColumn$1 } = types, re = /^\d+-\d+$/;
function strToArray$1(str2, { min: min2, max: max2 }) {
  if (!re.test(str2))
    return null;
  let range2 = str2.split("-"), start3 = parseInt(range2[0]), end2 = parseInt(range2[1]);
  return start3 > end2 || start3 < min2 || end2 > max2 ? null : util.range(start3, end2);
}
__name(strToArray$1, "strToArray$1");
function arrayToStr$1(arr, field) {
  let { min: min2, max: max2 } = field;
  if (arr.length <= 1)
    return null;
  let minValue = arr[0], maxValue = arr[arr.length - 1];
  if (minValue < min2 || maxValue > max2)
    return null;
  let ranges = [], start3 = 0;
  for (let i = 0; i < arr.length; i++)
    (arr[i + 1] === void 0 || arr[i + 1] - arr[i] > 1) && (i == start3 ? ranges.push(new ValueColumn$1(field, arr[start3])) : ranges.push(new RangeColumn(field, arr[start3], arr[i])), start3 = i + 1);
  return new CombinedColumn$1(field, ranges);
}
__name(arrayToStr$1, "arrayToStr$1");
var range$2 = {
  strToArray: strToArray$1,
  arrayToStr: arrayToStr$1
};
const { ValueColumn, CombinedColumn } = types;
function strToArray(str2, { min: min2, max: max2 }) {
  let number = parseInt(str2);
  return String(number) == str2 && number >= min2 && number <= max2 ? [number] : null;
}
__name(strToArray, "strToArray");
function arrayToStr(arr, field) {
  let { min: min2, max: max2 } = field;
  if (Math.min(arr) < min2 || Math.max(arr) > max2)
    return null;
  let values2 = arr.map((x) => new ValueColumn(field, x));
  return new CombinedColumn(field, values2);
}
__name(arrayToStr, "arrayToStr");
var value = {
  strToArray,
  arrayToStr
};
const _MultipleColumns = class _MultipleColumns {
  constructor(enableEveryAt) {
    this._enableEveryAt = null, this.enableEveryAt = enableEveryAt;
  }
  get enableEveryAt() {
    return this._enableEveryAt;
  }
  set enableEveryAt(value3) {
    this._enableEveryAt = !!value3;
  }
  get fieldTypes() {
    return this.enableEveryAt ? [any, every, everyAt, range$2, value] : [any, every, range$2, value];
  }
  strToArray(str2, field) {
    let fields2 = str2.split(","), res = [];
    for (let f of fields2) {
      if (f == "*")
        return [];
      let values2 = null;
      for (let fieldType of this.fieldTypes)
        if (values2 = fieldType.strToArray(f, field), values2 !== null)
          break;
      if (values2 === null)
        return null;
      res.push(...values2);
    }
    return Array.from(new Set(res));
  }
  arrayToStr(arr, field) {
    for (let fieldType of this.fieldTypes) {
      let value3 = fieldType.arrayToStr(arr, field);
      if (value3)
        return value3;
    }
    return null;
  }
};
__name(_MultipleColumns, "MultipleColumns");
let MultipleColumns = _MultipleColumns;
const { getLocale, defaultItems, getSuffix, getPrefix } = locale$2, { Field: Field$2 } = types;
var script$5 = {
  name: "VueCronCore",
  props: {
    value: {
      type: String,
      default: "* * * * *"
    },
    locale: {
      type: String,
      default: "en"
    },
    fields: {
      type: Array,
      default: /* @__PURE__ */ __name(function() {
        let items3 = defaultItems(this.locale);
        return [
          { id: "minute", items: items3.minuteItems },
          { id: "hour", items: items3.hourItems },
          { id: "day", items: items3.dayItems },
          { id: "month", items: items3.monthItems },
          { id: "dayOfWeek", items: items3.dayOfWeekItems }
        ];
      }, "default")
    },
    periods: {
      type: Array,
      default: /* @__PURE__ */ __name(() => [
        { id: "minute", text: "Minute", value: [] },
        { id: "hour", text: "Hour", value: ["minute"] },
        { id: "day", text: "Day", value: ["hour", "minute"] },
        { id: "week", text: "Week", value: ["dayOfWeek", "hour", "minute"] },
        { id: "month", text: "Month", value: ["day", "dayOfWeek", "hour", "minute"] },
        { id: "year", text: "Year", value: ["month", "day", "dayOfWeek", "hour", "minute"] }
      ], "default")
    },
    customLocale: {
      type: Object,
      default: /* @__PURE__ */ __name(function() {
        return getLocale(this.locale);
      }, "default")
    },
    mergeLocale: {
      type: Boolean,
      default: !0
    },
    enableEveryAt: {
      type: Boolean,
      default: !1
    }
  },
  data() {
    let selected = {};
    for (let field of this.fields)
      selected[field.id] = [];
    return {
      selected,
      error: "",
      selectedPeriod: this.periods[this.periods.length - 1],
      multiple: new MultipleColumns(this.enableEveryAt)
    };
  },
  computed: {
    splitValue() {
      return this.value.split(" ");
    },
    fieldIndex() {
      return this.fields.reduce((acc, f, i) => (acc[f.id] = i, acc), {});
    },
    periodIndex() {
      return this.periods.reduce((acc, p, i) => (acc[p.id] = i, acc));
    },
    computedFields() {
      return this.fields.map((f) => new Field$2(f.id, f.items));
    },
    filteredFields() {
      return this.selectedPeriod.value.map((fieldId) => {
        let i = this.fieldIndex[fieldId];
        return this.computedFields[i];
      });
    },
    computedLocale() {
      if (this.mergeLocale) {
        let defaultLocale = getLocale(this.locale);
        return util.deepMerge(defaultLocale, this.customLocale);
      } else
        return this.customLocale;
    }
  },
  watch: {
    value: {
      handler: /* @__PURE__ */ __name(function(value3) {
        this.cronToSelected(value3);
      }, "handler"),
      immediate: !0
    },
    selected: {
      handler: /* @__PURE__ */ __name(function(selected) {
        this.selectedToCron(selected);
      }, "handler"),
      deep: !0
    },
    selectedPeriod: {
      handler: /* @__PURE__ */ __name(function() {
        this.selectedToCron(this.selected);
      }, "handler")
    },
    error: {
      handler: /* @__PURE__ */ __name(function(error2) {
        this.$emit("error", error2);
      }, "handler")
    },
    enableEveryAt: {
      handler: /* @__PURE__ */ __name(function(enableEveryAt) {
        this.multiple.enableEveryAt = enableEveryAt, this.selectedToCron(this.selected);
      }, "handler")
    }
  },
  render() {
    if (!this.$scopedSlots.default)
      return;
    let fieldProps = [];
    for (let field of this.filteredFields) {
      let i = this.fieldIndex[field.id], values2 = this.selected[field.id], attrs2 = {
        value: values2
      }, events2 = {
        input: /* @__PURE__ */ ((fieldId) => (evt) => {
          const selected = Array.from(evt).sort((a2, b) => a2 > b ? 1 : -1);
          this.selected[fieldId] = selected;
        })(field.id)
      };
      fieldProps.push({
        ...field,
        cron: this.splitValue[i],
        selectedStr: this.multiple.arrayToStr(values2, field).getText(this.computedLocale, this.selectedPeriod.id),
        events: events2,
        attrs: attrs2,
        prefix: getPrefix(this.computedLocale, this.selectedPeriod.id, field.id),
        suffix: getSuffix(this.computedLocale, this.selectedPeriod.id, field.id)
      });
    }
    return this.$scopedSlots.default({
      error: this.error,
      fields: fieldProps,
      period: {
        attrs: {
          value: this.selectedPeriod.id
        },
        events: {
          input: /* @__PURE__ */ __name((periodId) => {
            let i = this.periodIndex[periodId] || 0;
            this.selectedPeriod = this.periods[i];
          }, "input")
        },
        items: this.periods,
        prefix: this.computedLocale.periodPrefix,
        suffix: this.computedLocale.periodSuffix
      }
    });
  },
  methods: {
    defaultValue() {
      return new Array(this.fields.length).fill("*").join(" ");
    },
    cronToSelected(value3) {
      if (!value3) {
        this.$emit("input", this.defaultValue());
        return;
      }
      if (this.splitValue.length != this.fields.length) {
        this.error = "invalid pattern";
        return;
      }
      for (var i = 0; i < this.splitValue.length; i++) {
        let field = this.computedFields[i];
        if (!this.selectedPeriod.value.includes(field.id))
          continue;
        let array = this.multiple.strToArray(this.splitValue[i], field);
        if (array === null) {
          this.error = "invalid pattern";
          return;
        }
        this.selected[field.id] = array;
      }
      this.error = "";
    },
    selectedToCron(selected) {
      let strings = [];
      for (let field of this.computedFields) {
        if (!this.selectedPeriod.value.includes(field.id)) {
          strings.push("*");
          continue;
        }
        let array = selected[field.id], str2 = this.multiple.arrayToStr(array, field);
        if (str2 === null) {
          this.error = "invalid selection";
          return;
        }
        strings.push(str2.value);
      }
      this.error = "", this.$emit("input", strings.join(" "));
    }
  }
};
function normalizeComponent$4(template2, style2, script2, scopeId, isFunctionalTemplate, moduleIdentifier, shadowMode, createInjector2, createInjectorSSR, createInjectorShadow) {
  const options2 = typeof script2 == "function" ? script2.options : script2;
  return template2 && template2.render && (options2.render = template2.render, options2.staticRenderFns = template2.staticRenderFns, options2._compiled = !0), script2;
}
__name(normalizeComponent$4, "normalizeComponent$4");
const __vue_script__$4 = script$5, __vue_inject_styles__$4 = void 0, __vue_component__$4 = /* @__PURE__ */ normalizeComponent$4(
  {},
  __vue_inject_styles__$4,
  __vue_script__$4
), plugin$4 = {
  component: __vue_component__$4,
  util
};
var script$1$1 = {
  inheritAttrs: !1,
  name: "CustomSelect",
  props: {
    multiple: {
      type: Boolean,
      default: !1
    },
    value: {
      type: String | Array | Object,
      default() {
        return this.multiple ? [] : null;
      }
    },
    items: {
      type: Array,
      default: /* @__PURE__ */ __name(() => [], "default")
    },
    returnObject: {
      type: Boolean,
      default: !1
    },
    itemText: {
      type: String,
      default: "text"
    },
    itemValue: {
      type: String,
      default: "value"
    },
    cols: {
      type: Number,
      default: 1
    },
    width: {
      type: String,
      default: "unset"
    }
  },
  data() {
    return {
      menu: !1
    };
  },
  computed: {
    listStyle() {
      return {
        display: this.menu ? "inline-block" : "none",
        minWidth: "5em",
        width: this.width
      };
    },
    listItemStyle() {
      return {
        width: 100 / this.cols + "%"
      };
    },
    _value() {
      return this.multiple ? this.value : [this.value];
    },
    selectedItems() {
      return this.items.filter((item) => {
        for (let value3 of this._value)
          if (this.returnObject) {
            if (value3 == item) return !0;
          } else if (value3 == item[this.itemValue]) return !0;
        return !1;
      });
    },
    selectedStr() {
      return this.selectedItems.map((item) => item[this.itemText]).join(",");
    }
  },
  methods: {
    menuEvtListener(evt) {
      this.menu = !1, document.removeEventListener("click", this.menuEvtListener);
    },
    toggleMenu() {
      this.menu = !this.menu, this.menu ? setTimeout(() => {
        document.addEventListener("click", this.menuEvtListener);
      }, 1) : document.removeEventListener("click", this.menuEvtListener);
    },
    select(item) {
      if (this.multiple) {
        let value3 = this.selectedItems.slice(), i = this.selectedItems.indexOf(item);
        i >= 0 ? value3.splice(i, 1) : value3.push(item), this.$emit("input", this.returnObject ? value3 : value3.map((item2) => item2[this.itemValue]));
      } else
        this.$emit("input", this.returnObject ? item : item[this.itemValue]);
    }
  }
};
function normalizeComponent$3(template2, style2, script2, scopeId, isFunctionalTemplate, moduleIdentifier, shadowMode, createInjector2, createInjectorSSR, createInjectorShadow) {
  const options2 = typeof script2 == "function" ? script2.options : script2;
  return template2 && template2.render && (options2.render = template2.render, options2.staticRenderFns = template2.staticRenderFns, options2._compiled = !0), script2;
}
__name(normalizeComponent$3, "normalizeComponent$3");
const __vue_script__$1$1 = script$1$1;
var __vue_render__$1$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _h = _vm.$createElement, _c = _vm._self._c || _h;
  return _c("div", { staticClass: "vcron-select-container" }, [
    _c(
      "span",
      { staticClass: "vcron-select-input", on: { click: _vm.toggleMenu } },
      [
        _vm._t("default", function() {
          return [_vm._v(_vm._s(_vm.selectedStr))];
        })
      ],
      2
    ),
    _vm._v(" "),
    _c(
      "span",
      { staticClass: "vcron-select-list", style: _vm.listStyle },
      _vm._l(_vm.items, function(item) {
        return _c(
          "span",
          {
            key: item[_vm.itemValue] + "",
            staticClass: "vcron-select-list-item",
            class: {
              "vcron-select-list-item-selected": _vm.selectedItems.includes(item)
            },
            style: _vm.listItemStyle,
            on: {
              click: [
                function($event) {
                  return _vm.select(item);
                },
                function($event) {
                  $event.stopPropagation(), _vm.multiple || _vm.toggleMenu();
                }
              ]
            }
          },
          [_vm._v(`
      
      ` + _vm._s(item[_vm.itemText]) + `
    `)]
        );
      }),
      0
    )
  ]);
}, "__vue_render__$1$1"), __vue_staticRenderFns__$1$1 = [];
__vue_render__$1$1._withStripped = !0;
const __vue_inject_styles__$1$1 = void 0, __vue_component__$1$1 = /* @__PURE__ */ normalizeComponent$3(
  { render: __vue_render__$1$1, staticRenderFns: __vue_staticRenderFns__$1$1 },
  __vue_inject_styles__$1$1,
  __vue_script__$1$1
);
var script$4 = {
  name: "VueCronEditor",
  components: {
    CronCore: plugin$4.component,
    CustomSelect: __vue_component__$1$1
  },
  props: {
    cols: {
      type: Function,
      default: /* @__PURE__ */ __name((fieldId) => fieldId == "minute" ? 5 : fieldId == "hour" || fieldId == "day" ? 4 : 1, "default")
    },
    width: {
      type: Function,
      default: /* @__PURE__ */ __name((fieldId) => fieldId == "minute" ? "10em" : fieldId == "hour" || fieldId == "day" ? "8em" : "unset", "default")
    },
    enableEveryAt: {
      type: Boolean,
      default: !1
    }
  }
};
const __vue_script__$3 = script$4;
var __vue_render__$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _h = _vm.$createElement, _c = _vm._self._c || _h;
  return _c(
    "CronCore",
    _vm._b(
      {
        attrs: { enableEveryAt: _vm.enableEveryAt },
        on: {
          input: /* @__PURE__ */ __name(function($event) {
            return _vm.$emit("input", $event);
          }, "input"),
          error: /* @__PURE__ */ __name(function($event) {
            return _vm.$emit("error", $event);
          }, "error")
        },
        scopedSlots: _vm._u([
          {
            key: "default",
            fn: /* @__PURE__ */ __name(function(ref2) {
              var fields2 = ref2.fields, period = ref2.period;
              return [
                _c(
                  "span",
                  { staticClass: "vcron-editor" },
                  [
                    _c("span", [_vm._v(_vm._s(period.prefix))]),
                    _vm._v(" "),
                    _c(
                      "custom-select",
                      _vm._g(
                        _vm._b(
                          {
                            attrs: {
                              items: period.items,
                              "item-value": "id",
                              cols: _vm.cols("period"),
                              width: _vm.width("period")
                            }
                          },
                          "custom-select",
                          period.attrs,
                          !1
                        ),
                        period.events
                      )
                    ),
                    _vm._v(" "),
                    _c("span", [_vm._v(_vm._s(period.suffix))]),
                    _vm._v(" "),
                    _vm._l(fields2, function(f) {
                      return [
                        _c("span", { key: f.id + "prefix" }, [
                          _vm._v(_vm._s(f.prefix))
                        ]),
                        _vm._v(" "),
                        _c(
                          "custom-select",
                          _vm._g(
                            _vm._b(
                              {
                                key: f.id,
                                attrs: {
                                  items: f.items,
                                  cols: _vm.cols(f.id),
                                  width: _vm.width(f.id),
                                  multiple: ""
                                }
                              },
                              "custom-select",
                              f.attrs,
                              !1
                            ),
                            f.events
                          ),
                          [_vm._v(_vm._s(f.selectedStr))]
                        ),
                        _vm._v(" "),
                        _c("span", { key: f.id + "suffix" }, [
                          _vm._v(_vm._s(f.suffix))
                        ])
                      ];
                    })
                  ],
                  2
                )
              ];
            }, "fn")
          }
        ])
      },
      "CronCore",
      _vm.$attrs,
      !1
    )
  );
}, "__vue_render__$3"), __vue_staticRenderFns__$3 = [];
__vue_render__$3._withStripped = !0;
const __vue_inject_styles__$3 = void 0, __vue_component__$3 = /* @__PURE__ */ normalizeComponent$3(
  { render: __vue_render__$3, staticRenderFns: __vue_staticRenderFns__$3 },
  __vue_inject_styles__$3,
  __vue_script__$3
);
function install$5(Vue2) {
  install$5.installed || (install$5.installed = !0, Vue2.component("CronLight", __vue_component__$3));
}
__name(install$5, "install$5");
const plugin$3 = {
  install: install$5,
  component: __vue_component__$3,
  util: plugin$4.util
};
var bootstrap = { exports: {} };
const require$$1 = /* @__PURE__ */ getAugmentedNamespace(popper$1);
/*!
  * Bootstrap v4.6.2 (https://getbootstrap.com/)
  * Copyright 2011-2022 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)
  * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
  */
(function(module2, exports) {
  (function(global2, factory2) {
    factory2(exports, requireJquery(), require$$1);
  })(commonjsGlobal, function(exports2, $2, Popper2) {
    function _interopDefaultLegacy(e2) {
      return e2 && typeof e2 == "object" && "default" in e2 ? e2 : { default: e2 };
    }
    __name(_interopDefaultLegacy, "_interopDefaultLegacy");
    var $__default = /* @__PURE__ */ _interopDefaultLegacy($2), Popper__default = /* @__PURE__ */ _interopDefaultLegacy(Popper2);
    function _defineProperties2(target2, props2) {
      for (var i = 0; i < props2.length; i++) {
        var descriptor = props2[i];
        descriptor.enumerable = descriptor.enumerable || !1, descriptor.configurable = !0, "value" in descriptor && (descriptor.writable = !0), Object.defineProperty(target2, descriptor.key, descriptor);
      }
    }
    __name(_defineProperties2, "_defineProperties");
    function _createClass2(Constructor, protoProps, staticProps) {
      return staticProps && _defineProperties2(Constructor, staticProps), Object.defineProperty(Constructor, "prototype", {
        writable: !1
      }), Constructor;
    }
    __name(_createClass2, "_createClass");
    function _extends2() {
      return _extends2 = Object.assign ? Object.assign.bind() : function(target2) {
        for (var i = 1; i < arguments.length; i++) {
          var source2 = arguments[i];
          for (var key in source2)
            Object.prototype.hasOwnProperty.call(source2, key) && (target2[key] = source2[key]);
        }
        return target2;
      }, _extends2.apply(this, arguments);
    }
    __name(_extends2, "_extends");
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype), subClass.prototype.constructor = subClass, _setPrototypeOf2(subClass, superClass);
    }
    __name(_inheritsLoose, "_inheritsLoose");
    function _setPrototypeOf2(o, p) {
      return _setPrototypeOf2 = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : /* @__PURE__ */ __name(function(o2, p2) {
        return o2.__proto__ = p2, o2;
      }, "_setPrototypeOf"), _setPrototypeOf2(o, p);
    }
    __name(_setPrototypeOf2, "_setPrototypeOf");
    var TRANSITION_END = "transitionend", MAX_UID = 1e6, MILLISECONDS_MULTIPLIER = 1e3;
    function toType4(obj2) {
      return obj2 === null || typeof obj2 > "u" ? "" + obj2 : {}.toString.call(obj2).match(/\s([a-z]+)/i)[1].toLowerCase();
    }
    __name(toType4, "toType");
    function getSpecialTransitionEndEvent() {
      return {
        bindType: TRANSITION_END,
        delegateType: TRANSITION_END,
        handle: /* @__PURE__ */ __name(function(event2) {
          if ($__default.default(event2.target).is(this))
            return event2.handleObj.handler.apply(this, arguments);
        }, "handle")
      };
    }
    __name(getSpecialTransitionEndEvent, "getSpecialTransitionEndEvent");
    function transitionEndEmulator(duration) {
      var _this = this, called = !1;
      return $__default.default(this).one(Util.TRANSITION_END, function() {
        called = !0;
      }), setTimeout(function() {
        called || Util.triggerTransitionEnd(_this);
      }, duration), this;
    }
    __name(transitionEndEmulator, "transitionEndEmulator");
    function setTransitionEndSupport() {
      $__default.default.fn.emulateTransitionEnd = transitionEndEmulator, $__default.default.event.special[Util.TRANSITION_END] = getSpecialTransitionEndEvent();
    }
    __name(setTransitionEndSupport, "setTransitionEndSupport");
    var Util = {
      TRANSITION_END: "bsTransitionEnd",
      getUID: /* @__PURE__ */ __name(function(prefix) {
        do
          prefix += ~~(Math.random() * MAX_UID);
        while (document.getElementById(prefix));
        return prefix;
      }, "getUID"),
      getSelectorFromElement: /* @__PURE__ */ __name(function(element) {
        var selector = element.getAttribute("data-target");
        if (!selector || selector === "#") {
          var hrefAttr = element.getAttribute("href");
          selector = hrefAttr && hrefAttr !== "#" ? hrefAttr.trim() : "";
        }
        try {
          return document.querySelector(selector) ? selector : null;
        } catch {
          return null;
        }
      }, "getSelectorFromElement"),
      getTransitionDurationFromElement: /* @__PURE__ */ __name(function(element) {
        if (!element)
          return 0;
        var transitionDuration = $__default.default(element).css("transition-duration"), transitionDelay = $__default.default(element).css("transition-delay"), floatTransitionDuration = parseFloat(transitionDuration), floatTransitionDelay = parseFloat(transitionDelay);
        return !floatTransitionDuration && !floatTransitionDelay ? 0 : (transitionDuration = transitionDuration.split(",")[0], transitionDelay = transitionDelay.split(",")[0], (parseFloat(transitionDuration) + parseFloat(transitionDelay)) * MILLISECONDS_MULTIPLIER);
      }, "getTransitionDurationFromElement"),
      reflow: /* @__PURE__ */ __name(function(element) {
        return element.offsetHeight;
      }, "reflow"),
      triggerTransitionEnd: /* @__PURE__ */ __name(function(element) {
        $__default.default(element).trigger(TRANSITION_END);
      }, "triggerTransitionEnd"),
      supportsTransitionEnd: /* @__PURE__ */ __name(function() {
        return !!TRANSITION_END;
      }, "supportsTransitionEnd"),
      isElement: /* @__PURE__ */ __name(function(obj2) {
        return (obj2[0] || obj2).nodeType;
      }, "isElement"),
      typeCheckConfig: /* @__PURE__ */ __name(function(componentName, config2, configTypes) {
        for (var property in configTypes)
          if (Object.prototype.hasOwnProperty.call(configTypes, property)) {
            var expectedTypes = configTypes[property], value3 = config2[property], valueType = value3 && Util.isElement(value3) ? "element" : toType4(value3);
            if (!new RegExp(expectedTypes).test(valueType))
              throw new Error(componentName.toUpperCase() + ": " + ('Option "' + property + '" provided type "' + valueType + '" ') + ('but expected type "' + expectedTypes + '".'));
          }
      }, "typeCheckConfig"),
      findShadowRoot: /* @__PURE__ */ __name(function(element) {
        if (!document.documentElement.attachShadow)
          return null;
        if (typeof element.getRootNode == "function") {
          var root = element.getRootNode();
          return root instanceof ShadowRoot ? root : null;
        }
        return element instanceof ShadowRoot ? element : element.parentNode ? Util.findShadowRoot(element.parentNode) : null;
      }, "findShadowRoot"),
      jQueryDetection: /* @__PURE__ */ __name(function() {
        if (typeof $__default.default > "u")
          throw new TypeError("Bootstrap's JavaScript requires jQuery. jQuery must be included before Bootstrap's JavaScript.");
        var version2 = $__default.default.fn.jquery.split(" ")[0].split("."), minMajor = 1, ltMajor = 2, minMinor = 9, minPatch = 1, maxMajor = 4;
        if (version2[0] < ltMajor && version2[1] < minMinor || version2[0] === minMajor && version2[1] === minMinor && version2[2] < minPatch || version2[0] >= maxMajor)
          throw new Error("Bootstrap's JavaScript requires at least jQuery v1.9.1 but less than v4.0.0");
      }, "jQueryDetection")
    };
    Util.jQueryDetection(), setTransitionEndSupport();
    var NAME$a = "alert", VERSION$a = "4.6.2", DATA_KEY$a = "bs.alert", EVENT_KEY$a = "." + DATA_KEY$a, DATA_API_KEY$7 = ".data-api", JQUERY_NO_CONFLICT$a = $__default.default.fn[NAME$a], CLASS_NAME_ALERT = "alert", CLASS_NAME_FADE$5 = "fade", CLASS_NAME_SHOW$7 = "show", EVENT_CLOSE = "close" + EVENT_KEY$a, EVENT_CLOSED = "closed" + EVENT_KEY$a, EVENT_CLICK_DATA_API$6 = "click" + EVENT_KEY$a + DATA_API_KEY$7, SELECTOR_DISMISS = '[data-dismiss="alert"]', Alert = /* @__PURE__ */ function() {
      function Alert2(element) {
        this._element = element;
      }
      __name(Alert2, "Alert");
      var _proto = Alert2.prototype;
      return _proto.close = /* @__PURE__ */ __name(function(element) {
        var rootElement = this._element;
        element && (rootElement = this._getRootElement(element));
        var customEvent = this._triggerCloseEvent(rootElement);
        customEvent.isDefaultPrevented() || this._removeElement(rootElement);
      }, "close"), _proto.dispose = /* @__PURE__ */ __name(function() {
        $__default.default.removeData(this._element, DATA_KEY$a), this._element = null;
      }, "dispose"), _proto._getRootElement = /* @__PURE__ */ __name(function(element) {
        var selector = Util.getSelectorFromElement(element), parent = !1;
        return selector && (parent = document.querySelector(selector)), parent || (parent = $__default.default(element).closest("." + CLASS_NAME_ALERT)[0]), parent;
      }, "_getRootElement"), _proto._triggerCloseEvent = /* @__PURE__ */ __name(function(element) {
        var closeEvent = $__default.default.Event(EVENT_CLOSE);
        return $__default.default(element).trigger(closeEvent), closeEvent;
      }, "_triggerCloseEvent"), _proto._removeElement = /* @__PURE__ */ __name(function(element) {
        var _this = this;
        if ($__default.default(element).removeClass(CLASS_NAME_SHOW$7), !$__default.default(element).hasClass(CLASS_NAME_FADE$5)) {
          this._destroyElement(element);
          return;
        }
        var transitionDuration = Util.getTransitionDurationFromElement(element);
        $__default.default(element).one(Util.TRANSITION_END, function(event2) {
          return _this._destroyElement(element, event2);
        }).emulateTransitionEnd(transitionDuration);
      }, "_removeElement"), _proto._destroyElement = /* @__PURE__ */ __name(function(element) {
        $__default.default(element).detach().trigger(EVENT_CLOSED).remove();
      }, "_destroyElement"), Alert2._jQueryInterface = /* @__PURE__ */ __name(function(config2) {
        return this.each(function() {
          var $element = $__default.default(this), data49 = $element.data(DATA_KEY$a);
          data49 || (data49 = new Alert2(this), $element.data(DATA_KEY$a, data49)), config2 === "close" && data49[config2](this);
        });
      }, "_jQueryInterface"), Alert2._handleDismiss = /* @__PURE__ */ __name(function(alertInstance) {
        return function(event2) {
          event2 && event2.preventDefault(), alertInstance.close(this);
        };
      }, "_handleDismiss"), _createClass2(Alert2, null, [{
        key: "VERSION",
        get: /* @__PURE__ */ __name(function() {
          return VERSION$a;
        }, "get")
      }]), Alert2;
    }();
    $__default.default(document).on(EVENT_CLICK_DATA_API$6, SELECTOR_DISMISS, Alert._handleDismiss(new Alert())), $__default.default.fn[NAME$a] = Alert._jQueryInterface, $__default.default.fn[NAME$a].Constructor = Alert, $__default.default.fn[NAME$a].noConflict = function() {
      return $__default.default.fn[NAME$a] = JQUERY_NO_CONFLICT$a, Alert._jQueryInterface;
    };
    var NAME$9 = "button", VERSION$9 = "4.6.2", DATA_KEY$9 = "bs.button", EVENT_KEY$9 = "." + DATA_KEY$9, DATA_API_KEY$6 = ".data-api", JQUERY_NO_CONFLICT$9 = $__default.default.fn[NAME$9], CLASS_NAME_ACTIVE$3 = "active", CLASS_NAME_BUTTON = "btn", CLASS_NAME_FOCUS = "focus", EVENT_CLICK_DATA_API$5 = "click" + EVENT_KEY$9 + DATA_API_KEY$6, EVENT_FOCUS_BLUR_DATA_API = "focus" + EVENT_KEY$9 + DATA_API_KEY$6 + " " + ("blur" + EVENT_KEY$9 + DATA_API_KEY$6), EVENT_LOAD_DATA_API$2 = "load" + EVENT_KEY$9 + DATA_API_KEY$6, SELECTOR_DATA_TOGGLE_CARROT = '[data-toggle^="button"]', SELECTOR_DATA_TOGGLES = '[data-toggle="buttons"]', SELECTOR_DATA_TOGGLE$4 = '[data-toggle="button"]', SELECTOR_DATA_TOGGLES_BUTTONS = '[data-toggle="buttons"] .btn', SELECTOR_INPUT = 'input:not([type="hidden"])', SELECTOR_ACTIVE$2 = ".active", SELECTOR_BUTTON = ".btn", Button = /* @__PURE__ */ function() {
      function Button2(element) {
        this._element = element, this.shouldAvoidTriggerChange = !1;
      }
      __name(Button2, "Button");
      var _proto = Button2.prototype;
      return _proto.toggle = /* @__PURE__ */ __name(function() {
        var triggerChangeEvent = !0, addAriaPressed = !0, rootElement = $__default.default(this._element).closest(SELECTOR_DATA_TOGGLES)[0];
        if (rootElement) {
          var input = this._element.querySelector(SELECTOR_INPUT);
          if (input) {
            if (input.type === "radio")
              if (input.checked && this._element.classList.contains(CLASS_NAME_ACTIVE$3))
                triggerChangeEvent = !1;
              else {
                var activeElement = rootElement.querySelector(SELECTOR_ACTIVE$2);
                activeElement && $__default.default(activeElement).removeClass(CLASS_NAME_ACTIVE$3);
              }
            triggerChangeEvent && ((input.type === "checkbox" || input.type === "radio") && (input.checked = !this._element.classList.contains(CLASS_NAME_ACTIVE$3)), this.shouldAvoidTriggerChange || $__default.default(input).trigger("change")), input.focus(), addAriaPressed = !1;
          }
        }
        this._element.hasAttribute("disabled") || this._element.classList.contains("disabled") || (addAriaPressed && this._element.setAttribute("aria-pressed", !this._element.classList.contains(CLASS_NAME_ACTIVE$3)), triggerChangeEvent && $__default.default(this._element).toggleClass(CLASS_NAME_ACTIVE$3));
      }, "toggle"), _proto.dispose = /* @__PURE__ */ __name(function() {
        $__default.default.removeData(this._element, DATA_KEY$9), this._element = null;
      }, "dispose"), Button2._jQueryInterface = /* @__PURE__ */ __name(function(config2, avoidTriggerChange) {
        return this.each(function() {
          var $element = $__default.default(this), data49 = $element.data(DATA_KEY$9);
          data49 || (data49 = new Button2(this), $element.data(DATA_KEY$9, data49)), data49.shouldAvoidTriggerChange = avoidTriggerChange, config2 === "toggle" && data49[config2]();
        });
      }, "_jQueryInterface"), _createClass2(Button2, null, [{
        key: "VERSION",
        get: /* @__PURE__ */ __name(function() {
          return VERSION$9;
        }, "get")
      }]), Button2;
    }();
    $__default.default(document).on(EVENT_CLICK_DATA_API$5, SELECTOR_DATA_TOGGLE_CARROT, function(event2) {
      var button = event2.target, initialButton = button;
      if ($__default.default(button).hasClass(CLASS_NAME_BUTTON) || (button = $__default.default(button).closest(SELECTOR_BUTTON)[0]), !button || button.hasAttribute("disabled") || button.classList.contains("disabled"))
        event2.preventDefault();
      else {
        var inputBtn = button.querySelector(SELECTOR_INPUT);
        if (inputBtn && (inputBtn.hasAttribute("disabled") || inputBtn.classList.contains("disabled"))) {
          event2.preventDefault();
          return;
        }
        (initialButton.tagName === "INPUT" || button.tagName !== "LABEL") && Button._jQueryInterface.call($__default.default(button), "toggle", initialButton.tagName === "INPUT");
      }
    }).on(EVENT_FOCUS_BLUR_DATA_API, SELECTOR_DATA_TOGGLE_CARROT, function(event2) {
      var button = $__default.default(event2.target).closest(SELECTOR_BUTTON)[0];
      $__default.default(button).toggleClass(CLASS_NAME_FOCUS, /^focus(in)?$/.test(event2.type));
    }), $__default.default(window).on(EVENT_LOAD_DATA_API$2, function() {
      for (var buttons = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLES_BUTTONS)), i = 0, len2 = buttons.length; i < len2; i++) {
        var button = buttons[i], input = button.querySelector(SELECTOR_INPUT);
        input.checked || input.hasAttribute("checked") ? button.classList.add(CLASS_NAME_ACTIVE$3) : button.classList.remove(CLASS_NAME_ACTIVE$3);
      }
      buttons = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$4));
      for (var _i = 0, _len = buttons.length; _i < _len; _i++) {
        var _button = buttons[_i];
        _button.getAttribute("aria-pressed") === "true" ? _button.classList.add(CLASS_NAME_ACTIVE$3) : _button.classList.remove(CLASS_NAME_ACTIVE$3);
      }
    }), $__default.default.fn[NAME$9] = Button._jQueryInterface, $__default.default.fn[NAME$9].Constructor = Button, $__default.default.fn[NAME$9].noConflict = function() {
      return $__default.default.fn[NAME$9] = JQUERY_NO_CONFLICT$9, Button._jQueryInterface;
    };
    var NAME$8 = "carousel", VERSION$8 = "4.6.2", DATA_KEY$8 = "bs.carousel", EVENT_KEY$8 = "." + DATA_KEY$8, DATA_API_KEY$5 = ".data-api", JQUERY_NO_CONFLICT$8 = $__default.default.fn[NAME$8], ARROW_LEFT_KEYCODE = 37, ARROW_RIGHT_KEYCODE = 39, TOUCHEVENT_COMPAT_WAIT = 500, SWIPE_THRESHOLD2 = 40, CLASS_NAME_CAROUSEL = "carousel", CLASS_NAME_ACTIVE$2 = "active", CLASS_NAME_SLIDE = "slide", CLASS_NAME_RIGHT = "carousel-item-right", CLASS_NAME_LEFT = "carousel-item-left", CLASS_NAME_NEXT = "carousel-item-next", CLASS_NAME_PREV = "carousel-item-prev", CLASS_NAME_POINTER_EVENT = "pointer-event", DIRECTION_NEXT = "next", DIRECTION_PREV = "prev", DIRECTION_LEFT = "left", DIRECTION_RIGHT = "right", EVENT_SLIDE = "slide" + EVENT_KEY$8, EVENT_SLID = "slid" + EVENT_KEY$8, EVENT_KEYDOWN = "keydown" + EVENT_KEY$8, EVENT_MOUSEENTER = "mouseenter" + EVENT_KEY$8, EVENT_MOUSELEAVE = "mouseleave" + EVENT_KEY$8, EVENT_TOUCHSTART = "touchstart" + EVENT_KEY$8, EVENT_TOUCHMOVE = "touchmove" + EVENT_KEY$8, EVENT_TOUCHEND = "touchend" + EVENT_KEY$8, EVENT_POINTERDOWN = "pointerdown" + EVENT_KEY$8, EVENT_POINTERUP = "pointerup" + EVENT_KEY$8, EVENT_DRAG_START = "dragstart" + EVENT_KEY$8, EVENT_LOAD_DATA_API$1 = "load" + EVENT_KEY$8 + DATA_API_KEY$5, EVENT_CLICK_DATA_API$4 = "click" + EVENT_KEY$8 + DATA_API_KEY$5, SELECTOR_ACTIVE$1 = ".active", SELECTOR_ACTIVE_ITEM = ".active.carousel-item", SELECTOR_ITEM2 = ".carousel-item", SELECTOR_ITEM_IMG = ".carousel-item img", SELECTOR_NEXT_PREV = ".carousel-item-next, .carousel-item-prev", SELECTOR_INDICATORS = ".carousel-indicators", SELECTOR_DATA_SLIDE = "[data-slide], [data-slide-to]", SELECTOR_DATA_RIDE = '[data-ride="carousel"]', Default$7 = {
      interval: 5e3,
      keyboard: !0,
      slide: !1,
      pause: "hover",
      wrap: !0,
      touch: !0
    }, DefaultType$7 = {
      interval: "(number|boolean)",
      keyboard: "boolean",
      slide: "(boolean|string)",
      pause: "(string|boolean)",
      wrap: "boolean",
      touch: "boolean"
    }, PointerType2 = {
      TOUCH: "touch",
      PEN: "pen"
    }, Carousel = /* @__PURE__ */ function() {
      function Carousel2(element, config2) {
        this._items = null, this._interval = null, this._activeElement = null, this._isPaused = !1, this._isSliding = !1, this.touchTimeout = null, this.touchStartX = 0, this.touchDeltaX = 0, this._config = this._getConfig(config2), this._element = element, this._indicatorsElement = this._element.querySelector(SELECTOR_INDICATORS), this._touchSupported = "ontouchstart" in document.documentElement || navigator.maxTouchPoints > 0, this._pointerEvent = !!(window.PointerEvent || window.MSPointerEvent), this._addEventListeners();
      }
      __name(Carousel2, "Carousel");
      var _proto = Carousel2.prototype;
      return _proto.next = /* @__PURE__ */ __name(function() {
        this._isSliding || this._slide(DIRECTION_NEXT);
      }, "next"), _proto.nextWhenVisible = /* @__PURE__ */ __name(function() {
        var $element = $__default.default(this._element);
        !document.hidden && $element.is(":visible") && $element.css("visibility") !== "hidden" && this.next();
      }, "nextWhenVisible"), _proto.prev = /* @__PURE__ */ __name(function() {
        this._isSliding || this._slide(DIRECTION_PREV);
      }, "prev"), _proto.pause = /* @__PURE__ */ __name(function(event2) {
        event2 || (this._isPaused = !0), this._element.querySelector(SELECTOR_NEXT_PREV) && (Util.triggerTransitionEnd(this._element), this.cycle(!0)), clearInterval(this._interval), this._interval = null;
      }, "pause"), _proto.cycle = /* @__PURE__ */ __name(function(event2) {
        event2 || (this._isPaused = !1), this._interval && (clearInterval(this._interval), this._interval = null), this._config.interval && !this._isPaused && (this._updateInterval(), this._interval = setInterval((document.visibilityState ? this.nextWhenVisible : this.next).bind(this), this._config.interval));
      }, "cycle"), _proto.to = /* @__PURE__ */ __name(function(index3) {
        var _this = this;
        this._activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);
        var activeIndex = this._getItemIndex(this._activeElement);
        if (!(index3 > this._items.length - 1 || index3 < 0)) {
          if (this._isSliding) {
            $__default.default(this._element).one(EVENT_SLID, function() {
              return _this.to(index3);
            });
            return;
          }
          if (activeIndex === index3) {
            this.pause(), this.cycle();
            return;
          }
          var direction = index3 > activeIndex ? DIRECTION_NEXT : DIRECTION_PREV;
          this._slide(direction, this._items[index3]);
        }
      }, "to"), _proto.dispose = /* @__PURE__ */ __name(function() {
        $__default.default(this._element).off(EVENT_KEY$8), $__default.default.removeData(this._element, DATA_KEY$8), this._items = null, this._config = null, this._element = null, this._interval = null, this._isPaused = null, this._isSliding = null, this._activeElement = null, this._indicatorsElement = null;
      }, "dispose"), _proto._getConfig = /* @__PURE__ */ __name(function(config2) {
        return config2 = _extends2({}, Default$7, config2), Util.typeCheckConfig(NAME$8, config2, DefaultType$7), config2;
      }, "_getConfig"), _proto._handleSwipe = /* @__PURE__ */ __name(function() {
        var absDeltax = Math.abs(this.touchDeltaX);
        if (!(absDeltax <= SWIPE_THRESHOLD2)) {
          var direction = absDeltax / this.touchDeltaX;
          this.touchDeltaX = 0, direction > 0 && this.prev(), direction < 0 && this.next();
        }
      }, "_handleSwipe"), _proto._addEventListeners = /* @__PURE__ */ __name(function() {
        var _this2 = this;
        this._config.keyboard && $__default.default(this._element).on(EVENT_KEYDOWN, function(event2) {
          return _this2._keydown(event2);
        }), this._config.pause === "hover" && $__default.default(this._element).on(EVENT_MOUSEENTER, function(event2) {
          return _this2.pause(event2);
        }).on(EVENT_MOUSELEAVE, function(event2) {
          return _this2.cycle(event2);
        }), this._config.touch && this._addTouchEventListeners();
      }, "_addEventListeners"), _proto._addTouchEventListeners = /* @__PURE__ */ __name(function() {
        var _this3 = this;
        if (this._touchSupported) {
          var start3 = /* @__PURE__ */ __name(function(event2) {
            _this3._pointerEvent && PointerType2[event2.originalEvent.pointerType.toUpperCase()] ? _this3.touchStartX = event2.originalEvent.clientX : _this3._pointerEvent || (_this3.touchStartX = event2.originalEvent.touches[0].clientX);
          }, "start"), move = /* @__PURE__ */ __name(function(event2) {
            _this3.touchDeltaX = event2.originalEvent.touches && event2.originalEvent.touches.length > 1 ? 0 : event2.originalEvent.touches[0].clientX - _this3.touchStartX;
          }, "move"), end2 = /* @__PURE__ */ __name(function(event2) {
            _this3._pointerEvent && PointerType2[event2.originalEvent.pointerType.toUpperCase()] && (_this3.touchDeltaX = event2.originalEvent.clientX - _this3.touchStartX), _this3._handleSwipe(), _this3._config.pause === "hover" && (_this3.pause(), _this3.touchTimeout && clearTimeout(_this3.touchTimeout), _this3.touchTimeout = setTimeout(function(event3) {
              return _this3.cycle(event3);
            }, TOUCHEVENT_COMPAT_WAIT + _this3._config.interval));
          }, "end");
          $__default.default(this._element.querySelectorAll(SELECTOR_ITEM_IMG)).on(EVENT_DRAG_START, function(e2) {
            return e2.preventDefault();
          }), this._pointerEvent ? ($__default.default(this._element).on(EVENT_POINTERDOWN, function(event2) {
            return start3(event2);
          }), $__default.default(this._element).on(EVENT_POINTERUP, function(event2) {
            return end2(event2);
          }), this._element.classList.add(CLASS_NAME_POINTER_EVENT)) : ($__default.default(this._element).on(EVENT_TOUCHSTART, function(event2) {
            return start3(event2);
          }), $__default.default(this._element).on(EVENT_TOUCHMOVE, function(event2) {
            return move(event2);
          }), $__default.default(this._element).on(EVENT_TOUCHEND, function(event2) {
            return end2(event2);
          }));
        }
      }, "_addTouchEventListeners"), _proto._keydown = /* @__PURE__ */ __name(function(event2) {
        if (!/input|textarea/i.test(event2.target.tagName))
          switch (event2.which) {
            case ARROW_LEFT_KEYCODE:
              event2.preventDefault(), this.prev();
              break;
            case ARROW_RIGHT_KEYCODE:
              event2.preventDefault(), this.next();
              break;
          }
      }, "_keydown"), _proto._getItemIndex = /* @__PURE__ */ __name(function(element) {
        return this._items = element && element.parentNode ? [].slice.call(element.parentNode.querySelectorAll(SELECTOR_ITEM2)) : [], this._items.indexOf(element);
      }, "_getItemIndex"), _proto._getItemByDirection = /* @__PURE__ */ __name(function(direction, activeElement) {
        var isNextDirection = direction === DIRECTION_NEXT, isPrevDirection = direction === DIRECTION_PREV, activeIndex = this._getItemIndex(activeElement), lastItemIndex = this._items.length - 1, isGoingToWrap = isPrevDirection && activeIndex === 0 || isNextDirection && activeIndex === lastItemIndex;
        if (isGoingToWrap && !this._config.wrap)
          return activeElement;
        var delta = direction === DIRECTION_PREV ? -1 : 1, itemIndex = (activeIndex + delta) % this._items.length;
        return itemIndex === -1 ? this._items[this._items.length - 1] : this._items[itemIndex];
      }, "_getItemByDirection"), _proto._triggerSlideEvent = /* @__PURE__ */ __name(function(relatedTarget, eventDirectionName) {
        var targetIndex = this._getItemIndex(relatedTarget), fromIndex = this._getItemIndex(this._element.querySelector(SELECTOR_ACTIVE_ITEM)), slideEvent = $__default.default.Event(EVENT_SLIDE, {
          relatedTarget,
          direction: eventDirectionName,
          from: fromIndex,
          to: targetIndex
        });
        return $__default.default(this._element).trigger(slideEvent), slideEvent;
      }, "_triggerSlideEvent"), _proto._setActiveIndicatorElement = /* @__PURE__ */ __name(function(element) {
        if (this._indicatorsElement) {
          var indicators = [].slice.call(this._indicatorsElement.querySelectorAll(SELECTOR_ACTIVE$1));
          $__default.default(indicators).removeClass(CLASS_NAME_ACTIVE$2);
          var nextIndicator = this._indicatorsElement.children[this._getItemIndex(element)];
          nextIndicator && $__default.default(nextIndicator).addClass(CLASS_NAME_ACTIVE$2);
        }
      }, "_setActiveIndicatorElement"), _proto._updateInterval = /* @__PURE__ */ __name(function() {
        var element = this._activeElement || this._element.querySelector(SELECTOR_ACTIVE_ITEM);
        if (element) {
          var elementInterval = parseInt(element.getAttribute("data-interval"), 10);
          elementInterval ? (this._config.defaultInterval = this._config.defaultInterval || this._config.interval, this._config.interval = elementInterval) : this._config.interval = this._config.defaultInterval || this._config.interval;
        }
      }, "_updateInterval"), _proto._slide = /* @__PURE__ */ __name(function(direction, element) {
        var _this4 = this, activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM), activeElementIndex = this._getItemIndex(activeElement), nextElement = element || activeElement && this._getItemByDirection(direction, activeElement), nextElementIndex = this._getItemIndex(nextElement), isCycling = !!this._interval, directionalClassName, orderClassName, eventDirectionName;
        if (direction === DIRECTION_NEXT ? (directionalClassName = CLASS_NAME_LEFT, orderClassName = CLASS_NAME_NEXT, eventDirectionName = DIRECTION_LEFT) : (directionalClassName = CLASS_NAME_RIGHT, orderClassName = CLASS_NAME_PREV, eventDirectionName = DIRECTION_RIGHT), nextElement && $__default.default(nextElement).hasClass(CLASS_NAME_ACTIVE$2)) {
          this._isSliding = !1;
          return;
        }
        var slideEvent = this._triggerSlideEvent(nextElement, eventDirectionName);
        if (!slideEvent.isDefaultPrevented() && !(!activeElement || !nextElement)) {
          this._isSliding = !0, isCycling && this.pause(), this._setActiveIndicatorElement(nextElement), this._activeElement = nextElement;
          var slidEvent = $__default.default.Event(EVENT_SLID, {
            relatedTarget: nextElement,
            direction: eventDirectionName,
            from: activeElementIndex,
            to: nextElementIndex
          });
          if ($__default.default(this._element).hasClass(CLASS_NAME_SLIDE)) {
            $__default.default(nextElement).addClass(orderClassName), Util.reflow(nextElement), $__default.default(activeElement).addClass(directionalClassName), $__default.default(nextElement).addClass(directionalClassName);
            var transitionDuration = Util.getTransitionDurationFromElement(activeElement);
            $__default.default(activeElement).one(Util.TRANSITION_END, function() {
              $__default.default(nextElement).removeClass(directionalClassName + " " + orderClassName).addClass(CLASS_NAME_ACTIVE$2), $__default.default(activeElement).removeClass(CLASS_NAME_ACTIVE$2 + " " + orderClassName + " " + directionalClassName), _this4._isSliding = !1, setTimeout(function() {
                return $__default.default(_this4._element).trigger(slidEvent);
              }, 0);
            }).emulateTransitionEnd(transitionDuration);
          } else
            $__default.default(activeElement).removeClass(CLASS_NAME_ACTIVE$2), $__default.default(nextElement).addClass(CLASS_NAME_ACTIVE$2), this._isSliding = !1, $__default.default(this._element).trigger(slidEvent);
          isCycling && this.cycle();
        }
      }, "_slide"), Carousel2._jQueryInterface = /* @__PURE__ */ __name(function(config2) {
        return this.each(function() {
          var data49 = $__default.default(this).data(DATA_KEY$8), _config = _extends2({}, Default$7, $__default.default(this).data());
          typeof config2 == "object" && (_config = _extends2({}, _config, config2));
          var action = typeof config2 == "string" ? config2 : _config.slide;
          if (data49 || (data49 = new Carousel2(this, _config), $__default.default(this).data(DATA_KEY$8, data49)), typeof config2 == "number")
            data49.to(config2);
          else if (typeof action == "string") {
            if (typeof data49[action] > "u")
              throw new TypeError('No method named "' + action + '"');
            data49[action]();
          } else _config.interval && _config.ride && (data49.pause(), data49.cycle());
        });
      }, "_jQueryInterface"), Carousel2._dataApiClickHandler = /* @__PURE__ */ __name(function(event2) {
        var selector = Util.getSelectorFromElement(this);
        if (selector) {
          var target2 = $__default.default(selector)[0];
          if (!(!target2 || !$__default.default(target2).hasClass(CLASS_NAME_CAROUSEL))) {
            var config2 = _extends2({}, $__default.default(target2).data(), $__default.default(this).data()), slideIndex = this.getAttribute("data-slide-to");
            slideIndex && (config2.interval = !1), Carousel2._jQueryInterface.call($__default.default(target2), config2), slideIndex && $__default.default(target2).data(DATA_KEY$8).to(slideIndex), event2.preventDefault();
          }
        }
      }, "_dataApiClickHandler"), _createClass2(Carousel2, null, [{
        key: "VERSION",
        get: /* @__PURE__ */ __name(function() {
          return VERSION$8;
        }, "get")
      }, {
        key: "Default",
        get: /* @__PURE__ */ __name(function() {
          return Default$7;
        }, "get")
      }]), Carousel2;
    }();
    $__default.default(document).on(EVENT_CLICK_DATA_API$4, SELECTOR_DATA_SLIDE, Carousel._dataApiClickHandler), $__default.default(window).on(EVENT_LOAD_DATA_API$1, function() {
      for (var carousels = [].slice.call(document.querySelectorAll(SELECTOR_DATA_RIDE)), i = 0, len2 = carousels.length; i < len2; i++) {
        var $carousel = $__default.default(carousels[i]);
        Carousel._jQueryInterface.call($carousel, $carousel.data());
      }
    }), $__default.default.fn[NAME$8] = Carousel._jQueryInterface, $__default.default.fn[NAME$8].Constructor = Carousel, $__default.default.fn[NAME$8].noConflict = function() {
      return $__default.default.fn[NAME$8] = JQUERY_NO_CONFLICT$8, Carousel._jQueryInterface;
    };
    var NAME$7 = "collapse", VERSION$7 = "4.6.2", DATA_KEY$7 = "bs.collapse", EVENT_KEY$7 = "." + DATA_KEY$7, DATA_API_KEY$4 = ".data-api", JQUERY_NO_CONFLICT$7 = $__default.default.fn[NAME$7], CLASS_NAME_SHOW$6 = "show", CLASS_NAME_COLLAPSE = "collapse", CLASS_NAME_COLLAPSING = "collapsing", CLASS_NAME_COLLAPSED = "collapsed", DIMENSION_WIDTH = "width", DIMENSION_HEIGHT = "height", EVENT_SHOW$4 = "show" + EVENT_KEY$7, EVENT_SHOWN$4 = "shown" + EVENT_KEY$7, EVENT_HIDE$4 = "hide" + EVENT_KEY$7, EVENT_HIDDEN$4 = "hidden" + EVENT_KEY$7, EVENT_CLICK_DATA_API$3 = "click" + EVENT_KEY$7 + DATA_API_KEY$4, SELECTOR_ACTIVES = ".show, .collapsing", SELECTOR_DATA_TOGGLE$3 = '[data-toggle="collapse"]', Default$6 = {
      toggle: !0,
      parent: ""
    }, DefaultType$6 = {
      toggle: "boolean",
      parent: "(string|element)"
    }, Collapse = /* @__PURE__ */ function() {
      function Collapse2(element, config2) {
        this._isTransitioning = !1, this._element = element, this._config = this._getConfig(config2), this._triggerArray = [].slice.call(document.querySelectorAll('[data-toggle="collapse"][href="#' + element.id + '"],' + ('[data-toggle="collapse"][data-target="#' + element.id + '"]')));
        for (var toggleList = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$3)), i = 0, len2 = toggleList.length; i < len2; i++) {
          var elem = toggleList[i], selector = Util.getSelectorFromElement(elem), filterElement = [].slice.call(document.querySelectorAll(selector)).filter(function(foundElem) {
            return foundElem === element;
          });
          selector !== null && filterElement.length > 0 && (this._selector = selector, this._triggerArray.push(elem));
        }
        this._parent = this._config.parent ? this._getParent() : null, this._config.parent || this._addAriaAndCollapsedClass(this._element, this._triggerArray), this._config.toggle && this.toggle();
      }
      __name(Collapse2, "Collapse");
      var _proto = Collapse2.prototype;
      return _proto.toggle = /* @__PURE__ */ __name(function() {
        $__default.default(this._element).hasClass(CLASS_NAME_SHOW$6) ? this.hide() : this.show();
      }, "toggle"), _proto.show = /* @__PURE__ */ __name(function() {
        var _this = this;
        if (!(this._isTransitioning || $__default.default(this._element).hasClass(CLASS_NAME_SHOW$6))) {
          var actives, activesData;
          if (this._parent && (actives = [].slice.call(this._parent.querySelectorAll(SELECTOR_ACTIVES)).filter(function(elem) {
            return typeof _this._config.parent == "string" ? elem.getAttribute("data-parent") === _this._config.parent : elem.classList.contains(CLASS_NAME_COLLAPSE);
          }), actives.length === 0 && (actives = null)), !(actives && (activesData = $__default.default(actives).not(this._selector).data(DATA_KEY$7), activesData && activesData._isTransitioning))) {
            var startEvent = $__default.default.Event(EVENT_SHOW$4);
            if ($__default.default(this._element).trigger(startEvent), !startEvent.isDefaultPrevented()) {
              actives && (Collapse2._jQueryInterface.call($__default.default(actives).not(this._selector), "hide"), activesData || $__default.default(actives).data(DATA_KEY$7, null));
              var dimension = this._getDimension();
              $__default.default(this._element).removeClass(CLASS_NAME_COLLAPSE).addClass(CLASS_NAME_COLLAPSING), this._element.style[dimension] = 0, this._triggerArray.length && $__default.default(this._triggerArray).removeClass(CLASS_NAME_COLLAPSED).attr("aria-expanded", !0), this.setTransitioning(!0);
              var complete = /* @__PURE__ */ __name(function() {
                $__default.default(_this._element).removeClass(CLASS_NAME_COLLAPSING).addClass(CLASS_NAME_COLLAPSE + " " + CLASS_NAME_SHOW$6), _this._element.style[dimension] = "", _this.setTransitioning(!1), $__default.default(_this._element).trigger(EVENT_SHOWN$4);
              }, "complete"), capitalizedDimension = dimension[0].toUpperCase() + dimension.slice(1), scrollSize = "scroll" + capitalizedDimension, transitionDuration = Util.getTransitionDurationFromElement(this._element);
              $__default.default(this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration), this._element.style[dimension] = this._element[scrollSize] + "px";
            }
          }
        }
      }, "show"), _proto.hide = /* @__PURE__ */ __name(function() {
        var _this2 = this;
        if (!(this._isTransitioning || !$__default.default(this._element).hasClass(CLASS_NAME_SHOW$6))) {
          var startEvent = $__default.default.Event(EVENT_HIDE$4);
          if ($__default.default(this._element).trigger(startEvent), !startEvent.isDefaultPrevented()) {
            var dimension = this._getDimension();
            this._element.style[dimension] = this._element.getBoundingClientRect()[dimension] + "px", Util.reflow(this._element), $__default.default(this._element).addClass(CLASS_NAME_COLLAPSING).removeClass(CLASS_NAME_COLLAPSE + " " + CLASS_NAME_SHOW$6);
            var triggerArrayLength = this._triggerArray.length;
            if (triggerArrayLength > 0)
              for (var i = 0; i < triggerArrayLength; i++) {
                var trigger2 = this._triggerArray[i], selector = Util.getSelectorFromElement(trigger2);
                if (selector !== null) {
                  var $elem = $__default.default([].slice.call(document.querySelectorAll(selector)));
                  $elem.hasClass(CLASS_NAME_SHOW$6) || $__default.default(trigger2).addClass(CLASS_NAME_COLLAPSED).attr("aria-expanded", !1);
                }
              }
            this.setTransitioning(!0);
            var complete = /* @__PURE__ */ __name(function() {
              _this2.setTransitioning(!1), $__default.default(_this2._element).removeClass(CLASS_NAME_COLLAPSING).addClass(CLASS_NAME_COLLAPSE).trigger(EVENT_HIDDEN$4);
            }, "complete");
            this._element.style[dimension] = "";
            var transitionDuration = Util.getTransitionDurationFromElement(this._element);
            $__default.default(this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
          }
        }
      }, "hide"), _proto.setTransitioning = /* @__PURE__ */ __name(function(isTransitioning) {
        this._isTransitioning = isTransitioning;
      }, "setTransitioning"), _proto.dispose = /* @__PURE__ */ __name(function() {
        $__default.default.removeData(this._element, DATA_KEY$7), this._config = null, this._parent = null, this._element = null, this._triggerArray = null, this._isTransitioning = null;
      }, "dispose"), _proto._getConfig = /* @__PURE__ */ __name(function(config2) {
        return config2 = _extends2({}, Default$6, config2), config2.toggle = !!config2.toggle, Util.typeCheckConfig(NAME$7, config2, DefaultType$6), config2;
      }, "_getConfig"), _proto._getDimension = /* @__PURE__ */ __name(function() {
        var hasWidth = $__default.default(this._element).hasClass(DIMENSION_WIDTH);
        return hasWidth ? DIMENSION_WIDTH : DIMENSION_HEIGHT;
      }, "_getDimension"), _proto._getParent = /* @__PURE__ */ __name(function() {
        var _this3 = this, parent;
        Util.isElement(this._config.parent) ? (parent = this._config.parent, typeof this._config.parent.jquery < "u" && (parent = this._config.parent[0])) : parent = document.querySelector(this._config.parent);
        var selector = '[data-toggle="collapse"][data-parent="' + this._config.parent + '"]', children2 = [].slice.call(parent.querySelectorAll(selector));
        return $__default.default(children2).each(function(i, element) {
          _this3._addAriaAndCollapsedClass(Collapse2._getTargetFromElement(element), [element]);
        }), parent;
      }, "_getParent"), _proto._addAriaAndCollapsedClass = /* @__PURE__ */ __name(function(element, triggerArray) {
        var isOpen = $__default.default(element).hasClass(CLASS_NAME_SHOW$6);
        triggerArray.length && $__default.default(triggerArray).toggleClass(CLASS_NAME_COLLAPSED, !isOpen).attr("aria-expanded", isOpen);
      }, "_addAriaAndCollapsedClass"), Collapse2._getTargetFromElement = /* @__PURE__ */ __name(function(element) {
        var selector = Util.getSelectorFromElement(element);
        return selector ? document.querySelector(selector) : null;
      }, "_getTargetFromElement"), Collapse2._jQueryInterface = /* @__PURE__ */ __name(function(config2) {
        return this.each(function() {
          var $element = $__default.default(this), data49 = $element.data(DATA_KEY$7), _config = _extends2({}, Default$6, $element.data(), typeof config2 == "object" && config2 ? config2 : {});
          if (!data49 && _config.toggle && typeof config2 == "string" && /show|hide/.test(config2) && (_config.toggle = !1), data49 || (data49 = new Collapse2(this, _config), $element.data(DATA_KEY$7, data49)), typeof config2 == "string") {
            if (typeof data49[config2] > "u")
              throw new TypeError('No method named "' + config2 + '"');
            data49[config2]();
          }
        });
      }, "_jQueryInterface"), _createClass2(Collapse2, null, [{
        key: "VERSION",
        get: /* @__PURE__ */ __name(function() {
          return VERSION$7;
        }, "get")
      }, {
        key: "Default",
        get: /* @__PURE__ */ __name(function() {
          return Default$6;
        }, "get")
      }]), Collapse2;
    }();
    $__default.default(document).on(EVENT_CLICK_DATA_API$3, SELECTOR_DATA_TOGGLE$3, function(event2) {
      event2.currentTarget.tagName === "A" && event2.preventDefault();
      var $trigger = $__default.default(this), selector = Util.getSelectorFromElement(this), selectors = [].slice.call(document.querySelectorAll(selector));
      $__default.default(selectors).each(function() {
        var $target = $__default.default(this), data49 = $target.data(DATA_KEY$7), config2 = data49 ? "toggle" : $trigger.data();
        Collapse._jQueryInterface.call($target, config2);
      });
    }), $__default.default.fn[NAME$7] = Collapse._jQueryInterface, $__default.default.fn[NAME$7].Constructor = Collapse, $__default.default.fn[NAME$7].noConflict = function() {
      return $__default.default.fn[NAME$7] = JQUERY_NO_CONFLICT$7, Collapse._jQueryInterface;
    };
    var NAME$6 = "dropdown", VERSION$6 = "4.6.2", DATA_KEY$6 = "bs.dropdown", EVENT_KEY$6 = "." + DATA_KEY$6, DATA_API_KEY$3 = ".data-api", JQUERY_NO_CONFLICT$6 = $__default.default.fn[NAME$6], ESCAPE_KEYCODE$1 = 27, SPACE_KEYCODE = 32, TAB_KEYCODE = 9, ARROW_UP_KEYCODE = 38, ARROW_DOWN_KEYCODE = 40, RIGHT_MOUSE_BUTTON_WHICH = 3, REGEXP_KEYDOWN = new RegExp(ARROW_UP_KEYCODE + "|" + ARROW_DOWN_KEYCODE + "|" + ESCAPE_KEYCODE$1), CLASS_NAME_DISABLED$1 = "disabled", CLASS_NAME_SHOW$5 = "show", CLASS_NAME_DROPUP = "dropup", CLASS_NAME_DROPRIGHT = "dropright", CLASS_NAME_DROPLEFT = "dropleft", CLASS_NAME_MENURIGHT = "dropdown-menu-right", CLASS_NAME_POSITION_STATIC = "position-static", EVENT_HIDE$3 = "hide" + EVENT_KEY$6, EVENT_HIDDEN$3 = "hidden" + EVENT_KEY$6, EVENT_SHOW$3 = "show" + EVENT_KEY$6, EVENT_SHOWN$3 = "shown" + EVENT_KEY$6, EVENT_CLICK = "click" + EVENT_KEY$6, EVENT_CLICK_DATA_API$2 = "click" + EVENT_KEY$6 + DATA_API_KEY$3, EVENT_KEYDOWN_DATA_API = "keydown" + EVENT_KEY$6 + DATA_API_KEY$3, EVENT_KEYUP_DATA_API = "keyup" + EVENT_KEY$6 + DATA_API_KEY$3, SELECTOR_DATA_TOGGLE$2 = '[data-toggle="dropdown"]', SELECTOR_FORM_CHILD2 = ".dropdown form", SELECTOR_MENU = ".dropdown-menu", SELECTOR_NAVBAR_NAV = ".navbar-nav", SELECTOR_VISIBLE_ITEMS = ".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)", PLACEMENT_TOP = "top-start", PLACEMENT_TOPEND = "top-end", PLACEMENT_BOTTOM = "bottom-start", PLACEMENT_BOTTOMEND = "bottom-end", PLACEMENT_RIGHT = "right-start", PLACEMENT_LEFT = "left-start", Default$5 = {
      offset: 0,
      flip: !0,
      boundary: "scrollParent",
      reference: "toggle",
      display: "dynamic",
      popperConfig: null
    }, DefaultType$5 = {
      offset: "(number|string|function)",
      flip: "boolean",
      boundary: "(string|element)",
      reference: "(string|element)",
      display: "string",
      popperConfig: "(null|object)"
    }, Dropdown2 = /* @__PURE__ */ function() {
      function Dropdown3(element, config2) {
        this._element = element, this._popper = null, this._config = this._getConfig(config2), this._menu = this._getMenuElement(), this._inNavbar = this._detectNavbar(), this._addEventListeners();
      }
      __name(Dropdown3, "Dropdown");
      var _proto = Dropdown3.prototype;
      return _proto.toggle = /* @__PURE__ */ __name(function() {
        if (!(this._element.disabled || $__default.default(this._element).hasClass(CLASS_NAME_DISABLED$1))) {
          var isActive = $__default.default(this._menu).hasClass(CLASS_NAME_SHOW$5);
          Dropdown3._clearMenus(), !isActive && this.show(!0);
        }
      }, "toggle"), _proto.show = /* @__PURE__ */ __name(function(usePopper) {
        if (usePopper === void 0 && (usePopper = !1), !(this._element.disabled || $__default.default(this._element).hasClass(CLASS_NAME_DISABLED$1) || $__default.default(this._menu).hasClass(CLASS_NAME_SHOW$5))) {
          var relatedTarget = {
            relatedTarget: this._element
          }, showEvent = $__default.default.Event(EVENT_SHOW$3, relatedTarget), parent = Dropdown3._getParentFromElement(this._element);
          if ($__default.default(parent).trigger(showEvent), !showEvent.isDefaultPrevented()) {
            if (!this._inNavbar && usePopper) {
              if (typeof Popper__default.default > "u")
                throw new TypeError("Bootstrap's dropdowns require Popper (https://popper.js.org)");
              var referenceElement = this._element;
              this._config.reference === "parent" ? referenceElement = parent : Util.isElement(this._config.reference) && (referenceElement = this._config.reference, typeof this._config.reference.jquery < "u" && (referenceElement = this._config.reference[0])), this._config.boundary !== "scrollParent" && $__default.default(parent).addClass(CLASS_NAME_POSITION_STATIC), this._popper = new Popper__default.default(referenceElement, this._menu, this._getPopperConfig());
            }
            "ontouchstart" in document.documentElement && $__default.default(parent).closest(SELECTOR_NAVBAR_NAV).length === 0 && $__default.default(document.body).children().on("mouseover", null, $__default.default.noop), this._element.focus(), this._element.setAttribute("aria-expanded", !0), $__default.default(this._menu).toggleClass(CLASS_NAME_SHOW$5), $__default.default(parent).toggleClass(CLASS_NAME_SHOW$5).trigger($__default.default.Event(EVENT_SHOWN$3, relatedTarget));
          }
        }
      }, "show"), _proto.hide = /* @__PURE__ */ __name(function() {
        if (!(this._element.disabled || $__default.default(this._element).hasClass(CLASS_NAME_DISABLED$1) || !$__default.default(this._menu).hasClass(CLASS_NAME_SHOW$5))) {
          var relatedTarget = {
            relatedTarget: this._element
          }, hideEvent = $__default.default.Event(EVENT_HIDE$3, relatedTarget), parent = Dropdown3._getParentFromElement(this._element);
          $__default.default(parent).trigger(hideEvent), !hideEvent.isDefaultPrevented() && (this._popper && this._popper.destroy(), $__default.default(this._menu).toggleClass(CLASS_NAME_SHOW$5), $__default.default(parent).toggleClass(CLASS_NAME_SHOW$5).trigger($__default.default.Event(EVENT_HIDDEN$3, relatedTarget)));
        }
      }, "hide"), _proto.dispose = /* @__PURE__ */ __name(function() {
        $__default.default.removeData(this._element, DATA_KEY$6), $__default.default(this._element).off(EVENT_KEY$6), this._element = null, this._menu = null, this._popper !== null && (this._popper.destroy(), this._popper = null);
      }, "dispose"), _proto.update = /* @__PURE__ */ __name(function() {
        this._inNavbar = this._detectNavbar(), this._popper !== null && this._popper.scheduleUpdate();
      }, "update"), _proto._addEventListeners = /* @__PURE__ */ __name(function() {
        var _this = this;
        $__default.default(this._element).on(EVENT_CLICK, function(event2) {
          event2.preventDefault(), event2.stopPropagation(), _this.toggle();
        });
      }, "_addEventListeners"), _proto._getConfig = /* @__PURE__ */ __name(function(config2) {
        return config2 = _extends2({}, this.constructor.Default, $__default.default(this._element).data(), config2), Util.typeCheckConfig(NAME$6, config2, this.constructor.DefaultType), config2;
      }, "_getConfig"), _proto._getMenuElement = /* @__PURE__ */ __name(function() {
        if (!this._menu) {
          var parent = Dropdown3._getParentFromElement(this._element);
          parent && (this._menu = parent.querySelector(SELECTOR_MENU));
        }
        return this._menu;
      }, "_getMenuElement"), _proto._getPlacement = /* @__PURE__ */ __name(function() {
        var $parentDropdown = $__default.default(this._element.parentNode), placement = PLACEMENT_BOTTOM;
        return $parentDropdown.hasClass(CLASS_NAME_DROPUP) ? placement = $__default.default(this._menu).hasClass(CLASS_NAME_MENURIGHT) ? PLACEMENT_TOPEND : PLACEMENT_TOP : $parentDropdown.hasClass(CLASS_NAME_DROPRIGHT) ? placement = PLACEMENT_RIGHT : $parentDropdown.hasClass(CLASS_NAME_DROPLEFT) ? placement = PLACEMENT_LEFT : $__default.default(this._menu).hasClass(CLASS_NAME_MENURIGHT) && (placement = PLACEMENT_BOTTOMEND), placement;
      }, "_getPlacement"), _proto._detectNavbar = /* @__PURE__ */ __name(function() {
        return $__default.default(this._element).closest(".navbar").length > 0;
      }, "_detectNavbar"), _proto._getOffset = /* @__PURE__ */ __name(function() {
        var _this2 = this, offset3 = {};
        return typeof this._config.offset == "function" ? offset3.fn = function(data49) {
          return data49.offsets = _extends2({}, data49.offsets, _this2._config.offset(data49.offsets, _this2._element)), data49;
        } : offset3.offset = this._config.offset, offset3;
      }, "_getOffset"), _proto._getPopperConfig = /* @__PURE__ */ __name(function() {
        var popperConfig2 = {
          placement: this._getPlacement(),
          modifiers: {
            offset: this._getOffset(),
            flip: {
              enabled: this._config.flip
            },
            preventOverflow: {
              boundariesElement: this._config.boundary
            }
          }
        };
        return this._config.display === "static" && (popperConfig2.modifiers.applyStyle = {
          enabled: !1
        }), _extends2({}, popperConfig2, this._config.popperConfig);
      }, "_getPopperConfig"), Dropdown3._jQueryInterface = /* @__PURE__ */ __name(function(config2) {
        return this.each(function() {
          var data49 = $__default.default(this).data(DATA_KEY$6), _config = typeof config2 == "object" ? config2 : null;
          if (data49 || (data49 = new Dropdown3(this, _config), $__default.default(this).data(DATA_KEY$6, data49)), typeof config2 == "string") {
            if (typeof data49[config2] > "u")
              throw new TypeError('No method named "' + config2 + '"');
            data49[config2]();
          }
        });
      }, "_jQueryInterface"), Dropdown3._clearMenus = /* @__PURE__ */ __name(function(event2) {
        if (!(event2 && (event2.which === RIGHT_MOUSE_BUTTON_WHICH || event2.type === "keyup" && event2.which !== TAB_KEYCODE)))
          for (var toggles = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$2)), i = 0, len2 = toggles.length; i < len2; i++) {
            var parent = Dropdown3._getParentFromElement(toggles[i]), context7 = $__default.default(toggles[i]).data(DATA_KEY$6), relatedTarget = {
              relatedTarget: toggles[i]
            };
            if (event2 && event2.type === "click" && (relatedTarget.clickEvent = event2), !!context7) {
              var dropdownMenu = context7._menu;
              if ($__default.default(parent).hasClass(CLASS_NAME_SHOW$5) && !(event2 && (event2.type === "click" && /input|textarea/i.test(event2.target.tagName) || event2.type === "keyup" && event2.which === TAB_KEYCODE) && $__default.default.contains(parent, event2.target))) {
                var hideEvent = $__default.default.Event(EVENT_HIDE$3, relatedTarget);
                $__default.default(parent).trigger(hideEvent), !hideEvent.isDefaultPrevented() && ("ontouchstart" in document.documentElement && $__default.default(document.body).children().off("mouseover", null, $__default.default.noop), toggles[i].setAttribute("aria-expanded", "false"), context7._popper && context7._popper.destroy(), $__default.default(dropdownMenu).removeClass(CLASS_NAME_SHOW$5), $__default.default(parent).removeClass(CLASS_NAME_SHOW$5).trigger($__default.default.Event(EVENT_HIDDEN$3, relatedTarget)));
              }
            }
          }
      }, "_clearMenus"), Dropdown3._getParentFromElement = /* @__PURE__ */ __name(function(element) {
        var parent, selector = Util.getSelectorFromElement(element);
        return selector && (parent = document.querySelector(selector)), parent || element.parentNode;
      }, "_getParentFromElement"), Dropdown3._dataApiKeydownHandler = /* @__PURE__ */ __name(function(event2) {
        if (!(/input|textarea/i.test(event2.target.tagName) ? event2.which === SPACE_KEYCODE || event2.which !== ESCAPE_KEYCODE$1 && (event2.which !== ARROW_DOWN_KEYCODE && event2.which !== ARROW_UP_KEYCODE || $__default.default(event2.target).closest(SELECTOR_MENU).length) : !REGEXP_KEYDOWN.test(event2.which)) && !(this.disabled || $__default.default(this).hasClass(CLASS_NAME_DISABLED$1))) {
          var parent = Dropdown3._getParentFromElement(this), isActive = $__default.default(parent).hasClass(CLASS_NAME_SHOW$5);
          if (!(!isActive && event2.which === ESCAPE_KEYCODE$1)) {
            if (event2.preventDefault(), event2.stopPropagation(), !isActive || event2.which === ESCAPE_KEYCODE$1 || event2.which === SPACE_KEYCODE) {
              event2.which === ESCAPE_KEYCODE$1 && $__default.default(parent.querySelector(SELECTOR_DATA_TOGGLE$2)).trigger("focus"), $__default.default(this).trigger("click");
              return;
            }
            var items3 = [].slice.call(parent.querySelectorAll(SELECTOR_VISIBLE_ITEMS)).filter(function(item) {
              return $__default.default(item).is(":visible");
            });
            if (items3.length !== 0) {
              var index3 = items3.indexOf(event2.target);
              event2.which === ARROW_UP_KEYCODE && index3 > 0 && index3--, event2.which === ARROW_DOWN_KEYCODE && index3 < items3.length - 1 && index3++, index3 < 0 && (index3 = 0), items3[index3].focus();
            }
          }
        }
      }, "_dataApiKeydownHandler"), _createClass2(Dropdown3, null, [{
        key: "VERSION",
        get: /* @__PURE__ */ __name(function() {
          return VERSION$6;
        }, "get")
      }, {
        key: "Default",
        get: /* @__PURE__ */ __name(function() {
          return Default$5;
        }, "get")
      }, {
        key: "DefaultType",
        get: /* @__PURE__ */ __name(function() {
          return DefaultType$5;
        }, "get")
      }]), Dropdown3;
    }();
    $__default.default(document).on(EVENT_KEYDOWN_DATA_API, SELECTOR_DATA_TOGGLE$2, Dropdown2._dataApiKeydownHandler).on(EVENT_KEYDOWN_DATA_API, SELECTOR_MENU, Dropdown2._dataApiKeydownHandler).on(EVENT_CLICK_DATA_API$2 + " " + EVENT_KEYUP_DATA_API, Dropdown2._clearMenus).on(EVENT_CLICK_DATA_API$2, SELECTOR_DATA_TOGGLE$2, function(event2) {
      event2.preventDefault(), event2.stopPropagation(), Dropdown2._jQueryInterface.call($__default.default(this), "toggle");
    }).on(EVENT_CLICK_DATA_API$2, SELECTOR_FORM_CHILD2, function(e2) {
      e2.stopPropagation();
    }), $__default.default.fn[NAME$6] = Dropdown2._jQueryInterface, $__default.default.fn[NAME$6].Constructor = Dropdown2, $__default.default.fn[NAME$6].noConflict = function() {
      return $__default.default.fn[NAME$6] = JQUERY_NO_CONFLICT$6, Dropdown2._jQueryInterface;
    };
    var NAME$5 = "modal", VERSION$5 = "4.6.2", DATA_KEY$5 = "bs.modal", EVENT_KEY$5 = "." + DATA_KEY$5, DATA_API_KEY$2 = ".data-api", JQUERY_NO_CONFLICT$5 = $__default.default.fn[NAME$5], ESCAPE_KEYCODE = 27, CLASS_NAME_SCROLLABLE = "modal-dialog-scrollable", CLASS_NAME_SCROLLBAR_MEASURER = "modal-scrollbar-measure", CLASS_NAME_BACKDROP = "modal-backdrop", CLASS_NAME_OPEN = "modal-open", CLASS_NAME_FADE$4 = "fade", CLASS_NAME_SHOW$4 = "show", CLASS_NAME_STATIC = "modal-static", EVENT_HIDE$2 = "hide" + EVENT_KEY$5, EVENT_HIDE_PREVENTED = "hidePrevented" + EVENT_KEY$5, EVENT_HIDDEN$2 = "hidden" + EVENT_KEY$5, EVENT_SHOW$2 = "show" + EVENT_KEY$5, EVENT_SHOWN$2 = "shown" + EVENT_KEY$5, EVENT_FOCUSIN = "focusin" + EVENT_KEY$5, EVENT_RESIZE = "resize" + EVENT_KEY$5, EVENT_CLICK_DISMISS$1 = "click.dismiss" + EVENT_KEY$5, EVENT_KEYDOWN_DISMISS = "keydown.dismiss" + EVENT_KEY$5, EVENT_MOUSEUP_DISMISS = "mouseup.dismiss" + EVENT_KEY$5, EVENT_MOUSEDOWN_DISMISS = "mousedown.dismiss" + EVENT_KEY$5, EVENT_CLICK_DATA_API$1 = "click" + EVENT_KEY$5 + DATA_API_KEY$2, SELECTOR_DIALOG = ".modal-dialog", SELECTOR_MODAL_BODY = ".modal-body", SELECTOR_DATA_TOGGLE$1 = '[data-toggle="modal"]', SELECTOR_DATA_DISMISS$1 = '[data-dismiss="modal"]', SELECTOR_FIXED_CONTENT2 = ".fixed-top, .fixed-bottom, .is-fixed, .sticky-top", SELECTOR_STICKY_CONTENT2 = ".sticky-top", Default$4 = {
      backdrop: !0,
      keyboard: !0,
      focus: !0,
      show: !0
    }, DefaultType$4 = {
      backdrop: "(boolean|string)",
      keyboard: "boolean",
      focus: "boolean",
      show: "boolean"
    }, Modal = /* @__PURE__ */ function() {
      function Modal2(element, config2) {
        this._config = this._getConfig(config2), this._element = element, this._dialog = element.querySelector(SELECTOR_DIALOG), this._backdrop = null, this._isShown = !1, this._isBodyOverflowing = !1, this._ignoreBackdropClick = !1, this._isTransitioning = !1, this._scrollbarWidth = 0;
      }
      __name(Modal2, "Modal");
      var _proto = Modal2.prototype;
      return _proto.toggle = /* @__PURE__ */ __name(function(relatedTarget) {
        return this._isShown ? this.hide() : this.show(relatedTarget);
      }, "toggle"), _proto.show = /* @__PURE__ */ __name(function(relatedTarget) {
        var _this = this;
        if (!(this._isShown || this._isTransitioning)) {
          var showEvent = $__default.default.Event(EVENT_SHOW$2, {
            relatedTarget
          });
          $__default.default(this._element).trigger(showEvent), !showEvent.isDefaultPrevented() && (this._isShown = !0, $__default.default(this._element).hasClass(CLASS_NAME_FADE$4) && (this._isTransitioning = !0), this._checkScrollbar(), this._setScrollbar(), this._adjustDialog(), this._setEscapeEvent(), this._setResizeEvent(), $__default.default(this._element).on(EVENT_CLICK_DISMISS$1, SELECTOR_DATA_DISMISS$1, function(event2) {
            return _this.hide(event2);
          }), $__default.default(this._dialog).on(EVENT_MOUSEDOWN_DISMISS, function() {
            $__default.default(_this._element).one(EVENT_MOUSEUP_DISMISS, function(event2) {
              $__default.default(event2.target).is(_this._element) && (_this._ignoreBackdropClick = !0);
            });
          }), this._showBackdrop(function() {
            return _this._showElement(relatedTarget);
          }));
        }
      }, "show"), _proto.hide = /* @__PURE__ */ __name(function(event2) {
        var _this2 = this;
        if (event2 && event2.preventDefault(), !(!this._isShown || this._isTransitioning)) {
          var hideEvent = $__default.default.Event(EVENT_HIDE$2);
          if ($__default.default(this._element).trigger(hideEvent), !(!this._isShown || hideEvent.isDefaultPrevented())) {
            this._isShown = !1;
            var transition2 = $__default.default(this._element).hasClass(CLASS_NAME_FADE$4);
            if (transition2 && (this._isTransitioning = !0), this._setEscapeEvent(), this._setResizeEvent(), $__default.default(document).off(EVENT_FOCUSIN), $__default.default(this._element).removeClass(CLASS_NAME_SHOW$4), $__default.default(this._element).off(EVENT_CLICK_DISMISS$1), $__default.default(this._dialog).off(EVENT_MOUSEDOWN_DISMISS), transition2) {
              var transitionDuration = Util.getTransitionDurationFromElement(this._element);
              $__default.default(this._element).one(Util.TRANSITION_END, function(event3) {
                return _this2._hideModal(event3);
              }).emulateTransitionEnd(transitionDuration);
            } else
              this._hideModal();
          }
        }
      }, "hide"), _proto.dispose = /* @__PURE__ */ __name(function() {
        [window, this._element, this._dialog].forEach(function(htmlElement) {
          return $__default.default(htmlElement).off(EVENT_KEY$5);
        }), $__default.default(document).off(EVENT_FOCUSIN), $__default.default.removeData(this._element, DATA_KEY$5), this._config = null, this._element = null, this._dialog = null, this._backdrop = null, this._isShown = null, this._isBodyOverflowing = null, this._ignoreBackdropClick = null, this._isTransitioning = null, this._scrollbarWidth = null;
      }, "dispose"), _proto.handleUpdate = /* @__PURE__ */ __name(function() {
        this._adjustDialog();
      }, "handleUpdate"), _proto._getConfig = /* @__PURE__ */ __name(function(config2) {
        return config2 = _extends2({}, Default$4, config2), Util.typeCheckConfig(NAME$5, config2, DefaultType$4), config2;
      }, "_getConfig"), _proto._triggerBackdropTransition = /* @__PURE__ */ __name(function() {
        var _this3 = this, hideEventPrevented = $__default.default.Event(EVENT_HIDE_PREVENTED);
        if ($__default.default(this._element).trigger(hideEventPrevented), !hideEventPrevented.isDefaultPrevented()) {
          var isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;
          isModalOverflowing || (this._element.style.overflowY = "hidden"), this._element.classList.add(CLASS_NAME_STATIC);
          var modalTransitionDuration = Util.getTransitionDurationFromElement(this._dialog);
          $__default.default(this._element).off(Util.TRANSITION_END), $__default.default(this._element).one(Util.TRANSITION_END, function() {
            _this3._element.classList.remove(CLASS_NAME_STATIC), isModalOverflowing || $__default.default(_this3._element).one(Util.TRANSITION_END, function() {
              _this3._element.style.overflowY = "";
            }).emulateTransitionEnd(_this3._element, modalTransitionDuration);
          }).emulateTransitionEnd(modalTransitionDuration), this._element.focus();
        }
      }, "_triggerBackdropTransition"), _proto._showElement = /* @__PURE__ */ __name(function(relatedTarget) {
        var _this4 = this, transition2 = $__default.default(this._element).hasClass(CLASS_NAME_FADE$4), modalBody = this._dialog ? this._dialog.querySelector(SELECTOR_MODAL_BODY) : null;
        (!this._element.parentNode || this._element.parentNode.nodeType !== Node.ELEMENT_NODE) && document.body.appendChild(this._element), this._element.style.display = "block", this._element.removeAttribute("aria-hidden"), this._element.setAttribute("aria-modal", !0), this._element.setAttribute("role", "dialog"), $__default.default(this._dialog).hasClass(CLASS_NAME_SCROLLABLE) && modalBody ? modalBody.scrollTop = 0 : this._element.scrollTop = 0, transition2 && Util.reflow(this._element), $__default.default(this._element).addClass(CLASS_NAME_SHOW$4), this._config.focus && this._enforceFocus();
        var shownEvent = $__default.default.Event(EVENT_SHOWN$2, {
          relatedTarget
        }), transitionComplete = /* @__PURE__ */ __name(function() {
          _this4._config.focus && _this4._element.focus(), _this4._isTransitioning = !1, $__default.default(_this4._element).trigger(shownEvent);
        }, "transitionComplete");
        if (transition2) {
          var transitionDuration = Util.getTransitionDurationFromElement(this._dialog);
          $__default.default(this._dialog).one(Util.TRANSITION_END, transitionComplete).emulateTransitionEnd(transitionDuration);
        } else
          transitionComplete();
      }, "_showElement"), _proto._enforceFocus = /* @__PURE__ */ __name(function() {
        var _this5 = this;
        $__default.default(document).off(EVENT_FOCUSIN).on(EVENT_FOCUSIN, function(event2) {
          document !== event2.target && _this5._element !== event2.target && $__default.default(_this5._element).has(event2.target).length === 0 && _this5._element.focus();
        });
      }, "_enforceFocus"), _proto._setEscapeEvent = /* @__PURE__ */ __name(function() {
        var _this6 = this;
        this._isShown ? $__default.default(this._element).on(EVENT_KEYDOWN_DISMISS, function(event2) {
          _this6._config.keyboard && event2.which === ESCAPE_KEYCODE ? (event2.preventDefault(), _this6.hide()) : !_this6._config.keyboard && event2.which === ESCAPE_KEYCODE && _this6._triggerBackdropTransition();
        }) : this._isShown || $__default.default(this._element).off(EVENT_KEYDOWN_DISMISS);
      }, "_setEscapeEvent"), _proto._setResizeEvent = /* @__PURE__ */ __name(function() {
        var _this7 = this;
        this._isShown ? $__default.default(window).on(EVENT_RESIZE, function(event2) {
          return _this7.handleUpdate(event2);
        }) : $__default.default(window).off(EVENT_RESIZE);
      }, "_setResizeEvent"), _proto._hideModal = /* @__PURE__ */ __name(function() {
        var _this8 = this;
        this._element.style.display = "none", this._element.setAttribute("aria-hidden", !0), this._element.removeAttribute("aria-modal"), this._element.removeAttribute("role"), this._isTransitioning = !1, this._showBackdrop(function() {
          $__default.default(document.body).removeClass(CLASS_NAME_OPEN), _this8._resetAdjustments(), _this8._resetScrollbar(), $__default.default(_this8._element).trigger(EVENT_HIDDEN$2);
        });
      }, "_hideModal"), _proto._removeBackdrop = /* @__PURE__ */ __name(function() {
        this._backdrop && ($__default.default(this._backdrop).remove(), this._backdrop = null);
      }, "_removeBackdrop"), _proto._showBackdrop = /* @__PURE__ */ __name(function(callback) {
        var _this9 = this, animate = $__default.default(this._element).hasClass(CLASS_NAME_FADE$4) ? CLASS_NAME_FADE$4 : "";
        if (this._isShown && this._config.backdrop) {
          if (this._backdrop = document.createElement("div"), this._backdrop.className = CLASS_NAME_BACKDROP, animate && this._backdrop.classList.add(animate), $__default.default(this._backdrop).appendTo(document.body), $__default.default(this._element).on(EVENT_CLICK_DISMISS$1, function(event2) {
            if (_this9._ignoreBackdropClick) {
              _this9._ignoreBackdropClick = !1;
              return;
            }
            event2.target === event2.currentTarget && (_this9._config.backdrop === "static" ? _this9._triggerBackdropTransition() : _this9.hide());
          }), animate && Util.reflow(this._backdrop), $__default.default(this._backdrop).addClass(CLASS_NAME_SHOW$4), !callback)
            return;
          if (!animate) {
            callback();
            return;
          }
          var backdropTransitionDuration = Util.getTransitionDurationFromElement(this._backdrop);
          $__default.default(this._backdrop).one(Util.TRANSITION_END, callback).emulateTransitionEnd(backdropTransitionDuration);
        } else if (!this._isShown && this._backdrop) {
          $__default.default(this._backdrop).removeClass(CLASS_NAME_SHOW$4);
          var callbackRemove = /* @__PURE__ */ __name(function() {
            _this9._removeBackdrop(), callback && callback();
          }, "callbackRemove");
          if ($__default.default(this._element).hasClass(CLASS_NAME_FADE$4)) {
            var _backdropTransitionDuration = Util.getTransitionDurationFromElement(this._backdrop);
            $__default.default(this._backdrop).one(Util.TRANSITION_END, callbackRemove).emulateTransitionEnd(_backdropTransitionDuration);
          } else
            callbackRemove();
        } else callback && callback();
      }, "_showBackdrop"), _proto._adjustDialog = /* @__PURE__ */ __name(function() {
        var isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;
        !this._isBodyOverflowing && isModalOverflowing && (this._element.style.paddingLeft = this._scrollbarWidth + "px"), this._isBodyOverflowing && !isModalOverflowing && (this._element.style.paddingRight = this._scrollbarWidth + "px");
      }, "_adjustDialog"), _proto._resetAdjustments = /* @__PURE__ */ __name(function() {
        this._element.style.paddingLeft = "", this._element.style.paddingRight = "";
      }, "_resetAdjustments"), _proto._checkScrollbar = /* @__PURE__ */ __name(function() {
        var rect = document.body.getBoundingClientRect();
        this._isBodyOverflowing = Math.round(rect.left + rect.right) < window.innerWidth, this._scrollbarWidth = this._getScrollbarWidth();
      }, "_checkScrollbar"), _proto._setScrollbar = /* @__PURE__ */ __name(function() {
        var _this10 = this;
        if (this._isBodyOverflowing) {
          var fixedContent = [].slice.call(document.querySelectorAll(SELECTOR_FIXED_CONTENT2)), stickyContent = [].slice.call(document.querySelectorAll(SELECTOR_STICKY_CONTENT2));
          $__default.default(fixedContent).each(function(index3, element) {
            var actualPadding2 = element.style.paddingRight, calculatedPadding2 = $__default.default(element).css("padding-right");
            $__default.default(element).data("padding-right", actualPadding2).css("padding-right", parseFloat(calculatedPadding2) + _this10._scrollbarWidth + "px");
          }), $__default.default(stickyContent).each(function(index3, element) {
            var actualMargin = element.style.marginRight, calculatedMargin = $__default.default(element).css("margin-right");
            $__default.default(element).data("margin-right", actualMargin).css("margin-right", parseFloat(calculatedMargin) - _this10._scrollbarWidth + "px");
          });
          var actualPadding = document.body.style.paddingRight, calculatedPadding = $__default.default(document.body).css("padding-right");
          $__default.default(document.body).data("padding-right", actualPadding).css("padding-right", parseFloat(calculatedPadding) + this._scrollbarWidth + "px");
        }
        $__default.default(document.body).addClass(CLASS_NAME_OPEN);
      }, "_setScrollbar"), _proto._resetScrollbar = /* @__PURE__ */ __name(function() {
        var fixedContent = [].slice.call(document.querySelectorAll(SELECTOR_FIXED_CONTENT2));
        $__default.default(fixedContent).each(function(index3, element) {
          var padding3 = $__default.default(element).data("padding-right");
          $__default.default(element).removeData("padding-right"), element.style.paddingRight = padding3 || "";
        });
        var elements = [].slice.call(document.querySelectorAll("" + SELECTOR_STICKY_CONTENT2));
        $__default.default(elements).each(function(index3, element) {
          var margin = $__default.default(element).data("margin-right");
          typeof margin < "u" && $__default.default(element).css("margin-right", margin).removeData("margin-right");
        });
        var padding2 = $__default.default(document.body).data("padding-right");
        $__default.default(document.body).removeData("padding-right"), document.body.style.paddingRight = padding2 || "";
      }, "_resetScrollbar"), _proto._getScrollbarWidth = /* @__PURE__ */ __name(function() {
        var scrollDiv = document.createElement("div");
        scrollDiv.className = CLASS_NAME_SCROLLBAR_MEASURER, document.body.appendChild(scrollDiv);
        var scrollbarWidth = scrollDiv.getBoundingClientRect().width - scrollDiv.clientWidth;
        return document.body.removeChild(scrollDiv), scrollbarWidth;
      }, "_getScrollbarWidth"), Modal2._jQueryInterface = /* @__PURE__ */ __name(function(config2, relatedTarget) {
        return this.each(function() {
          var data49 = $__default.default(this).data(DATA_KEY$5), _config = _extends2({}, Default$4, $__default.default(this).data(), typeof config2 == "object" && config2 ? config2 : {});
          if (data49 || (data49 = new Modal2(this, _config), $__default.default(this).data(DATA_KEY$5, data49)), typeof config2 == "string") {
            if (typeof data49[config2] > "u")
              throw new TypeError('No method named "' + config2 + '"');
            data49[config2](relatedTarget);
          } else _config.show && data49.show(relatedTarget);
        });
      }, "_jQueryInterface"), 