var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, an as ItemNotePriority, d as IndexingClient, T as Transformer, b as baseUrl, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { I as ItemNoteAlert } from "./itemNoteAlert-Do9RDMvA.js";
import { P as PrioritySelect } from "./prioritySelect-DJ_o_pQH.js";
import { I as IconSelect } from "./iconSelect-BeUqYgP_.js";
import { e as getParsedString } from "./noteDisplayHelper-0E8yeVJ1.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let ItemNoteModal$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "item");
    __publicField(this, "parseTitleAndMessage");
    __publicField(this, "showNewNotePanel", !1);
    __publicField(this, "newNote", {
      title: "",
      message: "",
      priority: ItemNotePriority.Information,
      icon: "",
      sticky: !0,
      metadata: []
    });
  }
  mounted() {
  }
  parseText(titleOrMessage) {
    return this.parseTitleAndMessage ? getParsedString(titleOrMessage) : titleOrMessage;
  }
  closeModal() {
    this.$emit("close");
  }
  getIcon(note) {
    return note.icon ? note.icon : "sticky-note";
  }
  get itemName() {
    return this.item.name ? this.item.name : this.item.file.name;
  }
  async addNote() {
    let addedNote = await new IndexingClient(new Transformer(), baseUrl()).addNote(this.item.id, this.newNote);
    this.item.notes.push(addedNote), this.showNewNotePanel = !1, this.newNote = {
      title: "",
      message: "",
      priority: ItemNotePriority.Information,
      icon: "",
      sticky: !0,
      metadata: []
    };
  }
  async removeNote(note) {
    await new IndexingClient(new Transformer(), baseUrl()).removeNote(this.item.id, note.id);
    let notes = this.notes.slice();
    notes.splice(this.notes.indexOf(note), 1), this.notes = notes;
  }
  get notes() {
    return this.item.notes;
  }
  set notes(notes) {
    this.item.notes = notes;
  }
  get itemNoteModalFields() {
    return [
      { key: "priority", label: "Priority", sortable: !1 },
      { key: "title", label: "Title", sortable: !0 },
      { key: "message", label: "Message", sortable: !0 },
      //{ key: 'timestamp', label: 'Created', sortable: true },
      { key: "actions", label: "", sortable: !1 }
    ];
  }
  getNoteVariant(note) {
    if (note && note.priority)
      switch (note.priority) {
        case ItemNotePriority.Information:
          return "info";
        case ItemNotePriority.Success:
          return "success";
        case ItemNotePriority.Warning:
          return "warning";
        case ItemNotePriority.Danger:
          return "danger";
        default:
          return "info";
      }
    return null;
  }
}, __name(_a, "ItemNoteModal"), _a);
__decorateClass([
  Prop({
    required: !0
  })
], ItemNoteModal$1.prototype, "item", 2);
__decorateClass([
  Prop({
    required: !1,
    default: !1
  })
], ItemNoteModal$1.prototype, "parseTitleAndMessage", 2);
ItemNoteModal$1 = __decorateClass([
  Component({
    components: { IconSelect, PrioritySelect, DateDisplay, ItemNoteAlert }
  })
], ItemNoteModal$1);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { id: _vm.item.id + "notes-modal", size: "lg" }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h4", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "sticky-note" } }), _vm._v(" Notes management")], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return cancel();
    }, "click") } }, [_vm._v(`
      Close
    `)])];
  }, "fn") }]) }, [_vm._v(" "), _c("span", [_c("b", [_vm._v(_vm._s(_vm.itemName))]), _vm._v(" "), _vm.showNewNotePanel ? _vm._e() : _c("span", { staticClass: "float-right mb-2" }, [_c("b-button", { attrs: { variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.showNewNotePanel = !_vm.showNewNotePanel;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add Note
      `)], 1)], 1)]), _vm._v(" "), _vm.showNewNotePanel ? _c("div", { staticClass: "mb-2" }, [_c("div", { staticClass: "row" }, [_c("priority-select", { model: { value: _vm.newNote.priority, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.newNote, "priority", $$v);
  }, "callback"), expression: "newNote.priority" } }), _vm._v(" "), _c("span", { staticClass: "col-sm-6" }, [_c("icon-select", { model: { value: _vm.newNote.icon, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.newNote, "icon", $$v);
  }, "callback"), expression: "newNote.icon" } })], 1)], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "titleInputGroup", label: "Title", "label-for": "titleInput" } }, [_c("b-form-input", { attrs: { id: "titleInput", type: "text" }, model: { value: _vm.newNote.title, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.newNote, "title", $$v);
  }, "callback"), expression: "newNote.title" } })], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "messageInputGroup", label: "Message", "label-for": "messageInput" } }, [_c("b-form-input", { attrs: { id: "messageInput", autofocus: "", type: "text" }, model: { value: _vm.newNote.message, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.newNote, "message", $$v);
  }, "callback"), expression: "newNote.message" } })], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "stickySwitchGroup", label: "Is Sticky", "label-for": "stickySwitch" } }, [_c("b-form-checkbox", { attrs: { name: "stickySwitch", switch: "" }, model: { value: _vm.newNote.sticky, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.newNote, "sticky", $$v);
  }, "callback"), expression: "newNote.sticky" } })], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "noteDisplayGroup", label: "Note display", "label-for": "noteDisplay" } }, [_c("item-note-alert", { attrs: { id: "noteDisplay", value: [_vm.newNote], dismissible: !1 } })], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.showNewNotePanel = !_vm.showNewNotePanel;
  }, "click") } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { variant: "success" }, on: { click: _vm.addNote } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Add Note")], 1)], 1) : _c("b-table", { attrs: { striped: "", hover: "", items: _vm.notes, fields: _vm.itemNoteModalFields, "sort-icon-left": "", "show-empty": "" }, scopedSlots: _vm._u([{ key: "empty", fn: /* @__PURE__ */ __name(function(scope) {
    return [_c("i", { staticClass: "text-muted" }, [_vm._v("There are no notes attached to this item")])];
  }, "fn") }, { key: "cell(priority)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: _vm.getNoteVariant(data.item), title: data.item.priority } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: _vm.getIcon(data.item) } })], 1), _vm._v(" "), data.item.sticky ? _c("b-badge", { attrs: { variant: "secondary" } }, [_c("font-awesome-icon", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "fa-fw", attrs: { icon: "thumbtack", title: "Sticky notes will persist after the item is processed" } })], 1) : _vm._e()];
  }, "fn") }, { key: "cell(title)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(`
      ` + _vm._s(_vm.parseText(data.item.title)) + `
    `)];
  }, "fn") }, { key: "cell(message)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("p", { domProps: { innerHTML: _vm._s(_vm.parseText(data.item.message)) } })];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-button", { staticClass: "float-right", attrs: { variant: "danger", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.removeNote(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)];
  }, "fn") }]) })], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  ItemNoteModal$1,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "168c9e70"
);
const ItemNoteModal = __component__.exports;
export {
  ItemNoteModal as I
};
