var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, b as baseUrl, n as normalizeComponent, d as IndexingClient, T as Transformer, t as toastr, W as Watch, aV as IndexingProcessingClient, aW as ItemPreProcessingStatus, aX as StageStatus, aY as JobStatus, aZ as ItemProcessingStatus, a_ as ProcessorStageStatus, a$ as ProcessingJobStatus, s as SortableHeader } from "./main-DAVWuHbi.js";
import { a as MetadataValue, i as isSingle, g as getTableHeaders, b as getTableValue, c as getMultiple, d as differenceIsMultiple, e as createdSingleSourceModels, f as createdSingleUpdatedModels, h as isTable, j as isObject, k as isMultiple, l as differenceIsTable, m as getObjectValues, M as MetadataSummary } from "./metadataSummary-BcmsGCgw.js";
import { E as EventLineUserDisplay, H as HistoryEventLookup, a as HistorySummary, b as HistoryEventLine } from "./historySummary-CNBwYP7S.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { A as AttributesValue } from "./attributesValue-DfDlL_KB.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
var __defProp$8 = Object.defineProperty, __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor, __decorateClass$8 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$8(target, key, result), result;
}, "__decorateClass$8"), _a;
let SplitItemNodeComponent$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "node");
    __publicField(this, "activeItemId");
    __publicField(this, "recursionAmount");
    __publicField(this, "loading", !1);
  }
  get hasChildren() {
    return this.node.children && this.node.children.length;
  }
  getFromItemUrl(itemId) {
    return new URL(baseUrl() + "/app/indexing/items/" + itemId).href;
  }
}, __name(_a, "SplitItemNodeComponent"), _a);
__decorateClass$8([
  Prop({ required: !0 })
], SplitItemNodeComponent$1.prototype, "node", 2);
__decorateClass$8([
  Prop({ required: !0 })
], SplitItemNodeComponent$1.prototype, "activeItemId", 2);
__decorateClass$8([
  Prop({ required: !0 })
], SplitItemNodeComponent$1.prototype, "recursionAmount", 2);
SplitItemNodeComponent$1 = __decorateClass$8([
  Component({
    components: {
      DateDisplay,
      "split-item-node": /* @__PURE__ */ __name(() => Promise.resolve().then(() => splitItemNode), "split-item-node")
    }
  })
], SplitItemNodeComponent$1);
var _sfc_render$8 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("li", { class: _vm.hasChildren ? "" : "mb-2" }, [_vm.hasChildren ? _c("details", { attrs: { open: "" } }, [_c("summary", { staticClass: "pl-1 mb-2" }, [_vm.node.status === "enqueued" && _vm.node.itemId != _vm.activeItemId ? _c("a", { attrs: { target: "_blank", href: _vm.getFromItemUrl(_vm.node.itemId) } }, [_vm._v(_vm._s(_vm.node.itemName))]) : _c("span", [_vm._v(_vm._s(_vm.node.itemName))]), _vm._v(" "), _vm.node.itemId === _vm.activeItemId ? _c("span", { staticClass: "text-warning ml-1" }, [_c("font-awesome-icon", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { icon: "star", title: "This is the current item you are viewing" } })], 1) : _vm._e()]), _vm._v(" "), _c("ul", _vm._l(_vm.node.children, function(child) {
    return _c("split-item-node", { key: child.itemId, attrs: { node: child, "active-item-id": _vm.activeItemId, name: child.itemId, "recursion-amount": _vm.recursionAmount + 1 } });
  }), 1)]) : _c("span", { staticClass: "pl-1" }, [_vm.node.status === "enqueued" && _vm.node.itemId != _vm.activeItemId ? _c("a", { attrs: { target: "_blank", href: _vm.getFromItemUrl(_vm.node.itemId) } }, [_vm._v(_vm._s(_vm.node.itemName))]) : _c("span", [_vm._v(_vm._s(_vm.node.itemName))]), _vm._v(" "), _vm.node.itemId === _vm.activeItemId ? _c("span", { staticClass: "text-warning ml-1" }, [_c("font-awesome-icon", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { icon: "star", title: "This is the current item you are viewing" } })], 1) : _vm._e()])]);
}, "render"), _sfc_staticRenderFns$8 = [], __component__$8 = /* @__PURE__ */ normalizeComponent(
  SplitItemNodeComponent$1,
  _sfc_render$8,
  _sfc_staticRenderFns$8,
  !1,
  null,
  "7a62e961"
);
const SplitItemNodeComponent = __component__$8.exports, splitItemNode = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: SplitItemNodeComponent
}, Symbol.toStringTag, { value: "Module" }));
var __defProp$7 = Object.defineProperty, __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor, __decorateClass$7 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$7(target, key, result), result;
}, "__decorateClass$7"), _a2;
let SplitItemSummaryComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "item");
    __publicField(this, "loading", !1);
    __publicField(this, "splitInfo", null);
  }
  async mounted() {
    await this.loadItemSplitInfo();
  }
  async loadItemSplitInfo() {
    this.splitInfo = null, this.loading = !0;
    try {
      this.splitInfo = await new IndexingClient(new Transformer(), baseUrl()).getItemSplitInfo(this.item.id);
    } catch (e) {
      toastr.error(e, "An error occurred while getting item split history");
    } finally {
      this.loading = !1;
    }
  }
}, __name(_a2, "SplitItemSummaryComponent"), _a2);
__decorateClass$7([
  Prop({ required: !0 })
], SplitItemSummaryComponent.prototype, "item", 2);
SplitItemSummaryComponent = __decorateClass$7([
  Component({
    components: { SplitItemNodeComponent, EventLineUserDisplay, DateDisplay, SplitItemSummaryComponent }
  })
], SplitItemSummaryComponent);
var _sfc_render$7 = /* @__PURE__ */ __name(function() {
  var _a10;
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [!_vm.splitInfo || ((_a10 = _vm.splitInfo.children) == null ? void 0 : _a10.length) === 0 ? _c("div", [_c("em", [_vm._v("No Splits or unable to find split information")])]) : _c("ul", { staticClass: "tree" }, [_vm.splitInfo ? _c("split-item-node-component", { key: _vm.splitInfo.itemId, attrs: { node: _vm.splitInfo, "active-item-id": _vm.item.id, name: _vm.splitInfo.itemId, "recursion-amount": 0 } }) : _vm._e()], 1)]);
}, "render"), _sfc_staticRenderFns$7 = [], __component__$7 = /* @__PURE__ */ normalizeComponent(
  SplitItemSummaryComponent,
  _sfc_render$7,
  _sfc_staticRenderFns$7,
  !1,
  null,
  "97607bb2"
);
const SplitItemsSummary = __component__$7.exports;
var __defProp$6 = Object.defineProperty, __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$6(target, key, result), result;
}, "__decorateClass$6"), _a3;
let MetadataSummaryComponent$3 = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "originalString");
    __publicField(this, "updateString");
    __publicField(this, "itemName");
    __publicField(this, "showLabel");
    __publicField(this, "alwaysShowValue");
  }
  get itemAdded() {
    return !this.originalString && this.updateString;
  }
  get itemRemoved() {
    return !this.updateString && this.originalString;
  }
  get itemChanged() {
    return this.updateString && this.originalString && this.updateString != this.originalString;
  }
}, __name(_a3, "MetadataSummaryComponent"), _a3);
__decorateClass$6([
  Prop({ required: !0 })
], MetadataSummaryComponent$3.prototype, "originalString", 2);
__decorateClass$6([
  Prop({ required: !0 })
], MetadataSummaryComponent$3.prototype, "updateString", 2);
__decorateClass$6([
  Prop({ required: !0 })
], MetadataSummaryComponent$3.prototype, "itemName", 2);
__decorateClass$6([
  Prop({ required: !1, default: !0 })
], MetadataSummaryComponent$3.prototype, "showLabel", 2);
__decorateClass$6([
  Prop({ required: !1, default: !1 })
], MetadataSummaryComponent$3.prototype, "alwaysShowValue", 2);
MetadataSummaryComponent$3 = __decorateClass$6([
  Component({
    methods: { isSingle },
    components: { AttributesValue, MetadataValue }
  })
], MetadataSummaryComponent$3);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("span", [_vm.originalString != _vm.updateString && !(!_vm.originalString && !_vm.updateString) ? _c("span", [_vm.showLabel ? _c("span", [_c("span", { staticClass: "font-weight-bold" }, [_vm._v(_vm._s(_vm.itemName))]), _vm._v(" "), _vm.itemAdded ? _c("span", [_c("b-badge", { attrs: { variant: "success" } }, [_vm._v("Added")])], 1) : _vm._e(), _vm._v(" "), _vm.itemRemoved ? _c("span", [_c("b-badge", { attrs: { variant: "danger" } }, [_vm._v("Removed")])], 1) : _vm._e(), _vm._v(" "), _vm.itemChanged ? _c("span", [_c("b-badge", { attrs: { variant: "info" } }, [_vm._v("Changed")])], 1) : _vm._e(), _vm._v(" "), _c("br"), _vm._v(" "), _vm.originalString ? _c("span", [_vm._v(_vm._s(_vm.originalString))]) : _c("b-badge", { staticClass: "font-italic", attrs: { variant: "light" } }, [_vm._v("No value")]), _vm._v(" "), _c("font-awesome-icon", { staticClass: "ml-1", attrs: { icon: "arrow-right" } }), _vm._v(" "), _vm.updateString ? _c("span", [_vm._v(_vm._s(_vm.updateString))]) : _c("b-badge", { staticClass: "font-italic", attrs: { variant: "light" } }, [_vm._v("No value")])], 1) : _c("span", [_vm.itemAdded ? _c("span", [_c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { pill: "", variant: "success", title: "Added" } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } })], 1), _vm._v(`
        ` + _vm._s(_vm.updateString) + `
      `)], 1) : _vm._e(), _vm._v(" "), _vm.itemRemoved ? _c("span", [_c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { pill: "", variant: "danger", title: "Removed" } }, [_c("font-awesome-icon", { attrs: { icon: "minus" } })], 1), _vm._v(`
        ` + _vm._s(_vm.originalString) + `
      `)], 1) : _vm._e(), _vm._v(" "), _vm.itemChanged ? _c("span", [_c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { pill: "", variant: "info", title: "Changed" } }, [_c("font-awesome-icon", { attrs: { icon: "swap" } })], 1), _vm._v(" "), _vm.originalString ? _c("span", [_vm._v(_vm._s(_vm.originalString))]) : _vm._e(), _vm._v(" "), _c("font-awesome-icon", { staticClass: "ml-1", attrs: { icon: "arrow-right" } }), _vm._v(" "), _vm.updateString ? _c("span", [_vm._v(_vm._s(_vm.updateString))]) : _vm._e()], 1) : _vm._e()])]) : _vm.alwaysShowValue ? _c("span", [_vm.updateString ? _c("span", [_vm._v(_vm._s(_vm.originalString))]) : _vm.originalString ? _c("span", [_vm._v(_vm._s(_vm.updateString))]) : _vm._e()]) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  MetadataSummaryComponent$3,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  "7dea1252"
);
const MetadataDifference = __component__$6.exports;
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$5"), _a4;
let MetadataSummaryComponent$2 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "originalCollectionValue");
    __publicField(this, "updatedCollectionValue");
    __publicField(this, "itemName");
    __publicField(this, "showLabel");
    __publicField(this, "alwaysShowValue");
  }
  get originalCollectionString() {
    return this.originalCollectionValue && this.originalCollectionValue.values ? getMultiple(this.originalCollectionValue).toString() : null;
  }
  get updatedCollectionString() {
    return this.updatedCollectionValue && this.updatedCollectionValue.values ? getMultiple(this.updatedCollectionValue).toString() : null;
  }
  async mounted() {
  }
}, __name(_a4, "MetadataSummaryComponent"), _a4);
__decorateClass$5([
  Prop({ required: !0 })
], MetadataSummaryComponent$2.prototype, "originalCollectionValue", 2);
__decorateClass$5([
  Prop({ required: !0 })
], MetadataSummaryComponent$2.prototype, "updatedCollectionValue", 2);
__decorateClass$5([
  Prop({ required: !0 })
], MetadataSummaryComponent$2.prototype, "itemName", 2);
__decorateClass$5([
  Prop({ required: !1, default: !0 })
], MetadataSummaryComponent$2.prototype, "showLabel", 2);
__decorateClass$5([
  Prop({ required: !1, default: !1 })
], MetadataSummaryComponent$2.prototype, "alwaysShowValue", 2);
MetadataSummaryComponent$2 = __decorateClass$5([
  Component({
    methods: { getMultiple, getTableValue, getTableHeaders },
    components: { MetadataDifference, AttributesValue, MetadataValue }
  })
], MetadataSummaryComponent$2);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("metadata-difference", { attrs: { "original-string": _vm.originalCollectionString, "update-string": _vm.updatedCollectionString, "item-name": _vm.itemName, "show-label": _vm.showLabel, "always-show-value": _vm.alwaysShowValue } });
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  MetadataSummaryComponent$2,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  "c957655a"
);
const MetadataCollectionDifference = __component__$5.exports;
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$4"), _a5;
let MetadataSummaryComponent$1 = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "originalCollection");
    __publicField(this, "updatedCollection");
    __publicField(this, "itemName");
    __publicField(this, "tableHeaders", []);
    __publicField(this, "originalRows", []);
    __publicField(this, "updatedRows", []);
    __publicField(this, "metadataDifferenceRows", []);
  }
  async mounted() {
    await this.getCombinedTableHeaders(), await this.getOriginalModels(), await this.createOriginalCombinedModels(), await this.getUpdatedModels(), await this.createUpdatedCombinedModels();
  }
  async getCombinedTableHeaders() {
    if (this.originalCollection && this.originalCollection.values)
      for (const metadataItem of this.originalCollection.values)
        this.tableHeaders = getTableHeaders(this.originalCollection);
    if (this.updatedCollection && this.updatedCollection.values)
      for (const metadataItem of this.updatedCollection.values)
        getTableHeaders(this.updatedCollection).forEach((updatedTableHeader) => {
          this.tableHeaders.map((header) => header.id).includes(updatedTableHeader.id) || this.tableHeaders.push(updatedTableHeader);
        });
  }
  async getOriginalModels() {
    if (this.originalCollection && this.originalCollection.values)
      for (const metadataItem of this.originalCollection.values) {
        let rowValues = [];
        this.tableHeaders.forEach((header) => {
          let rowValue = getTableValue(metadataItem, { id: header.id, name: header.id });
          rowValues.push(rowValue);
        }), this.originalRows.push(rowValues);
      }
  }
  async getUpdatedModels() {
    if (this.updatedCollection && this.updatedCollection.values)
      for (const metadataItem of this.updatedCollection.values) {
        let rowValues = [];
        this.tableHeaders.forEach((header) => {
          let rowValue = getTableValue(metadataItem, { id: header.id, name: header.id });
          rowValues.push(rowValue);
        }), this.updatedRows.push(rowValues);
      }
  }
  async createOriginalCombinedModels() {
    let originalResults = [];
    for (const row of this.originalRows)
      await createdSingleSourceModels(row, originalResults), this.metadataDifferenceRows.push(originalResults);
  }
  async createUpdatedCombinedModels() {
    for (const row of this.updatedRows) {
      const index = this.updatedRows.indexOf(row);
      let updatedResults = [];
      if (index + 1 > this.originalRows.length)
        await createdSingleUpdatedModels(row, updatedResults), this.metadataDifferenceRows.push(updatedResults);
      else {
        let rowToUpdate = this.metadataDifferenceRows[index];
        await createdSingleUpdatedModels(row, rowToUpdate), this.metadataDifferenceRows[index] = rowToUpdate;
      }
    }
  }
}, __name(_a5, "MetadataSummaryComponent"), _a5);
__decorateClass$4([
  Prop({ required: !0, default: { values: [] } })
], MetadataSummaryComponent$1.prototype, "originalCollection", 2);
__decorateClass$4([
  Prop({ required: !0, default: { values: [] } })
], MetadataSummaryComponent$1.prototype, "updatedCollection", 2);
__decorateClass$4([
  Prop({ required: !0 })
], MetadataSummaryComponent$1.prototype, "itemName", 2);
MetadataSummaryComponent$1 = __decorateClass$4([
  Component({
    methods: { differenceIsMultiple, isSingle, getTableValue, getTableHeaders },
    components: { MetadataCollectionDifference, MetadataDifference, AttributesValue, MetadataValue }
  })
], MetadataSummaryComponent$1);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _vm.metadataDifferenceRows && _vm.metadataDifferenceRows.length && _vm.originalCollection !== _vm.updatedCollection ? _c("span", [_c("span", { staticClass: "font-weight-bold" }, [_vm._v(_vm._s(_vm.itemName))]), _vm._v(" "), _c("table", { staticClass: "table table-sm table-bordered" }, [_c("thead", [_c("tr", _vm._l(_vm.tableHeaders, function(header) {
    return _c("th", { staticStyle: { "word-break": "keep-all", "white-space": "nowrap" } }, [[_vm._v(`
                  ` + _vm._s(header.id) + `
              `)]], 2);
  }), 0)]), _vm._v(" "), _c("tbody", _vm._l(_vm.metadataDifferenceRows, function(row) {
    return _c("tr", _vm._l(row, function(metadataDifferenceModel) {
      return _c("td", { staticStyle: { "word-break": "keep-all", "white-space": "nowrap" } }, [_vm.isSingle(metadataDifferenceModel) ? _c("metadata-difference", { attrs: { "original-string": metadataDifferenceModel.originalValue, "update-string": metadataDifferenceModel.updatedValue, "item-name": metadataDifferenceModel.name, "show-label": !1, alwaysShowValue: !0 } }) : _vm.differenceIsMultiple(metadataDifferenceModel) ? _c("metadata-collection-difference", { attrs: { "item-name": metadataDifferenceModel.name, "show-label": !1, alwaysShowValue: !0, "original-collection-value": metadataDifferenceModel.originalValue, "updated-collection-value": metadataDifferenceModel.updatedValue } }) : _vm._e()], 1);
    }), 0);
  }), 0)])]) : _vm._e();
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  MetadataSummaryComponent$1,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  "156bd18c"
);
const MetadataTableDifference = __component__$4.exports;
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$3"), _a6;
let MetadataSummaryComponent = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "itemHistoryResponse");
    __publicField(this, "metadataDifferenceModels", []);
    __publicField(this, "selectedSource", null);
    __publicField(this, "selectedTarget", null);
    __publicField(this, "historyLookup", HistoryEventLookup);
    __publicField(this, "loading", !1);
  }
  async selectedSourceUpdate() {
    await this.setMetadataDifferenceModels();
  }
  async selectedTargetUpdate() {
    await this.setMetadataDifferenceModels();
  }
  async mounted() {
    this.selectedSource = this.getFirstHistoryEvent, this.selectedTarget = this.itemHistoryResponse, await this.setMetadataDifferenceModels();
  }
  async setMetadataDifferenceModels() {
    if (this.loading = !0, this.metadataDifferenceModels = [], this.selectedSource && this.selectedSource.metadata && this.selectedTarget && this.selectedTarget.metadata) {
      let sourceMetadata = this.selectedSource.metadata, sourcePayloadMetadata = this.getPayloadMetadata(this.selectedSource);
      sourcePayloadMetadata && (sourceMetadata = sourcePayloadMetadata);
      let targetMetadata = this.selectedTarget.metadata, targetPayloadMetadata = this.getPayloadMetadata(this.selectedTarget);
      targetPayloadMetadata && (targetMetadata = targetPayloadMetadata), await createdSingleSourceModels(sourceMetadata, this.metadataDifferenceModels), await createdSingleUpdatedModels(targetMetadata, this.metadataDifferenceModels), this.loading = !1;
    } else
      this.loading = !1;
  }
  get historyEvents() {
    return this.itemHistoryResponse ? this.itemHistoryResponse.events : [];
  }
  get getFirstHistoryEvent() {
    var _a10;
    let createdEvents = (_a10 = this.historyEvents) == null ? void 0 : _a10.filter((y) => y.type == "FileCreated" && y.metadata && y.metadata.length).sort(function(a, b) {
      return new Date(b.timestamp) - new Date(a.timestamp);
    });
    if (createdEvents.length)
      return createdEvents[0];
    {
      let selectableEvents = this.getSelectableHistoryEvents.reverse();
      if (selectableEvents.length)
        return selectableEvents[0];
    }
    return this.itemHistoryResponse;
  }
  get getSelectableHistoryEvents() {
    return this.historyEvents.filter((y) => y.metadata && y.metadata.length && y.type === "EzeScan.WebApps.Indexing.Action" || y.type == "FileCreated").sort(function(a, b) {
      return new Date(b.timestamp) - new Date(a.timestamp);
    });
  }
  get selectableOptions() {
    let options = this.getSelectableHistoryEvents.map((historyEvent) => {
      let eventName = this.getSelectedHistoryLookup(historyEvent);
      return { value: historyEvent, text: eventName + " - " + this.$options.filters.dateFromNow(historyEvent.timestamp) };
    });
    return options.unshift({ value: this.itemHistoryResponse, text: "Current" }), options;
  }
  getSelectedHistoryLookup(historyEvent) {
    let actionName = this.getActionName(historyEvent);
    if (actionName)
      return actionName;
    {
      let lookupEntry = this.historyLookup.find((lookup) => lookup.id == historyEvent.type);
      return lookupEntry != null && lookupEntry.name ? lookupEntry == null ? void 0 : lookupEntry.name : lookupEntry == null ? void 0 : lookupEntry.id;
    }
  }
  getPayloadMetadata(historyEvent) {
    let actionMetadata = historyEvent.metadata.find((data) => data.id === "payload");
    if (actionMetadata)
      return getObjectValues(actionMetadata);
  }
  getActionMetadata(historyEvent) {
    let actionMetadata = historyEvent.metadata.find((data) => data.id === "action");
    if (actionMetadata)
      return actionMetadata.value;
  }
  getActionName(historyEvent) {
    let actionMetadata = this.getActionMetadata(historyEvent);
    if (actionMetadata && actionMetadata.name)
      return actionMetadata.name.value;
  }
}, __name(_a6, "MetadataSummaryComponent"), _a6);
__decorateClass$3([
  Prop({ required: !0 })
], MetadataSummaryComponent.prototype, "itemHistoryResponse", 2);
__decorateClass$3([
  Watch("selectedSource")
], MetadataSummaryComponent.prototype, "selectedSourceUpdate", 1);
__decorateClass$3([
  Watch("selectedTarget")
], MetadataSummaryComponent.prototype, "selectedTargetUpdate", 1);
MetadataSummaryComponent = __decorateClass$3([
  Component({
    methods: { differenceIsTable, differenceIsMultiple, isMultiple, isObject, isSingle, isTable },
    components: {
      MetadataTableDifference,
      MetadataCollectionDifference,
      MetadataDifference,
      AttributesValue,
      MetadataValue
    }
  })
], MetadataSummaryComponent);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_vm.itemHistoryResponse ? _c("b-row", [_c("b-col", [_c("b-input-group", [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_vm._v(`
          Source Event
        `)]), _vm._v(" "), _c("b-form-select", { attrs: { options: _vm.selectableOptions, disabled: _vm.selectableOptions.length === 2 }, on: { change: /* @__PURE__ */ __name(function($event) {
    return _vm.setMetadataDifferenceModels();
  }, "change") }, model: { value: _vm.selectedSource, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.selectedSource = $$v;
  }, "callback"), expression: "selectedSource" } })], 1)], 1), _vm._v(" "), _c("b-col", [_c("b-input-group", [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_vm._v(`
          Target Event
        `)]), _vm._v(" "), _c("b-form-select", { attrs: { options: _vm.selectableOptions, disabled: _vm.selectableOptions.length === 2 }, on: { change: /* @__PURE__ */ __name(function($event) {
    return _vm.setMetadataDifferenceModels();
  }, "change") }, model: { value: _vm.selectedTarget, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.selectedTarget = $$v;
  }, "callback"), expression: "selectedTarget" } })], 1)], 1)], 1) : _vm._e(), _vm._v(" "), _vm._l(_vm.metadataDifferenceModels, function(metadataDifferenceModel) {
    return _vm.metadataDifferenceModels && !_vm.loading ? _c("b-row", [_c("b-col", { staticStyle: { "overflow-x": "auto" } }, [_vm.isSingle(metadataDifferenceModel) ? _c("metadata-difference", { attrs: { "original-string": metadataDifferenceModel.originalValue, "update-string": metadataDifferenceModel.updatedValue, "item-name": metadataDifferenceModel.name } }) : _vm.isObject(metadataDifferenceModel) ? _c("metadata-difference", { attrs: { "original-string": metadataDifferenceModel.originalValue, "update-string": metadataDifferenceModel.updatedValue, "item-name": metadataDifferenceModel.name } }) : _vm.differenceIsMultiple(metadataDifferenceModel) ? _c("metadata-collection-difference", { attrs: { "item-name": metadataDifferenceModel.name, "original-collection-value": metadataDifferenceModel.originalValue, "updated-collection-value": metadataDifferenceModel.updatedValue } }) : _vm.differenceIsTable(metadataDifferenceModel) ? _c("metadata-table-difference", { attrs: { "original-collection": metadataDifferenceModel.originalValue, "updated-collection": metadataDifferenceModel.updatedValue, "item-name": metadataDifferenceModel.name } }) : _vm._e()], 1)], 1) : _vm._e();
  }), _vm._v(" "), !_vm.loading && _vm.selectableOptions.length === 1 ? _c("b-row", [_c("b-col", [_c("b-alert", { staticClass: "mt-2", attrs: { show: "", variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
        There are no events to select from.
      `)], 1)], 1)], 1) : _vm._e()], 2);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  MetadataSummaryComponent,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  "15f9ea39"
);
const MetadataDifferencesSummary = __component__$3.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$2"), _a7;
let ItemHistoryPreProcessors = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "itemId");
    __publicField(this, "model", null);
    __publicField(this, "tableItems", []);
    __publicField(this, "loading", !0);
    __publicField(this, "page", 1);
    __publicField(this, "pageSize", 50);
    __publicField(this, "rowDetailIds", []);
  }
  async pageChanged() {
    await this.getPreProcessingInfo(!0);
  }
  mounted() {
    this.getPreProcessingInfo(!0);
  }
  async getPreProcessingInfo(setLoading) {
    this.loading = setLoading;
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    this.model = await processingClient.getItemPreProcessingSummary(this.itemId, this.page, this.pageSize), this.tableItems = this.model.items.map((t) => ({
      id: t.id,
      item: t.item,
      name: t.name,
      finished: t.finished,
      started: t.started,
      status: t.status,
      stages: t.stages,
      _showDetails: this.rowDetailIds.includes(t.id)
    })), this.loading = !1;
  }
  downloadJobLog(job) {
    return new URL(baseUrl() + "/api/processing/preProcessing/jobs/" + job.id).href;
  }
  viewPreProcessorLog(processorId) {
    return new URL(baseUrl() + "/api/processing/preProcessing/processor/" + processorId + "/log").href;
  }
  toggleRowDetails(row) {
    row.toggleDetails(), this.rowDetailIds.includes(row.item.id) ? this.rowDetailIds = this.rowDetailIds.filter(function(i) {
      return i !== row.item.id;
    }) : this.rowDetailIds.push(row.item.id);
  }
  getStageName(stage) {
    return stage.name ? stage.name : "Pre-Processor not found";
  }
  get totalPages() {
    if (this.model)
      return this.model.totalPages;
  }
  getPreProcessorStatusClass(processor) {
    let buttonClass = "";
    switch (processor.status) {
      case ItemPreProcessingStatus.Pending:
        buttonClass += "warning";
        break;
      case ItemPreProcessingStatus.Running:
        buttonClass += "primary";
        break;
      case ItemPreProcessingStatus.Successful:
      case ItemPreProcessingStatus.Skipped:
      case ItemPreProcessingStatus.Split:
        buttonClass += "success";
        break;
      case ItemPreProcessingStatus.Failed:
        buttonClass += "danger";
        break;
      case ItemPreProcessingStatus.Queued:
      case ItemPreProcessingStatus.Cancelled:
        buttonClass += "secondary";
        break;
    }
    return buttonClass;
  }
  getStatusIcon(processor) {
    switch (processor.status) {
      case ItemPreProcessingStatus.Pending:
      case ItemPreProcessingStatus.Queued:
        return "clock";
      case ItemPreProcessingStatus.Running:
        return "circle-ellipsis";
      case ItemPreProcessingStatus.Successful:
        return "check-circle";
      case ItemPreProcessingStatus.Split:
        return "clone";
      case ItemPreProcessingStatus.Cancelled:
        return "ban";
      case ItemPreProcessingStatus.Skipped:
        return "circle-chevron-right";
      case ItemPreProcessingStatus.Failed:
        return "times-circle";
      default:
        return "question";
    }
  }
  getStatusTitle(processor) {
    switch (processor.status) {
      case ItemPreProcessingStatus.Pending:
        return "Waiting to start";
      case ItemPreProcessingStatus.Queued:
        return "Queued to run";
      default:
        return this.$options.filters.capitaliseFirstLetter(processor.status ? processor.status : "Unknown");
    }
  }
  getStageIcon(stage) {
    switch (stage.status) {
      case StageStatus.Pending:
      case StageStatus.Queued:
        return "clock";
      case StageStatus.Running:
        return "circle-ellipsis";
      case StageStatus.Success:
        return "check-circle";
      case StageStatus.Skipped:
        return "circle-chevron-right";
      case StageStatus.Cancelled:
        return "ban";
      case StageStatus.Failed:
        return "times-circle";
      case StageStatus.Split:
        return "clone";
    }
  }
  getJobIcon(job) {
    switch (job.status) {
      case JobStatus.Success:
        return "check-circle";
      case JobStatus.Failed:
        return "times-circle";
      case JobStatus.Skipped:
        return "circle-chevron-right";
      case JobStatus.Cancelled:
        return "ban";
      case JobStatus.Running:
        return "circle-ellipsis";
      default:
        return "";
    }
  }
  getStageItemProcessingStatusTitle(processorStage) {
    switch (processorStage.status) {
      case StageStatus.Pending:
        return "Waiting to start";
      case StageStatus.Queued:
        return "Queued to run";
      default:
        return this.$options.filters.capitaliseFirstLetter(processorStage.status ? processorStage.status : "Unknown");
    }
  }
  getStageClass(stage) {
    let stageButtonClass = "";
    switch (stage.status) {
      case StageStatus.Pending:
        stageButtonClass += "warning";
        break;
      case StageStatus.Running:
        stageButtonClass += "primary";
        break;
      case StageStatus.Success:
        stageButtonClass += "success";
        break;
      case StageStatus.Queued:
      case StageStatus.Cancelled:
      case StageStatus.Skipped:
        stageButtonClass += "secondary";
        break;
      case StageStatus.Failed:
        stageButtonClass += "danger";
        break;
      case StageStatus.Split:
        stageButtonClass += "success";
        break;
    }
    return stageButtonClass;
  }
  getJobTextClass(job) {
    switch (job.status) {
      case JobStatus.Success:
        return "success";
      case JobStatus.Failed:
        return "danger";
      case JobStatus.Skipped:
      case JobStatus.Cancelled:
        return "secondary";
      case JobStatus.Running:
        return "primary";
      default:
        return "";
    }
  }
  get tableFields() {
    return [
      { key: "started", label: "Started", sortable: !1, thClass: "align-middle" },
      { key: "status", label: "Status", sortable: !1, thClass: "align-middle" },
      { key: "completed", label: "Completed", sortable: !1, thClass: "align-middle" },
      { key: "actions", label: "", sortable: !1 }
    ];
  }
}, __name(_a7, "ItemHistoryPreProcessors"), _a7);
__decorateClass$2([
  Prop()
], ItemHistoryPreProcessors.prototype, "itemId", 2);
__decorateClass$2([
  Watch("page")
], ItemHistoryPreProcessors.prototype, "pageChanged", 1);
ItemHistoryPreProcessors = __decorateClass$2([
  Component({ components: { DateDisplay, PaginationControls } })
], ItemHistoryPreProcessors);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "" } }, [_c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.tableItems, striped: "", busy: _vm.loading, "details-td-class": "pt-0 pb-2", "show-empty": "", emptyText: "No pre-processing items could be found" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(started)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.started ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.started } }) : _vm._e()];
  }, "fn") }, { key: "cell(completed)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.finished ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.finished } }) : _vm._e(), _vm._v(" "), row.item.finished ? _c("span", { staticClass: "small text-muted" }, [_vm._v("(took " + _vm._s(_vm.$options.filters.datetimeDifference(row.item.started, row.item.finished)) + ")")]) : _vm._e()];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "text-nowrap" }, [_c("b-badge", { attrs: { variant: _vm.getPreProcessorStatusClass(row.item), pill: "", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.getStatusIcon(row.item) } }), _vm._v(`
            ` + _vm._s(_vm.getStatusTitle(row.item)) + `
          `)], 1), _vm._v(" "), _vm._l(row.item.stages, function(stage) {
      return _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { title: _vm.getStageName(stage) + " - " + _vm.getStageItemProcessingStatusTitle(stage) }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.toggleRowDetails(row);
      }, "click") } }, [_c("font-awesome-icon", { class: "text-" + _vm.getStageClass(stage), attrs: { icon: _vm.getStageIcon(stage) } })], 1);
    }), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { variant: "link", size: "sm", title: "Show stage details" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: row.detailsShowing ? "caret-down" : "caret-right" } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "ml-2 align-middle", attrs: { variant: "link", size: "sm", target: "_blank", href: _vm.viewPreProcessorLog(row.item.id), title: "View Pre-Processor Log" } }, [_c("font-awesome-icon", { attrs: { icon: "up-right-from-square" } })], 1)], 2)];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-card", { attrs: { "body-class": "p-3 mx-auto" } }, [_c("b-row", { staticClass: "py-0" }, [_c("b-col", _vm._l(row.item.stages, function(stage, index) {
      return _c("span", { staticClass: "center" }, [_c("b-dropdown", { class: { "mx-1": index + 1 != row.item.stages.length }, attrs: { "no-flip": "", size: "sm", right: "", variant: "outline-" + _vm.getStageClass(stage) }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
        return [_c("font-awesome-icon", { attrs: { icon: _vm.getStageIcon(stage) } }), _vm._v(`
                      ` + _vm._s(_vm.getStageName(stage)) + `
                    `)];
      }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _vm._l(stage.jobs, function(job, jobIndex) {
        return _c("b-dropdown-item", { key: jobIndex, attrs: { pill: "", href: _vm.downloadJobLog(job), target: "_blank" } }, [_c("font-awesome-icon", { class: "text-" + _vm.getJobTextClass(job), attrs: { icon: _vm.getJobIcon(job) } }), _vm._v(`
                      View Log file #` + _vm._s(jobIndex + 1) + `
                    `)], 1);
      })], 2), _vm._v(" "), index + 1 != row.item.stages.length ? _c("font-awesome-icon", { staticClass: "align-middle", attrs: { size: "xs", icon: "chevron-right" } }) : _vm._e(), _vm._v(` 
                `)], 1);
    }), 0)], 1)], 1)];
  }, "fn") }]) }), _vm._v(" "), _vm.model ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.page, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.page = $$v;
  }, "callback"), expression: "page" } }) : _vm._e()], 1)], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  ItemHistoryPreProcessors,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  null
);
const ItemPreProcessorSummary = __component__$2.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a8;
let ItemHistoryProcessors = (_a8 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "itemId");
    __publicField(this, "model", null);
    __publicField(this, "tableItems", []);
    __publicField(this, "rowDetailIds", []);
    __publicField(this, "loading", !0);
    __publicField(this, "page", 1);
    __publicField(this, "pageSize", 50);
  }
  async pageChanged() {
    await this.getProcessorInfo(!0);
  }
  mounted() {
    this.getProcessorInfo(!0);
  }
  async getProcessorInfo(setLoading) {
    this.loading = setLoading;
    let processingClient = new IndexingProcessingClient(new Transformer(), baseUrl());
    this.model = await processingClient.getItemProcessingSummary(this.itemId, this.page, this.pageSize), this.tableItems = this.model.processors.map((t) => ({
      id: t.id,
      item: t.item,
      name: t.name,
      finished: t.finished,
      started: t.started,
      status: t.status,
      stages: t.stages,
      action: t.action,
      _showDetails: this.rowDetailIds.includes(t.id)
    })), this.loading = !1;
  }
  get totalPages() {
    if (this.model)
      return this.model.totalPages;
  }
  toggleRowDetails(row) {
    row.toggleDetails(), this.rowDetailIds.includes(row.item.id) ? this.rowDetailIds = this.rowDetailIds.filter(function(i) {
      return i !== row.item.id;
    }) : this.rowDetailIds.push(row.item.id);
  }
  getStatusText(processor) {
    switch (processor.status) {
      case ItemProcessingStatus.Running:
        return processor.stages.filter((stage) => stage.status === ProcessorStageStatus.Failed).length ? "Stage Failed" : this.$options.filters.capitaliseFirstLetter(processor.status);
      case ItemProcessingStatus.Cancelled:
      case ItemProcessingStatus.Successful:
        return this.$options.filters.capitaliseFirstLetter(processor.status);
      case ItemProcessingStatus.Failed:
        return "Returned to queue";
      default:
        return "Unknown";
    }
  }
  getProcessorStatusClass(processor) {
    switch (processor.status) {
      case ItemProcessingStatus.Running:
        return processor.stages.filter((stage) => stage.status === ProcessorStageStatus.Failed).length ? "danger" : "primary";
      case ItemProcessingStatus.Successful:
        return "success";
      case ItemProcessingStatus.Failed:
        return "warning";
      default:
        return "";
    }
  }
  getProcessorIcon(processor) {
    switch (processor.status) {
      case ItemProcessingStatus.Running:
        return processor.stages.filter((stage) => stage.status === ProcessorStageStatus.Failed).length ? "times-circle" : "circle-ellipsis";
      case ItemProcessingStatus.Successful:
        return "check-circle";
      case ItemProcessingStatus.Cancelled:
        return "ban";
      case ItemProcessingStatus.Failed:
        return "inbox-in";
      default:
        return "question";
    }
  }
  getJobClass(job) {
    switch (job.status) {
      case ProcessingJobStatus.Successful:
        return "success";
      case ProcessingJobStatus.Failed:
        return "danger";
      case ProcessingJobStatus.Skipped:
        return "muted";
      case ProcessingJobStatus.Cancelled:
        return "muted";
      case ProcessingJobStatus.Running:
        return "primary";
      default:
        return "";
    }
  }
  getJobIcon(job) {
    switch (job.status) {
      case ProcessingJobStatus.Successful:
        return "check-circle";
      case ProcessingJobStatus.Failed:
        return "times-circle";
      case ProcessingJobStatus.Skipped:
        return "circle-chevron-right";
      case ProcessingJobStatus.Cancelled:
        return "ban";
      case ProcessingJobStatus.Running:
        return "circle-ellipsis";
      default:
        return "";
    }
  }
  getStageName(stage) {
    return stage.name ? stage.name : "Stage not found";
  }
  getStageClass(stage) {
    let stageButtonClass = "";
    switch (stage.status) {
      case ProcessorStageStatus.Running:
        stageButtonClass += "primary";
        break;
      case ProcessorStageStatus.Successful:
        stageButtonClass += "success";
        break;
      case ProcessorStageStatus.Queued:
      case ProcessorStageStatus.Cancelled:
      case ProcessorStageStatus.Skipped:
        stageButtonClass += "secondary";
        break;
      case ProcessorStageStatus.Failed:
        stageButtonClass += "danger";
        break;
    }
    return stageButtonClass;
  }
  getStageStatusTitle(stage) {
    switch (stage.status) {
      case ProcessorStageStatus.Queued:
        return "Queued to run";
      default:
        return this.$options.filters.capitaliseFirstLetter(stage.status ? stage.status : "Unknown");
    }
  }
  getStageIcon(stage) {
    switch (stage.status) {
      case ProcessorStageStatus.Queued:
        return "clock";
      case ProcessorStageStatus.Running:
        return "circle-ellipsis";
      case ProcessorStageStatus.Successful:
        return "check-circle";
      case ProcessorStageStatus.Skipped:
        return "circle-chevron-right";
      case ProcessorStageStatus.Cancelled:
        return "ban";
      case ProcessorStageStatus.Failed:
        return "times-circle";
    }
  }
  getProcessorFinalStage(item) {
    return item.stages.find((y) => y.order == item.stages.length);
  }
  downloadJobLog(job) {
    return new URL(baseUrl() + "/api/processing/processing/jobs/" + job.id).href;
  }
  viewProcessorLog(processorId) {
    return new URL(baseUrl() + "/api/processing/processors/" + processorId + "/log").href;
  }
  get tableFields() {
    return [
      { key: "action", label: "Action", sortable: !1, thClass: "align-middle" },
      { key: "started", label: "Started", sortable: !1, thClass: "align-middle" },
      { key: "status", label: "Status", sortable: !1, thClass: "align-middle" },
      { key: "completed", label: "Completed", sortable: !1, thClass: "align-middle" },
      { key: "actions", label: "", sortable: !1, thClass: "align-middle" }
    ];
  }
}, __name(_a8, "ItemHistoryProcessors"), _a8);
__decorateClass$1([
  Prop({ required: !0 })
], ItemHistoryProcessors.prototype, "itemId", 2);
__decorateClass$1([
  Watch("page")
], ItemHistoryProcessors.prototype, "pageChanged", 1);
ItemHistoryProcessors = __decorateClass$1([
  Component({ components: { DateDisplay, PaginationControls } })
], ItemHistoryProcessors);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "" } }, [_c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.tableItems, striped: "", busy: _vm.loading, "details-td-class": "pt-0 pb-2", "show-empty": "", emptyText: "No processing items could be found" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(action)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("span", { class: "text-" + row.item.action.colour }, [_c("font-awesome-icon", { attrs: { icon: row.item.action && row.item.action.icon ? row.item.action.icon : "question" } }), _vm._v(`
              ` + _vm._s(row.item.action && row.item.action.name ? row.item.action.name : "Unknown") + `
            `)], 1)];
  }, "fn") }, { key: "cell(started)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.started ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.started } }) : _vm._e()];
  }, "fn") }, { key: "cell(completed)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.finished ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.finished } }) : _vm._e(), _vm._v(" "), row.item.finished ? _c("span", { staticClass: "small text-muted" }, [_vm._v("(took " + _vm._s(_vm.$options.filters.datetimeDifference(row.item.started, row.item.finished)) + ")")]) : _vm._e()];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "text-nowrap" }, [_c("b-badge", { attrs: { variant: _vm.getProcessorStatusClass(row.item), pill: "", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.getProcessorIcon(row.item) } }), _vm._v(`
            ` + _vm._s(_vm.getStatusText(row.item)) + `
          `)], 1), _vm._v(" "), _vm._l(row.item.stages, function(stage) {
      return _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { title: _vm.getStageName(stage) + " - " + _vm.getStageStatusTitle(stage) }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.toggleRowDetails(row);
      }, "click") } }, [_c("font-awesome-icon", { class: "text-" + _vm.getStageClass(stage), attrs: { icon: _vm.getStageIcon(stage) } })], 1);
    }), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { variant: "link", size: "sm", title: "Show stage details" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: row.detailsShowing ? "caret-down" : "caret-right" } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "ml-2 align-middle", attrs: { variant: "link", size: "sm", target: "_blank", href: _vm.viewProcessorLog(row.item.id), title: "View Processor Log" } }, [_c("font-awesome-icon", { attrs: { icon: "up-right-from-square" } })], 1)], 2)];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-card", { attrs: { "body-class": "p-3 mx-auto" } }, [_c("b-row", { staticClass: "py-0" }, [_c("b-col", _vm._l(row.item.stages, function(stage, index) {
      return _c("span", { staticClass: "center" }, [_c("b-dropdown", { class: { "mx-1": index + 1 != row.item.stages.length }, attrs: { "no-flip": "", size: "sm", right: "", variant: "outline-" + _vm.getStageClass(stage) }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
        return [_c("font-awesome-icon", { attrs: { icon: _vm.getStageIcon(stage) } }), _vm._v(`
                      ` + _vm._s(_vm.getStageName(stage)) + `
                       `), stage.type == "ConditionProcessorStage" ? _c("b-badge", { attrs: { pill: "", variant: "info" } }, [_vm._v("Start")]) : _vm._e(), _vm._v(" "), stage.type == "ConditionEndProcessorStage" ? _c("b-badge", { attrs: { pill: "", variant: "info" } }, [_vm._v("End")]) : _vm._e()];
      }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _vm._l(stage.jobs, function(job, jobIndex) {
        return _c("b-dropdown-item", { key: jobIndex, attrs: { pill: "", href: _vm.downloadJobLog(job), target: "_blank" } }, [_c("font-awesome-icon", { class: "text-" + _vm.getJobClass(job), attrs: { icon: _vm.getJobIcon(job) } }), _vm._v(`
                      View Log file #` + _vm._s(jobIndex + 1) + `
                    `)], 1);
      })], 2), _vm._v(" "), index + 1 != row.item.stages.length ? _c("font-awesome-icon", { staticClass: "align-middle", attrs: { size: "xs", icon: "chevron-right" } }) : _vm._e(), _vm._v(` 
                `)], 1);
    }), 0)], 1)], 1)];
  }, "fn") }]) }), _vm._v(" "), _vm.model ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.page, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.page = $$v;
  }, "callback"), expression: "page" } }) : _vm._e()], 1)], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  ItemHistoryProcessors,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "d0cc12b0"
);
const ItemProcessorSummary = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a9;
let ItemHistoryModal$1 = (_a9 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "shouldShow");
    __publicField(this, "item");
    __publicField(this, "defaultTab");
    __publicField(this, "selectedTab", 0);
    __publicField(this, "showSystemEvents", !1);
    __publicField(this, "showMetaData", !1);
    __publicField(this, "filterText", "");
    __publicField(this, "loading", !1);
    __publicField(this, "showMetadataDisplayName", !1);
    __publicField(this, "itemHistoryResponse", null);
    __publicField(this, "historyEvents", []);
    __publicField(this, "showModal", !1);
  }
  mounted() {
  }
  async watchShouldShow(newVal) {
    this.showModal = newVal;
  }
  async watchShowModal(newVal) {
    this.showModal = newVal, newVal ? (await this.reloadHistoryItems(), this.defaultTab && this.selectDefaultTab()) : this.$emit("close");
  }
  selectDefaultTab() {
    switch (this.defaultTab) {
      case null:
      case "history":
        this.selectedTab = 0;
        break;
      case "split":
        this.selectedTab = 3;
        break;
    }
  }
  async reloadHistoryItems() {
    this.itemHistoryResponse = null, this.loading = !0;
    try {
      this.itemHistoryResponse = await new IndexingClient(new Transformer(), baseUrl()).getItemHistory(this.item.id), this.historyEvents = this.itemHistoryResponse.events;
    } catch {
    } finally {
      this.loading = !1;
    }
  }
  get splitHistoryEvents() {
    return this.historyEvents.filter((y) => y.type == "EzeScan.WebApps.Indexing.ItemSplit" && y.metadata.some((m) => m.id == "splitItemId"));
  }
  closeModal() {
    this.filterText = "", this.$emit("close");
  }
}, __name(_a9, "ItemHistoryModal"), _a9);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], ItemHistoryModal$1.prototype, "shouldShow", 2);
__decorateClass([
  Prop({
    required: !0
  })
], ItemHistoryModal$1.prototype, "item", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], ItemHistoryModal$1.prototype, "defaultTab", 2);
__decorateClass([
  Watch("shouldShow", { immediate: !0 })
], ItemHistoryModal$1.prototype, "watchShouldShow", 1);
__decorateClass([
  Watch("showModal", { immediate: !0 })
], ItemHistoryModal$1.prototype, "watchShowModal", 1);
ItemHistoryModal$1 = __decorateClass([
  Component({
    components: {
      MetadataDifferencesSummary,
      ItemPreProcessorSummary,
      ItemProcessorSummary,
      MetadataSummary,
      SplitItemsSummary,
      SortableHeader,
      HistoryEventLine,
      HistorySummary,
      DateDisplay
    }
  })
], ItemHistoryModal$1);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-modal", { attrs: { "no-close-on-backdrop": "", size: "xxl" }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h4", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "history" } }), _vm._v(" "), _vm.item.file ? _c("span", [_vm._v(_vm._s(_vm.item.file.name))]) : _c("span", [_vm._v(_vm._s(_vm.item.name))])], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v("Cancel")])];
  }, "fn") }]), model: { value: _vm.showModal, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.showModal = $$v;
  }, "callback"), expression: "showModal" } }, [_vm._v(" "), _c("b-tabs", { attrs: { "content-class": "mt-3" }, model: { value: _vm.selectedTab, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.selectedTab = $$v;
  }, "callback"), expression: "selectedTab" } }, [_c("b-tab", { key: "history", attrs: { title: "History", active: "" }, scopedSlots: _vm._u([{ key: "title", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "history" } }), _vm._v(` History
        `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-form-checkbox", { staticClass: "mb-1", attrs: { name: `${_vm.item.id}showSystemEventsRadio`, switch: "", disabled: _vm.loading }, model: { value: _vm.showSystemEvents, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.showSystemEvents = $$v;
  }, "callback"), expression: "showSystemEvents" } }, [_vm._v(`
          Show all system events
        `)]), _vm._v(" "), _c("b-input-group", [_c("b-input-group-prepend", [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "filter", placeholder: "Filter list" } })], 1)], 1), _vm._v(" "), _c("b-form-input", { attrs: { id: "filterTextInput", placeholder: "Filter...", disabled: _vm.loading }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", [_c("history-summary", { attrs: { filterText: _vm.filterText, value: _vm.historyEvents, showMetaData: _vm.showMetaData, showSystemEvents: _vm.showSystemEvents }, on: { showMetadata: /* @__PURE__ */ __name(function($event) {
    _vm.showMetaData = $event;
  }, "showMetadata") } })], 1)])])], 1), _vm._v(" "), _c("b-tab", { key: "metadata", attrs: { title: "Metadata" }, scopedSlots: _vm._u([{ key: "title", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "keyboard" } }), _vm._v(` Metadata
        `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_vm.loading ? _c("span", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _vm.itemHistoryResponse ? _c("metadata-summary", { attrs: { value: _vm.itemHistoryResponse.metadata, "show-display-name": _vm.showMetadataDisplayName, forceColumnId: !0, "show-attributes": !0 } }) : _vm._e()], 1)])]), _vm._v(" "), _c("b-tab", { key: "originalMetadata", attrs: { title: "Metadata Changes", lazy: "" }, scopedSlots: _vm._u([{ key: "title", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "swap-arrows" } }), _vm._v(` Metadata Changes
        `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _vm.itemHistoryResponse ? _c("div", [_c("metadata-differences-summary", { attrs: { "item-history-response": _vm.itemHistoryResponse } })], 1) : _vm._e()])])]), _vm._v(" "), _c("b-tab", { key: "split", attrs: { title: "Split Items", lazy: "" }, scopedSlots: _vm._u([{ key: "title", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "split" } }), _vm._v(` Split Items
        `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", [_vm.itemHistoryResponse ? _c("split-items-summary", { attrs: { item: _vm.item } }) : _vm._e()], 1)])])]), _vm._v(" "), _c("b-tab", { key: "preprocessors", attrs: { title: "Pre-Processors", lazy: "" }, scopedSlots: _vm._u([{ key: "title", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "sign-in" } }), _vm._v(` Pre-Processors
        `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", [_c("item-pre-processor-summary", { attrs: { itemId: _vm.item.id } })], 1)])])]), _vm._v(" "), _c("b-tab", { key: "processors", attrs: { title: "Processors", lazy: "" }, scopedSlots: _vm._u([{ key: "title", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "sign-out" } }), _vm._v(` Processors
        `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", [_c("item-processor-summary", { attrs: { itemId: _vm.item.id } })], 1)])])])], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  ItemHistoryModal$1,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "df3e54b1"
);
const ItemHistoryModal = __component__.exports;
export {
  ItemHistoryModal as I
};
