var __defProp = Object.defineProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
import { b5 as getDefaultExportFromCjs } from "./main-DAVWuHbi.js";
var isURL = { exports: {} }, assertString = { exports: {} };
(function(module, exports) {
  Object.defineProperty(exports, "__esModule", {
    value: !0
  }), exports.default = assertString2;
  function assertString2(input) {
    if (input == null) throw new TypeError("Expected a string but received a ".concat(input));
    if (input.constructor.name !== "String") throw new TypeError("Expected a string but received a ".concat(input.constructor.name));
  }
  __name(assertString2, "assertString"), module.exports = exports.default, module.exports.default = exports.default;
})(assertString, assertString.exports);
var assertStringExports = assertString.exports, checkHost = { exports: {} };
(function(module, exports) {
  Object.defineProperty(exports, "__esModule", {
    value: !0
  }), exports.default = checkHost2;
  function isRegExp(obj) {
    return Object.prototype.toString.call(obj) === "[object RegExp]";
  }
  __name(isRegExp, "isRegExp");
  function checkHost2(host, matches) {
    for (var i = 0; i < matches.length; i++) {
      var match = matches[i];
      if (host === match || isRegExp(match) && match.test(host))
        return !0;
    }
    return !1;
  }
  __name(checkHost2, "checkHost"), module.exports = exports.default, module.exports.default = exports.default;
})(checkHost, checkHost.exports);
var checkHostExports = checkHost.exports, includesString = { exports: {} };
(function(module, exports) {
  Object.defineProperty(exports, "__esModule", {
    value: !0
  }), exports.default = void 0;
  var includes = /* @__PURE__ */ __name(function(str, val) {
    return str.indexOf(val) !== -1;
  }, "includes");
  exports.default = includes, module.exports = exports.default, module.exports.default = exports.default;
})(includesString, includesString.exports);
var includesStringExports = includesString.exports, isFQDN = { exports: {} }, merge = { exports: {} };
(function(module, exports) {
  Object.defineProperty(exports, "__esModule", {
    value: !0
  }), exports.default = merge2;
  function merge2() {
    var obj = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {}, defaults = arguments.length > 1 ? arguments[1] : void 0;
    for (var key in defaults)
      typeof obj[key] > "u" && (obj[key] = defaults[key]);
    return obj;
  }
  __name(merge2, "merge"), module.exports = exports.default, module.exports.default = exports.default;
})(merge, merge.exports);
var mergeExports = merge.exports;
(function(module, exports) {
  Object.defineProperty(exports, "__esModule", {
    value: !0
  }), exports.default = isFQDN2;
  var _assertString = _interopRequireDefault(assertStringExports), _merge = _interopRequireDefault(mergeExports);
  function _interopRequireDefault(e) {
    return e && e.__esModule ? e : { default: e };
  }
  __name(_interopRequireDefault, "_interopRequireDefault");
  var default_fqdn_options = {
    require_tld: !0,
    allow_underscores: !1,
    allow_trailing_dot: !1,
    allow_numeric_tld: !1,
    allow_wildcard: !1,
    ignore_max_length: !1
  };
  function isFQDN2(str, options) {
    (0, _assertString.default)(str), options = (0, _merge.default)(options, default_fqdn_options), options.allow_trailing_dot && str[str.length - 1] === "." && (str = str.substring(0, str.length - 1)), options.allow_wildcard === !0 && str.indexOf("*.") === 0 && (str = str.substring(2));
    var parts = str.split("."), tld = parts[parts.length - 1];
    return options.require_tld && (parts.length < 2 || !options.allow_numeric_tld && !/^([a-z\u00A1-\u00A8\u00AA-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]{2,}|xn[a-z0-9-]{2,})$/i.test(tld) || /\s/.test(tld)) || !options.allow_numeric_tld && /^\d+$/.test(tld) ? !1 : parts.every(function(part) {
      return !(part.length > 63 && !options.ignore_max_length || !/^[a-z_\u00a1-\uffff0-9-]+$/i.test(part) || /[\uff01-\uff5e]/.test(part) || /^-|-$/.test(part) || !options.allow_underscores && /_/.test(part));
    });
  }
  __name(isFQDN2, "isFQDN"), module.exports = exports.default, module.exports.default = exports.default;
})(isFQDN, isFQDN.exports);
var isFQDNExports = isFQDN.exports, isIP = { exports: {} };
(function(module, exports) {
  Object.defineProperty(exports, "__esModule", {
    value: !0
  }), exports.default = isIP2;
  var _assertString = _interopRequireDefault(assertStringExports);
  function _interopRequireDefault(e) {
    return e && e.__esModule ? e : { default: e };
  }
  __name(_interopRequireDefault, "_interopRequireDefault");
  function _typeof(o) {
    "@babel/helpers - typeof";
    return _typeof = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(o2) {
      return typeof o2;
    } : function(o2) {
      return o2 && typeof Symbol == "function" && o2.constructor === Symbol && o2 !== Symbol.prototype ? "symbol" : typeof o2;
    }, _typeof(o);
  }
  __name(_typeof, "_typeof");
  var IPv4SegmentFormat = "(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])", IPv4AddressFormat = "(".concat(IPv4SegmentFormat, "[.]){3}").concat(IPv4SegmentFormat), IPv4AddressRegExp = new RegExp("^".concat(IPv4AddressFormat, "$")), IPv6SegmentFormat = "(?:[0-9a-fA-F]{1,4})", IPv6AddressRegExp = new RegExp("^(" + "(?:".concat(IPv6SegmentFormat, ":){7}(?:").concat(IPv6SegmentFormat, "|:)|") + "(?:".concat(IPv6SegmentFormat, ":){6}(?:").concat(IPv4AddressFormat, "|:").concat(IPv6SegmentFormat, "|:)|") + "(?:".concat(IPv6SegmentFormat, ":){5}(?::").concat(IPv4AddressFormat, "|(:").concat(IPv6SegmentFormat, "){1,2}|:)|") + "(?:".concat(IPv6SegmentFormat, ":){4}(?:(:").concat(IPv6SegmentFormat, "){0,1}:").concat(IPv4AddressFormat, "|(:").concat(IPv6SegmentFormat, "){1,3}|:)|") + "(?:".concat(IPv6SegmentFormat, ":){3}(?:(:").concat(IPv6SegmentFormat, "){0,2}:").concat(IPv4AddressFormat, "|(:").concat(IPv6SegmentFormat, "){1,4}|:)|") + "(?:".concat(IPv6SegmentFormat, ":){2}(?:(:").concat(IPv6SegmentFormat, "){0,3}:").concat(IPv4AddressFormat, "|(:").concat(IPv6SegmentFormat, "){1,5}|:)|") + "(?:".concat(IPv6SegmentFormat, ":){1}(?:(:").concat(IPv6SegmentFormat, "){0,4}:").concat(IPv4AddressFormat, "|(:").concat(IPv6SegmentFormat, "){1,6}|:)|") + "(?::((?::".concat(IPv6SegmentFormat, "){0,5}:").concat(IPv4AddressFormat, "|(?::").concat(IPv6SegmentFormat, "){1,7}|:))") + ")(%[0-9a-zA-Z.]{1,})?$");
  function isIP2(ipAddress) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    (0, _assertString.default)(ipAddress);
    var version = (_typeof(options) === "object" ? options.version : arguments[1]) || "";
    return version ? version.toString() === "4" ? IPv4AddressRegExp.test(ipAddress) : version.toString() === "6" ? IPv6AddressRegExp.test(ipAddress) : !1 : isIP2(ipAddress, {
      version: 4
    }) || isIP2(ipAddress, {
      version: 6
    });
  }
  __name(isIP2, "isIP"), module.exports = exports.default, module.exports.default = exports.default;
})(isIP, isIP.exports);
var isIPExports = isIP.exports;
(function(module, exports) {
  Object.defineProperty(exports, "__esModule", {
    value: !0
  }), exports.default = isURL2;
  var _assertString = _interopRequireDefault(assertStringExports), _checkHost = _interopRequireDefault(checkHostExports), _includesString = _interopRequireDefault(includesStringExports), _isFQDN = _interopRequireDefault(isFQDNExports), _isIP = _interopRequireDefault(isIPExports), _merge = _interopRequireDefault(mergeExports);
  function _interopRequireDefault(e) {
    return e && e.__esModule ? e : { default: e };
  }
  __name(_interopRequireDefault, "_interopRequireDefault");
  function _slicedToArray(r, e) {
    return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest();
  }
  __name(_slicedToArray, "_slicedToArray");
  function _nonIterableRest() {
    throw new TypeError(`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
  }
  __name(_nonIterableRest, "_nonIterableRest");
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if (typeof r == "string") return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return t === "Object" && r.constructor && (t = r.constructor.name), t === "Map" || t === "Set" ? Array.from(r) : t === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }
  __name(_unsupportedIterableToArray, "_unsupportedIterableToArray");
  function _arrayLikeToArray(r, a) {
    (a == null || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  __name(_arrayLikeToArray, "_arrayLikeToArray");
  function _iterableToArrayLimit(r, l) {
    var t = r == null ? null : typeof Symbol < "u" && r[Symbol.iterator] || r["@@iterator"];
    if (t != null) {
      var e, n, i, u, a = [], f = !0, o = !1;
      try {
        if (i = (t = t.call(r)).next, l !== 0) for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) ;
      } catch (r2) {
        o = !0, n = r2;
      } finally {
        try {
          if (!f && t.return != null && (u = t.return(), Object(u) !== u)) return;
        } finally {
          if (o) throw n;
        }
      }
      return a;
    }
  }
  __name(_iterableToArrayLimit, "_iterableToArrayLimit");
  function _arrayWithHoles(r) {
    if (Array.isArray(r)) return r;
  }
  __name(_arrayWithHoles, "_arrayWithHoles");
  var default_url_options = {
    protocols: ["http", "https", "ftp"],
    require_tld: !0,
    require_protocol: !1,
    require_host: !0,
    require_port: !1,
    require_valid_protocol: !0,
    allow_underscores: !1,
    allow_trailing_dot: !1,
    allow_protocol_relative_urls: !1,
    allow_fragments: !0,
    allow_query_components: !0,
    validate_length: !0,
    max_allowed_length: 2084
  }, wrapped_ipv6 = /^\[([^\]]+)\](?::([0-9]+))?$/;
  function isURL2(url, options) {
    if ((0, _assertString.default)(url), !url || /[\s<>]/.test(url) || url.indexOf("mailto:") === 0 || (options = (0, _merge.default)(options, default_url_options), options.validate_length && url.length > options.max_allowed_length) || !options.allow_fragments && (0, _includesString.default)(url, "#") || !options.allow_query_components && ((0, _includesString.default)(url, "?") || (0, _includesString.default)(url, "&")))
      return !1;
    var protocol, auth, host, hostname, port, port_str, split, ipv6;
    if (split = url.split("#"), url = split.shift(), split = url.split("?"), url = split.shift(), split = url.split("://"), split.length > 1) {
      if (protocol = split.shift().toLowerCase(), options.require_valid_protocol && options.protocols.indexOf(protocol) === -1)
        return !1;
    } else {
      if (options.require_protocol)
        return !1;
      if (url.slice(0, 2) === "//") {
        if (!options.allow_protocol_relative_urls)
          return !1;
        split[0] = url.slice(2);
      }
    }
    if (url = split.join("://"), url === "")
      return !1;
    if (split = url.split("/"), url = split.shift(), url === "" && !options.require_host)
      return !0;
    if (split = url.split("@"), split.length > 1) {
      if (options.disallow_auth || split[0] === "" || (auth = split.shift(), auth.indexOf(":") >= 0 && auth.split(":").length > 2))
        return !1;
      var _auth$split = auth.split(":"), _auth$split2 = _slicedToArray(_auth$split, 2), user = _auth$split2[0], password = _auth$split2[1];
      if (user === "" && password === "")
        return !1;
    }
    hostname = split.join("@"), port_str = null, ipv6 = null;
    var ipv6_match = hostname.match(wrapped_ipv6);
    if (ipv6_match ? (host = "", ipv6 = ipv6_match[1], port_str = ipv6_match[2] || null) : (split = hostname.split(":"), host = split.shift(), split.length && (port_str = split.join(":"))), port_str !== null && port_str.length > 0) {
      if (port = parseInt(port_str, 10), !/^[0-9]+$/.test(port_str) || port <= 0 || port > 65535)
        return !1;
    } else if (options.require_port)
      return !1;
    return options.host_whitelist ? (0, _checkHost.default)(host, options.host_whitelist) : host === "" && !options.require_host ? !0 : !(!(0, _isIP.default)(host) && !(0, _isFQDN.default)(host, options) && (!ipv6 || !(0, _isIP.default)(ipv6, 6)) || (host = host || ipv6, options.host_blacklist && (0, _checkHost.default)(host, options.host_blacklist)));
  }
  __name(isURL2, "isURL"), module.exports = exports.default, module.exports.default = exports.default;
})(isURL, isURL.exports);
var isURLExports = isURL.exports;
const isUrl = /* @__PURE__ */ getDefaultExportFromCjs(isURLExports);
export {
  isUrl as i
};
