var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, W as Watch, C as Component, V as Vue, l as lozad, b as baseUrl, n as normalizeComponent, M as Moment, I as IntrayClient, T as Transformer } from "./main-DAVWuHbi.js";
import { b as bytesToSize } from "./fileSizeHelpers-DezEXWHc.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { N as NoteSummary } from "./noteSummary-Dgu-1-YA.js";
import { g as getPriorityNote } from "./noteDisplayHelper-0E8yeVJ1.js";
import { I as ItemIcon } from "./itemIcon-6OcVSOiI.js";
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$3"), _a;
let ThumbnailComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "value");
    __publicField(this, "size");
    __publicField(this, "observer", lozad());
    __publicField(this, "data", null);
  }
  get imageSize() {
    return this.minSide + "px";
  }
  get thumbnailurl() {
    let url = new URL(baseUrl + "/api/indexing/items/" + this.value + "/thumbnail");
    return this.size && url.searchParams.append("size", this.size), url.href;
  }
  mounted() {
    $(this.$el).popover({
      html: !0,
      placement: "right",
      trigger: "hover",
      animation: !0,
      container: "body",
      template: '<div class="popover" role="tooltip"><div class="popover-body"></div></div>',
      content: /* @__PURE__ */ __name(() => '<img src="' + new URL(baseUrl + "/api/indexing/items/" + this.value + "/thumbnail") + '" alt="Loading...">', "content")
    }), this.observer.observe();
  }
  watchValue() {
  }
  loadImage() {
    this.loading = !0, fetch(this.thumbnailurl).then((d) => d.blob()).then((d) => {
      this.data = URL.createObjectURL(d);
    }).finally(() => {
      this.loading = !1;
    });
  }
  get minStyle() {
    return {
      "min-width": this.minSide + "px",
      "min-height": this.minSide + "px"
    };
  }
  get minSide() {
    if (!this.value)
      return 1;
    switch (this.size) {
      case "i":
        return 32;
      case "s":
        return 64;
      case "m":
        return 128;
      case "l":
        return 256;
      default:
        return 64;
    }
  }
}, __name(_a, "ThumbnailComponent"), _a);
__decorateClass$3([
  Prop({
    required: !0
  })
], ThumbnailComponent.prototype, "value", 2);
__decorateClass$3([
  Prop({
    required: !1
  })
], ThumbnailComponent.prototype, "size", 2);
__decorateClass$3([
  Watch("value")
], ThumbnailComponent.prototype, "watchValue", 1);
ThumbnailComponent = __decorateClass$3([
  Component({})
], ThumbnailComponent);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { style: _vm.minStyle }, [_vm.loading ? _c("div", { key: "loading" + _vm.value, staticClass: "loading-icon" }, [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } })], 1) : _c("img", { staticClass: "list-icon-image ria-thumbnail lozad", attrs: { "data-src": _vm.thumbnailurl } })]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  ThumbnailComponent,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  "ec6c0061"
);
const Thumbnail = __component__$3.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$2"), _a2;
let IntrayListTableComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "tableFields");
    __publicField(this, "tableBusy");
    __publicField(this, "filter");
    __publicField(this, "currentPage");
    __publicField(this, "perPage");
    __publicField(this, "pageId");
  }
  get tableItems() {
    return this.value;
  }
  emitFiltered(filteredItems) {
    this.$emit("filtered", filteredItems, this.pageId);
  }
  itemUrl(itemId) {
    return new URL(baseUrl() + "/app/indexing/items/" + itemId).href;
  }
  queueUrl(queueId) {
    return new URL(baseUrl() + "/app/indexing/queues/" + queueId + "/list").href;
  }
  pageUrl(pageId) {
    return new URL(baseUrl() + "/app/indexing/pages/" + pageId + "/defaultQueue").href;
  }
}, __name(_a2, "IntrayListTableComponent"), _a2);
__decorateClass$2([
  Prop({ required: !0 })
], IntrayListTableComponent.prototype, "value", 2);
__decorateClass$2([
  Prop({ required: !0 })
], IntrayListTableComponent.prototype, "tableFields", 2);
__decorateClass$2([
  Prop({ required: !0 })
], IntrayListTableComponent.prototype, "tableBusy", 2);
__decorateClass$2([
  Prop({ required: !0 })
], IntrayListTableComponent.prototype, "filter", 2);
__decorateClass$2([
  Prop({ required: !0 })
], IntrayListTableComponent.prototype, "currentPage", 2);
__decorateClass$2([
  Prop({ required: !0 })
], IntrayListTableComponent.prototype, "perPage", 2);
__decorateClass$2([
  Prop({ required: !1, default: "" })
], IntrayListTableComponent.prototype, "pageId", 2);
IntrayListTableComponent = __decorateClass$2([
  Component({
    components: { ItemIcon, Thumbnail, DateDisplay, NoteSummary, PaginationControls },
    filters: {
      moment: /* @__PURE__ */ __name((input) => Moment(input).fromNow(), "moment"),
      humanizeSize: /* @__PURE__ */ __name((input) => bytesToSize(input), "humanizeSize")
    },
    methods: { getPriorityNote }
  })
], IntrayListTableComponent);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.tableItems, busy: _vm.tableBusy, filter: _vm.filter, "per-page": _vm.perPage, "current-page": _vm.currentPage, "filter-included-fields": ["name"], small: "", responsive: "sm", "empty-filtered-text": "No items in filtered list", "empty-text": "No items in list", "sort-by": "created", hover: "", "sort-icon-left": "", "show-empty": "", "sticky-header": "" }, on: { filtered: _vm.emitFiltered }, scopedSlots: _vm._u([{ key: "empty", fn: /* @__PURE__ */ __name(function(scope) {
    return [_c("p", { staticClass: "text-muted" }, [_vm._v(_vm._s(scope.emptyText))])];
  }, "fn") }, { key: "emptyfiltered", fn: /* @__PURE__ */ __name(function(scope) {
    return [_c("p", { staticClass: "text-muted" }, [_vm._v(_vm._s(scope.emptyFilteredText))])];
  }, "fn") }, { key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-info my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v("Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(pageName)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("div", [_c("a", { attrs: { href: _vm.pageUrl(data.item.pageId) } }, [_vm._v(_vm._s(data.value))])])];
  }, "fn") }, { key: "cell(queueName)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("a", { attrs: { href: _vm.queueUrl(data.item.queueId) } }, [_vm._v(_vm._s(data.value))])];
  }, "fn") }, { key: "cell(thumbnail)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("div", { staticClass: "mx-auto", staticStyle: { width: "35px" } }, [_c("item-icon", { key: data.item.id, attrs: { size: "i", fallback: data.item.mimeType, value: { id: data.item.id, type: "image" } } })], 1)];
  }, "fn") }, { key: "cell(name)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.notes && data.item.notes.length > 0 ? _c("note-summary", { attrs: { "priority-note": _vm.getPriorityNote(data.item.notes), item: data.item, decode: !1 } }) : _vm._e(), _vm._v(" "), _c("a", { attrs: { href: _vm.itemUrl(data.item.id) } }, [_c("span", { staticStyle: { "word-wrap": "break-word", "max-width": "160px" } }, [_vm._v(_vm._s(data.value))])])];
  }, "fn") }, { key: "cell(fileSize)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(_vm._s(_vm._f("humanizeSize")(data.value)))];
  }, "fn") }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.value } })];
  }, "fn") }]) })], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  IntrayListTableComponent,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "1dab2a03"
);
const IntrayListTable = __component__$2.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$1"), _a3;
let IntrayListComponent = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "intray");
    __publicField(this, "icon");
    __publicField(this, "title");
    __publicField(this, "titleMessage");
    __publicField(this, "showQueues");
    __publicField(this, "loading");
    __publicField(this, "intrayMode", "item");
    __publicField(this, "hideIntray", !1);
    __publicField(this, "filter", "");
    __publicField(this, "totalItems", 0);
    __publicField(this, "currentPage", 1);
    __publicField(this, "perPage", 50);
    __publicField(this, "options", [{ value: "item", text: "No grouping" }, { value: "page", text: "Group by page" }]);
    __publicField(this, "pages", []);
  }
  mounted() {
    this.intray && (this.totalItems = this.intray.count);
  }
  get intrayItems() {
    if (this.intray)
      return this.intray.items;
  }
  async generatePageView() {
    this.intray.items.forEach((item) => {
      let page = { pageId: item.pageId, pageName: item.pageName, filter: "", hidden: !1, items: [], totalItems: 0, currentPage: 1 };
      this.pages.filter((p) => p.pageId == page.pageId).length === 0 && (page.items = this.intray.items.filter((item2) => item2.pageId === page.pageId), page.totalItems = page.items.length, this.pages.push(page));
    });
  }
  onFiltered(filteredItems) {
    this.totalItems = filteredItems.length;
  }
  onPageFiltered(filteredItems, pageId) {
    let page = this.pages.find((p) => p.pageId === pageId);
    page.totalItems = filteredItems.length;
  }
  watchIntray() {
    this.totalItems = this.intray.count;
  }
  async changeIntrayMode() {
    this.intrayMode === "page" && !this.pages.length && (await this.generatePageView(), this.loading = !1);
  }
  get tableFields() {
    let tableFields = [
      { key: "pageName", label: "Page", sortable: !0, class: "intray-15-percent-cell align-middle" },
      { key: "thumbnail", label: "", sortable: !1, class: "intray-thumbnail-cell align-middle" },
      { key: "name", label: "Item Name", sortable: !0, class: "intray-item-name-cell align-middle" },
      { key: "fileSize", label: "Size", sortable: !0, class: "intray-10-percent-cell align-middle" },
      { key: "created", label: "Created", sortable: !0, class: "intray-10-percent-cell align-middle" }
    ];
    return this.showQueues && tableFields.splice(1, 0, { key: "queueName", label: "Queue", sortable: !0, class: "intray-15-percent-cell  align-middle" }), tableFields;
  }
  get pageTableFields() {
    let tableFields = [
      { key: "thumbnail", label: "", sortable: !1, class: "intray-thumbnail-cell align-middle" },
      { key: "name", label: "Item Name", sortable: !0, class: "intray-item-name-cell align-middle" },
      { key: "fileSize", label: "Size", sortable: !0, class: "intray-10-percent-cell align-middle" },
      { key: "created", label: "Created", sortable: !0, class: "intray-10-percent-cell align-middle" }
    ];
    return this.showQueues && tableFields.splice(0, 0, { key: "queueName", label: "Queue", sortable: !0, class: "intray-15-percent-cell  align-middle" }), tableFields;
  }
}, __name(_a3, "IntrayListComponent"), _a3);
__decorateClass$1([
  Prop({ required: !0 })
], IntrayListComponent.prototype, "intray", 2);
__decorateClass$1([
  Prop({ required: !0 })
], IntrayListComponent.prototype, "icon", 2);
__decorateClass$1([
  Prop({ required: !0 })
], IntrayListComponent.prototype, "title", 2);
__decorateClass$1([
  Prop({ required: !0 })
], IntrayListComponent.prototype, "titleMessage", 2);
__decorateClass$1([
  Prop({ required: !0 })
], IntrayListComponent.prototype, "showQueues", 2);
__decorateClass$1([
  Prop({ required: !0 })
], IntrayListComponent.prototype, "loading", 2);
__decorateClass$1([
  Watch("intray")
], IntrayListComponent.prototype, "watchIntray", 1);
IntrayListComponent = __decorateClass$1([
  Component({
    components: { IntrayListTable, DateDisplay },
    filters: { humanizeSize: /* @__PURE__ */ __name((input) => bytesToSize(input), "humanizeSize") }
  })
], IntrayListComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("b-card", { attrs: { "no-body": _vm.hideIntray, "body-class": "pt-3", "header-class": "pb-2" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("span", { staticClass: "mt-3" }, [_c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: _vm.titleMessage } }, [_c("font-awesome-icon", { attrs: { icon: _vm.icon } }), _vm._v(" " + _vm._s(_vm.title) + `
            `)], 1), _vm._v(" "), _vm.intray ? _c("b-badge", { staticClass: "small", attrs: { variant: "info", pill: "" } }, [_vm.totalItems != _vm.intray.count && _vm.intrayMode === "item" ? _c("span", [_vm._v(_vm._s(_vm.totalItems) + " / ")]) : _vm._e(), _vm._v(_vm._s(_vm.intray.count))]) : _vm._e()], 1), _vm._v(" "), _c("div", { staticClass: "float-right" }, [_c("b-input-group", { scopedSlots: _vm._u([{ key: "prepend", fn: /* @__PURE__ */ __name(function() {
      return [_c("b-form-select", { attrs: { size: "sm", options: _vm.options }, on: { change: _vm.changeIntrayMode }, model: { value: _vm.intrayMode, callback: /* @__PURE__ */ __name(function($$v) {
        _vm.intrayMode = $$v;
      }, "callback"), expression: "intrayMode" } })];
    }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-button", { attrs: { variant: "link", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.hideIntray = !_vm.hideIntray;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.hideIntray ? "eye" : "eye-slash" } })], 1)], 1)], 1)])];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("div", { directives: [{ name: "show", rawName: "v-show", value: !_vm.hideIntray, expression: "!hideIntray" }] }, [_vm.intrayMode === "item" ? _c("div", { staticClass: "row mb-3" }, [_c("div", { staticClass: "col" }, [_c("b-input-group", { attrs: { size: "sm" }, scopedSlots: _vm._u([{ key: "prepend", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)];
  }, "fn"), proxy: !0 }], null, !1, 3656874073) }, [_vm._v(" "), _c("b-form-input", { attrs: { id: "filter-input", type: "search", placeholder: "Filter name..." }, model: { value: _vm.filter, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filter = $$v;
  }, "callback"), expression: "filter" } })], 1)], 1), _vm._v(" "), _c("div", { staticClass: "col" }, [_vm.totalItems > _vm.perPage ? _c("span", { staticClass: "float-right" }, [_vm.intray ? _c("b-pagination", { staticClass: "my-0", attrs: { size: "sm", "total-rows": _vm.totalItems, "per-page": _vm.perPage }, model: { value: _vm.currentPage, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.currentPage = $$v;
  }, "callback"), expression: "currentPage" } }) : _vm._e()], 1) : _vm._e()])]) : _vm._e(), _vm._v(" "), _vm.intrayMode === "item" ? _c("div", [_c("intray-list-table", { attrs: { value: _vm.intrayItems, "table-fields": _vm.tableFields, "table-busy": _vm.loading, filter: _vm.filter, "per-page": _vm.perPage, "current-page": _vm.currentPage }, on: { filtered: _vm.onFiltered } })], 1) : _vm._e(), _vm._v(" "), _vm.intrayMode === "page" ? _c("div", [_vm.pages && !_vm.pages.length ? _c("b-table", { attrs: { fields: _vm.tableFields, items: [], busy: _vm.loading, small: "", responsive: "sm", "empty-text": "No items in list", hover: "", "sort-icon-left": "", "show-empty": "", "sticky-header": "" }, scopedSlots: _vm._u([{ key: "empty", fn: /* @__PURE__ */ __name(function(scope) {
    return [_c("p", { staticClass: "text-muted" }, [_vm._v(_vm._s(scope.emptyText))])];
  }, "fn") }], null, !1, 252857171) }) : _vm._e(), _vm._v(" "), _vm._l(_vm.pages, function(page) {
    return _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("h5", [_c("b-form", { attrs: { inline: "" } }, [_c("span", { staticClass: "mr-2" }, [_vm._v(_vm._s(page.pageName))]), _vm._v(" "), _c("b-badge", { staticClass: "mr-2", attrs: { variant: "info", size: "sm", pill: "" } }, [_vm._v(_vm._s(page.totalItems))]), _vm._v(" "), _c("b-input-group", { attrs: { size: "sm" }, scopedSlots: _vm._u([{ key: "prepend", fn: /* @__PURE__ */ __name(function() {
      return [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-form-input", { attrs: { id: "filter-input", type: "search", placeholder: "Filter name..." }, model: { value: page.filter, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(page, "filter", $$v);
    }, "callback"), expression: "page.filter" } })], 1)], 1)], 1)]), _vm._v(" "), _c("div", { staticClass: "col" }, [page.totalItems > _vm.perPage ? _c("span", { staticClass: "float-right" }, [_vm.intray ? _c("b-pagination", { staticClass: "my-0", attrs: { "total-rows": page.totalItems, "per-page": _vm.perPage }, model: { value: page.currentPage, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(page, "currentPage", $$v);
    }, "callback"), expression: "page.currentPage" } }) : _vm._e()], 1) : _vm._e()])]), _vm._v(" "), page.hidden ? _c("hr") : _c("intray-list-table", { attrs: { value: page.items, "table-fields": _vm.pageTableFields, "table-busy": _vm.loading || !_vm.pages, "page-id": page.pageId, filter: page.filter, "total-items": page.totalItems, "per-page": _vm.perPage, "current-page": page.currentPage }, on: { filtered: _vm.onPageFiltered } })], 1);
  })], 2) : _vm._e()])])], 1)]);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  IntrayListComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "11fdfd6b"
);
const IntrayList = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a4;
let IntraysComponent = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "personalIntray", null);
    __publicField(this, "managerIntray", null);
    __publicField(this, "sharedIntray", null);
    __publicField(this, "personalIntrayLoading", !1);
    __publicField(this, "managerIntrayLoading", !1);
    __publicField(this, "sharedIntrayLoading", !1);
  }
  mounted() {
    this.loadMyIntray(!0), this.loadPersonalIntray(!0), this.loadSharedIntray(!0);
  }
  loadMyIntray(setLoading) {
    this.personalIntrayLoading = setLoading, new IntrayClient(new Transformer(), baseUrl()).personalIntray().then((model) => {
      this.personalIntray = model;
    }).finally(() => {
      this.personalIntrayLoading = !1;
    });
  }
  loadPersonalIntray(setLoading) {
    this.managerIntrayLoading = setLoading, new IntrayClient(new Transformer(), baseUrl()).managerIntray().then((model) => {
      this.managerIntray = model;
    }).finally(() => {
      this.managerIntrayLoading = !1;
    });
  }
  loadSharedIntray(setLoading) {
    this.sharedIntrayLoading = setLoading, new IntrayClient(new Transformer(), baseUrl()).sharedIntray().then((model) => {
      this.sharedIntray = model;
    }).finally(() => {
      this.sharedIntrayLoading = !1;
    });
  }
}, __name(_a4, "IntraysComponent"), _a4);
IntraysComponent = __decorateClass([
  Component({
    components: { IntrayList }
  })
], IntraysComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("intray-list", { staticClass: "mb-2", attrs: { intray: _vm.personalIntray, "show-queues": !1, loading: _vm.personalIntrayLoading, icon: "user", title: "My Items", "title-message": "Items that are located in your personal queues" } }), _vm._v(" "), _vm.managerIntray && _vm.managerIntray.accessible ? _c("intray-list", { staticClass: "mb-2", attrs: { intray: _vm.managerIntray, "show-queues": !0, loading: _vm.managerIntrayLoading, icon: "user-friends", title: "Staff items", "title-message": "Items that are located in personal queues that belong other users" } }) : _vm._e(), _vm._v(" "), _c("intray-list", { attrs: { intray: _vm.sharedIntray, "show-queues": !0, loading: _vm.sharedIntrayLoading, icon: "users", title: "Shared items", "title-message": "Items that are located in shared queues that are accessible by multiple users" } })], 1)]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  IntraysComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "5d8a9171"
);
const intrays = __component__.exports;
export {
  intrays as default
};
