var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { C as Component, V as Vue, n as normalizeComponent, P as Prop, cD as AdministrationIntegrationsEzeScanClient, T as Transformer, b as baseUrl, cE as Routes } from "./main-DAVWuHbi.js";
import { i as isUrl } from "./isURL-BKWXD2PE.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
import { V as VModel } from "./VModel-D6nuZPuz.js";
import { P as PrivateInput } from "./privateInput-Co-cfsKm.js";
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$4"), _a;
let ClientCredentialsGrantType = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
  get tokenEndpoint() {
    return this.model.endpoint;
  }
  set tokenEndpoint(endpoint) {
    this.model = { ...this.model, endpoint };
  }
  get clientId() {
    return this.model.clientId;
  }
  set clientId(clientId) {
    this.model = { ...this.model, clientId };
  }
  get clientSecret() {
    return this.model.clientSecret;
  }
  set clientSecret(clientSecret) {
    this.model = { ...this.model, clientSecret };
  }
  get ignoreSslErrors() {
    return this.model.ignoreSslCertificateErrors;
  }
  set ignoreSslErrors(ignoreSslCertificateErrors) {
    this.model = { ...this.model, ignoreSslCertificateErrors };
  }
}, __name(_a, "ClientCredentialsGrantType"), _a);
__decorateClass$4([
  VModel({ required: !0 })
], ClientCredentialsGrantType.prototype, "model", 2);
ClientCredentialsGrantType = __decorateClass$4([
  Component({
    components: { PrivateInput }
  })
], ClientCredentialsGrantType);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Token Endpoint")]), _vm._v(" "), _c("div", { staticClass: "input-group" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.tokenEndpoint, expression: "tokenEndpoint" }], staticClass: "form-control", domProps: { value: _vm.tokenEndpoint }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.tokenEndpoint = $event.target.value);
  }, "input") } })])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Client Id")]), _vm._v(" "), _c("div", { staticClass: "input-group" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.clientId, expression: "clientId" }], staticClass: "form-control", domProps: { value: _vm.clientId }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.clientId = $event.target.value);
  }, "input") } })])]), _vm._v(" "), _c("private-input", { attrs: { label: "Client Secret", "input-name": "clientSecret" }, model: { value: _vm.clientSecret, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.clientSecret = $$v;
  }, "callback"), expression: "clientSecret" } }), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "ignoreSslErrorsSwitch", switch: "" }, model: { value: _vm.ignoreSslErrors, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.ignoreSslErrors = $$v;
  }, "callback"), expression: "ignoreSslErrors" } }, [_c("b", [_vm._v(`Ignore
                Token Provider SSL Issues`)])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v(`Ignores any issues with the SSL certificate. Enabling this option potentially
            makes communication less secure.`)])])], 1);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  ClientCredentialsGrantType,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  "7324289f"
);
const ClientCredentialsGrantTypeComponent = __component__$4.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$3"), _a2;
let OAuthOptionsComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "grantTypes");
    __publicField(this, "model");
  }
  get grantTypeOptions() {
    return grantTypes.filter((t) => this.grantTypes.includes(t.id));
  }
  get grantType() {
    var _a6;
    return (_a6 = this.model) == null ? void 0 : _a6.grantType;
  }
  set grantType(grantType) {
    var _a6;
    this.model = (_a6 = grantTypes.find((t) => t.id == grantType)) == null ? void 0 : _a6.factory();
  }
  get grantOptionsComponent() {
    var _a6;
    return (_a6 = grantTypes.find((o) => o.id == this.grantType)) == null ? void 0 : _a6.component;
  }
}, __name(_a2, "OAuthOptionsComponent"), _a2);
__decorateClass$3([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], OAuthOptionsComponent.prototype, "grantTypes", 2);
__decorateClass$3([
  VModel({
    required: !0
  })
], OAuthOptionsComponent.prototype, "model", 2);
OAuthOptionsComponent = __decorateClass$3([
  Component({
    components: { ReactiveDropdown }
  })
], OAuthOptionsComponent);
const grantTypes = [
  {
    id: "client_credentials",
    name: "Client Credentials",
    component: ClientCredentialsGrantTypeComponent,
    factory: /* @__PURE__ */ __name(() => ({ grantType: "client_credentials", clientId: null, clientSecret: null }), "factory")
  }
];
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Grant Type")]), _vm._v(" "), _c("div", { staticClass: "input-group" }, [_c("reactive-dropdown", { attrs: { options: _vm.grantTypeOptions }, model: { value: _vm.grantType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.grantType = $$v;
  }, "callback"), expression: "grantType" } })], 1)]), _vm._v(" "), _vm.grantOptionsComponent ? _c(_vm.grantOptionsComponent, { tag: "component", model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } }) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  OAuthOptionsComponent,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  "050816a1"
);
const OAuthOptions = __component__$3.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$2"), _a3;
let OAuthAuthenticationOptionsComponent$1 = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
    __publicField(this, "grantTypes", ["client_credentials"]);
  }
  get options() {
    return this.model.options;
  }
  set options(options) {
    this.model = { ...this.model, options };
  }
}, __name(_a3, "OAuthAuthenticationOptionsComponent"), _a3);
__decorateClass$2([
  VModel({ required: !0 })
], OAuthAuthenticationOptionsComponent$1.prototype, "model", 2);
OAuthAuthenticationOptionsComponent$1 = __decorateClass$2([
  Component({
    components: { OAuthOptions }
  })
], OAuthAuthenticationOptionsComponent$1);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("o-auth-options", { attrs: { "grant-types": _vm.grantTypes }, model: { value: _vm.options, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.options = $$v;
  }, "callback"), expression: "options" } });
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  OAuthAuthenticationOptionsComponent$1,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "8320c06a"
);
const OAuthAuthenticationOptionsComponent = __component__$2.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$1"), _a4;
let ApiKeyAuthenticationOptionsComponent$1 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
  get apiKey() {
    return this.model.apiKey;
  }
  set apiKey(value) {
    this.model = { ...this.model, apiKey: value };
  }
}, __name(_a4, "ApiKeyAuthenticationOptionsComponent"), _a4);
__decorateClass$1([
  VModel({ required: !0 })
], ApiKeyAuthenticationOptionsComponent$1.prototype, "model", 2);
ApiKeyAuthenticationOptionsComponent$1 = __decorateClass$1([
  Component({
    components: { PrivateInput }
  })
], ApiKeyAuthenticationOptionsComponent$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("private-input", { attrs: { label: "API Key", "input-name": "apiKey", "help-text": "Enter the API key that has been configured in your EzeScan Server instance" }, model: { value: _vm.apiKey, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.apiKey = $$v;
  }, "callback"), expression: "apiKey" } });
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  ApiKeyAuthenticationOptionsComponent$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "5880ff7b"
);
const ApiKeyAuthenticationOptionsComponent = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a5;
let AdministrationEzeScanInstanceRoute = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "saving", !1);
    __publicField(this, "savingError", null);
    __publicField(this, "instance", { endpoint: null, id: null, name: null, disabled: !1 });
    __publicField(this, "testing", !1);
    __publicField(this, "testSuccess", !1);
    __publicField(this, "testFailure", null);
  }
  created() {
    this.instanceId && this.load(), this.$validator.extend("localUrl", url);
  }
  async load() {
    this.loading = !0, this.loadingError = null;
    try {
      this.instance = await new AdministrationIntegrationsEzeScanClient(new Transformer(), baseUrl()).getInstance(this.instanceId);
    } catch (e) {
      this.loadingError = e;
    } finally {
      this.loading = !1;
    }
  }
  get instanceId() {
    return this.$router.currentRoute.params.id;
  }
  get canSubmit() {
    return !this.$validator.errors.any();
  }
  onSave() {
    return this.save();
  }
  async save() {
    this.saving = !0;
    let client = new AdministrationIntegrationsEzeScanClient(new Transformer(), baseUrl());
    try {
      this.instanceId ? await client.updateInstance(this.instanceId, this.instance) : await client.createInstance(this.instance), this.$router.push({ name: Routes.Instances });
    } catch (e) {
      this.savingError = e;
    } finally {
      this.saving = !1;
    }
  }
  test() {
    this.testing = !0, this.testSuccess = !1, this.testFailure = null, new AdministrationIntegrationsEzeScanClient(new Transformer(), baseUrl()).testConnection({
      address: this.instance.endpoint,
      ignoreSslErrors: this.instance.ignoreSslErrors,
      authentication: this.authentication
    }).then((e) => {
      e.isSuccess ? this.testSuccess = !0 : this.testFailure = e.reason;
    }).finally(() => this.testing = !1);
  }
  onCancel() {
    this.$router.back();
  }
  get authenticationOptions() {
    return authenticationOptions;
  }
  get authenticationType() {
    var _a6;
    return (_a6 = this.instance.authentication) == null ? void 0 : _a6.authenticationType;
  }
  set authenticationType(authenticationType) {
    var _a6;
    let authentication = (_a6 = authenticationOptions.find((o) => o.id == authenticationType)) == null ? void 0 : _a6.factory();
    authentication != null && (this.instance = { ...this.instance, authentication });
  }
  get authenticationComponent() {
    var _a6;
    return this.authenticationType ? (_a6 = authenticationOptions.find((o) => o.id == this.authenticationType)) == null ? void 0 : _a6.component : null;
  }
  get authentication() {
    var _a6;
    return (_a6 = this.instance) == null ? void 0 : _a6.authentication;
  }
  set authentication(authentication) {
    this.instance = { ...this.instance, authentication };
  }
}, __name(_a5, "AdministrationEzeScanInstanceRoute"), _a5);
AdministrationEzeScanInstanceRoute = __decorateClass([
  Component({
    components: { ReactiveDropdown }
  })
], AdministrationEzeScanInstanceRoute);
function url(value) {
  return value == null && (value = ""), isUrl(value, {
    require_tld: !1,
    require_protocol: !0
  });
}
__name(url, "url");
const authenticationOptions = [
  {
    id: "none",
    name: "No Authentication",
    badge: null,
    colour: null,
    icon: null,
    component: Vue.component("ezescan-instance-no-authentication", { template: "<b-alert show variant='info'>No authentication configuration required</b-alert>" }),
    factory: /* @__PURE__ */ __name(() => ({ authenticationType: "none" }), "factory")
  },
  {
    id: "oauth",
    name: "OAuth",
    badge: null,
    icon: null,
    colour: null,
    component: OAuthAuthenticationOptionsComponent,
    factory: /* @__PURE__ */ __name(() => ({ authenticationType: "oauth", options: null }), "factory")
  },
  {
    id: "apiKey",
    name: "API Key",
    badge: null,
    icon: null,
    colour: null,
    component: ApiKeyAuthenticationOptionsComponent,
    factory: /* @__PURE__ */ __name(() => ({ authenticationType: "apiKey", apiKey: "" }), "factory")
  }
];
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_vm.instanceId ? _c("h3", [_vm._v("Edit EzeScan Server Instance")]) : _c("h3", [_vm._v("Create new EzeScan Server Instance")]), _vm._v(" "), _vm.loading ? _c("div", [_vm._v(`
            Loading
            `), _c("br"), _vm._v(" "), _c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } })], 1) : _vm.loadingError ? _c("div", [_vm._v(`
            ` + _vm._s(_vm.loadingError) + `
        `)]) : _c("div", [_c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("name") } }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }, { name: "model", rawName: "v-model", value: _vm.instance.name, expression: "instance.name" }], staticClass: "form-control", attrs: { type: "text", "data-vv-as": "EzeScan Instance Name", name: "name" }, domProps: { value: _vm.instance.name }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.instance, "name", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Name for the ezescan connection")]), _vm._v(" "), _vm.errors.has("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("name")))]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Endpoint URL")]), _vm._v(" "), _c("div", { staticClass: "input-group", class: { "has-error": _vm.errors.has("endpoint") } }, [_c("input", { directives: [{ name: "validate", rawName: "v-validate", value: "localUrl|required", expression: "'localUrl|required'" }, { name: "model", rawName: "v-model", value: _vm.instance.endpoint, expression: "instance.endpoint" }], staticClass: "form-control", attrs: { "data-vv-as": "EzeScan Url", name: "endpoint", type: "text", disabled: _vm.testing }, domProps: { value: _vm.instance.endpoint }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.instance, "endpoint", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("div", { staticClass: "input-group-append" }, [_c("button", { staticClass: "btn btn-primary", attrs: { disabled: _vm.testing || !_vm.canSubmit }, on: { click: _vm.test } }, [_vm.testing ? _c("span", [_vm._v("Testing...")]) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "vial" } }), _vm._v(" Test")], 1)])])]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Url of the EzeScan Web Service Endpoint")]), _vm._v(" "), _vm.errors.has("endpoint") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("endpoint")))]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_vm.testSuccess ? _c("div", { staticClass: "alert alert-success" }, [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(` Test Successful!
                `)], 1) : _vm.testFailure ? _c("div", { staticClass: "alert alert-danger" }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(" Test failed. " + _vm._s(_vm.testFailure) + `
                `)], 1) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "ignoreSslErrorsSwitch", switch: "" }, model: { value: _vm.instance.ignoreSslErrors, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.instance, "ignoreSslErrors", $$v);
  }, "callback"), expression: "instance.ignoreSslErrors" } }, [_c("b", [_vm._v(`Ignore
                        SSL Issues`)])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v(`Ignores any issues with the SSL certificate. Enabling this option potentially
                    makes communication less secure.`)])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Authentication")]), _vm._v(" "), _c("div", { staticClass: "input-group" }, [_c("reactive-dropdown", { attrs: { options: _vm.authenticationOptions }, model: { value: _vm.authenticationType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.authenticationType = $$v;
  }, "callback"), expression: "authenticationType" } })], 1)]), _vm._v(" "), _vm.authenticationComponent ? _c(_vm.authenticationComponent, { tag: "component", model: { value: _vm.authentication, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.authentication = $$v;
  }, "callback"), expression: "authentication" } }) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button" }, on: { click: _vm.onCancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", attrs: { type: "button", disabled: _vm.saving || !_vm.canSubmit }, on: { click: _vm.onSave } }, [_vm.saving ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(" Saving...")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1)])]), _vm._v(" "), _vm.savingError ? _c("div", [_vm._v(_vm._s(_vm.savingError))]) : _vm._e()], 1)])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationEzeScanInstanceRoute,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "94a8d578"
);
const instance = __component__.exports;
export {
  instance as default
};
