var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, b as baseUrl, c8 as FormsClient, T as Transformer, bI as ManagementFormStatus, c9 as AdministrationFormsClient, _, ca as ManagementFormOutputStatus, t as toastr, C as Component, w as createUrl, v as vSelect, L as LoadingBarComponent, E as ErrorPanel, n as normalizeComponent, c3 as UsageStatisticType, cb as AdministrationFormsUsageClient, M as Moment, g as v4, P as Prop, cc as AdministrationFormsCleanupClient, a6 as userIsSuperAdmin } from "./main-DAVWuHbi.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
import { V as VueMultiselect } from "./vue-multiselect.min-BYrAqjX1.js";
import { F as FormHistoryModal } from "./formHistoryModal-DbdedW2d.js";
import ErrorModal from "./errorModal-BqEHnF6f.js";
import TemplateSummary from "./templateSummary-BsyF-Lep.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
import { f as Bar, g as Line, C as Chart, p as plugin_title, a as plugin_tooltip, b as plugin_legend, L as LineElement, c as LinearScale, d as CategoryScale, e as PointElement, B as BarElement } from "./index-CL7C-Mhu.js";
var __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$4"), _a;
let FormsRoute = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "rowDetailIds", []);
    __publicField(this, "pageNumber", 1);
    __publicField(this, "pageOptions", []);
    __publicField(this, "filter", {
      limit: 10,
      offset: 0,
      campaignId: null,
      before: null,
      after: null,
      status: [],
      token: null,
      username: null,
      filterText: null,
      pageIds: [],
      sort: {}
    });
    __publicField(this, "error", null);
    __publicField(this, "loading", !1);
    __publicField(this, "pages", 0);
    __publicField(this, "forms", []);
    __publicField(this, "options", ["list", "of", "options"]);
    __publicField(this, "formIdHistoryToShow", null);
    __publicField(this, "showFormHistoryModal", !1);
    __publicField(this, "searchFormsDebounce", _.debounce(function() {
      this.getForms(!0);
    }, 300));
  }
  async mounted() {
    await this.getForms(!0), await this.setPageOptions();
  }
  downloadFormUrl(item) {
    return baseUrl() + "/app/forms/forms/" + item.id + "/submitted/download?submissionId=" + item.submissionId;
  }
  async setPageOptions() {
    let pages = await new FormsClient(new Transformer(), baseUrl()).getPages();
    this.pageOptions = [], pages.forEach((page) => {
      this.pageOptions.push({ name: page.name, value: page.id });
    });
  }
  get statuses() {
    return [
      { name: "Saved", value: ManagementFormStatus.Saved },
      { name: "Deleted", value: ManagementFormStatus.Deleted },
      { name: "Approved", value: ManagementFormStatus.Approved },
      { name: "Held", value: ManagementFormStatus.Held },
      { name: "Pending", value: ManagementFormStatus.Submitted }
    ];
  }
  get sort() {
    let sort = this.filter.sort;
    return sort || null;
  }
  set sort(sort) {
    this.filter.sort = sort, this.getForms();
  }
  async getForms(setLoading = !1) {
    let sortValue = null;
    this.filter.sort && this.filter.sort.by && (sortValue = (this.filter.sort.descending ? "-" : "+") + this.filter.sort.by), this.loading = setLoading;
    let model = await new AdministrationFormsClient(new Transformer(), baseUrl()).getForms(
      this.filter.campaignId,
      this.filter.before,
      this.filter.after,
      this.filter.limit,
      this.filter.offset,
      this.filter.status.map((v) => v.value),
      this.filter.filterText,
      this.filter.token,
      this.filter.username,
      this.pageIds.map((v) => v.value),
      sortValue
    );
    this.loading = !1, this.forms = model.forms, this.pages = Math.ceil(model.total / model.limit);
  }
  setHistoryToShow(formId) {
    this.formIdHistoryToShow = formId, this.showFormHistoryModal = !0;
  }
  closeHistoryModal() {
    this.formIdHistoryToShow = null, this.showFormHistoryModal = !1;
  }
  get filterStatus() {
    return this.filter.status;
  }
  set filterStatus(value) {
    this.filter.status = value, this.searchFormsDebounce();
  }
  get pageIds() {
    return this.filter.pageIds;
  }
  set pageIds(value) {
    this.filter.pageIds = value, this.searchFormsDebounce();
  }
  get filterText() {
    return this.filter.filterText;
  }
  set filterText(value) {
    this.filter.filterText = value, this.searchFormsDebounce();
  }
  get FormFilter() {
    return this.filter;
  }
  set FormFilter(value) {
    this.filter = value, this.getForms();
  }
  async changePage(page) {
    this.pageNumber = page, this.filter.offset = (page - 1) * this.filter.limit, await this.getForms(!0);
  }
  get tableFields() {
    return [
      { key: "token", tdClass: "align-middle" },
      { key: "created", tdClass: "align-middle" },
      { key: "lastUpdated", label: "Last Updated", tdClass: "align-middle" },
      { key: "pageName", tdClass: "align-middle" },
      { key: "status", label: "Status", tdClass: "align-middle" },
      { key: "user", label: "User", tdClass: "align-middle" },
      { key: "outputs" }
    ];
  }
  getStatusVariant(status) {
    switch (status) {
      case "saved":
        return "primary";
      case "submitted":
        return "warning";
      case "deleted":
        return "danger";
      case "approved":
        return "success";
      default:
        return "";
    }
  }
  getStatusIcon(status) {
    switch (status) {
      case "saved":
        return "save";
      case "submitted":
        return "paper-plane";
      case "deleted":
        return "trash";
      case "approved":
        return "check";
      default:
        return "";
    }
  }
  getStatusText(status) {
    switch (status) {
      case "saved":
        return "Active";
      case "submitted":
        return "Pending";
      case "deleted":
        return "Deleted";
      case "approved":
        return "Approved";
      default:
        return "";
    }
  }
  async retryOutput(pageId, output, formId) {
    if (output.status != ManagementFormOutputStatus.Failed && output.status != ManagementFormOutputStatus.Successful) {
      toastr.error("Can not retry a stage that has not completed");
      return;
    }
    let managementClient = new AdministrationFormsClient(new Transformer(), baseUrl());
    try {
      await managementClient.retryFormOutput(pageId, formId, output.id), toastr.success("The form output has been marked to retry");
    } catch (ex) {
      toastr.error("An error occurred while trying to retry the output" + ex);
    }
  }
  async downloadLog(pageId, outputLog, formId) {
    if (outputLog.status === ManagementFormOutputStatus.Failed || outputLog.status === ManagementFormOutputStatus.Successful) {
      let blob = (await new AdministrationFormsClient(new Transformer(), baseUrl()).getFormOutputLog(formId, outputLog.id, pageId)).data, downloadUrl = window.URL.createObjectURL(blob), anchor = document.createElement("a");
      anchor.href = downloadUrl, anchor.download = this.getOutputName(outputLog) + "-" + outputLog.id + ".log", document.body.appendChild(anchor), anchor.click(), anchor.remove();
    } else
      toastr.error("No output log can be downloaded");
  }
  getOutputName(output) {
    switch (output.name) {
      case "EzeScan.OutputConfiguration.Dispatch":
        return "Dispatch";
      case "EzeScan.OutputConfiguration.ApiEndpoint":
        return "API Endpoint";
      case "EzeScan.OutputConfiguration.Email":
        return "Email";
      case "EzeScan.OutputConfiguration.Filesystem":
        return "File System";
      case "EzeScan.OutputConfiguration.Indexing":
        return "Indexing";
      case "EzeScan.OutputConfiguration.SqlServer":
        return "Sql Server";
      case "EzeScan.OutputConfiguration.AzureBlobStorage":
        return "Azure Blob Storage";
      default:
        return output.name;
    }
  }
  getOutputIcon(output) {
    switch (output.status) {
      case ManagementFormOutputStatus.Running:
      case ManagementFormOutputStatus.Created:
        return "play-circle";
      case ManagementFormOutputStatus.Failed:
        return "times-circle";
      case ManagementFormOutputStatus.Successful:
        return "check-circle";
    }
  }
  getOutputVariant(output) {
    switch (output.status) {
      case ManagementFormOutputStatus.Running:
      case ManagementFormOutputStatus.Created:
        return "primary";
      case ManagementFormOutputStatus.Failed:
        return "danger";
      case ManagementFormOutputStatus.Successful:
        return "success";
    }
  }
  getOutputStatus(output) {
    switch (output.status) {
      case ManagementFormOutputStatus.Created:
        return "Started";
      case ManagementFormOutputStatus.Running:
        return "Running";
      case ManagementFormOutputStatus.Failed:
        return "Failed";
      case ManagementFormOutputStatus.Successful:
        return "Successful";
    }
  }
  getUserName(item) {
    if (item.contact) {
      if (item.contact.email)
        return item.contact.email;
      if (item.contact.userId)
        return item.contact.userId;
    }
    return null;
  }
  toggleRowDetails(row) {
    row.toggleDetails(), this.rowDetailIds.includes(row.item.id) ? this.rowDetailIds = this.rowDetailIds.filter(function(i) {
      return i !== row.item.id;
    }) : this.rowDetailIds.push(row.item.id);
  }
}, __name(_a, "FormsRoute"), _a);
FormsRoute = __decorateClass$4([
  Component({
    components: {
      SortableHeaderLink,
      TemplateSummary,
      ErrorPanel,
      LoadingBar: LoadingBarComponent,
      ErrorModal,
      ReactiveDropdown,
      PaginationControls,
      vSelect,
      DateDisplay,
      VueMultiselect,
      FormHistoryModal
    },
    methods: {
      createUrl
    }
  })
], FormsRoute);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_vm.error ? [_c("error-panel", { attrs: { error: _vm.error } }, [_vm._v(`
                    Failed to load forms. `), _c("a", { attrs: { role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.getForms(!0);
  }, "click") } }, [_vm._v("Retry?")])])] : !_vm.forms || _vm.loading ? [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)] : _vm._e(), _vm._v(" "), [_c("b-row", { staticClass: "mb-2" }, [_c("b-col", [_c("b-input-group", [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1), _vm._v(" "), _c("b-input", { attrs: { placeholder: "Filter...", id: "searchFilterText" }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1)], 1), _vm._v(" "), _c("b-col", [_c("vue-multiselect", { attrs: { options: _vm.statuses, multiple: !0, "track-by": "name", label: "name", loading: _vm.loading, placeholder: "Status", "close-on-select": !1, "clear-on-select": !1 }, scopedSlots: _vm._u([{ key: "selection", fn: /* @__PURE__ */ __name(function({ values, search, isOpen }) {
    return values.length && values.length > 1 ? [_c("span", { staticClass: "multiselect__single" }, [_vm._v(_vm._s(values.length) + " options selected")])] : void 0;
  }, "fn") }, { key: "option", fn: /* @__PURE__ */ __name(function(props) {
    return [_c("div", { staticClass: "option__desc" }, [_c("span", { staticClass: "option__title" }, [_vm._v(_vm._s(props.option.name))])])];
  }, "fn") }], null, !0), model: { value: _vm.filterStatus, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterStatus = $$v;
  }, "callback"), expression: "filterStatus" } })], 1), _vm._v(" "), _c("b-col", [_c("vue-multiselect", { attrs: { options: _vm.pageOptions, multiple: !0, "track-by": "name", label: "name", loading: _vm.loading, placeholder: "Pages", "close-on-select": !1, "clear-on-select": !1 }, scopedSlots: _vm._u([{ key: "selection", fn: /* @__PURE__ */ __name(function({ values, search, isOpen }) {
    return values.length && values.length > 1 ? [_c("span", { staticClass: "multiselect__single" }, [_vm._v(_vm._s(values.length) + " options selected")])] : void 0;
  }, "fn") }, { key: "option", fn: /* @__PURE__ */ __name(function(props) {
    return [_c("div", { staticClass: "option__desc" }, [_c("span", { staticClass: "option__title" }, [_vm._v(_vm._s(props.option.name))])])];
  }, "fn") }], null, !0), model: { value: _vm.pageIds, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageIds = $$v;
  }, "callback"), expression: "pageIds" } })], 1), _vm._v(" "), _c("b-col", [_c("b-button", { staticClass: "float-right rounded-pill mt-1", attrs: { size: "sm", variant: "outline-primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.getForms(!0);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(` Refresh
                  `)], 1)], 1)], 1), _vm._v(" "), _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.forms, striped: "", busy: _vm.loading, "details-td-class": "pt-0 pb-2", "sort-icon-left": "", "show-empty": "", emptyText: "No forms found", "thead-class": "pl-0", tdClass: "align-middle" }, scopedSlots: _vm._u([{ key: "head(token)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "created", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(created)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "created", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(lastUpdated)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "lastUpdated", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(pageName)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "created", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "status", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(user)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "user", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.created ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.created } }) : _vm._e()];
  }, "fn") }, { key: "cell(page)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
                  ` + _vm._s(row.item.pageId) + `
                `)];
  }, "fn") }, { key: "cell(lastUpdated)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.modified ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.modified } }) : _vm._e()];
  }, "fn") }, { key: "cell(token)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("a", { attrs: { href: _vm.downloadFormUrl(row.item), target: "_blank" } }, [_c("font-awesome-icon", { attrs: { icon: "download", title: "Download Form" } })], 1), _vm._v(`
                  ` + _vm._s(row.item.token) + `
                    `), _c("span", { staticClass: "float-right" }, [_c("b-button", { attrs: { variant: "link", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setHistoryToShow(row.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "history" } })], 1)], 1)];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-badge", { attrs: { variant: _vm.getStatusVariant(row.item.status) } }, [_c("font-awesome-icon", { attrs: { icon: _vm.getStatusIcon(row.item.status) } }), _vm._v(` 
                    ` + _vm._s(_vm.getStatusText(row.item.status)) + `
                  `)], 1), _vm._v(`
                   
                  `), row.item.campaign ? [_c("span", { staticClass: "badge badge-secondary" }, [_c("font-awesome-icon", { attrs: { icon: "layer-group" } }), _vm._v(`
                         
                        ` + _vm._s(row.item.campaign.name) + `
                    `)], 1), _vm._v(`
                     
                  `)] : _vm._e(), _vm._v(" "), row.item.rejection ? [_c("span", { staticClass: "badge badge-secondary" }, [_vm._v(`
                        Rejected
                    `)]), _vm._v(`
                     
                  `)] : _vm._e()];
  }, "fn") }, { key: "cell(user)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.contact.userId || row.item.contact.email ? _c("span", { staticClass: "badge badge-secondary" }, [_c("font-awesome-icon", { attrs: { icon: "user" } }), _vm._v(" " + _vm._s(_vm.getUserName(row.item)) + `
                  `)], 1) : _vm._e()];
  }, "fn") }, { key: "cell(outputs)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "text-nowrap" }, [_vm._l(row.item.outputs, function(output) {
      return _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { title: _vm.getOutputName(output) + " - " + _vm.getOutputStatus(output) }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.toggleRowDetails(row);
      }, "click") } }, [_c("font-awesome-icon", { class: "text-" + _vm.getOutputVariant(output), attrs: { icon: _vm.getOutputIcon(output) } })], 1);
    }), _vm._v(" "), row.item.outputs.length ? _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { variant: "link", size: "sm", title: "Show stage details" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: row.detailsShowing ? "caret-down" : "caret-right" } })], 1) : _vm._e()], 2)];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-card", { attrs: { "body-class": "p-3 mx-auto" } }, [_c("b-row", { staticClass: "py-0" }, [_c("b-col", _vm._l(row.item.outputs, function(output, index2) {
      return _c("span", { staticClass: "center" }, [output.status == "successful" || output.status == "failed" ? _c("b-dropdown", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], class: { "mx-1": index2 + 1 != row.item.outputs.length }, attrs: { "no-flip": "", title: _vm.getOutputName(output) + " - " + _vm.getOutputStatus(output), size: "sm", right: "", variant: "outline-" + _vm.getOutputVariant(output) }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
        return [_c("font-awesome-icon", { attrs: { icon: _vm.getOutputIcon(output) } }), _vm._v(`
                              ` + _vm._s(_vm.getOutputName(output)) + `
                            `)];
      }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { attrs: { pill: "" }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.downloadLog(row.item.pageId, output, row.item.id);
      }, "click") } }, [_c("font-awesome-icon", { class: "text-" + _vm.getOutputVariant(output), attrs: { icon: _vm.getOutputIcon(output) } }), _vm._v(`
                              Download Log file
                            `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { pill: "" }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.retryOutput(row.item.pageId, output, row.item.id);
      }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "refresh" } }), _vm._v(" "), output.status == "successful" ? _c("span", [_vm._v(`
                                  Rerun
                              `)]) : _c("span", [_vm._v(`
                                  Retry
                              `)])], 1)], 1) : _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: _vm.getOutputStatus(output) } }, [_c("b-button", { class: { "mx-1": index2 + 1 != row.item.outputs.length }, attrs: { disabled: "", size: "sm", right: "", variant: "outline-" + _vm.getOutputVariant(output) } }, [_c("font-awesome-icon", { attrs: { icon: _vm.getOutputIcon(output) } }), _vm._v(`
                              ` + _vm._s(_vm.getOutputName(output)) + `
                          `)], 1)], 1), _vm._v(" "), index2 + 1 != row.item.outputs.length ? _c("font-awesome-icon", { staticClass: "align-middle", attrs: { size: "xs", icon: "chevron-right" } }) : _vm._e(), _vm._v(` 
                        `)], 1);
    }), 0)], 1)], 1)];
  }, "fn") }]) }), _vm._v(" "), _c("div", { staticClass: "text-center" }, [_vm.filter ? _c("pagination-controls", { attrs: { count: _vm.pages, value: _vm.pageNumber }, on: { input: _vm.changePage } }) : _vm._e()], 1)]], 2)]), _vm._v(" "), _c("form-history-modal", { attrs: { formId: _vm.formIdHistoryToShow, shouldShow: _vm.showFormHistoryModal }, on: { close: _vm.closeHistoryModal } })], 1);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  FormsRoute,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  "debe5ffd"
);
const FormsComponent = __component__$4.exports;
var __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$3"), _a2;
let AdministrationFormsUsageComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !0);
    __publicField(this, "graphType", UsageStatisticType.Last24Hours);
    __publicField(this, "chart", "bar");
    __publicField(this, "model", null);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "barComponent", Bar);
    __publicField(this, "lineComponent", Line);
    __publicField(this, "showChart", !1);
    __publicField(this, "usageTypes", [
      { value: UsageStatisticType.Last24Hours, text: "Last 24 hours" },
      { value: UsageStatisticType.Today, text: "Today" },
      { value: UsageStatisticType.LastWeek, text: "Last week" },
      { value: UsageStatisticType.ThisWeek, text: "This week" },
      { value: UsageStatisticType.LastMonth, text: "Last month" },
      { value: UsageStatisticType.ThisMonth, text: "This month" },
      { value: UsageStatisticType.Last3Months, text: "Last 3 months" },
      { value: UsageStatisticType.LastYear, text: "Last year" },
      { value: UsageStatisticType.ThisYear, text: "This year" }
    ]);
    __publicField(this, "chartTypes", [
      { value: "bar", text: "Bar" },
      { value: "line", text: "Line" }
    ]);
  }
  async mounted() {
    await new AdministrationFormsUsageClient(new Transformer(), baseUrl()).getCanUseUsage() && (this.showChart = !0, Chart.register(plugin_title, plugin_tooltip, plugin_legend, LineElement, LinearScale, CategoryScale, PointElement, BarElement, CategoryScale, LinearScale), this.reloadTimer = setInterval(() => this.refresh(), 3e4), await this.refresh());
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer), this.loading = !1;
  }
  get usageType() {
    return this.graphType;
  }
  set usageType(value) {
    this.graphType = value, this.refresh();
  }
  get chartType() {
    return this.chart;
  }
  set chartType(value) {
    this.chart = value, this.loading = !0, this.loading = !1;
  }
  async refresh() {
    try {
      let results = await new AdministrationFormsUsageClient(new Transformer(), baseUrl()).getUsageStatistics(this.graphType);
      this.model = results;
    } catch {
    } finally {
      this.loading = !1;
    }
  }
  get labels() {
    return this.model.results.map((y) => this.mapDate(y.dateData));
  }
  mapDate(date) {
    switch (this.graphType) {
      case UsageStatisticType.Last24Hours:
      case UsageStatisticType.Today:
        return Moment(date).local().format("hA");
      case UsageStatisticType.LastWeek:
      case UsageStatisticType.ThisWeek:
        return Moment(date).local().format("dddd");
      case UsageStatisticType.LastMonth:
      case UsageStatisticType.ThisMonth:
        return "Week " + Moment(date).local().format("W");
      case UsageStatisticType.Last3Months:
        return "Week " + Moment(date).local().format("W");
      case UsageStatisticType.LastYear:
      case UsageStatisticType.ThisYear:
        return Moment(date).local().format("MMMM");
    }
  }
  get chartData() {
    return {
      labels: this.labels,
      datasets: [
        {
          label: "Created",
          backgroundColor: "#0074D9",
          data: this.model.results.map((y) => y.formsCreated)
        },
        {
          label: "Approved",
          backgroundColor: "#FF4136",
          data: this.model.results.map((y) => y.formsApproved)
        }
      ]
    };
  }
  get chartOptions() {
    return {
      responsive: !0,
      maintainAspectRatio: !1
    };
  }
  get canvasId() {
    return v4();
  }
}, __name(_a2, "AdministrationFormsUsageComponent"), _a2);
AdministrationFormsUsageComponent = __decorateClass$3([
  Component({ components: {} })
], AdministrationFormsUsageComponent);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_vm.showChart ? _c("b-card", { scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("span", { staticClass: "align-middle" }, [_c("font-awesome-icon", { attrs: { icon: "chart-simple" } }), _vm._v(`
              Usage
              `)], 1), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.refresh(!0);
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)])], 1)];
  }, "fn"), proxy: !0 }], null, !1, 79696856) }, [_vm._v(" "), !_vm.model && _vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _vm._e(), _vm._v(" "), _c("b-form-select", { staticClass: "col-md-1 mr-1", attrs: { options: _vm.chartTypes }, model: { value: _vm.chartType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.chartType = $$v;
  }, "callback"), expression: "chartType" } }), _vm._v(" "), _c("b-form-select", { staticClass: "col-md-2 mr-1", attrs: { options: _vm.usageTypes }, model: { value: _vm.usageType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.usageType = $$v;
  }, "callback"), expression: "usageType" } }), _vm._v(" "), _vm.model && !_vm.loading && _vm.chart == "bar" ? _c(_vm.barComponent, { tag: "component", attrs: { "chart-data": _vm.chartData, "chart-id": _vm.canvasId, "dataset-id-key": "dateData", "chart-options": _vm.chartOptions } }) : _vm._e(), _vm._v(" "), _vm.model && !_vm.loading && _vm.chart == "line" ? _c(_vm.lineComponent, { tag: "component", attrs: { "chart-data": _vm.chartData, "chart-id": _vm.canvasId, "dataset-id-key": "dateData", "chart-options": _vm.chartOptions } }) : _vm._e()], 1) : _c("b-alert", { attrs: { show: "", variant: "warning", id: "notSupportedAlert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
    You must configure your EWA instance to use SQL Server to access the forms usage graphs.
  `)], 1)], 1);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  AdministrationFormsUsageComponent,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const FormsUsageComponent = __component__$3.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$2"), _a3;
let ConfirmCleanupItemsModal = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "olderThanDate");
    __publicField(this, "formsToClean", 0);
  }
  async modalShown() {
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("confirm-cleanup-modal");
  }
  get modalTitle() {
    return "Remove " + this.formsToClean + " approved forms?";
  }
  get date() {
    return new Date(this.olderThanDate);
  }
}, __name(_a3, "ConfirmCleanupItemsModal"), _a3);
__decorateClass$2([
  Prop({ required: !0 })
], ConfirmCleanupItemsModal.prototype, "olderThanDate", 2);
__decorateClass$2([
  Prop({ required: !0 })
], ConfirmCleanupItemsModal.prototype, "formsToClean", 2);
ConfirmCleanupItemsModal = __decorateClass$2([
  Component({
    components: { DateDisplay }
  })
], ConfirmCleanupItemsModal);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "confirm-cleanup-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, on: { shown: _vm.modalShown }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
      Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "primary", disabled: _vm.formsToClean === 0 }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "broom" } }), _vm._v(` Start cleanup
    `)], 1)];
  }, "fn") }]) }, [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
    There are ` + _vm._s(_vm.formsToClean) + " approved forms before "), _c("date-display", { attrs: { humanise: !1, value: _vm.date, "show-time": !1 } }), _vm._v(" "), _c("br"), _vm._v(" "), _vm.formsToClean > 0 ? _c("span", [_vm._v(`
      Are you sure you want to remove ` + _vm._s(_vm.formsToClean) + ` approved/deleted form records?
      `), _c("br"), _vm._v(`
      This is not reversible.
    `)]) : _vm._e()], 1)], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  ConfirmCleanupItemsModal,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  null
);
const ConfirmCleanupModal = __component__$2.exports;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$1"), _a4;
let AdministrationFormsCleanupComponent = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !0);
    __publicField(this, "canUse", !1);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "isRunning", !1);
    __publicField(this, "olderThan", null);
    __publicField(this, "formsLeftToClean", 0);
    __publicField(this, "formScheduledToClean", 0);
    __publicField(this, "datepicker", null);
  }
  async mounted() {
    this.canUse = await new AdministrationFormsCleanupClient(new Transformer(), baseUrl()).getCanUse();
    let info = await new AdministrationFormsCleanupClient(new Transformer(), baseUrl()).cleanupRunningInfo();
    this.isRunning = info.isRunning, info.olderThanDate && (this.olderThan = Moment(info.olderThanDate).format("yyyy-MM-DD")), this.isRunning && info.operation == "Cleanup" ? (toastr.success("Clean-up is currently running"), this.reloadTimer = setInterval(() => this.refresh(), 1e4), await this.refresh()) : this.isRunning && (toastr.warning("Please wait for the current bulk operation completes", "Another bulk operation is running"), this.reloadTimer = setInterval(() => this.refresh(), 1e4), await this.refresh()), this.canUse && (await this.$nextTick, this.setDatepickerSettings());
  }
  setDatepickerSettings() {
    this.datepicker = $("#cleanup .input-group.date"), this.datepicker.datepicker({
      todayHighlight: !0,
      orientation: "bottom left",
      endDate: /* @__PURE__ */ new Date(),
      autoclose: !0,
      forceParse: !1,
      format: "yyyy-mm-dd"
    }).on("changeDate", (e) => {
      this.olderThan = e.format();
    });
  }
  async showConfigureSyncModal() {
    this.formScheduledToClean = await new AdministrationFormsCleanupClient(new Transformer(), baseUrl()).checkCleanCount(this.olderThan), this.$bvModal.show("confirm-cleanup-modal");
  }
  async startCleanup() {
    await new AdministrationFormsCleanupClient(new Transformer(), baseUrl()).startFormsClean(this.olderThan), toastr.info("Forms cleanup has started"), this.refresh(), this.reloadTimer = setInterval(() => this.refresh(), 1e3);
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer), this.loading = !1;
  }
  async refresh() {
    try {
      let info = await new AdministrationFormsCleanupClient(new Transformer(), baseUrl()).cleanupRunningInfo();
      this.isRunning = info.isRunning, this.isRunning && this.olderThan ? (this.formsLeftToClean = await new AdministrationFormsCleanupClient(new Transformer(), baseUrl()).checkCleanCount(this.olderThan), this.formScheduledToClean == 0 && (this.formScheduledToClean = this.formsLeftToClean)) : !this.isRunning && info.operation == "Cleanup" ? (toastr.success("Forms cleanup finished"), clearTimeout(this.reloadTimer)) : this.isRunning || (toastr.success("The other bulk operation has completed"), clearTimeout(this.reloadTimer));
    } finally {
      this.loading = !1;
    }
  }
}, __name(_a4, "AdministrationFormsCleanupComponent"), _a4);
AdministrationFormsCleanupComponent = __decorateClass$1([
  Component({ components: { ConfirmCleanupModal } })
], AdministrationFormsCleanupComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-alert", { attrs: { show: "", variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" "), _c("strong", [_vm._v("Preview Feature!")]), _c("br"), _c("span", [_vm._v("This feature is currently in preview. Please take a backup copy of the databases before running the cleanup.")])], 1), _vm._v(" "), _vm.canUse ? _c("b-card", { scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("span", { staticClass: "align-middle" }, [_c("font-awesome-icon", { attrs: { icon: "broom" } }), _vm._v(`
              Forms Cleanup
            `)], 1)])];
  }, "fn"), proxy: !0 }], null, !1, 528312352) }, [_vm._v(" "), _c("b-row", [_c("b-col", { attrs: { cols: "12" } }, [_c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
            Forms cleanup will allow you to remove old forms from the Database to free up space and reduce clutter.
            Doing so will permanently delete those records removing the ability to modify, output or search for those forms.
          `)], 1)], 1)], 1), _vm._v(" "), _c("b-row", { attrs: { id: "cleanup" } }, [_c("b-col", { attrs: { md: "6", lg: "4", cols: "12" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Cleanup Forms Approved/Deleted Before")]), _vm._v(" "), _c("b-input-group", { staticClass: "mb-2 date", scopedSlots: _vm._u([{ key: "append", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "calendar" } })], 1)];
  }, "fn"), proxy: !0 }], null, !1, 2330456349) }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.olderThan, expression: "olderThan" }], staticClass: "form-control", attrs: { type: "text", id: "olderThanDatePicker", placeholder: "Select a date...", disabled: _vm.isRunning, autocomplete: "off" }, domProps: { value: _vm.olderThan }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.olderThan = $event.target.value);
  }, "input") } })]), _vm._v(" "), _c("b-form-text", { attrs: { id: "password-help-block" } }, [_vm._v(`
              Any forms approved before and including this date will be deleted
            `)]), _vm._v(" "), _c("b-button", { staticClass: "mr-1 float-right", attrs: { variant: "outline-primary", disabled: !_vm.olderThan || _vm.isRunning }, on: { click: _vm.showConfigureSyncModal } }, [_c("span", [_c("font-awesome-icon", { attrs: { icon: "broom" } }), _vm._v(" Generate cleanup report")], 1)])], 1)], 1), _vm._v(" "), _vm.isRunning ? _c("div", { staticClass: "mt-2" }, [_c("b-progress", { attrs: { value: _vm.formScheduledToClean - _vm.formsLeftToClean, max: _vm.formScheduledToClean, "show-progress": "", animated: "" } }, [_c("b-progress-bar", { attrs: { value: _vm.formScheduledToClean - _vm.formsLeftToClean } }, [_vm._v(`
              ` + _vm._s(_vm.formScheduledToClean - _vm.formsLeftToClean) + "/" + _vm._s(_vm.formScheduledToClean) + `
            `)])], 1)], 1) : _vm._e()], 1) : _c("b-alert", { attrs: { show: "", variant: "warning", id: "notSupportedAlert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
        You must configure your EWA instance to use SQL server to access the Forms Management cleanup.
      `)], 1), _vm._v(" "), _c("confirm-cleanup-modal", { attrs: { olderThanDate: _vm.olderThan, "forms-to-clean": _vm.formScheduledToClean }, on: { confirm: _vm.startCleanup } })], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  AdministrationFormsCleanupComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const FormsCleanupComponent = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a5;
let AdministrationFormsManagementComponent = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "tab", null);
    __publicField(this, "tabs", [
      {
        id: "usage",
        name: "Usage",
        icon: "chart-simple",
        description: "Forms usage graphs",
        show: !0,
        component: FormsUsageComponent
      },
      {
        id: "forms",
        name: "Forms",
        icon: "scroll",
        description: "List of submitted forms",
        show: !0,
        component: FormsComponent
      },
      {
        id: "cleanup",
        name: "Cleanup",
        icon: "broom",
        description: "Clean up old approved forms",
        show: !0,
        component: FormsCleanupComponent
      }
    ]);
  }
  async mounted() {
    var hasCleanup = await userIsSuperAdmin();
    hasCleanup || (this.tabs = this.tabs.filter((y) => y.id != "cleanup"));
  }
  get activeTab() {
    return this.tab ? this.tab : (this.tabs.find((t) => t.show) || { id: null }).id;
  }
  selectTab(tabId) {
    this.tabs.find((t) => t.id === tabId && t.show) && (this.tab = tabId);
  }
}, __name(_a5, "AdministrationFormsManagementComponent"), _a5);
AdministrationFormsManagementComponent = __decorateClass([
  Component({
    components: { FormsComponent, FormsUsageComponent, FormsCleanupComponent }
  })
], AdministrationFormsManagementComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "clipboard-list" } }), _vm._v(" Forms Management")], 1)]), _vm._v(" "), _c("div", [_c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs", attrs: { id: "myTab", role: "tablist" } }, _vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item" }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab === tab.id }, attrs: { id: tab.id + "tab", "data-toggle": "tab", role: "tab", "aria-selected": "true" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(" " + _vm._s(tab.name) + `
                    `)], 1)]);
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_c("div", { staticClass: "container-fluid" }, [_vm.activeTab === "forms" ? _c("forms-component") : _vm._e(), _vm._v(" "), _vm.activeTab === "usage" ? _c("forms-usage-component") : _vm._e(), _vm._v(" "), _vm.activeTab === "cleanup" ? _c("forms-cleanup-component") : _vm._e()], 1)])])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationFormsManagementComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "dc8b2371"
);
const index = __component__.exports;
export {
  index as default
};
