var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { C as Component, V as Vue, bU as AdministrationIndexingRecyclingClient, T as Transformer, b as baseUrl, t as toastr, n as normalizeComponent, P as Prop, A as AdministrationAppsClient, bV as PageType, _, bW as AdministrationIndexingManagementClient, bX as PreProcessorStatus, bY as PreProcessingItemStageStatus, bZ as PreProcessorJobStatus, b_ as AdminBulkPreProcessorAction, W as Watch, bH as AdministrationReportingClient, b$ as AdministrationItemProcessingStatus, c0 as ProcessorItemStageStatus, c1 as ProcessorJobStatus, c2 as AdminBulkProcessorAction, c3 as UsageStatisticType, c4 as AdministrationIndexingUsageClient, M as Moment, g as v4, c5 as AdministrationIndexingCleanupClient, c6 as AdministrationIndexingBulkIndexClient, c7 as AdministrationIndexingQueueManagementClient, a0 as userHasPermission, a6 as userIsSuperAdmin } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { I as ItemHistoryModal } from "./itemHistoryModal-BQOXXlR-.js";
import { I as ItemIcon } from "./itemIcon-6OcVSOiI.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
import { f as Bar, g as Line, C as Chart, p as plugin_title, a as plugin_tooltip, b as plugin_legend, L as LineElement, c as LinearScale, d as CategoryScale, e as PointElement, B as BarElement } from "./index-CL7C-Mhu.js";
var __getOwnPropDesc$d = Object.getOwnPropertyDescriptor, __decorateClass$d = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$d(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$d"), _a;
let ConfigureRecyclingModal$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model", null);
    __publicField(this, "saving", !1);
    __publicField(this, "loading", !1);
  }
  async modalShown() {
    this.saving = !1, await this.loadConfig();
  }
  async loadConfig() {
    try {
      this.loading = !0;
      let config = await new AdministrationIndexingRecyclingClient(new Transformer(), baseUrl()).getRecyclingConfig();
      this.model = config;
    } catch (ex) {
      toastr.error("An error occured" + ex);
    } finally {
      this.loading = !1;
    }
  }
  async saveConfig() {
    if (await this.$validator.validateAll())
      try {
        this.saving = !0, await new AdministrationIndexingRecyclingClient(new Transformer(), baseUrl()).setRecyclingConfig(this.model), toastr.success("Recycling configuration has been saved!"), this.$bvModal.hide("configure-index-recycling-modal");
      } catch (ex) {
        toastr.error("An error occured" + ex);
      } finally {
        this.saving = !1;
      }
  }
}, __name(_a, "ConfigureRecyclingModal"), _a);
ConfigureRecyclingModal$1 = __decorateClass$d([
  Component({
    components: {}
  })
], ConfigureRecyclingModal$1);
var _sfc_render$d = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "md", id: "configure-index-recycling-modal", "no-close-on-backdrop": "", "cancel-variant": "", "hide-header-close": "" }, on: { shown: _vm.modalShown }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "cog" } }), _vm._v(`
             Configure Index Recycling
        `)], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary", size: "sm", disabled: _vm.saving }, on: { click: cancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "success", size: "sm", disabled: _vm.saving }, on: { click: _vm.saveConfig } }, [_vm.saving ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(` Saving
            `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save Config
            `)], 1)])];
  }, "fn") }]) }, [_vm._v(" "), _vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _vm.model ? _c("div", [_c("b-form-group", { attrs: { label: "", description: "Enables or disables storing of indexed items after they're processed" } }, [_c("b-checkbox", { attrs: { switch: "" }, model: { value: _vm.model.enabled, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "enabled", $$v);
  }, "callback"), expression: "model.enabled" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Enable Recycling")])])], 1), _vm._v(" "), _c("div", [_c("label", [_c("b", [_vm._v("Days to keep files")])]), _vm._v(" "), _c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required|numeric|max_value:90|min_value:1", expression: "'required|numeric|max_value:90|min_value:1'" }], attrs: { id: "daysToKeepInput", type: "number", min: "1", max: "90", name: "daysToKeep", disabled: !_vm.model.enabled }, model: { value: _vm.model.daysToKeep, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "daysToKeep", $$v);
  }, "callback"), expression: "model.daysToKeep" } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted" }, [_vm._v("Number of days to keep indexed files.")]), _vm._v(" "), _vm.errors.first("daysToKeep") ? _c("p", { staticClass: "text-danger" }, [_vm._v("Number of days to keep must be between 1 and 90")]) : _vm._e()], 1)], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$d = [], __component__$d = /* @__PURE__ */ normalizeComponent(
  ConfigureRecyclingModal$1,
  _sfc_render$d,
  _sfc_staticRenderFns$d,
  !1,
  null,
  null
);
const ConfigureRecyclingModal = __component__$d.exports;
var __defProp$6 = Object.defineProperty, __getOwnPropDesc$c = Object.getOwnPropertyDescriptor, __decorateClass$c = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$c(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$6(target, key, result), result;
}, "__decorateClass$c"), _a2;
let ConfirmRestoreItemModal$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "itemName");
  }
  confirm() {
    this.$bvModal.hide("confirm-restore-modal"), this.$emit("confirm");
  }
  get modalTitle() {
    return "Restore " + this.itemName + "?";
  }
}, __name(_a2, "ConfirmRestoreItemModal"), _a2);
__decorateClass$c([
  Prop({ required: !0 })
], ConfirmRestoreItemModal$1.prototype, "itemName", 2);
ConfirmRestoreItemModal$1 = __decorateClass$c([
  Component({})
], ConfirmRestoreItemModal$1);
var _sfc_render$c = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "confirm-restore-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
      Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "primary" }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Confirm
    `)], 1)];
  }, "fn") }]) }, [_c("div", [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`  Are you sure you want to restore the selected item(s)?
        `), _c("ul", { staticClass: "mb-0" }, [_c("li", [_vm._v("This will reactivate the item in it's original queue. ")])])], 1)], 1)]);
}, "render"), _sfc_staticRenderFns$c = [], __component__$c = /* @__PURE__ */ normalizeComponent(
  ConfirmRestoreItemModal$1,
  _sfc_render$c,
  _sfc_staticRenderFns$c,
  !1,
  null,
  null
);
const ConfirmRestoreModal = __component__$c.exports;
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$b = Object.getOwnPropertyDescriptor, __decorateClass$b = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$b(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$b"), _a3;
let ConfirmRestoreItemModal = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "itemName");
  }
  confirm() {
    this.$bvModal.hide("confirm-delete-modal"), this.$emit("confirm");
  }
  get modalTitle() {
    return "Delete " + this.itemName + "?";
  }
}, __name(_a3, "ConfirmRestoreItemModal"), _a3);
__decorateClass$b([
  Prop({ required: !0 })
], ConfirmRestoreItemModal.prototype, "itemName", 2);
ConfirmRestoreItemModal = __decorateClass$b([
  Component({})
], ConfirmRestoreItemModal);
var _sfc_render$b = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "confirm-delete-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
      Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "danger" }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Confirm
    `)], 1)];
  }, "fn") }]) }, [_c("div", [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`  Are you sure you want to delete the selected item?
        `), _c("ul", { staticClass: "mb-0" }, [_c("li", [_vm._v("This will removed permanently from the system. ")]), _vm._v(" "), _c("li", [_vm._v("This action cannot be reversed. ")])])], 1)], 1)]);
}, "render"), _sfc_staticRenderFns$b = [], __component__$b = /* @__PURE__ */ normalizeComponent(
  ConfirmRestoreItemModal,
  _sfc_render$b,
  _sfc_staticRenderFns$b,
  !1,
  null,
  null
);
const ConfirmDeleteModal = __component__$b.exports;
var __getOwnPropDesc$a = Object.getOwnPropertyDescriptor, __decorateClass$a = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$a(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$a"), _a4;
let AdministrationIndexRecyclingListComponent = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model", null);
    __publicField(this, "loading", !0);
    __publicField(this, "page", 1);
    __publicField(this, "pageSize", 50);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "confirmRestoreName", null);
    __publicField(this, "confirmDeleteName", null);
    __publicField(this, "itemToRestore", null);
    __publicField(this, "itemToDelete", null);
    __publicField(this, "indexingPages", []);
    __publicField(this, "filterModel", { pageId: null, sort: {} });
    __publicField(this, "selectedItemIds", []);
    __publicField(this, "searchItemsDebounce", _.debounce(function() {
      this.getItems(!0);
    }, 500));
    __publicField(this, "itemIdHistoryToShow", "");
    __publicField(this, "itemNameHistoryToShow", "");
    __publicField(this, "showItemHistoryModal", !1);
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.getItems(!1), 3e4), await this.getIndexingPages(), await this.getItems(!0);
  }
  get pageNumber() {
    return this.page;
  }
  set pageNumber(value) {
    this.page = value, this.getItems(!0);
  }
  get sort() {
    let sort = this.filterModel.sort;
    return sort || null;
  }
  set sort(sort) {
    this.filterModel.sort = sort, this.getItems(!0);
  }
  isItemSelected(item) {
    var _a15;
    return (_a15 = this.selectedItemIds) == null ? void 0 : _a15.includes(item.itemId);
  }
  get selectedItems() {
    return this.selectedItemIds;
  }
  set selectedItems(value) {
    this.selectedItemIds = value;
  }
  get partiallySelectedItems() {
    var _a15;
    return ((_a15 = this.selectedItemIds) == null ? void 0 : _a15.length) > 0 && this.selectedItemIds.length < this.model.results.length;
  }
  setItemToRestore(itemToRestore) {
    this.itemToRestore = itemToRestore, this.confirmRestoreName = itemToRestore.itemName;
  }
  setItemToDelete(itemToDelete) {
    this.itemToDelete = itemToDelete, this.confirmDeleteName = itemToDelete.itemName;
  }
  toggleItemSelected(item) {
    var _a15;
    ((_a15 = this.selectedItemIds) == null ? void 0 : _a15.find((x) => x == item.itemId)) ? this.selectedItemIds = this.selectedItemIds.filter((x) => x != item.itemId) : this.selectedItemIds = this.selectedItemIds.concat([item.itemId]);
  }
  toggleAllItemsSelected() {
    var _a15;
    ((_a15 = this.selectedItemIds) == null ? void 0 : _a15.length) == 0 ? this.selectedItemIds = this.model.results.map((x) => x.itemId) : this.selectedItemIds = [];
  }
  cleanSelected() {
    this.selectedItemIds.length && (this.selectedItemIds = this.selectedItemIds.filter((y) => this.model.results.some((x) => x.itemId == y)));
  }
  async getIndexingPages() {
    let pages;
    try {
      pages = await new AdministrationAppsClient(new Transformer(), baseUrl()).getFieldedPages();
    } catch (e) {
      toastr.error(e, "Failed to get pages");
    }
    pages = pages.filter((p) => p.type === PageType.RIA), this.indexingPages = pages;
  }
  get pageOptions() {
    let pageOptions = [{ value: null, text: "All" }];
    return this.indexingPages.forEach((page) => {
      pageOptions.push({ value: page.id, text: page.name });
    }), pageOptions;
  }
  async getItems(setLoading) {
    this.loading = setLoading;
    try {
      let managementClient = new AdministrationIndexingRecyclingClient(new Transformer(), baseUrl());
      this.model = await managementClient.getRecyclingItems(this.filterModel, this.pageSize, this.page), this.cleanSelected();
    } catch (ex) {
      toastr.error(ex, "An error occurred when retrieving the recycled items");
    } finally {
      this.loading = !1;
    }
  }
  showConfigureRecyclingModal() {
    this.$bvModal.show("configure-index-recycling-modal");
  }
  async deleteItem() {
    if (this.itemToDelete) {
      this.loading = !0;
      try {
        let result = await new AdministrationIndexingRecyclingClient(new Transformer(), baseUrl()).deleteRecyclingItem(this.itemToDelete.itemId, this.itemToDelete.fileId);
        toastr.success("The item has been deleted");
      } catch (ex) {
        toastr.error(ex, "An error occurred attempting to delete an item");
      } finally {
        this.confirmDeleteName = null, this.itemToDelete = null, this.getItems(!0);
      }
    }
  }
  async downloadItem(itemToDownload) {
    this.loading = !0;
    try {
      let result = await new AdministrationIndexingRecyclingClient(new Transformer(), baseUrl()).downloadRecyclingItem(itemToDownload.itemId, itemToDownload.fileId), url = window.URL.createObjectURL(new Blob([result.data])), link = document.createElement("a");
      link.href = url, link.setAttribute("download", itemToDownload.itemName), document.body.appendChild(link), link.click();
    } catch (ex) {
      toastr.error(ex, "An error occurred attempting to download an item");
    } finally {
      this.loading = !1;
    }
  }
  async downloadItemMetadata(itemToDownload) {
    this.loading = !0;
    try {
      let result = await new AdministrationIndexingRecyclingClient(new Transformer(), baseUrl()).downloadRecyclingItemMetadata(itemToDownload.itemId, itemToDownload.fileId), url = window.URL.createObjectURL(new Blob([result.data])), link = document.createElement("a");
      link.href = url, link.setAttribute("download", result.fileName), document.body.appendChild(link), link.click();
    } catch (ex) {
      toastr.error(ex, "An error occurred attempting to download an item's metadata");
    } finally {
      this.loading = !1;
    }
  }
  async restoreItem() {
    if (this.itemToRestore == null && this.selectedItemIds.length) {
      await this.restoreItems();
      return;
    }
    if (this.itemToRestore) {
      this.loading = !0;
      try {
        let result = await new AdministrationIndexingRecyclingClient(new Transformer(), baseUrl()).restoreItem(this.itemToRestore.itemId, this.itemToRestore.fileId);
        toastr.success("The item has been restored");
      } catch (ex) {
        toastr.error(ex, "An error occurred attempting to restore an item");
      } finally {
        this.confirmRestoreName = null, this.itemToRestore = null, this.selectedItemIds = [], this.getItems(!0);
      }
    }
  }
  async restoreItems() {
    this.loading = !0;
    try {
      let result = await new AdministrationIndexingRecyclingClient(new Transformer(), baseUrl()).restoreItems(this.selectedItemIds);
      toastr.success("The items have been restored");
    } catch (ex) {
      toastr.error(ex, "An error occurred attempting to restore the items");
    } finally {
      this.confirmRestoreName = null, this.itemToRestore = null, this.selectedItemIds = [], this.getItems(!0);
    }
  }
  get searchFilter() {
    return this.filterModel.search;
  }
  set searchFilter(value) {
    this.filterModel.search = value, this.searchItemsDebounce();
  }
  get pageIdFilter() {
    return this.filterModel.pageId;
  }
  set pageIdFilter(value) {
    this.filterModel.pageId = value, this.getItems(!0);
  }
  get totalPages() {
    if (this.model)
      return Math.ceil(this.model.count / this.pageSize);
  }
  setHistoryToShow(item) {
    this.itemIdHistoryToShow = item.itemId, this.itemNameHistoryToShow = item.itemName, this.showItemHistoryModal = !0;
  }
  closeHistoryModal() {
    this.itemIdHistoryToShow = null, this.itemNameHistoryToShow = null, this.showItemHistoryModal = !1;
  }
  get tableFields() {
    return [
      { key: "select", label: "", sortable: !1 },
      { key: "image", label: "", sortable: !1 },
      { key: "itemName", label: "Name", sortable: !1 },
      { key: "pageName", label: "Page", sortable: !1 },
      { key: "queueName", lable: "Queue", sortable: !1 },
      { key: "created", label: "Created", sortable: !1 },
      { key: "deletedOn", label: "Indexed On", sortable: !1 },
      { key: "actions", label: "", sortable: !1 }
    ];
  }
}, __name(_a4, "AdministrationIndexRecyclingListComponent"), _a4);
AdministrationIndexRecyclingListComponent = __decorateClass$a([
  Component({ components: {
    DateDisplay,
    PaginationControls,
    ConfirmRestoreModal,
    ItemHistoryModal,
    ConfigureRecyclingModal,
    ItemThumbnail: ItemIcon,
    SortableHeaderLink,
    ConfirmDeleteModal
  } })
], AdministrationIndexRecyclingListComponent);
var _sfc_render$a = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "recycle" } }), _vm._v(` Recycled items
            `), _c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.getItems(!0);
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)]), _vm._v(" "), _c("b-button", { staticClass: "float-right mr-1", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: _vm.showConfigureRecyclingModal } }, [_c("span", [_c("font-awesome-icon", { attrs: { icon: "cog" } }), _vm._v(" Configure")], 1)]), _vm._v(" "), _vm.selectedItemIds.length ? _c("b-button", { directives: [{ name: "b-modal", rawName: "v-b-modal", value: "confirm-restore-modal", expression: "'confirm-restore-modal'" }], staticClass: "float-right mr-1", attrs: { variant: "primary", size: "sm", title: "Restore Items" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.confirmRestoreName = _vm.selectedItemIds.length + " items";
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash-undo" } }), _vm._v(" Restore " + _vm._s(_vm.selectedItemIds.length) + ` items
            `)], 1) : _vm._e()], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-form-group", { staticClass: "mb-0" }, [_c("b-input-group", { attrs: { size: "sm" } }, [_c("b-form-input", { staticClass: "noAppendedBorder", attrs: { id: "filter-input", type: "search", placeholder: "Filter...", autocomplete: "off" }, model: { value: _vm.searchFilter, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.searchFilter = $$v;
  }, "callback"), expression: "searchFilter" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-input-group-text", { staticClass: "onlyBorderLeft" }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)], 1)], 1)], 1), _vm._v(" "), _vm.model ? _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.model.results, striped: "", busy: _vm.loading, "show-empty": "", emptyText: "No recycled items could be found" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "head(itemName)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "itemName", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(created)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "created", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(deletedOn)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "deletedOn", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(select)", fn: /* @__PURE__ */ __name(function(row) {
    var _a15;
    return [_c("b-checkbox", { attrs: { indeterminate: _vm.partiallySelectedItems, checked: !!((_a15 = _vm.selectedItems) != null && _a15.length) }, on: { change: _vm.toggleAllItemsSelected } })];
  }, "fn") }, { key: "head(pageName)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_vm._v(`
                    ` + _vm._s(row.label) + ` 
                    `), _c("b-form-select", { attrs: { size: "sm", options: _vm.pageOptions }, model: { value: _vm.pageIdFilter, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.pageIdFilter = $$v;
    }, "callback"), expression: "pageIdFilter" } })], 1)])];
  }, "fn") }, { key: "cell(select)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "d-inline-flex" }, [_c("b-checkbox", { attrs: { checked: _vm.isItemSelected(row.item), size: "sm" }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleItemSelected(row.item);
    }, "change") } })], 1)];
  }, "fn") }, { key: "cell(image)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("item-thumbnail", { key: row.item.itemId, attrs: { value: { id: row.item.itemId, type: "image" }, lazy: "true", size: "i" } })];
  }, "fn") }, { key: "cell(itemName)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("span", { staticClass: "align-middle" }, [_vm._v(`
                ` + _vm._s(row.item.itemName) + `
                `), _c("span", { staticClass: "float-right mb-0" }, [_c("b-button", { attrs: { variant: "link", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setHistoryToShow(row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "history" } })], 1)], 1)])];
  }, "fn") }, { key: "cell(pageId)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
                ` + _vm._s(row.item.pageId) + `
            `)];
  }, "fn") }, { key: "cell(queueName)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
                ` + _vm._s(row.item.queueName) + `
            `)];
  }, "fn") }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.created ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.created } }) : _vm._e()];
  }, "fn") }, { key: "cell(deletedOn)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.deletedOn ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.deletedOn } }) : _vm._e()];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-dropdown", { attrs: { "no-flip": "", variant: "primary", "no-caret": "", right: "", disabled: _vm.selectedItemIds.length > 0, id: row.item.itemId + "-DropDown" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { directives: [{ name: "b-modal", rawName: "v-b-modal", value: "confirm-restore-modal", expression: "'confirm-restore-modal'" }], attrs: { variant: "success" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setItemToRestore(row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash-undo" } }), _vm._v(` Restore
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.downloadItem(row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "download" } }), _vm._v(` Download
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.downloadItemMetadata(row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "download" } }), _vm._v(` Download Metadata
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { directives: [{ name: "b-modal", rawName: "v-b-modal", value: "confirm-delete-modal", expression: "'confirm-delete-modal'" }], attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setItemToDelete(row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
                    `)], 1)], 1)];
  }, "fn") }], null, !1, 3080653147) }) : _vm._e(), _vm._v(" "), _vm.model ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } }) : _vm._e()], 1), _vm._v(" "), _c("confirm-restore-modal", { attrs: { itemName: _vm.confirmRestoreName }, on: { confirm: _vm.restoreItem } }), _vm._v(" "), _c("confirm-delete-modal", { attrs: { itemName: _vm.confirmDeleteName }, on: { confirm: _vm.deleteItem } }), _vm._v(" "), _c("configure-recycling-modal"), _vm._v(" "), _c("item-history-modal", { attrs: { item: { id: _vm.itemIdHistoryToShow, name: _vm.itemNameHistoryToShow }, shouldShow: _vm.showItemHistoryModal }, on: { close: _vm.closeHistoryModal } })], 1);
}, "render"), _sfc_staticRenderFns$a = [], __component__$a = /* @__PURE__ */ normalizeComponent(
  AdministrationIndexRecyclingListComponent,
  _sfc_render$a,
  _sfc_staticRenderFns$a,
  !1,
  null,
  "5d52ed4b"
);
const RecycledItemsComponent = __component__$a.exports;
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$9 = Object.getOwnPropertyDescriptor, __decorateClass$9 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$9(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$9"), _a5;
let AdministrationIndexingPreProcessorListComponent = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "queueId");
    __publicField(this, "preProcessorId");
    __publicField(this, "model", null);
    __publicField(this, "filterModel", { filterStatus: null, sort: {} });
    __publicField(this, "tableItems", []);
    __publicField(this, "loading", !0);
    __publicField(this, "page", 1);
    __publicField(this, "pageSize", 50);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "rowDetailIds", []);
    __publicField(this, "filteredPageId", null);
    __publicField(this, "indexingPages", []);
    __publicField(this, "itemIdHistoryToShow", "");
    __publicField(this, "itemNameHistoryToShow", "");
    __publicField(this, "showItemHistoryModal", !1);
    __publicField(this, "selectedProcessorIds", []);
  }
  mounted() {
    this.reloadTimer = setInterval(() => {
      this.selectedProcessorIds.length > 0 || this.getPreProcessingInfo(!1);
    }, 3e4), this.getPreProcessingInfo(!0), this.getIndexingPages();
  }
  async pageChanged() {
    await this.getPreProcessingInfo(!0);
  }
  async getPreProcessingInfo(setLoading) {
    this.loading = setLoading;
    let managementClient = new AdministrationIndexingManagementClient(new Transformer(), baseUrl());
    this.model = await managementClient.getPreProcessingSummary(this.filterModel, this.page, this.pageSize), this.cleanSelected(), this.tableItems = this.model.items.map((t) => ({
      id: t.id,
      item: t.item,
      name: t.name,
      finished: t.finished,
      started: t.started,
      status: t.status,
      stages: t.stages,
      _showDetails: this.rowDetailIds.includes(t.id)
    })), this.loading = !1;
  }
  setHistoryToShow(item) {
    this.itemIdHistoryToShow = item.item.id, this.itemNameHistoryToShow = item.name, this.showItemHistoryModal = !0;
  }
  async getIndexingPages() {
    let pages;
    try {
      pages = await new AdministrationAppsClient(new Transformer(), baseUrl()).getFieldedPages();
    } catch (e) {
      toastr.error(e, "Failed to get pages");
    }
    pages = pages.filter((p) => p.type === PageType.RIA), this.indexingPages = pages;
  }
  get pageOptions() {
    let pageOptions = [{ value: null, text: "All" }];
    return this.indexingPages.forEach((page) => {
      pageOptions.push({ value: page.id, text: page.name });
    }), pageOptions;
  }
  get filterOptions() {
    return [
      { value: null, text: "All" },
      { value: PreProcessorStatus.Pending, text: "Pending" },
      { value: PreProcessorStatus.Running, text: "Running" },
      { value: PreProcessorStatus.Successful, text: "Successful" },
      { value: PreProcessorStatus.Cancelled, text: "Cancelled" },
      { value: PreProcessorStatus.Skipped, text: "Skipped" },
      { value: PreProcessorStatus.Failed, text: "Failed" }
    ];
  }
  getQueueUrl(queueId) {
    return new URL(baseUrl() + "/app/indexing/queues/" + queueId + "/list").href;
  }
  getDetailUrl(itemId) {
    return new URL(baseUrl() + "/app/indexing/items/" + itemId).href;
  }
  async downloadJobLog(job) {
    let logFile = await new AdministrationIndexingManagementClient(new Transformer(), baseUrl()).preProcessingJobDetails(job.id), blob = logFile.data, downloadUrl = window.URL.createObjectURL(blob), anchor = document.createElement("a");
    anchor.href = downloadUrl, anchor.download = logFile.fileName, document.body.appendChild(anchor), anchor.click(), anchor.remove();
  }
  toggleRowDetails(row) {
    row.toggleDetails(), this.rowDetailIds.includes(row.item.id) ? this.rowDetailIds = this.rowDetailIds.filter(function(i) {
      return i !== row.item.id;
    }) : this.rowDetailIds.push(row.item.id);
  }
  getStageName(stage) {
    return stage.name ? stage.name : "Pre-Processor not found";
  }
  getPreProcessorStatusClass(processor) {
    let buttonClass = "";
    switch (processor.status) {
      case PreProcessorStatus.Pending:
        buttonClass += "warning";
        break;
      case PreProcessorStatus.Running:
        buttonClass += "primary";
        break;
      case PreProcessorStatus.Successful:
      case PreProcessorStatus.Skipped:
      case PreProcessorStatus.Split:
        buttonClass += "success";
        break;
      case PreProcessorStatus.Failed:
        buttonClass += "danger";
        break;
      case PreProcessorStatus.Queued:
      case PreProcessorStatus.Cancelled:
        buttonClass += "secondary";
        break;
    }
    return buttonClass;
  }
  getStatusIcon(processor) {
    switch (processor.status) {
      case PreProcessorStatus.Pending:
      case PreProcessorStatus.Queued:
        return "clock";
      case PreProcessorStatus.Running:
        return "circle-ellipsis";
      case PreProcessorStatus.Successful:
        return "check-circle";
      case PreProcessorStatus.Split:
        return "clone";
      case PreProcessorStatus.Cancelled:
        return "ban";
      case PreProcessorStatus.Skipped:
        return "circle-chevron-right";
      case PreProcessorStatus.Failed:
        return "times-circle";
      default:
        return "question";
    }
  }
  getStatusTitle(processor) {
    switch (processor.status) {
      case PreProcessorStatus.Pending:
        return "Waiting to start";
      case PreProcessorStatus.Queued:
        return "Queued to run";
      default:
        return this.$options.filters.capitaliseFirstLetter(processor.status ? processor.status : "Unknown");
    }
  }
  getStageIcon(stage) {
    switch (stage.status) {
      case PreProcessingItemStageStatus.Pending:
      case PreProcessingItemStageStatus.Queued:
        return "clock";
      case PreProcessingItemStageStatus.Running:
        return "circle-ellipsis";
      case PreProcessingItemStageStatus.Success:
        return "check-circle";
      case PreProcessingItemStageStatus.Skipped:
        return "circle-chevron-right";
      case PreProcessingItemStageStatus.Cancelled:
        return "ban";
      case PreProcessingItemStageStatus.Failed:
        return "times-circle";
      case PreProcessingItemStageStatus.Split:
        return "clone";
    }
  }
  getJobIcon(job) {
    switch (job.status) {
      case PreProcessorJobStatus.Success:
        return "check-circle";
      case PreProcessorJobStatus.Failed:
        return "times-circle";
      case PreProcessorJobStatus.Skipped:
        return "circle-chevron-right";
      case PreProcessorJobStatus.Cancelled:
        return "ban";
      case PreProcessorJobStatus.Running:
        return "circle-ellipsis";
      default:
        return "";
    }
  }
  getStageStatusTitle(processorStage) {
    switch (processorStage.status) {
      case PreProcessingItemStageStatus.Pending:
        return "Waiting to start";
      case PreProcessingItemStageStatus.Queued:
        return "Queued to run";
      default:
        return this.$options.filters.capitaliseFirstLetter(processorStage.status ? processorStage.status : "Unknown");
    }
  }
  getStageClass(stage) {
    let stageButtonClass = "";
    switch (stage.status) {
      case PreProcessingItemStageStatus.Pending:
        stageButtonClass += "warning";
        break;
      case PreProcessingItemStageStatus.Running:
        stageButtonClass += "primary";
        break;
      case PreProcessingItemStageStatus.Success:
        stageButtonClass += "success";
        break;
      case PreProcessingItemStageStatus.Queued:
      case PreProcessingItemStageStatus.Cancelled:
      case PreProcessingItemStageStatus.Skipped:
        stageButtonClass += "secondary";
        break;
      case PreProcessingItemStageStatus.Failed:
        stageButtonClass += "danger";
        break;
      case PreProcessingItemStageStatus.Split:
        stageButtonClass += "success";
        break;
    }
    return stageButtonClass;
  }
  getJobTextClass(job) {
    switch (job.status) {
      case PreProcessorJobStatus.Success:
        return "success";
      case PreProcessorJobStatus.Failed:
        return "danger";
      case PreProcessorJobStatus.Skipped:
      case PreProcessorJobStatus.Cancelled:
        return "secondary";
      case PreProcessorJobStatus.Running:
        return "primary";
      default:
        return "";
    }
  }
  async cancelPreProcessor(processorId) {
    let managementClient = new AdministrationIndexingManagementClient(new Transformer(), baseUrl());
    try {
      await managementClient.cancelPreProcessor(processorId), toastr.info("The pre-processor has been cancelled");
    } catch (ex) {
      toastr.error(ex, "An error occurred while cancelling the pre-processor");
    }
  }
  async retryPreProcessor(processorId) {
    let managementClient = new AdministrationIndexingManagementClient(new Transformer(), baseUrl());
    try {
      await managementClient.retryPreProcessor(processorId), toastr.info("The pre-processor has been marked to retry");
    } catch (ex) {
      toastr.error(ex, "An error occurred while retrying the pre-processor");
    }
  }
  async skipPreProcessor(processorId) {
    let managementClient = new AdministrationIndexingManagementClient(new Transformer(), baseUrl());
    try {
      await managementClient.skipPreProcessor(processorId), toastr.info("The pre-processor has been skipped");
    } catch (ex) {
      toastr.error(ex, "An error occurred while skipping the pre-processor");
    }
  }
  setFilteredPageIds(pageId) {
    pageId ? this.filterModel.pageIds = [pageId] : this.filterModel.pageIds = null, this.getPreProcessingInfo(!0);
  }
  get sort() {
    let sort = this.filterModel.sort;
    return sort || null;
  }
  set sort(sort) {
    this.filterModel.sort = sort, this.getPreProcessingInfo(!0);
  }
  setHistoryToShowsetHistoryToShow(item) {
    this.itemIdHistoryToShow = item.item.id, this.itemNameHistoryToShow = item.name, this.showItemHistoryModal = !0;
  }
  closeHistoryModal() {
    this.itemIdHistoryToShow = null, this.itemNameHistoryToShow = null, this.showItemHistoryModal = !1;
  }
  isProcessorSelected(processorId) {
    var _a15;
    return (_a15 = this.selectedProcessorIds) == null ? void 0 : _a15.includes(processorId);
  }
  get selectedProcessors() {
    return this.selectedProcessorIds;
  }
  set selectedProcessors(value) {
    this.selectedProcessorIds = value;
  }
  get partiallySelectedProcessors() {
    var _a15;
    return ((_a15 = this.selectedProcessorIds) == null ? void 0 : _a15.length) > 0 && this.selectedProcessorIds.length < this.model.items.length;
  }
  toggleProcessorSelected(processorId) {
    var _a15;
    ((_a15 = this.selectedProcessorIds) == null ? void 0 : _a15.find((x) => x == processorId)) ? this.selectedProcessorIds = this.selectedProcessorIds.filter((x) => x != processorId) : this.selectedProcessorIds = this.selectedProcessorIds.concat([processorId]);
  }
  toggleAllProcessorsSelected() {
    var _a15;
    ((_a15 = this.selectedProcessorIds) == null ? void 0 : _a15.length) == 0 ? this.selectedProcessorIds = this.model.items.map((x) => x.id) : this.selectedProcessorIds = [];
  }
  async bulkActionProcessors(action) {
    let bulkAction = AdminBulkPreProcessorAction.Cancel;
    switch (action) {
      case "cancel":
        bulkAction = AdminBulkPreProcessorAction.Cancel;
        break;
      case "skip":
        bulkAction = AdminBulkPreProcessorAction.Skip;
        break;
      case "retry":
        bulkAction = AdminBulkPreProcessorAction.Retry;
        break;
    }
    let processingClient = new AdministrationIndexingManagementClient(new Transformer(), baseUrl());
    try {
      this.loading = !0, await processingClient.bulkActionPreProcessors({ processorIds: this.selectedProcessorIds, action: bulkAction }), toastr.info("The selected pre-processors have been actioned."), this.cleanSelected();
    } catch (ex) {
      toastr.error(ex, "An error occurred while actioning the pre-processors");
    } finally {
      this.loading = !1;
    }
  }
  checkProcessorsCanAction(action) {
    switch (action) {
      case "cancel":
        return this.model.items.filter((y) => this.selectedProcessorIds.indexOf(y.id) > -1).every((y) => y.status == "running" || y.status == "queued");
      case "retry":
        return this.model.items.filter((y) => this.selectedProcessorIds.indexOf(y.id) > -1).every((y) => y.status == "cancelled" || y.status == "failed");
      case "skip":
        return this.model.items.filter((y) => this.selectedProcessorIds.indexOf(y.id) > -1).every((y) => y.status == "cancelled" || y.status == "failed");
    }
  }
  cleanSelected() {
    this.selectedProcessorIds.length && (this.selectedProcessorIds = this.selectedProcessorIds.filter((y) => this.model.items.some((x) => x.processorId == y)));
  }
  get tableFields() {
    return [
      { key: "select", label: "", sortable: !1 },
      { key: "item", label: "Item", sortable: !1, thClass: "align-middle" },
      { key: "page", sortable: !1 },
      { key: "started", label: "Started", sortable: !1, thClass: "align-middle" },
      { key: "status", label: "Status", sortable: !1, thClass: "align-middle" },
      { key: "completed", label: "Completed", sortable: !1, thClass: "align-middle" },
      { key: "actions", label: "", sortable: !1 }
    ];
  }
}, __name(_a5, "AdministrationIndexingPreProcessorListComponent"), _a5);
__decorateClass$9([
  Prop()
], AdministrationIndexingPreProcessorListComponent.prototype, "queueId", 2);
__decorateClass$9([
  Prop()
], AdministrationIndexingPreProcessorListComponent.prototype, "preProcessorId", 2);
__decorateClass$9([
  Watch("page")
], AdministrationIndexingPreProcessorListComponent.prototype, "pageChanged", 1);
AdministrationIndexingPreProcessorListComponent = __decorateClass$9([
  Component({ components: { DateDisplay, PaginationControls, SortableHeaderLink, ItemHistoryModal } })
], AdministrationIndexingPreProcessorListComponent);
var _sfc_render$9 = /* @__PURE__ */ __name(function() {
  var _a15;
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "sign-in" } }), _vm._v(` Pre-Processing
        `), _c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.getPreProcessingInfo(!0);
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)])], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.tableItems, striped: "", busy: _vm.loading, "details-td-class": "pt-0 pb-2", "show-empty": "", emptyText: "No pre-processing items could be found" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "head(page)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_vm._v(`
            ` + _vm._s(row.label) + ` 
            `), _c("b-form-select", { attrs: { size: "sm", options: _vm.pageOptions }, on: { change: _vm.setFilteredPageIds }, model: { value: _vm.filteredPageId, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.filteredPageId = $$v;
    }, "callback"), expression: "filteredPageId" } })], 1)])];
  }, "fn") }, { key: "head(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_c("sortable-header-link", { staticClass: "mb-1", attrs: { id: "status", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } }), _vm._v(`
                     
                    `), _c("b-form-select", { attrs: { size: "sm", options: _vm.filterOptions }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.getPreProcessingInfo(!0);
    }, "change") }, model: { value: _vm.filterModel.filterStatus, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(_vm.filterModel, "filterStatus", $$v);
    }, "callback"), expression: "filterModel.filterStatus" } })], 1)])];
  }, "fn") }, { key: "cell(page)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
        ` + _vm._s(row.item.item.page ? row.item.item.page.name : "Unknown Page") + " - "), _c("small", [_vm._v(_vm._s(row.item.item.queue ? row.item.item.queue.name : "Unknown Queue"))])];
  }, "fn") }, { key: "head(item)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "item", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(started)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "started", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(completed)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "completed", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(select)", fn: /* @__PURE__ */ __name(function(row) {
    var _a16;
    return [_c("b-checkbox", { attrs: { indeterminate: _vm.partiallySelectedProcessors, checked: !!((_a16 = _vm.selectedProcessorIds) != null && _a16.length) }, on: { change: _vm.toggleAllProcessorsSelected } })];
  }, "fn") }, { key: "head(actions)", fn: /* @__PURE__ */ __name(function(row) {
    var _a16;
    return [(_a16 = _vm.selectedProcessorIds) != null && _a16.length ? _c("div", [_c("b-dropdown", { staticClass: "float-right", attrs: { variant: "primary", size: "sm", id: "bulkActionPreProcessors", disabled: _vm.loading, "no-caret": "", right: "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("cancel") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("cancel");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "ban" } }), _vm._v(" Cancel Processors (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("retry") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("retry");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Retry Processors (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("skip") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("skip");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "forward" } }), _vm._v(" Skip Processors (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1)], 1)], 1) : _vm._e()];
  }, "fn") }, { key: "cell(select)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "d-inline-flex" }, [_c("b-checkbox", { attrs: { checked: _vm.isProcessorSelected(row.item.id), size: "sm" }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleProcessorSelected(row.item.id);
    }, "change") } })], 1)];
  }, "fn") }, { key: "cell(started)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.started ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.started } }) : _vm._e()];
  }, "fn") }, { key: "cell(item)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.item.status == "enqueued" ? _c("span", [_c("a", { attrs: { href: _vm.getDetailUrl(row.item.item.id) } }, [_vm._v(_vm._s(row.item.name))])]) : _c("span", [_vm._v(_vm._s(row.item.name))]), _vm._v(" "), _c("span", [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "link", size: "sm", title: "View item history" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setHistoryToShow(row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "history" } })], 1)], 1)];
  }, "fn") }, { key: "cell(completed)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.finished ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.finished } }) : _vm._e(), _vm._v(" "), row.item.finished ? _c("span", { staticClass: "small text-muted" }, [_vm._v("(took " + _vm._s(_vm.$options.filters.datetimeDifference(row.item.started, row.item.finished)) + ")")]) : _vm._e()];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.stages ? _c("span", { staticClass: "float-right" }, [row.item.status == "running" || row.item.status == "queued" ? _c("b-button", { attrs: { size: "sm", variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.cancelPreProcessor(row.item.id);
    }, "click") } }, [_vm._v(`
                 Cancel Pre-Processor
               `)]) : row.item.status == "cancelled" || row.item.status == "failed" ? _c("b-dropdown", { attrs: { "no-flip": "", size: "sm", variant: "outline-primary" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(` Actions
                  `)];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.retryPreProcessor(row.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Retry")], 1), _vm._v(" "), _vm.model.canManage ? _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.skipPreProcessor(row.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "forward" } }), _vm._v(" Skip")], 1) : _vm._e()], 1) : _vm._e()], 1) : _vm._e()];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "text-nowrap" }, [_c("b-badge", { attrs: { variant: _vm.getPreProcessorStatusClass(row.item), pill: "", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.getStatusIcon(row.item) } }), _vm._v(`
            ` + _vm._s(_vm.getStatusTitle(row.item)) + `
          `)], 1), _vm._v(" "), _vm._l(row.item.stages, function(stage) {
      return _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { title: _vm.getStageName(stage) + " - " + _vm.getStageStatusTitle(stage) }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.toggleRowDetails(row);
      }, "click") } }, [_c("font-awesome-icon", { class: "text-" + _vm.getStageClass(stage), attrs: { icon: _vm.getStageIcon(stage), transform: stage.status === "skipped" ? "shrink-5" : "", mask: stage.status === "skipped" ? "fa-solid fa-circle" : "" } })], 1);
    }), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { variant: "link", size: "sm", title: "Show stage details" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: row.detailsShowing ? "caret-down" : "caret-right" } })], 1)], 2)];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-card", { attrs: { "body-class": "p-3 mx-auto" } }, [_c("b-row", { staticClass: "py-0" }, [_c("b-col", _vm._l(row.item.stages, function(stage, index2) {
      return _c("span", { staticClass: "center" }, [_c("b-dropdown", { class: { "mx-1": index2 + 1 != row.item.stages.length }, attrs: { "no-flip": "", size: "sm", right: "", variant: "outline-" + _vm.getStageClass(stage) }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
        return [_c("font-awesome-icon", { attrs: { icon: _vm.getStageIcon(stage) } }), _vm._v(`
                    ` + _vm._s(_vm.getStageName(stage)) + `
                  `)];
      }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _vm._l(stage.jobs, function(job, jobIndex) {
        return _c("b-dropdown-item", { key: jobIndex, attrs: { pill: "" }, on: { click: /* @__PURE__ */ __name(function($event) {
          return _vm.downloadJobLog(job);
        }, "click") } }, [_c("font-awesome-icon", { class: "text-" + _vm.getJobTextClass(job), attrs: { icon: _vm.getJobIcon(job) } }), _vm._v(`
                    Download Log file #` + _vm._s(jobIndex + 1) + `
                  `)], 1);
      })], 2), _vm._v(" "), index2 + 1 != row.item.stages.length ? _c("font-awesome-icon", { staticClass: "align-middle", attrs: { size: "xs", icon: "chevron-right" } }) : _vm._e(), _vm._v(` 
              `)], 1);
    }), 0)], 1)], 1)];
  }, "fn") }]) }), _vm._v(" "), _vm.model ? _c("pagination-controls", { attrs: { count: ((_a15 = _vm.model) == null ? void 0 : _a15.totalPages) ?? 1 }, model: { value: _vm.page, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.page = $$v;
  }, "callback"), expression: "page" } }) : _vm._e()], 1), _vm._v(" "), _c("item-history-modal", { attrs: { item: { id: _vm.itemIdHistoryToShow, name: _vm.itemNameHistoryToShow }, shouldShow: _vm.showItemHistoryModal }, on: { close: _vm.closeHistoryModal } })], 1);
}, "render"), _sfc_staticRenderFns$9 = [], __component__$9 = /* @__PURE__ */ normalizeComponent(
  AdministrationIndexingPreProcessorListComponent,
  _sfc_render$9,
  _sfc_staticRenderFns$9,
  !1,
  null,
  "49fca97b"
);
const PreProcessorComponent = __component__$9.exports;
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor, __decorateClass$8 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$8"), _a6;
let AdministrationIndexingProcessorListComponent = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "filterModel", { filterStatus: null, sort: {} });
    __publicField(this, "model", null);
    __publicField(this, "tableItems", []);
    __publicField(this, "rowDetailIds", []);
    __publicField(this, "loading", !0);
    __publicField(this, "page", 1);
    __publicField(this, "pageSize", 50);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "filteredPageId", null);
    __publicField(this, "filteredActionAlias", null);
    __publicField(this, "indexingPages", []);
    __publicField(this, "actions", []);
    __publicField(this, "itemIdHistoryToShow", "");
    __publicField(this, "itemNameHistoryToShow", "");
    __publicField(this, "showItemHistoryModal", !1);
    __publicField(this, "selectedProcessorIds", []);
  }
  mounted() {
    this.reloadTimer = setInterval(() => {
      this.selectedProcessorIds.length > 0 || this.getProcessorInfo(!1);
    }, 3e4), this.getProcessorInfo(!0), this.getIndexingPages(), this.loadActions();
  }
  async loadActions() {
    this.actions = await new AdministrationReportingClient(new Transformer(), baseUrl()).getReportActions();
  }
  get actionOptions() {
    let actionOptions = [{ value: null, text: "All" }];
    return this.actions.forEach((action) => {
      actionOptions.push({ value: action.alias, text: action.name });
    }), actionOptions;
  }
  get filterOptions() {
    return [
      { value: null, text: "All" },
      { value: AdministrationItemProcessingStatus.Failed, text: "Returned to Queue" },
      { value: AdministrationItemProcessingStatus.Cancelled, text: "Cancelled" },
      { value: AdministrationItemProcessingStatus.Running, text: "Failed" },
      { value: AdministrationItemProcessingStatus.Successful, text: "Successful" }
    ];
  }
  async getIndexingPages() {
    let pages;
    try {
      pages = await new AdministrationAppsClient(new Transformer(), baseUrl()).getFieldedPages();
    } catch (e) {
      toastr.error(e, "Failed to get pages");
    }
    pages = pages.filter((p) => p.type === PageType.RIA), this.indexingPages = pages;
  }
  get pageOptions() {
    let pageOptions = [{ value: null, text: "All" }];
    return this.indexingPages.forEach((page) => {
      pageOptions.push({ value: page.id, text: page.name });
    }), pageOptions;
  }
  async getProcessorInfo(setLoading) {
    this.loading = setLoading;
    let managementClient = new AdministrationIndexingManagementClient(new Transformer(), baseUrl());
    this.model = await managementClient.getProcessingSummary(this.filterModel, this.page, this.pageSize), this.cleanSelected(), this.tableItems = this.model.processors.map((t) => ({
      id: t.id,
      item: t.item,
      name: t.name,
      finished: t.finished,
      started: t.started,
      status: t.status,
      stages: t.stages,
      action: t.action,
      _showDetails: this.rowDetailIds.includes(t.id)
    })), this.loading = !1;
  }
  async pageChanged() {
    await this.getProcessorInfo(!0);
  }
  getDetailUrl(itemId) {
    return new URL(baseUrl() + "/app/indexing/items/" + itemId).href;
  }
  get totalPages() {
    if (this.model)
      return this.model.totalPages;
  }
  toggleRowDetails(row) {
    row.toggleDetails(), this.rowDetailIds.includes(row.item.id) ? this.rowDetailIds = this.rowDetailIds.filter(function(i) {
      return i !== row.item.id;
    }) : this.rowDetailIds.push(row.item.id);
  }
  getStatusText(processor) {
    switch (processor.status) {
      case AdministrationItemProcessingStatus.Running:
        return processor.stages.filter((stage) => stage.status === ProcessorItemStageStatus.Failed).length ? "Stage Failed" : this.$options.filters.capitaliseFirstLetter(processor.status);
      case AdministrationItemProcessingStatus.Cancelled:
      case AdministrationItemProcessingStatus.Successful:
        return this.$options.filters.capitaliseFirstLetter(processor.status);
      case AdministrationItemProcessingStatus.Failed:
        return "Returned to queue";
      default:
        return "Unknown";
    }
  }
  getProcessorStatusClass(processor) {
    switch (processor.status) {
      case AdministrationItemProcessingStatus.Running:
        return processor.stages.filter((stage) => stage.status === ProcessorItemStageStatus.Failed).length ? "danger" : "primary";
      case AdministrationItemProcessingStatus.Successful:
        return "success";
      case AdministrationItemProcessingStatus.Failed:
        return "warning";
      default:
        return "";
    }
  }
  getProcessorIcon(processor) {
    switch (processor.status) {
      case AdministrationItemProcessingStatus.Running:
        return processor.stages.filter((stage) => stage.status === ProcessorItemStageStatus.Failed).length ? "times-circle" : "circle-ellipsis";
      case AdministrationItemProcessingStatus.Successful:
        return "check-circle";
      case AdministrationItemProcessingStatus.Cancelled:
        return "ban";
      case AdministrationItemProcessingStatus.Failed:
        return "inbox-in";
      default:
        return "question";
    }
  }
  getJobClass(job) {
    switch (job.status) {
      case ProcessorJobStatus.Successful:
        return "success";
      case ProcessorJobStatus.Failed:
        return "danger";
      case ProcessorJobStatus.Skipped:
        return "muted";
      case ProcessorJobStatus.Cancelled:
        return "muted";
      case ProcessorJobStatus.Running:
        return "primary";
      default:
        return "";
    }
  }
  getJobIcon(job) {
    switch (job.status) {
      case ProcessorJobStatus.Successful:
        return "check-circle";
      case ProcessorJobStatus.Failed:
        return "times-circle";
      case ProcessorJobStatus.Skipped:
        return "circle-chevron-right";
      case ProcessorJobStatus.Cancelled:
        return "ban";
      case ProcessorJobStatus.Running:
        return "circle-ellipsis";
      default:
        return "";
    }
  }
  getStageName(stage) {
    return stage.name ? stage.name : "Stage not found";
  }
  getStageClass(stage) {
    let stageButtonClass = "";
    switch (stage.status) {
      case ProcessorItemStageStatus.Running:
        stageButtonClass += "primary";
        break;
      case ProcessorItemStageStatus.Successful:
        stageButtonClass += "success";
        break;
      case ProcessorItemStageStatus.Queued:
      case ProcessorItemStageStatus.Cancelled:
      case ProcessorItemStageStatus.Skipped:
        stageButtonClass += "secondary";
        break;
      case ProcessorItemStageStatus.Failed:
        stageButtonClass += "danger";
        break;
    }
    return stageButtonClass;
  }
  getStageStatusTitle(stage) {
    switch (stage.status) {
      case ProcessorItemStageStatus.Queued:
        return "Queued to run";
      default:
        return this.$options.filters.capitaliseFirstLetter(stage.status ? stage.status : "Unknown");
    }
  }
  getStageIcon(stage) {
    switch (stage.status) {
      case ProcessorItemStageStatus.Queued:
        return "clock";
      case ProcessorItemStageStatus.Running:
        return "circle-ellipsis";
      case ProcessorItemStageStatus.Successful:
        return "check-circle";
      case ProcessorItemStageStatus.Skipped:
        return "circle-chevron-right";
      case ProcessorItemStageStatus.Cancelled:
        return "ban";
      case ProcessorItemStageStatus.Failed:
        return "times-circle";
    }
  }
  getProcessorFinalStage(item) {
    return item == null ? void 0 : item.stages.find((y) => y.order == item.stages.length);
  }
  async downloadJobLog(job) {
    let logFile = await new AdministrationIndexingManagementClient(new Transformer(), baseUrl()).processingJobDetails(job.id), blob = logFile.data, downloadUrl = window.URL.createObjectURL(blob), anchor = document.createElement("a");
    anchor.href = downloadUrl, anchor.download = logFile.fileName, document.body.appendChild(anchor), anchor.click(), anchor.remove();
  }
  async cancelProcessor(processorId) {
    let managementClient = new AdministrationIndexingManagementClient(new Transformer(), baseUrl());
    try {
      await managementClient.cancelProcessor(processorId), toastr.info("The processor has been cancelled");
    } catch (ex) {
      toastr.error(ex, "An error occurred while cancelling the processor");
    }
    await this.$nextTick(), await this.getProcessorInfo(!1);
  }
  async retryProcessor(processorId) {
    let managementClient = new AdministrationIndexingManagementClient(new Transformer(), baseUrl());
    try {
      await managementClient.retryProcessor(processorId), toastr.info("The processor has been marked to retry");
    } catch (ex) {
      toastr.error(ex, "An error occurred while retrying the processor");
    }
    await this.$nextTick(), await this.getProcessorInfo(!1);
  }
  async failProcessor(processorId) {
    let managementClient = new AdministrationIndexingManagementClient(new Transformer(), baseUrl());
    try {
      await managementClient.failProcessor(processorId), toastr.info("The processor has been marked as failed");
    } catch (ex) {
      toastr.error(ex, "An error occurred while failing the processor");
    }
    await this.$nextTick(), await this.getProcessorInfo(!1);
  }
  setFilteredAction(actionId) {
    actionId ? this.filterModel.action = actionId : this.filterModel.action = null, this.getProcessorInfo(!0);
  }
  setFilteredPageIds(pageId) {
    pageId ? this.filterModel.pageIds = [pageId] : this.filterModel.pageIds = null, this.getProcessorInfo(!0);
  }
  get sort() {
    let sort = this.filterModel.sort;
    return sort || null;
  }
  set sort(sort) {
    this.filterModel.sort = sort, this.getProcessorInfo(!0);
  }
  setHistoryToShow(item) {
    this.itemIdHistoryToShow = item.item.id, this.itemNameHistoryToShow = item.name, this.showItemHistoryModal = !0;
  }
  closeHistoryModal() {
    this.itemIdHistoryToShow = null, this.itemNameHistoryToShow = null, this.showItemHistoryModal = !1;
  }
  isProcessorSelected(processorId) {
    var _a15;
    return (_a15 = this.selectedProcessorIds) == null ? void 0 : _a15.includes(processorId);
  }
  get selectedProcessors() {
    return this.selectedProcessorIds;
  }
  set selectedProcessors(value) {
    this.selectedProcessorIds = value;
  }
  get partiallySelectedProcessors() {
    var _a15;
    return ((_a15 = this.selectedProcessorIds) == null ? void 0 : _a15.length) > 0 && this.selectedProcessorIds.length < this.model.processors.length;
  }
  toggleProcessorSelected(processorId) {
    var _a15;
    ((_a15 = this.selectedProcessorIds) == null ? void 0 : _a15.find((x) => x == processorId)) ? this.selectedProcessorIds = this.selectedProcessorIds.filter((x) => x != processorId) : this.selectedProcessorIds = this.selectedProcessorIds.concat([processorId]);
  }
  toggleAllProcessorsSelected() {
    var _a15;
    ((_a15 = this.selectedProcessorIds) == null ? void 0 : _a15.length) == 0 ? this.selectedProcessorIds = this.model.processors.map((x) => x.id) : this.selectedProcessorIds = [];
  }
  async bulkActionProcessors(action) {
    let bulkAction = AdminBulkProcessorAction.Cancel;
    switch (action) {
      case "cancel":
        bulkAction = AdminBulkProcessorAction.Cancel;
        break;
      case "fail":
        bulkAction = AdminBulkProcessorAction.Fail;
        break;
      case "retry":
        bulkAction = AdminBulkProcessorAction.Retry;
        break;
    }
    let processingClient = new AdministrationIndexingManagementClient(new Transformer(), baseUrl());
    try {
      this.loading = !0, await processingClient.bulkActionProcessors({ processorIds: this.selectedProcessorIds, action: bulkAction }), toastr.info("The selected processors have been actioned."), this.cleanSelected();
    } catch (ex) {
      toastr.error(ex, "An error occurred while actioning the processors");
    } finally {
      this.loading = !1;
    }
  }
  checkProcessorsCanAction(action) {
    switch (action) {
      case "cancel":
        return this.model.processors.filter((y) => this.selectedProcessorIds.indexOf(y.id) > -1).every((y) => {
          var _a15, _b;
          return ((_a15 = this.getProcessorFinalStage(y)) == null ? void 0 : _a15.status) == "queued" || ((_b = this.getProcessorFinalStage(y)) == null ? void 0 : _b.status) == "running";
        });
      case "retry":
      case "fail":
        return this.model.processors.filter((y) => this.selectedProcessorIds.indexOf(y.id) > -1).every((y) => {
          var _a15, _b, _c;
          return ((_a15 = this.getProcessorFinalStage(y)) == null ? void 0 : _a15.status) != "queued" && y.status == "running" && (((_b = this.getProcessorFinalStage(y)) == null ? void 0 : _b.status) == "failed" || ((_c = this.getProcessorFinalStage(y)) == null ? void 0 : _c.status) == "cancelled");
        });
    }
  }
  cleanSelected() {
    this.selectedProcessorIds.length && (this.selectedProcessorIds = this.selectedProcessorIds.filter((y) => this.model.processors.some((x) => x.processorId == y)));
  }
  get tableFields() {
    return [
      { key: "select", label: "", sortable: !1 },
      { key: "action", label: "Action", sortable: !1 },
      { key: "item", label: "Item", sortable: !1, thClass: "align-middle" },
      { key: "page", sortable: !1 },
      { key: "started", label: "Started", sortable: !1, thClass: "align-middle" },
      { key: "status", label: "Status", sortable: !1 },
      { key: "completed", label: "Completed", sortable: !1, thClass: "align-middle" },
      { key: "actions", label: "", sortable: !1 }
    ];
  }
}, __name(_a6, "AdministrationIndexingProcessorListComponent"), _a6);
__decorateClass$8([
  Watch("page")
], AdministrationIndexingProcessorListComponent.prototype, "pageChanged", 1);
AdministrationIndexingProcessorListComponent = __decorateClass$8([
  Component({ components: { DateDisplay, PaginationControls, SortableHeaderLink, ItemHistoryModal } })
], AdministrationIndexingProcessorListComponent);
var _sfc_render$8 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "sign-out" } }), _vm._v(` Processing
        `), _c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.getProcessorInfo(!0);
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)])], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.tableItems, striped: "", busy: _vm.loading, "details-td-class": "pt-0 pb-2", "show-empty": "", emptyText: "No processing items could be found" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "head(action)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_vm._v(`
                    ` + _vm._s(row.label) + ` 
                `), _c("b-form-select", { attrs: { size: "sm", options: _vm.actionOptions }, on: { change: _vm.setFilteredAction }, model: { value: _vm.filteredActionAlias, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.filteredActionAlias = $$v;
    }, "callback"), expression: "filteredActionAlias" } })], 1)])];
  }, "fn") }, { key: "head(item)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "item", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(started)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "started", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(completed)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "completed", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_c("sortable-header-link", { staticClass: "mb-1", attrs: { id: "status", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } }), _vm._v(`
                 
                `), _c("b-form-select", { attrs: { size: "sm", options: _vm.filterOptions }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.getProcessorInfo(!0);
    }, "change") }, model: { value: _vm.filterModel.filterStatus, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(_vm.filterModel, "filterStatus", $$v);
    }, "callback"), expression: "filterModel.filterStatus" } })], 1)])];
  }, "fn") }, { key: "head(page)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_c("span", { staticClass: "mb-1" }, [_vm._v(_vm._s(row.label) + " ")]), _vm._v(" "), _c("b-form-select", { attrs: { size: "sm", options: _vm.pageOptions }, on: { change: _vm.setFilteredPageIds }, model: { value: _vm.filteredPageId, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.filteredPageId = $$v;
    }, "callback"), expression: "filteredPageId" } })], 1)])];
  }, "fn") }, { key: "head(select)", fn: /* @__PURE__ */ __name(function(row) {
    var _a15;
    return [_c("b-checkbox", { attrs: { indeterminate: _vm.partiallySelectedProcessors, checked: !!((_a15 = _vm.selectedProcessorIds) != null && _a15.length) }, on: { change: _vm.toggleAllProcessorsSelected } })];
  }, "fn") }, { key: "head(actions)", fn: /* @__PURE__ */ __name(function(row) {
    var _a15;
    return [(_a15 = _vm.selectedProcessorIds) != null && _a15.length ? _c("div", [_c("b-dropdown", { staticClass: "float-right", attrs: { variant: "primary", size: "sm", id: "bulkActionProcessors", disabled: _vm.loading, "no-caret": "", right: "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("cancel") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("cancel");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "ban" } }), _vm._v(" Cancel (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("retry") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("retry");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Retry (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { disabled: !_vm.checkProcessorsCanAction("fail") }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.bulkActionProcessors("fail");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "inbox-in" } }), _vm._v(" Return to Queue (" + _vm._s(_vm.selectedProcessorIds.length) + `)
                    `)], 1)], 1)], 1) : _vm._e()];
  }, "fn") }, { key: "cell(select)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "d-inline-flex" }, [_c("b-checkbox", { attrs: { checked: _vm.isProcessorSelected(row.item.id), size: "sm" }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleProcessorSelected(row.item.id);
    }, "change") } })], 1)];
  }, "fn") }, { key: "cell(action)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("span", { class: "text-" + row.item.action.colour }, [_c("font-awesome-icon", { attrs: { icon: row.item.action && row.item.action.icon ? row.item.action.icon : "question" } }), _vm._v(`
            ` + _vm._s(row.item.action && row.item.action.name ? row.item.action.name : "Unknown") + `
          `)], 1)];
  }, "fn") }, { key: "cell(page)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
          ` + _vm._s(row.item.item.page ? row.item.item.page.name : "Unknown Page") + " - "), _c("small", [_vm._v(_vm._s(row.item.item.queue ? row.item.item.queue.name : "Unknown Queue"))])];
  }, "fn") }, { key: "cell(started)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.started ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.started } }) : _vm._e()];
  }, "fn") }, { key: "cell(item)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.item.status == "enqueued" ? _c("span", [_c("a", { attrs: { href: _vm.getDetailUrl(row.item.item.id) } }, [_vm._v(_vm._s(row.item.name))])]) : _c("span", [_vm._v(_vm._s(row.item.name))]), _vm._v(" "), _c("span", [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "link", size: "sm", title: "View item history" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setHistoryToShow(row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "history" } })], 1)], 1)];
  }, "fn") }, { key: "cell(completed)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.finished ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.finished } }) : _vm._e(), _vm._v(" "), row.item.finished ? _c("span", { staticClass: "small text-muted" }, [_vm._v("(took " + _vm._s(_vm.$options.filters.datetimeDifference(row.item.started, row.item.finished)) + ")")]) : _vm._e()];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(row) {
    var _a15, _b, _c2;
    return [((_b = (_a15 = row.item) == null ? void 0 : _a15.stages) == null ? void 0 : _b.length) > 0 ? _c("span", { staticClass: "float-right", attrs: { let: _vm.lastStageStatus = (_c2 = _vm.getProcessorFinalStage(row.item)) == null ? void 0 : _c2.status } }, [_vm.lastStageStatus == "queued" || _vm.lastStageStatus == "running" ? _c("b-button", { attrs: { size: "sm", variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.cancelProcessor(row.item.id);
    }, "click") } }, [_vm._v("Cancel Processor")]) : _vm.lastStageStatus != "queued" && row.item.status == "running" && (_vm.lastStageStatus == "cancelled" || _vm.lastStageStatus == "failed") ? _c("b-dropdown", { attrs: { "no-flip": "", right: "", size: "sm", variant: "outline-primary" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(` Actions
                  `)];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.retryProcessor(row.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Retry failed stage")], 1), _vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.failProcessor(row.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "inbox-in" } }), _vm._v(" Return to Queue")], 1)], 1) : _vm._e()], 1) : _vm._e()];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "text-nowrap" }, [_c("b-badge", { attrs: { variant: _vm.getProcessorStatusClass(row.item), pill: "", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.getProcessorIcon(row.item) } }), _vm._v(`
            ` + _vm._s(_vm.getStatusText(row.item)) + `
          `)], 1), _vm._v(" "), _vm._l(row.item.stages, function(stage) {
      return _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { title: _vm.getStageName(stage) + " - " + _vm.getStageStatusTitle(stage) }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.toggleRowDetails(row);
      }, "click") } }, [_c("font-awesome-icon", { class: "text-" + _vm.getStageClass(stage), attrs: { icon: _vm.getStageIcon(stage), transform: stage.status === "skipped" ? "shrink-5" : "", mask: stage.status === "skipped" ? "fa-solid fa-circle" : "" } })], 1);
    }), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "align-middle", attrs: { variant: "link", size: "sm", title: "Show stage details" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: row.detailsShowing ? "caret-down" : "caret-right" } })], 1)], 2)];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-card", { attrs: { "body-class": "p-3 mx-auto" } }, [_c("b-row", { staticClass: "py-0" }, [_c("b-col", _vm._l(row.item.stages, function(stage, index2) {
      return _c("span", { staticClass: "center" }, [_c("b-dropdown", { class: { "mx-1": index2 + 1 != row.item.stages.length }, attrs: { "no-flip": "", size: "sm", right: "", variant: "outline-" + _vm.getStageClass(stage) }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
        return [_c("font-awesome-icon", { attrs: { icon: _vm.getStageIcon(stage) } }), _vm._v(`
                    ` + _vm._s(_vm.getStageName(stage)) + `
                  `)];
      }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _vm._l(stage.jobs, function(job, jobIndex) {
        return _c("b-dropdown-item", { key: jobIndex, attrs: { pill: "" }, on: { click: /* @__PURE__ */ __name(function($event) {
          return _vm.downloadJobLog(job);
        }, "click") } }, [_c("font-awesome-icon", { class: "text-" + _vm.getJobClass(job), attrs: { icon: _vm.getJobIcon(job) } }), _vm._v(`
                    Download Log file #` + _vm._s(jobIndex + 1) + `
                  `)], 1);
      })], 2), _vm._v(" "), index2 + 1 != row.item.stages.length ? _c("font-awesome-icon", { staticClass: "align-middle", attrs: { size: "xs", icon: "chevron-right" } }) : _vm._e(), _vm._v(` 
              `)], 1);
    }), 0)], 1)], 1)];
  }, "fn") }]) }), _vm._v(" "), _vm.model ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.page, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.page = $$v;
  }, "callback"), expression: "page" } }) : _vm._e()], 1), _vm._v(" "), _c("item-history-modal", { attrs: { item: { id: _vm.itemIdHistoryToShow, name: _vm.itemNameHistoryToShow }, shouldShow: _vm.showItemHistoryModal }, on: { close: _vm.closeHistoryModal } })], 1);
}, "render"), _sfc_staticRenderFns$8 = [], __component__$8 = /* @__PURE__ */ normalizeComponent(
  AdministrationIndexingProcessorListComponent,
  _sfc_render$8,
  _sfc_staticRenderFns$8,
  !1,
  null,
  "8979b1dc"
);
const ProcessorComponent = __component__$8.exports;
var __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor, __decorateClass$7 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$7"), _a7;
let AdministrationIndexingUsageComponent = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !0);
    __publicField(this, "graphType", UsageStatisticType.Last24Hours);
    __publicField(this, "chart", "bar");
    __publicField(this, "model", null);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "barComponent", Bar);
    __publicField(this, "lineComponent", Line);
    __publicField(this, "showChart", !1);
    __publicField(this, "usageTypes", [
      { value: UsageStatisticType.Last24Hours, text: "Last 24 hours" },
      { value: UsageStatisticType.Today, text: "Today" },
      { value: UsageStatisticType.LastWeek, text: "Last week" },
      { value: UsageStatisticType.ThisWeek, text: "This week" },
      { value: UsageStatisticType.LastMonth, text: "Last month" },
      { value: UsageStatisticType.ThisMonth, text: "This month" },
      { value: UsageStatisticType.Last3Months, text: "Last 3 months" },
      { value: UsageStatisticType.LastYear, text: "Last year" },
      { value: UsageStatisticType.ThisYear, text: "This year" }
    ]);
    __publicField(this, "chartTypes", [
      { value: "bar", text: "Bar" },
      { value: "line", text: "Line" }
    ]);
  }
  async mounted() {
    await new AdministrationIndexingUsageClient(new Transformer(), baseUrl()).getCanUseUsage() && (this.showChart = !0, Chart.register(plugin_title, plugin_tooltip, plugin_legend, LineElement, LinearScale, CategoryScale, PointElement, BarElement, CategoryScale, LinearScale), this.reloadTimer = setInterval(() => this.refresh(), 3e4), await this.refresh());
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer), this.loading = !1;
  }
  get usageType() {
    return this.graphType;
  }
  set usageType(value) {
    this.graphType = value, this.refresh();
  }
  get chartType() {
    return this.chart;
  }
  set chartType(value) {
    this.chart = value, this.loading = !0, this.loading = !1;
  }
  async refresh() {
    try {
      let results = await new AdministrationIndexingUsageClient(new Transformer(), baseUrl()).getUsageStatistics(this.graphType);
      this.model = results;
    } catch {
    } finally {
      this.loading = !1;
    }
  }
  get labels() {
    return this.model.results.map((y) => this.mapDate(y.dateData));
  }
  mapDate(date) {
    switch (this.graphType) {
      case UsageStatisticType.Last24Hours:
      case UsageStatisticType.Today:
        return Moment(date).local().format("hA");
      case UsageStatisticType.LastWeek:
      case UsageStatisticType.ThisWeek:
        return Moment(date).local().format("dddd");
      case UsageStatisticType.LastMonth:
      case UsageStatisticType.ThisMonth:
        return "Week " + Moment(date).local().format("W");
      case UsageStatisticType.Last3Months:
        return "Week " + Moment(date).local().format("W");
      case UsageStatisticType.LastYear:
      case UsageStatisticType.ThisYear:
        return Moment(date).local().format("MMMM");
    }
  }
  get chartData() {
    return {
      labels: this.labels,
      datasets: [
        {
          label: "Added",
          backgroundColor: "#7ecbf1",
          data: this.model.results.map((y) => y.itemsUploaded)
        },
        {
          label: "Indexed",
          backgroundColor: "#76b245",
          data: this.model.results.map((y) => y.itemsIndexed)
        }
      ]
    };
  }
  get chartOptions() {
    return {
      responsive: !0,
      maintainAspectRatio: !1
    };
  }
  get canvasId() {
    return v4();
  }
}, __name(_a7, "AdministrationIndexingUsageComponent"), _a7);
AdministrationIndexingUsageComponent = __decorateClass$7([
  Component({ components: {} })
], AdministrationIndexingUsageComponent);
var _sfc_render$7 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_vm.showChart ? _c("b-card", { scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("span", { staticClass: "align-middle" }, [_c("font-awesome-icon", { attrs: { icon: "chart-simple" } }), _vm._v(`
              Usage
              `)], 1), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.refresh(!0);
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)])], 1)];
  }, "fn"), proxy: !0 }], null, !1, 79696856) }, [_vm._v(" "), !_vm.model && _vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _vm._e(), _vm._v(" "), _c("b-form-select", { staticClass: "col-md-1 mr-1", attrs: { options: _vm.chartTypes }, model: { value: _vm.chartType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.chartType = $$v;
  }, "callback"), expression: "chartType" } }), _vm._v(" "), _c("b-form-select", { staticClass: "col-md-2 mr-1", attrs: { options: _vm.usageTypes }, model: { value: _vm.usageType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.usageType = $$v;
  }, "callback"), expression: "usageType" } }), _vm._v(" "), _vm.model && !_vm.loading && _vm.chart == "bar" ? _c(_vm.barComponent, { tag: "component", attrs: { "chart-data": _vm.chartData, "chart-id": _vm.canvasId, "dataset-id-key": "dateData", "chart-options": _vm.chartOptions } }) : _vm._e(), _vm._v(" "), _vm.model && !_vm.loading && _vm.chart == "line" ? _c(_vm.lineComponent, { tag: "component", attrs: { "chart-data": _vm.chartData, "chart-id": _vm.canvasId, "dataset-id-key": "dateData", "chart-options": _vm.chartOptions } }) : _vm._e()], 1) : _c("b-alert", { attrs: { show: "", variant: "warning", id: "notSupportedAlert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
    You must configure your EWA instance to use SQL Server to access the indexing management usage graphs.
  `)], 1)], 1);
}, "render"), _sfc_staticRenderFns$7 = [], __component__$7 = /* @__PURE__ */ normalizeComponent(
  AdministrationIndexingUsageComponent,
  _sfc_render$7,
  _sfc_staticRenderFns$7,
  !1,
  null,
  null
);
const IndexingUsageComponent = __component__$7.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$6"), _a8;
let ConfirmCleanupItemsModal = (_a8 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "olderThanDate");
    __publicField(this, "itemsToClean", 0);
  }
  async modalShown() {
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("confirm-cleanup-modal");
  }
  get modalTitle() {
    return "Remove ~" + this.itemsToClean + " indexed items?";
  }
  get date() {
    return new Date(this.olderThanDate);
  }
}, __name(_a8, "ConfirmCleanupItemsModal"), _a8);
__decorateClass$6([
  Prop({ required: !0 })
], ConfirmCleanupItemsModal.prototype, "olderThanDate", 2);
__decorateClass$6([
  Prop({ required: !0 })
], ConfirmCleanupItemsModal.prototype, "itemsToClean", 2);
ConfirmCleanupItemsModal = __decorateClass$6([
  Component({
    components: { DateDisplay }
  })
], ConfirmCleanupItemsModal);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "confirm-cleanup-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, on: { shown: _vm.modalShown }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
      Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "primary", disabled: _vm.itemsToClean === 0 }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "broom" } }), _vm._v(` Start cleanup
    `)], 1)];
  }, "fn") }]) }, [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
    There are ` + _vm._s(_vm.itemsToClean) + " indexed items before "), _c("date-display", { attrs: { humanise: !1, value: _vm.date, "show-time": !1 } }), _vm._v(" "), _c("br"), _vm._v(" "), _vm.itemsToClean > 0 ? _c("span", [_vm._v(`
      Are you sure you want to remove ~` + _vm._s(_vm.itemsToClean) + ` indexed item records?
      `), _c("br"), _vm._v(`
      This clean up may not remove the final item.
      `), _c("br"), _vm._v(`
      This is not reversible.
    `)]) : _vm._e()], 1)], 1);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  ConfirmCleanupItemsModal,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  null
);
const ConfirmCleanupModal = __component__$6.exports;
var __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$5"), _a9;
let AdministrationIndexingCleanupComponent = (_a9 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !0);
    __publicField(this, "canUse", !1);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "isRunning", !1);
    __publicField(this, "runningOperating", null);
    __publicField(this, "olderThan", null);
    __publicField(this, "itemsLeftToClean", 0);
    __publicField(this, "itemScheduledToClean", 0);
    __publicField(this, "confirmCancel", !1);
    __publicField(this, "datepicker", null);
  }
  async mounted() {
    this.canUse = await new AdministrationIndexingCleanupClient(new Transformer(), baseUrl()).getCanUse();
    let info = await new AdministrationIndexingCleanupClient(new Transformer(), baseUrl()).cleanupRunningInfo();
    this.isRunning = info.isRunning, this.runningOperating = info.operation, info.olderThanDate && (this.olderThan = Moment(info.olderThanDate).format("yyyy-MM-DD")), this.isRunning && info.operation == "Cleanup" ? (toastr.success("Clean-up is currently running"), this.reloadTimer = setInterval(() => this.refresh(), 1e4), await this.refresh()) : this.isRunning && (toastr.warning("Please wait for the current bulk operation completes", "Another bulk operation is running"), this.reloadTimer = setInterval(() => this.refresh(), 1e4), await this.refresh()), this.canUse && (await this.$nextTick, this.setDatepickerSettings());
  }
  setDatepickerSettings() {
    this.datepicker = $("#cleanup .input-group.date"), this.datepicker.datepicker({
      todayHighlight: !0,
      orientation: "bottom left",
      endDate: /* @__PURE__ */ new Date(),
      autoclose: !0,
      forceParse: !1,
      format: "yyyy-mm-dd"
    }).on("changeDate", (e) => {
      this.olderThan = e.format();
    });
  }
  async showConfigureSyncModal() {
    this.itemScheduledToClean = await new AdministrationIndexingCleanupClient(new Transformer(), baseUrl()).checkCleanCount(this.olderThan), this.$bvModal.show("confirm-cleanup-modal");
  }
  async startCleanup() {
    await new AdministrationIndexingCleanupClient(new Transformer(), baseUrl()).startIndexingClean(this.olderThan), toastr.info("Indexing cleanup has started"), this.refresh(), this.reloadTimer = setInterval(() => this.refresh(), 1e3);
  }
  async cancelCleanup() {
    if (!this.isRunning)
      return;
    this.confirmCancel = !1, await new AdministrationIndexingCleanupClient(new Transformer(), baseUrl()).cancelIndexingClean() ? (toastr.success("Indexing clean up has been cancelled"), this.reloadTimer && clearTimeout(this.reloadTimer)) : toastr.error("Unable to cancel indexing clean up job"), this.refresh();
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer), this.loading = !1;
  }
  async refresh() {
    try {
      let info = await new AdministrationIndexingCleanupClient(new Transformer(), baseUrl()).cleanupRunningInfo();
      this.isRunning = info.isRunning, this.runningOperating = info.operation, this.isRunning && this.olderThan ? (this.itemsLeftToClean = await new AdministrationIndexingCleanupClient(new Transformer(), baseUrl()).checkCleanCount(this.olderThan), this.itemScheduledToClean == 0 && (this.itemScheduledToClean = this.itemsLeftToClean)) : !this.isRunning && info.operation == "Cleanup" ? (toastr.success("Indexing cleanup finished"), clearTimeout(this.reloadTimer)) : this.isRunning || (toastr.success("The other bulk operation has completed"), clearTimeout(this.reloadTimer));
    } finally {
      this.loading = !1;
    }
  }
}, __name(_a9, "AdministrationIndexingCleanupComponent"), _a9);
AdministrationIndexingCleanupComponent = __decorateClass$5([
  Component({ components: { ConfirmCleanupModal } })
], AdministrationIndexingCleanupComponent);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-alert", { attrs: { show: "", variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" "), _c("strong", [_vm._v("Preview Feature!")]), _c("br"), _c("span", [_vm._v("This feature is currently in preview. Please take a backup copy of the databases before running the cleanup.")])], 1), _vm._v(" "), _vm.canUse ? _c("b-card", { scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("span", { staticClass: "align-middle" }, [_c("font-awesome-icon", { attrs: { icon: "broom" } }), _vm._v(`
              Indexing Cleanup
            `)], 1)])];
  }, "fn"), proxy: !0 }], null, !1, 1688924507) }, [_vm._v(" "), _c("b-row", [_c("b-col", { attrs: { cols: "12" } }, [_c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
            Indexing cleanup will allow you to remove old indexing records from the Database to free up space and reduce clutter.
            Doing so will permanently delete those records removing the ability to find or reactive those items.
          `)], 1)], 1)], 1), _vm._v(" "), _c("b-row", { attrs: { id: "cleanup" } }, [_c("b-col", { attrs: { md: "6", lg: "4", cols: "12" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Cleanup Items Indexed Before")]), _vm._v(" "), _c("b-input-group", { staticClass: "mb-2 date", scopedSlots: _vm._u([{ key: "append", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "calendar" } })], 1)];
  }, "fn"), proxy: !0 }], null, !1, 2330456349) }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.olderThan, expression: "olderThan" }], staticClass: "form-control", attrs: { type: "text", id: "olderThanDatePicker", placeholder: "Select a date...", disabled: _vm.isRunning, autocomplete: "off" }, domProps: { value: _vm.olderThan }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.olderThan = $event.target.value);
  }, "input") } })]), _vm._v(" "), _c("b-form-text", { attrs: { id: "password-help-block" } }, [_vm._v(`
              Any items indexed before and including this date will be deleted
            `)]), _vm._v(" "), _c("b-button", { staticClass: "mr-1 float-right", attrs: { variant: "outline-primary", disabled: !_vm.olderThan || _vm.isRunning }, on: { click: _vm.showConfigureSyncModal } }, [_c("span", [_c("font-awesome-icon", { attrs: { icon: "broom" } }), _vm._v(" Generate cleanup report")], 1)])], 1)], 1), _vm._v(" "), _vm.isRunning && _vm.runningOperating == "Cleanup" ? _c("div", { staticClass: "mt-2" }, [_c("hr"), _vm._v(" "), _c("span", { staticClass: "float-right" }, [_vm.confirmCancel ? _c("span", [_c("b-button", { attrs: { variant: "danger", size: "sm" }, on: { click: _vm.cancelCleanup } }, [_c("font-awesome-icon", { attrs: { icon: "x" } }), _vm._v(` Confirm
                      `)], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.confirmCancel = !1;
  }, "click") } }, [_vm._v(`
                      Cancel
                  `)])], 1) : _c("span", [_c("b-button", { attrs: { variant: "danger", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.confirmCancel = !0;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "x" } }), _vm._v(`
                      Cancel Clean Up
                  `)], 1)], 1)]), _vm._v(" "), _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Cleaning up items...")])], 1), _vm._v(" "), _c("b-progress", { attrs: { value: _vm.itemScheduledToClean - _vm.itemsLeftToClean, max: _vm.itemScheduledToClean, "show-progress": "", animated: "" } }, [_c("b-progress-bar", { staticStyle: { "min-width": "100px" }, attrs: { value: _vm.itemScheduledToClean - _vm.itemsLeftToClean } }, [_vm._v(`
              ` + _vm._s(_vm.itemScheduledToClean - _vm.itemsLeftToClean) + "/" + _vm._s(_vm.itemScheduledToClean) + `
            `)])], 1)], 1) : _vm._e()], 1) : _c("b-alert", { attrs: { show: "", variant: "warning", id: "notSupportedAlert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
        You must configure your EWA instance to use SQL server to access the indexing management cleanup.
      `)], 1), _vm._v(" "), _c("confirm-cleanup-modal", { attrs: { olderThanDate: _vm.olderThan, "items-to-clean": _vm.itemScheduledToClean }, on: { confirm: _vm.startCleanup } })], 1);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  AdministrationIndexingCleanupComponent,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  null
);
const IndexingCleanupComponent = __component__$5.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$4"), _a10;
let ConfirmBulkIndexItemsModal = (_a10 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "olderThanDate");
    __publicField(this, "itemsToIndex", 0);
  }
  async modalShown() {
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("confirm-bulk-index-modal");
  }
  get modalTitle() {
    return "Index " + this.itemsToIndex + " items?";
  }
  get date() {
    return new Date(this.olderThanDate);
  }
}, __name(_a10, "ConfirmBulkIndexItemsModal"), _a10);
__decorateClass$4([
  Prop({ required: !0 })
], ConfirmBulkIndexItemsModal.prototype, "olderThanDate", 2);
__decorateClass$4([
  Prop({ required: !0 })
], ConfirmBulkIndexItemsModal.prototype, "itemsToIndex", 2);
ConfirmBulkIndexItemsModal = __decorateClass$4([
  Component({
    components: { DateDisplay }
  })
], ConfirmBulkIndexItemsModal);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "confirm-bulk-index-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, on: { shown: _vm.modalShown }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
      Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "primary", disabled: _vm.itemsToIndex === 0 }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Start Bulk Index
    `)], 1)];
  }, "fn") }]) }, [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
    There are ` + _vm._s(_vm.itemsToIndex) + " items enqueued which were added before "), _c("date-display", { attrs: { humanise: !1, value: _vm.date, "show-time": !1 } }), _vm._v(" "), _c("br"), _vm._v(" "), _vm.itemsToIndex > 0 ? _c("span", [_vm._v(`
      Are you sure you want to index ` + _vm._s(_vm.itemsToIndex) + ` item records?
      `), _c("br"), _vm._v(`
      These items will be sent to the system recycling bin (if enabled). Otherwise, this process cannot be reversed.
    `)]) : _vm._e()], 1)], 1);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  ConfirmBulkIndexItemsModal,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  null
);
const ConfirmBulkIndexModal = __component__$4.exports;
var __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$3"), _a11;
let AdministrationIndexingBulkIndexComponent = (_a11 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !0);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "runningOperating", null);
    __publicField(this, "isRunning", !1);
    __publicField(this, "olderThan", null);
    __publicField(this, "itemsLeftToIndex", 0);
    __publicField(this, "itemsToIndex", 0);
    __publicField(this, "confirmCancel", !1);
    __publicField(this, "datepicker", null);
  }
  async mounted() {
    let info = await new AdministrationIndexingBulkIndexClient(new Transformer(), baseUrl()).bulkIndexRunningInfo();
    this.isRunning = info.isRunning, this.runningOperating = info.operation, info.olderThanDate && (this.olderThan = Moment(info.olderThanDate).format("yyyy-MM-DD")), this.isRunning && info.operation == "Bulk Index" ? (toastr.success("Bulk index is currently running"), this.reloadTimer = setInterval(() => this.refresh(), 1e4), await this.refresh()) : this.isRunning && (toastr.warning("Please wait for the current bulk operation completes", "Another bulk operation is running"), this.reloadTimer = setInterval(() => this.refresh(), 1e4), await this.refresh()), this.setDatepickerSettings();
  }
  setDatepickerSettings() {
    this.datepicker = $("#bulk .input-group.date"), this.datepicker.datepicker({
      todayHighlight: !0,
      orientation: "bottom left",
      endDate: /* @__PURE__ */ new Date(),
      autoclose: !0,
      forceParse: !1,
      format: "yyyy-mm-dd"
    }).on("changeDate", (e) => {
      this.olderThan = e.format();
    });
  }
  async showConfigureSyncModal() {
    this.itemsToIndex = await new AdministrationIndexingBulkIndexClient(new Transformer(), baseUrl()).checkBulkIndexCount(this.olderThan), this.$bvModal.show("confirm-bulk-index-modal");
  }
  async startBulkIndex() {
    await new AdministrationIndexingBulkIndexClient(new Transformer(), baseUrl()).startIndexingBulkIndex(this.olderThan), toastr.info("Indexing bulk index has started"), this.refresh(), this.reloadTimer = setInterval(() => this.refresh(), 1e3);
  }
  async cancelBulkIndex() {
    if (!this.isRunning)
      return;
    await new AdministrationIndexingBulkIndexClient(new Transformer(), baseUrl()).cancelIndexingBulkIndex() ? (toastr.success("Indexing bulk index has been cancelled"), this.reloadTimer && clearTimeout(this.reloadTimer)) : toastr.error("Unable to cancel bulk indexing job"), this.refresh(), this.confirmCancel = !1;
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer), this.loading = !1;
  }
  async refresh() {
    try {
      let info = await new AdministrationIndexingBulkIndexClient(new Transformer(), baseUrl()).bulkIndexRunningInfo();
      this.isRunning = info.isRunning, this.runningOperating = info.operation, this.isRunning && this.olderThan ? (this.itemsLeftToIndex = await new AdministrationIndexingBulkIndexClient(new Transformer(), baseUrl()).checkBulkIndexCount(this.olderThan), this.itemsToIndex == 0 && (this.itemsToIndex = this.itemsLeftToIndex)) : !this.isRunning && info.operation == "Bulk Index" ? (toastr.success("Indexing bulk index finished"), clearTimeout(this.reloadTimer)) : this.isRunning || (toastr.success("The other bulk operation has completed"), clearTimeout(this.reloadTimer));
    } finally {
      this.loading = !1;
    }
  }
}, __name(_a11, "AdministrationIndexingBulkIndexComponent"), _a11);
AdministrationIndexingBulkIndexComponent = __decorateClass$3([
  Component({ components: { ConfirmBulkIndexModal } })
], AdministrationIndexingBulkIndexComponent);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-alert", { attrs: { show: "", variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" "), _c("strong", [_vm._v("Preview Feature!")]), _c("br"), _c("span", [_vm._v("This feature is currently in preview. Please take a backup copy of the databases before running the bulk index.")])], 1), _vm._v(" "), _c("b-card", { scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("span", { staticClass: "align-middle" }, [_c("font-awesome-icon", { attrs: { icon: "box-check" } }), _vm._v(`
              Bulk Index
            `)], 1)])];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-row", [_c("b-col", { attrs: { cols: "12" } }, [_c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
            Bulk Index will allow you to remove old items which are still enqueued in the system which are older than a certain date.
            Doing so will Index these items, sending them to the recycling bin (if enabled) or deleting them.
          `)], 1)], 1)], 1), _vm._v(" "), _c("b-row", { attrs: { id: "bulk" } }, [_c("b-col", { attrs: { md: "6", lg: "4", cols: "12" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Bulk Index Items Before")]), _vm._v(" "), _c("b-input-group", { staticClass: "mb-2 date", scopedSlots: _vm._u([{ key: "append", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "calendar" } })], 1)];
  }, "fn"), proxy: !0 }]) }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.olderThan, expression: "olderThan" }], staticClass: "form-control", attrs: { type: "text", id: "olderThanDatePicker", placeholder: "Select a date...", disabled: _vm.isRunning, autocomplete: "off" }, domProps: { value: _vm.olderThan }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.olderThan = $event.target.value);
  }, "input") } })]), _vm._v(" "), _c("b-form-text", { attrs: { id: "password-help-block" } }, [_vm._v(`
              Any items added before and including this date will be indexed
            `)]), _vm._v(" "), _c("b-button", { staticClass: "mr-1 float-right", attrs: { variant: "outline-primary", disabled: !_vm.olderThan || _vm.isRunning }, on: { click: _vm.showConfigureSyncModal } }, [_c("span", [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Generate bulk index report")], 1)])], 1)], 1), _vm._v(" "), _vm.isRunning && _vm.runningOperating == "Bulk Index" ? _c("div", { staticClass: "mt-2" }, [_c("hr"), _vm._v(" "), _c("span", { staticClass: "float-right" }, [_vm.confirmCancel ? _c("span", [_c("b-button", { attrs: { variant: "danger", size: "sm" }, on: { click: _vm.cancelBulkIndex } }, [_c("font-awesome-icon", { attrs: { icon: "x" } }), _vm._v(` Confirm
                      `)], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.confirmCancel = !1;
  }, "click") } }, [_vm._v(`
                      Cancel
                  `)])], 1) : _c("span", [_c("b-button", { attrs: { variant: "danger", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.confirmCancel = !0;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "x" } }), _vm._v(`
                      Cancel Bulk Index
                  `)], 1)], 1)]), _vm._v(" "), _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Bulk indexing items...")])], 1), _vm._v(" "), _c("b-progress", { attrs: { value: _vm.itemsToIndex - _vm.itemsLeftToIndex, max: _vm.itemsToIndex, "show-progress": "", animated: "" } }, [_c("b-progress-bar", { staticStyle: { "min-width": "100px" }, attrs: { value: _vm.itemsToIndex - _vm.itemsLeftToIndex } }, [_vm._v(`
              ` + _vm._s(_vm.itemsToIndex - _vm.itemsLeftToIndex) + "/" + _vm._s(_vm.itemsToIndex) + `
            `)])], 1)], 1) : _vm._e()], 1), _vm._v(" "), _c("confirm-bulk-index-modal", { attrs: { olderThanDate: _vm.olderThan, "items-to-index": _vm.itemsToIndex }, on: { confirm: _vm.startBulkIndex } })], 1);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  AdministrationIndexingBulkIndexComponent,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const IndexingBulkIndexComponent = __component__$3.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$2"), _a12;
let ConfirmActionQueueModal$1 = (_a12 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "queueName");
    __publicField(this, "action");
  }
  confirm() {
    this.$bvModal.hide("confirm-action-modal"), this.$emit("confirm");
  }
  get modalTitle() {
    return this.$options.filters.capitaliseFirstLetter(this.action ?? "") + " " + this.queueName;
  }
}, __name(_a12, "ConfirmActionQueueModal"), _a12);
__decorateClass$2([
  Prop({ required: !0 })
], ConfirmActionQueueModal$1.prototype, "queueName", 2);
__decorateClass$2([
  Prop({ required: !0 })
], ConfirmActionQueueModal$1.prototype, "action", 2);
ConfirmActionQueueModal$1 = __decorateClass$2([
  Component({})
], ConfirmActionQueueModal$1);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "confirm-action-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
      Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "success" }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(` Confirm
    `)], 1)];
  }, "fn") }]) }, [_c("div", [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`  Are you sure you want to 
          ` + _vm._s(_vm.$options.filters.capitaliseFirstLetter(_vm.action ?? "")) + ` the selected Queue(s)?
      `)], 1)], 1)]);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  ConfirmActionQueueModal$1,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  null
);
const ConfirmActionQueueModal = __component__$2.exports;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$1"), _a13;
let AdministrationIndexQueueListComponent = (_a13 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model", null);
    __publicField(this, "loading", !0);
    __publicField(this, "page", 1);
    __publicField(this, "pageSize", 50);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "queueToAction", null);
    __publicField(this, "queueToActionName", null);
    __publicField(this, "queueAction", null);
    __publicField(this, "indexingPages", []);
    __publicField(this, "filterModel", { pageId: null, sort: {} });
    __publicField(this, "selectedQueueIds", []);
    __publicField(this, "searchQueuesDebounce", _.debounce(function() {
      this.getQueues(!0);
    }, 500));
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.getQueues(!1), 3e4), await this.getIndexingPages(), await this.getQueues(!0);
  }
  get pageNumber() {
    return this.page;
  }
  set pageNumber(value) {
    this.page = value, this.getQueues(!0);
  }
  get sort() {
    let sort = this.filterModel.sort;
    return sort || null;
  }
  set sort(sort) {
    this.filterModel.sort = sort, this.getQueues(!0);
  }
  getQueueUrl(queueId) {
    return new URL(baseUrl() + "/app/indexing/queues/" + queueId + "/list").href;
  }
  isQueueSelected(queue) {
    var _a15;
    return (_a15 = this.selectedQueueIds) == null ? void 0 : _a15.includes(queue.queueId);
  }
  get selectedItems() {
    return this.selectedQueueIds;
  }
  set selectedItems(value) {
    this.selectedQueueIds = value;
  }
  get partiallySelectedItems() {
    var _a15;
    return ((_a15 = this.selectedQueueIds) == null ? void 0 : _a15.length) > 0 && this.selectedQueueIds.length < this.model.results.length;
  }
  toggleQueueSelected(queue) {
    var _a15;
    ((_a15 = this.selectedQueueIds) == null ? void 0 : _a15.find((x) => x == queue.queueId)) ? this.selectedQueueIds = this.selectedQueueIds.filter((x) => x != queue.queueId) : this.selectedQueueIds = this.selectedQueueIds.concat([queue.queueId]);
  }
  toggleAllItemsSelected() {
    var _a15;
    ((_a15 = this.selectedQueueIds) == null ? void 0 : _a15.length) == 0 ? this.selectedQueueIds = this.model.results.map((x) => x.queueId) : this.selectedQueueIds = [];
  }
  getStatusBadge(status) {
    switch (status) {
      case "Closed":
        return "badge-danger";
      case "Open":
        return "badge-success";
      case "Suspended":
        return "badge-warning";
    }
  }
  cleanSelected() {
    this.selectedQueueIds.length && (this.selectedQueueIds = this.selectedQueueIds.filter((y) => this.model.results.some((x) => x.queueId == y)));
  }
  async getIndexingPages() {
    let pages;
    try {
      pages = await new AdministrationAppsClient(new Transformer(), baseUrl()).getFieldedPages();
    } catch (e) {
      toastr.error(e, "Failed to get pages");
    }
    pages = pages.filter((p) => p.type === PageType.RIA), this.indexingPages = pages;
  }
  get pageOptions() {
    let pageOptions = [{ value: null, text: "All" }];
    return this.indexingPages.forEach((page) => {
      pageOptions.push({ value: page.id, text: page.name });
    }), pageOptions;
  }
  async getQueues(setLoading) {
    this.loading = setLoading;
    try {
      let managementClient = new AdministrationIndexingQueueManagementClient(new Transformer(), baseUrl());
      this.model = await managementClient.getQueues(this.filterModel, this.pageSize, this.page), this.cleanSelected();
    } catch (ex) {
      toastr.error(ex, "An error occurred when retrieving queues");
    } finally {
      this.loading = !1;
    }
  }
  async confirmQueueAction() {
    if (this.queueToAction == null && this.selectedQueueIds.length) {
      await this.actionQueues();
      return;
    }
    this.queueToAction && await this.actionQueue();
  }
  setQueueToAction(action, queue) {
    this.queueToAction = queue, this.queueToActionName = "'" + queue.queueName + "'", this.queueAction = action, this.$bvModal.show("confirm-action-modal");
  }
  setQueuesToAction(action) {
    this.queueToActionName = this.selectedQueueIds.length + " Queues", this.queueAction = action, this.$bvModal.show("confirm-action-modal");
  }
  async actionQueue() {
    this.loading = !0;
    try {
      let result = await new AdministrationIndexingQueueManagementClient(new Transformer(), baseUrl()).actionQueue(this.queueToAction.queueId, this.queueAction);
      result.success ? toastr.success("The queue has been successfully actioned") : toastr.warning(result.response);
    } catch (ex) {
      toastr.error(ex, "An error occurred attempting to action the queue");
    } finally {
      this.queueToAction = null, this.queueAction = null, this.queueToActionName = null, this.getQueues(!0);
    }
  }
  async actionQueues() {
    this.loading = !0;
    try {
      let result = await new AdministrationIndexingQueueManagementClient(new Transformer(), baseUrl()).actionQueues(this.selectedQueueIds, this.queueAction);
      result.success ? (toastr.success("The queues have been successfully actioned"), this.selectedQueueIds = [], this.queueToActionName = null) : toastr.warning(result.response);
    } catch (ex) {
      toastr.error(ex, "An error occurred attempting to action the queues");
    } finally {
      await this.getQueues(!0);
    }
  }
  get searchFilter() {
    return this.filterModel.search;
  }
  set searchFilter(value) {
    this.filterModel.search = value, this.searchQueuesDebounce();
  }
  get pageIdFilter() {
    return this.filterModel.pageId;
  }
  set pageIdFilter(value) {
    this.filterModel.pageId = value, this.getQueues(!0);
  }
  get totalPages() {
    if (this.model)
      return Math.ceil(this.model.count / this.pageSize);
  }
  get tableFields() {
    return [
      { key: "select", label: "", sortable: !1 },
      { key: "pageName", label: "Page", sortable: !1 },
      { key: "queueName", label: "Name", sortable: !1 },
      { key: "queueType", lable: "Queue", sortable: !0 },
      { key: "status", lable: "Status", sortable: !1 },
      { key: "itemCount", lable: "Item Count", sortable: !1 },
      { key: "actions", label: "", sortable: !1 }
    ];
  }
}, __name(_a13, "AdministrationIndexQueueListComponent"), _a13);
AdministrationIndexQueueListComponent = __decorateClass$1([
  Component({
    components: { DateDisplay, PaginationControls, SortableHeaderLink, ConfirmActionQueueModal },
    methods: { baseUrl }
  })
], AdministrationIndexQueueListComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "list-ul" } }), _vm._v(`
          Queue Management
          `), _c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.getQueues(!0);
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)])], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-form-group", { staticClass: "mb-0" }, [_c("b-input-group", { attrs: { size: "sm" } }, [_c("b-form-input", { staticClass: "noAppendedBorder", attrs: { id: "filter-input", type: "search", placeholder: "Filter Queue Name...", autocomplete: "off" }, model: { value: _vm.searchFilter, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.searchFilter = $$v;
  }, "callback"), expression: "searchFilter" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-input-group-text", { staticClass: "onlyBorderLeft" }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)], 1)], 1)], 1), _vm._v(" "), _vm.model ? _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.model.results, striped: "", busy: _vm.loading, "show-empty": "", emptyText: "No queues could be found", "thead-class": "b-table-align-th-middle" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "head(select)", fn: /* @__PURE__ */ __name(function(row) {
    var _a15;
    return [_c("b-checkbox", { attrs: { indeterminate: _vm.partiallySelectedItems, checked: !!((_a15 = _vm.selectedItems) != null && _a15.length) }, on: { change: _vm.toggleAllItemsSelected } })];
  }, "fn") }, { key: "head(pageName)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-form", { staticClass: "mt-1", attrs: { inline: "" } }, [_c("label", { staticClass: "mr-sm-2" }, [_vm._v(`
                    ` + _vm._s(row.label) + ` 
                    `), _c("b-form-select", { attrs: { size: "sm", options: _vm.pageOptions }, model: { value: _vm.pageIdFilter, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.pageIdFilter = $$v;
    }, "callback"), expression: "pageIdFilter" } })], 1)])];
  }, "fn") }, { key: "head(actions)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-dropdown", { directives: [{ name: "b-modal", rawName: "v-b-modal", value: "confirm-action-modal", expression: "'confirm-action-modal'" }], staticClass: "float-right", attrs: { "no-flip": "", variant: "primary", "no-caret": "", right: "", size: "sm", title: "Action Queues", disabled: !_vm.selectedQueueIds.length }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } }), _vm._v(" "), _vm.selectedQueueIds.length ? _c("span", [_vm._v("Action " + _vm._s(_vm.selectedQueueIds.length) + " Queues")]) : _vm._e()];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setQueuesToAction("resume");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "lock-open" } }), _vm._v(" Resume " + _vm._s(_vm.selectedQueueIds.length) + ` Queues
              `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setQueuesToAction("suspend");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "lock" } }), _vm._v(" Suspend " + _vm._s(_vm.selectedQueueIds.length) + ` Queues
              `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setQueuesToAction("reopen");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "recycle" } }), _vm._v(" Reopen " + _vm._s(_vm.selectedQueueIds.length) + ` Queues
              `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setQueuesToAction("close");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(" Close " + _vm._s(_vm.selectedQueueIds.length) + ` Queues
              `)], 1)], 1)];
  }, "fn") }, { key: "cell(select)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("div", { staticClass: "d-inline-flex" }, [_c("b-checkbox", { attrs: { checked: _vm.isQueueSelected(row.item), size: "sm" }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleQueueSelected(row.item);
    }, "change") } })], 1)];
  }, "fn") }, { key: "cell(queueName)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("span", { staticClass: "align-middle" }, [row.item.pageId ? _c("a", { attrs: { href: _vm.getQueueUrl(row.item.queueId), size: "sm", target: "_blank" } }, [_vm._v(`
                  ` + _vm._s(row.item.queueName) + `
                `)]) : _c("span", [_vm._v(_vm._s(row.item.queueName) + " - "), _c("span", { staticClass: "text-muted small" }, [_vm._v("No page found")])])])];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("span", { staticClass: "align-middle" }, [_c("span", { staticClass: "badge", class: _vm.getStatusBadge(row.item.status) }, [_vm._v(`
                      ` + _vm._s(row.item.status) + `
                  `)])])];
  }, "fn") }, { key: "cell(itemCount)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("span", { staticClass: "align-middle" }, [_c("span", { staticClass: "badge badge-pill badge-secondary" }, [_vm._v(`
                    ` + _vm._s(row.item.itemCount) + `
                  `)])])];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-dropdown", { staticClass: "float-right", attrs: { "no-flip": "", size: "sm", variant: "primary", "no-caret": "", right: "", disabled: _vm.selectedQueueIds.length > 0, id: row.item.queueId + "-DropDown" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "primary", disabled: row.item.status != "Suspended" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setQueueToAction("resume", row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "lock-open" } }), _vm._v(` Resume
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "danger", disabled: row.item.status != "Open" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setQueueToAction("suspend", row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "lock" } }), _vm._v(` Suspend
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "primary", disabled: row.item.status != "Closed" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setQueueToAction("reopen", row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "recycle" } }), _vm._v(` Reopen
                    `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "danger", disabled: !(row.item.status == "Open" && row.item.itemCount == 0) }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setQueueToAction("close", row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Close
                    `)], 1)], 1)];
  }, "fn") }], null, !1, 658003283) }) : _vm._e(), _vm._v(" "), _vm.model ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } }) : _vm._e()], 1), _vm._v(" "), _c("confirm-action-queue-modal", { attrs: { queueName: _vm.queueToActionName, action: _vm.queueAction }, on: { confirm: _vm.confirmQueueAction } })], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  AdministrationIndexQueueListComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "960180e9"
);
const IndexingQueueManagementComponent = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a14;
let AdministrationIndexingManagementComponent = (_a14 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "tab", null);
    __publicField(this, "tabs", [
      {
        id: "usage",
        name: "Usage",
        icon: "chart-simple",
        description: "Indexing usage graphs",
        show: !0,
        component: IndexingUsageComponent
      },
      {
        id: "preProcessor",
        name: "Pre-Processing",
        icon: "sign-in",
        description: "List of Pre-Processors",
        show: !0,
        component: PreProcessorComponent
      },
      {
        id: "processor",
        name: "Processing",
        icon: "sign-out",
        description: "List of Processors",
        show: !0,
        component: ProcessorComponent
      },
      {
        id: "queueManagement",
        name: "Queue Management",
        icon: "list-ul",
        description: "View and manage all RIA queues",
        show: !0,
        component: IndexingQueueManagementComponent
      },
      {
        id: "recycledItems",
        name: "Recycled Items",
        icon: "recycle",
        description: "List of items in the recycling",
        show: !0,
        component: RecycledItemsComponent
      },
      {
        id: "bulkIndex",
        name: "Bulk Index",
        icon: "box-check",
        description: "Index old items in the system",
        show: !0,
        component: IndexingBulkIndexComponent
      },
      {
        id: "cleanup",
        name: "Cleanup",
        icon: "broom",
        description: "Delete old records for indexed items",
        show: !0,
        component: IndexingCleanupComponent
      }
    ]);
  }
  async mounted() {
    var hasUsage = await userHasPermission("adminActions.indexingManagement.usage");
    hasUsage || (this.tabs = this.tabs.filter((y) => y.id != "usage"));
    var hasRecycling = await userHasPermission("adminActions.indexingManagement.recycling");
    hasRecycling || (this.tabs = this.tabs.filter((y) => y.id != "recycledItems"));
    var hasPreProcessing = await userHasPermission("adminActions.indexingManagement.preProcessing");
    hasPreProcessing || (this.tabs = this.tabs.filter((y) => y.id != "preProcessor"));
    var hasProcessing = await userHasPermission("adminActions.indexingManagement.processing");
    hasProcessing || (this.tabs = this.tabs.filter((y) => y.id != "processor"));
    var hasQueueManagement = await userHasPermission("adminActions.indexingManagement.queueManagement");
    hasQueueManagement || (this.tabs = this.tabs.filter((y) => y.id != "queueManagement"));
    var hasCleanup = await userIsSuperAdmin();
    hasCleanup || (this.tabs = this.tabs.filter((y) => y.id != "cleanup"), this.tabs = this.tabs.filter((y) => y.id != "bulkIndex"));
  }
  get activeTab() {
    return this.tab ? this.tab : (this.tabs.find((t) => t.show) || { id: null }).id;
  }
  selectTab(tabId) {
    this.tabs.find((t) => t.id === tabId && t.show) && (this.tab = tabId);
  }
}, __name(_a14, "AdministrationIndexingManagementComponent"), _a14);
AdministrationIndexingManagementComponent = __decorateClass([
  Component({
    components: {
      PreProcessorComponent,
      ProcessorComponent,
      IndexingUsageComponent,
      RecycledItemsComponent,
      IndexingCleanupComponent,
      IndexingBulkIndexComponent,
      IndexingQueueManagementComponent
    }
  })
], AdministrationIndexingManagementComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "clipboard-list" } }), _vm._v(`
          Indexing Management
        `)], 1)]), _vm._v(" "), _c("div", [_c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs", attrs: { id: "myTab", role: "tablist" } }, _vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item" }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab === tab.id }, attrs: { id: tab.id + "Tab", "data-toggle": "tab", role: "tab", "aria-selected": "true" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(" " + _vm._s(tab.name) + `
                    `)], 1)]);
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_c("div", { staticClass: "container-fluid" }, [_vm.activeTab === "processor" ? _c("processor-component") : _vm._e(), _vm._v(" "), _vm.activeTab === "preProcessor" ? _c("pre-processor-component") : _vm._e(), _vm._v(" "), _vm.activeTab === "queueManagement" ? _c("indexing-queue-management-component") : _vm._e(), _vm._v(" "), _vm.activeTab === "usage" ? _c("indexing-usage-component") : _vm._e(), _vm._v(" "), _vm.activeTab === "recycledItems" ? _c("recycled-items-component") : _vm._e(), _vm._v(" "), _vm.activeTab === "cleanup" ? _c("indexing-cleanup-component") : _vm._e(), _vm._v(" "), _vm.activeTab === "bulkIndex" ? _c("indexing-bulk-index-component") : _vm._e()], 1)])])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationIndexingManagementComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "7e3fba36"
);
const index = __component__.exports;
export {
  index as default
};
