var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, ah as AdministrationLogsClient, T as Transformer, b as baseUrl, t as toastr, ai as LogLevel, C as Component, n as normalizeComponent, aj as AdministrationUserAuditClient, _, E as ErrorPanel, ak as AdministrationEmailLogClient, al as AdministrationIndexingLogsClient, a0 as userHasPermission, L as LoadingBarComponent } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
var __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$4"), _a;
let LogsListComponent$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "logsLoading", !0);
    __publicField(this, "logs", []);
    __publicField(this, "downloading", !1);
    __publicField(this, "level", null);
    __publicField(this, "levelLoading", !1);
    __publicField(this, "levelOptions", [
      {
        id: LogLevel.Debug,
        icon: "bug",
        name: "Debug"
      },
      {
        id: LogLevel.Information,
        icon: "info-circle",
        name: "Information"
      },
      {
        id: LogLevel.Warning,
        icon: "exclamation-triangle",
        name: "Warning"
      }
    ]);
  }
  async mounted() {
    await this.loadLevel(), new AdministrationLogsClient(new Transformer(), baseUrl()).getLogs().then((model) => {
      this.auditLogs = model, this.logsLoading = !1;
    });
  }
  get auditLogs() {
    return this.logs;
  }
  set auditLogs(value) {
    this.logs = value;
  }
  get logUrl() {
    return (log) => {
      let uri = new URL(baseUrl() + "/api/administration/logs/local/log");
      return uri.searchParams.append("logName", log.name), uri.href;
    };
  }
  downloadLog(logName) {
    this.downloading = !0, new AdministrationLogsClient(new Transformer(), baseUrl()).getLog(logName).then((model) => {
    }).catch((e) => {
    }).finally(() => {
      this.downloading = !1;
    });
  }
  async loadLevel() {
    this.levelLoading = !0;
    try {
      this.level = await new AdministrationLogsClient(new Transformer(), baseUrl()).getVerbosity();
    } finally {
      this.levelLoading = !1;
    }
  }
  async setLevel(level) {
    try {
      await new AdministrationLogsClient(new Transformer(), baseUrl()).setVerbosity(level), this.level = level, toastr.success("The logging level has been successfully updated to " + level);
    } catch (e) {
      throw toastr.error("Failed to set log level"), e;
    }
  }
}, __name(_a, "LogsListComponent"), _a);
LogsListComponent$1 = __decorateClass$4([
  Component({
    components: { ReactiveDropdown, DateDisplay }
  })
], LogsListComponent$1);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-sm-12" }, [_c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "logLevel" } }, [_vm._v("Logging level")]), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { value: _vm.level, options: _vm.levelOptions, loading: _vm.levelLoading, id: "logLevel" }, on: { input: _vm.setLevel } }), _vm._v(" "), _c("p", { staticClass: "form-text text-muted", attrs: { id: "loggingHelpBlock" } }, [_vm.level === "debug" ? [_vm._v("Debug logs show very detailed information, typically of interest only when diagnosing problems.")] : _vm._e(), _vm._v(" "), _vm.level === "information" ? [_vm._v("Information logs are confirmation that things are working as expected.")] : _vm._e(), _vm._v(" "), _vm.level === "warning" ? [_vm._v("Warning logs show an indication that something unexpected happened. The software is still working as expected.")] : _vm._e()], 2)], 1)])]), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("h4", [_vm._v("Local Logs - "), _c("small", { staticClass: "text-muted" }, [_vm._v(_vm._s(_vm.logs.length) + " log file"), _vm.logs.length > 1 ? _c("span", [_vm._v("s")]) : _vm._e()])])])]), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-sm-12 col-lg-8 col-xl-6" }, [_vm.logsLoading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", { staticClass: "table-responsive" }, [_vm.logs && _vm.logs.length > 0 ? _c("table", { staticClass: "table table-striped" }, [_c("thead", [_c("tr", [_c("th", { attrs: { scope: "col" } }, [_c("font-awesome-icon", { attrs: { icon: "file-alt" } }), _vm._v(` Log File
                        `)], 1), _vm._v(" "), _c("th", { attrs: { scope: "col" } }, [_c("font-awesome-icon", { attrs: { icon: "hdd" } }), _vm._v(` Size
                        `)], 1), _vm._v(" "), _c("th", { attrs: { scope: "col" } }, [_c("font-awesome-icon", { attrs: { icon: "calendar" } }), _vm._v(` Last modified
                        `)], 1), _vm._v(" "), _c("th", { attrs: { scope: "col float-right" } }, [_vm._v(" ")])])]), _vm._v(" "), _c("tbody", _vm._l(_vm.logs, function(log) {
    return _c("tr", { key: log.lastModified }, [_c("td", [_vm._v(_vm._s(log.name))]), _vm._v(" "), _c("td", [_vm._v(_vm._s(log.size))]), _vm._v(" "), _c("td", [_c("date-display", { attrs: { value: log.lastModified } })], 1), _vm._v(" "), _c("td", [_c("a", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-default btn-sm mr-2 float-right", class: { disabled: _vm.downloading }, attrs: { href: _vm.logUrl(log), title: "Download log file", disabled: _vm.downloading } }, [_c("font-awesome-icon", { attrs: { icon: "download" } })], 1)])]);
  }), 0)]) : _vm._e()])])])]);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  LogsListComponent$1,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  "b48a9233"
);
const LogsListComponent = __component__$4.exports;
var __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$3"), _a2;
let UserLoginLogs$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "rowDetailIds", []);
    __publicField(this, "pageNumber", 1);
    __publicField(this, "pageSize", 50);
    __publicField(this, "filter", {
      term: null,
      sort: {}
    });
    __publicField(this, "loading", !1);
    __publicField(this, "pages", 0);
    __publicField(this, "logs", []);
    __publicField(this, "searchLogsDebounce", _.debounce(function() {
      this.getLogs();
    }, 300));
  }
  async mounted() {
    await this.getLogs(!0);
  }
  get sort() {
    let sort = this.filter.sort;
    return sort || null;
  }
  set sort(sort) {
    this.filter.sort = sort, this.getLogs();
  }
  getActionIcon(action) {
    switch (action) {
      case "Login":
        return "sign-in";
      case "Logout":
        return "sign-out";
      default:
        return "";
    }
  }
  getStatusVariant(status) {
    switch (status) {
      case "Success":
        return "success";
      case "Failed":
        return "danger";
      default:
        return "secondary";
    }
  }
  getStatusIcon(status) {
    switch (status) {
      case "Success":
        return "check";
      case "Failed":
        return "times";
      default:
        return "";
    }
  }
  async getLogs(setLoading = !1) {
    let sortValue = null;
    this.filter.sort && this.filter.sort.by && (sortValue = (this.filter.sort.descending ? "-" : "+") + this.filter.sort.by), this.loading = setLoading;
    let model = await new AdministrationUserAuditClient(new Transformer(), baseUrl()).getUserLogs(
      this.filter.term,
      sortValue,
      this.pageSize,
      this.pageNumber
    );
    this.loading = !1, this.logs = model.logs, this.pages = Math.ceil(model.totalCount / model.pageSize);
  }
  get filterText() {
    return this.filter.term;
  }
  set filterText(value) {
    this.filter.term = value, this.searchLogsDebounce();
  }
  async changePage(page) {
    this.pageNumber = page, await this.getLogs();
  }
  get tableFields() {
    return [
      { key: "username", tdClass: "align-middle" },
      { key: "action", tdClass: "align-middle" },
      { key: "status", tdClass: "align-middle" },
      { key: "loginDateTime", tdClass: "align-middle" },
      { key: "userInfo", label: "", tdClass: "align-middle" }
    ];
  }
  toggleRowDetails(row) {
    row.toggleDetails(), this.rowDetailIds.includes(row.item.id) ? this.rowDetailIds = this.rowDetailIds.filter(function(i) {
      return i !== row.item.id;
    }) : this.rowDetailIds.push(row.item.id);
  }
}, __name(_a2, "UserLoginLogs"), _a2);
UserLoginLogs$1 = __decorateClass$3([
  Component({
    components: { SortableHeaderLink, ErrorPanel, PaginationControls, DateDisplay }
  })
], UserLoginLogs$1);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [!_vm.logs || _vm.loading ? [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)] : _vm._e(), _vm._v(" "), [_c("b-row", { staticClass: "mb-2" }, [_c("b-col", [_c("b-input-group", [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1), _vm._v(" "), _c("b-input", { attrs: { placeholder: "Filter...", id: "searchFilterText" }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1)], 1), _vm._v(" "), _c("b-col", [_c("b-button", { staticClass: "float-right rounded-pill mt-1", attrs: { size: "sm", variant: "outline-primary" }, on: { click: _vm.getLogs } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(` Refresh
                  `)], 1)], 1)], 1), _vm._v(" "), _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.logs, striped: "", busy: _vm.loading, "details-td-class": "pt-0 pb-2", "sort-icon-left": "", "show-empty": "", emptyText: "No logs found", "thead-class": "pl-0", tdClass: "align-middle" }, scopedSlots: _vm._u([{ key: "head(username)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
                        User
                    `)];
  }, "fn") }, { key: "head(action)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "action", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "status", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(loginDateTime)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "loginDateTime", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "cell(username)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.email && row.item.username ? _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: row.item.username } }, [_vm._v(`
                          ` + _vm._s(row.item.email) + `
                        `)]) : _c("span", [_vm._v(`
                          ` + _vm._s(row.item.username) + `
                        `)])];
  }, "fn") }, { key: "cell(action)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("font-awesome-icon", { attrs: { icon: _vm.getActionIcon(row.item.action) } }), _vm._v(`
                      ` + _vm._s(row.item.action) + `
                    `)];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-badge", { attrs: { pill: "", variant: _vm.getStatusVariant(row.item.status) } }, [_c("font-awesome-icon", { attrs: { icon: _vm.getStatusIcon(row.item.status) } }), _vm._v(`
                        ` + _vm._s(row.item.status) + `
                      `)], 1)];
  }, "fn") }, { key: "cell(loginDateTime)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.loginDateTime } })];
  }, "fn") }, { key: "cell(userInfo)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "float-right", attrs: { variant: "link", size: "sm", title: "Show User Info" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleRowDetails(row);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: row.detailsShowing ? "caret-down" : "caret-right" } })], 1)];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-card", [_c("dl", [_c("dt", { staticClass: "col-sm-4" }, [_vm._v("Username")]), _vm._v(" "), _c("dd", { staticClass: "col-sm-8" }, [_vm._v(_vm._s(row.item.username))]), _vm._v(" "), _c("dt", { staticClass: "col-sm-4" }, [_vm._v("IP Address")]), _vm._v(" "), _c("dd", { staticClass: "col-sm-8" }, [_vm._v(_vm._s(row.item.ipAddress))]), _vm._v(" "), _c("dt", { staticClass: "col-sm-4" }, [_vm._v("User Agent")]), _vm._v(" "), _c("dd", { staticClass: "col-sm-8" }, [_vm._v(_vm._s(row.item.userAgent))])])])];
  }, "fn") }]) }), _vm._v(" "), _c("div", { staticClass: "text-center" }, [_vm.filter ? _c("pagination-controls", { attrs: { count: _vm.pages, value: _vm.pageNumber }, on: { input: _vm.changePage } }) : _vm._e()], 1)]], 2)])]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  UserLoginLogs$1,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const UserLogsComponent = __component__$3.exports;
var __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$2"), _a3;
let UserLoginLogs = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "pageNumber", 1);
    __publicField(this, "pageSize", 50);
    __publicField(this, "filter", {
      term: null,
      sort: {}
    });
    __publicField(this, "loading", !1);
    __publicField(this, "pages", 0);
    __publicField(this, "logs", []);
    __publicField(this, "searchLogsDebounce", _.debounce(function() {
      this.getLogs();
    }, 300));
  }
  async mounted() {
    await this.getLogs(!0);
  }
  get sort() {
    let sort = this.filter.sort;
    return sort || null;
  }
  set sort(sort) {
    this.filter.sort = sort, this.getLogs();
  }
  async getLogs(setLoading = !1) {
    let sortValue = null;
    this.filter.sort && this.filter.sort.by && (sortValue = (this.filter.sort.descending ? "-" : "+") + this.filter.sort.by), this.loading = setLoading;
    let model = await new AdministrationEmailLogClient(new Transformer(), baseUrl()).getEmailLogs(
      this.filter.term,
      sortValue,
      this.pageSize,
      this.pageNumber
    );
    this.loading = !1, this.logs = model.logs, this.pages = Math.ceil(model.totalCount / model.pageSize);
  }
  get filterText() {
    return this.filter.term;
  }
  set filterText(value) {
    this.filter.term = value, this.searchLogsDebounce();
  }
  async changePage(page) {
    this.pageNumber = page, await this.getLogs();
  }
  get tableFields() {
    return [
      { key: "source", tdClass: "align-middle" },
      { key: "to", tdClass: "align-middle" },
      { key: "from", tdClass: "align-middle" },
      { key: "cc", tdClass: "align-middle" },
      { key: "subject", tdClass: "align-middle" },
      { key: "success", tdClass: "align-middle", label: "" },
      { key: "response", tdClass: "align-middle" },
      { key: "created", tdClass: "align-middle" }
    ];
  }
}, __name(_a3, "UserLoginLogs"), _a3);
UserLoginLogs = __decorateClass$2([
  Component({
    components: { SortableHeaderLink, ErrorPanel, PaginationControls, DateDisplay }
  })
], UserLoginLogs);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [!_vm.logs || _vm.loading ? [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)] : _vm._e(), _vm._v(" "), [_c("b-row", { staticClass: "mb-2" }, [_c("b-col", [_c("b-input-group", [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1), _vm._v(" "), _c("b-input", { attrs: { placeholder: "Filter...", id: "searchFilterText" }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1)], 1), _vm._v(" "), _c("b-col", [_c("b-button", { staticClass: "float-right rounded-pill mt-1", attrs: { size: "sm", variant: "outline-primary" }, on: { click: _vm.getLogs } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(` Refresh
                  `)], 1)], 1)], 1), _vm._v(" "), _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.logs, striped: "", busy: _vm.loading, "details-td-class": "pt-0 pb-2", "sort-icon-left": "", "show-empty": "", emptyText: "No logs found", "thead-class": "pl-0", tdClass: "align-middle" }, scopedSlots: _vm._u([{ key: "head(source)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "source", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(sourceId)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "sourceId", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(to)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "to", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(from)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "from", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(cc)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "cc", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(subject)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "subject", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(response)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "response", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(created)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "created", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "cell(success)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.success ? _c("span", { staticClass: "text-success" }, [_c("font-awesome-icon", { attrs: { icon: "check" } })], 1) : _c("span", { staticClass: "text-danger" }, [_c("font-awesome-icon", { attrs: { icon: "xmark" } })], 1)];
  }, "fn") }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.created } })];
  }, "fn") }]) }), _vm._v(" "), _c("div", { staticClass: "text-center" }, [_vm.filter ? _c("pagination-controls", { attrs: { count: _vm.pages, value: _vm.pageNumber }, on: { input: _vm.changePage } }) : _vm._e()], 1)]], 2)])]);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  UserLoginLogs,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  null
);
const EmailLogsComponent = __component__$2.exports;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$1"), _a4;
let IndexingImportLogsComponent$1 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !0);
    __publicField(this, "loadingImports", !0);
    __publicField(this, "loadingLogs", !0);
    __publicField(this, "selectedPageId", "");
    __publicField(this, "importPages", []);
    __publicField(this, "selectedImportId", "");
    __publicField(this, "importLogInfoModels", []);
    __publicField(this, "logs", []);
    __publicField(this, "client", new AdministrationIndexingLogsClient(new Transformer(), baseUrl()));
  }
  async mounted() {
    this.loading = !0, this.importPages = await this.client.getPages(), this.loading = !1;
  }
  async selectPage(page) {
    if (this.selectedPageId != page.id) {
      this.selectedPageId = page.id, this.selectedImportId = "", this.loadingImports = !0, this.logs = [];
      try {
        this.importLogInfoModels = await this.client.getImports(page.id);
      } finally {
        this.loadingImports = !1;
      }
    }
  }
  async selectImportJobs(importLogInfoModel) {
    if (this.selectedImportId != importLogInfoModel.id) {
      this.selectedImportId = importLogInfoModel.id, this.loadingLogs = !0;
      try {
        this.logs = await this.client.getLogs(this.selectedPageId, importLogInfoModel.id);
      } finally {
        this.loadingLogs = !1;
      }
    }
  }
  get tableFields() {
    return [
      { key: "name", tdClass: "align-middle" },
      { key: "size", tdClass: "align-middle" },
      { key: "lastModified", label: "Last Modified", tdClass: "align-middle" },
      { key: "actions", label: "" }
    ];
  }
  get logUrl() {
    return (log) => {
      let uri = new URL(baseUrl() + "/api/administration/logs/indexing/page/import/log");
      return uri.searchParams.append("pageId", this.selectedPageId), uri.searchParams.append("importId", this.selectedImportId), uri.searchParams.append("logName", log.name), uri.href;
    };
  }
}, __name(_a4, "IndexingImportLogsComponent"), _a4);
IndexingImportLogsComponent$1 = __decorateClass$1([
  Component({
    components: { DateDisplay }
  })
], IndexingImportLogsComponent$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_vm._m(0), _vm._v(" "), _c("b-row", [_c("b-alert", { attrs: { show: !_vm.importPages || _vm.importPages.length === 0, variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
        There are currently no import logs.
    `)], 1), _vm._v(" "), _c("b-col", { attrs: { cols: "2" } }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading Pages...")])], 1) : _c("b-list-group", _vm._l(_vm.importPages, function(page) {
    return _c("b-list-group-item", { staticClass: "align-middle", attrs: { button: "", active: _vm.selectedPageId === page.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.selectPage(page);
    }, "click") } }, [_c("h5", [_vm._v(`
                ` + _vm._s(page.name) + `
                `)])]);
  }), 1)], 1), _vm._v(" "), _c("b-col", { attrs: { cols: "2" } }, [_vm.loadingImports ? _vm.selectedPageId ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading Configurations...")])], 1) : _vm._e() : _c("b-list-group", _vm._l(_vm.importLogInfoModels, function(importConfigs) {
    return _c("b-list-group-item", { attrs: { button: "", active: _vm.selectedImportId === importConfigs.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.selectImportJobs(importConfigs);
    }, "click") } }, [_c("h5", [_vm._v(`
                ` + _vm._s(importConfigs.name) + `
            `)])]);
  }), 1)], 1), _vm._v(" "), _c("b-col", { attrs: { cols: "8" } }, [_vm.selectedImportId && !_vm.loadingLogs ? _c("b-table", { attrs: { items: _vm.logs, fields: _vm.tableFields }, scopedSlots: _vm._u([{ key: "cell(lastModified)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.lastModified } })];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_c("a", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-default btn-sm mr-2 float-right", attrs: { href: _vm.logUrl(data.item), title: "Download log file" } }, [_c("font-awesome-icon", { attrs: { icon: "download" } })], 1)])];
  }, "fn") }], null, !1, 499021429) }) : _vm.selectedImportId ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading Logs...")])], 1) : _vm._e()], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$1 = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("h4", [_vm._v("Indexing Import Logs")])])]);
}], __component__$1 = /* @__PURE__ */ normalizeComponent(
  IndexingImportLogsComponent$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "77a8ff25"
);
const IndexingImportLogsComponent = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a5;
let AdministrationLogComponent = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "hasUserLogsPermission", !1);
    __publicField(this, "hasEmailLogsPermission", !1);
    __publicField(this, "hasIndexingLogsPermission", !1);
    __publicField(this, "tabs", [
      {
        id: "local",
        name: "Application",
        icon: "thumbtack",
        description: "The inbuilt system logs for EWA",
        show: !0,
        component: LogsListComponent
      },
      {
        id: "userLogs",
        name: "User Logs",
        icon: "right-to-bracket",
        description: "User login audit logs",
        show: !0,
        component: UserLogsComponent
      },
      {
        id: "emailLogs",
        name: "Email Logs",
        icon: "envelope",
        description: "Emails sent from EWA logs",
        show: !0,
        component: EmailLogsComponent
      },
      {
        id: "importLogs",
        name: "Import Logs",
        icon: "file-import",
        description: "Indexing import logs",
        show: !0,
        component: IndexingImportLogsComponent
      }
    ]);
    __publicField(this, "selectedTab", this.tabs[0]);
  }
  async mounted() {
    this.hasUserLogsPermission = await userHasPermission("logs.users"), this.hasUserLogsPermission || (this.tabs = this.tabs.filter((y) => y.id != "userLogs")), this.hasEmailLogsPermission = await userHasPermission("logs.emails"), this.hasEmailLogsPermission || (this.tabs = this.tabs.filter((y) => y.id != "emailLogs")), this.hasIndexingLogsPermission = await userHasPermission("logs.indexing"), this.hasIndexingLogsPermission || (this.tabs = this.tabs.filter((y) => y.id != "importLogs"));
  }
  selectTab(tabId) {
    this.selectedTab = this.tabs.find((t) => t.id === tabId);
  }
}, __name(_a5, "AdministrationLogComponent"), _a5);
AdministrationLogComponent = __decorateClass([
  Component({
    components: { LogsListComponent, LoadingBar: LoadingBarComponent, UserLogsComponent, EmailLogsComponent, IndexingImportLogsComponent }
  })
], AdministrationLogComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "archive" } }), _vm._v(" Logs")], 1)]), _vm._v(" "), _c("div", [_c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs", attrs: { id: "myTab", role: "tablist" } }, _vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item" }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.selectedTab.id === tab.id }, attrs: { id: tab.id + "tab", "data-toggle": "tab", role: "tab", "aria-selected": "true" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(" " + _vm._s(tab.name) + `
                    `)], 1)]);
  }), 0)])]), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_vm.loading ? _vm._e() : _c("div", { staticClass: "container-fluid" }, [_c(_vm.selectedTab.component, { tag: "component" })], 1)])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationLogComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "5a83e53e"
);
const index = __component__.exports;
export {
  index as default
};
