var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, z as systemInAzureMode, t as toastr$1, g as v4, b as baseUrl, C as Component, L as LoadingBarComponent, n as normalizeComponent, P as Prop, W as Watch, b6 as AdministrationAppsIndexingClient, T as Transformer, bK as SmtpFileSelection, bL as Operator, f as draggable, bM as MailItemStatus, _, G as Getter, c as Action, S as State, M as Moment } from "./main-DAVWuHbi.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
import { P as PlaceholderInformation } from "./placeholderInformation-CJo0noa4.js";
import { I as IndexingPageReactiveDropdown } from "./indexingPageReactiveDropdown-BBO81Kq4.js";
import { E as ExternalConnectionDropDown } from "./externalConnectionDropDown-Du88bMty.js";
import { C as ContainerSelectionComponent } from "./containerSelector-DJmnNR6h.js";
import { D as DefaultableTextbox } from "./defaultableTextbox-DRxGWG_3.js";
import { b as bytesToSize } from "./fileSizeHelpers-DezEXWHc.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
var __getOwnPropDesc$b = Object.getOwnPropertyDescriptor, __decorateClass$b = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$b(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$b"), _a;
let ConfigComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loadingError", null);
    __publicField(this, "editingIndex", -1);
    __publicField(this, "deletingIndex", -1);
    __publicField(this, "isAzureMode", !1);
  }
  async mounted() {
    this.isAzureMode = await systemInAzureMode(), this.load();
  }
  load() {
    this.loadingError = null;
    try {
      return this.$store.dispatch("administration/smtp/server/actions/loadConfiguration");
    } catch (e) {
      this.loadingError = e;
    }
  }
  getAzureDisabledMessage() {
    return this.isAzureMode ? "This feature isn't supported when running in Azure Mode" : "";
  }
  async save() {
    if (await this.$validator.validateAll())
      try {
        await this.$store.dispatch("administration/smtp/server/actions/saveConfiguration"), toastr$1.success("Configuration saved");
      } catch (e) {
        toastr$1.error(e, "Failed to save configuration");
      }
    else
      return;
  }
  get saving() {
    return this.$store.getters["administration/smtp/server/getters/saving"];
  }
  get loading() {
    return this.$store.getters["administration/smtp/server/getters/loading"];
  }
  get model() {
    return this.$store.getters["administration/smtp/server/getters/configuration"];
  }
  set model(model) {
    this.$store.dispatch("administration/smtp/server/actions/updateLocal", model);
  }
  get canSave() {
    return this.$validator.errors.any() ? !1 : this.$store.getters["administration/smtp/server/getters/hasChanges"];
  }
  get enabled() {
    return this.model.enabled;
  }
  set enabled(value) {
    this.model = { ...this.model, enabled: value };
  }
  get sendGridEnabled() {
    return this.model.sendGridEnabled;
  }
  set sendGridEnabled(value) {
    this.model = { ...this.model, sendGridEnabled: value }, value && (this.sendGridToken = v4());
  }
  get sendGridToken() {
    return this.model.sendGridToken;
  }
  set sendGridToken(value) {
    this.model = { ...this.model, sendGridToken: value };
  }
  get requireAuthentication() {
    return this.model.requireAuthentication;
  }
  set requireAuthentication(value) {
    this.model = { ...this.model, requireAuthentication: value };
  }
  get username() {
    return this.model.username;
  }
  set username(value) {
    this.model = { ...this.model, username: value };
  }
  get password() {
    return this.model.password;
  }
  set password(value) {
    this.model = { ...this.model, password: value };
  }
  get port() {
    return this.model.port;
  }
  set port(value) {
    this.model = { ...this.model, port: value };
  }
  get allowedNetworks() {
    return this.model.allowedNetworks;
  }
  set allowedNetworks(value) {
    this.model = { ...this.model, allowedNetworks: value };
  }
  get rules() {
    return this.model.rules;
  }
  set rules(value) {
    this.model = { ...this.model, rules: value };
  }
  removeNetwork(index2) {
    if (index2 < 0)
      return;
    let newModel = this.allowedNetworks.slice();
    newModel.splice(index2, 1), this.allowedNetworks = newModel, this.deletingIndex = -1;
  }
  addNetwork() {
    let newModel = this.allowedNetworks.slice();
    newModel.push(""), this.allowedNetworks = newModel, this.editingIndex = this.allowedNetworks.length - 1, this.$nextTick(() => {
      var index2 = this.allowedNetworks.length - 1;
      $("#networkAddressInput" + index2).focus();
    });
  }
  showNetworkAddressModal() {
    $("#networkAddressModal").modal("show");
  }
  regenerateToken() {
    this.sendGridToken = v4();
  }
  get sendGridEndpoint() {
    return new URL(baseUrl() + "/smtp/sendgrid/" + this.sendGridToken + "/new").href;
  }
  async copyUrl() {
    try {
      await navigator.clipboard.writeText(this.sendGridEndpoint), toastr$1.success("Successfully copied");
    } catch {
      toastr$1.error("Could not copy");
    }
  }
}, __name(_a, "ConfigComponent"), _a);
ConfigComponent = __decorateClass$b([
  Component({
    components: { LoadingBar: LoadingBarComponent },
    methods: { systemInAzureMode }
  })
], ConfigComponent);
var _sfc_render$b = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "modal fade", attrs: { "data-backdrop": "static", id: "networkAddressModal", tabindex: "-1", role: "dialog", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "network-wired" } }), _vm._v(" Network address syntax")], 1), _vm._v(" "), _vm._m(0)]), _vm._v(" "), _vm._m(1)])])]), _vm._v(" "), _c("div", { staticClass: "col-md-6 col-sm-12" }, [_c("h4", [_c("font-awesome-icon", { attrs: { icon: "toolbox" } }), _vm._v(" Configuration")], 1), _vm._v(" "), _vm.loading ? _c("loading-bar") : _vm.loadingError ? _c("div", { staticClass: "alert alert-danger" }, [_vm._v(`
            Failed to load server settings. Retry?
        `)]) : _vm.model ? [_c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", value: _vm.getAzureDisabledMessage(), expression: "getAzureDisabledMessage()", modifiers: { hover: !0 } }], attrs: { name: "enabledSwitch", disabled: _vm.isAzureMode, switch: "" }, model: { value: _vm.enabled, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.enabled = $$v;
  }, "callback"), expression: "enabled" } }, [_c("b", [_vm._v("Enable SMTP Server")])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Turns on the ability to accept mail items via an SMTP server")])]), _vm._v(" "), _vm.enabled ? [_c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "portInput" } }, [_vm._v("Port")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.port, expression: "port" }, { name: "validate", rawName: "v-validate", value: "required|numeric|max_value:65535|min_value:1", expression: "'required|numeric|max_value:65535|min_value:1'" }], staticClass: "form-control", attrs: { type: "number", name: "portInput", id: "portInput", placeholder: "e.g. 25", min: "1", max: "65535" }, domProps: { value: _vm.port }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.port = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.first("portInput") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a valid port number. valid ports are between 1 and 65535")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "portInput" } }, [_vm._v(`  Allowed Networks 
                        `), _c("button", { staticClass: "btn btn-sm btn-default", on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.addNetwork();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } })], 1)]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v(`
                        This list is the allowed networks that the SMTP server will accept. 
                        `), _c("a", { attrs: { href: "javascript:void(0)" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.showNetworkAddressModal();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "question-circle" } }), _vm._v(`
                            Using network address syntax.
                        `)], 1)]), _vm._v(" "), _c("table", { staticClass: "table table-hover" }, [_c("tbody", _vm._l(_vm.allowedNetworks, function(network, index2) {
    return _c("tr", { key: index2 }, [_c("td", [_vm.editingIndex != index2 ? _c("span", [_vm.editingIndex != index2 ? _c("button", { staticClass: "btn btn-sm btn-default", on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.editingIndex = index2;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "pen" } })], 1) : _c("button", { staticClass: "btn btn-sm btn-default", on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.editingIndex = -1;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "check" } })], 1), _vm._v(` 
                                        `), _c("span", [_vm._v(_vm._s(network))])]) : _c("span", { staticClass: "float-left" }, [_c("div", { staticClass: "input-group" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.allowedNetworks[index2], expression: "allowedNetworks[index]" }], staticClass: "form-control", attrs: { id: "networkAddressInput" + index2, placeholder: "IP Address/Range" }, domProps: { value: _vm.allowedNetworks[index2] }, on: { input: /* @__PURE__ */ __name(function($event) {
      $event.target.composing || _vm.$set(_vm.allowedNetworks, index2, $event.target.value);
    }, "input") } }), _vm._v(" "), _c("div", { staticClass: "input-group-append" }, [_c("button", { staticClass: "btn btn-sm btn-default", on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.editingIndex = -1;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "check" } })], 1)])]), _vm._v(" "), _vm.errors.first("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v("Name is required")]) : _vm._e()])]), _vm._v(" "), _c("td", [_c("span", { staticClass: "float-right" }, [_vm.deletingIndex != index2 ? _c("span", [_c("button", { staticClass: "btn btn-sm btn-danger", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.deletingIndex = index2;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
                                            `)], 1)]) : _c("span", [_c("button", { staticClass: "btn btn-sm btn-default", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.deletingIndex = -1;
    }, "click") } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-sm btn-danger", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.removeNetwork(index2);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Confirm Delete
                                            `)], 1)])])])]);
  }), 0)])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "requireAuthenticationSwitch", switch: "" }, model: { value: _vm.requireAuthentication, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.requireAuthentication = $$v;
  }, "callback"), expression: "requireAuthentication" } }, [_c("b", [_vm._v("Require Authentication")])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Requires all sending devices to authenticate with the SMTP server.")])]), _vm._v(" "), _vm.requireAuthentication ? _c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header" }, [_c("font-awesome-icon", { attrs: { icon: "user-lock" } }), _vm._v(` Authentication Details
                    `)], 1), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "authenticationUsernameInput" } }, [_vm._v("Username")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.username, expression: "username" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", attrs: { type: "text", id: "authenticationUsernameInput", placeholder: "Username", name: "username" }, domProps: { value: _vm.username }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.username = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.first("username") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a username")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "authenticationPasswordInput" } }, [_vm._v("Password")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.password, expression: "password" }], staticClass: "form-control", attrs: { type: "password", id: "authenticationPasswordInput", placeholder: "Password" }, domProps: { value: _vm.password }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.password = $event.target.value);
  }, "input") } })])])]) : _vm._e()] : _vm._e(), _vm._v(" "), _c("b-form-group", { attrs: { id: "sendGridEnabledGroup" } }, [_c("b-form-checkbox", { attrs: { name: "sendGridEnabledSwitch", switch: "" }, model: { value: _vm.sendGridEnabled, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sendGridEnabled = $$v;
  }, "callback"), expression: "sendGridEnabled" } }, [_c("b", [_vm._v("Enable Send Grid Endpoint")])]), _vm._v(" "), _c("small", { staticClass: "form-text text-muted", attrs: { id: "emailInputHelp" } }, [_vm._v("Enables WebApps to receive SendGrid emails.")])], 1), _vm._v(" "), _vm.sendGridEnabled ? _c("b-form-group", { attrs: { id: "sendGridTokenGroup", label: "Send Grid Token", "label-class": "font-weight-bold" } }, [_c("b-input-group", [_c("b-form-input", { attrs: { id: "sendGridToken", readonly: "", type: "text" }, model: { value: _vm.sendGridToken, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sendGridToken = $$v;
  }, "callback"), expression: "sendGridToken" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "success", title: "Regenerate endpoint token" }, on: { click: _vm.regenerateToken } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(` 
                            Regenerate
                        `)], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "primary", title: "Copy Endpoint Url" }, on: { click: _vm.copyUrl } }, [_c("font-awesome-icon", { attrs: { icon: "clipboard-list" } })], 1)], 1)], 1), _vm._v(" "), _c("small", { staticClass: "form-text text-muted", attrs: { id: "sendGridTokenHelp" } }, [_vm._v("Send grid token for the endpoint")])], 1) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group mt-2" }, [_c("button", { staticClass: "btn btn-success", attrs: { type: "submit", disabled: !_vm.canSave }, on: { click: _vm.save } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save
                `)], 1)])] : _vm._e()], 2)]);
}, "render"), _sfc_staticRenderFns$b = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal-body" }, [_c("p", [_vm._v("You can use the following syntax to configure single or ranges of IP addresses.")]), _vm._v(" "), _c("ul", [_c("li", [_vm._v("Single Address: 192.168.0.10")]), _vm._v(" "), _c("li", [_vm._v("IP Range: 192.168.0.0-192.168.0.254")]), _vm._v(" "), _c("li", [_vm._v("CIDR Notation: 192.168.0.0/24")])])]);
}], __component__$b = /* @__PURE__ */ normalizeComponent(
  ConfigComponent,
  _sfc_render$b,
  _sfc_staticRenderFns$b,
  !1,
  null,
  "06c39d18"
);
const Config = __component__$b.exports;
var __defProp$8 = Object.defineProperty, __getOwnPropDesc$a = Object.getOwnPropertyDescriptor, __decorateClass$a = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$a(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$8(target, key, result), result;
}, "__decorateClass$a"), _a2;
let DeleteActionComponent$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
}, __name(_a2, "DeleteActionComponent"), _a2);
__decorateClass$a([
  Prop({
    required: !0
  })
], DeleteActionComponent$1.prototype, "value", 2);
DeleteActionComponent$1 = __decorateClass$a([
  Component
], DeleteActionComponent$1);
var _sfc_render$a = /* @__PURE__ */ __name(function() {
  var _vm = this;
  return _vm._self._c, _vm._self._setupProxy, _vm._m(0);
}, "render"), _sfc_staticRenderFns$a = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("br"), _vm._v(" "), _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
        Message will be deleted and will not be forwarded on, or retained in WebApps
    `)])]);
}], __component__$a = /* @__PURE__ */ normalizeComponent(
  DeleteActionComponent$1,
  _sfc_render$a,
  _sfc_staticRenderFns$a,
  !1,
  null,
  "5c14c626"
);
const DeleteActionComponent = __component__$a.exports;
var __defProp$7 = Object.defineProperty, __getOwnPropDesc$9 = Object.getOwnPropertyDescriptor, __decorateClass$9 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$9(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$7(target, key, result), result;
}, "__decorateClass$9"), _a3;
let IndexingActionComponent$1 = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "ruleId");
    __publicField(this, "queueTypesLoading", !1);
    __publicField(this, "queueTypesLoadingError", null);
    __publicField(this, "queueType", null);
    __publicField(this, "queuesLoading", !1);
    __publicField(this, "queuesLoadingError", null);
    __publicField(this, "queueTypes", []);
    __publicField(this, "queues", []);
    __publicField(this, "uniquePlaceHolderInfo", [
      { syntax: '{{message["address.from"]}}', description: "The address the message was sent from." },
      { syntax: '{{message["address.to"]}}', description: "The address the message was sent to." },
      { syntax: '{{message["subject"]}}', description: "The subject of the message." },
      { syntax: '{{message["host"]}}', description: "The host address that the email was sent from." },
      { syntax: '{{message["timestamp"]}}', description: "A time stamp of when the email was sent." }
    ]);
  }
  async mounted() {
    this.pageId && await this.updateQueueTypes();
  }
  watchRuleId(newValue) {
    this.pageId && this.updateQueueTypes();
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get pageId() {
    return this.model.pageId;
  }
  set pageId(value) {
    value != this.pageId && this.updatePageId(value);
  }
  get queueTypeId() {
    return this.model.queueTypeId;
  }
  set queueTypeId(value) {
    var _a13;
    value != this.queueTypeId && (this.queueType = (_a13 = this.queueTypes.find((y) => y.id == value)) == null ? void 0 : _a13.queueType, this.updateQueueTypeId(value));
  }
  get queueId() {
    return this.model.queueId;
  }
  set queueId(value) {
    value != null ? this.model = Object.assign(this.model, { queueId: value, queueName: null }) : this.model = Object.assign(this.model, { queueId: null });
  }
  get queueName() {
    return this.model.queueName;
  }
  set queueName(value) {
    this.model = Object.assign(this.model, { queueName: value });
  }
  get fileSelection() {
    return this.model.fileSelection;
  }
  set fileSelection(value) {
    this.model = Object.assign(this.model, { fileSelection: value });
  }
  async updatePageId(value) {
    this.model = Object.assign(this.model, { pageId: value, queueTypeId: null, queueId: null, queueName: null }), await this.$nextTick(), await this.updateQueueTypes();
  }
  async updateQueueTypeId(value) {
    this.model = Object.assign(this.model, { queueTypeId: value, queueId: null, queueName: null }), await this.$nextTick(), await this.updateQueues();
  }
  async updateQueueTypes() {
    var _a13;
    this.queueTypesLoading = !0, this.queueTypes = [];
    try {
      let type = await new AdministrationAppsIndexingClient(new Transformer(), baseUrl()).getQueueTypes(this.pageId);
      this.queueTypes = type.map((t) => ({
        id: t.id,
        queueType: t.type,
        name: t.name
      })), this.queueTypeId && (this.queueType = (_a13 = this.queueTypes.find((y) => y.id == this.queueTypeId)) == null ? void 0 : _a13.queueType);
    } catch (e) {
      this.queueTypesLoadingError = e;
    } finally {
      this.queueTypesLoading = !1;
    }
    this.queueTypeId && (await this.$nextTick(), await this.updateQueues());
  }
  async updateQueues() {
    this.queuesLoading = !0, this.queues = [];
    try {
      let response = await new AdministrationAppsIndexingClient(new Transformer(), baseUrl()).getQueues(this.pageId, this.queueTypeId);
      this.queues = [
        {
          id: null,
          name: "By Name",
          icon: "tag"
        },
        ...response.map((q) => ({
          id: q.id,
          name: q.name
        }))
      ];
    } catch (e) {
      this.queuesLoadingError = e;
    } finally {
      this.queuesLoading = !1;
    }
  }
  get importFileSelection() {
    return [
      { value: SmtpFileSelection.Automatic, text: "Automatic" },
      { value: SmtpFileSelection.AttachmentsOnly, text: "Attachments Only" },
      { value: SmtpFileSelection.EmailBody, text: "Email Body Only" },
      { value: SmtpFileSelection.RawEmail, text: "Raw Email File" }
    ];
  }
}, __name(_a3, "IndexingActionComponent"), _a3);
__decorateClass$9([
  Prop({
    required: !0
  })
], IndexingActionComponent$1.prototype, "value", 2);
__decorateClass$9([
  Prop({
    required: !0
  })
], IndexingActionComponent$1.prototype, "ruleId", 2);
__decorateClass$9([
  Watch("ruleId", { immediate: !0 })
], IndexingActionComponent$1.prototype, "watchRuleId", 1);
IndexingActionComponent$1 = __decorateClass$9([
  Component({
    components: { ReactiveDropdown, PlaceholderInformation, IndexingPageReactiveDropdown },
    inject: ["$validator"]
  })
], IndexingActionComponent$1);
var _sfc_render$9 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("br"), _vm._v(" "), _c("b-form-group", { attrs: { id: "emailImportOptionsGroup", label: "File Selection", "label-for": "fileSelectionOptions", description: "Select what part of the email message to import" } }, [_c("b-form-select", { attrs: { options: _vm.importFileSelection }, model: { value: _vm.fileSelection, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.fileSelection = $$v;
  }, "callback"), expression: "fileSelection" } })], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Page")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("indexing-page-reactive-dropdown", { on: { input: _vm.updatePageId }, model: { value: _vm.pageId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageId = $$v;
  }, "callback"), expression: "pageId" } }), _vm._v(" "), _vm.errors.has("indexingPage") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("indexingPage")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Select the page to put the email in.")])], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Queue Type")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], attrs: { options: _vm.queueTypes, loading: _vm.queueTypesLoading, restrictOverflow: "", button: { icon: "sync", disabled: _vm.queueTypesLoading, spin: _vm.queueTypesLoading }, "data-vv-as": "Queue Type", name: "indexingQueueType", disabled: !_vm.pageId }, on: { button: _vm.updateQueueTypes }, model: { value: _vm.queueTypeId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.queueTypeId = $$v;
  }, "callback"), expression: "queueTypeId" } }), _vm._v(" "), _vm.errors.has("indexingQueueType") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("indexingQueueType")))]) : _vm._e(), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Select the Queue Type to put the email in.")])], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Queue")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { directives: [{ name: "validate", rawName: "v-validate", value: { required: !this.queueName }, expression: "{ required: !this.queueName }" }], attrs: { options: _vm.queues, restrictOverflow: "", button: { icon: "sync", disabled: _vm.queuesLoading, spin: _vm.queuesLoading }, name: "indexingQueue", "data-vv-as": "Queue", loading: _vm.queuesLoading }, on: { button: _vm.updateQueues }, model: { value: _vm.queueId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.queueId = $$v;
  }, "callback"), expression: "queueId" } }), _vm._v(" "), _vm.errors.has("indexingQueue") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("indexingQueue")))]) : _vm._e(), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Select the Queue to put the email in.")])], 1), _vm._v(" "), _vm.queueId ? _vm._e() : _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Queue by Name")]), _vm._v(" "), _c("input", { directives: [{ name: "validate", rawName: "v-validate", value: { required: !this.queueId }, expression: "{ required: !this.queueId }" }, { name: "model", rawName: "v-model", value: _vm.queueName, expression: "queueName" }], staticClass: "form-control", attrs: { type: "text", name: "indexingQueueName", disabled: !_vm.queueTypeId, "data-vv-as": "Queue Name" }, domProps: { value: _vm.queueName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.queueName = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("indexingQueueName") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("indexingQueueName")))]) : _vm._e(), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v(`Select the Queue (by name) to put email. Supports
            `), _c("placeholder-information", { attrs: { "unique-placeholders": _vm.uniquePlaceHolderInfo } })], 1)]), _vm._v(" "), !_vm.queueId && _vm.queueType == "personal" ? _c("div", { staticClass: "form-group" }, [_c("b-alert", { attrs: { show: !0, variant: "primary" } }, [_c("font-awesome-icon", { attrs: { icon: "info-circle" } }), _vm._v(`
        If no existing queue is found, a personal queue will be created.
      `)], 1)], 1) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns$9 = [], __component__$9 = /* @__PURE__ */ normalizeComponent(
  IndexingActionComponent$1,
  _sfc_render$9,
  _sfc_staticRenderFns$9,
  !1,
  null,
  "3134b6d7"
);
const IndexingActionComponent = __component__$9.exports;
var __defProp$6 = Object.defineProperty, __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor, __decorateClass$8 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$6(target, key, result), result;
}, "__decorateClass$8"), _a4;
let RelayActionComponent$1 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  get model() {
    return this.value;
  }
  set model(input) {
    this.$emit("input", input);
  }
  get host() {
    return this.model.host;
  }
  set host(input) {
    this.model = Object.assign(this.model, { host: input });
  }
  get port() {
    return this.model.port;
  }
  set port(input) {
    this.model = Object.assign(this.model, { port: input });
  }
  get username() {
    return this.model.username;
  }
  set username(input) {
    this.model = Object.assign(this.model, { username: input });
  }
  get password() {
    return this.model.password;
  }
  set password(input) {
    this.model = Object.assign(this.model, { password: input });
  }
  get requiresAuthentication() {
    return this.model.requiresAuthentication;
  }
  set requiresAuthentication(value) {
    this.model = Object.assign(this.model, { requiresAuthentication: value });
  }
  get requiresSsl() {
    return this.model.requiresSsl;
  }
  set requiresSsl(value) {
    this.model = Object.assign(this.model, { requiresSsl: value });
  }
}, __name(_a4, "RelayActionComponent"), _a4);
__decorateClass$8([
  Prop({
    required: !0
  })
], RelayActionComponent$1.prototype, "value", 2);
RelayActionComponent$1 = __decorateClass$8([
  Component({
    components: { IndexingAction: IndexingActionComponent },
    inject: ["$validator"]
  })
], RelayActionComponent$1);
var _sfc_render$8 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("br"), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Host")]), _vm._v(" "), _c("input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }, { name: "model", rawName: "v-model", value: _vm.host, expression: "host" }], ref: "host", staticClass: "form-control", class: { "is-invalid": _vm.errors.first("relayHost") }, attrs: { type: "text", "data-vv-as": "Relay Host", name: "relayHost" }, domProps: { value: _vm.host }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.host = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.first("relayHost") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("relayHost")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Target host to forward messages to")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.first("relayPort") } }, [_c("label", [_vm._v("Port")]), _vm._v(" "), _c("input", { directives: [{ name: "validate", rawName: "v-validate", value: "numeric|between:1,65535|required", expression: "'numeric|between:1,65535|required'" }, { name: "model", rawName: "v-model", value: _vm.port, expression: "port" }], ref: "port", staticClass: "form-control", class: { "is-invalid": _vm.errors.first("relayPort") }, attrs: { type: "number", name: "relayPort", min: "1", max: "65535", "data-vv-as": "Relay Port" }, domProps: { value: _vm.port }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.port = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.first("relayPort") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("relayPort")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Port on the target host")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.first("relayUsername") } }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { ref: "requiresSsl", attrs: { name: "requiresSslSwitch", switch: "" }, model: { value: _vm.requiresSsl, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.requiresSsl = $$v;
  }, "callback"), expression: "requiresSsl" } }, [_c("b", [_vm._v("Require SSL/TLS")])])], 1)]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.first("relayUsername") } }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { ref: "requiresAuthentication", attrs: { name: "enabledSwitch", switch: "" }, model: { value: _vm.requiresAuthentication, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.requiresAuthentication = $$v;
  }, "callback"), expression: "requiresAuthentication" } }, [_c("b", [_vm._v(`Require
                Authentication`)])])], 1)]), _vm._v(" "), _vm.requiresAuthentication ? [_c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.first("relayUsername") } }, [_c("label", [_vm._v("Username")]), _vm._v(" "), _c("input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }, { name: "model", rawName: "v-model", value: _vm.username, expression: "username" }], ref: "username", staticClass: "form-control", class: { "is-invalid": _vm.errors.first("relayUsername") }, attrs: { type: "text", name: "relayUsername", "data-vv-as": "Username" }, domProps: { value: _vm.username }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.username = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.first("relayUsername") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("relayUsername")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Username to authenticate on target host")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.first("relayPassword") } }, [_c("label", [_vm._v("Password")]), _vm._v(" "), _c("input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }, { name: "model", rawName: "v-model", value: _vm.password, expression: "password" }], ref: "password", staticClass: "form-control", class: { "is-invalid": _vm.errors.first("relayPassword") }, attrs: { type: "password", name: "relayPassword", "data-vv-as": "Password" }, domProps: { value: _vm.password }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.password = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.first("relayPassword") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("relayPassword")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Password to authenticate on target host")])])] : _vm._e(), _vm._v(" "), _c("div")], 2);
}, "render"), _sfc_staticRenderFns$8 = [], __component__$8 = /* @__PURE__ */ normalizeComponent(
  RelayActionComponent$1,
  _sfc_render$8,
  _sfc_staticRenderFns$8,
  !1,
  null,
  "4e2e2054"
);
const RelayActionComponent = __component__$8.exports;
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor, __decorateClass$7 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$7"), _a5;
let AzureBlobActionComponent$1 = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "ruleId");
    __publicField(this, "uniquePlaceHolderInfo", [
      { syntax: '{{message["address.from"]}}', description: "The address the message was sent from." },
      { syntax: '{{message["address.to"]}}', description: "The address the message was sent to." },
      { syntax: '{{message["subject"]}}', description: "The subject of the message." },
      { syntax: '{{message["host"]}}', description: "The host address that the email was sent from." },
      { syntax: '{{message["timestamp"]}}', description: "A time stamp of when the email was sent." }
    ]);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get externalConnectionId() {
    return this.model.externalConnectionId;
  }
  set externalConnectionId(value) {
    this.model = Object.assign(this.model, { externalConnectionId: value });
  }
  get container() {
    return this.model.container;
  }
  set container(value) {
    this.model = Object.assign(this.model, { container: value });
  }
  get outputDirectory() {
    return this.model.outputDirectory;
  }
  set outputDirectory(value) {
    this.model = Object.assign(this.model, { outputDirectory: value });
  }
  get fileSelection() {
    return this.model.fileSelection;
  }
  set fileSelection(value) {
    this.model = Object.assign(this.model, { fileSelection: value });
  }
  get importFileSelection() {
    return [
      { value: SmtpFileSelection.Automatic, text: "Automatic" },
      { value: SmtpFileSelection.AttachmentsOnly, text: "Attachments Only" },
      { value: SmtpFileSelection.EmailBody, text: "Email Body Only" },
      { value: SmtpFileSelection.RawEmail, text: "Raw Email File" }
    ];
  }
}, __name(_a5, "AzureBlobActionComponent"), _a5);
__decorateClass$7([
  Prop({
    required: !0
  })
], AzureBlobActionComponent$1.prototype, "value", 2);
__decorateClass$7([
  Prop({
    required: !0
  })
], AzureBlobActionComponent$1.prototype, "ruleId", 2);
AzureBlobActionComponent$1 = __decorateClass$7([
  Component({
    components: { PlaceholderInformation, ExternalConnectionDropDown, ContainerSelectionComponent, DefaultableTextbox },
    inject: ["$validator"]
  })
], AzureBlobActionComponent$1);
var _sfc_render$7 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("br"), _vm._v(" "), _c("b-form-group", { attrs: { id: "emailImportOptionsGroup", label: "File Selection", "label-for": "fileSelectionOptions", description: "Select what part of the email message to import" } }, [_c("b-form-select", { attrs: { options: _vm.importFileSelection }, model: { value: _vm.fileSelection, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.fileSelection = $$v;
  }, "callback"), expression: "fileSelection" } })], 1), _vm._v(" "), _c("label", [_vm._v("Azure Connection")]), _vm._v(" "), _c("external-connection-drop-down", { attrs: { types: ["ExternalConnection.AzureStorage", "ExternalConnection.AzureStorageBuiltIn"] }, model: { value: _vm.externalConnectionId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.externalConnectionId = $$v;
  }, "callback"), expression: "externalConnectionId" } }), _vm._v(" "), _c("container-selection-component", { attrs: { externalConnectionId: _vm.externalConnectionId }, model: { value: _vm.container, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.container = $$v;
  }, "callback"), expression: "container" } }), _vm._v(" "), _c("b-form-group", { attrs: { label: "Output Directory" } }, [_c("defaultable-textbox", { attrs: { placeholder: "Enter a path..." }, model: { value: _vm.outputDirectory, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.outputDirectory = $$v;
  }, "callback"), expression: "outputDirectory" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v(`This field supports
            `), _c("placeholder-information", { attrs: { "unique-placeholders": _vm.uniquePlaceHolderInfo } })], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$7 = [], __component__$7 = /* @__PURE__ */ normalizeComponent(
  AzureBlobActionComponent$1,
  _sfc_render$7,
  _sfc_staticRenderFns$7,
  !1,
  null,
  "aa13d042"
);
const AzureBlobActionComponent = __component__$7.exports, actions = [
  {
    id: "delete",
    name: "Delete",
    description: "Permanently delete a message",
    component: DeleteActionComponent,
    icon: "trash",
    factory: /* @__PURE__ */ __name(() => ({
      discriminator: "delete"
    }), "factory")
  },
  {
    id: "relay",
    name: "Relay",
    description: "Relay message to target SMTP server",
    icon: "plane",
    component: RelayActionComponent,
    factory: /* @__PURE__ */ __name(() => ({
      discriminator: "relay",
      host: null,
      port: 0,
      username: null,
      password: null,
      requiresAuthentication: !1,
      requiresSsl: !1
    }), "factory")
  },
  {
    id: "indexing",
    name: "Indexing (RIA)",
    description: "Send email to Remote Indexing Page",
    icon: "inbox",
    component: IndexingActionComponent,
    factory: /* @__PURE__ */ __name(() => ({
      discriminator: "indexing",
      pageId: null,
      queueTypeId: null,
      queueName: null,
      queueId: null,
      fileSelection: SmtpFileSelection.AttachmentsOnly
    }), "factory")
  },
  {
    id: "azureBlob",
    name: "Azure Blob",
    description: "Uploads file to azure blob storage",
    icon: "clouds",
    component: AzureBlobActionComponent,
    factory: /* @__PURE__ */ __name(() => ({
      discriminator: "azureBlob",
      externalConnectionId: null,
      container: null,
      outputDirectory: null,
      fileSelection: SmtpFileSelection.AttachmentsOnly
    }), "factory")
  }
];
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$6"), _a6;
let RuleConditionComponent = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "disable");
    __publicField(this, "index");
    __publicField(this, "saving");
    __publicField(this, "conditionConstraints", [
      {
        id: "contains",
        name: "Contains"
      },
      {
        id: "matches",
        name: "Matches"
      },
      {
        id: "startsWith",
        name: "Starts With"
      },
      {
        id: "endsWith",
        name: "Ends With"
      },
      {
        id: "exists",
        name: "Exists"
      }
    ]);
    __publicField(this, "conditionProperties", [
      {
        id: "fromAddress",
        name: "From Address"
      },
      {
        id: "toAddress",
        name: "To Address"
      },
      {
        id: "subject",
        name: "Subject"
      },
      {
        id: "body",
        name: "Body"
      }
    ]);
  }
  get condition() {
    return this.value;
  }
  set condition(value) {
    this.$emit("input", value);
  }
  get conditionProperty() {
    return this.condition.property;
  }
  set conditionProperty(value) {
    this.condition = { ...this.condition, property: value };
  }
  get conditionConstraint() {
    return this.condition.constraint;
  }
  set conditionConstraint(value) {
    this.condition = { ...this.condition, constraint: value };
  }
  get conditionValue() {
    return this.condition.value;
  }
  set conditionValue(value) {
    this.condition = { ...this.condition, value };
  }
}, __name(_a6, "RuleConditionComponent"), _a6);
__decorateClass$6([
  Prop({ required: !0, default: /* @__PURE__ */ __name(() => null, "default") })
], RuleConditionComponent.prototype, "value", 2);
__decorateClass$6([
  Prop({ required: !1, default: /* @__PURE__ */ __name(() => !1, "default") })
], RuleConditionComponent.prototype, "disable", 2);
__decorateClass$6([
  Prop()
], RuleConditionComponent.prototype, "index", 2);
__decorateClass$6([
  Prop()
], RuleConditionComponent.prototype, "saving", 2);
RuleConditionComponent = __decorateClass$6([
  Component({
    components: {
      ReactiveDropdown
    },
    inject: [
      "$validator"
    ]
  })
], RuleConditionComponent);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { ref: "condition", staticClass: "card mb-3" }, [_c("div", { staticClass: "card-header" }, [_c("h5", [_vm._v("Condition #" + _vm._s(_vm.index + 1) + `
            `), _c("button", { staticClass: "btn btn-sm btn-danger float-right", on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.$emit("remove");
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)])]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("div", { staticClass: "form-inline" }, [_c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Property")]), _vm._v(" "), _c("reactive-dropdown", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], ref: "conditionProperty", class: { "is-invalid": _vm.errors.first("property"), disabled: _vm.saving }, attrs: { options: _vm.conditionProperties, fill: "", name: "property", disabled: _vm.disable }, model: { value: _vm.conditionProperty, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.conditionProperty = $$v;
  }, "callback"), expression: "conditionProperty" } }), _vm._v(" "), _vm.errors.has("property") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("property")))]) : _vm._e()], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Constraint")]), _vm._v(" "), _c("reactive-dropdown", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], ref: "conditionConstraint", class: { "is-invalid": _vm.errors.first("constraint"), disabled: _vm.saving }, attrs: { options: _vm.conditionConstraints, fill: "", name: "constraint", disabled: _vm.disable }, model: { value: _vm.conditionConstraint, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.conditionConstraint = $$v;
  }, "callback"), expression: "conditionConstraint" } }), _vm._v(" "), _vm.errors.has("constraint") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("constraint")))]) : _vm._e()], 1)]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("The item and condition to act against")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Condition value")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.conditionValue, expression: "conditionValue" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], ref: "conditionValue", staticClass: "form-control", class: { "is-invalid": _vm.errors.first("condition" + _vm.index), disabled: _vm.saving }, attrs: { placeholder: "e.g. Invoice #", name: "condition" + _vm.index, disabled: _vm.disable, "data-vv-as": "Condition Value" }, domProps: { value: _vm.conditionValue }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.conditionValue = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("condition" + _vm.index) ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("condition" + _vm.index)))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Value represents the text to use for the condition")])])])]);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  RuleConditionComponent,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  "d04aa4e7"
);
const RuleCondition = __component__$6.exports;
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$5"), _a7;
let RuleEditorComponent = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "saving", !1);
    __publicField(this, "moving", !1);
    __publicField(this, "ruleOperators", [
      {
        id: Operator.And,
        name: "And"
      },
      {
        id: Operator.Or,
        name: "Or"
      }
    ]);
  }
  addCondition() {
    let newConditions = this.conditions.slice(), newCondition = {};
    newConditions.push(newCondition), this.conditions = newConditions;
  }
  removeCondition(index2) {
    let newConditions = this.conditions.slice();
    newConditions.splice(index2, 1), this.conditions = newConditions;
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  save(value) {
    this.$emit("save", value);
  }
  async cancel() {
    this.moving = !0;
    try {
      await this.$store.dispatch("administration/smtp/rules/actions/cancel");
    } catch (e) {
      toastr.error(e, "Failed to reorder items");
    } finally {
      this.moving = !1;
    }
  }
  get conditions() {
    return this.model.conditions ? this.model.conditions : null;
  }
  set conditions(value) {
    this.model = { ...this.model, conditions: value };
  }
  get ruleName() {
    return this.model.name;
  }
  set ruleName(value) {
    this.model = { ...this.model, name: value };
  }
  get description() {
    return this.model.description;
  }
  set description(value) {
    this.model = { ...this.model, description: value };
  }
  get operator() {
    return this.model.operator;
  }
  set operator(value) {
    this.model = { ...this.model, operator: value };
  }
  get action() {
    return this.model.action;
  }
  set action(value) {
    this.model = { ...this.model, action: value };
  }
  get canSave() {
    return !this.$validator.errors.any();
  }
  get actionComponent() {
    if (this.action) {
      let matched = actions.find((a) => a.id === this.action.discriminator);
      if (matched)
        return matched.component;
    }
    return null;
  }
  get actionOptions() {
    return actions.map((a) => ({
      id: a.id,
      name: a.name,
      icon: a.icon
    }));
  }
  changeAction(actionId) {
    let matched = actions.find((a) => a.id === actionId);
    matched && (this.action = matched.factory());
  }
}, __name(_a7, "RuleEditorComponent"), _a7);
__decorateClass$5([
  Prop({ required: !0 })
], RuleEditorComponent.prototype, "value", 2);
RuleEditorComponent = __decorateClass$5([
  Component({
    components: { RuleCondition, ReactiveDropdown },
    inject: [
      "$validator"
    ]
  })
], RuleEditorComponent);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v(`Summary
        `), _vm.model.id ? _vm._e() : [_vm._v(" "), _c("small", [_vm._v("(New Rule)")])]], 2), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.ruleName, expression: "ruleName" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("name"), disabled: _vm.saving }, attrs: { placeholder: "e.g. Invoice Sorter", name: "name", disabled: _vm.saving }, domProps: { value: _vm.ruleName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.ruleName = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("name")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Name for the rule")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("description") } }, [_c("label", [_vm._v("Description")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.description, expression: "description" }], staticClass: "form-control", attrs: { placeholder: "e.g. Sorts invoices from accounts to the correct queues", name: "description" }, domProps: { value: _vm.description }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.description = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Short description for the rule")])]), _vm._v(" "), _c("div", { directives: [{ name: "show", rawName: "v-show", value: _vm.model.conditions.length, expression: "model.conditions.length" }], staticClass: "form-group" }, [_c("label", [_vm._v("Condition Operator")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], ref: "operatorDropdown", class: { "is-invalid": _vm.errors.first("operatorOption"), disabled: _vm.saving }, attrs: { options: _vm.ruleOperators, name: "operatorOption", disabled: _vm.saving }, model: { value: _vm.operator, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.operator = $$v;
  }, "callback"), expression: "operator" } }), _vm._v(" "), _vm.errors.has("operatorOption") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("operatorOption")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("This will set how the conditions will interact with each other")])], 1), _vm._v(" "), _c("h3", [_vm._v(`Conditions 
        `), _c("button", { staticClass: "btn btn-sm btn-primary", on: { click: _vm.addCondition } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Rule Condition
        `)], 1)]), _vm._v(" "), _vm._l(_vm.conditions, function(condition, index2) {
    return _vm.conditions && _vm.conditions.length ? [_c("rule-condition", { key: index2, ref: "conditions", refInFor: !0, attrs: { index: index2, saving: _vm.saving }, on: { remove: /* @__PURE__ */ __name(function($event) {
      return _vm.removeCondition(index2);
    }, "remove") }, model: { value: _vm.conditions[index2], callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(_vm.conditions, index2, $$v);
    }, "callback"), expression: "conditions[index]" } })] : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
        No conditions currently configured. Catching all messages.
    `)]);
  }), _vm._v(" "), _c("h3", [_vm._v("Action")]), _vm._v(" "), _c("reactive-dropdown", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("action"), action: _vm.saving }, attrs: { value: _vm.action ? _vm.action.discriminator : null, options: _vm.actionOptions, name: "action", disabled: _vm.saving }, on: { input: _vm.changeAction } }), _vm._v(" "), _c("br"), _vm._v(" "), _vm.errors.has("action") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("action")))]) : _vm._e(), _vm._v(" "), _vm.actionComponent ? _c(_vm.actionComponent, { ref: "actionEditor", tag: "component", attrs: { ruleId: _vm.action.id }, model: { value: _vm.action, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.action = $$v;
  }, "callback"), expression: "action" } }) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group mt-2" }, [_c("button", { staticClass: "btn btn-success", attrs: { disabled: !_vm.canSave || _vm.saving }, on: { click: _vm.save } }, [_c("font-awesome-icon", { attrs: { icon: _vm.saving ? "sync" : "save", spin: _vm.saving } }), _vm._v(` Save
        `)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default", attrs: { disabled: _vm.saving }, on: { click: _vm.cancel } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Cancel
        `)], 1)])], 2);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  RuleEditorComponent,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  "e1932e9d"
);
const RuleEditor = __component__$5.exports;
var __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$4"), _a8;
let RulesComponent = (_a8 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "saving", !1);
    __publicField(this, "moving", !1);
  }
  mounted() {
    this.loadRules();
  }
  async addRule() {
    await this.$store.dispatch("administration/smtp/rules/actions/createRule");
  }
  async editRule(ruleId) {
    await this.$store.dispatch("administration/smtp/rules/actions/editRule", ruleId);
  }
  async removeRule(ruleId) {
    try {
      await this.$store.dispatch("administration/smtp/rules/actions/removeRule", ruleId), await this.loadRules(), this.cancel();
    } catch (e) {
      toastr$1.error(e, "Failed to remove rule");
    }
  }
  get rules() {
    return this.$store.getters["administration/smtp/rules/getters/rules"];
  }
  get editing() {
    return this.$store.getters["administration/smtp/rules/getters/editing"];
  }
  set editing(value) {
    this.$store.dispatch("administration/smtp/rules/actions/updateEditing", value);
  }
  get editingId() {
    return this.editing ? this.editing.id : null;
  }
  async loadRules() {
    this.loading = !0, this.loadingError = null;
    try {
      await this.$store.dispatch("administration/smtp/rules/actions/loadRules");
    } catch (e) {
      toastr$1.error(e, "Failed to load rules"), this.loadingError = e;
    } finally {
      this.loading = !1;
    }
  }
  validate() {
    let validators = this.$children.map((c) => c.$validator);
    return Promise.all(validators.map((v) => v.validateAll())).then((r) => r.every((v) => v));
  }
  async save() {
    this.validate().then((valid) => {
      if (!valid) {
        toastr$1.error("Could not save, some values are missing.");
        return;
      }
      this.saving = !0;
      try {
        this.$store.dispatch("administration/smtp/rules/actions/save"), toastr$1.success("Saved rule successfully");
      } catch (e) {
        toastr$1.error(e, "Failed to save rule");
      } finally {
        this.saving = !1;
      }
    });
  }
  async onUpdate(e) {
    let rule = this.rules[e.oldIndex];
    await this.$store.dispatch("administration/smtp/rules/actions/moveRule", { id: rule.id, index: e.newIndex });
  }
  async cancel() {
    this.moving = !0;
    try {
      await this.$store.dispatch("administration/smtp/rules/actions/cancel");
    } catch (e) {
      toastr$1.error(e, "Failed to reorder items");
    } finally {
      this.moving = !1;
    }
  }
}, __name(_a8, "RulesComponent"), _a8);
RulesComponent = __decorateClass$4([
  Component({
    components: { ReactiveDropdown, RuleEditor, draggable }
  })
], RulesComponent);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-6" }, [_vm.rules && _vm.rules.length ? _c("div", [_c("draggable", { staticClass: "list-group mb-2", attrs: { value: _vm.rules, tag: "div", options: { disabled: _vm.moving } }, on: { update: _vm.onUpdate } }, _vm._l(_vm.rules, function(rule, index2) {
    return _c("a", { key: rule.id, staticClass: "list-group-item list-group-item-action smtp-rule", class: { active: rule.id === _vm.editingId }, attrs: { href: "javascript:void(0)" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editRule(rule.id);
    }, "click") } }, [_c("h4", { staticClass: "list-group-item-heading" }, [[_vm._v("Rule " + _vm._s(index2 + 1))], _vm._v(" "), _c("em", [rule.name ? [_vm._v(`
                                ` + _vm._s(rule.name) + `
                            `)] : [_vm._v("Unnamed Rule")]], 2), _vm._v(" "), _c("span", { staticClass: "float-right" }, [rule.id === _vm.editingId ? _c("button", { staticClass: "btn btn-danger", on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.removeRule(rule.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1) : _vm._e(), _vm._v(`
                         
                        `), rule.id === _vm.editingId ? _c("font-awesome-icon", { attrs: { icon: "arrow-right" } }) : _vm._e()], 1)], 2), _vm._v(" "), _c("span", { staticClass: "clearfix" }), _vm._v(" "), rule.description ? _c("p", { staticClass: "list-group-item-text rule-description" }, [_vm._v(_vm._s(rule.description))]) : _vm._e(), _vm._v(" "), rule.conditions && rule.conditions.length ? _c("p", [_vm._v(_vm._s(rule.conditions.length) + ` 
                        `), rule.conditions.length === 1 ? [_vm._v(`
                            Condition
                        `)] : [_vm._v(`
                            Conditions
                        `)]], 2) : _c("p", [_c("span", { staticClass: "badge badge-info" }, [_vm._v("Catch All")])])]);
  }), 0)], 1) : _c("div", { staticClass: "alert alert-info" }, [_vm._v("No rules currently configured")]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", on: { click: _vm.addRule } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add Rule
        `)], 1)]), _vm._v(" "), _vm.editing ? _c("div", { staticClass: "col-md-6" }, [_c("rule-editor", { on: { save: _vm.save, cancel: _vm.cancel }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } })], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  RulesComponent,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  "17444a4d"
);
const Rules = __component__$4.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$3"), _a9;
let MessagesTableComponent = (_a9 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "messages");
    __publicField(this, "loading");
    __publicField(this, "retrying", !1);
    __publicField(this, "fields", [
      { key: "from", label: "From", sortable: !1 },
      { key: "to", label: "To", sortable: !1 },
      { key: "subject", label: "Subject", sortable: !1 },
      { key: "attachments", Attachments: "From", sortable: !1 },
      { key: "received", label: "Received", sortable: !1 },
      { key: "status", label: "Status", sortable: !1 },
      { key: "action", label: "", sortable: !1 }
    ]);
  }
  statusIcon(status) {
    switch (status) {
      case MailItemStatus.Pending:
        return "play";
      case MailItemStatus.Hold:
        return "pause";
      case MailItemStatus.Faulted:
        return "exclamation-triangle";
      case MailItemStatus.Processed:
        return "check";
      case MailItemStatus.Removed:
        return "trash";
    }
  }
  async retry(messageId) {
    this.$emit("retry", messageId);
  }
  statusColour(message) {
    return {
      "text-success": [MailItemStatus.Removed, MailItemStatus.Processed].includes(message.status),
      "text-danger": [MailItemStatus.Faulted].includes(message.status),
      "text-warning": [MailItemStatus.Hold].includes(message.status)
    };
  }
  statusMessage(status) {
    switch (status) {
      case MailItemStatus.Pending:
        return "Pending";
      case MailItemStatus.Hold:
        return "Held";
      case MailItemStatus.Faulted:
        return "Faulted";
      case MailItemStatus.Processed:
        return "Processed";
      case MailItemStatus.Removed:
        return "Removed";
    }
  }
  canRetry(message) {
    switch (message.status) {
      case MailItemStatus.Hold:
      case MailItemStatus.Faulted:
        return !0;
    }
    return !1;
  }
}, __name(_a9, "MessagesTableComponent"), _a9);
__decorateClass$3([
  Prop({ required: !0 })
], MessagesTableComponent.prototype, "messages", 2);
__decorateClass$3([
  Prop({ required: !0 })
], MessagesTableComponent.prototype, "loading", 2);
MessagesTableComponent = __decorateClass$3([
  Component({
    components: { PaginationControls, DateDisplay },
    filters: { humanizeSize: /* @__PURE__ */ __name((input) => bytesToSize(input), "humanizeSize") }
  })
], MessagesTableComponent);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_vm.messages && _vm.messages.length ? _c("b-table", { attrs: { striped: "", hover: "", fields: _vm.fields, items: _vm.messages, "sort-icon-left": "" }, scopedSlots: _vm._u([{ key: "cell(from)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(_vm._s(data.item.summary.from))];
  }, "fn") }, { key: "cell(to)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("ul", { staticClass: "list-unstyled" }, _vm._l(data.item.summary.to, function(address) {
      return _c("li", [_vm._v(_vm._s(address))]);
    }), 0)];
  }, "fn") }, { key: "cell(subject)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(_vm._s(data.item.summary.subject))];
  }, "fn") }, { key: "cell(attachments)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.summary.attachments && data.item.summary.attachments.length ? _c("ul", { staticClass: "list-unstyled" }, _vm._l(data.item.summary.attachments, function(attachment) {
      return _c("li", [_vm._v(`
              ` + _vm._s(attachment.name) + " "), _c("span", { staticClass: "text-muted" }, [_vm._v("(" + _vm._s(_vm._f("humanizeSize")(attachment.size)) + ")")])]);
    }), 0) : _c("em", [_vm._v("No Attachments")])];
  }, "fn") }, { key: "cell(received)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.received } })];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { class: _vm.statusColour(data.item) }, [_c("font-awesome-icon", { attrs: { icon: _vm.statusIcon(data.item.status) } }), _vm._v(`
            ` + _vm._s(_vm.statusMessage(data.item.status)) + `
          `)], 1)];
  }, "fn") }, { key: "cell(action)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_vm.canRetry(data.item) ? _c("b-button", { attrs: { variant: "primary", size: "sm", disabled: _vm.retrying }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.retry(data.item.id);
    }, "click") } }, [_vm._v("Retry")]) : _vm._e()], 1)];
  }, "fn") }], null, !1, 2302954801) }) : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
        No messages currently queued
      `)])], 1)]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  MessagesTableComponent,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  "cfd7b8a2"
);
const MessagesTable = __component__$3.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$2"), _a10;
let QueueComponent$1 = (_a10 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "receivedMessagesResponse");
    __publicField(this, "loading");
    __publicField(this, "loadMessages");
    __publicField(this, "loadRules");
    __publicField(this, "rules");
    __publicField(this, "retryMessage");
    __publicField(this, "reloadTimer", null);
    __publicField(this, "pageValue", 1);
    __publicField(this, "pageSize", 25);
    __publicField(this, "filter");
    __publicField(this, "sortModel", {});
    __publicField(this, "retrying", !1);
    __publicField(this, "fields", [
      { key: "from", label: "From", sortable: !1 },
      { key: "to", label: "To", sortable: !1 },
      { key: "subject", label: "Subject", sortable: !1 },
      { key: "attachments", Attachments: "From", sortable: !1 },
      { key: "received", label: "Received", sortable: !1 },
      { key: "status", label: "Status", sortable: !1 },
      { key: "action", label: "", sortable: !1 }
    ]);
    __publicField(this, "searchLogsDebounce", _.debounce(function() {
      this.refresh();
    }, 300));
  }
  async watchPageNumber() {
    await this.refresh();
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.refresh(), 1e4), await this.refresh();
  }
  get skipValue() {
    return this.pageValue * this.pageSize - this.pageSize;
  }
  async retry(messageId) {
    await this.retryMessage({ messageId, skip: this.skipValue, take: this.pageSize });
  }
  canRetry(message) {
    switch (message.status) {
      case MailItemStatus.Hold:
      case MailItemStatus.Faulted:
        return !0;
    }
    return !1;
  }
  statusIcon(status) {
    switch (status) {
      case MailItemStatus.Pending:
        return "play";
      case MailItemStatus.Hold:
        return "pause";
      case MailItemStatus.Faulted:
        return "exclamation-triangle";
      case MailItemStatus.Processed:
        return "check";
      case MailItemStatus.Removed:
        return "trash";
    }
  }
  statusColour(message) {
    return {
      "text-success": [MailItemStatus.Removed, MailItemStatus.Processed].includes(message.status),
      "text-danger": [MailItemStatus.Faulted].includes(message.status),
      "text-warning": [MailItemStatus.Hold].includes(message.status)
    };
  }
  statusMessage(status) {
    switch (status) {
      case MailItemStatus.Pending:
        return "Pending";
      case MailItemStatus.Hold:
        return "Held";
      case MailItemStatus.Faulted:
        return "Faulted";
      case MailItemStatus.Processed:
        return "Processed";
      case MailItemStatus.Removed:
        return "Removed";
    }
  }
  get sort() {
    return this.sortModel;
  }
  set sort(sort) {
    this.sortModel = sort, this.refresh();
  }
  get filterText() {
    return this.filter;
  }
  set filterText(value) {
    this.filter = value, this.searchLogsDebounce();
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
  async refresh() {
    var _a13, _b;
    let skipValue = this.pageValue * this.pageSize - this.pageSize, sortString = ((_a13 = this.sort) != null && _a13.descending ? "-" : "+") + ((_b = this.sort) == null ? void 0 : _b.by);
    await this.loadMessages({ skip: skipValue, take: this.pageSize, sort: sortString, filter: this.filter }), await this.loadRules();
  }
}, __name(_a10, "QueueComponent"), _a10);
__decorateClass$2([
  Getter("administration/smtp/queue/getters/receivedMessagesResponse")
], QueueComponent$1.prototype, "receivedMessagesResponse", 2);
__decorateClass$2([
  Getter("administration/smtp/queue/getters/loading")
], QueueComponent$1.prototype, "loading", 2);
__decorateClass$2([
  Action("administration/smtp/queue/actions/loadMessages")
], QueueComponent$1.prototype, "loadMessages", 2);
__decorateClass$2([
  Action("administration/smtp/rules/actions/loadRules")
], QueueComponent$1.prototype, "loadRules", 2);
__decorateClass$2([
  Getter("administration/smtp/rules/getters/rules")
], QueueComponent$1.prototype, "rules", 2);
__decorateClass$2([
  Action("administration/smtp/queue/actions/retryMessage")
], QueueComponent$1.prototype, "retryMessage", 2);
__decorateClass$2([
  Watch("pageValue")
], QueueComponent$1.prototype, "watchPageNumber", 1);
QueueComponent$1 = __decorateClass$2([
  Component({
    components: { PaginationControls, MessagesTable, DateDisplay, SortableHeaderLink },
    filters: { humanizeSize: /* @__PURE__ */ __name((input) => bytesToSize(input), "humanizeSize") }
  })
], QueueComponent$1);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_c("b-button", { staticClass: "float-right ml-2 mt-1", attrs: { pill: "", size: "sm", variant: "primary", disabled: _vm.loading }, on: { click: _vm.refresh } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } })], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } })], 1), _vm._v(`
          Refresh
        `)]), _vm._v(" "), _vm.receivedMessagesResponse && Math.ceil(_vm.receivedMessagesResponse.count / this.pageSize) > 1 ? _c("span", { staticClass: "float-right" }, [_c("pagination-controls", { attrs: { count: Math.ceil(_vm.receivedMessagesResponse.count / this.pageSize) }, model: { value: _vm.pageValue, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageValue = $$v;
  }, "callback"), expression: "pageValue" } })], 1) : _vm._e(), _vm._v(" "), _c("h4", [_vm._v(`
          Mail queue
          `), _vm.receivedMessagesResponse && _vm.receivedMessagesResponse.receivedMessages ? _c("span", [_c("b-badge", { attrs: { variant: "info" } }, [_vm._v(_vm._s(_vm.receivedMessagesResponse.count))])], 1) : _vm._e()])], 1)]), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_vm.rules && !_vm.rules.length ? _c("b-alert", { attrs: { variant: "danger", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
        There are no SMTP rules configured which will prevent any items from leaving the mail queue
      `)], 1) : _vm._e()], 1)]), _vm._v(" "), _c("b-form-group", { staticClass: "col-md-12" }, [_c("b-input-group", { attrs: { size: "sm" } }, [_c("b-form-input", { staticClass: "noAppendedBorder", attrs: { id: "filter-input", type: "search", placeholder: "Filter...", autocomplete: "off" }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-input-group-text", { staticClass: "onlyBorderLeft" }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)], 1)], 1)], 1), _vm._v(" "), _vm.receivedMessagesResponse && _vm.receivedMessagesResponse.receivedMessages ? _c("div", [_c("div", { staticClass: "col-md-12" }, [_vm.receivedMessagesResponse.receivedMessages && _vm.receivedMessagesResponse.receivedMessages.length ? _c("b-table", { attrs: { striped: "", hover: "", fields: _vm.fields, items: _vm.receivedMessagesResponse.receivedMessages, "sort-icon-left": "" }, scopedSlots: _vm._u([{ key: "cell(from)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(_vm._s(data.item.summary.from))];
  }, "fn") }, { key: "cell(to)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("ul", { staticClass: "list-unstyled" }, _vm._l(data.item.summary.to, function(address) {
      return _c("li", [_vm._v(_vm._s(address))]);
    }), 0)];
  }, "fn") }, { key: "head(received)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "received", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "status", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "cell(subject)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(_vm._s(data.item.summary.subject))];
  }, "fn") }, { key: "cell(attachments)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.summary.attachments && data.item.summary.attachments.length ? _c("ul", { staticClass: "list-unstyled" }, _vm._l(data.item.summary.attachments, function(attachment) {
      return _c("li", [_vm._v(`
                ` + _vm._s(attachment.name) + " "), _c("span", { staticClass: "text-muted" }, [_vm._v("(" + _vm._s(_vm._f("humanizeSize")(attachment.size)) + ")")])]);
    }), 0) : _c("em", [_vm._v("No Attachments")])];
  }, "fn") }, { key: "cell(received)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.received } })];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { class: _vm.statusColour(data.item) }, [_c("font-awesome-icon", { attrs: { icon: _vm.statusIcon(data.item.status) } }), _vm._v(`
              ` + _vm._s(_vm.statusMessage(data.item.status)) + `
            `)], 1)];
  }, "fn") }, { key: "cell(action)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_vm.canRetry(data.item) ? _c("b-button", { attrs: { variant: "primary", size: "sm", disabled: _vm.retrying }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.retry(data.item.id);
    }, "click") } }, [_vm._v("Retry")]) : _vm._e()], 1)];
  }, "fn") }], null, !1, 3895743473) }) : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
          No messages currently queued
        `)])], 1)]) : _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  QueueComponent$1,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "73c76041"
);
const QueueComponent = __component__$2.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$1"), _a11;
let LogsComponent$1 = (_a11 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "receivedMessagesResponse");
    __publicField(this, "loading");
    __publicField(this, "loadMessages");
    __publicField(this, "retryMessage");
    __publicField(this, "pageValue", 1);
    __publicField(this, "pageSize", 25);
    __publicField(this, "filter");
    __publicField(this, "sortModel", {});
    __publicField(this, "reloadTimer", null);
    __publicField(this, "retrying", !1);
    __publicField(this, "fields", [
      { key: "from", label: "From", sortable: !1 },
      { key: "to", label: "To", sortable: !1 },
      { key: "subject", label: "Subject", sortable: !1 },
      { key: "attachments", Attachments: "From", sortable: !1 },
      { key: "received", label: "Received", sortable: !1 },
      { key: "status", label: "Status", sortable: !1 },
      { key: "action", label: "", sortable: !1 }
    ]);
    __publicField(this, "searchLogsDebounce", _.debounce(function() {
      this.refresh();
    }, 300));
  }
  async watchPageNumber() {
    await this.refresh();
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.refresh(), 1e4), await this.refresh();
  }
  get skipValue() {
    return this.pageValue * this.pageSize - this.pageSize;
  }
  async retry(messageId) {
    await this.retryMessage({ messageId, skip: this.skipValue, take: this.pageSize });
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer), this.loading = !1;
  }
  async refresh() {
    var _a13, _b;
    let skipValue = this.pageValue * this.pageSize - this.pageSize, sortString = ((_a13 = this.sort) != null && _a13.descending ? "-" : "+") + ((_b = this.sort) == null ? void 0 : _b.by);
    await this.loadMessages({ skip: skipValue, take: this.pageSize, sort: sortString, filter: this.filter });
  }
  statusIcon(status) {
    switch (status) {
      case MailItemStatus.Pending:
        return "play";
      case MailItemStatus.Hold:
        return "pause";
      case MailItemStatus.Faulted:
        return "exclamation-triangle";
      case MailItemStatus.Processed:
        return "check";
      case MailItemStatus.Removed:
        return "trash";
    }
  }
  statusColour(message) {
    return {
      "text-success": [MailItemStatus.Removed, MailItemStatus.Processed].includes(message.status),
      "text-danger": [MailItemStatus.Faulted].includes(message.status),
      "text-warning": [MailItemStatus.Hold].includes(message.status)
    };
  }
  statusMessage(status) {
    switch (status) {
      case MailItemStatus.Pending:
        return "Pending";
      case MailItemStatus.Hold:
        return "Held";
      case MailItemStatus.Faulted:
        return "Faulted";
      case MailItemStatus.Processed:
        return "Processed";
      case MailItemStatus.Removed:
        return "Removed";
    }
  }
  get sort() {
    return this.sortModel;
  }
  set sort(sort) {
    this.sortModel = sort, this.refresh();
  }
  get filterText() {
    return this.filter;
  }
  set filterText(value) {
    this.filter = value, this.searchLogsDebounce();
  }
  canRetry(message) {
    switch (message.status) {
      case MailItemStatus.Hold:
      case MailItemStatus.Faulted:
        return !0;
    }
    return !1;
  }
}, __name(_a11, "LogsComponent"), _a11);
__decorateClass$1([
  Getter("administration/smtp/messages/getters/receivedMessagesResponse")
], LogsComponent$1.prototype, "receivedMessagesResponse", 2);
__decorateClass$1([
  State((state) => state.administration.smtp.messages.loading)
], LogsComponent$1.prototype, "loading", 2);
__decorateClass$1([
  Action("administration/smtp/messages/actions/loadMessages")
], LogsComponent$1.prototype, "loadMessages", 2);
__decorateClass$1([
  Action("administration/smtp/messages/actions/retryMessage")
], LogsComponent$1.prototype, "retryMessage", 2);
__decorateClass$1([
  Watch("pageValue")
], LogsComponent$1.prototype, "watchPageNumber", 1);
LogsComponent$1 = __decorateClass$1([
  Component({
    components: { PaginationControls, SortableHeaderLink, DateDisplay },
    filters: {
      moment: /* @__PURE__ */ __name((input) => Moment(input).fromNow(), "moment"),
      humanizeSize: /* @__PURE__ */ __name((input) => bytesToSize(input), "humanizeSize")
    }
  })
], LogsComponent$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_c("b-button", { staticClass: "float-right ml-2 mt-1", attrs: { pill: "", size: "sm", variant: "primary", disabled: _vm.loading }, on: { click: _vm.refresh } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } })], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } })], 1), _vm._v(`
        Refresh
      `)]), _vm._v(" "), _vm.receivedMessagesResponse && Math.ceil(_vm.receivedMessagesResponse.count / this.pageSize) > 1 ? _c("span", { staticClass: "float-right" }, [_c("pagination-controls", { attrs: { count: Math.ceil(_vm.receivedMessagesResponse.count / this.pageSize) }, model: { value: _vm.pageValue, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageValue = $$v;
  }, "callback"), expression: "pageValue" } })], 1) : _vm._e(), _vm._v(" "), _c("h4", [_vm._v(`
        SMTP Logs
        `), _vm.receivedMessagesResponse && _vm.receivedMessagesResponse.receivedMessages ? _c("span", [_c("b-badge", { attrs: { variant: "info" } }, [_vm._v(_vm._s(_vm.receivedMessagesResponse.count))])], 1) : _vm._e()])], 1)]), _vm._v(" "), _c("b-form-group", { staticClass: "col-md-12" }, [_c("b-input-group", { attrs: { size: "sm" } }, [_c("b-form-input", { staticClass: "noAppendedBorder", attrs: { id: "filter-input", type: "search", placeholder: "Filter...", autocomplete: "off" }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-input-group-text", { staticClass: "onlyBorderLeft" }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)], 1)], 1)], 1), _vm._v(" "), _vm.receivedMessagesResponse && _vm.receivedMessagesResponse.receivedMessages ? _c("div", [_c("div", { staticClass: "col-md-12" }, [_vm.receivedMessagesResponse.receivedMessages && _vm.receivedMessagesResponse.receivedMessages.length ? _c("b-table", { attrs: { striped: "", hover: "", fields: _vm.fields, items: _vm.receivedMessagesResponse.receivedMessages, "sort-icon-left": "" }, scopedSlots: _vm._u([{ key: "cell(from)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(_vm._s(data.item.summary.from))];
  }, "fn") }, { key: "cell(to)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("ul", { staticClass: "list-unstyled" }, _vm._l(data.item.summary.to, function(address) {
      return _c("li", [_vm._v(_vm._s(address))]);
    }), 0)];
  }, "fn") }, { key: "head(received)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "received", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "status", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "cell(subject)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(_vm._s(data.item.summary.subject))];
  }, "fn") }, { key: "cell(attachments)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.summary.attachments && data.item.summary.attachments.length ? _c("ul", { staticClass: "list-unstyled" }, _vm._l(data.item.summary.attachments, function(attachment) {
      return _c("li", [_vm._v(`
                ` + _vm._s(attachment.name) + " "), _c("span", { staticClass: "text-muted" }, [_vm._v("(" + _vm._s(_vm._f("humanizeSize")(attachment.size)) + ")")])]);
    }), 0) : _c("em", [_vm._v("No Attachments")])];
  }, "fn") }, { key: "cell(received)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.received } })];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { class: _vm.statusColour(data.item) }, [_c("font-awesome-icon", { attrs: { icon: _vm.statusIcon(data.item.status) } }), _vm._v(`
              ` + _vm._s(_vm.statusMessage(data.item.status)) + `
            `)], 1)];
  }, "fn") }, { key: "cell(action)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_vm.canRetry(data.item) ? _c("b-button", { attrs: { variant: "primary", size: "sm", disabled: _vm.retrying }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.retry(data.item.id);
    }, "click") } }, [_vm._v("Retry")]) : _vm._e()], 1)];
  }, "fn") }], null, !1, 3895743473) }) : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
          No messages currently queued
        `)])], 1)]) : _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  LogsComponent$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "45d1037b"
);
const LogsComponent = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a12;
let AdministrationSMTPComponent = (_a12 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "tabs", [
      {
        id: "server",
        name: "Server Configuration",
        icon: "toolbox",
        description: "Set the configuration for the SMTP server",
        show: !0,
        component: Config
      },
      {
        id: "rules",
        name: "Rules",
        icon: "mail-bulk",
        description: "Manage the rule that are applied to incoming mail items",
        show: !0,
        component: Rules
      },
      {
        id: "queue",
        name: "Mail Queue",
        icon: "envelope-open",
        description: "Process mail items that have encountered a problem",
        show: !0,
        component: QueueComponent
      },
      {
        id: "logs",
        name: "Logs",
        icon: "clipboard-list",
        description: "Look through all the historical logs of the Smtp server",
        show: !0,
        component: LogsComponent
      }
    ]);
    __publicField(this, "tab", null);
  }
  get currentTab() {
    return this.tab || "server";
  }
  mounted() {
    this.tab || (this.tab = "server");
  }
  get activeComponent() {
    if (this.currentTab) {
      let component = this.tabs.find((t) => t.id == this.currentTab);
      if (component)
        return component.component;
    }
    return null;
  }
  selectTab(tabId) {
    this.tabs.find((t) => t.id === tabId && t.show) && (this.tab = tabId);
  }
}, __name(_a12, "AdministrationSMTPComponent"), _a12);
AdministrationSMTPComponent = __decorateClass([
  Component({ components: { LoadingBar: LoadingBarComponent } })
], AdministrationSMTPComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "mail-bulk" } }), _vm._v(" SMTP Server")], 1)]), _vm._v(" "), _c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs unselectable toggle-pane" }, _vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item", attrs: { role: "presentation" } }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.currentTab === tab.id, disabled: !tab.show }, attrs: { role: "button", title: tab.description }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(`
                    ` + _vm._s(tab.name) + `
                `)], 1)]);
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_c("div", { staticClass: "container-fluid" }, [_vm.activeComponent ? _c(_vm.activeComponent, { tag: "component" }) : _vm._e()], 1)])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationSMTPComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "f12a014c"
);
const index = __component__.exports;
export {
  index as default
};
