var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, L as LoadingBarComponent, V as Vue, n as normalizeComponent, W as Watch, t as toastr$1, O as DuplexOptions, U as ColourOptions } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { Q as QuotaBar } from "./quotaBar-YBpud5Td.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$4"), _a;
let PoolSummaryComponent$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  get item() {
    return this.value;
  }
}, __name(_a, "PoolSummaryComponent"), _a);
__decorateClass$4([
  Prop({
    required: !0
  })
], PoolSummaryComponent$1.prototype, "value", 2);
PoolSummaryComponent$1 = __decorateClass$4([
  Component({
    components: { QuotaBar, DateDisplay, LoadingBar: LoadingBarComponent }
  })
], PoolSummaryComponent$1);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Period Quota")]), _vm._v(" "), _c("quota-bar", { attrs: { total: _vm.item.quota, used: _vm.item.used, expiry: _vm.item.expiry } })], 1);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  PoolSummaryComponent$1,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  "cad678c4"
);
const PoolSummaryComponent = __component__$4.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$3"), _a2;
let ThroughputComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "loading", !1);
  }
  mounted() {
    this.reloadTimer = setInterval(() => this.loadQuotas(), 1e4), this.loadQuotas();
  }
  loadingWatcher(newValue) {
    this.$emit("loading", newValue);
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer), this.loading = !1;
  }
  async loadQuotas() {
    this.loading = !0;
    try {
      await this.$store.dispatch("administration/capture/throughput/getPools");
    } finally {
      this.loading = !1;
    }
  }
  get pools() {
    return this.$store.state.administration.capture.throughput.pools;
  }
  get activePools() {
    return this.pools.filter((p) => !p.expired);
  }
  get expiredPools() {
    return this.pools.filter((p) => p.expired);
  }
  get quota() {
    return this.activePools.map((p) => p.quota).reduce((total, n) => total + n, 0);
  }
  get used() {
    return this.activePools.map((p) => p.used).reduce((total, n) => total + n, 0);
  }
  get usage() {
    return this.used / this.quota * 100;
  }
}, __name(_a2, "ThroughputComponent"), _a2);
__decorateClass$3([
  Watch("loading", { immediate: !0 })
], ThroughputComponent.prototype, "loadingWatcher", 1);
ThroughputComponent = __decorateClass$3([
  Component({
    components: { QuotaBar, PoolSummaryComponent }
  })
], ThroughputComponent);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-6 mb-3" }, [_c("h4", [_vm._v("Total Active Quota")]), _vm._v(" "), _vm.activePools.length && _vm.quota > 0 ? _c("span", [_c("quota-bar", { attrs: { total: _vm.quota, used: _vm.used } })], 1) : _c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` No quota limits are configured, unlimited throughput allowed for capture devices.
        `)], 1)], 1)]), _vm._v(" "), _vm.activePools.length && _vm.quota > 0 ? _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-6 col-sm-12" }, [_c("h4", [_vm._v("Active Quotas")]), _vm._v(" "), _vm._l(_vm.activePools, function(pool) {
    return _c("pool-summary-component", { key: pool.id, attrs: { value: pool } });
  })], 2), _vm._v(" "), _c("div", { staticClass: "col-md-6 col-sm-12" }, [_c("h4", [_vm._v("Expired Quotas")]), _vm._v(" "), _vm._l(_vm.expiredPools, function(pool) {
    return _c("pool-summary-component", { key: pool.id, attrs: { value: pool } });
  }), _vm._v(" "), _vm.expiredPools.length ? _vm._e() : _c("div", [_c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` No expired quotas
                `)], 1)], 1)], 2)]) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  ThroughputComponent,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  "6cf80493"
);
const Throughput = __component__$3.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$2"), _a3;
let DevicesComponent = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "reloadTimer", null);
  }
  mounted() {
    this.reloadTimer = setInterval(() => this.loadDevices(), 1e4), this.loadDevices();
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer), this.loading = !1;
  }
  loadingWatcher(newValue) {
    this.$emit("loading", newValue);
  }
  async loadDevices() {
    this.loading = !0;
    try {
      await this.$store.dispatch("administration/capture/devices/getDevices");
    } catch (e) {
      toastr.error(e, "Failed to load devices. Click to retry", { onclick: /* @__PURE__ */ __name(() => this.loadDevices(), "onclick") });
    } finally {
      this.loading = !1;
    }
  }
  typeIcon(device) {
    switch (device.type) {
      case "smtp":
        return "envelope-open-text";
      case "device":
        return "print";
      default:
        return "question-circle";
    }
  }
  typeName(device) {
    switch (device.type) {
      case "smtp":
        return "SMTP Device";
      case "device":
        return "Standard Device";
      default:
        return "Unknown device type";
    }
  }
  get total() {
    return this.$store.getters["administration/capture/devices/total"];
  }
  get available() {
    return this.$store.getters["administration/capture/devices/available"];
  }
  get devices() {
    return this.$store.getters["administration/capture/devices"];
  }
  async deregisterDevice(id) {
    await this.$store.dispatch("administration/capture/devices/deregister", id);
  }
}, __name(_a3, "DevicesComponent"), _a3);
__decorateClass$2([
  Watch("loading", { immediate: !0 })
], DevicesComponent.prototype, "loadingWatcher", 1);
DevicesComponent = __decorateClass$2([
  Component({
    components: { DateDisplay }
  })
], DevicesComponent);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-sm-12 col-md-6 col-xl-6" }, [_c("h4", [_vm._v("Registered Devices")]), _vm._v(" "), _vm.available === null ? _c("em", [_vm._v(_vm._s(_vm.total) + " devices registered (Unlimited)")]) : _c("em", [_vm._v(_vm._s(_vm.total) + " of " + _vm._s(_vm.available) + " available devices registered")]), _vm._v(" "), _vm.devices && _vm.devices.length ? _c("table", { staticClass: "table table-striped" }, [_vm._m(0), _vm._v(" "), _c("tbody", _vm._l(_vm.devices, function(device) {
    return _c("tr", { key: device.id }, [_c("td", [_c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: _vm.typeName(device) } }, [_c("font-awesome-icon", { attrs: { icon: _vm.typeIcon(device) } }), _vm._v(` 
                    `)], 1), _vm._v(`
                    ` + _vm._s(device.serial) + `
                `)]), _vm._v(" "), _c("td", [device.lastConnected ? [_c("date-display", { attrs: { value: device.lastConnected } })] : [_vm._v(`
                        No connection time
                    `)]], 2), _vm._v(" "), _c("td", [_c("button", { staticClass: "btn btn-danger float-right", on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deregisterDevice(device.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` De-register
                    `)], 1)])]);
  }), 0)]) : _c("div", { staticClass: "alert alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` No devices currently registered
        `)], 1)])]);
}, "render"), _sfc_staticRenderFns$2 = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("thead", [_c("tr", [_c("th", [_vm._v("Device Identifier")]), _vm._v(" "), _c("th", [_vm._v("Last connected")]), _vm._v(" "), _c("th")])]);
}], __component__$2 = /* @__PURE__ */ normalizeComponent(
  DevicesComponent,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "8e21a3e1"
);
const Devices = __component__$2.exports;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$1"), _a4;
let ScanProfilesComponent = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "profiles", null);
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "saving", !1);
    __publicField(this, "dpiOptions", [{
      id: 100,
      name: "100dpi"
    }, {
      id: 200,
      name: "200dpi"
    }, {
      id: 300,
      name: "300dpi"
    }, {
      id: 400,
      name: "400dpi"
    }, {
      id: 600,
      name: "600dpi"
    }, {
      id: 1200,
      name: "1200dpi"
    }]);
    __publicField(this, "colourOptions", [
      {
        id: ColourOptions.Auto,
        name: "Automatic"
      },
      {
        id: ColourOptions.BlackAndWhite,
        name: "Black and White"
      },
      {
        id: ColourOptions.Colour,
        name: "Colour"
      },
      {
        id: ColourOptions.Greyscale,
        name: "Greyscale"
      }
    ]);
    __publicField(this, "duplexOptions", [
      {
        id: DuplexOptions.SingleSided,
        name: "Single"
      },
      {
        id: DuplexOptions.DoubleSided,
        name: "Double"
      }
    ]);
  }
  mounted() {
    this.loadProfiles();
  }
  async loadProfiles() {
    this.loading = !0, this.loadingError = null;
    try {
      this.profiles = await this.$store.dispatch("administration/capture/profiles/getProfiles");
    } catch (e) {
      throw this.loadingError = e, e;
    } finally {
      this.loading = !1;
    }
  }
  async saveProfiles() {
    this.saving = !0;
    try {
      this.profiles = await this.$store.dispatch("administration/capture/profiles/updateProfiles", this.profiles), toastr$1.success("Saved profiles!");
    } catch (e) {
      toastr$1.error(e, "Failed to save");
    } finally {
      this.saving = !1;
    }
  }
  createProfile() {
    this.profiles.push({
      id: null,
      default: !1,
      name: null,
      scanSettings: {
        colour: ColourOptions.Auto,
        duplex: DuplexOptions.SingleSided,
        dpi: 300
      }
    });
  }
  removeProfile(profile) {
    this.profiles.splice(this.profiles.indexOf(profile), 1);
  }
}, __name(_a4, "ScanProfilesComponent"), _a4);
ScanProfilesComponent = __decorateClass$1([
  Component({
    components: { ReactiveDropdown, LoadingBar: LoadingBarComponent }
  })
], ScanProfilesComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_vm.loading ? _c("div", { staticClass: "col-md-12" }, [_c("loading-bar")], 1) : !_vm.loading && !_vm.loadingError ? [_c("div", { staticClass: "col-md-12" }, [_c("h4", [_vm._v("Scan Profiles")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("button", { staticClass: "btn btn-success", on: { click: _vm.createProfile } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(`
                    New Profile
                `)], 1)])]), _vm._v(" "), !_vm.profiles || !_vm.profiles.length ? _c("div", { staticClass: "col-md-12 alert alert-info" }, [_vm._v(`
            No profiles configured
        `)]) : _vm._e(), _vm._v(" "), _vm._l(_vm.profiles, function(profile) {
    return _c("div", { staticClass: "col-md-6" }, [_c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header" }, [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "newspaper" } }), _vm._v(" "), profile.name && profile.name.length > 0 ? _c("span", [_vm._v(_vm._s(profile.name))]) : _c("span", [_vm._v("New Scan Profile")]), _vm._v(" "), profile.default ? _vm._e() : _c("button", { staticClass: "btn btn-danger btn-sm float-right", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.removeProfile(profile);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(`
                        Remove Profile
                    `)], 1)], 1)]), _vm._v(" "), _c("div", { staticClass: "card-body" }, [_c("div", { staticClass: "col-md-12 form-group" }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: profile.name, expression: "profile.name" }], staticClass: "form-control", attrs: { placeholder: "Name", disabled: profile.default }, domProps: { value: profile.name }, on: { input: /* @__PURE__ */ __name(function($event) {
      $event.target.composing || _vm.$set(profile, "name", $event.target.value);
    }, "input") } })]), _vm._v(" "), _c("div", { staticClass: "col-md-4 col-sm-12 form-group" }, [_c("label", [_vm._v(`Colour
                            `), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "Colour the scanner will use to capture documents" } }, [_c("font-awesome-icon", { attrs: { icon: "question-circle" } })], 1)]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { options: _vm.colourOptions }, model: { value: profile.scanSettings.colour, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(profile.scanSettings, "colour", $$v);
    }, "callback"), expression: "profile.scanSettings.colour" } })], 1), _vm._v(" "), _c("div", { staticClass: "col-md-4 col-sm-12 form-group" }, [_c("label", [_vm._v(`Resolution
                            `), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "Detail in which the scanner will use to capture documents. If the resolution is not supported, the closest available resolution will be used" } }, [_c("font-awesome-icon", { attrs: { icon: "question-circle" } })], 1)]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { options: _vm.dpiOptions }, model: { value: profile.scanSettings.dpi, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(profile.scanSettings, "dpi", $$v);
    }, "callback"), expression: "profile.scanSettings.dpi" } })], 1), _vm._v(" "), _c("div", { staticClass: "col-md-4 col-sm-12 form-group" }, [_c("label", [_vm._v(`Duplex
                            `), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "Capture both sides of a document, if supported" } }, [_c("font-awesome-icon", { attrs: { icon: "question-circle" } })], 1)]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { options: _vm.duplexOptions, fill: "" }, model: { value: profile.scanSettings.duplex, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(profile.scanSettings, "duplex", $$v);
    }, "callback"), expression: "profile.scanSettings.duplex" } })], 1)])])]);
  }), _vm._v(" "), _c("div", { staticClass: "col-md-12 form-group mt-2" }, [_c("button", { staticClass: "btn btn-success", attrs: { disabled: _vm.saving }, on: { click: _vm.saveProfiles } }, [_vm.saving ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(` Saving..
            `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1)])])] : _c("div", { staticClass: "alert alert-danger col-md-12" }, [_vm._v(`
        Failed to load profiles. `), _c("a", { attrs: { role: "button" }, on: { click: _vm.loadProfiles } }, [_vm._v("Try again?")])])], 2);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  ScanProfilesComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "e7503081"
);
const ScanProfiles = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a5;
let AdministrationCaptureDevicesComponent = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "tabs", [
      {
        id: "devices",
        name: "Devices",
        icon: "camera-retro",
        description: "Manage devices that can capture to this instance of EzeScan WebApps",
        show: !0,
        component: Devices
      },
      {
        id: "throughput",
        name: "Throughput",
        icon: "boxes",
        description: "View, and manage throughput for capture devices",
        show: !0,
        component: Throughput
      },
      {
        id: "scan-profiles",
        name: "Scan Profiles",
        icon: "id-card",
        description: "Manage scan profiles for capture devices",
        show: !0,
        component: ScanProfiles
      }
    ]);
    __publicField(this, "tab", null);
    __publicField(this, "loading", !1);
  }
  get activeTab() {
    return this.tab ? this.tab : (this.tabs.find((t) => t.show) || { id: null }).id;
  }
  selectTab(tabId) {
    this.tabs.find((t) => t.id === tabId && t.show) && (this.tab = tabId);
  }
}, __name(_a5, "AdministrationCaptureDevicesComponent"), _a5);
AdministrationCaptureDevicesComponent = __decorateClass([
  Component({
    components: { Devices, Throughput, ScanProfiles }
  })
], AdministrationCaptureDevicesComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "camera" } }), _vm._v(" Capture Device Management")], 1)]), _vm._v(" "), _c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs", attrs: { id: "myTab", role: "tablist" } }, _vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item" }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab === tab.id }, attrs: { id: tab.id + "tab", "data-toggle": "tab", role: "tab", "aria-selected": "true" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(" " + _vm._s(tab.name) + `
                `)], 1)]);
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_c("div", { staticClass: "container-fluid" }, [_c("div", { staticClass: "mb-4" }, [_vm.activeTab === "devices" ? _c("devices", { on: { loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading") } }) : _vm._e(), _vm._v(" "), _vm.activeTab === "throughput" ? _c("throughput", { on: { loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading") } }) : _vm._e(), _vm._v(" "), _vm.activeTab === "scan-profiles" ? _c("scan-profiles", { on: { loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading") } }) : _vm._e()], 1)])])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationCaptureDevicesComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "ca2e9bcb"
);
const index = __component__.exports;
export {
  index as default
};
